/* Copyright (c) 2025, Canaan Bright Sight Co., Ltd
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ws2812.h"
#include <stdbool.h>

void k230Show(uint8_t pin, uint8_t *pixels, uint32_t numBytes, bool is800KHz)
{
    uint32_t timing_ns[4];

    if (is800KHz) {
        // 800kHz: 1.25us per bit
        timing_ns[0] = 400;  // T0H: 0.4us
        timing_ns[1] = 850;  // T0L: 0.85us (1.25 - 0.4 = 0.85)
        timing_ns[2] = 800;  // T1H: 0.8us  
        timing_ns[3] = 450;  // T1L: 0.45us (1.25 - 0.8 = 0.45)
    } else {
        // 400kHz: 2.5us per bit
        timing_ns[0] = 500;  // T0H: 0.5us
        timing_ns[1] = 2000; // T0L: 2.0us
        timing_ns[2] = 1200; // T1H: 1.2us
        timing_ns[3] = 1300; // T1L: 1.3us
    }
    ws2812_stream_over_gpio(pin, timing_ns, pixels, numBytes);
}
