# OpenBLAS

## OpenBLAS简介

`OpenBLAS` 是一个基于 `BSD` 许可(开源)发行的优化`BLAS`计算库。`BLAS(Basic Linear Algebra Subprograms，基础线性代数程序集)`是一个应用程序接口(API)标准，用以规范发布基础线性代数操作的数值库(如矢量或矩阵乘法)，`OpenBLAS` 是 `BLAS` 标准的一种具体实现。

在 `K230 Arduino SDK` 中，已包含预先交叉编译好的 `OpenBLAS` 库位于`src/rtsmart/libs/openblas/`路径下，用户直接使用该静态库编译自己的可执行程序即可。

## 编译示例

本节介绍如何使用 `SDK` 中预置的 `OpenBLAS` 静态库，来进行可执行程序的编译。`SDK` 中已包含4个基于 `OpenBLAS` 实现的示例(位于`libraries/OpenBlas/examples`路径下)。

### 代码结构

该路径下的目录结构说明如下：

```shell
libraries/OpenBlas/examples
|-- cblas_saxpy            # saxpy示例，实现y = alpha * x + y
|   |-- cblas_saxpy.ino
|-- cblas_sgemm            # sgemm示例，实现C = alpha * A * B + beta * C
|   |-- cblas_sgemm.ino
|-- cblas_sger             # sger示例，实现A = alpha * x * y^T + beta * A
|   |-- cblas_sger.ino
|-- fortran_dgemm          # Fortran接口示例，实现C = alpha * A * B + beta * C
|   |-- fortran_dgemm.ino
```

## 运行示例

### cblas_saxpy

此函数用于测试 OpenBLAS 库中的 `cblas_saxpy` 函数。它将向量 x 乘以标量 alpha 后加到向量 y 上，并将结果与预期结果进行比较，输出测试结果。

运行方式及输出结果示例如下：

```shell
msh /sdcard/app/examples/openblas_examples>./openblas_cblas_saxpy.elf
*********************************************************
This is the result:
4 7 11 14
*********************************************************
This is the reference:
4 7 11 14
{Test PASS}.
```

### cblas_sgemm

此函数使用 OpenBLAS 库中的 `cblas_sgemm` 函数进行单精度矩阵乘法操作，并将结果与预期结果进行比较，输出测试结果。

运行方式及输出结果示例如下：

```shell
msh /sdcard/app/examples/openblas_examples>./openblas_cblas_sgemm.elf
*********************************************************
This is the result:
7 10 15 22
*********************************************************
This is the reference:
7 10 15 22
{Test PASS}.
```

### cblas_sger

此函数用于测试 OpenBLAS 库中的 `cblas_sger` 函数。该函数执行矩阵更新操作 `A <== alpha * x * y' + A`，其中 y' 是 y 的转置。程序会将结果与预期结果进行比较，并输出测试结果。

运行方式及输出结果示例如下：

```shell
msh /sdcard/app/examples/openblas_examples>./openblas_cblas_sger.elf
*********************************************************
This is the result:
20 40 10 20 30 60
*********************************************************
This is the reference:
20 40 10 20 30 60
{Test PASS}.

```

### fortran_dgemm

此函数用于执行矩阵乘法操作，使用 Fortran 风格的 BLAS 函数 `dgemm_` 进行双精度矩阵乘法。它会初始化矩阵 A、B 和 C，调用 dgemm_ 函数进行计算，然后输出结果并与预期结果进行比较。

运行方式及输出结果示例如下：

```shell
msh /sdcard/app/examples/openblas_examples>./openblas_fortran_dgemm.elf
m=2,n=3,k=4,alpha=1.200000,beta=0.001000,sizeofc=6
This is matrix A

1.000000 2.000000 3.000000 1.000000 2.000000 3.000000 1.000000 2.000000
This is matrix B

1.000000 2.000000 3.000000 1.000000 2.000000 3.000000 1.000000 2.000000 3.000000 1.000000 2.000000 3.000000
*********************************************************
This is the result:
16.801 18.002 18.003 16.801 15.602 22.803
*********************************************************
This is the reference:
16.801 18.002 18.003 16.801 15.602 22.803
{Test PASS}.
```
