#!/bin/bash

# GitLab CI environment check script
# Used for debugging and verifying GitLab CI environment variable settings

echo "=== GitLab CI Environment Check ==="

echo "GitLab CI Variables:"
echo "  CI_PROJECT_DIR: $CI_PROJECT_DIR"
echo "  CI_COMMIT_BRANCH: $CI_COMMIT_BRANCH"
echo "  CI_PIPELINE_SOURCE: $CI_PIPELINE_SOURCE"
echo "  CI_JOB_NAME: $CI_JOB_NAME"
echo "  CI_RUNNER_DESCRIPTION: $CI_RUNNER_DESCRIPTION"

echo ""
echo "Compatibility Variables (set by scripts):"
echo "  GITHUB_WORKSPACE: $GITHUB_WORKSPACE"
echo "  GITHUB_REPOSITORY: $GITHUB_REPOSITORY"

echo ""
echo "Arduino Build Variables:"
echo "  ARDUINO_BUILD_DIR: $ARDUINO_BUILD_DIR"
echo "  ARDUINO_IDE_PATH: $ARDUINO_IDE_PATH"
echo "  ARDUINO_USR_PATH: $ARDUINO_USR_PATH"
echo "  ARDUINO_K230_PATH: $ARDUINO_K230_PATH"

echo ""
echo "System Info:"
echo "  PWD: $PWD"
echo "  HOME: $HOME"
echo "  USER: $USER"
echo "  OS: $(uname -a)"

echo ""
echo "Python & Git versions:"
python3 --version 2>/dev/null || echo "  Python3: not installed"
git --version 2>/dev/null || echo "  Git: not installed"

echo ""
echo "Available disk space:"
df -h $HOME 2>/dev/null || echo "  Cannot check disk space"

echo ""
echo "=== End Environment Check ==="