# -*- mode: python ; coding: utf-8 -*-
from PyInstaller.utils.hooks import collect_submodules
import os
import platform
from pathlib import Path

spec_dir = Path.cwd()
block_cipher = None
system = platform.system().lower()

extra_datas = []

extra_datas.append(("bin/*", "bin/"))
extra_datas.append(("genimage_py/bin/*", "genimage_py/bin/"))
extra_datas.append(("image_tools/bin/*", "image_tools/bin/"))

a = Analysis(
    ['k230_arduino_flash.py'],
    pathex=[],
    binaries=[],
    datas=extra_datas,
    hiddenimports=[
        *collect_submodules("genimage_py"),
        *collect_submodules("image_tools"),
    ],
    hookspath=[],
    hooksconfig={},
    runtime_hooks=[],
    excludes=[],
    noarchive=False,
    optimize=0,
)
pyz = PYZ(a.pure)

exe = EXE(
    pyz,
    a.scripts,
    [],
    exclude_binaries=True,
    name='k230_arduino_flash',
    debug=False,
    bootloader_ignore_signals=False,
    strip=False,
    upx=True,
    console=True,
    disable_windowed_traceback=False,
    argv_emulation=False,
    target_arch=None,
    codesign_identity=None,
    entitlements_file=None,
)
coll = COLLECT(
    exe,
    a.binaries,
    a.datas,
    strip=False,
    upx=True,
    upx_exclude=[],
    name='k230_arduino_flash',
)
