#include <Arduino.h>
#line 1 "/builds/canmv/k230/arduino-k230-private/libraries/K230_WAV/examples/wav/wav.ino"

#include <iostream>
#include <vector>
#include <cmath>
using namespace arduino;
#include <k230_wave.h>

// Example 1: Read WAV file and display information
#line 50 "/builds/canmv/k230/arduino-k230-private/libraries/K230_WAV/examples/wav/wav.ino"
void example_generate_sine_wave(const std::string& filename);
#line 105 "/builds/canmv/k230/arduino-k230-private/libraries/K230_WAV/examples/wav/wav.ino"
void setup();
#line 112 "/builds/canmv/k230/arduino-k230-private/libraries/K230_WAV/examples/wav/wav.ino"
void loop();
#line 9 "/builds/canmv/k230/arduino-k230-private/libraries/K230_WAV/examples/wav/wav.ino"
void example_read_wave(const std::string& filename) {
    std::cout << "=== WAV File Reading Example ===" << std::endl;

    try {
        // Using open function
        auto file = open(filename, "rb");
        if (auto reader_file = dynamic_cast<WaveReadFile*>(file.get())) {
            WaveRead& reader = reader_file->reader;

            // Get file parameters
            WaveParams params = reader.get_params();
            std::cout << "WAV file parameters:" << std::endl;
            std::cout << "  Number of channels: " << params.nchannels << std::endl;
            std::cout << "  Sample width: " << params.sampwidth << " bytes" << std::endl;
            std::cout << "  Sample rate: " << params.framerate << " Hz" << std::endl;
            std::cout << "  Total frames: " << params.nframes << std::endl;
            std::cout << "  Compression type: " << params.comptype << std::endl;
            std::cout << "  Compression name: " << params.compname << std::endl;

            // Read some audio data
            std::cout << "\nReading first 1000 frames of audio data..." << std::endl;
            auto data = reader.read_frames(1000);
            std::cout << "Read " << data.size() << " bytes of data" << std::endl;

            // Display current position
            std::cout << "Current read position: " << reader.tell() << " frames" << std::endl;

            // Reset to beginning
            reader.rewind();
            std::cout << "Position after reset: " << reader.tell() << " frames" << std::endl;
        }
    } catch (const WaveError& e) {
        std::cerr << "Error reading WAV file: " << e.what() << std::endl;
    }

    std::cout << std::endl;
}



// Example 2: Generate sine wave and write to WAV file
void example_generate_sine_wave(const std::string& filename) {
    std::cout << "=== Sine Wave WAV File Generation ===" << std::endl;

    try {
        WaveWrite writer(filename);

        // Set WAV parameters
        writer.set_channels(2);        // Stereo
        writer.set_sampwidth(2);       // 16-bit
        writer.set_framerate(44100);   // 44.1kHz
        writer.set_frames(44100);      // 1 second of audio

        std::cout << "Created WAV file parameters:" << std::endl;
        auto params = writer.get_params();
        std::cout << "  Number of channels: " << params.nchannels << std::endl;
        std::cout << "  Sample width: " << params.sampwidth << std::endl;
        std::cout << "  Sample rate: " << params.framerate << std::endl;

        // Generate 1 second of 440Hz sine wave (A4 note)
        const double frequency = 440.0;  // A4
        const double amplitude = 0.5;    // Amplitude
        const int duration_frames = 44100; // 1 second

        std::vector<char> audio_data;

        for (int i = 0; i < duration_frames; ++i) {
            double time = static_cast<double>(i) / params.framerate;
            double sample = amplitude * std::sin(2.0 * M_PI * frequency * time);

            // Convert to 16-bit PCM
            int16_t pcm_sample = static_cast<int16_t>(sample * 32767);

            // Stereo: same for left and right channels
            for (int channel = 0; channel < params.nchannels; ++channel) {
                audio_data.push_back(static_cast<char>(pcm_sample & 0xFF));        // Lower byte
                audio_data.push_back(static_cast<char>((pcm_sample >> 8) & 0xFF)); // Higher byte
            }
        }

        // Write data
        std::cout << "Writing " << audio_data.size() << " bytes of audio data..." << std::endl;
        writer.write_frames(audio_data);

        std::cout << "Successfully generated sine wave file: " << filename << std::endl;
        std::cout << "Actual frames written: " << writer.get_frames() << std::endl;

        // File automatically closed (RAII)

    } catch (const WaveError& e) {
        std::cerr << "Error generating WAV file: " << e.what() << std::endl;
    }

    std::cout << std::endl;
}

void setup()
{
    example_generate_sine_wave("output.wav");
    // Read existing WAV file (replace with actual file path)
    example_read_wave("output.wav");
}

void loop()
{

}
