# YOLOv5 推理类 API 文档

## 概述

`Yolov5` 类封装了 **YOLOv5 模型** 在 **K230 / K230D** 上的完整推理流程，包含以下主要环节：

* 图像预处理（由 **AI2D 模块** 实现）
* 模型推理（由 **KPU 神经网络加速单元** 执行）
* 结果后处理（解码输出、筛选候选框、执行 NMS）
* 检测结果可视化（使用 **OpenCV** 绘制）

支持以下任务类型：

* **图像分类**（`classify`）
* **目标检测**（`detect`）
* **语义分割**（`segment`）

该类提供统一接口以实现 YOLOv5 模型在 `K230/K230D` 的加载、推理与显示，便于快速部署多种 AI 场景应用。

## API 介绍

### 构造函数 `Yolov5()`

加载 YOLOv5 模型文件、初始化输入输出张量，并配置检测参数。

```cpp
Yolov5(std::string task_type,
       std::string task_mode,
       std::string kmodel_file,
       FrameSize image_wh,
       std::vector<std::string> labels,
       float conf_thres = 0.5f,
       float nms_thres = 0.5f,
       float mask_thres = 0.5f,
       int debug_mode = 0);
```

**参数**

| 参数名           | 类型                         | 说明                                                 |
| ------------- | -------------------------- | -------------------------------------------------- |
| `task_type`   | `std::string`              | 任务类型：`"classify"`（分类）、`"detect"`（检测）、`"segment"`（分割） |
| `task_mode`   | `std::string`              | 模式类型：`"video"`（视频流）或 `"image"`（单张图像）               |
| `kmodel_file` | `std::string`              | YOLOv5 模型文件路径（.kmodel）                             |
| `image_wh`    | `FrameSize`                | 原始输入图像宽高                                           |
| `labels`      | `std::vector<std::string>` | 类别标签列表                                             |
| `conf_thres`  | `float`                    | 置信度阈值（默认 0.5）                                      |
| `nms_thres`   | `float`                    | 非极大值抑制（NMS）阈值（默认 0.5）                              |
| `mask_thres`  | `float`                    | 分割任务掩码阈值（默认 0.5）                                   |
| `debug_mode`  | `int`                      | 调试等级：0=关闭，1=打印耗时，2=打印详细日志                          |

**返回值**

构造成功后返回一个 `Yolov5` 类实例。

### 析构函数 `~Yolov5()`

释放模型加载、预处理、推理过程中分配的所有资源，确保内存安全。

```cpp
~Yolov5();
```

**参数**

无

**返回值**

无

### 图像预处理方法 `pre_process`

执行图像预处理（包括缩放、Padding 等），将原始图像转换为模型输入格式。预处理结果存放于 `model_input_tensor_` 中，用于后续推理。

```cpp
void pre_process(runtime_tensor &input_tensor);
```

**参数**

| 参数名            | 类型                 | 说明                      |
| -------------- | ------------------ | ----------------------- |
| `input_tensor` | `runtime_tensor &` | 输入图像创建的张量，用于后续 AI2D 预处理 |

**返回值**

无

### 模型推理方法 `inference`

执行 `YOLOv5` 模型推理，将预处理后的输入数据送入 KPU（神经网络加速单元）进行计算。该接口执行完成后可直接调用后处理接口获取结果。

```cpp
void inference();
```

**参数**

无

**返回值**

无

### 后处理方法 `post_process`

解析模型输出，根据不同任务类型执行相应后处理逻辑：

* 分类任务中根据处理分类结果和置信度；
* 检测任务重提取每个检测框的置信度与类别，应用置信度阈值与 NMS（Non-Maximum Suppression）过滤，生成最终检测结果（边界框 + 类别 + 置信度）；
* 分割任务中提取每个检测框位置、类别置信度和mask图像；

```cpp
void post_process(std::vector<YOLOBbox> &yolo_results);
```

**参数**

| 参数名            | 类型                        | 说明            |
| -------------- | ------------------------- | ------------- |
| `yolo_results` | `std::vector<YOLOBbox> &` | 保存后处理后的检测结果集合 |

**返回值**

无

### 绘制检测结果方法 `draw_results`

在输入图像上绘制检测结果，包括：

* 边界框
* 类别标签文字
* 置信度数值
* mask图像

```cpp
void draw_results(cv::Mat &draw_frame, std::vector<YOLOBbox> &yolo_results);
```

**参数**

| 参数名            | 类型                        | 说明       |
| -------------- | ------------------------- | -------- |
| `draw_frame`   | `cv::Mat &`               | 需要绘制的图像帧 |
| `yolo_results` | `std::vector<YOLOBbox> &` | 后处理得到的检测框结果集   |

**返回值**

无

### 集成方法 `run`

单个方法实现，包含预处理、推理、后处理和结果绘制。

```cpp
void run(runtime_tensor &input_tensor, std::vector<YOLOBbox> &yolo_results);
```

**参数**

| 参数名            | 类型                        | 说明          |
| -------------- | ------------------------- | ----------- |
| `input_tensor` | `runtime_tensor &` | 输入图像创建的张量，用于后续的预处理过程 |
| `yolo_results` | `std::vector<YOLOBbox> &` | 后处理得到的检测框结果集 |

**返回值**

无


## 私有成员变量说明

该类的私有成员变量及其说明如下：

| 成员变量                  | 类型                         | 说明                                    |
| --------------------- | -------------------------- | ------------------------------------- |
| `model_input_tensor_` | `runtime_tensor`           | 模型输入张量（由 AI2D 预处理生成）                  |
| `task_type_`          | `std::string`              | 当前任务类型（`detect` / `segment` / `pose`） |
| `task_mode_`          | `std::string`              | 当前任务模式（`video` / `image`）             |
| `labels_`             | `std::vector<std::string>` | 类别标签列表                                |
| `label_num_`          | `int`                      | 类别总数                                  |
| `colors`              | `std::vector<cv::Scalar>`  | 绘制检测框与掩码时使用的颜色表                       |
| `image_wh_`           | `FrameSize`                | 原始图像分辨率                               |
| `input_wh_`           | `FrameSize`                | 模型输入分辨率（AI2D resize 输出）               |
| `conf_thres_`         | `float`                    | 置信度阈值（过滤低置信度检测）                       |
| `nms_thres_`          | `float`                    | 非极大值抑制阈值（去除重叠检测框）                     |
| `mask_thres_`         | `float`                    | 分割掩码阈值（二值化时使用）                        |
| `box_num_`            | `int`                      | 当前帧检测框数量                              |
| `max_box_num_`        | `int`                      | 最大检测框数量（用于内存预分配）                      |
| `box_feature_len_`    | `int`                      | 每个检测框的特征维度长度                          |
| `debug_mode_`         | `int`                      | 调试模式等级（0=关闭 / 1=打印耗时 / 2=详细日志）        |
| `kpu`                 | `KPU*`                     | KPU 模型推理单元实例指针                        |
| `ai2d_yolo`           | `AI2D*`                    | AI2D 图像预处理模块指针                        |
