# 2.5 `FFT` 模块 API 手册

## 1. 概述

FFT（快速傅里叶变换）模块用于对输入的时域数据进行傅里叶变换，将其转换为频域数据并返回相应的频率幅值。通过 FFT 运算，可以有效地将时域信号转换为频域信号，便于分析信号的频率成分。该模块还提供了IFFT（逆傅里叶变换）功能，用于将频域数据转换回时域信号。

## 2. API 介绍

FFT 模块提供了 `FFT` 和 `IFFT` 两个类，支持快速傅里叶变换、逆傅里叶变换、频率计算及幅值计算。

### 2.1 类 `FFT`

**描述**：

该类用于创建 FFT 对象，并对输入的时域数据进行傅里叶变换。

**构造函数**：

```cpp
FFT(const std::vector<int16_t>& real_input, int point = K230_FFT_Defaults::POINT, int shift = K230_FFT_Defaults::FFT_SHIFT)
```

**参数**：

| 参数名称 | 描述 |
| :--- | :--- |
| `real_input` | 输入的时域数据（实部），类型为 `std::vector<int16_t>`，大小为 `point` |
| `point` | FFT 运算的点数，支持 64、128、256、512、1024、2048 和 4096 点。默认为 `K230_FFT_Defaults::POINT` |
| `shift` | 缩放因子。默认为 `K230_FFT_Defaults::FFT_SHIFT`，一般不要修改这值 |

### 2.1.1 `run()` 方法

**描述**：

该函数用于执行傅里叶变换并返回频域数据。

**语法**：

```cpp
std::vector<int16_t> run()
```

**参数**：

无

**返回值**：

| 返回值 | 描述 |
| :--- | :--- |
| `std::vector<int16_t>` | 返回频域数据结果向量，大小为 `2 * point`。实数部分在前 `point` 个元素，虚数部分在后 `point` 个元素 |

### 2.1.2 `calculate_frequencies()` 静态方法

**描述**：

该函数用于计算频率值。

**语法**：

```cpp
static std::vector<int32_t> calculate_frequencies(int point, int sample_rate)
```

**参数**：

| 参数名称 | 描述 |
| :--- | :--- |
| `point` | 参与 FFT 运算的点数。 |
| `sample_rate` | 数据采样率。 |

**返回值**：

| 返回值 | 描述 |
| :--- | :--- |
| `std::vector<int32_t>` | 返回包含运算后各频率点的频率值向量。 |

### 2.1.3 `calculate_amplitudes()` 方法

**描述**：

该函数用于计算各个频率点的幅值。

**语法**：

```cpp
std::vector<int32_t> calculate_amplitudes()
std::vector<int32_t> calculate_amplitudes(const std::vector<int16_t>& complex_data)
```

**参数**：

| 参数名称 | 描述 |
| :--- | :--- |
| `complex_data` | FFT 计算结果数据，包含实部和虚部，大小为 `2 * point`。如不提供，则使用最近一次 `run()` 的结果 |

**返回值**：

| 返回值 | 描述 |
| :--- | :--- |
| `std::vector<int32_t>` | 返回包含各个频率点的幅值向量。 |

### 2.2 类 `IFFT`

**描述**：

该类用于创建 IFFT 对象，并对输入的频域数据进行逆傅里叶变换，将其转换回时域信号。

**构造函数**：

```cpp
IFFT(const std::vector<int16_t>& real_input, const std::vector<int16_t>& imag_input, int point = K230_FFT_Defaults::POINT, int shift = K230_FFT_Defaults::IFFT_SHIFT)
```

**参数**：

| 参数名称 | 描述 |
| :--- | :--- |
| `real_input` | 输入的频域数据实部，类型为 `std::vector<int16_t>`，大小为 `point` |
| `imag_input` | 输入的频域数据虚部，类型为 `std::vector<int16_t>`，大小为 `point` |
| `point` | IFFT 运算的点数，支持 64、128、256、512、1024、2048 和 4096 点。默认为 `K230_FFT_Defaults::POINT` |
| `shift` | 缩放因子。默认为 `K230_FFT_Defaults::IFFT_SHIFT`，一般不要修改这值 |

### 2.2.1 `run()` 方法

**描述**：

该函数用于执行逆傅里叶变换并返回时域数据。

**语法**：

```cpp
std::vector<int16_t> run()
```

**参数**：

无

**返回值**：

| 返回值 | 描述 |
| :--- | :--- |
| `std::vector<int16_t>` | 返回时域数据结果向量，大小为 `2 * point`。实数部分在前 `point` 个元素，虚数部分在后 `point` 个元素 |

## 3. 注意事项

1. FFT 和 IFFT 的点数必须是 64、128、256、512、1024、2048 或 4096 中的一个
1. 输入数据的长度必须与指定的点数相匹配
1. 默认的缩放因子通常不需要修改，除非有特殊需求
1. `calculate_frequencies` 是静态方法，可以直接通过类名调用
1. IFFT 类需要同时提供实部和虚部输入数据
