#include <Arduino.h>
#line 1 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino"
#include <iostream>
#include<opencv2/opencv.hpp>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/imgproc/imgproc.hpp>
#include <opencv2/imgproc/imgproc_c.h>
#include <stdlib.h>
 
using namespace std;
using namespace cv;

#line 40 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino"
void loop();
#line 12 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino"
void setup() {
  // put your setup code here, to run once:
  Mat src = imread("./a.jpg");
  if (src.empty())
  {
      cout << "Image not found" << endl;
      return;
  }

  Mat grayImage, dstImage;
  cvtColor(src, grayImage, COLOR_BGR2GRAY);
  grayImage = grayImage > 120;

  vector<vector<Point>> contours;
  vector<Vec4i> hierarchy;
  findContours(grayImage, contours, hierarchy,
                RETR_CCOMP, CHAIN_APPROX_SIMPLE);

  dstImage = Mat::zeros(grayImage.size(), CV_8UC3);
  for (size_t i = 0; i < hierarchy.size(); i++)
  {
      Scalar color(rand() % 255, rand() % 255, rand() % 255);
      drawContours(dstImage, contours, (int)i, color, FILLED, 8, hierarchy);
  }

  imwrite("lena_contours.jpg", dstImage);
}

void loop() {
  // put your main code here, to run repeatedly:

}

