#include <opencv2/core/core.hpp>
#include <opencv2/features2d/features2d.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <vector>

using namespace std;
using namespace cv;

void setup() {
  // put your setup code here, to run once:
  Mat image = imread("./feature_ori.jpg");
  vector<KeyPoint> keyPoints;

  Ptr<FeatureDetector> fast = FastFeatureDetector::create(40);
  fast->detect(image, keyPoints);

  drawKeypoints(image, keyPoints, image, Scalar::all(255),
                DrawMatchesFlags::DRAW_OVER_OUTIMG);

  imwrite("./demo24_fast_feature.jpg", image);
}

void loop() {
  // put your main code here, to run repeatedly:

}
