# OpenCV

## OpenCV简介

`OpenCV (Open Source Computer Vision Library)`，是一个跨平台的计算机视觉库，由英特尔公司发起并参与开发，以 `BSD` 许可证授权发行，可以在商业和研究领域中免费使用。`OpenCV` 可用于开发实时的图像处理、计算机视觉以及模式识别程序。`K230 RTOS SDK` 提供了针对 `K230` 优化的升级版 `OpenCV` 加速库，相比于原始版本 `OpenCV`，可大幅减少 `OpenCV` 算子的推理时间。比如：

| 算子名称 |K230+原始版OpenCV | K230+升级版OpenCV |
| ---    |  ---      | ---             |
| 计算积分图(inter) |   34.5ms | 7.7ms |
| 仿射变换 (warpaffine) |  391.1ms |34.7ms  |

注意：
>上述算子推理时间均在K230处理器1.6GHZ的条件下测试。
>计算积分图(inter)算子：输入图像为1280x1080灰度图；积分图类型为32位浮点数。
>仿射变换 (warpaffine)算子：输入图像为1280x1080灰度图；顺时针旋转15度，缩放0.6倍；目标图像为1280x1080灰度图；

此外，`K230 Arduino SDK` 中已包含预先交叉编译好的升级版 `OpenCV` 加速库，用户直接使用该静态库编译自己的可执行程序即可。

## 编译示例

本节介绍如何使用在 `K230 RTOS SDK` 中编译好的的 `OpenCV` 静态库，来进行可执行程序的编译。`SDK` 给出5个基于 `OpenCV` 实现的示例(位于 `libraries/OpenCV/examples/` 路径下)。

### 代码结构

该路径下的目录结构说明如下：

``` shell
libraries/OpenCV/examples
|-- calculate_hist                  # 计算图像直方图
|   |-- calculate_hist.ino
|-- detect_features2d               # 特征点检测
|   |-- detect_feature2d.ino
|-- find_contours                   # 轮廓检测
|   |-- find_contours.ino
|-- rgb2gray                        # 灰度化和二值化
|   |-- rgb2gray.ino
|-- obj_detect                      # 人脸和人眼检测
|   |-- obj_detect.ino
```

## 运行示例

>注意：
>
>所有测试用例运行所需的输入图像数据，均位于 `tests/utils`路径下。

### calculate_hist

本示例读取一张图像，计算其每个颜色通道（蓝、绿、红）的直方图。

原图如下：

![image_opencv_calculate_hist](https://www.kendryte.com/api/post/attachment?id=542)

`calculate_hist`示例的运行结果如下：

![test_opencv_calculate_hist](https://www.kendryte.com/api/post/attachment?id=541)

### detect_features2d

本示例主要功能是读取一张图像，使用 FAST 特征检测器检测图像中的特征点。

原图如下：

![image_opencv_detect_features2d](https://www.kendryte.com/api/post/attachment?id=543)

`detect_features2d`示例的运行结果如下：

![test_opencv_detect_features2d](https://www.kendryte.com/api/post/attachment?id=544)

### find_contours

本示例用于读取图像，检测图像中的轮廓，并将轮廓绘制出来保存为新图像。

原图如下：

![image_opencv_find_contours](https://www.kendryte.com/api/post/attachment?id=542)

`find_contours`示例的运行结果如下：

![test_opencv_find_contours](https://www.kendryte.com/api/post/attachment?id=545)

### rgb2gray

本示例主要功能是读取一张彩色图像，将其转换为灰度图像并保存，然后对灰度图像进行二值化处理并保存处理后的图像。

原图如下：

![image_opencv_grayscale_binarize](https://www.kendryte.com/api/post/attachment?id=542)

灰度图如下：

![grayscale_opencv_grayscale_binarize](https://www.kendryte.com/api/post/attachment?id=546)

`rgb2gray`示例的运行结果如下：

![test_opencv_grayscale_binarize](https://www.kendryte.com/api/post/attachment?id=547)

### obj_detect

本示例使用级联分类器检测图像中的人脸和眼睛，并在原始图像上绘制检测结果。

原图如下：

![image_opencv_obj_detect](https://www.kendryte.com/api/post/attachment?id=549)

`obj_detect`示例的运行结果如下：

![test_opencv_obj_detect](https://www.kendryte.com/api/post/attachment?id=548)
