# 1 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino"
# 2 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2
# 3 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2
# 4 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2
# 5 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2
# 6 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2
# 7 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2
# 8 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino" 2


# 9 "/builds/canmv/k230/arduino-k230-private/libraries/OpenCV/examples/find_contours/find_contours.ino"
using namespace std;
using namespace cv;

void setup() {
  // put your setup code here, to run once:
  Mat src = imread("./a.jpg");
  if (src.empty())
  {
      cout << "Image not found" << endl;
      return;
  }

  Mat grayImage, dstImage;
  cvtColor(src, grayImage, COLOR_BGR2GRAY);
  grayImage = grayImage > 120;

  vector<vector<Point>> contours;
  vector<Vec4i> hierarchy;
  findContours(grayImage, contours, hierarchy,
                RETR_CCOMP, CHAIN_APPROX_SIMPLE);

  dstImage = Mat::zeros(grayImage.size(), (((0) & ((1 << 3) - 1)) + (((3)-1) << 3)));
  for (size_t i = 0; i < hierarchy.size(); i++)
  {
      Scalar color(rand() % 255, rand() % 255, rand() % 255);
      drawContours(dstImage, contours, (int)i, color, FILLED, 8, hierarchy);
  }

  imwrite("lena_contours.jpg", dstImage);
}

void loop() {
  // put your main code here, to run repeatedly:

}
