#include <Arduino.h>
#line 1 "/builds/canmv/k230/arduino-k230-private/libraries/K230_YOLO/examples/yolov8_obb/yolov8_obb.ino"
#include <iostream>
#include <fstream>
#include <opencv2/opencv.hpp>
#include "yolov8.h"
#include "utils.h"

std::string model_type="yolov8";
std::string task_type="obb";
std::string task_mode="image";
std::string kmodel_path="yolov8n_obb.kmodel";
std::string image_path="test_obb.jpg";
float conf_thres=0.1;
float nms_thres=0.6;
float mask_thres=0.5;
std::vector<std::string> labels={"plane","ship","storage tank","baseball diamond","tennis court","basketball court","ground track field","harbor","bridge","large vehicle","small vehicle","helicopter","roundabout","soccer ball field","swimming pool"};
int debug_mode=2;

#line 18 "/builds/canmv/k230/arduino-k230-private/libraries/K230_YOLO/examples/yolov8_obb/yolov8_obb.ino"
void setup();
#line 30 "/builds/canmv/k230/arduino-k230-private/libraries/K230_YOLO/examples/yolov8_obb/yolov8_obb.ino"
void loop();
#line 18 "/builds/canmv/k230/arduino-k230-private/libraries/K230_YOLO/examples/yolov8_obb/yolov8_obb.ino"
void setup() {
  // put your setup code here, to run once:
  cv::Mat ori_img = cv::imread(image_path);
  FrameSize image_wh={ori_img.cols,ori_img.rows};
  runtime_tensor image_tensor=mat_to_tensor(ori_img);
  std::vector<YOLOBbox> yolo_results;
  Yolov8 yolov8(task_type,task_mode,kmodel_path,image_wh,labels,conf_thres,nms_thres,mask_thres,debug_mode);
  yolov8.run(image_tensor,yolo_results);
  yolov8.draw_results(ori_img,yolo_results);
  cv::imwrite("result_"+model_type+"_"+task_type+".jpg",ori_img);
}

void loop() {
  // put your main code here, to run repeatedly:

}

