#ifndef _FACE_EMOTION_H
#define _FACE_EMOTION_H

#include <vector>
#include <string>
#include "ai_utils.h"
#include "face_detection.h"

using std::vector;
using std::string;

typedef struct FaceEmotionInfo
{
    int idx=-1;
    float score=0.0f;
    std::string label="";
} FaceEmotionInfo;


class FaceEmotion
{
public:
    FaceEmotion(std::string &kmodel_file,  float thresh, FrameCHWSize image_size, int debug_mode);

    ~FaceEmotion();

    void pre_process(runtime_tensor &input_tensor, float* sparse_points);

    void inference();

    void post_process(FaceEmotionInfo& result);

    void draw_results(cv::Mat& draw_frame,Bbox& bbox,FaceEmotionInfo& result);

    void run(runtime_tensor &input_tensor, float* sparse_points, FaceEmotionInfo& result);

protected:
    void svd22(const float a[4], float u[4], float s[2], float v[4]);
    
    void image_umeyama_224(float* src, float* dst);

    void get_affine_matrix(float* sparse_points);

    void softmax(vector<float>& input,vector<float>& output);

private:
    runtime_tensor model_input_tensor_;            
    FrameCHWSize image_size_;
    FrameCHWSize input_size_;

    float matrix_dst_[10];   
    vector<string> label_list_={"Anger","Disgust","Fear","Happiness","Neutral","Sadness","Surprise"}; 
    float thresh_=0.5;
    int debug_mode_;                     ///< Debug flag

    KPU *kpu = nullptr;                  ///< Pointer to KPU (Kendryte Processing Unit) instance
    AI2D *ai2d = nullptr;                ///< Pointer to AI2D preprocessing module
};
#endif