#include "Arduino.h"

#include "mpi_vb_api.h"

static volatile int keep_runing = 1;

static void sig_handler(int dummy) { keep_runing = 0; }

int main()
{
    k_s32 ret;

    k_vb_config vb_cfg = { .max_pool_cnt = VB_MAX_COMM_POOLS };
    if (K_SUCCESS != (ret = kd_mpi_vb_set_config(&vb_cfg))) {
        printf("kd_mpi_vb_set_config failed %d\n", ret);
        return -1;
    }

    k_vb_supplement_config supplement_config = { VB_SUPPLEMENT_JPEG_MASK };
    if (K_SUCCESS != (ret = kd_mpi_vb_set_supplement_config(&supplement_config))) {
        printf("kd_mpi_vb_set_supplement_config failed(%d).\n", ret);
        return -1;
    }

    if (K_SUCCESS != (ret = kd_mpi_vb_init())) {
        printf("kd_mpi_vb_init failed(%d)", ret);
        return -1;
    }

    setup();

    while (keep_runing) {
        loop();
    }

    kd_mpi_vb_exit();

    return 0; // This line is never reached, but it's good practice to have a
              // return statement.
}
