#include <stdint.h>
#include "imlib_config.h"

#ifdef IMLIB_ENABLE_YUV_LAB_FUNC

#include "math.h"
#if 0
static inline float lab_f(float t)
{
    if (t > 0.008856)
        return powf(t, (1 / 3.0));
    else
        return ((7.787037 * t) + 0.137931);
}

static inline float lab_lin(float c)
{
    if (c <= 0.04045)
        return 100.0 * (c / 12.92);
    else
        return 100.0 * powf((c + 0.055) / 1.055, 2.4);
}

// https://github.com/openmv/openmv/blob/master/tools/gen_rgb2lab.py
int8_t lab_table(uint32_t idx)
{
    int8_t l = 0, a = 0, b = 0;
    float r = 0, g = 0, bb = 0;

    uint16_t pixel = idx / 3;
    uint8_t lab = idx % 3;

    r = (uint8_t)(((((pixel >> 3) & 31) * 255) + 15.5) / 31);
    g = (uint8_t)((((((pixel & 7) << 3) | (pixel >> 13)) * 255) + 31.5) / 63);
    bb = (uint8_t)(((((pixel >> 8) & 31) * 255) + 15.5) / 31);

    float r_lin = lab_lin(r / 255.0);
    float g_lin = lab_lin(g / 255.0);
    float b_lin = lab_lin(bb / 255.0);

    float x = (r_lin * 0.4124) + (g_lin * 0.3576) + (b_lin * 0.1805);
    float y = (r_lin * 0.2126) + (g_lin * 0.7152) + (b_lin * 0.0722);
    float z = (r_lin * 0.0193) + (g_lin * 0.1192) + (b_lin * 0.9505);

    x = lab_f(x / 095.047);
    y = lab_f(y / 100.000);
    z = lab_f(z / 108.883);

    l = (int8_t)(roundf(116.0 * y)) - 16;
    a = (int8_t)(roundf(500.0 * (x - y)));
    b = (int8_t)(roundf(200.0 * (y - z)));

    return (int8_t)(lab == 0) ? l : (lab == 1) ? a : (lab == 2) ? b : 0;
}
#else

const int8_t lab_table_small[24576] = {
       0,    0,    0,        9,  -19,   14,       23,  -32,   31,       35,  -42,   41,
      47,  -52,   50,       58,  -61,   59,       68,  -70,   68,       79,  -79,   76,
       0,    2,    1,       10,  -16,   14,       23,  -31,   31,       35,  -42,   41,
      47,  -52,   51,       58,  -61,   59,       68,  -70,   68,       79,  -79,   76,
       1,    4,    2,       10,  -14,   15,       23,  -29,   31,       35,  -40,   41,
      47,  -51,   51,       58,  -60,   59,       69,  -69,   68,       79,  -78,   76,
       2,    8,    3,       11,   -9,   16,       24,  -26,   31,       36,  -39,   41,
      47,  -50,   51,       58,  -60,   59,       69,  -69,   68,       79,  -78,   76,
       3,   13,    5,       12,   -5,   17,       24,  -23,   32,       36,  -37,   42,
      47,  -49,   51,       58,  -59,   60,       69,  -68,   68,       79,  -77,   76,
       4,   19,    7,       13,    0,   19,       24,  -20,   33,       36,  -35,   42,
      48,  -47,   51,       58,  -57,   60,       69,  -67,   68,       79,  -76,   77,
       6,   24,    9,       14,    5,   20,       25,  -16,   33,       36,  -32,   43,
      48,  -45,   51,       59,  -56,   60,       69,  -66,   68,       79,  -76,   77,
       8,   28,   13,       15,   10,   22,       26,  -12,   34,       37,  -28,   43,
      48,  -42,   52,       59,  -54,   60,       69,  -64,   69,       80,  -74,   77,
      10,   30,   16,       16,   14,   24,       27,   -8,   35,       37,  -25,   44,
      48,  -40,   52,       59,  -52,   61,       69,  -63,   69,       80,  -73,   77,
      12,   33,   19,       18,   18,   26,       27,   -3,   36,       38,  -22,   44,
      49,  -37,   53,       59,  -50,   61,       69,  -61,   69,       80,  -72,   77,
      14,   35,   22,       19,   22,   29,       28,    1,   37,       38,  -18,   45,
      49,  -34,   53,       60,  -47,   61,       70,  -59,   69,       80,  -70,   77,
      16,   37,   25,       21,   25,   31,       29,    5,   39,       39,  -14,   46,
      50,  -31,   54,       60,  -45,   62,       70,  -57,   70,       80,  -68,   78,
      19,   40,   29,       23,   29,   33,       30,   10,   40,       40,  -10,   47,
      50,  -27,   54,       60,  -42,   62,       70,  -54,   70,       81,  -66,   78,
      21,   42,   31,       24,   32,   35,       32,   14,   41,       41,   -6,   48,
      51,  -24,   55,       61,  -39,   63,       71,  -52,   70,       81,  -64,   78,
      22,   45,   34,       26,   35,   37,       33,   17,   43,       42,   -2,   49,
      51,  -20,   56,       61,  -35,   63,       71,  -49,   71,       81,  -62,   79,
      24,   47,   37,       27,   38,   39,       34,   21,   44,       42,    2,   50,
      52,  -16,   57,       62,  -32,   64,       71,  -46,   71,       81,  -59,   79,
      26,   49,   39,       29,   41,   42,       35,   25,   46,       43,    7,   51,
      53,  -12,   58,       62,  -28,   65,       72,  -43,   72,       82,  -56,   80,
      28,   51,   42,       31,   44,   44,       37,   29,   47,       44,   10,   52,
      54,   -8,   58,       63,  -25,   65,       72,  -40,   72,       82,  -54,   80,
      30,   53,   44,       33,   47,   45,       38,   32,   49,       45,   14,   53,
      54,   -5,   59,       63,  -22,   66,       73,  -37,   73,       83,  -51,   80,
      32,   55,   46,       34,   49,   47,       39,   35,   50,       46,   18,   54,
      55,   -1,   60,       64,  -18,   67,       73,  -34,   74,       83,  -48,   81,
      34,   58,   48,       36,   52,   49,       41,   39,   52,       48,   22,   56,
      56,    3,   61,       65,  -14,   68,       74,  -30,   74,       83,  -45,   82,
      36,   60,   50,       38,   54,   51,       42,   42,   53,       49,   25,   57,
      57,    7,   62,       66,  -10,   68,       74,  -27,   75,       84,  -42,   82,
      38,   62,   52,       39,   57,   53,       44,   45,   55,       50,   29,   58,
      58,   11,   63,       66,   -7,   69,       75,  -23,   76,       84,  -39,   83,
      39,   64,   54,       41,   59,   54,       45,   48,   56,       51,   32,   60,
      59,   14,   64,       67,   -3,   70,       76,  -20,   76,       85,  -35,   83,
      41,   66,   55,       43,   61,   56,       47,   51,   58,       52,   35,   61,
      60,   18,   66,       68,    0,   71,       76,  -16,   77,       85,  -32,   84,
      43,   68,   57,       44,   64,   58,       48,   54,   59,       54,   39,   62,
      61,   22,   67,       69,    4,   72,       77,  -12,   78,       86,  -28,   85,
      45,   70,   59,       46,   66,   59,       50,   56,   61,       55,   42,   64,
      62,   25,   68,       70,    8,   73,       78,   -9,   79,       87,  -25,   85,
      46,   72,   61,       48,   68,   61,       51,   59,   62,       56,   45,   65,
      63,   29,   69,       70,   11,   74,       79,   -5,   80,       87,  -22,   86,
      48,   74,   62,       49,   70,   63,       53,   61,   64,       57,   48,   67,
      64,   32,   70,       71,   15,   75,       79,   -2,   81,       88,  -18,   87,
      50,   76,   64,       51,   73,   64,       54,   64,   66,       59,   52,   68,
      65,   35,   72,       72,   19,   76,       80,    2,   82,       89,  -15,   88,
      52,   78,   66,       53,   75,   66,       56,   67,   67,       60,   54,   69,
      66,   39,   73,       73,   22,   77,       81,    5,   83,       89,  -11,   88,
      53,   80,   67,       54,   77,   68,       57,   69,   69,       61,   57,   71,
      67,   42,   74,       74,   25,   79,       82,    9,   84,       90,   -8,   89,
       0,    1,   -3,        9,  -18,   10,       23,  -32,   27,       35,  -42,   39,
      47,  -52,   49,       58,  -61,   58,       68,  -70,   67,       79,  -79,   75,
       1,    3,   -2,       10,  -15,   11,       23,  -30,   28,       35,  -41,   39,
      47,  -51,   49,       58,  -61,   58,       68,  -70,   67,       79,  -79,   76,
       1,    6,   -1,       10,  -13,   12,       23,  -28,   28,       35,  -40,   39,
      47,  -51,   49,       58,  -60,   58,       69,  -69,   67,       79,  -78,   76,
       2,    9,    0,       11,   -8,   13,       24,  -26,   28,       36,  -38,   39,
      47,  -50,   49,       58,  -59,   58,       69,  -69,   67,       79,  -78,   76,
       3,   14,    2,       12,   -4,   14,       24,  -23,   29,       36,  -36,   39,
      47,  -48,   49,       58,  -58,   58,       69,  -68,   67,       79,  -77,   76,
       4,   20,    4,       13,    1,   16,       25,  -19,   29,       36,  -34,   40,
      48,  -47,   50,       58,  -57,   59,       69,  -67,   67,       79,  -76,   76,
       6,   25,    6,       14,    5,   17,       25,  -16,   30,       36,  -31,   40,
      48,  -45,   50,       59,  -56,   59,       69,  -66,   67,       79,  -75,   76,
       8,   28,   10,       15,   10,   19,       26,  -11,   31,       37,  -28,   41,
      48,  -42,   50,       59,  -54,   59,       69,  -64,   68,       80,  -74,   76,
      10,   31,   13,       17,   14,   21,       27,   -7,   32,       37,  -25,   41,
      48,  -40,   51,       59,  -52,   59,       69,  -63,   68,       80,  -73,   76,
      12,   33,   16,       18,   18,   23,       27,   -3,   33,       38,  -21,   42,
      49,  -37,   51,       59,  -50,   60,       70,  -61,   68,       80,  -71,   76,
      14,   35,   19,       19,   22,   25,       28,    1,   34,       38,  -18,   43,
      49,  -34,   52,       60,  -47,   60,       70,  -59,   68,       80,  -70,   77,
      16,   38,   22,       21,   25,   27,       29,    5,   35,       39,  -14,   44,
      50,  -31,   52,       60,  -45,   61,       70,  -57,   69,       80,  -68,   77,
      19,   40,   25,       23,   29,   30,       31,   10,   37,       40,   -9,   45,
      50,  -27,   53,       60,  -41,   61,       70,  -54,   69,       81,  -66,   77,
      21,   42,   28,       24,   32,   32,       32,   14,   38,       41,   -5,   46,
      51,  -23,   54,       61,  -38,   62,       71,  -52,   70,       81,  -64,   78,
      23,   45,   31,       26,   35,   34,       33,   18,   40,       42,   -2,   47,
      51,  -20,   54,       61,  -35,   62,       71,  -49,   70,       81,  -61,   78,
      24,   47,   33,       27,   38,   36,       34,   21,   41,       42,    2,   48,
      52,  -16,   55,       62,  -32,   63,       71,  -46,   70,       81,  -59,   78,
      27,   49,   36,       29,   41,   38,       35,   25,   43,       43,    7,   49,
      53,  -12,   56,       62,  -28,   63,       72,  -43,   71,       82,  -56,   79,
      28,   51,   38,       31,   44,   40,       37,   29,   44,       44,   11,   50,
      54,   -8,   57,       63,  -25,   64,       72,  -40,   72,       82,  -54,   79,
      30,   54,   41,       33,   47,   42,       38,   32,   46,       45,   14,   51,
      54,   -5,   58,       63,  -21,   65,       73,  -37,   72,       83,  -51,   80,
      32,   56,   43,       34,   49,   44,       39,   35,   47,       46,   18,   52,
      55,   -1,   59,       64,  -18,   66,       73,  -33,   73,       83,  -48,   80,
      34,   58,   45,       36,   52,   46,       41,   39,   49,       48,   22,   54,
      56,    3,   60,       65,  -14,   67,       74,  -30,   73,       83,  -45,   81,
      36,   60,   47,       38,   54,   48,       42,   42,   51,       49,   25,   55,
      57,    7,   61,       66,  -10,   67,       74,  -26,   74,       84,  -42,   81,
      38,   62,   49,       39,   57,   50,       44,   45,   52,       50,   29,   57,
      58,   11,   62,       66,   -7,   68,       75,  -23,   75,       84,  -38,   82,
      39,   64,   51,       41,   59,   52,       45,   48,   54,       51,   32,   58,
      59,   14,   63,       67,   -3,   69,       76,  -20,   76,       85,  -35,   83,
      41,   66,   53,       43,   61,   53,       47,   51,   56,       52,   36,   59,
      60,   18,   64,       68,    0,   70,       76,  -16,   76,       85,  -32,   83,
      43,   68,   55,       44,   64,   55,       48,   54,   57,       54,   39,   61,
      61,   22,   66,       69,    4,   71,       77,  -12,   77,       86,  -28,   84,
      45,   70,   56,       46,   66,   57,       50,   56,   59,       55,   42,   62,
      62,   25,   67,       70,    8,   72,       78,   -9,   78,       87,  -25,   85,
      46,   72,   58,       48,   68,   59,       51,   59,   61,       56,   45,   64,
      63,   29,   68,       70,   11,   73,       79,   -5,   79,       87,  -22,   85,
      48,   74,   60,       49,   70,   61,       53,   62,   62,       57,   48,   65,
      64,   32,   69,       71,   15,   74,       79,   -2,   80,       88,  -18,   86,
      50,   76,   62,       51,   73,   62,       54,   64,   64,       59,   52,   67,
      65,   36,   71,       72,   19,   75,       80,    2,   81,       89,  -15,   87,
      52,   78,   64,       53,   75,   64,       56,   67,   66,       60,   54,   68,
      66,   39,   72,       73,   22,   76,       81,    5,   82,       89,  -11,   88,
      53,   80,   65,       54,   77,   66,       57,   69,   67,       62,   57,   70,
      67,   42,   73,       74,   26,   78,       82,    9,   83,       90,   -8,   89,
       0,    2,   -6,       10,  -16,    7,       23,  -31,   24,       35,  -41,   36,
      47,  -52,   47,       58,  -61,   57,       68,  -70,   66,       79,  -79,   75,
       1,    4,   -6,       10,  -14,    8,       23,  -29,   24,       35,  -41,   36,
      47,  -51,   47,       58,  -60,   57,       69,  -69,   66,       79,  -78,   75,
       1,    7,   -5,       10,  -11,    8,       23,  -28,   24,       35,  -40,   36,
      47,  -50,   47,       58,  -60,   57,       69,  -69,   66,       79,  -78,   75,
       2,   11,   -4,       11,   -7,    9,       24,  -25,   25,       36,  -38,   37,
      47,  -49,   48,       58,  -59,   57,       69,  -68,   66,       79,  -78,   75,
       3,   15,   -2,       12,   -3,   11,       24,  -22,   25,       36,  -36,   37,
      47,  -48,   48,       58,  -58,   57,       69,  -68,   66,       79,  -77,   75,
       5,   21,    0,       13,    2,   12,       25,  -19,   26,       36,  -34,   37,
      48,  -46,   48,       58,  -57,   57,       69,  -67,   66,       79,  -76,   75,
       6,   26,    3,       14,    6,   14,       25,  -15,   27,       36,  -31,   38,
      48,  -44,   48,       59,  -55,   58,       69,  -66,   66,       79,  -75,   75,
       8,   29,    6,       15,   11,   16,       26,  -11,   28,       37,  -28,   38,
      48,  -42,   49,       59,  -54,   58,       69,  -64,   67,       80,  -74,   75,
      11,   31,   10,       17,   15,   18,       27,   -7,   29,       37,  -24,   39,
      48,  -39,   49,       59,  -52,   58,       69,  -62,   67,       80,  -73,   75,
      13,   33,   13,       18,   19,   20,       28,   -3,   30,       38,  -21,   40,
      49,  -37,   50,       59,  -49,   59,       70,  -61,   67,       80,  -71,   76,
      15,   36,   16,       19,   22,   22,       28,    2,   31,       39,  -17,   41,
      49,  -34,   50,       60,  -47,   59,       70,  -59,   67,       80,  -70,   76,
      17,   38,   19,       21,   26,   24,       29,    6,   32,       39,  -13,   41,
      50,  -30,   51,       60,  -44,   59,       70,  -57,   68,       80,  -68,   76,
      19,   40,   22,       23,   29,   26,       31,   10,   34,       40,   -9,   42,
      50,  -27,   51,       60,  -41,   60,       70,  -54,   68,       81,  -66,   77,
      21,   43,   25,       24,   33,   28,       32,   14,   35,       41,   -5,   43,
      51,  -23,   52,       61,  -38,   60,       71,  -51,   69,       81,  -64,   77,
      23,   45,   27,       26,   36,   30,       33,   18,   37,       42,   -1,   44,
      51,  -20,   53,       61,  -35,   61,       71,  -49,   69,       81,  -61,   77,
      24,   47,   30,       28,   38,   33,       34,   22,   38,       42,    3,   46,
      52,  -16,   54,       62,  -32,   62,       71,  -46,   69,       81,  -59,   78,
      27,   49,   32,       29,   42,   35,       35,   26,   40,       43,    7,   47,
      53,  -12,   55,       62,  -28,   62,       72,  -43,   70,       82,  -56,   78,
      28,   52,   35,       31,   44,   37,       37,   29,   42,       44,   11,   48,
      54,   -8,   55,       63,  -25,   63,       72,  -40,   71,       82,  -53,   79,
      30,   54,   37,       33,   47,   39,       38,   32,   43,       45,   14,   49,
      54,   -4,   56,       63,  -21,   64,       73,  -37,   71,       83,  -51,   79,
      32,   56,   39,       34,   49,   41,       39,   36,   45,       47,   18,   51,
      55,   -1,   57,       64,  -18,   64,       73,  -33,   72,       83,  -48,   79,
      34,   58,   42,       36,   52,   43,       41,   39,   47,       48,   22,   52,
      56,    4,   58,       65,  -14,   65,       74,  -30,   73,       83,  -45,   80,
      36,   60,   44,       38,   55,   45,       42,   42,   48,       49,   26,   53,
      57,    7,   60,       66,  -10,   66,       75,  -26,   73,       84,  -41,   81,
      38,   62,   46,       39,   57,   47,       44,   45,   50,       50,   29,   55,
      58,   11,   61,       66,   -7,   67,       75,  -23,   74,       84,  -38,   81,
      39,   64,   48,       41,   59,   49,       45,   48,   52,       51,   32,   56,
      59,   14,   62,       67,   -3,   68,       76,  -20,   75,       85,  -35,   82,
      41,   66,   50,       43,   62,   51,       47,   51,   53,       52,   36,   57,
      60,   18,   63,       68,    1,   69,       76,  -16,   75,       85,  -32,   83,
      43,   68,   52,       45,   64,   53,       48,   54,   55,       54,   39,   59,
      61,   22,   64,       69,    5,   70,       77,  -12,   76,       86,  -28,   83,
      45,   70,   54,       46,   66,   55,       50,   56,   57,       55,   42,   61,
      62,   25,   65,       70,    8,   71,       78,   -9,   77,       87,  -25,   84,
      46,   72,   56,       48,   68,   57,       51,   59,   59,       56,   45,   62,
      63,   29,   67,       70,   12,   72,       79,   -5,   78,       87,  -22,   85,
      48,   74,   58,       49,   71,   58,       53,   62,   60,       57,   48,   63,
      64,   32,   68,       71,   15,   73,       79,   -2,   79,       88,  -18,   85,
      50,   76,   60,       51,   73,   60,       54,   64,   62,       59,   52,   65,
      65,   36,   69,       72,   19,   74,       80,    2,   80,       89,  -15,   86,
      52,   78,   61,       53,   75,   62,       56,   67,   64,       60,   55,   67,
      66,   39,   71,       73,   22,   75,       81,    6,   81,       89,  -11,   87,
      53,   80,   63,       54,   77,   64,       57,   69,   65,       62,   57,   68,
      67,   42,   72,       74,   26,   77,       82,    9,   82,       90,   -8,   88,
       1,    4,  -12,       10,  -14,    1,       23,  -29,   19,       35,  -41,   33,
      47,  -51,   45,       58,  -61,   55,       68,  -69,   64,       79,  -78,   73,
       1,    7,  -11,       10,  -12,    2,       23,  -28,   19,       35,  -40,   33,
      47,  -50,   45,       58,  -60,   55,       69,  -69,   64,       79,  -78,   73,
       2,    9,  -11,       11,   -9,    3,       24,  -26,   20,       35,  -39,   33,
      47,  -50,   45,       58,  -60,   55,       69,  -69,   64,       79,  -78,   73,
       3,   13,   -9,       11,   -5,    4,       24,  -24,   20,       36,  -37,   33,
      47,  -49,   45,       58,  -59,   55,       69,  -68,   64,       79,  -77,   74,
       4,   18,   -8,       12,   -1,    5,       24,  -21,   21,       36,  -35,   34,
      47,  -47,   45,       58,  -58,   55,       69,  -67,   65,       79,  -77,   74,
       5,   23,   -5,       13,    3,    6,       25,  -18,   21,       36,  -33,   34,
      48,  -46,   45,       58,  -57,   55,       69,  -66,   65,       79,  -76,   74,
       7,   27,   -3,       14,    7,    8,       25,  -14,   22,       37,  -30,   34,
      48,  -44,   46,       59,  -55,   56,       69,  -65,   65,       79,  -75,   74,
       9,   30,    1,       16,   12,   10,       26,  -10,   23,       37,  -27,   35,
      48,  -41,   46,       59,  -53,   56,       69,  -64,   65,       80,  -74,   74,
      11,   32,    4,       17,   16,   12,       27,   -6,   24,       37,  -24,   36,
      49,  -39,   46,       59,  -51,   56,       69,  -62,   65,       80,  -73,   74,
      13,   34,    7,       18,   19,   14,       28,   -2,   25,       38,  -20,   36,
      49,  -36,   47,       59,  -49,   57,       70,  -60,   66,       80,  -71,   74,
      15,   36,   10,       20,   23,   16,       28,    2,   27,       39,  -17,   37,
      49,  -33,   48,       60,  -47,   57,       70,  -58,   66,       80,  -69,   75,
      17,   38,   13,       21,   26,   18,       29,    6,   28,       39,  -13,   38,
      50,  -30,   48,       60,  -44,   57,       70,  -56,   66,       80,  -68,   75,
      19,   41,   16,       23,   30,   21,       31,   11,   30,       40,   -9,   39,
      50,  -26,   49,       60,  -41,   58,       70,  -54,   67,       81,  -65,   75,
      21,   43,   19,       24,   33,   23,       32,   14,   31,       41,   -5,   40,
      51,  -23,   50,       61,  -38,   58,       71,  -51,   67,       81,  -63,   76,
      23,   45,   22,       26,   36,   25,       33,   18,   33,       42,   -1,   41,
      51,  -19,   50,       61,  -35,   59,       71,  -49,   67,       81,  -61,   76,
      25,   47,   24,       28,   39,   27,       34,   22,   34,       43,    3,   42,
      52,  -16,   51,       62,  -32,   60,       71,  -46,   68,       81,  -59,   76,
      27,   50,   27,       29,   42,   30,       36,   26,   36,       44,    7,   44,
      53,  -12,   52,       62,  -28,   60,       72,  -42,   69,       82,  -56,   77,
      29,   52,   30,       31,   44,   32,       37,   29,   38,       45,   11,   45,
      54,   -8,   53,       63,  -25,   61,       72,  -39,   69,       82,  -53,   77,
      30,   54,   32,       33,   47,   34,       38,   33,   39,       46,   15,   46,
      54,   -4,   54,       64,  -21,   62,       73,  -36,   70,       83,  -51,   78,
      32,   56,   34,       34,   50,   36,       39,   36,   41,       47,   18,   48,
      55,    0,   55,       64,  -18,   63,       73,  -33,   70,       83,  -48,   78,
      34,   58,   37,       36,   52,   39,       41,   39,   43,       48,   22,   49,
      56,    4,   56,       65,  -14,   64,       74,  -29,   71,       83,  -44,   79,
      36,   60,   39,       38,   55,   41,       42,   42,   45,       49,   26,   50,
      57,    7,   57,       66,  -10,   64,       75,  -26,   72,       84,  -41,   79,
      38,   62,   41,       39,   57,   43,       44,   45,   47,       50,   29,   52,
      58,   11,   58,       66,   -6,   65,       75,  -23,   72,       84,  -38,   80,
      39,   64,   44,       41,   59,   45,       45,   48,   48,       51,   33,   53,
      59,   15,   60,       67,   -3,   66,       76,  -19,   73,       85,  -35,   81,
      41,   66,   46,       43,   62,   47,       47,   51,   50,       52,   36,   55,
      60,   18,   61,       68,    1,   67,       76,  -16,   74,       85,  -32,   81,
      43,   68,   48,       45,   64,   49,       48,   54,   52,       54,   39,   56,
      61,   22,   62,       69,    5,   68,       77,  -12,   75,       86,  -28,   82,
      45,   70,   50,       46,   66,   51,       50,   57,   54,       55,   43,   58,
      62,   25,   63,       70,    8,   69,       78,   -9,   76,       87,  -25,   83,
      46,   72,   52,       48,   69,   53,       51,   59,   56,       56,   46,   59,
      63,   29,   65,       70,   12,   70,       79,   -5,   77,       87,  -22,   84,
      48,   74,   54,       49,   71,   55,       53,   62,   57,       58,   49,   61,
      64,   32,   66,       71,   15,   71,       79,   -2,   78,       88,  -18,   84,
      50,   77,   56,       51,   73,   57,       54,   64,   59,       59,   52,   63,
      65,   36,   67,       72,   19,   73,       80,    2,   79,       89,  -14,   85,
      52,   78,   58,       53,   75,   59,       56,   67,   61,       60,   55,   64,
      66,   39,   69,       73,   22,   74,       81,    6,   80,       89,  -11,   86,
      53,   80,   60,       54,   77,   61,       57,   69,   63,       62,   57,   66,
      67,   42,   70,       74,   26,   75,       82,    9,   81,       90,   -8,   87,
       1,    7,  -18,       10,  -11,   -4,       23,  -28,   14,       35,  -40,   29,
      47,  -50,   42,       58,  -60,   53,       69,  -69,   62,       79,  -78,   72,
       1,    9,  -17,       11,   -9,   -3,       23,  -26,   15,       35,  -39,   29,
      47,  -50,   42,       58,  -60,   53,       69,  -69,   62,       79,  -78,   72,
       2,   11,  -16,       11,   -6,   -3,       24,  -25,   15,       36,  -38,   29,
      47,  -49,   42,       58,  -59,   53,       69,  -68,   63,       79,  -78,   72,
       3,   15,  -15,       12,   -3,   -2,       24,  -22,   15,       36,  -36,   30,
      47,  -48,   42,       58,  -58,   53,       69,  -68,   63,       79,  -77,   72,
       4,   20,  -13,       12,    1,   -1,       24,  -20,   16,       36,  -34,   30,
      47,  -47,   42,       58,  -57,   53,       69,  -67,   63,       79,  -76,   72,
       5,   24,  -11,       13,    5,    1,       25,  -17,   17,       36,  -32,   30,
      48,  -45,   42,       58,  -56,   53,       69,  -66,   63,       79,  -76,   72,
       7,   28,   -9,       14,    8,    3,       25,  -13,   17,       37,  -30,   31,
      48,  -43,   43,       59,  -55,   53,       69,  -65,   63,       79,  -75,   72,
       9,   30,   -5,       16,   13,    5,       26,   -9,   19,       37,  -26,   31,
      48,  -41,   43,       59,  -53,   54,       69,  -63,   63,       80,  -74,   73,
      11,   33,   -2,       17,   16,    7,       27,   -5,   20,       38,  -23,   32,
      49,  -38,   44,       59,  -51,   54,       69,  -62,   63,       80,  -72,   73,
      13,   35,    1,       18,   20,    9,       28,   -1,   21,       38,  -20,   33,
      49,  -36,   44,       59,  -49,   54,       70,  -60,   64,       80,  -71,   73,
      15,   37,    4,       20,   23,   11,       29,    3,   22,       39,  -16,   34,
      49,  -33,   45,       60,  -46,   55,       70,  -58,   64,       80,  -69,   73,
      17,   39,    7,       21,   27,   13,       30,    7,   24,       39,  -12,   34,
      50,  -30,   45,       60,  -44,   55,       70,  -56,   64,       80,  -67,   73,
      19,   41,   11,       23,   30,   16,       31,   11,   25,       40,   -8,   36,
      50,  -26,   46,       60,  -41,   56,       70,  -53,   65,       81,  -65,   74,
      21,   43,   13,       25,   33,   18,       32,   15,   27,       41,   -4,   37,
      51,  -22,   47,       61,  -38,   56,       71,  -51,   65,       81,  -63,   74,
      23,   46,   16,       26,   36,   20,       33,   19,   28,       42,   -1,   38,
      52,  -19,   48,       61,  -35,   57,       71,  -48,   66,       81,  -61,   74,
      25,   48,   19,       28,   39,   23,       34,   22,   30,       43,    3,   39,
      52,  -15,   48,       62,  -31,   57,       71,  -45,   66,       81,  -59,   75,
      27,   50,   22,       30,   42,   25,       36,   26,   32,       44,    8,   40,
      53,  -11,   49,       62,  -28,   58,       72,  -42,   67,       82,  -56,   75,
      29,   52,   25,       31,   45,   27,       37,   30,   34,       45,   11,   42,
      54,   -8,   50,       63,  -24,   59,       72,  -39,   67,       82,  -53,   76,
      30,   54,   27,       33,   47,   30,       38,   33,   35,       46,   15,   43,
      54,   -4,   51,       64,  -21,   60,       73,  -36,   68,       83,  -50,   76,
      32,   56,   30,       34,   50,   32,       40,   36,   37,       47,   19,   44,
      55,    0,   52,       64,  -17,   60,       73,  -33,   69,       83,  -47,   77,
      34,   58,   32,       36,   53,   34,       41,   40,   39,       48,   23,   46,
      56,    4,   54,       65,  -13,   61,       74,  -29,   69,       83,  -44,   77,
      36,   60,   35,       38,   55,   37,       42,   43,   41,       49,   26,   47,
      57,    8,   55,       66,  -10,   62,       75,  -26,   70,       84,  -41,   78,
      38,   62,   37,       40,   57,   39,       44,   45,   43,       50,   29,   49,
      58,   11,   56,       66,   -6,   63,       75,  -23,   71,       84,  -38,   79,
      39,   64,   39,       41,   60,   41,       45,   48,   45,       51,   33,   50,
      59,   15,   57,       67,   -3,   64,       76,  -19,   72,       85,  -35,   79,
      41,   66,   42,       43,   62,   43,       47,   51,   47,       52,   36,   52,
      60,   18,   58,       68,    1,   65,       76,  -16,   72,       85,  -32,   80,
      43,   69,   44,       45,   64,   45,       48,   54,   49,       54,   40,   54,
      61,   22,   60,       69,    5,   66,       77,  -12,   73,       86,  -28,   81,
      45,   71,   46,       46,   67,   47,       50,   57,   50,       55,   43,   55,
      62,   26,   61,       70,    8,   67,       78,   -8,   74,       87,  -25,   81,
      46,   73,   48,       48,   69,   49,       51,   59,   52,       56,   46,   57,
      63,   29,   62,       71,   12,   68,       79,   -5,   75,       87,  -21,   82,
      48,   74,   50,       49,   71,   51,       53,   62,   54,       58,   49,   58,
      64,   32,   64,       71,   15,   70,       79,   -1,   76,       88,  -18,   83,
      50,   77,   53,       51,   73,   54,       54,   65,   56,       59,   52,   60,
      65,   36,   65,       72,   19,   71,       80,    2,   77,       89,  -14,   84,
      52,   79,   55,       53,   75,   56,       56,   67,   58,       60,   55,   62,
      66,   39,   66,       73,   23,   72,       81,    6,   78,       89,  -11,   85,
      53,   80,   57,       54,   77,   58,       57,   69,   60,       62,   58,   63,
      68,   42,   68,       74,   26,   73,       82,    9,   79,       90,   -8,   85,
       1,   10,  -24,       11,   -8,   -9,       23,  -26,    9,       35,  -38,   25,
      47,  -50,   38,       58,  -59,   50,       69,  -69,   60,       79,  -78,   70,
       2,   12,  -23,       11,   -6,   -9,       24,  -24,   10,       36,  -38,   25,
      47,  -49,   38,       58,  -59,   50,       69,  -68,   60,       79,  -77,   70,
       2,   15,  -22,       11,   -4,   -8,       24,  -23,   10,       36,  -37,   25,
      47,  -48,   39,       58,  -58,   50,       69,  -68,   60,       79,  -77,   70,
       3,   19,  -21,       12,    0,   -7,       24,  -21,   11,       36,  -35,   25,
      47,  -47,   39,       58,  -58,   50,       69,  -67,   60,       79,  -77,   70,
       4,   23,  -19,       13,    3,   -6,       25,  -18,   11,       36,  -33,   26,
      48,  -46,   39,       58,  -57,   50,       69,  -67,   61,       79,  -76,   70,
       6,   26,  -17,       14,    6,   -4,       25,  -15,   12,       36,  -31,   26,
      48,  -44,   39,       58,  -56,   50,       69,  -66,   61,       79,  -75,   70,
       7,   29,  -14,       15,   10,   -3,       26,  -12,   13,       37,  -29,   27,
      48,  -43,   40,       59,  -54,   51,       69,  -64,   61,       79,  -74,   71,
       9,   31,  -10,       16,   14,   -1,       26,   -8,   14,       37,  -25,   27,
      48,  -40,   40,       59,  -52,   51,       69,  -63,   61,       80,  -73,   71,
      11,   33,   -7,       17,   18,    1,       27,   -4,   15,       38,  -22,   28,
      49,  -38,   40,       59,  -50,   51,       69,  -61,   61,       80,  -72,   71,
      13,   35,   -4,       19,   21,    3,       28,    0,   16,       38,  -19,   29,
      49,  -35,   41,       59,  -48,   52,       70,  -60,   62,       80,  -70,   71,
      15,   37,   -1,       20,   24,    6,       29,    4,   17,       39,  -15,   30,
      49,  -32,   41,       60,  -46,   52,       70,  -58,   62,       80,  -69,   71,
      17,   40,    2,       21,   28,    8,       30,    8,   19,       39,  -12,   31,
      50,  -29,   42,       60,  -43,   53,       70,  -56,   62,       80,  -67,   72,
      19,   42,    5,       23,   31,   11,       31,   12,   21,       40,   -8,   32,
      50,  -25,   43,       60,  -40,   53,       70,  -53,   63,       81,  -65,   72,
      21,   44,    8,       25,   34,   13,       32,   16,   22,       41,   -4,   33,
      51,  -22,   44,       61,  -37,   54,       71,  -51,   63,       81,  -63,   72,
      23,   46,   11,       26,   37,   15,       33,   19,   24,       42,    0,   34,
      52,  -18,   44,       61,  -34,   54,       71,  -48,   64,       81,  -61,   73,
      25,   48,   14,       28,   40,   18,       34,   23,   26,       43,    4,   35,
      52,  -15,   45,       62,  -31,   55,       72,  -45,   64,       81,  -58,   73,
      27,   50,   17,       30,   43,   20,       36,   27,   28,       44,    8,   37,
      53,  -11,   46,       62,  -27,   56,       72,  -42,   65,       82,  -55,   74,
      29,   52,   19,       31,   45,   23,       37,   30,   29,       45,   12,   38,
      54,   -7,   47,       63,  -24,   56,       72,  -39,   65,       82,  -53,   74,
      31,   54,   22,       33,   48,   25,       38,   33,   31,       46,   15,   39,
      54,   -3,   48,       64,  -20,   57,       73,  -36,   66,       83,  -50,   75,
      32,   56,   25,       35,   50,   27,       40,   36,   33,       47,   19,   41,
      55,    0,   49,       64,  -17,   58,       73,  -33,   66,       83,  -47,   75,
      34,   59,   27,       36,   53,   30,       41,   40,   35,       48,   23,   42,
      56,    4,   51,       65,  -13,   59,       74,  -29,   67,       83,  -44,   76,
      36,   61,   30,       38,   55,   32,       42,   43,   37,       49,   26,   44,
      57,    8,   52,       66,   -9,   60,       75,  -26,   68,       84,  -41,   76,
      38,   63,   32,       40,   58,   34,       44,   46,   39,       50,   30,   45,
      58,   12,   53,       66,   -6,   61,       75,  -22,   69,       84,  -38,   77,
      40,   65,   35,       41,   60,   37,       45,   49,   41,       51,   33,   47,
      59,   15,   54,       67,   -2,   62,       76,  -19,   70,       85,  -35,   78,
      41,   67,   37,       43,   62,   39,       47,   51,   43,       52,   36,   48,
      60,   19,   55,       68,    1,   63,       76,  -15,   70,       85,  -31,   78,
      43,   69,   40,       45,   65,   41,       48,   54,   45,       54,   40,   50,
      61,   22,   57,       69,    5,   64,       77,  -12,   71,       86,  -28,   79,
      45,   71,   42,       46,   67,   43,       50,   57,   47,       55,   43,   52,
      62,   26,   58,       70,    9,   65,       78,   -8,   72,       87,  -24,   80,
      47,   73,   44,       48,   69,   45,       51,   60,   49,       56,   46,   53,
      63,   29,   59,       71,   12,   66,       79,   -5,   73,       87,  -21,   80,
      48,   75,   46,       50,   71,   48,       53,   62,   51,       58,   49,   55,
      64,   32,   61,       71,   16,   67,       79,   -1,   74,       88,  -18,   81,
      50,   77,   49,       51,   73,   50,       54,   65,   53,       59,   52,   57,
      65,   36,   62,       72,   19,   68,       80,    3,   75,       89,  -14,   82,
      52,   79,   51,       53,   75,   52,       56,   67,   54,       60,   55,   58,
      66,   39,   64,       73,   23,   70,       81,    6,   76,       89,  -11,   83,
      53,   81,   53,       55,   77,   54,       57,   70,   56,       62,   58,   60,
      68,   42,   65,       74,   26,   71,       82,    9,   77,       90,   -7,   84,
       2,   14,  -29,       11,   -4,  -15,       24,  -23,    5,       36,  -37,   21,
      47,  -49,   35,       58,  -59,   47,       69,  -68,   58,       79,  -77,   68,
       2,   16,  -28,       11,   -2,  -14,       24,  -22,    5,       36,  -36,   21,
      47,  -48,   35,       58,  -58,   47,       69,  -68,   58,       79,  -77,   68,
       3,   19,  -27,       12,    0,  -13,       24,  -21,    5,       36,  -35,   21,
      47,  -47,   35,       58,  -58,   47,       69,  -67,   58,       79,  -77,   68,
       4,   22,  -26,       12,    2,  -12,       24,  -19,    6,       36,  -34,   21,
      47,  -46,   35,       58,  -57,   47,       69,  -67,   58,       79,  -76,   68,
       5,   26,  -24,       13,    5,  -11,       25,  -16,    6,       36,  -32,   21,
      48,  -45,   35,       58,  -56,   47,       69,  -66,   58,       79,  -76,   68,
       6,   29,  -22,       14,    8,  -10,       25,  -13,    7,       36,  -30,   22,
      48,  -43,   36,       59,  -55,   47,       69,  -65,   58,       79,  -75,   68,
       8,   31,  -19,       15,   12,   -8,       26,  -10,    8,       37,  -27,   22,
      48,  -42,   36,       59,  -53,   48,       69,  -64,   58,       80,  -74,   68,
      10,   33,  -16,       16,   16,   -6,       26,   -6,    9,       37,  -24,   23,
      48,  -39,   36,       59,  -51,   48,       69,  -62,   59,       80,  -73,   69,
      12,   35,  -13,       18,   19,   -4,       27,   -3,   10,       38,  -21,   24,
      49,  -37,   37,       59,  -50,   48,       69,  -61,   59,       80,  -71,   69,
      14,   36,  -10,       19,   22,   -2,       28,    1,   11,       38,  -18,   25,
      49,  -34,   37,       59,  -47,   49,       70,  -59,   59,       80,  -70,   69,
      16,   38,   -7,       20,   25,    0,       29,    5,   13,       39,  -14,   25,
      49,  -31,   38,       60,  -45,   49,       70,  -57,   59,       80,  -68,   69,
      17,   40,   -4,       22,   28,    3,       30,    9,   14,       39,  -11,   26,
      50,  -28,   39,       60,  -43,   50,       70,  -55,   60,       80,  -67,   70,
      20,   43,    0,       23,   32,    5,       31,   13,   16,       40,   -7,   27,
      50,  -25,   39,       61,  -39,   50,       70,  -53,   60,       81,  -65,   70,
      21,   45,    3,       25,   35,    8,       32,   16,   17,       41,   -3,   29,
      51,  -21,   40,       61,  -37,   51,       71,  -50,   61,       81,  -62,   70,
      23,   47,    6,       26,   37,   10,       33,   20,   19,       42,    1,   30,
      52,  -18,   41,       61,  -34,   51,       71,  -47,   61,       81,  -60,   71,
      25,   49,    8,       28,   40,   12,       34,   23,   21,       43,    4,   31,
      52,  -14,   42,       62,  -30,   52,       72,  -45,   62,       81,  -58,   71,
      27,   51,   12,       30,   43,   15,       36,   27,   23,       44,    9,   32,
      53,  -10,   43,       62,  -27,   53,       72,  -41,   62,       82,  -55,   71,
      29,   53,   14,       31,   46,   18,       37,   31,   25,       45,   12,   34,
      54,   -7,   44,       63,  -23,   53,       72,  -38,   63,       82,  -52,   72,
      31,   55,   17,       33,   48,   20,       38,   34,   27,       46,   16,   35,
      55,   -3,   45,       64,  -20,   54,       73,  -35,   63,       83,  -50,   72,
      32,   57,   20,       35,   51,   22,       40,   37,   29,       47,   19,   37,
      55,    1,   46,       64,  -17,   55,       73,  -32,   64,       83,  -47,   73,
      34,   59,   23,       36,   53,   25,       41,   40,   31,       48,   23,   38,
      56,    5,   47,       65,  -13,   56,       74,  -29,   65,       84,  -44,   74,
      36,   61,   25,       38,   56,   27,       43,   43,   33,       49,   27,   40,
      57,    8,   48,       66,   -9,   57,       75,  -25,   66,       84,  -41,   74,
      38,   63,   28,       40,   58,   30,       44,   46,   35,       50,   30,   41,
      58,   12,   50,       66,   -6,   58,       75,  -22,   66,       84,  -37,   75,
      40,   65,   30,       41,   60,   32,       45,   49,   37,       51,   33,   43,
      59,   15,   51,       67,   -2,   59,       76,  -19,   67,       85,  -34,   75,
      41,   67,   32,       43,   62,   34,       47,   52,   38,       53,   37,   45,
      60,   19,   52,       68,    1,   60,       76,  -15,   68,       86,  -31,   76,
      43,   69,   35,       45,   65,   37,       48,   55,   41,       54,   40,   46,
      61,   23,   54,       69,    5,   61,       77,  -11,   69,       86,  -28,   77,
      45,   71,   37,       46,   67,   39,       50,   57,   43,       55,   43,   48,
      62,   26,   55,       70,    9,   62,       78,   -8,   70,       87,  -24,   78,
      47,   73,   40,       48,   69,   41,       51,   60,   45,       56,   46,   50,
      63,   29,   56,       71,   12,   63,       79,   -4,   71,       87,  -21,   78,
      48,   75,   42,       50,   71,   43,       53,   62,   47,       58,   49,   51,
      64,   33,   58,       71,   16,   65,       79,   -1,   72,       88,  -18,   79,
      50,   77,   45,       51,   74,   46,       54,   65,   49,       59,   52,   53,
      65,   36,   59,       73,   20,   66,       80,    3,   73,       89,  -14,   80,
      52,   79,   47,       53,   76,   48,       56,   67,   51,       60,   55,   55,
      66,   40,   61,       73,   23,   67,       81,    6,   74,       89,  -11,   81,
      53,   81,   49,       55,   78,   50,       57,   70,   53,       62,   58,   57,
      68,   43,   62,       74,   26,   68,       82,   10,   75,       90,   -7,   82,
       3,   19,  -34,       12,    0,  -20,       24,  -21,   -1,       36,  -35,   15,
      47,  -47,   30,       58,  -58,   43,       69,  -67,   54,       79,  -77,   65,
       3,   21,  -33,       12,    2,  -19,       24,  -19,   -1,       36,  -34,   16,
      47,  -47,   30,       58,  -57,   43,       69,  -67,   54,       79,  -76,   65,
       4,   24,  -33,       12,    3,  -19,       24,  -18,    0,       36,  -33,   16,
      47,  -46,   31,       58,  -57,   43,       69,  -67,   55,       79,  -76,   65,
       5,   26,  -31,       13,    6,  -18,       25,  -16,    0,       36,  -32,   16,
      48,  -45,   31,       58,  -56,   43,       69,  -66,   55,       79,  -76,   65,
       6,   29,  -29,       14,    8,  -17,       25,  -14,    1,       36,  -30,   16,
      48,  -44,   31,       58,  -55,   43,       69,  -65,   55,       79,  -75,   65,
       7,   31,  -27,       14,   11,  -15,       25,  -11,    1,       37,  -28,   17,
      48,  -42,   31,       59,  -54,   44,       69,  -64,   55,       79,  -74,   66,
       9,   33,  -24,       15,   14,  -14,       26,   -8,    2,       37,  -26,   17,
      48,  -40,   32,       59,  -52,   44,       69,  -63,   55,       80,  -73,   66,
      11,   34,  -21,       17,   18,  -12,       27,   -5,    3,       37,  -23,   18,
      48,  -38,   32,       59,  -51,   44,       69,  -62,   55,       80,  -72,   66,
      12,   36,  -18,       18,   21,  -10,       27,   -1,    4,       38,  -20,   19,
      49,  -36,   32,       59,  -49,   44,       70,  -60,   56,       80,  -71,   66,
      14,   38,  -15,       19,   24,   -8,       28,    3,    6,       38,  -17,   20,
      49,  -33,   33,       60,  -47,   45,       70,  -58,   56,       80,  -69,   66,
      16,   39,  -12,       21,   27,   -5,       29,    6,    7,       39,  -13,   20,
      50,  -30,   34,       60,  -44,   45,       70,  -57,   56,       80,  -68,   67,
      18,   41,   -9,       22,   30,   -3,       30,   10,    9,       40,  -10,   21,
      50,  -27,   34,       60,  -42,   46,       70,  -54,   57,       80,  -66,   67,
      20,   43,   -6,       24,   33,    0,       31,   14,   10,       40,   -6,   23,
      51,  -24,   35,       61,  -39,   46,       71,  -52,   57,       81,  -64,   67,
      22,   45,   -3,       25,   36,    2,       32,   17,   12,       41,   -2,   24,
      51,  -20,   36,       61,  -36,   47,       71,  -49,   57,       81,  -62,   68,
      24,   47,    0,       27,   38,    4,       33,   21,   14,       42,    2,   25,
      52,  -17,   37,       61,  -33,   48,       71,  -47,   58,       81,  -60,   68,
      25,   49,    3,       28,   41,    7,       35,   24,   15,       43,    5,   26,
      52,  -13,   38,       62,  -30,   48,       72,  -44,   58,       82,  -57,   68,
      27,   51,    6,       30,   44,    9,       36,   28,   18,       44,    9,   28,
      53,  -10,   39,       63,  -26,   49,       72,  -41,   59,       82,  -55,   69,
      29,   53,    8,       32,   46,   12,       37,   31,   19,       45,   13,   29,
      54,   -6,   40,       63,  -23,   50,       73,  -38,   60,       82,  -52,   69,
      31,   55,   11,       33,   49,   14,       39,   34,   21,       46,   17,   30,
      55,   -2,   41,       64,  -19,   51,       73,  -35,   60,       83,  -49,   70,
      33,   57,   14,       35,   51,   17,       40,   37,   23,       47,   20,   32,
      55,    1,   42,       64,  -16,   51,       74,  -32,   61,       83,  -46,   70,
      35,   60,   17,       37,   54,   19,       41,   41,   26,       48,   24,   34,
      56,    5,   43,       65,  -12,   52,       74,  -28,   62,       84,  -43,   71,
      36,   61,   19,       38,   56,   22,       43,   44,   27,       49,   27,   35,
      57,    9,   44,       66,   -9,   53,       75,  -25,   62,       84,  -40,   72,
      38,   63,   22,       40,   58,   24,       44,   47,   29,       50,   31,   37,
      58,   12,   46,       66,   -5,   54,       75,  -22,   63,       85,  -37,   72,
      40,   65,   25,       41,   61,   27,       46,   49,   32,       51,   34,   38,
      59,   16,   47,       67,   -2,   55,       76,  -18,   64,       85,  -34,   73,
      41,   67,   27,       43,   63,   29,       47,   52,   34,       53,   37,   40,
      60,   19,   48,       68,    2,   56,       77,  -15,   65,       86,  -31,   74,
      43,   69,   30,       45,   65,   32,       49,   55,   36,       54,   41,   42,
      61,   23,   50,       69,    6,   58,       77,  -11,   66,       86,  -27,   74,
      45,   71,   32,       46,   67,   34,       50,   58,   38,       55,   44,   44,
      62,   27,   51,       70,    9,   59,       78,   -8,   67,       87,  -24,   75,
      47,   73,   35,       48,   69,   36,       51,   60,   40,       56,   47,   45,
      63,   30,   52,       71,   13,   60,       79,   -4,   68,       87,  -21,   76,
      48,   75,   37,       50,   71,   38,       53,   63,   42,       58,   49,   47,
      64,   33,   54,       72,   16,   61,       79,   -1,   69,       88,  -17,   77,
      50,   77,   40,       51,   74,   41,       54,   65,   44,       59,   53,   49,
      65,   37,   55,       73,   20,   62,       80,    3,   70,       89,  -14,   78,
      52,   79,   42,       53,   76,   43,       56,   68,   46,       60,   55,   51,
      67,   40,   57,       73,   23,   64,       81,    7,   71,       89,  -10,   78,
      54,   81,   44,       55,   78,   45,       57,   70,   48,       62,   58,   53,
      68,   43,   58,       74,   27,   65,       82,   10,   72,       90,   -7,   79,
       4,   25,  -39,       12,    4,  -25,       24,  -18,   -6,       36,  -33,   11,
      47,  -46,   26,       58,  -57,   39,       69,  -66,   51,       79,  -76,   62,
       4,   26,  -38,       12,    5,  -24,       24,  -17,   -6,       36,  -32,   11,
      48,  -45,   26,       58,  -56,   39,       69,  -66,   51,       79,  -76,   62,
       5,   28,  -37,       13,    7,  -24,       25,  -15,   -5,       36,  -31,   11,
      48,  -45,   26,       58,  -56,   40,       69,  -66,   51,       79,  -75,   63,
       5,   30,  -36,       13,    9,  -23,       25,  -14,   -5,       36,  -30,   11,
      48,  -44,   27,       58,  -55,   40,       69,  -65,   51,       79,  -75,   63,
       6,   32,  -34,       14,   11,  -21,       25,  -11,   -4,       36,  -28,   12,
      48,  -42,   27,       59,  -54,   40,       69,  -64,   52,       79,  -74,   63,
       8,   33,  -32,       15,   14,  -20,       26,   -9,   -4,       37,  -26,   12,
      48,  -41,   27,       59,  -53,   40,       69,  -64,   52,       80,  -74,   63,
       9,   34,  -29,       16,   16,  -19,       26,   -6,   -3,       37,  -24,   13,
      48,  -39,   27,       59,  -51,   40,       69,  -62,   52,       80,  -73,   63,
      11,   36,  -26,       17,   19,  -17,       27,   -3,   -2,       38,  -21,   13,
      49,  -37,   28,       59,  -50,   41,       69,  -61,   52,       80,  -72,   63,
      13,   37,  -23,       18,   22,  -15,       28,    1,    0,       38,  -18,   14,
      49,  -35,   28,       59,  -48,   41,       70,  -59,   52,       80,  -70,   63,
      15,   39,  -20,       20,   25,  -13,       28,    4,    1,       39,  -15,   15,
      49,  -32,   29,       60,  -46,   41,       70,  -58,   53,       80,  -69,   64,
      16,   41,  -17,       21,   28,  -10,       29,    8,    2,       39,  -12,   16,
      50,  -29,   29,       60,  -43,   42,       70,  -56,   53,       80,  -67,   64,
      18,   42,  -14,       22,   31,   -8,       30,   11,    4,       40,   -9,   17,
      50,  -26,   30,       60,  -41,   42,       70,  -54,   53,       80,  -66,   64,
      20,   44,  -11,       24,   34,   -5,       31,   15,    5,       41,   -5,   18,
      51,  -23,   31,       61,  -38,   43,       71,  -51,   54,       81,  -63,   64,
      22,   46,   -8,       25,   37,   -3,       32,   18,    7,       41,   -1,   19,
      51,  -19,   32,       61,  -35,   43,       71,  -49,   54,       81,  -61,   65,
      24,   48,   -5,       27,   39,   -1,       34,   22,    9,       42,    3,   20,
      52,  -16,   33,       62,  -32,   44,       71,  -46,   55,       81,  -59,   65,
      26,   50,   -3,       28,   42,    2,       35,   25,   11,       43,    6,   22,
      52,  -13,   34,       62,  -29,   45,       72,  -44,   55,       82,  -57,   66,
      28,   52,    1,       30,   44,    4,       36,   29,   13,       44,   10,   23,
      53,   -9,   35,       63,  -25,   46,       72,  -40,   56,       82,  -54,   66,
      29,   54,    3,       32,   47,    7,       37,   32,   15,       45,   14,   25,
      54,   -5,   36,       63,  -22,   46,       73,  -37,   57,       82,  -51,   67,
      31,   56,    6,       33,   49,    9,       39,   35,   17,       46,   17,   26,
      55,   -2,   37,       64,  -19,   47,       73,  -34,   57,       83,  -49,   67,
      33,   58,    9,       35,   52,   12,       40,   38,   19,       47,   21,   28,
      56,    2,   38,       64,  -15,   48,       74,  -31,   58,       83,  -46,   68,
      35,   60,   12,       37,   54,   15,       41,   41,   21,       48,   25,   29,
      56,    6,   39,       65,  -12,   49,       74,  -28,   59,       84,  -43,   68,
      37,   62,   14,       38,   57,   17,       43,   44,   23,       49,   28,   31,
      57,    9,   40,       66,   -8,   50,       75,  -24,   59,       84,  -40,   69,
      38,   64,   17,       40,   59,   19,       44,   47,   25,       50,   31,   33,
      58,   13,   42,       67,   -5,   51,       75,  -21,   60,       85,  -37,   70,
      40,   66,   20,       42,   61,   22,       46,   50,   27,       52,   34,   34,
      59,   16,   43,       67,   -1,   52,       76,  -18,   61,       85,  -34,   70,
      42,   68,   22,       43,   63,   24,       47,   52,   29,       53,   38,   36,
      60,   20,   44,       68,    2,   53,       77,  -14,   62,       86,  -30,   71,
      44,   70,   25,       45,   66,   27,       49,   55,   31,       54,   41,   38,
      61,   24,   46,       69,    6,   54,       77,  -11,   63,       86,  -27,   72,
      45,   72,   27,       47,   68,   29,       50,   58,   33,       55,   44,   40,
      62,   27,   47,       70,   10,   55,       78,   -7,   64,       87,  -24,   73,
      47,   74,   30,       48,   70,   32,       52,   60,   35,       57,   47,   41,
      63,   30,   49,       71,   13,   57,       79,   -4,   65,       87,  -20,   73,
      49,   75,   32,       50,   72,   34,       53,   63,   37,       58,   50,   43,
      64,   33,   50,       72,   17,   58,       79,    0,   66,       88,  -17,   74,
      50,   78,   35,       52,   74,   36,       55,   66,   40,       59,   53,   45,
      66,   37,   52,       73,   20,   59,       80,    3,   67,       89,  -13,   75,
      52,   79,   37,       53,   76,   39,       56,   68,   42,       61,   56,   47,
      67,   40,   53,       74,   24,   60,       81,    7,   68,       89,  -10,   76,
      54,   81,   40,       55,   78,   41,       57,   70,   44,       62,   59,   49,
      68,   43,   55,       75,   27,   62,       82,   10,   69,       90,   -7,   77,
       4,   29,  -43,       13,    8,  -29,       25,  -15,  -11,       36,  -31,    6,
      48,  -44,   22,       58,  -55,   36,       69,  -66,   48,       79,  -75,   59,
       5,   30,  -42,       13,    9,  -29,       25,  -14,  -10,       36,  -30,    6,
      48,  -44,   22,       58,  -55,   36,       69,  -65,   48,       79,  -75,   60,
       5,   31,  -41,       13,   10,  -28,       25,  -13,  -10,       36,  -29,    7,
      48,  -43,   22,       58,  -55,   36,       69,  -65,   48,       79,  -75,   60,
       6,   33,  -40,       14,   12,  -27,       25,  -11,  -10,       36,  -28,    7,
      48,  -42,   22,       59,  -54,   36,       69,  -64,   48,       79,  -74,   60,
       7,   34,  -38,       15,   14,  -26,       26,   -9,   -9,       37,  -26,    7,
      48,  -41,   23,       59,  -53,   36,       69,  -64,   48,       79,  -74,   60,
       9,   35,  -36,       15,   16,  -25,       26,   -7,   -8,       37,  -25,    8,
      48,  -40,   23,       59,  -52,   36,       69,  -63,   48,       80,  -73,   60,
      10,   36,  -33,       16,   19,  -23,       27,   -4,   -8,       37,  -22,    8,
      48,  -38,   23,       59,  -50,   36,       69,  -62,   49,       80,  -72,   60,
      12,   37,  -30,       18,   22,  -21,       27,   -1,   -6,       38,  -20,    9,
      49,  -36,   24,       59,  -49,   37,       69,  -60,   49,       80,  -71,   60,
      14,   39,  -28,       19,   24,  -19,       28,    3,   -5,       38,  -17,   10,
      49,  -33,   24,       59,  -47,   37,       70,  -59,   49,       80,  -70,   60,
      15,   40,  -25,       20,   27,  -17,       29,    6,   -4,       39,  -14,   10,
      49,  -31,   25,       60,  -45,   38,       70,  -57,   49,       80,  -68,   61,
      17,   42,  -22,       21,   29,  -15,       30,    9,   -3,       39,  -11,   11,
      50,  -28,   25,       60,  -42,   38,       70,  -55,   50,       80,  -67,   61,
      19,   43,  -19,       23,   32,  -13,       31,   12,   -1,       40,   -7,   12,
      50,  -25,   26,       60,  -40,   38,       70,  -53,   50,       81,  -65,   61,
      21,   45,  -16,       24,   35,  -10,       32,   16,    1,       41,   -3,   13,
      51,  -22,   27,       61,  -37,   39,       71,  -50,   51,       81,  -63,   62,
      22,   47,  -13,       26,   38,   -8,       33,   20,    2,       41,    0,   15,
      51,  -18,   28,       61,  -34,   40,       71,  -48,   51,       81,  -61,   62,
      24,   49,  -10,       27,   40,   -6,       34,   23,    4,       42,    4,   16,
      52,  -15,   28,       62,  -31,   40,       71,  -45,   51,       81,  -59,   62,
      26,   51,   -7,       29,   43,   -3,       35,   26,    6,       43,    7,   17,
      53,  -12,   29,       62,  -28,   41,       72,  -43,   52,       82,  -56,   63,
      28,   53,   -4,       30,   45,    0,       36,   30,    8,       44,   11,   19,
      53,   -8,   31,       63,  -25,   42,       72,  -40,   53,       82,  -53,   63,
      30,   55,   -2,       32,   48,    2,       38,   33,   10,       45,   15,   20,
      54,   -4,   32,       63,  -21,   43,       73,  -37,   53,       82,  -51,   64,
      31,   57,    1,       34,   50,    4,       39,   36,   12,       46,   18,   22,
      55,   -1,   33,       64,  -18,   43,       73,  -34,   54,       83,  -48,   64,
      33,   58,    4,       35,   52,    7,       40,   39,   14,       47,   21,   23,
      56,    3,   34,       64,  -15,   44,       74,  -31,   55,       83,  -45,   65,
      35,   61,    7,       37,   55,   10,       42,   42,   16,       48,   25,   25,
      57,    7,   35,       65,  -11,   45,       74,  -27,   55,       84,  -42,   65,
      37,   62,   10,       39,   57,   12,       43,   45,   18,       49,   28,   26,
      57,   10,   36,       66,   -7,   46,       75,  -24,   56,       84,  -39,   66,
      38,   64,   12,       40,   59,   15,       44,   48,   20,       51,   32,   28,
      58,   13,   38,       67,   -4,   47,       75,  -21,   57,       85,  -36,   67,
      40,   66,   15,       42,   61,   17,       46,   50,   22,       52,   35,   30,
      59,   17,   39,       67,   -1,   48,       76,  -17,   58,       85,  -33,   67,
      42,   68,   17,       43,   64,   19,       47,   53,   24,       53,   38,   32,
      60,   20,   40,       68,    3,   50,       77,  -14,   59,       86,  -30,   68,
      44,   70,   20,       45,   66,   22,       49,   56,   27,       54,   41,   34,
      61,   24,   42,       69,    7,   51,       77,  -10,   60,       86,  -26,   69,
      45,   72,   23,       47,   68,   24,       50,   58,   29,       55,   44,   35,
      62,   27,   43,       70,   10,   52,       78,   -7,   61,       87,  -23,   70,
      47,   74,   25,       48,   70,   27,       52,   61,   31,       57,   47,   37,
      63,   31,   45,       71,   14,   53,       79,   -3,   62,       87,  -20,   71,
      49,   76,   28,       50,   72,   29,       53,   63,   33,       58,   50,   39,
      64,   34,   46,       72,   17,   54,       80,    0,   63,       88,  -17,   71,
      51,   78,   30,       52,   74,   32,       55,   66,   35,       59,   53,   41,
      66,   37,   48,       73,   21,   56,       80,    4,   64,       89,  -13,   72,
      52,   80,   33,       53,   76,   34,       56,   68,   37,       61,   56,   43,
      67,   41,   50,       74,   24,   57,       81,    7,   65,       89,  -10,   73,
      54,   82,   35,       55,   78,   36,       58,   71,   40,       62,   59,   45,
      68,   44,   51,       75,   27,   58,       82,   11,   66,       90,   -6,   74,
       6,   33,  -47,       13,   12,  -34,       25,  -11,  -15,       36,  -29,    2,
      48,  -43,   18,       58,  -54,   32,       69,  -65,   44,       79,  -74,   56,
       6,   34,  -46,       14,   13,  -33,       25,  -11,  -15,       36,  -28,    2,
      48,  -42,   18,       59,  -54,   32,       69,  -64,   44,       79,  -74,   56,
       6,   35,  -45,       14,   14,  -33,       25,  -10,  -15,       36,  -27,    2,
      48,  -41,   18,       59,  -53,   32,       69,  -64,   44,       79,  -74,   56,
       7,   36,  -44,       15,   15,  -32,       26,   -8,  -14,       37,  -26,    2,
      48,  -40,   18,       59,  -53,   32,       69,  -63,   45,       79,  -73,   57,
       8,   36,  -42,       15,   17,  -31,       26,   -6,  -14,       37,  -24,    3,
      48,  -39,   18,       59,  -52,   32,       69,  -63,   45,       80,  -73,   57,
      10,   37,  -40,       16,   19,  -29,       26,   -4,  -13,       37,  -23,    3,
      48,  -38,   19,       59,  -51,   32,       69,  -62,   45,       80,  -72,   57,
      11,   38,  -37,       17,   21,  -28,       27,   -1,  -12,       38,  -20,    4,
      49,  -36,   19,       59,  -49,   33,       69,  -61,   45,       80,  -71,   57,
      13,   39,  -35,       18,   24,  -26,       28,    2,  -11,       38,  -18,    4,
      49,  -34,   19,       59,  -47,   33,       70,  -59,   45,       80,  -70,   57,
      14,   40,  -32,       19,   26,  -24,       28,    5,  -10,       38,  -15,    5,
      49,  -32,   20,       60,  -46,   33,       70,  -58,   46,       80,  -69,   57,
      16,   42,  -29,       20,   29,  -22,       29,    8,   -9,       39,  -12,    6,
      50,  -29,   20,       60,  -44,   34,       70,  -56,   46,       80,  -67,   57,
      17,   43,  -27,       22,   31,  -20,       30,   11,   -7,       40,   -9,    7,
      50,  -27,   21,       60,  -41,   34,       70,  -54,   46,       80,  -66,   58,
      19,   45,  -24,       23,   34,  -18,       31,   14,   -6,       40,   -6,    8,
      50,  -24,   22,       60,  -39,   35,       70,  -52,   47,       81,  -64,   58,
      21,   46,  -21,       25,   36,  -15,       32,   18,   -4,       41,   -2,    9,
      51,  -20,   23,       61,  -36,   35,       71,  -50,   47,       81,  -62,   58,
      23,   48,  -18,       26,   39,  -13,       33,   21,   -3,       42,    1,   10,
      51,  -17,   23,       61,  -33,   36,       71,  -47,   47,       81,  -60,   59,
      24,   50,  -15,       28,   41,  -10,       34,   24,   -1,       42,    5,   11,
      52,  -14,   24,       62,  -30,   36,       71,  -45,   48,       81,  -58,   59,
      26,   52,  -12,       29,   44,   -8,       35,   27,    1,       43,    8,   13,
      53,  -11,   25,       62,  -27,   37,       72,  -42,   49,       82,  -56,   60,
      28,   54,   -9,       31,   46,   -5,       37,   31,    3,       44,   12,   14,
      53,   -7,   26,       63,  -24,   38,       72,  -39,   49,       82,  -53,   60,
      30,   55,   -6,       32,   48,   -3,       38,   34,    5,       45,   15,   16,
      54,   -4,   27,       63,  -21,   39,       73,  -36,   50,       82,  -50,   61,
      32,   57,   -4,       34,   51,    0,       39,   37,    7,       46,   19,   17,
      55,    0,   28,       64,  -17,   40,       73,  -33,   50,       83,  -48,   61,
      33,   59,   -1,       35,   53,    2,       40,   40,    9,       47,   22,   19,
      56,    3,   30,       65,  -14,   41,       74,  -30,   51,       83,  -45,   62,
      35,   61,    2,       37,   55,    5,       42,   43,   11,       48,   26,   20,
      57,    7,   31,       65,  -10,   42,       74,  -26,   52,       84,  -42,   62,
      37,   63,    5,       39,   58,    7,       43,   46,   13,       50,   29,   22,
      58,   11,   32,       66,   -7,   43,       75,  -23,   53,       84,  -39,   63,
      39,   65,    7,       40,   60,   10,       45,   48,   16,       51,   32,   24,
      58,   14,   34,       67,   -3,   44,       75,  -20,   54,       85,  -36,   64,
      40,   67,   10,       42,   62,   12,       46,   51,   18,       52,   36,   25,
      59,   18,   35,       67,    0,   45,       76,  -17,   54,       85,  -33,   64,
      42,   69,   13,       44,   64,   15,       47,   53,   20,       53,   39,   27,
      60,   21,   36,       68,    3,   46,       77,  -13,   55,       86,  -29,   65,
      44,   71,   15,       45,   66,   17,       49,   56,   22,       54,   42,   29,
      61,   25,   38,       69,    7,   47,       77,  -10,   56,       86,  -26,   66,
      46,   72,   18,       47,   68,   20,       50,   59,   24,       56,   45,   31,
      62,   28,   39,       70,   11,   48,       78,   -6,   57,       87,  -23,   67,
      47,   74,   20,       48,   71,   22,       52,   61,   26,       57,   48,   33,
      63,   31,   41,       71,   14,   49,       79,   -3,   58,       88,  -19,   68,
      49,   76,   23,       50,   73,   25,       53,   64,   29,       58,   51,   35,
      64,   34,   42,       72,   17,   51,       80,    1,   59,       88,  -16,   68,
      51,   78,   26,       52,   75,   27,       55,   66,   31,       59,   54,   37,
      66,   38,   44,       73,   21,   52,       80,    4,   61,       89,  -12,   69,
      52,   80,   28,       53,   77,   29,       56,   69,   33,       61,   57,   38,
      67,   41,   46,       74,   24,   53,       81,    8,   62,       90,   -9,   70,
      54,   82,   30,       55,   79,   32,       58,   71,   35,       62,   59,   40,
      68,   44,   47,       75,   28,   55,       82,   11,   63,       90,   -6,   71,
       7,   37,  -50,       14,   16,  -38,       25,   -8,  -20,       37,  -26,   -3,
      48,  -41,   13,       59,  -53,   28,       69,  -63,   41,       79,  -74,   53,
       7,   37,  -50,       15,   16,  -37,       25,   -7,  -20,       37,  -25,   -3,
      48,  -40,   13,       59,  -52,   28,       69,  -63,   41,       79,  -73,   53,
       8,   37,  -49,       15,   17,  -37,       26,   -6,  -19,       37,  -25,   -3,
      48,  -40,   13,       59,  -52,   28,       69,  -63,   41,       79,  -73,   53,
       9,   38,  -47,       15,   19,  -36,       26,   -5,  -19,       37,  -23,   -2,
      48,  -39,   14,       59,  -51,   28,       69,  -62,   41,       80,  -72,   53,
       9,   38,  -46,       16,   20,  -35,       26,   -3,  -18,       37,  -22,   -2,
      48,  -38,   14,       59,  -50,   28,       69,  -61,   41,       80,  -72,   53,
      11,   39,  -44,       17,   22,  -34,       27,   -1,  -18,       37,  -20,   -2,
      48,  -36,   14,       59,  -49,   28,       69,  -61,   41,       80,  -71,   53,
      12,   40,  -41,       18,   24,  -32,       27,    1,  -17,       38,  -18,   -1,
      49,  -35,   15,       59,  -48,   28,       69,  -59,   41,       80,  -70,   54,
      13,   41,  -39,       19,   26,  -30,       28,    4,  -16,       38,  -16,    0,
      49,  -32,   15,       59,  -46,   29,       70,  -58,   42,       80,  -69,   54,
      15,   42,  -36,       20,   28,  -29,       29,    7,  -15,       39,  -13,    0,
      49,  -30,   15,       60,  -44,   29,       70,  -57,   42,       80,  -68,   54,
      16,   43,  -34,       21,   30,  -27,       29,   10,  -13,       39,  -10,    1,
      50,  -28,   16,       60,  -42,   30,       70,  -55,   42,       80,  -67,   54,
      18,   45,  -31,       22,   33,  -25,       30,   13,  -12,       40,   -7,    2,
      50,  -25,   17,       60,  -40,   30,       70,  -53,   42,       80,  -65,   54,
      20,   46,  -28,       23,   35,  -22,       31,   16,  -11,       40,   -4,    3,
      51,  -22,   17,       61,  -38,   31,       71,  -51,   43,       81,  -63,   55,
      22,   48,  -25,       25,   38,  -20,       32,   19,   -9,       41,   -1,    4,
      51,  -19,   18,       61,  -35,   31,       71,  -49,   43,       81,  -61,   55,
      23,   49,  -23,       26,   40,  -18,       33,   22,   -7,       42,    3,    5,
      52,  -16,   19,       61,  -32,   32,       71,  -46,   44,       81,  -59,   55,
      25,   51,  -20,       28,   42,  -15,       34,   25,   -5,       43,    6,    7,
      52,  -13,   20,       62,  -29,   32,       72,  -44,   44,       81,  -57,   56,
      27,   53,  -17,       29,   45,  -13,       35,   28,   -4,       44,    9,    8,
      53,  -10,   21,       62,  -26,   33,       72,  -41,   45,       82,  -55,   56,
      28,   55,  -14,       31,   47,  -10,       37,   32,   -2,       45,   13,   10,
      54,   -6,   22,       63,  -23,   34,       72,  -38,   46,       82,  -52,   57,
      30,   56,  -11,       33,   49,   -8,       38,   35,    0,       45,   17,   11,
      54,   -3,   23,       63,  -20,   35,       73,  -35,   46,       83,  -50,   57,
      32,   58,   -9,       34,   52,   -5,       39,   38,    2,       46,   20,   13,
      55,    1,   24,       64,  -16,   36,       73,  -32,   47,       83,  -47,   58,
      34,   60,   -6,       36,   54,   -3,       41,   40,    4,       47,   23,   14,
      56,    4,   25,       65,  -13,   37,       74,  -29,   48,       83,  -44,   58,
      35,   62,   -3,       37,   56,    0,       42,   44,    7,       49,   27,   16,
      57,    8,   27,       65,   -9,   38,       74,  -26,   48,       84,  -41,   59,
      37,   64,    0,       39,   58,    3,       43,   46,    9,       50,   30,   18,
      58,   12,   28,       66,   -6,   39,       75,  -23,   49,       84,  -38,   60,
      39,   65,    3,       41,   60,    5,       45,   49,   11,       51,   33,   19,
      59,   15,   29,       67,   -3,   40,       76,  -19,   50,       85,  -35,   60,
      41,   67,    5,       42,   63,    7,       46,   52,   13,       52,   36,   21,
      59,   18,   31,       68,    1,   41,       76,  -16,   51,       85,  -32,   61,
      42,   69,    8,       44,   65,   10,       47,   54,   15,       53,   39,   23,
      60,   22,   32,       68,    4,   42,       77,  -13,   52,       86,  -29,   62,
      44,   71,   11,       45,   67,   13,       49,   57,   18,       54,   43,   25,
      62,   25,   34,       69,    8,   43,       78,   -9,   53,       86,  -25,   63,
      46,   73,   13,       47,   69,   15,       50,   59,   20,       56,   46,   27,
      63,   29,   35,       70,   11,   44,       78,   -6,   54,       87,  -22,   64,
      47,   75,   16,       49,   71,   17,       52,   62,   22,       57,   48,   28,
      64,   32,   37,       71,   15,   46,       79,   -2,   55,       88,  -19,   64,
      49,   77,   18,       50,   73,   20,       53,   64,   24,       58,   51,   30,
      65,   35,   38,       72,   18,   47,       80,    1,   56,       88,  -16,   65,
      51,   79,   21,       52,   75,   23,       55,   67,   26,       60,   54,   32,
      66,   38,   40,       73,   22,   48,       81,    5,   57,       89,  -12,   66,
      52,   80,   23,       54,   77,   25,       56,   69,   29,       61,   57,   34,
      67,   41,   42,       74,   25,   50,       81,    8,   58,       90,   -9,   67,
      54,   82,   26,       55,   79,   27,       58,   71,   31,       62,   60,   36,
      68,   44,   43,       75,   28,   51,       82,   11,   59,       90,   -5,   68,
       8,   40,  -54,       15,   20,  -42,       26,   -4,  -25,       37,  -23,   -8,
      48,  -38,    8,       59,  -51,   23,       69,  -62,   36,       80,  -72,   49,
       9,   40,  -53,       15,   20,  -42,       26,   -3,  -25,       37,  -22,   -8,
      48,  -38,    8,       59,  -51,   23,       69,  -62,   36,       80,  -72,   49,
       9,   40,  -52,       16,   21,  -41,       26,   -3,  -25,       37,  -22,   -8,
      48,  -37,    9,       59,  -50,   23,       69,  -61,   36,       80,  -72,   49,
      10,   40,  -51,       16,   22,  -40,       26,   -1,  -24,       37,  -21,   -7,
      48,  -36,    9,       59,  -49,   23,       69,  -61,   37,       80,  -71,   49,
      11,   41,  -49,       17,   23,  -40,       27,    0,  -24,       37,  -19,   -7,
      48,  -35,    9,       59,  -49,   23,       69,  -60,   37,       80,  -71,   49,
      12,   41,  -48,       17,   25,  -38,       27,    2,  -23,       38,  -18,   -7,
      49,  -34,    9,       59,  -47,   24,       69,  -59,   37,       80,  -70,   49,
      13,   42,  -46,       18,   27,  -37,       28,    4,  -22,       38,  -16,   -6,
      49,  -32,   10,       59,  -46,   24,       70,  -58,   37,       80,  -69,   50,
      14,   43,  -43,       19,   29,  -35,       28,    7,  -21,       38,  -13,   -5,
      49,  -30,   10,       60,  -44,   24,       70,  -57,   37,       80,  -68,   50,
      16,   44,  -41,       20,   31,  -33,       29,    9,  -20,       39,  -11,   -5,
      50,  -28,   11,       60,  -43,   25,       70,  -55,   38,       80,  -67,   50,
      17,   45,  -39,       22,   33,  -32,       30,   12,  -19,       39,   -8,   -4,
      50,  -26,   11,       60,  -41,   25,       70,  -54,   38,       80,  -65,   50,
      19,   46,  -36,       23,   35,  -30,       31,   15,  -17,       40,   -5,   -3,
      50,  -23,   12,       60,  -39,   25,       70,  -52,   38,       81,  -64,   51,
      20,   48,  -33,       24,   37,  -27,       31,   18,  -16,       41,   -2,   -2,
      51,  -21,   12,       61,  -36,   26,       71,  -50,   39,       81,  -62,   51,
      22,   49,  -30,       26,   39,  -25,       33,   21,  -14,       41,    1,   -1,
      51,  -18,   13,       61,  -33,   27,       71,  -47,   39,       81,  -60,   51,
      24,   51,  -28,       27,   42,  -23,       34,   24,  -12,       42,    4,    0,
      52,  -15,   14,       62,  -31,   27,       71,  -45,   40,       81,  -58,   52,
      25,   52,  -25,       28,   44,  -20,       35,   27,  -11,       43,    8,    2,
      52,  -11,   15,       62,  -28,   28,       72,  -43,   40,       82,  -56,   52,
      27,   54,  -22,       30,   46,  -18,       36,   30,   -9,       44,   11,    3,
      53,   -8,   16,       62,  -25,   29,       72,  -40,   41,       82,  -54,   52,
      29,   56,  -19,       31,   48,  -15,       37,   33,   -7,       45,   15,    4,
      54,   -5,   17,       63,  -22,   29,       72,  -37,   41,       82,  -51,   53,
      31,   57,  -17,       33,   50,  -13,       38,   36,   -5,       46,   18,    6,
      54,   -1,   18,       64,  -19,   30,       73,  -34,   42,       83,  -49,   53,
      32,   59,  -14,       34,   53,  -10,       40,   39,   -3,       47,   21,    7,
      55,    2,   19,       64,  -15,   31,       73,  -31,   43,       83,  -46,   54,
      34,   61,  -11,       36,   55,   -8,       41,   41,   -1,       48,   24,    9,
      56,    5,   21,       65,  -12,   32,       74,  -28,   43,       83,  -43,   55,
      36,   63,   -8,       38,   57,   -5,       42,   44,    1,       49,   28,   11,
      57,    9,   22,       66,   -8,   33,       74,  -25,   44,       84,  -40,   55,
      37,   64,   -5,       39,   59,   -3,       44,   47,    4,       50,   31,   12,
      58,   12,   23,       66,   -5,   34,       75,  -22,   45,       84,  -37,   56,
      39,   66,   -3,       41,   61,    0,       45,   50,    6,       51,   34,   14,
      59,   16,   25,       67,   -2,   35,       76,  -18,   46,       85,  -34,   57,
      41,   68,    0,       42,   63,    2,       46,   52,    8,       52,   37,   16,
      60,   19,   26,       68,    2,   36,       76,  -15,   47,       85,  -31,   57,
      42,   70,    2,       44,   65,    5,       48,   55,   10,       53,   40,   18,
      61,   22,   27,       68,    5,   37,       77,  -12,   48,       86,  -28,   58,
      44,   72,    5,       46,   68,    7,       49,   58,   12,       55,   43,   20,
      62,   26,   29,       69,    9,   39,       78,   -8,   49,       86,  -25,   59,
      46,   74,    8,       47,   70,   10,       51,   60,   15,       56,   46,   22,
      63,   29,   30,       70,   12,   40,       78,   -5,   50,       87,  -21,   60,
      48,   75,   10,       49,   72,   12,       52,   62,   17,       57,   49,   23,
      64,   32,   32,       71,   15,   41,       79,   -2,   51,       88,  -18,   61,
      49,   77,   13,       50,   74,   15,       53,   65,   19,       58,   52,   25,
      65,   36,   34,       72,   19,   42,       80,    2,   52,       88,  -15,   61,
      51,   79,   16,       52,   76,   17,       55,   67,   21,       60,   55,   27,
      66,   39,   35,       73,   22,   44,       81,    5,   53,       89,  -11,   62,
      53,   81,   18,       54,   78,   20,       57,   70,   23,       61,   58,   29,
      67,   42,   37,       74,   26,   45,       81,    9,   54,       90,   -8,   63,
      54,   83,   21,       55,   80,   22,       58,   72,   26,       62,   60,   31,
      68,   45,   39,       75,   29,   47,       82,   12,   55,       90,   -5,   64,
       9,   42,  -57,       16,   23,  -46,       26,   -1,  -29,       37,  -20,  -13,
      48,  -36,    4,       59,  -49,   19,       69,  -61,   32,       80,  -71,   46,
      10,   42,  -56,       16,   24,  -46,       26,    0,  -29,       37,  -20,  -12,
      48,  -36,    4,       59,  -49,   19,       69,  -60,   33,       80,  -71,   46,
      10,   42,  -55,       17,   24,  -45,       27,    1,  -29,       37,  -19,  -12,
      48,  -35,    4,       59,  -48,   19,       69,  -60,   33,       80,  -71,   46,
      11,   42,  -54,       17,   25,  -44,       27,    2,  -29,       38,  -18,  -12,
      49,  -34,    4,       59,  -48,   19,       69,  -59,   33,       80,  -70,   46,
      12,   43,  -53,       18,   26,  -44,       27,    3,  -28,       38,  -17,  -12,
      49,  -33,    5,       59,  -47,   19,       69,  -59,   33,       80,  -70,   46,
      13,   43,  -51,       18,   28,  -42,       28,    5,  -27,       38,  -15,  -11,
      49,  -32,    5,       59,  -46,   19,       70,  -58,   33,       80,  -69,   46,
      14,   44,  -49,       19,   29,  -41,       28,    7,  -26,       38,  -13,  -11,
      49,  -30,    5,       59,  -45,   20,       70,  -57,   33,       80,  -68,   46,
      15,   45,  -47,       20,   31,  -39,       29,    9,  -25,       39,  -11,  -10,
      49,  -28,    6,       60,  -43,   20,       70,  -55,   33,       80,  -67,   46,
      17,   46,  -45,       21,   33,  -38,       29,   12,  -24,       39,   -9,   -9,
      50,  -26,    6,       60,  -41,   20,       70,  -54,   34,       80,  -66,   46,
      18,   47,  -43,       22,   35,  -36,       30,   14,  -23,       40,   -6,   -8,
      50,  -24,    7,       60,  -39,   21,       70,  -52,   34,       80,  -64,   47,
      19,   48,  -40,       23,   37,  -34,       31,   17,  -22,       40,   -3,   -8,
      50,  -22,    7,       61,  -37,   21,       70,  -51,   34,       81,  -63,   47,
      21,   49,  -38,       25,   39,  -32,       32,   20,  -20,       41,    0,   -7,
      51,  -19,    8,       61,  -35,   22,       71,  -49,   35,       81,  -61,   47,
      23,   50,  -35,       26,   41,  -29,       33,   23,  -19,       42,    3,   -5,
      51,  -16,    9,       61,  -32,   22,       71,  -46,   35,       81,  -59,   48,
      24,   52,  -32,       27,   43,  -27,       34,   26,  -17,       42,    6,   -4,
      52,  -13,   10,       62,  -30,   23,       71,  -44,   36,       81,  -57,   48,
      26,   53,  -29,       29,   45,  -25,       35,   28,  -15,       43,    9,   -3,
      53,  -10,   11,       62,  -27,   24,       72,  -42,   36,       82,  -55,   48,
      27,   55,  -27,       30,   47,  -23,       36,   31,  -13,       44,   12,   -2,
      53,   -7,   12,       63,  -24,   24,       72,  -39,   37,       82,  -53,   49,
      29,   57,  -24,       32,   49,  -20,       37,   34,  -11,       45,   16,    0,
      54,   -3,   13,       63,  -21,   25,       73,  -36,   37,       82,  -50,   49,
      31,   58,  -21,       33,   52,  -18,       39,   37,   -9,       46,   19,    1,
      55,    0,   14,       64,  -18,   26,       73,  -33,   38,       83,  -48,   50,
      33,   60,  -18,       35,   54,  -15,       40,   40,   -7,       47,   22,    3,
      55,    3,   15,       64,  -14,   27,       74,  -30,   39,       83,  -45,   50,
      34,   62,  -16,       36,   56,  -13,       41,   42,   -5,       48,   25,    4,
      56,    6,   16,       65,  -11,   28,       74,  -27,   40,       83,  -42,   51,
      36,   63,  -13,       38,   58,  -10,       43,   45,   -3,       49,   29,    6,
      57,   10,   18,       66,   -8,   29,       75,  -24,   40,       84,  -39,   52,
      38,   65,  -10,       40,   60,   -7,       44,   48,   -1,       50,   32,    8,
      58,   13,   19,       66,   -4,   30,       75,  -21,   41,       84,  -36,   52,
      39,   67,   -7,       41,   62,   -5,       45,   51,    1,       51,   35,   10,
      59,   17,   20,       67,   -1,   31,       76,  -18,   42,       85,  -34,   53,
      41,   69,   -5,       43,   64,   -2,       47,   53,    3,       52,   38,   11,
      60,   20,   22,       68,    2,   32,       76,  -14,   43,       85,  -31,   54,
      43,   70,   -2,       44,   66,    0,       48,   56,    5,       53,   41,   13,
      61,   23,   23,       69,    6,   33,       77,  -11,   44,       86,  -27,   55,
      44,   72,    1,       46,   68,    3,       49,   58,    8,       55,   44,   15,
      62,   27,   25,       69,    9,   35,       78,   -8,   45,       87,  -24,   55,
      46,   74,    3,       47,   70,    5,       51,   61,   10,       56,   47,   17,
      63,   30,   26,       70,   13,   36,       78,   -4,   46,       87,  -21,   56,
      48,   76,    6,       49,   72,    8,       52,   63,   12,       57,   50,   19,
      64,   33,   28,       71,   16,   37,       79,   -1,   47,       88,  -18,   57,
      49,   78,    8,       51,   74,   10,       54,   65,   14,       58,   52,   21,
      65,   36,   29,       72,   19,   38,       80,    2,   48,       88,  -14,   58,
      51,   80,   11,       52,   76,   13,       55,   68,   17,       60,   55,   23,
      66,   40,   31,       73,   23,   40,       81,    6,   49,       89,  -11,   59,
      53,   81,   14,       54,   78,   15,       57,   70,   19,       61,   58,   25,
      67,   43,   33,       74,   26,   41,       82,    9,   50,       90,   -8,   60,
      54,   83,   16,       55,   80,   17,       58,   72,   21,       62,   61,   27,
      68,   46,   34,       75,   29,   43,       82,   13,   52,       90,   -4,   61,
      11,   44,  -60,       17,   26,  -50,       27,    3,  -34,       37,  -17,  -17,
      49,  -34,    0,       59,  -47,   15,       69,  -59,   29,       80,  -70,   42,
      11,   44,  -59,       17,   27,  -50,       27,    3,  -34,       38,  -17,  -17,
      49,  -33,    0,       59,  -47,   15,       69,  -59,   29,       80,  -70,   42,
      12,   44,  -59,       17,   27,  -49,       27,    4,  -33,       38,  -16,  -17,
      49,  -33,    0,       59,  -47,   15,       69,  -58,   29,       80,  -69,   42,
      12,   45,  -58,       18,   28,  -48,       27,    5,  -33,       38,  -15,  -16,
      49,  -32,    0,       59,  -46,   15,       69,  -58,   29,       80,  -69,   42,
      13,   45,  -56,       18,   29,  -47,       28,    6,  -32,       38,  -14,  -16,
      49,  -31,    0,       59,  -45,   15,       70,  -57,   29,       80,  -68,   42,
      14,   45,  -55,       19,   30,  -46,       28,    8,  -32,       38,  -12,  -16,
      49,  -30,    0,       59,  -44,   15,       70,  -56,   29,       80,  -68,   42,
      15,   46,  -53,       20,   32,  -45,       29,   10,  -31,       39,  -11,  -15,
      49,  -28,    1,       60,  -43,   15,       70,  -55,   29,       80,  -67,   42,
      16,   47,  -51,       21,   33,  -43,       29,   12,  -30,       39,   -8,  -14,
      50,  -26,    1,       60,  -41,   16,       70,  -54,   29,       80,  -66,   43,
      17,   47,  -49,       22,   35,  -42,       30,   14,  -29,       39,   -6,  -14,
      50,  -24,    2,       60,  -40,   16,       70,  -53,   30,       80,  -65,   43,
      19,   48,  -47,       23,   37,  -40,       31,   17,  -28,       40,   -4,  -13,
      50,  -22,    2,       60,  -38,   17,       70,  -51,   30,       81,  -63,   43,
      20,   49,  -44,       24,   39,  -38,       31,   19,  -26,       41,   -1,  -12,
      51,  -20,    3,       61,  -36,   17,       71,  -49,   30,       81,  -62,   43,
      22,   50,  -42,       25,   40,  -36,       32,   22,  -25,       41,    2,  -11,
      51,  -17,    4,       61,  -33,   18,       71,  -47,   31,       81,  -60,   44,
      23,   52,  -39,       27,   43,  -34,       33,   25,  -23,       42,    5,  -10,
      52,  -14,    5,       61,  -31,   18,       71,  -45,   31,       81,  -58,   44,
      25,   53,  -36,       28,   45,  -32,       34,   27,  -21,       43,    8,   -9,
      52,  -12,    5,       62,  -28,   19,       72,  -43,   32,       81,  -56,   44,
      26,   55,  -34,       29,   46,  -29,       35,   30,  -20,       43,   11,   -7,
      53,   -9,    6,       62,  -25,   20,       72,  -40,   32,       82,  -54,   45,
      28,   56,  -31,       31,   48,  -27,       36,   33,  -18,       44,   14,   -6,
      53,   -6,    7,       63,  -23,   20,       72,  -38,   33,       82,  -52,   45,
      30,   58,  -28,       32,   51,  -24,       38,   36,  -16,       45,   17,   -5,
      54,   -2,    8,       63,  -19,   21,       73,  -35,   34,       82,  -49,   46,
      31,   59,  -26,       34,   53,  -22,       39,   38,  -14,       46,   20,   -3,
      55,    1,    9,       64,  -16,   22,       73,  -32,   34,       83,  -47,   46,
      33,   61,  -23,       35,   55,  -20,       40,   41,  -12,       47,   23,   -2,
      56,    4,   11,       64,  -13,   23,       74,  -29,   35,       83,  -44,   47,
      35,   62,  -20,       37,   57,  -17,       41,   44,  -10,       48,   26,    0,
      56,    8,   12,       65,  -10,   24,       74,  -26,   36,       84,  -42,   47,
      36,   64,  -17,       38,   59,  -14,       43,   46,   -8,       49,   30,    2,
      57,   11,   13,       66,   -6,   25,       75,  -23,   37,       84,  -38,   48,
      38,   66,  -15,       40,   61,  -12,       44,   49,   -6,       50,   33,    3,
      58,   14,   15,       66,   -3,   26,       75,  -20,   37,       85,  -36,   49,
      40,   68,  -12,       41,   63,  -10,       45,   51,   -4,       51,   36,    5,
      59,   18,   16,       67,    0,   27,       76,  -17,   38,       85,  -33,   50,
      41,   69,   -9,       43,   65,   -7,       47,   54,   -1,       53,   39,    7,
      60,   21,   17,       68,    3,   28,       76,  -14,   39,       86,  -30,   50,
      43,   71,   -7,       44,   67,   -5,       48,   56,    1,       54,   42,    9,
      61,   24,   19,       69,    7,   29,       77,  -10,   40,       86,  -27,   51,
      45,   73,   -4,       46,   69,   -2,       50,   59,    3,       55,   45,   11,
      62,   28,   20,       70,   10,   31,       78,   -7,   41,       87,  -23,   52,
      46,   75,   -1,       48,   71,    1,       51,   61,    5,       56,   48,   13,
      63,   31,   22,       70,   13,   32,       79,   -4,   42,       87,  -20,   53,
      48,   76,    1,       49,   73,    3,       52,   64,    8,       57,   50,   15,
      64,   34,   23,       71,   17,   33,       79,    0,   43,       88,  -17,   54,
      50,   78,    4,       51,   75,    5,       54,   66,   10,       59,   53,   16,
      65,   37,   25,       72,   20,   34,       80,    3,   44,       88,  -14,   54,
      51,   80,    6,       53,   77,    8,       55,   69,   12,       60,   56,   19,
      66,   40,   27,       73,   24,   36,       81,    7,   45,       89,  -10,   55,
      53,   82,    9,       54,   79,   11,       57,   71,   14,       61,   59,   20,
      67,   43,   28,       74,   27,   37,       82,   10,   47,       90,   -7,   56,
      55,   84,   11,       56,   81,   13,       58,   73,   17,       63,   61,   22,
      68,   46,   30,       75,   30,   39,       82,   13,   48,       91,   -4,   57,
      12,   46,  -63,       18,   30,  -54,       27,    6,  -38,       38,  -14,  -21,
      49,  -31,   -5,       59,  -45,   10,       69,  -57,   24,       80,  -69,   38,
      12,   46,  -62,       18,   30,  -53,       27,    7,  -38,       38,  -14,  -21,
      49,  -31,   -5,       59,  -45,   10,       70,  -57,   25,       80,  -68,   38,
      13,   46,  -62,       18,   31,  -53,       28,    7,  -37,       38,  -13,  -21,
      49,  -30,   -5,       59,  -45,   11,       70,  -57,   25,       80,  -68,   38,
      13,   47,  -61,       19,   31,  -52,       28,    8,  -37,       38,  -12,  -21,
      49,  -30,   -4,       59,  -44,   11,       70,  -56,   25,       80,  -68,   38,
      14,   47,  -60,       19,   32,  -51,       28,   10,  -36,       38,  -11,  -20,
      49,  -29,   -4,       60,  -43,   11,       70,  -56,   25,       80,  -67,   38,
      15,   47,  -58,       20,   33,  -50,       29,   11,  -36,       39,  -10,  -20,
      49,  -28,   -4,       60,  -42,   11,       70,  -55,   25,       80,  -66,   38,
      16,   48,  -57,       21,   34,  -49,       29,   13,  -35,       39,   -8,  -20,
      50,  -26,   -4,       60,  -41,   11,       70,  -54,   25,       80,  -66,   39,
      17,   48,  -54,       21,   36,  -47,       30,   15,  -34,       39,   -6,  -19,
      50,  -24,   -3,       60,  -39,   12,       70,  -52,   25,       80,  -65,   39,
      18,   49,  -52,       22,   37,  -46,       30,   17,  -33,       40,   -4,  -18,
      50,  -22,   -3,       60,  -38,   12,       70,  -51,   26,       80,  -63,   39,
      20,   50,  -50,       23,   39,  -44,       31,   19,  -32,       40,   -1,  -17,
      51,  -20,   -2,       61,  -36,   12,       71,  -50,   26,       81,  -62,   39,
      21,   51,  -48,       25,   41,  -42,       32,   21,  -31,       41,    1,  -16,
      51,  -18,   -1,       61,  -34,   13,       71,  -48,   26,       81,  -61,   40,
      22,   52,  -46,       26,   42,  -40,       33,   24,  -29,       41,    4,  -15,
      51,  -16,   -1,       61,  -32,   13,       71,  -46,   27,       81,  -59,   40,
      24,   53,  -43,       27,   44,  -38,       34,   27,  -27,       42,    7,  -14,
      52,  -13,    0,       62,  -29,   14,       71,  -44,   27,       81,  -57,   40,
      25,   55,  -41,       28,   46,  -36,       35,   29,  -26,       43,   10,  -13,
      52,  -10,    1,       62,  -27,   15,       72,  -41,   28,       82,  -55,   41,
      27,   56,  -38,       30,   48,  -34,       36,   32,  -24,       44,   12,  -12,
      53,   -7,    2,       62,  -24,   15,       72,  -39,   28,       82,  -53,   41,
      28,   57,  -35,       31,   50,  -31,       37,   34,  -22,       45,   15,  -11,
      54,   -4,    3,       63,  -21,   16,       72,  -37,   29,       82,  -51,   41,
      30,   59,  -33,       33,   52,  -29,       38,   37,  -20,       45,   19,   -9,
      54,   -1,    4,       63,  -18,   17,       73,  -34,   30,       83,  -48,   42,
      32,   60,  -30,       34,   54,  -26,       39,   40,  -18,       46,   22,   -8,
      55,    3,    5,       64,  -15,   18,       73,  -31,   30,       83,  -46,   43,
      33,   62,  -27,       36,   56,  -24,       40,   42,  -16,       47,   25,   -6,
      56,    6,    6,       65,  -12,   19,       74,  -28,   31,       83,  -43,   43,
      35,   63,  -25,       37,   58,  -22,       42,   45,  -14,       48,   28,   -4,
      57,    9,    7,       65,   -9,   20,       74,  -25,   32,       84,  -41,   44,
      37,   65,  -22,       39,   60,  -19,       43,   48,  -12,       49,   31,   -3,
      57,   12,    9,       66,   -5,   21,       75,  -22,   33,       84,  -38,   44,
      38,   67,  -19,       40,   62,  -16,       44,   50,  -10,       51,   34,   -1,
      58,   16,   10,       67,   -2,   22,       75,  -19,   33,       85,  -35,   45,
      40,   69,  -17,       42,   64,  -14,       46,   52,   -8,       52,   37,    1,
      59,   19,   12,       67,    1,   23,       76,  -16,   34,       85,  -32,   46,
      42,   70,  -14,       43,   66,  -12,       47,   55,   -6,       53,   40,    3,
      60,   22,   13,       68,    4,   24,       77,  -13,   35,       86,  -29,   47,
      43,   72,  -11,       45,   67,   -9,       48,   57,   -4,       54,   43,    4,
      61,   25,   14,       69,    7,   25,       77,  -10,   36,       86,  -26,   47,
      45,   74,   -9,       46,   70,   -6,       50,   60,   -1,       55,   46,    6,
      62,   28,   16,       70,   11,   26,       78,   -6,   37,       87,  -22,   48,
      47,   75,   -6,       48,   72,   -4,       51,   62,    1,       56,   48,    8,
      63,   32,   18,       71,   14,   28,       79,   -3,   38,       87,  -19,   49,
      48,   77,   -3,       49,   73,   -2,       53,   64,    3,       58,   51,   10,
      64,   35,   19,       71,   18,   29,       79,    1,   39,       88,  -16,   50,
      50,   79,   -1,       51,   75,    1,       54,   67,    5,       59,   54,   12,
      65,   38,   21,       72,   21,   30,       80,    4,   40,       89,  -13,   51,
      52,   81,    2,       53,   77,    4,       56,   69,    8,       60,   57,   14,
      66,   41,   23,       73,   24,   32,       81,    7,   42,       89,  -10,   52,
      53,   82,    4,       54,   79,    6,       57,   71,   10,       61,   59,   16,
      67,   44,   24,       74,   27,   33,       82,   11,   43,       90,   -6,   53,
      55,   84,    7,       56,   81,    8,       58,   74,   12,       63,   62,   18,
      69,   47,   26,       75,   31,   35,       83,   14,   44,       91,   -3,   54,
      14,   49,  -66,       19,   33,  -58,       28,   10,  -43,       38,  -11,  -26,
      49,  -29,  -10,       59,  -43,    6,       70,  -56,   20,       80,  -67,   34,
      14,   49,  -66,       19,   34,  -57,       28,   11,  -42,       38,  -10,  -26,
      49,  -28,  -10,       59,  -43,    6,       70,  -55,   20,       80,  -67,   34,
      14,   49,  -65,       19,   34,  -57,       28,   11,  -42,       38,  -10,  -26,
      49,  -28,   -9,       60,  -42,    6,       70,  -55,   20,       80,  -67,   34,
      15,   49,  -64,       20,   35,  -56,       29,   12,  -42,       39,   -9,  -26,
      49,  -27,   -9,       60,  -42,    6,       70,  -54,   20,       80,  -66,   34,
      15,   49,  -63,       20,   35,  -55,       29,   13,  -41,       39,   -8,  -25,
      49,  -26,   -9,       60,  -41,    6,       70,  -54,   20,       80,  -66,   34,
      16,   50,  -62,       21,   36,  -54,       29,   14,  -40,       39,   -6,  -25,
      50,  -25,   -9,       60,  -40,    6,       70,  -53,   20,       80,  -65,   34,
      17,   50,  -60,       21,   37,  -53,       30,   16,  -40,       39,   -5,  -24,
      50,  -23,   -8,       60,  -39,    7,       70,  -52,   21,       80,  -64,   34,
      18,   51,  -58,       22,   39,  -52,       30,   18,  -39,       40,   -3,  -24,
      50,  -22,   -8,       60,  -37,    7,       70,  -51,   21,       80,  -63,   35,
      19,   51,  -57,       23,   40,  -50,       31,   20,  -38,       40,   -1,  -23,
      50,  -20,   -7,       60,  -36,    7,       70,  -49,   21,       81,  -62,   35,
      21,   52,  -54,       24,   41,  -49,       32,   22,  -37,       41,    1,  -22,
      51,  -18,   -7,       61,  -34,    8,       71,  -48,   21,       81,  -61,   35,
      22,   53,  -52,       25,   43,  -47,       32,   24,  -35,       41,    4,  -21,
      51,  -16,   -6,       61,  -32,    8,       71,  -46,   22,       81,  -59,   35,
      23,   54,  -50,       26,   44,  -45,       33,   26,  -34,       42,    6,  -20,
      52,  -13,   -6,       61,  -30,    9,       71,  -44,   22,       81,  -58,   36,
      25,   55,  -47,       28,   46,  -43,       34,   29,  -32,       43,    9,  -19,
      52,  -10,   -5,       62,  -27,    9,       71,  -42,   23,       81,  -56,   36,
      26,   56,  -45,       29,   48,  -41,       35,   31,  -31,       43,   12,  -18,
      53,   -8,   -4,       62,  -25,   10,       72,  -40,   23,       82,  -54,   36,
      28,   57,  -43,       30,   50,  -38,       36,   34,  -29,       44,   14,  -17,
      53,   -5,   -3,       63,  -22,   11,       72,  -38,   24,       82,  -52,   37,
      29,   59,  -40,       32,   51,  -36,       37,   36,  -27,       45,   17,  -15,
      54,   -2,   -2,       63,  -20,   11,       73,  -35,   24,       82,  -50,   37,
      31,   60,  -37,       33,   53,  -34,       38,   39,  -25,       46,   21,  -14,
      55,    1,   -1,       64,  -16,   12,       73,  -32,   25,       83,  -47,   38,
      32,   62,  -35,       35,   55,  -31,       40,   41,  -23,       47,   23,  -12,
      55,    4,    0,       64,  -14,   13,       73,  -30,   26,       83,  -45,   38,
      34,   63,  -32,       36,   57,  -29,       41,   44,  -21,       48,   26,  -11,
      56,    7,    1,       65,  -11,   14,       74,  -27,   26,       83,  -42,   39,
      35,   65,  -30,       37,   59,  -27,       42,   46,  -19,       49,   29,   -9,
      57,   10,    3,       65,   -8,   15,       74,  -24,   27,       84,  -39,   39,
      37,   66,  -27,       39,   61,  -24,       43,   49,  -17,       50,   32,   -8,
      58,   14,    4,       66,   -4,   16,       75,  -21,   28,       84,  -36,   40,
      39,   68,  -24,       41,   63,  -21,       45,   51,  -15,       51,   35,   -6,
      59,   17,    5,       67,   -1,   17,       76,  -18,   29,       85,  -34,   41,
      40,   69,  -22,       42,   65,  -19,       46,   54,  -13,       52,   38,   -4,
      59,   20,    7,       68,    2,   18,       76,  -15,   30,       85,  -31,   42,
      42,   71,  -19,       44,   67,  -17,       47,   56,  -11,       53,   41,   -2,
      60,   23,    8,       68,    5,   19,       77,  -12,   31,       86,  -28,   42,
      44,   73,  -16,       45,   68,  -14,       49,   58,   -9,       54,   44,   -1,
      61,   26,   10,       69,    9,   20,       77,   -8,   32,       86,  -25,   43,
      45,   75,  -14,       47,   71,  -11,       50,   61,   -6,       55,   47,    1,
      62,   30,   11,       70,   12,   22,       78,   -5,   33,       87,  -22,   44,
      47,   76,  -11,       48,   72,   -9,       52,   63,   -4,       57,   49,    3,
      63,   33,   13,       71,   15,   23,       79,   -2,   34,       87,  -18,   45,
      49,   78,   -8,       50,   74,   -7,       53,   65,   -2,       58,   52,    5,
      64,   36,   14,       72,   18,   24,       79,    1,   35,       88,  -15,   46,
      50,   80,   -6,       51,   76,   -4,       54,   67,    0,       59,   55,    7,
      65,   39,   16,       72,   22,   26,       80,    5,   36,       89,  -12,   47,
      52,   81,   -3,       53,   78,   -1,       56,   70,    3,       60,   58,    9,
      67,   42,   18,       73,   25,   27,       81,    8,   37,       89,   -9,   48,
      53,   83,   -1,       55,   80,    1,       57,   72,    5,       62,   60,   11,
      68,   45,   19,       74,   28,   29,       82,   11,   38,       90,   -6,   49,
      55,   85,    2,       56,   82,    3,       59,   74,    7,       63,   63,   13,
      69,   48,   21,       75,   31,   30,       83,   15,   40,       91,   -2,   50,
      15,   51,  -69,       20,   36,  -61,       29,   14,  -47,       39,   -7,  -30,
      49,  -26,  -14,       60,  -41,    1,       70,  -54,   16,       80,  -66,   30,
      15,   51,  -69,       20,   37,  -61,       29,   14,  -46,       39,   -7,  -30,
      49,  -25,  -14,       60,  -40,    1,       70,  -53,   16,       80,  -65,   30,
      16,   51,  -68,       20,   37,  -60,       29,   15,  -46,       39,   -7,  -30,
      49,  -25,  -14,       60,  -40,    2,       70,  -53,   16,       80,  -65,   30,
      16,   51,  -67,       21,   38,  -60,       29,   15,  -46,       39,   -6,  -30,
      50,  -24,  -14,       60,  -39,    2,       70,  -53,   16,       80,  -65,   30,
      17,   51,  -66,       21,   38,  -59,       29,   16,  -45,       39,   -5,  -30,
      50,  -23,  -13,       60,  -39,    2,       70,  -52,   16,       80,  -64,   30,
      17,   52,  -65,       22,   39,  -58,       30,   18,  -45,       39,   -4,  -29,
      50,  -22,  -13,       60,  -38,    2,       70,  -51,   16,       80,  -63,   30,
      18,   52,  -64,       22,   40,  -57,       30,   19,  -44,       40,   -2,  -29,
      50,  -21,  -13,       60,  -37,    2,       70,  -50,   17,       80,  -63,   30,
      19,   53,  -62,       23,   41,  -55,       31,   21,  -43,       40,    0,  -28,
      50,  -19,  -12,       60,  -35,    3,       70,  -49,   17,       81,  -62,   31,
      20,   53,  -60,       24,   42,  -54,       31,   22,  -42,       41,    2,  -27,
      51,  -18,  -12,       61,  -34,    3,       71,  -48,   17,       81,  -60,   31,
      21,   54,  -58,       25,   44,  -52,       32,   24,  -41,       41,    4,  -26,
      51,  -16,  -11,       61,  -32,    3,       71,  -46,   17,       81,  -59,   31,
      23,   55,  -56,       26,   45,  -51,       33,   26,  -39,       42,    6,  -26,
      51,  -13,  -11,       61,  -30,    4,       71,  -45,   18,       81,  -58,   31,
      24,   56,  -54,       27,   46,  -49,       34,   28,  -38,       42,    8,  -25,
      52,  -11,  -10,       62,  -28,    4,       71,  -43,   18,       81,  -56,   32,
      25,   57,  -51,       28,   48,  -47,       35,   31,  -36,       43,   11,  -23,
      52,   -8,   -9,       62,  -25,    5,       72,  -41,   19,       82,  -54,   32,
      27,   58,  -49,       30,   50,  -45,       36,   33,  -35,       44,   14,  -22,
      53,   -6,   -8,       62,  -23,    6,       72,  -38,   19,       82,  -52,   32,
      28,   59,  -47,       31,   51,  -42,       37,   35,  -33,       44,   16,  -21,
      53,   -3,   -7,       63,  -21,    6,       72,  -36,   20,       82,  -50,   33,
      30,   60,  -44,       32,   53,  -40,       38,   38,  -32,       45,   19,  -20,
      54,    0,   -6,       63,  -18,    7,       73,  -34,   20,       82,  -48,   33,
      31,   62,  -41,       34,   55,  -38,       39,   40,  -29,       46,   22,  -18,
      55,    3,   -5,       64,  -15,    8,       73,  -31,   21,       83,  -46,   34,
      33,   63,  -39,       35,   57,  -36,       40,   43,  -28,       47,   25,  -17,
      56,    6,   -4,       64,  -12,    9,       74,  -28,   22,       83,  -43,   34,
      34,   64,  -36,       36,   58,  -33,       41,   45,  -26,       48,   28,  -15,
      56,    9,   -3,       65,   -9,   10,       74,  -26,   22,       84,  -41,   35,
      36,   66,  -34,       38,   60,  -31,       42,   47,  -24,       49,   31,  -14,
      57,   12,   -2,       66,   -6,   11,       75,  -23,   23,       84,  -38,   36,
      38,   67,  -31,       39,   62,  -28,       44,   50,  -21,       50,   34,  -12,
      58,   15,    0,       66,   -3,   12,       75,  -20,   24,       84,  -35,   36,
      39,   69,  -28,       41,   64,  -26,       45,   52,  -19,       51,   36,  -10,
      59,   18,    1,       67,    0,   13,       76,  -17,   25,       85,  -33,   37,
      41,   70,  -26,       42,   66,  -23,       46,   55,  -17,       52,   39,   -9,
      60,   21,    2,       68,    3,   14,       76,  -14,   26,       85,  -30,   38,
      42,   72,  -23,       44,   68,  -21,       48,   57,  -15,       53,   42,   -7,
      60,   24,    4,       68,    6,   15,       77,  -11,   27,       86,  -27,   38,
      44,   74,  -21,       45,   69,  -19,       49,   59,  -13,       54,   45,   -5,
      61,   27,    5,       69,   10,   16,       77,   -7,   28,       86,  -24,   39,
      46,   75,  -18,       47,   71,  -16,       50,   62,  -11,       56,   48,   -3,
      62,   31,    7,       70,   13,   18,       78,   -4,   29,       87,  -21,   40,
      47,   77,  -15,       49,   73,  -13,       52,   64,   -9,       57,   50,   -1,
      63,   34,    9,       71,   16,   19,       79,   -1,   30,       88,  -18,   41,
      49,   79,  -13,       50,   75,  -11,       53,   66,   -6,       58,   53,    1,
      64,   36,   10,       72,   19,   20,       80,    2,   31,       88,  -14,   42,
      50,   80,  -10,       52,   77,   -9,       55,   68,   -4,       59,   56,    3,
      66,   39,   12,       73,   23,   22,       80,    6,   32,       89,  -11,   43,
      52,   82,   -8,       53,   79,   -6,       56,   71,   -2,       61,   58,    5,
      67,   43,   13,       74,   26,   23,       81,    9,   33,       89,   -8,   44,
      54,   84,   -5,       55,   81,   -3,       58,   73,    1,       62,   61,    7,
      68,   46,   15,       75,   29,   24,       82,   12,   34,       90,   -5,   45,
      55,   85,   -3,       56,   82,   -1,       59,   75,    3,       63,   63,    9,
      69,   48,   17,       75,   32,   26,       83,   15,   36,       91,   -2,   46,
      16,   53,  -72,       21,   39,  -64,       29,   17,  -50,       39,   -4,  -35,
      50,  -23,  -18,       60,  -38,   -3,       70,  -52,   12,       80,  -64,   26,
      16,   53,  -71,       21,   40,  -64,       29,   17,  -50,       39,   -4,  -34,
      50,  -23,  -18,       60,  -38,   -3,       70,  -52,   12,       80,  -64,   26,
      17,   53,  -71,       21,   40,  -64,       29,   18,  -50,       39,   -3,  -34,
      50,  -22,  -18,       60,  -38,   -3,       70,  -51,   12,       80,  -63,   26,
      17,   53,  -70,       21,   40,  -63,       30,   19,  -50,       39,   -3,  -34,
      50,  -22,  -18,       60,  -37,   -2,       70,  -51,   12,       80,  -63,   26,
      18,   53,  -69,       22,   41,  -62,       30,   20,  -49,       40,   -2,  -34,
      50,  -21,  -18,       60,  -36,   -2,       70,  -50,   12,       80,  -63,   26,
      18,   54,  -68,       22,   42,  -61,       30,   21,  -48,       40,   -1,  -33,
      50,  -20,  -17,       60,  -36,   -2,       70,  -49,   12,       80,  -62,   26,
      19,   54,  -67,       23,   42,  -60,       31,   22,  -48,       40,    1,  -33,
      50,  -18,  -17,       60,  -34,   -2,       70,  -48,   13,       81,  -61,   27,
      20,   54,  -65,       24,   43,  -59,       31,   23,  -47,       41,    3,  -32,
      51,  -17,  -16,       61,  -33,   -2,       71,  -47,   13,       81,  -60,   27,
      21,   55,  -63,       25,   45,  -58,       32,   25,  -46,       41,    4,  -31,
      51,  -15,  -16,       61,  -32,   -1,       71,  -46,   13,       81,  -59,   27,
      22,   56,  -62,       26,   46,  -56,       33,   27,  -45,       41,    6,  -31,
      51,  -13,  -15,       61,  -30,   -1,       71,  -44,   13,       81,  -58,   27,
      23,   56,  -60,       27,   47,  -54,       33,   29,  -43,       42,    8,  -30,
      52,  -11,  -15,       61,  -28,    0,       71,  -43,   14,       81,  -56,   27,
      25,   57,  -58,       28,   48,  -53,       34,   31,  -42,       43,   11,  -29,
      52,   -9,  -14,       62,  -26,    0,       71,  -41,   14,       81,  -55,   28,
      26,   58,  -55,       29,   50,  -51,       35,   33,  -41,       43,   13,  -28,
      53,   -6,  -13,       62,  -24,    1,       72,  -39,   15,       82,  -53,   28,
      27,   59,  -53,       30,   51,  -49,       36,   35,  -39,       44,   16,  -27,
      53,   -4,  -12,       63,  -21,    2,       72,  -37,   15,       82,  -51,   29,
      29,   60,  -51,       31,   53,  -46,       37,   37,  -37,       45,   18,  -25,
      54,   -1,  -11,       63,  -19,    2,       72,  -35,   16,       82,  -49,   29,
      30,   61,  -48,       33,   55,  -44,       38,   40,  -36,       45,   21,  -24,
      54,    1,  -11,       63,  -16,    3,       73,  -32,   16,       83,  -47,   29,
      32,   63,  -45,       34,   56,  -42,       39,   42,  -34,       46,   24,  -23,
      55,    4,   -9,       64,  -13,    4,       73,  -29,   17,       83,  -44,   30,
      33,   64,  -43,       35,   58,  -40,       40,   44,  -32,       47,   27,  -21,
      56,    7,   -8,       65,  -11,    5,       74,  -27,   18,       83,  -42,   31,
      35,   65,  -41,       37,   60,  -37,       42,   47,  -30,       48,   29,  -20,
      56,   10,   -7,       65,   -8,    6,       74,  -24,   18,       84,  -40,   31,
      36,   67,  -38,       38,   61,  -35,       43,   49,  -28,       49,   32,  -18,
      57,   13,   -6,       66,   -5,    7,       75,  -21,   19,       84,  -37,   32,
      38,   68,  -35,       40,   63,  -32,       44,   51,  -26,       50,   35,  -16,
      58,   16,   -5,       67,   -1,    8,       75,  -18,   20,       85,  -34,   32,
      40,   70,  -33,       41,   65,  -30,       45,   54,  -24,       51,   38,  -15,
      59,   19,   -3,       67,    2,    9,       76,  -15,   21,       85,  -31,   33,
      41,   71,  -30,       43,   67,  -28,       47,   56,  -22,       52,   40,  -13,
      60,   22,   -2,       68,    5,   10,       76,  -12,   22,       85,  -29,   34,
      43,   73,  -28,       44,   69,  -25,       48,   58,  -20,       53,   43,  -11,
      61,   25,    0,       69,    8,   11,       77,   -9,   23,       86,  -26,   35,
      44,   74,  -25,       46,   70,  -23,       49,   60,  -17,       55,   46,   -9,
      62,   28,    1,       69,   11,   12,       78,   -6,   24,       86,  -23,   35,
      46,   76,  -22,       47,   72,  -20,       51,   63,  -15,       56,   49,   -7,
      63,   32,    3,       70,   14,   13,       78,   -3,   25,       87,  -20,   36,
      48,   78,  -20,       49,   74,  -18,       52,   65,  -13,       57,   51,   -5,
      64,   35,    4,       71,   17,   15,       79,    0,   26,       88,  -17,   37,
      49,   79,  -17,       50,   76,  -15,       53,   67,  -11,       58,   54,   -4,
      65,   37,    6,       72,   20,   16,       80,    3,   27,       88,  -14,   38,
      51,   81,  -15,       52,   78,  -13,       55,   69,   -9,       59,   56,   -2,
      66,   40,    7,       73,   23,   17,       80,    6,   28,       89,  -11,   39,
      52,   83,  -12,       54,   80,  -10,       56,   71,   -6,       61,   59,    1,
      67,   44,    9,       74,   27,   19,       81,   10,   29,       90,   -7,   40,
      54,   84,   -9,       55,   81,   -8,       58,   74,   -4,       62,   62,    2,
      68,   46,   11,       75,   30,   20,       82,   13,   30,       90,   -4,   41,
      55,   86,   -7,       57,   83,   -5,       59,   76,   -2,       63,   64,    4,
      69,   49,   13,       76,   33,   22,       83,   16,   32,       91,   -1,   42,
      17,   55,  -75,       22,   42,  -68,       30,   20,  -54,       39,   -1,  -39,
      50,  -20,  -22,       60,  -36,   -7,       70,  -50,    8,       80,  -62,   22,
      18,   55,  -74,       22,   42,  -67,       30,   21,  -54,       40,   -1,  -39,
      50,  -20,  -22,       60,  -36,   -7,       70,  -50,    8,       80,  -62,   22,
      18,   55,  -74,       22,   43,  -67,       30,   21,  -54,       40,    0,  -38,
      50,  -19,  -22,       60,  -35,   -7,       70,  -49,    8,       80,  -62,   22,
      18,   55,  -73,       22,   43,  -66,       30,   22,  -53,       40,    1,  -38,
      50,  -19,  -22,       60,  -35,   -7,       70,  -49,    8,       80,  -61,   22,
      19,   55,  -72,       23,   44,  -66,       31,   23,  -53,       40,    1,  -38,
      50,  -18,  -22,       60,  -34,   -6,       70,  -48,    8,       81,  -61,   22,
      20,   56,  -71,       23,   44,  -65,       31,   24,  -52,       40,    2,  -37,
      50,  -17,  -21,       61,  -33,   -6,       70,  -47,    8,       81,  -60,   22,
      20,   56,  -70,       24,   45,  -64,       31,   25,  -52,       41,    4,  -37,
      51,  -16,  -21,       61,  -32,   -6,       71,  -46,    8,       81,  -59,   23,
      21,   56,  -68,       25,   46,  -63,       32,   26,  -51,       41,    5,  -36,
      51,  -14,  -21,       61,  -31,   -6,       71,  -45,    9,       81,  -58,   23,
      22,   57,  -67,       26,   47,  -61,       33,   28,  -50,       41,    7,  -36,
      51,  -13,  -20,       61,  -29,   -5,       71,  -44,    9,       81,  -57,   23,
      23,   57,  -65,       26,   48,  -60,       33,   29,  -49,       42,    9,  -35,
      52,  -11,  -20,       61,  -28,   -5,       71,  -43,    9,       81,  -56,   23,
      24,   58,  -63,       27,   49,  -58,       34,   31,  -47,       42,   11,  -34,
      52,   -9,  -19,       62,  -26,   -4,       71,  -41,   10,       81,  -55,   24,
      25,   59,  -61,       28,   50,  -56,       35,   33,  -46,       43,   13,  -33,
      52,   -7,  -18,       62,  -24,   -4,       72,  -39,   10,       82,  -53,   24,
      27,   60,  -59,       30,   52,  -54,       36,   35,  -45,       44,   16,  -32,
      53,   -4,  -17,       62,  -22,   -3,       72,  -37,   11,       82,  -51,   24,
      28,   61,  -57,       31,   53,  -52,       37,   37,  -43,       44,   18,  -31,
      53,   -2,  -17,       63,  -19,   -3,       72,  -35,   11,       82,  -50,   25,
      30,   62,  -54,       32,   55,  -50,       38,   39,  -41,       45,   20,  -30,
      54,    1,  -16,       63,  -17,   -2,       73,  -33,   12,       82,  -48,   25,
      31,   63,  -52,       33,   56,  -48,       39,   41,  -40,       46,   23,  -28,
      55,    3,  -15,       64,  -15,   -1,       73,  -31,   12,       83,  -46,   26,
      32,   64,  -49,       35,   58,  -46,       40,   44,  -38,       47,   26,  -27,
      55,    6,  -14,       64,  -12,    0,       73,  -28,   13,       83,  -43,   26,
      34,   65,  -47,       36,   59,  -44,       41,   46,  -36,       48,   28,  -25,
      56,    9,  -13,       65,   -9,    1,       74,  -25,   14,       83,  -41,   27,
      35,   67,  -45,       37,   61,  -41,       42,   48,  -34,       49,   31,  -24,
      57,   12,  -11,       65,   -6,    1,       74,  -23,   14,       84,  -38,   27,
      37,   68,  -42,       39,   63,  -39,       43,   50,  -32,       50,   34,  -22,
      57,   15,  -10,       66,   -3,    2,       75,  -20,   15,       84,  -36,   28,
      39,   70,  -39,       40,   64,  -37,       44,   53,  -30,       51,   37,  -20,
      58,   18,   -9,       67,    0,    3,       75,  -17,   16,       85,  -33,   29,
      40,   71,  -37,       42,   66,  -34,       46,   55,  -28,       52,   39,  -19,
      59,   21,   -7,       67,    3,    5,       76,  -14,   17,       85,  -30,   29,
      42,   72,  -34,       43,   68,  -32,       47,   57,  -26,       53,   42,  -17,
      60,   24,   -6,       68,    6,    6,       77,  -11,   18,       86,  -28,   30,
      43,   74,  -32,       45,   70,  -30,       48,   59,  -24,       54,   44,  -15,
      61,   27,   -5,       69,    9,    7,       77,   -8,   19,       86,  -25,   31,
      45,   75,  -29,       46,   71,  -27,       50,   61,  -22,       55,   47,  -14,
      62,   30,   -3,       70,   12,    8,       78,   -5,   20,       87,  -22,   32,
      46,   77,  -27,       48,   73,  -24,       51,   64,  -19,       56,   50,  -12,
      63,   33,   -2,       70,   15,    9,       79,   -2,   21,       87,  -19,   32,
      48,   79,  -24,       49,   75,  -22,       52,   66,  -17,       57,   52,  -10,
      64,   36,    0,       71,   18,   11,       79,    1,   22,       88,  -16,   33,
      49,   80,  -22,       51,   77,  -20,       54,   68,  -15,       58,   55,   -8,
      65,   38,    2,       72,   21,   12,       80,    4,   23,       88,  -13,   34,
      51,   82,  -19,       52,   78,  -17,       55,   70,  -13,       60,   57,   -6,
      66,   41,    3,       73,   24,   13,       81,    7,   24,       89,  -10,   35,
      53,   84,  -16,       54,   80,  -15,       57,   72,  -10,       61,   60,   -4,
      67,   44,    5,       74,   28,   15,       81,   11,   25,       90,   -6,   36,
      54,   85,  -14,       55,   82,  -12,       58,   74,   -8,       62,   63,   -2,
      68,   47,    7,       75,   31,   16,       82,   14,   26,       90,   -3,   37,
      56,   87,  -11,       57,   84,  -10,       59,   76,   -6,       64,   65,    0,
      69,   50,    8,       76,   34,   18,       83,   17,   28,       91,    0,   38,
      19,   57,  -78,       23,   45,  -71,       31,   24,  -58,       40,    3,  -43,
      50,  -17,  -27,       60,  -33,  -12,       70,  -47,    3,       81,  -60,   18,
      19,   57,  -77,       23,   45,  -71,       31,   25,  -58,       40,    3,  -43,
      50,  -17,  -27,       60,  -33,  -12,       70,  -47,    3,       81,  -60,   18,
      19,   57,  -77,       23,   46,  -71,       31,   25,  -58,       40,    3,  -43,
      50,  -16,  -27,       60,  -33,  -11,       70,  -47,    3,       81,  -60,   18,
      20,   57,  -76,       24,   46,  -70,       31,   25,  -58,       40,    4,  -43,
      51,  -16,  -27,       61,  -32,  -11,       71,  -46,    3,       81,  -59,   18,
      20,   58,  -76,       24,   46,  -69,       31,   26,  -57,       41,    5,  -42,
      51,  -15,  -26,       61,  -31,  -11,       71,  -46,    3,       81,  -59,   18,
      21,   58,  -75,       24,   47,  -69,       32,   27,  -57,       41,    6,  -42,
      51,  -14,  -26,       61,  -31,  -11,       71,  -45,    4,       81,  -58,   18,
      21,   58,  -73,       25,   48,  -68,       32,   28,  -56,       41,    7,  -41,
      51,  -13,  -26,       61,  -30,  -11,       71,  -44,    4,       81,  -58,   18,
      22,   59,  -72,       26,   49,  -66,       33,   29,  -55,       41,    9,  -41,
      51,  -11,  -25,       61,  -28,  -10,       71,  -43,    4,       81,  -57,   18,
      23,   59,  -70,       26,   49,  -65,       33,   31,  -54,       42,   10,  -40,
      52,  -10,  -25,       61,  -27,  -10,       71,  -42,    4,       81,  -55,   19,
      24,   60,  -69,       27,   50,  -64,       34,   32,  -53,       42,   12,  -39,
      52,   -8,  -24,       62,  -25,  -10,       71,  -40,    5,       81,  -54,   19,
      25,   60,  -67,       28,   51,  -62,       35,   34,  -52,       43,   14,  -39,
      52,   -6,  -24,       62,  -24,   -9,       72,  -39,    5,       82,  -53,   19,
      26,   61,  -65,       29,   53,  -61,       35,   36,  -51,       43,   16,  -38,
      53,   -4,  -23,       62,  -22,   -9,       72,  -37,    5,       82,  -51,   19,
      28,   62,  -63,       30,   54,  -59,       36,   38,  -49,       44,   18,  -36,
      53,   -2,  -22,       63,  -19,   -8,       72,  -35,    6,       82,  -50,   20,
      29,   63,  -61,       32,   55,  -57,       37,   40,  -48,       45,   20,  -35,
      54,    1,  -21,       63,  -17,   -7,       73,  -33,    6,       82,  -48,   20,
      30,   64,  -59,       33,   57,  -55,       38,   41,  -46,       46,   23,  -34,
      54,    3,  -20,       64,  -15,   -7,       73,  -31,    7,       83,  -46,   21,
      32,   65,  -56,       34,   58,  -53,       39,   43,  -44,       46,   25,  -33,
      55,    5,  -19,       64,  -12,   -6,       73,  -29,    8,       83,  -44,   21,
      33,   66,  -54,       35,   60,  -50,       40,   46,  -42,       47,   28,  -31,
      56,    8,  -18,       65,  -10,   -5,       74,  -26,    8,       83,  -41,   22,
      35,   67,  -51,       37,   61,  -48,       41,   48,  -41,       48,   30,  -30,
      56,   11,  -17,       65,   -7,   -4,       74,  -24,    9,       84,  -39,   22,
      36,   68,  -49,       38,   63,  -46,       42,   50,  -39,       49,   33,  -29,
      57,   14,  -16,       66,   -4,   -3,       75,  -21,   10,       84,  -37,   23,
      37,   69,  -47,       39,   64,  -44,       44,   52,  -37,       50,   35,  -27,
      58,   17,  -15,       66,   -2,   -2,       75,  -18,   10,       84,  -34,   23,
      39,   71,  -44,       41,   66,  -41,       45,   54,  -35,       51,   38,  -25,
      59,   20,  -13,       67,    2,   -1,       76,  -15,   11,       85,  -32,   24,
      41,   72,  -41,       42,   67,  -39,       46,   56,  -33,       52,   41,  -24,
      59,   22,  -12,       68,    5,    0,       76,  -13,   12,       85,  -29,   25,
      42,   74,  -39,       44,   69,  -37,       47,   58,  -31,       53,   43,  -22,
      60,   25,  -11,       68,    7,    1,       77,  -10,   13,       86,  -26,   26,
      44,   75,  -37,       45,   71,  -34,       49,   60,  -29,       54,   46,  -20,
      61,   28,   -9,       69,   10,    2,       77,   -7,   14,       86,  -23,   26,
      45,   77,  -34,       46,   72,  -32,       50,   63,  -26,       55,   48,  -18,
      62,   31,   -8,       70,   13,    3,       78,   -4,   15,       87,  -21,   27,
      47,   78,  -31,       48,   74,  -29,       51,   65,  -24,       56,   51,  -16,
      63,   34,   -6,       71,   17,    5,       79,    0,   16,       87,  -17,   28,
      48,   80,  -29,       50,   76,  -27,       53,   67,  -22,       58,   54,  -14,
      64,   37,   -5,       71,   20,    6,       79,    3,   17,       88,  -14,   29,
      50,   81,  -26,       51,   78,  -24,       54,   69,  -20,       59,   56,  -13,
      65,   40,   -3,       72,   23,    7,       80,    6,   18,       89,  -11,   30,
      51,   83,  -24,       52,   79,  -22,       55,   71,  -18,       60,   58,  -11,
      66,   42,   -2,       73,   26,    9,       81,    9,   19,       89,   -8,   31,
      53,   84,  -21,       54,   81,  -19,       57,   73,  -15,       61,   61,   -9,
      67,   46,    0,       74,   29,   10,       82,   12,   21,       90,   -5,   32,
      55,   86,  -19,       56,   83,  -17,       58,   75,  -13,       63,   64,   -7,
      68,   48,    2,       75,   32,   12,       82,   15,   22,       91,   -2,   33,
      56,   88,  -16,       57,   85,  -15,       60,   77,  -11,       64,   66,   -5,
      69,   51,    4,       76,   35,   13,       83,   18,   23,       91,    1,   34,
      20,   59,  -81,       24,   48,  -74,       31,   27,  -62,       41,    6,  -47,
      51,  -14,  -31,       61,  -31,  -16,       71,  -45,   -1,       81,  -58,   14,
      20,   59,  -80,       24,   48,  -74,       31,   28,  -62,       41,    6,  -47,
      51,  -14,  -31,       61,  -30,  -16,       71,  -45,   -1,       81,  -58,   14,
      21,   59,  -80,       24,   48,  -74,       32,   28,  -62,       41,    7,  -47,
      51,  -13,  -31,       61,  -30,  -16,       71,  -45,   -1,       81,  -58,   14,
      21,   59,  -79,       25,   49,  -73,       32,   29,  -61,       41,    7,  -47,
      51,  -13,  -31,       61,  -30,  -15,       71,  -44,   -1,       81,  -58,   14,
      21,   60,  -79,       25,   49,  -73,       32,   29,  -61,       41,    8,  -46,
      51,  -12,  -30,       61,  -29,  -15,       71,  -44,   -1,       81,  -57,   14,
      22,   60,  -78,       25,   50,  -72,       32,   30,  -60,       41,    9,  -46,
      51,  -11,  -30,       61,  -28,  -15,       71,  -43,    0,       81,  -56,   14,
      23,   60,  -77,       26,   50,  -71,       33,   31,  -60,       42,   10,  -45,
      51,  -10,  -30,       61,  -27,  -15,       71,  -42,    0,       81,  -56,   14,
      23,   60,  -75,       27,   51,  -70,       33,   32,  -59,       42,   12,  -45,
      52,   -9,  -29,       61,  -26,  -14,       71,  -41,    0,       81,  -55,   14,
      24,   61,  -74,       27,   52,  -69,       34,   34,  -58,       42,   13,  -44,
      52,   -7,  -29,       62,  -25,  -14,       71,  -40,    0,       81,  -54,   15,
      25,   61,  -72,       28,   53,  -67,       35,   35,  -57,       43,   15,  -43,
      52,   -6,  -28,       62,  -23,  -14,       72,  -38,    1,       82,  -53,   15,
      26,   62,  -70,       29,   54,  -66,       35,   36,  -56,       43,   16,  -43,
      53,   -4,  -28,       62,  -21,  -13,       72,  -37,    1,       82,  -51,   15,
      27,   63,  -69,       30,   55,  -64,       36,   38,  -54,       44,   18,  -42,
      53,   -2,  -27,       63,  -20,  -13,       72,  -35,    1,       82,  -50,   15,
      29,   63,  -66,       31,   56,  -62,       37,   40,  -53,       45,   21,  -40,
      54,    1,  -26,       63,  -17,  -12,       72,  -33,    2,       82,  -48,   16,
      30,   64,  -64,       32,   57,  -60,       38,   42,  -51,       45,   23,  -39,
      54,    3,  -25,       63,  -15,  -11,       73,  -31,    2,       82,  -46,   16,
      31,   65,  -62,       33,   58,  -58,       39,   43,  -50,       46,   25,  -38,
      55,    5,  -25,       64,  -13,  -11,       73,  -29,    3,       83,  -44,   17,
      32,   66,  -60,       35,   60,  -56,       40,   45,  -48,       47,   27,  -37,
      55,    7,  -24,       64,  -11,  -10,       73,  -27,    4,       83,  -42,   17,
      34,   67,  -58,       36,   61,  -54,       41,   48,  -46,       48,   30,  -35,
      56,   10,  -22,       65,   -8,   -9,       74,  -24,    4,       83,  -40,   18,
      35,   68,  -55,       37,   63,  -52,       42,   49,  -45,       48,   32,  -34,
      57,   13,  -21,       65,   -5,   -8,       74,  -22,    5,       84,  -38,   18,
      37,   70,  -53,       38,   64,  -50,       43,   51,  -43,       49,   35,  -33,
      57,   16,  -20,       66,   -3,   -7,       75,  -20,    6,       84,  -35,   19,
      38,   71,  -51,       40,   65,  -48,       44,   53,  -41,       50,   37,  -31,
      58,   18,  -19,       66,    0,   -6,       75,  -17,    6,       84,  -33,   19,
      40,   72,  -48,       41,   67,  -45,       45,   56,  -39,       51,   40,  -29,
      59,   21,  -18,       67,    3,   -5,       76,  -14,    7,       85,  -30,   20,
      41,   73,  -45,       43,   69,  -43,       47,   58,  -37,       52,   42,  -28,
      60,   24,  -16,       68,    6,   -4,       76,  -11,    8,       85,  -28,   21,
      43,   75,  -43,       44,   70,  -41,       48,   60,  -35,       53,   45,  -26,
      61,   27,  -15,       69,    9,   -3,       77,   -8,    9,       86,  -25,   22,
      44,   76,  -41,       45,   72,  -38,       49,   62,  -33,       54,   47,  -24,
      61,   29,  -14,       69,   12,   -2,       78,   -5,   10,       86,  -22,   22,
      45,   78,  -38,       47,   73,  -36,       50,   64,  -31,       56,   50,  -23,
      62,   32,  -12,       70,   15,   -1,       78,   -3,   11,       87,  -19,   23,
      47,   79,  -35,       48,   75,  -33,       52,   66,  -28,       57,   52,  -21,
      63,   35,  -10,       71,   18,    1,       79,    1,   12,       88,  -16,   24,
      49,   81,  -33,       50,   77,  -31,       53,   68,  -26,       58,   55,  -19,
      64,   38,   -9,       72,   21,    2,       80,    4,   13,       88,  -13,   25,
      50,   82,  -31,       51,   79,  -29,       54,   70,  -24,       59,   57,  -17,
      65,   41,   -7,       72,   24,    3,       80,    7,   14,       89,  -10,   26,
      52,   84,  -28,       53,   80,  -26,       56,   72,  -22,       60,   59,  -15,
      66,   44,   -6,       73,   27,    4,       81,   10,   15,       89,   -7,   27,
      53,   85,  -25,       54,   82,  -24,       57,   74,  -19,       62,   62,  -13,
      68,   47,   -4,       74,   30,    6,       82,   13,   17,       90,   -4,   28,
      55,   87,  -23,       56,   84,  -21,       59,   76,  -17,       63,   64,  -11,
      69,   49,   -2,       75,   33,    7,       83,   16,   18,       91,   -1,   29,
      56,   88,  -20,       57,   85,  -19,       60,   78,  -15,       64,   67,   -9,
      70,   52,   -1,       76,   36,    9,       83,   19,   19,       91,    2,   30,
      21,   61,  -83,       25,   51,  -78,       32,   31,  -66,       41,    9,  -51,
      51,  -11,  -35,       61,  -28,  -20,       71,  -43,   -5,       81,  -57,   10,
      22,   61,  -83,       25,   51,  -77,       32,   31,  -65,       41,   10,  -51,
      51,  -11,  -35,       61,  -28,  -20,       71,  -43,   -5,       81,  -56,   10,
      22,   61,  -83,       25,   51,  -77,       32,   31,  -65,       41,   10,  -51,
      51,  -10,  -35,       61,  -28,  -20,       71,  -42,   -5,       81,  -56,   10,
      22,   61,  -82,       25,   51,  -76,       33,   32,  -65,       41,   10,  -50,
      51,  -10,  -35,       61,  -27,  -20,       71,  -42,   -5,       81,  -56,   10,
      23,   62,  -81,       26,   52,  -76,       33,   32,  -64,       42,   11,  -50,
      51,   -9,  -35,       61,  -26,  -19,       71,  -41,   -5,       81,  -55,   10,
      23,   62,  -81,       26,   52,  -75,       33,   33,  -64,       42,   12,  -50,
      52,   -8,  -34,       61,  -26,  -19,       71,  -41,   -4,       81,  -55,   10,
      24,   62,  -80,       27,   53,  -74,       33,   34,  -63,       42,   13,  -49,
      52,   -7,  -34,       62,  -25,  -19,       71,  -40,   -4,       81,  -54,   10,
      24,   62,  -78,       27,   53,  -73,       34,   35,  -62,       42,   14,  -49,
      52,   -6,  -33,       62,  -23,  -19,       71,  -39,   -4,       81,  -53,   10,
      25,   63,  -77,       28,   54,  -72,       35,   36,  -61,       43,   16,  -48,
      52,   -4,  -33,       62,  -22,  -18,       72,  -38,   -4,       82,  -52,   11,
      26,   63,  -75,       29,   55,  -71,       35,   38,  -60,       43,   17,  -47,
      53,   -3,  -32,       62,  -21,  -18,       72,  -36,   -3,       82,  -51,   11,
      27,   64,  -74,       30,   56,  -69,       36,   39,  -59,       44,   19,  -46,
      53,   -1,  -32,       62,  -19,  -17,       72,  -35,   -3,       82,  -49,   11,
      28,   64,  -72,       31,   57,  -68,       37,   40,  -58,       44,   21,  -46,
      53,    1,  -31,       63,  -17,  -17,       72,  -33,   -3,       82,  -48,   12,
      29,   65,  -70,       32,   58,  -66,       37,   42,  -57,       45,   23,  -44,
      54,    3,  -30,       63,  -15,  -16,       73,  -31,   -2,       82,  -46,   12,
      31,   66,  -68,       33,   59,  -64,       38,   44,  -55,       46,   25,  -43,
      54,    5,  -29,       64,  -13,  -16,       73,  -29,   -2,       83,  -45,   12,
      32,   67,  -66,       34,   60,  -62,       39,   46,  -54,       46,   27,  -42,
      55,    7,  -29,       64,  -11,  -15,       73,  -27,   -1,       83,  -43,   13,
      33,   68,  -64,       35,   61,  -60,       40,   47,  -52,       47,   29,  -41,
      56,   10,  -28,       64,   -9,  -14,       74,  -25,   -1,       83,  -41,   13,
      34,   69,  -61,       37,   63,  -58,       41,   49,  -50,       48,   32,  -40,
      56,   12,  -27,       65,   -6,  -13,       74,  -23,    0,       84,  -38,   14,
      36,   70,  -59,       38,   64,  -56,       42,   51,  -49,       49,   34,  -38,
      57,   15,  -25,       66,   -3,  -12,       75,  -20,    1,       84,  -36,   14,
      37,   71,  -57,       39,   65,  -54,       43,   53,  -47,       50,   36,  -37,
      58,   17,  -24,       66,   -1,  -11,       75,  -18,    2,       84,  -34,   15,
      39,   72,  -54,       40,   67,  -52,       44,   55,  -45,       51,   39,  -35,
      58,   20,  -23,       67,    2,  -11,       75,  -15,    2,       85,  -32,   16,
      40,   73,  -52,       42,   69,  -49,       46,   57,  -43,       52,   41,  -33,
      59,   23,  -22,       67,    5,   -9,       76,  -12,    3,       85,  -29,   16,
      42,   75,  -49,       43,   70,  -47,       47,   59,  -41,       53,   44,  -32,
      60,   26,  -20,       68,    8,   -8,       77,  -10,    4,       86,  -26,   17,
      43,   76,  -47,       45,   72,  -45,       48,   61,  -39,       54,   46,  -30,
      61,   28,  -19,       69,   10,   -7,       77,   -7,    5,       86,  -24,   18,
      44,   77,  -45,       46,   73,  -42,       49,   63,  -37,       55,   49,  -28,
      62,   31,  -18,       69,   13,   -6,       78,   -4,    6,       87,  -21,   18,
      46,   79,  -42,       47,   75,  -40,       51,   65,  -35,       56,   51,  -27,
      63,   34,  -16,       70,   16,   -5,       78,   -1,    7,       87,  -18,   19,
      48,   80,  -39,       49,   76,  -37,       52,   67,  -32,       57,   54,  -25,
      64,   37,  -15,       71,   19,   -4,       79,    2,    8,       88,  -15,   20,
      49,   82,  -37,       50,   78,  -35,       53,   69,  -30,       58,   56,  -23,
      65,   39,  -13,       72,   22,   -2,       80,    5,    9,       88,  -12,   21,
      51,   83,  -35,       52,   80,  -33,       55,   71,  -28,       59,   58,  -21,
      66,   42,  -11,       73,   25,   -1,       80,    8,   10,       89,   -9,   22,
      52,   85,  -32,       53,   81,  -30,       56,   73,  -26,       61,   61,  -19,
      67,   45,  -10,       74,   28,    0,       81,   11,   11,       89,   -6,   23,
      54,   86,  -29,       55,   83,  -28,       58,   75,  -24,       62,   63,  -17,
      68,   48,   -8,       75,   31,    2,       82,   14,   13,       90,   -3,   24,
      55,   88,  -27,       56,   85,  -25,       59,   77,  -21,       63,   65,  -15,
      69,   50,   -6,       75,   34,    3,       83,   17,   14,       91,    0,   25,
      57,   89,  -25,       58,   86,  -23,       60,   79,  -19,       64,   68,  -13,
      70,   53,   -5,       76,   37,    5,       84,   20,   15,       91,    3,   26,
      23,   63,  -86,       26,   53,  -81,       33,   34,  -69,       42,   12,  -55,
      51,   -8,  -39,       61,  -25,  -24,       71,  -41,   -9,       81,  -54,    6,
      23,   63,  -86,       26,   53,  -80,       33,   34,  -69,       42,   13,  -55,
      51,   -8,  -39,       61,  -25,  -24,       71,  -40,   -9,       81,  -54,    6,
      23,   63,  -85,       26,   53,  -80,       33,   34,  -69,       42,   13,  -55,
      52,   -7,  -39,       61,  -25,  -24,       71,  -40,   -9,       81,  -54,    6,
      23,   63,  -85,       26,   54,  -80,       33,   35,  -68,       42,   14,  -54,
      52,   -7,  -39,       61,  -24,  -24,       71,  -40,   -9,       81,  -54,    6,
      24,   64,  -84,       27,   54,  -79,       34,   35,  -68,       42,   14,  -54,
      52,   -6,  -38,       62,  -24,  -23,       71,  -39,   -9,       81,  -53,    6,
      24,   64,  -83,       27,   54,  -78,       34,   36,  -67,       42,   15,  -54,
      52,   -5,  -38,       62,  -23,  -23,       71,  -38,   -8,       81,  -53,    6,
      25,   64,  -82,       28,   55,  -77,       34,   37,  -67,       43,   16,  -53,
      52,   -4,  -38,       62,  -22,  -23,       71,  -38,   -8,       81,  -52,    6,
      25,   64,  -81,       28,   56,  -76,       35,   38,  -66,       43,   17,  -53,
      52,   -3,  -37,       62,  -21,  -23,       72,  -37,   -8,       82,  -51,    6,
      26,   65,  -80,       29,   56,  -75,       35,   39,  -65,       43,   19,  -52,
      53,   -2,  -37,       62,  -20,  -22,       72,  -35,   -8,       82,  -50,    7,
      27,   65,  -78,       30,   57,  -74,       36,   40,  -64,       44,   20,  -51,
      53,    0,  -36,       62,  -18,  -22,       72,  -34,   -7,       82,  -49,    7,
      28,   66,  -77,       31,   58,  -73,       36,   41,  -63,       44,   22,  -50,
      53,    1,  -36,       63,  -17,  -21,       72,  -33,   -7,       82,  -48,    7,
      29,   66,  -75,       32,   59,  -71,       37,   43,  -62,       45,   23,  -49,
      54,    3,  -35,       63,  -15,  -21,       73,  -31,   -7,       82,  -46,    8,
      30,   67,  -73,       33,   60,  -69,       38,   44,  -60,       45,   25,  -48,
      54,    5,  -34,       63,  -13,  -20,       73,  -29,   -6,       83,  -44,    8,
      31,   68,  -71,       34,   61,  -68,       39,   46,  -59,       46,   27,  -47,
      55,    7,  -34,       64,  -11,  -20,       73,  -27,   -6,       83,  -43,    8,
      33,   68,  -69,       35,   62,  -66,       40,   48,  -57,       47,   29,  -46,
      55,    9,  -33,       64,   -9,  -19,       73,  -25,   -5,       83,  -41,    9,
      34,   69,  -67,       36,   63,  -64,       41,   49,  -56,       48,   31,  -45,
      56,   12,  -32,       65,   -7,  -18,       74,  -23,   -5,       83,  -39,    9,
      35,   70,  -65,       37,   64,  -62,       42,   51,  -54,       48,   34,  -43,
      57,   14,  -31,       65,   -4,  -17,       74,  -21,   -4,       84,  -37,   10,
      36,   71,  -63,       38,   66,  -60,       43,   53,  -52,       49,   36,  -42,
      57,   17,  -30,       66,   -2,  -16,       75,  -19,   -3,       84,  -35,   10,
      38,   72,  -60,       40,   67,  -58,       44,   55,  -51,       50,   38,  -41,
      58,   19,  -28,       66,    1,  -16,       75,  -16,   -2,       84,  -32,   11,
      39,   73,  -58,       41,   68,  -55,       45,   57,  -49,       51,   40,  -39,
      59,   22,  -27,       67,    4,  -15,       76,  -14,   -2,       85,  -30,   12,
      41,   75,  -56,       42,   70,  -53,       46,   59,  -47,       52,   43,  -37,
      60,   25,  -26,       68,    7,  -13,       76,  -11,   -1,       85,  -27,   12,
      42,   76,  -53,       44,   71,  -51,       47,   61,  -45,       53,   45,  -36,
      60,   27,  -25,       68,    9,  -12,       77,   -8,    0,       86,  -25,   13,
      44,   77,  -51,       45,   73,  -49,       49,   62,  -43,       54,   48,  -34,
      61,   30,  -23,       69,   12,  -11,       77,   -5,    1,       86,  -22,   14,
      45,   78,  -49,       46,   74,  -46,       50,   64,  -41,       55,   50,  -32,
      62,   32,  -22,       70,   15,  -10,       78,   -3,    2,       87,  -20,   15,
      46,   80,  -46,       48,   76,  -44,       51,   66,  -39,       56,   52,  -31,
      63,   35,  -20,       70,   17,   -9,       79,    0,    3,       87,  -17,   15,
      48,   81,  -43,       49,   77,  -41,       52,   68,  -36,       57,   55,  -29,
      64,   38,  -19,       71,   21,   -8,       79,    3,    4,       88,  -14,   16,
      49,   83,  -41,       51,   79,  -39,       54,   70,  -34,       59,   57,  -27,
      65,   41,  -17,       72,   23,   -6,       80,    6,    5,       88,  -11,   17,
      51,   84,  -39,       52,   81,  -37,       55,   72,  -32,       60,   59,  -25,
      66,   43,  -16,       73,   26,   -5,       81,    9,    6,       89,   -8,   18,
      52,   85,  -36,       54,   82,  -35,       56,   74,  -30,       61,   62,  -23,
      67,   46,  -14,       74,   29,   -4,       81,   12,    7,       90,   -5,   19,
      54,   87,  -34,       55,   84,  -32,       58,   76,  -28,       62,   64,  -21,
      68,   49,  -12,       75,   32,   -2,       82,   15,    9,       90,   -2,   20,
      56,   89,  -31,       57,   86,  -30,       59,   78,  -25,       63,   66,  -19,
      69,   51,  -11,       76,   35,   -1,       83,   18,   10,       91,    1,   21,
      57,   90,  -29,       58,   87,  -27,       61,   80,  -23,       65,   69,  -17,
      70,   54,   -9,       77,   38,    1,       84,   21,   11,       92,    4,   22,
      24,   65,  -89,       27,   56,  -84,       34,   37,  -73,       42,   16,  -59,
      52,   -5,  -43,       62,  -23,  -28,       71,  -38,  -13,       81,  -52,    2,
      24,   65,  -89,       27,   56,  -83,       34,   37,  -72,       42,   16,  -58,
      52,   -5,  -43,       62,  -22,  -28,       71,  -38,  -13,       81,  -52,    2,
      24,   65,  -88,       27,   56,  -83,       34,   37,  -72,       42,   16,  -58,
      52,   -4,  -43,       62,  -22,  -28,       71,  -38,  -13,       81,  -52,    2,
      24,   65,  -88,       27,   56,  -83,       34,   38,  -72,       42,   17,  -58,
      52,   -4,  -43,       62,  -22,  -28,       71,  -37,  -13,       81,  -52,    2,
      25,   66,  -87,       28,   56,  -82,       34,   38,  -71,       43,   17,  -58,
      52,   -3,  -42,       62,  -21,  -27,       72,  -37,  -13,       81,  -51,    2,
      25,   66,  -86,       28,   57,  -81,       35,   39,  -71,       43,   18,  -57,
      52,   -2,  -42,       62,  -20,  -27,       72,  -36,  -12,       82,  -51,    2,
      26,   66,  -85,       29,   57,  -81,       35,   40,  -70,       43,   19,  -57,
      53,   -2,  -42,       62,  -19,  -27,       72,  -35,  -12,       82,  -50,    2,
      27,   66,  -84,       29,   58,  -80,       35,   41,  -69,       43,   20,  -56,
      53,    0,  -41,       62,  -18,  -27,       72,  -34,  -12,       82,  -49,    3,
      27,   67,  -83,       30,   58,  -78,       36,   42,  -69,       44,   21,  -56,
      53,    1,  -41,       63,  -17,  -26,       72,  -33,  -12,       82,  -48,    3,
      28,   67,  -82,       31,   59,  -77,       36,   43,  -68,       44,   23,  -55,
      53,    2,  -40,       63,  -16,  -26,       72,  -32,  -11,       82,  -47,    3,
      29,   67,  -80,       31,   60,  -76,       37,   44,  -67,       45,   24,  -54,
      54,    4,  -40,       63,  -14,  -25,       73,  -31,  -11,       82,  -46,    3,
      30,   68,  -78,       32,   61,  -74,       38,   45,  -65,       45,   26,  -53,
      54,    6,  -39,       63,  -13,  -25,       73,  -29,  -11,       82,  -44,    4,
      31,   69,  -76,       33,   62,  -73,       39,   47,  -64,       46,   28,  -52,
      55,    8,  -38,       64,  -11,  -24,       73,  -27,  -10,       83,  -43,    4,
      32,   69,  -75,       34,   63,  -71,       39,   48,  -63,       47,   30,  -51,
      55,   10,  -37,       64,   -9,  -24,       73,  -25,  -10,       83,  -41,    4,
      33,   70,  -73,       35,   64,  -69,       40,   50,  -61,       47,   32,  -50,
      56,   12,  -37,       65,   -7,  -23,       74,  -23,   -9,       83,  -39,    5,
      34,   71,  -71,       37,   65,  -67,       41,   51,  -60,       48,   34,  -49,
      56,   14,  -36,       65,   -4,  -22,       74,  -21,   -9,       84,  -37,    5,
      36,   72,  -68,       38,   66,  -65,       42,   53,  -58,       49,   36,  -47,
      57,   16,  -35,       66,   -2,  -21,       75,  -19,   -8,       84,  -35,    6,
      37,   73,  -66,       39,   67,  -63,       43,   55,  -56,       50,   38,  -46,
      58,   19,  -34,       66,    0,  -20,       75,  -17,   -7,       84,  -33,    6,
      38,   74,  -64,       40,   69,  -61,       44,   57,  -54,       51,   40,  -45,
      58,   21,  -32,       67,    3,  -20,       75,  -14,   -6,       85,  -31,    7,
      40,   75,  -62,       41,   70,  -59,       45,   58,  -53,       51,   42,  -43,
      59,   24,  -31,       67,    5,  -19,       76,  -12,   -6,       85,  -28,    8,
      41,   76,  -59,       43,   71,  -57,       47,   60,  -51,       52,   45,  -41,
      60,   26,  -30,       68,    8,  -18,       76,   -9,   -5,       85,  -26,    8,
      43,   77,  -57,       44,   73,  -55,       48,   62,  -49,       53,   47,  -40,
      61,   29,  -29,       69,   11,  -16,       77,   -7,   -4,       86,  -23,    9,
      44,   78,  -55,       45,   74,  -52,       49,   64,  -47,       54,   49,  -38,
      61,   31,  -27,       69,   14,  -15,       78,   -4,   -3,       86,  -21,   10,
      45,   80,  -52,       47,   76,  -50,       50,   66,  -45,       55,   51,  -36,
      62,   34,  -26,       70,   16,  -14,       78,   -1,   -2,       87,  -18,   11,
      47,   81,  -50,       48,   77,  -48,       51,   68,  -43,       57,   54,  -35,
      63,   37,  -24,       71,   19,  -13,       79,    2,   -1,       87,  -15,   11,
      48,   82,  -47,       50,   79,  -45,       53,   70,  -40,       58,   56,  -33,
      64,   39,  -23,       72,   22,  -12,       79,    5,    0,       88,  -12,   12,
      50,   84,  -45,       51,   80,  -43,       54,   71,  -38,       59,   58,  -31,
      65,   42,  -21,       72,   25,  -10,       80,    8,    1,       89,  -10,   13,
      51,   85,  -43,       53,   82,  -41,       55,   73,  -36,       60,   61,  -29,
      66,   45,  -20,       73,   28,   -9,       81,   10,    2,       89,   -7,   14,
      53,   86,  -40,       54,   83,  -39,       57,   75,  -34,       61,   63,  -27,
      67,   47,  -18,       74,   30,   -8,       82,   13,    3,       90,   -4,   15,
      54,   88,  -38,       55,   85,  -36,       58,   77,  -32,       62,   65,  -25,
      68,   50,  -16,       75,   33,   -6,       82,   16,    5,       90,   -1,   16,
      56,   89,  -35,       57,   86,  -34,       60,   79,  -30,       64,   68,  -23,
      69,   53,  -15,       76,   36,   -5,       83,   19,    6,       91,    2,   17,
      57,   91,  -33,       58,   88,  -31,       61,   81,  -27,       65,   70,  -21,
      70,   55,  -13,       77,   39,   -3,       84,   22,    7,       92,    5,   18,
      25,   67,  -92,       28,   58,  -87,       34,   40,  -76,       43,   19,  -63,
      52,   -1,  -47,       62,  -20,  -32,       72,  -35,  -17,       82,  -50,   -3,
      25,   67,  -92,       28,   59,  -87,       35,   40,  -76,       43,   20,  -63,
      52,   -1,  -47,       62,  -19,  -32,       72,  -35,  -17,       82,  -50,   -3,
      25,   68,  -91,       28,   59,  -86,       35,   41,  -76,       43,   20,  -62,
      52,   -1,  -47,       62,  -19,  -32,       72,  -35,  -17,       82,  -50,   -3,
      26,   68,  -91,       29,   59,  -86,       35,   41,  -76,       43,   20,  -62,
      53,    0,  -47,       62,  -19,  -32,       72,  -35,  -17,       82,  -49,   -3,
      26,   68,  -90,       29,   59,  -85,       35,   42,  -75,       43,   21,  -62,
      53,    0,  -47,       62,  -18,  -32,       72,  -34,  -17,       82,  -49,   -2,
      27,   68,  -89,       29,   59,  -85,       35,   42,  -75,       43,   22,  -62,
      53,    1,  -47,       62,  -17,  -32,       72,  -33,  -17,       82,  -48,   -2,
      27,   68,  -89,       30,   60,  -84,       36,   43,  -74,       44,   22,  -61,
      53,    2,  -46,       62,  -16,  -31,       72,  -33,  -17,       82,  -48,   -2,
      28,   68,  -87,       30,   60,  -83,       36,   44,  -73,       44,   24,  -61,
      53,    3,  -46,       63,  -15,  -31,       72,  -32,  -17,       82,  -47,   -2,
      28,   69,  -86,       31,   61,  -82,       37,   45,  -72,       44,   25,  -60,
      54,    4,  -45,       63,  -14,  -31,       72,  -31,  -16,       82,  -46,   -2,
      29,   69,  -85,       32,   62,  -81,       37,   46,  -72,       45,   26,  -59,
      54,    5,  -45,       63,  -13,  -30,       73,  -29,  -16,       82,  -45,   -1,
      30,   69,  -84,       32,   62,  -80,       38,   47,  -71,       45,   27,  -58,
      54,    7,  -44,       63,  -11,  -30,       73,  -28,  -16,       82,  -43,   -1,
      31,   70,  -82,       33,   63,  -78,       39,   48,  -69,       46,   29,  -58,
      55,    9,  -44,       64,  -10,  -29,       73,  -27,  -15,       83,  -42,   -1,
      32,   71,  -80,       34,   64,  -76,       39,   49,  -68,       47,   31,  -56,
      55,   11,  -43,       64,   -8,  -29,       73,  -25,  -15,       83,  -40,    0,
      33,   71,  -78,       35,   65,  -75,       40,   51,  -67,       47,   32,  -55,
      56,   12,  -42,       65,   -6,  -28,       74,  -23,  -14,       83,  -39,    0,
      34,   72,  -77,       36,   66,  -73,       41,   52,  -65,       48,   34,  -54,
      56,   14,  -41,       65,   -4,  -27,       74,  -21,  -14,       83,  -37,    0,
      35,   73,  -75,       37,   67,  -71,       42,   54,  -64,       49,   36,  -53,
      57,   16,  -40,       65,   -2,  -27,       74,  -19,  -13,       84,  -35,    1,
      37,   74,  -72,       39,   68,  -69,       43,   55,  -62,       49,   38,  -52,
      57,   19,  -39,       66,    0,  -26,       75,  -17,  -12,       84,  -33,    1,
      38,   74,  -70,       40,   69,  -67,       44,   57,  -60,       50,   40,  -50,
      58,   21,  -38,       66,    3,  -25,       75,  -15,  -12,       84,  -31,    2,
      39,   75,  -68,       41,   70,  -65,       45,   59,  -59,       51,   42,  -49,
      59,   23,  -37,       67,    5,  -24,       76,  -12,  -11,       85,  -29,    3,
      40,   76,  -66,       42,   72,  -63,       46,   60,  -57,       52,   44,  -48,
      59,   26,  -36,       68,    7,  -23,       76,  -10,  -10,       85,  -27,    3,
      42,   78,  -64,       43,   73,  -61,       47,   62,  -55,       53,   47,  -46,
      60,   28,  -34,       68,   10,  -22,       77,   -7,   -9,       86,  -24,    4,
      43,   79,  -61,       45,   74,  -59,       48,   64,  -53,       54,   49,  -44,
      61,   31,  -33,       69,   13,  -21,       77,   -5,   -8,       86,  -22,    5,
      45,   80,  -59,       46,   76,  -57,       50,   66,  -51,       55,   51,  -43,
      62,   33,  -32,       70,   15,  -20,       78,   -2,   -8,       87,  -19,    5,
      46,   81,  -57,       47,   77,  -55,       51,   67,  -49,       56,   53,  -41,
      63,   36,  -30,       70,   18,  -19,       78,    1,   -7,       87,  -16,    6,
      47,   82,  -54,       49,   78,  -52,       52,   69,  -47,       57,   55,  -39,
      64,   38,  -29,       71,   21,  -18,       79,    3,   -6,       88,  -14,    7,
      49,   84,  -52,       50,   80,  -50,       53,   71,  -45,       58,   58,  -37,
      65,   41,  -27,       72,   24,  -16,       80,    6,   -4,       88,  -11,    8,
      50,   85,  -49,       52,   81,  -48,       55,   73,  -43,       59,   60,  -35,
      66,   44,  -26,       73,   26,  -15,       80,    9,   -3,       89,   -8,    9,
      52,   86,  -47,       53,   83,  -45,       56,   75,  -41,       60,   62,  -34,
      66,   46,  -24,       73,   29,  -14,       81,   12,   -2,       89,   -5,   10,
      53,   88,  -45,       54,   84,  -43,       57,   76,  -39,       62,   64,  -32,
      67,   49,  -23,       74,   32,  -12,       82,   15,   -1,       90,   -3,   11,
      55,   89,  -42,       56,   86,  -40,       59,   78,  -36,       63,   67,  -30,
      69,   51,  -21,       75,   35,  -11,       83,   18,    0,       91,    1,   12,
      56,   91,  -40,       57,   88,  -38,       60,   80,  -34,       64,   69,  -28,
      70,   54,  -19,       76,   38,   -9,       83,   21,    1,       91,    3,   13,
      58,   92,  -37,       59,   89,  -36,       61,   82,  -32,       65,   71,  -26,
      71,   56,  -17,       77,   40,   -8,       84,   24,    2,       92,    6,   14,
      26,   69,  -94,       29,   61,  -90,       35,   43,  -80,       43,   23,  -66,
      53,    2,  -51,       62,  -17,  -36,       72,  -33,  -21,       82,  -48,   -7,
      26,   69,  -94,       29,   61,  -90,       35,   43,  -79,       43,   23,  -66,
      53,    2,  -51,       62,  -16,  -36,       72,  -33,  -21,       82,  -48,   -7,
      27,   69,  -94,       29,   61,  -89,       35,   44,  -79,       44,   23,  -66,
      53,    2,  -51,       62,  -16,  -36,       72,  -32,  -21,       82,  -47,   -7,
      27,   70,  -93,       30,   61,  -89,       36,   44,  -79,       44,   23,  -66,
      53,    3,  -51,       62,  -16,  -36,       72,  -32,  -21,       82,  -47,   -6,
      27,   70,  -93,       30,   61,  -88,       36,   44,  -79,       44,   24,  -66,
      53,    3,  -51,       63,  -15,  -36,       72,  -32,  -21,       82,  -47,   -6,
      28,   70,  -92,       30,   62,  -88,       36,   45,  -78,       44,   25,  -65,
      53,    4,  -50,       63,  -15,  -36,       72,  -31,  -21,       82,  -46,   -6,
      28,   70,  -91,       31,   62,  -87,       37,   46,  -77,       44,   25,  -65,
      53,    5,  -50,       63,  -14,  -35,       72,  -30,  -21,       82,  -45,   -6,
      29,   70,  -90,       31,   63,  -86,       37,   46,  -77,       45,   26,  -64,
      54,    6,  -50,       63,  -13,  -35,       72,  -29,  -20,       82,  -44,   -6,
      29,   71,  -89,       32,   63,  -85,       37,   47,  -76,       45,   28,  -64,
      54,    7,  -49,       63,  -12,  -35,       73,  -28,  -20,       82,  -44,   -6,
      30,   71,  -88,       33,   64,  -84,       38,   48,  -75,       45,   29,  -63,
      54,    8,  -49,       63,  -10,  -34,       73,  -27,  -20,       83,  -42,   -5,
      31,   71,  -87,       33,   64,  -83,       39,   49,  -74,       46,   30,  -62,
      55,   10,  -48,       64,   -9,  -34,       73,  -26,  -20,       83,  -41,   -5,
      32,   72,  -85,       34,   65,  -81,       39,   50,  -73,       46,   31,  -61,
      55,   11,  -47,       64,   -7,  -33,       73,  -24,  -19,       83,  -40,   -5,
      33,   72,  -83,       35,   66,  -80,       40,   52,  -72,       47,   33,  -60,
      56,   13,  -47,       64,   -6,  -33,       74,  -23,  -19,       83,  -38,   -4,
      34,   73,  -82,       36,   67,  -78,       41,   53,  -70,       48,   35,  -59,
      56,   15,  -46,       65,   -4,  -32,       74,  -21,  -18,       83,  -37,   -4,
      35,   74,  -80,       37,   68,  -77,       42,   54,  -69,       48,   36,  -58,
      57,   17,  -45,       65,   -2,  -31,       74,  -19,  -18,       84,  -35,   -4,
      36,   74,  -78,       38,   69,  -75,       43,   56,  -67,       49,   38,  -57,
      57,   19,  -44,       66,    0,  -31,       75,  -17,  -17,       84,  -33,   -3,
      37,   75,  -76,       39,   70,  -73,       44,   57,  -66,       50,   40,  -56,
      58,   21,  -43,       66,    3,  -30,       75,  -15,  -16,       84,  -31,   -2,
      39,   76,  -74,       40,   71,  -71,       45,   59,  -64,       51,   42,  -54,
      58,   23,  -42,       67,    5,  -29,       75,  -13,  -16,       85,  -29,   -2,
      40,   77,  -72,       42,   72,  -69,       46,   60,  -62,       51,   44,  -53,
      59,   25,  -41,       67,    7,  -28,       76,  -10,  -15,       85,  -27,   -1,
      41,   78,  -70,       43,   73,  -67,       47,   62,  -61,       52,   46,  -51,
      60,   28,  -40,       68,    9,  -27,       76,   -8,  -14,       85,  -25,   -1,
      43,   79,  -67,       44,   74,  -65,       48,   64,  -59,       53,   48,  -50,
      61,   30,  -38,       69,   12,  -26,       77,   -5,  -13,       86,  -22,    0,
      44,   80,  -65,       45,   76,  -63,       49,   65,  -57,       54,   51,  -48,
      61,   33,  -37,       69,   15,  -25,       77,   -3,  -12,       86,  -20,    1,
      45,   81,  -63,       47,   77,  -60,       50,   67,  -55,       55,   53,  -47,
      62,   35,  -36,       70,   17,  -24,       78,    0,  -12,       87,  -17,    1,
      47,   82,  -60,       48,   78,  -58,       51,   69,  -53,       56,   55,  -45,
      63,   37,  -34,       71,   20,  -23,       79,    2,  -11,       87,  -15,    2,
      48,   83,  -58,       49,   80,  -56,       52,   70,  -51,       57,   57,  -43,
      64,   40,  -33,       71,   22,  -22,       79,    5,  -10,       88,  -12,    3,
      49,   85,  -56,       51,   81,  -54,       54,   72,  -49,       59,   59,  -41,
      65,   43,  -31,       72,   25,  -20,       80,    8,   -8,       88,   -9,    4,
      51,   86,  -53,       52,   83,  -51,       55,   74,  -47,       60,   61,  -39,
      66,   45,  -30,       73,   28,  -19,       81,   11,   -7,       89,   -7,    5,
      52,   87,  -51,       53,   84,  -49,       56,   76,  -45,       61,   63,  -38,
      67,   47,  -28,       74,   31,  -18,       81,   13,   -6,       90,   -4,    6,
      54,   89,  -49,       55,   85,  -47,       58,   78,  -43,       62,   65,  -36,
      68,   50,  -27,       75,   33,  -16,       82,   16,   -5,       90,   -1,    7,
      55,   90,  -46,       56,   87,  -44,       59,   80,  -40,       63,   68,  -34,
      69,   53,  -25,       75,   36,  -15,       83,   19,   -4,       91,    2,    8,
      57,   92,  -44,       58,   89,  -42,       60,   81,  -38,       64,   70,  -32,
      70,   55,  -23,       76,   39,  -13,       84,   22,   -3,       91,    5,    9,
      58,   93,  -41,       59,   90,  -40,       62,   83,  -36,       65,   72,  -30,
      71,   57,  -22,       77,   41,  -12,       84,   25,   -1,       92,    8,   10,
      28,   71,  -97,       30,   63,  -93,       36,   46,  -83,       44,   26,  -70,
      53,    5,  -55,       63,  -14,  -40,       72,  -30,  -25,       82,  -45,  -11,
      28,   71,  -97,       30,   63,  -92,       36,   46,  -83,       44,   26,  -70,
      53,    5,  -55,       63,  -14,  -40,       72,  -30,  -25,       82,  -45,  -10,
      28,   71,  -97,       30,   63,  -92,       36,   46,  -83,       44,   26,  -70,
      53,    5,  -55,       63,  -13,  -40,       72,  -30,  -25,       82,  -45,  -10,
      28,   72,  -96,       31,   64,  -92,       36,   47,  -82,       44,   27,  -69,
      53,    6,  -55,       63,  -13,  -40,       72,  -29,  -25,       82,  -45,  -10,
      28,   72,  -96,       31,   64,  -91,       37,   47,  -82,       44,   27,  -69,
      54,    6,  -54,       63,  -12,  -40,       72,  -29,  -25,       82,  -44,  -10,
      29,   72,  -95,       31,   64,  -91,       37,   48,  -81,       45,   28,  -69,
      54,    7,  -54,       63,  -12,  -39,       72,  -28,  -25,       82,  -44,  -10,
      29,   72,  -94,       32,   64,  -90,       37,   48,  -81,       45,   28,  -68,
      54,    8,  -54,       63,  -11,  -39,       73,  -28,  -25,       82,  -43,  -10,
      30,   72,  -93,       32,   65,  -89,       38,   49,  -80,       45,   29,  -68,
      54,    9,  -53,       63,  -10,  -39,       73,  -27,  -24,       82,  -42,  -10,
      30,   72,  -92,       33,   65,  -88,       38,   50,  -79,       46,   30,  -67,
      54,   10,  -53,       64,   -9,  -39,       73,  -26,  -24,       83,  -41,  -10,
      31,   73,  -91,       33,   66,  -87,       39,   51,  -78,       46,   31,  -67,
      55,   11,  -52,       64,   -8,  -38,       73,  -25,  -24,       83,  -40,   -9,
      32,   73,  -90,       34,   66,  -86,       39,   52,  -77,       46,   33,  -66,
      55,   12,  -52,       64,   -6,  -38,       73,  -23,  -23,       83,  -39,   -9,
      33,   74,  -88,       35,   67,  -85,       40,   53,  -76,       47,   34,  -65,
      55,   14,  -51,       64,   -5,  -37,       74,  -22,  -23,       83,  -38,   -9,
      34,   74,  -86,       36,   68,  -83,       41,   54,  -75,       48,   36,  -64,
      56,   16,  -50,       65,   -3,  -37,       74,  -20,  -23,       83,  -36,   -8,
      35,   75,  -85,       37,   69,  -81,       42,   55,  -74,       48,   37,  -63,
      56,   17,  -50,       65,   -1,  -36,       74,  -19,  -22,       84,  -35,   -8,
      36,   75,  -83,       38,   69,  -80,       42,   56,  -72,       49,   39,  -62,
      57,   19,  -49,       66,    0,  -35,       75,  -17,  -22,       84,  -33,   -7,
      37,   76,  -81,       39,   70,  -78,       43,   58,  -71,       50,   41,  -61,
      58,   21,  -48,       66,    2,  -35,       75,  -15,  -21,       84,  -31,   -7,
      38,   77,  -79,       40,   71,  -76,       44,   59,  -69,       50,   43,  -59,
      58,   23,  -47,       67,    5,  -34,       75,  -13,  -20,       85,  -29,   -6,
      39,   78,  -77,       41,   72,  -74,       45,   61,  -68,       51,   44,  -58,
      59,   25,  -46,       67,    7,  -33,       76,  -11,  -20,       85,  -27,   -6,
      41,   78,  -75,       42,   74,  -72,       46,   62,  -66,       52,   46,  -57,
      59,   27,  -45,       68,    9,  -32,       76,   -8,  -19,       85,  -25,   -5,
      42,   79,  -73,       43,   75,  -71,       47,   64,  -64,       53,   48,  -55,
      60,   30,  -44,       68,   11,  -31,       77,   -6,  -18,       86,  -23,   -5,
      43,   80,  -71,       45,   76,  -68,       48,   65,  -62,       54,   50,  -53,
      61,   32,  -42,       69,   14,  -30,       77,   -4,  -17,       86,  -21,   -4,
      44,   81,  -69,       46,   77,  -66,       49,   67,  -61,       55,   52,  -52,
      62,   34,  -41,       69,   16,  -29,       78,   -1,  -16,       87,  -18,   -3,
      46,   82,  -66,       47,   78,  -64,       51,   69,  -59,       56,   54,  -50,
      63,   37,  -40,       70,   19,  -28,       78,    1,  -15,       87,  -16,   -2,
      47,   84,  -64,       48,   80,  -62,       52,   70,  -57,       57,   56,  -49,
      63,   39,  -38,       71,   21,  -27,       79,    4,  -15,       88,  -13,   -2,
      48,   85,  -62,       50,   81,  -60,       53,   72,  -55,       58,   58,  -47,
      64,   41,  -37,       72,   24,  -26,       79,    6,  -14,       88,  -11,   -1,
      50,   86,  -59,       51,   82,  -57,       54,   74,  -53,       59,   61,  -45,
      65,   44,  -35,       72,   27,  -24,       80,    9,  -12,       89,   -8,    0,
      51,   87,  -57,       53,   84,  -55,       55,   75,  -51,       60,   63,  -43,
      66,   46,  -34,       73,   29,  -23,       81,   12,  -11,       89,   -5,    1,
      53,   88,  -55,       54,   85,  -53,       57,   77,  -49,       61,   65,  -42,
      67,   49,  -32,       74,   32,  -22,       82,   15,  -10,       90,   -3,    2,
      54,   90,  -52,       55,   87,  -51,       58,   79,  -46,       62,   67,  -40,
      68,   51,  -31,       75,   35,  -20,       82,   17,   -9,       90,    0,    3,
      56,   91,  -50,       57,   88,  -48,       59,   81,  -44,       63,   69,  -38,
      69,   54,  -29,       76,   38,  -19,       83,   21,   -8,       91,    3,    4,
      57,   93,  -48,       58,   90,  -46,       61,   82,  -42,       65,   71,  -36,
      70,   56,  -27,       77,   40,  -17,       84,   23,   -7,       92,    6,    5,
      59,   94,  -45,       59,   91,  -44,       62,   84,  -40,       66,   73,  -34,
      71,   59,  -25,       78,   43,  -16,       85,   26,   -5,       92,    9,    6,
      29,   73, -100,       31,   65,  -96,       37,   49,  -86,       45,   29,  -73,
      54,    8,  -59,       63,  -11,  -44,       72,  -28,  -29,       82,  -43,  -14,
      29,   73, -100,       31,   66,  -95,       37,   49,  -86,       45,   29,  -73,
      54,    8,  -59,       63,  -11,  -44,       72,  -27,  -29,       82,  -43,  -14,
      29,   73,  -99,       31,   66,  -95,       37,   49,  -86,       45,   29,  -73,
      54,    8,  -59,       63,  -10,  -44,       72,  -27,  -29,       82,  -43,  -14,
      29,   73,  -99,       32,   66,  -95,       37,   50,  -85,       45,   30,  -73,
      54,    9,  -58,       63,  -10,  -44,       73,  -27,  -29,       82,  -42,  -14,
      30,   74,  -98,       32,   66,  -94,       38,   50,  -85,       45,   30,  -73,
      54,    9,  -58,       63,  -10,  -44,       73,  -26,  -29,       82,  -42,  -14,
      30,   74,  -98,       32,   66,  -94,       38,   50,  -85,       45,   31,  -72,
      54,   10,  -58,       63,   -9,  -43,       73,  -26,  -29,       82,  -41,  -14,
      30,   74,  -97,       33,   67,  -93,       38,   51,  -84,       46,   31,  -72,
      54,   11,  -58,       64,   -8,  -43,       73,  -25,  -29,       83,  -41,  -14,
      31,   74,  -96,       33,   67,  -92,       39,   52,  -83,       46,   32,  -71,
      55,   12,  -57,       64,   -7,  -43,       73,  -24,  -28,       83,  -40,  -14,
      32,   74,  -95,       34,   67,  -91,       39,   52,  -83,       46,   33,  -71,
      55,   13,  -57,       64,   -6,  -42,       73,  -23,  -28,       83,  -39,  -13,
      32,   75,  -94,       34,   68,  -90,       39,   53,  -82,       47,   34,  -70,
      55,   14,  -56,       64,   -5,  -42,       73,  -22,  -28,       83,  -38,  -13,
      33,   75,  -93,       35,   68,  -89,       40,   54,  -81,       47,   35,  -69,
      56,   15,  -56,       64,   -4,  -42,       74,  -21,  -27,       83,  -37,  -13,
      34,   75,  -91,       36,   69,  -88,       41,   55,  -80,       48,   37,  -69,
      56,   16,  -55,       65,   -2,  -41,       74,  -20,  -27,       83,  -36,  -13,
      35,   76,  -90,       37,   70,  -86,       41,   56,  -78,       48,   38,  -67,
      56,   18,  -54,       65,   -1,  -40,       74,  -18,  -26,       84,  -34,  -12,
      36,   76,  -88,       38,   71,  -85,       42,   57,  -77,       49,   40,  -66,
      57,   20,  -53,       65,    1,  -40,       74,  -16,  -26,       84,  -33,  -12,
      37,   77,  -86,       39,   71,  -83,       43,   58,  -76,       49,   41,  -65,
      57,   22,  -53,       66,    3,  -39,       75,  -15,  -25,       84,  -31,  -11,
      38,   78,  -84,       40,   72,  -82,       44,   60,  -74,       50,   43,  -64,
      58,   23,  -52,       66,    5,  -38,       75,  -13,  -25,       84,  -29,  -11,
      39,   78,  -82,       41,   73,  -80,       45,   61,  -73,       51,   45,  -63,
      59,   26,  -51,       67,    7,  -38,       76,  -11,  -24,       85,  -27,  -10,
      40,   79,  -81,       42,   74,  -78,       46,   63,  -71,       52,   46,  -62,
      59,   28,  -50,       67,    9,  -37,       76,   -9,  -23,       85,  -25,  -10,
      41,   80,  -79,       43,   75,  -76,       47,   64,  -70,       52,   48,  -60,
      60,   30,  -48,       68,   11,  -36,       76,   -6,  -23,       85,  -23,   -9,
      42,   81,  -77,       44,   76,  -74,       48,   65,  -68,       53,   50,  -59,
      61,   32,  -47,       68,   13,  -35,       77,   -4,  -22,       86,  -21,   -9,
      44,   82,  -74,       45,   77,  -72,       49,   67,  -66,       54,   52,  -57,
      61,   34,  -46,       69,   16,  -34,       77,   -2,  -21,       86,  -19,   -8,
      45,   83,  -72,       46,   79,  -70,       50,   69,  -64,       55,   54,  -56,
      62,   36,  -45,       70,   18,  -33,       78,    1,  -20,       87,  -16,   -7,
      46,   84,  -70,       48,   80,  -68,       51,   70,  -62,       56,   56,  -54,
      63,   39,  -43,       70,   21,  -32,       79,    3,  -19,       87,  -14,   -6,
      48,   85,  -68,       49,   81,  -66,       52,   72,  -60,       57,   58,  -53,
      64,   41,  -42,       71,   23,  -31,       79,    6,  -18,       88,  -12,   -6,
      49,   86,  -66,       50,   82,  -64,       53,   73,  -59,       58,   60,  -51,
      65,   43,  -41,       72,   26,  -29,       80,    8,  -17,       88,   -9,   -5,
      50,   87,  -63,       52,   84,  -61,       55,   75,  -56,       59,   62,  -49,
      66,   46,  -39,       73,   28,  -28,       80,   11,  -16,       89,   -6,   -4,
      52,   88,  -61,       53,   85,  -59,       56,   77,  -54,       60,   64,  -47,
      67,   48,  -38,       73,   31,  -27,       81,   14,  -15,       89,   -4,   -3,
      53,   90,  -59,       54,   86,  -57,       57,   78,  -52,       61,   66,  -45,
      67,   50,  -36,       74,   33,  -26,       82,   16,  -14,       90,   -1,   -2,
      55,   91,  -56,       56,   88,  -55,       58,   80,  -50,       63,   68,  -44,
      68,   53,  -35,       75,   36,  -24,       82,   19,  -13,       91,    2,   -1,
      56,   92,  -54,       57,   89,  -52,       60,   82,  -48,       64,   70,  -42,
      69,   55,  -33,       76,   39,  -23,       83,   22,  -12,       91,    5,    0,
      58,   94,  -51,       59,   91,  -50,       61,   83,  -46,       65,   72,  -40,
      70,   58,  -31,       77,   41,  -21,       84,   25,  -11,       92,    7,    1,
      59,   95,  -49,       60,   92,  -48,       62,   85,  -44,       66,   74,  -38,
      72,   60,  -29,       78,   44,  -20,       85,   27,   -9,       93,   10,    2,
      30,   75, -103,       32,   68,  -99,       38,   52,  -90,       45,   32,  -77,
      54,   11,  -63,       63,   -8,  -48,       73,  -25,  -34,       82,  -40,  -19,
      30,   75, -102,       33,   68,  -98,       38,   52,  -89,       45,   32,  -77,
      54,   12,  -63,       63,   -7,  -48,       73,  -24,  -34,       82,  -40,  -19,
      30,   75, -102,       33,   68,  -98,       38,   52,  -89,       45,   33,  -77,
      54,   12,  -63,       63,   -7,  -48,       73,  -24,  -33,       83,  -40,  -19,
      30,   76, -102,       33,   68,  -98,       38,   53,  -89,       46,   33,  -77,
      54,   12,  -62,       64,   -7,  -48,       73,  -24,  -33,       83,  -40,  -19,
      31,   76, -101,       33,   68,  -97,       38,   53,  -89,       46,   33,  -77,
      55,   13,  -62,       64,   -6,  -48,       73,  -23,  -33,       83,  -39,  -18,
      31,   76, -101,       33,   69,  -97,       39,   53,  -88,       46,   34,  -76,
      55,   13,  -62,       64,   -6,  -48,       73,  -23,  -33,       83,  -39,  -18,
      32,   76, -100,       34,   69,  -96,       39,   54,  -88,       46,   35,  -76,
      55,   14,  -62,       64,   -5,  -47,       73,  -22,  -33,       83,  -38,  -18,
      32,   76,  -99,       34,   69,  -95,       39,   55,  -87,       47,   35,  -75,
      55,   15,  -61,       64,   -4,  -47,       73,  -21,  -33,       83,  -37,  -18,
      33,   76,  -98,       35,   70,  -95,       40,   55,  -86,       47,   36,  -75,
      55,   16,  -61,       64,   -3,  -47,       74,  -20,  -32,       83,  -37,  -18,
      33,   77,  -97,       35,   70,  -94,       40,   56,  -85,       47,   37,  -74,
      56,   17,  -60,       65,   -2,  -46,       74,  -19,  -32,       83,  -36,  -18,
      34,   77,  -96,       36,   71,  -92,       41,   57,  -84,       48,   38,  -73,
      56,   18,  -60,       65,   -1,  -46,       74,  -18,  -32,       83,  -34,  -17,
      35,   77,  -95,       37,   71,  -91,       42,   58,  -83,       48,   40,  -72,
      56,   19,  -59,       65,    1,  -45,       74,  -17,  -31,       84,  -33,  -17,
      36,   78,  -93,       38,   72,  -90,       42,   59,  -82,       49,   41,  -71,
      57,   21,  -58,       66,    2,  -45,       74,  -15,  -31,       84,  -32,  -16,
      37,   78,  -91,       39,   73,  -88,       43,   60,  -81,       49,   42,  -71,
      57,   23,  -58,       66,    4,  -44,       75,  -14,  -30,       84,  -30,  -16,
      38,   79,  -90,       39,   73,  -87,       44,   61,  -80,       50,   44,  -69,
      58,   24,  -57,       66,    6,  -43,       75,  -12,  -30,       84,  -29,  -16,
      39,   79,  -88,       40,   74,  -85,       45,   62,  -78,       51,   45,  -68,
      58,   26,  -56,       67,    7,  -43,       75,  -10,  -29,       85,  -27,  -15,
      40,   80,  -86,       41,   75,  -83,       46,   63,  -77,       51,   47,  -67,
      59,   28,  -55,       67,   10,  -42,       76,   -8,  -28,       85,  -25,  -15,
      41,   81,  -84,       43,   76,  -82,       46,   65,  -75,       52,   49,  -66,
      60,   30,  -54,       68,   12,  -41,       76,   -6,  -28,       85,  -23,  -14,
      42,   82,  -82,       44,   77,  -80,       47,   66,  -74,       53,   51,  -64,
      60,   32,  -53,       68,   14,  -40,       77,   -4,  -27,       86,  -21,  -14,
      43,   83,  -80,       45,   78,  -78,       48,   67,  -72,       54,   52,  -63,
      61,   34,  -52,       69,   16,  -39,       77,   -2,  -26,       86,  -19,  -13,
      45,   83,  -78,       46,   79,  -76,       50,   69,  -70,       55,   54,  -61,
      62,   36,  -50,       70,   18,  -38,       78,    1,  -25,       87,  -17,  -12,
      46,   84,  -76,       47,   80,  -74,       51,   70,  -68,       56,   56,  -60,
      63,   38,  -49,       70,   20,  -37,       78,    3,  -25,       87,  -14,  -11,
      47,   85,  -74,       48,   81,  -72,       52,   72,  -66,       57,   58,  -58,
      63,   41,  -48,       71,   23,  -36,       79,    5,  -24,       87,  -12,  -11,
      48,   86,  -72,       50,   83,  -70,       53,   73,  -65,       58,   60,  -57,
      64,   43,  -46,       71,   25,  -35,       79,    8,  -23,       88,  -10,  -10,
      50,   87,  -70,       51,   84,  -68,       54,   75,  -63,       59,   62,  -55,
      65,   45,  -45,       72,   28,  -34,       80,   10,  -22,       88,   -7,   -9,
      51,   89,  -67,       52,   85,  -65,       55,   77,  -61,       60,   64,  -53,
      66,   48,  -43,       73,   30,  -32,       81,   13,  -21,       89,   -5,   -8,
      52,   90,  -65,       54,   86,  -63,       56,   78,  -59,       61,   66,  -51,
      67,   50,  -42,       74,   33,  -31,       81,   15,  -20,       90,   -2,   -7,
      54,   91,  -63,       55,   88,  -61,       58,   80,  -57,       62,   68,  -50,
      68,   52,  -40,       75,   35,  -30,       82,   18,  -19,       90,    1,   -6,
      55,   92,  -60,       56,   89,  -59,       59,   81,  -55,       63,   70,  -48,
      69,   54,  -39,       75,   38,  -29,       83,   21,  -17,       91,    3,   -5,
      57,   94,  -58,       58,   91,  -56,       60,   83,  -52,       64,   72,  -46,
      70,   57,  -37,       76,   40,  -27,       84,   24,  -16,       91,    6,   -4,
      58,   95,  -56,       59,   92,  -54,       61,   85,  -50,       65,   74,  -44,
      71,   59,  -35,       77,   43,  -26,       84,   26,  -15,       92,    9,   -3,
      59,   96,  -53,       60,   93,  -52,       63,   86,  -48,       67,   76,  -42,
      72,   61,  -34,       78,   45,  -24,       85,   29,  -14,       93,   12,   -2,
      31,   77, -105,       33,   70, -101,       39,   55,  -93,       46,   35,  -81,
      55,   14,  -66,       64,   -5,  -52,       73,  -22,  -37,       83,  -38,  -23,
      31,   77, -105,       34,   70, -101,       39,   55,  -93,       46,   36,  -81,
      55,   15,  -66,       64,   -4,  -52,       73,  -22,  -37,       83,  -38,  -23,
      31,   77, -105,       34,   70, -101,       39,   55,  -92,       46,   36,  -80,
      55,   15,  -66,       64,   -4,  -52,       73,  -22,  -37,       83,  -38,  -22,
      32,   77, -104,       34,   71, -101,       39,   55,  -92,       46,   36,  -80,
      55,   15,  -66,       64,   -4,  -52,       73,  -21,  -37,       83,  -37,  -22,
      32,   78, -104,       34,   71, -100,       39,   56,  -92,       46,   36,  -80,
      55,   16,  -66,       64,   -3,  -52,       73,  -21,  -37,       83,  -37,  -22,
      32,   78, -103,       34,   71, -100,       40,   56,  -91,       47,   37,  -80,
      55,   16,  -66,       64,   -3,  -51,       73,  -20,  -37,       83,  -36,  -22,
      33,   78, -103,       35,   71,  -99,       40,   56,  -91,       47,   38,  -79,
      55,   17,  -65,       64,   -2,  -51,       74,  -20,  -37,       83,  -36,  -22,
      33,   78, -102,       35,   71,  -98,       40,   57,  -90,       47,   38,  -79,
      56,   18,  -65,       65,   -1,  -51,       74,  -19,  -36,       83,  -35,  -22,
      34,   78, -101,       36,   72,  -97,       41,   58,  -89,       48,   39,  -78,
      56,   19,  -64,       65,    0,  -50,       74,  -18,  -36,       83,  -34,  -22,
      34,   78, -100,       36,   72,  -96,       41,   58,  -89,       48,   40,  -77,
      56,   20,  -64,       65,    1,  -50,       74,  -17,  -36,       83,  -33,  -21,
      35,   79,  -99,       37,   73,  -95,       42,   59,  -88,       48,   41,  -77,
      57,   21,  -63,       65,    2,  -50,       74,  -16,  -36,       84,  -32,  -21,
      36,   79,  -97,       38,   73,  -94,       42,   60,  -87,       49,   42,  -76,
      57,   22,  -63,       66,    3,  -49,       74,  -14,  -35,       84,  -31,  -21,
      37,   80,  -96,       39,   74,  -93,       43,   61,  -85,       49,   44,  -75,
      57,   24,  -62,       66,    5,  -49,       75,  -13,  -35,       84,  -30,  -20,
      38,   80,  -94,       39,   75,  -91,       44,   62,  -84,       50,   45,  -74,
      58,   25,  -61,       66,    6,  -48,       75,  -11,  -34,       84,  -28,  -20,
      38,   81,  -93,       40,   75,  -90,       44,   63,  -83,       51,   46,  -73,
      58,   27,  -60,       67,    8,  -47,       75,  -10,  -34,       85,  -27,  -20,
      39,   81,  -91,       41,   76,  -88,       45,   64,  -82,       51,   48,  -72,
      59,   28,  -60,       67,   10,  -47,       76,   -8,  -33,       85,  -25,  -19,
      41,   82,  -89,       42,   77,  -87,       46,   65,  -80,       52,   49,  -71,
      60,   30,  -59,       68,   12,  -46,       76,   -6,  -32,       85,  -23,  -18,
      42,   83,  -87,       43,   78,  -85,       47,   67,  -79,       53,   51,  -69,
      60,   32,  -58,       68,   14,  -45,       77,   -4,  -32,       86,  -21,  -18,
      43,   83,  -86,       44,   79,  -83,       48,   68,  -77,       54,   53,  -68,
      61,   34,  -56,       69,   16,  -44,       77,   -2,  -31,       86,  -19,  -17,
      44,   84,  -84,       45,   80,  -81,       49,   69,  -75,       54,   54,  -67,
      61,   36,  -55,       69,   18,  -43,       77,    0,  -30,       86,  -17,  -17,
      45,   85,  -82,       47,   81,  -79,       50,   71,  -74,       55,   56,  -65,
      62,   38,  -54,       70,   20,  -42,       78,    2,  -29,       87,  -15,  -16,
      46,   86,  -79,       48,   82,  -77,       51,   72,  -72,       56,   58,  -64,
      63,   40,  -53,       70,   22,  -41,       79,    5,  -28,       87,  -13,  -15,
      48,   87,  -77,       49,   83,  -75,       52,   74,  -70,       57,   60,  -62,
      64,   42,  -52,       71,   25,  -40,       79,    7,  -28,       88,  -10,  -15,
      49,   88,  -75,       50,   84,  -73,       53,   75,  -68,       58,   62,  -60,
      65,   45,  -50,       72,   27,  -39,       80,    9,  -27,       88,   -8,  -14,
      50,   89,  -73,       51,   85,  -71,       54,   76,  -66,       59,   63,  -59,
      65,   47,  -49,       73,   29,  -38,       80,   12,  -26,       89,   -6,  -13,
      52,   90,  -71,       53,   87,  -69,       56,   78,  -64,       60,   65,  -57,
      66,   49,  -47,       73,   32,  -36,       81,   15,  -25,       89,   -3,  -12,
      53,   91,  -69,       54,   88,  -67,       57,   80,  -62,       61,   67,  -55,
      67,   51,  -46,       74,   34,  -35,       82,   17,  -24,       90,    0,  -11,
      54,   92,  -66,       55,   89,  -65,       58,   81,  -60,       62,   69,  -53,
      68,   54,  -44,       75,   37,  -34,       82,   20,  -22,       90,    2,  -10,
      56,   93,  -64,       57,   90,  -63,       59,   83,  -58,       63,   71,  -52,
      69,   56,  -43,       76,   39,  -33,       83,   22,  -21,       91,    5,   -9,
      57,   95,  -62,       58,   92,  -60,       61,   84,  -56,       65,   73,  -50,
      70,   58,  -41,       77,   42,  -31,       84,   25,  -20,       92,    8,   -8,
      58,   96,  -59,       59,   93,  -58,       62,   86,  -54,       66,   75,  -48,
      71,   60,  -39,       77,   44,  -30,       85,   28,  -19,       92,   10,   -7,
      60,   97,  -57,       61,   94,  -56,       63,   88,  -52,       67,   77,  -46,
      72,   63,  -38,       78,   47,  -28,       85,   30,  -18,       93,   13,   -6,
      32,   79, -108,       35,   72, -104,       40,   58,  -96,       47,   38,  -84,
      55,   18,  -70,       64,   -2,  -56,       73,  -19,  -41,       83,  -36,  -26,
      32,   79, -108,       35,   72, -104,       40,   58,  -96,       47,   39,  -84,
      55,   18,  -70,       64,   -1,  -56,       73,  -19,  -41,       83,  -35,  -26,
      33,   79, -107,       35,   73, -104,       40,   58,  -95,       47,   39,  -84,
      55,   18,  -70,       64,   -1,  -56,       73,  -19,  -41,       83,  -35,  -26,
      33,   79, -107,       35,   73, -103,       40,   58,  -95,       47,   39,  -84,
      55,   18,  -70,       64,   -1,  -55,       74,  -18,  -41,       83,  -35,  -26,
      33,   79, -107,       35,   73, -103,       40,   58,  -95,       47,   39,  -83,
      56,   19,  -69,       64,    0,  -55,       74,  -18,  -41,       83,  -34,  -26,
      33,   80, -106,       35,   73, -103,       40,   59,  -94,       47,   40,  -83,
      56,   19,  -69,       65,    0,  -55,       74,  -18,  -41,       83,  -34,  -26,
      34,   80, -105,       36,   73, -102,       41,   59,  -94,       48,   40,  -83,
      56,   20,  -69,       65,    1,  -55,       74,  -17,  -41,       83,  -33,  -26,
      34,   80, -105,       36,   74, -101,       41,   60,  -93,       48,   41,  -82,
      56,   21,  -69,       65,    2,  -55,       74,  -16,  -40,       83,  -33,  -26,
      35,   80, -104,       37,   74, -100,       41,   60,  -93,       48,   42,  -82,
      56,   22,  -68,       65,    2,  -54,       74,  -15,  -40,       84,  -32,  -25,
      35,   80, -103,       37,   74,  -99,       42,   61,  -92,       49,   43,  -81,
      57,   23,  -68,       65,    3,  -54,       74,  -14,  -40,       84,  -31,  -25,
      36,   81, -102,       38,   75,  -98,       42,   62,  -91,       49,   44,  -80,
      57,   24,  -67,       66,    5,  -53,       75,  -13,  -39,       84,  -30,  -25,
      37,   81, -100,       39,   75,  -97,       43,   62,  -90,       49,   45,  -79,
      57,   25,  -66,       66,    6,  -53,       75,  -12,  -39,       84,  -29,  -25,
      38,   81,  -99,       39,   76,  -96,       44,   63,  -89,       50,   46,  -78,
      58,   26,  -66,       66,    7,  -52,       75,  -10,  -38,       84,  -27,  -24,
      38,   82,  -97,       40,   76,  -95,       44,   64,  -88,       51,   47,  -78,
      58,   28,  -65,       67,    9,  -52,       75,   -9,  -38,       85,  -26,  -24,
      39,   82,  -96,       41,   77,  -93,       45,   65,  -86,       51,   49,  -77,
      59,   29,  -64,       67,   10,  -51,       76,   -7,  -37,       85,  -24,  -23,
      40,   83,  -94,       42,   78,  -92,       46,   66,  -85,       52,   50,  -75,
      59,   31,  -63,       67,   12,  -50,       76,   -6,  -37,       85,  -23,  -23,
      41,   83,  -92,       43,   79,  -90,       47,   67,  -83,       53,   52,  -74,
      60,   33,  -62,       68,   14,  -49,       77,   -4,  -36,       86,  -21,  -22,
      42,   84,  -91,       44,   80,  -88,       48,   69,  -82,       53,   53,  -73,
      61,   35,  -61,       68,   16,  -49,       77,   -2,  -35,       86,  -19,  -22,
      44,   85,  -89,       45,   80,  -86,       49,   70,  -81,       54,   55,  -72,
      61,   36,  -60,       69,   18,  -48,       77,    0,  -35,       86,  -17,  -21,
      45,   86,  -87,       46,   81,  -85,       50,   71,  -79,       55,   56,  -70,
      62,   38,  -59,       70,   20,  -47,       78,    2,  -34,       87,  -15,  -21,
      46,   86,  -85,       47,   82,  -83,       51,   72,  -77,       56,   58,  -69,
      63,   40,  -58,       70,   22,  -46,       78,    5,  -33,       87,  -13,  -20,
      47,   87,  -83,       48,   83,  -81,       52,   74,  -75,       57,   60,  -67,
      63,   42,  -57,       71,   24,  -45,       79,    7,  -32,       88,  -11,  -19,
      48,   88,  -81,       50,   84,  -79,       53,   75,  -74,       58,   62,  -66,
      64,   44,  -55,       71,   27,  -44,       79,    9,  -31,       88,   -9,  -18,
      50,   89,  -79,       51,   85,  -77,       54,   77,  -72,       59,   63,  -64,
      65,   46,  -54,       72,   29,  -43,       80,   11,  -31,       88,   -6,  -18,
      51,   90,  -77,       52,   87,  -75,       55,   78,  -70,       60,   65,  -63,
      66,   49,  -53,       73,   31,  -42,       81,   14,  -30,       89,   -4,  -17,
      52,   91,  -74,       53,   88,  -72,       56,   80,  -68,       61,   67,  -61,
      67,   51,  -51,       74,   34,  -40,       81,   16,  -28,       90,   -1,  -16,
      54,   92,  -72,       55,   89,  -70,       57,   81,  -66,       62,   69,  -59,
      68,   53,  -50,       74,   36,  -39,       82,   19,  -27,       90,    1,  -15,
      55,   93,  -70,       56,   90,  -68,       59,   83,  -64,       63,   71,  -57,
      69,   55,  -48,       75,   38,  -38,       83,   21,  -26,       91,    4,  -14,
      56,   95,  -68,       57,   92,  -66,       60,   84,  -62,       64,   72,  -55,
      69,   57,  -47,       76,   41,  -36,       83,   24,  -25,       91,    6,  -13,
      58,   96,  -65,       59,   93,  -64,       61,   86,  -60,       65,   75,  -53,
      71,   60,  -45,       77,   43,  -35,       84,   27,  -24,       92,    9,  -12,
      59,   97,  -63,       60,   94,  -62,       62,   87,  -58,       66,   76,  -52,
      72,   62,  -43,       78,   46,  -33,       85,   29,  -23,       93,   12,  -11,
      60,   98,  -61,       61,   96,  -59,       64,   89,  -56,       67,   78,  -50,
      73,   64,  -42,       79,   48,  -32,       86,   32,  -22,       93,   14,  -10,
};

const int8_t rest_lab_table[8*3] = {0,1,3,4,5,6,8,9,0,2,3,5,6,8,9,11,0,1,3,4,6,7,9,10};

//原lab_table 保留至1/8,即24KB处, 记为lab_table_small

#define TABLE_SIZE (8*1024*3)

int8_t lab_table(uint32_t idx)
{
	return lab_table_small[idx%TABLE_SIZE]+rest_lab_table[((idx%3)<<3)+(idx/TABLE_SIZE)];
}

#endif
#else
const int8_t lab_table[196608] = {
       0,    0,    0,        9,  -19,   14,       23,  -32,   31,       35,  -42,   41,
      47,  -52,   50,       58,  -61,   59,       68,  -70,   68,       79,  -79,   76,
       0,    2,    1,       10,  -16,   14,       23,  -31,   31,       35,  -42,   41,
      47,  -52,   51,       58,  -61,   59,       68,  -70,   68,       79,  -79,   76,
       1,    4,    2,       10,  -14,   15,       23,  -29,   31,       35,  -40,   41,
      47,  -51,   51,       58,  -60,   59,       69,  -69,   68,       79,  -78,   76,
       2,    8,    3,       11,   -9,   16,       24,  -26,   31,       36,  -39,   41,
      47,  -50,   51,       58,  -60,   59,       69,  -69,   68,       79,  -78,   76,
       3,   13,    5,       12,   -5,   17,       24,  -23,   32,       36,  -37,   42,
      47,  -49,   51,       58,  -59,   60,       69,  -68,   68,       79,  -77,   76,
       4,   19,    7,       13,    0,   19,       24,  -20,   33,       36,  -35,   42,
      48,  -47,   51,       58,  -57,   60,       69,  -67,   68,       79,  -76,   77,
       6,   24,    9,       14,    5,   20,       25,  -16,   33,       36,  -32,   43,
      48,  -45,   51,       59,  -56,   60,       69,  -66,   68,       79,  -76,   77,
       8,   28,   13,       15,   10,   22,       26,  -12,   34,       37,  -28,   43,
      48,  -42,   52,       59,  -54,   60,       69,  -64,   69,       80,  -74,   77,
      10,   30,   16,       16,   14,   24,       27,   -8,   35,       37,  -25,   44,
      48,  -40,   52,       59,  -52,   61,       69,  -63,   69,       80,  -73,   77,
      12,   33,   19,       18,   18,   26,       27,   -3,   36,       38,  -22,   44,
      49,  -37,   53,       59,  -50,   61,       69,  -61,   69,       80,  -72,   77,
      14,   35,   22,       19,   22,   29,       28,    1,   37,       38,  -18,   45,
      49,  -34,   53,       60,  -47,   61,       70,  -59,   69,       80,  -70,   77,
      16,   37,   25,       21,   25,   31,       29,    5,   39,       39,  -14,   46,
      50,  -31,   54,       60,  -45,   62,       70,  -57,   70,       80,  -68,   78,
      19,   40,   29,       23,   29,   33,       30,   10,   40,       40,  -10,   47,
      50,  -27,   54,       60,  -42,   62,       70,  -54,   70,       81,  -66,   78,
      21,   42,   31,       24,   32,   35,       32,   14,   41,       41,   -6,   48,
      51,  -24,   55,       61,  -39,   63,       71,  -52,   70,       81,  -64,   78,
      22,   45,   34,       26,   35,   37,       33,   17,   43,       42,   -2,   49,
      51,  -20,   56,       61,  -35,   63,       71,  -49,   71,       81,  -62,   79,
      24,   47,   37,       27,   38,   39,       34,   21,   44,       42,    2,   50,
      52,  -16,   57,       62,  -32,   64,       71,  -46,   71,       81,  -59,   79,
      26,   49,   39,       29,   41,   42,       35,   25,   46,       43,    7,   51,
      53,  -12,   58,       62,  -28,   65,       72,  -43,   72,       82,  -56,   80,
      28,   51,   42,       31,   44,   44,       37,   29,   47,       44,   10,   52,
      54,   -8,   58,       63,  -25,   65,       72,  -40,   72,       82,  -54,   80,
      30,   53,   44,       33,   47,   45,       38,   32,   49,       45,   14,   53,
      54,   -5,   59,       63,  -22,   66,       73,  -37,   73,       83,  -51,   80,
      32,   55,   46,       34,   49,   47,       39,   35,   50,       46,   18,   54,
      55,   -1,   60,       64,  -18,   67,       73,  -34,   74,       83,  -48,   81,
      34,   58,   48,       36,   52,   49,       41,   39,   52,       48,   22,   56,
      56,    3,   61,       65,  -14,   68,       74,  -30,   74,       83,  -45,   82,
      36,   60,   50,       38,   54,   51,       42,   42,   53,       49,   25,   57,
      57,    7,   62,       66,  -10,   68,       74,  -27,   75,       84,  -42,   82,
      38,   62,   52,       39,   57,   53,       44,   45,   55,       50,   29,   58,
      58,   11,   63,       66,   -7,   69,       75,  -23,   76,       84,  -39,   83,
      39,   64,   54,       41,   59,   54,       45,   48,   56,       51,   32,   60,
      59,   14,   64,       67,   -3,   70,       76,  -20,   76,       85,  -35,   83,
      41,   66,   55,       43,   61,   56,       47,   51,   58,       52,   35,   61,
      60,   18,   66,       68,    0,   71,       76,  -16,   77,       85,  -32,   84,
      43,   68,   57,       44,   64,   58,       48,   54,   59,       54,   39,   62,
      61,   22,   67,       69,    4,   72,       77,  -12,   78,       86,  -28,   85,
      45,   70,   59,       46,   66,   59,       50,   56,   61,       55,   42,   64,
      62,   25,   68,       70,    8,   73,       78,   -9,   79,       87,  -25,   85,
      46,   72,   61,       48,   68,   61,       51,   59,   62,       56,   45,   65,
      63,   29,   69,       70,   11,   74,       79,   -5,   80,       87,  -22,   86,
      48,   74,   62,       49,   70,   63,       53,   61,   64,       57,   48,   67,
      64,   32,   70,       71,   15,   75,       79,   -2,   81,       88,  -18,   87,
      50,   76,   64,       51,   73,   64,       54,   64,   66,       59,   52,   68,
      65,   35,   72,       72,   19,   76,       80,    2,   82,       89,  -15,   88,
      52,   78,   66,       53,   75,   66,       56,   67,   67,       60,   54,   69,
      66,   39,   73,       73,   22,   77,       81,    5,   83,       89,  -11,   88,
      53,   80,   67,       54,   77,   68,       57,   69,   69,       61,   57,   71,
      67,   42,   74,       74,   25,   79,       82,    9,   84,       90,   -8,   89,
       0,    1,   -3,        9,  -18,   10,       23,  -32,   27,       35,  -42,   39,
      47,  -52,   49,       58,  -61,   58,       68,  -70,   67,       79,  -79,   75,
       1,    3,   -2,       10,  -15,   11,       23,  -30,   28,       35,  -41,   39,
      47,  -51,   49,       58,  -61,   58,       68,  -70,   67,       79,  -79,   76,
       1,    6,   -1,       10,  -13,   12,       23,  -28,   28,       35,  -40,   39,
      47,  -51,   49,       58,  -60,   58,       69,  -69,   67,       79,  -78,   76,
       2,    9,    0,       11,   -8,   13,       24,  -26,   28,       36,  -38,   39,
      47,  -50,   49,       58,  -59,   58,       69,  -69,   67,       79,  -78,   76,
       3,   14,    2,       12,   -4,   14,       24,  -23,   29,       36,  -36,   39,
      47,  -48,   49,       58,  -58,   58,       69,  -68,   67,       79,  -77,   76,
       4,   20,    4,       13,    1,   16,       25,  -19,   29,       36,  -34,   40,
      48,  -47,   50,       58,  -57,   59,       69,  -67,   67,       79,  -76,   76,
       6,   25,    6,       14,    5,   17,       25,  -16,   30,       36,  -31,   40,
      48,  -45,   50,       59,  -56,   59,       69,  -66,   67,       79,  -75,   76,
       8,   28,   10,       15,   10,   19,       26,  -11,   31,       37,  -28,   41,
      48,  -42,   50,       59,  -54,   59,       69,  -64,   68,       80,  -74,   76,
      10,   31,   13,       17,   14,   21,       27,   -7,   32,       37,  -25,   41,
      48,  -40,   51,       59,  -52,   59,       69,  -63,   68,       80,  -73,   76,
      12,   33,   16,       18,   18,   23,       27,   -3,   33,       38,  -21,   42,
      49,  -37,   51,       59,  -50,   60,       70,  -61,   68,       80,  -71,   76,
      14,   35,   19,       19,   22,   25,       28,    1,   34,       38,  -18,   43,
      49,  -34,   52,       60,  -47,   60,       70,  -59,   68,       80,  -70,   77,
      16,   38,   22,       21,   25,   27,       29,    5,   35,       39,  -14,   44,
      50,  -31,   52,       60,  -45,   61,       70,  -57,   69,       80,  -68,   77,
      19,   40,   25,       23,   29,   30,       31,   10,   37,       40,   -9,   45,
      50,  -27,   53,       60,  -41,   61,       70,  -54,   69,       81,  -66,   77,
      21,   42,   28,       24,   32,   32,       32,   14,   38,       41,   -5,   46,
      51,  -23,   54,       61,  -38,   62,       71,  -52,   70,       81,  -64,   78,
      23,   45,   31,       26,   35,   34,       33,   18,   40,       42,   -2,   47,
      51,  -20,   54,       61,  -35,   62,       71,  -49,   70,       81,  -61,   78,
      24,   47,   33,       27,   38,   36,       34,   21,   41,       42,    2,   48,
      52,  -16,   55,       62,  -32,   63,       71,  -46,   70,       81,  -59,   78,
      27,   49,   36,       29,   41,   38,       35,   25,   43,       43,    7,   49,
      53,  -12,   56,       62,  -28,   63,       72,  -43,   71,       82,  -56,   79,
      28,   51,   38,       31,   44,   40,       37,   29,   44,       44,   11,   50,
      54,   -8,   57,       63,  -25,   64,       72,  -40,   72,       82,  -54,   79,
      30,   54,   41,       33,   47,   42,       38,   32,   46,       45,   14,   51,
      54,   -5,   58,       63,  -21,   65,       73,  -37,   72,       83,  -51,   80,
      32,   56,   43,       34,   49,   44,       39,   35,   47,       46,   18,   52,
      55,   -1,   59,       64,  -18,   66,       73,  -33,   73,       83,  -48,   80,
      34,   58,   45,       36,   52,   46,       41,   39,   49,       48,   22,   54,
      56,    3,   60,       65,  -14,   67,       74,  -30,   73,       83,  -45,   81,
      36,   60,   47,       38,   54,   48,       42,   42,   51,       49,   25,   55,
      57,    7,   61,       66,  -10,   67,       74,  -26,   74,       84,  -42,   81,
      38,   62,   49,       39,   57,   50,       44,   45,   52,       50,   29,   57,
      58,   11,   62,       66,   -7,   68,       75,  -23,   75,       84,  -38,   82,
      39,   64,   51,       41,   59,   52,       45,   48,   54,       51,   32,   58,
      59,   14,   63,       67,   -3,   69,       76,  -20,   76,       85,  -35,   83,
      41,   66,   53,       43,   61,   53,       47,   51,   56,       52,   36,   59,
      60,   18,   64,       68,    0,   70,       76,  -16,   76,       85,  -32,   83,
      43,   68,   55,       44,   64,   55,       48,   54,   57,       54,   39,   61,
      61,   22,   66,       69,    4,   71,       77,  -12,   77,       86,  -28,   84,
      45,   70,   56,       46,   66,   57,       50,   56,   59,       55,   42,   62,
      62,   25,   67,       70,    8,   72,       78,   -9,   78,       87,  -25,   85,
      46,   72,   58,       48,   68,   59,       51,   59,   61,       56,   45,   64,
      63,   29,   68,       70,   11,   73,       79,   -5,   79,       87,  -22,   85,
      48,   74,   60,       49,   70,   61,       53,   62,   62,       57,   48,   65,
      64,   32,   69,       71,   15,   74,       79,   -2,   80,       88,  -18,   86,
      50,   76,   62,       51,   73,   62,       54,   64,   64,       59,   52,   67,
      65,   36,   71,       72,   19,   75,       80,    2,   81,       89,  -15,   87,
      52,   78,   64,       53,   75,   64,       56,   67,   66,       60,   54,   68,
      66,   39,   72,       73,   22,   76,       81,    5,   82,       89,  -11,   88,
      53,   80,   65,       54,   77,   66,       57,   69,   67,       62,   57,   70,
      67,   42,   73,       74,   26,   78,       82,    9,   83,       90,   -8,   89,
       0,    2,   -6,       10,  -16,    7,       23,  -31,   24,       35,  -41,   36,
      47,  -52,   47,       58,  -61,   57,       68,  -70,   66,       79,  -79,   75,
       1,    4,   -6,       10,  -14,    8,       23,  -29,   24,       35,  -41,   36,
      47,  -51,   47,       58,  -60,   57,       69,  -69,   66,       79,  -78,   75,
       1,    7,   -5,       10,  -11,    8,       23,  -28,   24,       35,  -40,   36,
      47,  -50,   47,       58,  -60,   57,       69,  -69,   66,       79,  -78,   75,
       2,   11,   -4,       11,   -7,    9,       24,  -25,   25,       36,  -38,   37,
      47,  -49,   48,       58,  -59,   57,       69,  -68,   66,       79,  -78,   75,
       3,   15,   -2,       12,   -3,   11,       24,  -22,   25,       36,  -36,   37,
      47,  -48,   48,       58,  -58,   57,       69,  -68,   66,       79,  -77,   75,
       5,   21,    0,       13,    2,   12,       25,  -19,   26,       36,  -34,   37,
      48,  -46,   48,       58,  -57,   57,       69,  -67,   66,       79,  -76,   75,
       6,   26,    3,       14,    6,   14,       25,  -15,   27,       36,  -31,   38,
      48,  -44,   48,       59,  -55,   58,       69,  -66,   66,       79,  -75,   75,
       8,   29,    6,       15,   11,   16,       26,  -11,   28,       37,  -28,   38,
      48,  -42,   49,       59,  -54,   58,       69,  -64,   67,       80,  -74,   75,
      11,   31,   10,       17,   15,   18,       27,   -7,   29,       37,  -24,   39,
      48,  -39,   49,       59,  -52,   58,       69,  -62,   67,       80,  -73,   75,
      13,   33,   13,       18,   19,   20,       28,   -3,   30,       38,  -21,   40,
      49,  -37,   50,       59,  -49,   59,       70,  -61,   67,       80,  -71,   76,
      15,   36,   16,       19,   22,   22,       28,    2,   31,       39,  -17,   41,
      49,  -34,   50,       60,  -47,   59,       70,  -59,   67,       80,  -70,   76,
      17,   38,   19,       21,   26,   24,       29,    6,   32,       39,  -13,   41,
      50,  -30,   51,       60,  -44,   59,       70,  -57,   68,       80,  -68,   76,
      19,   40,   22,       23,   29,   26,       31,   10,   34,       40,   -9,   42,
      50,  -27,   51,       60,  -41,   60,       70,  -54,   68,       81,  -66,   77,
      21,   43,   25,       24,   33,   28,       32,   14,   35,       41,   -5,   43,
      51,  -23,   52,       61,  -38,   60,       71,  -51,   69,       81,  -64,   77,
      23,   45,   27,       26,   36,   30,       33,   18,   37,       42,   -1,   44,
      51,  -20,   53,       61,  -35,   61,       71,  -49,   69,       81,  -61,   77,
      24,   47,   30,       28,   38,   33,       34,   22,   38,       42,    3,   46,
      52,  -16,   54,       62,  -32,   62,       71,  -46,   69,       81,  -59,   78,
      27,   49,   32,       29,   42,   35,       35,   26,   40,       43,    7,   47,
      53,  -12,   55,       62,  -28,   62,       72,  -43,   70,       82,  -56,   78,
      28,   52,   35,       31,   44,   37,       37,   29,   42,       44,   11,   48,
      54,   -8,   55,       63,  -25,   63,       72,  -40,   71,       82,  -53,   79,
      30,   54,   37,       33,   47,   39,       38,   32,   43,       45,   14,   49,
      54,   -4,   56,       63,  -21,   64,       73,  -37,   71,       83,  -51,   79,
      32,   56,   39,       34,   49,   41,       39,   36,   45,       47,   18,   51,
      55,   -1,   57,       64,  -18,   64,       73,  -33,   72,       83,  -48,   79,
      34,   58,   42,       36,   52,   43,       41,   39,   47,       48,   22,   52,
      56,    4,   58,       65,  -14,   65,       74,  -30,   73,       83,  -45,   80,
      36,   60,   44,       38,   55,   45,       42,   42,   48,       49,   26,   53,
      57,    7,   60,       66,  -10,   66,       75,  -26,   73,       84,  -41,   81,
      38,   62,   46,       39,   57,   47,       44,   45,   50,       50,   29,   55,
      58,   11,   61,       66,   -7,   67,       75,  -23,   74,       84,  -38,   81,
      39,   64,   48,       41,   59,   49,       45,   48,   52,       51,   32,   56,
      59,   14,   62,       67,   -3,   68,       76,  -20,   75,       85,  -35,   82,
      41,   66,   50,       43,   62,   51,       47,   51,   53,       52,   36,   57,
      60,   18,   63,       68,    1,   69,       76,  -16,   75,       85,  -32,   83,
      43,   68,   52,       45,   64,   53,       48,   54,   55,       54,   39,   59,
      61,   22,   64,       69,    5,   70,       77,  -12,   76,       86,  -28,   83,
      45,   70,   54,       46,   66,   55,       50,   56,   57,       55,   42,   61,
      62,   25,   65,       70,    8,   71,       78,   -9,   77,       87,  -25,   84,
      46,   72,   56,       48,   68,   57,       51,   59,   59,       56,   45,   62,
      63,   29,   67,       70,   12,   72,       79,   -5,   78,       87,  -22,   85,
      48,   74,   58,       49,   71,   58,       53,   62,   60,       57,   48,   63,
      64,   32,   68,       71,   15,   73,       79,   -2,   79,       88,  -18,   85,
      50,   76,   60,       51,   73,   60,       54,   64,   62,       59,   52,   65,
      65,   36,   69,       72,   19,   74,       80,    2,   80,       89,  -15,   86,
      52,   78,   61,       53,   75,   62,       56,   67,   64,       60,   55,   67,
      66,   39,   71,       73,   22,   75,       81,    6,   81,       89,  -11,   87,
      53,   80,   63,       54,   77,   64,       57,   69,   65,       62,   57,   68,
      67,   42,   72,       74,   26,   77,       82,    9,   82,       90,   -8,   88,
       1,    4,  -12,       10,  -14,    1,       23,  -29,   19,       35,  -41,   33,
      47,  -51,   45,       58,  -61,   55,       68,  -69,   64,       79,  -78,   73,
       1,    7,  -11,       10,  -12,    2,       23,  -28,   19,       35,  -40,   33,
      47,  -50,   45,       58,  -60,   55,       69,  -69,   64,       79,  -78,   73,
       2,    9,  -11,       11,   -9,    3,       24,  -26,   20,       35,  -39,   33,
      47,  -50,   45,       58,  -60,   55,       69,  -69,   64,       79,  -78,   73,
       3,   13,   -9,       11,   -5,    4,       24,  -24,   20,       36,  -37,   33,
      47,  -49,   45,       58,  -59,   55,       69,  -68,   64,       79,  -77,   74,
       4,   18,   -8,       12,   -1,    5,       24,  -21,   21,       36,  -35,   34,
      47,  -47,   45,       58,  -58,   55,       69,  -67,   65,       79,  -77,   74,
       5,   23,   -5,       13,    3,    6,       25,  -18,   21,       36,  -33,   34,
      48,  -46,   45,       58,  -57,   55,       69,  -66,   65,       79,  -76,   74,
       7,   27,   -3,       14,    7,    8,       25,  -14,   22,       37,  -30,   34,
      48,  -44,   46,       59,  -55,   56,       69,  -65,   65,       79,  -75,   74,
       9,   30,    1,       16,   12,   10,       26,  -10,   23,       37,  -27,   35,
      48,  -41,   46,       59,  -53,   56,       69,  -64,   65,       80,  -74,   74,
      11,   32,    4,       17,   16,   12,       27,   -6,   24,       37,  -24,   36,
      49,  -39,   46,       59,  -51,   56,       69,  -62,   65,       80,  -73,   74,
      13,   34,    7,       18,   19,   14,       28,   -2,   25,       38,  -20,   36,
      49,  -36,   47,       59,  -49,   57,       70,  -60,   66,       80,  -71,   74,
      15,   36,   10,       20,   23,   16,       28,    2,   27,       39,  -17,   37,
      49,  -33,   48,       60,  -47,   57,       70,  -58,   66,       80,  -69,   75,
      17,   38,   13,       21,   26,   18,       29,    6,   28,       39,  -13,   38,
      50,  -30,   48,       60,  -44,   57,       70,  -56,   66,       80,  -68,   75,
      19,   41,   16,       23,   30,   21,       31,   11,   30,       40,   -9,   39,
      50,  -26,   49,       60,  -41,   58,       70,  -54,   67,       81,  -65,   75,
      21,   43,   19,       24,   33,   23,       32,   14,   31,       41,   -5,   40,
      51,  -23,   50,       61,  -38,   58,       71,  -51,   67,       81,  -63,   76,
      23,   45,   22,       26,   36,   25,       33,   18,   33,       42,   -1,   41,
      51,  -19,   50,       61,  -35,   59,       71,  -49,   67,       81,  -61,   76,
      25,   47,   24,       28,   39,   27,       34,   22,   34,       43,    3,   42,
      52,  -16,   51,       62,  -32,   60,       71,  -46,   68,       81,  -59,   76,
      27,   50,   27,       29,   42,   30,       36,   26,   36,       44,    7,   44,
      53,  -12,   52,       62,  -28,   60,       72,  -42,   69,       82,  -56,   77,
      29,   52,   30,       31,   44,   32,       37,   29,   38,       45,   11,   45,
      54,   -8,   53,       63,  -25,   61,       72,  -39,   69,       82,  -53,   77,
      30,   54,   32,       33,   47,   34,       38,   33,   39,       46,   15,   46,
      54,   -4,   54,       64,  -21,   62,       73,  -36,   70,       83,  -51,   78,
      32,   56,   34,       34,   50,   36,       39,   36,   41,       47,   18,   48,
      55,    0,   55,       64,  -18,   63,       73,  -33,   70,       83,  -48,   78,
      34,   58,   37,       36,   52,   39,       41,   39,   43,       48,   22,   49,
      56,    4,   56,       65,  -14,   64,       74,  -29,   71,       83,  -44,   79,
      36,   60,   39,       38,   55,   41,       42,   42,   45,       49,   26,   50,
      57,    7,   57,       66,  -10,   64,       75,  -26,   72,       84,  -41,   79,
      38,   62,   41,       39,   57,   43,       44,   45,   47,       50,   29,   52,
      58,   11,   58,       66,   -6,   65,       75,  -23,   72,       84,  -38,   80,
      39,   64,   44,       41,   59,   45,       45,   48,   48,       51,   33,   53,
      59,   15,   60,       67,   -3,   66,       76,  -19,   73,       85,  -35,   81,
      41,   66,   46,       43,   62,   47,       47,   51,   50,       52,   36,   55,
      60,   18,   61,       68,    1,   67,       76,  -16,   74,       85,  -32,   81,
      43,   68,   48,       45,   64,   49,       48,   54,   52,       54,   39,   56,
      61,   22,   62,       69,    5,   68,       77,  -12,   75,       86,  -28,   82,
      45,   70,   50,       46,   66,   51,       50,   57,   54,       55,   43,   58,
      62,   25,   63,       70,    8,   69,       78,   -9,   76,       87,  -25,   83,
      46,   72,   52,       48,   69,   53,       51,   59,   56,       56,   46,   59,
      63,   29,   65,       70,   12,   70,       79,   -5,   77,       87,  -22,   84,
      48,   74,   54,       49,   71,   55,       53,   62,   57,       58,   49,   61,
      64,   32,   66,       71,   15,   71,       79,   -2,   78,       88,  -18,   84,
      50,   77,   56,       51,   73,   57,       54,   64,   59,       59,   52,   63,
      65,   36,   67,       72,   19,   73,       80,    2,   79,       89,  -14,   85,
      52,   78,   58,       53,   75,   59,       56,   67,   61,       60,   55,   64,
      66,   39,   69,       73,   22,   74,       81,    6,   80,       89,  -11,   86,
      53,   80,   60,       54,   77,   61,       57,   69,   63,       62,   57,   66,
      67,   42,   70,       74,   26,   75,       82,    9,   81,       90,   -8,   87,
       1,    7,  -18,       10,  -11,   -4,       23,  -28,   14,       35,  -40,   29,
      47,  -50,   42,       58,  -60,   53,       69,  -69,   62,       79,  -78,   72,
       1,    9,  -17,       11,   -9,   -3,       23,  -26,   15,       35,  -39,   29,
      47,  -50,   42,       58,  -60,   53,       69,  -69,   62,       79,  -78,   72,
       2,   11,  -16,       11,   -6,   -3,       24,  -25,   15,       36,  -38,   29,
      47,  -49,   42,       58,  -59,   53,       69,  -68,   63,       79,  -78,   72,
       3,   15,  -15,       12,   -3,   -2,       24,  -22,   15,       36,  -36,   30,
      47,  -48,   42,       58,  -58,   53,       69,  -68,   63,       79,  -77,   72,
       4,   20,  -13,       12,    1,   -1,       24,  -20,   16,       36,  -34,   30,
      47,  -47,   42,       58,  -57,   53,       69,  -67,   63,       79,  -76,   72,
       5,   24,  -11,       13,    5,    1,       25,  -17,   17,       36,  -32,   30,
      48,  -45,   42,       58,  -56,   53,       69,  -66,   63,       79,  -76,   72,
       7,   28,   -9,       14,    8,    3,       25,  -13,   17,       37,  -30,   31,
      48,  -43,   43,       59,  -55,   53,       69,  -65,   63,       79,  -75,   72,
       9,   30,   -5,       16,   13,    5,       26,   -9,   19,       37,  -26,   31,
      48,  -41,   43,       59,  -53,   54,       69,  -63,   63,       80,  -74,   73,
      11,   33,   -2,       17,   16,    7,       27,   -5,   20,       38,  -23,   32,
      49,  -38,   44,       59,  -51,   54,       69,  -62,   63,       80,  -72,   73,
      13,   35,    1,       18,   20,    9,       28,   -1,   21,       38,  -20,   33,
      49,  -36,   44,       59,  -49,   54,       70,  -60,   64,       80,  -71,   73,
      15,   37,    4,       20,   23,   11,       29,    3,   22,       39,  -16,   34,
      49,  -33,   45,       60,  -46,   55,       70,  -58,   64,       80,  -69,   73,
      17,   39,    7,       21,   27,   13,       30,    7,   24,       39,  -12,   34,
      50,  -30,   45,       60,  -44,   55,       70,  -56,   64,       80,  -67,   73,
      19,   41,   11,       23,   30,   16,       31,   11,   25,       40,   -8,   36,
      50,  -26,   46,       60,  -41,   56,       70,  -53,   65,       81,  -65,   74,
      21,   43,   13,       25,   33,   18,       32,   15,   27,       41,   -4,   37,
      51,  -22,   47,       61,  -38,   56,       71,  -51,   65,       81,  -63,   74,
      23,   46,   16,       26,   36,   20,       33,   19,   28,       42,   -1,   38,
      52,  -19,   48,       61,  -35,   57,       71,  -48,   66,       81,  -61,   74,
      25,   48,   19,       28,   39,   23,       34,   22,   30,       43,    3,   39,
      52,  -15,   48,       62,  -31,   57,       71,  -45,   66,       81,  -59,   75,
      27,   50,   22,       30,   42,   25,       36,   26,   32,       44,    8,   40,
      53,  -11,   49,       62,  -28,   58,       72,  -42,   67,       82,  -56,   75,
      29,   52,   25,       31,   45,   27,       37,   30,   34,       45,   11,   42,
      54,   -8,   50,       63,  -24,   59,       72,  -39,   67,       82,  -53,   76,
      30,   54,   27,       33,   47,   30,       38,   33,   35,       46,   15,   43,
      54,   -4,   51,       64,  -21,   60,       73,  -36,   68,       83,  -50,   76,
      32,   56,   30,       34,   50,   32,       40,   36,   37,       47,   19,   44,
      55,    0,   52,       64,  -17,   60,       73,  -33,   69,       83,  -47,   77,
      34,   58,   32,       36,   53,   34,       41,   40,   39,       48,   23,   46,
      56,    4,   54,       65,  -13,   61,       74,  -29,   69,       83,  -44,   77,
      36,   60,   35,       38,   55,   37,       42,   43,   41,       49,   26,   47,
      57,    8,   55,       66,  -10,   62,       75,  -26,   70,       84,  -41,   78,
      38,   62,   37,       40,   57,   39,       44,   45,   43,       50,   29,   49,
      58,   11,   56,       66,   -6,   63,       75,  -23,   71,       84,  -38,   79,
      39,   64,   39,       41,   60,   41,       45,   48,   45,       51,   33,   50,
      59,   15,   57,       67,   -3,   64,       76,  -19,   72,       85,  -35,   79,
      41,   66,   42,       43,   62,   43,       47,   51,   47,       52,   36,   52,
      60,   18,   58,       68,    1,   65,       76,  -16,   72,       85,  -32,   80,
      43,   69,   44,       45,   64,   45,       48,   54,   49,       54,   40,   54,
      61,   22,   60,       69,    5,   66,       77,  -12,   73,       86,  -28,   81,
      45,   71,   46,       46,   67,   47,       50,   57,   50,       55,   43,   55,
      62,   26,   61,       70,    8,   67,       78,   -8,   74,       87,  -25,   81,
      46,   73,   48,       48,   69,   49,       51,   59,   52,       56,   46,   57,
      63,   29,   62,       71,   12,   68,       79,   -5,   75,       87,  -21,   82,
      48,   74,   50,       49,   71,   51,       53,   62,   54,       58,   49,   58,
      64,   32,   64,       71,   15,   70,       79,   -1,   76,       88,  -18,   83,
      50,   77,   53,       51,   73,   54,       54,   65,   56,       59,   52,   60,
      65,   36,   65,       72,   19,   71,       80,    2,   77,       89,  -14,   84,
      52,   79,   55,       53,   75,   56,       56,   67,   58,       60,   55,   62,
      66,   39,   66,       73,   23,   72,       81,    6,   78,       89,  -11,   85,
      53,   80,   57,       54,   77,   58,       57,   69,   60,       62,   58,   63,
      68,   42,   68,       74,   26,   73,       82,    9,   79,       90,   -8,   85,
       1,   10,  -24,       11,   -8,   -9,       23,  -26,    9,       35,  -38,   25,
      47,  -50,   38,       58,  -59,   50,       69,  -69,   60,       79,  -78,   70,
       2,   12,  -23,       11,   -6,   -9,       24,  -24,   10,       36,  -38,   25,
      47,  -49,   38,       58,  -59,   50,       69,  -68,   60,       79,  -77,   70,
       2,   15,  -22,       11,   -4,   -8,       24,  -23,   10,       36,  -37,   25,
      47,  -48,   39,       58,  -58,   50,       69,  -68,   60,       79,  -77,   70,
       3,   19,  -21,       12,    0,   -7,       24,  -21,   11,       36,  -35,   25,
      47,  -47,   39,       58,  -58,   50,       69,  -67,   60,       79,  -77,   70,
       4,   23,  -19,       13,    3,   -6,       25,  -18,   11,       36,  -33,   26,
      48,  -46,   39,       58,  -57,   50,       69,  -67,   61,       79,  -76,   70,
       6,   26,  -17,       14,    6,   -4,       25,  -15,   12,       36,  -31,   26,
      48,  -44,   39,       58,  -56,   50,       69,  -66,   61,       79,  -75,   70,
       7,   29,  -14,       15,   10,   -3,       26,  -12,   13,       37,  -29,   27,
      48,  -43,   40,       59,  -54,   51,       69,  -64,   61,       79,  -74,   71,
       9,   31,  -10,       16,   14,   -1,       26,   -8,   14,       37,  -25,   27,
      48,  -40,   40,       59,  -52,   51,       69,  -63,   61,       80,  -73,   71,
      11,   33,   -7,       17,   18,    1,       27,   -4,   15,       38,  -22,   28,
      49,  -38,   40,       59,  -50,   51,       69,  -61,   61,       80,  -72,   71,
      13,   35,   -4,       19,   21,    3,       28,    0,   16,       38,  -19,   29,
      49,  -35,   41,       59,  -48,   52,       70,  -60,   62,       80,  -70,   71,
      15,   37,   -1,       20,   24,    6,       29,    4,   17,       39,  -15,   30,
      49,  -32,   41,       60,  -46,   52,       70,  -58,   62,       80,  -69,   71,
      17,   40,    2,       21,   28,    8,       30,    8,   19,       39,  -12,   31,
      50,  -29,   42,       60,  -43,   53,       70,  -56,   62,       80,  -67,   72,
      19,   42,    5,       23,   31,   11,       31,   12,   21,       40,   -8,   32,
      50,  -25,   43,       60,  -40,   53,       70,  -53,   63,       81,  -65,   72,
      21,   44,    8,       25,   34,   13,       32,   16,   22,       41,   -4,   33,
      51,  -22,   44,       61,  -37,   54,       71,  -51,   63,       81,  -63,   72,
      23,   46,   11,       26,   37,   15,       33,   19,   24,       42,    0,   34,
      52,  -18,   44,       61,  -34,   54,       71,  -48,   64,       81,  -61,   73,
      25,   48,   14,       28,   40,   18,       34,   23,   26,       43,    4,   35,
      52,  -15,   45,       62,  -31,   55,       72,  -45,   64,       81,  -58,   73,
      27,   50,   17,       30,   43,   20,       36,   27,   28,       44,    8,   37,
      53,  -11,   46,       62,  -27,   56,       72,  -42,   65,       82,  -55,   74,
      29,   52,   19,       31,   45,   23,       37,   30,   29,       45,   12,   38,
      54,   -7,   47,       63,  -24,   56,       72,  -39,   65,       82,  -53,   74,
      31,   54,   22,       33,   48,   25,       38,   33,   31,       46,   15,   39,
      54,   -3,   48,       64,  -20,   57,       73,  -36,   66,       83,  -50,   75,
      32,   56,   25,       35,   50,   27,       40,   36,   33,       47,   19,   41,
      55,    0,   49,       64,  -17,   58,       73,  -33,   66,       83,  -47,   75,
      34,   59,   27,       36,   53,   30,       41,   40,   35,       48,   23,   42,
      56,    4,   51,       65,  -13,   59,       74,  -29,   67,       83,  -44,   76,
      36,   61,   30,       38,   55,   32,       42,   43,   37,       49,   26,   44,
      57,    8,   52,       66,   -9,   60,       75,  -26,   68,       84,  -41,   76,
      38,   63,   32,       40,   58,   34,       44,   46,   39,       50,   30,   45,
      58,   12,   53,       66,   -6,   61,       75,  -22,   69,       84,  -38,   77,
      40,   65,   35,       41,   60,   37,       45,   49,   41,       51,   33,   47,
      59,   15,   54,       67,   -2,   62,       76,  -19,   70,       85,  -35,   78,
      41,   67,   37,       43,   62,   39,       47,   51,   43,       52,   36,   48,
      60,   19,   55,       68,    1,   63,       76,  -15,   70,       85,  -31,   78,
      43,   69,   40,       45,   65,   41,       48,   54,   45,       54,   40,   50,
      61,   22,   57,       69,    5,   64,       77,  -12,   71,       86,  -28,   79,
      45,   71,   42,       46,   67,   43,       50,   57,   47,       55,   43,   52,
      62,   26,   58,       70,    9,   65,       78,   -8,   72,       87,  -24,   80,
      47,   73,   44,       48,   69,   45,       51,   60,   49,       56,   46,   53,
      63,   29,   59,       71,   12,   66,       79,   -5,   73,       87,  -21,   80,
      48,   75,   46,       50,   71,   48,       53,   62,   51,       58,   49,   55,
      64,   32,   61,       71,   16,   67,       79,   -1,   74,       88,  -18,   81,
      50,   77,   49,       51,   73,   50,       54,   65,   53,       59,   52,   57,
      65,   36,   62,       72,   19,   68,       80,    3,   75,       89,  -14,   82,
      52,   79,   51,       53,   75,   52,       56,   67,   54,       60,   55,   58,
      66,   39,   64,       73,   23,   70,       81,    6,   76,       89,  -11,   83,
      53,   81,   53,       55,   77,   54,       57,   70,   56,       62,   58,   60,
      68,   42,   65,       74,   26,   71,       82,    9,   77,       90,   -7,   84,
       2,   14,  -29,       11,   -4,  -15,       24,  -23,    5,       36,  -37,   21,
      47,  -49,   35,       58,  -59,   47,       69,  -68,   58,       79,  -77,   68,
       2,   16,  -28,       11,   -2,  -14,       24,  -22,    5,       36,  -36,   21,
      47,  -48,   35,       58,  -58,   47,       69,  -68,   58,       79,  -77,   68,
       3,   19,  -27,       12,    0,  -13,       24,  -21,    5,       36,  -35,   21,
      47,  -47,   35,       58,  -58,   47,       69,  -67,   58,       79,  -77,   68,
       4,   22,  -26,       12,    2,  -12,       24,  -19,    6,       36,  -34,   21,
      47,  -46,   35,       58,  -57,   47,       69,  -67,   58,       79,  -76,   68,
       5,   26,  -24,       13,    5,  -11,       25,  -16,    6,       36,  -32,   21,
      48,  -45,   35,       58,  -56,   47,       69,  -66,   58,       79,  -76,   68,
       6,   29,  -22,       14,    8,  -10,       25,  -13,    7,       36,  -30,   22,
      48,  -43,   36,       59,  -55,   47,       69,  -65,   58,       79,  -75,   68,
       8,   31,  -19,       15,   12,   -8,       26,  -10,    8,       37,  -27,   22,
      48,  -42,   36,       59,  -53,   48,       69,  -64,   58,       80,  -74,   68,
      10,   33,  -16,       16,   16,   -6,       26,   -6,    9,       37,  -24,   23,
      48,  -39,   36,       59,  -51,   48,       69,  -62,   59,       80,  -73,   69,
      12,   35,  -13,       18,   19,   -4,       27,   -3,   10,       38,  -21,   24,
      49,  -37,   37,       59,  -50,   48,       69,  -61,   59,       80,  -71,   69,
      14,   36,  -10,       19,   22,   -2,       28,    1,   11,       38,  -18,   25,
      49,  -34,   37,       59,  -47,   49,       70,  -59,   59,       80,  -70,   69,
      16,   38,   -7,       20,   25,    0,       29,    5,   13,       39,  -14,   25,
      49,  -31,   38,       60,  -45,   49,       70,  -57,   59,       80,  -68,   69,
      17,   40,   -4,       22,   28,    3,       30,    9,   14,       39,  -11,   26,
      50,  -28,   39,       60,  -43,   50,       70,  -55,   60,       80,  -67,   70,
      20,   43,    0,       23,   32,    5,       31,   13,   16,       40,   -7,   27,
      50,  -25,   39,       61,  -39,   50,       70,  -53,   60,       81,  -65,   70,
      21,   45,    3,       25,   35,    8,       32,   16,   17,       41,   -3,   29,
      51,  -21,   40,       61,  -37,   51,       71,  -50,   61,       81,  -62,   70,
      23,   47,    6,       26,   37,   10,       33,   20,   19,       42,    1,   30,
      52,  -18,   41,       61,  -34,   51,       71,  -47,   61,       81,  -60,   71,
      25,   49,    8,       28,   40,   12,       34,   23,   21,       43,    4,   31,
      52,  -14,   42,       62,  -30,   52,       72,  -45,   62,       81,  -58,   71,
      27,   51,   12,       30,   43,   15,       36,   27,   23,       44,    9,   32,
      53,  -10,   43,       62,  -27,   53,       72,  -41,   62,       82,  -55,   71,
      29,   53,   14,       31,   46,   18,       37,   31,   25,       45,   12,   34,
      54,   -7,   44,       63,  -23,   53,       72,  -38,   63,       82,  -52,   72,
      31,   55,   17,       33,   48,   20,       38,   34,   27,       46,   16,   35,
      55,   -3,   45,       64,  -20,   54,       73,  -35,   63,       83,  -50,   72,
      32,   57,   20,       35,   51,   22,       40,   37,   29,       47,   19,   37,
      55,    1,   46,       64,  -17,   55,       73,  -32,   64,       83,  -47,   73,
      34,   59,   23,       36,   53,   25,       41,   40,   31,       48,   23,   38,
      56,    5,   47,       65,  -13,   56,       74,  -29,   65,       84,  -44,   74,
      36,   61,   25,       38,   56,   27,       43,   43,   33,       49,   27,   40,
      57,    8,   48,       66,   -9,   57,       75,  -25,   66,       84,  -41,   74,
      38,   63,   28,       40,   58,   30,       44,   46,   35,       50,   30,   41,
      58,   12,   50,       66,   -6,   58,       75,  -22,   66,       84,  -37,   75,
      40,   65,   30,       41,   60,   32,       45,   49,   37,       51,   33,   43,
      59,   15,   51,       67,   -2,   59,       76,  -19,   67,       85,  -34,   75,
      41,   67,   32,       43,   62,   34,       47,   52,   38,       53,   37,   45,
      60,   19,   52,       68,    1,   60,       76,  -15,   68,       86,  -31,   76,
      43,   69,   35,       45,   65,   37,       48,   55,   41,       54,   40,   46,
      61,   23,   54,       69,    5,   61,       77,  -11,   69,       86,  -28,   77,
      45,   71,   37,       46,   67,   39,       50,   57,   43,       55,   43,   48,
      62,   26,   55,       70,    9,   62,       78,   -8,   70,       87,  -24,   78,
      47,   73,   40,       48,   69,   41,       51,   60,   45,       56,   46,   50,
      63,   29,   56,       71,   12,   63,       79,   -4,   71,       87,  -21,   78,
      48,   75,   42,       50,   71,   43,       53,   62,   47,       58,   49,   51,
      64,   33,   58,       71,   16,   65,       79,   -1,   72,       88,  -18,   79,
      50,   77,   45,       51,   74,   46,       54,   65,   49,       59,   52,   53,
      65,   36,   59,       73,   20,   66,       80,    3,   73,       89,  -14,   80,
      52,   79,   47,       53,   76,   48,       56,   67,   51,       60,   55,   55,
      66,   40,   61,       73,   23,   67,       81,    6,   74,       89,  -11,   81,
      53,   81,   49,       55,   78,   50,       57,   70,   53,       62,   58,   57,
      68,   43,   62,       74,   26,   68,       82,   10,   75,       90,   -7,   82,
       3,   19,  -34,       12,    0,  -20,       24,  -21,   -1,       36,  -35,   15,
      47,  -47,   30,       58,  -58,   43,       69,  -67,   54,       79,  -77,   65,
       3,   21,  -33,       12,    2,  -19,       24,  -19,   -1,       36,  -34,   16,
      47,  -47,   30,       58,  -57,   43,       69,  -67,   54,       79,  -76,   65,
       4,   24,  -33,       12,    3,  -19,       24,  -18,    0,       36,  -33,   16,
      47,  -46,   31,       58,  -57,   43,       69,  -67,   55,       79,  -76,   65,
       5,   26,  -31,       13,    6,  -18,       25,  -16,    0,       36,  -32,   16,
      48,  -45,   31,       58,  -56,   43,       69,  -66,   55,       79,  -76,   65,
       6,   29,  -29,       14,    8,  -17,       25,  -14,    1,       36,  -30,   16,
      48,  -44,   31,       58,  -55,   43,       69,  -65,   55,       79,  -75,   65,
       7,   31,  -27,       14,   11,  -15,       25,  -11,    1,       37,  -28,   17,
      48,  -42,   31,       59,  -54,   44,       69,  -64,   55,       79,  -74,   66,
       9,   33,  -24,       15,   14,  -14,       26,   -8,    2,       37,  -26,   17,
      48,  -40,   32,       59,  -52,   44,       69,  -63,   55,       80,  -73,   66,
      11,   34,  -21,       17,   18,  -12,       27,   -5,    3,       37,  -23,   18,
      48,  -38,   32,       59,  -51,   44,       69,  -62,   55,       80,  -72,   66,
      12,   36,  -18,       18,   21,  -10,       27,   -1,    4,       38,  -20,   19,
      49,  -36,   32,       59,  -49,   44,       70,  -60,   56,       80,  -71,   66,
      14,   38,  -15,       19,   24,   -8,       28,    3,    6,       38,  -17,   20,
      49,  -33,   33,       60,  -47,   45,       70,  -58,   56,       80,  -69,   66,
      16,   39,  -12,       21,   27,   -5,       29,    6,    7,       39,  -13,   20,
      50,  -30,   34,       60,  -44,   45,       70,  -57,   56,       80,  -68,   67,
      18,   41,   -9,       22,   30,   -3,       30,   10,    9,       40,  -10,   21,
      50,  -27,   34,       60,  -42,   46,       70,  -54,   57,       80,  -66,   67,
      20,   43,   -6,       24,   33,    0,       31,   14,   10,       40,   -6,   23,
      51,  -24,   35,       61,  -39,   46,       71,  -52,   57,       81,  -64,   67,
      22,   45,   -3,       25,   36,    2,       32,   17,   12,       41,   -2,   24,
      51,  -20,   36,       61,  -36,   47,       71,  -49,   57,       81,  -62,   68,
      24,   47,    0,       27,   38,    4,       33,   21,   14,       42,    2,   25,
      52,  -17,   37,       61,  -33,   48,       71,  -47,   58,       81,  -60,   68,
      25,   49,    3,       28,   41,    7,       35,   24,   15,       43,    5,   26,
      52,  -13,   38,       62,  -30,   48,       72,  -44,   58,       82,  -57,   68,
      27,   51,    6,       30,   44,    9,       36,   28,   18,       44,    9,   28,
      53,  -10,   39,       63,  -26,   49,       72,  -41,   59,       82,  -55,   69,
      29,   53,    8,       32,   46,   12,       37,   31,   19,       45,   13,   29,
      54,   -6,   40,       63,  -23,   50,       73,  -38,   60,       82,  -52,   69,
      31,   55,   11,       33,   49,   14,       39,   34,   21,       46,   17,   30,
      55,   -2,   41,       64,  -19,   51,       73,  -35,   60,       83,  -49,   70,
      33,   57,   14,       35,   51,   17,       40,   37,   23,       47,   20,   32,
      55,    1,   42,       64,  -16,   51,       74,  -32,   61,       83,  -46,   70,
      35,   60,   17,       37,   54,   19,       41,   41,   26,       48,   24,   34,
      56,    5,   43,       65,  -12,   52,       74,  -28,   62,       84,  -43,   71,
      36,   61,   19,       38,   56,   22,       43,   44,   27,       49,   27,   35,
      57,    9,   44,       66,   -9,   53,       75,  -25,   62,       84,  -40,   72,
      38,   63,   22,       40,   58,   24,       44,   47,   29,       50,   31,   37,
      58,   12,   46,       66,   -5,   54,       75,  -22,   63,       85,  -37,   72,
      40,   65,   25,       41,   61,   27,       46,   49,   32,       51,   34,   38,
      59,   16,   47,       67,   -2,   55,       76,  -18,   64,       85,  -34,   73,
      41,   67,   27,       43,   63,   29,       47,   52,   34,       53,   37,   40,
      60,   19,   48,       68,    2,   56,       77,  -15,   65,       86,  -31,   74,
      43,   69,   30,       45,   65,   32,       49,   55,   36,       54,   41,   42,
      61,   23,   50,       69,    6,   58,       77,  -11,   66,       86,  -27,   74,
      45,   71,   32,       46,   67,   34,       50,   58,   38,       55,   44,   44,
      62,   27,   51,       70,    9,   59,       78,   -8,   67,       87,  -24,   75,
      47,   73,   35,       48,   69,   36,       51,   60,   40,       56,   47,   45,
      63,   30,   52,       71,   13,   60,       79,   -4,   68,       87,  -21,   76,
      48,   75,   37,       50,   71,   38,       53,   63,   42,       58,   49,   47,
      64,   33,   54,       72,   16,   61,       79,   -1,   69,       88,  -17,   77,
      50,   77,   40,       51,   74,   41,       54,   65,   44,       59,   53,   49,
      65,   37,   55,       73,   20,   62,       80,    3,   70,       89,  -14,   78,
      52,   79,   42,       53,   76,   43,       56,   68,   46,       60,   55,   51,
      67,   40,   57,       73,   23,   64,       81,    7,   71,       89,  -10,   78,
      54,   81,   44,       55,   78,   45,       57,   70,   48,       62,   58,   53,
      68,   43,   58,       74,   27,   65,       82,   10,   72,       90,   -7,   79,
       4,   25,  -39,       12,    4,  -25,       24,  -18,   -6,       36,  -33,   11,
      47,  -46,   26,       58,  -57,   39,       69,  -66,   51,       79,  -76,   62,
       4,   26,  -38,       12,    5,  -24,       24,  -17,   -6,       36,  -32,   11,
      48,  -45,   26,       58,  -56,   39,       69,  -66,   51,       79,  -76,   62,
       5,   28,  -37,       13,    7,  -24,       25,  -15,   -5,       36,  -31,   11,
      48,  -45,   26,       58,  -56,   40,       69,  -66,   51,       79,  -75,   63,
       5,   30,  -36,       13,    9,  -23,       25,  -14,   -5,       36,  -30,   11,
      48,  -44,   27,       58,  -55,   40,       69,  -65,   51,       79,  -75,   63,
       6,   32,  -34,       14,   11,  -21,       25,  -11,   -4,       36,  -28,   12,
      48,  -42,   27,       59,  -54,   40,       69,  -64,   52,       79,  -74,   63,
       8,   33,  -32,       15,   14,  -20,       26,   -9,   -4,       37,  -26,   12,
      48,  -41,   27,       59,  -53,   40,       69,  -64,   52,       80,  -74,   63,
       9,   34,  -29,       16,   16,  -19,       26,   -6,   -3,       37,  -24,   13,
      48,  -39,   27,       59,  -51,   40,       69,  -62,   52,       80,  -73,   63,
      11,   36,  -26,       17,   19,  -17,       27,   -3,   -2,       38,  -21,   13,
      49,  -37,   28,       59,  -50,   41,       69,  -61,   52,       80,  -72,   63,
      13,   37,  -23,       18,   22,  -15,       28,    1,    0,       38,  -18,   14,
      49,  -35,   28,       59,  -48,   41,       70,  -59,   52,       80,  -70,   63,
      15,   39,  -20,       20,   25,  -13,       28,    4,    1,       39,  -15,   15,
      49,  -32,   29,       60,  -46,   41,       70,  -58,   53,       80,  -69,   64,
      16,   41,  -17,       21,   28,  -10,       29,    8,    2,       39,  -12,   16,
      50,  -29,   29,       60,  -43,   42,       70,  -56,   53,       80,  -67,   64,
      18,   42,  -14,       22,   31,   -8,       30,   11,    4,       40,   -9,   17,
      50,  -26,   30,       60,  -41,   42,       70,  -54,   53,       80,  -66,   64,
      20,   44,  -11,       24,   34,   -5,       31,   15,    5,       41,   -5,   18,
      51,  -23,   31,       61,  -38,   43,       71,  -51,   54,       81,  -63,   64,
      22,   46,   -8,       25,   37,   -3,       32,   18,    7,       41,   -1,   19,
      51,  -19,   32,       61,  -35,   43,       71,  -49,   54,       81,  -61,   65,
      24,   48,   -5,       27,   39,   -1,       34,   22,    9,       42,    3,   20,
      52,  -16,   33,       62,  -32,   44,       71,  -46,   55,       81,  -59,   65,
      26,   50,   -3,       28,   42,    2,       35,   25,   11,       43,    6,   22,
      52,  -13,   34,       62,  -29,   45,       72,  -44,   55,       82,  -57,   66,
      28,   52,    1,       30,   44,    4,       36,   29,   13,       44,   10,   23,
      53,   -9,   35,       63,  -25,   46,       72,  -40,   56,       82,  -54,   66,
      29,   54,    3,       32,   47,    7,       37,   32,   15,       45,   14,   25,
      54,   -5,   36,       63,  -22,   46,       73,  -37,   57,       82,  -51,   67,
      31,   56,    6,       33,   49,    9,       39,   35,   17,       46,   17,   26,
      55,   -2,   37,       64,  -19,   47,       73,  -34,   57,       83,  -49,   67,
      33,   58,    9,       35,   52,   12,       40,   38,   19,       47,   21,   28,
      56,    2,   38,       64,  -15,   48,       74,  -31,   58,       83,  -46,   68,
      35,   60,   12,       37,   54,   15,       41,   41,   21,       48,   25,   29,
      56,    6,   39,       65,  -12,   49,       74,  -28,   59,       84,  -43,   68,
      37,   62,   14,       38,   57,   17,       43,   44,   23,       49,   28,   31,
      57,    9,   40,       66,   -8,   50,       75,  -24,   59,       84,  -40,   69,
      38,   64,   17,       40,   59,   19,       44,   47,   25,       50,   31,   33,
      58,   13,   42,       67,   -5,   51,       75,  -21,   60,       85,  -37,   70,
      40,   66,   20,       42,   61,   22,       46,   50,   27,       52,   34,   34,
      59,   16,   43,       67,   -1,   52,       76,  -18,   61,       85,  -34,   70,
      42,   68,   22,       43,   63,   24,       47,   52,   29,       53,   38,   36,
      60,   20,   44,       68,    2,   53,       77,  -14,   62,       86,  -30,   71,
      44,   70,   25,       45,   66,   27,       49,   55,   31,       54,   41,   38,
      61,   24,   46,       69,    6,   54,       77,  -11,   63,       86,  -27,   72,
      45,   72,   27,       47,   68,   29,       50,   58,   33,       55,   44,   40,
      62,   27,   47,       70,   10,   55,       78,   -7,   64,       87,  -24,   73,
      47,   74,   30,       48,   70,   32,       52,   60,   35,       57,   47,   41,
      63,   30,   49,       71,   13,   57,       79,   -4,   65,       87,  -20,   73,
      49,   75,   32,       50,   72,   34,       53,   63,   37,       58,   50,   43,
      64,   33,   50,       72,   17,   58,       79,    0,   66,       88,  -17,   74,
      50,   78,   35,       52,   74,   36,       55,   66,   40,       59,   53,   45,
      66,   37,   52,       73,   20,   59,       80,    3,   67,       89,  -13,   75,
      52,   79,   37,       53,   76,   39,       56,   68,   42,       61,   56,   47,
      67,   40,   53,       74,   24,   60,       81,    7,   68,       89,  -10,   76,
      54,   81,   40,       55,   78,   41,       57,   70,   44,       62,   59,   49,
      68,   43,   55,       75,   27,   62,       82,   10,   69,       90,   -7,   77,
       4,   29,  -43,       13,    8,  -29,       25,  -15,  -11,       36,  -31,    6,
      48,  -44,   22,       58,  -55,   36,       69,  -66,   48,       79,  -75,   59,
       5,   30,  -42,       13,    9,  -29,       25,  -14,  -10,       36,  -30,    6,
      48,  -44,   22,       58,  -55,   36,       69,  -65,   48,       79,  -75,   60,
       5,   31,  -41,       13,   10,  -28,       25,  -13,  -10,       36,  -29,    7,
      48,  -43,   22,       58,  -55,   36,       69,  -65,   48,       79,  -75,   60,
       6,   33,  -40,       14,   12,  -27,       25,  -11,  -10,       36,  -28,    7,
      48,  -42,   22,       59,  -54,   36,       69,  -64,   48,       79,  -74,   60,
       7,   34,  -38,       15,   14,  -26,       26,   -9,   -9,       37,  -26,    7,
      48,  -41,   23,       59,  -53,   36,       69,  -64,   48,       79,  -74,   60,
       9,   35,  -36,       15,   16,  -25,       26,   -7,   -8,       37,  -25,    8,
      48,  -40,   23,       59,  -52,   36,       69,  -63,   48,       80,  -73,   60,
      10,   36,  -33,       16,   19,  -23,       27,   -4,   -8,       37,  -22,    8,
      48,  -38,   23,       59,  -50,   36,       69,  -62,   49,       80,  -72,   60,
      12,   37,  -30,       18,   22,  -21,       27,   -1,   -6,       38,  -20,    9,
      49,  -36,   24,       59,  -49,   37,       69,  -60,   49,       80,  -71,   60,
      14,   39,  -28,       19,   24,  -19,       28,    3,   -5,       38,  -17,   10,
      49,  -33,   24,       59,  -47,   37,       70,  -59,   49,       80,  -70,   60,
      15,   40,  -25,       20,   27,  -17,       29,    6,   -4,       39,  -14,   10,
      49,  -31,   25,       60,  -45,   38,       70,  -57,   49,       80,  -68,   61,
      17,   42,  -22,       21,   29,  -15,       30,    9,   -3,       39,  -11,   11,
      50,  -28,   25,       60,  -42,   38,       70,  -55,   50,       80,  -67,   61,
      19,   43,  -19,       23,   32,  -13,       31,   12,   -1,       40,   -7,   12,
      50,  -25,   26,       60,  -40,   38,       70,  -53,   50,       81,  -65,   61,
      21,   45,  -16,       24,   35,  -10,       32,   16,    1,       41,   -3,   13,
      51,  -22,   27,       61,  -37,   39,       71,  -50,   51,       81,  -63,   62,
      22,   47,  -13,       26,   38,   -8,       33,   20,    2,       41,    0,   15,
      51,  -18,   28,       61,  -34,   40,       71,  -48,   51,       81,  -61,   62,
      24,   49,  -10,       27,   40,   -6,       34,   23,    4,       42,    4,   16,
      52,  -15,   28,       62,  -31,   40,       71,  -45,   51,       81,  -59,   62,
      26,   51,   -7,       29,   43,   -3,       35,   26,    6,       43,    7,   17,
      53,  -12,   29,       62,  -28,   41,       72,  -43,   52,       82,  -56,   63,
      28,   53,   -4,       30,   45,    0,       36,   30,    8,       44,   11,   19,
      53,   -8,   31,       63,  -25,   42,       72,  -40,   53,       82,  -53,   63,
      30,   55,   -2,       32,   48,    2,       38,   33,   10,       45,   15,   20,
      54,   -4,   32,       63,  -21,   43,       73,  -37,   53,       82,  -51,   64,
      31,   57,    1,       34,   50,    4,       39,   36,   12,       46,   18,   22,
      55,   -1,   33,       64,  -18,   43,       73,  -34,   54,       83,  -48,   64,
      33,   58,    4,       35,   52,    7,       40,   39,   14,       47,   21,   23,
      56,    3,   34,       64,  -15,   44,       74,  -31,   55,       83,  -45,   65,
      35,   61,    7,       37,   55,   10,       42,   42,   16,       48,   25,   25,
      57,    7,   35,       65,  -11,   45,       74,  -27,   55,       84,  -42,   65,
      37,   62,   10,       39,   57,   12,       43,   45,   18,       49,   28,   26,
      57,   10,   36,       66,   -7,   46,       75,  -24,   56,       84,  -39,   66,
      38,   64,   12,       40,   59,   15,       44,   48,   20,       51,   32,   28,
      58,   13,   38,       67,   -4,   47,       75,  -21,   57,       85,  -36,   67,
      40,   66,   15,       42,   61,   17,       46,   50,   22,       52,   35,   30,
      59,   17,   39,       67,   -1,   48,       76,  -17,   58,       85,  -33,   67,
      42,   68,   17,       43,   64,   19,       47,   53,   24,       53,   38,   32,
      60,   20,   40,       68,    3,   50,       77,  -14,   59,       86,  -30,   68,
      44,   70,   20,       45,   66,   22,       49,   56,   27,       54,   41,   34,
      61,   24,   42,       69,    7,   51,       77,  -10,   60,       86,  -26,   69,
      45,   72,   23,       47,   68,   24,       50,   58,   29,       55,   44,   35,
      62,   27,   43,       70,   10,   52,       78,   -7,   61,       87,  -23,   70,
      47,   74,   25,       48,   70,   27,       52,   61,   31,       57,   47,   37,
      63,   31,   45,       71,   14,   53,       79,   -3,   62,       87,  -20,   71,
      49,   76,   28,       50,   72,   29,       53,   63,   33,       58,   50,   39,
      64,   34,   46,       72,   17,   54,       80,    0,   63,       88,  -17,   71,
      51,   78,   30,       52,   74,   32,       55,   66,   35,       59,   53,   41,
      66,   37,   48,       73,   21,   56,       80,    4,   64,       89,  -13,   72,
      52,   80,   33,       53,   76,   34,       56,   68,   37,       61,   56,   43,
      67,   41,   50,       74,   24,   57,       81,    7,   65,       89,  -10,   73,
      54,   82,   35,       55,   78,   36,       58,   71,   40,       62,   59,   45,
      68,   44,   51,       75,   27,   58,       82,   11,   66,       90,   -6,   74,
       6,   33,  -47,       13,   12,  -34,       25,  -11,  -15,       36,  -29,    2,
      48,  -43,   18,       58,  -54,   32,       69,  -65,   44,       79,  -74,   56,
       6,   34,  -46,       14,   13,  -33,       25,  -11,  -15,       36,  -28,    2,
      48,  -42,   18,       59,  -54,   32,       69,  -64,   44,       79,  -74,   56,
       6,   35,  -45,       14,   14,  -33,       25,  -10,  -15,       36,  -27,    2,
      48,  -41,   18,       59,  -53,   32,       69,  -64,   44,       79,  -74,   56,
       7,   36,  -44,       15,   15,  -32,       26,   -8,  -14,       37,  -26,    2,
      48,  -40,   18,       59,  -53,   32,       69,  -63,   45,       79,  -73,   57,
       8,   36,  -42,       15,   17,  -31,       26,   -6,  -14,       37,  -24,    3,
      48,  -39,   18,       59,  -52,   32,       69,  -63,   45,       80,  -73,   57,
      10,   37,  -40,       16,   19,  -29,       26,   -4,  -13,       37,  -23,    3,
      48,  -38,   19,       59,  -51,   32,       69,  -62,   45,       80,  -72,   57,
      11,   38,  -37,       17,   21,  -28,       27,   -1,  -12,       38,  -20,    4,
      49,  -36,   19,       59,  -49,   33,       69,  -61,   45,       80,  -71,   57,
      13,   39,  -35,       18,   24,  -26,       28,    2,  -11,       38,  -18,    4,
      49,  -34,   19,       59,  -47,   33,       70,  -59,   45,       80,  -70,   57,
      14,   40,  -32,       19,   26,  -24,       28,    5,  -10,       38,  -15,    5,
      49,  -32,   20,       60,  -46,   33,       70,  -58,   46,       80,  -69,   57,
      16,   42,  -29,       20,   29,  -22,       29,    8,   -9,       39,  -12,    6,
      50,  -29,   20,       60,  -44,   34,       70,  -56,   46,       80,  -67,   57,
      17,   43,  -27,       22,   31,  -20,       30,   11,   -7,       40,   -9,    7,
      50,  -27,   21,       60,  -41,   34,       70,  -54,   46,       80,  -66,   58,
      19,   45,  -24,       23,   34,  -18,       31,   14,   -6,       40,   -6,    8,
      50,  -24,   22,       60,  -39,   35,       70,  -52,   47,       81,  -64,   58,
      21,   46,  -21,       25,   36,  -15,       32,   18,   -4,       41,   -2,    9,
      51,  -20,   23,       61,  -36,   35,       71,  -50,   47,       81,  -62,   58,
      23,   48,  -18,       26,   39,  -13,       33,   21,   -3,       42,    1,   10,
      51,  -17,   23,       61,  -33,   36,       71,  -47,   47,       81,  -60,   59,
      24,   50,  -15,       28,   41,  -10,       34,   24,   -1,       42,    5,   11,
      52,  -14,   24,       62,  -30,   36,       71,  -45,   48,       81,  -58,   59,
      26,   52,  -12,       29,   44,   -8,       35,   27,    1,       43,    8,   13,
      53,  -11,   25,       62,  -27,   37,       72,  -42,   49,       82,  -56,   60,
      28,   54,   -9,       31,   46,   -5,       37,   31,    3,       44,   12,   14,
      53,   -7,   26,       63,  -24,   38,       72,  -39,   49,       82,  -53,   60,
      30,   55,   -6,       32,   48,   -3,       38,   34,    5,       45,   15,   16,
      54,   -4,   27,       63,  -21,   39,       73,  -36,   50,       82,  -50,   61,
      32,   57,   -4,       34,   51,    0,       39,   37,    7,       46,   19,   17,
      55,    0,   28,       64,  -17,   40,       73,  -33,   50,       83,  -48,   61,
      33,   59,   -1,       35,   53,    2,       40,   40,    9,       47,   22,   19,
      56,    3,   30,       65,  -14,   41,       74,  -30,   51,       83,  -45,   62,
      35,   61,    2,       37,   55,    5,       42,   43,   11,       48,   26,   20,
      57,    7,   31,       65,  -10,   42,       74,  -26,   52,       84,  -42,   62,
      37,   63,    5,       39,   58,    7,       43,   46,   13,       50,   29,   22,
      58,   11,   32,       66,   -7,   43,       75,  -23,   53,       84,  -39,   63,
      39,   65,    7,       40,   60,   10,       45,   48,   16,       51,   32,   24,
      58,   14,   34,       67,   -3,   44,       75,  -20,   54,       85,  -36,   64,
      40,   67,   10,       42,   62,   12,       46,   51,   18,       52,   36,   25,
      59,   18,   35,       67,    0,   45,       76,  -17,   54,       85,  -33,   64,
      42,   69,   13,       44,   64,   15,       47,   53,   20,       53,   39,   27,
      60,   21,   36,       68,    3,   46,       77,  -13,   55,       86,  -29,   65,
      44,   71,   15,       45,   66,   17,       49,   56,   22,       54,   42,   29,
      61,   25,   38,       69,    7,   47,       77,  -10,   56,       86,  -26,   66,
      46,   72,   18,       47,   68,   20,       50,   59,   24,       56,   45,   31,
      62,   28,   39,       70,   11,   48,       78,   -6,   57,       87,  -23,   67,
      47,   74,   20,       48,   71,   22,       52,   61,   26,       57,   48,   33,
      63,   31,   41,       71,   14,   49,       79,   -3,   58,       88,  -19,   68,
      49,   76,   23,       50,   73,   25,       53,   64,   29,       58,   51,   35,
      64,   34,   42,       72,   17,   51,       80,    1,   59,       88,  -16,   68,
      51,   78,   26,       52,   75,   27,       55,   66,   31,       59,   54,   37,
      66,   38,   44,       73,   21,   52,       80,    4,   61,       89,  -12,   69,
      52,   80,   28,       53,   77,   29,       56,   69,   33,       61,   57,   38,
      67,   41,   46,       74,   24,   53,       81,    8,   62,       90,   -9,   70,
      54,   82,   30,       55,   79,   32,       58,   71,   35,       62,   59,   40,
      68,   44,   47,       75,   28,   55,       82,   11,   63,       90,   -6,   71,
       7,   37,  -50,       14,   16,  -38,       25,   -8,  -20,       37,  -26,   -3,
      48,  -41,   13,       59,  -53,   28,       69,  -63,   41,       79,  -74,   53,
       7,   37,  -50,       15,   16,  -37,       25,   -7,  -20,       37,  -25,   -3,
      48,  -40,   13,       59,  -52,   28,       69,  -63,   41,       79,  -73,   53,
       8,   37,  -49,       15,   17,  -37,       26,   -6,  -19,       37,  -25,   -3,
      48,  -40,   13,       59,  -52,   28,       69,  -63,   41,       79,  -73,   53,
       9,   38,  -47,       15,   19,  -36,       26,   -5,  -19,       37,  -23,   -2,
      48,  -39,   14,       59,  -51,   28,       69,  -62,   41,       80,  -72,   53,
       9,   38,  -46,       16,   20,  -35,       26,   -3,  -18,       37,  -22,   -2,
      48,  -38,   14,       59,  -50,   28,       69,  -61,   41,       80,  -72,   53,
      11,   39,  -44,       17,   22,  -34,       27,   -1,  -18,       37,  -20,   -2,
      48,  -36,   14,       59,  -49,   28,       69,  -61,   41,       80,  -71,   53,
      12,   40,  -41,       18,   24,  -32,       27,    1,  -17,       38,  -18,   -1,
      49,  -35,   15,       59,  -48,   28,       69,  -59,   41,       80,  -70,   54,
      13,   41,  -39,       19,   26,  -30,       28,    4,  -16,       38,  -16,    0,
      49,  -32,   15,       59,  -46,   29,       70,  -58,   42,       80,  -69,   54,
      15,   42,  -36,       20,   28,  -29,       29,    7,  -15,       39,  -13,    0,
      49,  -30,   15,       60,  -44,   29,       70,  -57,   42,       80,  -68,   54,
      16,   43,  -34,       21,   30,  -27,       29,   10,  -13,       39,  -10,    1,
      50,  -28,   16,       60,  -42,   30,       70,  -55,   42,       80,  -67,   54,
      18,   45,  -31,       22,   33,  -25,       30,   13,  -12,       40,   -7,    2,
      50,  -25,   17,       60,  -40,   30,       70,  -53,   42,       80,  -65,   54,
      20,   46,  -28,       23,   35,  -22,       31,   16,  -11,       40,   -4,    3,
      51,  -22,   17,       61,  -38,   31,       71,  -51,   43,       81,  -63,   55,
      22,   48,  -25,       25,   38,  -20,       32,   19,   -9,       41,   -1,    4,
      51,  -19,   18,       61,  -35,   31,       71,  -49,   43,       81,  -61,   55,
      23,   49,  -23,       26,   40,  -18,       33,   22,   -7,       42,    3,    5,
      52,  -16,   19,       61,  -32,   32,       71,  -46,   44,       81,  -59,   55,
      25,   51,  -20,       28,   42,  -15,       34,   25,   -5,       43,    6,    7,
      52,  -13,   20,       62,  -29,   32,       72,  -44,   44,       81,  -57,   56,
      27,   53,  -17,       29,   45,  -13,       35,   28,   -4,       44,    9,    8,
      53,  -10,   21,       62,  -26,   33,       72,  -41,   45,       82,  -55,   56,
      28,   55,  -14,       31,   47,  -10,       37,   32,   -2,       45,   13,   10,
      54,   -6,   22,       63,  -23,   34,       72,  -38,   46,       82,  -52,   57,
      30,   56,  -11,       33,   49,   -8,       38,   35,    0,       45,   17,   11,
      54,   -3,   23,       63,  -20,   35,       73,  -35,   46,       83,  -50,   57,
      32,   58,   -9,       34,   52,   -5,       39,   38,    2,       46,   20,   13,
      55,    1,   24,       64,  -16,   36,       73,  -32,   47,       83,  -47,   58,
      34,   60,   -6,       36,   54,   -3,       41,   40,    4,       47,   23,   14,
      56,    4,   25,       65,  -13,   37,       74,  -29,   48,       83,  -44,   58,
      35,   62,   -3,       37,   56,    0,       42,   44,    7,       49,   27,   16,
      57,    8,   27,       65,   -9,   38,       74,  -26,   48,       84,  -41,   59,
      37,   64,    0,       39,   58,    3,       43,   46,    9,       50,   30,   18,
      58,   12,   28,       66,   -6,   39,       75,  -23,   49,       84,  -38,   60,
      39,   65,    3,       41,   60,    5,       45,   49,   11,       51,   33,   19,
      59,   15,   29,       67,   -3,   40,       76,  -19,   50,       85,  -35,   60,
      41,   67,    5,       42,   63,    7,       46,   52,   13,       52,   36,   21,
      59,   18,   31,       68,    1,   41,       76,  -16,   51,       85,  -32,   61,
      42,   69,    8,       44,   65,   10,       47,   54,   15,       53,   39,   23,
      60,   22,   32,       68,    4,   42,       77,  -13,   52,       86,  -29,   62,
      44,   71,   11,       45,   67,   13,       49,   57,   18,       54,   43,   25,
      62,   25,   34,       69,    8,   43,       78,   -9,   53,       86,  -25,   63,
      46,   73,   13,       47,   69,   15,       50,   59,   20,       56,   46,   27,
      63,   29,   35,       70,   11,   44,       78,   -6,   54,       87,  -22,   64,
      47,   75,   16,       49,   71,   17,       52,   62,   22,       57,   48,   28,
      64,   32,   37,       71,   15,   46,       79,   -2,   55,       88,  -19,   64,
      49,   77,   18,       50,   73,   20,       53,   64,   24,       58,   51,   30,
      65,   35,   38,       72,   18,   47,       80,    1,   56,       88,  -16,   65,
      51,   79,   21,       52,   75,   23,       55,   67,   26,       60,   54,   32,
      66,   38,   40,       73,   22,   48,       81,    5,   57,       89,  -12,   66,
      52,   80,   23,       54,   77,   25,       56,   69,   29,       61,   57,   34,
      67,   41,   42,       74,   25,   50,       81,    8,   58,       90,   -9,   67,
      54,   82,   26,       55,   79,   27,       58,   71,   31,       62,   60,   36,
      68,   44,   43,       75,   28,   51,       82,   11,   59,       90,   -5,   68,
       8,   40,  -54,       15,   20,  -42,       26,   -4,  -25,       37,  -23,   -8,
      48,  -38,    8,       59,  -51,   23,       69,  -62,   36,       80,  -72,   49,
       9,   40,  -53,       15,   20,  -42,       26,   -3,  -25,       37,  -22,   -8,
      48,  -38,    8,       59,  -51,   23,       69,  -62,   36,       80,  -72,   49,
       9,   40,  -52,       16,   21,  -41,       26,   -3,  -25,       37,  -22,   -8,
      48,  -37,    9,       59,  -50,   23,       69,  -61,   36,       80,  -72,   49,
      10,   40,  -51,       16,   22,  -40,       26,   -1,  -24,       37,  -21,   -7,
      48,  -36,    9,       59,  -49,   23,       69,  -61,   37,       80,  -71,   49,
      11,   41,  -49,       17,   23,  -40,       27,    0,  -24,       37,  -19,   -7,
      48,  -35,    9,       59,  -49,   23,       69,  -60,   37,       80,  -71,   49,
      12,   41,  -48,       17,   25,  -38,       27,    2,  -23,       38,  -18,   -7,
      49,  -34,    9,       59,  -47,   24,       69,  -59,   37,       80,  -70,   49,
      13,   42,  -46,       18,   27,  -37,       28,    4,  -22,       38,  -16,   -6,
      49,  -32,   10,       59,  -46,   24,       70,  -58,   37,       80,  -69,   50,
      14,   43,  -43,       19,   29,  -35,       28,    7,  -21,       38,  -13,   -5,
      49,  -30,   10,       60,  -44,   24,       70,  -57,   37,       80,  -68,   50,
      16,   44,  -41,       20,   31,  -33,       29,    9,  -20,       39,  -11,   -5,
      50,  -28,   11,       60,  -43,   25,       70,  -55,   38,       80,  -67,   50,
      17,   45,  -39,       22,   33,  -32,       30,   12,  -19,       39,   -8,   -4,
      50,  -26,   11,       60,  -41,   25,       70,  -54,   38,       80,  -65,   50,
      19,   46,  -36,       23,   35,  -30,       31,   15,  -17,       40,   -5,   -3,
      50,  -23,   12,       60,  -39,   25,       70,  -52,   38,       81,  -64,   51,
      20,   48,  -33,       24,   37,  -27,       31,   18,  -16,       41,   -2,   -2,
      51,  -21,   12,       61,  -36,   26,       71,  -50,   39,       81,  -62,   51,
      22,   49,  -30,       26,   39,  -25,       33,   21,  -14,       41,    1,   -1,
      51,  -18,   13,       61,  -33,   27,       71,  -47,   39,       81,  -60,   51,
      24,   51,  -28,       27,   42,  -23,       34,   24,  -12,       42,    4,    0,
      52,  -15,   14,       62,  -31,   27,       71,  -45,   40,       81,  -58,   52,
      25,   52,  -25,       28,   44,  -20,       35,   27,  -11,       43,    8,    2,
      52,  -11,   15,       62,  -28,   28,       72,  -43,   40,       82,  -56,   52,
      27,   54,  -22,       30,   46,  -18,       36,   30,   -9,       44,   11,    3,
      53,   -8,   16,       62,  -25,   29,       72,  -40,   41,       82,  -54,   52,
      29,   56,  -19,       31,   48,  -15,       37,   33,   -7,       45,   15,    4,
      54,   -5,   17,       63,  -22,   29,       72,  -37,   41,       82,  -51,   53,
      31,   57,  -17,       33,   50,  -13,       38,   36,   -5,       46,   18,    6,
      54,   -1,   18,       64,  -19,   30,       73,  -34,   42,       83,  -49,   53,
      32,   59,  -14,       34,   53,  -10,       40,   39,   -3,       47,   21,    7,
      55,    2,   19,       64,  -15,   31,       73,  -31,   43,       83,  -46,   54,
      34,   61,  -11,       36,   55,   -8,       41,   41,   -1,       48,   24,    9,
      56,    5,   21,       65,  -12,   32,       74,  -28,   43,       83,  -43,   55,
      36,   63,   -8,       38,   57,   -5,       42,   44,    1,       49,   28,   11,
      57,    9,   22,       66,   -8,   33,       74,  -25,   44,       84,  -40,   55,
      37,   64,   -5,       39,   59,   -3,       44,   47,    4,       50,   31,   12,
      58,   12,   23,       66,   -5,   34,       75,  -22,   45,       84,  -37,   56,
      39,   66,   -3,       41,   61,    0,       45,   50,    6,       51,   34,   14,
      59,   16,   25,       67,   -2,   35,       76,  -18,   46,       85,  -34,   57,
      41,   68,    0,       42,   63,    2,       46,   52,    8,       52,   37,   16,
      60,   19,   26,       68,    2,   36,       76,  -15,   47,       85,  -31,   57,
      42,   70,    2,       44,   65,    5,       48,   55,   10,       53,   40,   18,
      61,   22,   27,       68,    5,   37,       77,  -12,   48,       86,  -28,   58,
      44,   72,    5,       46,   68,    7,       49,   58,   12,       55,   43,   20,
      62,   26,   29,       69,    9,   39,       78,   -8,   49,       86,  -25,   59,
      46,   74,    8,       47,   70,   10,       51,   60,   15,       56,   46,   22,
      63,   29,   30,       70,   12,   40,       78,   -5,   50,       87,  -21,   60,
      48,   75,   10,       49,   72,   12,       52,   62,   17,       57,   49,   23,
      64,   32,   32,       71,   15,   41,       79,   -2,   51,       88,  -18,   61,
      49,   77,   13,       50,   74,   15,       53,   65,   19,       58,   52,   25,
      65,   36,   34,       72,   19,   42,       80,    2,   52,       88,  -15,   61,
      51,   79,   16,       52,   76,   17,       55,   67,   21,       60,   55,   27,
      66,   39,   35,       73,   22,   44,       81,    5,   53,       89,  -11,   62,
      53,   81,   18,       54,   78,   20,       57,   70,   23,       61,   58,   29,
      67,   42,   37,       74,   26,   45,       81,    9,   54,       90,   -8,   63,
      54,   83,   21,       55,   80,   22,       58,   72,   26,       62,   60,   31,
      68,   45,   39,       75,   29,   47,       82,   12,   55,       90,   -5,   64,
       9,   42,  -57,       16,   23,  -46,       26,   -1,  -29,       37,  -20,  -13,
      48,  -36,    4,       59,  -49,   19,       69,  -61,   32,       80,  -71,   46,
      10,   42,  -56,       16,   24,  -46,       26,    0,  -29,       37,  -20,  -12,
      48,  -36,    4,       59,  -49,   19,       69,  -60,   33,       80,  -71,   46,
      10,   42,  -55,       17,   24,  -45,       27,    1,  -29,       37,  -19,  -12,
      48,  -35,    4,       59,  -48,   19,       69,  -60,   33,       80,  -71,   46,
      11,   42,  -54,       17,   25,  -44,       27,    2,  -29,       38,  -18,  -12,
      49,  -34,    4,       59,  -48,   19,       69,  -59,   33,       80,  -70,   46,
      12,   43,  -53,       18,   26,  -44,       27,    3,  -28,       38,  -17,  -12,
      49,  -33,    5,       59,  -47,   19,       69,  -59,   33,       80,  -70,   46,
      13,   43,  -51,       18,   28,  -42,       28,    5,  -27,       38,  -15,  -11,
      49,  -32,    5,       59,  -46,   19,       70,  -58,   33,       80,  -69,   46,
      14,   44,  -49,       19,   29,  -41,       28,    7,  -26,       38,  -13,  -11,
      49,  -30,    5,       59,  -45,   20,       70,  -57,   33,       80,  -68,   46,
      15,   45,  -47,       20,   31,  -39,       29,    9,  -25,       39,  -11,  -10,
      49,  -28,    6,       60,  -43,   20,       70,  -55,   33,       80,  -67,   46,
      17,   46,  -45,       21,   33,  -38,       29,   12,  -24,       39,   -9,   -9,
      50,  -26,    6,       60,  -41,   20,       70,  -54,   34,       80,  -66,   46,
      18,   47,  -43,       22,   35,  -36,       30,   14,  -23,       40,   -6,   -8,
      50,  -24,    7,       60,  -39,   21,       70,  -52,   34,       80,  -64,   47,
      19,   48,  -40,       23,   37,  -34,       31,   17,  -22,       40,   -3,   -8,
      50,  -22,    7,       61,  -37,   21,       70,  -51,   34,       81,  -63,   47,
      21,   49,  -38,       25,   39,  -32,       32,   20,  -20,       41,    0,   -7,
      51,  -19,    8,       61,  -35,   22,       71,  -49,   35,       81,  -61,   47,
      23,   50,  -35,       26,   41,  -29,       33,   23,  -19,       42,    3,   -5,
      51,  -16,    9,       61,  -32,   22,       71,  -46,   35,       81,  -59,   48,
      24,   52,  -32,       27,   43,  -27,       34,   26,  -17,       42,    6,   -4,
      52,  -13,   10,       62,  -30,   23,       71,  -44,   36,       81,  -57,   48,
      26,   53,  -29,       29,   45,  -25,       35,   28,  -15,       43,    9,   -3,
      53,  -10,   11,       62,  -27,   24,       72,  -42,   36,       82,  -55,   48,
      27,   55,  -27,       30,   47,  -23,       36,   31,  -13,       44,   12,   -2,
      53,   -7,   12,       63,  -24,   24,       72,  -39,   37,       82,  -53,   49,
      29,   57,  -24,       32,   49,  -20,       37,   34,  -11,       45,   16,    0,
      54,   -3,   13,       63,  -21,   25,       73,  -36,   37,       82,  -50,   49,
      31,   58,  -21,       33,   52,  -18,       39,   37,   -9,       46,   19,    1,
      55,    0,   14,       64,  -18,   26,       73,  -33,   38,       83,  -48,   50,
      33,   60,  -18,       35,   54,  -15,       40,   40,   -7,       47,   22,    3,
      55,    3,   15,       64,  -14,   27,       74,  -30,   39,       83,  -45,   50,
      34,   62,  -16,       36,   56,  -13,       41,   42,   -5,       48,   25,    4,
      56,    6,   16,       65,  -11,   28,       74,  -27,   40,       83,  -42,   51,
      36,   63,  -13,       38,   58,  -10,       43,   45,   -3,       49,   29,    6,
      57,   10,   18,       66,   -8,   29,       75,  -24,   40,       84,  -39,   52,
      38,   65,  -10,       40,   60,   -7,       44,   48,   -1,       50,   32,    8,
      58,   13,   19,       66,   -4,   30,       75,  -21,   41,       84,  -36,   52,
      39,   67,   -7,       41,   62,   -5,       45,   51,    1,       51,   35,   10,
      59,   17,   20,       67,   -1,   31,       76,  -18,   42,       85,  -34,   53,
      41,   69,   -5,       43,   64,   -2,       47,   53,    3,       52,   38,   11,
      60,   20,   22,       68,    2,   32,       76,  -14,   43,       85,  -31,   54,
      43,   70,   -2,       44,   66,    0,       48,   56,    5,       53,   41,   13,
      61,   23,   23,       69,    6,   33,       77,  -11,   44,       86,  -27,   55,
      44,   72,    1,       46,   68,    3,       49,   58,    8,       55,   44,   15,
      62,   27,   25,       69,    9,   35,       78,   -8,   45,       87,  -24,   55,
      46,   74,    3,       47,   70,    5,       51,   61,   10,       56,   47,   17,
      63,   30,   26,       70,   13,   36,       78,   -4,   46,       87,  -21,   56,
      48,   76,    6,       49,   72,    8,       52,   63,   12,       57,   50,   19,
      64,   33,   28,       71,   16,   37,       79,   -1,   47,       88,  -18,   57,
      49,   78,    8,       51,   74,   10,       54,   65,   14,       58,   52,   21,
      65,   36,   29,       72,   19,   38,       80,    2,   48,       88,  -14,   58,
      51,   80,   11,       52,   76,   13,       55,   68,   17,       60,   55,   23,
      66,   40,   31,       73,   23,   40,       81,    6,   49,       89,  -11,   59,
      53,   81,   14,       54,   78,   15,       57,   70,   19,       61,   58,   25,
      67,   43,   33,       74,   26,   41,       82,    9,   50,       90,   -8,   60,
      54,   83,   16,       55,   80,   17,       58,   72,   21,       62,   61,   27,
      68,   46,   34,       75,   29,   43,       82,   13,   52,       90,   -4,   61,
      11,   44,  -60,       17,   26,  -50,       27,    3,  -34,       37,  -17,  -17,
      49,  -34,    0,       59,  -47,   15,       69,  -59,   29,       80,  -70,   42,
      11,   44,  -59,       17,   27,  -50,       27,    3,  -34,       38,  -17,  -17,
      49,  -33,    0,       59,  -47,   15,       69,  -59,   29,       80,  -70,   42,
      12,   44,  -59,       17,   27,  -49,       27,    4,  -33,       38,  -16,  -17,
      49,  -33,    0,       59,  -47,   15,       69,  -58,   29,       80,  -69,   42,
      12,   45,  -58,       18,   28,  -48,       27,    5,  -33,       38,  -15,  -16,
      49,  -32,    0,       59,  -46,   15,       69,  -58,   29,       80,  -69,   42,
      13,   45,  -56,       18,   29,  -47,       28,    6,  -32,       38,  -14,  -16,
      49,  -31,    0,       59,  -45,   15,       70,  -57,   29,       80,  -68,   42,
      14,   45,  -55,       19,   30,  -46,       28,    8,  -32,       38,  -12,  -16,
      49,  -30,    0,       59,  -44,   15,       70,  -56,   29,       80,  -68,   42,
      15,   46,  -53,       20,   32,  -45,       29,   10,  -31,       39,  -11,  -15,
      49,  -28,    1,       60,  -43,   15,       70,  -55,   29,       80,  -67,   42,
      16,   47,  -51,       21,   33,  -43,       29,   12,  -30,       39,   -8,  -14,
      50,  -26,    1,       60,  -41,   16,       70,  -54,   29,       80,  -66,   43,
      17,   47,  -49,       22,   35,  -42,       30,   14,  -29,       39,   -6,  -14,
      50,  -24,    2,       60,  -40,   16,       70,  -53,   30,       80,  -65,   43,
      19,   48,  -47,       23,   37,  -40,       31,   17,  -28,       40,   -4,  -13,
      50,  -22,    2,       60,  -38,   17,       70,  -51,   30,       81,  -63,   43,
      20,   49,  -44,       24,   39,  -38,       31,   19,  -26,       41,   -1,  -12,
      51,  -20,    3,       61,  -36,   17,       71,  -49,   30,       81,  -62,   43,
      22,   50,  -42,       25,   40,  -36,       32,   22,  -25,       41,    2,  -11,
      51,  -17,    4,       61,  -33,   18,       71,  -47,   31,       81,  -60,   44,
      23,   52,  -39,       27,   43,  -34,       33,   25,  -23,       42,    5,  -10,
      52,  -14,    5,       61,  -31,   18,       71,  -45,   31,       81,  -58,   44,
      25,   53,  -36,       28,   45,  -32,       34,   27,  -21,       43,    8,   -9,
      52,  -12,    5,       62,  -28,   19,       72,  -43,   32,       81,  -56,   44,
      26,   55,  -34,       29,   46,  -29,       35,   30,  -20,       43,   11,   -7,
      53,   -9,    6,       62,  -25,   20,       72,  -40,   32,       82,  -54,   45,
      28,   56,  -31,       31,   48,  -27,       36,   33,  -18,       44,   14,   -6,
      53,   -6,    7,       63,  -23,   20,       72,  -38,   33,       82,  -52,   45,
      30,   58,  -28,       32,   51,  -24,       38,   36,  -16,       45,   17,   -5,
      54,   -2,    8,       63,  -19,   21,       73,  -35,   34,       82,  -49,   46,
      31,   59,  -26,       34,   53,  -22,       39,   38,  -14,       46,   20,   -3,
      55,    1,    9,       64,  -16,   22,       73,  -32,   34,       83,  -47,   46,
      33,   61,  -23,       35,   55,  -20,       40,   41,  -12,       47,   23,   -2,
      56,    4,   11,       64,  -13,   23,       74,  -29,   35,       83,  -44,   47,
      35,   62,  -20,       37,   57,  -17,       41,   44,  -10,       48,   26,    0,
      56,    8,   12,       65,  -10,   24,       74,  -26,   36,       84,  -42,   47,
      36,   64,  -17,       38,   59,  -14,       43,   46,   -8,       49,   30,    2,
      57,   11,   13,       66,   -6,   25,       75,  -23,   37,       84,  -38,   48,
      38,   66,  -15,       40,   61,  -12,       44,   49,   -6,       50,   33,    3,
      58,   14,   15,       66,   -3,   26,       75,  -20,   37,       85,  -36,   49,
      40,   68,  -12,       41,   63,  -10,       45,   51,   -4,       51,   36,    5,
      59,   18,   16,       67,    0,   27,       76,  -17,   38,       85,  -33,   50,
      41,   69,   -9,       43,   65,   -7,       47,   54,   -1,       53,   39,    7,
      60,   21,   17,       68,    3,   28,       76,  -14,   39,       86,  -30,   50,
      43,   71,   -7,       44,   67,   -5,       48,   56,    1,       54,   42,    9,
      61,   24,   19,       69,    7,   29,       77,  -10,   40,       86,  -27,   51,
      45,   73,   -4,       46,   69,   -2,       50,   59,    3,       55,   45,   11,
      62,   28,   20,       70,   10,   31,       78,   -7,   41,       87,  -23,   52,
      46,   75,   -1,       48,   71,    1,       51,   61,    5,       56,   48,   13,
      63,   31,   22,       70,   13,   32,       79,   -4,   42,       87,  -20,   53,
      48,   76,    1,       49,   73,    3,       52,   64,    8,       57,   50,   15,
      64,   34,   23,       71,   17,   33,       79,    0,   43,       88,  -17,   54,
      50,   78,    4,       51,   75,    5,       54,   66,   10,       59,   53,   16,
      65,   37,   25,       72,   20,   34,       80,    3,   44,       88,  -14,   54,
      51,   80,    6,       53,   77,    8,       55,   69,   12,       60,   56,   19,
      66,   40,   27,       73,   24,   36,       81,    7,   45,       89,  -10,   55,
      53,   82,    9,       54,   79,   11,       57,   71,   14,       61,   59,   20,
      67,   43,   28,       74,   27,   37,       82,   10,   47,       90,   -7,   56,
      55,   84,   11,       56,   81,   13,       58,   73,   17,       63,   61,   22,
      68,   46,   30,       75,   30,   39,       82,   13,   48,       91,   -4,   57,
      12,   46,  -63,       18,   30,  -54,       27,    6,  -38,       38,  -14,  -21,
      49,  -31,   -5,       59,  -45,   10,       69,  -57,   24,       80,  -69,   38,
      12,   46,  -62,       18,   30,  -53,       27,    7,  -38,       38,  -14,  -21,
      49,  -31,   -5,       59,  -45,   10,       70,  -57,   25,       80,  -68,   38,
      13,   46,  -62,       18,   31,  -53,       28,    7,  -37,       38,  -13,  -21,
      49,  -30,   -5,       59,  -45,   11,       70,  -57,   25,       80,  -68,   38,
      13,   47,  -61,       19,   31,  -52,       28,    8,  -37,       38,  -12,  -21,
      49,  -30,   -4,       59,  -44,   11,       70,  -56,   25,       80,  -68,   38,
      14,   47,  -60,       19,   32,  -51,       28,   10,  -36,       38,  -11,  -20,
      49,  -29,   -4,       60,  -43,   11,       70,  -56,   25,       80,  -67,   38,
      15,   47,  -58,       20,   33,  -50,       29,   11,  -36,       39,  -10,  -20,
      49,  -28,   -4,       60,  -42,   11,       70,  -55,   25,       80,  -66,   38,
      16,   48,  -57,       21,   34,  -49,       29,   13,  -35,       39,   -8,  -20,
      50,  -26,   -4,       60,  -41,   11,       70,  -54,   25,       80,  -66,   39,
      17,   48,  -54,       21,   36,  -47,       30,   15,  -34,       39,   -6,  -19,
      50,  -24,   -3,       60,  -39,   12,       70,  -52,   25,       80,  -65,   39,
      18,   49,  -52,       22,   37,  -46,       30,   17,  -33,       40,   -4,  -18,
      50,  -22,   -3,       60,  -38,   12,       70,  -51,   26,       80,  -63,   39,
      20,   50,  -50,       23,   39,  -44,       31,   19,  -32,       40,   -1,  -17,
      51,  -20,   -2,       61,  -36,   12,       71,  -50,   26,       81,  -62,   39,
      21,   51,  -48,       25,   41,  -42,       32,   21,  -31,       41,    1,  -16,
      51,  -18,   -1,       61,  -34,   13,       71,  -48,   26,       81,  -61,   40,
      22,   52,  -46,       26,   42,  -40,       33,   24,  -29,       41,    4,  -15,
      51,  -16,   -1,       61,  -32,   13,       71,  -46,   27,       81,  -59,   40,
      24,   53,  -43,       27,   44,  -38,       34,   27,  -27,       42,    7,  -14,
      52,  -13,    0,       62,  -29,   14,       71,  -44,   27,       81,  -57,   40,
      25,   55,  -41,       28,   46,  -36,       35,   29,  -26,       43,   10,  -13,
      52,  -10,    1,       62,  -27,   15,       72,  -41,   28,       82,  -55,   41,
      27,   56,  -38,       30,   48,  -34,       36,   32,  -24,       44,   12,  -12,
      53,   -7,    2,       62,  -24,   15,       72,  -39,   28,       82,  -53,   41,
      28,   57,  -35,       31,   50,  -31,       37,   34,  -22,       45,   15,  -11,
      54,   -4,    3,       63,  -21,   16,       72,  -37,   29,       82,  -51,   41,
      30,   59,  -33,       33,   52,  -29,       38,   37,  -20,       45,   19,   -9,
      54,   -1,    4,       63,  -18,   17,       73,  -34,   30,       83,  -48,   42,
      32,   60,  -30,       34,   54,  -26,       39,   40,  -18,       46,   22,   -8,
      55,    3,    5,       64,  -15,   18,       73,  -31,   30,       83,  -46,   43,
      33,   62,  -27,       36,   56,  -24,       40,   42,  -16,       47,   25,   -6,
      56,    6,    6,       65,  -12,   19,       74,  -28,   31,       83,  -43,   43,
      35,   63,  -25,       37,   58,  -22,       42,   45,  -14,       48,   28,   -4,
      57,    9,    7,       65,   -9,   20,       74,  -25,   32,       84,  -41,   44,
      37,   65,  -22,       39,   60,  -19,       43,   48,  -12,       49,   31,   -3,
      57,   12,    9,       66,   -5,   21,       75,  -22,   33,       84,  -38,   44,
      38,   67,  -19,       40,   62,  -16,       44,   50,  -10,       51,   34,   -1,
      58,   16,   10,       67,   -2,   22,       75,  -19,   33,       85,  -35,   45,
      40,   69,  -17,       42,   64,  -14,       46,   52,   -8,       52,   37,    1,
      59,   19,   12,       67,    1,   23,       76,  -16,   34,       85,  -32,   46,
      42,   70,  -14,       43,   66,  -12,       47,   55,   -6,       53,   40,    3,
      60,   22,   13,       68,    4,   24,       77,  -13,   35,       86,  -29,   47,
      43,   72,  -11,       45,   67,   -9,       48,   57,   -4,       54,   43,    4,
      61,   25,   14,       69,    7,   25,       77,  -10,   36,       86,  -26,   47,
      45,   74,   -9,       46,   70,   -6,       50,   60,   -1,       55,   46,    6,
      62,   28,   16,       70,   11,   26,       78,   -6,   37,       87,  -22,   48,
      47,   75,   -6,       48,   72,   -4,       51,   62,    1,       56,   48,    8,
      63,   32,   18,       71,   14,   28,       79,   -3,   38,       87,  -19,   49,
      48,   77,   -3,       49,   73,   -2,       53,   64,    3,       58,   51,   10,
      64,   35,   19,       71,   18,   29,       79,    1,   39,       88,  -16,   50,
      50,   79,   -1,       51,   75,    1,       54,   67,    5,       59,   54,   12,
      65,   38,   21,       72,   21,   30,       80,    4,   40,       89,  -13,   51,
      52,   81,    2,       53,   77,    4,       56,   69,    8,       60,   57,   14,
      66,   41,   23,       73,   24,   32,       81,    7,   42,       89,  -10,   52,
      53,   82,    4,       54,   79,    6,       57,   71,   10,       61,   59,   16,
      67,   44,   24,       74,   27,   33,       82,   11,   43,       90,   -6,   53,
      55,   84,    7,       56,   81,    8,       58,   74,   12,       63,   62,   18,
      69,   47,   26,       75,   31,   35,       83,   14,   44,       91,   -3,   54,
      14,   49,  -66,       19,   33,  -58,       28,   10,  -43,       38,  -11,  -26,
      49,  -29,  -10,       59,  -43,    6,       70,  -56,   20,       80,  -67,   34,
      14,   49,  -66,       19,   34,  -57,       28,   11,  -42,       38,  -10,  -26,
      49,  -28,  -10,       59,  -43,    6,       70,  -55,   20,       80,  -67,   34,
      14,   49,  -65,       19,   34,  -57,       28,   11,  -42,       38,  -10,  -26,
      49,  -28,   -9,       60,  -42,    6,       70,  -55,   20,       80,  -67,   34,
      15,   49,  -64,       20,   35,  -56,       29,   12,  -42,       39,   -9,  -26,
      49,  -27,   -9,       60,  -42,    6,       70,  -54,   20,       80,  -66,   34,
      15,   49,  -63,       20,   35,  -55,       29,   13,  -41,       39,   -8,  -25,
      49,  -26,   -9,       60,  -41,    6,       70,  -54,   20,       80,  -66,   34,
      16,   50,  -62,       21,   36,  -54,       29,   14,  -40,       39,   -6,  -25,
      50,  -25,   -9,       60,  -40,    6,       70,  -53,   20,       80,  -65,   34,
      17,   50,  -60,       21,   37,  -53,       30,   16,  -40,       39,   -5,  -24,
      50,  -23,   -8,       60,  -39,    7,       70,  -52,   21,       80,  -64,   34,
      18,   51,  -58,       22,   39,  -52,       30,   18,  -39,       40,   -3,  -24,
      50,  -22,   -8,       60,  -37,    7,       70,  -51,   21,       80,  -63,   35,
      19,   51,  -57,       23,   40,  -50,       31,   20,  -38,       40,   -1,  -23,
      50,  -20,   -7,       60,  -36,    7,       70,  -49,   21,       81,  -62,   35,
      21,   52,  -54,       24,   41,  -49,       32,   22,  -37,       41,    1,  -22,
      51,  -18,   -7,       61,  -34,    8,       71,  -48,   21,       81,  -61,   35,
      22,   53,  -52,       25,   43,  -47,       32,   24,  -35,       41,    4,  -21,
      51,  -16,   -6,       61,  -32,    8,       71,  -46,   22,       81,  -59,   35,
      23,   54,  -50,       26,   44,  -45,       33,   26,  -34,       42,    6,  -20,
      52,  -13,   -6,       61,  -30,    9,       71,  -44,   22,       81,  -58,   36,
      25,   55,  -47,       28,   46,  -43,       34,   29,  -32,       43,    9,  -19,
      52,  -10,   -5,       62,  -27,    9,       71,  -42,   23,       81,  -56,   36,
      26,   56,  -45,       29,   48,  -41,       35,   31,  -31,       43,   12,  -18,
      53,   -8,   -4,       62,  -25,   10,       72,  -40,   23,       82,  -54,   36,
      28,   57,  -43,       30,   50,  -38,       36,   34,  -29,       44,   14,  -17,
      53,   -5,   -3,       63,  -22,   11,       72,  -38,   24,       82,  -52,   37,
      29,   59,  -40,       32,   51,  -36,       37,   36,  -27,       45,   17,  -15,
      54,   -2,   -2,       63,  -20,   11,       73,  -35,   24,       82,  -50,   37,
      31,   60,  -37,       33,   53,  -34,       38,   39,  -25,       46,   21,  -14,
      55,    1,   -1,       64,  -16,   12,       73,  -32,   25,       83,  -47,   38,
      32,   62,  -35,       35,   55,  -31,       40,   41,  -23,       47,   23,  -12,
      55,    4,    0,       64,  -14,   13,       73,  -30,   26,       83,  -45,   38,
      34,   63,  -32,       36,   57,  -29,       41,   44,  -21,       48,   26,  -11,
      56,    7,    1,       65,  -11,   14,       74,  -27,   26,       83,  -42,   39,
      35,   65,  -30,       37,   59,  -27,       42,   46,  -19,       49,   29,   -9,
      57,   10,    3,       65,   -8,   15,       74,  -24,   27,       84,  -39,   39,
      37,   66,  -27,       39,   61,  -24,       43,   49,  -17,       50,   32,   -8,
      58,   14,    4,       66,   -4,   16,       75,  -21,   28,       84,  -36,   40,
      39,   68,  -24,       41,   63,  -21,       45,   51,  -15,       51,   35,   -6,
      59,   17,    5,       67,   -1,   17,       76,  -18,   29,       85,  -34,   41,
      40,   69,  -22,       42,   65,  -19,       46,   54,  -13,       52,   38,   -4,
      59,   20,    7,       68,    2,   18,       76,  -15,   30,       85,  -31,   42,
      42,   71,  -19,       44,   67,  -17,       47,   56,  -11,       53,   41,   -2,
      60,   23,    8,       68,    5,   19,       77,  -12,   31,       86,  -28,   42,
      44,   73,  -16,       45,   68,  -14,       49,   58,   -9,       54,   44,   -1,
      61,   26,   10,       69,    9,   20,       77,   -8,   32,       86,  -25,   43,
      45,   75,  -14,       47,   71,  -11,       50,   61,   -6,       55,   47,    1,
      62,   30,   11,       70,   12,   22,       78,   -5,   33,       87,  -22,   44,
      47,   76,  -11,       48,   72,   -9,       52,   63,   -4,       57,   49,    3,
      63,   33,   13,       71,   15,   23,       79,   -2,   34,       87,  -18,   45,
      49,   78,   -8,       50,   74,   -7,       53,   65,   -2,       58,   52,    5,
      64,   36,   14,       72,   18,   24,       79,    1,   35,       88,  -15,   46,
      50,   80,   -6,       51,   76,   -4,       54,   67,    0,       59,   55,    7,
      65,   39,   16,       72,   22,   26,       80,    5,   36,       89,  -12,   47,
      52,   81,   -3,       53,   78,   -1,       56,   70,    3,       60,   58,    9,
      67,   42,   18,       73,   25,   27,       81,    8,   37,       89,   -9,   48,
      53,   83,   -1,       55,   80,    1,       57,   72,    5,       62,   60,   11,
      68,   45,   19,       74,   28,   29,       82,   11,   38,       90,   -6,   49,
      55,   85,    2,       56,   82,    3,       59,   74,    7,       63,   63,   13,
      69,   48,   21,       75,   31,   30,       83,   15,   40,       91,   -2,   50,
      15,   51,  -69,       20,   36,  -61,       29,   14,  -47,       39,   -7,  -30,
      49,  -26,  -14,       60,  -41,    1,       70,  -54,   16,       80,  -66,   30,
      15,   51,  -69,       20,   37,  -61,       29,   14,  -46,       39,   -7,  -30,
      49,  -25,  -14,       60,  -40,    1,       70,  -53,   16,       80,  -65,   30,
      16,   51,  -68,       20,   37,  -60,       29,   15,  -46,       39,   -7,  -30,
      49,  -25,  -14,       60,  -40,    2,       70,  -53,   16,       80,  -65,   30,
      16,   51,  -67,       21,   38,  -60,       29,   15,  -46,       39,   -6,  -30,
      50,  -24,  -14,       60,  -39,    2,       70,  -53,   16,       80,  -65,   30,
      17,   51,  -66,       21,   38,  -59,       29,   16,  -45,       39,   -5,  -30,
      50,  -23,  -13,       60,  -39,    2,       70,  -52,   16,       80,  -64,   30,
      17,   52,  -65,       22,   39,  -58,       30,   18,  -45,       39,   -4,  -29,
      50,  -22,  -13,       60,  -38,    2,       70,  -51,   16,       80,  -63,   30,
      18,   52,  -64,       22,   40,  -57,       30,   19,  -44,       40,   -2,  -29,
      50,  -21,  -13,       60,  -37,    2,       70,  -50,   17,       80,  -63,   30,
      19,   53,  -62,       23,   41,  -55,       31,   21,  -43,       40,    0,  -28,
      50,  -19,  -12,       60,  -35,    3,       70,  -49,   17,       81,  -62,   31,
      20,   53,  -60,       24,   42,  -54,       31,   22,  -42,       41,    2,  -27,
      51,  -18,  -12,       61,  -34,    3,       71,  -48,   17,       81,  -60,   31,
      21,   54,  -58,       25,   44,  -52,       32,   24,  -41,       41,    4,  -26,
      51,  -16,  -11,       61,  -32,    3,       71,  -46,   17,       81,  -59,   31,
      23,   55,  -56,       26,   45,  -51,       33,   26,  -39,       42,    6,  -26,
      51,  -13,  -11,       61,  -30,    4,       71,  -45,   18,       81,  -58,   31,
      24,   56,  -54,       27,   46,  -49,       34,   28,  -38,       42,    8,  -25,
      52,  -11,  -10,       62,  -28,    4,       71,  -43,   18,       81,  -56,   32,
      25,   57,  -51,       28,   48,  -47,       35,   31,  -36,       43,   11,  -23,
      52,   -8,   -9,       62,  -25,    5,       72,  -41,   19,       82,  -54,   32,
      27,   58,  -49,       30,   50,  -45,       36,   33,  -35,       44,   14,  -22,
      53,   -6,   -8,       62,  -23,    6,       72,  -38,   19,       82,  -52,   32,
      28,   59,  -47,       31,   51,  -42,       37,   35,  -33,       44,   16,  -21,
      53,   -3,   -7,       63,  -21,    6,       72,  -36,   20,       82,  -50,   33,
      30,   60,  -44,       32,   53,  -40,       38,   38,  -32,       45,   19,  -20,
      54,    0,   -6,       63,  -18,    7,       73,  -34,   20,       82,  -48,   33,
      31,   62,  -41,       34,   55,  -38,       39,   40,  -29,       46,   22,  -18,
      55,    3,   -5,       64,  -15,    8,       73,  -31,   21,       83,  -46,   34,
      33,   63,  -39,       35,   57,  -36,       40,   43,  -28,       47,   25,  -17,
      56,    6,   -4,       64,  -12,    9,       74,  -28,   22,       83,  -43,   34,
      34,   64,  -36,       36,   58,  -33,       41,   45,  -26,       48,   28,  -15,
      56,    9,   -3,       65,   -9,   10,       74,  -26,   22,       84,  -41,   35,
      36,   66,  -34,       38,   60,  -31,       42,   47,  -24,       49,   31,  -14,
      57,   12,   -2,       66,   -6,   11,       75,  -23,   23,       84,  -38,   36,
      38,   67,  -31,       39,   62,  -28,       44,   50,  -21,       50,   34,  -12,
      58,   15,    0,       66,   -3,   12,       75,  -20,   24,       84,  -35,   36,
      39,   69,  -28,       41,   64,  -26,       45,   52,  -19,       51,   36,  -10,
      59,   18,    1,       67,    0,   13,       76,  -17,   25,       85,  -33,   37,
      41,   70,  -26,       42,   66,  -23,       46,   55,  -17,       52,   39,   -9,
      60,   21,    2,       68,    3,   14,       76,  -14,   26,       85,  -30,   38,
      42,   72,  -23,       44,   68,  -21,       48,   57,  -15,       53,   42,   -7,
      60,   24,    4,       68,    6,   15,       77,  -11,   27,       86,  -27,   38,
      44,   74,  -21,       45,   69,  -19,       49,   59,  -13,       54,   45,   -5,
      61,   27,    5,       69,   10,   16,       77,   -7,   28,       86,  -24,   39,
      46,   75,  -18,       47,   71,  -16,       50,   62,  -11,       56,   48,   -3,
      62,   31,    7,       70,   13,   18,       78,   -4,   29,       87,  -21,   40,
      47,   77,  -15,       49,   73,  -13,       52,   64,   -9,       57,   50,   -1,
      63,   34,    9,       71,   16,   19,       79,   -1,   30,       88,  -18,   41,
      49,   79,  -13,       50,   75,  -11,       53,   66,   -6,       58,   53,    1,
      64,   36,   10,       72,   19,   20,       80,    2,   31,       88,  -14,   42,
      50,   80,  -10,       52,   77,   -9,       55,   68,   -4,       59,   56,    3,
      66,   39,   12,       73,   23,   22,       80,    6,   32,       89,  -11,   43,
      52,   82,   -8,       53,   79,   -6,       56,   71,   -2,       61,   58,    5,
      67,   43,   13,       74,   26,   23,       81,    9,   33,       89,   -8,   44,
      54,   84,   -5,       55,   81,   -3,       58,   73,    1,       62,   61,    7,
      68,   46,   15,       75,   29,   24,       82,   12,   34,       90,   -5,   45,
      55,   85,   -3,       56,   82,   -1,       59,   75,    3,       63,   63,    9,
      69,   48,   17,       75,   32,   26,       83,   15,   36,       91,   -2,   46,
      16,   53,  -72,       21,   39,  -64,       29,   17,  -50,       39,   -4,  -35,
      50,  -23,  -18,       60,  -38,   -3,       70,  -52,   12,       80,  -64,   26,
      16,   53,  -71,       21,   40,  -64,       29,   17,  -50,       39,   -4,  -34,
      50,  -23,  -18,       60,  -38,   -3,       70,  -52,   12,       80,  -64,   26,
      17,   53,  -71,       21,   40,  -64,       29,   18,  -50,       39,   -3,  -34,
      50,  -22,  -18,       60,  -38,   -3,       70,  -51,   12,       80,  -63,   26,
      17,   53,  -70,       21,   40,  -63,       30,   19,  -50,       39,   -3,  -34,
      50,  -22,  -18,       60,  -37,   -2,       70,  -51,   12,       80,  -63,   26,
      18,   53,  -69,       22,   41,  -62,       30,   20,  -49,       40,   -2,  -34,
      50,  -21,  -18,       60,  -36,   -2,       70,  -50,   12,       80,  -63,   26,
      18,   54,  -68,       22,   42,  -61,       30,   21,  -48,       40,   -1,  -33,
      50,  -20,  -17,       60,  -36,   -2,       70,  -49,   12,       80,  -62,   26,
      19,   54,  -67,       23,   42,  -60,       31,   22,  -48,       40,    1,  -33,
      50,  -18,  -17,       60,  -34,   -2,       70,  -48,   13,       81,  -61,   27,
      20,   54,  -65,       24,   43,  -59,       31,   23,  -47,       41,    3,  -32,
      51,  -17,  -16,       61,  -33,   -2,       71,  -47,   13,       81,  -60,   27,
      21,   55,  -63,       25,   45,  -58,       32,   25,  -46,       41,    4,  -31,
      51,  -15,  -16,       61,  -32,   -1,       71,  -46,   13,       81,  -59,   27,
      22,   56,  -62,       26,   46,  -56,       33,   27,  -45,       41,    6,  -31,
      51,  -13,  -15,       61,  -30,   -1,       71,  -44,   13,       81,  -58,   27,
      23,   56,  -60,       27,   47,  -54,       33,   29,  -43,       42,    8,  -30,
      52,  -11,  -15,       61,  -28,    0,       71,  -43,   14,       81,  -56,   27,
      25,   57,  -58,       28,   48,  -53,       34,   31,  -42,       43,   11,  -29,
      52,   -9,  -14,       62,  -26,    0,       71,  -41,   14,       81,  -55,   28,
      26,   58,  -55,       29,   50,  -51,       35,   33,  -41,       43,   13,  -28,
      53,   -6,  -13,       62,  -24,    1,       72,  -39,   15,       82,  -53,   28,
      27,   59,  -53,       30,   51,  -49,       36,   35,  -39,       44,   16,  -27,
      53,   -4,  -12,       63,  -21,    2,       72,  -37,   15,       82,  -51,   29,
      29,   60,  -51,       31,   53,  -46,       37,   37,  -37,       45,   18,  -25,
      54,   -1,  -11,       63,  -19,    2,       72,  -35,   16,       82,  -49,   29,
      30,   61,  -48,       33,   55,  -44,       38,   40,  -36,       45,   21,  -24,
      54,    1,  -11,       63,  -16,    3,       73,  -32,   16,       83,  -47,   29,
      32,   63,  -45,       34,   56,  -42,       39,   42,  -34,       46,   24,  -23,
      55,    4,   -9,       64,  -13,    4,       73,  -29,   17,       83,  -44,   30,
      33,   64,  -43,       35,   58,  -40,       40,   44,  -32,       47,   27,  -21,
      56,    7,   -8,       65,  -11,    5,       74,  -27,   18,       83,  -42,   31,
      35,   65,  -41,       37,   60,  -37,       42,   47,  -30,       48,   29,  -20,
      56,   10,   -7,       65,   -8,    6,       74,  -24,   18,       84,  -40,   31,
      36,   67,  -38,       38,   61,  -35,       43,   49,  -28,       49,   32,  -18,
      57,   13,   -6,       66,   -5,    7,       75,  -21,   19,       84,  -37,   32,
      38,   68,  -35,       40,   63,  -32,       44,   51,  -26,       50,   35,  -16,
      58,   16,   -5,       67,   -1,    8,       75,  -18,   20,       85,  -34,   32,
      40,   70,  -33,       41,   65,  -30,       45,   54,  -24,       51,   38,  -15,
      59,   19,   -3,       67,    2,    9,       76,  -15,   21,       85,  -31,   33,
      41,   71,  -30,       43,   67,  -28,       47,   56,  -22,       52,   40,  -13,
      60,   22,   -2,       68,    5,   10,       76,  -12,   22,       85,  -29,   34,
      43,   73,  -28,       44,   69,  -25,       48,   58,  -20,       53,   43,  -11,
      61,   25,    0,       69,    8,   11,       77,   -9,   23,       86,  -26,   35,
      44,   74,  -25,       46,   70,  -23,       49,   60,  -17,       55,   46,   -9,
      62,   28,    1,       69,   11,   12,       78,   -6,   24,       86,  -23,   35,
      46,   76,  -22,       47,   72,  -20,       51,   63,  -15,       56,   49,   -7,
      63,   32,    3,       70,   14,   13,       78,   -3,   25,       87,  -20,   36,
      48,   78,  -20,       49,   74,  -18,       52,   65,  -13,       57,   51,   -5,
      64,   35,    4,       71,   17,   15,       79,    0,   26,       88,  -17,   37,
      49,   79,  -17,       50,   76,  -15,       53,   67,  -11,       58,   54,   -4,
      65,   37,    6,       72,   20,   16,       80,    3,   27,       88,  -14,   38,
      51,   81,  -15,       52,   78,  -13,       55,   69,   -9,       59,   56,   -2,
      66,   40,    7,       73,   23,   17,       80,    6,   28,       89,  -11,   39,
      52,   83,  -12,       54,   80,  -10,       56,   71,   -6,       61,   59,    1,
      67,   44,    9,       74,   27,   19,       81,   10,   29,       90,   -7,   40,
      54,   84,   -9,       55,   81,   -8,       58,   74,   -4,       62,   62,    2,
      68,   46,   11,       75,   30,   20,       82,   13,   30,       90,   -4,   41,
      55,   86,   -7,       57,   83,   -5,       59,   76,   -2,       63,   64,    4,
      69,   49,   13,       76,   33,   22,       83,   16,   32,       91,   -1,   42,
      17,   55,  -75,       22,   42,  -68,       30,   20,  -54,       39,   -1,  -39,
      50,  -20,  -22,       60,  -36,   -7,       70,  -50,    8,       80,  -62,   22,
      18,   55,  -74,       22,   42,  -67,       30,   21,  -54,       40,   -1,  -39,
      50,  -20,  -22,       60,  -36,   -7,       70,  -50,    8,       80,  -62,   22,
      18,   55,  -74,       22,   43,  -67,       30,   21,  -54,       40,    0,  -38,
      50,  -19,  -22,       60,  -35,   -7,       70,  -49,    8,       80,  -62,   22,
      18,   55,  -73,       22,   43,  -66,       30,   22,  -53,       40,    1,  -38,
      50,  -19,  -22,       60,  -35,   -7,       70,  -49,    8,       80,  -61,   22,
      19,   55,  -72,       23,   44,  -66,       31,   23,  -53,       40,    1,  -38,
      50,  -18,  -22,       60,  -34,   -6,       70,  -48,    8,       81,  -61,   22,
      20,   56,  -71,       23,   44,  -65,       31,   24,  -52,       40,    2,  -37,
      50,  -17,  -21,       61,  -33,   -6,       70,  -47,    8,       81,  -60,   22,
      20,   56,  -70,       24,   45,  -64,       31,   25,  -52,       41,    4,  -37,
      51,  -16,  -21,       61,  -32,   -6,       71,  -46,    8,       81,  -59,   23,
      21,   56,  -68,       25,   46,  -63,       32,   26,  -51,       41,    5,  -36,
      51,  -14,  -21,       61,  -31,   -6,       71,  -45,    9,       81,  -58,   23,
      22,   57,  -67,       26,   47,  -61,       33,   28,  -50,       41,    7,  -36,
      51,  -13,  -20,       61,  -29,   -5,       71,  -44,    9,       81,  -57,   23,
      23,   57,  -65,       26,   48,  -60,       33,   29,  -49,       42,    9,  -35,
      52,  -11,  -20,       61,  -28,   -5,       71,  -43,    9,       81,  -56,   23,
      24,   58,  -63,       27,   49,  -58,       34,   31,  -47,       42,   11,  -34,
      52,   -9,  -19,       62,  -26,   -4,       71,  -41,   10,       81,  -55,   24,
      25,   59,  -61,       28,   50,  -56,       35,   33,  -46,       43,   13,  -33,
      52,   -7,  -18,       62,  -24,   -4,       72,  -39,   10,       82,  -53,   24,
      27,   60,  -59,       30,   52,  -54,       36,   35,  -45,       44,   16,  -32,
      53,   -4,  -17,       62,  -22,   -3,       72,  -37,   11,       82,  -51,   24,
      28,   61,  -57,       31,   53,  -52,       37,   37,  -43,       44,   18,  -31,
      53,   -2,  -17,       63,  -19,   -3,       72,  -35,   11,       82,  -50,   25,
      30,   62,  -54,       32,   55,  -50,       38,   39,  -41,       45,   20,  -30,
      54,    1,  -16,       63,  -17,   -2,       73,  -33,   12,       82,  -48,   25,
      31,   63,  -52,       33,   56,  -48,       39,   41,  -40,       46,   23,  -28,
      55,    3,  -15,       64,  -15,   -1,       73,  -31,   12,       83,  -46,   26,
      32,   64,  -49,       35,   58,  -46,       40,   44,  -38,       47,   26,  -27,
      55,    6,  -14,       64,  -12,    0,       73,  -28,   13,       83,  -43,   26,
      34,   65,  -47,       36,   59,  -44,       41,   46,  -36,       48,   28,  -25,
      56,    9,  -13,       65,   -9,    1,       74,  -25,   14,       83,  -41,   27,
      35,   67,  -45,       37,   61,  -41,       42,   48,  -34,       49,   31,  -24,
      57,   12,  -11,       65,   -6,    1,       74,  -23,   14,       84,  -38,   27,
      37,   68,  -42,       39,   63,  -39,       43,   50,  -32,       50,   34,  -22,
      57,   15,  -10,       66,   -3,    2,       75,  -20,   15,       84,  -36,   28,
      39,   70,  -39,       40,   64,  -37,       44,   53,  -30,       51,   37,  -20,
      58,   18,   -9,       67,    0,    3,       75,  -17,   16,       85,  -33,   29,
      40,   71,  -37,       42,   66,  -34,       46,   55,  -28,       52,   39,  -19,
      59,   21,   -7,       67,    3,    5,       76,  -14,   17,       85,  -30,   29,
      42,   72,  -34,       43,   68,  -32,       47,   57,  -26,       53,   42,  -17,
      60,   24,   -6,       68,    6,    6,       77,  -11,   18,       86,  -28,   30,
      43,   74,  -32,       45,   70,  -30,       48,   59,  -24,       54,   44,  -15,
      61,   27,   -5,       69,    9,    7,       77,   -8,   19,       86,  -25,   31,
      45,   75,  -29,       46,   71,  -27,       50,   61,  -22,       55,   47,  -14,
      62,   30,   -3,       70,   12,    8,       78,   -5,   20,       87,  -22,   32,
      46,   77,  -27,       48,   73,  -24,       51,   64,  -19,       56,   50,  -12,
      63,   33,   -2,       70,   15,    9,       79,   -2,   21,       87,  -19,   32,
      48,   79,  -24,       49,   75,  -22,       52,   66,  -17,       57,   52,  -10,
      64,   36,    0,       71,   18,   11,       79,    1,   22,       88,  -16,   33,
      49,   80,  -22,       51,   77,  -20,       54,   68,  -15,       58,   55,   -8,
      65,   38,    2,       72,   21,   12,       80,    4,   23,       88,  -13,   34,
      51,   82,  -19,       52,   78,  -17,       55,   70,  -13,       60,   57,   -6,
      66,   41,    3,       73,   24,   13,       81,    7,   24,       89,  -10,   35,
      53,   84,  -16,       54,   80,  -15,       57,   72,  -10,       61,   60,   -4,
      67,   44,    5,       74,   28,   15,       81,   11,   25,       90,   -6,   36,
      54,   85,  -14,       55,   82,  -12,       58,   74,   -8,       62,   63,   -2,
      68,   47,    7,       75,   31,   16,       82,   14,   26,       90,   -3,   37,
      56,   87,  -11,       57,   84,  -10,       59,   76,   -6,       64,   65,    0,
      69,   50,    8,       76,   34,   18,       83,   17,   28,       91,    0,   38,
      19,   57,  -78,       23,   45,  -71,       31,   24,  -58,       40,    3,  -43,
      50,  -17,  -27,       60,  -33,  -12,       70,  -47,    3,       81,  -60,   18,
      19,   57,  -77,       23,   45,  -71,       31,   25,  -58,       40,    3,  -43,
      50,  -17,  -27,       60,  -33,  -12,       70,  -47,    3,       81,  -60,   18,
      19,   57,  -77,       23,   46,  -71,       31,   25,  -58,       40,    3,  -43,
      50,  -16,  -27,       60,  -33,  -11,       70,  -47,    3,       81,  -60,   18,
      20,   57,  -76,       24,   46,  -70,       31,   25,  -58,       40,    4,  -43,
      51,  -16,  -27,       61,  -32,  -11,       71,  -46,    3,       81,  -59,   18,
      20,   58,  -76,       24,   46,  -69,       31,   26,  -57,       41,    5,  -42,
      51,  -15,  -26,       61,  -31,  -11,       71,  -46,    3,       81,  -59,   18,
      21,   58,  -75,       24,   47,  -69,       32,   27,  -57,       41,    6,  -42,
      51,  -14,  -26,       61,  -31,  -11,       71,  -45,    4,       81,  -58,   18,
      21,   58,  -73,       25,   48,  -68,       32,   28,  -56,       41,    7,  -41,
      51,  -13,  -26,       61,  -30,  -11,       71,  -44,    4,       81,  -58,   18,
      22,   59,  -72,       26,   49,  -66,       33,   29,  -55,       41,    9,  -41,
      51,  -11,  -25,       61,  -28,  -10,       71,  -43,    4,       81,  -57,   18,
      23,   59,  -70,       26,   49,  -65,       33,   31,  -54,       42,   10,  -40,
      52,  -10,  -25,       61,  -27,  -10,       71,  -42,    4,       81,  -55,   19,
      24,   60,  -69,       27,   50,  -64,       34,   32,  -53,       42,   12,  -39,
      52,   -8,  -24,       62,  -25,  -10,       71,  -40,    5,       81,  -54,   19,
      25,   60,  -67,       28,   51,  -62,       35,   34,  -52,       43,   14,  -39,
      52,   -6,  -24,       62,  -24,   -9,       72,  -39,    5,       82,  -53,   19,
      26,   61,  -65,       29,   53,  -61,       35,   36,  -51,       43,   16,  -38,
      53,   -4,  -23,       62,  -22,   -9,       72,  -37,    5,       82,  -51,   19,
      28,   62,  -63,       30,   54,  -59,       36,   38,  -49,       44,   18,  -36,
      53,   -2,  -22,       63,  -19,   -8,       72,  -35,    6,       82,  -50,   20,
      29,   63,  -61,       32,   55,  -57,       37,   40,  -48,       45,   20,  -35,
      54,    1,  -21,       63,  -17,   -7,       73,  -33,    6,       82,  -48,   20,
      30,   64,  -59,       33,   57,  -55,       38,   41,  -46,       46,   23,  -34,
      54,    3,  -20,       64,  -15,   -7,       73,  -31,    7,       83,  -46,   21,
      32,   65,  -56,       34,   58,  -53,       39,   43,  -44,       46,   25,  -33,
      55,    5,  -19,       64,  -12,   -6,       73,  -29,    8,       83,  -44,   21,
      33,   66,  -54,       35,   60,  -50,       40,   46,  -42,       47,   28,  -31,
      56,    8,  -18,       65,  -10,   -5,       74,  -26,    8,       83,  -41,   22,
      35,   67,  -51,       37,   61,  -48,       41,   48,  -41,       48,   30,  -30,
      56,   11,  -17,       65,   -7,   -4,       74,  -24,    9,       84,  -39,   22,
      36,   68,  -49,       38,   63,  -46,       42,   50,  -39,       49,   33,  -29,
      57,   14,  -16,       66,   -4,   -3,       75,  -21,   10,       84,  -37,   23,
      37,   69,  -47,       39,   64,  -44,       44,   52,  -37,       50,   35,  -27,
      58,   17,  -15,       66,   -2,   -2,       75,  -18,   10,       84,  -34,   23,
      39,   71,  -44,       41,   66,  -41,       45,   54,  -35,       51,   38,  -25,
      59,   20,  -13,       67,    2,   -1,       76,  -15,   11,       85,  -32,   24,
      41,   72,  -41,       42,   67,  -39,       46,   56,  -33,       52,   41,  -24,
      59,   22,  -12,       68,    5,    0,       76,  -13,   12,       85,  -29,   25,
      42,   74,  -39,       44,   69,  -37,       47,   58,  -31,       53,   43,  -22,
      60,   25,  -11,       68,    7,    1,       77,  -10,   13,       86,  -26,   26,
      44,   75,  -37,       45,   71,  -34,       49,   60,  -29,       54,   46,  -20,
      61,   28,   -9,       69,   10,    2,       77,   -7,   14,       86,  -23,   26,
      45,   77,  -34,       46,   72,  -32,       50,   63,  -26,       55,   48,  -18,
      62,   31,   -8,       70,   13,    3,       78,   -4,   15,       87,  -21,   27,
      47,   78,  -31,       48,   74,  -29,       51,   65,  -24,       56,   51,  -16,
      63,   34,   -6,       71,   17,    5,       79,    0,   16,       87,  -17,   28,
      48,   80,  -29,       50,   76,  -27,       53,   67,  -22,       58,   54,  -14,
      64,   37,   -5,       71,   20,    6,       79,    3,   17,       88,  -14,   29,
      50,   81,  -26,       51,   78,  -24,       54,   69,  -20,       59,   56,  -13,
      65,   40,   -3,       72,   23,    7,       80,    6,   18,       89,  -11,   30,
      51,   83,  -24,       52,   79,  -22,       55,   71,  -18,       60,   58,  -11,
      66,   42,   -2,       73,   26,    9,       81,    9,   19,       89,   -8,   31,
      53,   84,  -21,       54,   81,  -19,       57,   73,  -15,       61,   61,   -9,
      67,   46,    0,       74,   29,   10,       82,   12,   21,       90,   -5,   32,
      55,   86,  -19,       56,   83,  -17,       58,   75,  -13,       63,   64,   -7,
      68,   48,    2,       75,   32,   12,       82,   15,   22,       91,   -2,   33,
      56,   88,  -16,       57,   85,  -15,       60,   77,  -11,       64,   66,   -5,
      69,   51,    4,       76,   35,   13,       83,   18,   23,       91,    1,   34,
      20,   59,  -81,       24,   48,  -74,       31,   27,  -62,       41,    6,  -47,
      51,  -14,  -31,       61,  -31,  -16,       71,  -45,   -1,       81,  -58,   14,
      20,   59,  -80,       24,   48,  -74,       31,   28,  -62,       41,    6,  -47,
      51,  -14,  -31,       61,  -30,  -16,       71,  -45,   -1,       81,  -58,   14,
      21,   59,  -80,       24,   48,  -74,       32,   28,  -62,       41,    7,  -47,
      51,  -13,  -31,       61,  -30,  -16,       71,  -45,   -1,       81,  -58,   14,
      21,   59,  -79,       25,   49,  -73,       32,   29,  -61,       41,    7,  -47,
      51,  -13,  -31,       61,  -30,  -15,       71,  -44,   -1,       81,  -58,   14,
      21,   60,  -79,       25,   49,  -73,       32,   29,  -61,       41,    8,  -46,
      51,  -12,  -30,       61,  -29,  -15,       71,  -44,   -1,       81,  -57,   14,
      22,   60,  -78,       25,   50,  -72,       32,   30,  -60,       41,    9,  -46,
      51,  -11,  -30,       61,  -28,  -15,       71,  -43,    0,       81,  -56,   14,
      23,   60,  -77,       26,   50,  -71,       33,   31,  -60,       42,   10,  -45,
      51,  -10,  -30,       61,  -27,  -15,       71,  -42,    0,       81,  -56,   14,
      23,   60,  -75,       27,   51,  -70,       33,   32,  -59,       42,   12,  -45,
      52,   -9,  -29,       61,  -26,  -14,       71,  -41,    0,       81,  -55,   14,
      24,   61,  -74,       27,   52,  -69,       34,   34,  -58,       42,   13,  -44,
      52,   -7,  -29,       62,  -25,  -14,       71,  -40,    0,       81,  -54,   15,
      25,   61,  -72,       28,   53,  -67,       35,   35,  -57,       43,   15,  -43,
      52,   -6,  -28,       62,  -23,  -14,       72,  -38,    1,       82,  -53,   15,
      26,   62,  -70,       29,   54,  -66,       35,   36,  -56,       43,   16,  -43,
      53,   -4,  -28,       62,  -21,  -13,       72,  -37,    1,       82,  -51,   15,
      27,   63,  -69,       30,   55,  -64,       36,   38,  -54,       44,   18,  -42,
      53,   -2,  -27,       63,  -20,  -13,       72,  -35,    1,       82,  -50,   15,
      29,   63,  -66,       31,   56,  -62,       37,   40,  -53,       45,   21,  -40,
      54,    1,  -26,       63,  -17,  -12,       72,  -33,    2,       82,  -48,   16,
      30,   64,  -64,       32,   57,  -60,       38,   42,  -51,       45,   23,  -39,
      54,    3,  -25,       63,  -15,  -11,       73,  -31,    2,       82,  -46,   16,
      31,   65,  -62,       33,   58,  -58,       39,   43,  -50,       46,   25,  -38,
      55,    5,  -25,       64,  -13,  -11,       73,  -29,    3,       83,  -44,   17,
      32,   66,  -60,       35,   60,  -56,       40,   45,  -48,       47,   27,  -37,
      55,    7,  -24,       64,  -11,  -10,       73,  -27,    4,       83,  -42,   17,
      34,   67,  -58,       36,   61,  -54,       41,   48,  -46,       48,   30,  -35,
      56,   10,  -22,       65,   -8,   -9,       74,  -24,    4,       83,  -40,   18,
      35,   68,  -55,       37,   63,  -52,       42,   49,  -45,       48,   32,  -34,
      57,   13,  -21,       65,   -5,   -8,       74,  -22,    5,       84,  -38,   18,
      37,   70,  -53,       38,   64,  -50,       43,   51,  -43,       49,   35,  -33,
      57,   16,  -20,       66,   -3,   -7,       75,  -20,    6,       84,  -35,   19,
      38,   71,  -51,       40,   65,  -48,       44,   53,  -41,       50,   37,  -31,
      58,   18,  -19,       66,    0,   -6,       75,  -17,    6,       84,  -33,   19,
      40,   72,  -48,       41,   67,  -45,       45,   56,  -39,       51,   40,  -29,
      59,   21,  -18,       67,    3,   -5,       76,  -14,    7,       85,  -30,   20,
      41,   73,  -45,       43,   69,  -43,       47,   58,  -37,       52,   42,  -28,
      60,   24,  -16,       68,    6,   -4,       76,  -11,    8,       85,  -28,   21,
      43,   75,  -43,       44,   70,  -41,       48,   60,  -35,       53,   45,  -26,
      61,   27,  -15,       69,    9,   -3,       77,   -8,    9,       86,  -25,   22,
      44,   76,  -41,       45,   72,  -38,       49,   62,  -33,       54,   47,  -24,
      61,   29,  -14,       69,   12,   -2,       78,   -5,   10,       86,  -22,   22,
      45,   78,  -38,       47,   73,  -36,       50,   64,  -31,       56,   50,  -23,
      62,   32,  -12,       70,   15,   -1,       78,   -3,   11,       87,  -19,   23,
      47,   79,  -35,       48,   75,  -33,       52,   66,  -28,       57,   52,  -21,
      63,   35,  -10,       71,   18,    1,       79,    1,   12,       88,  -16,   24,
      49,   81,  -33,       50,   77,  -31,       53,   68,  -26,       58,   55,  -19,
      64,   38,   -9,       72,   21,    2,       80,    4,   13,       88,  -13,   25,
      50,   82,  -31,       51,   79,  -29,       54,   70,  -24,       59,   57,  -17,
      65,   41,   -7,       72,   24,    3,       80,    7,   14,       89,  -10,   26,
      52,   84,  -28,       53,   80,  -26,       56,   72,  -22,       60,   59,  -15,
      66,   44,   -6,       73,   27,    4,       81,   10,   15,       89,   -7,   27,
      53,   85,  -25,       54,   82,  -24,       57,   74,  -19,       62,   62,  -13,
      68,   47,   -4,       74,   30,    6,       82,   13,   17,       90,   -4,   28,
      55,   87,  -23,       56,   84,  -21,       59,   76,  -17,       63,   64,  -11,
      69,   49,   -2,       75,   33,    7,       83,   16,   18,       91,   -1,   29,
      56,   88,  -20,       57,   85,  -19,       60,   78,  -15,       64,   67,   -9,
      70,   52,   -1,       76,   36,    9,       83,   19,   19,       91,    2,   30,
      21,   61,  -83,       25,   51,  -78,       32,   31,  -66,       41,    9,  -51,
      51,  -11,  -35,       61,  -28,  -20,       71,  -43,   -5,       81,  -57,   10,
      22,   61,  -83,       25,   51,  -77,       32,   31,  -65,       41,   10,  -51,
      51,  -11,  -35,       61,  -28,  -20,       71,  -43,   -5,       81,  -56,   10,
      22,   61,  -83,       25,   51,  -77,       32,   31,  -65,       41,   10,  -51,
      51,  -10,  -35,       61,  -28,  -20,       71,  -42,   -5,       81,  -56,   10,
      22,   61,  -82,       25,   51,  -76,       33,   32,  -65,       41,   10,  -50,
      51,  -10,  -35,       61,  -27,  -20,       71,  -42,   -5,       81,  -56,   10,
      23,   62,  -81,       26,   52,  -76,       33,   32,  -64,       42,   11,  -50,
      51,   -9,  -35,       61,  -26,  -19,       71,  -41,   -5,       81,  -55,   10,
      23,   62,  -81,       26,   52,  -75,       33,   33,  -64,       42,   12,  -50,
      52,   -8,  -34,       61,  -26,  -19,       71,  -41,   -4,       81,  -55,   10,
      24,   62,  -80,       27,   53,  -74,       33,   34,  -63,       42,   13,  -49,
      52,   -7,  -34,       62,  -25,  -19,       71,  -40,   -4,       81,  -54,   10,
      24,   62,  -78,       27,   53,  -73,       34,   35,  -62,       42,   14,  -49,
      52,   -6,  -33,       62,  -23,  -19,       71,  -39,   -4,       81,  -53,   10,
      25,   63,  -77,       28,   54,  -72,       35,   36,  -61,       43,   16,  -48,
      52,   -4,  -33,       62,  -22,  -18,       72,  -38,   -4,       82,  -52,   11,
      26,   63,  -75,       29,   55,  -71,       35,   38,  -60,       43,   17,  -47,
      53,   -3,  -32,       62,  -21,  -18,       72,  -36,   -3,       82,  -51,   11,
      27,   64,  -74,       30,   56,  -69,       36,   39,  -59,       44,   19,  -46,
      53,   -1,  -32,       62,  -19,  -17,       72,  -35,   -3,       82,  -49,   11,
      28,   64,  -72,       31,   57,  -68,       37,   40,  -58,       44,   21,  -46,
      53,    1,  -31,       63,  -17,  -17,       72,  -33,   -3,       82,  -48,   12,
      29,   65,  -70,       32,   58,  -66,       37,   42,  -57,       45,   23,  -44,
      54,    3,  -30,       63,  -15,  -16,       73,  -31,   -2,       82,  -46,   12,
      31,   66,  -68,       33,   59,  -64,       38,   44,  -55,       46,   25,  -43,
      54,    5,  -29,       64,  -13,  -16,       73,  -29,   -2,       83,  -45,   12,
      32,   67,  -66,       34,   60,  -62,       39,   46,  -54,       46,   27,  -42,
      55,    7,  -29,       64,  -11,  -15,       73,  -27,   -1,       83,  -43,   13,
      33,   68,  -64,       35,   61,  -60,       40,   47,  -52,       47,   29,  -41,
      56,   10,  -28,       64,   -9,  -14,       74,  -25,   -1,       83,  -41,   13,
      34,   69,  -61,       37,   63,  -58,       41,   49,  -50,       48,   32,  -40,
      56,   12,  -27,       65,   -6,  -13,       74,  -23,    0,       84,  -38,   14,
      36,   70,  -59,       38,   64,  -56,       42,   51,  -49,       49,   34,  -38,
      57,   15,  -25,       66,   -3,  -12,       75,  -20,    1,       84,  -36,   14,
      37,   71,  -57,       39,   65,  -54,       43,   53,  -47,       50,   36,  -37,
      58,   17,  -24,       66,   -1,  -11,       75,  -18,    2,       84,  -34,   15,
      39,   72,  -54,       40,   67,  -52,       44,   55,  -45,       51,   39,  -35,
      58,   20,  -23,       67,    2,  -11,       75,  -15,    2,       85,  -32,   16,
      40,   73,  -52,       42,   69,  -49,       46,   57,  -43,       52,   41,  -33,
      59,   23,  -22,       67,    5,   -9,       76,  -12,    3,       85,  -29,   16,
      42,   75,  -49,       43,   70,  -47,       47,   59,  -41,       53,   44,  -32,
      60,   26,  -20,       68,    8,   -8,       77,  -10,    4,       86,  -26,   17,
      43,   76,  -47,       45,   72,  -45,       48,   61,  -39,       54,   46,  -30,
      61,   28,  -19,       69,   10,   -7,       77,   -7,    5,       86,  -24,   18,
      44,   77,  -45,       46,   73,  -42,       49,   63,  -37,       55,   49,  -28,
      62,   31,  -18,       69,   13,   -6,       78,   -4,    6,       87,  -21,   18,
      46,   79,  -42,       47,   75,  -40,       51,   65,  -35,       56,   51,  -27,
      63,   34,  -16,       70,   16,   -5,       78,   -1,    7,       87,  -18,   19,
      48,   80,  -39,       49,   76,  -37,       52,   67,  -32,       57,   54,  -25,
      64,   37,  -15,       71,   19,   -4,       79,    2,    8,       88,  -15,   20,
      49,   82,  -37,       50,   78,  -35,       53,   69,  -30,       58,   56,  -23,
      65,   39,  -13,       72,   22,   -2,       80,    5,    9,       88,  -12,   21,
      51,   83,  -35,       52,   80,  -33,       55,   71,  -28,       59,   58,  -21,
      66,   42,  -11,       73,   25,   -1,       80,    8,   10,       89,   -9,   22,
      52,   85,  -32,       53,   81,  -30,       56,   73,  -26,       61,   61,  -19,
      67,   45,  -10,       74,   28,    0,       81,   11,   11,       89,   -6,   23,
      54,   86,  -29,       55,   83,  -28,       58,   75,  -24,       62,   63,  -17,
      68,   48,   -8,       75,   31,    2,       82,   14,   13,       90,   -3,   24,
      55,   88,  -27,       56,   85,  -25,       59,   77,  -21,       63,   65,  -15,
      69,   50,   -6,       75,   34,    3,       83,   17,   14,       91,    0,   25,
      57,   89,  -25,       58,   86,  -23,       60,   79,  -19,       64,   68,  -13,
      70,   53,   -5,       76,   37,    5,       84,   20,   15,       91,    3,   26,
      23,   63,  -86,       26,   53,  -81,       33,   34,  -69,       42,   12,  -55,
      51,   -8,  -39,       61,  -25,  -24,       71,  -41,   -9,       81,  -54,    6,
      23,   63,  -86,       26,   53,  -80,       33,   34,  -69,       42,   13,  -55,
      51,   -8,  -39,       61,  -25,  -24,       71,  -40,   -9,       81,  -54,    6,
      23,   63,  -85,       26,   53,  -80,       33,   34,  -69,       42,   13,  -55,
      52,   -7,  -39,       61,  -25,  -24,       71,  -40,   -9,       81,  -54,    6,
      23,   63,  -85,       26,   54,  -80,       33,   35,  -68,       42,   14,  -54,
      52,   -7,  -39,       61,  -24,  -24,       71,  -40,   -9,       81,  -54,    6,
      24,   64,  -84,       27,   54,  -79,       34,   35,  -68,       42,   14,  -54,
      52,   -6,  -38,       62,  -24,  -23,       71,  -39,   -9,       81,  -53,    6,
      24,   64,  -83,       27,   54,  -78,       34,   36,  -67,       42,   15,  -54,
      52,   -5,  -38,       62,  -23,  -23,       71,  -38,   -8,       81,  -53,    6,
      25,   64,  -82,       28,   55,  -77,       34,   37,  -67,       43,   16,  -53,
      52,   -4,  -38,       62,  -22,  -23,       71,  -38,   -8,       81,  -52,    6,
      25,   64,  -81,       28,   56,  -76,       35,   38,  -66,       43,   17,  -53,
      52,   -3,  -37,       62,  -21,  -23,       72,  -37,   -8,       82,  -51,    6,
      26,   65,  -80,       29,   56,  -75,       35,   39,  -65,       43,   19,  -52,
      53,   -2,  -37,       62,  -20,  -22,       72,  -35,   -8,       82,  -50,    7,
      27,   65,  -78,       30,   57,  -74,       36,   40,  -64,       44,   20,  -51,
      53,    0,  -36,       62,  -18,  -22,       72,  -34,   -7,       82,  -49,    7,
      28,   66,  -77,       31,   58,  -73,       36,   41,  -63,       44,   22,  -50,
      53,    1,  -36,       63,  -17,  -21,       72,  -33,   -7,       82,  -48,    7,
      29,   66,  -75,       32,   59,  -71,       37,   43,  -62,       45,   23,  -49,
      54,    3,  -35,       63,  -15,  -21,       73,  -31,   -7,       82,  -46,    8,
      30,   67,  -73,       33,   60,  -69,       38,   44,  -60,       45,   25,  -48,
      54,    5,  -34,       63,  -13,  -20,       73,  -29,   -6,       83,  -44,    8,
      31,   68,  -71,       34,   61,  -68,       39,   46,  -59,       46,   27,  -47,
      55,    7,  -34,       64,  -11,  -20,       73,  -27,   -6,       83,  -43,    8,
      33,   68,  -69,       35,   62,  -66,       40,   48,  -57,       47,   29,  -46,
      55,    9,  -33,       64,   -9,  -19,       73,  -25,   -5,       83,  -41,    9,
      34,   69,  -67,       36,   63,  -64,       41,   49,  -56,       48,   31,  -45,
      56,   12,  -32,       65,   -7,  -18,       74,  -23,   -5,       83,  -39,    9,
      35,   70,  -65,       37,   64,  -62,       42,   51,  -54,       48,   34,  -43,
      57,   14,  -31,       65,   -4,  -17,       74,  -21,   -4,       84,  -37,   10,
      36,   71,  -63,       38,   66,  -60,       43,   53,  -52,       49,   36,  -42,
      57,   17,  -30,       66,   -2,  -16,       75,  -19,   -3,       84,  -35,   10,
      38,   72,  -60,       40,   67,  -58,       44,   55,  -51,       50,   38,  -41,
      58,   19,  -28,       66,    1,  -16,       75,  -16,   -2,       84,  -32,   11,
      39,   73,  -58,       41,   68,  -55,       45,   57,  -49,       51,   40,  -39,
      59,   22,  -27,       67,    4,  -15,       76,  -14,   -2,       85,  -30,   12,
      41,   75,  -56,       42,   70,  -53,       46,   59,  -47,       52,   43,  -37,
      60,   25,  -26,       68,    7,  -13,       76,  -11,   -1,       85,  -27,   12,
      42,   76,  -53,       44,   71,  -51,       47,   61,  -45,       53,   45,  -36,
      60,   27,  -25,       68,    9,  -12,       77,   -8,    0,       86,  -25,   13,
      44,   77,  -51,       45,   73,  -49,       49,   62,  -43,       54,   48,  -34,
      61,   30,  -23,       69,   12,  -11,       77,   -5,    1,       86,  -22,   14,
      45,   78,  -49,       46,   74,  -46,       50,   64,  -41,       55,   50,  -32,
      62,   32,  -22,       70,   15,  -10,       78,   -3,    2,       87,  -20,   15,
      46,   80,  -46,       48,   76,  -44,       51,   66,  -39,       56,   52,  -31,
      63,   35,  -20,       70,   17,   -9,       79,    0,    3,       87,  -17,   15,
      48,   81,  -43,       49,   77,  -41,       52,   68,  -36,       57,   55,  -29,
      64,   38,  -19,       71,   21,   -8,       79,    3,    4,       88,  -14,   16,
      49,   83,  -41,       51,   79,  -39,       54,   70,  -34,       59,   57,  -27,
      65,   41,  -17,       72,   23,   -6,       80,    6,    5,       88,  -11,   17,
      51,   84,  -39,       52,   81,  -37,       55,   72,  -32,       60,   59,  -25,
      66,   43,  -16,       73,   26,   -5,       81,    9,    6,       89,   -8,   18,
      52,   85,  -36,       54,   82,  -35,       56,   74,  -30,       61,   62,  -23,
      67,   46,  -14,       74,   29,   -4,       81,   12,    7,       90,   -5,   19,
      54,   87,  -34,       55,   84,  -32,       58,   76,  -28,       62,   64,  -21,
      68,   49,  -12,       75,   32,   -2,       82,   15,    9,       90,   -2,   20,
      56,   89,  -31,       57,   86,  -30,       59,   78,  -25,       63,   66,  -19,
      69,   51,  -11,       76,   35,   -1,       83,   18,   10,       91,    1,   21,
      57,   90,  -29,       58,   87,  -27,       61,   80,  -23,       65,   69,  -17,
      70,   54,   -9,       77,   38,    1,       84,   21,   11,       92,    4,   22,
      24,   65,  -89,       27,   56,  -84,       34,   37,  -73,       42,   16,  -59,
      52,   -5,  -43,       62,  -23,  -28,       71,  -38,  -13,       81,  -52,    2,
      24,   65,  -89,       27,   56,  -83,       34,   37,  -72,       42,   16,  -58,
      52,   -5,  -43,       62,  -22,  -28,       71,  -38,  -13,       81,  -52,    2,
      24,   65,  -88,       27,   56,  -83,       34,   37,  -72,       42,   16,  -58,
      52,   -4,  -43,       62,  -22,  -28,       71,  -38,  -13,       81,  -52,    2,
      24,   65,  -88,       27,   56,  -83,       34,   38,  -72,       42,   17,  -58,
      52,   -4,  -43,       62,  -22,  -28,       71,  -37,  -13,       81,  -52,    2,
      25,   66,  -87,       28,   56,  -82,       34,   38,  -71,       43,   17,  -58,
      52,   -3,  -42,       62,  -21,  -27,       72,  -37,  -13,       81,  -51,    2,
      25,   66,  -86,       28,   57,  -81,       35,   39,  -71,       43,   18,  -57,
      52,   -2,  -42,       62,  -20,  -27,       72,  -36,  -12,       82,  -51,    2,
      26,   66,  -85,       29,   57,  -81,       35,   40,  -70,       43,   19,  -57,
      53,   -2,  -42,       62,  -19,  -27,       72,  -35,  -12,       82,  -50,    2,
      27,   66,  -84,       29,   58,  -80,       35,   41,  -69,       43,   20,  -56,
      53,    0,  -41,       62,  -18,  -27,       72,  -34,  -12,       82,  -49,    3,
      27,   67,  -83,       30,   58,  -78,       36,   42,  -69,       44,   21,  -56,
      53,    1,  -41,       63,  -17,  -26,       72,  -33,  -12,       82,  -48,    3,
      28,   67,  -82,       31,   59,  -77,       36,   43,  -68,       44,   23,  -55,
      53,    2,  -40,       63,  -16,  -26,       72,  -32,  -11,       82,  -47,    3,
      29,   67,  -80,       31,   60,  -76,       37,   44,  -67,       45,   24,  -54,
      54,    4,  -40,       63,  -14,  -25,       73,  -31,  -11,       82,  -46,    3,
      30,   68,  -78,       32,   61,  -74,       38,   45,  -65,       45,   26,  -53,
      54,    6,  -39,       63,  -13,  -25,       73,  -29,  -11,       82,  -44,    4,
      31,   69,  -76,       33,   62,  -73,       39,   47,  -64,       46,   28,  -52,
      55,    8,  -38,       64,  -11,  -24,       73,  -27,  -10,       83,  -43,    4,
      32,   69,  -75,       34,   63,  -71,       39,   48,  -63,       47,   30,  -51,
      55,   10,  -37,       64,   -9,  -24,       73,  -25,  -10,       83,  -41,    4,
      33,   70,  -73,       35,   64,  -69,       40,   50,  -61,       47,   32,  -50,
      56,   12,  -37,       65,   -7,  -23,       74,  -23,   -9,       83,  -39,    5,
      34,   71,  -71,       37,   65,  -67,       41,   51,  -60,       48,   34,  -49,
      56,   14,  -36,       65,   -4,  -22,       74,  -21,   -9,       84,  -37,    5,
      36,   72,  -68,       38,   66,  -65,       42,   53,  -58,       49,   36,  -47,
      57,   16,  -35,       66,   -2,  -21,       75,  -19,   -8,       84,  -35,    6,
      37,   73,  -66,       39,   67,  -63,       43,   55,  -56,       50,   38,  -46,
      58,   19,  -34,       66,    0,  -20,       75,  -17,   -7,       84,  -33,    6,
      38,   74,  -64,       40,   69,  -61,       44,   57,  -54,       51,   40,  -45,
      58,   21,  -32,       67,    3,  -20,       75,  -14,   -6,       85,  -31,    7,
      40,   75,  -62,       41,   70,  -59,       45,   58,  -53,       51,   42,  -43,
      59,   24,  -31,       67,    5,  -19,       76,  -12,   -6,       85,  -28,    8,
      41,   76,  -59,       43,   71,  -57,       47,   60,  -51,       52,   45,  -41,
      60,   26,  -30,       68,    8,  -18,       76,   -9,   -5,       85,  -26,    8,
      43,   77,  -57,       44,   73,  -55,       48,   62,  -49,       53,   47,  -40,
      61,   29,  -29,       69,   11,  -16,       77,   -7,   -4,       86,  -23,    9,
      44,   78,  -55,       45,   74,  -52,       49,   64,  -47,       54,   49,  -38,
      61,   31,  -27,       69,   14,  -15,       78,   -4,   -3,       86,  -21,   10,
      45,   80,  -52,       47,   76,  -50,       50,   66,  -45,       55,   51,  -36,
      62,   34,  -26,       70,   16,  -14,       78,   -1,   -2,       87,  -18,   11,
      47,   81,  -50,       48,   77,  -48,       51,   68,  -43,       57,   54,  -35,
      63,   37,  -24,       71,   19,  -13,       79,    2,   -1,       87,  -15,   11,
      48,   82,  -47,       50,   79,  -45,       53,   70,  -40,       58,   56,  -33,
      64,   39,  -23,       72,   22,  -12,       79,    5,    0,       88,  -12,   12,
      50,   84,  -45,       51,   80,  -43,       54,   71,  -38,       59,   58,  -31,
      65,   42,  -21,       72,   25,  -10,       80,    8,    1,       89,  -10,   13,
      51,   85,  -43,       53,   82,  -41,       55,   73,  -36,       60,   61,  -29,
      66,   45,  -20,       73,   28,   -9,       81,   10,    2,       89,   -7,   14,
      53,   86,  -40,       54,   83,  -39,       57,   75,  -34,       61,   63,  -27,
      67,   47,  -18,       74,   30,   -8,       82,   13,    3,       90,   -4,   15,
      54,   88,  -38,       55,   85,  -36,       58,   77,  -32,       62,   65,  -25,
      68,   50,  -16,       75,   33,   -6,       82,   16,    5,       90,   -1,   16,
      56,   89,  -35,       57,   86,  -34,       60,   79,  -30,       64,   68,  -23,
      69,   53,  -15,       76,   36,   -5,       83,   19,    6,       91,    2,   17,
      57,   91,  -33,       58,   88,  -31,       61,   81,  -27,       65,   70,  -21,
      70,   55,  -13,       77,   39,   -3,       84,   22,    7,       92,    5,   18,
      25,   67,  -92,       28,   58,  -87,       34,   40,  -76,       43,   19,  -63,
      52,   -1,  -47,       62,  -20,  -32,       72,  -35,  -17,       82,  -50,   -3,
      25,   67,  -92,       28,   59,  -87,       35,   40,  -76,       43,   20,  -63,
      52,   -1,  -47,       62,  -19,  -32,       72,  -35,  -17,       82,  -50,   -3,
      25,   68,  -91,       28,   59,  -86,       35,   41,  -76,       43,   20,  -62,
      52,   -1,  -47,       62,  -19,  -32,       72,  -35,  -17,       82,  -50,   -3,
      26,   68,  -91,       29,   59,  -86,       35,   41,  -76,       43,   20,  -62,
      53,    0,  -47,       62,  -19,  -32,       72,  -35,  -17,       82,  -49,   -3,
      26,   68,  -90,       29,   59,  -85,       35,   42,  -75,       43,   21,  -62,
      53,    0,  -47,       62,  -18,  -32,       72,  -34,  -17,       82,  -49,   -2,
      27,   68,  -89,       29,   59,  -85,       35,   42,  -75,       43,   22,  -62,
      53,    1,  -47,       62,  -17,  -32,       72,  -33,  -17,       82,  -48,   -2,
      27,   68,  -89,       30,   60,  -84,       36,   43,  -74,       44,   22,  -61,
      53,    2,  -46,       62,  -16,  -31,       72,  -33,  -17,       82,  -48,   -2,
      28,   68,  -87,       30,   60,  -83,       36,   44,  -73,       44,   24,  -61,
      53,    3,  -46,       63,  -15,  -31,       72,  -32,  -17,       82,  -47,   -2,
      28,   69,  -86,       31,   61,  -82,       37,   45,  -72,       44,   25,  -60,
      54,    4,  -45,       63,  -14,  -31,       72,  -31,  -16,       82,  -46,   -2,
      29,   69,  -85,       32,   62,  -81,       37,   46,  -72,       45,   26,  -59,
      54,    5,  -45,       63,  -13,  -30,       73,  -29,  -16,       82,  -45,   -1,
      30,   69,  -84,       32,   62,  -80,       38,   47,  -71,       45,   27,  -58,
      54,    7,  -44,       63,  -11,  -30,       73,  -28,  -16,       82,  -43,   -1,
      31,   70,  -82,       33,   63,  -78,       39,   48,  -69,       46,   29,  -58,
      55,    9,  -44,       64,  -10,  -29,       73,  -27,  -15,       83,  -42,   -1,
      32,   71,  -80,       34,   64,  -76,       39,   49,  -68,       47,   31,  -56,
      55,   11,  -43,       64,   -8,  -29,       73,  -25,  -15,       83,  -40,    0,
      33,   71,  -78,       35,   65,  -75,       40,   51,  -67,       47,   32,  -55,
      56,   12,  -42,       65,   -6,  -28,       74,  -23,  -14,       83,  -39,    0,
      34,   72,  -77,       36,   66,  -73,       41,   52,  -65,       48,   34,  -54,
      56,   14,  -41,       65,   -4,  -27,       74,  -21,  -14,       83,  -37,    0,
      35,   73,  -75,       37,   67,  -71,       42,   54,  -64,       49,   36,  -53,
      57,   16,  -40,       65,   -2,  -27,       74,  -19,  -13,       84,  -35,    1,
      37,   74,  -72,       39,   68,  -69,       43,   55,  -62,       49,   38,  -52,
      57,   19,  -39,       66,    0,  -26,       75,  -17,  -12,       84,  -33,    1,
      38,   74,  -70,       40,   69,  -67,       44,   57,  -60,       50,   40,  -50,
      58,   21,  -38,       66,    3,  -25,       75,  -15,  -12,       84,  -31,    2,
      39,   75,  -68,       41,   70,  -65,       45,   59,  -59,       51,   42,  -49,
      59,   23,  -37,       67,    5,  -24,       76,  -12,  -11,       85,  -29,    3,
      40,   76,  -66,       42,   72,  -63,       46,   60,  -57,       52,   44,  -48,
      59,   26,  -36,       68,    7,  -23,       76,  -10,  -10,       85,  -27,    3,
      42,   78,  -64,       43,   73,  -61,       47,   62,  -55,       53,   47,  -46,
      60,   28,  -34,       68,   10,  -22,       77,   -7,   -9,       86,  -24,    4,
      43,   79,  -61,       45,   74,  -59,       48,   64,  -53,       54,   49,  -44,
      61,   31,  -33,       69,   13,  -21,       77,   -5,   -8,       86,  -22,    5,
      45,   80,  -59,       46,   76,  -57,       50,   66,  -51,       55,   51,  -43,
      62,   33,  -32,       70,   15,  -20,       78,   -2,   -8,       87,  -19,    5,
      46,   81,  -57,       47,   77,  -55,       51,   67,  -49,       56,   53,  -41,
      63,   36,  -30,       70,   18,  -19,       78,    1,   -7,       87,  -16,    6,
      47,   82,  -54,       49,   78,  -52,       52,   69,  -47,       57,   55,  -39,
      64,   38,  -29,       71,   21,  -18,       79,    3,   -6,       88,  -14,    7,
      49,   84,  -52,       50,   80,  -50,       53,   71,  -45,       58,   58,  -37,
      65,   41,  -27,       72,   24,  -16,       80,    6,   -4,       88,  -11,    8,
      50,   85,  -49,       52,   81,  -48,       55,   73,  -43,       59,   60,  -35,
      66,   44,  -26,       73,   26,  -15,       80,    9,   -3,       89,   -8,    9,
      52,   86,  -47,       53,   83,  -45,       56,   75,  -41,       60,   62,  -34,
      66,   46,  -24,       73,   29,  -14,       81,   12,   -2,       89,   -5,   10,
      53,   88,  -45,       54,   84,  -43,       57,   76,  -39,       62,   64,  -32,
      67,   49,  -23,       74,   32,  -12,       82,   15,   -1,       90,   -3,   11,
      55,   89,  -42,       56,   86,  -40,       59,   78,  -36,       63,   67,  -30,
      69,   51,  -21,       75,   35,  -11,       83,   18,    0,       91,    1,   12,
      56,   91,  -40,       57,   88,  -38,       60,   80,  -34,       64,   69,  -28,
      70,   54,  -19,       76,   38,   -9,       83,   21,    1,       91,    3,   13,
      58,   92,  -37,       59,   89,  -36,       61,   82,  -32,       65,   71,  -26,
      71,   56,  -17,       77,   40,   -8,       84,   24,    2,       92,    6,   14,
      26,   69,  -94,       29,   61,  -90,       35,   43,  -80,       43,   23,  -66,
      53,    2,  -51,       62,  -17,  -36,       72,  -33,  -21,       82,  -48,   -7,
      26,   69,  -94,       29,   61,  -90,       35,   43,  -79,       43,   23,  -66,
      53,    2,  -51,       62,  -16,  -36,       72,  -33,  -21,       82,  -48,   -7,
      27,   69,  -94,       29,   61,  -89,       35,   44,  -79,       44,   23,  -66,
      53,    2,  -51,       62,  -16,  -36,       72,  -32,  -21,       82,  -47,   -7,
      27,   70,  -93,       30,   61,  -89,       36,   44,  -79,       44,   23,  -66,
      53,    3,  -51,       62,  -16,  -36,       72,  -32,  -21,       82,  -47,   -6,
      27,   70,  -93,       30,   61,  -88,       36,   44,  -79,       44,   24,  -66,
      53,    3,  -51,       63,  -15,  -36,       72,  -32,  -21,       82,  -47,   -6,
      28,   70,  -92,       30,   62,  -88,       36,   45,  -78,       44,   25,  -65,
      53,    4,  -50,       63,  -15,  -36,       72,  -31,  -21,       82,  -46,   -6,
      28,   70,  -91,       31,   62,  -87,       37,   46,  -77,       44,   25,  -65,
      53,    5,  -50,       63,  -14,  -35,       72,  -30,  -21,       82,  -45,   -6,
      29,   70,  -90,       31,   63,  -86,       37,   46,  -77,       45,   26,  -64,
      54,    6,  -50,       63,  -13,  -35,       72,  -29,  -20,       82,  -44,   -6,
      29,   71,  -89,       32,   63,  -85,       37,   47,  -76,       45,   28,  -64,
      54,    7,  -49,       63,  -12,  -35,       73,  -28,  -20,       82,  -44,   -6,
      30,   71,  -88,       33,   64,  -84,       38,   48,  -75,       45,   29,  -63,
      54,    8,  -49,       63,  -10,  -34,       73,  -27,  -20,       83,  -42,   -5,
      31,   71,  -87,       33,   64,  -83,       39,   49,  -74,       46,   30,  -62,
      55,   10,  -48,       64,   -9,  -34,       73,  -26,  -20,       83,  -41,   -5,
      32,   72,  -85,       34,   65,  -81,       39,   50,  -73,       46,   31,  -61,
      55,   11,  -47,       64,   -7,  -33,       73,  -24,  -19,       83,  -40,   -5,
      33,   72,  -83,       35,   66,  -80,       40,   52,  -72,       47,   33,  -60,
      56,   13,  -47,       64,   -6,  -33,       74,  -23,  -19,       83,  -38,   -4,
      34,   73,  -82,       36,   67,  -78,       41,   53,  -70,       48,   35,  -59,
      56,   15,  -46,       65,   -4,  -32,       74,  -21,  -18,       83,  -37,   -4,
      35,   74,  -80,       37,   68,  -77,       42,   54,  -69,       48,   36,  -58,
      57,   17,  -45,       65,   -2,  -31,       74,  -19,  -18,       84,  -35,   -4,
      36,   74,  -78,       38,   69,  -75,       43,   56,  -67,       49,   38,  -57,
      57,   19,  -44,       66,    0,  -31,       75,  -17,  -17,       84,  -33,   -3,
      37,   75,  -76,       39,   70,  -73,       44,   57,  -66,       50,   40,  -56,
      58,   21,  -43,       66,    3,  -30,       75,  -15,  -16,       84,  -31,   -2,
      39,   76,  -74,       40,   71,  -71,       45,   59,  -64,       51,   42,  -54,
      58,   23,  -42,       67,    5,  -29,       75,  -13,  -16,       85,  -29,   -2,
      40,   77,  -72,       42,   72,  -69,       46,   60,  -62,       51,   44,  -53,
      59,   25,  -41,       67,    7,  -28,       76,  -10,  -15,       85,  -27,   -1,
      41,   78,  -70,       43,   73,  -67,       47,   62,  -61,       52,   46,  -51,
      60,   28,  -40,       68,    9,  -27,       76,   -8,  -14,       85,  -25,   -1,
      43,   79,  -67,       44,   74,  -65,       48,   64,  -59,       53,   48,  -50,
      61,   30,  -38,       69,   12,  -26,       77,   -5,  -13,       86,  -22,    0,
      44,   80,  -65,       45,   76,  -63,       49,   65,  -57,       54,   51,  -48,
      61,   33,  -37,       69,   15,  -25,       77,   -3,  -12,       86,  -20,    1,
      45,   81,  -63,       47,   77,  -60,       50,   67,  -55,       55,   53,  -47,
      62,   35,  -36,       70,   17,  -24,       78,    0,  -12,       87,  -17,    1,
      47,   82,  -60,       48,   78,  -58,       51,   69,  -53,       56,   55,  -45,
      63,   37,  -34,       71,   20,  -23,       79,    2,  -11,       87,  -15,    2,
      48,   83,  -58,       49,   80,  -56,       52,   70,  -51,       57,   57,  -43,
      64,   40,  -33,       71,   22,  -22,       79,    5,  -10,       88,  -12,    3,
      49,   85,  -56,       51,   81,  -54,       54,   72,  -49,       59,   59,  -41,
      65,   43,  -31,       72,   25,  -20,       80,    8,   -8,       88,   -9,    4,
      51,   86,  -53,       52,   83,  -51,       55,   74,  -47,       60,   61,  -39,
      66,   45,  -30,       73,   28,  -19,       81,   11,   -7,       89,   -7,    5,
      52,   87,  -51,       53,   84,  -49,       56,   76,  -45,       61,   63,  -38,
      67,   47,  -28,       74,   31,  -18,       81,   13,   -6,       90,   -4,    6,
      54,   89,  -49,       55,   85,  -47,       58,   78,  -43,       62,   65,  -36,
      68,   50,  -27,       75,   33,  -16,       82,   16,   -5,       90,   -1,    7,
      55,   90,  -46,       56,   87,  -44,       59,   80,  -40,       63,   68,  -34,
      69,   53,  -25,       75,   36,  -15,       83,   19,   -4,       91,    2,    8,
      57,   92,  -44,       58,   89,  -42,       60,   81,  -38,       64,   70,  -32,
      70,   55,  -23,       76,   39,  -13,       84,   22,   -3,       91,    5,    9,
      58,   93,  -41,       59,   90,  -40,       62,   83,  -36,       65,   72,  -30,
      71,   57,  -22,       77,   41,  -12,       84,   25,   -1,       92,    8,   10,
      28,   71,  -97,       30,   63,  -93,       36,   46,  -83,       44,   26,  -70,
      53,    5,  -55,       63,  -14,  -40,       72,  -30,  -25,       82,  -45,  -11,
      28,   71,  -97,       30,   63,  -92,       36,   46,  -83,       44,   26,  -70,
      53,    5,  -55,       63,  -14,  -40,       72,  -30,  -25,       82,  -45,  -10,
      28,   71,  -97,       30,   63,  -92,       36,   46,  -83,       44,   26,  -70,
      53,    5,  -55,       63,  -13,  -40,       72,  -30,  -25,       82,  -45,  -10,
      28,   72,  -96,       31,   64,  -92,       36,   47,  -82,       44,   27,  -69,
      53,    6,  -55,       63,  -13,  -40,       72,  -29,  -25,       82,  -45,  -10,
      28,   72,  -96,       31,   64,  -91,       37,   47,  -82,       44,   27,  -69,
      54,    6,  -54,       63,  -12,  -40,       72,  -29,  -25,       82,  -44,  -10,
      29,   72,  -95,       31,   64,  -91,       37,   48,  -81,       45,   28,  -69,
      54,    7,  -54,       63,  -12,  -39,       72,  -28,  -25,       82,  -44,  -10,
      29,   72,  -94,       32,   64,  -90,       37,   48,  -81,       45,   28,  -68,
      54,    8,  -54,       63,  -11,  -39,       73,  -28,  -25,       82,  -43,  -10,
      30,   72,  -93,       32,   65,  -89,       38,   49,  -80,       45,   29,  -68,
      54,    9,  -53,       63,  -10,  -39,       73,  -27,  -24,       82,  -42,  -10,
      30,   72,  -92,       33,   65,  -88,       38,   50,  -79,       46,   30,  -67,
      54,   10,  -53,       64,   -9,  -39,       73,  -26,  -24,       83,  -41,  -10,
      31,   73,  -91,       33,   66,  -87,       39,   51,  -78,       46,   31,  -67,
      55,   11,  -52,       64,   -8,  -38,       73,  -25,  -24,       83,  -40,   -9,
      32,   73,  -90,       34,   66,  -86,       39,   52,  -77,       46,   33,  -66,
      55,   12,  -52,       64,   -6,  -38,       73,  -23,  -23,       83,  -39,   -9,
      33,   74,  -88,       35,   67,  -85,       40,   53,  -76,       47,   34,  -65,
      55,   14,  -51,       64,   -5,  -37,       74,  -22,  -23,       83,  -38,   -9,
      34,   74,  -86,       36,   68,  -83,       41,   54,  -75,       48,   36,  -64,
      56,   16,  -50,       65,   -3,  -37,       74,  -20,  -23,       83,  -36,   -8,
      35,   75,  -85,       37,   69,  -81,       42,   55,  -74,       48,   37,  -63,
      56,   17,  -50,       65,   -1,  -36,       74,  -19,  -22,       84,  -35,   -8,
      36,   75,  -83,       38,   69,  -80,       42,   56,  -72,       49,   39,  -62,
      57,   19,  -49,       66,    0,  -35,       75,  -17,  -22,       84,  -33,   -7,
      37,   76,  -81,       39,   70,  -78,       43,   58,  -71,       50,   41,  -61,
      58,   21,  -48,       66,    2,  -35,       75,  -15,  -21,       84,  -31,   -7,
      38,   77,  -79,       40,   71,  -76,       44,   59,  -69,       50,   43,  -59,
      58,   23,  -47,       67,    5,  -34,       75,  -13,  -20,       85,  -29,   -6,
      39,   78,  -77,       41,   72,  -74,       45,   61,  -68,       51,   44,  -58,
      59,   25,  -46,       67,    7,  -33,       76,  -11,  -20,       85,  -27,   -6,
      41,   78,  -75,       42,   74,  -72,       46,   62,  -66,       52,   46,  -57,
      59,   27,  -45,       68,    9,  -32,       76,   -8,  -19,       85,  -25,   -5,
      42,   79,  -73,       43,   75,  -71,       47,   64,  -64,       53,   48,  -55,
      60,   30,  -44,       68,   11,  -31,       77,   -6,  -18,       86,  -23,   -5,
      43,   80,  -71,       45,   76,  -68,       48,   65,  -62,       54,   50,  -53,
      61,   32,  -42,       69,   14,  -30,       77,   -4,  -17,       86,  -21,   -4,
      44,   81,  -69,       46,   77,  -66,       49,   67,  -61,       55,   52,  -52,
      62,   34,  -41,       69,   16,  -29,       78,   -1,  -16,       87,  -18,   -3,
      46,   82,  -66,       47,   78,  -64,       51,   69,  -59,       56,   54,  -50,
      63,   37,  -40,       70,   19,  -28,       78,    1,  -15,       87,  -16,   -2,
      47,   84,  -64,       48,   80,  -62,       52,   70,  -57,       57,   56,  -49,
      63,   39,  -38,       71,   21,  -27,       79,    4,  -15,       88,  -13,   -2,
      48,   85,  -62,       50,   81,  -60,       53,   72,  -55,       58,   58,  -47,
      64,   41,  -37,       72,   24,  -26,       79,    6,  -14,       88,  -11,   -1,
      50,   86,  -59,       51,   82,  -57,       54,   74,  -53,       59,   61,  -45,
      65,   44,  -35,       72,   27,  -24,       80,    9,  -12,       89,   -8,    0,
      51,   87,  -57,       53,   84,  -55,       55,   75,  -51,       60,   63,  -43,
      66,   46,  -34,       73,   29,  -23,       81,   12,  -11,       89,   -5,    1,
      53,   88,  -55,       54,   85,  -53,       57,   77,  -49,       61,   65,  -42,
      67,   49,  -32,       74,   32,  -22,       82,   15,  -10,       90,   -3,    2,
      54,   90,  -52,       55,   87,  -51,       58,   79,  -46,       62,   67,  -40,
      68,   51,  -31,       75,   35,  -20,       82,   17,   -9,       90,    0,    3,
      56,   91,  -50,       57,   88,  -48,       59,   81,  -44,       63,   69,  -38,
      69,   54,  -29,       76,   38,  -19,       83,   21,   -8,       91,    3,    4,
      57,   93,  -48,       58,   90,  -46,       61,   82,  -42,       65,   71,  -36,
      70,   56,  -27,       77,   40,  -17,       84,   23,   -7,       92,    6,    5,
      59,   94,  -45,       59,   91,  -44,       62,   84,  -40,       66,   73,  -34,
      71,   59,  -25,       78,   43,  -16,       85,   26,   -5,       92,    9,    6,
      29,   73, -100,       31,   65,  -96,       37,   49,  -86,       45,   29,  -73,
      54,    8,  -59,       63,  -11,  -44,       72,  -28,  -29,       82,  -43,  -14,
      29,   73, -100,       31,   66,  -95,       37,   49,  -86,       45,   29,  -73,
      54,    8,  -59,       63,  -11,  -44,       72,  -27,  -29,       82,  -43,  -14,
      29,   73,  -99,       31,   66,  -95,       37,   49,  -86,       45,   29,  -73,
      54,    8,  -59,       63,  -10,  -44,       72,  -27,  -29,       82,  -43,  -14,
      29,   73,  -99,       32,   66,  -95,       37,   50,  -85,       45,   30,  -73,
      54,    9,  -58,       63,  -10,  -44,       73,  -27,  -29,       82,  -42,  -14,
      30,   74,  -98,       32,   66,  -94,       38,   50,  -85,       45,   30,  -73,
      54,    9,  -58,       63,  -10,  -44,       73,  -26,  -29,       82,  -42,  -14,
      30,   74,  -98,       32,   66,  -94,       38,   50,  -85,       45,   31,  -72,
      54,   10,  -58,       63,   -9,  -43,       73,  -26,  -29,       82,  -41,  -14,
      30,   74,  -97,       33,   67,  -93,       38,   51,  -84,       46,   31,  -72,
      54,   11,  -58,       64,   -8,  -43,       73,  -25,  -29,       83,  -41,  -14,
      31,   74,  -96,       33,   67,  -92,       39,   52,  -83,       46,   32,  -71,
      55,   12,  -57,       64,   -7,  -43,       73,  -24,  -28,       83,  -40,  -14,
      32,   74,  -95,       34,   67,  -91,       39,   52,  -83,       46,   33,  -71,
      55,   13,  -57,       64,   -6,  -42,       73,  -23,  -28,       83,  -39,  -13,
      32,   75,  -94,       34,   68,  -90,       39,   53,  -82,       47,   34,  -70,
      55,   14,  -56,       64,   -5,  -42,       73,  -22,  -28,       83,  -38,  -13,
      33,   75,  -93,       35,   68,  -89,       40,   54,  -81,       47,   35,  -69,
      56,   15,  -56,       64,   -4,  -42,       74,  -21,  -27,       83,  -37,  -13,
      34,   75,  -91,       36,   69,  -88,       41,   55,  -80,       48,   37,  -69,
      56,   16,  -55,       65,   -2,  -41,       74,  -20,  -27,       83,  -36,  -13,
      35,   76,  -90,       37,   70,  -86,       41,   56,  -78,       48,   38,  -67,
      56,   18,  -54,       65,   -1,  -40,       74,  -18,  -26,       84,  -34,  -12,
      36,   76,  -88,       38,   71,  -85,       42,   57,  -77,       49,   40,  -66,
      57,   20,  -53,       65,    1,  -40,       74,  -16,  -26,       84,  -33,  -12,
      37,   77,  -86,       39,   71,  -83,       43,   58,  -76,       49,   41,  -65,
      57,   22,  -53,       66,    3,  -39,       75,  -15,  -25,       84,  -31,  -11,
      38,   78,  -84,       40,   72,  -82,       44,   60,  -74,       50,   43,  -64,
      58,   23,  -52,       66,    5,  -38,       75,  -13,  -25,       84,  -29,  -11,
      39,   78,  -82,       41,   73,  -80,       45,   61,  -73,       51,   45,  -63,
      59,   26,  -51,       67,    7,  -38,       76,  -11,  -24,       85,  -27,  -10,
      40,   79,  -81,       42,   74,  -78,       46,   63,  -71,       52,   46,  -62,
      59,   28,  -50,       67,    9,  -37,       76,   -9,  -23,       85,  -25,  -10,
      41,   80,  -79,       43,   75,  -76,       47,   64,  -70,       52,   48,  -60,
      60,   30,  -48,       68,   11,  -36,       76,   -6,  -23,       85,  -23,   -9,
      42,   81,  -77,       44,   76,  -74,       48,   65,  -68,       53,   50,  -59,
      61,   32,  -47,       68,   13,  -35,       77,   -4,  -22,       86,  -21,   -9,
      44,   82,  -74,       45,   77,  -72,       49,   67,  -66,       54,   52,  -57,
      61,   34,  -46,       69,   16,  -34,       77,   -2,  -21,       86,  -19,   -8,
      45,   83,  -72,       46,   79,  -70,       50,   69,  -64,       55,   54,  -56,
      62,   36,  -45,       70,   18,  -33,       78,    1,  -20,       87,  -16,   -7,
      46,   84,  -70,       48,   80,  -68,       51,   70,  -62,       56,   56,  -54,
      63,   39,  -43,       70,   21,  -32,       79,    3,  -19,       87,  -14,   -6,
      48,   85,  -68,       49,   81,  -66,       52,   72,  -60,       57,   58,  -53,
      64,   41,  -42,       71,   23,  -31,       79,    6,  -18,       88,  -12,   -6,
      49,   86,  -66,       50,   82,  -64,       53,   73,  -59,       58,   60,  -51,
      65,   43,  -41,       72,   26,  -29,       80,    8,  -17,       88,   -9,   -5,
      50,   87,  -63,       52,   84,  -61,       55,   75,  -56,       59,   62,  -49,
      66,   46,  -39,       73,   28,  -28,       80,   11,  -16,       89,   -6,   -4,
      52,   88,  -61,       53,   85,  -59,       56,   77,  -54,       60,   64,  -47,
      67,   48,  -38,       73,   31,  -27,       81,   14,  -15,       89,   -4,   -3,
      53,   90,  -59,       54,   86,  -57,       57,   78,  -52,       61,   66,  -45,
      67,   50,  -36,       74,   33,  -26,       82,   16,  -14,       90,   -1,   -2,
      55,   91,  -56,       56,   88,  -55,       58,   80,  -50,       63,   68,  -44,
      68,   53,  -35,       75,   36,  -24,       82,   19,  -13,       91,    2,   -1,
      56,   92,  -54,       57,   89,  -52,       60,   82,  -48,       64,   70,  -42,
      69,   55,  -33,       76,   39,  -23,       83,   22,  -12,       91,    5,    0,
      58,   94,  -51,       59,   91,  -50,       61,   83,  -46,       65,   72,  -40,
      70,   58,  -31,       77,   41,  -21,       84,   25,  -11,       92,    7,    1,
      59,   95,  -49,       60,   92,  -48,       62,   85,  -44,       66,   74,  -38,
      72,   60,  -29,       78,   44,  -20,       85,   27,   -9,       93,   10,    2,
      30,   75, -103,       32,   68,  -99,       38,   52,  -90,       45,   32,  -77,
      54,   11,  -63,       63,   -8,  -48,       73,  -25,  -34,       82,  -40,  -19,
      30,   75, -102,       33,   68,  -98,       38,   52,  -89,       45,   32,  -77,
      54,   12,  -63,       63,   -7,  -48,       73,  -24,  -34,       82,  -40,  -19,
      30,   75, -102,       33,   68,  -98,       38,   52,  -89,       45,   33,  -77,
      54,   12,  -63,       63,   -7,  -48,       73,  -24,  -33,       83,  -40,  -19,
      30,   76, -102,       33,   68,  -98,       38,   53,  -89,       46,   33,  -77,
      54,   12,  -62,       64,   -7,  -48,       73,  -24,  -33,       83,  -40,  -19,
      31,   76, -101,       33,   68,  -97,       38,   53,  -89,       46,   33,  -77,
      55,   13,  -62,       64,   -6,  -48,       73,  -23,  -33,       83,  -39,  -18,
      31,   76, -101,       33,   69,  -97,       39,   53,  -88,       46,   34,  -76,
      55,   13,  -62,       64,   -6,  -48,       73,  -23,  -33,       83,  -39,  -18,
      32,   76, -100,       34,   69,  -96,       39,   54,  -88,       46,   35,  -76,
      55,   14,  -62,       64,   -5,  -47,       73,  -22,  -33,       83,  -38,  -18,
      32,   76,  -99,       34,   69,  -95,       39,   55,  -87,       47,   35,  -75,
      55,   15,  -61,       64,   -4,  -47,       73,  -21,  -33,       83,  -37,  -18,
      33,   76,  -98,       35,   70,  -95,       40,   55,  -86,       47,   36,  -75,
      55,   16,  -61,       64,   -3,  -47,       74,  -20,  -32,       83,  -37,  -18,
      33,   77,  -97,       35,   70,  -94,       40,   56,  -85,       47,   37,  -74,
      56,   17,  -60,       65,   -2,  -46,       74,  -19,  -32,       83,  -36,  -18,
      34,   77,  -96,       36,   71,  -92,       41,   57,  -84,       48,   38,  -73,
      56,   18,  -60,       65,   -1,  -46,       74,  -18,  -32,       83,  -34,  -17,
      35,   77,  -95,       37,   71,  -91,       42,   58,  -83,       48,   40,  -72,
      56,   19,  -59,       65,    1,  -45,       74,  -17,  -31,       84,  -33,  -17,
      36,   78,  -93,       38,   72,  -90,       42,   59,  -82,       49,   41,  -71,
      57,   21,  -58,       66,    2,  -45,       74,  -15,  -31,       84,  -32,  -16,
      37,   78,  -91,       39,   73,  -88,       43,   60,  -81,       49,   42,  -71,
      57,   23,  -58,       66,    4,  -44,       75,  -14,  -30,       84,  -30,  -16,
      38,   79,  -90,       39,   73,  -87,       44,   61,  -80,       50,   44,  -69,
      58,   24,  -57,       66,    6,  -43,       75,  -12,  -30,       84,  -29,  -16,
      39,   79,  -88,       40,   74,  -85,       45,   62,  -78,       51,   45,  -68,
      58,   26,  -56,       67,    7,  -43,       75,  -10,  -29,       85,  -27,  -15,
      40,   80,  -86,       41,   75,  -83,       46,   63,  -77,       51,   47,  -67,
      59,   28,  -55,       67,   10,  -42,       76,   -8,  -28,       85,  -25,  -15,
      41,   81,  -84,       43,   76,  -82,       46,   65,  -75,       52,   49,  -66,
      60,   30,  -54,       68,   12,  -41,       76,   -6,  -28,       85,  -23,  -14,
      42,   82,  -82,       44,   77,  -80,       47,   66,  -74,       53,   51,  -64,
      60,   32,  -53,       68,   14,  -40,       77,   -4,  -27,       86,  -21,  -14,
      43,   83,  -80,       45,   78,  -78,       48,   67,  -72,       54,   52,  -63,
      61,   34,  -52,       69,   16,  -39,       77,   -2,  -26,       86,  -19,  -13,
      45,   83,  -78,       46,   79,  -76,       50,   69,  -70,       55,   54,  -61,
      62,   36,  -50,       70,   18,  -38,       78,    1,  -25,       87,  -17,  -12,
      46,   84,  -76,       47,   80,  -74,       51,   70,  -68,       56,   56,  -60,
      63,   38,  -49,       70,   20,  -37,       78,    3,  -25,       87,  -14,  -11,
      47,   85,  -74,       48,   81,  -72,       52,   72,  -66,       57,   58,  -58,
      63,   41,  -48,       71,   23,  -36,       79,    5,  -24,       87,  -12,  -11,
      48,   86,  -72,       50,   83,  -70,       53,   73,  -65,       58,   60,  -57,
      64,   43,  -46,       71,   25,  -35,       79,    8,  -23,       88,  -10,  -10,
      50,   87,  -70,       51,   84,  -68,       54,   75,  -63,       59,   62,  -55,
      65,   45,  -45,       72,   28,  -34,       80,   10,  -22,       88,   -7,   -9,
      51,   89,  -67,       52,   85,  -65,       55,   77,  -61,       60,   64,  -53,
      66,   48,  -43,       73,   30,  -32,       81,   13,  -21,       89,   -5,   -8,
      52,   90,  -65,       54,   86,  -63,       56,   78,  -59,       61,   66,  -51,
      67,   50,  -42,       74,   33,  -31,       81,   15,  -20,       90,   -2,   -7,
      54,   91,  -63,       55,   88,  -61,       58,   80,  -57,       62,   68,  -50,
      68,   52,  -40,       75,   35,  -30,       82,   18,  -19,       90,    1,   -6,
      55,   92,  -60,       56,   89,  -59,       59,   81,  -55,       63,   70,  -48,
      69,   54,  -39,       75,   38,  -29,       83,   21,  -17,       91,    3,   -5,
      57,   94,  -58,       58,   91,  -56,       60,   83,  -52,       64,   72,  -46,
      70,   57,  -37,       76,   40,  -27,       84,   24,  -16,       91,    6,   -4,
      58,   95,  -56,       59,   92,  -54,       61,   85,  -50,       65,   74,  -44,
      71,   59,  -35,       77,   43,  -26,       84,   26,  -15,       92,    9,   -3,
      59,   96,  -53,       60,   93,  -52,       63,   86,  -48,       67,   76,  -42,
      72,   61,  -34,       78,   45,  -24,       85,   29,  -14,       93,   12,   -2,
      31,   77, -105,       33,   70, -101,       39,   55,  -93,       46,   35,  -81,
      55,   14,  -66,       64,   -5,  -52,       73,  -22,  -37,       83,  -38,  -23,
      31,   77, -105,       34,   70, -101,       39,   55,  -93,       46,   36,  -81,
      55,   15,  -66,       64,   -4,  -52,       73,  -22,  -37,       83,  -38,  -23,
      31,   77, -105,       34,   70, -101,       39,   55,  -92,       46,   36,  -80,
      55,   15,  -66,       64,   -4,  -52,       73,  -22,  -37,       83,  -38,  -22,
      32,   77, -104,       34,   71, -101,       39,   55,  -92,       46,   36,  -80,
      55,   15,  -66,       64,   -4,  -52,       73,  -21,  -37,       83,  -37,  -22,
      32,   78, -104,       34,   71, -100,       39,   56,  -92,       46,   36,  -80,
      55,   16,  -66,       64,   -3,  -52,       73,  -21,  -37,       83,  -37,  -22,
      32,   78, -103,       34,   71, -100,       40,   56,  -91,       47,   37,  -80,
      55,   16,  -66,       64,   -3,  -51,       73,  -20,  -37,       83,  -36,  -22,
      33,   78, -103,       35,   71,  -99,       40,   56,  -91,       47,   38,  -79,
      55,   17,  -65,       64,   -2,  -51,       74,  -20,  -37,       83,  -36,  -22,
      33,   78, -102,       35,   71,  -98,       40,   57,  -90,       47,   38,  -79,
      56,   18,  -65,       65,   -1,  -51,       74,  -19,  -36,       83,  -35,  -22,
      34,   78, -101,       36,   72,  -97,       41,   58,  -89,       48,   39,  -78,
      56,   19,  -64,       65,    0,  -50,       74,  -18,  -36,       83,  -34,  -22,
      34,   78, -100,       36,   72,  -96,       41,   58,  -89,       48,   40,  -77,
      56,   20,  -64,       65,    1,  -50,       74,  -17,  -36,       83,  -33,  -21,
      35,   79,  -99,       37,   73,  -95,       42,   59,  -88,       48,   41,  -77,
      57,   21,  -63,       65,    2,  -50,       74,  -16,  -36,       84,  -32,  -21,
      36,   79,  -97,       38,   73,  -94,       42,   60,  -87,       49,   42,  -76,
      57,   22,  -63,       66,    3,  -49,       74,  -14,  -35,       84,  -31,  -21,
      37,   80,  -96,       39,   74,  -93,       43,   61,  -85,       49,   44,  -75,
      57,   24,  -62,       66,    5,  -49,       75,  -13,  -35,       84,  -30,  -20,
      38,   80,  -94,       39,   75,  -91,       44,   62,  -84,       50,   45,  -74,
      58,   25,  -61,       66,    6,  -48,       75,  -11,  -34,       84,  -28,  -20,
      38,   81,  -93,       40,   75,  -90,       44,   63,  -83,       51,   46,  -73,
      58,   27,  -60,       67,    8,  -47,       75,  -10,  -34,       85,  -27,  -20,
      39,   81,  -91,       41,   76,  -88,       45,   64,  -82,       51,   48,  -72,
      59,   28,  -60,       67,   10,  -47,       76,   -8,  -33,       85,  -25,  -19,
      41,   82,  -89,       42,   77,  -87,       46,   65,  -80,       52,   49,  -71,
      60,   30,  -59,       68,   12,  -46,       76,   -6,  -32,       85,  -23,  -18,
      42,   83,  -87,       43,   78,  -85,       47,   67,  -79,       53,   51,  -69,
      60,   32,  -58,       68,   14,  -45,       77,   -4,  -32,       86,  -21,  -18,
      43,   83,  -86,       44,   79,  -83,       48,   68,  -77,       54,   53,  -68,
      61,   34,  -56,       69,   16,  -44,       77,   -2,  -31,       86,  -19,  -17,
      44,   84,  -84,       45,   80,  -81,       49,   69,  -75,       54,   54,  -67,
      61,   36,  -55,       69,   18,  -43,       77,    0,  -30,       86,  -17,  -17,
      45,   85,  -82,       47,   81,  -79,       50,   71,  -74,       55,   56,  -65,
      62,   38,  -54,       70,   20,  -42,       78,    2,  -29,       87,  -15,  -16,
      46,   86,  -79,       48,   82,  -77,       51,   72,  -72,       56,   58,  -64,
      63,   40,  -53,       70,   22,  -41,       79,    5,  -28,       87,  -13,  -15,
      48,   87,  -77,       49,   83,  -75,       52,   74,  -70,       57,   60,  -62,
      64,   42,  -52,       71,   25,  -40,       79,    7,  -28,       88,  -10,  -15,
      49,   88,  -75,       50,   84,  -73,       53,   75,  -68,       58,   62,  -60,
      65,   45,  -50,       72,   27,  -39,       80,    9,  -27,       88,   -8,  -14,
      50,   89,  -73,       51,   85,  -71,       54,   76,  -66,       59,   63,  -59,
      65,   47,  -49,       73,   29,  -38,       80,   12,  -26,       89,   -6,  -13,
      52,   90,  -71,       53,   87,  -69,       56,   78,  -64,       60,   65,  -57,
      66,   49,  -47,       73,   32,  -36,       81,   15,  -25,       89,   -3,  -12,
      53,   91,  -69,       54,   88,  -67,       57,   80,  -62,       61,   67,  -55,
      67,   51,  -46,       74,   34,  -35,       82,   17,  -24,       90,    0,  -11,
      54,   92,  -66,       55,   89,  -65,       58,   81,  -60,       62,   69,  -53,
      68,   54,  -44,       75,   37,  -34,       82,   20,  -22,       90,    2,  -10,
      56,   93,  -64,       57,   90,  -63,       59,   83,  -58,       63,   71,  -52,
      69,   56,  -43,       76,   39,  -33,       83,   22,  -21,       91,    5,   -9,
      57,   95,  -62,       58,   92,  -60,       61,   84,  -56,       65,   73,  -50,
      70,   58,  -41,       77,   42,  -31,       84,   25,  -20,       92,    8,   -8,
      58,   96,  -59,       59,   93,  -58,       62,   86,  -54,       66,   75,  -48,
      71,   60,  -39,       77,   44,  -30,       85,   28,  -19,       92,   10,   -7,
      60,   97,  -57,       61,   94,  -56,       63,   88,  -52,       67,   77,  -46,
      72,   63,  -38,       78,   47,  -28,       85,   30,  -18,       93,   13,   -6,
      32,   79, -108,       35,   72, -104,       40,   58,  -96,       47,   38,  -84,
      55,   18,  -70,       64,   -2,  -56,       73,  -19,  -41,       83,  -36,  -26,
      32,   79, -108,       35,   72, -104,       40,   58,  -96,       47,   39,  -84,
      55,   18,  -70,       64,   -1,  -56,       73,  -19,  -41,       83,  -35,  -26,
      33,   79, -107,       35,   73, -104,       40,   58,  -95,       47,   39,  -84,
      55,   18,  -70,       64,   -1,  -56,       73,  -19,  -41,       83,  -35,  -26,
      33,   79, -107,       35,   73, -103,       40,   58,  -95,       47,   39,  -84,
      55,   18,  -70,       64,   -1,  -55,       74,  -18,  -41,       83,  -35,  -26,
      33,   79, -107,       35,   73, -103,       40,   58,  -95,       47,   39,  -83,
      56,   19,  -69,       64,    0,  -55,       74,  -18,  -41,       83,  -34,  -26,
      33,   80, -106,       35,   73, -103,       40,   59,  -94,       47,   40,  -83,
      56,   19,  -69,       65,    0,  -55,       74,  -18,  -41,       83,  -34,  -26,
      34,   80, -105,       36,   73, -102,       41,   59,  -94,       48,   40,  -83,
      56,   20,  -69,       65,    1,  -55,       74,  -17,  -41,       83,  -33,  -26,
      34,   80, -105,       36,   74, -101,       41,   60,  -93,       48,   41,  -82,
      56,   21,  -69,       65,    2,  -55,       74,  -16,  -40,       83,  -33,  -26,
      35,   80, -104,       37,   74, -100,       41,   60,  -93,       48,   42,  -82,
      56,   22,  -68,       65,    2,  -54,       74,  -15,  -40,       84,  -32,  -25,
      35,   80, -103,       37,   74,  -99,       42,   61,  -92,       49,   43,  -81,
      57,   23,  -68,       65,    3,  -54,       74,  -14,  -40,       84,  -31,  -25,
      36,   81, -102,       38,   75,  -98,       42,   62,  -91,       49,   44,  -80,
      57,   24,  -67,       66,    5,  -53,       75,  -13,  -39,       84,  -30,  -25,
      37,   81, -100,       39,   75,  -97,       43,   62,  -90,       49,   45,  -79,
      57,   25,  -66,       66,    6,  -53,       75,  -12,  -39,       84,  -29,  -25,
      38,   81,  -99,       39,   76,  -96,       44,   63,  -89,       50,   46,  -78,
      58,   26,  -66,       66,    7,  -52,       75,  -10,  -38,       84,  -27,  -24,
      38,   82,  -97,       40,   76,  -95,       44,   64,  -88,       51,   47,  -78,
      58,   28,  -65,       67,    9,  -52,       75,   -9,  -38,       85,  -26,  -24,
      39,   82,  -96,       41,   77,  -93,       45,   65,  -86,       51,   49,  -77,
      59,   29,  -64,       67,   10,  -51,       76,   -7,  -37,       85,  -24,  -23,
      40,   83,  -94,       42,   78,  -92,       46,   66,  -85,       52,   50,  -75,
      59,   31,  -63,       67,   12,  -50,       76,   -6,  -37,       85,  -23,  -23,
      41,   83,  -92,       43,   79,  -90,       47,   67,  -83,       53,   52,  -74,
      60,   33,  -62,       68,   14,  -49,       77,   -4,  -36,       86,  -21,  -22,
      42,   84,  -91,       44,   80,  -88,       48,   69,  -82,       53,   53,  -73,
      61,   35,  -61,       68,   16,  -49,       77,   -2,  -35,       86,  -19,  -22,
      44,   85,  -89,       45,   80,  -86,       49,   70,  -81,       54,   55,  -72,
      61,   36,  -60,       69,   18,  -48,       77,    0,  -35,       86,  -17,  -21,
      45,   86,  -87,       46,   81,  -85,       50,   71,  -79,       55,   56,  -70,
      62,   38,  -59,       70,   20,  -47,       78,    2,  -34,       87,  -15,  -21,
      46,   86,  -85,       47,   82,  -83,       51,   72,  -77,       56,   58,  -69,
      63,   40,  -58,       70,   22,  -46,       78,    5,  -33,       87,  -13,  -20,
      47,   87,  -83,       48,   83,  -81,       52,   74,  -75,       57,   60,  -67,
      63,   42,  -57,       71,   24,  -45,       79,    7,  -32,       88,  -11,  -19,
      48,   88,  -81,       50,   84,  -79,       53,   75,  -74,       58,   62,  -66,
      64,   44,  -55,       71,   27,  -44,       79,    9,  -31,       88,   -9,  -18,
      50,   89,  -79,       51,   85,  -77,       54,   77,  -72,       59,   63,  -64,
      65,   46,  -54,       72,   29,  -43,       80,   11,  -31,       88,   -6,  -18,
      51,   90,  -77,       52,   87,  -75,       55,   78,  -70,       60,   65,  -63,
      66,   49,  -53,       73,   31,  -42,       81,   14,  -30,       89,   -4,  -17,
      52,   91,  -74,       53,   88,  -72,       56,   80,  -68,       61,   67,  -61,
      67,   51,  -51,       74,   34,  -40,       81,   16,  -28,       90,   -1,  -16,
      54,   92,  -72,       55,   89,  -70,       57,   81,  -66,       62,   69,  -59,
      68,   53,  -50,       74,   36,  -39,       82,   19,  -27,       90,    1,  -15,
      55,   93,  -70,       56,   90,  -68,       59,   83,  -64,       63,   71,  -57,
      69,   55,  -48,       75,   38,  -38,       83,   21,  -26,       91,    4,  -14,
      56,   95,  -68,       57,   92,  -66,       60,   84,  -62,       64,   72,  -55,
      69,   57,  -47,       76,   41,  -36,       83,   24,  -25,       91,    6,  -13,
      58,   96,  -65,       59,   93,  -64,       61,   86,  -60,       65,   75,  -53,
      71,   60,  -45,       77,   43,  -35,       84,   27,  -24,       92,    9,  -12,
      59,   97,  -63,       60,   94,  -62,       62,   87,  -58,       66,   76,  -52,
      72,   62,  -43,       78,   46,  -33,       85,   29,  -23,       93,   12,  -11,
      60,   98,  -61,       61,   96,  -59,       64,   89,  -56,       67,   78,  -50,
      73,   64,  -42,       79,   48,  -32,       86,   32,  -22,       93,   14,  -10,
       1,   -2,    1,       11,  -22,   16,       25,  -34,   32,       37,  -44,   42,
      48,  -53,   52,       59,  -62,   60,       70,  -71,   69,       80,  -80,   77,
       1,    0,    2,       11,  -19,   17,       25,  -32,   32,       37,  -43,   42,
      48,  -53,   52,       59,  -62,   60,       70,  -71,   69,       80,  -80,   77,
       2,    3,    3,       12,  -16,   17,       25,  -31,   33,       37,  -42,   42,
      48,  -52,   52,       59,  -62,   60,       70,  -71,   69,       80,  -79,   77,
       3,    7,    4,       12,  -12,   18,       25,  -28,   33,       37,  -40,   43,
      49,  -51,   52,       59,  -61,   61,       70,  -70,   69,       80,  -79,   77,
       4,   12,    6,       13,   -7,   19,       26,  -25,   33,       37,  -38,   43,
      49,  -50,   52,       60,  -60,   61,       70,  -69,   69,       80,  -78,   77,
       5,   17,    8,       14,   -3,   21,       26,  -22,   34,       37,  -36,   43,
      49,  -48,   52,       60,  -59,   61,       70,  -68,   69,       81,  -78,   78,
       7,   22,   10,       15,    2,   22,       26,  -18,   35,       38,  -34,   44,
      49,  -46,   53,       60,  -57,   61,       70,  -67,   69,       81,  -77,   78,
       9,   26,   14,       16,    7,   24,       27,  -14,   36,       38,  -30,   44,
      49,  -44,   53,       60,  -55,   61,       70,  -66,   70,       81,  -75,   78,
      11,   29,   17,       18,   11,   26,       28,  -10,   36,       39,  -27,   45,
      50,  -41,   53,       60,  -53,   62,       71,  -64,   70,       81,  -74,   78,
      13,   31,   20,       19,   15,   28,       29,   -6,   37,       39,  -24,   45,
      50,  -39,   54,       61,  -51,   62,       71,  -62,   70,       81,  -73,   78,
      15,   34,   23,       20,   19,   30,       30,   -2,   38,       40,  -20,   46,
      51,  -36,   54,       61,  -49,   62,       71,  -60,   70,       81,  -71,   78,
      17,   36,   26,       22,   23,   32,       30,    3,   40,       40,  -16,   47,
      51,  -33,   55,       61,  -46,   63,       71,  -58,   71,       81,  -69,   79,
      19,   39,   29,       23,   27,   34,       32,    7,   41,       41,  -12,   48,
      51,  -29,   55,       62,  -43,   63,       72,  -56,   71,       82,  -67,   79,
      21,   41,   32,       25,   30,   36,       33,   11,   42,       42,   -8,   49,
      52,  -26,   56,       62,  -40,   64,       72,  -53,   71,       82,  -65,   79,
      23,   44,   34,       26,   33,   38,       34,   15,   43,       43,   -4,   49,
      53,  -22,   57,       62,  -37,   64,       72,  -51,   72,       82,  -63,   80,
      25,   46,   37,       28,   36,   40,       35,   19,   45,       44,    0,   50,
      53,  -18,   57,       63,  -34,   65,       73,  -48,   72,       83,  -61,   80,
      27,   48,   39,       30,   40,   42,       36,   23,   46,       45,    4,   52,
      54,  -14,   58,       63,  -30,   65,       73,  -45,   73,       83,  -58,   80,
      29,   51,   42,       31,   42,   44,       38,   26,   48,       45,    8,   53,
      55,  -11,   59,       64,  -27,   66,       74,  -42,   73,       83,  -55,   81,
      30,   53,   44,       33,   45,   46,       39,   30,   49,       46,   12,   54,
      55,   -7,   60,       65,  -24,   67,       74,  -39,   74,       84,  -53,   81,
      32,   55,   46,       35,   48,   48,       40,   33,   50,       47,   16,   55,
      56,   -3,   61,       65,  -20,   68,       74,  -35,   74,       84,  -50,   82,
      34,   57,   48,       36,   51,   50,       42,   37,   52,       49,   20,   56,
      57,    1,   62,       66,  -16,   68,       75,  -32,   75,       85,  -46,   82,
      36,   59,   50,       38,   53,   51,       43,   40,   54,       50,   23,   58,
      58,    5,   63,       67,  -13,   69,       76,  -28,   76,       85,  -43,   83,
      38,   61,   52,       40,   56,   53,       44,   43,   55,       51,   27,   59,
      59,    8,   64,       67,   -9,   70,       76,  -25,   77,       85,  -40,   84,
      39,   64,   54,       41,   58,   54,       46,   46,   57,       52,   30,   60,
      60,   12,   65,       68,   -5,   71,       77,  -22,   77,       86,  -37,   84,
      41,   66,   55,       43,   60,   56,       47,   49,   58,       53,   33,   61,
      61,   16,   66,       69,   -2,   72,       77,  -18,   78,       87,  -34,   85,
      43,   68,   57,       45,   63,   58,       49,   52,   60,       54,   37,   63,
      62,   20,   67,       70,    2,   73,       78,  -14,   79,       87,  -30,   85,
      45,   70,   59,       46,   65,   60,       50,   55,   61,       56,   40,   64,
      63,   23,   69,       71,    6,   74,       79,  -11,   80,       88,  -27,   86,
      46,   72,   61,       48,   67,   61,       52,   57,   63,       57,   43,   66,
      64,   26,   70,       71,    9,   75,       80,   -7,   81,       88,  -24,   87,
      48,   74,   62,       50,   70,   63,       53,   60,   64,       58,   46,   67,
      65,   30,   71,       72,   13,   76,       80,   -4,   81,       89,  -20,   88,
      50,   76,   64,       51,   72,   65,       55,   63,   66,       60,   50,   68,
      66,   33,   72,       73,   17,   77,       81,    0,   82,       90,  -17,   88,
      52,   78,   66,       53,   74,   66,       56,   65,   67,       61,   53,   70,
      67,   37,   74,       74,   20,   78,       82,    3,   83,       90,  -13,   89,
      53,   80,   67,       55,   76,   68,       58,   68,   69,       62,   55,   71,
      68,   40,   75,       75,   23,   79,       83,    7,   84,       91,  -10,   90,
       1,    0,   -2,       11,  -20,   13,       25,  -33,   29,       37,  -43,   40,
      48,  -53,   50,       59,  -62,   59,       70,  -71,   68,       80,  -80,   76,
       1,    2,   -1,       11,  -18,   13,       25,  -31,   29,       37,  -42,   40,
      48,  -53,   50,       59,  -62,   59,       70,  -71,   68,       80,  -80,   77,
       2,    4,    0,       12,  -15,   14,       25,  -30,   29,       37,  -41,   40,
      48,  -52,   50,       59,  -61,   59,       70,  -70,   68,       80,  -79,   77,
       3,    8,    1,       13,  -11,   15,       25,  -27,   30,       37,  -40,   40,
      49,  -51,   50,       59,  -61,   59,       70,  -70,   68,       80,  -79,   77,
       4,   13,    3,       13,   -6,   16,       26,  -25,   30,       37,  -38,   41,
      49,  -50,   51,       60,  -60,   60,       70,  -69,   68,       80,  -78,   77,
       5,   18,    5,       14,   -2,   17,       26,  -22,   31,       37,  -36,   41,
      49,  -48,   51,       60,  -58,   60,       70,  -68,   68,       81,  -77,   77,
       7,   23,    7,       15,    3,   19,       27,  -18,   31,       38,  -33,   41,
      49,  -46,   51,       60,  -57,   60,       70,  -67,   68,       81,  -77,   77,
       9,   26,   11,       16,    7,   21,       27,  -14,   32,       38,  -30,   42,
      49,  -44,   51,       60,  -55,   60,       70,  -65,   69,       81,  -75,   77,
      11,   29,   14,       18,   12,   23,       28,  -10,   33,       39,  -27,   43,
      50,  -41,   52,       60,  -53,   60,       71,  -64,   69,       81,  -74,   77,
      13,   32,   17,       19,   16,   24,       29,   -5,   34,       39,  -23,   43,
      50,  -38,   52,       61,  -51,   61,       71,  -62,   69,       81,  -73,   77,
      15,   34,   20,       20,   20,   26,       30,   -1,   35,       40,  -20,   44,
      51,  -36,   53,       61,  -49,   61,       71,  -60,   69,       81,  -71,   78,
      17,   36,   23,       22,   23,   28,       31,    3,   36,       40,  -16,   45,
      51,  -32,   53,       61,  -46,   62,       71,  -58,   70,       81,  -69,   78,
      19,   39,   26,       23,   27,   31,       32,    7,   38,       41,  -12,   46,
      52,  -29,   54,       62,  -43,   62,       72,  -56,   70,       82,  -67,   78,
      21,   42,   29,       25,   30,   33,       33,   11,   39,       42,   -8,   47,
      52,  -25,   55,       62,  -40,   63,       72,  -53,   71,       82,  -65,   79,
      23,   44,   31,       27,   34,   35,       34,   15,   41,       43,   -4,   47,
      53,  -22,   55,       62,  -37,   63,       72,  -51,   71,       82,  -63,   79,
      25,   46,   34,       28,   37,   37,       35,   19,   42,       44,    0,   49,
      53,  -18,   56,       63,  -34,   64,       73,  -48,   71,       83,  -61,   79,
      27,   49,   36,       30,   40,   39,       36,   23,   44,       45,    4,   50,
      54,  -14,   57,       64,  -30,   64,       73,  -45,   72,       83,  -58,   80,
      29,   51,   39,       31,   43,   41,       38,   27,   45,       45,    8,   51,
      55,  -10,   58,       64,  -27,   65,       74,  -42,   72,       83,  -55,   80,
      30,   53,   41,       33,   45,   43,       39,   30,   46,       46,   12,   52,
      55,   -7,   59,       65,  -23,   66,       74,  -38,   73,       84,  -52,   81,
      32,   55,   43,       35,   48,   44,       40,   33,   48,       47,   16,   53,
      56,   -3,   60,       65,  -20,   67,       74,  -35,   74,       84,  -50,   81,
      34,   57,   45,       37,   51,   46,       42,   37,   50,       49,   20,   55,
      57,    1,   61,       66,  -16,   67,       75,  -32,   74,       85,  -46,   82,
      36,   59,   47,       38,   53,   48,       43,   40,   51,       50,   23,   56,
      58,    5,   62,       67,  -12,   68,       76,  -28,   75,       85,  -43,   82,
      38,   62,   49,       40,   56,   50,       44,   43,   53,       51,   27,   57,
      59,    8,   63,       67,   -9,   69,       76,  -25,   76,       86,  -40,   83,
      39,   64,   51,       41,   58,   52,       46,   46,   54,       52,   30,   58,
      60,   12,   64,       68,   -5,   70,       77,  -22,   76,       86,  -37,   83,
      41,   66,   53,       43,   60,   54,       47,   49,   56,       53,   33,   60,
      61,   16,   65,       69,   -2,   71,       77,  -18,   77,       87,  -34,   84,
      43,   68,   55,       45,   63,   56,       49,   52,   58,       54,   37,   61,
      62,   20,   66,       70,    2,   72,       78,  -14,   78,       87,  -30,   85,
      45,   70,   56,       46,   65,   57,       50,   55,   59,       56,   40,   63,
      63,   23,   67,       71,    6,   73,       79,  -11,   79,       88,  -27,   86,
      46,   72,   58,       48,   67,   59,       52,   57,   61,       57,   43,   64,
      64,   26,   69,       71,    9,   74,       80,   -7,   80,       88,  -24,   86,
      48,   74,   60,       50,   70,   61,       53,   60,   62,       58,   46,   65,
      65,   30,   70,       72,   13,   75,       80,   -4,   81,       89,  -20,   87,
      50,   76,   62,       51,   72,   63,       55,   63,   64,       60,   50,   67,
      66,   34,   71,       73,   17,   76,       81,    0,   82,       90,  -17,   88,
      52,   78,   64,       53,   74,   64,       56,   65,   66,       61,   53,   68,
      67,   37,   72,       74,   20,   77,       82,    3,   83,       90,  -13,   89,
      53,   80,   65,       55,   76,   66,       58,   68,   67,       62,   56,   70,
      68,   40,   74,       75,   23,   78,       83,    7,   83,       91,  -10,   89,
       1,    1,   -5,       11,  -19,    9,       25,  -32,   26,       37,  -43,   38,
      48,  -53,   48,       59,  -62,   58,       70,  -71,   67,       80,  -80,   76,
       2,    3,   -5,       12,  -16,   10,       25,  -31,   26,       37,  -42,   38,
      48,  -52,   48,       59,  -62,   58,       70,  -71,   67,       80,  -79,   76,
       2,    5,   -4,       12,  -14,   11,       25,  -29,   26,       37,  -41,   38,
      49,  -52,   49,       59,  -61,   58,       70,  -70,   67,       80,  -79,   76,
       3,    9,   -2,       13,  -10,   11,       25,  -27,   26,       37,  -39,   38,
      49,  -51,   49,       59,  -60,   58,       70,  -70,   67,       80,  -79,   76,
       4,   14,   -1,       13,   -5,   13,       26,  -24,   27,       37,  -38,   38,
      49,  -49,   49,       60,  -59,   58,       70,  -69,   67,       80,  -78,   76,
       5,   19,    1,       14,   -1,   14,       26,  -21,   27,       38,  -35,   39,
      49,  -48,   49,       60,  -58,   58,       70,  -68,   67,       81,  -77,   76,
       7,   23,    4,       15,    3,   15,       27,  -17,   28,       38,  -33,   39,
      49,  -46,   49,       60,  -57,   59,       70,  -67,   67,       81,  -76,   76,
       9,   27,    7,       16,    8,   17,       27,  -13,   29,       38,  -30,   40,
      49,  -43,   50,       60,  -55,   59,       70,  -65,   68,       81,  -75,   76,
      11,   29,   10,       18,   12,   19,       28,   -9,   30,       39,  -26,   40,
      50,  -41,   50,       60,  -53,   59,       71,  -64,   68,       81,  -74,   77,
      13,   32,   13,       19,   16,   21,       29,   -5,   31,       39,  -23,   41,
      50,  -38,   51,       61,  -51,   60,       71,  -62,   68,       81,  -73,   77,
      15,   34,   16,       20,   20,   23,       30,   -1,   32,       40,  -19,   42,
      51,  -35,   51,       61,  -48,   60,       71,  -60,   68,       81,  -71,   77,
      17,   37,   19,       22,   23,   25,       31,    3,   33,       40,  -16,   43,
      51,  -32,   52,       61,  -46,   60,       71,  -58,   69,       81,  -69,   77,
      19,   39,   22,       24,   27,   27,       32,    8,   35,       41,  -11,   43,
      52,  -29,   52,       62,  -43,   61,       72,  -55,   69,       82,  -67,   78,
      21,   42,   25,       25,   31,   29,       33,   12,   36,       42,   -8,   44,
      52,  -25,   53,       62,  -40,   61,       72,  -53,   70,       82,  -65,   78,
      23,   44,   27,       27,   34,   31,       34,   15,   38,       43,   -4,   45,
      53,  -22,   54,       62,  -37,   62,       72,  -50,   70,       82,  -63,   78,
      25,   46,   30,       28,   37,   33,       35,   19,   39,       44,    0,   46,
      53,  -18,   55,       63,  -34,   63,       73,  -48,   70,       83,  -60,   79,
      27,   49,   33,       30,   40,   35,       36,   23,   41,       45,    5,   48,
      54,  -14,   55,       64,  -30,   63,       73,  -44,   71,       83,  -58,   79,
      29,   51,   35,       32,   43,   37,       38,   27,   42,       46,    8,   49,
      55,  -10,   56,       64,  -27,   64,       74,  -41,   72,       83,  -55,   79,
      30,   53,   37,       33,   45,   39,       39,   30,   44,       46,   12,   50,
      55,   -7,   57,       65,  -23,   65,       74,  -38,   72,       84,  -52,   80,
      32,   55,   39,       35,   48,   41,       40,   34,   46,       48,   16,   51,
      56,   -3,   58,       65,  -20,   65,       75,  -35,   73,       84,  -49,   80,
      34,   58,   42,       37,   51,   43,       42,   37,   47,       49,   20,   53,
      57,    1,   59,       66,  -16,   66,       75,  -32,   73,       85,  -46,   81,
      36,   60,   44,       38,   53,   45,       43,   40,   49,       50,   23,   54,
      58,    5,   60,       67,  -12,   67,       76,  -28,   74,       85,  -43,   82,
      38,   62,   46,       40,   56,   47,       44,   43,   51,       51,   27,   55,
      59,    9,   61,       67,   -9,   68,       76,  -25,   75,       86,  -40,   82,
      39,   64,   48,       41,   58,   49,       46,   46,   52,       52,   30,   57,
      60,   12,   63,       68,   -5,   69,       77,  -21,   76,       86,  -37,   83,
      41,   66,   50,       43,   61,   51,       47,   49,   54,       53,   34,   58,
      61,   16,   64,       69,   -2,   70,       77,  -18,   76,       87,  -34,   83,
      43,   68,   52,       45,   63,   53,       49,   52,   56,       55,   37,   60,
      62,   20,   65,       70,    2,   71,       78,  -14,   77,       87,  -30,   84,
      45,   70,   54,       46,   65,   55,       50,   55,   57,       56,   40,   61,
      63,   23,   66,       71,    6,   72,       79,  -11,   78,       88,  -27,   85,
      47,   72,   56,       48,   68,   57,       52,   58,   59,       57,   43,   62,
      64,   27,   67,       71,    9,   73,       80,   -7,   79,       88,  -24,   86,
      48,   74,   58,       50,   70,   58,       53,   60,   61,       58,   47,   64,
      65,   30,   69,       72,   13,   74,       80,   -4,   80,       89,  -20,   86,
      50,   76,   60,       51,   72,   60,       55,   63,   62,       60,   50,   66,
      66,   34,   70,       73,   17,   75,       81,    0,   81,       90,  -17,   87,
      52,   78,   61,       53,   74,   62,       56,   65,   64,       61,   53,   67,
      67,   37,   71,       74,   20,   76,       82,    3,   82,       90,  -13,   88,
      53,   80,   63,       55,   76,   64,       58,   68,   66,       62,   56,   68,
      68,   40,   72,       75,   24,   77,       83,    7,   83,       91,  -10,   89,
       1,    3,  -11,       11,  -17,    4,       25,  -31,   21,       37,  -42,   34,
      48,  -52,   46,       59,  -62,   56,       70,  -71,   65,       80,  -79,   74,
       2,    5,  -10,       12,  -14,    4,       25,  -29,   21,       37,  -41,   34,
      48,  -52,   46,       59,  -61,   56,       70,  -70,   65,       80,  -79,   75,
       2,    7,   -9,       12,  -11,    5,       25,  -28,   21,       37,  -40,   34,
      49,  -51,   46,       59,  -61,   56,       70,  -70,   65,       80,  -79,   75,
       3,   11,   -8,       13,   -8,    6,       25,  -26,   22,       37,  -39,   35,
      49,  -50,   46,       59,  -60,   56,       70,  -69,   66,       80,  -78,   75,
       4,   16,   -6,       14,   -4,    7,       26,  -23,   22,       37,  -37,   35,
      49,  -49,   46,       60,  -59,   56,       70,  -69,   66,       80,  -78,   75,
       6,   21,   -4,       14,    0,    8,       26,  -20,   23,       38,  -35,   35,
      49,  -47,   47,       60,  -58,   57,       70,  -68,   66,       81,  -77,   75,
       7,   25,   -2,       15,    4,   10,       27,  -16,   24,       38,  -32,   36,
      49,  -45,   47,       60,  -56,   57,       70,  -66,   66,       81,  -76,   75,
       9,   27,    2,       17,    9,   12,       27,  -12,   25,       38,  -29,   36,
      50,  -43,   47,       60,  -55,   57,       70,  -65,   66,       81,  -75,   75,
      11,   30,    5,       18,   13,   13,       28,   -8,   26,       39,  -26,   37,
      50,  -40,   48,       60,  -53,   57,       71,  -63,   66,       81,  -74,   75,
      13,   32,    8,       19,   17,   15,       29,   -4,   27,       39,  -22,   38,
      50,  -38,   48,       61,  -51,   58,       71,  -62,   67,       81,  -72,   75,
      15,   35,   11,       21,   20,   17,       30,    0,   28,       40,  -19,   38,
      51,  -35,   49,       61,  -48,   58,       71,  -60,   67,       81,  -71,   76,
      17,   37,   13,       22,   24,   19,       31,    4,   29,       40,  -15,   39,
      51,  -32,   49,       61,  -46,   58,       71,  -58,   67,       82,  -69,   76,
      19,   40,   17,       24,   28,   22,       32,    8,   31,       41,  -11,   40,
      52,  -28,   50,       62,  -43,   59,       72,  -55,   68,       82,  -67,   76,
      21,   42,   19,       25,   31,   24,       33,   12,   32,       42,   -7,   41,
      52,  -25,   51,       62,  -40,   60,       72,  -53,   68,       82,  -65,   77,
      23,   44,   22,       27,   34,   26,       34,   16,   34,       43,   -3,   42,
      53,  -21,   51,       62,  -37,   60,       72,  -50,   69,       82,  -63,   77,
      25,   47,   24,       28,   37,   28,       35,   20,   35,       44,    1,   43,
      53,  -18,   52,       63,  -33,   61,       73,  -47,   69,       83,  -60,   77,
      27,   49,   27,       30,   40,   31,       36,   24,   37,       45,    5,   45,
      54,  -14,   53,       64,  -30,   61,       73,  -44,   70,       83,  -57,   78,
      29,   51,   30,       32,   43,   33,       38,   27,   39,       46,    9,   46,
      55,  -10,   54,       64,  -26,   62,       74,  -41,   70,       83,  -55,   78,
      31,   53,   32,       33,   46,   35,       39,   30,   40,       47,   12,   47,
      55,   -6,   55,       65,  -23,   63,       74,  -38,   71,       84,  -52,   79,
      32,   55,   35,       35,   48,   37,       40,   34,   42,       48,   16,   48,
      56,   -3,   56,       65,  -20,   64,       75,  -35,   71,       84,  -49,   79,
      34,   58,   37,       37,   51,   39,       42,   37,   44,       49,   20,   50,
      57,    1,   57,       66,  -16,   64,       75,  -31,   72,       85,  -46,   80,
      36,   60,   39,       38,   54,   41,       43,   40,   45,       50,   24,   51,
      58,    5,   58,       67,  -12,   65,       76,  -28,   73,       85,  -43,   80,
      38,   62,   42,       40,   56,   43,       44,   43,   47,       51,   27,   53,
      59,    9,   59,       67,   -9,   66,       76,  -25,   73,       86,  -40,   81,
      40,   64,   44,       41,   58,   45,       46,   46,   49,       52,   30,   54,
      60,   12,   60,       68,   -5,   67,       77,  -21,   74,       86,  -37,   82,
      41,   66,   46,       43,   61,   47,       47,   49,   51,       53,   34,   55,
      61,   16,   62,       69,   -1,   68,       77,  -18,   75,       87,  -34,   82,
      43,   68,   48,       45,   63,   49,       49,   52,   53,       55,   37,   57,
      62,   20,   63,       70,    3,   69,       78,  -14,   76,       87,  -30,   83,
      45,   70,   50,       46,   65,   51,       50,   55,   54,       56,   41,   59,
      63,   23,   64,       71,    6,   70,       79,  -11,   77,       88,  -27,   84,
      47,   72,   52,       48,   68,   53,       52,   58,   56,       57,   44,   60,
      64,   27,   65,       71,   10,   71,       80,   -7,   78,       88,  -23,   84,
      48,   74,   54,       50,   70,   55,       53,   60,   58,       58,   47,   61,
      65,   30,   67,       72,   13,   72,       80,   -4,   78,       89,  -20,   85,
      50,   76,   56,       51,   72,   57,       55,   63,   60,       60,   50,   63,
      66,   34,   68,       73,   17,   73,       81,    0,   79,       90,  -16,   86,
      52,   78,   58,       53,   74,   59,       56,   66,   61,       61,   53,   65,
      67,   37,   69,       74,   20,   75,       82,    4,   80,       90,  -13,   87,
      53,   80,   60,       55,   76,   61,       58,   68,   63,       62,   56,   66,
      68,   40,   71,       75,   24,   76,       83,    7,   81,       91,  -10,   88,
       2,    5,  -17,       12,  -14,   -2,       25,  -29,   16,       37,  -41,   31,
      48,  -52,   43,       59,  -61,   54,       70,  -70,   64,       80,  -79,   73,
       2,    7,  -16,       12,  -11,   -1,       25,  -28,   17,       37,  -40,   31,
      49,  -51,   43,       59,  -61,   54,       70,  -70,   64,       80,  -79,   73,
       3,   10,  -15,       12,   -9,   -1,       25,  -27,   17,       37,  -39,   31,
      49,  -50,   43,       59,  -60,   54,       70,  -70,   64,       80,  -79,   73,
       4,   14,  -14,       13,   -6,    0,       25,  -24,   17,       37,  -38,   31,
      49,  -49,   43,       60,  -59,   54,       70,  -69,   64,       80,  -78,   73,
       5,   18,  -12,       14,   -2,    2,       26,  -22,   18,       37,  -36,   31,
      49,  -48,   44,       60,  -59,   54,       70,  -68,   64,       81,  -78,   73,
       6,   22,  -10,       15,    2,    3,       26,  -19,   18,       38,  -34,   32,
      49,  -47,   44,       60,  -57,   54,       70,  -67,   64,       81,  -77,   73,
       8,   26,   -7,       16,    6,    4,       27,  -15,   19,       38,  -31,   32,
      49,  -45,   44,       60,  -56,   55,       70,  -66,   64,       81,  -76,   73,
      10,   28,   -4,       17,   10,    6,       27,  -11,   20,       38,  -28,   33,
      50,  -42,   45,       60,  -54,   55,       70,  -65,   64,       81,  -75,   74,
      12,   31,   -1,       18,   14,    8,       28,   -8,   21,       39,  -25,   33,
      50,  -40,   45,       60,  -52,   55,       71,  -63,   65,       81,  -73,   74,
      14,   33,    2,       19,   18,   10,       29,   -4,   22,       39,  -22,   34,
      50,  -37,   45,       61,  -50,   56,       71,  -61,   65,       81,  -72,   74,
      15,   35,    5,       21,   21,   12,       30,    0,   24,       40,  -18,   35,
      51,  -34,   46,       61,  -48,   56,       71,  -60,   65,       81,  -70,   74,
      17,   38,    8,       22,   25,   14,       31,    4,   25,       41,  -15,   36,
      51,  -31,   47,       61,  -45,   56,       71,  -57,   66,       82,  -69,   75,
      19,   40,   11,       24,   28,   17,       32,    9,   26,       41,  -10,   37,
      52,  -28,   47,       62,  -42,   57,       72,  -55,   66,       82,  -67,   75,
      21,   42,   14,       25,   31,   19,       33,   13,   28,       42,   -7,   38,
      52,  -24,   48,       62,  -39,   57,       72,  -52,   66,       82,  -65,   75,
      23,   45,   17,       27,   34,   21,       34,   16,   29,       43,   -3,   39,
      53,  -21,   49,       63,  -36,   58,       72,  -50,   67,       82,  -62,   76,
      25,   47,   19,       28,   37,   23,       35,   20,   31,       44,    1,   40,
      53,  -17,   50,       63,  -33,   59,       73,  -47,   67,       83,  -60,   76,
      27,   49,   22,       30,   41,   26,       37,   24,   33,       45,    5,   41,
      54,  -13,   51,       64,  -30,   59,       73,  -44,   68,       83,  -57,   76,
      29,   51,   25,       32,   43,   28,       38,   27,   35,       46,    9,   43,
      55,  -10,   51,       64,  -26,   60,       74,  -41,   68,       83,  -55,   77,
      31,   54,   27,       33,   46,   30,       39,   31,   36,       47,   13,   44,
      56,   -6,   52,       65,  -23,   61,       74,  -38,   69,       84,  -52,   77,
      32,   56,   30,       35,   49,   32,       40,   34,   38,       48,   16,   45,
      56,   -2,   53,       65,  -19,   62,       75,  -35,   70,       84,  -49,   78,
      34,   58,   33,       37,   51,   35,       42,   38,   40,       49,   20,   47,
      57,    2,   55,       66,  -15,   62,       75,  -31,   70,       85,  -46,   78,
      36,   60,   35,       38,   54,   37,       43,   41,   42,       50,   24,   48,
      58,    5,   56,       67,  -12,   63,       76,  -28,   71,       85,  -43,   79,
      38,   62,   37,       40,   56,   39,       45,   44,   44,       51,   27,   50,
      59,    9,   57,       67,   -8,   64,       76,  -24,   72,       86,  -40,   80,
      40,   64,   39,       42,   59,   41,       46,   47,   45,       52,   31,   51,
      60,   13,   58,       68,   -5,   65,       77,  -21,   72,       86,  -37,   80,
      41,   66,   42,       43,   61,   43,       47,   49,   47,       53,   34,   53,
      61,   16,   59,       69,   -1,   66,       78,  -18,   73,       87,  -33,   81,
      43,   68,   44,       45,   63,   46,       49,   53,   49,       55,   38,   54,
      62,   20,   60,       70,    3,   67,       78,  -14,   74,       87,  -30,   82,
      45,   70,   46,       47,   66,   48,       50,   55,   51,       56,   41,   56,
      63,   23,   62,       71,    6,   68,       79,  -10,   75,       88,  -27,   82,
      47,   72,   48,       48,   68,   50,       52,   58,   53,       57,   44,   57,
      64,   27,   63,       71,   10,   69,       80,   -7,   76,       88,  -23,   83,
      48,   74,   51,       50,   70,   52,       53,   60,   55,       58,   47,   59,
      65,   30,   64,       72,   13,   70,       80,   -4,   77,       89,  -20,   84,
      50,   76,   53,       52,   72,   54,       55,   63,   57,       60,   50,   61,
      66,   34,   66,       73,   17,   72,       81,    0,   78,       90,  -16,   85,
      52,   78,   55,       53,   74,   56,       56,   66,   58,       61,   53,   62,
      67,   37,   67,       74,   20,   73,       82,    4,   79,       90,  -13,   85,
      53,   80,   57,       55,   77,   58,       58,   68,   60,       62,   56,   64,
      68,   40,   68,       75,   24,   74,       83,    7,   80,       91,  -10,   86,
       2,    9,  -22,       12,  -10,   -7,       25,  -27,   12,       37,  -40,   27,
      49,  -51,   40,       59,  -61,   51,       70,  -70,   61,       80,  -79,   71,
       3,   11,  -22,       12,   -8,   -6,       25,  -26,   12,       37,  -39,   27,
      49,  -50,   40,       59,  -60,   51,       70,  -69,   61,       80,  -79,   71,
       3,   13,  -21,       13,   -6,   -6,       25,  -25,   12,       37,  -38,   27,
      49,  -50,   40,       59,  -60,   51,       70,  -69,   62,       80,  -78,   71,
       4,   17,  -19,       13,   -3,   -5,       26,  -23,   12,       37,  -37,   27,
      49,  -49,   40,       60,  -59,   51,       70,  -68,   62,       80,  -78,   71,
       5,   21,  -18,       14,    0,   -4,       26,  -20,   13,       37,  -35,   27,
      49,  -47,   40,       60,  -58,   52,       70,  -68,   62,       81,  -77,   71,
       6,   24,  -15,       15,    4,   -2,       26,  -17,   14,       38,  -33,   28,
      49,  -46,   41,       60,  -57,   52,       70,  -67,   62,       81,  -76,   72,
       8,   27,  -13,       16,    7,   -1,       27,  -14,   14,       38,  -30,   28,
      49,  -44,   41,       60,  -55,   52,       70,  -66,   62,       81,  -76,   72,
      10,   30,   -9,       17,   11,    1,       28,  -10,   15,       38,  -27,   29,
      50,  -42,   41,       60,  -54,   52,       70,  -64,   62,       81,  -74,   72,
      12,   32,   -6,       18,   15,    3,       28,   -7,   17,       39,  -24,   30,
      50,  -39,   42,       60,  -52,   53,       71,  -63,   62,       81,  -73,   72,
      14,   34,   -3,       20,   19,    5,       29,   -3,   18,       39,  -21,   30,
      50,  -37,   42,       61,  -50,   53,       71,  -61,   63,       81,  -72,   72,
      16,   36,   -1,       21,   22,    7,       30,    1,   19,       40,  -18,   31,
      51,  -34,   43,       61,  -47,   53,       71,  -59,   63,       81,  -70,   73,
      18,   38,    2,       22,   25,    9,       31,    5,   20,       41,  -14,   32,
      51,  -31,   43,       61,  -45,   54,       71,  -57,   63,       82,  -68,   73,
      20,   41,    6,       24,   29,   12,       32,    9,   22,       41,  -10,   33,
      52,  -27,   44,       62,  -42,   54,       72,  -54,   64,       82,  -66,   73,
      21,   43,    8,       25,   32,   14,       33,   13,   23,       42,   -6,   34,
      52,  -24,   45,       62,  -39,   55,       72,  -52,   64,       82,  -64,   73,
      23,   45,   11,       27,   35,   16,       34,   17,   25,       43,   -2,   35,
      53,  -20,   46,       63,  -36,   55,       72,  -49,   65,       82,  -62,   74,
      25,   47,   14,       28,   38,   18,       35,   20,   27,       44,    1,   36,
      53,  -17,   46,       63,  -33,   56,       73,  -47,   65,       83,  -60,   74,
      27,   50,   17,       30,   41,   21,       37,   24,   29,       45,    6,   38,
      54,  -13,   47,       64,  -29,   57,       73,  -44,   66,       83,  -57,   75,
      29,   52,   20,       32,   44,   23,       38,   28,   30,       46,    9,   39,
      55,   -9,   48,       64,  -26,   57,       74,  -41,   66,       83,  -54,   75,
      31,   54,   22,       33,   46,   25,       39,   31,   32,       47,   13,   40,
      56,   -6,   49,       65,  -22,   58,       74,  -38,   67,       84,  -52,   76,
      33,   56,   25,       35,   49,   28,       40,   34,   34,       48,   17,   42,
      56,   -2,   50,       65,  -19,   59,       75,  -34,   68,       84,  -49,   76,
      34,   58,   28,       37,   52,   30,       42,   38,   36,       49,   21,   43,
      57,    2,   52,       66,  -15,   60,       75,  -31,   68,       85,  -46,   77,
      36,   60,   30,       38,   54,   33,       43,   41,   38,       50,   24,   45,
      58,    6,   53,       67,  -12,   61,       76,  -28,   69,       85,  -43,   77,
      38,   62,   33,       40,   56,   35,       45,   44,   40,       51,   28,   46,
      59,    9,   54,       67,   -8,   62,       76,  -24,   70,       86,  -40,   78,
      40,   64,   35,       42,   59,   37,       46,   47,   41,       52,   31,   48,
      60,   13,   55,       68,   -4,   63,       77,  -21,   70,       86,  -36,   78,
      41,   66,   37,       43,   61,   39,       47,   50,   43,       53,   34,   49,
      61,   16,   56,       69,   -1,   64,       78,  -17,   71,       87,  -33,   79,
      43,   68,   40,       45,   64,   42,       49,   53,   45,       55,   38,   51,
      62,   20,   58,       70,    3,   65,       78,  -14,   72,       87,  -30,   80,
      45,   70,   42,       47,   66,   44,       50,   55,   47,       56,   41,   52,
      63,   24,   59,       71,    6,   66,       79,  -10,   73,       88,  -26,   81,
      47,   72,   44,       48,   68,   46,       52,   58,   49,       57,   44,   54,
      64,   27,   60,       72,   10,   67,       80,   -7,   74,       88,  -23,   81,
      48,   74,   46,       50,   70,   48,       53,   61,   51,       58,   47,   56,
      65,   30,   62,       72,   13,   68,       80,   -3,   75,       89,  -20,   82,
      50,   76,   49,       52,   73,   50,       55,   63,   53,       60,   50,   57,
      66,   34,   63,       73,   17,   69,       81,    1,   76,       90,  -16,   83,
      52,   78,   51,       53,   75,   52,       56,   66,   55,       61,   53,   59,
      67,   37,   64,       74,   21,   70,       82,    4,   77,       90,  -13,   84,
      53,   80,   53,       55,   77,   54,       58,   68,   57,       62,   56,   61,
      68,   40,   66,       75,   24,   72,       83,    7,   78,       91,   -9,   85,
       3,   12,  -28,       13,   -7,  -12,       25,  -25,    7,       37,  -38,   22,
      49,  -50,   36,       59,  -60,   48,       70,  -69,   59,       80,  -78,   69,
       3,   15,  -27,       13,   -5,  -12,       25,  -24,    7,       37,  -38,   22,
      49,  -49,   36,       59,  -59,   48,       70,  -69,   59,       80,  -78,   69,
       4,   17,  -26,       13,   -3,  -11,       26,  -23,    7,       37,  -37,   23,
      49,  -49,   36,       60,  -59,   48,       70,  -69,   59,       80,  -78,   69,
       5,   20,  -24,       14,   -1,  -10,       26,  -21,    8,       37,  -35,   23,
      49,  -48,   37,       60,  -58,   48,       70,  -68,   59,       81,  -77,   69,
       6,   24,  -23,       14,    2,   -9,       26,  -18,    8,       38,  -34,   23,
      49,  -46,   37,       60,  -57,   49,       70,  -67,   59,       81,  -77,   69,
       7,   26,  -21,       15,    6,   -8,       27,  -16,    9,       38,  -32,   24,
      49,  -45,   37,       60,  -56,   49,       70,  -66,   59,       81,  -76,   69,
       9,   29,  -18,       16,    9,   -6,       27,  -13,   10,       38,  -29,   24,
      49,  -43,   37,       60,  -55,   49,       70,  -65,   60,       81,  -75,   70,
      11,   31,  -15,       17,   13,   -4,       28,   -9,   11,       39,  -26,   25,
      50,  -41,   38,       60,  -53,   49,       71,  -64,   60,       81,  -74,   70,
      12,   33,  -12,       19,   16,   -2,       28,   -5,   12,       39,  -23,   25,
      50,  -38,   38,       60,  -51,   50,       71,  -62,   60,       81,  -73,   70,
      14,   35,   -9,       20,   20,    0,       29,   -2,   13,       40,  -20,   26,
      50,  -36,   39,       61,  -49,   50,       71,  -60,   60,       81,  -71,   70,
      16,   37,   -6,       21,   23,    2,       30,    2,   14,       40,  -17,   27,
      51,  -33,   39,       61,  -47,   50,       71,  -59,   61,       81,  -70,   70,
      18,   39,   -3,       23,   26,    4,       31,    6,   16,       41,  -13,   28,
      51,  -30,   40,       61,  -44,   51,       71,  -57,   61,       82,  -68,   71,
      20,   42,    0,       24,   30,    6,       32,   10,   17,       42,   -9,   29,
      52,  -27,   41,       62,  -41,   51,       72,  -54,   61,       82,  -66,   71,
      22,   44,    3,       26,   33,    9,       33,   14,   19,       42,   -5,   30,
      52,  -23,   41,       62,  -38,   52,       72,  -52,   62,       82,  -64,   71,
      24,   46,    6,       27,   36,   11,       34,   18,   20,       43,   -2,   31,
      53,  -20,   42,       63,  -35,   53,       72,  -49,   62,       82,  -62,   72,
      25,   48,    9,       29,   38,   13,       35,   21,   22,       44,    2,   32,
      53,  -16,   43,       63,  -32,   53,       73,  -46,   63,       83,  -59,   72,
      27,   50,   12,       30,   42,   16,       37,   25,   24,       45,    6,   34,
      54,  -12,   44,       64,  -29,   54,       73,  -43,   63,       83,  -57,   73,
      29,   52,   15,       32,   44,   18,       38,   28,   26,       46,   10,   35,
      55,   -9,   45,       64,  -25,   55,       74,  -40,   64,       83,  -54,   73,
      31,   54,   17,       34,   47,   21,       39,   32,   28,       47,   14,   36,
      56,   -5,   46,       65,  -22,   55,       74,  -37,   64,       84,  -51,   74,
      33,   56,   20,       35,   49,   23,       40,   35,   29,       48,   17,   38,
      56,   -2,   47,       65,  -19,   56,       75,  -34,   65,       84,  -49,   74,
      35,   59,   23,       37,   52,   26,       42,   38,   32,       49,   21,   39,
      57,    3,   48,       66,  -15,   57,       75,  -30,   66,       85,  -45,   75,
      36,   61,   25,       38,   54,   28,       43,   41,   33,       50,   25,   41,
      58,    6,   49,       67,  -11,   58,       76,  -27,   67,       85,  -42,   75,
      38,   63,   28,       40,   57,   30,       45,   44,   35,       51,   28,   42,
      59,   10,   51,       68,   -8,   59,       76,  -24,   67,       86,  -39,   76,
      40,   65,   30,       42,   59,   32,       46,   47,   37,       52,   31,   44,
      60,   13,   52,       68,   -4,   60,       77,  -21,   68,       86,  -36,   76,
      41,   67,   33,       43,   61,   35,       47,   50,   39,       53,   35,   45,
      61,   17,   53,       69,   -1,   61,       78,  -17,   69,       87,  -33,   77,
      43,   69,   35,       45,   64,   37,       49,   53,   41,       55,   38,   47,
      62,   21,   55,       70,    3,   62,       78,  -13,   70,       87,  -29,   78,
      45,   71,   38,       47,   66,   39,       50,   56,   43,       56,   41,   49,
      63,   24,   56,       71,    7,   63,       79,  -10,   71,       88,  -26,   79,
      47,   73,   40,       48,   68,   41,       52,   58,   45,       57,   44,   50,
      64,   27,   57,       72,   10,   64,       80,   -7,   72,       88,  -23,   79,
      48,   75,   42,       50,   70,   44,       53,   61,   47,       58,   47,   52,
      65,   31,   59,       72,   14,   65,       80,   -3,   73,       89,  -20,   80,
      50,   77,   45,       52,   73,   46,       55,   64,   49,       60,   51,   54,
      66,   34,   60,       73,   18,   67,       81,    1,   74,       90,  -16,   81,
      52,   79,   47,       53,   75,   48,       56,   66,   51,       61,   53,   56,
      67,   38,   61,       74,   21,   68,       82,    4,   75,       90,  -13,   82,
      54,   80,   49,       55,   77,   50,       58,   69,   53,       62,   56,   57,
      68,   41,   63,       75,   24,   69,       83,    8,   76,       91,   -9,   83,
       4,   18,  -33,       13,   -3,  -18,       25,  -23,    1,       37,  -37,   17,
      49,  -49,   32,       60,  -59,   44,       70,  -68,   56,       80,  -78,   66,
       4,   20,  -32,       13,   -1,  -17,       26,  -21,    1,       37,  -36,   18,
      49,  -48,   32,       60,  -58,   45,       70,  -68,   56,       80,  -77,   66,
       5,   22,  -31,       14,    0,  -17,       26,  -20,    2,       37,  -35,   18,
      49,  -47,   32,       60,  -58,   45,       70,  -68,   56,       80,  -77,   67,
       5,   24,  -30,       14,    3,  -16,       26,  -18,    2,       38,  -34,   18,
      49,  -46,   32,       60,  -57,   45,       70,  -67,   56,       81,  -77,   67,
       6,   27,  -28,       15,    5,  -15,       26,  -16,    3,       38,  -32,   18,
      49,  -45,   33,       60,  -56,   45,       70,  -66,   56,       81,  -76,   67,
       8,   29,  -26,       16,    8,  -13,       27,  -14,    3,       38,  -30,   19,
      49,  -44,   33,       60,  -55,   45,       70,  -66,   56,       81,  -75,   67,
       9,   30,  -23,       17,   11,  -12,       27,  -11,    4,       38,  -28,   19,
      50,  -42,   33,       60,  -54,   45,       70,  -64,   56,       81,  -75,   67,
      11,   32,  -20,       18,   15,  -10,       28,   -7,    5,       39,  -25,   20,
      50,  -40,   34,       60,  -52,   46,       71,  -63,   57,       81,  -73,   67,
      13,   34,  -17,       19,   18,   -8,       29,   -4,    6,       39,  -22,   20,
      50,  -37,   34,       61,  -50,   46,       71,  -62,   57,       81,  -72,   67,
      15,   36,  -15,       20,   21,   -6,       29,    0,    7,       40,  -19,   21,
      50,  -35,   34,       61,  -48,   46,       71,  -60,   57,       81,  -71,   67,
      16,   38,  -12,       21,   24,   -4,       30,    4,    9,       40,  -15,   22,
      51,  -32,   35,       61,  -46,   47,       71,  -58,   57,       81,  -69,   68,
      18,   40,   -9,       23,   27,   -2,       31,    7,   10,       41,  -12,   23,
      51,  -29,   36,       61,  -43,   47,       71,  -56,   58,       82,  -67,   68,
      20,   42,   -6,       24,   31,    1,       32,   11,   12,       42,   -8,   24,
      52,  -26,   36,       62,  -40,   48,       72,  -53,   58,       82,  -65,   68,
      22,   44,   -3,       26,   34,    3,       33,   15,   13,       42,   -4,   25,
      52,  -22,   37,       62,  -38,   48,       72,  -51,   59,       82,  -63,   69,
      24,   46,    0,       27,   37,    5,       34,   18,   15,       43,   -1,   26,
      53,  -19,   38,       63,  -35,   49,       72,  -48,   59,       82,  -61,   69,
      26,   48,    3,       29,   39,    8,       36,   22,   17,       44,    3,   27,
      54,  -16,   39,       63,  -32,   50,       73,  -46,   60,       83,  -59,   69,
      28,   51,    6,       31,   42,   10,       37,   26,   19,       45,    7,   29,
      54,  -12,   40,       64,  -28,   50,       73,  -43,   60,       83,  -56,   70,
      29,   53,    9,       32,   45,   13,       38,   29,   21,       46,   11,   30,
      55,   -8,   41,       64,  -25,   51,       74,  -40,   61,       83,  -54,   70,
      31,   55,   11,       34,   47,   15,       39,   32,   22,       47,   14,   32,
      56,   -5,   42,       65,  -21,   52,       74,  -37,   61,       84,  -51,   71,
      33,   57,   14,       35,   50,   17,       41,   35,   24,       48,   18,   33,
      57,   -1,   43,       65,  -18,   53,       75,  -34,   62,       84,  -48,   71,
      35,   59,   17,       37,   53,   20,       42,   39,   26,       49,   22,   35,
      57,    3,   44,       66,  -14,   54,       75,  -30,   63,       85,  -45,   72,
      37,   61,   20,       39,   55,   22,       43,   42,   28,       50,   25,   36,
      58,    7,   45,       67,  -11,   55,       76,  -27,   64,       85,  -42,   73,
      38,   63,   22,       40,   57,   25,       45,   45,   30,       51,   28,   38,
      59,   10,   47,       68,   -7,   56,       76,  -23,   64,       86,  -39,   73,
      40,   65,   25,       42,   60,   27,       46,   48,   32,       52,   32,   39,
      60,   14,   48,       68,   -4,   57,       77,  -20,   65,       86,  -36,   74,
      42,   67,   27,       43,   62,   29,       48,   50,   34,       53,   35,   41,
      61,   17,   49,       69,    0,   58,       78,  -17,   66,       87,  -33,   75,
      44,   69,   30,       45,   64,   32,       49,   53,   36,       55,   39,   43,
      62,   21,   51,       70,    4,   59,       78,  -13,   67,       87,  -29,   75,
      45,   71,   32,       47,   66,   34,       51,   56,   38,       56,   42,   45,
      63,   24,   52,       71,    7,   60,       79,  -10,   68,       88,  -26,   76,
      47,   73,   35,       48,   69,   36,       52,   59,   40,       57,   45,   46,
      64,   28,   53,       72,   11,   61,       80,   -6,   69,       88,  -23,   77,
      49,   75,   37,       50,   71,   39,       53,   61,   42,       58,   48,   48,
      65,   31,   55,       72,   14,   62,       80,   -3,   70,       89,  -19,   78,
      50,   77,   40,       52,   73,   41,       55,   64,   45,       60,   51,   50,
      66,   35,   56,       73,   18,   63,       81,    1,   71,       90,  -16,   79,
      52,   79,   42,       53,   75,   43,       56,   66,   47,       61,   54,   51,
      67,   38,   58,       74,   21,   65,       82,    4,   72,       90,  -12,   79,
      54,   81,   44,       55,   77,   45,       58,   69,   49,       62,   56,   53,
      68,   41,   59,       75,   25,   66,       83,    8,   73,       91,   -9,   80,
       4,   23,  -37,       14,    1,  -22,       26,  -20,   -4,       37,  -35,   13,
      49,  -47,   28,       60,  -58,   41,       70,  -68,   53,       80,  -77,   64,
       5,   24,  -37,       14,    2,  -22,       26,  -19,   -3,       37,  -34,   13,
      49,  -47,   28,       60,  -57,   41,       70,  -67,   53,       81,  -77,   64,
       5,   26,  -36,       14,    4,  -21,       26,  -18,   -3,       38,  -33,   13,
      49,  -46,   28,       60,  -57,   41,       70,  -67,   53,       81,  -77,   64,
       6,   28,  -34,       15,    6,  -21,       26,  -16,   -3,       38,  -32,   13,
      49,  -45,   28,       60,  -56,   41,       70,  -66,   53,       81,  -76,   64,
       7,   29,  -33,       15,    8,  -19,       27,  -14,   -2,       38,  -30,   14,
      49,  -44,   28,       60,  -55,   41,       70,  -66,   53,       81,  -76,   64,
       9,   31,  -30,       16,   11,  -18,       27,  -11,   -2,       38,  -28,   14,
      49,  -43,   29,       60,  -54,   42,       70,  -65,   53,       81,  -75,   64,
      10,   32,  -28,       17,   14,  -17,       28,   -9,   -1,       38,  -26,   15,
      50,  -41,   29,       60,  -53,   42,       70,  -64,   53,       81,  -74,   64,
      12,   34,  -25,       18,   17,  -15,       28,   -5,    0,       39,  -23,   15,
      50,  -39,   30,       60,  -51,   42,       71,  -62,   54,       81,  -73,   64,
      13,   36,  -22,       19,   20,  -13,       29,   -2,    1,       39,  -20,   16,
      50,  -36,   30,       61,  -49,   42,       71,  -61,   54,       81,  -72,   65,
      15,   37,  -19,       20,   23,  -11,       30,    1,    3,       40,  -17,   17,
      51,  -34,   30,       61,  -47,   43,       71,  -59,   54,       81,  -70,   65,
      17,   39,  -17,       22,   26,   -9,       31,    5,    4,       40,  -14,   18,
      51,  -31,   31,       61,  -45,   43,       71,  -57,   54,       81,  -69,   65,
      19,   41,  -14,       23,   29,   -7,       31,    8,    5,       41,  -11,   18,
      51,  -28,   32,       62,  -43,   44,       72,  -55,   55,       82,  -67,   65,
      21,   43,  -11,       25,   32,   -4,       32,   12,    7,       42,   -7,   20,
      52,  -25,   32,       62,  -40,   44,       72,  -53,   55,       82,  -65,   66,
      22,   45,   -8,       26,   35,   -2,       34,   16,    9,       43,   -3,   21,
      52,  -22,   33,       62,  -37,   45,       72,  -50,   56,       82,  -63,   66,
      24,   47,   -5,       28,   37,    0,       35,   19,   10,       43,    0,   22,
      53,  -18,   34,       63,  -34,   45,       73,  -48,   56,       82,  -61,   66,
      26,   49,   -2,       29,   40,    3,       36,   23,   12,       44,    4,   23,
      54,  -15,   35,       63,  -31,   46,       73,  -45,   57,       83,  -58,   67,
      28,   51,    1,       31,   43,    5,       37,   27,   14,       45,    8,   25,
      54,  -11,   36,       64,  -27,   47,       73,  -42,   57,       83,  -56,   67,
      30,   53,    4,       32,   45,    8,       38,   30,   16,       46,   11,   26,
      55,   -7,   37,       64,  -24,   48,       74,  -39,   58,       84,  -53,   68,
      31,   55,    6,       34,   48,   10,       39,   33,   18,       47,   15,   27,
      56,   -4,   38,       65,  -21,   48,       74,  -36,   58,       84,  -50,   68,
      33,   57,    9,       35,   50,   12,       41,   36,   20,       48,   18,   29,
      57,    0,   39,       66,  -17,   49,       75,  -33,   59,       84,  -48,   69,
      35,   60,   12,       37,   53,   15,       42,   39,   22,       49,   22,   30,
      58,    4,   40,       66,  -14,   50,       75,  -30,   60,       85,  -44,   69,
      37,   61,   15,       39,   55,   18,       44,   42,   24,       50,   26,   32,
      58,    7,   42,       67,  -10,   51,       76,  -26,   61,       85,  -41,   70,
      38,   63,   17,       40,   58,   20,       45,   45,   26,       51,   29,   34,
      59,   11,   43,       68,   -7,   52,       76,  -23,   61,       86,  -38,   71,
      40,   65,   20,       42,   60,   22,       46,   48,   28,       52,   32,   35,
      60,   14,   44,       68,   -3,   53,       77,  -20,   62,       86,  -35,   71,
      42,   67,   22,       44,   62,   25,       48,   51,   30,       54,   35,   37,
      61,   18,   45,       69,    0,   54,       78,  -16,   63,       87,  -32,   72,
      44,   69,   25,       45,   65,   27,       49,   54,   32,       55,   39,   39,
      62,   21,   47,       70,    4,   55,       78,  -13,   64,       87,  -29,   73,
      45,   71,   28,       47,   67,   30,       51,   56,   34,       56,   42,   40,
      63,   25,   48,       71,    8,   57,       79,   -9,   65,       88,  -25,   74,
      47,   73,   30,       48,   69,   32,       52,   59,   36,       57,   45,   42,
      64,   28,   50,       72,   11,   58,       80,   -6,   66,       88,  -22,   74,
      49,   75,   32,       50,   71,   34,       53,   61,   38,       59,   48,   44,
      65,   31,   51,       73,   14,   59,       81,   -2,   67,       89,  -19,   75,
      50,   77,   35,       52,   73,   37,       55,   64,   40,       60,   51,   46,
      66,   35,   53,       74,   18,   60,       81,    1,   68,       90,  -15,   76,
      52,   79,   37,       53,   75,   39,       57,   67,   42,       61,   54,   48,
      67,   38,   54,       74,   22,   61,       82,    5,   69,       90,  -12,   77,
      54,   81,   40,       55,   77,   41,       58,   69,   44,       62,   57,   49,
      69,   41,   56,       75,   25,   63,       83,    8,   70,       91,   -9,   78,
       5,   27,  -42,       14,    5,  -27,       26,  -17,   -9,       37,  -33,    8,
      49,  -46,   24,       60,  -57,   37,       70,  -67,   49,       81,  -76,   61,
       6,   28,  -41,       14,    6,  -27,       26,  -16,   -8,       38,  -32,    8,
      49,  -45,   24,       60,  -56,   37,       70,  -66,   49,       81,  -76,   61,
       6,   29,  -40,       15,    7,  -26,       26,  -15,   -8,       38,  -31,    9,
      49,  -45,   24,       60,  -56,   37,       70,  -66,   49,       81,  -76,   61,
       7,   31,  -38,       15,    9,  -25,       27,  -13,   -8,       38,  -30,    9,
      49,  -44,   24,       60,  -55,   37,       70,  -66,   50,       81,  -75,   61,
       8,   32,  -37,       16,   11,  -24,       27,  -11,   -7,       38,  -28,    9,
      49,  -43,   24,       60,  -54,   38,       70,  -65,   50,       81,  -75,   61,
       9,   33,  -35,       17,   13,  -23,       27,   -9,   -6,       38,  -27,   10,
      50,  -41,   25,       60,  -53,   38,       70,  -64,   50,       81,  -74,   61,
      11,   34,  -32,       18,   16,  -22,       28,   -6,   -6,       39,  -24,   10,
      50,  -39,   25,       60,  -52,   38,       71,  -63,   50,       81,  -73,   61,
      12,   36,  -29,       19,   19,  -20,       29,   -3,   -5,       39,  -22,   11,
      50,  -37,   25,       60,  -50,   38,       71,  -61,   50,       81,  -72,   62,
      14,   37,  -27,       20,   22,  -18,       29,    0,   -3,       40,  -19,   11,
      50,  -35,   26,       61,  -48,   39,       71,  -60,   50,       81,  -71,   62,
      16,   39,  -24,       21,   24,  -16,       30,    3,   -2,       40,  -16,   12,
      51,  -33,   26,       61,  -46,   39,       71,  -58,   51,       81,  -69,   62,
      17,   41,  -21,       22,   27,  -14,       31,    7,   -1,       41,  -13,   13,
      51,  -30,   27,       61,  -44,   39,       71,  -56,   51,       82,  -68,   62,
      19,   42,  -19,       23,   30,  -12,       32,   10,    0,       41,  -10,   14,
      52,  -27,   28,       62,  -42,   40,       72,  -54,   51,       82,  -66,   62,
      21,   44,  -15,       25,   33,   -9,       33,   14,    2,       42,   -6,   15,
      52,  -24,   28,       62,  -39,   41,       72,  -52,   52,       82,  -64,   63,
      23,   46,  -13,       26,   36,   -7,       34,   17,    4,       43,   -2,   16,
      53,  -21,   29,       62,  -36,   41,       72,  -50,   52,       82,  -62,   63,
      24,   48,  -10,       28,   38,   -5,       35,   20,    5,       43,    1,   17,
      53,  -17,   30,       63,  -33,   42,       73,  -47,   53,       83,  -60,   64,
      26,   50,   -7,       29,   41,   -2,       36,   24,    7,       44,    5,   19,
      54,  -14,   31,       63,  -30,   42,       73,  -45,   53,       83,  -58,   64,
      28,   52,   -4,       31,   44,    0,       37,   27,    9,       45,    9,   20,
      55,  -10,   32,       64,  -27,   43,       73,  -41,   54,       83,  -55,   64,
      30,   54,   -1,       33,   46,    3,       38,   31,   11,       46,   12,   21,
      55,   -7,   33,       64,  -23,   44,       74,  -39,   55,       84,  -52,   65,
      32,   56,    1,       34,   49,    5,       40,   34,   13,       47,   16,   23,
      56,   -3,   34,       65,  -20,   45,       74,  -36,   55,       84,  -50,   65,
      33,   58,    4,       36,   51,    8,       41,   37,   15,       48,   19,   24,
      57,    0,   35,       66,  -17,   46,       75,  -32,   56,       84,  -47,   66,
      35,   60,    7,       37,   54,   10,       42,   40,   17,       49,   23,   26,
      58,    4,   36,       66,  -13,   47,       75,  -29,   57,       85,  -44,   67,
      37,   62,   10,       39,   56,   13,       44,   43,   19,       50,   26,   28,
      58,    8,   38,       67,  -10,   48,       76,  -26,   57,       85,  -41,   67,
      39,   64,   12,       41,   58,   15,       45,   46,   21,       51,   30,   29,
      59,   11,   39,       68,   -6,   49,       77,  -23,   58,       86,  -38,   68,
      40,   66,   15,       42,   60,   17,       46,   49,   23,       53,   33,   31,
      60,   15,   40,       68,   -3,   50,       77,  -19,   59,       86,  -35,   69,
      42,   68,   18,       44,   63,   20,       48,   51,   25,       54,   36,   33,
      61,   18,   42,       69,    1,   51,       78,  -16,   60,       87,  -32,   69,
      44,   70,   20,       45,   65,   23,       49,   54,   27,       55,   39,   34,
      62,   22,   43,       70,    5,   52,       78,  -12,   61,       87,  -28,   70,
      45,   72,   23,       47,   67,   25,       51,   57,   30,       56,   42,   36,
      63,   25,   44,       71,    8,   53,       79,   -9,   62,       88,  -25,   71,
      47,   74,   25,       49,   69,   27,       52,   59,   32,       57,   45,   38,
      64,   29,   46,       72,   11,   54,       80,   -5,   63,       89,  -22,   72,
      49,   75,   28,       50,   71,   30,       54,   62,   34,       59,   48,   40,
      65,   32,   47,       73,   15,   55,       81,   -2,   64,       89,  -19,   72,
      51,   78,   30,       52,   74,   32,       55,   65,   36,       60,   52,   42,
      66,   35,   49,       74,   19,   57,       81,    2,   65,       90,  -15,   73,
      52,   79,   33,       54,   76,   34,       57,   67,   38,       61,   54,   43,
      68,   39,   50,       75,   22,   58,       82,    5,   66,       91,  -12,   74,
      54,   81,   35,       55,   78,   37,       58,   69,   40,       63,   57,   45,
      69,   42,   52,       75,   25,   59,       83,    9,   67,       91,   -8,   75,
       6,   31,  -45,       15,    9,  -31,       26,  -14,  -13,       38,  -30,    4,
      49,  -44,   19,       60,  -55,   33,       70,  -66,   46,       81,  -76,   58,
       7,   32,  -45,       15,   10,  -31,       26,  -13,  -13,       38,  -30,    4,
      49,  -44,   20,       60,  -55,   33,       70,  -65,   46,       81,  -75,   58,
       7,   32,  -44,       15,   11,  -30,       27,  -12,  -13,       38,  -29,    4,
      49,  -43,   20,       60,  -55,   33,       70,  -65,   46,       81,  -75,   58,
       8,   33,  -42,       16,   12,  -30,       27,  -10,  -12,       38,  -28,    4,
      49,  -42,   20,       60,  -54,   34,       70,  -65,   46,       81,  -75,   58,
       9,   34,  -41,       16,   14,  -29,       27,   -9,  -12,       38,  -26,    5,
      49,  -41,   20,       60,  -53,   34,       70,  -64,   46,       81,  -74,   58,
      10,   35,  -39,       17,   16,  -27,       28,   -6,  -11,       39,  -25,    5,
      50,  -40,   20,       60,  -52,   34,       71,  -63,   46,       81,  -73,   58,
      12,   36,  -36,       18,   18,  -26,       28,   -4,  -10,       39,  -22,    5,
      50,  -38,   21,       60,  -51,   34,       71,  -62,   47,       81,  -72,   58,
      13,   37,  -34,       19,   21,  -24,       29,   -1,   -9,       39,  -20,    6,
      50,  -36,   21,       61,  -49,   34,       71,  -60,   47,       81,  -71,   58,
      15,   39,  -31,       20,   24,  -23,       29,    2,   -8,       40,  -17,    7,
      50,  -34,   22,       61,  -47,   35,       71,  -59,   47,       81,  -70,   59,
      16,   40,  -29,       21,   26,  -21,       30,    5,   -7,       40,  -14,    8,
      51,  -31,   22,       61,  -45,   35,       71,  -57,   47,       81,  -69,   59,
      18,   42,  -26,       23,   29,  -19,       31,    8,   -6,       41,  -11,    8,
      51,  -29,   23,       61,  -43,   36,       71,  -56,   48,       82,  -67,   59,
      20,   44,  -23,       24,   31,  -17,       32,   11,   -4,       41,   -8,    9,
      52,  -26,   23,       62,  -41,   36,       72,  -54,   48,       82,  -66,   59,
      21,   46,  -20,       25,   34,  -14,       33,   15,   -3,       42,   -4,   11,
      52,  -23,   24,       62,  -38,   37,       72,  -51,   48,       82,  -63,   60,
      23,   47,  -17,       27,   37,  -12,       34,   18,   -1,       43,   -1,   12,
      53,  -19,   25,       63,  -35,   37,       72,  -49,   49,       82,  -61,   60,
      25,   49,  -15,       28,   39,  -10,       35,   22,    1,       44,    2,   13,
      53,  -16,   26,       63,  -32,   38,       73,  -46,   49,       83,  -59,   60,
      26,   51,  -12,       30,   42,   -7,       36,   25,    2,       44,    6,   14,
      54,  -13,   27,       63,  -29,   39,       73,  -44,   50,       83,  -57,   61,
      28,   53,   -9,       31,   45,   -5,       37,   28,    4,       45,   10,   16,
      55,   -9,   28,       64,  -26,   39,       73,  -41,   51,       83,  -54,   61,
      30,   55,   -6,       33,   47,   -2,       39,   32,    6,       46,   13,   17,
      55,   -6,   29,       65,  -23,   40,       74,  -38,   51,       84,  -52,   62,
      32,   57,   -3,       34,   49,    0,       40,   35,    8,       47,   17,   18,
      56,   -2,   30,       65,  -19,   41,       74,  -35,   52,       84,  -49,   62,
      33,   59,   -1,       36,   52,    3,       41,   38,   10,       48,   20,   20,
      57,    1,   31,       66,  -16,   42,       75,  -32,   52,       84,  -47,   63,
      35,   61,    2,       38,   54,    5,       43,   41,   12,       49,   24,   22,
      58,    5,   32,       66,  -12,   43,       75,  -28,   53,       85,  -43,   64,
      37,   63,    5,       39,   57,    8,       44,   44,   14,       50,   27,   23,
      59,    8,   34,       67,   -9,   44,       76,  -25,   54,       85,  -40,   64,
      39,   64,    8,       41,   59,   10,       45,   46,   16,       52,   30,   25,
      59,   12,   35,       68,   -6,   45,       77,  -22,   55,       86,  -37,   65,
      40,   66,   10,       42,   61,   13,       47,   49,   18,       53,   33,   27,
      60,   15,   36,       69,   -2,   46,       77,  -19,   56,       86,  -34,   66,
      42,   68,   13,       44,   63,   15,       48,   52,   21,       54,   37,   28,
      61,   19,   37,       69,    1,   47,       78,  -15,   57,       87,  -31,   66,
      44,   70,   16,       46,   66,   18,       49,   55,   23,       55,   40,   30,
      62,   22,   39,       70,    5,   48,       79,  -12,   58,       87,  -28,   67,
      46,   72,   18,       47,   68,   20,       51,   57,   25,       56,   43,   32,
      63,   26,   40,       71,    9,   49,       79,   -8,   59,       88,  -25,   68,
      47,   74,   21,       49,   70,   23,       52,   60,   27,       58,   46,   34,
      64,   29,   42,       72,   12,   51,       80,   -5,   59,       89,  -21,   69,
      49,   76,   23,       50,   72,   25,       54,   62,   29,       59,   49,   35,
      65,   32,   43,       73,   15,   52,       81,   -2,   60,       89,  -18,   69,
      51,   78,   26,       52,   74,   27,       55,   65,   32,       60,   52,   37,
      67,   36,   45,       74,   19,   53,       81,    2,   62,       90,  -14,   70,
      52,   80,   28,       54,   76,   30,       57,   67,   34,       61,   55,   39,
      68,   39,   47,       75,   22,   54,       82,    6,   63,       91,  -11,   71,
      54,   82,   31,       55,   78,   32,       58,   70,   36,       63,   58,   41,
      69,   42,   48,       76,   26,   56,       83,    9,   64,       91,   -8,   72,
       7,   34,  -49,       15,   13,  -36,       27,  -11,  -18,       38,  -28,   -1,
      49,  -42,   15,       60,  -54,   29,       70,  -65,   42,       81,  -75,   54,
       8,   35,  -48,       16,   13,  -35,       27,  -10,  -18,       38,  -27,   -1,
      49,  -42,   15,       60,  -54,   29,       70,  -64,   42,       81,  -74,   54,
       8,   35,  -47,       16,   14,  -35,       27,   -9,  -17,       38,  -27,   -1,
      49,  -41,   15,       60,  -53,   29,       70,  -64,   42,       81,  -74,   55,
       9,   36,  -46,       17,   16,  -34,       27,   -7,  -17,       38,  -25,    0,
      49,  -40,   16,       60,  -53,   30,       70,  -63,   42,       81,  -74,   55,
      10,   36,  -44,       17,   17,  -33,       28,   -6,  -16,       38,  -24,    0,
      50,  -39,   16,       60,  -52,   30,       70,  -63,   43,       81,  -73,   55,
      11,   37,  -43,       18,   19,  -32,       28,   -4,  -16,       39,  -22,    0,
      50,  -38,   16,       60,  -51,   30,       71,  -62,   43,       81,  -72,   55,
      12,   38,  -41,       19,   21,  -31,       29,   -2,  -15,       39,  -20,    1,
      50,  -36,   16,       60,  -49,   30,       71,  -61,   43,       81,  -72,   55,
      14,   39,  -38,       20,   23,  -29,       29,    1,  -14,       39,  -18,    2,
      50,  -34,   17,       61,  -48,   30,       71,  -59,   43,       81,  -70,   55,
      15,   41,  -36,       21,   26,  -27,       30,    4,  -13,       40,  -15,    2,
      51,  -32,   17,       61,  -46,   31,       71,  -58,   43,       81,  -69,   55,
      17,   42,  -33,       22,   28,  -25,       31,    7,  -12,       40,  -13,    3,
      51,  -30,   18,       61,  -44,   31,       71,  -56,   44,       81,  -68,   56,
      18,   43,  -31,       23,   31,  -23,       31,   10,  -10,       41,  -10,    4,
      51,  -27,   18,       61,  -42,   32,       72,  -55,   44,       82,  -66,   56,
      20,   45,  -28,       24,   33,  -21,       32,   13,   -9,       42,   -7,    5,
      52,  -25,   19,       62,  -40,   32,       72,  -53,   44,       82,  -65,   56,
      22,   47,  -25,       26,   36,  -19,       33,   17,   -7,       42,   -3,    6,
      52,  -21,   20,       62,  -37,   33,       72,  -50,   45,       82,  -63,   56,
      24,   48,  -22,       27,   38,  -17,       34,   20,   -6,       43,    0,    7,
      53,  -18,   21,       63,  -34,   33,       72,  -48,   45,       82,  -61,   57,
      25,   50,  -19,       28,   41,  -14,       35,   23,   -4,       44,    4,    8,
      53,  -15,   21,       63,  -31,   34,       73,  -45,   46,       83,  -59,   57,
      27,   52,  -17,       30,   43,  -12,       36,   26,   -2,       45,    7,   10,
      54,  -12,   22,       64,  -28,   35,       73,  -43,   46,       83,  -56,   58,
      29,   54,  -14,       32,   46,   -9,       38,   30,    0,       46,   11,   11,
      55,   -8,   23,       64,  -25,   35,       74,  -40,   47,       83,  -54,   58,
      30,   56,  -11,       33,   48,   -7,       39,   33,    2,       46,   14,   12,
      55,   -5,   25,       65,  -22,   36,       74,  -37,   48,       84,  -51,   59,
      32,   57,   -8,       35,   50,   -4,       40,   35,    4,       47,   18,   14,
      56,   -1,   26,       65,  -19,   37,       74,  -34,   48,       84,  -49,   59,
      34,   59,   -6,       36,   53,   -2,       41,   38,    5,       48,   21,   15,
      57,    2,   27,       66,  -15,   38,       75,  -31,   49,       84,  -46,   60,
      36,   61,   -3,       38,   55,    1,       43,   42,    8,       50,   25,   17,
      58,    6,   28,       67,  -12,   39,       76,  -28,   50,       85,  -43,   60,
      37,   63,    0,       39,   57,    3,       44,   44,   10,       51,   28,   19,
      59,    9,   29,       67,   -8,   40,       76,  -24,   51,       85,  -40,   61,
      39,   65,    3,       41,   59,    6,       45,   47,   12,       52,   31,   20,
      60,   13,   31,       68,   -5,   41,       77,  -21,   51,       86,  -37,   62,
      41,   67,    5,       42,   62,    8,       47,   50,   14,       53,   34,   22,
      60,   16,   32,       69,   -1,   42,       77,  -18,   52,       86,  -34,   62,
      42,   69,    8,       44,   64,   10,       48,   52,   16,       54,   37,   24,
      61,   19,   33,       69,    2,   43,       78,  -15,   53,       87,  -31,   63,
      44,   71,   11,       46,   66,   13,       50,   55,   18,       55,   41,   26,
      62,   23,   35,       70,    6,   44,       79,  -11,   54,       87,  -27,   64,
      46,   73,   13,       47,   68,   15,       51,   58,   20,       56,   44,   27,
      63,   26,   36,       71,    9,   46,       79,   -8,   55,       88,  -24,   65,
      47,   74,   16,       49,   70,   18,       52,   60,   23,       58,   46,   29,
      64,   30,   38,       72,   12,   47,       80,   -4,   56,       89,  -21,   66,
      49,   76,   18,       50,   72,   20,       54,   63,   25,       59,   49,   31,
      65,   33,   39,       73,   16,   48,       81,   -1,   57,       89,  -18,   66,
      51,   78,   21,       52,   74,   23,       55,   65,   27,       60,   52,   33,
      67,   36,   41,       74,   20,   49,       82,    3,   58,       90,  -14,   67,
      53,   80,   24,       54,   76,   25,       57,   68,   29,       61,   55,   35,
      68,   39,   43,       75,   23,   51,       82,    6,   59,       91,  -11,   68,
      54,   82,   26,       55,   78,   27,       58,   70,   31,       63,   58,   37,
      69,   42,   44,       76,   26,   52,       83,    9,   60,       91,   -7,   69,
       9,   37,  -53,       16,   17,  -40,       27,   -7,  -23,       38,  -25,   -6,
      49,  -40,   10,       60,  -52,   25,       70,  -63,   38,       81,  -74,   51,
       9,   37,  -52,       17,   17,  -40,       27,   -6,  -23,       38,  -24,   -6,
      49,  -40,   10,       60,  -52,   25,       70,  -63,   38,       81,  -73,   51,
      10,   38,  -51,       17,   18,  -39,       27,   -5,  -22,       38,  -24,   -6,
      50,  -39,   10,       60,  -52,   25,       70,  -63,   38,       81,  -73,   51,
      11,   38,  -50,       17,   19,  -39,       28,   -4,  -22,       39,  -23,   -5,
      50,  -38,   11,       60,  -51,   25,       71,  -62,   38,       81,  -73,   51,
      11,   39,  -48,       18,   21,  -38,       28,   -2,  -21,       39,  -21,   -5,
      50,  -37,   11,       60,  -50,   25,       71,  -61,   38,       81,  -72,   51,
      12,   39,  -47,       19,   22,  -37,       28,   -1,  -21,       39,  -20,   -5,
      50,  -36,   11,       60,  -49,   25,       71,  -61,   38,       81,  -71,   51,
      13,   40,  -45,       19,   24,  -35,       29,    1,  -20,       39,  -18,   -4,
      50,  -34,   11,       61,  -48,   26,       71,  -60,   39,       81,  -70,   51,
      15,   41,  -43,       20,   26,  -34,       30,    4,  -19,       40,  -15,   -4,
      51,  -32,   12,       61,  -46,   26,       71,  -58,   39,       81,  -69,   51,
      16,   43,  -40,       21,   28,  -32,       30,    7,  -18,       40,  -13,   -3,
      51,  -30,   12,       61,  -44,   26,       71,  -57,   39,       81,  -68,   51,
      18,   44,  -38,       22,   30,  -30,       31,    9,  -17,       41,  -10,   -2,
      51,  -28,   13,       61,  -42,   27,       71,  -55,   39,       82,  -67,   52,
      19,   45,  -35,       24,   33,  -28,       32,   12,  -16,       41,   -8,   -1,
      52,  -25,   13,       62,  -40,   27,       72,  -53,   40,       82,  -65,   52,
      21,   46,  -33,       25,   35,  -26,       33,   15,  -14,       42,   -5,    0,
      52,  -23,   14,       62,  -38,   28,       72,  -51,   40,       82,  -64,   52,
      22,   48,  -30,       26,   37,  -24,       34,   19,  -13,       43,   -1,    1,
      53,  -20,   15,       62,  -35,   28,       72,  -49,   41,       82,  -62,   53,
      24,   50,  -27,       28,   40,  -22,       35,   22,  -11,       43,    2,    2,
      53,  -17,   16,       63,  -33,   29,       73,  -47,   41,       82,  -60,   53,
      26,   51,  -25,       29,   42,  -19,       36,   25,   -9,       44,    5,    3,
      54,  -14,   17,       63,  -30,   29,       73,  -44,   42,       83,  -58,   53,
      27,   53,  -22,       30,   44,  -17,       37,   28,   -8,       45,    8,    4,
      54,  -11,   18,       64,  -27,   30,       73,  -42,   42,       83,  -55,   54,
      29,   55,  -19,       32,   47,  -15,       38,   31,   -5,       46,   12,    6,
      55,   -7,   19,       64,  -24,   31,       74,  -39,   43,       83,  -53,   54,
      31,   57,  -16,       33,   49,  -12,       39,   34,   -4,       47,   15,    7,
      56,   -4,   20,       65,  -21,   32,       74,  -36,   43,       84,  -50,   55,
      32,   58,  -14,       35,   51,  -10,       40,   37,   -2,       48,   19,    9,
      56,    0,   21,       65,  -17,   33,       75,  -33,   44,       84,  -48,   55,
      34,   60,  -11,       36,   53,   -7,       42,   39,    0,       49,   22,   10,
      57,    3,   22,       66,  -14,   33,       75,  -30,   45,       85,  -45,   56,
      36,   62,   -8,       38,   56,   -5,       43,   43,    2,       50,   26,   12,
      58,    7,   23,       67,  -11,   35,       76,  -27,   46,       85,  -42,   57,
      38,   64,   -5,       40,   58,   -2,       44,   45,    5,       51,   29,   14,
      59,   10,   25,       67,   -7,   36,       76,  -24,   46,       85,  -39,   57,
      39,   66,   -3,       41,   60,    0,       46,   48,    7,       52,   32,   15,
      60,   14,   26,       68,   -4,   37,       77,  -20,   47,       86,  -36,   58,
      41,   68,    0,       43,   62,    3,       47,   51,    9,       53,   35,   17,
      61,   17,   27,       69,   -1,   38,       77,  -17,   48,       86,  -33,   59,
      43,   69,    3,       44,   64,    5,       48,   53,   11,       54,   38,   19,
      61,   20,   29,       70,    3,   39,       78,  -14,   49,       87,  -30,   59,
      44,   71,    5,       46,   67,    8,       50,   56,   13,       55,   41,   21,
      63,   24,   30,       70,    7,   40,       79,  -10,   50,       88,  -27,   60,
      46,   73,    8,       48,   69,   10,       51,   59,   15,       57,   44,   23,
      64,   27,   32,       71,   10,   41,       79,   -7,   51,       88,  -23,   61,
      48,   75,   11,       49,   71,   13,       53,   61,   17,       58,   47,   24,
      65,   30,   33,       72,   13,   42,       80,   -4,   52,       89,  -20,   62,
      49,   77,   13,       51,   73,   15,       54,   63,   20,       59,   50,   26,
      66,   33,   35,       73,   16,   44,       81,    0,   53,       89,  -17,   63,
      51,   79,   16,       52,   75,   18,       56,   66,   22,       60,   53,   28,
      67,   37,   36,       74,   20,   45,       82,    3,   54,       90,  -13,   64,
      53,   81,   18,       54,   77,   20,       57,   68,   24,       62,   56,   30,
      68,   40,   38,       75,   23,   46,       82,    7,   55,       91,  -10,   65,
      54,   82,   21,       56,   79,   22,       58,   71,   26,       63,   58,   32,
      69,   43,   39,       76,   27,   48,       83,   10,   56,       91,   -7,   65,
      10,   40,  -56,       17,   20,  -44,       28,   -3,  -27,       38,  -22,  -11,
      50,  -38,    6,       60,  -51,   21,       70,  -62,   34,       81,  -72,   47,
      11,   40,  -55,       17,   21,  -44,       28,   -3,  -27,       39,  -22,  -10,
      50,  -37,    6,       60,  -50,   21,       71,  -62,   34,       81,  -72,   47,
      11,   40,  -54,       18,   21,  -43,       28,   -2,  -27,       39,  -21,  -10,
      50,  -37,    6,       60,  -50,   21,       71,  -61,   34,       81,  -72,   47,
      12,   41,  -53,       18,   22,  -43,       28,   -1,  -26,       39,  -20,  -10,
      50,  -36,    6,       60,  -49,   21,       71,  -61,   34,       81,  -71,   47,
      12,   41,  -52,       19,   24,  -42,       28,    1,  -26,       39,  -19,  -10,
      50,  -35,    6,       60,  -48,   21,       71,  -60,   34,       81,  -71,   47,
      13,   42,  -50,       19,   25,  -41,       29,    2,  -25,       39,  -17,   -9,
      50,  -34,    7,       61,  -47,   21,       71,  -59,   35,       81,  -70,   47,
      14,   42,  -49,       20,   27,  -40,       29,    4,  -25,       40,  -15,   -9,
      50,  -32,    7,       61,  -46,   21,       71,  -58,   35,       81,  -69,   48,
      16,   43,  -46,       21,   29,  -38,       30,    7,  -24,       40,  -13,   -8,
      51,  -30,    8,       61,  -45,   22,       71,  -57,   35,       81,  -68,   48,
      17,   44,  -44,       22,   30,  -36,       31,    9,  -22,       40,  -11,   -7,
      51,  -28,    8,       61,  -43,   22,       71,  -55,   35,       81,  -67,   48,
      18,   45,  -42,       23,   32,  -35,       31,   12,  -21,       41,   -8,   -7,
      51,  -26,    9,       61,  -41,   22,       71,  -54,   36,       82,  -66,   48,
      20,   47,  -40,       24,   35,  -33,       32,   14,  -20,       41,   -6,   -6,
      52,  -24,    9,       62,  -39,   23,       72,  -52,   36,       82,  -64,   48,
      21,   48,  -37,       25,   37,  -31,       33,   17,  -19,       42,   -3,   -5,
      52,  -21,   10,       62,  -37,   23,       72,  -50,   36,       82,  -63,   49,
      23,   50,  -34,       27,   39,  -28,       34,   20,  -17,       43,    1,   -4,
      53,  -18,   11,       62,  -34,   24,       72,  -48,   37,       82,  -61,   49,
      25,   51,  -32,       28,   41,  -26,       35,   23,  -15,       43,    4,   -3,
      53,  -15,   11,       63,  -31,   25,       73,  -46,   37,       83,  -59,   49,
      26,   53,  -29,       29,   43,  -24,       36,   26,  -14,       44,    7,   -1,
      54,  -12,   12,       63,  -29,   25,       73,  -43,   38,       83,  -57,   50,
      28,   54,  -26,       31,   46,  -22,       37,   29,  -12,       45,   10,    0,
      54,   -9,   13,       64,  -26,   26,       73,  -41,   38,       83,  -55,   50,
      30,   56,  -23,       32,   48,  -19,       38,   32,  -10,       46,   13,    1,
      55,   -6,   14,       64,  -23,   27,       74,  -38,   39,       84,  -52,   51,
      31,   58,  -21,       34,   50,  -17,       39,   35,   -8,       47,   17,    3,
      56,   -2,   15,       65,  -20,   28,       74,  -35,   40,       84,  -49,   51,
      33,   59,  -18,       35,   52,  -14,       41,   38,   -6,       48,   20,    4,
      56,    1,   16,       65,  -16,   29,       75,  -32,   40,       84,  -47,   52,
      34,   61,  -15,       37,   54,  -12,       42,   40,   -4,       49,   23,    6,
      57,    4,   18,       66,  -13,   29,       75,  -29,   41,       85,  -44,   52,
      36,   63,  -13,       38,   57,   -9,       43,   44,   -2,       50,   27,    8,
      58,    8,   19,       67,  -10,   30,       76,  -26,   42,       85,  -41,   53,
      38,   65,  -10,       40,   59,   -7,       45,   46,    0,       51,   30,    9,
      59,   11,   20,       67,   -6,   31,       76,  -23,   43,       86,  -38,   54,
      40,   66,   -7,       41,   61,   -4,       46,   49,    2,       52,   33,   11,
      60,   14,   22,       68,   -3,   32,       77,  -20,   43,       86,  -35,   54,
      41,   68,   -5,       43,   63,   -2,       47,   51,    4,       53,   36,   13,
      61,   18,   23,       69,    0,   34,       77,  -16,   44,       87,  -32,   55,
      43,   70,   -2,       45,   65,    0,       48,   54,    6,       54,   39,   14,
      62,   21,   24,       70,    4,   35,       78,  -13,   45,       87,  -29,   56,
      45,   72,    1,       46,   67,    3,       50,   57,    9,       56,   42,   16,
      63,   25,   26,       70,    7,   36,       79,  -10,   46,       88,  -26,   57,
      46,   74,    3,       48,   69,    6,       51,   59,   11,       57,   45,   18,
      64,   28,   27,       71,   11,   37,       79,   -6,   47,       88,  -23,   58,
      48,   76,    6,       49,   71,    8,       53,   62,   13,       58,   48,   20,
      65,   31,   29,       72,   14,   38,       80,   -3,   48,       89,  -20,   58,
      49,   77,    8,       51,   73,   10,       54,   64,   15,       59,   51,   22,
      66,   34,   30,       73,   17,   40,       81,    0,   49,       89,  -16,   59,
      51,   79,   11,       53,   76,   13,       56,   67,   17,       61,   54,   24,
      67,   38,   32,       74,   21,   41,       82,    4,   50,       90,  -13,   60,
      53,   81,   14,       54,   77,   15,       57,   69,   20,       62,   56,   26,
      68,   41,   34,       75,   24,   42,       82,    7,   52,       91,  -10,   61,
      54,   83,   16,       56,   79,   18,       59,   71,   22,       63,   59,   28,
      69,   44,   35,       76,   27,   44,       83,   10,   53,       91,   -6,   62,
      11,   42,  -59,       18,   24,  -48,       28,    0,  -32,       39,  -19,  -15,
      50,  -36,    1,       60,  -49,   16,       71,  -60,   30,       81,  -71,   43,
      12,   42,  -58,       18,   24,  -48,       28,    1,  -31,       39,  -19,  -15,
      50,  -35,    2,       60,  -49,   16,       71,  -60,   30,       81,  -71,   43,
      12,   42,  -58,       18,   25,  -47,       28,    1,  -31,       39,  -18,  -15,
      50,  -35,    2,       60,  -48,   17,       71,  -60,   30,       81,  -71,   43,
      13,   43,  -57,       19,   26,  -47,       29,    2,  -31,       39,  -17,  -14,
      50,  -34,    2,       61,  -47,   17,       71,  -59,   30,       81,  -70,   44,
      14,   43,  -55,       19,   27,  -46,       29,    4,  -30,       39,  -16,  -14,
      50,  -33,    2,       61,  -47,   17,       71,  -59,   31,       81,  -70,   44,
      14,   44,  -54,       20,   28,  -45,       29,    5,  -30,       40,  -15,  -14,
      50,  -32,    2,       61,  -46,   17,       71,  -58,   31,       81,  -69,   44,
      15,   44,  -52,       21,   29,  -44,       30,    7,  -29,       40,  -13,  -13,
      51,  -30,    3,       61,  -44,   17,       71,  -57,   31,       81,  -68,   44,
      17,   45,  -50,       22,   31,  -42,       30,    9,  -28,       40,  -11,  -13,
      51,  -28,    3,       61,  -43,   18,       71,  -55,   31,       81,  -67,   44,
      18,   46,  -48,       23,   33,  -40,       31,   12,  -27,       41,   -9,  -12,
      51,  -26,    4,       61,  -41,   18,       71,  -54,   31,       82,  -66,   44,
      19,   47,  -46,       24,   35,  -39,       32,   14,  -26,       41,   -6,  -11,
      52,  -24,    4,       62,  -39,   18,       72,  -53,   32,       82,  -65,   45,
      21,   48,  -44,       25,   37,  -37,       32,   17,  -25,       42,   -4,  -10,
      52,  -22,    5,       62,  -37,   19,       72,  -51,   32,       82,  -63,   45,
      22,   50,  -41,       26,   38,  -35,       33,   19,  -23,       42,   -1,   -9,
      52,  -20,    5,       62,  -35,   19,       72,  -49,   32,       82,  -62,   45,
      24,   51,  -38,       27,   41,  -33,       34,   22,  -22,       43,    2,   -8,
      53,  -17,    6,       63,  -33,   20,       72,  -47,   33,       82,  -60,   45,
      25,   52,  -36,       28,   43,  -31,       35,   25,  -20,       44,    5,   -7,
      53,  -14,    7,       63,  -30,   20,       73,  -44,   33,       83,  -58,   46,
      27,   54,  -33,       30,   45,  -28,       36,   28,  -18,       45,    8,   -6,
      54,  -11,    8,       63,  -27,   21,       73,  -42,   34,       83,  -56,   46,
      28,   55,  -31,       31,   47,  -26,       37,   30,  -17,       45,   11,   -5,
      55,   -8,    9,       64,  -25,   22,       73,  -40,   34,       83,  -54,   47,
      30,   57,  -28,       33,   49,  -24,       39,   33,  -15,       46,   15,   -3,
      55,   -4,   10,       64,  -21,   23,       74,  -37,   35,       84,  -51,   47,
      32,   59,  -25,       34,   51,  -21,       40,   36,  -13,       47,   18,   -2,
      56,   -1,   11,       65,  -18,   24,       74,  -34,   36,       84,  -49,   48,
      33,   60,  -23,       36,   53,  -19,       41,   39,  -11,       48,   21,    0,
      57,    2,   12,       66,  -15,   24,       75,  -31,   36,       84,  -46,   48,
      35,   62,  -20,       37,   55,  -17,       42,   42,   -9,       49,   24,    1,
      57,    5,   13,       66,  -12,   25,       75,  -28,   37,       85,  -43,   49,
      37,   64,  -17,       39,   58,  -14,       43,   45,   -7,       50,   28,    3,
      58,    9,   15,       67,   -9,   26,       76,  -25,   38,       85,  -40,   50,
      38,   66,  -14,       40,   60,  -11,       45,   47,   -5,       51,   31,    5,
      59,   12,   16,       68,   -5,   27,       76,  -22,   39,       86,  -37,   50,
      40,   67,  -12,       42,   62,   -9,       46,   50,   -3,       52,   34,    6,
      60,   15,   17,       68,   -2,   28,       77,  -19,   40,       86,  -35,   51,
      41,   69,   -9,       43,   64,   -7,       47,   52,    0,       53,   37,    8,
      61,   19,   19,       69,    1,   29,       78,  -16,   40,       87,  -32,   52,
      43,   71,   -7,       45,   66,   -4,       49,   55,    2,       54,   40,   10,
      62,   22,   20,       70,    4,   31,       78,  -12,   41,       87,  -29,   52,
      45,   73,   -4,       46,   68,   -1,       50,   57,    4,       56,   43,   12,
      63,   25,   22,       71,    8,   32,       79,   -9,   42,       88,  -25,   53,
      46,   74,   -1,       48,   70,    1,       52,   60,    6,       57,   46,   14,
      64,   29,   23,       71,   11,   33,       80,   -6,   43,       88,  -22,   54,
      48,   76,    1,       50,   72,    3,       53,   62,    8,       58,   48,   16,
      65,   32,   25,       72,   15,   34,       80,   -2,   44,       89,  -19,   55,
      50,   78,    4,       51,   74,    6,       54,   65,   10,       59,   51,   17,
      66,   35,   26,       73,   18,   36,       81,    1,   45,       89,  -16,   56,
      51,   80,    7,       53,   76,    8,       56,   67,   13,       61,   54,   19,
      67,   38,   28,       74,   21,   37,       82,    5,   47,       90,  -12,   57,
      53,   82,    9,       54,   78,   11,       57,   69,   15,       62,   57,   21,
      68,   41,   30,       75,   25,   38,       83,    8,   48,       91,   -9,   58,
      55,   83,   12,       56,   80,   13,       59,   72,   17,       63,   60,   23,
      69,   44,   31,       76,   28,   40,       83,   11,   49,       92,   -6,   59,
      13,   44,  -62,       19,   27,  -52,       29,    3,  -36,       39,  -16,  -19,
      50,  -33,   -3,       61,  -47,   12,       71,  -59,   26,       81,  -70,   40,
      13,   45,  -61,       19,   27,  -52,       29,    4,  -36,       39,  -16,  -19,
      50,  -33,   -3,       61,  -47,   12,       71,  -59,   26,       81,  -70,   40,
      13,   45,  -61,       19,   28,  -51,       29,    5,  -35,       39,  -15,  -19,
      50,  -32,   -3,       61,  -46,   12,       71,  -58,   26,       81,  -69,   40,
      14,   45,  -60,       20,   29,  -50,       29,    6,  -35,       39,  -14,  -19,
      50,  -32,   -2,       61,  -46,   12,       71,  -58,   26,       81,  -69,   40,
      15,   45,  -59,       20,   30,  -50,       29,    7,  -35,       40,  -13,  -18,
      50,  -31,   -2,       61,  -45,   13,       71,  -57,   27,       81,  -69,   40,
      15,   46,  -57,       21,   31,  -49,       30,    8,  -34,       40,  -12,  -18,
      51,  -29,   -2,       61,  -44,   13,       71,  -56,   27,       81,  -68,   40,
      16,   46,  -56,       21,   32,  -48,       30,   10,  -33,       40,  -10,  -18,
      51,  -28,   -2,       61,  -43,   13,       71,  -55,   27,       81,  -67,   40,
      18,   47,  -54,       22,   34,  -46,       31,   12,  -32,       41,   -8,  -17,
      51,  -26,   -1,       61,  -41,   13,       71,  -54,   27,       82,  -66,   40,
      19,   48,  -52,       23,   35,  -45,       31,   14,  -31,       41,   -6,  -16,
      51,  -24,   -1,       62,  -40,   14,       72,  -53,   27,       82,  -65,   41,
      20,   49,  -50,       24,   37,  -43,       32,   16,  -30,       42,   -4,  -15,
      52,  -22,    0,       62,  -38,   14,       72,  -51,   28,       82,  -64,   41,
      21,   50,  -48,       25,   39,  -41,       33,   19,  -29,       42,   -1,  -15,
      52,  -20,    0,       62,  -36,   15,       72,  -49,   28,       82,  -62,   41,
      23,   51,  -45,       26,   40,  -39,       34,   21,  -28,       43,    1,  -14,
      53,  -18,    1,       62,  -34,   15,       72,  -48,   28,       82,  -60,   41,
      24,   53,  -43,       28,   42,  -37,       35,   24,  -26,       43,    4,  -13,
      53,  -15,    2,       63,  -31,   16,       73,  -45,   29,       83,  -59,   42,
      26,   54,  -40,       29,   44,  -35,       36,   27,  -24,       44,    7,  -11,
      54,  -12,    3,       63,  -29,   16,       73,  -43,   29,       83,  -57,   42,
      27,   55,  -38,       30,   46,  -33,       37,   29,  -23,       45,   10,  -10,
      54,   -9,    4,       64,  -26,   17,       73,  -41,   30,       83,  -55,   43,
      29,   57,  -35,       32,   48,  -31,       38,   32,  -21,       46,   13,   -9,
      55,   -6,    5,       64,  -23,   18,       74,  -38,   30,       83,  -52,   43,
      30,   58,  -32,       33,   51,  -28,       39,   35,  -19,       47,   16,   -7,
      55,   -3,    6,       65,  -20,   19,       74,  -36,   31,       84,  -50,   44,
      32,   60,  -30,       35,   53,  -26,       40,   38,  -17,       47,   19,   -6,
      56,    0,    7,       65,  -17,   19,       74,  -33,   32,       84,  -48,   44,
      34,   61,  -27,       36,   54,  -23,       41,   40,  -15,       48,   22,   -5,
      57,    3,    8,       66,  -14,   20,       75,  -30,   32,       84,  -45,   45,
      35,   63,  -24,       37,   56,  -21,       42,   43,  -13,       49,   25,   -3,
      58,    7,    9,       66,  -11,   21,       75,  -27,   33,       85,  -42,   45,
      37,   65,  -22,       39,   59,  -18,       44,   46,  -11,       50,   29,   -1,
      58,   10,   10,       67,   -8,   22,       76,  -24,   34,       85,  -39,   46,
      39,   66,  -19,       41,   61,  -16,       45,   48,   -9,       51,   32,    0,
      59,   13,   12,       68,   -4,   23,       76,  -21,   35,       86,  -37,   46,
      40,   68,  -16,       42,   63,  -14,       46,   51,   -7,       52,   35,    2,
      60,   16,   13,       68,   -1,   24,       77,  -18,   36,       86,  -34,   47,
      42,   70,  -14,       44,   65,  -11,       48,   53,   -5,       54,   38,    4,
      61,   20,   14,       69,    2,   25,       78,  -15,   37,       87,  -31,   48,
      43,   71,  -11,       45,   67,   -9,       49,   56,   -3,       55,   41,    5,
      62,   23,   16,       70,    5,   26,       78,  -12,   37,       87,  -28,   49,
      45,   73,   -8,       47,   69,   -6,       50,   58,    0,       56,   44,    7,
      63,   26,   17,       71,    9,   28,       79,   -8,   39,       88,  -24,   50,
      47,   75,   -6,       48,   71,   -4,       52,   61,    2,       57,   47,    9,
      64,   29,   19,       72,   12,   29,       80,   -5,   40,       88,  -21,   50,
      48,   77,   -3,       50,   73,   -1,       53,   63,    4,       58,   49,   11,
      65,   33,   20,       72,   15,   30,       80,   -2,   41,       89,  -18,   51,
      50,   79,   -1,       51,   75,    1,       55,   65,    6,       59,   52,   13,
      66,   36,   22,       73,   19,   32,       81,    2,   42,       90,  -15,   52,
      52,   80,    2,       53,   77,    4,       56,   68,    8,       61,   55,   15,
      67,   39,   24,       74,   22,   33,       82,    5,   43,       90,  -12,   53,
      53,   82,    5,       55,   79,    6,       58,   70,   11,       62,   58,   17,
      68,   42,   25,       75,   25,   34,       83,    9,   44,       91,   -8,   54,
      55,   84,    7,       56,   80,    9,       59,   72,   13,       63,   60,   19,
      69,   45,   27,       76,   28,   36,       83,   12,   45,       92,   -5,   55,
      14,   47,  -65,       20,   31,  -56,       29,    7,  -41,       40,  -13,  -24,
      50,  -30,   -8,       61,  -45,    7,       71,  -57,   22,       81,  -68,   35,
      14,   47,  -65,       20,   31,  -56,       29,    8,  -40,       40,  -13,  -24,
      50,  -30,   -8,       61,  -44,    8,       71,  -57,   22,       81,  -68,   35,
      15,   47,  -64,       20,   31,  -55,       29,    8,  -40,       40,  -12,  -24,
      50,  -30,   -7,       61,  -44,    8,       71,  -56,   22,       81,  -68,   35,
      15,   48,  -63,       21,   32,  -55,       30,    9,  -40,       40,  -11,  -24,
      51,  -29,   -7,       61,  -43,    8,       71,  -56,   22,       81,  -67,   36,
      16,   48,  -62,       21,   33,  -54,       30,   10,  -39,       40,  -10,  -23,
      51,  -28,   -7,       61,  -43,    8,       71,  -55,   22,       81,  -67,   36,
      17,   48,  -61,       22,   34,  -53,       30,   12,  -39,       40,   -9,  -23,
      51,  -27,   -7,       61,  -42,    8,       71,  -54,   22,       81,  -66,   36,
      17,   49,  -60,       22,   35,  -52,       31,   13,  -38,       41,   -7,  -22,
      51,  -26,   -6,       61,  -40,    8,       71,  -54,   22,       82,  -66,   36,
      19,   49,  -58,       23,   36,  -50,       31,   15,  -37,       41,   -5,  -22,
      51,  -24,   -6,       62,  -39,    9,       72,  -52,   23,       82,  -64,   36,
      20,   50,  -56,       24,   38,  -49,       32,   17,  -36,       41,   -3,  -21,
      52,  -22,   -6,       62,  -37,    9,       72,  -51,   23,       82,  -63,   36,
      21,   51,  -54,       25,   39,  -47,       33,   19,  -35,       42,   -1,  -20,
      52,  -20,   -5,       62,  -36,    9,       72,  -49,   23,       82,  -62,   37,
      22,   52,  -52,       26,   41,  -46,       33,   21,  -34,       42,    1,  -20,
      52,  -18,   -4,       62,  -34,   10,       72,  -48,   24,       82,  -61,   37,
      23,   53,  -50,       27,   43,  -44,       34,   24,  -32,       43,    4,  -19,
      53,  -15,   -4,       63,  -32,   10,       72,  -46,   24,       82,  -59,   37,
      25,   54,  -47,       28,   45,  -42,       35,   26,  -31,       44,    7,  -17,
      53,  -13,   -3,       63,  -29,   11,       73,  -44,   24,       83,  -57,   38,
      26,   55,  -45,       30,   46,  -40,       36,   29,  -29,       44,    9,  -16,
      54,  -10,   -2,       63,  -27,   12,       73,  -42,   25,       83,  -55,   38,
      28,   57,  -42,       31,   48,  -37,       37,   31,  -28,       45,   12,  -15,
      54,   -7,   -1,       64,  -24,   12,       73,  -39,   25,       83,  -53,   38,
      29,   58,  -40,       32,   50,  -35,       38,   34,  -26,       46,   15,  -14,
      55,   -4,    0,       64,  -22,   13,       74,  -37,   26,       83,  -51,   39,
      31,   60,  -37,       34,   52,  -33,       39,   37,  -24,       47,   18,  -12,
      56,   -1,    1,       65,  -18,   14,       74,  -34,   27,       84,  -49,   39,
      33,   61,  -34,       35,   54,  -31,       40,   39,  -22,       48,   21,  -11,
      56,    2,    2,       65,  -16,   15,       75,  -32,   27,       84,  -46,   40,
      34,   63,  -32,       36,   56,  -28,       42,   42,  -20,       49,   24,  -10,
      57,    5,    3,       66,  -13,   16,       75,  -29,   28,       85,  -44,   40,
      36,   64,  -29,       38,   58,  -26,       43,   44,  -18,       50,   27,   -8,
      58,    8,    4,       67,  -10,   16,       76,  -26,   29,       85,  -41,   41,
      37,   66,  -26,       39,   60,  -23,       44,   47,  -16,       51,   30,   -6,
      59,   11,    6,       67,   -6,   18,       76,  -23,   30,       85,  -38,   42,
      39,   67,  -24,       41,   62,  -21,       45,   49,  -14,       52,   33,   -5,
      60,   15,    7,       68,   -3,   19,       77,  -20,   30,       86,  -35,   42,
      41,   69,  -21,       42,   64,  -19,       47,   52,  -12,       53,   36,   -3,
      60,   18,    8,       69,    0,   20,       77,  -17,   31,       86,  -33,   43,
      42,   71,  -19,       44,   66,  -16,       48,   54,  -10,       54,   39,   -1,
      61,   21,   10,       69,    3,   21,       78,  -14,   32,       87,  -30,   44,
      44,   72,  -16,       45,   68,  -14,       49,   57,   -8,       55,   42,    1,
      62,   24,   11,       70,    6,   22,       78,  -11,   33,       87,  -27,   44,
      45,   74,  -13,       47,   70,  -11,       51,   59,   -5,       56,   45,    3,
      63,   27,   13,       71,   10,   23,       79,   -7,   34,       88,  -23,   45,
      47,   76,  -11,       49,   72,   -9,       52,   62,   -3,       57,   47,    4,
      64,   30,   14,       72,   13,   24,       80,   -4,   35,       89,  -20,   46,
      49,   78,   -8,       50,   73,   -6,       53,   64,   -1,       59,   50,    6,
      65,   33,   16,       73,   16,   26,       81,   -1,   36,       89,  -17,   47,
      50,   79,   -6,       52,   75,   -4,       55,   66,    1,       60,   53,    8,
      66,   36,   17,       73,   19,   27,       81,    3,   37,       90,  -14,   48,
      52,   81,   -3,       53,   77,   -1,       56,   69,    3,       61,   56,   10,
      67,   40,   19,       74,   23,   28,       82,    6,   38,       90,  -11,   49,
      54,   83,   -1,       55,   79,    1,       58,   71,    6,       62,   58,   12,
      68,   43,   21,       75,   26,   30,       83,    9,   40,       91,   -8,   50,
      55,   85,    2,       56,   81,    4,       59,   73,    8,       64,   61,   14,
      69,   46,   22,       76,   29,   31,       84,   13,   41,       92,   -4,   51,
      15,   49,  -68,       21,   34,  -59,       30,   11,  -45,       40,  -10,  -28,
      51,  -28,  -12,       61,  -43,    3,       71,  -55,   18,       81,  -67,   32,
      16,   49,  -68,       21,   34,  -59,       30,   11,  -44,       40,   -9,  -28,
      51,  -27,  -12,       61,  -42,    3,       71,  -55,   18,       81,  -67,   32,
      16,   49,  -67,       21,   34,  -59,       30,   12,  -44,       40,   -9,  -28,
      51,  -27,  -12,       61,  -42,    3,       71,  -55,   18,       81,  -66,   32,
      16,   50,  -66,       21,   35,  -58,       30,   13,  -44,       40,   -8,  -28,
      51,  -26,  -12,       61,  -41,    4,       71,  -54,   18,       81,  -66,   32,
      17,   50,  -66,       22,   36,  -57,       31,   14,  -43,       40,   -7,  -28,
      51,  -25,  -11,       61,  -40,    4,       71,  -54,   18,       81,  -66,   32,
      18,   50,  -64,       22,   37,  -57,       31,   15,  -43,       41,   -6,  -27,
      51,  -24,  -11,       61,  -40,    4,       71,  -53,   18,       82,  -65,   32,
      19,   51,  -63,       23,   38,  -56,       31,   16,  -42,       41,   -5,  -27,
      51,  -23,  -11,       61,  -38,    4,       72,  -52,   18,       82,  -64,   32,
      20,   51,  -61,       24,   39,  -54,       32,   18,  -41,       41,   -3,  -26,
      52,  -21,  -10,       62,  -37,    4,       72,  -51,   19,       82,  -63,   32,
      21,   52,  -59,       25,   40,  -53,       32,   20,  -40,       42,   -1,  -25,
      52,  -20,  -10,       62,  -35,    5,       72,  -49,   19,       82,  -62,   32,
      22,   53,  -58,       26,   42,  -51,       33,   22,  -39,       42,    1,  -25,
      52,  -18,   -9,       62,  -34,    5,       72,  -48,   19,       82,  -61,   33,
      23,   54,  -56,       27,   43,  -50,       34,   24,  -38,       43,    3,  -24,
      53,  -16,   -9,       62,  -32,    6,       72,  -46,   19,       82,  -59,   33,
      24,   55,  -53,       28,   45,  -48,       35,   26,  -36,       43,    6,  -23,
      53,  -13,   -8,       63,  -30,    6,       73,  -44,   20,       82,  -58,   33,
      26,   56,  -51,       29,   46,  -46,       36,   28,  -35,       44,    9,  -22,
      54,  -11,   -7,       63,  -27,    7,       73,  -42,   20,       83,  -56,   34,
      27,   57,  -49,       30,   48,  -44,       37,   31,  -33,       45,   11,  -21,
      54,   -8,   -6,       64,  -25,    7,       73,  -40,   21,       83,  -54,   34,
      28,   58,  -46,       31,   50,  -42,       37,   33,  -32,       45,   14,  -19,
      55,   -5,   -6,       64,  -23,    8,       73,  -38,   21,       83,  -52,   34,
      30,   59,  -44,       33,   51,  -39,       38,   36,  -30,       46,   17,  -18,
      55,   -3,   -5,       64,  -20,    9,       74,  -36,   22,       84,  -50,   35,
      32,   61,  -41,       34,   53,  -37,       40,   38,  -28,       47,   20,  -17,
      56,    0,   -3,       65,  -17,   10,       74,  -33,   23,       84,  -47,   35,
      33,   62,  -39,       35,   55,  -35,       41,   41,  -26,       48,   23,  -15,
      57,    3,   -2,       66,  -14,   10,       75,  -30,   23,       84,  -45,   36,
      35,   64,  -36,       37,   57,  -33,       42,   43,  -25,       49,   25,  -14,
      57,    6,   -1,       66,  -11,   11,       75,  -28,   24,       85,  -43,   37,
      36,   65,  -34,       38,   59,  -30,       43,   46,  -23,       50,   28,  -12,
      58,    9,    0,       67,   -8,   12,       76,  -25,   25,       85,  -40,   37,
      38,   67,  -31,       40,   61,  -28,       44,   48,  -20,       51,   31,  -11,
      59,   13,    1,       67,   -5,   13,       76,  -22,   26,       86,  -37,   38,
      39,   68,  -28,       41,   63,  -25,       46,   51,  -18,       52,   34,   -9,
      60,   16,    3,       68,   -2,   14,       77,  -19,   26,       86,  -34,   38,
      41,   70,  -26,       43,   65,  -23,       47,   53,  -16,       53,   37,   -7,
      61,   19,    4,       69,    1,   15,       77,  -16,   27,       86,  -32,   39,
      42,   72,  -23,       44,   67,  -20,       48,   55,  -14,       54,   40,   -6,
      61,   22,    5,       69,    4,   17,       78,  -13,   28,       87,  -29,   40,
      44,   73,  -21,       46,   68,  -18,       50,   58,  -12,       55,   43,   -4,
      62,   25,    7,       70,    7,   18,       79,  -10,   29,       87,  -26,   41,
      46,   75,  -18,       47,   70,  -15,       51,   60,  -10,       56,   46,   -2,
      63,   28,    8,       71,   11,   19,       79,   -6,   30,       88,  -23,   42,
      47,   77,  -15,       49,   72,  -13,       52,   62,   -8,       58,   48,    0,
      64,   31,   10,       72,   14,   20,       80,   -3,   31,       89,  -20,   42,
      49,   78,  -13,       50,   74,  -11,       54,   65,   -6,       59,   51,    2,
      65,   34,   11,       73,   17,   22,       81,    0,   32,       89,  -16,   43,
      50,   80,  -10,       52,   76,   -8,       55,   67,   -3,       60,   54,    4,
      66,   37,   13,       74,   20,   23,       81,    3,   33,       90,  -13,   44,
      52,   82,   -7,       53,   78,   -6,       57,   69,   -1,       61,   57,    6,
      67,   41,   15,       75,   24,   24,       82,    7,   34,       91,  -10,   45,
      54,   84,   -5,       55,   80,   -3,       58,   72,    1,       62,   59,    8,
      69,   44,   16,       75,   27,   26,       83,   10,   36,       91,   -7,   46,
      55,   85,   -2,       57,   82,   -1,       59,   74,    3,       64,   62,   10,
      70,   46,   18,       76,   30,   27,       84,   13,   37,       92,   -4,   47,
      17,   51,  -71,       22,   37,  -63,       30,   14,  -48,       40,   -7,  -33,
      51,  -25,  -16,       61,  -40,   -1,       71,  -53,   14,       81,  -65,   28,
      17,   52,  -71,       22,   37,  -63,       31,   15,  -48,       40,   -6,  -32,
      51,  -25,  -16,       61,  -40,   -1,       71,  -53,   14,       81,  -65,   28,
      17,   52,  -70,       22,   37,  -62,       31,   15,  -48,       41,   -6,  -32,
      51,  -24,  -16,       61,  -40,   -1,       71,  -53,   14,       82,  -65,   28,
      18,   52,  -70,       22,   38,  -62,       31,   16,  -48,       41,   -5,  -32,
      51,  -24,  -16,       61,  -39,   -1,       71,  -52,   14,       82,  -64,   28,
      18,   52,  -69,       23,   39,  -61,       31,   17,  -47,       41,   -4,  -32,
      51,  -23,  -16,       61,  -38,    0,       71,  -52,   14,       82,  -64,   28,
      19,   52,  -68,       23,   39,  -60,       31,   18,  -47,       41,   -3,  -31,
      51,  -22,  -15,       62,  -37,    0,       72,  -51,   14,       82,  -63,   28,
      20,   53,  -66,       24,   40,  -59,       32,   19,  -46,       41,   -2,  -31,
      52,  -21,  -15,       62,  -36,    0,       72,  -50,   14,       82,  -63,   28,
      21,   53,  -65,       25,   41,  -58,       32,   21,  -45,       42,    0,  -30,
      52,  -19,  -15,       62,  -35,    0,       72,  -49,   15,       82,  -62,   28,
      22,   54,  -63,       25,   43,  -56,       33,   22,  -44,       42,    2,  -30,
      52,  -17,  -14,       62,  -33,    1,       72,  -48,   15,       82,  -60,   29,
      23,   55,  -61,       26,   44,  -55,       34,   24,  -43,       43,    4,  -29,
      53,  -15,  -14,       62,  -32,    1,       72,  -46,   15,       82,  -59,   29,
      24,   56,  -59,       27,   45,  -53,       34,   26,  -42,       43,    6,  -28,
      53,  -13,  -13,       63,  -30,    2,       72,  -45,   15,       82,  -58,   29,
      25,   56,  -57,       28,   47,  -52,       35,   28,  -41,       44,    8,  -27,
      53,  -11,  -12,       63,  -28,    2,       73,  -43,   16,       83,  -56,   29,
      26,   57,  -55,       30,   48,  -50,       36,   31,  -39,       44,   11,  -26,
      54,   -9,  -11,       63,  -26,    3,       73,  -41,   16,       83,  -54,   30,
      28,   59,  -52,       31,   50,  -48,       37,   33,  -38,       45,   13,  -25,
      54,   -6,  -11,       64,  -23,    3,       73,  -39,   17,       83,  -53,   30,
      29,   60,  -50,       32,   51,  -46,       38,   35,  -36,       46,   16,  -24,
      55,   -4,  -10,       64,  -21,    4,       74,  -36,   17,       83,  -51,   31,
      30,   61,  -48,       33,   53,  -44,       39,   37,  -34,       47,   19,  -22,
      55,   -1,   -9,       65,  -18,    5,       74,  -34,   18,       84,  -49,   31,
      32,   62,  -45,       35,   55,  -41,       40,   40,  -32,       47,   22,  -21,
      56,    2,   -8,       65,  -15,    5,       74,  -31,   19,       84,  -46,   32,
      34,   64,  -43,       36,   57,  -39,       41,   42,  -31,       48,   24,  -20,
      57,    5,   -7,       66,  -13,    6,       75,  -29,   19,       84,  -44,   32,
      35,   65,  -40,       37,   58,  -37,       42,   45,  -29,       49,   27,  -18,
      58,    8,   -6,       66,  -10,    7,       75,  -26,   20,       85,  -41,   33,
      37,   66,  -38,       39,   60,  -34,       43,   47,  -27,       50,   30,  -17,
      58,   11,   -4,       67,   -7,    8,       76,  -23,   21,       85,  -39,   33,
      38,   68,  -35,       40,   62,  -32,       45,   49,  -25,       51,   33,  -15,
      59,   14,   -3,       68,   -4,    9,       76,  -20,   22,       86,  -36,   34,
      40,   70,  -32,       42,   64,  -30,       46,   52,  -23,       52,   36,  -13,
      60,   17,   -2,       68,   -1,   10,       77,  -17,   22,       86,  -33,   35,
      41,   71,  -30,       43,   66,  -27,       47,   54,  -21,       53,   38,  -12,
      61,   20,    0,       69,    2,   11,       77,  -14,   23,       87,  -31,   35,
      43,   73,  -27,       45,   68,  -25,       49,   56,  -19,       54,   41,  -10,
      62,   23,    1,       70,    5,   12,       78,  -11,   24,       87,  -28,   36,
      44,   74,  -25,       46,   69,  -22,       50,   59,  -17,       55,   44,   -8,
      63,   26,    2,       70,    9,   14,       79,   -8,   25,       88,  -25,   37,
      46,   76,  -22,       48,   71,  -20,       51,   61,  -14,       57,   47,   -6,
      64,   29,    4,       71,   12,   15,       79,   -5,   26,       88,  -22,   38,
      48,   77,  -20,       49,   73,  -17,       53,   63,  -12,       58,   49,   -4,
      65,   32,    6,       72,   15,   16,       80,   -2,   27,       89,  -19,   39,
      49,   79,  -17,       51,   75,  -15,       54,   66,  -10,       59,   52,   -2,
      66,   35,    7,       73,   18,   17,       81,    1,   28,       89,  -16,   39,
      51,   81,  -15,       52,   77,  -13,       55,   68,   -8,       60,   55,   -1,
      67,   38,    9,       74,   21,   19,       81,    4,   29,       90,  -13,   40,
      52,   83,  -12,       54,   79,  -10,       57,   70,   -5,       61,   57,    1,
      68,   42,   10,       75,   25,   20,       82,    8,   31,       91,   -9,   41,
      54,   84,   -9,       55,   81,   -8,       58,   72,   -3,       63,   60,    3,
      69,   44,   12,       76,   28,   22,       83,   11,   32,       91,   -6,   42,
      56,   86,   -7,       57,   82,   -5,       60,   74,   -1,       64,   62,    5,
      70,   47,   14,       76,   31,   23,       84,   14,   33,       92,   -3,   43,
      18,   54,  -74,       23,   40,  -66,       31,   18,  -52,       41,   -4,  -37,
      51,  -22,  -20,       61,  -38,   -5,       71,  -51,    9,       82,  -64,   24,
      18,   54,  -74,       23,   40,  -66,       31,   18,  -52,       41,   -3,  -37,
      51,  -22,  -20,       61,  -38,   -5,       71,  -51,   10,       82,  -64,   24,
      18,   54,  -73,       23,   40,  -66,       31,   18,  -52,       41,   -3,  -36,
      51,  -22,  -20,       61,  -37,   -5,       71,  -51,   10,       82,  -63,   24,
      19,   54,  -73,       23,   41,  -65,       31,   19,  -52,       41,   -2,  -36,
      51,  -21,  -20,       62,  -37,   -5,       72,  -50,   10,       82,  -63,   24,
      19,   54,  -72,       24,   41,  -64,       32,   20,  -51,       41,   -1,  -36,
      52,  -20,  -20,       62,  -36,   -5,       72,  -50,   10,       82,  -62,   24,
      20,   55,  -71,       24,   42,  -64,       32,   21,  -51,       41,    0,  -35,
      52,  -19,  -20,       62,  -35,   -4,       72,  -49,   10,       82,  -62,   24,
      21,   55,  -69,       25,   43,  -63,       33,   22,  -50,       42,    1,  -35,
      52,  -18,  -19,       62,  -34,   -4,       72,  -48,   10,       82,  -61,   24,
      22,   55,  -68,       25,   44,  -61,       33,   24,  -49,       42,    3,  -34,
      52,  -16,  -19,       62,  -33,   -4,       72,  -47,   10,       82,  -60,   24,
      22,   56,  -66,       26,   45,  -60,       34,   25,  -48,       43,    5,  -34,
      53,  -15,  -18,       62,  -31,   -4,       72,  -46,   11,       82,  -59,   25,
      23,   57,  -65,       27,   46,  -59,       34,   27,  -47,       43,    6,  -33,
      53,  -13,  -18,       63,  -30,   -3,       72,  -44,   11,       82,  -58,   25,
      25,   57,  -63,       28,   47,  -57,       35,   29,  -46,       44,    8,  -32,
      53,  -11,  -17,       63,  -28,   -3,       73,  -43,   11,       83,  -56,   25,
      26,   58,  -61,       29,   49,  -55,       36,   31,  -45,       44,   11,  -31,
      54,   -9,  -16,       63,  -26,   -2,       73,  -41,   12,       83,  -55,   25,
      27,   59,  -58,       30,   50,  -53,       37,   33,  -43,       45,   13,  -30,
      54,   -7,  -16,       64,  -24,   -2,       73,  -39,   12,       83,  -53,   26,
      28,   60,  -56,       31,   52,  -52,       37,   35,  -42,       45,   15,  -29,
      55,   -4,  -15,       64,  -21,   -1,       73,  -37,   13,       83,  -51,   26,
      30,   61,  -54,       32,   53,  -50,       38,   37,  -40,       46,   18,  -28,
      55,   -2,  -14,       64,  -19,    0,       74,  -35,   13,       84,  -49,   27,
      31,   62,  -52,       34,   55,  -48,       39,   39,  -38,       47,   20,  -27,
      56,    1,  -13,       65,  -17,    0,       74,  -33,   14,       84,  -47,   27,
      33,   64,  -49,       35,   56,  -45,       41,   42,  -37,       48,   23,  -25,
      56,    4,  -12,       65,  -14,    1,       75,  -30,   14,       84,  -45,   28,
      34,   65,  -47,       36,   58,  -43,       42,   44,  -35,       49,   26,  -24,
      57,    7,  -11,       66,  -11,    2,       75,  -27,   15,       85,  -43,   28,
      36,   66,  -44,       38,   60,  -41,       43,   46,  -33,       50,   29,  -22,
      58,   10,  -10,       66,   -8,    3,       76,  -25,   16,       85,  -40,   29,
      37,   68,  -42,       39,   61,  -39,       44,   48,  -31,       50,   31,  -21,
      59,   12,   -9,       67,   -5,    4,       76,  -22,   17,       85,  -38,   29,
      39,   69,  -39,       41,   63,  -36,       45,   51,  -29,       52,   34,  -19,
      59,   16,   -7,       68,   -2,    5,       77,  -19,   17,       86,  -35,   30,
      40,   71,  -37,       42,   65,  -34,       46,   53,  -27,       52,   37,  -18,
      60,   19,   -6,       68,    1,    6,       77,  -16,   18,       86,  -32,   31,
      42,   72,  -34,       43,   67,  -31,       48,   55,  -25,       54,   40,  -16,
      61,   21,   -5,       69,    4,    7,       78,  -13,   19,       87,  -29,   31,
      43,   74,  -32,       45,   69,  -29,       49,   58,  -23,       55,   42,  -14,
      62,   24,   -3,       70,    7,    8,       78,  -10,   20,       87,  -27,   32,
      45,   75,  -29,       46,   70,  -27,       50,   60,  -21,       56,   45,  -12,
      63,   27,   -2,       71,   10,    9,       79,   -7,   21,       88,  -24,   33,
      46,   77,  -26,       48,   72,  -24,       52,   62,  -18,       57,   48,  -10,
      64,   31,    0,       71,   13,   11,       80,   -4,   22,       88,  -21,   34,
      48,   78,  -24,       49,   74,  -22,       53,   64,  -16,       58,   50,   -9,
      65,   34,    1,       72,   16,   12,       80,   -1,   23,       89,  -18,   35,
      50,   80,  -21,       51,   76,  -19,       54,   66,  -14,       59,   53,   -7,
      66,   36,    3,       73,   19,   13,       81,    2,   24,       89,  -15,   36,
      51,   82,  -19,       52,   78,  -17,       56,   69,  -12,       60,   56,   -5,
      67,   39,    4,       74,   22,   15,       82,    5,   25,       90,  -12,   36,
      53,   83,  -16,       54,   80,  -14,       57,   71,  -10,       62,   58,   -3,
      68,   42,    6,       75,   26,   16,       82,    9,   27,       91,   -8,   38,
      54,   85,  -14,       56,   81,  -12,       58,   73,   -7,       63,   61,   -1,
      69,   45,    8,       76,   29,   17,       83,   12,   28,       91,   -5,   38,
      56,   87,  -11,       57,   83,   -9,       60,   75,   -5,       64,   63,    1,
      70,   48,    9,       77,   32,   19,       84,   15,   29,       92,   -2,   39,
      19,   56,  -77,       24,   43,  -70,       32,   21,  -57,       41,    0,  -41,
      52,  -19,  -25,       62,  -35,  -10,       72,  -49,    5,       82,  -62,   19,
      19,   56,  -77,       24,   43,  -70,       32,   22,  -56,       41,    0,  -41,
      52,  -19,  -25,       62,  -35,  -10,       72,  -49,    5,       82,  -62,   19,
      20,   56,  -76,       24,   43,  -69,       32,   22,  -56,       41,    1,  -41,
      52,  -18,  -25,       62,  -35,  -10,       72,  -49,    5,       82,  -61,   19,
      20,   56,  -76,       24,   44,  -69,       32,   23,  -56,       42,    2,  -41,
      52,  -18,  -25,       62,  -34,   -9,       72,  -48,    5,       82,  -61,   19,
      21,   57,  -75,       25,   44,  -68,       32,   23,  -55,       42,    2,  -40,
      52,  -17,  -24,       62,  -33,   -9,       72,  -47,    5,       82,  -60,   20,
      21,   57,  -74,       25,   45,  -67,       33,   24,  -55,       42,    3,  -40,
      52,  -16,  -24,       62,  -33,   -9,       72,  -47,    5,       82,  -60,   20,
      22,   57,  -73,       26,   46,  -67,       33,   25,  -54,       42,    5,  -40,
      52,  -15,  -24,       62,  -32,   -9,       72,  -46,    6,       82,  -59,   20,
      23,   58,  -71,       26,   47,  -65,       34,   27,  -53,       43,    6,  -39,
      53,  -14,  -23,       62,  -30,   -9,       72,  -45,    6,       82,  -58,   20,
      24,   58,  -70,       27,   48,  -64,       34,   28,  -52,       43,    8,  -38,
      53,  -12,  -23,       63,  -29,   -8,       72,  -44,    6,       82,  -57,   20,
      25,   59,  -68,       28,   49,  -63,       35,   30,  -51,       43,    9,  -38,
      53,  -10,  -22,       63,  -27,   -8,       73,  -42,    6,       83,  -56,   20,
      26,   59,  -67,       29,   50,  -61,       36,   31,  -50,       44,   11,  -37,
      54,   -9,  -22,       63,  -26,   -7,       73,  -41,    7,       83,  -55,   21,
      27,   60,  -65,       30,   51,  -60,       36,   33,  -49,       45,   13,  -36,
      54,   -7,  -21,       63,  -24,   -7,       73,  -39,    7,       83,  -53,   21,
      28,   61,  -62,       31,   52,  -58,       37,   35,  -48,       45,   16,  -35,
      54,   -4,  -20,       64,  -21,   -6,       73,  -37,    8,       83,  -51,   21,
      29,   62,  -60,       32,   54,  -56,       38,   37,  -46,       46,   18,  -34,
      55,   -2,  -20,       64,  -19,   -6,       74,  -35,    8,       83,  -50,   22,
      31,   63,  -58,       33,   55,  -54,       39,   39,  -45,       47,   20,  -33,
      55,    1,  -19,       65,  -17,   -5,       74,  -33,    9,       84,  -48,   22,
      32,   64,  -56,       34,   57,  -52,       40,   41,  -43,       47,   23,  -31,
      56,    3,  -18,       65,  -15,   -4,       74,  -31,    9,       84,  -46,   23,
      33,   65,  -53,       36,   58,  -50,       41,   44,  -41,       48,   25,  -30,
      57,    6,  -17,       66,  -12,   -3,       75,  -28,   10,       84,  -43,   23,
      35,   66,  -51,       37,   60,  -47,       42,   46,  -39,       49,   28,  -29,
      57,    9,  -16,       66,   -9,   -3,       75,  -26,   11,       85,  -41,   24,
      36,   68,  -49,       38,   61,  -45,       43,   48,  -38,       50,   31,  -27,
      58,   11,  -14,       67,   -6,   -2,       76,  -23,   11,       85,  -39,   24,
      38,   69,  -46,       40,   63,  -43,       44,   50,  -36,       51,   33,  -26,
      59,   14,  -13,       67,   -4,   -1,       76,  -20,   12,       85,  -36,   25,
      39,   70,  -44,       41,   65,  -41,       46,   52,  -34,       52,   36,  -24,
      60,   17,  -12,       68,   -1,    0,       77,  -17,   13,       86,  -33,   26,
      41,   72,  -41,       43,   66,  -38,       47,   55,  -32,       53,   39,  -22,
      60,   20,  -11,       69,    2,    1,       77,  -15,   14,       86,  -31,   26,
      42,   73,  -39,       44,   68,  -36,       48,   57,  -30,       54,   41,  -21,
      61,   23,   -9,       69,    5,    2,       78,  -12,   15,       87,  -28,   27,
      44,   75,  -36,       45,   70,  -34,       49,   59,  -28,       55,   44,  -19,
      62,   26,   -8,       70,    8,    4,       78,   -9,   16,       87,  -25,   28,
      45,   76,  -34,       47,   72,  -31,       51,   61,  -26,       56,   46,  -17,
      63,   29,   -7,       71,   11,    5,       79,   -6,   16,       88,  -23,   29,
      47,   78,  -31,       48,   73,  -29,       52,   63,  -23,       57,   49,  -15,
      64,   32,   -5,       72,   15,    6,       80,   -3,   18,       88,  -19,   29,
      48,   79,  -29,       50,   75,  -26,       53,   65,  -21,       58,   52,  -13,
      65,   35,   -3,       72,   17,    7,       80,    0,   19,       89,  -16,   30,
      50,   81,  -26,       51,   77,  -24,       55,   68,  -19,       59,   54,  -12,
      66,   38,   -2,       73,   20,    9,       81,    3,   20,       90,  -13,   31,
      51,   82,  -24,       53,   79,  -22,       56,   70,  -17,       61,   57,  -10,
      67,   40,    0,       74,   23,   10,       82,    6,   21,       90,  -10,   32,
      53,   84,  -21,       54,   81,  -19,       57,   72,  -14,       62,   59,   -8,
      68,   44,    1,       75,   27,   11,       83,   10,   22,       91,   -7,   33,
      55,   86,  -18,       56,   82,  -17,       59,   74,  -12,       63,   62,   -6,
      69,   46,    3,       76,   30,   13,       83,   13,   23,       92,   -4,   34,
      56,   87,  -16,       57,   84,  -14,       60,   76,  -10,       64,   64,   -4,
      70,   49,    5,       77,   33,   14,       84,   16,   24,       92,   -1,   35,
      20,   58,  -80,       25,   46,  -73,       32,   25,  -60,       42,    3,  -45,
      52,  -16,  -29,       62,  -33,  -14,       72,  -47,    1,       82,  -60,   15,
      21,   58,  -80,       25,   46,  -73,       33,   25,  -60,       42,    4,  -45,
      52,  -16,  -29,       62,  -32,  -14,       72,  -47,    1,       82,  -60,   15,
      21,   58,  -79,       25,   46,  -73,       33,   25,  -60,       42,    4,  -45,
      52,  -16,  -29,       62,  -32,  -14,       72,  -46,    1,       82,  -59,   15,
      21,   58,  -79,       25,   47,  -72,       33,   26,  -60,       42,    5,  -45,
      52,  -15,  -29,       62,  -32,  -14,       72,  -46,    1,       82,  -59,   15,
      22,   59,  -78,       26,   47,  -72,       33,   27,  -59,       42,    5,  -44,
      52,  -14,  -29,       62,  -31,  -13,       72,  -45,    1,       82,  -59,   16,
      22,   59,  -77,       26,   48,  -71,       33,   27,  -59,       42,    6,  -44,
      52,  -13,  -28,       62,  -30,  -13,       72,  -45,    1,       82,  -58,   16,
      23,   59,  -76,       27,   48,  -70,       34,   28,  -58,       43,    7,  -44,
      53,  -12,  -28,       62,  -29,  -13,       72,  -44,    2,       82,  -57,   16,
      24,   60,  -75,       27,   49,  -69,       34,   30,  -57,       43,    9,  -43,
      53,  -11,  -28,       63,  -28,  -13,       72,  -43,    2,       82,  -56,   16,
      25,   60,  -73,       28,   50,  -68,       35,   31,  -56,       43,   10,  -42,
      53,   -9,  -27,       63,  -27,  -12,       73,  -42,    2,       83,  -55,   16,
      25,   61,  -72,       29,   51,  -66,       35,   32,  -55,       44,   12,  -42,
      54,   -8,  -27,       63,  -25,  -12,       73,  -40,    2,       83,  -54,   17,
      26,   61,  -70,       30,   52,  -65,       36,   34,  -54,       44,   14,  -41,
      54,   -6,  -26,       63,  -23,  -11,       73,  -39,    3,       83,  -53,   17,
      28,   62,  -68,       31,   53,  -63,       37,   36,  -53,       45,   16,  -40,
      54,   -4,  -25,       64,  -22,  -11,       73,  -37,    3,       83,  -51,   17,
      29,   63,  -66,       32,   54,  -61,       38,   38,  -51,       46,   18,  -39,
      55,   -2,  -24,       64,  -19,  -10,       74,  -35,    4,       83,  -50,   18,
      30,   64,  -64,       33,   56,  -60,       39,   39,  -50,       46,   20,  -38,
      55,    0,  -24,       64,  -17,  -10,       74,  -33,    4,       84,  -48,   18,
      31,   65,  -62,       34,   57,  -58,       39,   41,  -49,       47,   22,  -37,
      56,    3,  -23,       65,  -15,   -9,       74,  -31,    5,       84,  -46,   18,
      33,   66,  -60,       35,   58,  -56,       40,   43,  -47,       48,   25,  -35,
      56,    5,  -22,       65,  -13,   -8,       75,  -29,    5,       84,  -44,   19,
      34,   67,  -57,       36,   60,  -53,       41,   45,  -45,       49,   27,  -34,
      57,    8,  -21,       66,  -10,   -7,       75,  -26,    6,       85,  -42,   19,
      35,   68,  -55,       38,   61,  -51,       43,   47,  -43,       49,   30,  -33,
      58,   11,  -20,       66,   -7,   -7,       75,  -24,    7,       85,  -40,   20,
      37,   69,  -53,       39,   63,  -49,       44,   50,  -42,       50,   32,  -31,
      58,   13,  -19,       67,   -5,   -6,       76,  -22,    7,       85,  -37,   20,
      38,   70,  -50,       40,   64,  -47,       45,   52,  -40,       51,   35,  -30,
      59,   16,  -17,       68,   -2,   -5,       76,  -19,    8,       86,  -35,   21,
      40,   72,  -48,       42,   66,  -45,       46,   54,  -38,       52,   38,  -28,
      60,   19,  -16,       68,    1,   -4,       77,  -16,    9,       86,  -32,   22,
      41,   73,  -45,       43,   68,  -42,       47,   56,  -36,       53,   40,  -26,
      61,   22,  -15,       69,    4,   -3,       77,  -13,   10,       87,  -29,   22,
      43,   74,  -43,       44,   69,  -40,       48,   58,  -34,       54,   43,  -25,
      62,   24,  -14,       70,    7,   -2,       78,  -10,   11,       87,  -27,   23,
      44,   76,  -40,       46,   71,  -38,       50,   60,  -32,       55,   45,  -23,
      62,   27,  -12,       70,   10,   -1,       79,   -8,   11,       87,  -24,   24,
      46,   77,  -38,       47,   73,  -36,       51,   62,  -30,       56,   48,  -21,
      63,   30,  -11,       71,   12,    1,       79,   -5,   12,       88,  -21,   25,
      47,   79,  -35,       49,   74,  -33,       52,   64,  -27,       58,   50,  -19,
      64,   33,   -9,       72,   16,    2,       80,   -1,   14,       89,  -18,   26,
      49,   80,  -33,       50,   76,  -31,       54,   67,  -25,       59,   53,  -18,
      65,   36,   -8,       73,   19,    3,       81,    2,   15,       89,  -15,   26,
      50,   82,  -30,       52,   78,  -28,       55,   69,  -23,       60,   55,  -16,
      66,   39,   -6,       73,   22,    4,       81,    5,   16,       90,  -12,   27,
      52,   83,  -28,       53,   80,  -26,       56,   71,  -21,       61,   58,  -14,
      67,   42,   -5,       74,   25,    6,       82,    8,   17,       90,   -9,   28,
      53,   85,  -25,       55,   81,  -23,       58,   73,  -19,       62,   60,  -12,
      68,   45,   -3,       75,   28,    7,       83,   11,   18,       91,   -6,   29,
      55,   87,  -23,       56,   83,  -21,       59,   75,  -17,       63,   63,  -10,
      69,   47,   -1,       76,   31,    9,       84,   14,   19,       92,   -3,   30,
      56,   88,  -20,       58,   85,  -19,       60,   77,  -14,       65,   65,   -8,
      70,   50,    1,       77,   34,   10,       84,   17,   20,       92,    0,   31,
      22,   60,  -83,       26,   49,  -76,       33,   28,  -64,       42,    7,  -49,
      52,  -13,  -33,       62,  -30,  -18,       72,  -45,   -3,       82,  -58,   11,
      22,   60,  -83,       26,   49,  -76,       33,   28,  -64,       42,    7,  -49,
      52,  -13,  -33,       62,  -30,  -18,       72,  -44,   -3,       82,  -58,   11,
      22,   60,  -82,       26,   49,  -76,       33,   29,  -63,       42,    7,  -49,
      52,  -13,  -33,       62,  -29,  -18,       72,  -44,   -3,       82,  -58,   11,
      22,   61,  -82,       26,   49,  -75,       34,   29,  -63,       43,    8,  -49,
      53,  -12,  -33,       62,  -29,  -18,       72,  -44,   -3,       82,  -57,   12,
      23,   61,  -81,       27,   50,  -75,       34,   30,  -63,       43,    9,  -48,
      53,  -11,  -33,       62,  -28,  -17,       72,  -43,   -3,       82,  -57,   12,
      23,   61,  -80,       27,   50,  -74,       34,   30,  -62,       43,    9,  -48,
      53,  -11,  -32,       63,  -28,  -17,       72,  -43,   -3,       82,  -56,   12,
      24,   61,  -79,       27,   51,  -73,       34,   31,  -62,       43,   10,  -47,
      53,  -10,  -32,       63,  -27,  -17,       72,  -42,   -2,       82,  -55,   12,
      25,   62,  -78,       28,   51,  -72,       35,   33,  -61,       44,   12,  -47,
      53,   -8,  -32,       63,  -25,  -17,       73,  -41,   -2,       83,  -54,   12,
      26,   62,  -76,       29,   52,  -71,       35,   34,  -60,       44,   13,  -46,
      54,   -7,  -31,       63,  -24,  -16,       73,  -39,   -2,       83,  -53,   12,
      26,   62,  -75,       30,   53,  -70,       36,   35,  -59,       44,   15,  -46,
      54,   -5,  -31,       63,  -23,  -16,       73,  -38,   -2,       83,  -52,   13,
      27,   63,  -73,       30,   54,  -68,       37,   37,  -58,       45,   16,  -45,
      54,   -4,  -30,       64,  -21,  -16,       73,  -37,   -1,       83,  -51,   13,
      28,   64,  -72,       31,   55,  -67,       37,   38,  -57,       45,   18,  -44,
      55,   -2,  -29,       64,  -19,  -15,       73,  -35,   -1,       83,  -50,   13,
      30,   65,  -69,       32,   56,  -65,       38,   40,  -55,       46,   20,  -43,
      55,    1,  -29,       64,  -17,  -14,       74,  -33,    0,       84,  -48,   14,
      31,   65,  -67,       33,   57,  -63,       39,   42,  -54,       47,   23,  -42,
      56,    3,  -28,       65,  -15,  -14,       74,  -31,    0,       84,  -46,   14,
      32,   66,  -65,       34,   59,  -61,       40,   43,  -52,       47,   25,  -41,
      56,    5,  -27,       65,  -13,  -13,       74,  -29,    1,       84,  -44,   14,
      33,   67,  -63,       36,   60,  -59,       41,   45,  -51,       48,   27,  -39,
      57,    7,  -26,       66,  -11,  -12,       75,  -27,    1,       84,  -43,   15,
      35,   68,  -61,       37,   62,  -57,       42,   47,  -49,       49,   29,  -38,
      57,   10,  -25,       66,   -8,  -12,       75,  -25,    2,       85,  -40,   15,
      36,   69,  -59,       38,   63,  -55,       43,   49,  -47,       50,   32,  -37,
      58,   12,  -24,       67,   -6,  -11,       76,  -22,    3,       85,  -38,   16,
      37,   70,  -56,       39,   64,  -53,       44,   51,  -46,       51,   34,  -35,
      59,   15,  -23,       67,   -3,  -10,       76,  -20,    3,       85,  -36,   16,
      39,   72,  -54,       41,   66,  -51,       45,   53,  -44,       52,   36,  -34,
      59,   18,  -22,       68,    0,   -9,       77,  -17,    4,       86,  -33,   17,
      40,   73,  -52,       42,   68,  -49,       46,   55,  -42,       53,   39,  -32,
      60,   21,  -20,       68,    3,   -8,       77,  -14,    5,       86,  -31,   18,
      42,   74,  -49,       43,   69,  -46,       48,   57,  -40,       54,   42,  -31,
      61,   23,  -19,       69,    5,   -7,       78,  -12,    6,       87,  -28,   18,
      43,   76,  -47,       45,   71,  -44,       49,   59,  -38,       55,   44,  -29,
      62,   26,  -18,       70,    8,   -6,       78,   -9,    7,       87,  -26,   19,
      45,   77,  -44,       46,   72,  -42,       50,   61,  -36,       56,   46,  -27,
      63,   29,  -16,       70,   11,   -5,       79,   -6,    7,       88,  -23,   20,
      46,   78,  -42,       48,   74,  -40,       51,   63,  -34,       57,   49,  -25,
      64,   31,  -15,       71,   14,   -3,       79,   -3,    8,       88,  -20,   21,
      48,   80,  -39,       49,   76,  -37,       53,   66,  -32,       58,   52,  -24,
      65,   35,  -13,       72,   17,   -2,       80,    0,   10,       89,  -17,   22,
      49,   81,  -37,       51,   77,  -35,       54,   68,  -29,       59,   54,  -22,
      66,   37,  -12,       73,   20,   -1,       81,    3,   11,       89,  -14,   23,
      51,   83,  -34,       52,   79,  -32,       55,   70,  -27,       60,   56,  -20,
      66,   40,  -10,       74,   23,    0,       81,    6,   12,       90,  -11,   23,
      52,   84,  -32,       53,   80,  -30,       57,   72,  -25,       61,   59,  -18,
      67,   43,   -9,       74,   26,    2,       82,    9,   13,       90,   -8,   24,
      54,   86,  -29,       55,   82,  -27,       58,   74,  -23,       63,   61,  -16,
      69,   46,   -7,       75,   29,    3,       83,   12,   14,       91,   -5,   25,
      55,   87,  -27,       56,   84,  -25,       59,   76,  -21,       64,   64,  -14,
      70,   48,   -5,       76,   32,    5,       84,   15,   15,       92,   -2,   26,
      57,   89,  -24,       58,   86,  -23,       61,   78,  -19,       65,   66,  -12,
      71,   51,   -4,       77,   35,    6,       84,   18,   16,       92,    1,   27,
      23,   62,  -86,       27,   51,  -79,       34,   31,  -67,       43,   10,  -53,
      53,  -10,  -37,       62,  -27,  -22,       72,  -42,   -7,       82,  -56,    7,
      23,   62,  -85,       27,   51,  -79,       34,   31,  -67,       43,   10,  -53,
      53,  -10,  -37,       63,  -27,  -22,       72,  -42,   -7,       82,  -56,    7,
      23,   62,  -85,       27,   52,  -79,       34,   32,  -67,       43,   11,  -53,
      53,  -10,  -37,       63,  -27,  -22,       72,  -42,   -7,       82,  -56,    8,
      24,   63,  -84,       27,   52,  -78,       34,   32,  -67,       43,   11,  -52,
      53,   -9,  -37,       63,  -26,  -22,       72,  -41,   -7,       82,  -55,    8,
      24,   63,  -84,       27,   52,  -78,       35,   33,  -66,       43,   12,  -52,
      53,   -9,  -37,       63,  -26,  -22,       72,  -41,   -7,       82,  -55,    8,
      24,   63,  -83,       28,   53,  -77,       35,   33,  -66,       43,   13,  -52,
      53,   -8,  -36,       63,  -25,  -21,       73,  -40,   -7,       83,  -54,    8,
      25,   63,  -82,       28,   53,  -76,       35,   34,  -65,       44,   13,  -51,
      53,   -7,  -36,       63,  -24,  -21,       73,  -39,   -6,       83,  -54,    8,
      26,   64,  -81,       29,   54,  -75,       36,   35,  -64,       44,   15,  -51,
      54,   -5,  -36,       63,  -23,  -21,       73,  -38,   -6,       83,  -53,    8,
      27,   64,  -79,       30,   55,  -74,       36,   36,  -64,       44,   16,  -50,
      54,   -4,  -35,       63,  -22,  -20,       73,  -37,   -6,       83,  -52,    8,
      27,   64,  -78,       30,   55,  -73,       37,   38,  -63,       45,   18,  -49,
      54,   -3,  -35,       64,  -20,  -20,       73,  -36,   -6,       83,  -50,    9,
      28,   65,  -76,       31,   56,  -72,       37,   39,  -62,       45,   19,  -49,
      55,   -1,  -34,       64,  -19,  -20,       73,  -35,   -5,       83,  -49,    9,
      29,   65,  -75,       32,   57,  -70,       38,   40,  -60,       46,   21,  -48,
      55,    1,  -33,       64,  -17,  -19,       74,  -33,   -5,       83,  -48,    9,
      30,   66,  -73,       33,   58,  -68,       39,   42,  -59,       46,   23,  -47,
      55,    3,  -33,       65,  -15,  -18,       74,  -31,   -4,       84,  -46,   10,
      32,   67,  -71,       34,   59,  -67,       40,   44,  -58,       47,   25,  -46,
      56,    5,  -32,       65,  -13,  -18,       74,  -29,   -4,       84,  -45,   10,
      33,   68,  -69,       35,   61,  -65,       41,   45,  -56,       48,   27,  -45,
      56,    7,  -31,       65,  -11,  -17,       75,  -27,   -3,       84,  -43,   10,
      34,   69,  -67,       36,   62,  -63,       41,   47,  -55,       49,   29,  -43,
      57,    9,  -30,       66,   -9,  -16,       75,  -25,   -3,       85,  -41,   11,
      35,   70,  -65,       38,   63,  -61,       43,   49,  -53,       49,   31,  -42,
      58,   12,  -29,       66,   -6,  -16,       75,  -23,   -2,       85,  -39,   11,
      37,   71,  -62,       39,   65,  -59,       44,   51,  -51,       50,   34,  -41,
      58,   14,  -28,       67,   -4,  -15,       76,  -21,   -2,       85,  -36,   12,
      38,   72,  -60,       40,   66,  -57,       45,   53,  -50,       51,   36,  -39,
      59,   17,  -27,       67,   -1,  -14,       76,  -18,   -1,       86,  -34,   13,
      39,   73,  -58,       41,   67,  -55,       46,   55,  -48,       52,   38,  -38,
      60,   19,  -26,       68,    1,  -13,       77,  -16,    0,       86,  -32,   13,
      41,   74,  -55,       43,   69,  -52,       47,   57,  -46,       53,   41,  -36,
      61,   22,  -24,       69,    4,  -12,       77,  -13,    1,       86,  -29,   14,
      42,   76,  -53,       44,   70,  -50,       48,   59,  -44,       54,   43,  -35,
      61,   25,  -23,       69,    7,  -11,       78,  -10,    2,       87,  -27,   15,
      44,   77,  -51,       45,   72,  -48,       49,   61,  -42,       55,   46,  -33,
      62,   28,  -22,       70,   10,  -10,       78,   -8,    3,       87,  -24,   15,
      45,   78,  -48,       47,   73,  -46,       50,   63,  -40,       56,   48,  -31,
      63,   30,  -20,       71,   12,   -9,       79,   -5,    3,       88,  -21,   16,
      46,   79,  -46,       48,   75,  -44,       52,   65,  -38,       57,   50,  -30,
      64,   33,  -19,       71,   15,   -8,       80,   -2,    4,       88,  -19,   17,
      48,   81,  -43,       50,   77,  -41,       53,   67,  -36,       58,   53,  -28,
      65,   36,  -17,       72,   18,   -6,       80,    1,    5,       89,  -16,   18,
      50,   82,  -41,       51,   78,  -39,       54,   69,  -34,       59,   55,  -26,
      66,   39,  -16,       73,   21,   -5,       81,    4,    7,       89,  -13,   19,
      51,   84,  -39,       52,   80,  -36,       56,   71,  -31,       60,   58,  -24,
      67,   41,  -14,       74,   24,   -4,       82,    7,    8,       90,  -10,   19,
      52,   85,  -36,       54,   81,  -34,       57,   73,  -29,       61,   60,  -22,
      68,   44,  -13,       75,   27,   -2,       82,   10,    9,       91,   -7,   20,
      54,   87,  -33,       55,   83,  -32,       58,   75,  -27,       63,   63,  -20,
      69,   47,  -11,       76,   30,   -1,       83,   13,   10,       91,   -4,   21,
      56,   88,  -31,       57,   85,  -29,       60,   77,  -25,       64,   65,  -18,
      70,   49,   -9,       77,   33,    0,       84,   16,   11,       92,   -1,   22,
      57,   90,  -29,       58,   87,  -27,       61,   79,  -23,       65,   67,  -16,
      71,   52,   -8,       77,   36,    2,       85,   19,   12,       93,    2,   23,
      24,   64,  -88,       28,   54,  -83,       35,   34,  -71,       43,   13,  -57,
      53,   -7,  -41,       63,  -25,  -26,       73,  -40,  -11,       82,  -54,    3,
      24,   64,  -88,       28,   54,  -82,       35,   35,  -71,       43,   13,  -57,
      53,   -7,  -41,       63,  -24,  -26,       73,  -40,  -11,       83,  -54,    4,
      24,   64,  -88,       28,   54,  -82,       35,   35,  -71,       43,   14,  -56,
      53,   -7,  -41,       63,  -24,  -26,       73,  -40,  -11,       83,  -54,    4,
      25,   65,  -87,       28,   54,  -82,       35,   35,  -70,       44,   14,  -56,
      53,   -6,  -41,       63,  -24,  -26,       73,  -39,  -11,       83,  -53,    4,
      25,   65,  -87,       28,   55,  -81,       35,   36,  -70,       44,   15,  -56,
      53,   -6,  -41,       63,  -23,  -26,       73,  -39,  -11,       83,  -53,    4,
      26,   65,  -86,       29,   55,  -80,       36,   36,  -69,       44,   16,  -56,
      54,   -5,  -40,       63,  -22,  -25,       73,  -38,  -11,       83,  -52,    4,
      26,   65,  -85,       29,   56,  -80,       36,   37,  -69,       44,   16,  -55,
      54,   -4,  -40,       63,  -22,  -25,       73,  -37,  -10,       83,  -52,    4,
      27,   65,  -84,       30,   56,  -79,       36,   38,  -68,       45,   18,  -55,
      54,   -3,  -40,       64,  -20,  -25,       73,  -36,  -10,       83,  -51,    4,
      28,   66,  -83,       31,   57,  -77,       37,   39,  -67,       45,   19,  -54,
      54,   -1,  -39,       64,  -19,  -24,       73,  -35,  -10,       83,  -50,    4,
      28,   66,  -81,       31,   58,  -76,       37,   40,  -66,       45,   20,  -53,
      55,    0,  -39,       64,  -18,  -24,       73,  -34,  -10,       83,  -49,    5,
      29,   67,  -80,       32,   58,  -75,       38,   42,  -65,       46,   22,  -52,
      55,    2,  -38,       64,  -16,  -24,       74,  -32,   -9,       83,  -47,    5,
      30,   67,  -78,       33,   59,  -74,       39,   43,  -64,       46,   23,  -52,
      55,    3,  -37,       65,  -15,  -23,       74,  -31,   -9,       84,  -46,    5,
      31,   68,  -76,       34,   60,  -72,       39,   45,  -63,       47,   25,  -51,
      56,    5,  -37,       65,  -13,  -22,       74,  -29,   -8,       84,  -44,    6,
      32,   69,  -74,       35,   61,  -70,       40,   46,  -61,       48,   27,  -50,
      56,    7,  -36,       65,  -11,  -22,       75,  -27,   -8,       84,  -43,    6,
      33,   69,  -72,       36,   62,  -69,       41,   48,  -60,       48,   29,  -48,
      57,    9,  -35,       66,   -9,  -21,       75,  -25,   -7,       84,  -41,    7,
      35,   70,  -70,       37,   64,  -67,       42,   49,  -58,       49,   31,  -47,
      57,   12,  -34,       66,   -7,  -20,       75,  -23,   -7,       85,  -39,    7,
      36,   71,  -68,       38,   65,  -65,       43,   51,  -57,       50,   34,  -46,
      58,   14,  -33,       67,   -4,  -20,       76,  -21,   -6,       85,  -37,    8,
      37,   72,  -66,       39,   66,  -63,       44,   53,  -55,       51,   36,  -45,
      59,   16,  -32,       67,   -2,  -19,       76,  -19,   -6,       85,  -35,    8,
      39,   73,  -64,       41,   67,  -61,       45,   55,  -53,       51,   38,  -43,
      59,   19,  -31,       68,    1,  -18,       77,  -16,   -5,       86,  -33,    9,
      40,   74,  -62,       42,   69,  -59,       46,   56,  -52,       52,   40,  -42,
      60,   21,  -30,       68,    3,  -17,       77,  -14,   -4,       86,  -30,    9,
      41,   76,  -59,       43,   70,  -56,       47,   59,  -50,       53,   43,  -40,
      61,   24,  -28,       69,    6,  -16,       78,  -11,   -3,       87,  -28,   10,
      43,   77,  -57,       44,   72,  -54,       48,   60,  -48,       54,   45,  -39,
      62,   27,  -27,       70,    9,  -15,       78,   -9,   -2,       87,  -25,   11,
      44,   78,  -55,       46,   73,  -52,       50,   62,  -46,       55,   47,  -37,
      62,   29,  -26,       70,   11,  -14,       79,   -6,   -1,       87,  -23,   11,
      46,   79,  -52,       47,   75,  -50,       51,   64,  -44,       56,   49,  -35,
      63,   32,  -24,       71,   14,  -13,       79,   -3,   -1,       88,  -20,   12,
      47,   81,  -50,       48,   76,  -48,       52,   66,  -42,       57,   52,  -34,
      64,   34,  -23,       72,   17,  -12,       80,   -1,    0,       88,  -17,   13,
      49,   82,  -47,       50,   78,  -45,       53,   68,  -40,       58,   54,  -32,
      65,   37,  -21,       73,   20,  -10,       80,    3,    1,       89,  -14,   14,
      50,   83,  -45,       51,   79,  -43,       55,   70,  -38,       60,   57,  -30,
      66,   40,  -20,       73,   23,   -9,       81,    5,    3,       90,  -12,   15,
      51,   85,  -43,       53,   81,  -40,       56,   72,  -35,       61,   59,  -28,
      67,   42,  -18,       74,   25,   -8,       82,    8,    4,       90,   -9,   16,
      53,   86,  -40,       54,   82,  -38,       57,   74,  -33,       62,   61,  -26,
      68,   45,  -17,       75,   28,   -6,       83,   11,    5,       91,   -6,   16,
      55,   88,  -37,       56,   84,  -36,       59,   76,  -31,       63,   64,  -24,
      69,   48,  -15,       76,   31,   -5,       83,   14,    6,       91,   -3,   18,
      56,   89,  -35,       57,   86,  -33,       60,   78,  -29,       64,   66,  -22,
      70,   51,  -13,       77,   34,   -4,       84,   17,    7,       92,    0,   19,
      57,   91,  -33,       59,   87,  -31,       61,   80,  -27,       65,   68,  -20,
      71,   53,  -12,       78,   37,   -2,       85,   20,    8,       93,    3,   20,
      25,   67,  -91,       29,   57,  -86,       35,   38,  -75,       44,   17,  -61,
      53,   -4,  -46,       63,  -22,  -30,       73,  -37,  -16,       83,  -52,   -1,
      26,   67,  -91,       29,   57,  -86,       36,   38,  -75,       44,   17,  -61,
      54,   -4,  -45,       63,  -21,  -30,       73,  -37,  -16,       83,  -51,   -1,
      26,   67,  -91,       29,   57,  -85,       36,   38,  -74,       44,   17,  -61,
      54,   -3,  -45,       63,  -21,  -30,       73,  -37,  -16,       83,  -51,   -1,
      26,   67,  -90,       29,   57,  -85,       36,   39,  -74,       44,   18,  -60,
      54,   -3,  -45,       63,  -21,  -30,       73,  -36,  -15,       83,  -51,   -1,
      26,   67,  -90,       30,   57,  -84,       36,   39,  -74,       44,   18,  -60,
      54,   -2,  -45,       63,  -20,  -30,       73,  -36,  -15,       83,  -50,   -1,
      27,   67,  -89,       30,   58,  -84,       36,   40,  -73,       45,   19,  -60,
      54,   -1,  -45,       64,  -19,  -30,       73,  -35,  -15,       83,  -50,   -1,
      27,   67,  -88,       30,   58,  -83,       37,   40,  -73,       45,   20,  -59,
      54,   -1,  -44,       64,  -19,  -30,       73,  -35,  -15,       83,  -49,    0,
      28,   68,  -87,       31,   59,  -82,       37,   41,  -72,       45,   21,  -59,
      54,    1,  -44,       64,  -17,  -29,       73,  -34,  -15,       83,  -48,    0,
      29,   68,  -86,       32,   59,  -81,       38,   42,  -71,       46,   22,  -58,
      55,    2,  -43,       64,  -16,  -29,       74,  -33,  -14,       83,  -47,    0,
      29,   68,  -85,       32,   60,  -80,       38,   43,  -70,       46,   23,  -58,
      55,    3,  -43,       64,  -15,  -28,       74,  -31,  -14,       83,  -46,    0,
      30,   69,  -83,       33,   61,  -79,       39,   44,  -69,       46,   25,  -57,
      55,    5,  -42,       65,  -14,  -28,       74,  -30,  -14,       84,  -45,    1,
      31,   69,  -82,       34,   62,  -77,       39,   46,  -68,       47,   26,  -56,
      56,    6,  -42,       65,  -12,  -28,       74,  -29,  -13,       84,  -44,    1,
      32,   70,  -80,       35,   63,  -76,       40,   47,  -67,       48,   28,  -55,
      56,    8,  -41,       65,  -10,  -27,       75,  -27,  -13,       84,  -42,    1,
      33,   71,  -78,       36,   63,  -74,       41,   49,  -65,       48,   30,  -54,
      57,   10,  -40,       66,   -8,  -26,       75,  -25,  -12,       84,  -41,    2,
      34,   71,  -76,       37,   64,  -72,       42,   50,  -64,       49,   32,  -53,
      57,   12,  -39,       66,   -6,  -26,       75,  -23,  -12,       85,  -39,    2,
      36,   72,  -74,       38,   66,  -71,       43,   52,  -63,       49,   34,  -52,
      58,   14,  -38,       66,   -4,  -25,       75,  -21,  -11,       85,  -37,    3,
      37,   73,  -72,       39,   67,  -69,       44,   53,  -61,       50,   36,  -50,
      58,   17,  -37,       67,   -2,  -24,       76,  -19,  -11,       85,  -35,    3,
      38,   74,  -70,       40,   68,  -67,       45,   55,  -59,       51,   38,  -49,
      59,   19,  -36,       68,    0,  -23,       76,  -17,  -10,       86,  -33,    4,
      39,   75,  -68,       41,   69,  -65,       46,   57,  -58,       52,   40,  -48,
      60,   21,  -35,       68,    3,  -22,       77,  -14,   -9,       86,  -31,    4,
      41,   76,  -66,       42,   71,  -63,       47,   58,  -56,       53,   42,  -46,
      60,   23,  -34,       69,    5,  -22,       77,  -12,   -9,       86,  -28,    5,
      42,   77,  -63,       44,   72,  -60,       48,   60,  -54,       54,   45,  -45,
      61,   26,  -33,       69,    8,  -20,       78,   -9,   -8,       87,  -26,    6,
      43,   78,  -61,       45,   73,  -58,       49,   62,  -52,       55,   47,  -43,
      62,   29,  -32,       70,   11,  -19,       78,   -7,   -7,       87,  -23,    6,
      45,   79,  -59,       46,   75,  -56,       50,   64,  -50,       56,   49,  -41,
      63,   31,  -30,       71,   13,  -18,       79,   -4,   -6,       88,  -21,    7,
      46,   81,  -57,       48,   76,  -54,       51,   66,  -48,       57,   51,  -40,
      64,   34,  -29,       71,   16,  -17,       79,   -2,   -5,       88,  -18,    8,
      48,   82,  -54,       49,   78,  -52,       52,   68,  -46,       58,   53,  -38,
      64,   36,  -28,       72,   18,  -16,       80,    1,   -4,       89,  -16,    8,
      49,   83,  -52,       50,   79,  -49,       54,   70,  -44,       59,   56,  -36,
      65,   39,  -26,       73,   22,  -15,       81,    4,   -3,       89,  -13,    9,
      50,   85,  -49,       52,   81,  -47,       55,   71,  -42,       60,   58,  -34,
      66,   41,  -24,       74,   24,  -14,       81,    7,   -2,       90,  -10,   10,
      52,   86,  -47,       53,   82,  -45,       56,   73,  -40,       61,   60,  -33,
      67,   44,  -23,       74,   27,  -12,       82,   10,   -1,       90,   -7,   11,
      53,   87,  -45,       55,   84,  -43,       58,   75,  -38,       62,   62,  -31,
      68,   47,  -21,       75,   30,  -11,       83,   13,    0,       91,   -5,   12,
      55,   89,  -42,       56,   85,  -40,       59,   77,  -36,       63,   65,  -29,
      69,   49,  -20,       76,   33,   -9,       84,   16,    1,       92,   -1,   13,
      56,   90,  -40,       58,   87,  -38,       60,   79,  -33,       65,   67,  -27,
      70,   52,  -18,       77,   35,   -8,       84,   19,    3,       92,    1,   14,
      58,   92,  -37,       59,   88,  -35,       62,   81,  -31,       66,   69,  -25,
      71,   54,  -16,       78,   38,   -7,       85,   21,    4,       93,    4,   15,
      27,   69,  -94,       30,   59,  -89,       36,   41,  -78,       44,   20,  -65,
      54,   -1,  -49,       63,  -19,  -34,       73,  -35,  -20,       83,  -49,   -5,
      27,   69,  -94,       30,   59,  -89,       36,   41,  -78,       45,   20,  -64,
      54,   -1,  -49,       63,  -19,  -34,       73,  -35,  -20,       83,  -49,   -5,
      27,   69,  -94,       30,   59,  -88,       36,   41,  -78,       45,   20,  -64,
      54,    0,  -49,       64,  -18,  -34,       73,  -34,  -19,       83,  -49,   -5,
      27,   69,  -93,       30,   60,  -88,       37,   42,  -77,       45,   21,  -64,
      54,    0,  -49,       64,  -18,  -34,       73,  -34,  -19,       83,  -49,   -5,
      27,   69,  -93,       30,   60,  -88,       37,   42,  -77,       45,   21,  -64,
      54,    1,  -49,       64,  -17,  -34,       73,  -33,  -19,       83,  -48,   -5,
      28,   69,  -92,       31,   60,  -87,       37,   42,  -77,       45,   22,  -63,
      54,    1,  -49,       64,  -17,  -34,       73,  -33,  -19,       83,  -48,   -4,
      28,   69,  -91,       31,   60,  -86,       37,   43,  -76,       45,   23,  -63,
      55,    2,  -48,       64,  -16,  -33,       73,  -32,  -19,       83,  -47,   -4,
      29,   70,  -90,       32,   61,  -85,       38,   44,  -75,       46,   24,  -62,
      55,    3,  -48,       64,  -15,  -33,       74,  -31,  -19,       83,  -46,   -4,
      30,   70,  -89,       32,   62,  -84,       38,   45,  -75,       46,   25,  -62,
      55,    5,  -47,       64,  -14,  -33,       74,  -30,  -18,       84,  -45,   -4,
      30,   70,  -88,       33,   62,  -83,       39,   46,  -74,       46,   26,  -61,
      55,    6,  -47,       65,  -13,  -32,       74,  -29,  -18,       84,  -44,   -4,
      31,   71,  -86,       34,   63,  -82,       39,   47,  -73,       47,   28,  -60,
      56,    7,  -46,       65,  -11,  -32,       74,  -28,  -18,       84,  -43,   -3,
      32,   71,  -85,       35,   64,  -81,       40,   48,  -72,       47,   29,  -60,
      56,    9,  -46,       65,  -10,  -32,       74,  -26,  -17,       84,  -42,   -3,
      33,   72,  -83,       36,   65,  -79,       41,   49,  -70,       48,   31,  -59,
      57,   11,  -45,       66,   -8,  -31,       75,  -25,  -17,       84,  -40,   -3,
      34,   72,  -81,       36,   65,  -77,       42,   51,  -69,       49,   32,  -58,
      57,   12,  -44,       66,   -6,  -30,       75,  -23,  -16,       85,  -39,   -2,
      35,   73,  -80,       37,   66,  -76,       42,   52,  -68,       49,   34,  -57,
      58,   14,  -43,       66,   -4,  -30,       75,  -21,  -16,       85,  -37,   -2,
      36,   74,  -78,       38,   67,  -74,       43,   54,  -66,       50,   36,  -55,
      58,   16,  -42,       67,   -2,  -29,       76,  -19,  -15,       85,  -35,   -1,
      38,   75,  -76,       40,   69,  -72,       44,   55,  -65,       51,   38,  -54,
      59,   19,  -41,       67,    0,  -28,       76,  -17,  -15,       85,  -33,   -1,
      39,   76,  -74,       41,   70,  -70,       45,   57,  -63,       52,   40,  -53,
      59,   21,  -40,       68,    3,  -27,       77,  -15,  -14,       86,  -31,    0,
      40,   76,  -71,       42,   71,  -68,       46,   59,  -61,       52,   42,  -51,
      60,   23,  -39,       68,    5,  -26,       77,  -13,  -13,       86,  -29,    0,
      41,   77,  -69,       43,   72,  -66,       47,   60,  -60,       53,   44,  -50,
      61,   25,  -38,       69,    7,  -26,       77,  -10,  -13,       87,  -27,    1,
      43,   79,  -67,       44,   73,  -64,       48,   62,  -58,       54,   46,  -48,
      62,   28,  -37,       70,   10,  -24,       78,   -7,  -12,       87,  -24,    2,
      44,   80,  -65,       46,   75,  -62,       49,   64,  -56,       55,   48,  -47,
      62,   30,  -36,       70,   12,  -23,       79,   -5,  -11,       87,  -22,    2,
      45,   81,  -63,       47,   76,  -60,       51,   65,  -54,       56,   51,  -45,
      63,   33,  -34,       71,   15,  -22,       79,   -2,  -10,       88,  -19,    3,
      47,   82,  -60,       48,   77,  -58,       52,   67,  -52,       57,   53,  -44,
      64,   35,  -33,       72,   17,  -21,       80,    0,   -9,       88,  -17,    4,
      48,   83,  -58,       49,   79,  -56,       53,   69,  -50,       58,   55,  -42,
      65,   38,  -32,       72,   20,  -20,       80,    3,   -8,       89,  -14,    5,
      50,   85,  -55,       51,   80,  -53,       54,   71,  -48,       59,   57,  -40,
      66,   40,  -30,       73,   23,  -19,       81,    6,   -7,       89,  -11,    5,
      51,   86,  -53,       52,   82,  -51,       55,   73,  -46,       60,   59,  -38,
      67,   43,  -28,       74,   26,  -18,       82,    8,   -6,       90,   -9,    6,
      52,   87,  -51,       54,   83,  -49,       57,   74,  -44,       61,   62,  -37,
      68,   45,  -27,       75,   28,  -16,       82,   11,   -5,       91,   -6,    7,
      54,   88,  -48,       55,   85,  -47,       58,   76,  -42,       62,   64,  -35,
      69,   48,  -25,       75,   31,  -15,       83,   14,   -4,       91,   -3,    8,
      55,   90,  -46,       57,   86,  -44,       59,   78,  -40,       64,   66,  -33,
      70,   51,  -24,       76,   34,  -13,       84,   17,   -3,       92,    0,    9,
      57,   91,  -44,       58,   88,  -42,       61,   80,  -37,       65,   68,  -31,
      71,   53,  -22,       77,   37,  -12,       84,   20,   -1,       92,    3,   10,
      58,   93,  -41,       59,   89,  -39,       62,   82,  -35,       66,   70,  -29,
      72,   56,  -20,       78,   39,  -11,       85,   23,    0,       93,    6,   11,
      28,   71,  -97,       31,   61,  -92,       37,   44,  -81,       45,   23,  -68,
      54,    2,  -53,       64,  -16,  -38,       73,  -32,  -24,       83,  -47,   -9,
      28,   71,  -97,       31,   62,  -92,       37,   44,  -81,       45,   23,  -68,
      54,    3,  -53,       64,  -16,  -38,       73,  -32,  -23,       83,  -47,   -9,
      28,   71,  -96,       31,   62,  -91,       37,   44,  -81,       45,   24,  -68,
      54,    3,  -53,       64,  -15,  -38,       73,  -32,  -23,       83,  -47,   -9,
      28,   71,  -96,       31,   62,  -91,       37,   44,  -81,       45,   24,  -68,
      55,    3,  -53,       64,  -15,  -38,       73,  -31,  -23,       83,  -46,   -9,
      29,   71,  -95,       31,   62,  -90,       38,   45,  -80,       46,   24,  -67,
      55,    4,  -53,       64,  -15,  -38,       74,  -31,  -23,       83,  -46,   -8,
      29,   71,  -95,       32,   62,  -90,       38,   45,  -80,       46,   25,  -67,
      55,    4,  -52,       64,  -14,  -38,       74,  -30,  -23,       83,  -46,   -8,
      29,   71,  -94,       32,   63,  -89,       38,   46,  -79,       46,   26,  -67,
      55,    5,  -52,       64,  -13,  -37,       74,  -30,  -23,       83,  -45,   -8,
      30,   72,  -93,       33,   63,  -88,       39,   47,  -79,       46,   27,  -66,
      55,    6,  -52,       65,  -12,  -37,       74,  -29,  -23,       84,  -44,   -8,
      31,   72,  -92,       33,   64,  -87,       39,   47,  -78,       47,   28,  -66,
      56,    7,  -51,       65,  -11,  -37,       74,  -28,  -22,       84,  -43,   -8,
      31,   72,  -91,       34,   64,  -86,       40,   48,  -77,       47,   29,  -65,
      56,    9,  -51,       65,  -10,  -36,       74,  -27,  -22,       84,  -42,   -8,
      32,   73,  -89,       35,   65,  -85,       40,   49,  -76,       47,   30,  -64,
      56,   10,  -50,       65,   -9,  -36,       74,  -25,  -22,       84,  -41,   -7,
      33,   73,  -88,       35,   66,  -84,       41,   50,  -75,       48,   32,  -63,
      57,   11,  -49,       66,   -7,  -35,       75,  -24,  -21,       84,  -40,   -7,
      34,   74,  -86,       36,   67,  -82,       42,   52,  -74,       49,   33,  -62,
      57,   13,  -49,       66,   -5,  -35,       75,  -22,  -21,       85,  -38,   -7,
      35,   74,  -85,       37,   67,  -81,       42,   53,  -73,       49,   35,  -61,
      58,   15,  -48,       66,   -4,  -34,       75,  -21,  -20,       85,  -37,   -6,
      36,   75,  -83,       38,   68,  -79,       43,   54,  -71,       50,   36,  -60,
      58,   17,  -47,       67,   -2,  -34,       76,  -19,  -20,       85,  -35,   -6,
      37,   75,  -81,       39,   69,  -78,       44,   56,  -70,       50,   38,  -59,
      59,   19,  -46,       67,    0,  -33,       76,  -17,  -19,       85,  -33,   -5,
      38,   76,  -79,       40,   70,  -76,       45,   57,  -68,       51,   40,  -58,
      59,   21,  -45,       68,    2,  -32,       76,  -15,  -19,       86,  -31,   -5,
      39,   77,  -77,       41,   71,  -74,       46,   59,  -67,       52,   42,  -57,
      60,   23,  -44,       68,    5,  -31,       77,  -13,  -18,       86,  -29,   -4,
      41,   78,  -75,       43,   73,  -72,       47,   60,  -65,       53,   44,  -55,
      60,   25,  -43,       69,    7,  -30,       77,  -11,  -17,       86,  -27,   -4,
      42,   79,  -73,       44,   74,  -70,       48,   62,  -63,       54,   46,  -54,
      61,   27,  -42,       69,    9,  -29,       78,   -8,  -16,       87,  -25,   -3,
      43,   80,  -71,       45,   75,  -68,       49,   64,  -61,       55,   48,  -52,
      62,   30,  -41,       70,   12,  -28,       78,   -6,  -16,       87,  -23,   -2,
      45,   81,  -68,       46,   76,  -66,       50,   65,  -60,       56,   50,  -51,
      63,   32,  -39,       70,   14,  -27,       79,   -3,  -15,       88,  -20,   -2,
      46,   82,  -66,       47,   78,  -64,       51,   67,  -58,       56,   52,  -49,
      63,   35,  -38,       71,   17,  -26,       79,   -1,  -14,       88,  -18,   -1,
      47,   83,  -64,       49,   79,  -62,       52,   69,  -56,       57,   54,  -48,
      64,   37,  -37,       72,   19,  -25,       80,    2,  -13,       89,  -15,    0,
      49,   84,  -62,       50,   80,  -59,       53,   70,  -54,       58,   56,  -46,
      65,   39,  -35,       73,   22,  -24,       80,    4,  -12,       89,  -13,    1,
      50,   86,  -59,       51,   82,  -57,       55,   72,  -52,       60,   59,  -44,
      66,   42,  -34,       73,   25,  -23,       81,    7,  -11,       90,  -10,    2,
      51,   87,  -57,       53,   83,  -55,       56,   74,  -50,       61,   61,  -42,
      67,   44,  -32,       74,   27,  -22,       82,   10,  -10,       90,   -7,    2,
      53,   88,  -55,       54,   84,  -53,       57,   76,  -48,       62,   63,  -41,
      68,   47,  -31,       75,   30,  -20,       82,   13,   -9,       91,   -5,    3,
      54,   89,  -52,       55,   86,  -50,       58,   77,  -46,       63,   65,  -39,
      69,   49,  -29,       76,   32,  -19,       83,   15,   -8,       91,   -2,    4,
      56,   91,  -50,       57,   88,  -48,       60,   79,  -43,       64,   67,  -37,
      70,   52,  -28,       77,   35,  -17,       84,   18,   -6,       92,    1,    5,
      57,   92,  -47,       58,   89,  -46,       61,   81,  -41,       65,   69,  -35,
      71,   54,  -26,       77,   38,  -16,       85,   21,   -5,       93,    4,    6,
      59,   94,  -45,       60,   90,  -43,       62,   83,  -39,       66,   72,  -33,
      72,   57,  -24,       78,   41,  -15,       85,   24,   -4,       93,    7,    7,
      29,   73,  -99,       32,   64,  -95,       38,   47,  -85,       46,   26,  -72,
      55,    5,  -57,       64,  -13,  -42,       74,  -30,  -27,       83,  -45,  -13,
      29,   73,  -99,       32,   64,  -94,       38,   47,  -84,       46,   26,  -72,
      55,    6,  -57,       64,  -13,  -42,       74,  -29,  -27,       83,  -45,  -13,
      29,   73,  -99,       32,   64,  -94,       38,   47,  -84,       46,   27,  -71,
      55,    6,  -57,       64,  -13,  -42,       74,  -29,  -27,       83,  -45,  -13,
      29,   73,  -98,       32,   64,  -94,       38,   47,  -84,       46,   27,  -71,
      55,    6,  -57,       64,  -12,  -42,       74,  -29,  -27,       83,  -44,  -12,
      30,   73,  -98,       32,   64,  -93,       38,   48,  -84,       46,   28,  -71,
      55,    7,  -56,       64,  -12,  -42,       74,  -28,  -27,       84,  -44,  -12,
      30,   73,  -97,       33,   65,  -93,       39,   48,  -83,       46,   28,  -71,
      55,    7,  -56,       65,  -11,  -41,       74,  -28,  -27,       84,  -43,  -12,
      31,   73,  -97,       33,   65,  -92,       39,   49,  -83,       47,   29,  -70,
      55,    8,  -56,       65,  -10,  -41,       74,  -27,  -27,       84,  -43,  -12,
      31,   73,  -96,       34,   66,  -91,       39,   49,  -82,       47,   30,  -70,
      56,    9,  -55,       65,   -9,  -41,       74,  -26,  -26,       84,  -42,  -12,
      32,   74,  -95,       34,   66,  -90,       40,   50,  -81,       47,   31,  -69,
      56,   10,  -55,       65,   -8,  -41,       74,  -25,  -26,       84,  -41,  -12,
      32,   74,  -93,       35,   66,  -89,       40,   51,  -80,       48,   32,  -68,
      56,   11,  -54,       65,   -7,  -40,       75,  -24,  -26,       84,  -40,  -11,
      33,   74,  -92,       36,   67,  -88,       41,   52,  -79,       48,   33,  -68,
      57,   13,  -54,       66,   -6,  -40,       75,  -23,  -26,       84,  -39,  -11,
      34,   75,  -91,       36,   68,  -87,       41,   53,  -78,       49,   34,  -67,
      57,   14,  -53,       66,   -5,  -39,       75,  -22,  -25,       85,  -38,  -11,
      35,   75,  -89,       37,   69,  -85,       42,   54,  -77,       49,   36,  -66,
      57,   16,  -52,       66,   -3,  -39,       75,  -20,  -25,       85,  -36,  -10,
      36,   76,  -88,       38,   69,  -84,       43,   55,  -76,       50,   37,  -65,
      58,   17,  -52,       67,   -1,  -38,       76,  -18,  -24,       85,  -35,  -10,
      37,   76,  -86,       39,   70,  -83,       44,   57,  -75,       50,   39,  -64,
      58,   19,  -51,       67,    1,  -37,       76,  -17,  -24,       85,  -33,  -10,
      38,   77,  -84,       40,   71,  -81,       44,   58,  -73,       51,   41,  -63,
      59,   21,  -50,       67,    2,  -37,       76,  -15,  -23,       86,  -31,   -9,
      39,   78,  -82,       41,   72,  -79,       45,   59,  -72,       52,   42,  -62,
      60,   23,  -49,       68,    5,  -36,       77,  -13,  -22,       86,  -29,   -9,
      40,   79,  -80,       42,   73,  -77,       46,   61,  -70,       53,   44,  -60,
      60,   25,  -48,       68,    7,  -35,       77,  -11,  -22,       86,  -27,   -8,
      41,   80,  -78,       43,   74,  -75,       47,   62,  -69,       53,   46,  -59,
      61,   27,  -47,       69,    9,  -34,       78,   -9,  -21,       87,  -25,   -8,
      43,   80,  -76,       44,   75,  -74,       48,   64,  -67,       54,   48,  -58,
      62,   29,  -46,       70,   11,  -33,       78,   -6,  -20,       87,  -23,   -7,
      44,   81,  -74,       46,   77,  -71,       49,   65,  -65,       55,   50,  -56,
      62,   32,  -45,       70,   14,  -32,       79,   -4,  -19,       87,  -21,   -6,
      45,   82,  -72,       47,   78,  -69,       51,   67,  -63,       56,   52,  -55,
      63,   34,  -43,       71,   16,  -31,       79,   -1,  -19,       88,  -18,   -5,
      46,   83,  -70,       48,   79,  -67,       52,   69,  -61,       57,   54,  -53,
      64,   36,  -42,       71,   18,  -30,       80,    1,  -18,       88,  -16,   -5,
      48,   85,  -68,       49,   80,  -65,       53,   70,  -60,       58,   56,  -51,
      65,   39,  -41,       72,   21,  -29,       80,    3,  -17,       89,  -14,   -4,
      49,   86,  -65,       51,   81,  -63,       54,   72,  -58,       59,   58,  -50,
      65,   41,  -39,       73,   23,  -28,       81,    6,  -16,       89,  -11,   -3,
      51,   87,  -63,       52,   83,  -61,       55,   74,  -56,       60,   60,  -48,
      66,   44,  -38,       74,   26,  -27,       81,    9,  -15,       90,   -8,   -2,
      52,   88,  -61,       53,   84,  -59,       56,   75,  -54,       61,   62,  -46,
      67,   46,  -36,       74,   29,  -25,       82,   11,  -14,       90,   -6,   -1,
      53,   89,  -58,       55,   86,  -56,       58,   77,  -52,       62,   64,  -44,
      68,   48,  -35,       75,   31,  -24,       83,   14,  -13,       91,   -3,   -1,
      55,   91,  -56,       56,   87,  -54,       59,   79,  -50,       63,   66,  -43,
      69,   51,  -33,       76,   34,  -23,       83,   17,  -12,       92,   -1,    0,
      56,   92,  -54,       57,   89,  -52,       60,   81,  -47,       64,   69,  -41,
      70,   53,  -32,       77,   37,  -21,       84,   20,  -10,       92,    3,    1,
      58,   93,  -51,       59,   90,  -49,       61,   82,  -45,       66,   71,  -39,
      71,   56,  -30,       78,   39,  -20,       85,   22,   -9,       93,    5,    2,
      59,   95,  -49,       60,   92,  -47,       63,   84,  -43,       67,   73,  -37,
      72,   58,  -28,       79,   42,  -19,       86,   25,   -8,       94,    8,    3,
      30,   75, -102,       33,   66,  -98,       39,   50,  -88,       46,   30,  -76,
      55,    9,  -61,       65,  -10,  -46,       74,  -27,  -32,       84,  -42,  -17,
      30,   75, -102,       33,   67,  -98,       39,   50,  -88,       46,   30,  -75,
      55,    9,  -61,       65,  -10,  -46,       74,  -27,  -32,       84,  -42,  -17,
      30,   75, -102,       33,   67,  -97,       39,   50,  -88,       47,   30,  -75,
      55,    9,  -61,       65,   -9,  -46,       74,  -26,  -32,       84,  -42,  -17,
      31,   75, -101,       33,   67,  -97,       39,   50,  -88,       47,   31,  -75,
      56,   10,  -61,       65,   -9,  -46,       74,  -26,  -32,       84,  -42,  -17,
      31,   75, -101,       34,   67,  -97,       39,   51,  -87,       47,   31,  -75,
      56,   10,  -60,       65,   -9,  -46,       74,  -25,  -31,       84,  -41,  -17,
      31,   75, -100,       34,   67,  -96,       40,   51,  -87,       47,   31,  -75,
      56,   11,  -60,       65,   -8,  -46,       74,  -25,  -31,       84,  -41,  -17,
      32,   75, -100,       34,   68,  -95,       40,   52,  -86,       47,   32,  -74,
      56,   11,  -60,       65,   -7,  -46,       74,  -24,  -31,       84,  -40,  -16,
      32,   76,  -99,       35,   68,  -95,       40,   52,  -86,       48,   33,  -74,
      56,   12,  -60,       65,   -6,  -45,       75,  -23,  -31,       84,  -39,  -16,
      33,   76,  -98,       35,   68,  -94,       41,   53,  -85,       48,   34,  -73,
      57,   13,  -59,       65,   -5,  -45,       75,  -22,  -31,       84,  -38,  -16,
      34,   76,  -97,       36,   69,  -93,       41,   54,  -84,       48,   35,  -72,
      57,   15,  -59,       66,   -4,  -44,       75,  -21,  -30,       84,  -37,  -16,
      34,   76,  -96,       37,   69,  -92,       42,   55,  -83,       49,   36,  -72,
      57,   16,  -58,       66,   -3,  -44,       75,  -20,  -30,       85,  -36,  -15,
      35,   77,  -94,       37,   70,  -91,       42,   56,  -82,       49,   37,  -71,
      58,   17,  -57,       66,   -2,  -44,       75,  -19,  -30,       85,  -35,  -15,
      36,   77,  -93,       38,   71,  -89,       43,   57,  -81,       50,   39,  -70,
      58,   19,  -57,       67,    0,  -43,       76,  -17,  -29,       85,  -34,  -15,
      37,   78,  -91,       39,   71,  -88,       44,   58,  -80,       50,   40,  -69,
      58,   20,  -56,       67,    2,  -42,       76,  -16,  -29,       85,  -32,  -14,
      38,   78,  -90,       40,   72,  -86,       44,   59,  -79,       51,   42,  -68,
      59,   22,  -55,       67,    3,  -42,       76,  -14,  -28,       86,  -31,  -14,
      39,   79,  -88,       41,   73,  -85,       45,   60,  -77,       52,   43,  -67,
      59,   24,  -54,       68,    5,  -41,       77,  -12,  -27,       86,  -29,  -14,
      40,   80,  -86,       42,   74,  -83,       46,   62,  -76,       52,   45,  -66,
      60,   26,  -53,       68,    7,  -40,       77,  -10,  -27,       86,  -27,  -13,
      41,   80,  -84,       43,   75,  -81,       47,   63,  -74,       53,   47,  -64,
      61,   28,  -52,       69,    9,  -39,       77,   -8,  -26,       86,  -25,  -12,
      42,   81,  -82,       44,   76,  -79,       48,   64,  -73,       54,   48,  -63,
      61,   30,  -51,       69,   11,  -39,       78,   -6,  -25,       87,  -23,  -12,
      43,   82,  -80,       45,   77,  -77,       49,   66,  -71,       55,   50,  -62,
      62,   32,  -50,       70,   13,  -38,       78,   -4,  -25,       87,  -21,  -11,
      45,   83,  -78,       46,   78,  -75,       50,   67,  -69,       56,   52,  -60,
      63,   34,  -49,       71,   16,  -37,       79,   -2,  -24,       88,  -19,  -11,
      46,   84,  -76,       47,   79,  -73,       51,   69,  -67,       57,   54,  -59,
      63,   36,  -48,       71,   18,  -36,       79,    1,  -23,       88,  -16,  -10,
      47,   85,  -74,       49,   81,  -71,       52,   70,  -66,       57,   56,  -57,
      64,   38,  -46,       72,   21,  -35,       80,    3,  -22,       89,  -14,   -9,
      48,   86,  -72,       50,   82,  -69,       53,   72,  -64,       58,   58,  -56,
      65,   41,  -45,       72,   23,  -34,       80,    5,  -21,       89,  -12,   -8,
      50,   87,  -69,       51,   83,  -67,       54,   74,  -62,       59,   60,  -54,
      66,   43,  -44,       73,   25,  -32,       81,    8,  -20,       90,   -9,   -8,
      51,   88,  -67,       53,   84,  -65,       56,   75,  -60,       60,   62,  -52,
      67,   45,  -42,       74,   28,  -31,       82,   11,  -19,       90,   -7,   -7,
      53,   90,  -65,       54,   86,  -63,       57,   77,  -58,       62,   64,  -50,
      68,   48,  -41,       75,   31,  -30,       82,   13,  -18,       91,   -4,   -6,
      54,   91,  -63,       55,   87,  -61,       58,   79,  -56,       63,   66,  -49,
      69,   50,  -39,       75,   33,  -29,       83,   16,  -17,       91,   -1,   -5,
      55,   92,  -60,       56,   88,  -58,       59,   80,  -54,       64,   68,  -47,
      70,   52,  -38,       76,   36,  -27,       84,   18,  -16,       92,    1,   -4,
      57,   93,  -58,       58,   90,  -56,       61,   82,  -52,       65,   70,  -45,
      71,   55,  -36,       77,   38,  -26,       84,   21,  -15,       92,    4,   -3,
      58,   95,  -56,       59,   91,  -54,       62,   84,  -50,       66,   72,  -43,
      72,   57,  -34,       78,   41,  -24,       85,   24,  -14,       93,    7,   -2,
      60,   96,  -53,       61,   93,  -52,       63,   85,  -47,       67,   74,  -41,
      73,   59,  -33,       79,   43,  -23,       86,   27,  -12,       94,    9,   -1,
      31,   77, -105,       34,   69, -101,       40,   53,  -91,       47,   33,  -79,
      56,   12,  -65,       65,   -7,  -50,       74,  -24,  -36,       84,  -40,  -21,
      31,   77, -105,       34,   69, -100,       40,   53,  -91,       47,   33,  -79,
      56,   12,  -65,       65,   -7,  -50,       74,  -24,  -36,       84,  -40,  -21,
      32,   77, -105,       34,   69, -100,       40,   53,  -91,       47,   33,  -79,
      56,   12,  -64,       65,   -6,  -50,       74,  -24,  -35,       84,  -39,  -21,
      32,   77, -104,       34,   69, -100,       40,   53,  -91,       47,   34,  -79,
      56,   13,  -64,       65,   -6,  -50,       74,  -23,  -35,       84,  -39,  -21,
      32,   77, -104,       35,   69, -100,       40,   53,  -90,       47,   34,  -78,
      56,   13,  -64,       65,   -6,  -50,       74,  -23,  -35,       84,  -39,  -21,
      32,   77, -103,       35,   69,  -99,       40,   54,  -90,       48,   34,  -78,
      56,   14,  -64,       65,   -5,  -50,       75,  -22,  -35,       84,  -38,  -20,
      33,   77, -102,       35,   70,  -98,       41,   54,  -90,       48,   35,  -78,
      57,   14,  -64,       65,   -4,  -49,       75,  -22,  -35,       84,  -38,  -20,
      33,   77, -102,       36,   70,  -98,       41,   55,  -89,       48,   36,  -77,
      57,   15,  -63,       66,   -4,  -49,       75,  -21,  -35,       84,  -37,  -20,
      34,   78, -101,       36,   71,  -97,       41,   56,  -88,       48,   37,  -77,
      57,   16,  -63,       66,   -3,  -49,       75,  -20,  -34,       84,  -36,  -20,
      35,   78, -100,       37,   71,  -96,       42,   56,  -87,       49,   38,  -76,
      57,   17,  -62,       66,   -2,  -48,       75,  -19,  -34,       85,  -35,  -20,
      35,   78,  -98,       37,   71,  -95,       42,   57,  -86,       49,   39,  -75,
      58,   18,  -62,       66,    0,  -48,       75,  -18,  -34,       85,  -34,  -19,
      36,   79,  -97,       38,   72,  -94,       43,   58,  -86,       50,   40,  -74,
      58,   20,  -61,       67,    1,  -47,       76,  -17,  -33,       85,  -33,  -19,
      37,   79,  -96,       39,   73,  -92,       44,   59,  -84,       50,   41,  -74,
      58,   21,  -60,       67,    3,  -47,       76,  -15,  -33,       85,  -31,  -19,
      38,   80,  -94,       40,   73,  -91,       44,   60,  -83,       51,   43,  -73,
      59,   23,  -60,       67,    4,  -46,       76,  -13,  -32,       86,  -30,  -18,
      39,   80,  -93,       41,   74,  -89,       45,   61,  -82,       51,   44,  -72,
      59,   24,  -59,       68,    6,  -46,       77,  -12,  -32,       86,  -29,  -18,
      40,   81,  -91,       42,   75,  -88,       46,   62,  -81,       52,   45,  -71,
      60,   26,  -58,       68,    7,  -45,       77,  -10,  -31,       86,  -27,  -17,
      41,   81,  -89,       43,   76,  -86,       47,   64,  -79,       53,   47,  -69,
      60,   28,  -57,       69,   10,  -44,       77,   -8,  -31,       86,  -25,  -17,
      42,   82,  -87,       44,   77,  -84,       48,   65,  -78,       54,   49,  -68,
      61,   30,  -56,       69,   11,  -43,       78,   -6,  -30,       87,  -23,  -16,
      43,   83,  -85,       45,   78,  -83,       49,   66,  -76,       54,   50,  -67,
      62,   32,  -55,       70,   13,  -42,       78,   -4,  -29,       87,  -21,  -16,
      44,   84,  -84,       46,   79,  -81,       50,   68,  -75,       55,   52,  -65,
      62,   34,  -54,       70,   16,  -42,       79,   -2,  -29,       87,  -19,  -15,
      45,   85,  -81,       47,   80,  -79,       51,   69,  -73,       56,   54,  -64,
      63,   36,  -53,       71,   18,  -40,       79,    0,  -28,       88,  -17,  -14,
      47,   86,  -79,       48,   81,  -77,       52,   71,  -71,       57,   56,  -62,
      64,   38,  -51,       71,   20,  -39,       80,    3,  -27,       88,  -15,  -14,
      48,   86,  -77,       49,   82,  -75,       53,   72,  -69,       58,   58,  -61,
      65,   40,  -50,       72,   22,  -38,       80,    5,  -26,       89,  -12,  -13,
      49,   87,  -75,       50,   83,  -73,       54,   74,  -67,       59,   60,  -59,
      65,   42,  -49,       73,   25,  -37,       81,    7,  -25,       89,  -10,  -12,
      50,   88,  -73,       52,   84,  -71,       55,   75,  -66,       60,   61,  -58,
      66,   45,  -48,       73,   27,  -36,       81,   10,  -24,       90,   -8,  -11,
      52,   90,  -71,       53,   86,  -68,       56,   77,  -63,       61,   64,  -56,
      67,   47,  -46,       74,   30,  -35,       82,   12,  -23,       90,   -5,  -11,
      53,   91,  -68,       54,   87,  -66,       57,   78,  -62,       62,   65,  -54,
      68,   49,  -45,       75,   32,  -34,       83,   15,  -22,       91,   -2,  -10,
      54,   92,  -66,       56,   88,  -64,       59,   80,  -60,       63,   67,  -52,
      69,   52,  -43,       76,   35,  -32,       83,   17,  -21,       91,    0,   -9,
      56,   93,  -64,       57,   90,  -62,       60,   81,  -58,       64,   69,  -51,
      70,   54,  -42,       77,   37,  -31,       84,   20,  -20,       92,    3,   -8,
      57,   94,  -62,       58,   91,  -60,       61,   83,  -55,       65,   71,  -49,
      71,   56,  -40,       77,   40,  -30,       85,   23,  -19,       93,    6,   -7,
      59,   96,  -59,       60,   92,  -58,       62,   85,  -53,       66,   73,  -47,
      72,   59,  -38,       78,   42,  -28,       85,   25,  -17,       93,    8,   -6,
      60,   97,  -57,       61,   94,  -55,       64,   86,  -51,       67,   75,  -45,
      73,   61,  -37,       79,   45,  -27,       86,   28,  -16,       94,   11,   -5,
      32,   79, -108,       35,   71, -103,       40,   55,  -94,       48,   36,  -82,
      56,   15,  -68,       65,   -4,  -54,       75,  -21,  -39,       84,  -37,  -25,
      33,   79, -107,       35,   71, -103,       40,   55,  -94,       48,   36,  -82,
      56,   15,  -68,       65,   -4,  -54,       75,  -21,  -39,       84,  -37,  -25,
      33,   79, -107,       35,   71, -103,       41,   56,  -94,       48,   36,  -82,
      56,   15,  -68,       65,   -4,  -54,       75,  -21,  -39,       84,  -37,  -25,
      33,   79, -107,       35,   71, -103,       41,   56,  -94,       48,   37,  -82,
      57,   16,  -68,       66,   -3,  -54,       75,  -21,  -39,       84,  -37,  -24,
      33,   79, -106,       36,   71, -102,       41,   56,  -94,       48,   37,  -82,
      57,   16,  -68,       66,   -3,  -53,       75,  -20,  -39,       84,  -36,  -24,
      34,   79, -106,       36,   72, -102,       41,   56,  -93,       48,   37,  -81,
      57,   17,  -68,       66,   -2,  -53,       75,  -20,  -39,       84,  -36,  -24,
      34,   79, -105,       36,   72, -101,       41,   57,  -93,       48,   38,  -81,
      57,   17,  -67,       66,   -2,  -53,       75,  -19,  -39,       84,  -35,  -24,
      34,   79, -104,       37,   72, -100,       42,   57,  -92,       49,   39,  -81,
      57,   18,  -67,       66,   -1,  -53,       75,  -18,  -38,       85,  -35,  -24,
      35,   80, -103,       37,   73, -100,       42,   58,  -91,       49,   39,  -80,
      57,   19,  -66,       66,    0,  -52,       75,  -17,  -38,       85,  -34,  -24,
      36,   80, -102,       38,   73,  -99,       43,   59,  -91,       49,   40,  -79,
      58,   20,  -66,       66,    1,  -52,       75,  -16,  -38,       85,  -33,  -23,
      36,   80, -101,       38,   74,  -98,       43,   59,  -90,       50,   41,  -79,
      58,   21,  -65,       67,    2,  -52,       76,  -15,  -38,       85,  -32,  -23,
      37,   80, -100,       39,   74,  -97,       44,   60,  -89,       50,   42,  -78,
      58,   22,  -65,       67,    4,  -51,       76,  -14,  -37,       85,  -31,  -23,
      38,   81,  -99,       40,   75,  -95,       44,   61,  -88,       51,   44,  -77,
      59,   24,  -64,       67,    5,  -51,       76,  -13,  -37,       86,  -29,  -22,
      39,   81,  -97,       41,   75,  -94,       45,   62,  -86,       51,   45,  -76,
      59,   25,  -63,       68,    7,  -50,       77,  -11,  -36,       86,  -28,  -22,
      39,   82,  -96,       41,   76,  -93,       46,   63,  -85,       52,   46,  -75,
      60,   27,  -63,       68,    8,  -49,       77,  -10,  -36,       86,  -26,  -22,
      40,   82,  -94,       42,   77,  -91,       47,   64,  -84,       53,   48,  -74,
      60,   29,  -62,       69,   10,  -49,       77,   -8,  -35,       86,  -25,  -21,
      42,   83,  -92,       43,   78,  -89,       47,   66,  -82,       53,   49,  -73,
      61,   30,  -61,       69,   12,  -48,       78,   -6,  -34,       87,  -23,  -21,
      43,   84,  -90,       44,   79,  -88,       48,   67,  -81,       54,   51,  -72,
      62,   32,  -60,       70,   14,  -47,       78,   -4,  -34,       87,  -21,  -20,
      44,   84,  -89,       45,   79,  -86,       49,   68,  -80,       55,   53,  -70,
      62,   34,  -59,       70,   16,  -46,       78,   -2,  -33,       87,  -19,  -20,
      45,   85,  -87,       46,   80,  -84,       50,   69,  -78,       56,   54,  -69,
      63,   36,  -58,       71,   18,  -45,       79,    0,  -32,       88,  -17,  -19,
      46,   86,  -85,       48,   81,  -82,       51,   71,  -76,       57,   56,  -67,
      64,   38,  -56,       71,   20,  -44,       79,    2,  -32,       88,  -15,  -18,
      47,   87,  -83,       49,   83,  -80,       52,   72,  -74,       57,   58,  -66,
      64,   40,  -55,       72,   22,  -43,       80,    5,  -31,       89,  -13,  -18,
      48,   88,  -81,       50,   84,  -78,       53,   74,  -73,       58,   60,  -65,
      65,   42,  -54,       72,   24,  -42,       80,    7,  -30,       89,  -11,  -17,
      50,   89,  -79,       51,   85,  -76,       54,   75,  -71,       59,   61,  -63,
      66,   44,  -53,       73,   27,  -41,       81,    9,  -29,       89,   -8,  -16,
      51,   90,  -77,       52,   86,  -74,       55,   77,  -69,       60,   63,  -61,
      67,   46,  -51,       74,   29,  -40,       82,   11,  -28,       90,   -6,  -15,
      52,   91,  -74,       54,   87,  -72,       57,   78,  -67,       61,   65,  -60,
      68,   49,  -50,       75,   32,  -39,       82,   14,  -27,       91,   -3,  -14,
      54,   92,  -72,       55,   88,  -70,       58,   80,  -65,       62,   67,  -58,
      68,   51,  -48,       75,   34,  -38,       83,   17,  -26,       91,   -1,  -14,
      55,   93,  -70,       56,   90,  -68,       59,   81,  -63,       63,   69,  -56,
      69,   53,  -47,       76,   36,  -36,       84,   19,  -25,       92,    2,  -13,
      56,   94,  -68,       57,   91,  -66,       60,   83,  -61,       64,   71,  -54,
      70,   55,  -45,       77,   39,  -35,       84,   22,  -24,       92,    4,  -12,
      58,   96,  -65,       59,   92,  -63,       62,   85,  -59,       66,   73,  -52,
      71,   58,  -44,       78,   41,  -34,       85,   24,  -23,       93,    7,  -11,
      59,   97,  -63,       60,   94,  -61,       63,   86,  -57,       67,   75,  -51,
      72,   60,  -42,       79,   44,  -32,       86,   27,  -21,       94,   10,  -10,
      60,   98,  -61,       61,   95,  -59,       64,   88,  -55,       68,   77,  -49,
      73,   62,  -40,       79,   46,  -31,       86,   30,  -20,       94,   12,   -9,
       2,   -3,    2,       13,  -24,   18,       26,  -35,   34,       38,  -45,   43,
      50,  -55,   53,       61,  -64,   61,       71,  -72,   70,       82,  -81,   78,
       2,   -1,    3,       13,  -21,   19,       26,  -34,   34,       38,  -44,   43,
      50,  -54,   53,       61,  -63,   61,       71,  -72,   70,       82,  -81,   78,
       3,    1,    4,       13,  -18,   19,       26,  -32,   34,       38,  -43,   44,
      50,  -53,   53,       61,  -63,   62,       71,  -72,   70,       82,  -80,   78,
       3,    5,    5,       14,  -14,   20,       27,  -30,   34,       38,  -42,   44,
      50,  -52,   53,       61,  -62,   62,       71,  -71,   70,       82,  -80,   78,
       4,   10,    7,       15,  -10,   21,       27,  -27,   35,       39,  -40,   44,
      50,  -51,   53,       61,  -61,   62,       71,  -70,   70,       82,  -79,   78,
       6,   16,    9,       15,   -5,   22,       27,  -24,   35,       39,  -38,   44,
      50,  -50,   53,       61,  -60,   62,       71,  -69,   70,       82,  -79,   79,
       7,   20,   12,       16,   -1,   24,       28,  -21,   36,       39,  -35,   45,
      50,  -48,   54,       61,  -58,   62,       71,  -68,   70,       82,  -78,   79,
      10,   24,   15,       18,    4,   25,       29,  -16,   37,       40,  -32,   45,
      51,  -45,   54,       61,  -57,   62,       72,  -67,   71,       82,  -77,   79,
      11,   27,   18,       19,    9,   27,       29,  -12,   38,       40,  -29,   46,
      51,  -43,   54,       62,  -55,   63,       72,  -65,   71,       82,  -75,   79,
      13,   30,   21,       20,   13,   29,       30,   -8,   38,       41,  -26,   46,
      51,  -40,   55,       62,  -53,   63,       72,  -64,   71,       82,  -74,   79,
      15,   32,   24,       21,   17,   31,       31,   -4,   39,       41,  -22,   47,
      52,  -38,   55,       62,  -50,   63,       72,  -62,   71,       82,  -72,   79,
      17,   35,   26,       23,   21,   33,       32,    0,   40,       42,  -18,   48,
      52,  -34,   56,       62,  -48,   64,       73,  -60,   72,       83,  -71,   80,
      19,   38,   29,       24,   25,   35,       33,    5,   42,       42,  -14,   49,
      53,  -31,   56,       63,  -45,   64,       73,  -57,   72,       83,  -69,   80,
      21,   40,   32,       26,   28,   37,       34,    9,   43,       43,  -10,   49,
      53,  -28,   57,       63,  -42,   65,       73,  -55,   72,       83,  -67,   80,
      23,   43,   35,       27,   31,   39,       35,   13,   44,       44,   -6,   50,
      54,  -24,   58,       64,  -39,   65,       73,  -52,   73,       83,  -64,   81,
      25,   45,   37,       29,   35,   40,       36,   16,   45,       45,   -2,   51,
      54,  -20,   58,       64,  -36,   66,       74,  -50,   73,       84,  -62,   81,
      27,   48,   40,       30,   38,   43,       37,   21,   47,       46,    2,   52,
      55,  -16,   59,       65,  -32,   66,       74,  -46,   74,       84,  -59,   81,
      29,   50,   42,       32,   41,   44,       38,   24,   48,       47,    6,   53,
      56,  -13,   60,       65,  -29,   67,       75,  -43,   74,       84,  -57,   82,
      31,   52,   44,       34,   44,   46,       40,   28,   50,       47,    9,   55,
      57,   -9,   61,       66,  -26,   68,       75,  -40,   75,       85,  -54,   82,
      32,   54,   46,       35,   46,   48,       41,   31,   51,       48,   13,   56,
      57,   -5,   62,       66,  -22,   68,       76,  -37,   75,       85,  -51,   83,
      34,   57,   48,       37,   49,   50,       42,   35,   53,       50,   17,   57,
      58,   -1,   63,       67,  -18,   69,       76,  -34,   76,       86,  -48,   83,
      36,   59,   50,       39,   52,   51,       44,   38,   54,       51,   21,   58,
      59,    3,   64,       68,  -15,   70,       77,  -30,   77,       86,  -45,   84,
      38,   61,   52,       40,   54,   53,       45,   41,   55,       52,   24,   59,
      60,    6,   65,       68,  -11,   71,       77,  -27,   77,       87,  -42,   84,
      40,   63,   54,       42,   57,   55,       46,   44,   57,       53,   28,   61,
      61,   10,   66,       69,   -7,   72,       78,  -24,   78,       87,  -39,   85,
      41,   65,   55,       43,   59,   56,       48,   47,   58,       54,   31,   62,
      62,   13,   67,       70,   -4,   73,       79,  -20,   79,       88,  -36,   86,
      43,   67,   57,       45,   62,   58,       49,   50,   60,       55,   35,   63,
      63,   17,   68,       71,    0,   74,       79,  -16,   80,       88,  -32,   86,
      45,   69,   59,       47,   64,   60,       51,   53,   62,       56,   38,   65,
      64,   21,   69,       72,    4,   75,       80,  -13,   80,       89,  -29,   87,
      47,   71,   61,       48,   67,   61,       52,   56,   63,       58,   41,   66,
      65,   24,   70,       72,    7,   75,       81,   -9,   81,       89,  -26,   88,
      48,   73,   62,       50,   69,   63,       54,   58,   65,       59,   44,   67,
      66,   28,   72,       73,   11,   76,       81,   -6,   82,       90,  -22,   88,
      50,   76,   64,       52,   71,   65,       55,   61,   66,       60,   48,   69,
      67,   31,   73,       74,   15,   78,       82,   -2,   83,       91,  -19,   89,
      52,   78,   66,       53,   73,   66,       57,   64,   68,       62,   51,   70,
      68,   35,   74,       75,   18,   79,       83,    1,   84,       91,  -15,   90,
      53,   80,   67,       55,   75,   68,       58,   66,   69,       63,   54,   72,
      69,   38,   75,       76,   21,   80,       84,    5,   85,       92,  -12,   91,
       2,   -2,   -1,       13,  -22,   15,       26,  -34,   30,       38,  -44,   41,
      50,  -54,   51,       61,  -63,   60,       71,  -72,   69,       82,  -81,   78,
       2,    0,    0,       13,  -20,   16,       26,  -33,   31,       38,  -44,   41,
      50,  -54,   51,       61,  -63,   60,       71,  -72,   69,       82,  -81,   78,
       3,    2,    1,       14,  -17,   16,       26,  -31,   31,       38,  -43,   41,
      50,  -53,   51,       61,  -63,   60,       71,  -71,   69,       82,  -80,   78,
       4,    6,    2,       14,  -13,   17,       27,  -29,   31,       38,  -41,   42,
      50,  -52,   52,       61,  -62,   61,       71,  -71,   69,       82,  -80,   78,
       5,   11,    4,       15,   -9,   18,       27,  -27,   32,       39,  -39,   42,
      50,  -51,   52,       61,  -61,   61,       71,  -70,   69,       82,  -79,   78,
       6,   16,    6,       16,   -5,   19,       27,  -23,   32,       39,  -37,   42,
      50,  -49,   52,       61,  -60,   61,       71,  -69,   69,       82,  -79,   78,
       8,   21,    9,       16,    0,   21,       28,  -20,   33,       39,  -35,   43,
      51,  -48,   52,       61,  -58,   61,       71,  -68,   69,       82,  -78,   78,
      10,   24,   12,       18,    5,   22,       29,  -16,   34,       40,  -32,   43,
      51,  -45,   53,       61,  -56,   61,       72,  -67,   70,       82,  -76,   78,
      12,   27,   15,       19,    9,   24,       29,  -12,   34,       40,  -29,   44,
      51,  -43,   53,       62,  -55,   62,       72,  -65,   70,       82,  -75,   78,
      14,   30,   18,       20,   13,   26,       30,   -8,   35,       41,  -25,   44,
      51,  -40,   53,       62,  -52,   62,       72,  -63,   70,       82,  -74,   78,
      15,   33,   21,       21,   17,   28,       31,   -4,   36,       41,  -22,   45,
      52,  -37,   54,       62,  -50,   62,       72,  -62,   70,       83,  -72,   79,
      17,   35,   23,       23,   21,   29,       32,    0,   37,       42,  -18,   46,
      52,  -34,   54,       62,  -48,   63,       73,  -60,   71,       83,  -71,   79,
      19,   38,   26,       24,   25,   32,       33,    5,   39,       42,  -14,   47,
      53,  -31,   55,       63,  -45,   63,       73,  -57,   71,       83,  -69,   79,
      21,   41,   29,       26,   28,   33,       34,    9,   40,       43,  -10,   47,
      53,  -27,   56,       63,  -42,   64,       73,  -55,   72,       83,  -66,   80,
      23,   43,   31,       27,   32,   35,       35,   13,   41,       44,   -6,   48,
      54,  -24,   56,       64,  -39,   64,       73,  -52,   72,       83,  -64,   80,
      25,   45,   34,       29,   35,   37,       36,   17,   43,       45,   -2,   49,
      54,  -20,   57,       64,  -36,   65,       74,  -49,   72,       84,  -62,   80,
      27,   48,   36,       30,   38,   39,       37,   21,   44,       46,    2,   51,
      55,  -16,   58,       65,  -32,   65,       74,  -46,   73,       84,  -59,   81,
      29,   50,   39,       32,   41,   41,       38,   24,   46,       47,    6,   52,
      56,  -13,   59,       65,  -29,   66,       75,  -43,   73,       84,  -57,   81,
      31,   52,   41,       34,   44,   43,       40,   28,   47,       48,   10,   53,
      57,   -9,   60,       66,  -25,   67,       75,  -40,   74,       85,  -54,   82,
      32,   54,   43,       35,   47,   45,       41,   31,   49,       48,   13,   54,
      57,   -5,   60,       66,  -22,   67,       76,  -37,   75,       85,  -51,   82,
      34,   57,   45,       37,   49,   47,       42,   35,   50,       50,   17,   55,
      58,   -1,   62,       67,  -18,   68,       76,  -33,   75,       86,  -48,   83,
      36,   59,   47,       39,   52,   49,       44,   38,   52,       51,   21,   57,
      59,    3,   63,       68,  -14,   69,       77,  -30,   76,       86,  -45,   83,
      38,   61,   49,       40,   55,   50,       45,   41,   53,       52,   25,   58,
      60,    6,   64,       68,  -11,   70,       77,  -27,   77,       87,  -42,   84,
      40,   63,   51,       42,   57,   52,       46,   44,   55,       53,   28,   59,
      61,   10,   65,       69,   -7,   71,       78,  -24,   77,       87,  -39,   84,
      41,   65,   53,       43,   59,   54,       48,   47,   56,       54,   31,   60,
      62,   13,   66,       70,   -4,   72,       79,  -20,   78,       88,  -36,   85,
      43,   68,   55,       45,   62,   56,       49,   50,   58,       55,   35,   62,
      63,   17,   67,       71,    0,   73,       79,  -16,   79,       88,  -32,   86,
      45,   70,   56,       47,   64,   57,       51,   53,   60,       57,   38,   63,
      64,   21,   68,       72,    4,   74,       80,  -13,   80,       89,  -29,   86,
      47,   72,   58,       48,   67,   59,       52,   56,   61,       58,   41,   65,
      65,   24,   69,       72,    7,   75,       81,   -9,   81,       89,  -26,   87,
      48,   74,   60,       50,   69,   61,       54,   59,   63,       59,   45,   66,
      66,   28,   70,       73,   11,   76,       81,   -6,   81,       90,  -22,   88,
      50,   76,   62,       52,   71,   63,       55,   61,   65,       60,   48,   67,
      67,   31,   72,       74,   15,   77,       82,   -2,   82,       91,  -19,   89,
      52,   78,   64,       53,   73,   64,       57,   64,   66,       62,   51,   69,
      68,   35,   73,       75,   18,   78,       83,    1,   83,       91,  -15,   89,
      53,   80,   65,       55,   76,   66,       58,   67,   68,       63,   54,   70,
      69,   38,   74,       76,   21,   79,       84,    5,   84,       92,  -12,   90,
       2,   -1,   -4,       13,  -21,   12,       26,  -34,   27,       38,  -44,   39,
      50,  -54,   50,       61,  -63,   59,       71,  -72,   68,       82,  -81,   77,
       2,    1,   -3,       13,  -18,   12,       26,  -32,   27,       38,  -43,   39,
      50,  -53,   50,       61,  -63,   59,       71,  -72,   68,       82,  -80,   77,
       3,    4,   -3,       14,  -16,   13,       26,  -31,   28,       38,  -42,   39,
      50,  -53,   50,       61,  -62,   59,       71,  -71,   68,       82,  -80,   77,
       4,    8,   -1,       14,  -12,   14,       27,  -28,   28,       38,  -41,   39,
      50,  -52,   50,       61,  -62,   59,       71,  -71,   68,       82,  -80,   77,
       5,   12,    0,       15,   -8,   14,       27,  -26,   28,       39,  -39,   40,
      50,  -51,   50,       61,  -61,   59,       71,  -70,   68,       82,  -79,   77,
       6,   17,    3,       16,   -4,   16,       28,  -23,   29,       39,  -37,   40,
      50,  -49,   50,       61,  -59,   60,       71,  -69,   68,       82,  -78,   77,
       8,   21,    5,       17,    0,   17,       28,  -20,   30,       39,  -35,   40,
      51,  -47,   51,       61,  -58,   60,       72,  -68,   69,       82,  -78,   77,
      10,   25,    8,       18,    5,   19,       29,  -15,   30,       40,  -31,   41,
      51,  -45,   51,       61,  -56,   60,       72,  -67,   69,       82,  -76,   77,
      12,   28,   11,       19,    9,   20,       29,  -11,   31,       40,  -28,   42,
      51,  -43,   51,       62,  -54,   60,       72,  -65,   69,       82,  -75,   78,
      14,   30,   14,       20,   14,   22,       30,   -7,   32,       41,  -25,   42,
      51,  -40,   52,       62,  -52,   61,       72,  -63,   69,       82,  -74,   78,
      16,   33,   17,       21,   17,   24,       31,   -3,   33,       41,  -21,   43,
      52,  -37,   52,       62,  -50,   61,       72,  -61,   70,       83,  -72,   78,
      17,   36,   20,       23,   21,   26,       32,    1,   35,       42,  -18,   44,
      52,  -34,   53,       62,  -48,   61,       73,  -59,   70,       83,  -70,   78,
      19,   38,   23,       24,   25,   28,       33,    5,   36,       42,  -14,   45,
      53,  -30,   53,       63,  -45,   62,       73,  -57,   70,       83,  -68,   79,
      21,   41,   25,       26,   29,   30,       34,    9,   37,       43,  -10,   45,
      53,  -27,   54,       63,  -42,   62,       73,  -54,   71,       83,  -66,   79,
      23,   43,   28,       27,   32,   32,       35,   13,   39,       44,   -6,   46,
      54,  -24,   55,       64,  -39,   63,       73,  -52,   71,       83,  -64,   79,
      25,   45,   30,       29,   35,   34,       36,   17,   40,       45,   -2,   47,
      54,  -20,   56,       64,  -36,   64,       74,  -49,   71,       84,  -62,   80,
      27,   48,   33,       31,   38,   36,       37,   21,   42,       46,    2,   49,
      55,  -16,   56,       65,  -32,   64,       74,  -46,   72,       84,  -59,   80,
      29,   50,   35,       32,   41,   38,       39,   25,   43,       47,    6,   50,
      56,  -12,   57,       65,  -29,   65,       75,  -43,   73,       84,  -57,   80,
      31,   52,   37,       34,   44,   40,       40,   28,   45,       48,   10,   51,
      57,   -9,   58,       66,  -25,   66,       75,  -40,   73,       85,  -54,   81,
      32,   55,   39,       35,   47,   42,       41,   31,   46,       49,   13,   52,
      57,   -5,   59,       66,  -22,   66,       76,  -37,   74,       85,  -51,   81,
      34,   57,   42,       37,   50,   44,       42,   35,   48,       50,   18,   53,
      58,   -1,   60,       67,  -18,   67,       76,  -33,   74,       86,  -48,   82,
      36,   59,   44,       39,   52,   46,       44,   38,   49,       51,   21,   55,
      59,    3,   61,       68,  -14,   68,       77,  -30,   75,       86,  -45,   82,
      38,   61,   46,       40,   55,   48,       45,   41,   51,       52,   25,   56,
      60,    6,   62,       68,  -11,   69,       77,  -27,   76,       87,  -42,   83,
      40,   63,   48,       42,   57,   49,       46,   44,   53,       53,   28,   57,
      61,   10,   63,       69,   -7,   70,       78,  -23,   76,       87,  -39,   84,
      41,   65,   50,       43,   59,   51,       48,   47,   54,       54,   31,   59,
      62,   14,   64,       70,   -4,   71,       79,  -20,   77,       88,  -36,   84,
      43,   68,   52,       45,   62,   53,       49,   50,   56,       55,   35,   60,
      63,   18,   66,       71,    0,   72,       79,  -16,   78,       88,  -32,   85,
      45,   70,   54,       47,   64,   55,       51,   53,   58,       57,   38,   62,
      64,   21,   67,       72,    4,   73,       80,  -13,   79,       89,  -29,   86,
      47,   72,   56,       48,   67,   57,       52,   56,   59,       58,   42,   63,
      65,   24,   68,       72,    7,   74,       81,   -9,   80,       89,  -26,   86,
      48,   74,   58,       50,   69,   59,       54,   59,   61,       59,   45,   64,
      66,   28,   69,       73,   11,   75,       81,   -6,   81,       90,  -22,   87,
      50,   76,   60,       52,   71,   61,       55,   62,   63,       60,   48,   66,
      67,   32,   71,       74,   15,   76,       82,   -2,   82,       91,  -18,   88,
      52,   78,   62,       53,   73,   62,       57,   64,   64,       62,   51,   67,
      68,   35,   72,       75,   18,   77,       83,    1,   82,       91,  -15,   89,
      53,   80,   63,       55,   76,   64,       58,   67,   66,       63,   54,   69,
      69,   38,   73,       76,   21,   78,       84,    5,   83,       92,  -12,   89,
       2,    1,  -10,       13,  -19,    6,       26,  -32,   23,       38,  -43,   36,
      50,  -53,   47,       61,  -63,   57,       71,  -72,   67,       82,  -81,   76,
       3,    3,   -9,       13,  -16,    7,       26,  -31,   23,       38,  -42,   36,
      50,  -53,   47,       61,  -62,   57,       71,  -71,   67,       82,  -80,   76,
       3,    6,   -8,       14,  -14,    7,       27,  -30,   23,       38,  -42,   36,
      50,  -52,   47,       61,  -62,   57,       71,  -71,   67,       82,  -80,   76,
       4,   10,   -7,       14,  -10,    8,       27,  -27,   24,       39,  -40,   36,
      50,  -51,   48,       61,  -61,   57,       71,  -70,   67,       82,  -79,   76,
       5,   14,   -5,       15,   -7,    9,       27,  -25,   24,       39,  -38,   36,
      50,  -50,   48,       61,  -60,   58,       71,  -70,   67,       82,  -79,   76,
       6,   19,   -3,       16,   -3,   10,       28,  -22,   25,       39,  -36,   37,
      50,  -49,   48,       61,  -59,   58,       71,  -69,   67,       82,  -78,   76,
       8,   22,   -1,       17,    2,   11,       28,  -19,   25,       39,  -34,   37,
      51,  -47,   48,       61,  -58,   58,       72,  -68,   67,       82,  -77,   76,
      10,   26,    3,       18,    6,   13,       29,  -15,   26,       40,  -31,   38,
      51,  -44,   49,       61,  -56,   58,       72,  -66,   67,       82,  -76,   76,
      12,   28,    6,       19,   10,   15,       29,  -11,   27,       40,  -28,   38,
      51,  -42,   49,       62,  -54,   59,       72,  -65,   67,       82,  -75,   76,
      14,   31,    8,       20,   14,   17,       30,   -7,   28,       41,  -24,   39,
      51,  -40,   49,       62,  -52,   59,       72,  -63,   68,       82,  -74,   77,
      16,   34,   11,       22,   18,   19,       31,   -3,   29,       41,  -21,   40,
      52,  -37,   50,       62,  -50,   59,       72,  -61,   68,       83,  -72,   77,
      18,   36,   14,       23,   22,   20,       32,    1,   30,       42,  -17,   41,
      52,  -34,   50,       63,  -47,   60,       73,  -59,   68,       83,  -70,   77,
      20,   39,   17,       24,   26,   23,       33,    6,   32,       42,  -13,   41,
      53,  -30,   51,       63,  -44,   60,       73,  -57,   69,       83,  -68,   77,
      21,   41,   20,       26,   29,   25,       34,   10,   33,       43,   -9,   42,
      53,  -27,   52,       63,  -41,   61,       73,  -54,   69,       83,  -66,   78,
      23,   43,   22,       27,   32,   27,       35,   13,   35,       44,   -6,   43,
      54,  -23,   53,       64,  -38,   61,       74,  -52,   70,       84,  -64,   78,
      25,   46,   25,       29,   35,   29,       36,   17,   36,       45,   -2,   44,
      55,  -20,   53,       64,  -35,   62,       74,  -49,   70,       84,  -62,   78,
      27,   48,   28,       31,   39,   31,       37,   21,   38,       46,    3,   46,
      55,  -16,   54,       65,  -32,   62,       74,  -46,   71,       84,  -59,   79,
      29,   50,   30,       32,   41,   33,       39,   25,   39,       47,    6,   47,
      56,  -12,   55,       65,  -28,   63,       75,  -43,   71,       85,  -56,   79,
      31,   53,   32,       34,   44,   35,       40,   28,   41,       48,   10,   48,
      57,   -9,   56,       66,  -25,   64,       75,  -40,   72,       85,  -54,   80,
      33,   55,   35,       35,   47,   37,       41,   32,   43,       49,   14,   49,
      57,   -5,   57,       66,  -22,   65,       76,  -37,   72,       85,  -51,   80,
      34,   57,   37,       37,   50,   40,       43,   35,   44,       50,   18,   51,
      58,   -1,   58,       67,  -18,   65,       76,  -33,   73,       86,  -48,   81,
      36,   59,   39,       39,   52,   42,       44,   38,   46,       51,   21,   52,
      59,    3,   59,       68,  -14,   66,       77,  -30,   74,       86,  -45,   81,
      38,   61,   42,       40,   55,   44,       45,   42,   48,       52,   25,   53,
      60,    7,   60,       68,  -11,   67,       77,  -27,   74,       87,  -42,   82,
      40,   63,   44,       42,   57,   46,       47,   45,   49,       53,   28,   55,
      61,   10,   61,       69,   -7,   68,       78,  -23,   75,       87,  -39,   82,
      41,   65,   46,       43,   60,   48,       48,   47,   51,       54,   32,   56,
      62,   14,   62,       70,   -4,   69,       79,  -20,   76,       88,  -35,   83,
      43,   68,   48,       45,   62,   50,       49,   51,   53,       55,   35,   58,
      63,   18,   64,       71,    0,   70,       79,  -16,   77,       88,  -32,   84,
      45,   70,   50,       47,   65,   52,       51,   53,   55,       57,   39,   59,
      64,   21,   65,       72,    4,   71,       80,  -13,   77,       89,  -29,   85,
      47,   72,   52,       48,   67,   54,       52,   56,   56,       58,   42,   61,
      65,   25,   66,       72,    7,   72,       81,   -9,   78,       89,  -25,   85,
      48,   74,   54,       50,   69,   55,       54,   59,   58,       59,   45,   62,
      66,   28,   67,       73,   11,   73,       81,   -6,   79,       90,  -22,   86,
      50,   76,   56,       52,   71,   58,       55,   62,   60,       60,   48,   64,
      67,   32,   69,       74,   15,   74,       82,   -2,   80,       91,  -18,   87,
      52,   78,   58,       53,   74,   59,       57,   64,   62,       62,   51,   65,
      68,   35,   70,       75,   18,   75,       83,    2,   81,       91,  -15,   88,
      53,   80,   60,       55,   76,   61,       58,   67,   63,       63,   54,   67,
      69,   38,   71,       76,   22,   76,       84,    5,   82,       92,  -12,   88,
       3,    4,  -16,       13,  -16,    1,       26,  -31,   18,       38,  -42,   32,
      50,  -53,   45,       61,  -62,   55,       71,  -71,   65,       82,  -80,   74,
       3,    6,  -15,       14,  -14,    1,       27,  -30,   18,       38,  -42,   32,
      50,  -52,   45,       61,  -62,   55,       71,  -71,   65,       82,  -80,   74,
       4,    8,  -14,       14,  -12,    2,       27,  -28,   19,       38,  -41,   32,
      50,  -52,   45,       61,  -61,   55,       71,  -71,   65,       82,  -80,   74,
       4,   12,  -13,       15,   -8,    3,       27,  -26,   19,       39,  -39,   33,
      50,  -51,   45,       61,  -61,   55,       71,  -70,   65,       82,  -79,   74,
       5,   17,  -11,       15,   -5,    4,       27,  -24,   20,       39,  -38,   33,
      50,  -49,   45,       61,  -60,   55,       71,  -69,   65,       82,  -79,   74,
       7,   20,   -9,       16,   -1,    5,       28,  -21,   20,       39,  -36,   33,
      50,  -48,   45,       61,  -59,   56,       71,  -68,   65,       82,  -78,   74,
       8,   23,   -6,       17,    3,    6,       28,  -18,   21,       39,  -33,   34,
      51,  -46,   46,       61,  -57,   56,       72,  -67,   65,       82,  -77,   75,
      10,   27,   -3,       18,    7,    8,       29,  -14,   22,       40,  -30,   34,
      51,  -44,   46,       61,  -55,   56,       72,  -66,   66,       82,  -76,   75,
      12,   29,    0,       19,   11,   10,       29,  -10,   23,       40,  -27,   35,
      51,  -42,   46,       62,  -54,   56,       72,  -64,   66,       82,  -75,   75,
      14,   32,    3,       20,   15,   11,       30,   -6,   24,       41,  -24,   36,
      52,  -39,   47,       62,  -52,   57,       72,  -63,   66,       82,  -73,   75,
      16,   34,    6,       22,   19,   13,       31,   -2,   25,       41,  -20,   36,
      52,  -36,   47,       62,  -49,   57,       72,  -61,   66,       83,  -72,   75,
      18,   37,    8,       23,   22,   15,       32,    2,   26,       42,  -17,   37,
      52,  -33,   48,       63,  -47,   58,       73,  -59,   67,       83,  -70,   76,
      20,   39,   12,       25,   26,   18,       33,    6,   28,       43,  -13,   38,
      53,  -30,   49,       63,  -44,   58,       73,  -56,   67,       83,  -68,   76,
      22,   42,   14,       26,   29,   20,       34,   10,   29,       43,   -9,   39,
      53,  -26,   49,       63,  -41,   59,       73,  -54,   67,       83,  -66,   76,
      23,   44,   17,       27,   33,   22,       35,   14,   31,       44,   -5,   40,
      54,  -23,   50,       64,  -38,   59,       74,  -51,   68,       84,  -64,   77,
      25,   46,   20,       29,   36,   24,       36,   18,   32,       45,   -1,   41,
      55,  -19,   51,       64,  -35,   60,       74,  -49,   68,       84,  -61,   77,
      27,   49,   23,       31,   39,   27,       37,   22,   34,       46,    3,   43,
      55,  -15,   52,       65,  -31,   60,       74,  -46,   69,       84,  -59,   77,
      29,   51,   25,       32,   42,   29,       39,   25,   36,       47,    7,   44,
      56,  -12,   53,       65,  -28,   61,       75,  -43,   69,       85,  -56,   78,
      31,   53,   28,       34,   44,   31,       40,   29,   37,       48,   10,   45,
      57,   -8,   53,       66,  -25,   62,       75,  -40,   70,       85,  -54,   78,
      33,   55,   30,       35,   47,   33,       41,   32,   39,       49,   14,   46,
      57,   -5,   54,       66,  -21,   63,       76,  -37,   71,       85,  -51,   79,
      35,   57,   33,       37,   50,   35,       43,   36,   41,       50,   18,   48,
      58,    0,   56,       67,  -17,   63,       76,  -33,   71,       86,  -48,   79,
      36,   60,   35,       39,   53,   38,       44,   39,   43,       51,   22,   49,
      59,    3,   57,       68,  -14,   64,       77,  -30,   72,       86,  -45,   80,
      38,   62,   37,       40,   55,   40,       45,   42,   44,       52,   25,   50,
      60,    7,   58,       69,  -10,   65,       77,  -26,   73,       87,  -42,   81,
      40,   64,   40,       42,   57,   42,       47,   45,   46,       53,   29,   52,
      61,   10,   59,       69,   -7,   66,       78,  -23,   73,       87,  -38,   81,
      41,   66,   42,       44,   60,   44,       48,   48,   48,       54,   32,   53,
      62,   14,   60,       70,   -3,   67,       79,  -20,   74,       88,  -35,   82,
      43,   68,   44,       45,   62,   46,       49,   51,   50,       55,   36,   55,
      63,   18,   61,       71,    1,   68,       79,  -16,   75,       88,  -32,   82,
      45,   70,   46,       47,   65,   48,       51,   54,   52,       57,   39,   56,
      64,   21,   62,       72,    4,   69,       80,  -12,   76,       89,  -28,   83,
      47,   72,   49,       48,   67,   50,       52,   56,   53,       58,   42,   58,
      65,   25,   64,       72,    8,   70,       81,   -9,   77,       89,  -25,   84,
      48,   74,   51,       50,   69,   52,       54,   59,   55,       59,   45,   59,
      66,   28,   65,       73,   11,   71,       81,   -6,   78,       90,  -22,   85,
      50,   76,   53,       52,   72,   54,       55,   62,   57,       60,   48,   61,
      67,   32,   66,       74,   15,   72,       82,   -2,   79,       91,  -18,   85,
      52,   78,   55,       53,   74,   56,       57,   64,   59,       62,   51,   63,
      68,   35,   68,       75,   18,   73,       83,    2,   80,       91,  -15,   86,
      54,   80,   57,       55,   76,   58,       58,   67,   60,       63,   54,   64,
      69,   38,   69,       76,   22,   75,       84,    5,   81,       92,  -12,   87,
       3,    7,  -21,       14,  -13,   -5,       27,  -29,   14,       38,  -41,   28,
      50,  -52,   41,       61,  -62,   53,       71,  -71,   63,       82,  -80,   72,
       3,    9,  -20,       14,  -11,   -4,       27,  -28,   14,       38,  -40,   28,
      50,  -52,   41,       61,  -61,   53,       71,  -71,   63,       82,  -80,   72,
       4,   11,  -20,       14,   -9,   -4,       27,  -27,   14,       39,  -40,   29,
      50,  -51,   42,       61,  -61,   53,       71,  -70,   63,       82,  -79,   72,
       5,   15,  -18,       15,   -6,   -3,       27,  -25,   14,       39,  -38,   29,
      50,  -50,   42,       61,  -60,   53,       71,  -70,   63,       82,  -79,   73,
       6,   19,  -16,       15,   -3,   -2,       27,  -22,   15,       39,  -37,   29,
      50,  -49,   42,       61,  -59,   53,       71,  -69,   63,       82,  -78,   73,
       7,   22,  -14,       16,    1,    0,       28,  -20,   16,       39,  -35,   29,
      50,  -47,   42,       61,  -58,   53,       71,  -68,   63,       82,  -78,   73,
       9,   25,  -12,       17,    4,    1,       28,  -16,   16,       39,  -32,   30,
      51,  -46,   42,       61,  -57,   53,       72,  -67,   63,       82,  -77,   73,
      11,   28,   -8,       18,    9,    3,       29,  -13,   17,       40,  -29,   31,
      51,  -43,   43,       61,  -55,   54,       72,  -65,   63,       82,  -76,   73,
      13,   30,   -6,       19,   12,    4,       30,   -9,   18,       40,  -26,   31,
      51,  -41,   43,       62,  -53,   54,       72,  -64,   64,       82,  -74,   73,
      14,   33,   -3,       21,   16,    6,       30,   -5,   19,       41,  -23,   32,
      52,  -38,   44,       62,  -51,   54,       72,  -62,   64,       82,  -73,   73,
      16,   35,    0,       22,   20,    8,       31,   -1,   20,       41,  -20,   33,
      52,  -36,   44,       62,  -49,   55,       72,  -60,   64,       83,  -71,   74,
      18,   37,    3,       23,   23,   10,       32,    3,   22,       42,  -16,   33,
      52,  -33,   45,       63,  -46,   55,       73,  -58,   65,       83,  -70,   74,
      20,   40,    6,       25,   27,   13,       33,    7,   23,       43,  -12,   34,
      53,  -29,   45,       63,  -43,   56,       73,  -56,   65,       83,  -68,   74,
      22,   42,    9,       26,   30,   15,       34,   11,   25,       43,   -8,   35,
      53,  -26,   46,       63,  -41,   56,       73,  -54,   65,       83,  -66,   75,
      24,   44,   12,       28,   33,   17,       35,   14,   26,       44,   -5,   36,
      54,  -23,   47,       64,  -38,   57,       74,  -51,   66,       84,  -63,   75,
      25,   47,   14,       29,   36,   19,       36,   18,   28,       45,   -1,   38,
      55,  -19,   48,       64,  -35,   57,       74,  -48,   66,       84,  -61,   75,
      27,   49,   17,       31,   39,   22,       38,   22,   30,       46,    3,   39,
      55,  -15,   49,       65,  -31,   58,       74,  -45,   67,       84,  -58,   76,
      29,   51,   20,       32,   42,   24,       39,   26,   31,       47,    7,   40,
      56,  -11,   50,       65,  -28,   59,       75,  -42,   67,       85,  -56,   76,
      31,   53,   23,       34,   45,   26,       40,   29,   33,       48,   11,   41,
      57,   -8,   51,       66,  -24,   59,       75,  -39,   68,       85,  -53,   77,
      33,   55,   25,       35,   47,   28,       41,   32,   35,       49,   14,   43,
      57,   -4,   52,       67,  -21,   60,       76,  -36,   69,       85,  -50,   77,
      35,   58,   28,       37,   50,   31,       43,   36,   37,       50,   18,   44,
      58,    0,   53,       67,  -17,   61,       76,  -33,   69,       86,  -47,   78,
      36,   60,   30,       39,   53,   33,       44,   39,   39,       51,   22,   46,
      59,    4,   54,       68,  -14,   62,       77,  -29,   70,       86,  -44,   78,
      38,   62,   33,       40,   55,   35,       45,   42,   40,       52,   25,   47,
      60,    7,   55,       69,  -10,   63,       77,  -26,   71,       87,  -41,   79,
      40,   64,   35,       42,   58,   37,       47,   45,   42,       53,   29,   49,
      61,   11,   56,       69,   -7,   64,       78,  -23,   71,       87,  -38,   79,
      42,   66,   37,       44,   60,   40,       48,   48,   44,       54,   32,   50,
      62,   14,   57,       70,   -3,   65,       79,  -19,   72,       88,  -35,   80,
      43,   68,   40,       45,   63,   42,       50,   51,   46,       55,   36,   52,
      63,   18,   59,       71,    1,   66,       79,  -16,   73,       88,  -32,   81,
      45,   70,   42,       47,   65,   44,       51,   54,   48,       57,   39,   53,
      64,   22,   60,       72,    4,   67,       80,  -12,   74,       89,  -28,   82,
      47,   72,   44,       49,   67,   46,       52,   56,   50,       58,   42,   55,
      65,   25,   61,       73,    8,   68,       81,   -9,   75,       89,  -25,   82,
      48,   74,   47,       50,   69,   48,       54,   59,   51,       59,   45,   56,
      66,   28,   62,       73,   11,   69,       81,   -5,   76,       90,  -22,   83,
      50,   76,   49,       52,   72,   50,       55,   62,   54,       60,   48,   58,
      67,   32,   64,       74,   15,   70,       82,   -2,   77,       91,  -18,   84,
      52,   78,   51,       53,   74,   52,       57,   65,   55,       62,   51,   60,
      68,   35,   65,       75,   19,   71,       83,    2,   78,       91,  -15,   85,
      54,   80,   53,       55,   76,   54,       58,   67,   57,       63,   54,   61,
      69,   38,   66,       76,   22,   72,       84,    5,   79,       92,  -11,   86,
       4,   11,  -26,       14,  -10,  -10,       27,  -27,    9,       38,  -40,   24,
      50,  -51,   38,       61,  -61,   50,       71,  -70,   60,       82,  -79,   70,
       4,   13,  -26,       14,   -8,   -9,       27,  -26,    9,       39,  -39,   24,
      50,  -51,   38,       61,  -61,   50,       71,  -70,   60,       82,  -79,   70,
       5,   15,  -25,       15,   -6,   -9,       27,  -25,    9,       39,  -38,   24,
      50,  -50,   38,       61,  -60,   50,       71,  -70,   60,       82,  -79,   70,
       5,   19,  -23,       15,   -3,   -8,       27,  -23,   10,       39,  -37,   25,
      50,  -49,   38,       61,  -59,   50,       71,  -69,   60,       82,  -78,   70,
       6,   22,  -21,       16,    0,   -7,       28,  -21,   10,       39,  -35,   25,
      50,  -48,   38,       61,  -59,   50,       71,  -68,   61,       82,  -78,   71,
       8,   24,  -19,       17,    3,   -6,       28,  -18,   11,       39,  -33,   25,
      51,  -46,   39,       61,  -57,   50,       72,  -67,   61,       82,  -77,   71,
       9,   26,  -17,       17,    6,   -4,       28,  -15,   11,       40,  -31,   26,
      51,  -45,   39,       61,  -56,   50,       72,  -66,   61,       82,  -76,   71,
      11,   29,  -14,       19,   10,   -3,       29,  -11,   12,       40,  -28,   26,
      51,  -42,   39,       62,  -54,   51,       72,  -65,   61,       82,  -75,   71,
      13,   31,  -11,       20,   14,   -1,       30,   -8,   13,       40,  -25,   27,
      51,  -40,   40,       62,  -53,   51,       72,  -64,   61,       82,  -74,   71,
      15,   34,   -8,       21,   17,    1,       31,   -4,   15,       41,  -22,   28,
      52,  -38,   40,       62,  -50,   51,       72,  -62,   62,       82,  -73,   71,
      16,   36,   -5,       22,   21,    3,       31,    0,   16,       41,  -19,   28,
      52,  -35,   41,       62,  -48,   52,       72,  -60,   62,       83,  -71,   72,
      18,   38,   -2,       23,   24,    5,       32,    3,   17,       42,  -15,   29,
      52,  -32,   41,       63,  -46,   52,       73,  -58,   62,       83,  -69,   72,
      20,   41,    1,       25,   28,    8,       33,    8,   19,       43,  -11,   30,
      53,  -29,   42,       63,  -43,   53,       73,  -56,   63,       83,  -67,   72,
      22,   43,    4,       26,   31,   10,       34,   11,   20,       43,   -8,   31,
      54,  -25,   43,       63,  -40,   53,       73,  -53,   63,       83,  -65,   72,
      24,   45,    6,       28,   34,   12,       35,   15,   22,       44,   -4,   32,
      54,  -22,   44,       64,  -37,   54,       74,  -51,   63,       84,  -63,   73,
      26,   47,    9,       29,   37,   14,       36,   19,   23,       45,    0,   34,
      55,  -18,   44,       64,  -34,   54,       74,  -48,   64,       84,  -61,   73,
      28,   49,   12,       31,   40,   17,       38,   23,   25,       46,    4,   35,
      55,  -15,   45,       65,  -31,   55,       74,  -45,   64,       84,  -58,   74,
      29,   52,   15,       33,   43,   19,       39,   26,   27,       47,    8,   36,
      56,  -11,   46,       65,  -27,   56,       75,  -42,   65,       85,  -56,   74,
      31,   54,   17,       34,   45,   21,       40,   29,   29,       48,   11,   38,
      57,   -7,   47,       66,  -24,   57,       75,  -39,   66,       85,  -53,   75,
      33,   56,   20,       36,   48,   24,       41,   33,   30,       49,   15,   39,
      58,   -4,   48,       67,  -21,   57,       76,  -36,   66,       85,  -50,   75,
      35,   58,   23,       37,   51,   26,       43,   36,   32,       50,   19,   40,
      58,    0,   49,       67,  -17,   58,       76,  -32,   67,       86,  -47,   76,
      37,   60,   25,       39,   53,   28,       44,   39,   34,       51,   22,   42,
      59,    4,   51,       68,  -13,   59,       77,  -29,   68,       86,  -44,   76,
      38,   62,   28,       41,   56,   31,       45,   42,   36,       52,   26,   43,
      60,    7,   52,       69,  -10,   60,       77,  -26,   68,       87,  -41,   77,
      40,   64,   30,       42,   58,   33,       47,   45,   38,       53,   29,   45,
      61,   11,   53,       69,   -6,   61,       78,  -23,   69,       87,  -38,   77,
      42,   66,   33,       44,   60,   35,       48,   48,   40,       54,   32,   46,
      62,   15,   54,       70,   -3,   62,       79,  -19,   70,       88,  -35,   78,
      44,   68,   35,       45,   63,   37,       50,   51,   42,       56,   36,   48,
      63,   18,   55,       71,    1,   63,       79,  -15,   71,       88,  -31,   79,
      45,   70,   38,       47,   65,   40,       51,   54,   44,       57,   39,   50,
      64,   22,   57,       72,    5,   64,       80,  -12,   72,       89,  -28,   80,
      47,   72,   40,       49,   67,   42,       52,   57,   46,       58,   42,   51,
      65,   25,   58,       73,    8,   65,       81,   -9,   73,       89,  -25,   80,
      49,   74,   42,       50,   70,   44,       54,   59,   48,       59,   45,   53,
      66,   29,   59,       73,   12,   66,       81,   -5,   74,       90,  -22,   81,
      50,   76,   45,       52,   72,   46,       55,   62,   50,       60,   49,   55,
      67,   32,   61,       74,   15,   68,       82,   -1,   75,       91,  -18,   82,
      52,   78,   47,       54,   74,   48,       57,   65,   52,       62,   52,   56,
      68,   35,   62,       75,   19,   69,       83,    2,   76,       91,  -14,   83,
      54,   80,   49,       55,   76,   50,       58,   67,   53,       63,   54,   58,
      69,   39,   64,       76,   22,   70,       84,    5,   77,       92,  -11,   84,
       4,   16,  -32,       15,   -6,  -15,       27,  -25,    3,       39,  -38,   19,
      50,  -50,   34,       61,  -60,   46,       71,  -70,   57,       82,  -79,   68,
       5,   18,  -31,       15,   -4,  -15,       27,  -23,    4,       39,  -37,   19,
      50,  -49,   34,       61,  -60,   46,       71,  -69,   57,       82,  -79,   68,
       5,   20,  -30,       15,   -3,  -14,       27,  -22,    4,       39,  -37,   20,
      50,  -49,   34,       61,  -59,   46,       71,  -69,   57,       82,  -78,   68,
       6,   22,  -29,       16,    0,  -14,       28,  -20,    4,       39,  -35,   20,
      50,  -48,   34,       61,  -59,   46,       71,  -68,   57,       82,  -78,   68,
       7,   25,  -27,       16,    2,  -13,       28,  -18,    5,       39,  -34,   20,
      50,  -47,   34,       61,  -58,   46,       71,  -68,   57,       82,  -77,   68,
       9,   26,  -25,       17,    5,  -11,       28,  -16,    5,       39,  -32,   20,
      51,  -45,   34,       61,  -57,   47,       72,  -67,   58,       82,  -77,   68,
      10,   28,  -22,       18,    8,  -10,       29,  -13,    6,       40,  -30,   21,
      51,  -44,   35,       61,  -55,   47,       72,  -66,   58,       82,  -76,   68,
      12,   31,  -19,       19,   12,   -8,       29,   -9,    7,       40,  -27,   22,
      51,  -41,   35,       62,  -53,   47,       72,  -64,   58,       82,  -75,   68,
      13,   33,  -17,       20,   15,   -7,       30,   -6,    8,       41,  -24,   22,
      51,  -39,   36,       62,  -52,   47,       72,  -63,   58,       82,  -73,   68,
      15,   35,  -14,       21,   19,   -5,       31,   -3,    9,       41,  -21,   23,
      52,  -37,   36,       62,  -50,   48,       72,  -61,   58,       82,  -72,   69,
      17,   37,  -11,       22,   22,   -3,       31,    1,   10,       42,  -18,   24,
      52,  -34,   37,       62,  -47,   48,       72,  -59,   59,       83,  -70,   69,
      19,   39,   -8,       24,   25,   -1,       32,    5,   12,       42,  -14,   25,
      53,  -31,   37,       63,  -45,   49,       73,  -57,   59,       83,  -69,   69,
      21,   41,   -5,       25,   29,    2,       33,    9,   13,       43,  -10,   26,
      53,  -28,   38,       63,  -42,   49,       73,  -55,   59,       83,  -67,   70,
      22,   44,   -2,       27,   32,    4,       34,   12,   15,       44,   -7,   27,
      54,  -24,   39,       63,  -39,   50,       73,  -53,   60,       83,  -65,   70,
      24,   46,    1,       28,   35,    6,       35,   16,   16,       44,   -3,   28,
      54,  -21,   39,       64,  -37,   50,       74,  -50,   60,       84,  -63,   70,
      26,   48,    3,       29,   37,    9,       37,   20,   18,       45,    1,   29,
      55,  -18,   40,       64,  -33,   51,       74,  -47,   61,       84,  -60,   71,
      28,   50,    6,       31,   41,   11,       38,   23,   20,       46,    5,   30,
      55,  -14,   41,       65,  -30,   52,       74,  -44,   61,       84,  -58,   71,
      30,   52,    9,       33,   43,   13,       39,   27,   22,       47,    8,   32,
      56,  -10,   42,       65,  -27,   52,       75,  -41,   62,       85,  -55,   72,
      31,   54,   12,       34,   46,   16,       40,   30,   23,       48,   12,   33,
      57,   -7,   43,       66,  -23,   53,       75,  -38,   63,       85,  -52,   72,
      33,   56,   14,       36,   48,   18,       41,   33,   25,       49,   15,   34,
      58,   -3,   44,       67,  -20,   54,       76,  -35,   63,       85,  -50,   73,
      35,   59,   17,       38,   51,   21,       43,   37,   27,       50,   19,   36,
      58,    1,   45,       67,  -16,   55,       76,  -32,   64,       86,  -47,   73,
      37,   61,   20,       39,   54,   23,       44,   40,   29,       51,   23,   37,
      59,    4,   47,       68,  -13,   56,       77,  -29,   65,       86,  -44,   74,
      38,   63,   22,       41,   56,   25,       45,   43,   31,       52,   26,   39,
      60,    8,   48,       69,   -9,   57,       78,  -25,   65,       87,  -41,   74,
      40,   65,   25,       42,   58,   28,       47,   46,   33,       53,   30,   40,
      61,   11,   49,       69,   -6,   58,       78,  -22,   66,       87,  -38,   75,
      42,   66,   27,       44,   61,   30,       48,   49,   35,       54,   33,   42,
      62,   15,   50,       70,   -2,   59,       79,  -19,   67,       88,  -34,   76,
      44,   69,   30,       46,   63,   32,       50,   52,   37,       56,   36,   44,
      63,   19,   52,       71,    2,   60,       79,  -15,   68,       88,  -31,   76,
      45,   71,   32,       47,   65,   35,       51,   54,   39,       57,   40,   45,
      64,   22,   53,       72,    5,   61,       80,  -12,   69,       89,  -28,   77,
      47,   73,   35,       49,   68,   37,       53,   57,   41,       58,   43,   47,
      65,   26,   54,       73,    8,   62,       81,   -8,   70,       90,  -24,   78,
      49,   75,   37,       50,   70,   39,       54,   60,   43,       59,   46,   49,
      66,   29,   56,       73,   12,   63,       81,   -5,   71,       90,  -21,   79,
      50,   77,   40,       52,   72,   41,       56,   63,   45,       61,   49,   51,
      67,   33,   57,       74,   16,   64,       82,   -1,   72,       91,  -17,   80,
      52,   79,   42,       54,   74,   44,       57,   65,   47,       62,   52,   52,
      68,   36,   59,       75,   19,   65,       83,    2,   73,       91,  -14,   80,
      54,   80,   44,       55,   76,   46,       58,   67,   49,       63,   55,   54,
      69,   39,   60,       76,   22,   67,       84,    6,   74,       92,  -11,   81,
       5,   21,  -36,       15,   -2,  -20,       27,  -22,   -2,       39,  -36,   15,
      50,  -49,   30,       61,  -59,   42,       71,  -69,   54,       82,  -78,   65,
       6,   22,  -35,       15,   -1,  -20,       27,  -21,   -1,       39,  -36,   15,
      50,  -48,   30,       61,  -59,   43,       71,  -69,   54,       82,  -78,   65,
       6,   24,  -35,       16,    1,  -19,       27,  -20,   -1,       39,  -35,   15,
      50,  -48,   30,       61,  -58,   43,       71,  -68,   54,       82,  -78,   65,
       7,   26,  -33,       16,    3,  -18,       28,  -18,   -1,       39,  -34,   15,
      50,  -47,   30,       61,  -58,   43,       71,  -68,   54,       82,  -77,   65,
       8,   27,  -31,       17,    5,  -17,       28,  -16,    0,       39,  -32,   16,
      51,  -45,   30,       61,  -57,   43,       72,  -67,   54,       82,  -77,   65,
       9,   29,  -29,       17,    8,  -16,       28,  -14,    0,       40,  -30,   16,
      51,  -44,   30,       61,  -56,   43,       72,  -66,   55,       82,  -76,   65,
      11,   30,  -27,       18,   11,  -15,       29,  -11,    1,       40,  -28,   16,
      51,  -42,   31,       61,  -54,   43,       72,  -65,   55,       82,  -75,   66,
      12,   32,  -24,       19,   14,  -13,       30,   -8,    2,       40,  -25,   17,
      51,  -40,   31,       62,  -53,   44,       72,  -64,   55,       82,  -74,   66,
      14,   34,  -21,       20,   17,  -11,       30,   -4,    3,       41,  -23,   18,
      52,  -38,   32,       62,  -51,   44,       72,  -62,   55,       82,  -73,   66,
      16,   36,  -19,       21,   20,  -10,       31,   -1,    4,       41,  -20,   18,
      52,  -36,   32,       62,  -49,   44,       72,  -61,   55,       83,  -71,   66,
      17,   38,  -16,       23,   23,   -8,       32,    2,    6,       42,  -16,   19,
      52,  -33,   33,       62,  -47,   45,       73,  -59,   56,       83,  -70,   66,
      19,   40,  -13,       24,   26,   -6,       33,    6,    7,       42,  -13,   20,
      53,  -30,   33,       63,  -44,   45,       73,  -57,   56,       83,  -68,   67,
      21,   42,  -10,       25,   30,   -3,       34,   10,    8,       43,   -9,   21,
      53,  -27,   34,       63,  -41,   46,       73,  -54,   56,       83,  -66,   67,
      23,   44,   -7,       27,   33,   -1,       35,   13,   10,       44,   -6,   22,
      54,  -24,   35,       64,  -39,   46,       73,  -52,   57,       83,  -64,   67,
      24,   46,   -5,       28,   36,    1,       36,   17,   12,       44,   -2,   23,
      54,  -20,   36,       64,  -36,   47,       74,  -49,   57,       84,  -62,   68,
      26,   48,   -2,       30,   38,    4,       37,   20,   13,       45,    1,   25,
      55,  -17,   36,       64,  -33,   47,       74,  -47,   58,       84,  -60,   68,
      28,   51,    1,       31,   41,    6,       38,   24,   15,       46,    5,   26,
      56,  -13,   37,       65,  -29,   48,       75,  -44,   58,       84,  -57,   69,
      30,   53,    4,       33,   44,    8,       39,   28,   17,       47,    9,   27,
      56,  -10,   38,       66,  -26,   49,       75,  -41,   59,       85,  -55,   69,
      31,   55,    7,       34,   46,   11,       40,   31,   19,       48,   13,   29,
      57,   -6,   39,       66,  -23,   50,       75,  -38,   60,       85,  -52,   69,
      33,   57,    9,       36,   49,   13,       42,   34,   21,       49,   16,   30,
      58,   -3,   40,       67,  -20,   51,       76,  -35,   60,       85,  -49,   70,
      35,   59,   12,       38,   52,   16,       43,   37,   23,       50,   20,   32,
      59,    1,   42,       67,  -16,   51,       76,  -31,   61,       86,  -46,   71,
      37,   61,   15,       39,   54,   18,       44,   40,   25,       51,   23,   33,
      59,    5,   43,       68,  -12,   52,       77,  -28,   62,       86,  -43,   71,
      39,   63,   18,       41,   57,   20,       46,   43,   27,       52,   27,   35,
      60,    8,   44,       69,   -9,   53,       78,  -25,   63,       87,  -40,   72,
      40,   65,   20,       42,   59,   23,       47,   46,   29,       53,   30,   36,
      61,   12,   45,       69,   -5,   54,       78,  -22,   63,       87,  -37,   72,
      42,   67,   23,       44,   61,   25,       48,   49,   31,       54,   33,   38,
      62,   15,   47,       70,   -2,   55,       79,  -18,   64,       88,  -34,   73,
      44,   69,   25,       46,   64,   28,       50,   52,   33,       56,   37,   40,
      63,   19,   48,       71,    2,   56,       79,  -15,   65,       88,  -31,   74,
      45,   71,   28,       47,   66,   30,       51,   55,   35,       57,   40,   41,
      64,   23,   49,       72,    5,   58,       80,  -11,   66,       89,  -27,   75,
      47,   73,   30,       49,   68,   32,       53,   57,   37,       58,   43,   43,
      65,   26,   51,       73,    9,   59,       81,   -8,   67,       90,  -24,   75,
      49,   75,   33,       50,   70,   34,       54,   60,   39,       59,   46,   45,
      66,   29,   52,       74,   12,   60,       82,   -4,   68,       90,  -21,   76,
      51,   77,   35,       52,   73,   37,       56,   63,   41,       61,   49,   47,
      67,   33,   54,       75,   16,   61,       82,   -1,   69,       91,  -17,   77,
      52,   79,   37,       54,   75,   39,       57,   65,   43,       62,   52,   48,
      68,   36,   55,       75,   19,   62,       83,    3,   70,       91,  -14,   78,
      54,   81,   40,       55,   77,   41,       58,   68,   45,       63,   55,   50,
      69,   39,   57,       76,   23,   64,       84,    6,   71,       92,  -11,   79,
       6,   25,  -40,       16,    2,  -25,       27,  -19,   -6,       39,  -34,   10,
      50,  -47,   25,       61,  -58,   39,       71,  -68,   51,       82,  -78,   62,
       7,   26,  -40,       16,    3,  -24,       28,  -18,   -6,       39,  -34,   10,
      50,  -47,   26,       61,  -58,   39,       71,  -68,   51,       82,  -77,   62,
       7,   27,  -39,       16,    4,  -24,       28,  -17,   -6,       39,  -33,   11,
      50,  -46,   26,       61,  -57,   39,       71,  -67,   51,       82,  -77,   62,
       8,   28,  -37,       17,    6,  -23,       28,  -16,   -5,       39,  -32,   11,
      51,  -45,   26,       61,  -57,   39,       72,  -67,   51,       82,  -77,   62,
       9,   29,  -35,       17,    8,  -22,       28,  -14,   -5,       39,  -30,   11,
      51,  -44,   26,       61,  -56,   39,       72,  -66,   51,       82,  -76,   62,
      10,   31,  -33,       18,   11,  -21,       29,  -11,   -4,       40,  -28,   11,
      51,  -43,   26,       61,  -55,   39,       72,  -65,   51,       82,  -75,   63,
      11,   32,  -31,       19,   13,  -20,       29,   -9,   -4,       40,  -26,   12,
      51,  -41,   27,       62,  -53,   40,       72,  -64,   51,       82,  -74,   63,
      13,   34,  -29,       20,   16,  -18,       30,   -6,   -3,       40,  -24,   13,
      51,  -39,   27,       62,  -52,   40,       72,  -63,   52,       82,  -73,   63,
      15,   36,  -26,       21,   19,  -16,       30,   -3,   -2,       41,  -21,   13,
      52,  -37,   27,       62,  -50,   40,       72,  -61,   52,       82,  -72,   63,
      16,   38,  -23,       22,   22,  -14,       31,    1,    0,       41,  -18,   14,
      52,  -34,   28,       62,  -48,   41,       72,  -60,   52,       83,  -71,   63,
      18,   39,  -21,       23,   25,  -13,       32,    4,    1,       42,  -15,   15,
      52,  -32,   29,       63,  -46,   41,       73,  -58,   52,       83,  -69,   63,
      19,   41,  -18,       24,   28,  -11,       33,    7,    2,       42,  -12,   16,
      53,  -29,   29,       63,  -43,   41,       73,  -56,   53,       83,  -68,   64,
      21,   43,  -15,       26,   31,   -8,       34,   11,    4,       43,   -8,   17,
      53,  -26,   30,       63,  -41,   42,       73,  -54,   53,       83,  -66,   64,
      23,   45,  -12,       27,   34,   -6,       35,   15,    5,       44,   -5,   18,
      54,  -23,   31,       64,  -38,   43,       73,  -51,   54,       83,  -64,   64,
      25,   47,   -9,       29,   37,   -4,       36,   18,    7,       45,   -1,   19,
      54,  -19,   31,       64,  -35,   43,       74,  -49,   54,       84,  -61,   65,
      26,   49,   -7,       30,   39,   -1,       37,   21,    9,       45,    2,   20,
      55,  -16,   32,       65,  -32,   44,       74,  -46,   55,       84,  -59,   65,
      28,   51,   -4,       32,   42,    1,       38,   25,   10,       46,    6,   22,
      56,  -12,   33,       65,  -29,   45,       75,  -43,   55,       84,  -57,   66,
      30,   53,   -1,       33,   45,    4,       39,   28,   12,       47,   10,   23,
      56,   -9,   34,       66,  -25,   45,       75,  -40,   56,       85,  -54,   66,
      32,   55,    2,       35,   47,    6,       41,   32,   14,       48,   13,   24,
      57,   -5,   35,       66,  -22,   46,       75,  -37,   56,       85,  -51,   67,
      33,   57,    4,       36,   50,    8,       42,   35,   16,       49,   17,   26,
      58,   -2,   36,       67,  -19,   47,       76,  -34,   57,       85,  -49,   67,
      35,   60,    7,       38,   52,   11,       43,   38,   18,       50,   21,   27,
      59,    2,   38,       67,  -15,   48,       77,  -31,   58,       86,  -46,   68,
      37,   61,   10,       39,   55,   13,       44,   41,   20,       51,   24,   29,
      59,    6,   39,       68,  -12,   49,       77,  -28,   59,       86,  -43,   68,
      39,   63,   13,       41,   57,   16,       46,   44,   22,       52,   27,   30,
      60,    9,   40,       69,   -8,   50,       78,  -24,   59,       87,  -40,   69,
      40,   65,   15,       43,   59,   18,       47,   47,   24,       53,   31,   32,
      61,   13,   41,       70,   -5,   51,       78,  -21,   60,       87,  -37,   70,
      42,   67,   18,       44,   62,   20,       48,   50,   26,       55,   34,   34,
      62,   16,   43,       70,   -1,   52,       79,  -18,   61,       88,  -34,   70,
      44,   69,   21,       46,   64,   23,       50,   53,   28,       56,   37,   35,
      63,   20,   44,       71,    2,   53,       80,  -14,   62,       88,  -30,   71,
      46,   71,   23,       47,   66,   25,       51,   55,   30,       57,   40,   37,
      64,   23,   45,       72,    6,   54,       80,  -11,   63,       89,  -27,   72,
      47,   73,   25,       49,   68,   28,       53,   58,   32,       58,   43,   39,
      65,   26,   47,       73,    9,   55,       81,   -7,   64,       90,  -24,   73,
      49,   75,   28,       50,   70,   30,       54,   60,   34,       59,   46,   41,
      66,   30,   48,       74,   13,   56,       82,   -4,   65,       90,  -20,   73,
      51,   77,   31,       52,   73,   32,       56,   63,   37,       61,   50,   42,
      67,   33,   50,       75,   16,   58,       82,    0,   66,       91,  -17,   74,
      52,   79,   33,       54,   75,   35,       57,   66,   39,       62,   53,   44,
      68,   36,   51,       75,   20,   59,       83,    3,   67,       92,  -14,   75,
      54,   81,   35,       55,   77,   37,       59,   68,   41,       63,   55,   46,
      69,   40,   53,       76,   23,   60,       84,    6,   68,       92,  -10,   76,
       7,   29,  -44,       16,    6,  -29,       28,  -16,  -11,       39,  -32,    6,
      50,  -46,   21,       61,  -57,   35,       71,  -67,   47,       82,  -77,   59,
       8,   30,  -43,       16,    7,  -29,       28,  -15,  -11,       39,  -32,    6,
      50,  -45,   21,       61,  -56,   35,       71,  -67,   47,       82,  -77,   59,
       8,   30,  -42,       17,    8,  -28,       28,  -14,  -11,       39,  -31,    6,
      51,  -45,   21,       61,  -56,   35,       72,  -66,   47,       82,  -76,   59,
       9,   31,  -41,       17,    9,  -28,       28,  -13,  -10,       39,  -30,    6,
      51,  -44,   22,       61,  -55,   35,       72,  -66,   48,       82,  -76,   59,
      10,   32,  -39,       18,   11,  -27,       29,  -11,  -10,       40,  -28,    7,
      51,  -43,   22,       61,  -54,   35,       72,  -65,   48,       82,  -75,   59,
      11,   33,  -38,       18,   13,  -26,       29,   -9,   -9,       40,  -27,    7,
      51,  -41,   22,       62,  -53,   36,       72,  -64,   48,       82,  -75,   59,
      12,   34,  -36,       19,   16,  -24,       29,   -7,   -8,       40,  -25,    7,
      51,  -40,   22,       62,  -52,   36,       72,  -63,   48,       82,  -74,   60,
      14,   36,  -33,       20,   18,  -23,       30,   -4,   -7,       41,  -22,    8,
      51,  -38,   23,       62,  -50,   36,       72,  -62,   48,       82,  -73,   60,
      15,   37,  -31,       21,   21,  -21,       31,   -1,   -6,       41,  -19,    9,
      52,  -35,   23,       62,  -49,   36,       72,  -60,   48,       82,  -71,   60,
      17,   39,  -28,       22,   24,  -19,       31,    2,   -5,       41,  -17,    9,
      52,  -33,   24,       62,  -47,   37,       72,  -59,   49,       83,  -70,   60,
      18,   41,  -25,       23,   27,  -17,       32,    6,   -4,       42,  -14,   10,
      52,  -31,   24,       63,  -45,   37,       73,  -57,   49,       83,  -69,   60,
      20,   43,  -23,       25,   29,  -15,       33,    9,   -3,       43,  -10,   11,
      53,  -28,   25,       63,  -42,   38,       73,  -55,   49,       83,  -67,   61,
      22,   45,  -20,       26,   32,  -13,       34,   13,   -1,       43,   -7,   12,
      53,  -25,   26,       63,  -40,   38,       73,  -53,   50,       83,  -65,   61,
      23,   46,  -17,       27,   35,  -11,       35,   16,    1,       44,   -3,   13,
      54,  -22,   26,       64,  -37,   39,       74,  -50,   50,       84,  -63,   61,
      25,   48,  -14,       29,   38,   -9,       36,   19,    2,       45,    0,   14,
      54,  -18,   27,       64,  -34,   39,       74,  -48,   51,       84,  -61,   62,
      27,   50,  -12,       30,   40,   -6,       37,   23,    4,       46,    3,   16,
      55,  -15,   28,       65,  -31,   40,       74,  -45,   51,       84,  -59,   62,
      29,   52,   -9,       32,   43,   -4,       38,   26,    6,       46,    7,   17,
      56,  -11,   29,       65,  -28,   41,       75,  -42,   52,       84,  -56,   63,
      30,   54,   -6,       33,   46,   -1,       39,   29,    8,       47,   11,   18,
      56,   -8,   30,       66,  -25,   42,       75,  -40,   52,       85,  -53,   63,
      32,   56,   -3,       35,   48,    1,       41,   32,    9,       48,   14,   20,
      57,   -5,   31,       66,  -21,   42,       76,  -37,   53,       85,  -51,   64,
      34,   58,    0,       36,   50,    3,       42,   35,   11,       49,   18,   21,
      58,   -1,   32,       67,  -18,   43,       76,  -34,   54,       86,  -48,   64,
      36,   60,    3,       38,   53,    6,       43,   39,   13,       50,   21,   23,
      59,    3,   34,       68,  -14,   44,       77,  -30,   55,       86,  -45,   65,
      37,   62,    5,       40,   55,    8,       45,   42,   15,       51,   25,   24,
      60,    6,   35,       68,  -11,   45,       77,  -27,   55,       86,  -42,   65,
      39,   64,    8,       41,   58,   11,       46,   45,   17,       52,   28,   26,
      60,   10,   36,       69,   -8,   46,       78,  -24,   56,       87,  -39,   66,
      41,   66,   10,       43,   60,   13,       47,   47,   19,       54,   31,   28,
      61,   13,   37,       70,   -4,   47,       78,  -21,   57,       87,  -36,   67,
      42,   68,   13,       44,   62,   16,       49,   50,   21,       55,   34,   29,
      62,   17,   39,       70,   -1,   48,       79,  -17,   58,       88,  -33,   67,
      44,   70,   16,       46,   65,   18,       50,   53,   24,       56,   38,   31,
      63,   20,   40,       71,    3,   49,       80,  -14,   59,       89,  -30,   68,
      46,   72,   18,       48,   67,   21,       51,   56,   26,       57,   41,   33,
      64,   24,   42,       72,    6,   51,       80,  -10,   60,       89,  -26,   69,
      47,   74,   21,       49,   69,   23,       53,   58,   28,       58,   44,   35,
      65,   27,   43,       73,   10,   52,       81,   -7,   61,       90,  -23,   70,
      49,   76,   23,       51,   71,   25,       54,   61,   30,       59,   47,   36,
      66,   30,   44,       74,   13,   53,       82,   -4,   62,       90,  -20,   71,
      51,   78,   26,       52,   73,   28,       56,   64,   32,       61,   50,   38,
      67,   34,   46,       75,   17,   54,       82,    0,   63,       91,  -16,   71,
      52,   80,   28,       54,   75,   30,       57,   66,   34,       62,   53,   40,
      68,   37,   47,       76,   20,   55,       83,    4,   64,       92,  -13,   72,
      54,   81,   31,       55,   77,   32,       59,   68,   36,       63,   56,   42,
      70,   40,   49,       76,   24,   57,       84,    7,   65,       92,  -10,   73,
       8,   32,  -48,       17,    9,  -34,       28,  -13,  -16,       39,  -30,    1,
      51,  -44,   17,       61,  -55,   31,       72,  -66,   44,       82,  -76,   56,
       9,   32,  -47,       17,   10,  -33,       28,  -12,  -15,       39,  -29,    1,
      51,  -43,   17,       61,  -55,   31,       72,  -66,   44,       82,  -76,   56,
       9,   33,  -46,       17,   11,  -33,       28,  -11,  -15,       39,  -29,    1,
      51,  -43,   17,       61,  -55,   31,       72,  -65,   44,       82,  -75,   56,
      10,   33,  -45,       18,   13,  -32,       29,  -10,  -15,       40,  -27,    2,
      51,  -42,   17,       61,  -54,   31,       72,  -65,   44,       82,  -75,   56,
      11,   34,  -43,       18,   14,  -31,       29,   -8,  -14,       40,  -26,    2,
      51,  -41,   18,       61,  -53,   31,       72,  -64,   44,       82,  -74,   56,
      12,   35,  -42,       19,   16,  -30,       29,   -6,  -14,       40,  -24,    2,
      51,  -40,   18,       62,  -52,   32,       72,  -63,   44,       82,  -74,   56,
      13,   36,  -40,       20,   18,  -29,       30,   -4,  -13,       40,  -23,    3,
      51,  -38,   18,       62,  -51,   32,       72,  -62,   44,       82,  -73,   56,
      14,   38,  -37,       21,   21,  -27,       30,   -1,  -12,       41,  -20,    3,
      52,  -36,   19,       62,  -49,   32,       72,  -61,   45,       82,  -72,   57,
      16,   39,  -35,       22,   23,  -26,       31,    2,  -11,       41,  -18,    4,
      52,  -34,   19,       62,  -48,   32,       72,  -59,   45,       83,  -71,   57,
      17,   41,  -32,       23,   26,  -24,       32,    4,  -10,       42,  -15,    5,
      52,  -32,   20,       62,  -46,   33,       73,  -58,   45,       83,  -69,   57,
      19,   42,  -30,       24,   28,  -22,       32,    7,   -9,       42,  -12,    6,
      53,  -29,   20,       63,  -44,   33,       73,  -56,   45,       83,  -68,   57,
      20,   44,  -27,       25,   31,  -20,       33,   11,   -7,       43,   -9,    7,
      53,  -27,   21,       63,  -41,   34,       73,  -54,   46,       83,  -66,   57,
      22,   46,  -24,       26,   34,  -18,       34,   14,   -6,       43,   -5,    8,
      54,  -23,   21,       63,  -38,   34,       73,  -52,   46,       83,  -64,   58,
      24,   48,  -22,       28,   36,  -15,       35,   17,   -4,       44,   -2,    9,
      54,  -20,   22,       64,  -36,   35,       74,  -50,   47,       84,  -62,   58,
      25,   49,  -19,       29,   39,  -13,       36,   21,   -3,       45,    1,   10,
      55,  -17,   23,       64,  -33,   35,       74,  -47,   47,       84,  -60,   59,
      27,   51,  -16,       31,   41,  -11,       37,   24,   -1,       46,    5,   11,
      55,  -14,   24,       65,  -30,   36,       74,  -45,   48,       84,  -58,   59,
      29,   53,  -13,       32,   44,   -8,       39,   27,    1,       47,    8,   13,
      56,  -10,   25,       65,  -27,   37,       75,  -42,   48,       85,  -55,   59,
      31,   55,  -11,       34,   46,   -6,       40,   30,    3,       48,   12,   14,
      57,   -7,   26,       66,  -24,   38,       75,  -39,   49,       85,  -53,   60,
      32,   57,   -8,       35,   49,   -4,       41,   33,    5,       48,   15,   15,
      57,   -4,   27,       66,  -21,   39,       76,  -36,   50,       85,  -50,   60,
      34,   59,   -5,       37,   51,   -1,       42,   36,    7,       49,   19,   17,
      58,    0,   28,       67,  -17,   39,       76,  -33,   50,       86,  -48,   61,
      36,   61,   -2,       38,   54,    1,       44,   40,    9,       51,   22,   18,
      59,    4,   29,       68,  -14,   40,       77,  -30,   51,       86,  -44,   62,
      37,   63,    0,       40,   56,    4,       45,   42,   11,       52,   26,   20,
      60,    7,   31,       68,  -10,   41,       77,  -26,   52,       87,  -42,   62,
      39,   65,    3,       41,   58,    6,       46,   45,   13,       53,   29,   22,
      61,   10,   32,       69,   -7,   42,       78,  -23,   53,       87,  -39,   63,
      41,   66,    6,       43,   60,    8,       47,   48,   15,       54,   32,   23,
      61,   14,   33,       70,   -4,   43,       78,  -20,   53,       87,  -36,   64,
      42,   68,    8,       44,   63,   11,       49,   51,   17,       55,   35,   25,
      62,   17,   35,       70,    0,   44,       79,  -17,   54,       88,  -33,   64,
      44,   70,   11,       46,   65,   14,       50,   54,   19,       56,   39,   27,
      63,   21,   36,       71,    4,   46,       80,  -13,   55,       89,  -29,   65,
      46,   72,   13,       48,   67,   16,       52,   56,   21,       57,   42,   29,
      64,   24,   37,       72,    7,   47,       80,  -10,   56,       89,  -26,   66,
      48,   74,   16,       49,   69,   18,       53,   59,   23,       58,   45,   30,
      65,   27,   39,       73,   10,   48,       81,   -6,   57,       90,  -23,   67,
      49,   76,   18,       51,   71,   21,       54,   61,   25,       60,   47,   32,
      66,   31,   40,       74,   14,   49,       82,   -3,   58,       90,  -20,   67,
      51,   78,   21,       53,   74,   23,       56,   64,   28,       61,   51,   34,
      67,   34,   42,       75,   17,   50,       83,    1,   59,       91,  -16,   68,
      53,   80,   24,       54,   76,   26,       57,   66,   30,       62,   53,   36,
      69,   37,   44,       76,   21,   52,       83,    4,   60,       92,  -13,   69,
      54,   82,   26,       56,   78,   28,       59,   69,   32,       63,   56,   38,
      70,   40,   45,       77,   24,   53,       84,    7,   61,       92,   -9,   70,
      10,   35,  -51,       18,   14,  -38,       29,   -9,  -21,       40,  -27,   -4,
      51,  -42,   12,       61,  -54,   26,       72,  -65,   40,       82,  -75,   52,
      10,   35,  -51,       18,   14,  -38,       29,   -9,  -21,       40,  -26,   -4,
      51,  -41,   12,       61,  -53,   26,       72,  -64,   40,       82,  -75,   52,
      10,   36,  -50,       18,   15,  -38,       29,   -8,  -20,       40,  -26,   -4,
      51,  -41,   12,       61,  -53,   27,       72,  -64,   40,       82,  -74,   52,
      11,   36,  -49,       18,   16,  -37,       29,   -7,  -20,       40,  -25,   -3,
      51,  -40,   12,       62,  -52,   27,       72,  -63,   40,       82,  -74,   52,
      12,   37,  -47,       19,   18,  -36,       29,   -5,  -19,       40,  -23,   -3,
      51,  -39,   13,       62,  -52,   27,       72,  -63,   40,       82,  -73,   52,
      13,   38,  -46,       20,   19,  -35,       30,   -3,  -19,       40,  -22,   -3,
      51,  -38,   13,       62,  -50,   27,       72,  -62,   40,       82,  -73,   52,
      14,   39,  -44,       20,   21,  -34,       30,   -1,  -18,       41,  -20,   -2,
      52,  -36,   13,       62,  -49,   27,       72,  -61,   40,       82,  -72,   53,
      15,   40,  -42,       21,   24,  -32,       31,    1,  -17,       41,  -18,   -2,
      52,  -34,   14,       62,  -48,   28,       72,  -60,   40,       82,  -71,   53,
      17,   41,  -40,       22,   26,  -31,       31,    4,  -16,       41,  -15,   -1,
      52,  -32,   14,       62,  -46,   28,       72,  -58,   41,       83,  -69,   53,
      18,   43,  -37,       23,   28,  -29,       32,    7,  -15,       42,  -13,    0,
      52,  -30,   15,       63,  -44,   28,       73,  -57,   41,       83,  -68,   53,
      20,   44,  -35,       24,   30,  -27,       33,   10,  -14,       42,  -10,    1,
      53,  -27,   15,       63,  -42,   29,       73,  -55,   41,       83,  -67,   53,
      21,   46,  -32,       26,   33,  -25,       34,   13,  -13,       43,   -7,    1,
      53,  -25,   16,       63,  -40,   29,       73,  -53,   42,       83,  -65,   54,
      23,   47,  -29,       27,   35,  -23,       35,   16,  -11,       44,   -4,    3,
      54,  -22,   17,       64,  -37,   30,       73,  -51,   42,       83,  -63,   54,
      24,   49,  -27,       28,   38,  -21,       36,   19,   -9,       44,    0,    4,
      54,  -19,   17,       64,  -35,   30,       74,  -48,   43,       84,  -61,   54,
      26,   51,  -24,       30,   40,  -18,       37,   22,   -8,       45,    3,    5,
      55,  -16,   18,       64,  -32,   31,       74,  -46,   43,       84,  -59,   55,
      28,   52,  -22,       31,   43,  -16,       38,   25,   -6,       46,    6,    6,
      55,  -13,   19,       65,  -29,   32,       74,  -44,   44,       84,  -57,   55,
      29,   54,  -19,       33,   45,  -14,       39,   29,   -4,       47,   10,    7,
      56,   -9,   20,       65,  -26,   32,       75,  -41,   44,       85,  -54,   56,
      31,   56,  -16,       34,   48,  -11,       40,   32,   -2,       48,   13,    9,
      57,   -6,   21,       66,  -23,   33,       75,  -38,   45,       85,  -52,   56,
      33,   58,  -13,       35,   50,   -9,       41,   35,   -1,       49,   16,   10,
      57,   -2,   22,       66,  -20,   34,       76,  -35,   45,       85,  -49,   57,
      34,   60,  -11,       37,   52,   -7,       42,   37,    1,       50,   20,   12,
      58,    1,   23,       67,  -16,   35,       76,  -32,   46,       86,  -47,   57,
      36,   62,   -8,       39,   55,   -4,       44,   41,    4,       51,   23,   13,
      59,    5,   25,       68,  -13,   36,       77,  -29,   47,       86,  -44,   58,
      38,   64,   -5,       40,   57,   -2,       45,   43,    6,       52,   27,   15,
      60,    8,   26,       68,   -9,   37,       77,  -26,   48,       87,  -41,   59,
      39,   65,   -2,       42,   59,    1,       46,   46,    8,       53,   30,   17,
      61,   11,   27,       69,   -6,   38,       78,  -22,   49,       87,  -38,   59,
      41,   67,    0,       43,   61,    3,       48,   49,   10,       54,   33,   18,
      62,   15,   28,       70,   -3,   39,       78,  -19,   49,       88,  -35,   60,
      43,   69,    3,       45,   63,    6,       49,   51,   12,       55,   36,   20,
      62,   18,   30,       71,    1,   40,       79,  -16,   50,       88,  -32,   61,
      45,   71,    6,       46,   66,    8,       50,   54,   14,       56,   39,   22,
      64,   22,   31,       71,    4,   41,       80,  -12,   51,       89,  -28,   61,
      46,   73,    8,       48,   68,   11,       52,   57,   16,       57,   42,   24,
      64,   25,   33,       72,    8,   42,       80,   -9,   52,       89,  -25,   62,
      48,   75,   11,       49,   70,   13,       53,   59,   18,       59,   45,   25,
      65,   28,   34,       73,   11,   44,       81,   -6,   53,       90,  -22,   63,
      49,   77,   13,       51,   72,   15,       55,   62,   20,       60,   48,   27,
      66,   31,   36,       74,   14,   45,       82,   -2,   54,       90,  -19,   64,
      51,   79,   16,       53,   74,   18,       56,   65,   23,       61,   51,   29,
      68,   35,   37,       75,   18,   46,       83,    1,   55,       91,  -15,   65,
      53,   80,   18,       54,   76,   20,       58,   67,   25,       62,   54,   31,
      69,   38,   39,       76,   21,   47,       83,    5,   56,       92,  -12,   66,
      54,   82,   21,       56,   78,   23,       59,   69,   27,       64,   57,   33,
      70,   41,   40,       77,   25,   49,       84,    8,   57,       92,   -9,   67,
      11,   38,  -55,       18,   17,  -42,       29,   -6,  -25,       40,  -24,   -8,
      51,  -40,    8,       61,  -52,   22,       72,  -63,   36,       82,  -74,   49,
      11,   38,  -54,       18,   18,  -42,       29,   -5,  -25,       40,  -24,   -8,
      51,  -39,    8,       62,  -52,   22,       72,  -63,   36,       82,  -73,   49,
      12,   38,  -53,       19,   19,  -42,       29,   -5,  -25,       40,  -23,   -8,
      51,  -39,    8,       62,  -51,   22,       72,  -63,   36,       82,  -73,   49,
      12,   39,  -52,       19,   20,  -41,       29,   -3,  -24,       40,  -22,   -8,
      51,  -38,    8,       62,  -51,   23,       72,  -62,   36,       82,  -73,   49,
      13,   39,  -51,       20,   21,  -40,       30,   -2,  -24,       40,  -21,   -8,
      51,  -37,    8,       62,  -50,   23,       72,  -61,   36,       82,  -72,   49,
      14,   40,  -50,       20,   22,  -39,       30,    0,  -23,       41,  -19,   -7,
      52,  -36,    9,       62,  -49,   23,       72,  -61,   36,       82,  -72,   49,
      15,   41,  -48,       21,   24,  -38,       31,    2,  -23,       41,  -18,   -7,
      52,  -34,    9,       62,  -48,   23,       72,  -60,   36,       82,  -71,   49,
      16,   42,  -46,       22,   26,  -36,       31,    4,  -22,       41,  -15,   -6,
      52,  -32,    9,       62,  -46,   23,       72,  -58,   37,       83,  -70,   49,
      17,   43,  -44,       23,   28,  -35,       32,    6,  -21,       42,  -13,   -5,
      52,  -30,   10,       62,  -45,   24,       73,  -57,   37,       83,  -68,   49,
      19,   44,  -41,       24,   30,  -33,       32,    9,  -20,       42,  -11,   -5,
      53,  -28,   10,       63,  -43,   24,       73,  -55,   37,       83,  -67,   50,
      20,   46,  -39,       25,   32,  -31,       33,   12,  -18,       43,   -8,   -4,
      53,  -26,   11,       63,  -41,   25,       73,  -54,   37,       83,  -66,   50,
      22,   47,  -37,       26,   35,  -30,       34,   15,  -17,       43,   -5,   -3,
      53,  -23,   12,       63,  -38,   25,       73,  -52,   38,       83,  -64,   50,
      23,   49,  -34,       27,   37,  -27,       35,   18,  -15,       44,   -2,   -2,
      54,  -20,   12,       64,  -36,   26,       74,  -50,   38,       84,  -62,   51,
      25,   50,  -31,       29,   39,  -25,       36,   21,  -14,       45,    1,   -1,
      54,  -17,   13,       64,  -33,   26,       74,  -47,   39,       84,  -60,   51,
      26,   52,  -29,       30,   42,  -23,       37,   24,  -12,       45,    4,    0,
      55,  -14,   14,       65,  -31,   27,       74,  -45,   39,       84,  -58,   51,
      28,   53,  -26,       31,   44,  -21,       38,   27,  -11,       46,    7,    2,
      56,  -11,   15,       65,  -28,   28,       75,  -43,   40,       84,  -56,   52,
      30,   55,  -23,       33,   46,  -18,       39,   30,   -9,       47,   11,    3,
      56,   -8,   16,       66,  -25,   28,       75,  -40,   40,       85,  -54,   52,
      31,   57,  -20,       34,   49,  -16,       40,   33,   -7,       48,   14,    4,
      57,   -5,   17,       66,  -22,   29,       75,  -37,   41,       85,  -51,   53,
      33,   59,  -18,       36,   51,  -14,       41,   36,   -5,       49,   18,    6,
      58,   -1,   18,       67,  -19,   30,       76,  -34,   42,       85,  -49,   53,
      35,   61,  -15,       37,   53,  -11,       43,   38,   -3,       50,   21,    7,
      58,    2,   19,       67,  -15,   31,       76,  -31,   42,       86,  -46,   54,
      36,   62,  -12,       39,   56,   -9,       44,   42,   -1,       51,   24,    9,
      59,    6,   20,       68,  -12,   32,       77,  -28,   43,       86,  -43,   54,
      38,   64,  -10,       40,   58,   -6,       45,   44,    1,       52,   27,   11,
      60,    9,   22,       69,   -9,   33,       77,  -25,   44,       87,  -40,   55,
      40,   66,   -7,       42,   60,   -4,       47,   47,    3,       53,   31,   12,
      61,   12,   23,       69,   -5,   34,       78,  -22,   45,       87,  -37,   56,
      41,   68,   -4,       43,   62,   -1,       48,   50,    5,       54,   34,   14,
      62,   16,   24,       70,   -2,   35,       79,  -18,   46,       88,  -34,   56,
      43,   70,   -2,       45,   64,    1,       49,   52,    7,       55,   37,   15,
      63,   19,   26,       71,    1,   36,       79,  -15,   47,       88,  -31,   57,
      45,   72,    1,       47,   66,    4,       51,   55,    9,       56,   40,   17,
      64,   22,   27,       72,    5,   37,       80,  -12,   48,       89,  -28,   58,
      46,   73,    4,       48,   68,    6,       52,   58,   12,       58,   43,   19,
      65,   26,   29,       72,    8,   38,       81,   -8,   48,       89,  -25,   59,
      48,   75,    6,       50,   70,    8,       53,   60,   14,       59,   46,   21,
      66,   29,   30,       73,   12,   40,       81,   -5,   49,       90,  -22,   60,
      50,   77,    9,       51,   72,   11,       55,   62,   16,       60,   49,   23,
      67,   32,   32,       74,   15,   41,       82,   -2,   50,       90,  -18,   60,
      51,   79,   11,       53,   75,   13,       56,   65,   18,       61,   52,   25,
      68,   35,   33,       75,   19,   42,       83,    2,   52,       91,  -15,   61,
      53,   81,   14,       54,   77,   16,       58,   68,   20,       62,   55,   27,
      69,   39,   35,       76,   22,   44,       83,    5,   53,       92,  -12,   62,
      55,   83,   16,       56,   79,   18,       59,   70,   22,       64,   57,   28,
      70,   42,   36,       77,   25,   45,       84,    8,   54,       92,   -8,   63,
      12,   40,  -58,       19,   21,  -46,       29,   -3,  -30,       40,  -22,  -13,
      51,  -37,    3,       62,  -50,   18,       72,  -62,   32,       82,  -73,   45,
      12,   41,  -57,       19,   21,  -46,       30,   -2,  -29,       40,  -21,  -13,
      51,  -37,    4,       62,  -50,   18,       72,  -62,   32,       82,  -72,   45,
      13,   41,  -57,       19,   22,  -46,       30,   -1,  -29,       40,  -20,  -13,
      51,  -37,    4,       62,  -50,   18,       72,  -61,   32,       82,  -72,   45,
      13,   41,  -56,       20,   23,  -45,       30,    0,  -29,       40,  -19,  -12,
      51,  -36,    4,       62,  -49,   18,       72,  -61,   32,       82,  -72,   45,
      14,   42,  -55,       20,   24,  -44,       30,    1,  -28,       41,  -18,  -12,
      52,  -35,    4,       62,  -48,   19,       72,  -60,   32,       82,  -71,   45,
      15,   42,  -53,       21,   25,  -43,       31,    3,  -28,       41,  -17,  -12,
      52,  -34,    4,       62,  -47,   19,       72,  -59,   32,       82,  -70,   45,
      16,   43,  -52,       22,   27,  -42,       31,    4,  -27,       41,  -15,  -11,
      52,  -32,    5,       62,  -46,   19,       72,  -58,   32,       83,  -70,   45,
      17,   44,  -49,       22,   29,  -41,       32,    7,  -26,       42,  -13,  -11,
      52,  -30,    5,       62,  -45,   19,       72,  -57,   33,       83,  -68,   46,
      18,   45,  -47,       23,   30,  -39,       32,    9,  -25,       42,  -11,  -10,
      52,  -28,    5,       63,  -43,   20,       73,  -56,   33,       83,  -67,   46,
      20,   46,  -45,       24,   32,  -37,       33,   11,  -24,       42,   -9,   -9,
      53,  -26,    6,       63,  -41,   20,       73,  -54,   33,       83,  -66,   46,
      21,   47,  -43,       25,   34,  -36,       34,   14,  -23,       43,   -6,   -8,
      53,  -24,    7,       63,  -39,   20,       73,  -52,   34,       83,  -65,   46,
      22,   49,  -41,       27,   36,  -34,       34,   17,  -21,       44,   -3,   -7,
      54,  -22,    7,       63,  -37,   21,       73,  -51,   34,       83,  -63,   47,
      24,   50,  -38,       28,   39,  -32,       35,   20,  -20,       44,    0,   -6,
      54,  -19,    8,       64,  -34,   22,       74,  -48,   34,       84,  -61,   47,
      25,   52,  -36,       29,   41,  -30,       36,   22,  -18,       45,    3,   -5,
      55,  -16,    9,       64,  -32,   22,       74,  -46,   35,       84,  -59,   47,
      27,   53,  -33,       30,   43,  -27,       37,   25,  -17,       46,    6,   -4,
      55,  -13,   10,       65,  -29,   23,       74,  -44,   35,       84,  -57,   48,
      28,   55,  -30,       32,   45,  -25,       38,   28,  -15,       46,    9,   -3,
      56,  -10,   11,       65,  -27,   23,       75,  -41,   36,       84,  -55,   48,
      30,   56,  -28,       33,   48,  -23,       39,   31,  -13,       47,   12,   -1,
      56,   -7,   12,       66,  -23,   24,       75,  -39,   37,       85,  -53,   49,
      32,   58,  -25,       35,   50,  -20,       41,   34,  -11,       48,   16,    0,
      57,   -3,   13,       66,  -20,   25,       75,  -36,   37,       85,  -50,   49,
      33,   60,  -22,       36,   52,  -18,       42,   37,  -10,       49,   19,    1,
      58,    0,   14,       67,  -17,   26,       76,  -33,   38,       85,  -48,   50,
      35,   61,  -20,       38,   54,  -16,       43,   40,   -8,       50,   22,    3,
      58,    3,   15,       67,  -14,   27,       76,  -30,   39,       86,  -45,   50,
      37,   63,  -17,       39,   56,  -13,       44,   43,   -6,       51,   25,    4,
      59,    7,   16,       68,  -11,   28,       77,  -27,   39,       86,  -42,   51,
      38,   65,  -14,       41,   59,  -11,       45,   45,   -4,       52,   28,    6,
      60,   10,   17,       69,   -8,   29,       77,  -24,   40,       87,  -39,   52,
      40,   67,  -12,       42,   61,   -8,       47,   48,   -2,       53,   32,    8,
      61,   13,   19,       69,   -4,   30,       78,  -21,   41,       87,  -36,   52,
      42,   69,   -9,       44,   63,   -6,       48,   50,    0,       54,   35,    9,
      62,   16,   20,       70,   -1,   31,       79,  -18,   42,       88,  -33,   53,
      43,   70,   -6,       45,   65,   -4,       49,   53,    3,       55,   38,   11,
      63,   20,   21,       71,    2,   32,       79,  -14,   43,       88,  -30,   54,
      45,   72,   -4,       47,   67,   -1,       51,   56,    5,       57,   41,   13,
      64,   23,   23,       72,    6,   33,       80,  -11,   44,       89,  -27,   54,
      47,   74,   -1,       48,   69,    1,       52,   58,    7,       58,   44,   15,
      65,   26,   24,       72,    9,   34,       81,   -8,   45,       89,  -24,   55,
      48,   76,    1,       50,   71,    4,       54,   61,    9,       59,   47,   17,
      66,   30,   26,       73,   12,   36,       81,   -4,   46,       90,  -21,   56,
      50,   78,    4,       51,   73,    6,       55,   63,   11,       60,   49,   18,
      67,   33,   27,       74,   16,   37,       82,   -1,   47,       91,  -18,   57,
      52,   80,    7,       53,   75,    9,       56,   66,   14,       61,   52,   20,
      68,   36,   29,       75,   19,   38,       83,    3,   48,       91,  -14,   58,
      53,   81,    9,       55,   77,   11,       58,   68,   16,       63,   55,   22,
      69,   39,   31,       76,   23,   40,       84,    6,   49,       92,  -11,   59,
      55,   83,   12,       56,   79,   14,       59,   70,   18,       64,   58,   24,
      70,   42,   32,       77,   26,   41,       84,    9,   50,       93,   -8,   60,
      13,   43,  -61,       20,   24,  -50,       30,    1,  -34,       40,  -19,  -17,
      51,  -35,   -1,       62,  -49,   14,       72,  -60,   28,       82,  -71,   41,
      14,   43,  -61,       20,   25,  -50,       30,    1,  -34,       41,  -18,  -17,
      51,  -35,   -1,       62,  -48,   14,       72,  -60,   28,       82,  -71,   41,
      14,   43,  -60,       20,   25,  -49,       30,    2,  -33,       41,  -18,  -17,
      52,  -34,   -1,       62,  -48,   14,       72,  -60,   28,       82,  -71,   41,
      14,   44,  -59,       21,   26,  -49,       30,    3,  -33,       41,  -17,  -17,
      52,  -33,   -1,       62,  -47,   14,       72,  -59,   28,       82,  -70,   41,
      15,   44,  -58,       21,   27,  -48,       31,    4,  -33,       41,  -16,  -16,
      52,  -33,    0,       62,  -46,   14,       72,  -59,   28,       82,  -70,   41,
      16,   45,  -57,       22,   28,  -47,       31,    6,  -32,       41,  -14,  -16,
      52,  -31,    0,       62,  -45,   15,       72,  -58,   28,       83,  -69,   42,
      17,   45,  -55,       22,   29,  -46,       31,    7,  -31,       42,  -13,  -16,
      52,  -30,    0,       62,  -44,   15,       72,  -57,   29,       83,  -68,   42,
      18,   46,  -53,       23,   31,  -45,       32,    9,  -30,       42,  -11,  -15,
      52,  -28,    1,       63,  -43,   15,       73,  -56,   29,       83,  -67,   42,
      19,   47,  -51,       24,   33,  -43,       33,   11,  -29,       42,   -9,  -14,
      53,  -26,    1,       63,  -41,   16,       73,  -54,   29,       83,  -66,   42,
      20,   48,  -49,       25,   35,  -42,       33,   14,  -28,       43,   -6,  -14,
      53,  -24,    2,       63,  -40,   16,       73,  -53,   29,       83,  -65,   42,
      22,   49,  -47,       26,   36,  -40,       34,   16,  -27,       43,   -4,  -13,
      53,  -22,    2,       63,  -38,   16,       73,  -51,   30,       83,  -64,   43,
      23,   50,  -45,       27,   38,  -38,       35,   19,  -26,       44,   -1,  -12,
      54,  -20,    3,       64,  -35,   17,       73,  -49,   30,       83,  -62,   43,
      25,   52,  -42,       28,   41,  -36,       36,   22,  -24,       44,    2,  -11,
      54,  -17,    4,       64,  -33,   17,       74,  -47,   30,       84,  -60,   43,
      26,   53,  -40,       30,   43,  -34,       37,   24,  -23,       45,    5,  -10,
      55,  -14,    4,       64,  -30,   18,       74,  -45,   31,       84,  -58,   44,
      27,   54,  -37,       31,   45,  -32,       38,   27,  -21,       46,    8,   -9,
      55,  -11,    5,       65,  -28,   19,       74,  -43,   31,       84,  -56,   44,
      29,   56,  -35,       32,   47,  -30,       39,   30,  -20,       47,   11,   -7,
      56,   -8,    6,       65,  -25,   19,       75,  -40,   32,       85,  -54,   44,
      31,   58,  -32,       34,   49,  -27,       40,   33,  -18,       48,   14,   -6,
      57,   -5,    7,       66,  -22,   20,       75,  -37,   33,       85,  -52,   45,
      32,   59,  -29,       35,   51,  -25,       41,   35,  -16,       48,   17,   -5,
      57,   -2,    8,       66,  -19,   21,       76,  -35,   33,       85,  -49,   45,
      34,   61,  -27,       36,   53,  -23,       42,   38,  -14,       49,   20,   -3,
      58,    1,    9,       67,  -16,   22,       76,  -32,   34,       86,  -47,   46,
      35,   62,  -24,       38,   55,  -20,       43,   41,  -12,       50,   23,   -2,
      59,    4,   11,       67,  -13,   23,       77,  -29,   35,       86,  -44,   47,
      37,   64,  -21,       39,   57,  -18,       45,   44,  -10,       51,   27,    0,
      60,    8,   12,       68,  -10,   24,       77,  -26,   35,       86,  -41,   47,
      39,   66,  -19,       41,   60,  -15,       46,   46,   -8,       52,   30,    2,
      60,   11,   13,       69,   -6,   25,       78,  -23,   36,       87,  -38,   48,
      40,   68,  -16,       42,   62,  -13,       47,   49,   -6,       53,   33,    3,
      61,   14,   14,       69,   -3,   26,       78,  -20,   37,       87,  -36,   49,
      42,   69,  -14,       44,   64,  -11,       48,   51,   -4,       54,   36,    5,
      62,   17,   16,       70,    0,   27,       79,  -17,   38,       88,  -33,   49,
      43,   71,  -11,       45,   66,   -8,       50,   54,   -2,       55,   38,    7,
      63,   21,   17,       71,    3,   28,       79,  -14,   39,       88,  -30,   50,
      45,   73,   -8,       47,   68,   -5,       51,   57,    0,       57,   42,    9,
      64,   24,   19,       72,    7,   29,       80,  -10,   40,       89,  -26,   51,
      47,   75,   -6,       49,   70,   -3,       52,   59,    3,       58,   45,   10,
      65,   27,   20,       73,   10,   30,       81,   -7,   41,       89,  -23,   52,
      48,   76,   -3,       50,   72,   -1,       54,   61,    5,       59,   47,   12,
      66,   30,   22,       73,   13,   32,       81,   -4,   42,       90,  -20,   52,
      50,   78,   -1,       52,   74,    2,       55,   64,    7,       60,   50,   14,
      67,   33,   23,       74,   16,   33,       82,    0,   43,       91,  -17,   53,
      52,   80,    2,       53,   76,    4,       57,   66,    9,       62,   53,   16,
      68,   37,   25,       75,   20,   34,       83,    3,   44,       91,  -13,   54,
      53,   82,    5,       55,   78,    7,       58,   69,   11,       63,   56,   18,
      69,   40,   26,       76,   23,   36,       84,    6,   45,       92,  -10,   55,
      55,   84,    7,       56,   80,    9,       59,   71,   13,       64,   58,   20,
      70,   43,   28,       77,   26,   37,       84,   10,   46,       93,   -7,   56,
      15,   46,  -64,       21,   28,  -54,       30,    5,  -39,       41,  -15,  -22,
      52,  -32,   -6,       62,  -46,    9,       72,  -58,   23,       82,  -70,   37,
      15,   46,  -64,       21,   28,  -54,       31,    5,  -38,       41,  -15,  -22,
      52,  -32,   -6,       62,  -46,    9,       72,  -58,   23,       82,  -70,   37,
      15,   46,  -63,       21,   29,  -54,       31,    6,  -38,       41,  -14,  -22,
      52,  -32,   -6,       62,  -46,    9,       72,  -58,   23,       82,  -69,   37,
      16,   46,  -63,       22,   29,  -53,       31,    7,  -38,       41,  -13,  -22,
      52,  -31,   -5,       62,  -45,   10,       72,  -57,   24,       83,  -69,   37,
      16,   47,  -62,       22,   30,  -52,       31,    8,  -37,       41,  -12,  -21,
      52,  -30,   -5,       62,  -44,   10,       72,  -57,   24,       83,  -68,   37,
      17,   47,  -60,       22,   31,  -51,       32,    9,  -37,       42,  -11,  -21,
      52,  -29,   -5,       62,  -43,   10,       72,  -56,   24,       83,  -68,   37,
      18,   48,  -59,       23,   33,  -50,       32,   11,  -36,       42,  -10,  -20,
      52,  -28,   -5,       63,  -42,   10,       73,  -55,   24,       83,  -67,   37,
      19,   48,  -57,       24,   34,  -49,       33,   13,  -35,       42,   -8,  -20,
      53,  -26,   -4,       63,  -41,   10,       73,  -54,   24,       83,  -66,   38,
      20,   49,  -55,       25,   36,  -48,       33,   14,  -34,       43,   -6,  -19,
      53,  -24,   -4,       63,  -39,   11,       73,  -53,   25,       83,  -65,   38,
      21,   50,  -53,       26,   37,  -46,       34,   17,  -33,       43,   -4,  -18,
      53,  -22,   -3,       63,  -38,   11,       73,  -51,   25,       83,  -63,   38,
      22,   51,  -51,       27,   39,  -44,       34,   19,  -32,       44,   -1,  -18,
      54,  -20,   -3,       64,  -36,   12,       73,  -49,   25,       83,  -62,   38,
      24,   52,  -49,       28,   41,  -43,       35,   21,  -31,       44,    1,  -17,
      54,  -18,   -2,       64,  -34,   12,       74,  -48,   26,       84,  -61,   39,
      25,   53,  -47,       29,   43,  -41,       36,   24,  -29,       45,    4,  -16,
      55,  -15,   -1,       64,  -31,   13,       74,  -45,   26,       84,  -59,   39,
      27,   55,  -44,       30,   45,  -39,       37,   26,  -28,       45,    7,  -15,
      55,  -12,    0,       65,  -29,   13,       74,  -43,   26,       84,  -57,   39,
      28,   56,  -42,       31,   46,  -37,       38,   29,  -26,       46,   10,  -13,
      56,  -10,    0,       65,  -26,   14,       75,  -41,   27,       84,  -55,   40,
      30,   57,  -39,       33,   48,  -34,       39,   32,  -25,       47,   12,  -12,
      56,   -7,    1,       65,  -24,   15,       75,  -39,   28,       85,  -53,   40,
      31,   59,  -37,       34,   51,  -32,       40,   34,  -23,       48,   16,  -11,
      57,   -3,    2,       66,  -21,   15,       75,  -36,   28,       85,  -50,   41,
      33,   61,  -34,       36,   53,  -30,       41,   37,  -21,       49,   19,   -9,
      57,    0,    3,       67,  -18,   16,       76,  -33,   29,       85,  -48,   41,
      34,   62,  -32,       37,   54,  -27,       42,   40,  -19,       50,   22,   -8,
      58,    3,    5,       67,  -15,   17,       76,  -31,   29,       86,  -46,   42,
      36,   64,  -29,       38,   56,  -25,       44,   42,  -17,       50,   25,   -7,
      59,    6,    6,       68,  -12,   18,       77,  -28,   30,       86,  -43,   42,
      38,   65,  -26,       40,   59,  -23,       45,   45,  -15,       52,   28,   -5,
      60,    9,    7,       68,   -8,   19,       77,  -25,   31,       87,  -40,   43,
      39,   67,  -24,       41,   61,  -20,       46,   48,  -13,       53,   31,   -3,
      61,   12,    8,       69,   -5,   20,       78,  -22,   32,       87,  -37,   44,
      41,   69,  -21,       43,   63,  -18,       47,   50,  -11,       54,   34,   -2,
      61,   15,   10,       70,   -2,   21,       78,  -19,   33,       87,  -34,   44,
      42,   70,  -19,       44,   65,  -16,       49,   53,   -9,       55,   37,    0,
      62,   19,   11,       70,    1,   22,       79,  -16,   34,       88,  -32,   45,
      44,   72,  -16,       46,   67,  -13,       50,   55,   -7,       56,   40,    2,
      63,   22,   12,       71,    4,   23,       79,  -13,   34,       88,  -29,   46,
      46,   74,  -13,       47,   69,  -10,       51,   58,   -5,       57,   43,    4,
      64,   25,   14,       72,    8,   25,       80,   -9,   35,       89,  -25,   47,
      47,   76,  -11,       49,   71,   -8,       53,   60,   -2,       58,   46,    5,
      65,   28,   15,       73,   11,   26,       81,   -6,   36,       90,  -22,   47,
      49,   77,   -8,       50,   73,   -6,       54,   62,    0,       59,   48,    7,
      66,   31,   17,       74,   14,   27,       82,   -3,   37,       90,  -19,   48,
      50,   79,   -6,       52,   74,   -3,       55,   65,    2,       60,   51,    9,
      67,   34,   18,       74,   17,   28,       82,    0,   39,       91,  -16,   49,
      52,   81,   -3,       54,   77,   -1,       57,   67,    4,       62,   54,   11,
      68,   38,   20,       75,   21,   30,       83,    4,   40,       91,  -13,   50,
      54,   83,    0,       55,   79,    2,       58,   69,    6,       63,   57,   13,
      69,   41,   22,       76,   24,   31,       84,    7,   41,       92,  -10,   51,
      55,   84,    2,       57,   80,    4,       60,   72,    8,       64,   59,   15,
      70,   44,   23,       77,   27,   32,       85,   10,   42,       93,   -6,   52,
      16,   48,  -68,       22,   31,  -58,       31,    8,  -43,       41,  -12,  -26,
      52,  -30,  -10,       62,  -44,    5,       72,  -57,   19,       83,  -68,   33,
      16,   48,  -67,       22,   32,  -58,       31,    9,  -42,       41,  -12,  -26,
      52,  -29,  -10,       62,  -44,    5,       72,  -56,   19,       83,  -68,   33,
      16,   48,  -67,       22,   32,  -57,       31,    9,  -42,       41,  -11,  -26,
      52,  -29,  -10,       62,  -43,    5,       72,  -56,   19,       83,  -68,   33,
      17,   48,  -66,       22,   33,  -57,       31,   10,  -42,       42,  -11,  -26,
      52,  -28,  -10,       62,  -43,    5,       72,  -56,   20,       83,  -67,   33,
      17,   49,  -65,       23,   33,  -56,       32,   11,  -41,       42,  -10,  -26,
      52,  -27,   -9,       62,  -42,    6,       73,  -55,   20,       83,  -67,   33,
      18,   49,  -64,       23,   34,  -55,       32,   12,  -41,       42,   -8,  -25,
      52,  -26,   -9,       63,  -41,    6,       73,  -54,   20,       83,  -66,   34,
      19,   50,  -62,       24,   35,  -54,       33,   13,  -40,       42,   -7,  -25,
      53,  -25,   -9,       63,  -40,    6,       73,  -53,   20,       83,  -65,   34,
      20,   50,  -61,       25,   37,  -53,       33,   15,  -39,       43,   -5,  -24,
      53,  -23,   -8,       63,  -39,    6,       73,  -52,   20,       83,  -64,   34,
      21,   51,  -59,       25,   38,  -51,       34,   17,  -38,       43,   -3,  -23,
      53,  -22,   -8,       63,  -37,    7,       73,  -51,   21,       83,  -63,   34,
      22,   52,  -57,       26,   39,  -50,       34,   19,  -37,       43,   -1,  -23,
      54,  -20,   -7,       63,  -36,    7,       73,  -49,   21,       83,  -62,   34,
      23,   53,  -55,       27,   41,  -48,       35,   21,  -36,       44,    1,  -22,
      54,  -18,   -7,       64,  -34,    7,       73,  -48,   21,       83,  -61,   35,
      24,   54,  -53,       28,   43,  -47,       36,   23,  -35,       44,    3,  -21,
      54,  -16,   -6,       64,  -32,    8,       74,  -46,   22,       84,  -59,   35,
      26,   55,  -51,       30,   45,  -45,       37,   26,  -33,       45,    6,  -20,
      55,  -13,   -5,       64,  -29,    9,       74,  -44,   22,       84,  -57,   35,
      27,   56,  -48,       31,   46,  -43,       37,   28,  -32,       46,    9,  -19,
      55,  -10,   -5,       65,  -27,    9,       74,  -42,   22,       84,  -56,   36,
      29,   58,  -46,       32,   48,  -41,       38,   31,  -30,       47,   12,  -18,
      56,   -8,   -4,       65,  -25,   10,       75,  -40,   23,       84,  -54,   36,
      30,   59,  -44,       33,   50,  -39,       39,   33,  -29,       47,   14,  -17,
      56,   -5,   -3,       66,  -22,   10,       75,  -37,   24,       85,  -52,   36,
      32,   60,  -41,       35,   52,  -36,       41,   36,  -27,       48,   17,  -15,
      57,   -2,   -2,       66,  -19,   11,       75,  -35,   24,       85,  -49,   37,
      33,   62,  -38,       36,   54,  -34,       42,   39,  -25,       49,   20,  -14,
      58,    1,   -1,       67,  -16,   12,       76,  -32,   25,       85,  -47,   37,
      35,   63,  -36,       37,   56,  -32,       43,   41,  -23,       50,   23,  -12,
      58,    4,    0,       67,  -13,   13,       76,  -29,   25,       86,  -44,   38,
      36,   65,  -33,       39,   58,  -30,       44,   44,  -21,       51,   26,  -11,
      59,    7,    1,       68,  -10,   14,       77,  -27,   26,       86,  -42,   39,
      38,   66,  -31,       40,   60,  -27,       45,   46,  -19,       52,   29,   -9,
      60,   11,    3,       68,   -7,   15,       77,  -23,   27,       87,  -39,   39,
      39,   68,  -28,       42,   62,  -25,       46,   49,  -17,       53,   32,   -8,
      61,   14,    4,       69,   -4,   16,       78,  -21,   28,       87,  -36,   40,
      41,   70,  -25,       43,   64,  -22,       48,   51,  -15,       54,   35,   -6,
      62,   17,    5,       70,   -1,   17,       78,  -18,   29,       88,  -34,   41,
      43,   71,  -23,       45,   66,  -20,       49,   54,  -13,       55,   38,   -4,
      62,   20,    7,       70,    2,   18,       79,  -15,   30,       88,  -31,   41,
      44,   73,  -20,       46,   67,  -18,       50,   56,  -11,       56,   41,   -3,
      63,   23,    8,       71,    5,   19,       80,  -12,   30,       89,  -28,   42,
      46,   75,  -18,       48,   70,  -15,       52,   59,   -9,       57,   44,   -1,
      64,   26,   10,       72,    9,   20,       80,   -8,   32,       89,  -24,   43,
      47,   76,  -15,       49,   71,  -13,       53,   61,   -7,       58,   46,    1,
      65,   29,   11,       73,   12,   22,       81,   -5,   33,       90,  -21,   44,
      49,   78,  -13,       51,   73,  -10,       54,   63,   -5,       59,   49,    3,
      66,   32,   13,       74,   15,   23,       82,   -2,   34,       90,  -18,   45,
      51,   80,  -10,       52,   75,   -8,       56,   65,   -3,       61,   52,    5,
      67,   35,   14,       74,   18,   24,       82,    1,   35,       91,  -15,   45,
      52,   82,   -7,       54,   77,   -5,       57,   68,    0,       62,   55,    7,
      68,   39,   16,       75,   22,   26,       83,    5,   36,       92,  -12,   46,
      54,   83,   -5,       55,   79,   -3,       58,   70,    2,       63,   57,    9,
      69,   41,   17,       76,   25,   27,       84,    8,   37,       92,   -9,   47,
      55,   85,   -2,       57,   81,    0,       60,   72,    4,       64,   60,   11,
      70,   44,   19,       77,   28,   28,       85,   11,   38,       93,   -6,   48,
      17,   50,  -70,       22,   34,  -61,       32,   11,  -47,       42,   -9,  -31,
      52,  -27,  -14,       62,  -42,    1,       72,  -55,   15,       83,  -67,   29,
      17,   50,  -70,       23,   35,  -61,       32,   12,  -46,       42,   -9,  -30,
      52,  -27,  -14,       62,  -42,    1,       73,  -55,   15,       83,  -67,   29,
      18,   50,  -70,       23,   35,  -61,       32,   12,  -46,       42,   -8,  -30,
      52,  -26,  -14,       63,  -41,    1,       73,  -54,   15,       83,  -66,   29,
      18,   51,  -69,       23,   36,  -60,       32,   13,  -46,       42,   -7,  -30,
      52,  -26,  -14,       63,  -41,    1,       73,  -54,   16,       83,  -66,   29,
      19,   51,  -68,       24,   36,  -60,       32,   14,  -45,       42,   -7,  -30,
      53,  -25,  -14,       63,  -40,    1,       73,  -53,   16,       83,  -65,   30,
      19,   51,  -67,       24,   37,  -59,       33,   15,  -45,       42,   -5,  -29,
      53,  -24,  -13,       63,  -39,    2,       73,  -53,   16,       83,  -65,   30,
      20,   52,  -66,       25,   38,  -58,       33,   16,  -44,       43,   -4,  -29,
      53,  -23,  -13,       63,  -38,    2,       73,  -52,   16,       83,  -64,   30,
      21,   52,  -64,       25,   39,  -56,       34,   18,  -43,       43,   -2,  -28,
      53,  -21,  -13,       63,  -37,    2,       73,  -50,   16,       83,  -63,   30,
      22,   53,  -62,       26,   40,  -55,       34,   20,  -42,       43,   -1,  -28,
      53,  -19,  -12,       63,  -35,    2,       73,  -49,   16,       83,  -62,   30,
      23,   54,  -61,       27,   42,  -54,       35,   22,  -41,       44,    1,  -27,
      54,  -18,  -12,       64,  -34,    3,       73,  -48,   17,       83,  -61,   30,
      24,   55,  -59,       28,   43,  -52,       35,   24,  -40,       44,    3,  -26,
      54,  -16,  -11,       64,  -32,    3,       74,  -46,   17,       84,  -59,   31,
      25,   56,  -57,       29,   45,  -51,       36,   26,  -39,       45,    6,  -25,
      55,  -14,  -10,       64,  -30,    4,       74,  -45,   17,       84,  -58,   31,
      27,   57,  -54,       30,   46,  -49,       37,   28,  -38,       45,    8,  -24,
      55,  -11,  -10,       65,  -28,    4,       74,  -42,   18,       84,  -56,   31,
      28,   58,  -52,       31,   48,  -47,       38,   30,  -36,       46,   11,  -23,
      56,   -8,   -9,       65,  -25,    5,       75,  -40,   18,       84,  -54,   32,
      29,   59,  -50,       32,   50,  -45,       39,   33,  -35,       47,   13,  -22,
      56,   -6,   -8,       65,  -23,    6,       75,  -38,   19,       85,  -52,   32,
      31,   60,  -48,       34,   52,  -43,       40,   35,  -33,       48,   16,  -21,
      57,   -3,   -7,       66,  -20,    6,       75,  -36,   19,       85,  -50,   33,
      32,   62,  -45,       35,   54,  -40,       41,   38,  -31,       48,   19,  -19,
      57,    0,   -6,       66,  -17,    7,       76,  -33,   20,       85,  -48,   33,
      34,   63,  -42,       36,   55,  -38,       42,   40,  -29,       49,   22,  -18,
      58,    3,   -5,       67,  -15,    8,       76,  -31,   21,       86,  -46,   34,
      35,   64,  -40,       38,   57,  -36,       43,   43,  -28,       50,   25,  -17,
      59,    6,   -4,       67,  -12,    9,       76,  -28,   21,       86,  -43,   34,
      37,   66,  -38,       39,   59,  -34,       44,   45,  -26,       51,   28,  -15,
      59,    9,   -3,       68,   -9,   10,       77,  -25,   22,       86,  -41,   35,
      38,   68,  -35,       41,   61,  -31,       46,   48,  -24,       52,   31,  -14,
      60,   12,   -2,       69,   -6,   11,       78,  -22,   23,       87,  -38,   35,
      40,   69,  -32,       42,   63,  -29,       47,   50,  -22,       53,   33,  -12,
      61,   15,    0,       69,   -3,   12,       78,  -19,   24,       87,  -35,   36,
      41,   71,  -30,       43,   65,  -27,       48,   52,  -20,       54,   36,  -10,
      62,   18,    1,       70,    0,   13,       79,  -16,   25,       88,  -32,   37,
      43,   72,  -27,       45,   67,  -24,       49,   55,  -18,       55,   39,   -9,
      63,   21,    2,       71,    3,   14,       79,  -14,   26,       88,  -30,   37,
      44,   74,  -25,       46,   68,  -22,       50,   57,  -16,       56,   42,   -7,
      63,   24,    4,       71,    6,   15,       80,  -10,   26,       89,  -27,   38,
      46,   76,  -22,       48,   70,  -19,       52,   60,  -13,       57,   45,   -5,
      65,   27,    5,       72,   10,   16,       80,   -7,   28,       89,  -24,   39,
      48,   77,  -19,       49,   72,  -17,       53,   62,  -11,       59,   47,   -3,
      65,   30,    7,       73,   13,   17,       81,   -4,   29,       90,  -21,   40,
      49,   79,  -17,       51,   74,  -15,       54,   64,   -9,       60,   50,   -1,
      66,   33,    8,       74,   16,   19,       82,   -1,   30,       90,  -18,   41,
      51,   80,  -14,       52,   76,  -12,       56,   66,   -7,       61,   53,    0,
      67,   36,   10,       75,   19,   20,       82,    2,   31,       91,  -14,   42,
      53,   82,  -12,       54,   78,   -9,       57,   69,   -5,       62,   56,    2,
      69,   39,   12,       76,   23,   21,       83,    6,   32,       92,  -11,   43,
      54,   84,   -9,       56,   80,   -7,       59,   71,   -2,       63,   58,    4,
      70,   42,   13,       76,   26,   23,       84,    9,   33,       92,   -8,   44,
      56,   86,   -7,       57,   82,   -5,       60,   73,    0,       65,   61,    6,
      71,   45,   15,       77,   29,   24,       85,   12,   34,       93,   -5,   45,
      18,   52,  -73,       23,   37,  -65,       32,   15,  -50,       42,   -6,  -35,
      52,  -24,  -18,       63,  -40,   -3,       73,  -53,   11,       83,  -65,   25,
      18,   53,  -73,       24,   38,  -65,       32,   15,  -50,       42,   -6,  -35,
      53,  -24,  -18,       63,  -39,   -3,       73,  -53,   11,       83,  -65,   25,
      19,   53,  -73,       24,   38,  -64,       32,   16,  -50,       42,   -5,  -34,
      53,  -24,  -18,       63,  -39,   -3,       73,  -52,   11,       83,  -65,   25,
      19,   53,  -72,       24,   38,  -64,       33,   16,  -50,       42,   -4,  -34,
      53,  -23,  -18,       63,  -38,   -3,       73,  -52,   11,       83,  -64,   26,
      20,   53,  -71,       24,   39,  -63,       33,   17,  -49,       43,   -4,  -34,
      53,  -22,  -18,       63,  -38,   -3,       73,  -51,   12,       83,  -64,   26,
      20,   53,  -70,       25,   40,  -62,       33,   18,  -49,       43,   -3,  -34,
      53,  -21,  -18,       63,  -37,   -3,       73,  -51,   12,       83,  -63,   26,
      21,   54,  -69,       25,   41,  -61,       34,   19,  -48,       43,   -1,  -33,
      53,  -20,  -17,       63,  -36,   -2,       73,  -50,   12,       83,  -62,   26,
      22,   54,  -67,       26,   42,  -60,       34,   21,  -47,       43,    0,  -32,
      53,  -19,  -17,       63,  -35,   -2,       73,  -49,   12,       83,  -61,   26,
      23,   55,  -66,       27,   43,  -59,       35,   23,  -46,       44,    2,  -32,
      54,  -17,  -16,       64,  -33,   -2,       73,  -47,   12,       83,  -60,   26,
      24,   56,  -64,       28,   44,  -57,       35,   24,  -45,       44,    4,  -31,
      54,  -15,  -16,       64,  -32,   -1,       74,  -46,   13,       84,  -59,   27,
      25,   57,  -62,       29,   45,  -56,       36,   26,  -44,       45,    6,  -30,
      54,  -13,  -15,       64,  -30,   -1,       74,  -44,   13,       84,  -58,   27,
      26,   57,  -60,       30,   47,  -54,       37,   28,  -43,       45,    8,  -29,
      55,  -11,  -15,       64,  -28,    0,       74,  -43,   13,       84,  -56,   27,
      27,   58,  -58,       31,   48,  -52,       38,   30,  -42,       46,   11,  -28,
      55,   -9,  -14,       65,  -26,    0,       74,  -41,   14,       84,  -55,   27,
      29,   59,  -56,       32,   50,  -51,       38,   33,  -40,       46,   13,  -27,
      56,   -6,  -13,       65,  -24,    1,       75,  -39,   14,       84,  -53,   28,
      30,   61,  -54,       33,   52,  -49,       39,   35,  -39,       47,   16,  -26,
      56,   -4,  -12,       66,  -21,    1,       75,  -37,   15,       85,  -51,   28,
      31,   62,  -51,       34,   53,  -47,       40,   37,  -37,       48,   18,  -25,
      57,   -1,  -11,       66,  -19,    2,       75,  -34,   15,       85,  -49,   29,
      33,   63,  -49,       36,   55,  -44,       41,   39,  -35,       49,   21,  -24,
      58,    2,  -10,       67,  -16,    3,       76,  -32,   16,       85,  -47,   29,
      34,   64,  -46,       37,   57,  -42,       42,   42,  -34,       50,   24,  -22,
      58,    4,   -9,       67,  -13,    4,       76,  -29,   17,       86,  -44,   30,
      36,   66,  -44,       38,   58,  -40,       43,   44,  -32,       50,   26,  -21,
      59,    7,   -8,       68,  -10,    5,       77,  -27,   17,       86,  -42,   30,
      37,   67,  -42,       40,   60,  -38,       45,   46,  -30,       51,   29,  -19,
      60,   10,   -7,       68,   -8,    6,       77,  -24,   18,       86,  -40,   31,
      39,   69,  -39,       41,   62,  -35,       46,   49,  -28,       52,   32,  -18,
      60,   13,   -6,       69,   -4,    7,       78,  -21,   19,       87,  -37,   32,
      40,   70,  -36,       42,   64,  -33,       47,   51,  -26,       53,   35,  -16,
      61,   16,   -4,       69,   -1,    8,       78,  -18,   20,       87,  -34,   32,
      42,   72,  -34,       44,   66,  -31,       48,   54,  -24,       54,   38,  -15,
      62,   19,   -3,       70,    2,    9,       79,  -15,   21,       88,  -31,   33,
      43,   73,  -31,       45,   68,  -28,       49,   56,  -22,       55,   40,  -13,
      63,   22,   -2,       71,    5,   10,       79,  -12,   22,       88,  -29,   34,
      45,   75,  -29,       47,   69,  -26,       51,   58,  -20,       56,   43,  -11,
      64,   25,    0,       72,    8,   11,       80,   -9,   22,       89,  -26,   34,
      47,   76,  -26,       48,   71,  -24,       52,   61,  -18,       58,   46,   -9,
      65,   28,    1,       72,   11,   12,       81,   -6,   24,       89,  -22,   35,
      48,   78,  -24,       50,   73,  -21,       53,   63,  -16,       59,   48,   -8,
      66,   31,    3,       73,   14,   13,       81,   -3,   25,       90,  -20,   36,
      50,   80,  -21,       51,   75,  -19,       55,   65,  -13,       60,   51,   -6,
      67,   34,    4,       74,   17,   15,       82,    0,   26,       90,  -17,   37,
      51,   81,  -19,       53,   77,  -16,       56,   67,  -11,       61,   54,   -4,
      68,   37,    6,       75,   20,   16,       83,    3,   27,       91,  -14,   38,
      53,   83,  -16,       54,   79,  -14,       58,   70,   -9,       62,   57,   -2,
      69,   40,    7,       76,   24,   17,       83,    7,   28,       92,  -10,   39,
      54,   85,  -14,       56,   81,  -11,       59,   72,   -7,       64,   59,    0,
      70,   43,    9,       77,   27,   19,       84,   10,   29,       92,   -7,   40,
      56,   86,  -11,       57,   82,   -9,       60,   74,   -5,       65,   62,    2,
      71,   46,   11,       78,   30,   20,       85,   13,   30,       93,   -4,   41,
      20,   55,  -77,       24,   41,  -69,       33,   19,  -55,       42,   -2,  -39,
      53,  -21,  -23,       63,  -37,   -8,       73,  -51,    7,       83,  -63,   21,
      20,   55,  -76,       25,   41,  -68,       33,   19,  -55,       43,   -2,  -39,
      53,  -21,  -23,       63,  -37,   -8,       73,  -50,    7,       83,  -63,   21,
      20,   55,  -76,       25,   41,  -68,       33,   19,  -54,       43,   -2,  -39,
      53,  -21,  -23,       63,  -36,   -8,       73,  -50,    7,       83,  -63,   21,
      20,   55,  -75,       25,   42,  -68,       33,   20,  -54,       43,   -1,  -39,
      53,  -20,  -23,       63,  -36,   -8,       73,  -50,    7,       83,  -62,   21,
      21,   56,  -74,       25,   42,  -67,       34,   21,  -54,       43,    0,  -38,
      53,  -19,  -23,       63,  -35,   -7,       73,  -49,    7,       83,  -62,   21,
      21,   56,  -74,       26,   43,  -66,       34,   22,  -53,       43,    1,  -38,
      53,  -18,  -22,       63,  -34,   -7,       73,  -48,    7,       83,  -61,   21,
      22,   56,  -72,       26,   44,  -65,       34,   23,  -52,       43,    2,  -38,
      54,  -17,  -22,       63,  -33,   -7,       73,  -48,    7,       83,  -61,   21,
      23,   57,  -71,       27,   45,  -64,       35,   24,  -52,       44,    4,  -37,
      54,  -16,  -22,       64,  -32,   -7,       73,  -46,    8,       83,  -60,   22,
      24,   57,  -69,       28,   46,  -63,       35,   26,  -51,       44,    5,  -36,
      54,  -14,  -21,       64,  -31,   -6,       74,  -45,    8,       84,  -59,   22,
      25,   58,  -68,       29,   47,  -62,       36,   27,  -50,       45,    7,  -36,
      54,  -13,  -21,       64,  -29,   -6,       74,  -44,    8,       84,  -57,   22,
      26,   59,  -66,       29,   48,  -60,       37,   29,  -49,       45,    9,  -35,
      55,  -11,  -20,       64,  -28,   -6,       74,  -42,    9,       84,  -56,   22,
      27,   59,  -64,       30,   49,  -59,       37,   31,  -48,       46,   11,  -34,
      55,   -9,  -19,       65,  -26,   -5,       74,  -41,    9,       84,  -55,   23,
      28,   60,  -62,       32,   51,  -57,       38,   33,  -46,       46,   13,  -33,
      56,   -6,  -19,       65,  -24,   -4,       75,  -39,    9,       84,  -53,   23,
      29,   61,  -60,       33,   52,  -55,       39,   35,  -45,       47,   16,  -32,
      56,   -4,  -18,       65,  -21,   -4,       75,  -37,   10,       85,  -51,   23,
      31,   62,  -58,       34,   54,  -53,       40,   37,  -43,       48,   18,  -31,
      57,   -2,  -17,       66,  -19,   -3,       75,  -35,   10,       85,  -49,   24,
      32,   63,  -56,       35,   55,  -51,       41,   39,  -42,       48,   20,  -30,
      57,    1,  -16,       66,  -17,   -3,       76,  -33,   11,       85,  -47,   24,
      34,   65,  -53,       36,   57,  -49,       42,   42,  -40,       49,   23,  -28,
      58,    4,  -15,       67,  -14,   -2,       76,  -30,   12,       86,  -45,   25,
      35,   66,  -51,       37,   58,  -47,       43,   44,  -38,       50,   26,  -27,
      58,    6,  -14,       67,  -11,   -1,       76,  -28,   12,       86,  -43,   25,
      36,   67,  -49,       39,   60,  -45,       44,   46,  -36,       51,   28,  -26,
      59,    9,  -13,       68,   -9,    0,       77,  -25,   13,       86,  -40,   26,
      38,   69,  -46,       40,   62,  -42,       45,   48,  -35,       52,   31,  -24,
      60,   12,  -12,       68,   -6,    1,       77,  -22,   14,       87,  -38,   26,
      39,   70,  -43,       42,   64,  -40,       46,   51,  -33,       53,   34,  -22,
      61,   15,  -10,       69,   -3,    2,       78,  -19,   14,       87,  -35,   27,
      41,   71,  -41,       43,   65,  -38,       47,   53,  -31,       54,   36,  -21,
      61,   18,   -9,       70,    0,    3,       78,  -17,   15,       87,  -33,   28,
      42,   73,  -39,       44,   67,  -35,       49,   55,  -29,       55,   39,  -19,
      62,   21,   -8,       70,    3,    4,       79,  -14,   16,       88,  -30,   29,
      44,   74,  -36,       46,   69,  -33,       50,   57,  -27,       56,   42,  -18,
      63,   24,   -7,       71,    6,    5,       79,  -11,   17,       88,  -27,   29,
      45,   76,  -34,       47,   71,  -31,       51,   59,  -25,       57,   44,  -16,
      64,   27,   -5,       72,    9,    6,       80,   -8,   18,       89,  -24,   30,
      47,   78,  -31,       49,   73,  -28,       53,   62,  -22,       58,   47,  -14,
      65,   30,   -4,       73,   12,    7,       81,   -5,   19,       90,  -21,   31,
      48,   79,  -28,       50,   74,  -26,       54,   64,  -20,       59,   50,  -12,
      66,   33,   -2,       73,   15,    9,       81,   -2,   20,       90,  -18,   32,
      50,   81,  -26,       52,   76,  -24,       55,   66,  -18,       60,   52,  -10,
      67,   35,   -1,       74,   18,   10,       82,    1,   21,       91,  -15,   33,
      52,   82,  -24,       53,   78,  -21,       56,   68,  -16,       61,   55,   -9,
      68,   38,    1,       75,   21,   11,       83,    4,   22,       91,  -12,   33,
      53,   84,  -21,       55,   80,  -19,       58,   71,  -14,       63,   58,   -7,
      69,   41,    3,       76,   25,   13,       84,    8,   23,       92,   -9,   35,
      55,   86,  -18,       56,   82,  -16,       59,   73,  -12,       64,   60,   -5,
      70,   44,    4,       77,   28,   14,       84,   11,   24,       93,   -6,   35,
      56,   87,  -16,       58,   83,  -14,       61,   75,   -9,       65,   63,   -3,
      71,   47,    6,       78,   31,   15,       85,   14,   26,       93,   -3,   36,
      21,   57,  -80,       25,   44,  -72,       34,   22,  -58,       43,    1,  -43,
      53,  -18,  -27,       63,  -35,  -12,       73,  -49,    3,       83,  -61,   17,
      21,   57,  -79,       26,   44,  -72,       34,   22,  -58,       43,    1,  -43,
      53,  -18,  -27,       63,  -34,  -12,       73,  -48,    3,       83,  -61,   17,
      21,   57,  -79,       26,   44,  -71,       34,   23,  -58,       43,    2,  -43,
      53,  -18,  -27,       63,  -34,  -12,       73,  -48,    3,       83,  -61,   17,
      22,   57,  -78,       26,   44,  -71,       34,   23,  -58,       43,    2,  -43,
      53,  -17,  -27,       63,  -33,  -12,       73,  -48,    3,       83,  -61,   17,
      22,   58,  -77,       26,   45,  -70,       34,   24,  -57,       43,    3,  -42,
      54,  -16,  -27,       63,  -33,  -12,       73,  -47,    3,       83,  -60,   17,
      23,   58,  -77,       27,   45,  -70,       35,   25,  -57,       44,    4,  -42,
      54,  -16,  -26,       64,  -32,  -11,       73,  -46,    3,       83,  -60,   17,
      23,   58,  -76,       27,   46,  -69,       35,   26,  -56,       44,    5,  -42,
      54,  -15,  -26,       64,  -31,  -11,       73,  -46,    3,       83,  -59,   18,
      24,   59,  -74,       28,   47,  -68,       35,   27,  -55,       44,    6,  -41,
      54,  -13,  -26,       64,  -30,  -11,       74,  -44,    4,       84,  -58,   18,
      25,   59,  -73,       29,   48,  -66,       36,   28,  -55,       45,    8,  -40,
      54,  -12,  -25,       64,  -29,  -10,       74,  -43,    4,       84,  -57,   18,
      26,   60,  -71,       29,   49,  -65,       36,   30,  -54,       45,   10,  -40,
      55,  -10,  -25,       64,  -27,  -10,       74,  -42,    4,       84,  -56,   18,
      27,   60,  -70,       30,   50,  -64,       37,   32,  -53,       46,   11,  -39,
      55,   -8,  -24,       65,  -25,  -10,       74,  -41,    4,       84,  -54,   18,
      28,   61,  -68,       31,   51,  -62,       38,   33,  -51,       46,   13,  -38,
      55,   -6,  -23,       65,  -24,   -9,       74,  -39,    5,       84,  -53,   19,
      29,   62,  -66,       32,   53,  -60,       39,   35,  -50,       47,   16,  -37,
      56,   -4,  -23,       65,  -21,   -9,       75,  -37,    5,       85,  -51,   19,
      30,   63,  -64,       33,   54,  -59,       39,   37,  -49,       47,   18,  -36,
      56,   -2,  -22,       66,  -19,   -8,       75,  -35,    6,       85,  -50,   20,
      31,   64,  -62,       34,   55,  -57,       40,   39,  -47,       48,   20,  -35,
      57,    0,  -21,       66,  -17,   -7,       75,  -33,    6,       85,  -48,   20,
      33,   65,  -59,       35,   57,  -55,       41,   41,  -46,       49,   22,  -34,
      57,    3,  -20,       67,  -15,   -7,       76,  -31,    7,       85,  -46,   20,
      34,   66,  -57,       37,   58,  -53,       42,   43,  -44,       50,   25,  -32,
      58,    6,  -19,       67,  -12,   -6,       76,  -28,    8,       86,  -44,   21,
      36,   67,  -55,       38,   60,  -51,       43,   45,  -42,       50,   28,  -31,
      59,    8,  -18,       68,  -10,   -5,       77,  -26,    8,       86,  -41,   21,
      37,   69,  -52,       39,   62,  -49,       44,   48,  -40,       51,   30,  -30,
      59,   11,  -17,       68,   -7,   -4,       77,  -24,    9,       86,  -39,   22,
      38,   70,  -50,       41,   63,  -46,       45,   50,  -39,       52,   33,  -28,
      60,   14,  -16,       69,   -4,   -3,       77,  -21,   10,       87,  -37,   23,
      40,   71,  -47,       42,   65,  -44,       47,   52,  -37,       53,   35,  -27,
      61,   17,  -15,       69,   -1,   -2,       78,  -18,   10,       87,  -34,   23,
      41,   73,  -45,       43,   67,  -42,       48,   54,  -35,       54,   38,  -25,
      62,   19,  -13,       70,    2,   -1,       79,  -15,   11,       88,  -31,   24,
      43,   74,  -43,       45,   68,  -40,       49,   56,  -33,       55,   40,  -23,
      63,   22,  -12,       71,    4,    0,       79,  -12,   12,       88,  -29,   25,
      44,   75,  -40,       46,   70,  -37,       50,   58,  -31,       56,   43,  -22,
      63,   25,  -11,       71,    7,    1,       80,  -10,   13,       89,  -26,   25,
      46,   77,  -38,       48,   72,  -35,       51,   61,  -29,       57,   46,  -20,
      64,   28,   -9,       72,   10,    2,       80,   -7,   14,       89,  -23,   26,
      47,   79,  -35,       49,   74,  -32,       53,   63,  -27,       58,   48,  -18,
      65,   31,   -8,       73,   14,    3,       81,   -3,   15,       90,  -20,   27,
      49,   80,  -33,       50,   75,  -30,       54,   65,  -24,       59,   51,  -16,
      66,   34,   -6,       74,   17,    5,       82,   -1,   16,       90,  -17,   28,
      50,   82,  -30,       52,   77,  -28,       55,   67,  -22,       60,   53,  -15,
      67,   37,   -5,       74,   19,    6,       82,    2,   17,       91,  -14,   29,
      52,   83,  -28,       53,   79,  -25,       57,   69,  -20,       62,   56,  -13,
      68,   39,   -3,       75,   22,    7,       83,    5,   18,       91,  -11,   30,
      54,   85,  -25,       55,   81,  -23,       58,   72,  -18,       63,   59,  -11,
      69,   43,   -2,       76,   26,    9,       84,    9,   19,       92,   -8,   31,
      55,   86,  -23,       56,   82,  -20,       59,   74,  -16,       64,   61,   -9,
      70,   45,    0,       77,   29,   10,       85,   12,   20,       93,   -5,   32,
      57,   88,  -20,       58,   84,  -18,       61,   76,  -14,       65,   63,   -7,
      71,   48,    2,       78,   32,   11,       85,   15,   22,       93,   -2,   33,
      22,   59,  -82,       26,   46,  -75,       34,   25,  -62,       43,    4,  -47,
      54,  -16,  -31,       63,  -32,  -16,       73,  -46,   -1,       83,  -60,   13,
      22,   59,  -82,       26,   47,  -75,       34,   26,  -62,       43,    4,  -47,
      54,  -15,  -31,       63,  -32,  -16,       73,  -46,   -1,       83,  -59,   13,
      22,   59,  -82,       27,   47,  -75,       34,   26,  -62,       44,    5,  -47,
      54,  -15,  -31,       64,  -31,  -16,       73,  -46,   -1,       83,  -59,   13,
      23,   60,  -81,       27,   47,  -74,       35,   26,  -61,       44,    5,  -47,
      54,  -14,  -31,       64,  -31,  -16,       73,  -45,   -1,       83,  -59,   13,
      23,   60,  -80,       27,   48,  -74,       35,   27,  -61,       44,    6,  -46,
      54,  -14,  -31,       64,  -30,  -16,       73,  -45,   -1,       83,  -58,   13,
      24,   60,  -80,       28,   48,  -73,       35,   28,  -61,       44,    7,  -46,
      54,  -13,  -30,       64,  -30,  -15,       74,  -44,   -1,       84,  -58,   13,
      24,   60,  -79,       28,   49,  -72,       36,   29,  -60,       44,    8,  -46,
      54,  -12,  -30,       64,  -29,  -15,       74,  -43,   -1,       84,  -57,   14,
      25,   61,  -77,       29,   49,  -71,       36,   30,  -59,       45,    9,  -45,
      54,  -10,  -30,       64,  -27,  -15,       74,  -42,    0,       84,  -56,   14,
      26,   61,  -76,       29,   50,  -70,       36,   31,  -58,       45,   11,  -44,
      55,   -9,  -29,       64,  -26,  -15,       74,  -41,    0,       84,  -55,   14,
      27,   62,  -74,       30,   51,  -69,       37,   33,  -57,       45,   12,  -44,
      55,   -8,  -29,       65,  -25,  -14,       74,  -40,    0,       84,  -54,   14,
      28,   62,  -73,       31,   52,  -67,       38,   34,  -56,       46,   14,  -43,
      55,   -6,  -28,       65,  -23,  -14,       74,  -39,    0,       84,  -53,   15,
      29,   63,  -71,       32,   53,  -66,       38,   36,  -55,       46,   16,  -42,
      56,   -4,  -28,       65,  -21,  -13,       75,  -37,    1,       84,  -51,   15,
      30,   64,  -69,       33,   55,  -64,       39,   38,  -54,       47,   18,  -41,
      56,   -2,  -27,       66,  -19,  -13,       75,  -35,    1,       85,  -50,   15,
      31,   65,  -67,       34,   56,  -62,       40,   39,  -52,       48,   20,  -40,
      57,    0,  -26,       66,  -17,  -12,       75,  -33,    2,       85,  -48,   16,
      32,   66,  -65,       35,   57,  -60,       41,   41,  -51,       48,   22,  -39,
      57,    3,  -25,       66,  -15,  -11,       76,  -31,    2,       85,  -46,   16,
      33,   67,  -63,       36,   59,  -59,       42,   43,  -50,       49,   24,  -38,
      58,    5,  -24,       67,  -13,  -11,       76,  -29,    3,       85,  -44,   16,
      35,   68,  -61,       37,   60,  -56,       43,   45,  -48,       50,   27,  -36,
      58,    8,  -23,       67,  -10,  -10,       76,  -27,    4,       86,  -42,   17,
      36,   69,  -58,       39,   62,  -54,       44,   47,  -46,       51,   29,  -35,
      59,   10,  -22,       68,   -8,   -9,       77,  -24,    4,       86,  -40,   18,
      37,   70,  -56,       40,   63,  -52,       45,   49,  -44,       52,   32,  -34,
      60,   13,  -21,       68,   -5,   -8,       77,  -22,    5,       87,  -38,   18,
      39,   71,  -54,       41,   65,  -50,       46,   51,  -43,       52,   34,  -32,
      60,   15,  -20,       69,   -3,   -7,       78,  -19,    6,       87,  -35,   19,
      40,   73,  -51,       43,   66,  -48,       47,   54,  -41,       53,   37,  -31,
      61,   18,  -19,       70,    0,   -6,       78,  -16,    6,       87,  -33,   19,
      42,   74,  -49,       44,   68,  -46,       48,   56,  -39,       54,   39,  -29,
      62,   21,  -17,       70,    3,   -5,       79,  -14,    7,       88,  -30,   20,
      43,   75,  -47,       45,   70,  -44,       49,   58,  -37,       55,   42,  -28,
      63,   24,  -16,       71,    6,   -4,       79,  -11,    8,       88,  -27,   21,
      45,   77,  -44,       47,   71,  -41,       51,   60,  -35,       56,   44,  -26,
      64,   27,  -15,       71,    9,   -3,       80,   -8,    9,       89,  -25,   21,
      46,   78,  -42,       48,   73,  -39,       52,   62,  -33,       57,   47,  -24,
      64,   29,  -14,       72,   12,   -2,       80,   -5,   10,       89,  -22,   22,
      48,   80,  -39,       49,   75,  -37,       53,   64,  -31,       59,   50,  -22,
      65,   32,  -12,       73,   15,   -1,       81,   -2,   11,       90,  -19,   23,
      49,   81,  -37,       51,   76,  -34,       54,   66,  -29,       60,   52,  -21,
      66,   35,  -10,       74,   18,    1,       82,    1,   12,       90,  -16,   24,
      51,   82,  -34,       52,   78,  -32,       56,   68,  -27,       61,   55,  -19,
      67,   38,   -9,       75,   21,    2,       82,    4,   13,       91,  -13,   25,
      52,   84,  -32,       54,   80,  -30,       57,   70,  -24,       62,   57,  -17,
      68,   41,   -7,       75,   24,    3,       83,    7,   14,       91,  -10,   26,
      54,   86,  -29,       55,   82,  -27,       58,   73,  -22,       63,   60,  -15,
      69,   44,   -6,       76,   27,    5,       84,   10,   15,       92,   -7,   27,
      55,   87,  -27,       57,   83,  -25,       60,   75,  -20,       64,   62,  -13,
      70,   46,   -4,       77,   30,    6,       85,   13,   16,       93,   -4,   28,
      57,   89,  -24,       58,   85,  -22,       61,   77,  -18,       66,   64,  -11,
      71,   49,   -2,       78,   33,    7,       85,   16,   18,       93,   -1,   29,
      23,   61,  -85,       27,   49,  -78,       35,   28,  -66,       44,    7,  -51,
      54,  -13,  -35,       64,  -29,  -20,       73,  -44,   -5,       83,  -58,    9,
      23,   61,  -85,       27,   49,  -78,       35,   29,  -66,       44,    8,  -51,
      54,  -12,  -35,       64,  -29,  -20,       74,  -44,   -5,       84,  -57,    9,
      24,   62,  -84,       28,   49,  -78,       35,   29,  -65,       44,    8,  -51,
      54,  -12,  -35,       64,  -29,  -20,       74,  -44,   -5,       84,  -57,    9,
      24,   62,  -84,       28,   50,  -77,       35,   30,  -65,       44,    8,  -51,
      54,  -11,  -35,       64,  -28,  -20,       74,  -43,   -5,       84,  -57,    9,
      24,   62,  -83,       28,   50,  -77,       36,   30,  -65,       44,    9,  -50,
      54,  -11,  -35,       64,  -28,  -20,       74,  -43,   -5,       84,  -56,    9,
      25,   62,  -83,       29,   51,  -76,       36,   31,  -64,       45,   10,  -50,
      54,  -10,  -34,       64,  -27,  -19,       74,  -42,   -5,       84,  -56,   10,
      25,   62,  -82,       29,   51,  -75,       36,   32,  -64,       45,   11,  -50,
      55,   -9,  -34,       64,  -26,  -19,       74,  -41,   -5,       84,  -55,   10,
      26,   63,  -80,       30,   52,  -74,       37,   33,  -63,       45,   12,  -49,
      55,   -8,  -34,       64,  -25,  -19,       74,  -40,   -4,       84,  -54,   10,
      27,   63,  -79,       30,   53,  -73,       37,   34,  -62,       46,   14,  -48,
      55,   -6,  -33,       65,  -24,  -19,       74,  -39,   -4,       84,  -53,   10,
      28,   64,  -78,       31,   54,  -72,       38,   35,  -61,       46,   15,  -48,
      55,   -5,  -33,       65,  -22,  -18,       74,  -38,   -4,       84,  -52,   10,
      28,   64,  -76,       32,   54,  -71,       38,   37,  -60,       46,   17,  -47,
      56,   -3,  -32,       65,  -21,  -18,       75,  -37,   -4,       84,  -51,   11,
      29,   65,  -74,       33,   55,  -69,       39,   38,  -59,       47,   18,  -46,
      56,   -2,  -32,       65,  -19,  -17,       75,  -35,   -3,       85,  -50,   11,
      31,   66,  -72,       34,   57,  -68,       40,   40,  -58,       48,   20,  -45,
      57,    1,  -31,       66,  -17,  -17,       75,  -33,   -3,       85,  -48,   11,
      32,   66,  -71,       35,   58,  -66,       41,   42,  -56,       48,   22,  -44,
      57,    3,  -30,       66,  -15,  -16,       75,  -31,   -2,       85,  -46,   12,
      33,   67,  -69,       36,   59,  -64,       41,   43,  -55,       49,   24,  -43,
      58,    5,  -29,       67,  -13,  -15,       76,  -29,   -2,       85,  -44,   12,
      34,   68,  -67,       37,   60,  -62,       42,   45,  -53,       49,   27,  -42,
      58,    7,  -28,       67,  -11,  -15,       76,  -27,   -1,       86,  -43,   13,
      36,   69,  -64,       38,   62,  -60,       43,   47,  -52,       50,   29,  -40,
      59,   10,  -27,       68,   -8,  -14,       77,  -25,    0,       86,  -40,   13,
      37,   70,  -62,       39,   63,  -58,       44,   49,  -50,       51,   31,  -39,
      59,   12,  -26,       68,   -6,  -13,       77,  -23,    0,       86,  -38,   14,
      38,   71,  -60,       40,   65,  -56,       45,   51,  -48,       52,   34,  -38,
      60,   15,  -25,       69,   -3,  -12,       77,  -20,    1,       87,  -36,   14,
      39,   73,  -58,       42,   66,  -54,       46,   53,  -47,       53,   36,  -36,
      61,   17,  -24,       69,   -1,  -11,       78,  -18,    2,       87,  -34,   15,
      41,   74,  -55,       43,   68,  -52,       48,   55,  -45,       54,   39,  -35,
      62,   20,  -23,       70,    2,  -10,       78,  -15,    2,       88,  -31,   15,
      42,   75,  -53,       44,   69,  -50,       49,   57,  -43,       55,   41,  -33,
      62,   23,  -22,       70,    5,   -9,       79,  -12,    3,       88,  -29,   16,
      44,   76,  -51,       46,   71,  -47,       50,   59,  -41,       56,   43,  -32,
      63,   25,  -20,       71,    8,   -8,       79,  -10,    4,       88,  -26,   17,
      45,   78,  -48,       47,   72,  -45,       51,   61,  -39,       57,   46,  -30,
      64,   28,  -19,       72,   10,   -7,       80,   -7,    5,       89,  -23,   18,
      47,   79,  -46,       48,   74,  -43,       52,   63,  -37,       58,   48,  -28,
      65,   31,  -18,       72,   13,   -6,       81,   -4,    6,       89,  -21,   18,
      48,   81,  -43,       50,   76,  -41,       54,   65,  -35,       59,   51,  -26,
      66,   34,  -16,       73,   16,   -5,       81,   -1,    7,       90,  -18,   19,
      50,   82,  -41,       51,   77,  -38,       55,   67,  -33,       60,   53,  -25,
      67,   36,  -15,       74,   19,   -4,       82,    2,    8,       90,  -15,   20,
      51,   83,  -38,       53,   79,  -36,       56,   69,  -31,       61,   56,  -23,
      68,   39,  -13,       75,   22,   -2,       83,    5,    9,       91,  -12,   21,
      53,   85,  -36,       54,   81,  -34,       57,   71,  -29,       62,   58,  -21,
      69,   42,  -12,       76,   25,   -1,       83,    8,   10,       92,   -9,   22,
      54,   87,  -33,       56,   83,  -31,       59,   74,  -26,       63,   61,  -19,
      70,   45,  -10,       77,   28,    0,       84,   11,   11,       92,   -6,   23,
      56,   88,  -31,       57,   84,  -29,       60,   75,  -24,       65,   63,  -17,
      71,   47,   -8,       77,   31,    2,       85,   14,   12,       93,   -3,   24,
      57,   90,  -28,       58,   86,  -26,       61,   77,  -22,       66,   65,  -15,
      72,   50,   -7,       78,   34,    3,       86,   17,   14,       94,    0,   25,
      24,   63,  -88,       28,   52,  -81,       36,   32,  -69,       44,   11,  -55,
      54,  -10,  -39,       64,  -27,  -24,       74,  -42,   -9,       84,  -56,    5,
      25,   64,  -88,       28,   52,  -81,       36,   32,  -69,       44,   11,  -55,
      54,   -9,  -39,       64,  -26,  -24,       74,  -42,   -9,       84,  -55,    5,
      25,   64,  -87,       29,   52,  -81,       36,   32,  -69,       45,   11,  -55,
      54,   -9,  -39,       64,  -26,  -24,       74,  -41,   -9,       84,  -55,    5,
      25,   64,  -87,       29,   52,  -80,       36,   33,  -69,       45,   12,  -54,
      54,   -8,  -39,       64,  -26,  -24,       74,  -41,   -9,       84,  -55,    5,
      25,   64,  -86,       29,   53,  -80,       36,   33,  -68,       45,   12,  -54,
      55,   -8,  -39,       64,  -25,  -24,       74,  -40,   -9,       84,  -54,    5,
      26,   64,  -85,       29,   53,  -79,       36,   34,  -68,       45,   13,  -54,
      55,   -7,  -38,       64,  -24,  -23,       74,  -40,   -9,       84,  -54,    6,
      26,   64,  -85,       30,   54,  -79,       37,   35,  -67,       45,   14,  -53,
      55,   -6,  -38,       65,  -24,  -23,       74,  -39,   -9,       84,  -53,    6,
      27,   65,  -83,       31,   54,  -78,       37,   36,  -66,       46,   15,  -53,
      55,   -5,  -38,       65,  -22,  -23,       74,  -38,   -8,       84,  -52,    6,
      28,   65,  -82,       31,   55,  -76,       38,   37,  -66,       46,   16,  -52,
      55,   -4,  -37,       65,  -21,  -23,       74,  -37,   -8,       84,  -51,    6,
      29,   66,  -81,       32,   56,  -75,       38,   38,  -65,       46,   18,  -52,
      56,   -2,  -37,       65,  -20,  -22,       75,  -36,   -8,       84,  -50,    6,
      29,   66,  -79,       33,   57,  -74,       39,   39,  -64,       47,   19,  -51,
      56,   -1,  -36,       65,  -19,  -22,       75,  -34,   -8,       85,  -49,    7,
      30,   67,  -78,       33,   58,  -73,       40,   41,  -63,       47,   21,  -50,
      56,    1,  -36,       66,  -17,  -21,       75,  -33,   -7,       85,  -48,    7,
      31,   67,  -76,       34,   59,  -71,       40,   42,  -61,       48,   23,  -49,
      57,    3,  -35,       66,  -15,  -21,       75,  -31,   -7,       85,  -46,    7,
      33,   68,  -74,       35,   60,  -69,       41,   44,  -60,       49,   25,  -48,
      57,    5,  -34,       66,  -13,  -20,       76,  -29,   -6,       85,  -44,    8,
      34,   69,  -72,       36,   61,  -68,       42,   45,  -59,       49,   27,  -47,
      58,    7,  -33,       67,  -11,  -19,       76,  -27,   -6,       86,  -43,    8,
      35,   70,  -70,       37,   62,  -66,       43,   47,  -57,       50,   29,  -46,
      58,    9,  -32,       67,   -9,  -19,       76,  -25,   -5,       86,  -41,    9,
      36,   71,  -68,       39,   64,  -64,       44,   49,  -56,       51,   31,  -44,
      59,   12,  -31,       68,   -6,  -18,       77,  -23,   -4,       86,  -39,    9,
      37,   72,  -66,       40,   65,  -62,       45,   51,  -54,       52,   33,  -43,
      60,   14,  -30,       68,   -4,  -17,       77,  -21,   -4,       87,  -37,   10,
      39,   73,  -64,       41,   66,  -60,       46,   53,  -52,       52,   36,  -42,
      60,   17,  -29,       69,   -2,  -16,       78,  -18,   -3,       87,  -34,   10,
      40,   74,  -61,       42,   68,  -58,       47,   55,  -51,       53,   38,  -40,
      61,   19,  -28,       69,    1,  -15,       78,  -16,   -2,       87,  -32,   11,
      42,   75,  -59,       44,   69,  -56,       48,   57,  -49,       54,   40,  -39,
      62,   22,  -27,       70,    4,  -14,       79,  -13,   -2,       88,  -30,   12,
      43,   76,  -57,       45,   71,  -54,       49,   59,  -47,       55,   43,  -37,
      63,   24,  -26,       71,    6,  -13,       79,  -11,   -1,       88,  -27,   12,
      44,   78,  -54,       46,   72,  -51,       50,   61,  -45,       56,   45,  -36,
      63,   27,  -24,       71,    9,  -12,       80,   -8,    0,       89,  -25,   13,
      46,   79,  -52,       47,   74,  -49,       51,   62,  -43,       57,   47,  -34,
      64,   30,  -23,       72,   12,  -11,       80,   -5,    1,       89,  -22,   14,
      47,   80,  -50,       49,   75,  -47,       53,   64,  -41,       58,   50,  -32,
      65,   32,  -22,       73,   15,  -10,       81,   -3,    2,       90,  -19,   14,
      49,   82,  -47,       50,   77,  -45,       54,   67,  -39,       59,   52,  -31,
      66,   35,  -20,       73,   18,   -9,       82,    0,    3,       90,  -16,   15,
      50,   83,  -45,       52,   79,  -42,       55,   69,  -37,       60,   55,  -29,
      67,   38,  -19,       74,   20,   -8,       82,    3,    4,       91,  -14,   16,
      52,   84,  -42,       53,   80,  -40,       56,   70,  -35,       61,   57,  -27,
      68,   40,  -17,       75,   23,   -6,       83,    6,    5,       91,  -11,   17,
      53,   86,  -40,       54,   82,  -38,       58,   72,  -33,       62,   59,  -25,
      69,   43,  -16,       76,   26,   -5,       83,    9,    6,       92,   -8,   18,
      55,   88,  -37,       56,   84,  -35,       59,   75,  -30,       64,   62,  -23,
      70,   46,  -14,       77,   29,   -4,       84,   12,    7,       92,   -5,   19,
      56,   89,  -35,       57,   85,  -33,       60,   77,  -28,       65,   64,  -21,
      71,   49,  -12,       78,   32,   -2,       85,   15,    8,       93,   -2,   20,
      58,   90,  -33,       59,   87,  -31,       62,   78,  -26,       66,   66,  -19,
      72,   51,  -11,       78,   35,   -1,       86,   18,   10,       94,    1,   21,
      26,   66,  -91,       29,   55,  -85,       36,   35,  -73,       45,   14,  -59,
      55,   -6,  -44,       64,  -24,  -29,       74,  -39,  -14,       84,  -53,    1,
      26,   66,  -91,       29,   55,  -85,       37,   35,  -73,       45,   14,  -59,
      55,   -6,  -44,       64,  -23,  -28,       74,  -39,  -14,       84,  -53,    1,
      26,   66,  -90,       30,   55,  -84,       37,   36,  -73,       45,   15,  -59,
      55,   -6,  -43,       64,  -23,  -28,       74,  -39,  -14,       84,  -53,    1,
      26,   66,  -90,       30,   55,  -84,       37,   36,  -72,       45,   15,  -59,
      55,   -5,  -43,       64,  -23,  -28,       74,  -38,  -14,       84,  -53,    1,
      27,   66,  -89,       30,   56,  -83,       37,   36,  -72,       45,   16,  -58,
      55,   -5,  -43,       65,  -22,  -28,       74,  -38,  -14,       84,  -52,    1,
      27,   66,  -89,       31,   56,  -83,       37,   37,  -72,       46,   16,  -58,
      55,   -4,  -43,       65,  -22,  -28,       74,  -37,  -13,       84,  -52,    1,
      28,   67,  -88,       31,   56,  -82,       38,   38,  -71,       46,   17,  -58,
      55,   -3,  -43,       65,  -21,  -28,       74,  -36,  -13,       84,  -51,    1,
      28,   67,  -87,       32,   57,  -81,       38,   39,  -70,       46,   18,  -57,
      56,   -2,  -42,       65,  -20,  -27,       75,  -35,  -13,       84,  -50,    2,
      29,   67,  -86,       32,   58,  -80,       39,   40,  -70,       47,   20,  -56,
      56,   -1,  -42,       65,  -18,  -27,       75,  -34,  -13,       84,  -49,    2,
      30,   68,  -84,       33,   58,  -79,       39,   41,  -69,       47,   21,  -56,
      56,    1,  -41,       65,  -17,  -27,       75,  -33,  -12,       85,  -48,    2,
      30,   68,  -83,       33,   59,  -78,       40,   42,  -68,       47,   22,  -55,
      57,    2,  -41,       66,  -16,  -26,       75,  -32,  -12,       85,  -47,    2,
      31,   69,  -81,       34,   60,  -76,       40,   43,  -67,       48,   24,  -54,
      57,    4,  -40,       66,  -14,  -26,       75,  -30,  -12,       85,  -46,    3,
      32,   69,  -79,       35,   61,  -75,       41,   45,  -65,       49,   26,  -53,
      57,    6,  -39,       66,  -12,  -25,       76,  -29,  -11,       85,  -44,    3,
      33,   70,  -78,       36,   62,  -73,       42,   46,  -64,       49,   28,  -52,
      58,    8,  -38,       67,  -10,  -25,       76,  -27,  -11,       86,  -42,    3,
      35,   71,  -76,       37,   63,  -72,       43,   48,  -63,       50,   29,  -51,
      58,   10,  -38,       67,   -9,  -24,       76,  -25,  -10,       86,  -41,    4,
      36,   72,  -74,       38,   64,  -70,       43,   49,  -61,       50,   31,  -50,
      59,   12,  -37,       68,   -6,  -23,       77,  -23,  -10,       86,  -39,    4,
      37,   73,  -72,       39,   66,  -68,       44,   51,  -60,       51,   34,  -49,
      59,   14,  -36,       68,   -4,  -22,       77,  -21,   -9,       86,  -37,    5,
      38,   74,  -70,       40,   67,  -66,       45,   53,  -58,       52,   36,  -48,
      60,   16,  -35,       69,   -2,  -22,       77,  -19,   -8,       87,  -35,    5,
      39,   75,  -68,       42,   68,  -64,       46,   55,  -57,       53,   38,  -46,
      61,   19,  -34,       69,    1,  -21,       78,  -16,   -8,       87,  -33,    6,
      41,   76,  -66,       43,   69,  -62,       47,   57,  -55,       54,   40,  -45,
      61,   21,  -33,       70,    3,  -20,       78,  -14,   -7,       87,  -30,    6,
      42,   77,  -63,       44,   71,  -60,       49,   59,  -53,       55,   42,  -43,
      62,   24,  -31,       70,    6,  -19,       79,  -11,   -6,       88,  -28,    7,
      44,   78,  -61,       45,   72,  -58,       50,   60,  -51,       56,   45,  -42,
      63,   26,  -30,       71,    8,  -18,       79,   -9,   -5,       88,  -25,    8,
      45,   79,  -59,       47,   74,  -56,       51,   62,  -49,       56,   47,  -40,
      64,   29,  -29,       72,   11,  -17,       80,   -6,   -4,       89,  -23,    8,
      46,   80,  -56,       48,   75,  -54,       52,   64,  -47,       57,   49,  -39,
      65,   31,  -28,       72,   14,  -16,       80,   -4,   -4,       89,  -20,    9,
      48,   82,  -54,       49,   77,  -51,       53,   66,  -45,       58,   51,  -37,
      65,   34,  -26,       73,   16,  -15,       81,   -1,   -3,       90,  -18,   10,
      49,   83,  -51,       51,   78,  -49,       54,   68,  -43,       60,   54,  -35,
      66,   37,  -25,       74,   19,  -13,       82,    2,   -2,       90,  -15,   11,
      51,   84,  -49,       52,   80,  -47,       56,   70,  -41,       61,   56,  -33,
      67,   39,  -23,       75,   22,  -12,       82,    5,   -1,       91,  -12,   12,
      52,   86,  -47,       53,   81,  -44,       57,   72,  -39,       62,   58,  -32,
      68,   42,  -22,       75,   25,  -11,       83,    8,    1,       91,   -9,   13,
      53,   87,  -44,       55,   83,  -42,       58,   74,  -37,       63,   61,  -30,
      69,   44,  -20,       76,   28,  -10,       84,   10,    2,       92,   -7,   14,
      55,   89,  -42,       56,   85,  -40,       60,   76,  -35,       64,   63,  -28,
      70,   47,  -18,       77,   31,   -8,       85,   14,    3,       93,   -3,   15,
      56,   90,  -39,       58,   86,  -37,       61,   78,  -33,       65,   65,  -26,
      71,   50,  -17,       78,   33,   -7,       85,   16,    4,       93,   -1,   16,
      58,   91,  -37,       59,   88,  -35,       62,   80,  -31,       66,   68,  -24,
      72,   52,  -15,       79,   36,   -5,       86,   19,    5,       94,    2,   17,
      27,   68,  -94,       30,   57,  -88,       37,   38,  -77,       46,   17,  -63,
      55,   -3,  -47,       65,  -21,  -32,       74,  -37,  -18,       84,  -51,   -3,
      27,   68,  -93,       30,   57,  -88,       37,   38,  -76,       46,   18,  -63,
      55,   -3,  -47,       65,  -21,  -32,       74,  -36,  -18,       84,  -51,   -3,
      27,   68,  -93,       31,   57,  -87,       37,   39,  -76,       46,   18,  -62,
      55,   -3,  -47,       65,  -20,  -32,       74,  -36,  -18,       84,  -51,   -3,
      27,   68,  -93,       31,   58,  -87,       38,   39,  -76,       46,   18,  -62,
      55,   -2,  -47,       65,  -20,  -32,       74,  -36,  -18,       84,  -50,   -3,
      28,   68,  -92,       31,   58,  -86,       38,   39,  -76,       46,   19,  -62,
      55,   -2,  -47,       65,  -19,  -32,       74,  -35,  -17,       84,  -50,   -3,
      28,   68,  -91,       31,   58,  -86,       38,   40,  -75,       46,   20,  -62,
      56,   -1,  -47,       65,  -19,  -32,       75,  -35,  -17,       84,  -49,   -3,
      29,   69,  -91,       32,   59,  -85,       38,   41,  -75,       46,   20,  -61,
      56,    0,  -46,       65,  -18,  -32,       75,  -34,  -17,       84,  -49,   -3,
      29,   69,  -90,       32,   59,  -84,       39,   42,  -74,       47,   21,  -61,
      56,    1,  -46,       65,  -17,  -31,       75,  -33,  -17,       85,  -48,   -2,
      30,   69,  -88,       33,   60,  -83,       39,   42,  -73,       47,   22,  -60,
      56,    2,  -46,       66,  -16,  -31,       75,  -32,  -17,       85,  -47,   -2,
      31,   70,  -87,       34,   61,  -82,       40,   43,  -72,       48,   24,  -60,
      57,    3,  -45,       66,  -15,  -31,       75,  -31,  -16,       85,  -46,   -2,
      31,   70,  -86,       34,   61,  -81,       40,   45,  -71,       48,   25,  -59,
      57,    5,  -45,       66,  -13,  -30,       75,  -30,  -16,       85,  -45,   -2,
      32,   71,  -84,       35,   62,  -80,       41,   46,  -70,       48,   27,  -58,
      57,    6,  -44,       66,  -12,  -30,       76,  -28,  -16,       85,  -44,   -1,
      33,   71,  -83,       36,   63,  -78,       42,   47,  -69,       49,   28,  -57,
      58,    8,  -43,       67,  -10,  -29,       76,  -27,  -15,       85,  -42,   -1,
      34,   72,  -81,       37,   64,  -77,       42,   49,  -68,       50,   30,  -56,
      58,   10,  -42,       67,   -8,  -29,       76,  -25,  -15,       86,  -40,   -1,
      35,   73,  -79,       38,   65,  -75,       43,   50,  -66,       50,   32,  -55,
      59,   12,  -42,       67,   -6,  -28,       77,  -23,  -14,       86,  -39,    0,
      36,   73,  -77,       39,   66,  -73,       44,   52,  -65,       51,   34,  -54,
      59,   14,  -41,       68,   -4,  -27,       77,  -21,  -14,       86,  -37,    0,
      38,   74,  -75,       40,   67,  -71,       45,   53,  -63,       52,   36,  -53,
      60,   16,  -40,       68,   -2,  -26,       77,  -19,  -13,       87,  -35,    1,
      39,   75,  -73,       41,   68,  -70,       46,   55,  -62,       52,   38,  -51,
      60,   19,  -39,       69,    0,  -26,       78,  -17,  -12,       87,  -33,    1,
      40,   76,  -71,       42,   70,  -68,       47,   57,  -60,       53,   40,  -50,
      61,   21,  -38,       69,    3,  -25,       78,  -15,  -12,       87,  -31,    2,
      41,   77,  -69,       43,   71,  -66,       48,   58,  -59,       54,   42,  -49,
      62,   23,  -37,       70,    5,  -24,       79,  -12,  -11,       88,  -29,    3,
      43,   78,  -67,       45,   72,  -64,       49,   60,  -57,       55,   44,  -47,
      63,   26,  -35,       71,    8,  -23,       79,  -10,  -10,       88,  -26,    3,
      44,   79,  -65,       46,   74,  -62,       50,   62,  -55,       56,   46,  -46,
      63,   28,  -34,       71,   10,  -22,       80,   -7,   -9,       89,  -24,    4,
      45,   80,  -62,       47,   75,  -59,       51,   64,  -53,       57,   49,  -44,
      64,   31,  -33,       72,   13,  -21,       80,   -5,   -8,       89,  -21,    5,
      47,   82,  -60,       49,   77,  -57,       52,   66,  -51,       58,   51,  -42,
      65,   33,  -32,       73,   15,  -20,       81,   -2,   -7,       89,  -19,    5,
      48,   83,  -58,       50,   78,  -55,       53,   67,  -49,       59,   53,  -41,
      66,   35,  -30,       73,   18,  -19,       81,    1,   -7,       90,  -16,    6,
      50,   84,  -55,       51,   80,  -53,       55,   69,  -47,       60,   55,  -39,
      67,   38,  -29,       74,   21,  -17,       82,    4,   -5,       91,  -13,    7,
      51,   85,  -53,       53,   81,  -51,       56,   71,  -45,       61,   58,  -37,
      68,   41,  -27,       75,   24,  -16,       83,    6,   -4,       91,  -11,    8,
      52,   87,  -51,       54,   83,  -48,       57,   73,  -43,       62,   60,  -36,
      68,   43,  -26,       76,   26,  -15,       83,    9,   -3,       92,   -8,    9,
      54,   88,  -48,       55,   84,  -46,       58,   75,  -41,       63,   62,  -34,
      69,   46,  -24,       76,   29,  -14,       84,   12,   -2,       92,   -5,   10,
      55,   90,  -46,       57,   86,  -44,       60,   77,  -39,       64,   64,  -32,
      70,   49,  -22,       77,   32,  -12,       85,   15,   -1,       93,   -2,   11,
      57,   91,  -43,       58,   87,  -41,       61,   79,  -37,       66,   67,  -30,
      71,   51,  -21,       78,   35,  -11,       85,   18,    0,       93,    1,   12,
      58,   92,  -41,       60,   89,  -39,       62,   81,  -35,       67,   69,  -28,
      72,   54,  -19,       79,   37,   -9,       86,   21,    1,       94,    3,   13,
      28,   70,  -96,       31,   60,  -91,       38,   41,  -80,       46,   21,  -66,
      56,    0,  -51,       65,  -18,  -36,       75,  -34,  -22,       84,  -49,   -7,
      28,   70,  -96,       31,   60,  -91,       38,   41,  -80,       46,   21,  -66,
      56,    0,  -51,       65,  -18,  -36,       75,  -34,  -22,       84,  -49,   -7,
      28,   70,  -96,       32,   60,  -90,       38,   42,  -80,       46,   21,  -66,
      56,    0,  -51,       65,  -18,  -36,       75,  -34,  -22,       84,  -49,   -7,
      29,   70,  -95,       32,   60,  -90,       38,   42,  -79,       46,   21,  -66,
      56,    1,  -51,       65,  -17,  -36,       75,  -33,  -21,       84,  -48,   -7,
      29,   70,  -95,       32,   60,  -90,       38,   42,  -79,       47,   22,  -66,
      56,    1,  -51,       65,  -17,  -36,       75,  -33,  -21,       84,  -48,   -7,
      29,   70,  -94,       32,   61,  -89,       39,   43,  -78,       47,   23,  -65,
      56,    2,  -50,       65,  -16,  -36,       75,  -32,  -21,       85,  -47,   -7,
      30,   71,  -93,       33,   61,  -88,       39,   43,  -78,       47,   23,  -65,
      56,    3,  -50,       65,  -15,  -36,       75,  -32,  -21,       85,  -47,   -6,
      30,   71,  -92,       33,   62,  -87,       39,   44,  -77,       47,   24,  -64,
      56,    4,  -50,       66,  -14,  -35,       75,  -31,  -21,       85,  -46,   -6,
      31,   71,  -91,       34,   62,  -86,       40,   45,  -76,       48,   25,  -64,
      57,    5,  -49,       66,  -13,  -35,       75,  -30,  -21,       85,  -45,   -6,
      32,   72,  -90,       34,   63,  -85,       40,   46,  -76,       48,   26,  -63,
      57,    6,  -49,       66,  -12,  -35,       75,  -29,  -20,       85,  -44,   -6,
      32,   72,  -89,       35,   63,  -84,       41,   47,  -75,       48,   28,  -62,
      57,    8,  -48,       66,  -11,  -34,       76,  -27,  -20,       85,  -43,   -6,
      33,   72,  -88,       36,   64,  -83,       42,   48,  -74,       49,   29,  -62,
      58,    9,  -48,       67,   -9,  -34,       76,  -26,  -20,       85,  -42,   -5,
      34,   73,  -86,       37,   65,  -81,       42,   50,  -72,       50,   31,  -61,
      58,   11,  -47,       67,   -8,  -33,       76,  -24,  -19,       86,  -40,   -5,
      35,   74,  -84,       38,   66,  -80,       43,   51,  -71,       50,   32,  -60,
      59,   13,  -46,       67,   -6,  -32,       76,  -23,  -19,       86,  -38,   -4,
      36,   74,  -83,       39,   67,  -78,       44,   52,  -70,       51,   34,  -59,
      59,   14,  -45,       68,   -4,  -32,       77,  -21,  -18,       86,  -37,   -4,
      37,   75,  -81,       40,   68,  -77,       45,   54,  -69,       51,   36,  -58,
      60,   16,  -45,       68,   -2,  -31,       77,  -19,  -18,       86,  -35,   -4,
      38,   76,  -79,       41,   69,  -75,       46,   55,  -67,       52,   38,  -56,
      60,   19,  -44,       69,    0,  -30,       78,  -17,  -17,       87,  -33,   -3,
      40,   77,  -77,       42,   70,  -73,       46,   57,  -66,       53,   40,  -55,
      61,   21,  -43,       69,    2,  -30,       78,  -15,  -16,       87,  -31,   -3,
      41,   78,  -75,       43,   71,  -71,       47,   58,  -64,       54,   42,  -54,
      61,   23,  -42,       70,    5,  -29,       78,  -13,  -16,       87,  -29,   -2,
      42,   79,  -73,       44,   73,  -69,       48,   60,  -62,       54,   44,  -53,
      62,   25,  -40,       70,    7,  -28,       79,  -10,  -15,       88,  -27,   -1,
      43,   80,  -70,       45,   74,  -67,       50,   62,  -60,       55,   46,  -51,
      63,   28,  -39,       71,   10,  -27,       79,   -8,  -14,       88,  -24,   -1,
      45,   81,  -68,       47,   75,  -65,       51,   64,  -59,       56,   48,  -49,
      64,   30,  -38,       71,   12,  -26,       80,   -5,  -13,       89,  -22,    0,
      46,   82,  -66,       48,   77,  -63,       52,   65,  -57,       57,   50,  -48,
      64,   32,  -37,       72,   14,  -25,       80,   -3,  -12,       89,  -20,    1,
      47,   83,  -64,       49,   78,  -61,       53,   67,  -55,       58,   52,  -46,
      65,   35,  -35,       73,   17,  -24,       81,    0,  -11,       90,  -17,    1,
      49,   84,  -62,       50,   79,  -59,       54,   69,  -53,       59,   54,  -45,
      66,   37,  -34,       73,   20,  -23,       82,    2,  -10,       90,  -15,    2,
      50,   85,  -59,       52,   81,  -57,       55,   71,  -51,       60,   57,  -43,
      67,   40,  -33,       74,   22,  -21,       82,    5,   -9,       91,  -12,    3,
      52,   87,  -57,       53,   82,  -54,       56,   73,  -49,       61,   59,  -41,
      68,   42,  -31,       75,   25,  -20,       83,    8,   -8,       91,   -9,    4,
      53,   88,  -54,       54,   84,  -52,       58,   74,  -47,       62,   61,  -39,
      69,   45,  -30,       76,   28,  -19,       83,   10,   -7,       92,   -7,    5,
      54,   89,  -52,       56,   85,  -50,       59,   76,  -45,       64,   63,  -38,
      70,   47,  -28,       77,   30,  -18,       84,   13,   -6,       92,   -4,    6,
      56,   91,  -50,       57,   87,  -47,       60,   78,  -43,       65,   66,  -36,
      71,   50,  -26,       78,   33,  -16,       85,   16,   -5,       93,   -1,    7,
      57,   92,  -47,       59,   88,  -45,       61,   80,  -41,       66,   68,  -34,
      72,   52,  -25,       78,   36,  -15,       86,   19,   -4,       94,    2,    8,
      59,   93,  -45,       60,   90,  -43,       63,   82,  -39,       67,   70,  -32,
      73,   55,  -23,       79,   39,  -13,       86,   22,   -3,       94,    5,    9,
      29,   72,  -99,       32,   62,  -94,       39,   44,  -83,       47,   24,  -70,
      56,    3,  -55,       65,  -15,  -40,       75,  -32,  -26,       85,  -47,  -11,
      29,   72,  -99,       32,   62,  -93,       39,   44,  -83,       47,   24,  -70,
      56,    3,  -55,       65,  -15,  -40,       75,  -31,  -26,       85,  -46,  -11,
      29,   72,  -99,       33,   62,  -93,       39,   44,  -83,       47,   24,  -70,
      56,    3,  -55,       65,  -15,  -40,       75,  -31,  -25,       85,  -46,  -11,
      30,   72,  -98,       33,   63,  -93,       39,   45,  -83,       47,   25,  -69,
      56,    4,  -55,       65,  -14,  -40,       75,  -31,  -25,       85,  -46,  -11,
      30,   72,  -98,       33,   63,  -92,       39,   45,  -82,       47,   25,  -69,
      56,    4,  -55,       66,  -14,  -40,       75,  -30,  -25,       85,  -46,  -11,
      30,   72,  -97,       33,   63,  -92,       39,   46,  -82,       47,   26,  -69,
      56,    5,  -54,       66,  -13,  -40,       75,  -30,  -25,       85,  -45,  -10,
      31,   73,  -96,       34,   63,  -91,       40,   46,  -81,       48,   26,  -69,
      57,    6,  -54,       66,  -13,  -39,       75,  -29,  -25,       85,  -44,  -10,
      31,   73,  -95,       34,   64,  -90,       40,   47,  -81,       48,   27,  -68,
      57,    7,  -54,       66,  -12,  -39,       75,  -28,  -25,       85,  -44,  -10,
      32,   73,  -94,       35,   64,  -90,       41,   48,  -80,       48,   28,  -67,
      57,    8,  -53,       66,  -11,  -39,       76,  -27,  -24,       85,  -43,  -10,
      33,   73,  -93,       35,   65,  -89,       41,   49,  -79,       49,   29,  -67,
      57,    9,  -53,       66,   -9,  -38,       76,  -26,  -24,       85,  -42,  -10,
      33,   74,  -92,       36,   66,  -87,       42,   50,  -78,       49,   30,  -66,
      58,   10,  -52,       67,   -8,  -38,       76,  -25,  -24,       85,  -41,   -9,
      34,   74,  -91,       37,   66,  -86,       42,   51,  -77,       49,   32,  -65,
      58,   12,  -52,       67,   -7,  -38,       76,  -24,  -23,       86,  -39,   -9,
      35,   75,  -89,       38,   67,  -85,       43,   52,  -76,       50,   33,  -64,
      59,   13,  -51,       67,   -5,  -37,       76,  -22,  -23,       86,  -38,   -9,
      36,   75,  -87,       38,   68,  -83,       44,   53,  -75,       51,   35,  -63,
      59,   15,  -50,       68,   -3,  -36,       77,  -20,  -22,       86,  -36,   -8,
      37,   76,  -86,       39,   69,  -82,       44,   54,  -74,       51,   36,  -62,
      59,   17,  -49,       68,   -2,  -36,       77,  -19,  -22,       86,  -35,   -8,
      38,   77,  -84,       40,   70,  -80,       45,   56,  -72,       52,   38,  -61,
      60,   19,  -48,       69,    0,  -35,       77,  -17,  -21,       87,  -33,   -7,
      39,   77,  -82,       41,   71,  -78,       46,   57,  -71,       53,   40,  -60,
      61,   21,  -47,       69,    2,  -34,       78,  -15,  -21,       87,  -31,   -7,
      40,   78,  -80,       42,   72,  -77,       47,   59,  -69,       53,   42,  -59,
      61,   23,  -46,       69,    5,  -33,       78,  -13,  -20,       87,  -29,   -6,
      42,   79,  -78,       44,   73,  -75,       48,   60,  -68,       54,   44,  -58,
      62,   25,  -45,       70,    7,  -33,       79,  -11,  -19,       88,  -27,   -6,
      43,   80,  -76,       45,   74,  -73,       49,   62,  -66,       55,   46,  -56,
      62,   27,  -44,       71,    9,  -32,       79,   -8,  -19,       88,  -25,   -5,
      44,   81,  -74,       46,   76,  -71,       50,   64,  -64,       56,   48,  -55,
      63,   30,  -43,       71,   11,  -31,       80,   -6,  -18,       89,  -23,   -5,
      45,   82,  -72,       47,   77,  -69,       51,   65,  -62,       57,   50,  -53,
      64,   32,  -42,       72,   14,  -30,       80,   -4,  -17,       89,  -20,   -4,
      47,   83,  -70,       48,   78,  -67,       52,   67,  -61,       58,   52,  -52,
      65,   34,  -41,       72,   16,  -29,       81,   -1,  -16,       89,  -18,   -3,
      48,   84,  -67,       50,   79,  -65,       53,   69,  -59,       59,   54,  -50,
      66,   36,  -39,       73,   19,  -28,       81,    1,  -15,       90,  -16,   -2,
      49,   85,  -65,       51,   81,  -63,       54,   70,  -57,       60,   56,  -49,
      66,   39,  -38,       74,   21,  -27,       82,    4,  -14,       90,  -13,   -2,
      51,   87,  -63,       52,   82,  -60,       56,   72,  -55,       61,   58,  -47,
      67,   41,  -36,       75,   24,  -25,       82,    7,  -13,       91,  -10,   -1,
      52,   88,  -61,       54,   83,  -58,       57,   74,  -53,       62,   60,  -45,
      68,   44,  -35,       75,   27,  -24,       83,    9,  -12,       91,   -8,    0,
      53,   89,  -58,       55,   85,  -56,       58,   76,  -51,       63,   63,  -43,
      69,   46,  -34,       76,   29,  -23,       84,   12,  -11,       92,   -5,    1,
      55,   90,  -56,       56,   86,  -54,       59,   77,  -49,       64,   65,  -42,
      70,   49,  -32,       77,   32,  -22,       84,   15,  -10,       93,   -3,    2,
      56,   92,  -53,       58,   88,  -51,       61,   79,  -47,       65,   67,  -40,
      71,   51,  -30,       78,   35,  -20,       85,   18,   -9,       93,    0,    3,
      58,   93,  -51,       59,   89,  -49,       62,   81,  -45,       66,   69,  -38,
      72,   54,  -29,       79,   37,  -19,       86,   20,   -8,       94,    3,    4,
      59,   94,  -49,       60,   91,  -47,       63,   83,  -42,       67,   71,  -36,
      73,   56,  -27,       79,   40,  -17,       87,   23,   -7,       94,    6,    5,
      30,   74, -102,       33,   65,  -97,       40,   47,  -87,       47,   27,  -74,
      56,    6,  -59,       66,  -12,  -45,       75,  -29,  -30,       85,  -44,  -15,
      31,   74, -102,       34,   65,  -97,       40,   48,  -87,       47,   27,  -74,
      57,    7,  -59,       66,  -12,  -44,       75,  -28,  -30,       85,  -44,  -15,
      31,   74, -102,       34,   65,  -97,       40,   48,  -86,       48,   28,  -74,
      57,    7,  -59,       66,  -12,  -44,       75,  -28,  -30,       85,  -44,  -15,
      31,   74, -101,       34,   65,  -96,       40,   48,  -86,       48,   28,  -73,
      57,    7,  -59,       66,  -11,  -44,       75,  -28,  -30,       85,  -43,  -15,
      31,   74, -101,       34,   65,  -96,       40,   48,  -86,       48,   28,  -73,
      57,    8,  -59,       66,  -11,  -44,       75,  -27,  -30,       85,  -43,  -15,
      32,   75, -100,       34,   66,  -95,       40,   49,  -85,       48,   29,  -73,
      57,    8,  -58,       66,  -10,  -44,       75,  -27,  -29,       85,  -42,  -15,
      32,   75,  -99,       35,   66,  -95,       41,   49,  -85,       48,   30,  -73,
      57,    9,  -58,       66,   -9,  -44,       76,  -26,  -29,       85,  -42,  -15,
      32,   75,  -98,       35,   66,  -94,       41,   50,  -84,       49,   30,  -72,
      57,   10,  -58,       66,   -9,  -43,       76,  -25,  -29,       85,  -41,  -14,
      33,   75,  -98,       36,   67,  -93,       41,   51,  -84,       49,   31,  -71,
      58,   11,  -57,       67,   -8,  -43,       76,  -24,  -29,       85,  -40,  -14,
      34,   76,  -96,       36,   67,  -92,       42,   52,  -83,       49,   32,  -71,
      58,   12,  -57,       67,   -6,  -43,       76,  -23,  -28,       86,  -39,  -14,
      34,   76,  -95,       37,   68,  -91,       42,   52,  -82,       50,   34,  -70,
      58,   13,  -56,       67,   -5,  -42,       76,  -22,  -28,       86,  -38,  -14,
      35,   76,  -94,       38,   69,  -90,       43,   53,  -81,       50,   35,  -69,
      59,   15,  -56,       67,   -4,  -42,       76,  -21,  -28,       86,  -37,  -13,
      36,   77,  -92,       39,   69,  -88,       44,   55,  -80,       51,   36,  -68,
      59,   16,  -55,       68,   -2,  -41,       77,  -19,  -27,       86,  -36,  -13,
      37,   77,  -91,       39,   70,  -87,       44,   56,  -79,       51,   38,  -68,
      59,   18,  -54,       68,   -1,  -41,       77,  -18,  -27,       86,  -34,  -13,
      38,   78,  -89,       40,   71,  -85,       45,   57,  -77,       52,   39,  -67,
      60,   20,  -54,       68,    1,  -40,       77,  -16,  -26,       87,  -33,  -12,
      39,   79,  -88,       41,   72,  -84,       46,   58,  -76,       52,   41,  -65,
      60,   21,  -53,       69,    3,  -39,       78,  -15,  -26,       87,  -31,  -12,
      40,   79,  -86,       42,   73,  -82,       47,   60,  -75,       53,   43,  -64,
      61,   23,  -52,       69,    5,  -39,       78,  -12,  -25,       87,  -29,  -11,
      41,   80,  -84,       43,   74,  -80,       48,   61,  -73,       54,   44,  -63,
      62,   25,  -51,       70,    7,  -38,       78,  -10,  -24,       88,  -27,  -11,
      42,   81,  -82,       44,   75,  -79,       49,   63,  -72,       55,   46,  -62,
      62,   27,  -50,       70,    9,  -37,       79,   -8,  -24,       88,  -25,  -10,
      43,   82,  -80,       45,   76,  -77,       50,   64,  -70,       55,   48,  -60,
      63,   29,  -49,       71,   11,  -36,       79,   -6,  -23,       88,  -23,  -10,
      45,   83,  -78,       47,   77,  -75,       51,   66,  -68,       56,   50,  -59,
      64,   32,  -47,       72,   14,  -35,       80,   -4,  -22,       89,  -21,   -9,
      46,   84,  -76,       48,   78,  -73,       52,   67,  -66,       57,   52,  -57,
      64,   34,  -46,       72,   16,  -34,       80,   -1,  -21,       89,  -18,   -8,
      47,   85,  -74,       49,   80,  -71,       53,   69,  -65,       58,   54,  -56,
      65,   36,  -45,       73,   18,  -33,       81,    1,  -21,       90,  -16,   -8,
      49,   86,  -71,       50,   81,  -69,       54,   70,  -63,       59,   56,  -54,
      66,   38,  -44,       73,   21,  -32,       81,    3,  -20,       90,  -14,   -7,
      50,   87,  -69,       51,   82,  -67,       55,   72,  -61,       60,   58,  -53,
      67,   41,  -42,       74,   23,  -31,       82,    6,  -19,       91,  -11,   -6,
      51,   88,  -67,       53,   84,  -64,       56,   74,  -59,       61,   60,  -51,
      68,   43,  -41,       75,   26,  -30,       83,    9,  -18,       91,   -9,   -5,
      53,   89,  -65,       54,   85,  -62,       57,   75,  -57,       62,   62,  -49,
      69,   46,  -39,       76,   28,  -28,       83,   11,  -17,       92,   -6,   -4,
      54,   90,  -62,       55,   86,  -60,       59,   77,  -55,       63,   64,  -48,
      69,   48,  -38,       76,   31,  -27,       84,   14,  -16,       92,   -4,   -3,
      55,   92,  -60,       57,   88,  -58,       60,   79,  -53,       64,   66,  -46,
      70,   50,  -36,       77,   33,  -26,       85,   16,  -15,       93,   -1,   -3,
      57,   93,  -58,       58,   89,  -56,       61,   81,  -51,       66,   68,  -44,
      71,   53,  -35,       78,   36,  -24,       85,   19,  -13,       93,    2,   -1,
      58,   94,  -55,       59,   91,  -53,       62,   82,  -49,       67,   70,  -42,
      72,   55,  -33,       79,   39,  -23,       86,   22,  -12,       94,    5,    0,
      60,   96,  -53,       61,   92,  -51,       64,   84,  -47,       68,   72,  -40,
      73,   58,  -32,       80,   41,  -22,       87,   25,  -11,       95,    7,    1,
      32,   76, -105,       34,   67, -100,       40,   50,  -90,       48,   30,  -77,
      57,   10,  -63,       66,   -9,  -48,       75,  -26,  -34,       85,  -42,  -19,
      32,   76, -104,       35,   67, -100,       40,   50,  -90,       48,   30,  -77,
      57,   10,  -63,       66,   -9,  -48,       75,  -26,  -34,       85,  -41,  -19,
      32,   76, -104,       35,   67,  -99,       41,   51,  -90,       48,   31,  -77,
      57,   10,  -63,       66,   -9,  -48,       75,  -26,  -34,       85,  -41,  -19,
      32,   76, -104,       35,   68,  -99,       41,   51,  -89,       48,   31,  -77,
      57,   10,  -63,       66,   -8,  -48,       76,  -25,  -34,       85,  -41,  -19,
      32,   76, -103,       35,   68,  -99,       41,   51,  -89,       48,   31,  -77,
      57,   11,  -62,       66,   -8,  -48,       76,  -25,  -33,       85,  -41,  -19,
      33,   76, -103,       35,   68,  -98,       41,   52,  -89,       49,   32,  -76,
      57,   11,  -62,       66,   -7,  -48,       76,  -24,  -33,       85,  -40,  -19,
      33,   77, -102,       36,   68,  -98,       41,   52,  -88,       49,   33,  -76,
      58,   12,  -62,       67,   -7,  -48,       76,  -24,  -33,       85,  -40,  -19,
      34,   77, -101,       36,   69,  -97,       42,   53,  -88,       49,   33,  -75,
      58,   13,  -61,       67,   -6,  -47,       76,  -23,  -33,       86,  -39,  -18,
      34,   77, -100,       37,   69,  -96,       42,   53,  -87,       49,   34,  -75,
      58,   14,  -61,       67,   -5,  -47,       76,  -22,  -33,       86,  -38,  -18,
      35,   77,  -99,       37,   70,  -95,       43,   54,  -86,       50,   35,  -74,
      58,   15,  -61,       67,   -4,  -47,       76,  -21,  -32,       86,  -37,  -18,
      35,   78,  -98,       38,   70,  -94,       43,   55,  -85,       50,   36,  -74,
      59,   16,  -60,       67,   -3,  -46,       77,  -20,  -32,       86,  -36,  -18,
      36,   78,  -97,       39,   71,  -93,       44,   56,  -84,       51,   37,  -73,
      59,   17,  -59,       68,   -1,  -46,       77,  -19,  -32,       86,  -35,  -17,
      37,   79,  -95,       39,   71,  -91,       44,   57,  -83,       51,   39,  -72,
      59,   19,  -59,       68,    0,  -45,       77,  -17,  -31,       86,  -33,  -17,
      38,   79,  -94,       40,   72,  -90,       45,   58,  -82,       52,   40,  -71,
      60,   20,  -58,       68,    2,  -44,       77,  -16,  -31,       87,  -32,  -17,
      39,   80,  -92,       41,   73,  -89,       46,   59,  -81,       52,   42,  -70,
      60,   22,  -57,       69,    3,  -44,       78,  -14,  -30,       87,  -30,  -16,
      40,   80,  -91,       42,   74,  -87,       47,   60,  -80,       53,   43,  -69,
      61,   24,  -56,       69,    5,  -43,       78,  -12,  -30,       87,  -29,  -16,
      41,   81,  -89,       43,   75,  -85,       47,   62,  -78,       54,   45,  -68,
      61,   26,  -55,       70,    7,  -42,       78,  -10,  -29,       88,  -27,  -15,
      42,   82,  -87,       44,   76,  -84,       48,   63,  -77,       54,   47,  -67,
      62,   28,  -54,       70,    9,  -42,       79,   -8,  -28,       88,  -25,  -15,
      43,   82,  -85,       45,   77,  -82,       49,   64,  -75,       55,   48,  -65,
      63,   30,  -53,       71,   11,  -41,       79,   -6,  -28,       88,  -23,  -14,
      44,   83,  -83,       46,   78,  -80,       50,   66,  -74,       56,   50,  -64,
      63,   32,  -52,       71,   13,  -40,       80,   -4,  -27,       89,  -21,  -13,
      45,   84,  -81,       47,   79,  -78,       51,   67,  -72,       57,   52,  -63,
      64,   34,  -51,       72,   16,  -39,       80,   -2,  -26,       89,  -19,  -13,
      47,   85,  -79,       48,   80,  -76,       52,   69,  -70,       58,   54,  -61,
      65,   36,  -50,       72,   18,  -38,       81,    0,  -25,       89,  -17,  -12,
      48,   86,  -77,       50,   81,  -74,       53,   70,  -68,       59,   56,  -60,
      66,   38,  -49,       73,   20,  -37,       81,    3,  -24,       90,  -14,  -11,
      49,   87,  -75,       51,   82,  -72,       54,   72,  -67,       60,   58,  -58,
      66,   40,  -47,       74,   23,  -36,       82,    5,  -24,       90,  -12,  -11,
      50,   88,  -73,       52,   84,  -70,       55,   74,  -65,       61,   60,  -57,
      67,   42,  -46,       74,   25,  -35,       82,    7,  -23,       91,  -10,  -10,
      52,   89,  -70,       53,   85,  -68,       57,   75,  -63,       62,   62,  -55,
      68,   45,  -45,       75,   28,  -33,       83,   10,  -22,       91,   -7,   -9,
      53,   90,  -68,       55,   86,  -66,       58,   77,  -61,       63,   64,  -53,
      69,   47,  -43,       76,   30,  -32,       84,   13,  -21,       92,   -5,   -8,
      54,   92,  -66,       56,   88,  -64,       59,   79,  -59,       64,   66,  -51,
      70,   49,  -42,       77,   33,  -31,       84,   15,  -20,       92,   -2,   -7,
      56,   93,  -64,       57,   89,  -62,       60,   80,  -57,       65,   68,  -50,
      71,   52,  -40,       77,   35,  -30,       85,   18,  -18,       93,    1,   -6,
      57,   94,  -61,       59,   90,  -59,       62,   82,  -55,       66,   70,  -48,
      72,   54,  -39,       78,   38,  -28,       86,   21,  -17,       94,    3,   -5,
      59,   95,  -59,       60,   92,  -57,       63,   84,  -53,       67,   72,  -46,
      73,   57,  -37,       79,   40,  -27,       86,   23,  -16,       94,    6,   -4,
      60,   97,  -57,       61,   93,  -55,       64,   85,  -51,       68,   74,  -44,
      74,   59,  -35,       80,   43,  -26,       87,   26,  -15,       95,    9,   -3,
      33,   78, -107,       35,   69, -103,       41,   53,  -93,       49,   33,  -81,
      57,   13,  -66,       66,   -6,  -52,       76,  -23,  -38,       85,  -39,  -23,
      33,   78, -107,       36,   70, -102,       41,   53,  -93,       49,   33,  -81,
      58,   13,  -66,       67,   -6,  -52,       76,  -23,  -38,       85,  -39,  -23,
      33,   78, -107,       36,   70, -102,       41,   53,  -93,       49,   34,  -81,
      58,   13,  -66,       67,   -6,  -52,       76,  -23,  -37,       85,  -39,  -23,
      33,   78, -106,       36,   70, -102,       42,   54,  -93,       49,   34,  -80,
      58,   13,  -66,       67,   -5,  -52,       76,  -23,  -37,       85,  -39,  -23,
      33,   78, -106,       36,   70, -102,       42,   54,  -92,       49,   34,  -80,
      58,   14,  -66,       67,   -5,  -52,       76,  -22,  -37,       85,  -38,  -23,
      34,   78, -106,       36,   70, -101,       42,   54,  -92,       49,   35,  -80,
      58,   14,  -66,       67,   -5,  -51,       76,  -22,  -37,       86,  -38,  -22,
      34,   79, -105,       37,   71, -100,       42,   55,  -91,       49,   35,  -79,
      58,   15,  -65,       67,   -4,  -51,       76,  -21,  -37,       86,  -37,  -22,
      35,   79, -104,       37,   71, -100,       43,   55,  -91,       50,   36,  -79,
      58,   16,  -65,       67,   -3,  -51,       76,  -20,  -37,       86,  -36,  -22,
      35,   79, -103,       38,   71,  -99,       43,   56,  -90,       50,   37,  -78,
      59,   17,  -65,       67,   -2,  -51,       76,  -19,  -36,       86,  -36,  -22,
      36,   79, -102,       38,   72,  -98,       43,   57,  -89,       50,   38,  -78,
      59,   18,  -64,       68,   -1,  -50,       77,  -18,  -36,       86,  -35,  -22,
      36,   80, -101,       39,   72,  -97,       44,   57,  -88,       51,   39,  -77,
      59,   19,  -64,       68,    0,  -50,       77,  -17,  -36,       86,  -34,  -21,
      37,   80, -100,       39,   73,  -96,       44,   58,  -88,       51,   40,  -76,
      59,   20,  -63,       68,    1,  -49,       77,  -16,  -35,       86,  -33,  -21,
      38,   80,  -98,       40,   73,  -95,       45,   59,  -86,       52,   41,  -76,
      60,   22,  -62,       68,    3,  -49,       77,  -15,  -35,       87,  -31,  -21,
      39,   81,  -97,       41,   74,  -93,       46,   60,  -85,       52,   43,  -75,
      60,   23,  -62,       69,    4,  -48,       78,  -13,  -35,       87,  -30,  -20,
      40,   81,  -95,       42,   75,  -92,       46,   61,  -84,       53,   44,  -74,
      61,   25,  -61,       69,    6,  -48,       78,  -12,  -34,       87,  -28,  -20,
      41,   82,  -94,       43,   76,  -90,       47,   63,  -83,       54,   45,  -73,
      61,   26,  -60,       70,    8,  -47,       78,  -10,  -33,       87,  -27,  -20,
      42,   83,  -92,       44,   77,  -89,       48,   64,  -81,       54,   47,  -71,
      62,   28,  -59,       70,   10,  -46,       79,   -8,  -33,       88,  -25,  -19,
      43,   83,  -90,       45,   77,  -87,       49,   65,  -80,       55,   49,  -70,
      62,   30,  -58,       71,   11,  -45,       79,   -6,  -32,       88,  -23,  -18,
      44,   84,  -88,       46,   78,  -85,       50,   66,  -79,       56,   50,  -69,
      63,   32,  -57,       71,   13,  -45,       79,   -4,  -32,       88,  -21,  -18,
      45,   85,  -87,       47,   79,  -84,       51,   68,  -77,       56,   52,  -68,
      64,   34,  -56,       72,   15,  -44,       80,   -2,  -31,       89,  -19,  -17,
      46,   86,  -84,       48,   81,  -82,       52,   69,  -75,       57,   54,  -66,
      64,   36,  -55,       72,   18,  -43,       80,    0,  -30,       89,  -17,  -17,
      47,   87,  -83,       49,   82,  -80,       53,   71,  -74,       58,   56,  -65,
      65,   38,  -54,       73,   20,  -42,       81,    2,  -29,       90,  -15,  -16,
      49,   88,  -80,       50,   83,  -78,       54,   72,  -72,       59,   58,  -63,
      66,   40,  -52,       73,   22,  -41,       81,    5,  -28,       90,  -13,  -15,
      50,   89,  -78,       51,   84,  -76,       55,   74,  -70,       60,   59,  -62,
      67,   42,  -51,       74,   24,  -40,       82,    7,  -27,       91,  -10,  -15,
      51,   90,  -76,       53,   85,  -74,       56,   75,  -68,       61,   61,  -60,
      67,   44,  -50,       75,   27,  -39,       83,    9,  -27,       91,   -8,  -14,
      52,   91,  -74,       54,   86,  -72,       57,   77,  -66,       62,   63,  -59,
      68,   47,  -48,       76,   29,  -37,       83,   12,  -25,       92,   -5,  -13,
      54,   92,  -72,       55,   88,  -70,       58,   78,  -64,       63,   65,  -57,
      69,   49,  -47,       76,   32,  -36,       84,   14,  -24,       92,   -3,  -12,
      55,   93,  -70,       56,   89,  -68,       59,   80,  -63,       64,   67,  -55,
      70,   51,  -46,       77,   34,  -35,       84,   17,  -23,       93,    0,  -11,
      56,   94,  -68,       58,   90,  -65,       61,   81,  -61,       65,   69,  -53,
      71,   53,  -44,       78,   37,  -34,       85,   19,  -22,       93,    2,  -10,
      58,   95,  -65,       59,   92,  -63,       62,   83,  -58,       66,   71,  -52,
      72,   56,  -42,       79,   39,  -32,       86,   22,  -21,       94,    5,   -9,
      59,   97,  -63,       60,   93,  -61,       63,   85,  -56,       67,   73,  -50,
      73,   58,  -41,       79,   42,  -31,       87,   25,  -20,       94,    8,   -8,
      60,   98,  -61,       62,   94,  -59,       64,   86,  -54,       68,   75,  -48,
      74,   60,  -39,       80,   44,  -29,       87,   27,  -19,       95,   10,   -7,
       2,   -5,    3,       15,  -26,   21,       28,  -36,   35,       39,  -46,   44,
      51,  -56,   54,       62,  -65,   62,       72,  -73,   71,       83,  -82,   79,
       3,   -3,    4,       15,  -23,   22,       28,  -35,   35,       40,  -45,   45,
      51,  -55,   54,       62,  -64,   63,       72,  -73,   71,       83,  -82,   79,
       3,    0,    5,       15,  -21,   22,       28,  -34,   35,       40,  -44,   45,
      51,  -55,   54,       62,  -64,   63,       72,  -73,   71,       83,  -82,   79,
       4,    4,    6,       16,  -17,   23,       28,  -31,   36,       40,  -43,   45,
      51,  -54,   54,       62,  -63,   63,       72,  -72,   71,       83,  -81,   79,
       5,    8,    8,       17,  -13,   24,       28,  -29,   36,       40,  -41,   45,
      51,  -52,   54,       62,  -62,   63,       73,  -71,   71,       83,  -80,   79,
       7,   14,   10,       17,   -9,   25,       29,  -26,   36,       40,  -39,   45,
      52,  -51,   54,       62,  -61,   63,       73,  -71,   71,       83,  -80,   80,
       8,   18,   13,       18,   -4,   26,       29,  -23,   37,       41,  -37,   46,
      52,  -49,   55,       62,  -60,   63,       73,  -69,   71,       83,  -79,   80,
      10,   22,   16,       19,    1,   27,       30,  -18,   38,       41,  -34,   46,
      52,  -47,   55,       63,  -58,   63,       73,  -68,   72,       83,  -78,   80,
      12,   25,   19,       20,    5,   29,       31,  -15,   39,       41,  -31,   47,
      52,  -45,   55,       63,  -56,   64,       73,  -67,   72,       83,  -77,   80,
      14,   28,   22,       21,   10,   30,       31,  -11,   39,       42,  -28,   47,
      53,  -42,   56,       63,  -54,   64,       73,  -65,   72,       84,  -75,   80,
      16,   31,   24,       23,   14,   32,       32,   -7,   40,       42,  -24,   48,
      53,  -39,   56,       63,  -52,   64,       74,  -63,   72,       84,  -74,   80,
      18,   34,   27,       24,   18,   34,       33,   -2,   41,       43,  -20,   49,
      54,  -36,   57,       64,  -49,   65,       74,  -61,   73,       84,  -72,   81,
      20,   37,   30,       25,   22,   36,       34,    2,   42,       44,  -16,   50,
      54,  -33,   57,       64,  -46,   65,       74,  -59,   73,       84,  -70,   81,
      22,   39,   32,       27,   25,   38,       35,    6,   44,       44,  -12,   50,
      55,  -29,   58,       64,  -44,   66,       74,  -56,   73,       84,  -68,   81,
      23,   42,   35,       28,   29,   39,       36,   10,   45,       45,   -9,   51,
      55,  -26,   59,       65,  -41,   66,       75,  -54,   74,       85,  -66,   82,
      25,   44,   37,       30,   32,   41,       37,   14,   46,       46,   -5,   52,
      56,  -23,   59,       65,  -38,   67,       75,  -51,   74,       85,  -64,   82,
      27,   47,   40,       31,   36,   43,       38,   18,   47,       47,    0,   53,
      56,  -18,   60,       66,  -34,   67,       75,  -48,   75,       85,  -61,   82,
      29,   49,   42,       33,   39,   45,       39,   22,   49,       48,    3,   54,
      57,  -15,   61,       66,  -31,   68,       76,  -45,   75,       86,  -58,   83,
      31,   52,   44,       34,   42,   47,       41,   26,   50,       49,    7,   55,
      58,  -11,   62,       67,  -27,   69,       76,  -42,   76,       86,  -56,   83,
      33,   54,   46,       36,   44,   48,       42,   29,   51,       50,   11,   56,
      58,   -8,   63,       68,  -24,   69,       77,  -39,   76,       86,  -53,   84,
      35,   56,   49,       38,   48,   50,       43,   33,   53,       51,   15,   58,
      59,   -3,   64,       68,  -20,   70,       77,  -35,   77,       87,  -50,   84,
      36,   58,   50,       39,   50,   52,       45,   36,   54,       52,   19,   59,
      60,    0,   65,       69,  -17,   71,       78,  -32,   78,       87,  -47,   85,
      38,   61,   52,       41,   53,   53,       46,   39,   56,       53,   22,   60,
      61,    4,   66,       70,  -13,   72,       78,  -29,   78,       88,  -44,   85,
      40,   63,   54,       42,   55,   55,       47,   42,   57,       54,   26,   61,
      62,    8,   67,       70,  -10,   72,       79,  -26,   79,       88,  -41,   86,
      41,   65,   55,       44,   58,   56,       48,   45,   59,       55,   29,   62,
      63,   11,   68,       71,   -6,   73,       80,  -22,   80,       89,  -38,   86,
      43,   67,   57,       46,   61,   58,       50,   49,   60,       56,   33,   64,
      64,   15,   69,       72,   -2,   74,       80,  -18,   80,       89,  -34,   87,
      45,   69,   59,       47,   63,   60,       51,   51,   62,       57,   36,   65,
      65,   19,   70,       73,    2,   75,       81,  -15,   81,       90,  -31,   88,
      47,   71,   61,       49,   65,   61,       53,   54,   63,       58,   39,   66,
      66,   22,   71,       73,    5,   76,       82,  -11,   82,       90,  -28,   88,
      48,   73,   62,       50,   68,   63,       54,   57,   65,       60,   43,   68,
      67,   26,   72,       74,    9,   77,       82,   -8,   83,       91,  -24,   89,
      50,   75,   64,       52,   70,   65,       56,   60,   66,       61,   46,   69,
      68,   29,   73,       75,   12,   78,       83,   -4,   84,       92,  -21,   90,
      52,   77,   66,       54,   72,   66,       57,   63,   68,       62,   49,   71,
      69,   33,   75,       76,   16,   79,       84,   -1,   85,       92,  -17,   91,
      54,   79,   67,       55,   74,   68,       59,   65,   69,       64,   52,   72,
      70,   36,   76,       77,   19,   80,       85,    3,   86,       93,  -14,   91,
       3,   -4,    0,       15,  -24,   18,       28,  -36,   32,       40,  -46,   42,
      51,  -55,   52,       62,  -65,   61,       72,  -73,   70,       83,  -82,   79,
       3,   -2,    1,       15,  -22,   18,       28,  -34,   32,       40,  -45,   43,
      51,  -55,   52,       62,  -64,   61,       72,  -73,   70,       83,  -82,   79,
       4,    1,    2,       16,  -20,   19,       28,  -33,   32,       40,  -44,   43,
      51,  -54,   53,       62,  -64,   62,       72,  -73,   70,       83,  -81,   79,
       4,    5,    3,       16,  -16,   20,       28,  -31,   33,       40,  -43,   43,
      51,  -53,   53,       62,  -63,   62,       72,  -72,   70,       83,  -81,   79,
       5,    9,    5,       17,  -12,   20,       29,  -28,   33,       40,  -41,   43,
      51,  -52,   53,       62,  -62,   62,       73,  -71,   70,       83,  -80,   79,
       7,   15,    7,       17,   -8,   21,       29,  -25,   33,       40,  -39,   43,
      52,  -51,   53,       62,  -61,   62,       73,  -70,   70,       83,  -80,   79,
       8,   18,   10,       18,   -4,   23,       29,  -22,   34,       41,  -37,   44,
      52,  -49,   53,       62,  -60,   62,       73,  -69,   71,       83,  -79,   79,
      10,   22,   13,       19,    1,   24,       30,  -18,   35,       41,  -33,   44,
      52,  -47,   54,       63,  -58,   62,       73,  -68,   71,       83,  -78,   79,
      12,   26,   16,       20,    6,   26,       31,  -14,   36,       41,  -30,   45,
      52,  -44,   54,       63,  -56,   63,       73,  -66,   71,       83,  -76,   79,
      14,   29,   18,       21,   10,   27,       31,  -10,   36,       42,  -27,   45,
      53,  -42,   54,       63,  -54,   63,       73,  -65,   71,       84,  -75,   79,
      16,   31,   21,       23,   14,   29,       32,   -6,   37,       42,  -24,   46,
      53,  -39,   55,       63,  -52,   63,       74,  -63,   71,       84,  -74,   80,
      18,   34,   24,       24,   18,   31,       33,   -2,   38,       43,  -20,   47,
      54,  -36,   55,       64,  -49,   64,       74,  -61,   72,       84,  -72,   80,
      20,   37,   27,       25,   22,   33,       34,    2,   40,       44,  -16,   48,
      54,  -33,   56,       64,  -46,   64,       74,  -58,   72,       84,  -70,   80,
      22,   40,   29,       27,   26,   34,       35,    6,   41,       44,  -12,   48,
      55,  -29,   57,       64,  -44,   65,       74,  -56,   72,       84,  -68,   81,
      23,   42,   32,       28,   29,   36,       36,   10,   42,       45,   -8,   49,
      55,  -26,   57,       65,  -41,   65,       75,  -54,   73,       85,  -66,   81,
      25,   44,   34,       30,   32,   38,       37,   14,   43,       46,   -5,   50,
      56,  -22,   58,       65,  -38,   66,       75,  -51,   73,       85,  -63,   81,
      27,   47,   37,       31,   36,   40,       38,   18,   45,       47,    0,   51,
      56,  -18,   59,       66,  -34,   66,       75,  -48,   74,       85,  -61,   82,
      29,   49,   39,       33,   39,   42,       39,   22,   46,       48,    4,   52,
      57,  -15,   60,       66,  -31,   67,       76,  -45,   74,       86,  -58,   82,
      31,   52,   41,       34,   42,   43,       41,   26,   48,       49,    7,   54,
      58,  -11,   60,       67,  -27,   68,       76,  -42,   75,       86,  -56,   83,
      33,   54,   43,       36,   45,   45,       42,   29,   49,       50,   11,   55,
      58,   -7,   61,       68,  -24,   68,       77,  -39,   75,       86,  -53,   83,
      35,   56,   45,       38,   48,   47,       43,   33,   51,       51,   15,   56,
      59,   -3,   62,       68,  -20,   69,       77,  -35,   76,       87,  -50,   84,
      36,   59,   47,       39,   50,   49,       45,   36,   52,       52,   19,   57,
      60,    0,   63,       69,  -17,   70,       78,  -32,   77,       87,  -47,   84,
      38,   61,   49,       41,   53,   51,       46,   39,   54,       53,   22,   58,
      61,    4,   64,       70,  -13,   71,       78,  -29,   77,       88,  -44,   85,
      40,   63,   51,       42,   55,   52,       47,   42,   55,       54,   26,   60,
      62,    8,   65,       70,   -9,   72,       79,  -25,   78,       88,  -41,   85,
      41,   65,   53,       44,   58,   54,       49,   45,   57,       55,   29,   61,
      63,   11,   66,       71,   -6,   72,       80,  -22,   79,       89,  -38,   86,
      43,   67,   55,       46,   61,   56,       50,   49,   59,       56,   33,   62,
      64,   15,   68,       72,   -2,   73,       80,  -18,   80,       89,  -34,   86,
      45,   69,   57,       47,   63,   58,       51,   52,   60,       57,   36,   64,
      65,   19,   69,       73,    2,   74,       81,  -15,   80,       90,  -31,   87,
      47,   71,   58,       49,   65,   59,       53,   54,   62,       58,   39,   65,
      66,   22,   70,       73,    5,   75,       82,  -11,   81,       90,  -27,   88,
      48,   73,   60,       50,   68,   61,       54,   57,   63,       60,   43,   66,
      67,   26,   71,       74,    9,   76,       82,   -8,   82,       91,  -24,   89,
      50,   75,   62,       52,   70,   63,       56,   60,   65,       61,   46,   68,
      68,   29,   72,       75,   12,   77,       83,   -4,   83,       92,  -20,   89,
      52,   77,   64,       54,   72,   65,       57,   63,   66,       62,   49,   69,
      69,   33,   73,       76,   16,   78,       84,   -1,   84,       92,  -17,   90,
      54,   79,   65,       55,   74,   66,       59,   65,   68,       64,   52,   71,
      70,   36,   75,       77,   19,   79,       85,    3,   85,       93,  -14,   91,
       3,   -2,   -3,       15,  -23,   14,       28,  -35,   29,       40,  -45,   40,
      51,  -55,   51,       62,  -64,   60,       72,  -73,   69,       83,  -82,   78,
       3,    0,   -2,       15,  -21,   15,       28,  -34,   29,       40,  -44,   40,
      51,  -55,   51,       62,  -64,   60,       72,  -73,   69,       83,  -82,   78,
       4,    2,   -1,       16,  -18,   15,       28,  -32,   29,       40,  -44,   41,
      51,  -54,   51,       62,  -63,   60,       72,  -72,   69,       83,  -81,   78,
       5,    6,    0,       16,  -15,   16,       28,  -30,   29,       40,  -42,   41,
      51,  -53,   51,       62,  -63,   60,       72,  -72,   69,       83,  -81,   78,
       6,   11,    2,       17,  -11,   17,       29,  -28,   30,       40,  -41,   41,
      52,  -52,   51,       62,  -62,   61,       73,  -71,   69,       83,  -80,   78,
       7,   15,    4,       17,   -7,   18,       29,  -25,   30,       40,  -39,   41,
      52,  -50,   52,       62,  -61,   61,       73,  -70,   69,       83,  -80,   78,
       9,   19,    6,       18,   -3,   19,       29,  -22,   31,       41,  -36,   42,
      52,  -49,   52,       62,  -59,   61,       73,  -69,   70,       83,  -79,   78,
      11,   23,    9,       19,    2,   21,       30,  -18,   32,       41,  -33,   42,
      52,  -46,   52,       63,  -58,   61,       73,  -68,   70,       83,  -78,   78,
      12,   26,   12,       20,    6,   22,       31,  -14,   33,       41,  -30,   43,
      52,  -44,   53,       63,  -56,   61,       73,  -66,   70,       83,  -76,   79,
      14,   29,   15,       21,   10,   24,       31,  -10,   34,       42,  -27,   43,
      53,  -42,   53,       63,  -54,   62,       73,  -65,   70,       84,  -75,   79,
      16,   32,   18,       23,   14,   25,       32,   -6,   35,       42,  -24,   44,
      53,  -39,   53,       63,  -52,   62,       74,  -63,   71,       84,  -73,   79,
      18,   34,   20,       24,   18,   27,       33,   -2,   36,       43,  -20,   45,
      54,  -36,   54,       64,  -49,   63,       74,  -61,   71,       84,  -72,   79,
      20,   37,   23,       25,   22,   29,       34,    3,   37,       44,  -16,   46,
      54,  -32,   55,       64,  -46,   63,       74,  -58,   71,       84,  -70,   80,
      22,   40,   26,       27,   26,   31,       35,    7,   38,       44,  -12,   47,
      55,  -29,   55,       65,  -43,   63,       74,  -56,   72,       84,  -68,   80,
      23,   42,   28,       28,   29,   33,       36,   11,   40,       45,   -8,   47,
      55,  -26,   56,       65,  -40,   64,       75,  -53,   72,       85,  -66,   80,
      25,   45,   30,       30,   32,   34,       37,   14,   41,       46,   -4,   48,
      56,  -22,   57,       65,  -37,   65,       75,  -51,   72,       85,  -63,   81,
      27,   47,   33,       31,   36,   37,       38,   19,   42,       47,    0,   50,
      56,  -18,   57,       66,  -34,   65,       76,  -48,   73,       85,  -61,   81,
      29,   50,   35,       33,   39,   38,       39,   22,   44,       48,    4,   51,
      57,  -15,   58,       66,  -31,   66,       76,  -45,   73,       86,  -58,   81,
      31,   52,   37,       34,   42,   40,       41,   26,   45,       49,    7,   52,
      58,  -11,   59,       67,  -27,   67,       76,  -42,   74,       86,  -55,   82,
      33,   54,   40,       36,   45,   42,       42,   29,   47,       50,   11,   53,
      58,   -7,   60,       68,  -24,   67,       77,  -39,   75,       86,  -53,   82,
      35,   56,   42,       38,   48,   44,       43,   33,   49,       51,   15,   54,
      59,   -3,   61,       68,  -20,   68,       77,  -35,   75,       87,  -50,   83,
      36,   59,   44,       39,   50,   46,       45,   36,   50,       52,   19,   55,
      60,    1,   62,       69,  -16,   69,       78,  -32,   76,       87,  -47,   83,
      38,   61,   46,       41,   53,   48,       46,   39,   52,       53,   22,   57,
      61,    4,   63,       70,  -13,   70,       78,  -29,   77,       88,  -44,   84,
      40,   63,   48,       42,   56,   50,       47,   42,   53,       54,   26,   58,
      62,    8,   64,       70,   -9,   70,       79,  -25,   77,       88,  -41,   84,
      41,   65,   50,       44,   58,   52,       49,   45,   55,       55,   29,   59,
      63,   11,   65,       71,   -6,   71,       80,  -22,   78,       89,  -37,   85,
      43,   67,   52,       46,   61,   54,       50,   49,   57,       56,   33,   61,
      64,   15,   66,       72,   -2,   72,       80,  -18,   79,       89,  -34,   86,
      45,   69,   54,       47,   63,   55,       51,   52,   58,       57,   36,   62,
      65,   19,   67,       73,    2,   73,       81,  -15,   80,       90,  -31,   86,
      47,   71,   56,       49,   65,   57,       53,   54,   60,       59,   40,   64,
      66,   22,   69,       73,    5,   74,       82,  -11,   80,       90,  -27,   87,
      48,   73,   58,       50,   68,   59,       54,   57,   61,       60,   43,   65,
      67,   26,   70,       74,    9,   75,       82,   -8,   81,       91,  -24,   88,
      50,   75,   60,       52,   70,   61,       56,   60,   63,       61,   46,   66,
      68,   29,   71,       75,   13,   76,       83,   -4,   82,       92,  -20,   89,
      52,   77,   62,       54,   72,   63,       57,   63,   65,       62,   49,   68,
      69,   33,   72,       76,   16,   77,       84,   -1,   83,       92,  -17,   89,
      54,   79,   63,       55,   75,   64,       59,   65,   66,       64,   52,   69,
      70,   36,   74,       77,   19,   79,       85,    3,   84,       93,  -14,   90,
       3,    0,   -9,       15,  -21,    9,       28,  -34,   24,       40,  -45,   37,
      51,  -55,   49,       62,  -64,   58,       72,  -73,   68,       83,  -82,   77,
       3,    2,   -8,       15,  -19,    9,       28,  -33,   25,       40,  -44,   37,
      51,  -54,   49,       62,  -64,   58,       72,  -72,   68,       83,  -81,   77,
       4,    4,   -7,       16,  -17,   10,       28,  -31,   25,       40,  -43,   37,
      51,  -54,   49,       62,  -63,   59,       72,  -72,   68,       83,  -81,   77,
       5,    8,   -6,       16,  -13,   10,       28,  -29,   25,       40,  -42,   38,
      51,  -53,   49,       62,  -62,   59,       73,  -72,   68,       83,  -81,   77,
       6,   13,   -4,       17,  -10,   11,       29,  -27,   26,       40,  -40,   38,
      52,  -51,   49,       62,  -61,   59,       73,  -71,   68,       83,  -80,   77,
       7,   17,   -2,       18,   -6,   12,       29,  -24,   26,       40,  -38,   38,
      52,  -50,   49,       62,  -60,   59,       73,  -70,   68,       83,  -79,   77,
       9,   20,    1,       18,   -2,   14,       29,  -21,   27,       41,  -36,   39,
      52,  -48,   49,       63,  -59,   59,       73,  -69,   68,       83,  -78,   77,
      11,   24,    4,       19,    3,   15,       30,  -17,   28,       41,  -33,   39,
      52,  -46,   50,       63,  -57,   59,       73,  -67,   68,       83,  -77,   77,
      13,   27,    6,       20,    7,   17,       31,  -13,   29,       41,  -30,   40,
      52,  -44,   50,       63,  -55,   60,       73,  -66,   69,       83,  -76,   77,
      14,   30,    9,       22,   11,   18,       31,   -9,   30,       42,  -26,   40,
      53,  -41,   51,       63,  -53,   60,       73,  -64,   69,       84,  -75,   78,
      16,   32,   12,       23,   15,   20,       32,   -5,   31,       42,  -23,   41,
      53,  -38,   51,       63,  -51,   60,       74,  -63,   69,       84,  -73,   78,
      18,   35,   14,       24,   19,   22,       33,   -1,   32,       43,  -20,   42,
      54,  -35,   52,       64,  -49,   61,       74,  -61,   69,       84,  -72,   78,
      20,   38,   17,       26,   23,   24,       34,    3,   33,       44,  -15,   43,
      54,  -32,   52,       64,  -46,   61,       74,  -58,   70,       84,  -70,   78,
      22,   40,   20,       27,   26,   26,       35,    7,   34,       44,  -12,   44,
      55,  -29,   53,       65,  -43,   62,       74,  -56,   70,       84,  -68,   79,
      24,   43,   23,       28,   30,   28,       36,   11,   36,       45,   -8,   45,
      55,  -25,   54,       65,  -40,   62,       75,  -53,   71,       85,  -65,   79,
      25,   45,   25,       30,   33,   30,       37,   15,   37,       46,   -4,   46,
      56,  -22,   54,       65,  -37,   63,       75,  -51,   71,       85,  -63,   79,
      27,   48,   28,       31,   36,   32,       38,   19,   39,       47,    0,   47,
      56,  -18,   55,       66,  -34,   63,       76,  -48,   72,       85,  -60,   80,
      29,   50,   30,       33,   39,   34,       40,   23,   40,       48,    4,   48,
      57,  -14,   56,       66,  -30,   64,       76,  -45,   72,       86,  -58,   80,
      31,   52,   33,       34,   42,   36,       41,   26,   42,       49,    8,   49,
      58,  -11,   57,       67,  -27,   65,       76,  -42,   73,       86,  -55,   81,
      33,   54,   35,       36,   45,   38,       42,   30,   43,       50,   11,   50,
      58,   -7,   58,       68,  -24,   66,       77,  -39,   73,       86,  -53,   81,
      35,   57,   37,       38,   48,   40,       43,   33,   45,       51,   16,   52,
      59,   -3,   59,       68,  -20,   66,       77,  -35,   74,       87,  -49,   82,
      36,   59,   40,       39,   51,   42,       45,   36,   47,       52,   19,   53,
      60,    1,   60,       69,  -16,   67,       78,  -32,   75,       87,  -46,   82,
      38,   61,   42,       41,   53,   44,       46,   40,   48,       53,   23,   54,
      61,    4,   61,       70,  -13,   68,       78,  -29,   75,       88,  -43,   83,
      40,   63,   44,       42,   56,   46,       47,   43,   50,       54,   26,   55,
      62,    8,   62,       70,   -9,   69,       79,  -25,   76,       88,  -40,   83,
      42,   65,   46,       44,   58,   48,       49,   46,   52,       55,   30,   57,
      63,   12,   63,       71,   -6,   70,       80,  -22,   77,       89,  -37,   84,
      43,   67,   48,       46,   61,   50,       50,   49,   54,       56,   33,   58,
      64,   16,   64,       72,   -2,   71,       80,  -18,   78,       89,  -34,   85,
      45,   69,   50,       47,   63,   52,       51,   52,   55,       57,   36,   60,
      65,   19,   66,       73,    2,   72,       81,  -15,   78,       90,  -31,   85,
      47,   71,   52,       49,   66,   54,       53,   54,   57,       59,   40,   61,
      66,   22,   67,       73,    5,   73,       82,  -11,   79,       90,  -27,   86,
      48,   73,   54,       50,   68,   56,       54,   57,   59,       60,   43,   63,
      67,   26,   68,       74,    9,   74,       82,   -8,   80,       91,  -24,   87,
      50,   76,   56,       52,   70,   58,       56,   60,   60,       61,   46,   64,
      68,   30,   69,       75,   13,   75,       83,   -4,   81,       92,  -20,   88,
      52,   78,   58,       54,   72,   60,       57,   63,   62,       62,   49,   66,
      69,   33,   70,       76,   16,   76,       84,   -1,   82,       92,  -17,   88,
      54,   79,   60,       55,   75,   61,       59,   65,   64,       64,   52,   67,
      70,   36,   72,       77,   19,   77,       85,    3,   83,       93,  -14,   89,
       3,    2,  -14,       15,  -19,    4,       28,  -32,   20,       40,  -44,   34,
      51,  -54,   46,       62,  -63,   56,       72,  -72,   66,       83,  -81,   75,
       4,    4,  -14,       16,  -17,    4,       28,  -31,   20,       40,  -43,   34,
      51,  -54,   46,       62,  -63,   56,       72,  -72,   66,       83,  -81,   75,
       4,    7,  -13,       16,  -15,    5,       28,  -30,   21,       40,  -42,   34,
      51,  -53,   46,       62,  -63,   56,       72,  -72,   66,       83,  -81,   75,
       5,   10,  -11,       16,  -11,    5,       28,  -28,   21,       40,  -41,   34,
      51,  -52,   46,       62,  -62,   57,       73,  -71,   66,       83,  -80,   75,
       6,   15,  -10,       17,   -8,    6,       29,  -26,   21,       40,  -39,   35,
      52,  -51,   46,       62,  -61,   57,       73,  -70,   66,       83,  -80,   75,
       8,   18,   -8,       18,   -4,    7,       29,  -23,   22,       40,  -37,   35,
      52,  -49,   47,       62,  -60,   57,       73,  -70,   66,       83,  -79,   76,
       9,   21,   -5,       19,   -1,    8,       30,  -20,   23,       41,  -35,   35,
      52,  -48,   47,       63,  -59,   57,       73,  -69,   66,       83,  -78,   76,
      11,   25,   -2,       20,    4,   10,       30,  -16,   23,       41,  -32,   36,
      52,  -45,   47,       63,  -57,   57,       73,  -67,   67,       83,  -77,   76,
      13,   28,    1,       21,    8,   12,       31,  -12,   24,       42,  -29,   36,
      53,  -43,   48,       63,  -55,   58,       73,  -66,   67,       83,  -76,   76,
      15,   30,    3,       22,   12,   13,       32,   -9,   25,       42,  -26,   37,
      53,  -41,   48,       63,  -53,   58,       73,  -64,   67,       84,  -74,   76,
      16,   33,    6,       23,   16,   15,       32,   -5,   26,       43,  -22,   38,
      53,  -38,   49,       63,  -51,   58,       74,  -62,   67,       84,  -73,   76,
      18,   35,    9,       24,   19,   17,       33,   -1,   28,       43,  -19,   39,
      54,  -35,   49,       64,  -48,   59,       74,  -60,   68,       84,  -71,   77,
      20,   38,   12,       26,   23,   19,       34,    4,   29,       44,  -15,   39,
      54,  -32,   50,       64,  -46,   59,       74,  -58,   68,       84,  -69,   77,
      22,   41,   15,       27,   27,   21,       35,    8,   30,       44,  -11,   40,
      55,  -28,   50,       65,  -43,   60,       74,  -55,   69,       84,  -67,   77,
      24,   43,   17,       28,   30,   23,       36,   11,   32,       45,   -7,   41,
      55,  -25,   51,       65,  -40,   60,       75,  -53,   69,       85,  -65,   78,
      26,   45,   20,       30,   33,   25,       37,   15,   33,       46,   -4,   42,
      56,  -22,   52,       65,  -37,   61,       75,  -50,   69,       85,  -63,   78,
      28,   48,   23,       32,   37,   27,       38,   19,   35,       47,    1,   44,
      56,  -18,   53,       66,  -33,   61,       76,  -47,   70,       85,  -60,   78,
      29,   50,   25,       33,   40,   30,       40,   23,   37,       48,    4,   45,
      57,  -14,   54,       66,  -30,   62,       76,  -44,   70,       86,  -58,   79,
      31,   52,   28,       35,   42,   32,       41,   26,   38,       49,    8,   46,
      58,  -10,   54,       67,  -27,   63,       76,  -41,   71,       86,  -55,   79,
      33,   54,   30,       36,   45,   34,       42,   30,   40,       50,   12,   47,
      59,   -7,   55,       68,  -23,   64,       77,  -38,   72,       86,  -52,   80,
      35,   57,   33,       38,   48,   36,       43,   34,   42,       51,   16,   49,
      59,   -3,   57,       68,  -19,   64,       77,  -35,   72,       87,  -49,   80,
      36,   59,   35,       39,   51,   38,       45,   37,   43,       52,   19,   50,
      60,    1,   58,       69,  -16,   65,       78,  -32,   73,       87,  -46,   81,
      38,   61,   38,       41,   53,   40,       46,   40,   45,       53,   23,   51,
      61,    5,   59,       70,  -12,   66,       79,  -28,   74,       88,  -43,   81,
      40,   63,   40,       42,   56,   42,       47,   43,   47,       54,   26,   53,
      62,    8,   60,       70,   -9,   67,       79,  -25,   74,       88,  -40,   82,
      42,   65,   42,       44,   58,   44,       49,   46,   48,       55,   30,   54,
      63,   12,   61,       71,   -5,   68,       80,  -22,   75,       89,  -37,   83,
      43,   68,   44,       46,   61,   46,       50,   49,   50,       56,   33,   56,
      64,   16,   62,       72,   -1,   69,       80,  -18,   76,       89,  -34,   83,
      45,   70,   47,       47,   63,   48,       52,   52,   52,       57,   37,   57,
      65,   19,   63,       73,    2,   70,       81,  -14,   77,       90,  -30,   84,
      47,   72,   49,       49,   66,   50,       53,   55,   54,       59,   40,   59,
      66,   23,   64,       73,    6,   71,       82,  -11,   78,       90,  -27,   85,
      49,   74,   51,       50,   68,   52,       54,   57,   55,       60,   43,   60,
      67,   26,   66,       74,    9,   72,       82,   -8,   78,       91,  -24,   85,
      50,   76,   53,       52,   70,   54,       56,   60,   57,       61,   46,   62,
      68,   30,   67,       75,   13,   73,       83,   -4,   79,       92,  -20,   86,
      52,   78,   55,       54,   73,   56,       57,   63,   59,       62,   49,   63,
      69,   33,   68,       76,   16,   74,       84,    0,   80,       92,  -17,   87,
      54,   80,   57,       55,   75,   58,       59,   65,   61,       64,   52,   65,
      70,   36,   70,       77,   20,   75,       85,    3,   81,       93,  -13,   88,
       4,    5,  -20,       16,  -16,   -2,       28,  -31,   16,       40,  -43,   30,
      51,  -53,   43,       62,  -63,   54,       72,  -72,   64,       83,  -81,   74,
       4,    7,  -19,       16,  -14,   -1,       28,  -30,   16,       40,  -42,   30,
      51,  -53,   43,       62,  -63,   54,       72,  -72,   64,       83,  -81,   74,
       5,   10,  -18,       16,  -12,   -1,       28,  -28,   16,       40,  -41,   30,
      51,  -52,   43,       62,  -62,   54,       73,  -71,   64,       83,  -80,   74,
       6,   14,  -17,       17,   -9,    0,       29,  -27,   16,       40,  -40,   30,
      52,  -51,   43,       62,  -61,   54,       73,  -71,   64,       83,  -80,   74,
       7,   17,  -15,       17,   -6,    1,       29,  -24,   17,       40,  -38,   31,
      52,  -50,   43,       62,  -60,   54,       73,  -70,   64,       83,  -79,   74,
       8,   20,  -13,       18,   -3,    2,       29,  -22,   17,       41,  -36,   31,
      52,  -49,   44,       62,  -59,   54,       73,  -69,   64,       83,  -79,   74,
      10,   23,  -10,       19,    1,    3,       30,  -19,   18,       41,  -34,   32,
      52,  -47,   44,       63,  -58,   55,       73,  -68,   64,       83,  -78,   74,
      11,   26,   -7,       20,    5,    5,       30,  -15,   19,       41,  -31,   32,
      52,  -45,   44,       63,  -56,   55,       73,  -67,   65,       83,  -77,   74,
      13,   29,   -5,       21,    9,    6,       31,  -11,   20,       42,  -28,   33,
      53,  -43,   45,       63,  -55,   55,       73,  -65,   65,       83,  -76,   74,
      15,   31,   -2,       22,   13,    8,       32,   -8,   21,       42,  -25,   33,
      53,  -40,   45,       63,  -53,   55,       73,  -64,   65,       84,  -74,   74,
      17,   34,    1,       23,   16,   10,       32,   -4,   22,       43,  -22,   34,
      53,  -37,   46,       64,  -50,   56,       74,  -62,   65,       84,  -73,   75,
      18,   36,    4,       24,   20,   12,       33,    0,   23,       43,  -18,   35,
      54,  -35,   46,       64,  -48,   56,       74,  -60,   66,       84,  -71,   75,
      20,   39,    7,       26,   24,   14,       34,    4,   25,       44,  -14,   36,
      54,  -31,   47,       64,  -45,   57,       74,  -57,   66,       84,  -69,   75,
      22,   41,    9,       27,   27,   16,       35,    8,   26,       45,  -11,   37,
      55,  -28,   47,       65,  -42,   57,       74,  -55,   66,       84,  -67,   76,
      24,   43,   12,       29,   31,   18,       36,   12,   27,       45,   -7,   38,
      55,  -25,   48,       65,  -39,   58,       75,  -53,   67,       85,  -65,   76,
      26,   46,   15,       30,   34,   20,       37,   16,   29,       46,   -3,   39,
      56,  -21,   49,       65,  -36,   58,       75,  -50,   67,       85,  -63,   76,
      28,   48,   18,       32,   37,   23,       39,   20,   31,       47,    1,   40,
      56,  -17,   50,       66,  -33,   59,       76,  -47,   68,       85,  -60,   77,
      29,   50,   20,       33,   40,   25,       40,   23,   32,       48,    5,   41,
      57,  -14,   51,       67,  -30,   60,       76,  -44,   68,       86,  -57,   77,
      31,   53,   23,       35,   43,   27,       41,   27,   34,       49,    8,   42,
      58,  -10,   52,       67,  -26,   60,       76,  -41,   69,       86,  -55,   78,
      33,   55,   25,       36,   46,   29,       42,   30,   36,       50,   12,   44,
      59,   -6,   53,       68,  -23,   61,       77,  -38,   70,       86,  -52,   78,
      35,   57,   28,       38,   49,   32,       43,   34,   38,       51,   16,   45,
      59,   -2,   54,       68,  -19,   62,       77,  -35,   70,       87,  -49,   79,
      37,   59,   31,       39,   51,   34,       45,   37,   39,       52,   20,   47,
      60,    1,   55,       69,  -16,   63,       78,  -31,   71,       87,  -46,   79,
      38,   61,   33,       41,   54,   36,       46,   40,   41,       53,   23,   48,
      61,    5,   56,       70,  -12,   64,       79,  -28,   72,       88,  -43,   80,
      40,   63,   35,       43,   56,   38,       47,   43,   43,       54,   27,   49,
      62,    8,   57,       70,   -9,   65,       79,  -25,   72,       88,  -40,   80,
      42,   65,   38,       44,   59,   40,       49,   46,   45,       55,   30,   51,
      63,   12,   58,       71,   -5,   66,       80,  -21,   73,       89,  -37,   81,
      44,   68,   40,       46,   61,   42,       50,   49,   47,       56,   34,   52,
      64,   16,   59,       72,   -1,   67,       80,  -18,   74,       89,  -33,   82,
      45,   70,   42,       47,   64,   44,       52,   52,   48,       57,   37,   54,
      65,   19,   61,       73,    2,   68,       81,  -14,   75,       90,  -30,   82,
      47,   72,   45,       49,   66,   46,       53,   55,   50,       59,   40,   55,
      66,   23,   62,       74,    6,   69,       82,  -11,   76,       91,  -27,   83,
      49,   74,   47,       51,   68,   49,       54,   58,   52,       60,   43,   57,
      67,   26,   63,       74,    9,   70,       82,   -7,   77,       91,  -24,   84,
      50,   76,   49,       52,   71,   51,       56,   60,   54,       61,   47,   59,
      68,   30,   65,       75,   13,   71,       83,   -4,   78,       92,  -20,   85,
      52,   78,   51,       54,   73,   53,       57,   63,   56,       62,   50,   60,
      69,   33,   66,       76,   16,   72,       84,    0,   79,       92,  -17,   86,
      54,   80,   53,       55,   75,   55,       59,   66,   58,       64,   52,   62,
      70,   36,   67,       77,   20,   73,       85,    3,   79,       93,  -13,   86,
       4,    9,  -25,       16,  -13,   -7,       28,  -29,   11,       40,  -41,   26,
      51,  -52,   39,       62,  -62,   51,       72,  -71,   61,       83,  -81,   71,
       5,   11,  -24,       16,  -11,   -6,       28,  -28,   11,       40,  -41,   26,
      51,  -52,   39,       62,  -62,   51,       73,  -71,   62,       83,  -80,   72,
       5,   14,  -23,       17,   -9,   -6,       28,  -27,   11,       40,  -40,   26,
      51,  -51,   40,       62,  -61,   51,       73,  -71,   62,       83,  -80,   72,
       6,   17,  -22,       17,   -7,   -5,       29,  -25,   12,       40,  -39,   26,
      52,  -50,   40,       62,  -61,   51,       73,  -70,   62,       83,  -80,   72,
       7,   20,  -20,       18,   -4,   -4,       29,  -23,   12,       40,  -37,   27,
      52,  -49,   40,       62,  -60,   51,       73,  -70,   62,       83,  -79,   72,
       9,   22,  -18,       18,   -1,   -3,       29,  -20,   13,       41,  -35,   27,
      52,  -48,   40,       62,  -59,   52,       73,  -69,   62,       83,  -78,   72,
      10,   24,  -16,       19,    3,   -2,       30,  -17,   13,       41,  -33,   27,
      52,  -46,   40,       63,  -57,   52,       73,  -68,   62,       83,  -77,   72,
      12,   27,  -13,       20,    7,    0,       30,  -14,   14,       41,  -30,   28,
      52,  -44,   41,       63,  -56,   52,       73,  -66,   62,       83,  -76,   72,
      13,   30,  -10,       21,   10,    1,       31,  -10,   15,       42,  -27,   29,
      53,  -42,   41,       63,  -54,   52,       73,  -65,   62,       84,  -75,   72,
      15,   32,   -7,       22,   14,    3,       32,   -6,   16,       42,  -24,   29,
      53,  -39,   42,       63,  -52,   53,       73,  -63,   63,       84,  -74,   72,
      17,   35,   -5,       23,   18,    5,       33,   -3,   17,       43,  -21,   30,
      53,  -37,   42,       64,  -50,   53,       74,  -61,   63,       84,  -72,   73,
      19,   37,   -2,       25,   21,    7,       33,    1,   19,       43,  -18,   31,
      54,  -34,   43,       64,  -47,   53,       74,  -59,   63,       84,  -71,   73,
      21,   40,    1,       26,   25,    9,       34,    5,   20,       44,  -14,   32,
      54,  -30,   43,       64,  -45,   54,       74,  -57,   64,       84,  -69,   73,
      22,   42,    4,       27,   28,   11,       35,    9,   22,       45,  -10,   33,
      55,  -27,   44,       65,  -42,   54,       75,  -55,   64,       85,  -67,   74,
      24,   44,    7,       29,   31,   13,       36,   13,   23,       45,   -6,   34,
      55,  -24,   45,       65,  -39,   55,       75,  -52,   65,       85,  -65,   74,
      26,   46,   10,       30,   34,   15,       37,   16,   25,       46,   -3,   35,
      56,  -21,   46,       66,  -36,   56,       75,  -50,   65,       85,  -62,   74,
      28,   49,   13,       32,   38,   18,       39,   20,   26,       47,    2,   36,
      57,  -17,   47,       66,  -32,   56,       76,  -47,   66,       85,  -60,   75,
      30,   51,   15,       33,   40,   20,       40,   24,   28,       48,    5,   37,
      57,  -13,   47,       67,  -29,   57,       76,  -44,   66,       86,  -57,   75,
      31,   53,   18,       35,   43,   22,       41,   27,   30,       49,    9,   39,
      58,  -10,   48,       67,  -26,   58,       76,  -41,   67,       86,  -55,   76,
      33,   55,   20,       36,   46,   24,       42,   31,   31,       50,   13,   40,
      59,   -6,   49,       68,  -23,   58,       77,  -38,   67,       87,  -52,   76,
      35,   58,   23,       38,   49,   27,       44,   34,   33,       51,   17,   42,
      59,   -2,   51,       68,  -19,   59,       77,  -34,   68,       87,  -49,   77,
      37,   60,   26,       40,   51,   29,       45,   37,   35,       52,   20,   43,
      60,    2,   52,       69,  -15,   60,       78,  -31,   69,       87,  -46,   77,
      38,   62,   28,       41,   54,   31,       46,   40,   37,       53,   24,   44,
      61,    5,   53,       70,  -12,   61,       79,  -28,   69,       88,  -43,   78,
      40,   64,   31,       43,   56,   33,       47,   43,   39,       54,   27,   46,
      62,    9,   54,       70,   -8,   62,       79,  -24,   70,       88,  -40,   78,
      42,   66,   33,       44,   59,   36,       49,   46,   41,       55,   30,   47,
      63,   12,   55,       71,   -5,   63,       80,  -21,   71,       89,  -37,   79,
      44,   68,   36,       46,   62,   38,       50,   50,   43,       56,   34,   49,
      64,   16,   56,       72,   -1,   64,       80,  -17,   72,       89,  -33,   80,
      45,   70,   38,       47,   64,   40,       52,   52,   45,       58,   37,   50,
      65,   20,   58,       73,    3,   65,       81,  -14,   73,       90,  -30,   81,
      47,   72,   40,       49,   66,   42,       53,   55,   46,       59,   40,   52,
      66,   23,   59,       74,    6,   66,       82,  -11,   74,       91,  -27,   81,
      49,   74,   42,       51,   68,   44,       54,   58,   48,       60,   43,   54,
      67,   26,   60,       74,    9,   67,       82,   -7,   74,       91,  -23,   82,
      50,   76,   45,       52,   71,   47,       56,   61,   50,       61,   47,   55,
      68,   30,   62,       75,   13,   68,       83,   -3,   75,       92,  -20,   83,
      52,   78,   47,       54,   73,   49,       57,   63,   52,       62,   50,   57,
      69,   33,   63,       76,   17,   70,       84,    0,   76,       92,  -16,   84,
      54,   80,   49,       55,   75,   51,       59,   66,   54,       64,   53,   59,
      70,   37,   64,       77,   20,   71,       85,    3,   77,       93,  -13,   85,
       5,   14,  -30,       16,   -9,  -12,       28,  -26,    5,       40,  -40,   21,
      51,  -51,   35,       62,  -61,   47,       73,  -71,   58,       83,  -80,   69,
       6,   16,  -30,       17,   -7,  -12,       29,  -25,    6,       40,  -39,   21,
      51,  -51,   35,       62,  -61,   47,       73,  -70,   58,       83,  -80,   69,
       6,   18,  -29,       17,   -6,  -12,       29,  -24,    6,       40,  -38,   21,
      52,  -50,   35,       62,  -61,   48,       73,  -70,   59,       83,  -79,   69,
       7,   20,  -27,       17,   -4,  -11,       29,  -23,    6,       40,  -37,   22,
      52,  -49,   36,       62,  -60,   48,       73,  -70,   59,       83,  -79,   69,
       8,   22,  -26,       18,   -1,  -10,       29,  -20,    7,       41,  -35,   22,
      52,  -48,   36,       62,  -59,   48,       73,  -69,   59,       83,  -78,   69,
       9,   24,  -23,       19,    2,   -9,       30,  -18,    7,       41,  -34,   22,
      52,  -47,   36,       63,  -58,   48,       73,  -68,   59,       83,  -78,   69,
      11,   27,  -21,       19,    5,   -8,       30,  -15,    8,       41,  -31,   23,
      52,  -45,   36,       63,  -57,   48,       73,  -67,   59,       83,  -77,   69,
      12,   29,  -18,       20,    9,   -6,       31,  -12,    9,       41,  -29,   23,
      52,  -43,   37,       63,  -55,   48,       73,  -66,   59,       83,  -76,   70,
      14,   31,  -16,       21,   12,   -4,       31,   -8,   10,       42,  -26,   24,
      53,  -41,   37,       63,  -53,   49,       73,  -64,   59,       84,  -75,   70,
      16,   33,  -13,       22,   16,   -3,       32,   -5,   11,       42,  -23,   25,
      53,  -38,   38,       63,  -51,   49,       73,  -63,   60,       84,  -73,   70,
      17,   36,  -10,       24,   19,   -1,       33,   -1,   12,       43,  -20,   25,
      53,  -36,   38,       64,  -49,   49,       74,  -61,   60,       84,  -72,   70,
      19,   38,   -8,       25,   22,    1,       34,    2,   13,       43,  -16,   26,
      54,  -33,   39,       64,  -47,   50,       74,  -59,   60,       84,  -70,   70,
      21,   40,   -5,       26,   26,    3,       35,    6,   15,       44,  -13,   27,
      54,  -30,   39,       64,  -44,   50,       74,  -56,   61,       84,  -68,   71,
      23,   43,   -2,       28,   29,    5,       35,   10,   16,       45,   -9,   28,
      55,  -26,   40,       65,  -41,   51,       75,  -54,   61,       85,  -66,   71,
      24,   45,    1,       29,   32,    8,       36,   14,   18,       45,   -5,   29,
      55,  -23,   41,       65,  -38,   52,       75,  -52,   62,       85,  -64,   71,
      26,   47,    4,       30,   35,   10,       38,   17,   19,       46,   -2,   30,
      56,  -20,   42,       66,  -35,   52,       75,  -49,   62,       85,  -62,   72,
      28,   49,    7,       32,   38,   12,       39,   21,   21,       47,    2,   32,
      57,  -16,   43,       66,  -32,   53,       76,  -46,   63,       85,  -59,   72,
      30,   52,    9,       33,   41,   14,       40,   25,   23,       48,    6,   33,
      57,  -12,   43,       67,  -29,   54,       76,  -43,   63,       86,  -57,   73,
      31,   54,   12,       35,   44,   17,       41,   28,   25,       49,   10,   34,
      58,   -9,   44,       67,  -25,   54,       77,  -40,   64,       86,  -54,   73,
      33,   56,   15,       36,   47,   19,       42,   31,   26,       50,   13,   35,
      59,   -5,   45,       68,  -22,   55,       77,  -37,   64,       87,  -51,   74,
      35,   58,   18,       38,   49,   21,       44,   35,   28,       51,   17,   37,
      60,   -1,   47,       68,  -18,   56,       78,  -34,   65,       87,  -48,   74,
      37,   60,   20,       40,   52,   24,       45,   38,   30,       52,   21,   38,
      60,    2,   48,       69,  -15,   57,       78,  -31,   66,       87,  -45,   75,
      39,   62,   23,       41,   54,   26,       46,   41,   32,       53,   24,   40,
      61,    6,   49,       70,  -11,   58,       79,  -27,   67,       88,  -42,   75,
      40,   64,   25,       43,   57,   28,       48,   44,   34,       54,   27,   41,
      62,    9,   50,       70,   -8,   59,       79,  -24,   67,       88,  -39,   76,
      42,   66,   28,       44,   59,   30,       49,   47,   36,       55,   31,   43,
      63,   13,   51,       71,   -4,   60,       80,  -21,   68,       89,  -36,   77,
      44,   68,   30,       46,   62,   33,       50,   50,   38,       56,   34,   45,
      64,   17,   53,       72,   -1,   61,       80,  -17,   69,       89,  -33,   77,
      45,   70,   33,       48,   64,   35,       52,   53,   40,       58,   38,   46,
      65,   20,   54,       73,    3,   62,       81,  -14,   70,       90,  -30,   78,
      47,   72,   35,       49,   66,   37,       53,   55,   42,       59,   41,   48,
      66,   23,   55,       74,    6,   63,       82,  -10,   71,       91,  -26,   79,
      49,   74,   37,       51,   69,   39,       54,   58,   44,       60,   44,   49,
      67,   27,   57,       74,   10,   64,       83,   -7,   72,       91,  -23,   80,
      51,   76,   40,       52,   71,   42,       56,   61,   46,       61,   47,   51,
      68,   30,   58,       75,   14,   65,       83,   -3,   73,       92,  -19,   80,
      52,   78,   42,       54,   73,   44,       57,   64,   48,       63,   50,   53,
      69,   34,   59,       76,   17,   66,       84,    0,   74,       92,  -16,   81,
      54,   80,   44,       56,   75,   46,       59,   66,   50,       64,   53,   55,
      70,   37,   61,       77,   20,   68,       85,    4,   75,       93,  -13,   82,
       6,   19,  -35,       17,   -5,  -17,       29,  -24,    1,       40,  -38,   17,
      52,  -50,   31,       62,  -60,   44,       73,  -70,   55,       83,  -79,   66,
       6,   20,  -34,       17,   -4,  -17,       29,  -23,    1,       40,  -37,   17,
      52,  -50,   31,       62,  -60,   44,       73,  -70,   55,       83,  -79,   66,
       7,   22,  -33,       17,   -3,  -16,       29,  -22,    1,       40,  -37,   17,
      52,  -49,   31,       62,  -60,   44,       73,  -69,   56,       83,  -79,   66,
       8,   23,  -32,       18,   -1,  -16,       29,  -20,    1,       40,  -35,   17,
      52,  -48,   32,       62,  -59,   44,       73,  -69,   56,       83,  -78,   66,
       9,   25,  -30,       18,    2,  -15,       29,  -18,    2,       41,  -34,   17,
      52,  -47,   32,       62,  -58,   44,       73,  -68,   56,       83,  -78,   67,
      10,   27,  -28,       19,    4,  -14,       30,  -16,    2,       41,  -32,   18,
      52,  -46,   32,       63,  -57,   45,       73,  -67,   56,       83,  -77,   67,
      11,   28,  -26,       20,    7,  -13,       30,  -13,    3,       41,  -30,   18,
      52,  -44,   32,       63,  -56,   45,       73,  -66,   56,       83,  -76,   67,
      13,   31,  -23,       21,   11,  -11,       31,  -10,    4,       42,  -27,   19,
      53,  -42,   33,       63,  -54,   45,       73,  -65,   56,       83,  -75,   67,
      14,   33,  -21,       22,   14,   -9,       31,   -7,    5,       42,  -25,   19,
      53,  -40,   33,       63,  -52,   45,       73,  -63,   56,       84,  -74,   67,
      16,   35,  -18,       23,   17,   -8,       32,   -4,    6,       42,  -22,   20,
      53,  -37,   34,       63,  -50,   46,       74,  -62,   57,       84,  -73,   67,
      18,   37,  -15,       24,   20,   -6,       33,    0,    7,       43,  -19,   21,
      54,  -35,   34,       64,  -48,   46,       74,  -60,   57,       84,  -71,   68,
      19,   39,  -13,       25,   24,   -4,       34,    3,    9,       44,  -15,   22,
      54,  -32,   35,       64,  -46,   46,       74,  -58,   57,       84,  -70,   68,
      21,   41,  -10,       27,   27,   -2,       35,    7,   10,       44,  -12,   23,
      54,  -29,   35,       64,  -43,   47,       74,  -56,   58,       84,  -68,   68,
      23,   44,   -7,       28,   30,    0,       36,   11,   12,       45,   -8,   24,
      55,  -26,   36,       65,  -40,   48,       75,  -54,   58,       85,  -66,   68,
      25,   46,   -4,       29,   33,    3,       37,   15,   13,       46,   -4,   25,
      55,  -22,   37,       65,  -38,   48,       75,  -51,   59,       85,  -64,   69,
      26,   48,   -1,       31,   36,    5,       38,   18,   15,       46,   -1,   26,
      56,  -19,   38,       66,  -35,   49,       75,  -49,   59,       85,  -61,   69,
      28,   50,    2,       32,   39,    7,       39,   22,   16,       47,    3,   27,
      57,  -15,   39,       66,  -31,   50,       76,  -45,   60,       86,  -59,   70,
      30,   52,    4,       34,   42,   10,       40,   25,   18,       48,    7,   29,
      57,  -12,   40,       67,  -28,   50,       76,  -43,   60,       86,  -56,   70,
      32,   54,    7,       35,   44,   12,       41,   29,   20,       49,   10,   30,
      58,   -8,   41,       67,  -25,   51,       77,  -40,   61,       86,  -54,   71,
      33,   56,   10,       37,   47,   14,       42,   32,   22,       50,   14,   31,
      59,   -5,   42,       68,  -22,   52,       77,  -37,   61,       87,  -51,   71,
      35,   58,   13,       38,   50,   17,       44,   35,   24,       51,   18,   33,
      60,   -1,   43,       69,  -18,   53,       78,  -33,   62,       87,  -48,   72,
      37,   61,   15,       40,   52,   19,       45,   38,   26,       52,   21,   34,
      60,    3,   44,       69,  -14,   54,       78,  -30,   63,       87,  -45,   72,
      39,   63,   18,       41,   55,   21,       46,   41,   28,       53,   25,   36,
      61,    6,   45,       70,  -11,   54,       79,  -27,   64,       88,  -42,   73,
      40,   64,   20,       43,   57,   23,       48,   44,   29,       54,   28,   37,
      62,   10,   46,       71,   -7,   55,       79,  -24,   64,       88,  -39,   74,
      42,   66,   23,       44,   60,   26,       49,   47,   31,       55,   31,   39,
      63,   13,   48,       71,   -4,   56,       80,  -20,   65,       89,  -36,   74,
      44,   69,   25,       46,   62,   28,       50,   50,   34,       57,   35,   41,
      64,   17,   49,       72,    0,   58,       81,  -17,   66,       90,  -32,   75,
      46,   71,   28,       48,   65,   31,       52,   53,   35,       58,   38,   42,
      65,   20,   50,       73,    3,   59,       81,  -13,   67,       90,  -29,   76,
      47,   73,   30,       49,   67,   33,       53,   56,   37,       59,   41,   44,
      66,   24,   52,       74,    7,   60,       82,  -10,   68,       91,  -26,   76,
      49,   74,   33,       51,   69,   35,       55,   58,   39,       60,   44,   46,
      67,   27,   53,       75,   10,   61,       83,   -6,   69,       91,  -23,   77,
      51,   77,   35,       53,   71,   37,       56,   61,   42,       61,   47,   47,
      68,   31,   55,       75,   14,   62,       83,   -3,   70,       92,  -19,   78,
      52,   79,   38,       54,   74,   40,       58,   64,   44,       63,   50,   49,
      69,   34,   56,       76,   17,   63,       84,    1,   71,       93,  -16,   79,
      54,   80,   40,       56,   76,   42,       59,   66,   45,       64,   53,   51,
      70,   37,   57,       77,   21,   64,       85,    4,   72,       93,  -13,   80,
       7,   23,  -39,       17,   -2,  -22,       29,  -21,   -4,       40,  -36,   12,
      52,  -49,   27,       62,  -59,   40,       73,  -69,   52,       83,  -79,   63,
       7,   24,  -38,       18,   -1,  -22,       29,  -20,   -4,       40,  -35,   12,
      52,  -48,   27,       62,  -59,   40,       73,  -69,   52,       83,  -78,   64,
       8,   25,  -37,       18,    1,  -21,       29,  -19,   -4,       40,  -35,   12,
      52,  -48,   27,       62,  -59,   40,       73,  -69,   52,       83,  -78,   64,
       9,   26,  -36,       18,    2,  -20,       29,  -18,   -3,       41,  -33,   13,
      52,  -47,   28,       62,  -58,   41,       73,  -68,   52,       83,  -78,   64,
      10,   27,  -34,       19,    5,  -20,       30,  -16,   -3,       41,  -32,   13,
      52,  -46,   28,       63,  -57,   41,       73,  -67,   53,       83,  -77,   64,
      11,   29,  -32,       19,    7,  -19,       30,  -14,   -2,       41,  -30,   13,
      52,  -44,   28,       63,  -56,   41,       73,  -66,   53,       83,  -76,   64,
      12,   31,  -30,       20,   10,  -17,       31,  -11,   -2,       41,  -28,   14,
      52,  -43,   28,       63,  -55,   41,       73,  -65,   53,       83,  -76,   64,
      14,   32,  -28,       21,   13,  -16,       31,   -8,   -1,       42,  -26,   14,
      53,  -41,   29,       63,  -53,   41,       73,  -64,   53,       84,  -75,   64,
      15,   34,  -25,       22,   16,  -14,       32,   -5,    0,       42,  -23,   15,
      53,  -39,   29,       63,  -51,   42,       73,  -63,   53,       84,  -73,   64,
      17,   36,  -23,       23,   19,  -13,       32,   -2,    1,       43,  -20,   16,
      53,  -36,   30,       64,  -49,   42,       74,  -61,   54,       84,  -72,   65,
      18,   38,  -20,       24,   22,  -11,       33,    1,    3,       43,  -17,   16,
      54,  -34,   30,       64,  -47,   42,       74,  -59,   54,       84,  -71,   65,
      20,   40,  -17,       25,   25,   -9,       34,    5,    4,       44,  -14,   17,
      54,  -31,   31,       64,  -45,   43,       74,  -57,   54,       84,  -69,   65,
      22,   42,  -14,       27,   28,   -7,       35,    9,    5,       44,  -10,   18,
      55,  -28,   31,       64,  -42,   43,       74,  -55,   55,       84,  -67,   65,
      23,   44,  -12,       28,   31,   -4,       36,   12,    7,       45,   -7,   19,
      55,  -25,   32,       65,  -40,   44,       75,  -53,   55,       85,  -65,   66,
      25,   47,   -9,       29,   34,   -2,       37,   16,    8,       46,   -3,   20,
      56,  -21,   33,       65,  -37,   45,       75,  -50,   55,       85,  -63,   66,
      27,   49,   -6,       31,   37,    0,       38,   19,   10,       47,    0,   22,
      56,  -18,   34,       66,  -34,   45,       75,  -48,   56,       85,  -61,   66,
      29,   51,   -3,       32,   40,    2,       39,   23,   12,       47,    4,   23,
      57,  -14,   35,       66,  -30,   46,       76,  -45,   57,       86,  -58,   67,
      30,   53,   -1,       34,   43,    5,       40,   26,   13,       48,    8,   24,
      57,  -11,   36,       67,  -27,   47,       76,  -42,   57,       86,  -56,   67,
      32,   55,    2,       35,   45,    7,       41,   29,   15,       49,   11,   26,
      58,   -8,   37,       67,  -24,   47,       77,  -39,   58,       86,  -53,   68,
      34,   57,    5,       37,   48,    9,       43,   33,   17,       50,   15,   27,
      59,   -4,   38,       68,  -21,   48,       77,  -36,   58,       87,  -50,   68,
      36,   59,    8,       38,   51,   12,       44,   36,   19,       51,   18,   29,
      60,    0,   39,       69,  -17,   49,       78,  -33,   59,       87,  -47,   69,
      37,   61,   10,       40,   53,   14,       45,   39,   21,       52,   22,   30,
      61,    3,   40,       69,  -14,   50,       78,  -30,   60,       88,  -44,   70,
      39,   63,   13,       42,   55,   16,       46,   42,   23,       53,   25,   32,
      61,    7,   41,       70,  -10,   51,       79,  -26,   61,       88,  -42,   70,
      41,   65,   15,       43,   58,   19,       48,   45,   25,       54,   28,   33,
      62,   10,   43,       71,   -7,   52,       79,  -23,   61,       88,  -39,   71,
      42,   67,   18,       45,   60,   21,       49,   48,   27,       55,   32,   35,
      63,   14,   44,       71,   -4,   53,       80,  -20,   62,       89,  -35,   71,
      44,   69,   21,       46,   63,   24,       51,   51,   29,       57,   35,   36,
      64,   18,   45,       72,    0,   54,       81,  -16,   63,       90,  -32,   72,
      46,   71,   23,       48,   65,   26,       52,   54,   31,       58,   38,   38,
      65,   21,   47,       73,    4,   55,       81,  -13,   64,       90,  -29,   73,
      47,   73,   26,       49,   67,   28,       53,   56,   33,       59,   42,   40,
      66,   24,   48,       74,    7,   56,       82,   -9,   65,       91,  -26,   74,
      49,   75,   28,       51,   69,   30,       55,   59,   35,       60,   45,   41,
      67,   28,   49,       75,   11,   57,       83,   -6,   66,       91,  -22,   75,
      51,   77,   31,       53,   72,   33,       56,   62,   37,       61,   48,   43,
      68,   31,   51,       76,   14,   59,       83,   -2,   67,       92,  -19,   75,
      52,   79,   33,       54,   74,   35,       58,   64,   39,       63,   51,   45,
      69,   34,   52,       76,   18,   60,       84,    1,   68,       93,  -15,   76,
      54,   81,   35,       56,   76,   37,       59,   67,   41,       64,   54,   47,
      70,   38,   54,       77,   21,   61,       85,    4,   69,       93,  -12,   77,
       8,   27,  -43,       18,    2,  -27,       29,  -18,   -9,       40,  -34,    8,
      52,  -47,   23,       62,  -58,   37,       73,  -68,   49,       83,  -78,   60,
       8,   27,  -42,       18,    3,  -26,       29,  -18,   -9,       41,  -33,    8,
      52,  -47,   23,       62,  -58,   37,       73,  -68,   49,       83,  -78,   61,
       9,   28,  -41,       18,    4,  -26,       29,  -17,   -8,       41,  -33,    8,
      52,  -46,   23,       63,  -57,   37,       73,  -68,   49,       83,  -77,   61,
      10,   29,  -40,       19,    6,  -25,       30,  -15,   -8,       41,  -31,    8,
      52,  -45,   23,       63,  -57,   37,       73,  -67,   49,       83,  -77,   61,
      11,   30,  -38,       19,    8,  -24,       30,  -13,   -8,       41,  -30,    8,
      52,  -44,   24,       63,  -56,   37,       73,  -66,   49,       83,  -76,   61,
      12,   31,  -37,       20,   10,  -23,       30,  -11,   -7,       41,  -28,    9,
      52,  -43,   24,       63,  -55,   37,       73,  -66,   49,       83,  -76,   61,
      13,   33,  -35,       21,   12,  -22,       31,   -9,   -6,       42,  -27,    9,
      53,  -41,   24,       63,  -54,   37,       73,  -65,   49,       83,  -75,   61,
      14,   34,  -32,       22,   15,  -20,       31,   -6,   -5,       42,  -24,   10,
      53,  -39,   25,       63,  -52,   38,       73,  -63,   50,       84,  -74,   61,
      16,   36,  -30,       22,   18,  -19,       32,   -3,   -4,       42,  -21,   10,
      53,  -37,   25,       63,  -50,   38,       73,  -62,   50,       84,  -73,   61,
      17,   38,  -27,       23,   21,  -17,       33,    0,   -3,       43,  -19,   11,
      53,  -35,   25,       64,  -48,   38,       74,  -60,   50,       84,  -71,   62,
      19,   40,  -25,       25,   24,  -16,       33,    3,   -2,       43,  -16,   12,
      54,  -32,   26,       64,  -46,   39,       74,  -59,   50,       84,  -70,   62,
      20,   41,  -22,       26,   26,  -14,       34,    6,   -1,       44,  -13,   13,
      54,  -30,   27,       64,  -44,   39,       74,  -57,   51,       84,  -68,   62,
      22,   44,  -19,       27,   30,  -11,       35,   10,    1,       45,   -9,   14,
      55,  -27,   27,       65,  -41,   40,       74,  -54,   51,       84,  -66,   62,
      24,   46,  -17,       28,   32,   -9,       36,   13,    2,       45,   -6,   15,
      55,  -24,   28,       65,  -39,   40,       75,  -52,   52,       85,  -64,   63,
      25,   47,  -14,       30,   35,   -7,       37,   17,    4,       46,   -2,   16,
      56,  -20,   29,       65,  -36,   41,       75,  -50,   52,       85,  -62,   63,
      27,   49,  -11,       31,   38,   -5,       38,   20,    5,       47,    1,   17,
      56,  -17,   30,       66,  -33,   41,       75,  -47,   53,       85,  -60,   63,
      29,   52,   -8,       33,   41,   -2,       39,   24,    7,       48,    5,   18,
      57,  -14,   31,       66,  -30,   42,       76,  -44,   53,       86,  -58,   64,
      31,   54,   -6,       34,   43,    0,       40,   27,    9,       48,    8,   20,
      58,  -10,   32,       67,  -27,   43,       76,  -41,   54,       86,  -55,   64,
      32,   56,   -3,       36,   46,    2,       42,   30,   11,       49,   12,   21,
      58,   -7,   33,       67,  -23,   44,       77,  -38,   54,       86,  -53,   65,
      34,   57,    0,       37,   48,    4,       43,   33,   12,       50,   15,   23,
      59,   -3,   34,       68,  -20,   45,       77,  -36,   55,       87,  -50,   65,
      36,   60,    3,       39,   51,    7,       44,   37,   15,       51,   19,   24,
      60,    1,   35,       69,  -16,   46,       78,  -32,   56,       87,  -47,   66,
      37,   62,    5,       40,   54,    9,       45,   40,   16,       52,   23,   26,
      61,    4,   36,       69,  -13,   46,       78,  -29,   57,       88,  -44,   67,
      39,   64,    8,       42,   56,   12,       47,   43,   18,       53,   26,   27,
      61,    7,   37,       70,  -10,   47,       79,  -26,   57,       88,  -41,   67,
      41,   65,   11,       43,   58,   14,       48,   46,   20,       54,   29,   29,
      62,   11,   39,       71,   -6,   48,       79,  -23,   58,       89,  -38,   68,
      42,   67,   13,       45,   61,   16,       49,   48,   22,       55,   32,   30,
      63,   14,   40,       71,   -3,   49,       80,  -19,   59,       89,  -35,   69,
      44,   70,   16,       46,   63,   19,       51,   51,   25,       57,   36,   32,
      64,   18,   41,       72,    1,   51,       81,  -16,   60,       90,  -31,   69,
      46,   71,   18,       48,   65,   21,       52,   54,   27,       58,   39,   34,
      65,   21,   43,       73,    4,   52,       81,  -12,   61,       90,  -28,   70,
      47,   73,   21,       50,   68,   24,       53,   57,   29,       59,   42,   36,
      66,   25,   44,       74,    8,   53,       82,   -9,   62,       91,  -25,   71,
      49,   75,   23,       51,   70,   26,       55,   59,   31,       60,   45,   37,
      67,   28,   45,       75,   11,   54,       83,   -6,   63,       91,  -22,   72,
      51,   77,   26,       53,   72,   28,       56,   62,   33,       62,   48,   39,
      68,   32,   47,       76,   15,   55,       83,   -2,   64,       92,  -18,   73,
      53,   79,   28,       54,   74,   31,       58,   65,   35,       63,   51,   41,
      69,   35,   48,       76,   18,   56,       84,    1,   65,       93,  -15,   73,
      54,   81,   31,       56,   76,   33,       59,   67,   37,       64,   54,   43,
      70,   38,   50,       77,   21,   58,       85,    5,   66,       93,  -12,   74,
       9,   30,  -46,       18,    6,  -31,       30,  -15,  -14,       41,  -32,    3,
      52,  -45,   19,       63,  -57,   33,       73,  -67,   45,       83,  -77,   57,
       9,   30,  -46,       19,    7,  -31,       30,  -15,  -13,       41,  -31,    3,
      52,  -45,   19,       63,  -56,   33,       73,  -67,   45,       83,  -77,   57,
      10,   31,  -45,       19,    8,  -30,       30,  -14,  -13,       41,  -30,    3,
      52,  -44,   19,       63,  -56,   33,       73,  -67,   45,       83,  -77,   57,
      11,   32,  -44,       19,    9,  -29,       30,  -12,  -13,       41,  -29,    4,
      52,  -44,   19,       63,  -55,   33,       73,  -66,   45,       83,  -76,   57,
      11,   32,  -42,       20,   11,  -29,       30,  -11,  -12,       41,  -28,    4,
      52,  -43,   19,       63,  -55,   33,       73,  -65,   46,       83,  -76,   58,
      12,   34,  -41,       20,   13,  -28,       31,   -9,  -12,       41,  -26,    4,
      52,  -41,   20,       63,  -54,   33,       73,  -65,   46,       83,  -75,   58,
      14,   35,  -39,       21,   15,  -27,       31,   -7,  -11,       42,  -25,    5,
      53,  -40,   20,       63,  -52,   33,       73,  -64,   46,       84,  -74,   58,
      15,   36,  -36,       22,   17,  -25,       32,   -4,  -10,       42,  -22,    5,
      53,  -38,   20,       63,  -51,   34,       73,  -62,   46,       84,  -73,   58,
      16,   38,  -34,       23,   20,  -24,       32,   -1,   -9,       43,  -20,    6,
      53,  -36,   21,       63,  -49,   34,       74,  -61,   46,       84,  -72,   58,
      18,   39,  -32,       24,   23,  -22,       33,    2,   -8,       43,  -17,    7,
      54,  -34,   21,       64,  -47,   34,       74,  -59,   47,       84,  -71,   58,
      19,   41,  -29,       25,   25,  -20,       34,    5,   -7,       43,  -14,    7,
      54,  -31,   22,       64,  -45,   35,       74,  -58,   47,       84,  -69,   59,
      21,   43,  -27,       26,   28,  -18,       34,    8,   -6,       44,  -11,    8,
      54,  -28,   22,       64,  -43,   35,       74,  -56,   47,       84,  -67,   59,
      22,   45,  -24,       27,   31,  -16,       35,   12,   -4,       45,   -8,    9,
      55,  -25,   23,       65,  -40,   36,       75,  -53,   48,       85,  -66,   59,
      24,   47,  -21,       29,   34,  -14,       36,   15,   -3,       45,   -4,   10,
      55,  -22,   24,       65,  -38,   36,       75,  -51,   48,       85,  -64,   60,
      26,   49,  -19,       30,   36,  -12,       37,   18,   -1,       46,   -1,   11,
      56,  -19,   25,       65,  -35,   37,       75,  -49,   49,       85,  -62,   60,
      27,   50,  -16,       31,   39,  -10,       38,   21,    1,       47,    2,   13,
      56,  -16,   26,       66,  -32,   38,       76,  -46,   49,       85,  -59,   60,
      29,   53,  -13,       33,   42,   -7,       39,   25,    2,       48,    6,   14,
      57,  -13,   27,       66,  -29,   38,       76,  -43,   50,       86,  -57,   61,
      31,   54,  -10,       34,   44,   -5,       41,   28,    4,       49,    9,   15,
      58,   -9,   27,       67,  -26,   39,       76,  -41,   50,       86,  -54,   61,
      32,   56,   -8,       36,   47,   -3,       42,   31,    6,       49,   13,   17,
      58,   -6,   29,       68,  -23,   40,       77,  -38,   51,       86,  -52,   62,
      34,   58,   -5,       37,   49,    0,       43,   34,    8,       50,   16,   18,
      59,   -2,   30,       68,  -19,   41,       77,  -35,   52,       87,  -49,   62,
      36,   60,   -2,       39,   52,    2,       44,   38,   10,       51,   20,   20,
      60,    1,   31,       69,  -16,   42,       78,  -31,   52,       87,  -46,   63,
      38,   62,    1,       40,   54,    5,       46,   40,   12,       52,   23,   21,
      61,    5,   32,       69,  -12,   43,       78,  -28,   53,       88,  -43,   64,
      39,   64,    3,       42,   57,    7,       47,   43,   14,       53,   27,   23,
      62,    8,   33,       70,   -9,   44,       79,  -25,   54,       88,  -40,   64,
      41,   66,    6,       43,   59,    9,       48,   46,   16,       55,   30,   24,
      62,   12,   34,       71,   -6,   45,       79,  -22,   55,       89,  -37,   65,
      43,   68,    8,       45,   61,   12,       49,   49,   18,       56,   33,   26,
      63,   15,   36,       71,   -2,   46,       80,  -19,   56,       89,  -34,   65,
      44,   70,   11,       47,   64,   14,       51,   52,   20,       57,   36,   28,
      64,   19,   37,       72,    1,   47,       81,  -15,   56,       90,  -31,   66,
      46,   72,   14,       48,   66,   17,       52,   55,   22,       58,   40,   30,
      65,   22,   39,       73,    5,   48,       81,  -12,   57,       90,  -28,   67,
      48,   74,   16,       50,   68,   19,       54,   57,   24,       59,   43,   31,
      66,   25,   40,       74,    8,   49,       82,   -8,   58,       91,  -25,   68,
      49,   76,   19,       51,   70,   21,       55,   60,   26,       60,   45,   33,
      67,   29,   41,       75,   12,   50,       83,   -5,   59,       91,  -21,   69,
      51,   78,   21,       53,   73,   24,       56,   63,   28,       62,   49,   35,
      68,   32,   43,       76,   15,   52,       84,   -1,   60,       92,  -18,   70,
      53,   80,   24,       54,   75,   26,       58,   65,   30,       63,   52,   37,
      69,   35,   44,       77,   19,   53,       84,    2,   61,       93,  -15,   70,
      54,   81,   26,       56,   77,   28,       59,   67,   32,       64,   54,   38,
      70,   38,   46,       77,   22,   54,       85,    5,   62,       93,  -11,   71,
      10,   33,  -50,       19,   10,  -36,       30,  -12,  -19,       41,  -29,   -2,
      52,  -43,   14,       63,  -55,   28,       73,  -66,   41,       83,  -76,   53,
      11,   33,  -50,       19,   11,  -35,       30,  -11,  -18,       41,  -28,   -2,
      52,  -43,   14,       63,  -55,   28,       73,  -66,   41,       83,  -76,   54,
      11,   34,  -49,       20,   11,  -35,       30,  -10,  -18,       41,  -28,   -2,
      52,  -42,   14,       63,  -54,   28,       73,  -65,   41,       83,  -75,   54,
      12,   34,  -48,       20,   13,  -34,       30,   -9,  -18,       41,  -27,   -1,
      52,  -42,   14,       63,  -54,   28,       73,  -65,   41,       83,  -75,   54,
      13,   35,  -47,       20,   14,  -34,       31,   -8,  -17,       41,  -25,   -1,
      52,  -41,   15,       63,  -53,   29,       73,  -64,   41,       83,  -74,   54,
      13,   36,  -45,       21,   16,  -33,       31,   -6,  -17,       42,  -24,   -1,
      53,  -39,   15,       63,  -52,   29,       73,  -63,   42,       83,  -74,   54,
      14,   37,  -43,       22,   18,  -32,       31,   -4,  -16,       42,  -22,    0,
      53,  -38,   15,       63,  -51,   29,       73,  -62,   42,       84,  -73,   54,
      16,   39,  -41,       23,   20,  -30,       32,   -1,  -15,       42,  -20,    0,
      53,  -36,   15,       63,  -49,   29,       74,  -61,   42,       84,  -72,   54,
      17,   40,  -39,       23,   23,  -29,       33,    1,  -14,       43,  -17,    1,
      53,  -34,   16,       64,  -48,   30,       74,  -60,   42,       84,  -71,   54,
      18,   41,  -37,       24,   25,  -27,       33,    4,  -13,       43,  -15,    2,
      54,  -32,   16,       64,  -46,   30,       74,  -58,   43,       84,  -70,   55,
      20,   43,  -34,       25,   27,  -25,       34,    7,  -12,       44,  -12,    2,
      54,  -29,   17,       64,  -44,   30,       74,  -56,   43,       84,  -68,   55,
      21,   45,  -32,       27,   30,  -23,       35,   10,  -11,       44,   -9,    3,
      54,  -27,   18,       64,  -42,   31,       74,  -55,   43,       84,  -67,   55,
      23,   46,  -29,       28,   33,  -21,       36,   14,   -9,       45,   -6,    4,
      55,  -24,   18,       65,  -39,   31,       75,  -52,   44,       85,  -65,   55,
      25,   48,  -26,       29,   35,  -19,       37,   17,   -8,       46,   -3,    5,
      55,  -21,   19,       65,  -36,   32,       75,  -50,   44,       85,  -63,   56,
      26,   50,  -24,       30,   38,  -17,       38,   20,   -6,       46,    0,    6,
      56,  -18,   20,       66,  -34,   33,       75,  -48,   45,       85,  -61,   56,
      28,   52,  -21,       32,   40,  -15,       39,   23,   -5,       47,    4,    8,
      57,  -15,   21,       66,  -31,   33,       76,  -45,   45,       85,  -59,   57,
      30,   54,  -18,       33,   43,  -12,       40,   26,   -3,       48,    7,    9,
      57,  -11,   22,       67,  -28,   34,       76,  -42,   46,       86,  -56,   57,
      31,   55,  -16,       35,   46,  -10,       41,   29,   -1,       49,   11,   10,
      58,   -8,   23,       67,  -25,   35,       76,  -40,   46,       86,  -54,   58,
      33,   57,  -13,       36,   48,   -8,       42,   32,    1,       50,   14,   12,
      59,   -5,   24,       68,  -22,   35,       77,  -37,   47,       86,  -51,   58,
      34,   59,  -10,       38,   50,   -6,       43,   35,    3,       51,   17,   13,
      59,   -1,   25,       68,  -18,   36,       77,  -34,   48,       87,  -48,   59,
      36,   61,   -7,       39,   53,   -3,       45,   39,    5,       52,   21,   15,
      60,    2,   26,       69,  -15,   37,       78,  -31,   48,       87,  -45,   59,
      38,   63,   -5,       41,   55,   -1,       46,   41,    7,       53,   24,   16,
      61,    6,   27,       70,  -11,   38,       78,  -27,   49,       88,  -43,   60,
      40,   65,   -2,       42,   57,    2,       47,   44,    9,       54,   27,   18,
      62,    9,   29,       70,   -8,   39,       79,  -24,   50,       88,  -40,   60,
      41,   67,    0,       44,   60,    4,       48,   47,   11,       55,   31,   19,
      63,   12,   30,       71,   -5,   40,       80,  -21,   51,       89,  -37,   61,
      43,   69,    3,       45,   62,    6,       50,   50,   13,       56,   34,   21,
      63,   16,   31,       72,   -2,   41,       80,  -18,   51,       89,  -34,   62,
      45,   71,    6,       47,   64,    9,       51,   53,   15,       57,   37,   23,
      64,   20,   33,       72,    2,   42,       81,  -14,   52,       90,  -30,   63,
      46,   73,    8,       48,   67,   11,       52,   55,   17,       58,   40,   25,
      65,   23,   34,       73,    6,   44,       81,  -11,   53,       90,  -27,   63,
      48,   74,   11,       50,   69,   14,       54,   58,   19,       59,   43,   26,
      66,   26,   35,       74,    9,   45,       82,   -8,   54,       91,  -24,   64,
      49,   76,   13,       51,   71,   16,       55,   60,   21,       60,   46,   28,
      67,   29,   37,       75,   12,   46,       83,   -5,   55,       91,  -21,   65,
      51,   78,   16,       53,   73,   19,       57,   63,   23,       62,   49,   30,
      68,   33,   38,       76,   16,   47,       84,   -1,   56,       92,  -17,   66,
      53,   80,   19,       55,   75,   21,       58,   66,   25,       63,   52,   32,
      69,   36,   40,       77,   19,   49,       84,    3,   58,       93,  -14,   67,
      54,   82,   21,       56,   77,   23,       59,   68,   27,       64,   55,   34,
      71,   39,   41,       78,   22,   50,       85,    6,   59,       93,  -11,   68,
      11,   36,  -54,       20,   14,  -40,       30,   -9,  -23,       41,  -26,   -6,
      52,  -41,   10,       63,  -54,   24,       73,  -65,   37,       83,  -75,   50,
      12,   36,  -53,       20,   14,  -40,       30,   -8,  -23,       41,  -26,   -6,
      52,  -41,   10,       63,  -53,   24,       73,  -64,   37,       83,  -75,   50,
      12,   37,  -52,       20,   15,  -39,       31,   -7,  -23,       41,  -25,   -6,
      52,  -40,   10,       63,  -53,   24,       73,  -64,   37,       83,  -74,   50,
      13,   37,  -51,       21,   16,  -39,       31,   -6,  -22,       42,  -24,   -6,
      53,  -40,   10,       63,  -52,   24,       73,  -63,   38,       83,  -74,   50,
      14,   38,  -50,       21,   17,  -38,       31,   -5,  -22,       42,  -23,   -6,
      53,  -39,   10,       63,  -51,   24,       73,  -63,   38,       84,  -73,   50,
      14,   39,  -49,       22,   19,  -37,       31,   -3,  -21,       42,  -22,   -5,
      53,  -37,   10,       63,  -50,   25,       73,  -62,   38,       84,  -73,   50,
      15,   39,  -47,       22,   21,  -36,       32,   -1,  -21,       42,  -20,   -5,
      53,  -36,   11,       63,  -49,   25,       73,  -61,   38,       84,  -72,   51,
      17,   41,  -45,       23,   23,  -34,       32,    1,  -20,       43,  -18,   -4,
      53,  -34,   11,       64,  -48,   25,       74,  -60,   38,       84,  -71,   51,
      18,   42,  -43,       24,   25,  -33,       33,    4,  -19,       43,  -15,   -4,
      54,  -32,   12,       64,  -46,   25,       74,  -58,   38,       84,  -70,   51,
      19,   43,  -41,       25,   27,  -31,       34,    6,  -18,       43,  -13,   -3,
      54,  -30,   12,       64,  -44,   26,       74,  -57,   39,       84,  -69,   51,
      21,   45,  -38,       26,   29,  -30,       34,    9,  -17,       44,  -10,   -2,
      54,  -28,   13,       64,  -42,   26,       74,  -55,   39,       84,  -67,   51,
      22,   46,  -36,       27,   32,  -28,       35,   12,  -15,       44,   -8,   -1,
      55,  -25,   13,       65,  -40,   27,       74,  -53,   39,       84,  -66,   52,
      24,   48,  -33,       28,   34,  -26,       36,   15,  -14,       45,   -4,    0,
      55,  -22,   14,       65,  -38,   27,       75,  -51,   40,       85,  -64,   52,
      25,   49,  -31,       30,   37,  -24,       37,   18,  -12,       46,   -1,    1,
      56,  -20,   15,       65,  -35,   28,       75,  -49,   40,       85,  -62,   52,
      27,   51,  -28,       31,   39,  -22,       38,   21,  -11,       47,    2,    2,
      56,  -17,   16,       66,  -33,   28,       75,  -47,   41,       85,  -60,   53,
      28,   53,  -26,       32,   42,  -20,       39,   24,   -9,       47,    5,    3,
      57,  -14,   16,       66,  -30,   29,       76,  -44,   41,       86,  -58,   53,
      30,   55,  -23,       34,   44,  -17,       40,   28,   -7,       48,    9,    5,
      57,  -10,   17,       67,  -27,   30,       76,  -41,   42,       86,  -55,   54,
      32,   56,  -20,       35,   47,  -15,       41,   31,   -6,       49,   12,    6,
      58,   -7,   18,       67,  -24,   31,       77,  -39,   42,       86,  -53,   54,
      33,   58,  -18,       36,   49,  -13,       42,   33,   -4,       50,   15,    7,
      59,   -4,   19,       68,  -21,   31,       77,  -36,   43,       87,  -50,   55,
      35,   60,  -15,       38,   51,  -10,       43,   36,   -2,       51,   18,    9,
      59,    0,   21,       68,  -17,   32,       77,  -33,   44,       87,  -48,   55,
      37,   62,  -12,       39,   54,   -8,       45,   40,    0,       52,   22,   10,
      60,    3,   22,       69,  -14,   33,       78,  -30,   45,       87,  -45,   56,
      38,   64,   -9,       41,   56,   -5,       46,   42,    2,       53,   25,   12,
      61,    7,   23,       70,  -11,   34,       79,  -27,   45,       88,  -42,   56,
      40,   66,   -7,       42,   58,   -3,       47,   45,    4,       54,   28,   13,
      62,   10,   24,       70,   -7,   35,       79,  -24,   46,       88,  -39,   57,
      41,   67,   -4,       44,   60,   -1,       48,   48,    6,       55,   31,   15,
      63,   13,   26,       71,   -4,   36,       80,  -20,   47,       89,  -36,   58,
      43,   69,   -2,       45,   63,    2,       50,   50,    8,       56,   35,   17,
      64,   17,   27,       72,   -1,   37,       80,  -17,   48,       89,  -33,   58,
      45,   71,    1,       47,   65,    4,       51,   53,   10,       57,   38,   19,
      65,   20,   28,       73,    3,   39,       81,  -14,   49,       90,  -30,   59,
      46,   73,    4,       49,   67,    7,       53,   56,   12,       58,   41,   20,
      66,   24,   30,       73,    6,   40,       82,  -10,   50,       90,  -27,   60,
      48,   75,    6,       50,   69,    9,       54,   58,   14,       59,   44,   22,
      66,   27,   31,       74,   10,   41,       82,   -7,   51,       91,  -23,   61,
      50,   77,    9,       52,   71,   11,       55,   61,   16,       61,   47,   24,
      67,   30,   33,       75,   13,   42,       83,   -4,   52,       92,  -20,   62,
      51,   79,   11,       53,   74,   14,       57,   64,   19,       62,   50,   26,
      69,   33,   34,       76,   17,   43,       84,    0,   53,       92,  -17,   63,
      53,   81,   14,       55,   76,   16,       58,   66,   21,       63,   53,   28,
      70,   37,   36,       77,   20,   45,       84,    3,   54,       93,  -14,   63,
      55,   82,   16,       56,   78,   19,       60,   68,   23,       64,   55,   29,
      71,   40,   37,       78,   23,   46,       85,    6,   55,       93,  -10,   64,
      13,   39,  -57,       20,   17,  -44,       31,   -5,  -27,       41,  -24,  -11,
      52,  -39,    5,       63,  -52,   20,       73,  -63,   33,       83,  -74,   46,
      13,   39,  -56,       21,   18,  -44,       31,   -5,  -27,       42,  -23,  -11,
      53,  -39,    5,       63,  -52,   20,       73,  -63,   34,       83,  -74,   46,
      13,   39,  -56,       21,   18,  -43,       31,   -4,  -27,       42,  -23,  -11,
      53,  -38,    6,       63,  -51,   20,       73,  -63,   34,       83,  -73,   47,
      14,   40,  -55,       21,   19,  -43,       31,   -3,  -27,       42,  -22,  -10,
      53,  -37,    6,       63,  -51,   20,       73,  -62,   34,       84,  -73,   47,
      15,   40,  -54,       22,   20,  -42,       32,   -2,  -26,       42,  -20,  -10,
      53,  -37,    6,       63,  -50,   20,       73,  -61,   34,       84,  -72,   47,
      15,   41,  -52,       22,   22,  -41,       32,    0,  -26,       42,  -19,  -10,
      53,  -35,    6,       63,  -49,   21,       73,  -61,   34,       84,  -72,   47,
      16,   42,  -51,       23,   23,  -40,       32,    2,  -25,       43,  -17,   -9,
      53,  -34,    6,       63,  -48,   21,       74,  -60,   34,       84,  -71,   47,
      17,   43,  -49,       24,   25,  -39,       33,    4,  -24,       43,  -15,   -9,
      53,  -32,    7,       64,  -46,   21,       74,  -58,   34,       84,  -70,   47,
      19,   44,  -47,       25,   27,  -37,       33,    6,  -23,       43,  -13,   -8,
      54,  -30,    7,       64,  -45,   21,       74,  -57,   35,       84,  -69,   47,
      20,   45,  -45,       25,   29,  -36,       34,    9,  -22,       44,  -11,   -7,
      54,  -28,    8,       64,  -43,   22,       74,  -56,   35,       84,  -67,   48,
      21,   46,  -43,       26,   32,  -34,       35,   11,  -21,       44,   -8,   -7,
      54,  -26,    8,       64,  -41,   22,       74,  -54,   35,       84,  -66,   48,
      23,   48,  -40,       28,   34,  -32,       35,   14,  -20,       45,   -6,   -6,
      55,  -24,    9,       65,  -39,   23,       75,  -52,   36,       85,  -65,   48,
      24,   49,  -38,       29,   36,  -30,       36,   17,  -18,       45,   -2,   -5,
      55,  -21,   10,       65,  -36,   23,       75,  -50,   36,       85,  -63,   48,
      26,   51,  -35,       30,   38,  -28,       37,   20,  -17,       46,    1,   -4,
      56,  -18,   10,       65,  -34,   24,       75,  -48,   36,       85,  -61,   49,
      27,   52,  -33,       31,   41,  -26,       38,   23,  -15,       47,    4,   -3,
      56,  -15,   11,       66,  -31,   24,       75,  -46,   37,       85,  -59,   49,
      29,   54,  -30,       33,   43,  -24,       39,   26,  -14,       47,    7,   -1,
      57,  -12,   12,       66,  -29,   25,       76,  -43,   37,       86,  -57,   50,
      30,   56,  -27,       34,   46,  -22,       40,   29,  -12,       48,   10,    0,
      58,   -9,   13,       67,  -25,   26,       76,  -40,   38,       86,  -54,   50,
      32,   58,  -25,       35,   48,  -19,       41,   32,  -10,       49,   13,    1,
      58,   -6,   14,       67,  -22,   27,       77,  -38,   39,       86,  -52,   51,
      34,   59,  -22,       37,   50,  -17,       43,   35,   -8,       50,   16,    3,
      59,   -2,   15,       68,  -19,   27,       77,  -35,   39,       87,  -49,   51,
      35,   61,  -19,       38,   52,  -15,       44,   37,   -7,       51,   20,    4,
      60,    1,   16,       68,  -16,   28,       78,  -32,   40,       87,  -47,   52,
      37,   63,  -17,       40,   55,  -12,       45,   41,   -4,       52,   23,    6,
      60,    4,   18,       69,  -13,   29,       78,  -29,   41,       87,  -44,   52,
      39,   65,  -14,       41,   57,  -10,       46,   43,   -2,       53,   26,    7,
      61,    8,   19,       70,  -10,   30,       79,  -26,   42,       88,  -41,   53,
      40,   66,  -11,       43,   59,   -8,       47,   46,   -1,       54,   29,    9,
      62,   11,   20,       70,   -6,   31,       79,  -23,   42,       88,  -38,   54,
      42,   68,   -9,       44,   61,   -5,       49,   49,    1,       55,   32,   11,
      63,   14,   21,       71,   -3,   32,       80,  -20,   43,       89,  -35,   54,
      43,   70,   -6,       46,   63,   -3,       50,   51,    4,       56,   35,   12,
      64,   17,   23,       72,    0,   33,       80,  -16,   44,       89,  -32,   55,
      45,   72,   -3,       47,   66,    0,       51,   54,    6,       57,   39,   14,
      65,   21,   24,       73,    4,   35,       81,  -13,   45,       90,  -29,   56,
      47,   74,   -1,       49,   68,    2,       53,   57,    8,       58,   42,   16,
      66,   24,   26,       73,    7,   36,       82,  -10,   46,       90,  -26,   57,
      48,   76,    2,       50,   70,    4,       54,   59,   10,       60,   45,   18,
      67,   27,   27,       74,   10,   37,       82,   -6,   47,       91,  -23,   57,
      50,   77,    4,       52,   72,    7,       55,   62,   12,       61,   47,   19,
      68,   31,   28,       75,   14,   38,       83,   -3,   48,       92,  -20,   58,
      52,   79,    7,       53,   74,    9,       57,   64,   14,       62,   51,   21,
      69,   34,   30,       76,   17,   39,       84,    0,   49,       92,  -16,   59,
      53,   81,    9,       55,   76,   12,       58,   67,   16,       63,   53,   23,
      70,   37,   32,       77,   20,   41,       85,    4,   50,       93,  -13,   60,
      55,   83,   12,       56,   78,   14,       60,   69,   19,       65,   56,   25,
      71,   40,   33,       78,   24,   42,       85,    7,   51,       94,  -10,   61,
      14,   41,  -60,       21,   21,  -48,       31,   -2,  -32,       42,  -21,  -15,
      53,  -37,    1,       63,  -50,   16,       73,  -62,   30,       84,  -73,   43,
      14,   41,  -60,       21,   21,  -48,       31,   -1,  -32,       42,  -20,  -15,
      53,  -36,    1,       63,  -50,   16,       73,  -61,   30,       84,  -72,   43,
      14,   42,  -59,       22,   22,  -47,       31,   -1,  -31,       42,  -20,  -15,
      53,  -36,    1,       63,  -49,   16,       73,  -61,   30,       84,  -72,   43,
      15,   42,  -58,       22,   23,  -47,       32,    0,  -31,       42,  -19,  -15,
      53,  -35,    1,       63,  -49,   16,       73,  -61,   30,       84,  -72,   43,
      16,   43,  -57,       22,   24,  -46,       32,    1,  -31,       42,  -18,  -14,
      53,  -34,    2,       63,  -48,   16,       73,  -60,   30,       84,  -71,   43,
      16,   43,  -56,       23,   25,  -45,       32,    3,  -30,       43,  -17,  -14,
      53,  -33,    2,       63,  -47,   16,       74,  -59,   30,       84,  -70,   43,
      17,   44,  -54,       24,   26,  -44,       33,    5,  -29,       43,  -15,  -14,
      53,  -32,    2,       64,  -46,   17,       74,  -58,   30,       84,  -70,   43,
      18,   45,  -52,       24,   28,  -43,       33,    7,  -28,       43,  -13,  -13,
      54,  -30,    3,       64,  -44,   17,       74,  -57,   30,       84,  -69,   43,
      19,   46,  -51,       25,   30,  -41,       34,    9,  -28,       44,  -11,  -12,
      54,  -28,    3,       64,  -43,   17,       74,  -56,   31,       84,  -68,   44,
      21,   47,  -49,       26,   32,  -40,       34,   11,  -27,       44,   -9,  -12,
      54,  -26,    3,       64,  -41,   18,       74,  -54,   31,       84,  -66,   44,
      22,   48,  -46,       27,   34,  -38,       35,   14,  -25,       44,   -6,  -11,
      55,  -24,    4,       65,  -39,   18,       74,  -53,   31,       84,  -65,   44,
      23,   49,  -44,       28,   36,  -36,       36,   16,  -24,       45,   -4,  -10,
      55,  -22,    5,       65,  -37,   18,       75,  -51,   32,       85,  -63,   44,
      25,   51,  -42,       29,   38,  -34,       37,   19,  -23,       46,   -1,   -9,
      56,  -19,    5,       65,  -35,   19,       75,  -49,   32,       85,  -62,   45,
      26,   52,  -39,       30,   40,  -32,       38,   22,  -21,       46,    2,   -8,
      56,  -16,    6,       66,  -32,   20,       75,  -47,   33,       85,  -60,   45,
      28,   54,  -37,       32,   42,  -30,       39,   25,  -20,       47,    5,   -7,
      57,  -14,    7,       66,  -30,   20,       76,  -44,   33,       85,  -58,   46,
      29,   55,  -34,       33,   44,  -28,       39,   27,  -18,       48,    8,   -6,
      57,  -11,    8,       66,  -27,   21,       76,  -42,   34,       86,  -56,   46,
      31,   57,  -32,       34,   47,  -26,       41,   30,  -16,       49,   12,   -4,
      58,   -7,    9,       67,  -24,   22,       76,  -39,   34,       86,  -53,   46,
      32,   59,  -29,       36,   49,  -24,       42,   33,  -15,       49,   15,   -3,
      58,   -4,   10,       67,  -21,   22,       77,  -37,   35,       86,  -51,   47,
      34,   60,  -26,       37,   51,  -22,       43,   36,  -13,       50,   18,   -2,
      59,   -1,   11,       68,  -18,   23,       77,  -34,   35,       87,  -48,   47,
      36,   62,  -24,       39,   53,  -19,       44,   39,  -11,       51,   21,    0,
      60,    2,   12,       69,  -15,   24,       78,  -31,   36,       87,  -46,   48,
      37,   64,  -21,       40,   56,  -17,       45,   42,   -9,       52,   24,    1,
      61,    6,   13,       69,  -12,   25,       78,  -28,   37,       88,  -43,   49,
      39,   66,  -18,       42,   58,  -14,       46,   44,   -7,       53,   27,    3,
      61,    9,   15,       70,   -9,   26,       79,  -25,   38,       88,  -40,   49,
      40,   67,  -16,       43,   60,  -12,       48,   47,   -5,       54,   30,    5,
      62,   12,   16,       71,   -5,   27,       79,  -22,   38,       88,  -37,   50,
      42,   69,  -13,       44,   62,  -10,       49,   50,   -3,       55,   33,    6,
      63,   15,   17,       71,   -2,   28,       80,  -19,   39,       89,  -34,   51,
      44,   71,  -11,       46,   64,   -7,       50,   52,   -1,       56,   36,    8,
      64,   18,   18,       72,    1,   29,       80,  -16,   40,       89,  -32,   51,
      45,   73,   -8,       48,   66,   -5,       52,   55,    1,       58,   40,   10,
      65,   22,   20,       73,    5,   30,       81,  -12,   41,       90,  -28,   52,
      47,   74,   -5,       49,   69,   -2,       53,   57,    3,       59,   43,   11,
      66,   25,   21,       74,    8,   32,       82,   -9,   42,       91,  -25,   53,
      49,   76,   -3,       50,   71,    0,       54,   60,    5,       60,   45,   13,
      67,   28,   23,       74,   11,   33,       82,   -6,   43,       91,  -22,   54,
      50,   78,    0,       52,   73,    2,       56,   62,    8,       61,   48,   15,
      68,   31,   24,       75,   14,   34,       83,   -2,   44,       92,  -19,   55,
      52,   80,    2,       54,   75,    5,       57,   65,   10,       62,   51,   17,
      69,   35,   26,       76,   18,   35,       84,    1,   45,       92,  -15,   56,
      53,   82,    5,       55,   77,    7,       59,   67,   12,       63,   54,   19,
      70,   38,   27,       77,   21,   37,       85,    4,   46,       93,  -12,   56,
      55,   83,    7,       57,   79,   10,       60,   70,   14,       65,   57,   21,
      71,   41,   29,       78,   24,   38,       85,    8,   48,       94,   -9,   57,
      15,   44,  -64,       22,   24,  -52,       32,    2,  -36,       42,  -18,  -20,
      53,  -34,   -4,       63,  -48,   11,       73,  -60,   25,       84,  -71,   39,
      15,   44,  -63,       22,   25,  -52,       32,    2,  -36,       42,  -17,  -20,
      53,  -34,   -4,       63,  -48,   11,       73,  -60,   25,       84,  -71,   39,
      16,   44,  -63,       22,   25,  -51,       32,    3,  -36,       42,  -17,  -20,
      53,  -33,   -4,       63,  -47,   11,       73,  -59,   25,       84,  -71,   39,
      16,   45,  -62,       23,   26,  -51,       32,    4,  -36,       42,  -16,  -20,
      53,  -33,   -3,       63,  -47,   11,       74,  -59,   25,       84,  -70,   39,
      17,   45,  -61,       23,   27,  -50,       32,    5,  -35,       43,  -15,  -19,
      53,  -32,   -3,       64,  -46,   12,       74,  -58,   25,       84,  -70,   39,
      17,   46,  -60,       24,   28,  -49,       33,    6,  -35,       43,  -13,  -19,
      53,  -31,   -3,       64,  -45,   12,       74,  -57,   26,       84,  -69,   39,
      18,   46,  -58,       24,   29,  -48,       33,    8,  -34,       43,  -12,  -19,
      54,  -29,   -3,       64,  -44,   12,       74,  -57,   26,       84,  -68,   39,
      19,   47,  -57,       25,   31,  -47,       34,   10,  -33,       44,  -10,  -18,
      54,  -28,   -2,       64,  -42,   12,       74,  -55,   26,       84,  -67,   39,
      20,   48,  -55,       26,   33,  -46,       34,   12,  -32,       44,   -8,  -17,
      54,  -26,   -2,       64,  -41,   13,       74,  -54,   26,       84,  -66,   39,
      22,   49,  -53,       27,   34,  -44,       35,   14,  -31,       44,   -6,  -17,
      55,  -24,   -1,       64,  -39,   13,       74,  -53,   26,       84,  -65,   40,
      23,   50,  -51,       28,   36,  -43,       36,   16,  -30,       45,   -4,  -16,
      55,  -22,   -1,       65,  -37,   13,       75,  -51,   27,       85,  -64,   40,
      24,   51,  -49,       29,   38,  -41,       36,   19,  -29,       45,   -1,  -15,
      55,  -20,    0,       65,  -35,   14,       75,  -49,   27,       85,  -62,   40,
      26,   53,  -46,       30,   40,  -39,       37,   21,  -28,       46,    2,  -14,
      56,  -17,    1,       65,  -33,   14,       75,  -47,   28,       85,  -60,   41,
      27,   54,  -44,       31,   42,  -37,       38,   24,  -26,       47,    4,  -13,
      56,  -14,    1,       66,  -31,   15,       75,  -45,   28,       85,  -58,   41,
      28,   55,  -42,       32,   44,  -35,       39,   27,  -25,       47,    7,  -12,
      57,  -12,    2,       66,  -28,   16,       76,  -43,   29,       86,  -56,   41,
      30,   57,  -39,       33,   46,  -33,       40,   29,  -23,       48,   10,  -11,
      57,   -9,    3,       67,  -26,   16,       76,  -41,   29,       86,  -54,   42,
      31,   58,  -36,       35,   48,  -31,       41,   32,  -21,       49,   13,   -9,
      58,   -6,    4,       67,  -23,   17,       77,  -38,   30,       86,  -52,   42,
      33,   60,  -34,       36,   51,  -29,       42,   35,  -20,       50,   16,   -8,
      59,   -3,    5,       68,  -20,   18,       77,  -35,   30,       86,  -50,   43,
      34,   62,  -31,       38,   53,  -26,       43,   37,  -18,       51,   19,   -7,
      59,    0,    6,       68,  -17,   19,       77,  -33,   31,       87,  -47,   43,
      36,   63,  -29,       39,   55,  -24,       44,   40,  -16,       51,   22,   -5,
      60,    3,    7,       69,  -14,   20,       78,  -30,   32,       87,  -45,   44,
      38,   65,  -26,       40,   57,  -22,       46,   43,  -14,       53,   26,   -3,
      61,    7,    9,       69,  -10,   21,       78,  -27,   33,       88,  -42,   44,
      39,   67,  -23,       42,   59,  -19,       47,   46,  -12,       53,   29,   -2,
      62,   10,   10,       70,   -7,   22,       79,  -24,   33,       88,  -39,   45,
      41,   68,  -21,       43,   61,  -17,       48,   48,  -10,       54,   32,    0,
      62,   13,   11,       71,   -4,   23,       79,  -21,   34,       89,  -36,   46,
      42,   70,  -18,       45,   63,  -15,       49,   51,   -8,       56,   35,    1,
      63,   16,   12,       71,   -1,   24,       80,  -18,   35,       89,  -33,   46,
      44,   72,  -16,       46,   65,  -12,       51,   53,   -6,       57,   37,    3,
      64,   20,   14,       72,    2,   25,       81,  -15,   36,       90,  -31,   47,
      46,   74,  -13,       48,   67,  -10,       52,   56,   -4,       58,   41,    5,
      65,   23,   15,       73,    6,   26,       81,  -11,   37,       90,  -27,   48,
      47,   75,  -10,       49,   69,   -7,       53,   58,   -2,       59,   44,    7,
      66,   26,   17,       74,    9,   27,       82,   -8,   38,       91,  -24,   49,
      49,   77,   -8,       51,   71,   -5,       55,   61,    0,       60,   46,    8,
      67,   29,   18,       74,   12,   28,       83,   -5,   39,       91,  -21,   50,
      50,   79,   -5,       52,   73,   -3,       56,   63,    3,       61,   49,   10,
      68,   32,   19,       75,   15,   29,       83,   -2,   40,       92,  -18,   50,
      52,   81,   -3,       54,   76,    0,       57,   66,    5,       62,   52,   12,
      69,   36,   21,       76,   19,   31,       84,    2,   41,       92,  -15,   51,
      54,   82,    0,       55,   77,    2,       59,   68,    7,       64,   55,   14,
      70,   39,   23,       77,   22,   32,       85,    5,   42,       93,  -12,   52,
      55,   84,    2,       57,   79,    5,       60,   70,    9,       65,   57,   16,
      71,   42,   24,       78,   25,   34,       86,    8,   43,       94,   -8,   53,
      16,   46,  -67,       23,   28,  -56,       32,    5,  -41,       43,  -15,  -24,
      53,  -32,   -8,       63,  -46,    7,       74,  -58,   21,       84,  -70,   35,
      17,   47,  -66,       23,   28,  -55,       32,    6,  -40,       43,  -14,  -24,
      53,  -31,   -8,       64,  -46,    7,       74,  -58,   21,       84,  -69,   35,
      17,   47,  -66,       23,   29,  -55,       33,    6,  -40,       43,  -14,  -24,
      53,  -31,   -8,       64,  -45,    7,       74,  -58,   21,       84,  -69,   35,
      17,   47,  -65,       24,   29,  -55,       33,    7,  -40,       43,  -13,  -24,
      53,  -30,   -8,       64,  -45,    7,       74,  -57,   21,       84,  -69,   35,
      18,   47,  -64,       24,   30,  -54,       33,    8,  -39,       43,  -12,  -24,
      54,  -29,   -8,       64,  -44,    7,       74,  -57,   21,       84,  -68,   35,
      18,   48,  -63,       24,   31,  -53,       33,    9,  -39,       43,  -11,  -23,
      54,  -28,   -7,       64,  -43,    8,       74,  -56,   22,       84,  -68,   35,
      19,   49,  -62,       25,   32,  -52,       34,   11,  -38,       43,   -9,  -23,
      54,  -27,   -7,       64,  -42,    8,       74,  -55,   22,       84,  -67,   35,
      20,   49,  -60,       26,   34,  -51,       34,   13,  -37,       44,   -7,  -22,
      54,  -26,   -7,       64,  -41,    8,       74,  -54,   22,       84,  -66,   35,
      21,   50,  -58,       27,   35,  -50,       35,   15,  -36,       44,   -6,  -22,
      54,  -24,   -6,       64,  -39,    8,       74,  -52,   22,       84,  -65,   36,
      22,   51,  -57,       27,   37,  -48,       35,   17,  -36,       45,   -4,  -21,
      55,  -22,   -6,       65,  -37,    9,       75,  -51,   22,       85,  -64,   36,
      24,   52,  -55,       28,   38,  -47,       36,   19,  -34,       45,   -1,  -20,
      55,  -20,   -5,       65,  -36,    9,       75,  -50,   23,       85,  -62,   36,
      25,   53,  -53,       29,   40,  -45,       37,   21,  -33,       46,    1,  -19,
      55,  -18,   -4,       65,  -34,   10,       75,  -48,   23,       85,  -61,   36,
      26,   54,  -50,       30,   42,  -43,       38,   24,  -32,       46,    4,  -18,
      56,  -15,   -4,       66,  -31,   10,       75,  -46,   24,       85,  -59,   37,
      28,   56,  -48,       32,   44,  -41,       38,   26,  -30,       47,    6,  -17,
      56,  -13,   -3,       66,  -29,   11,       76,  -44,   24,       85,  -57,   37,
      29,   57,  -46,       33,   46,  -39,       39,   28,  -29,       48,    9,  -16,
      57,  -10,   -2,       66,  -27,   11,       76,  -42,   25,       86,  -55,   38,
      30,   58,  -43,       34,   48,  -37,       40,   31,  -27,       48,   12,  -15,
      58,   -7,   -1,       67,  -24,   12,       76,  -39,   25,       86,  -53,   38,
      32,   60,  -40,       35,   50,  -35,       41,   34,  -26,       49,   15,  -14,
      58,   -4,    0,       67,  -21,   13,       77,  -36,   26,       86,  -51,   38,
      33,   61,  -38,       37,   52,  -33,       42,   36,  -24,       50,   18,  -12,
      59,   -1,    1,       68,  -18,   14,       77,  -34,   26,       87,  -49,   39,
      35,   63,  -36,       38,   54,  -31,       44,   39,  -22,       51,   21,  -11,
      59,    2,    2,       68,  -15,   15,       77,  -31,   27,       87,  -46,   39,
      36,   64,  -33,       39,   56,  -29,       45,   41,  -20,       52,   24,   -9,
      60,    5,    3,       69,  -13,   15,       78,  -29,   28,       87,  -44,   40,
      38,   66,  -30,       41,   58,  -26,       46,   44,  -18,       53,   27,   -8,
      61,    8,    4,       70,   -9,   16,       78,  -25,   29,       88,  -41,   41,
      40,   68,  -28,       42,   60,  -24,       47,   47,  -16,       54,   30,   -6,
      62,   11,    5,       70,   -6,   17,       79,  -23,   29,       88,  -38,   41,
      41,   69,  -25,       44,   62,  -21,       48,   49,  -14,       55,   33,   -5,
      63,   14,    7,       71,   -3,   18,       80,  -20,   30,       89,  -35,   42,
      43,   71,  -23,       45,   64,  -19,       50,   52,  -12,       56,   36,   -3,
      63,   18,    8,       72,    0,   19,       80,  -17,   31,       89,  -33,   43,
      44,   72,  -20,       46,   66,  -17,       51,   54,  -10,       57,   39,   -1,
      64,   21,    9,       72,    3,   21,       81,  -14,   32,       90,  -30,   43,
      46,   74,  -17,       48,   68,  -14,       52,   57,   -8,       58,   42,    0,
      65,   24,   11,       73,    7,   22,       81,  -10,   33,       90,  -26,   44,
      48,   76,  -15,       50,   70,  -12,       53,   59,   -6,       59,   44,    2,
      66,   27,   12,       74,   10,   23,       82,   -7,   34,       91,  -23,   45,
      49,   78,  -12,       51,   72,  -10,       55,   62,   -4,       60,   47,    4,
      67,   30,   14,       75,   13,   24,       83,   -4,   35,       91,  -20,   46,
      51,   79,  -10,       53,   74,   -7,       56,   64,   -2,       61,   50,    6,
      68,   33,   15,       75,   16,   25,       83,   -1,   36,       92,  -17,   47,
      52,   81,   -7,       54,   76,   -5,       58,   67,    1,       63,   53,    8,
      69,   36,   17,       76,   20,   27,       84,    3,   37,       93,  -14,   48,
      54,   83,   -5,       56,   78,   -2,       59,   69,    3,       64,   56,   10,
      70,   39,   19,       77,   23,   28,       85,    6,   38,       93,  -11,   49,
      55,   85,   -2,       57,   80,    0,       60,   71,    5,       65,   58,   12,
      71,   42,   20,       78,   26,   29,       86,    9,   39,       94,   -8,   50,
      17,   49,  -70,       24,   31,  -59,       33,    9,  -45,       43,  -11,  -29,
      53,  -29,  -12,       64,  -44,    3,       74,  -56,   17,       84,  -68,   31,
      18,   49,  -69,       24,   31,  -59,       33,    9,  -44,       43,  -11,  -28,
      54,  -29,  -12,       64,  -43,    3,       74,  -56,   17,       84,  -68,   31,
      18,   49,  -69,       24,   32,  -59,       33,   10,  -44,       43,  -11,  -28,
      54,  -28,  -12,       64,  -43,    3,       74,  -56,   17,       84,  -68,   31,
      18,   49,  -68,       24,   32,  -58,       33,   10,  -44,       43,  -10,  -28,
      54,  -28,  -12,       64,  -42,    3,       74,  -55,   17,       84,  -67,   31,
      19,   50,  -67,       25,   33,  -58,       33,   11,  -43,       43,   -9,  -28,
      54,  -27,  -12,       64,  -42,    3,       74,  -55,   17,       84,  -67,   31,
      20,   50,  -66,       25,   34,  -57,       34,   12,  -43,       44,   -8,  -27,
      54,  -26,  -12,       64,  -41,    3,       74,  -54,   18,       84,  -66,   31,
      20,   51,  -65,       26,   35,  -56,       34,   14,  -42,       44,   -7,  -27,
      54,  -25,  -11,       64,  -40,    4,       74,  -53,   18,       84,  -65,   31,
      21,   51,  -63,       26,   36,  -55,       35,   16,  -41,       44,   -5,  -26,
      54,  -23,  -11,       64,  -39,    4,       74,  -52,   18,       84,  -64,   32,
      22,   52,  -62,       27,   38,  -54,       35,   17,  -41,       45,   -3,  -26,
      55,  -22,  -10,       65,  -37,    4,       74,  -51,   18,       84,  -63,   32,
      23,   53,  -60,       28,   39,  -52,       36,   19,  -40,       45,   -1,  -25,
      55,  -20,  -10,       65,  -36,    5,       75,  -49,   18,       85,  -62,   32,
      24,   54,  -58,       29,   41,  -51,       36,   21,  -39,       45,    1,  -24,
      55,  -18,   -9,       65,  -34,    5,       75,  -48,   19,       85,  -61,   32,
      25,   55,  -56,       30,   42,  -49,       37,   23,  -37,       46,    3,  -24,
      56,  -16,   -9,       65,  -32,    6,       75,  -46,   19,       85,  -59,   33,
      27,   56,  -54,       31,   44,  -47,       38,   26,  -36,       47,    6,  -22,
      56,  -13,   -8,       66,  -30,    6,       75,  -44,   20,       85,  -58,   33,
      28,   57,  -52,       32,   46,  -45,       39,   28,  -35,       47,    8,  -21,
      57,  -11,   -7,       66,  -27,    7,       76,  -42,   20,       86,  -56,   33,
      30,   58,  -49,       33,   48,  -43,       40,   30,  -33,       48,   11,  -20,
      57,   -8,   -6,       67,  -25,    7,       76,  -40,   21,       86,  -54,   34,
      31,   60,  -47,       34,   49,  -41,       41,   33,  -32,       49,   14,  -19,
      58,   -5,   -5,       67,  -22,    8,       76,  -38,   21,       86,  -52,   34,
      32,   61,  -45,       36,   52,  -39,       42,   36,  -30,       49,   17,  -18,
      58,   -2,   -4,       68,  -20,    9,       77,  -35,   22,       86,  -50,   35,
      34,   63,  -42,       37,   53,  -37,       43,   38,  -28,       50,   20,  -17,
      59,    0,   -3,       68,  -17,   10,       77,  -33,   22,       87,  -47,   35,
      35,   64,  -40,       38,   55,  -35,       44,   40,  -26,       51,   22,  -15,
      60,    3,   -2,       69,  -14,   10,       78,  -30,   23,       87,  -45,   36,
      37,   65,  -37,       40,   57,  -33,       45,   43,  -25,       52,   25,  -14,
      60,    6,   -1,       69,  -11,   11,       78,  -27,   24,       87,  -43,   36,
      39,   67,  -35,       41,   59,  -30,       46,   46,  -22,       53,   28,  -12,
      61,   10,    0,       70,   -8,   12,       79,  -24,   25,       88,  -40,   37,
      40,   69,  -32,       43,   61,  -28,       47,   48,  -21,       54,   31,  -11,
      62,   13,    1,       70,   -5,   13,       79,  -21,   25,       88,  -37,   38,
      42,   70,  -30,       44,   63,  -26,       49,   50,  -19,       55,   34,   -9,
      63,   16,    2,       71,   -2,   14,       80,  -18,   26,       89,  -34,   38,
      43,   72,  -27,       45,   65,  -23,       50,   53,  -17,       56,   37,   -7,
      64,   19,    4,       72,    1,   15,       80,  -16,   27,       89,  -32,   39,
      45,   73,  -25,       47,   67,  -21,       51,   55,  -15,       57,   40,   -6,
      64,   22,    5,       72,    4,   16,       81,  -13,   28,       90,  -29,   40,
      46,   75,  -22,       48,   69,  -19,       52,   58,  -12,       58,   43,   -4,
      65,   25,    7,       73,    8,   18,       82,   -9,   29,       90,  -25,   41,
      48,   77,  -19,       50,   71,  -16,       54,   60,  -10,       59,   45,   -2,
      66,   28,    8,       74,   11,   19,       82,   -6,   30,       91,  -22,   41,
      49,   78,  -17,       51,   73,  -14,       55,   63,   -8,       60,   48,    0,
      67,   31,   10,       75,   14,   20,       83,   -3,   31,       91,  -19,   42,
      51,   80,  -14,       53,   75,  -12,       56,   65,   -6,       62,   51,    1,
      68,   34,   11,       76,   17,   21,       83,    0,   32,       92,  -16,   43,
      53,   82,  -12,       54,   77,   -9,       58,   67,   -4,       63,   54,    4,
      69,   37,   13,       77,   21,   23,       84,    4,   33,       93,  -13,   44,
      54,   84,   -9,       56,   79,   -7,       59,   70,   -2,       64,   56,    5,
      70,   40,   14,       77,   24,   24,       85,    7,   34,       93,  -10,   45,
      56,   85,   -7,       57,   81,   -4,       61,   72,    0,       65,   59,    7,
      71,   43,   16,       78,   27,   25,       86,   10,   35,       94,   -7,   46,
      19,   51,  -73,       25,   34,  -63,       33,   12,  -49,       43,   -8,  -33,
      54,  -26,  -17,       64,  -41,   -1,       74,  -55,   13,       84,  -67,   27,
      19,   51,  -72,       25,   34,  -63,       33,   13,  -48,       43,   -8,  -33,
      54,  -26,  -16,       64,  -41,   -1,       74,  -54,   13,       84,  -66,   27,
      19,   51,  -72,       25,   35,  -62,       34,   13,  -48,       43,   -8,  -32,
      54,  -26,  -16,       64,  -41,   -1,       74,  -54,   13,       84,  -66,   27,
      20,   52,  -71,       25,   35,  -62,       34,   14,  -48,       44,   -7,  -32,
      54,  -25,  -16,       64,  -40,   -1,       74,  -54,   13,       84,  -66,   27,
      20,   52,  -70,       26,   36,  -61,       34,   15,  -47,       44,   -6,  -32,
      54,  -24,  -16,       64,  -40,   -1,       74,  -53,   13,       84,  -65,   27,
      21,   52,  -69,       26,   37,  -60,       34,   16,  -47,       44,   -5,  -32,
      54,  -23,  -16,       64,  -39,   -1,       74,  -52,   13,       84,  -65,   27,
      21,   53,  -68,       27,   38,  -60,       35,   17,  -46,       44,   -4,  -31,
      54,  -22,  -15,       64,  -38,   -1,       74,  -51,   14,       84,  -64,   28,
      22,   53,  -67,       27,   39,  -58,       35,   18,  -45,       45,   -2,  -31,
      55,  -21,  -15,       65,  -36,    0,       74,  -50,   14,       85,  -63,   28,
      23,   54,  -65,       28,   40,  -57,       36,   20,  -45,       45,    0,  -30,
      55,  -19,  -15,       65,  -35,    0,       75,  -49,   14,       85,  -62,   28,
      24,   55,  -64,       29,   41,  -56,       36,   22,  -44,       45,    1,  -29,
      55,  -17,  -14,       65,  -34,    0,       75,  -48,   14,       85,  -61,   28,
      25,   56,  -62,       30,   43,  -54,       37,   24,  -43,       46,    3,  -29,
      56,  -16,  -13,       65,  -32,    1,       75,  -46,   15,       85,  -59,   28,
      26,   57,  -60,       31,   44,  -53,       38,   26,  -41,       46,    6,  -28,
      56,  -14,  -13,       66,  -30,    1,       75,  -45,   15,       85,  -58,   29,
      28,   58,  -58,       32,   46,  -51,       38,   28,  -40,       47,    8,  -27,
      56,  -11,  -12,       66,  -28,    2,       76,  -43,   16,       85,  -56,   29,
      29,   59,  -56,       33,   48,  -49,       39,   30,  -39,       48,   11,  -26,
      57,   -9,  -11,       66,  -26,    3,       76,  -41,   16,       86,  -54,   29,
      30,   60,  -53,       34,   49,  -47,       40,   32,  -37,       48,   13,  -25,
      57,   -6,  -11,       67,  -23,    3,       76,  -38,   17,       86,  -53,   30,
      32,   61,  -51,       35,   51,  -45,       41,   35,  -36,       49,   16,  -23,
      58,   -4,  -10,       67,  -21,    4,       77,  -36,   17,       86,  -51,   30,
      33,   63,  -48,       36,   53,  -43,       42,   37,  -34,       50,   19,  -22,
      59,   -1,   -9,       68,  -18,    5,       77,  -34,   18,       87,  -48,   31,
      34,   64,  -46,       38,   55,  -41,       43,   40,  -32,       51,   21,  -21,
      59,    2,   -8,       68,  -15,    5,       77,  -31,   18,       87,  -46,   31,
      36,   65,  -44,       39,   57,  -39,       44,   42,  -31,       51,   24,  -19,
      60,    5,   -7,       69,  -13,    6,       78,  -29,   19,       87,  -44,   32,
      37,   67,  -41,       40,   59,  -37,       45,   44,  -29,       52,   27,  -18,
      61,    8,   -6,       69,  -10,    7,       78,  -26,   20,       88,  -41,   32,
      39,   68,  -39,       42,   61,  -34,       47,   47,  -27,       53,   30,  -16,
      61,   11,   -4,       70,   -7,    8,       79,  -23,   21,       88,  -38,   33,
      40,   70,  -36,       43,   62,  -32,       48,   49,  -25,       54,   33,  -15,
      62,   14,   -3,       71,   -4,    9,       79,  -20,   21,       88,  -36,   34,
      42,   71,  -34,       44,   64,  -30,       49,   52,  -23,       55,   35,  -13,
      63,   17,   -2,       71,   -1,   10,       80,  -17,   22,       89,  -33,   34,
      43,   73,  -31,       46,   66,  -28,       50,   54,  -21,       56,   38,  -12,
      64,   20,    0,       72,    2,   11,       80,  -14,   23,       89,  -30,   35,
      45,   74,  -29,       47,   68,  -25,       51,   56,  -19,       57,   41,  -10,
      65,   23,    1,       73,    5,   12,       81,  -11,   24,       90,  -28,   36,
      47,   76,  -26,       49,   70,  -23,       53,   59,  -17,       58,   44,   -8,
      66,   26,    2,       73,    9,   14,       82,   -8,   25,       90,  -24,   37,
      48,   78,  -24,       50,   72,  -21,       54,   61,  -15,       60,   47,   -6,
      67,   29,    4,       74,   12,   15,       82,   -5,   26,       91,  -21,   37,
      50,   79,  -21,       52,   74,  -18,       55,   63,  -13,       61,   49,   -5,
      67,   32,    5,       75,   15,   16,       83,   -2,   27,       92,  -19,   38,
      51,   81,  -19,       53,   76,  -16,       57,   66,  -11,       62,   52,   -3,
      68,   35,    7,       76,   18,   17,       84,    1,   28,       92,  -16,   39,
      53,   83,  -16,       55,   78,  -13,       58,   68,   -8,       63,   55,   -1,
      70,   38,    9,       77,   21,   19,       84,    5,   29,       93,  -12,   40,
      54,   84,  -13,       56,   80,  -11,       59,   70,   -6,       64,   57,    1,
      71,   41,   10,       78,   24,   20,       85,    8,   30,       93,   -9,   41,
      56,   86,  -11,       58,   81,   -9,       61,   73,   -4,       65,   60,    3,
      72,   44,   12,       78,   28,   21,       86,   11,   31,       94,   -6,   42,
      20,   54,  -76,       26,   38,  -67,       34,   16,  -53,       44,   -5,  -37,
      54,  -23,  -21,       64,  -39,   -6,       74,  -52,    8,       84,  -65,   23,
      20,   54,  -76,       26,   38,  -67,       34,   16,  -53,       44,   -4,  -37,
      54,  -23,  -21,       64,  -39,   -6,       74,  -52,    9,       84,  -64,   23,
      20,   54,  -75,       26,   38,  -66,       34,   17,  -52,       44,   -4,  -37,
      54,  -23,  -21,       64,  -38,   -6,       74,  -52,    9,       84,  -64,   23,
      21,   54,  -75,       26,   39,  -66,       34,   17,  -52,       44,   -3,  -37,
      54,  -22,  -21,       64,  -38,   -6,       74,  -51,    9,       84,  -64,   23,
      21,   55,  -74,       26,   39,  -65,       35,   18,  -52,       44,   -3,  -37,
      54,  -21,  -21,       64,  -37,   -6,       74,  -51,    9,       84,  -63,   23,
      22,   55,  -73,       27,   40,  -64,       35,   19,  -51,       44,   -2,  -36,
      55,  -20,  -20,       65,  -36,   -5,       74,  -50,    9,       84,  -63,   23,
      22,   55,  -72,       27,   41,  -64,       35,   20,  -51,       45,    0,  -36,
      55,  -19,  -20,       65,  -35,   -5,       75,  -49,    9,       85,  -62,   23,
      23,   56,  -70,       28,   42,  -62,       36,   22,  -50,       45,    1,  -35,
      55,  -18,  -20,       65,  -34,   -5,       75,  -48,    9,       85,  -61,   23,
      24,   56,  -69,       29,   43,  -61,       36,   23,  -49,       45,    3,  -35,
      55,  -16,  -19,       65,  -33,   -5,       75,  -47,   10,       85,  -60,   24,
      25,   57,  -67,       30,   44,  -60,       37,   25,  -48,       46,    4,  -34,
      56,  -15,  -19,       65,  -31,   -4,       75,  -46,   10,       85,  -59,   24,
      26,   58,  -66,       30,   45,  -59,       38,   26,  -47,       46,    6,  -33,
      56,  -13,  -18,       66,  -30,   -4,       75,  -44,   10,       85,  -58,   24,
      27,   59,  -64,       31,   47,  -57,       38,   28,  -46,       47,    8,  -32,
      56,  -11,  -18,       66,  -28,   -3,       75,  -43,   11,       85,  -56,   24,
      28,   60,  -62,       32,   48,  -55,       39,   31,  -45,       47,   11,  -31,
      57,   -9,  -17,       66,  -26,   -3,       76,  -41,   11,       86,  -54,   25,
      30,   61,  -60,       33,   50,  -54,       40,   33,  -43,       48,   13,  -30,
      57,   -6,  -16,       67,  -23,   -2,       76,  -39,   12,       86,  -53,   25,
      31,   62,  -58,       34,   51,  -52,       41,   35,  -42,       49,   15,  -29,
      58,   -4,  -15,       67,  -21,   -1,       76,  -37,   12,       86,  -51,   25,
      32,   63,  -55,       36,   53,  -50,       42,   37,  -40,       49,   18,  -28,
      58,   -1,  -14,       67,  -19,   -1,       77,  -34,   13,       86,  -49,   26,
      34,   64,  -53,       37,   55,  -48,       43,   39,  -39,       50,   21,  -27,
      59,    1,  -13,       68,  -16,    0,       77,  -32,   13,       87,  -47,   26,
      35,   65,  -51,       38,   57,  -46,       44,   42,  -37,       51,   23,  -25,
      60,    4,  -12,       68,  -13,    1,       78,  -30,   14,       87,  -45,   27,
      37,   67,  -48,       39,   58,  -44,       45,   44,  -35,       52,   26,  -24,
      60,    7,  -11,       69,  -11,    2,       78,  -27,   14,       87,  -42,   27,
      38,   68,  -46,       41,   60,  -41,       46,   46,  -33,       53,   29,  -23,
      61,   10,  -10,       70,   -8,    2,       78,  -24,   15,       88,  -40,   28,
      40,   70,  -43,       42,   62,  -39,       47,   49,  -31,       54,   32,  -21,
      62,   13,   -9,       70,   -5,    4,       79,  -21,   16,       88,  -37,   29,
      41,   71,  -41,       43,   64,  -37,       48,   51,  -30,       55,   34,  -20,
      62,   16,   -8,       71,   -2,    4,       79,  -19,   17,       89,  -35,   29,
      42,   72,  -38,       45,   66,  -35,       49,   53,  -28,       56,   37,  -18,
      63,   19,   -6,       71,    1,    5,       80,  -16,   18,       89,  -32,   30,
      44,   74,  -36,       46,   67,  -32,       51,   55,  -26,       57,   40,  -16,
      64,   21,   -5,       72,    4,    7,       81,  -13,   19,       90,  -29,   31,
      45,   75,  -34,       48,   69,  -30,       52,   58,  -24,       58,   42,  -15,
      65,   24,   -4,       73,    7,    8,       81,  -10,   19,       90,  -26,   31,
      47,   77,  -31,       49,   71,  -28,       53,   60,  -21,       59,   45,  -13,
      66,   28,   -2,       74,   10,    9,       82,   -7,   20,       91,  -23,   32,
      49,   79,  -28,       51,   73,  -25,       54,   62,  -19,       60,   48,  -11,
      67,   30,   -1,       74,   13,   10,       82,   -4,   21,       91,  -20,   33,
      50,   80,  -26,       52,   75,  -23,       56,   65,  -17,       61,   50,   -9,
      68,   33,    1,       75,   16,   11,       83,   -1,   22,       92,  -17,   34,
      52,   82,  -23,       53,   77,  -21,       57,   67,  -15,       62,   53,   -8,
      69,   36,    2,       76,   19,   13,       84,    2,   23,       92,  -14,   35,
      53,   84,  -21,       55,   79,  -18,       58,   69,  -13,       63,   56,   -6,
      70,   39,    4,       77,   23,   14,       85,    6,   25,       93,  -11,   36,
      55,   85,  -18,       56,   81,  -16,       60,   71,  -11,       65,   58,   -4,
      71,   42,    5,       78,   26,   15,       85,    9,   26,       94,   -8,   37,
      56,   87,  -16,       58,   82,  -13,       61,   73,   -9,       66,   61,   -2,
      72,   45,    7,       79,   29,   17,       86,   12,   27,       94,   -5,   38,
      21,   56,  -79,       26,   41,  -70,       35,   19,  -57,       44,   -2,  -41,
      54,  -21,  -25,       64,  -36,  -10,       74,  -50,    4,       84,  -63,   19,
      21,   56,  -79,       27,   41,  -70,       35,   20,  -56,       44,   -1,  -41,
      54,  -20,  -25,       64,  -36,  -10,       74,  -50,    4,       84,  -63,   19,
      22,   56,  -78,       27,   41,  -70,       35,   20,  -56,       44,   -1,  -41,
      55,  -20,  -25,       64,  -36,  -10,       74,  -50,    5,       84,  -62,   19,
      22,   56,  -78,       27,   41,  -69,       35,   21,  -56,       44,    0,  -41,
      55,  -19,  -25,       65,  -35,  -10,       74,  -49,    5,       84,  -62,   19,
      22,   57,  -77,       27,   42,  -69,       35,   21,  -56,       45,    0,  -41,
      55,  -19,  -25,       65,  -35,  -10,       74,  -49,    5,       85,  -62,   19,
      23,   57,  -76,       28,   43,  -68,       36,   22,  -55,       45,    1,  -40,
      55,  -18,  -24,       65,  -34,  -10,       75,  -48,    5,       85,  -61,   19,
      23,   57,  -75,       28,   43,  -67,       36,   23,  -54,       45,    2,  -40,
      55,  -17,  -24,       65,  -33,   -9,       75,  -47,    5,       85,  -60,   19,
      24,   58,  -74,       29,   44,  -66,       36,   25,  -54,       45,    4,  -39,
      55,  -15,  -24,       65,  -32,   -9,       75,  -46,    5,       85,  -59,   19,
      25,   58,  -72,       30,   45,  -65,       37,   26,  -53,       46,    5,  -39,
      56,  -14,  -23,       65,  -30,   -9,       75,  -45,    6,       85,  -58,   20,
      26,   59,  -71,       30,   46,  -64,       37,   27,  -52,       46,    7,  -38,
      56,  -12,  -23,       66,  -29,   -8,       75,  -44,    6,       85,  -57,   20,
      27,   60,  -69,       31,   48,  -62,       38,   29,  -51,       47,    9,  -37,
      56,  -11,  -22,       66,  -27,   -8,       75,  -42,    6,       85,  -56,   20,
      28,   60,  -67,       32,   49,  -61,       39,   31,  -50,       47,   11,  -36,
      57,   -9,  -22,       66,  -26,   -7,       76,  -41,    7,       85,  -55,   20,
      29,   61,  -65,       33,   50,  -59,       40,   33,  -48,       48,   13,  -35,
      57,   -6,  -21,       66,  -24,   -7,       76,  -39,    7,       86,  -53,   21,
      30,   62,  -63,       34,   52,  -57,       40,   35,  -47,       48,   15,  -34,
      58,   -4,  -20,       67,  -21,   -6,       76,  -37,    8,       86,  -51,   21,
      32,   63,  -61,       35,   53,  -56,       41,   37,  -46,       49,   18,  -33,
      58,   -2,  -19,       67,  -19,   -6,       77,  -35,    8,       86,  -49,   22,
      33,   64,  -59,       36,   55,  -54,       42,   39,  -44,       50,   20,  -32,
      59,    1,  -19,       68,  -17,   -5,       77,  -33,    9,       86,  -48,   22,
      34,   66,  -57,       37,   57,  -52,       43,   41,  -43,       51,   23,  -31,
      59,    3,  -17,       68,  -14,   -4,       77,  -30,    9,       87,  -45,   23,
      36,   67,  -54,       39,   58,  -50,       44,   43,  -41,       51,   25,  -30,
      60,    6,  -16,       69,  -12,   -3,       78,  -28,   10,       87,  -43,   23,
      37,   68,  -52,       40,   60,  -48,       45,   45,  -39,       52,   28,  -28,
      60,    9,  -15,       69,   -9,   -2,       78,  -25,   10,       88,  -41,   24,
      38,   69,  -50,       41,   62,  -45,       46,   48,  -38,       53,   30,  -27,
      61,   11,  -14,       70,   -6,   -2,       79,  -23,   11,       88,  -39,   24,
      40,   71,  -47,       43,   63,  -43,       47,   50,  -36,       54,   33,  -25,
      62,   14,  -13,       70,   -3,   -1,       79,  -20,   12,       88,  -36,   25,
      41,   72,  -45,       44,   65,  -41,       49,   52,  -34,       55,   36,  -24,
      63,   17,  -12,       71,   -1,    0,       80,  -17,   13,       89,  -33,   25,
      43,   74,  -42,       45,   67,  -39,       50,   54,  -32,       56,   38,  -22,
      63,   20,  -11,       72,    2,    1,       80,  -15,   14,       89,  -31,   26,
      44,   75,  -40,       47,   69,  -37,       51,   57,  -30,       57,   41,  -21,
      64,   23,   -9,       72,    5,    2,       81,  -12,   14,       90,  -28,   27,
      46,   77,  -38,       48,   70,  -34,       52,   59,  -28,       58,   43,  -19,
      65,   26,   -8,       73,    8,    4,       81,   -9,   15,       90,  -25,   28,
      47,   78,  -35,       50,   72,  -32,       53,   61,  -26,       59,   46,  -17,
      66,   29,   -6,       74,   11,    5,       82,   -6,   16,       91,  -22,   28,
      49,   80,  -32,       51,   74,  -29,       55,   63,  -24,       60,   49,  -15,
      67,   32,   -5,       75,   14,    6,       83,   -3,   17,       91,  -19,   29,
      50,   81,  -30,       52,   76,  -27,       56,   66,  -22,       61,   51,  -14,
      68,   35,   -4,       75,   17,    7,       83,    0,   18,       92,  -16,   30,
      52,   83,  -28,       54,   78,  -25,       57,   68,  -20,       62,   54,  -12,
      69,   37,   -2,       76,   20,    8,       84,    3,   19,       92,  -13,   31,
      54,   84,  -25,       55,   80,  -22,       59,   70,  -17,       64,   57,  -10,
      70,   40,    0,       77,   24,   10,       85,    7,   21,       93,  -10,   32,
      55,   86,  -22,       57,   81,  -20,       60,   72,  -15,       65,   59,   -8,
      71,   43,    1,       78,   27,   11,       85,   10,   22,       94,   -7,   33,
      57,   88,  -20,       58,   83,  -18,       61,   74,  -13,       66,   62,   -6,
      72,   46,    3,       79,   30,   13,       86,   13,   23,       94,   -4,   34,
      22,   58,  -82,       27,   43,  -73,       35,   23,  -60,       45,    2,  -45,
      55,  -18,  -29,       65,  -34,  -14,       74,  -48,    0,       85,  -61,   15,
      22,   58,  -81,       27,   44,  -73,       35,   23,  -60,       45,    2,  -45,
      55,  -17,  -29,       65,  -34,  -14,       75,  -48,    0,       85,  -61,   15,
      23,   58,  -81,       28,   44,  -73,       36,   23,  -60,       45,    2,  -45,
      55,  -17,  -29,       65,  -33,  -14,       75,  -48,    1,       85,  -61,   15,
      23,   59,  -81,       28,   44,  -72,       36,   24,  -60,       45,    3,  -45,
      55,  -17,  -29,       65,  -33,  -14,       75,  -47,    1,       85,  -60,   15,
      23,   59,  -80,       28,   45,  -72,       36,   24,  -59,       45,    4,  -45,
      55,  -16,  -29,       65,  -32,  -14,       75,  -47,    1,       85,  -60,   15,
      24,   59,  -79,       29,   45,  -71,       36,   25,  -59,       45,    4,  -44,
      55,  -15,  -29,       65,  -32,  -14,       75,  -46,    1,       85,  -59,   15,
      24,   59,  -78,       29,   46,  -70,       37,   26,  -58,       46,    5,  -44,
      55,  -14,  -28,       65,  -31,  -13,       75,  -45,    1,       85,  -59,   15,
      25,   60,  -77,       30,   47,  -69,       37,   27,  -57,       46,    7,  -43,
      56,  -13,  -28,       65,  -29,  -13,       75,  -44,    1,       85,  -58,   16,
      26,   60,  -75,       30,   48,  -68,       37,   29,  -57,       46,    8,  -43,
      56,  -11,  -27,       66,  -28,  -13,       75,  -43,    2,       85,  -57,   16,
      27,   61,  -74,       31,   49,  -67,       38,   30,  -56,       47,   10,  -42,
      56,  -10,  -27,       66,  -27,  -12,       75,  -42,    2,       85,  -56,   16,
      28,   62,  -72,       32,   50,  -66,       39,   32,  -55,       47,   11,  -41,
      57,   -8,  -26,       66,  -25,  -12,       76,  -40,    2,       85,  -54,   16,
      29,   62,  -71,       33,   51,  -64,       39,   33,  -54,       48,   13,  -40,
      57,   -6,  -26,       66,  -23,  -11,       76,  -39,    3,       86,  -53,   17,
      30,   63,  -69,       34,   52,  -63,       40,   35,  -52,       48,   16,  -39,
      57,   -4,  -25,       67,  -21,  -11,       76,  -37,    3,       86,  -51,   17,
      31,   64,  -67,       35,   54,  -61,       41,   37,  -51,       49,   18,  -38,
      58,   -2,  -24,       67,  -19,  -10,       76,  -35,    3,       86,  -50,   17,
      32,   65,  -65,       36,   55,  -59,       42,   39,  -50,       49,   20,  -37,
      58,    0,  -23,       67,  -17,  -10,       77,  -33,    4,       86,  -48,   18,
      34,   66,  -63,       37,   57,  -58,       43,   41,  -48,       50,   22,  -36,
      59,    3,  -23,       68,  -15,   -9,       77,  -31,    5,       87,  -46,   18,
      35,   67,  -60,       38,   58,  -55,       44,   43,  -47,       51,   25,  -35,
      60,    5,  -22,       68,  -12,   -8,       78,  -29,    5,       87,  -44,   19,
      36,   68,  -58,       39,   60,  -53,       45,   45,  -45,       52,   27,  -34,
      60,    8,  -21,       69,  -10,   -7,       78,  -26,    6,       87,  -42,   19,
      38,   69,  -56,       40,   61,  -51,       46,   47,  -43,       52,   30,  -32,
      61,   10,  -20,       69,   -7,   -7,       78,  -24,    6,       88,  -39,   20,
      39,   71,  -54,       42,   63,  -49,       47,   49,  -42,       53,   32,  -31,
      61,   13,  -18,       70,   -5,   -6,       79,  -21,    7,       88,  -37,   20,
      41,   72,  -51,       43,   65,  -47,       48,   52,  -40,       54,   35,  -29,
      62,   16,  -17,       71,   -2,   -5,       79,  -18,    8,       88,  -34,   21,
      42,   73,  -49,       44,   66,  -45,       49,   54,  -38,       55,   37,  -28,
      63,   19,  -16,       71,    1,   -4,       80,  -16,    9,       89,  -32,   22,
      43,   75,  -46,       46,   68,  -43,       50,   56,  -36,       56,   40,  -26,
      64,   22,  -15,       72,    4,   -3,       80,  -13,   10,       89,  -29,   22,
      45,   76,  -44,       47,   70,  -41,       51,   58,  -34,       57,   42,  -25,
      65,   24,  -13,       73,    7,   -2,       81,  -10,   10,       90,  -27,   23,
      46,   78,  -42,       48,   72,  -38,       52,   60,  -32,       58,   45,  -23,
      65,   27,  -12,       73,    9,   -1,       81,   -8,   11,       90,  -24,   24,
      48,   79,  -39,       50,   73,  -36,       54,   62,  -30,       59,   48,  -21,
      66,   30,  -11,       74,   13,    1,       82,   -4,   12,       91,  -21,   25,
      49,   81,  -37,       51,   75,  -34,       55,   65,  -28,       60,   50,  -19,
      67,   33,   -9,       75,   16,    2,       83,   -1,   13,       91,  -18,   25,
      51,   82,  -34,       53,   77,  -31,       56,   67,  -26,       61,   53,  -18,
      68,   36,   -8,       76,   19,    3,       83,    2,   14,       92,  -15,   26,
      52,   84,  -32,       54,   79,  -29,       58,   69,  -24,       63,   55,  -16,
      69,   38,   -6,       76,   21,    4,       84,    4,   15,       93,  -12,   27,
      54,   85,  -29,       56,   81,  -26,       59,   71,  -21,       64,   58,  -14,
      70,   42,   -4,       77,   25,    6,       85,    8,   17,       93,   -9,   28,
      55,   87,  -27,       57,   82,  -24,       60,   73,  -19,       65,   60,  -12,
      71,   44,   -3,       78,   28,    7,       86,   11,   18,       94,   -6,   29,
      57,   88,  -24,       58,   84,  -22,       62,   75,  -17,       66,   63,  -10,
      72,   47,   -1,       79,   31,    9,       86,   14,   19,       94,   -3,   30,
      23,   60,  -85,       28,   46,  -77,       36,   26,  -64,       45,    5,  -49,
      55,  -15,  -33,       65,  -31,  -18,       75,  -46,   -4,       85,  -59,   11,
      24,   61,  -84,       28,   46,  -76,       36,   26,  -64,       45,    5,  -49,
      55,  -15,  -33,       65,  -31,  -18,       75,  -46,   -4,       85,  -59,   11,
      24,   61,  -84,       29,   47,  -76,       36,   26,  -64,       45,    5,  -49,
      55,  -14,  -33,       65,  -31,  -18,       75,  -45,   -3,       85,  -59,   11,
      24,   61,  -83,       29,   47,  -76,       36,   27,  -63,       45,    6,  -49,
      55,  -14,  -33,       65,  -30,  -18,       75,  -45,   -3,       85,  -58,   11,
      25,   61,  -83,       29,   47,  -75,       37,   27,  -63,       46,    7,  -48,
      55,  -13,  -33,       65,  -30,  -18,       75,  -44,   -3,       85,  -58,   11,
      25,   61,  -82,       29,   48,  -75,       37,   28,  -62,       46,    7,  -48,
      56,  -12,  -33,       65,  -29,  -18,       75,  -44,   -3,       85,  -57,   11,
      26,   62,  -81,       30,   49,  -74,       37,   29,  -62,       46,    8,  -48,
      56,  -11,  -32,       65,  -28,  -17,       75,  -43,   -3,       85,  -57,   11,
      26,   62,  -80,       31,   49,  -73,       38,   30,  -61,       46,   10,  -47,
      56,  -10,  -32,       66,  -27,  -17,       75,  -42,   -3,       85,  -56,   12,
      27,   62,  -79,       31,   50,  -72,       38,   31,  -60,       47,   11,  -47,
      56,   -9,  -31,       66,  -26,  -17,       75,  -41,   -2,       85,  -55,   12,
      28,   63,  -77,       32,   51,  -71,       39,   33,  -59,       47,   13,  -46,
      57,   -7,  -31,       66,  -24,  -16,       76,  -40,   -2,       85,  -54,   12,
      29,   63,  -76,       33,   52,  -69,       39,   34,  -59,       48,   14,  -45,
      57,   -6,  -30,       66,  -23,  -16,       76,  -38,   -2,       86,  -53,   12,
      30,   64,  -74,       33,   53,  -68,       40,   36,  -57,       48,   16,  -44,
      57,   -4,  -30,       67,  -21,  -15,       76,  -37,   -1,       86,  -51,   13,
      31,   65,  -72,       34,   55,  -66,       41,   38,  -56,       49,   18,  -43,
      58,   -2,  -29,       67,  -19,  -15,       76,  -35,   -1,       86,  -50,   13,
      32,   66,  -70,       35,   56,  -65,       41,   39,  -55,       49,   20,  -42,
      58,    0,  -28,       67,  -17,  -14,       77,  -33,   -1,       86,  -48,   13,
      33,   67,  -68,       36,   57,  -63,       42,   41,  -54,       50,   22,  -41,
      59,    2,  -28,       68,  -15,  -14,       77,  -31,    0,       87,  -46,   14,
      34,   68,  -66,       37,   58,  -61,       43,   43,  -52,       50,   24,  -40,
      59,    5,  -27,       68,  -13,  -13,       77,  -29,    1,       87,  -44,   14,
      36,   69,  -64,       39,   60,  -59,       44,   45,  -50,       51,   27,  -39,
      60,    7,  -26,       69,  -10,  -12,       78,  -27,    1,       87,  -42,   15,
      37,   70,  -62,       40,   61,  -57,       45,   47,  -49,       52,   29,  -38,
      60,   10,  -25,       69,   -8,  -11,       78,  -25,    2,       87,  -40,   15,
      38,   71,  -60,       41,   63,  -55,       46,   49,  -47,       53,   31,  -36,
      61,   12,  -24,       70,   -6,  -11,       79,  -22,    2,       88,  -38,   16,
      40,   72,  -57,       42,   65,  -53,       47,   51,  -46,       54,   34,  -35,
      62,   15,  -23,       70,   -3,  -10,       79,  -20,    3,       88,  -36,   16,
      41,   73,  -55,       44,   66,  -51,       48,   53,  -44,       55,   36,  -33,
      63,   18,  -21,       71,    0,   -9,       80,  -17,    4,       89,  -33,   17,
      42,   75,  -53,       45,   68,  -49,       49,   55,  -42,       56,   39,  -32,
      63,   20,  -20,       71,    3,   -8,       80,  -14,    5,       89,  -30,   18,
      44,   76,  -50,       46,   69,  -47,       50,   57,  -40,       57,   41,  -30,
      64,   23,  -19,       72,    5,   -7,       81,  -12,    6,       90,  -28,   18,
      45,   77,  -48,       47,   71,  -45,       52,   59,  -38,       57,   44,  -29,
      65,   26,  -18,       73,    8,   -6,       81,   -9,    6,       90,  -25,   19,
      47,   79,  -46,       49,   73,  -42,       53,   61,  -36,       58,   46,  -27,
      66,   28,  -16,       73,   11,   -5,       82,   -6,    7,       90,  -23,   20,
      48,   80,  -43,       50,   75,  -40,       54,   64,  -34,       60,   49,  -25,
      67,   32,  -15,       74,   14,   -3,       82,   -3,    8,       91,  -20,   21,
      50,   82,  -41,       52,   76,  -38,       55,   66,  -32,       61,   51,  -24,
      68,   34,  -13,       75,   17,   -2,       83,    0,    9,       92,  -17,   22,
      51,   83,  -38,       53,   78,  -35,       57,   68,  -30,       62,   54,  -22,
      68,   37,  -12,       76,   20,   -1,       84,    3,   10,       92,  -14,   22,
      53,   85,  -36,       54,   80,  -33,       58,   70,  -28,       63,   56,  -20,
      69,   40,  -10,       77,   23,    0,       84,    6,   11,       93,  -11,   23,
      54,   86,  -33,       56,   81,  -31,       59,   72,  -25,       64,   59,  -18,
      70,   43,   -9,       77,   26,    2,       85,    9,   13,       93,   -8,   24,
      56,   88,  -31,       57,   83,  -28,       61,   74,  -23,       65,   61,  -16,
      71,   45,   -7,       78,   29,    3,       86,   12,   14,       94,   -5,   25,
      57,   89,  -28,       59,   85,  -26,       62,   76,  -21,       66,   64,  -14,
      72,   48,   -5,       79,   32,    4,       87,   15,   15,       95,   -2,   26,
      25,   63,  -87,       29,   49,  -80,       37,   29,  -68,       46,    8,  -53,
      55,  -12,  -37,       65,  -29,  -22,       75,  -44,   -8,       85,  -57,    7,
      25,   63,  -87,       29,   49,  -80,       37,   29,  -67,       46,    8,  -53,
      56,  -12,  -37,       65,  -28,  -22,       75,  -43,   -8,       85,  -57,    7,
      25,   63,  -87,       29,   49,  -79,       37,   30,  -67,       46,    9,  -53,
      56,  -11,  -37,       65,  -28,  -22,       75,  -43,   -7,       85,  -57,    7,
      25,   63,  -86,       30,   50,  -79,       37,   30,  -67,       46,    9,  -53,
      56,  -11,  -37,       65,  -28,  -22,       75,  -43,   -7,       85,  -56,    7,
      26,   63,  -86,       30,   50,  -78,       37,   31,  -67,       46,   10,  -52,
      56,  -10,  -37,       65,  -27,  -22,       75,  -42,   -7,       85,  -56,    7,
      26,   63,  -85,       30,   51,  -78,       37,   31,  -66,       46,   10,  -52,
      56,   -9,  -37,       66,  -26,  -22,       75,  -42,   -7,       85,  -55,    7,
      27,   64,  -84,       31,   51,  -77,       38,   32,  -66,       46,   11,  -52,
      56,   -8,  -36,       66,  -26,  -21,       75,  -41,   -7,       85,  -55,    7,
      27,   64,  -83,       31,   52,  -76,       38,   33,  -65,       47,   13,  -51,
      56,   -7,  -36,       66,  -25,  -21,       75,  -40,   -7,       85,  -54,    8,
      28,   64,  -82,       32,   53,  -75,       39,   34,  -64,       47,   14,  -50,
      57,   -6,  -35,       66,  -23,  -21,       76,  -39,   -6,       85,  -53,    8,
      29,   65,  -80,       33,   53,  -74,       39,   35,  -63,       48,   15,  -50,
      57,   -5,  -35,       66,  -22,  -20,       76,  -38,   -6,       86,  -52,    8,
      30,   65,  -79,       33,   54,  -73,       40,   37,  -62,       48,   17,  -49,
      57,   -3,  -34,       67,  -21,  -20,       76,  -36,   -6,       86,  -51,    8,
      31,   66,  -77,       34,   55,  -71,       40,   38,  -61,       48,   18,  -48,
      58,   -1,  -34,       67,  -19,  -20,       76,  -35,   -5,       86,  -49,    9,
      32,   67,  -75,       35,   57,  -70,       41,   40,  -60,       49,   20,  -47,
      58,    1,  -33,       67,  -17,  -19,       77,  -33,   -5,       86,  -48,    9,
      33,   68,  -74,       36,   58,  -68,       42,   42,  -59,       50,   22,  -46,
      59,    3,  -32,       68,  -15,  -18,       77,  -31,   -5,       86,  -46,    9,
      34,   68,  -72,       37,   59,  -67,       43,   43,  -57,       50,   24,  -45,
      59,    5,  -32,       68,  -13,  -18,       77,  -29,   -4,       87,  -44,   10,
      35,   69,  -70,       38,   60,  -65,       44,   45,  -56,       51,   26,  -44,
      60,    7,  -31,       68,  -11,  -17,       78,  -27,   -3,       87,  -43,   10,
      36,   70,  -68,       39,   62,  -63,       45,   47,  -54,       52,   29,  -43,
      60,    9,  -30,       69,   -9,  -16,       78,  -25,   -3,       87,  -41,   11,
      38,   71,  -66,       40,   63,  -61,       46,   49,  -53,       52,   31,  -42,
      61,   12,  -29,       69,   -6,  -15,       78,  -23,   -2,       88,  -38,   11,
      39,   72,  -63,       42,   65,  -59,       46,   51,  -51,       53,   33,  -40,
      61,   14,  -28,       70,   -4,  -15,       79,  -20,   -2,       88,  -36,   12,
      40,   74,  -61,       43,   66,  -57,       48,   53,  -49,       54,   36,  -39,
      62,   17,  -27,       70,   -1,  -14,       79,  -18,   -1,       88,  -34,   12,
      42,   75,  -59,       44,   68,  -55,       49,   55,  -47,       55,   38,  -37,
      63,   20,  -25,       71,    2,  -13,       80,  -15,    0,       89,  -31,   13,
      43,   76,  -56,       45,   69,  -53,       50,   57,  -46,       56,   41,  -36,
      64,   22,  -24,       72,    4,  -12,       80,  -13,    1,       89,  -29,   14,
      44,   77,  -54,       47,   71,  -51,       51,   59,  -44,       57,   43,  -34,
      64,   25,  -23,       72,    7,  -11,       81,  -10,    2,       90,  -27,   14,
      46,   79,  -52,       48,   72,  -48,       52,   61,  -42,       58,   45,  -33,
      65,   27,  -22,       73,   10,  -10,       81,   -7,    2,       90,  -24,   15,
      47,   80,  -50,       49,   74,  -46,       53,   63,  -40,       59,   48,  -31,
      66,   30,  -20,       74,   12,   -9,       82,   -5,    3,       91,  -21,   16,
      49,   81,  -47,       51,   76,  -44,       55,   65,  -38,       60,   50,  -29,
      67,   33,  -19,       74,   15,   -7,       83,   -2,    4,       91,  -18,   17,
      50,   83,  -45,       52,   77,  -42,       56,   67,  -36,       61,   53,  -28,
      68,   36,  -17,       75,   18,   -6,       83,    1,    5,       92,  -16,   18,
      52,   84,  -42,       53,   79,  -39,       57,   69,  -34,       62,   55,  -26,
      69,   38,  -16,       76,   21,   -5,       84,    4,    6,       92,  -13,   18,
      53,   86,  -40,       55,   81,  -37,       58,   71,  -32,       63,   57,  -24,
      70,   41,  -14,       77,   24,   -4,       84,    7,    8,       93,  -10,   19,
      55,   87,  -37,       56,   82,  -35,       60,   73,  -30,       64,   60,  -22,
      71,   44,  -13,       78,   27,   -2,       85,   10,    9,       94,   -7,   20,
      56,   89,  -35,       58,   84,  -32,       61,   75,  -27,       66,   62,  -20,
      72,   47,  -11,       79,   30,   -1,       86,   13,   10,       94,   -4,   21,
      58,   90,  -32,       59,   86,  -30,       62,   77,  -25,       67,   65,  -18,
      73,   49,   -9,       79,   33,    0,       87,   16,   11,       95,   -1,   22,
      26,   65,  -91,       30,   52,  -83,       37,   33,  -71,       46,   12,  -57,
      56,   -8,  -42,       66,  -26,  -27,       75,  -41,  -12,       85,  -55,    3,
      26,   65,  -90,       30,   52,  -83,       38,   33,  -71,       46,   12,  -57,
      56,   -8,  -42,       66,  -25,  -27,       75,  -41,  -12,       85,  -55,    3,
      26,   65,  -90,       31,   52,  -83,       38,   33,  -71,       46,   12,  -57,
      56,   -8,  -42,       66,  -25,  -27,       75,  -40,  -12,       85,  -54,    3,
      27,   65,  -89,       31,   53,  -82,       38,   33,  -71,       46,   13,  -57,
      56,   -7,  -41,       66,  -25,  -26,       75,  -40,  -12,       85,  -54,    3,
      27,   65,  -89,       31,   53,  -82,       38,   34,  -70,       47,   13,  -57,
      56,   -7,  -41,       66,  -24,  -26,       75,  -40,  -12,       85,  -54,    3,
      27,   66,  -88,       31,   53,  -81,       38,   35,  -70,       47,   14,  -56,
      56,   -6,  -41,       66,  -24,  -26,       75,  -39,  -12,       85,  -53,    3,
      28,   66,  -87,       32,   54,  -81,       39,   35,  -70,       47,   15,  -56,
      57,   -5,  -41,       66,  -23,  -26,       76,  -38,  -11,       85,  -53,    3,
      28,   66,  -86,       32,   55,  -80,       39,   36,  -69,       47,   16,  -55,
      57,   -4,  -40,       66,  -22,  -26,       76,  -37,  -11,       86,  -52,    3,
      29,   67,  -85,       33,   55,  -79,       39,   37,  -68,       48,   17,  -55,
      57,   -3,  -40,       66,  -21,  -25,       76,  -36,  -11,       86,  -51,    3,
      30,   67,  -84,       34,   56,  -78,       40,   38,  -67,       48,   18,  -54,
      57,   -2,  -39,       67,  -19,  -25,       76,  -35,  -11,       86,  -50,    4,
      31,   68,  -82,       34,   57,  -77,       41,   40,  -66,       48,   20,  -53,
      58,    0,  -39,       67,  -18,  -24,       76,  -34,  -10,       86,  -49,    4,
      32,   68,  -81,       35,   58,  -75,       41,   41,  -65,       49,   21,  -53,
      58,    1,  -38,       67,  -16,  -24,       77,  -32,  -10,       86,  -47,    4,
      33,   69,  -79,       36,   59,  -74,       42,   43,  -64,       50,   23,  -52,
      58,    3,  -37,       68,  -14,  -23,       77,  -31,   -9,       86,  -46,    5,
      34,   70,  -77,       37,   60,  -72,       43,   44,  -63,       50,   25,  -51,
      59,    5,  -37,       68,  -13,  -23,       77,  -29,   -9,       87,  -44,    5,
      35,   70,  -76,       38,   61,  -71,       43,   46,  -61,       51,   27,  -50,
      59,    7,  -36,       68,  -11,  -22,       77,  -27,   -8,       87,  -42,    5,
      36,   71,  -74,       39,   62,  -69,       44,   47,  -60,       51,   29,  -49,
      60,    9,  -35,       69,   -9,  -22,       78,  -25,   -8,       87,  -41,    6,
      37,   72,  -72,       40,   64,  -67,       45,   49,  -58,       52,   31,  -47,
      61,   12,  -34,       69,   -6,  -21,       78,  -23,   -7,       88,  -39,    6,
      38,   73,  -70,       41,   65,  -65,       46,   51,  -57,       53,   33,  -46,
      61,   14,  -33,       70,   -4,  -20,       79,  -21,   -7,       88,  -37,    7,
      40,   74,  -67,       42,   66,  -63,       47,   53,  -55,       54,   36,  -45,
      62,   16,  -32,       70,   -2,  -19,       79,  -18,   -6,       88,  -34,    7,
      41,   75,  -65,       43,   68,  -61,       48,   55,  -54,       55,   38,  -43,
      62,   19,  -31,       71,    1,  -18,       79,  -16,   -5,       89,  -32,    8,
      42,   76,  -63,       45,   69,  -59,       49,   57,  -52,       55,   40,  -42,
      63,   22,  -30,       71,    4,  -17,       80,  -13,   -4,       89,  -30,    9,
      44,   78,  -61,       46,   71,  -57,       50,   59,  -50,       56,   42,  -40,
      64,   24,  -29,       72,    6,  -16,       80,  -11,   -4,       89,  -27,    9,
      45,   79,  -58,       47,   72,  -55,       51,   61,  -48,       57,   45,  -39,
      65,   27,  -27,       73,    9,  -15,       81,   -8,   -3,       90,  -25,   10,
      46,   80,  -56,       48,   74,  -53,       52,   62,  -46,       58,   47,  -37,
      65,   29,  -26,       73,   11,  -14,       82,   -6,   -2,       90,  -22,   11,
      48,   81,  -54,       50,   75,  -51,       54,   64,  -44,       59,   49,  -36,
      66,   32,  -25,       74,   14,  -13,       82,   -3,   -1,       91,  -20,   12,
      49,   83,  -51,       51,   77,  -48,       55,   66,  -42,       60,   52,  -34,
      67,   35,  -23,       75,   17,  -12,       83,    0,    0,       91,  -17,   12,
      51,   84,  -49,       53,   79,  -46,       56,   68,  -40,       61,   54,  -32,
      68,   37,  -22,       75,   20,  -11,       83,    3,    1,       92,  -14,   13,
      52,   85,  -47,       54,   80,  -44,       57,   70,  -38,       62,   57,  -30,
      69,   40,  -20,       76,   23,   -9,       84,    6,    2,       92,  -11,   14,
      54,   87,  -44,       55,   82,  -42,       59,   72,  -36,       64,   59,  -29,
      70,   42,  -19,       77,   25,   -8,       85,    8,    3,       93,   -9,   15,
      55,   88,  -42,       57,   84,  -39,       60,   74,  -34,       65,   61,  -27,
      71,   45,  -17,       78,   29,   -7,       85,   12,    4,       94,   -5,   16,
      57,   90,  -39,       58,   85,  -37,       61,   76,  -32,       66,   64,  -25,
      72,   48,  -16,       79,   31,   -5,       86,   14,    5,       94,   -3,   17,
      58,   91,  -37,       60,   87,  -35,       63,   78,  -30,       67,   66,  -23,
      73,   50,  -14,       80,   34,   -4,       87,   17,    7,       95,    0,   18,
      27,   67,  -93,       31,   55,  -86,       38,   36,  -75,       47,   15,  -61,
      56,   -5,  -46,       66,  -23,  -31,       75,  -39,  -16,       85,  -53,   -1,
      27,   67,  -93,       31,   55,  -86,       38,   36,  -75,       47,   15,  -61,
      56,   -5,  -46,       66,  -23,  -31,       75,  -38,  -16,       85,  -53,   -1,
      27,   67,  -93,       31,   55,  -86,       38,   36,  -75,       47,   15,  -61,
      56,   -5,  -45,       66,  -23,  -31,       76,  -38,  -16,       85,  -52,   -1,
      28,   67,  -92,       32,   55,  -86,       38,   36,  -74,       47,   16,  -60,
      56,   -4,  -45,       66,  -22,  -30,       76,  -38,  -16,       85,  -52,   -1,
      28,   67,  -92,       32,   56,  -85,       39,   37,  -74,       47,   16,  -60,
      57,   -4,  -45,       66,  -22,  -30,       76,  -37,  -16,       85,  -52,   -1,
      28,   68,  -91,       32,   56,  -85,       39,   37,  -74,       47,   17,  -60,
      57,   -3,  -45,       66,  -21,  -30,       76,  -37,  -16,       86,  -51,   -1,
      29,   68,  -90,       33,   56,  -84,       39,   38,  -73,       48,   18,  -60,
      57,   -2,  -45,       66,  -20,  -30,       76,  -36,  -15,       86,  -50,   -1,
      29,   68,  -89,       33,   57,  -83,       40,   39,  -72,       48,   19,  -59,
      57,   -1,  -44,       67,  -19,  -30,       76,  -35,  -15,       86,  -50,   -1,
      30,   69,  -88,       34,   58,  -82,       40,   40,  -72,       48,   20,  -58,
      57,    0,  -44,       67,  -18,  -29,       76,  -34,  -15,       86,  -49,    0,
      31,   69,  -87,       34,   58,  -81,       41,   41,  -71,       49,   21,  -58,
      58,    1,  -43,       67,  -17,  -29,       76,  -33,  -15,       86,  -48,    0,
      32,   69,  -86,       35,   59,  -80,       41,   42,  -70,       49,   23,  -57,
      58,    2,  -43,       67,  -15,  -28,       77,  -32,  -14,       86,  -47,    0,
      32,   70,  -84,       36,   60,  -79,       42,   43,  -69,       49,   24,  -56,
      58,    4,  -42,       68,  -14,  -28,       77,  -30,  -14,       86,  -45,    0,
      34,   71,  -82,       37,   61,  -77,       42,   45,  -68,       50,   26,  -55,
      59,    6,  -41,       68,  -12,  -27,       77,  -29,  -13,       87,  -44,    1,
      34,   71,  -81,       38,   62,  -76,       43,   46,  -66,       51,   28,  -54,
      59,    8,  -41,       68,  -10,  -27,       77,  -27,  -13,       87,  -42,    1,
      36,   72,  -79,       39,   63,  -74,       44,   48,  -65,       51,   29,  -53,
      60,   10,  -40,       69,   -8,  -26,       78,  -25,  -12,       87,  -41,    2,
      37,   73,  -77,       39,   64,  -72,       45,   49,  -64,       52,   31,  -52,
      60,   12,  -39,       69,   -6,  -26,       78,  -23,  -12,       87,  -39,    2,
      38,   74,  -75,       41,   66,  -70,       46,   51,  -62,       53,   33,  -51,
      61,   14,  -38,       69,   -4,  -25,       78,  -21,  -11,       88,  -37,    2,
      39,   75,  -73,       42,   67,  -69,       47,   53,  -61,       53,   35,  -50,
      61,   16,  -37,       70,   -2,  -24,       79,  -19,  -11,       88,  -35,    3,
      40,   76,  -71,       43,   68,  -67,       48,   55,  -59,       54,   38,  -49,
      62,   18,  -36,       70,    0,  -23,       79,  -17,  -10,       88,  -33,    4,
      42,   77,  -69,       44,   69,  -65,       49,   56,  -57,       55,   40,  -47,
      63,   21,  -35,       71,    3,  -22,       80,  -14,   -9,       89,  -31,    4,
      43,   78,  -67,       45,   71,  -63,       50,   58,  -56,       56,   42,  -46,
      64,   23,  -34,       72,    5,  -21,       80,  -12,   -8,       89,  -28,    5,
      44,   79,  -64,       46,   72,  -61,       51,   60,  -54,       57,   44,  -44,
      64,   26,  -33,       72,    8,  -20,       81,   -9,   -8,       90,  -26,    5,
      46,   80,  -62,       48,   74,  -59,       52,   62,  -52,       58,   46,  -43,
      65,   28,  -31,       73,   10,  -19,       81,   -7,   -7,       90,  -23,    6,
      47,   81,  -60,       49,   75,  -57,       53,   64,  -50,       59,   49,  -41,
      66,   31,  -30,       74,   13,  -18,       82,   -4,   -6,       91,  -21,    7,
      48,   82,  -58,       50,   77,  -54,       54,   66,  -48,       60,   51,  -40,
      67,   33,  -29,       74,   16,  -17,       82,   -2,   -5,       91,  -18,    8,
      50,   84,  -55,       52,   78,  -52,       55,   68,  -46,       61,   53,  -38,
      68,   36,  -27,       75,   19,  -16,       83,    1,   -4,       92,  -15,    8,
      51,   85,  -53,       53,   80,  -50,       57,   70,  -44,       62,   56,  -36,
      68,   39,  -26,       76,   21,  -15,       84,    4,   -3,       92,  -13,    9,
      53,   86,  -51,       54,   81,  -48,       58,   72,  -42,       63,   58,  -34,
      69,   41,  -24,       76,   24,  -13,       84,    7,   -2,       93,  -10,   10,
      54,   88,  -48,       56,   83,  -46,       59,   73,  -40,       64,   60,  -33,
      70,   44,  -23,       77,   27,  -12,       85,   10,   -1,       93,   -7,   11,
      56,   89,  -46,       57,   85,  -43,       60,   76,  -38,       65,   63,  -31,
      71,   47,  -21,       78,   30,  -11,       86,   13,    0,       94,   -4,   12,
      57,   91,  -43,       59,   86,  -41,       62,   77,  -36,       66,   65,  -29,
      72,   49,  -20,       79,   33,   -9,       86,   16,    1,       94,   -1,   13,
      58,   92,  -41,       60,   88,  -39,       63,   79,  -34,       67,   67,  -27,
      73,   52,  -18,       80,   35,   -8,       87,   18,    3,       95,    1,   14,
      28,   69,  -96,       32,   57,  -89,       39,   39,  -78,       47,   18,  -65,
      57,   -2,  -49,       66,  -20,  -35,       76,  -36,  -20,       86,  -51,   -5,
      28,   69,  -96,       32,   57,  -89,       39,   39,  -78,       47,   18,  -64,
      57,   -2,  -49,       66,  -20,  -34,       76,  -36,  -20,       86,  -50,   -5,
      29,   69,  -95,       32,   58,  -89,       39,   39,  -78,       47,   18,  -64,
      57,   -2,  -49,       66,  -20,  -34,       76,  -36,  -20,       86,  -50,   -5,
      29,   69,  -95,       33,   58,  -89,       39,   39,  -78,       48,   19,  -64,
      57,   -2,  -49,       66,  -19,  -34,       76,  -35,  -20,       86,  -50,   -5,
      29,   69,  -95,       33,   58,  -88,       39,   40,  -77,       48,   19,  -64,
      57,   -1,  -49,       66,  -19,  -34,       76,  -35,  -20,       86,  -49,   -5,
      29,   70,  -94,       33,   58,  -88,       40,   40,  -77,       48,   20,  -64,
      57,    0,  -49,       67,  -18,  -34,       76,  -34,  -19,       86,  -49,   -5,
      30,   70,  -93,       34,   59,  -87,       40,   41,  -76,       48,   21,  -63,
      57,    0,  -48,       67,  -17,  -34,       76,  -34,  -19,       86,  -48,   -5,
      30,   70,  -92,       34,   59,  -86,       40,   42,  -76,       48,   22,  -63,
      58,    2,  -48,       67,  -16,  -33,       76,  -33,  -19,       86,  -47,   -5,
      31,   71,  -91,       35,   60,  -85,       41,   43,  -75,       49,   23,  -62,
      58,    3,  -48,       67,  -15,  -33,       76,  -32,  -19,       86,  -47,   -4,
      32,   71,  -90,       35,   61,  -84,       41,   44,  -74,       49,   24,  -62,
      58,    4,  -47,       67,  -14,  -33,       77,  -31,  -18,       86,  -46,   -4,
      33,   71,  -89,       36,   61,  -83,       42,   45,  -73,       50,   25,  -61,
      58,    5,  -47,       68,  -13,  -32,       77,  -29,  -18,       86,  -45,   -4,
      33,   72,  -87,       37,   62,  -82,       42,   46,  -72,       50,   27,  -60,
      59,    7,  -46,       68,  -11,  -32,       77,  -28,  -18,       87,  -43,   -4,
      34,   72,  -86,       37,   63,  -80,       43,   47,  -71,       51,   28,  -59,
      59,    8,  -45,       68,  -10,  -31,       77,  -26,  -17,       87,  -42,   -3,
      35,   73,  -84,       38,   64,  -79,       44,   49,  -70,       51,   30,  -58,
      60,   10,  -45,       69,   -8,  -31,       78,  -25,  -17,       87,  -40,   -3,
      36,   74,  -82,       39,   65,  -77,       45,   50,  -69,       52,   32,  -57,
      60,   12,  -44,       69,   -6,  -30,       78,  -23,  -16,       87,  -39,   -2,
      37,   74,  -80,       40,   66,  -76,       45,   52,  -67,       52,   34,  -56,
      61,   14,  -43,       69,   -4,  -29,       78,  -21,  -16,       88,  -37,   -2,
      39,   75,  -78,       41,   67,  -74,       46,   53,  -66,       53,   36,  -55,
      61,   16,  -42,       70,   -2,  -29,       79,  -19,  -15,       88,  -35,   -1,
      40,   76,  -76,       42,   69,  -72,       47,   55,  -64,       54,   38,  -54,
      62,   18,  -41,       70,    0,  -28,       79,  -17,  -15,       88,  -33,   -1,
      41,   77,  -74,       43,   70,  -70,       48,   57,  -63,       55,   40,  -52,
      62,   21,  -40,       71,    2,  -27,       79,  -15,  -14,       89,  -31,    0,
      42,   78,  -72,       45,   71,  -69,       49,   58,  -61,       55,   42,  -51,
      63,   23,  -39,       71,    5,  -26,       80,  -12,  -13,       89,  -29,    0,
      44,   79,  -70,       46,   73,  -66,       50,   60,  -59,       56,   44,  -50,
      64,   25,  -38,       72,    7,  -25,       80,  -10,  -12,       89,  -26,    1,
      45,   80,  -68,       47,   74,  -64,       51,   62,  -58,       57,   46,  -48,
      65,   28,  -37,       73,   10,  -24,       81,   -7,  -12,       90,  -24,    2,
      46,   81,  -66,       48,   75,  -62,       52,   64,  -56,       58,   48,  -47,
      65,   30,  -35,       73,   12,  -23,       81,   -5,  -11,       90,  -22,    2,
      47,   83,  -64,       49,   77,  -60,       53,   65,  -54,       59,   50,  -45,
      66,   33,  -34,       74,   15,  -22,       82,   -2,  -10,       91,  -19,    3,
      49,   84,  -61,       51,   78,  -58,       55,   67,  -52,       60,   52,  -44,
      67,   35,  -33,       74,   17,  -21,       83,    0,   -9,       91,  -17,    4,
      50,   85,  -59,       52,   80,  -56,       56,   69,  -50,       61,   55,  -42,
      68,   38,  -31,       75,   20,  -20,       83,    3,   -8,       92,  -14,    5,
      52,   86,  -57,       53,   81,  -54,       57,   71,  -48,       62,   57,  -40,
      69,   40,  -30,       76,   23,  -19,       84,    6,   -7,       92,  -11,    5,
      53,   88,  -54,       55,   83,  -52,       58,   73,  -46,       63,   59,  -38,
      70,   43,  -28,       77,   26,  -17,       84,    8,   -6,       93,   -9,    6,
      54,   89,  -52,       56,   84,  -49,       59,   75,  -44,       64,   61,  -37,
      70,   45,  -27,       78,   28,  -16,       85,   11,   -5,       93,   -6,    7,
      56,   90,  -49,       58,   86,  -47,       61,   77,  -42,       65,   64,  -35,
      72,   48,  -25,       78,   31,  -15,       86,   14,   -4,       94,   -3,    8,
      57,   92,  -47,       59,   87,  -45,       62,   79,  -40,       67,   66,  -33,
      72,   50,  -24,       79,   34,  -13,       87,   17,   -3,       95,    0,    9,
      59,   93,  -45,       60,   89,  -42,       63,   80,  -38,       68,   68,  -31,
      73,   53,  -22,       80,   36,  -12,       87,   20,   -1,       95,    3,   10,
      29,   71,  -99,       33,   60,  -92,       40,   42,  -82,       48,   21,  -68,
      57,    1,  -53,       67,  -17,  -38,       76,  -34,  -24,       86,  -48,   -9,
      29,   71,  -98,       33,   60,  -92,       40,   42,  -81,       48,   21,  -68,
      57,    1,  -53,       67,  -17,  -38,       76,  -33,  -24,       86,  -48,   -9,
      30,   71,  -98,       33,   60,  -92,       40,   42,  -81,       48,   22,  -68,
      57,    1,  -53,       67,  -17,  -38,       76,  -33,  -24,       86,  -48,   -9,
      30,   71,  -98,       34,   60,  -92,       40,   42,  -81,       48,   22,  -68,
      57,    1,  -53,       67,  -17,  -38,       76,  -33,  -24,       86,  -48,   -9,
      30,   72,  -97,       34,   61,  -91,       40,   43,  -81,       48,   22,  -68,
      57,    2,  -53,       67,  -16,  -38,       76,  -32,  -23,       86,  -47,   -9,
      31,   72,  -97,       34,   61,  -91,       40,   43,  -80,       48,   23,  -67,
      58,    3,  -52,       67,  -15,  -38,       76,  -32,  -23,       86,  -47,   -9,
      31,   72,  -96,       34,   61,  -90,       41,   44,  -80,       49,   24,  -67,
      58,    3,  -52,       67,  -15,  -38,       76,  -31,  -23,       86,  -46,   -9,
      32,   72,  -95,       35,   62,  -89,       41,   45,  -79,       49,   25,  -66,
      58,    4,  -52,       67,  -14,  -37,       77,  -30,  -23,       86,  -45,   -8,
      32,   72,  -94,       35,   62,  -88,       41,   45,  -78,       49,   26,  -66,
      58,    5,  -51,       67,  -13,  -37,       77,  -29,  -23,       86,  -44,   -8,
      33,   73,  -93,       36,   63,  -87,       42,   46,  -78,       50,   27,  -65,
      59,    7,  -51,       68,  -12,  -37,       77,  -28,  -22,       86,  -44,   -8,
      33,   73,  -92,       37,   64,  -86,       42,   47,  -77,       50,   28,  -64,
      59,    8,  -50,       68,  -10,  -36,       77,  -27,  -22,       87,  -42,   -8,
      34,   74,  -90,       37,   64,  -85,       43,   48,  -76,       50,   29,  -64,
      59,    9,  -50,       68,   -9,  -36,       77,  -26,  -22,       87,  -41,   -7,
      35,   74,  -89,       38,   65,  -84,       44,   50,  -75,       51,   31,  -63,
      60,   11,  -49,       68,   -7,  -35,       78,  -24,  -21,       87,  -40,   -7,
      36,   75,  -87,       39,   66,  -82,       44,   51,  -73,       52,   32,  -62,
      60,   13,  -48,       69,   -6,  -35,       78,  -22,  -21,       87,  -38,   -7,
      37,   75,  -85,       40,   67,  -81,       45,   52,  -72,       52,   34,  -61,
      61,   14,  -48,       69,   -4,  -34,       78,  -21,  -20,       88,  -37,   -6,
      38,   76,  -84,       41,   68,  -79,       46,   54,  -71,       53,   36,  -60,
      61,   16,  -47,       70,   -2,  -33,       79,  -19,  -20,       88,  -35,   -6,
      39,   77,  -82,       42,   69,  -77,       47,   55,  -69,       54,   38,  -59,
      62,   19,  -46,       70,    0,  -33,       79,  -17,  -19,       88,  -33,   -5,
      40,   78,  -80,       43,   70,  -76,       48,   57,  -68,       54,   40,  -57,
      62,   21,  -45,       71,    2,  -32,       79,  -15,  -18,       88,  -31,   -5,
      42,   79,  -78,       44,   72,  -74,       49,   58,  -66,       55,   42,  -56,
      63,   23,  -44,       71,    4,  -31,       80,  -13,  -18,       89,  -29,   -4,
      43,   80,  -76,       45,   73,  -72,       50,   60,  -65,       56,   44,  -55,
      63,   25,  -43,       72,    7,  -30,       80,  -11,  -17,       89,  -27,   -4,
      44,   81,  -74,       46,   74,  -70,       51,   62,  -63,       57,   46,  -53,
      64,   27,  -42,       72,    9,  -29,       81,   -8,  -16,       90,  -25,   -3,
      45,   82,  -72,       48,   75,  -68,       52,   64,  -61,       58,   48,  -52,
      65,   30,  -40,       73,   12,  -28,       81,   -6,  -15,       90,  -22,   -2,
      47,   83,  -69,       49,   77,  -66,       53,   65,  -60,       58,   50,  -50,
      66,   32,  -39,       73,   14,  -27,       82,   -3,  -15,       90,  -20,   -2,
      48,   84,  -67,       50,   78,  -64,       54,   67,  -58,       59,   52,  -49,
      66,   34,  -38,       74,   17,  -26,       82,   -1,  -14,       91,  -18,   -1,
      49,   85,  -65,       51,   79,  -62,       55,   69,  -56,       60,   54,  -47,
      67,   37,  -37,       75,   19,  -25,       83,    2,  -13,       91,  -15,    0,
      51,   86,  -63,       53,   81,  -60,       56,   71,  -54,       61,   56,  -46,
      68,   39,  -35,       76,   22,  -24,       83,    5,  -12,       92,  -12,    1,
      52,   88,  -60,       54,   82,  -58,       57,   72,  -52,       62,   59,  -44,
      69,   42,  -34,       76,   24,  -23,       84,    7,  -11,       92,  -10,    2,
      53,   89,  -58,       55,   84,  -55,       59,   74,  -50,       63,   61,  -42,
      70,   44,  -32,       77,   27,  -21,       85,   10,  -10,       93,   -7,    2,
      55,   90,  -56,       56,   85,  -53,       60,   76,  -48,       65,   63,  -41,
      71,   47,  -31,       78,   30,  -20,       85,   13,   -9,       94,   -5,    3,
      56,   92,  -53,       58,   87,  -51,       61,   78,  -46,       66,   65,  -39,
      72,   49,  -29,       79,   33,  -19,       86,   16,   -8,       94,   -2,    4,
      58,   93,  -51,       59,   88,  -49,       62,   80,  -44,       67,   67,  -37,
      73,   52,  -28,       79,   35,  -17,       87,   18,   -6,       95,    1,    5,
      59,   94,  -49,       61,   90,  -46,       64,   82,  -42,       68,   69,  -35,
      74,   54,  -26,       80,   38,  -16,       88,   21,   -5,       95,    4,    6,
      31,   73, -102,       34,   63,  -96,       40,   45,  -85,       48,   25,  -72,
      58,    4,  -57,       67,  -14,  -43,       76,  -31,  -28,       86,  -46,  -13,
      31,   73, -101,       34,   63,  -95,       41,   45,  -85,       49,   25,  -72,
      58,    4,  -57,       67,  -14,  -43,       76,  -30,  -28,       86,  -46,  -13,
      31,   74, -101,       34,   63,  -95,       41,   45,  -85,       49,   25,  -72,
      58,    4,  -57,       67,  -14,  -43,       76,  -30,  -28,       86,  -45,  -13,
      31,   74, -101,       35,   63,  -95,       41,   46,  -85,       49,   25,  -72,
      58,    5,  -57,       67,  -13,  -42,       76,  -30,  -28,       86,  -45,  -13,
      31,   74, -100,       35,   63,  -95,       41,   46,  -84,       49,   26,  -72,
      58,    5,  -57,       67,  -13,  -42,       76,  -29,  -28,       86,  -45,  -13,
      32,   74, -100,       35,   64,  -94,       41,   46,  -84,       49,   26,  -71,
      58,    6,  -57,       67,  -12,  -42,       77,  -29,  -28,       86,  -44,  -13,
      32,   74,  -99,       36,   64,  -93,       42,   47,  -84,       49,   27,  -71,
      58,    7,  -56,       67,  -12,  -42,       77,  -28,  -28,       86,  -44,  -13,
      33,   74,  -98,       36,   64,  -93,       42,   48,  -83,       50,   28,  -70,
      58,    8,  -56,       68,  -11,  -42,       77,  -27,  -27,       86,  -43,  -13,
      33,   75,  -97,       36,   65,  -92,       42,   48,  -82,       50,   29,  -70,
      59,    9,  -56,       68,  -10,  -41,       77,  -26,  -27,       87,  -42,  -13,
      34,   75,  -96,       37,   65,  -91,       43,   49,  -81,       50,   30,  -69,
      59,   10,  -55,       68,   -9,  -41,       77,  -25,  -27,       87,  -41,  -12,
      35,   75,  -95,       38,   66,  -90,       43,   50,  -81,       51,   31,  -69,
      59,   11,  -55,       68,   -7,  -41,       77,  -24,  -26,       87,  -40,  -12,
      35,   76,  -94,       38,   67,  -89,       44,   51,  -80,       51,   32,  -68,
      60,   12,  -54,       69,   -6,  -40,       78,  -23,  -26,       87,  -39,  -12,
      36,   76,  -92,       39,   68,  -87,       45,   52,  -78,       52,   34,  -67,
      60,   14,  -53,       69,   -4,  -40,       78,  -21,  -26,       87,  -37,  -11,
      37,   77,  -91,       40,   68,  -86,       45,   54,  -77,       52,   35,  -66,
      61,   16,  -53,       69,   -3,  -39,       78,  -20,  -25,       88,  -36,  -11,
      38,   77,  -89,       41,   69,  -85,       46,   55,  -76,       53,   37,  -65,
      61,   17,  -52,       70,   -1,  -38,       78,  -18,  -25,       88,  -34,  -11,
      39,   78,  -87,       42,   70,  -83,       47,   56,  -75,       53,   38,  -64,
      61,   19,  -51,       70,    1,  -38,       79,  -17,  -24,       88,  -33,  -10,
      40,   79,  -85,       43,   71,  -81,       48,   58,  -73,       54,   40,  -63,
      62,   21,  -50,       70,    3,  -37,       79,  -14,  -23,       88,  -31,  -10,
      41,   80,  -84,       44,   72,  -80,       48,   59,  -72,       55,   42,  -62,
      63,   23,  -49,       71,    5,  -36,       80,  -13,  -23,       89,  -29,   -9,
      42,   80,  -82,       45,   73,  -78,       49,   61,  -70,       56,   44,  -60,
      63,   25,  -48,       71,    7,  -35,       80,  -11,  -22,       89,  -27,   -9,
      44,   81,  -80,       46,   75,  -76,       50,   62,  -69,       56,   46,  -59,
      64,   27,  -47,       72,    9,  -34,       80,   -8,  -21,       89,  -25,   -8,
      45,   82,  -78,       47,   76,  -74,       51,   64,  -67,       57,   48,  -58,
      65,   30,  -46,       73,   11,  -33,       81,   -6,  -21,       90,  -23,   -7,
      46,   83,  -75,       48,   77,  -72,       52,   66,  -65,       58,   50,  -56,
      65,   32,  -45,       73,   14,  -33,       81,   -4,  -20,       90,  -20,   -7,
      47,   84,  -73,       49,   78,  -70,       53,   67,  -64,       59,   52,  -55,
      66,   34,  -44,       74,   16,  -32,       82,   -1,  -19,       91,  -18,   -6,
      49,   85,  -71,       51,   80,  -68,       54,   69,  -62,       60,   54,  -53,
      67,   36,  -42,       74,   19,  -30,       82,    1,  -18,       91,  -16,   -5,
      50,   87,  -69,       52,   81,  -66,       55,   70,  -60,       61,   56,  -52,
      68,   39,  -41,       75,   21,  -29,       83,    4,  -17,       92,  -13,   -5,
      51,   88,  -67,       53,   82,  -64,       57,   72,  -58,       62,   58,  -50,
      69,   41,  -39,       76,   24,  -28,       84,    6,  -16,       92,  -11,   -4,
      53,   89,  -64,       54,   84,  -62,       58,   74,  -56,       63,   60,  -48,
      69,   43,  -38,       77,   26,  -27,       84,    9,  -15,       93,   -8,   -3,
      54,   90,  -62,       56,   85,  -60,       59,   76,  -54,       64,   62,  -47,
      70,   46,  -37,       77,   29,  -26,       85,   12,  -14,       93,   -6,   -2,
      55,   91,  -60,       57,   87,  -57,       60,   77,  -52,       65,   64,  -45,
      71,   48,  -35,       78,   31,  -25,       86,   14,  -13,       94,   -3,   -1,
      57,   93,  -58,       58,   88,  -55,       62,   79,  -50,       66,   67,  -43,
      72,   51,  -34,       79,   34,  -23,       86,   17,  -12,       94,    0,    0,
      58,   94,  -55,       60,   90,  -53,       63,   81,  -48,       67,   69,  -41,
      73,   53,  -32,       80,   37,  -22,       87,   20,  -11,       95,    3,    1,
      60,   95,  -53,       61,   91,  -51,       64,   83,  -46,       68,   71,  -39,
      74,   56,  -30,       81,   39,  -20,       88,   23,  -10,       96,    5,    2,
      32,   75, -104,       35,   65,  -99,       41,   48,  -88,       49,   28,  -76,
      58,    7,  -61,       67,  -11,  -47,       77,  -28,  -32,       86,  -43,  -17,
      32,   75, -104,       35,   65,  -98,       41,   48,  -88,       49,   28,  -76,
      58,    7,  -61,       67,  -11,  -46,       77,  -28,  -32,       86,  -43,  -17,
      32,   76, -104,       35,   65,  -98,       41,   48,  -88,       49,   28,  -75,
      58,    8,  -61,       67,  -11,  -46,       77,  -28,  -32,       86,  -43,  -17,
      32,   76, -103,       36,   65,  -98,       42,   48,  -88,       49,   28,  -75,
      58,    8,  -61,       67,  -11,  -46,       77,  -27,  -32,       86,  -43,  -17,
      32,   76, -103,       36,   66,  -97,       42,   49,  -88,       49,   29,  -75,
      58,    8,  -61,       68,  -10,  -46,       77,  -27,  -32,       86,  -42,  -17,
      33,   76, -102,       36,   66,  -97,       42,   49,  -87,       50,   29,  -75,
      59,    9,  -60,       68,  -10,  -46,       77,  -26,  -32,       86,  -42,  -17,
      33,   76, -102,       36,   66,  -96,       42,   50,  -87,       50,   30,  -74,
      59,   10,  -60,       68,   -9,  -46,       77,  -26,  -31,       87,  -41,  -17,
      34,   76, -101,       37,   67,  -96,       43,   50,  -86,       50,   31,  -74,
      59,   10,  -60,       68,   -8,  -45,       77,  -25,  -31,       87,  -41,  -17,
      34,   77, -100,       37,   67,  -95,       43,   51,  -85,       50,   32,  -73,
      59,   11,  -59,       68,   -7,  -45,       77,  -24,  -31,       87,  -40,  -16,
      35,   77,  -99,       38,   68,  -94,       43,   52,  -85,       51,   33,  -73,
      59,   12,  -59,       68,   -6,  -45,       77,  -23,  -31,       87,  -39,  -16,
      36,   77,  -98,       39,   68,  -93,       44,   53,  -84,       51,   34,  -72,
      60,   14,  -58,       69,   -5,  -44,       78,  -22,  -30,       87,  -38,  -16,
      36,   78,  -97,       39,   69,  -92,       45,   54,  -83,       52,   35,  -71,
      60,   15,  -58,       69,   -4,  -44,       78,  -21,  -30,       87,  -37,  -16,
      37,   78,  -95,       40,   70,  -90,       45,   55,  -82,       52,   36,  -70,
      61,   17,  -57,       69,   -2,  -43,       78,  -19,  -29,       88,  -35,  -15,
      38,   79,  -94,       41,   70,  -89,       46,   56,  -81,       53,   38,  -70,
      61,   18,  -56,       70,    0,  -43,       78,  -18,  -29,       88,  -34,  -15,
      39,   79,  -92,       42,   71,  -88,       47,   57,  -80,       53,   39,  -69,
      61,   20,  -56,       70,    1,  -42,       79,  -16,  -28,       88,  -32,  -14,
      40,   80,  -91,       42,   72,  -86,       47,   58,  -78,       54,   41,  -68,
      62,   21,  -55,       70,    3,  -42,       79,  -14,  -28,       88,  -31,  -14,
      41,   81,  -89,       44,   73,  -85,       48,   60,  -77,       55,   43,  -66,
      62,   23,  -54,       71,    5,  -41,       79,  -12,  -27,       89,  -29,  -13,
      42,   81,  -87,       44,   74,  -83,       49,   61,  -75,       55,   44,  -65,
      63,   25,  -53,       71,    7,  -40,       80,  -10,  -27,       89,  -27,  -13,
      43,   82,  -85,       45,   75,  -81,       50,   63,  -74,       56,   46,  -64,
      64,   27,  -52,       72,    9,  -39,       80,   -8,  -26,       89,  -25,  -12,
      44,   83,  -83,       47,   76,  -79,       51,   64,  -72,       57,   48,  -63,
      64,   29,  -51,       72,   11,  -38,       81,   -6,  -25,       90,  -23,  -12,
      46,   84,  -81,       48,   78,  -77,       52,   66,  -71,       58,   50,  -61,
      65,   32,  -50,       73,   14,  -37,       81,   -4,  -24,       90,  -21,  -11,
      47,   85,  -79,       49,   79,  -76,       53,   67,  -69,       59,   52,  -60,
      66,   34,  -49,       73,   16,  -36,       82,   -2,  -24,       90,  -19,  -11,
      48,   86,  -77,       50,   80,  -74,       54,   69,  -67,       59,   54,  -58,
      66,   36,  -47,       74,   18,  -35,       82,    1,  -23,       91,  -16,  -10,
      49,   87,  -75,       51,   81,  -72,       55,   70,  -66,       60,   56,  -57,
      67,   38,  -46,       75,   20,  -34,       83,    3,  -22,       91,  -14,   -9,
      51,   88,  -73,       52,   82,  -70,       56,   72,  -64,       61,   58,  -55,
      68,   40,  -45,       75,   23,  -33,       83,    5,  -21,       92,  -12,   -8,
      52,   89,  -70,       54,   84,  -67,       57,   74,  -62,       62,   60,  -54,
      69,   43,  -43,       76,   25,  -32,       84,    8,  -20,       92,   -9,   -7,
      53,   90,  -68,       55,   85,  -65,       58,   75,  -60,       63,   62,  -52,
      70,   45,  -42,       77,   28,  -31,       85,   11,  -19,       93,   -7,   -7,
      55,   91,  -66,       56,   87,  -63,       59,   77,  -58,       64,   64,  -50,
      71,   47,  -40,       78,   30,  -30,       85,   13,  -18,       93,   -4,   -6,
      56,   93,  -64,       57,   88,  -61,       61,   79,  -56,       65,   66,  -49,
      71,   50,  -39,       78,   33,  -28,       86,   16,  -17,       94,   -1,   -5,
      57,   94,  -61,       59,   89,  -59,       62,   81,  -54,       67,   68,  -47,
      73,   52,  -37,       79,   36,  -27,       87,   19,  -16,       95,    1,   -4,
      59,   95,  -59,       60,   91,  -57,       63,   82,  -52,       68,   70,  -45,
      73,   55,  -36,       80,   38,  -26,       87,   21,  -15,       95,    4,   -3,
      60,   96,  -57,       62,   92,  -54,       64,   84,  -50,       69,   72,  -43,
      74,   57,  -34,       81,   41,  -24,       88,   24,  -14,       96,    7,   -2,
      33,   77, -107,       36,   67, -101,       42,   51,  -92,       50,   31,  -79,
      59,   10,  -65,       68,   -8,  -50,       77,  -25,  -36,       86,  -41,  -21,
      33,   77, -107,       36,   68, -101,       42,   51,  -92,       50,   31,  -79,
      59,   10,  -65,       68,   -8,  -50,       77,  -25,  -36,       87,  -41,  -21,
      33,   77, -106,       36,   68, -101,       42,   51,  -91,       50,   31,  -79,
      59,   11,  -65,       68,   -8,  -50,       77,  -25,  -36,       87,  -41,  -21,
      33,   78, -106,       37,   68, -101,       42,   51,  -91,       50,   31,  -79,
      59,   11,  -64,       68,   -8,  -50,       77,  -25,  -36,       87,  -40,  -21,
      34,   78, -106,       37,   68, -100,       43,   52,  -91,       50,   32,  -78,
      59,   11,  -64,       68,   -7,  -50,       77,  -24,  -35,       87,  -40,  -21,
      34,   78, -105,       37,   68, -100,       43,   52,  -90,       50,   32,  -78,
      59,   12,  -64,       68,   -7,  -50,       77,  -24,  -35,       87,  -40,  -21,
      34,   78, -105,       37,   69,  -99,       43,   52,  -90,       50,   33,  -78,
      59,   13,  -64,       68,   -6,  -49,       77,  -23,  -35,       87,  -39,  -21,
      35,   78, -104,       38,   69,  -99,       43,   53,  -89,       51,   34,  -77,
      59,   13,  -63,       68,   -5,  -49,       77,  -22,  -35,       87,  -38,  -20,
      35,   78, -103,       38,   69,  -98,       44,   54,  -89,       51,   35,  -77,
      60,   14,  -63,       68,   -4,  -49,       78,  -21,  -35,       87,  -37,  -20,
      36,   79, -102,       39,   70,  -97,       44,   54,  -88,       51,   35,  -76,
      60,   15,  -62,       69,   -3,  -48,       78,  -20,  -34,       87,  -37,  -20,
      37,   79, -101,       39,   70,  -96,       45,   55,  -87,       52,   37,  -76,
      60,   16,  -62,       69,   -2,  -48,       78,  -19,  -34,       87,  -36,  -20,
      37,   79, -100,       40,   71,  -95,       45,   56,  -86,       52,   38,  -75,
      61,   18,  -61,       69,   -1,  -48,       78,  -18,  -34,       88,  -34,  -19,
      38,   80,  -98,       41,   72,  -94,       46,   57,  -85,       53,   39,  -74,
      61,   19,  -61,       70,    1,  -47,       78,  -17,  -33,       88,  -33,  -19,
      39,   80,  -97,       42,   72,  -92,       47,   58,  -84,       53,   40,  -73,
      61,   21,  -60,       70,    2,  -47,       79,  -15,  -33,       88,  -32,  -19,
      40,   81,  -95,       42,   73,  -91,       47,   59,  -83,       54,   42,  -72,
      62,   22,  -59,       70,    4,  -46,       79,  -14,  -32,       88,  -30,  -18,
      41,   82,  -94,       43,   74,  -89,       48,   61,  -82,       54,   43,  -71,
      62,   24,  -58,       71,    5,  -45,       79,  -12,  -32,       89,  -29,  -18,
      42,   82,  -92,       44,   75,  -88,       49,   62,  -80,       55,   45,  -70,
      63,   26,  -58,       71,    7,  -45,       80,  -10,  -31,       89,  -27,  -17,
      43,   83,  -90,       45,   76,  -86,       50,   63,  -79,       56,   47,  -69,
      63,   28,  -57,       72,    9,  -44,       80,   -8,  -31,       89,  -25,  -17,
      44,   84,  -88,       46,   77,  -85,       50,   65,  -77,       57,   48,  -68,
      64,   29,  -56,       72,   11,  -43,       81,   -6,  -30,       90,  -23,  -16,
      45,   84,  -86,       47,   78,  -83,       51,   66,  -76,       57,   50,  -66,
      65,   31,  -55,       73,   13,  -42,       81,   -4,  -29,       90,  -21,  -16,
      46,   85,  -84,       48,   79,  -81,       52,   68,  -74,       58,   52,  -65,
      65,   34,  -53,       73,   16,  -41,       81,   -2,  -28,       90,  -19,  -15,
      47,   86,  -82,       49,   80,  -79,       53,   69,  -73,       59,   54,  -64,
      66,   36,  -52,       74,   18,  -40,       82,    0,  -28,       91,  -17,  -14,
      49,   87,  -80,       51,   81,  -77,       54,   71,  -71,       60,   56,  -62,
      67,   38,  -51,       74,   20,  -39,       82,    2,  -27,       91,  -15,  -14,
      50,   88,  -78,       52,   83,  -75,       55,   72,  -69,       61,   57,  -61,
      68,   40,  -50,       75,   22,  -38,       83,    5,  -26,       92,  -12,  -13,
      51,   89,  -76,       53,   84,  -73,       56,   74,  -67,       62,   59,  -59,
      68,   42,  -49,       76,   25,  -37,       84,    7,  -25,       92,  -10,  -12,
      53,   90,  -74,       54,   85,  -71,       58,   75,  -65,       63,   61,  -57,
      69,   45,  -47,       76,   27,  -36,       84,   10,  -24,       93,   -7,  -11,
      54,   91,  -72,       55,   87,  -69,       59,   77,  -64,       64,   63,  -56,
      70,   47,  -46,       77,   30,  -35,       85,   12,  -23,       93,   -5,  -10,
      55,   93,  -70,       57,   88,  -67,       60,   79,  -62,       65,   65,  -54,
      71,   49,  -44,       78,   32,  -34,       85,   15,  -22,       94,   -2,  -10,
      56,   94,  -67,       58,   89,  -65,       61,   80,  -60,       66,   67,  -52,
      72,   51,  -43,       79,   34,  -32,       86,   17,  -21,       94,    0,   -9,
      58,   95,  -65,       59,   91,  -62,       62,   82,  -58,       67,   69,  -51,
      73,   54,  -41,       80,   37,  -31,       87,   20,  -20,       95,    3,   -8,
      59,   96,  -63,       61,   92,  -60,       64,   84,  -56,       68,   71,  -49,
      74,   56,  -40,       80,   40,  -30,       88,   23,  -19,       95,    6,   -7,
      61,   98,  -60,       62,   93,  -58,       65,   85,  -54,       69,   73,  -47,
      75,   58,  -38,       81,   42,  -28,       88,   25,  -17,       96,    8,   -6,
       3,   -7,    5,       16,  -27,   23,       29,  -37,   36,       41,  -47,   46,
      52,  -57,   55,       63,  -66,   64,       74,  -74,   72,       84,  -83,   80,
       4,   -5,    6,       17,  -25,   24,       29,  -36,   36,       41,  -47,   46,
      53,  -56,   55,       63,  -65,   64,       74,  -74,   72,       84,  -83,   80,
       4,   -2,    6,       17,  -22,   24,       29,  -35,   37,       41,  -46,   46,
      53,  -56,   55,       63,  -65,   64,       74,  -74,   72,       84,  -83,   80,
       5,    2,    8,       17,  -19,   25,       30,  -33,   37,       41,  -44,   46,
      53,  -55,   55,       63,  -64,   64,       74,  -73,   72,       84,  -82,   80,
       6,    6,   10,       18,  -15,   25,       30,  -31,   37,       41,  -43,   46,
      53,  -54,   55,       63,  -63,   64,       74,  -73,   72,       84,  -82,   80,
       8,   11,   12,       19,  -11,   26,       30,  -28,   38,       42,  -41,   47,
      53,  -52,   56,       64,  -62,   64,       74,  -72,   72,       84,  -81,   80,
       9,   16,   14,       19,   -7,   27,       31,  -25,   38,       42,  -38,   47,
      53,  -51,   56,       64,  -61,   64,       74,  -71,   72,       84,  -80,   81,
      11,   20,   17,       20,   -2,   29,       31,  -21,   39,       42,  -36,   47,
      53,  -48,   56,       64,  -59,   64,       74,  -69,   73,       84,  -79,   81,
      13,   23,   20,       21,    3,   30,       32,  -17,   40,       43,  -33,   48,
      54,  -46,   56,       64,  -57,   65,       74,  -68,   73,       85,  -78,   81,
      15,   27,   22,       22,    7,   32,       33,  -13,   40,       43,  -29,   48,
      54,  -44,   57,       64,  -56,   65,       75,  -66,   73,       85,  -76,   81,
      16,   30,   25,       24,   11,   33,       33,   -9,   41,       44,  -26,   49,
      54,  -41,   57,       65,  -53,   65,       75,  -64,   73,       85,  -75,   81,
      18,   32,   28,       25,   15,   35,       34,   -5,   42,       44,  -23,   50,
      55,  -38,   58,       65,  -51,   66,       75,  -62,   74,       85,  -73,   82,
      20,   36,   30,       26,   19,   37,       35,    0,   43,       45,  -18,   50,
      55,  -35,   58,       65,  -48,   66,       75,  -60,   74,       85,  -71,   82,
      22,   38,   33,       28,   23,   38,       36,    4,   44,       46,  -15,   51,
      56,  -31,   59,       66,  -45,   67,       76,  -58,   74,       86,  -69,   82,
      24,   41,   35,       29,   27,   40,       37,    8,   46,       46,  -11,   52,
      56,  -28,   60,       66,  -42,   67,       76,  -55,   75,       86,  -67,   82,
      26,   43,   38,       30,   30,   42,       38,   12,   47,       47,   -7,   53,
      57,  -25,   60,       67,  -39,   68,       76,  -53,   75,       86,  -65,   83,
      28,   46,   40,       32,   34,   44,       39,   16,   48,       48,   -3,   54,
      58,  -21,   61,       67,  -36,   68,       77,  -50,   76,       87,  -62,   83,
      29,   49,   42,       34,   37,   45,       40,   20,   49,       49,    1,   55,
      58,  -17,   62,       68,  -33,   69,       77,  -47,   76,       87,  -60,   84,
      31,   51,   44,       35,   40,   47,       42,   23,   51,       50,    5,   56,
      59,  -13,   63,       68,  -29,   69,       78,  -44,   77,       87,  -57,   84,
      33,   53,   46,       36,   43,   49,       43,   27,   52,       51,    9,   57,
      60,  -10,   63,       69,  -26,   70,       78,  -41,   77,       88,  -55,   85,
      35,   56,   49,       38,   46,   50,       44,   31,   54,       52,   13,   58,
      60,   -6,   64,       69,  -22,   71,       79,  -37,   78,       88,  -51,   85,
      36,   58,   50,       40,   49,   52,       45,   34,   55,       53,   16,   59,
      61,   -2,   65,       70,  -19,   72,       79,  -34,   78,       88,  -48,   86,
      38,   60,   52,       41,   51,   53,       47,   37,   56,       54,   20,   61,
      62,    2,   66,       71,  -15,   72,       80,  -31,   79,       89,  -46,   86,
      40,   62,   54,       43,   54,   55,       48,   40,   58,       55,   24,   62,
      63,    5,   67,       71,  -12,   73,       80,  -27,   80,       89,  -42,   87,
      42,   64,   56,       44,   57,   57,       49,   43,   59,       56,   27,   63,
      64,    9,   68,       72,   -8,   74,       81,  -24,   80,       90,  -39,   87,
      43,   67,   57,       46,   59,   58,       51,   47,   61,       57,   31,   64,
      65,   13,   69,       73,   -4,   75,       81,  -20,   81,       90,  -36,   88,
      45,   69,   59,       48,   62,   60,       52,   50,   62,       58,   34,   66,
      66,   17,   70,       74,   -1,   76,       82,  -17,   82,       91,  -33,   89,
      47,   71,   61,       49,   64,   62,       53,   53,   64,       59,   37,   67,
      67,   20,   72,       74,    3,   77,       83,  -13,   83,       92,  -29,   89,
      49,   73,   62,       51,   66,   63,       55,   55,   65,       60,   41,   68,
      68,   23,   73,       75,    6,   78,       83,  -10,   84,       92,  -26,   90,
      50,   75,   64,       52,   69,   65,       56,   58,   67,       62,   44,   70,
      69,   27,   74,       76,   10,   79,       84,   -6,   85,       93,  -22,   91,
      52,   77,   66,       54,   71,   67,       58,   61,   68,       63,   47,   71,
      70,   31,   75,       77,   14,   80,       85,   -3,   85,       93,  -19,   91,
      54,   79,   67,       56,   73,   68,       59,   64,   70,       64,   50,   72,
      71,   34,   76,       78,   17,   81,       86,    1,   86,       94,  -16,   92,
       4,   -6,    2,       17,  -26,   20,       29,  -37,   33,       41,  -47,   44,
      52,  -57,   54,       63,  -66,   62,       74,  -74,   71,       84,  -83,   80,
       4,   -4,    3,       17,  -24,   20,       29,  -36,   33,       41,  -46,   44,
      53,  -56,   54,       63,  -65,   63,       74,  -74,   71,       84,  -83,   80,
       5,   -1,    3,       17,  -21,   21,       29,  -34,   34,       41,  -45,   44,
      53,  -56,   54,       63,  -65,   63,       74,  -74,   71,       84,  -82,   80,
       5,    3,    5,       18,  -18,   21,       30,  -32,   34,       41,  -44,   44,
      53,  -55,   54,       63,  -64,   63,       74,  -73,   71,       84,  -82,   80,
       6,    7,    6,       18,  -14,   22,       30,  -30,   34,       41,  -42,   44,
      53,  -53,   54,       63,  -63,   63,       74,  -72,   71,       84,  -81,   80,
       8,   12,    9,       19,  -10,   23,       30,  -27,   35,       42,  -40,   45,
      53,  -52,   54,       64,  -62,   63,       74,  -72,   71,       84,  -81,   80,
       9,   16,   11,       20,   -6,   24,       31,  -24,   35,       42,  -38,   45,
      53,  -50,   54,       64,  -61,   63,       74,  -71,   72,       84,  -80,   80,
      11,   20,   14,       20,   -1,   26,       31,  -20,   36,       42,  -35,   45,
      53,  -48,   55,       64,  -59,   63,       74,  -69,   72,       84,  -79,   80,
      13,   24,   17,       21,    3,   27,       32,  -16,   37,       43,  -32,   46,
      54,  -46,   55,       64,  -57,   64,       74,  -68,   72,       85,  -78,   80,
      15,   27,   19,       23,    7,   28,       33,  -13,   38,       43,  -29,   47,
      54,  -43,   55,       64,  -55,   64,       75,  -66,   72,       85,  -76,   80,
      16,   30,   22,       24,   11,   30,       33,   -9,   39,       44,  -26,   47,
      54,  -41,   56,       65,  -53,   64,       75,  -64,   72,       85,  -75,   81,
      18,   33,   24,       25,   15,   32,       34,   -5,   39,       44,  -22,   48,
      55,  -38,   56,       65,  -51,   65,       75,  -62,   73,       85,  -73,   81,
      20,   36,   27,       26,   20,   33,       35,    0,   41,       45,  -18,   49,
      55,  -34,   57,       65,  -48,   65,       75,  -60,   73,       85,  -71,   81,
      22,   39,   30,       28,   23,   35,       36,    4,   42,       46,  -14,   49,
      56,  -31,   58,       66,  -45,   66,       76,  -58,   73,       86,  -69,   82,
      24,   41,   32,       29,   27,   37,       37,    8,   43,       46,  -11,   50,
      56,  -28,   58,       66,  -42,   66,       76,  -55,   74,       86,  -67,   82,
      26,   44,   34,       30,   30,   39,       38,   12,   44,       47,   -7,   51,
      57,  -24,   59,       67,  -39,   67,       76,  -53,   74,       86,  -65,   82,
      28,   46,   37,       32,   34,   40,       39,   16,   46,       48,   -3,   52,
      58,  -20,   60,       67,  -36,   67,       77,  -50,   75,       87,  -62,   83,
      29,   49,   39,       34,   37,   42,       40,   20,   47,       49,    1,   53,
      58,  -17,   61,       68,  -33,   68,       77,  -47,   75,       87,  -60,   83,
      31,   51,   41,       35,   40,   44,       42,   23,   48,       50,    5,   54,
      59,  -13,   61,       68,  -29,   68,       78,  -44,   76,       87,  -57,   83,
      33,   53,   43,       37,   43,   46,       43,   27,   50,       51,    9,   55,
      60,  -10,   62,       69,  -26,   69,       78,  -41,   76,       88,  -54,   84,
      35,   56,   45,       38,   46,   48,       44,   31,   51,       52,   13,   57,
      60,   -5,   63,       69,  -22,   70,       79,  -37,   77,       88,  -51,   84,
      37,   58,   47,       40,   49,   49,       45,   34,   53,       53,   17,   58,
      61,   -2,   64,       70,  -19,   71,       79,  -34,   78,       88,  -48,   85,
      38,   60,   49,       41,   51,   51,       47,   37,   54,       54,   20,   59,
      62,    2,   65,       71,  -15,   72,       80,  -31,   78,       89,  -45,   85,
      40,   62,   51,       43,   54,   53,       48,   40,   56,       55,   24,   60,
      63,    5,   66,       71,  -12,   72,       80,  -27,   79,       89,  -42,   86,
      42,   64,   53,       44,   57,   54,       49,   44,   57,       56,   27,   62,
      64,    9,   67,       72,   -8,   73,       81,  -24,   80,       90,  -39,   87,
      44,   67,   55,       46,   59,   56,       51,   47,   59,       57,   31,   63,
      65,   13,   68,       73,   -4,   74,       81,  -20,   81,       90,  -36,   87,
      45,   69,   57,       48,   62,   58,       52,   50,   60,       58,   34,   64,
      66,   17,   69,       74,   -1,   75,       82,  -17,   81,       91,  -33,   88,
      47,   71,   58,       49,   64,   60,       53,   53,   62,       59,   37,   66,
      67,   20,   70,       74,    3,   76,       83,  -13,   82,       92,  -29,   89,
      49,   73,   60,       51,   67,   61,       55,   55,   63,       60,   41,   67,
      68,   23,   72,       75,    6,   77,       83,  -10,   83,       92,  -26,   89,
      50,   75,   62,       52,   69,   63,       56,   58,   65,       62,   44,   68,
      69,   27,   73,       76,   10,   78,       84,   -6,   84,       93,  -22,   90,
      52,   77,   64,       54,   71,   65,       58,   61,   67,       63,   47,   70,
      70,   31,   74,       77,   14,   79,       85,   -3,   85,       93,  -19,   91,
      54,   79,   65,       56,   74,   66,       59,   64,   68,       64,   50,   71,
      71,   34,   75,       78,   17,   80,       86,    1,   86,       94,  -16,   92,
       4,   -4,   -2,       17,  -25,   16,       29,  -36,   30,       41,  -47,   42,
      53,  -56,   52,       63,  -65,   61,       74,  -74,   70,       84,  -83,   79,
       4,   -2,   -1,       17,  -23,   17,       29,  -35,   30,       41,  -46,   42,
      53,  -56,   52,       63,  -65,   61,       74,  -74,   70,       84,  -83,   79,
       5,    0,    0,       17,  -20,   17,       29,  -34,   31,       41,  -45,   42,
      53,  -55,   52,       63,  -65,   61,       74,  -73,   70,       84,  -82,   79,
       6,    4,    1,       18,  -17,   18,       30,  -32,   31,       41,  -44,   42,
      53,  -54,   52,       63,  -64,   62,       74,  -73,   70,       84,  -82,   79,
       7,    9,    3,       18,  -14,   19,       30,  -29,   31,       41,  -42,   42,
      53,  -53,   53,       64,  -63,   62,       74,  -72,   70,       84,  -81,   79,
       8,   13,    5,       19,  -10,   20,       30,  -27,   32,       42,  -40,   43,
      53,  -52,   53,       64,  -62,   62,       74,  -71,   71,       84,  -81,   79,
       9,   17,    8,       20,   -6,   21,       31,  -24,   32,       42,  -38,   43,
      53,  -50,   53,       64,  -61,   62,       74,  -70,   71,       84,  -80,   79,
      11,   21,   10,       21,   -1,   22,       31,  -20,   33,       42,  -35,   43,
      53,  -48,   53,       64,  -59,   62,       74,  -69,   71,       85,  -79,   79,
      13,   24,   13,       22,    4,   23,       32,  -16,   34,       43,  -32,   44,
      54,  -46,   54,       64,  -57,   63,       74,  -68,   71,       85,  -77,   80,
      15,   27,   16,       23,    8,   25,       33,  -12,   35,       43,  -29,   45,
      54,  -43,   54,       64,  -55,   63,       75,  -66,   71,       85,  -76,   80,
      17,   30,   18,       24,   12,   26,       33,   -8,   36,       44,  -26,   45,
      54,  -40,   55,       65,  -53,   63,       75,  -64,   72,       85,  -75,   80,
      18,   33,   21,       25,   16,   28,       34,   -4,   37,       44,  -22,   46,
      55,  -38,   55,       65,  -51,   64,       75,  -62,   72,       85,  -73,   80,
      20,   36,   24,       26,   20,   30,       35,    0,   38,       45,  -18,   47,
      55,  -34,   56,       65,  -48,   64,       75,  -60,   72,       85,  -71,   81,
      22,   39,   26,       28,   24,   32,       36,    4,   39,       46,  -14,   48,
      56,  -31,   56,       66,  -45,   64,       76,  -57,   73,       86,  -69,   81,
      24,   41,   28,       29,   27,   33,       37,    8,   40,       46,  -10,   48,
      56,  -28,   57,       66,  -42,   65,       76,  -55,   73,       86,  -67,   81,
      26,   44,   31,       31,   30,   35,       38,   12,   42,       47,   -7,   49,
      57,  -24,   58,       67,  -39,   66,       76,  -52,   73,       86,  -65,   81,
      28,   46,   33,       32,   34,   37,       39,   16,   43,       48,   -2,   50,
      58,  -20,   58,       67,  -36,   66,       77,  -49,   74,       87,  -62,   82,
      29,   49,   36,       34,   37,   39,       40,   20,   45,       49,    1,   52,
      58,  -17,   59,       68,  -32,   67,       77,  -47,   74,       87,  -60,   82,
      31,   51,   38,       35,   40,   41,       42,   24,   46,       50,    5,   53,
      59,  -13,   60,       68,  -29,   67,       78,  -44,   75,       87,  -57,   83,
      33,   53,   40,       37,   43,   43,       43,   27,   48,       51,    9,   54,
      60,   -9,   61,       69,  -26,   68,       78,  -41,   76,       88,  -54,   83,
      35,   56,   42,       38,   46,   45,       44,   31,   49,       52,   13,   55,
      60,   -5,   62,       69,  -22,   69,       79,  -37,   76,       88,  -51,   84,
      37,   58,   44,       40,   49,   47,       45,   34,   51,       53,   17,   56,
      61,   -2,   63,       70,  -18,   70,       79,  -34,   77,       88,  -48,   84,
      38,   60,   46,       41,   52,   48,       47,   37,   52,       54,   20,   57,
      62,    2,   64,       71,  -15,   70,       80,  -31,   77,       89,  -45,   85,
      40,   62,   48,       43,   54,   50,       48,   41,   54,       55,   24,   59,
      63,    6,   65,       71,  -11,   71,       80,  -27,   78,       89,  -42,   85,
      42,   64,   50,       44,   57,   52,       49,   44,   55,       56,   27,   60,
      64,    9,   66,       72,   -8,   72,       81,  -24,   79,       90,  -39,   86,
      44,   67,   52,       46,   59,   54,       51,   47,   57,       57,   31,   61,
      65,   13,   67,       73,   -4,   73,       81,  -20,   80,       90,  -36,   87,
      45,   69,   54,       48,   62,   56,       52,   50,   59,       58,   34,   63,
      66,   17,   68,       74,    0,   74,       82,  -17,   80,       91,  -32,   87,
      47,   71,   56,       49,   64,   57,       53,   53,   60,       59,   38,   64,
      67,   20,   69,       74,    3,   75,       83,  -13,   81,       92,  -29,   88,
      49,   73,   58,       51,   67,   59,       55,   55,   62,       60,   41,   65,
      68,   24,   70,       75,    7,   76,       83,  -10,   82,       92,  -26,   89,
      50,   75,   60,       52,   69,   61,       56,   58,   63,       62,   44,   67,
      69,   27,   72,       76,   10,   77,       84,   -6,   83,       93,  -22,   89,
      52,   77,   62,       54,   71,   63,       58,   61,   65,       63,   47,   68,
      70,   31,   73,       77,   14,   78,       85,   -3,   84,       93,  -19,   90,
      54,   79,   63,       56,   74,   64,       59,   64,   67,       64,   50,   70,
      71,   34,   74,       78,   17,   79,       86,    1,   85,       94,  -16,   91,
       4,   -2,   -7,       17,  -23,   11,       29,  -35,   26,       41,  -46,   39,
      53,  -56,   50,       63,  -65,   60,       74,  -74,   69,       84,  -83,   78,
       4,    0,   -6,       17,  -21,   11,       29,  -34,   26,       41,  -45,   39,
      53,  -55,   50,       63,  -65,   60,       74,  -74,   69,       84,  -82,   78,
       5,    2,   -6,       17,  -19,   12,       30,  -33,   27,       41,  -44,   39,
      53,  -55,   50,       63,  -64,   60,       74,  -73,   69,       84,  -82,   78,
       6,    6,   -4,       18,  -16,   12,       30,  -31,   27,       41,  -43,   39,
      53,  -54,   50,       63,  -64,   60,       74,  -73,   69,       84,  -82,   78,
       7,   10,   -3,       18,  -12,   13,       30,  -29,   27,       42,  -41,   39,
      53,  -53,   50,       64,  -63,   60,       74,  -72,   69,       84,  -81,   78,
       8,   14,    0,       19,   -8,   14,       30,  -26,   28,       42,  -39,   40,
      53,  -51,   50,       64,  -62,   60,       74,  -71,   69,       84,  -80,   78,
      10,   18,    2,       20,   -4,   15,       31,  -23,   28,       42,  -37,   40,
      53,  -50,   51,       64,  -60,   60,       74,  -70,   69,       84,  -80,   78,
      12,   22,    5,       21,    0,   17,       31,  -19,   29,       42,  -34,   41,
      54,  -47,   51,       64,  -59,   61,       74,  -69,   69,       85,  -78,   78,
      13,   25,    7,       22,    4,   18,       32,  -15,   30,       43,  -31,   41,
      54,  -45,   51,       64,  -57,   61,       74,  -67,   70,       85,  -77,   78,
      15,   28,   10,       23,    8,   20,       33,  -12,   31,       43,  -28,   42,
      54,  -43,   52,       64,  -55,   61,       75,  -66,   70,       85,  -76,   79,
      17,   31,   12,       24,   12,   21,       33,   -8,   32,       44,  -25,   42,
      54,  -40,   52,       65,  -53,   61,       75,  -64,   70,       85,  -74,   79,
      18,   34,   15,       25,   16,   23,       34,   -4,   33,       44,  -22,   43,
      55,  -37,   53,       65,  -50,   62,       75,  -62,   70,       85,  -73,   79,
      20,   37,   18,       27,   20,   25,       35,    1,   34,       45,  -18,   44,
      55,  -34,   53,       65,  -47,   62,       75,  -60,   71,       85,  -71,   79,
      22,   39,   20,       28,   24,   27,       36,    5,   36,       46,  -14,   45,
      56,  -31,   54,       66,  -45,   63,       76,  -57,   71,       86,  -69,   80,
      24,   42,   23,       29,   27,   29,       37,    9,   37,       46,  -10,   46,
      56,  -27,   55,       66,  -42,   63,       76,  -55,   72,       86,  -67,   80,
      26,   44,   25,       31,   31,   31,       38,   12,   38,       47,   -6,   47,
      57,  -24,   55,       67,  -39,   64,       76,  -52,   72,       86,  -65,   80,
      28,   47,   28,       32,   34,   33,       39,   17,   40,       48,   -2,   48,
      58,  -20,   56,       67,  -35,   64,       77,  -49,   73,       87,  -62,   81,
      29,   49,   31,       34,   37,   35,       40,   20,   41,       49,    2,   49,
      58,  -16,   57,       68,  -32,   65,       77,  -46,   73,       87,  -59,   81,
      31,   51,   33,       35,   40,   37,       42,   24,   43,       50,    5,   50,
      59,  -13,   58,       68,  -29,   66,       78,  -43,   74,       87,  -57,   82,
      33,   54,   35,       37,   43,   39,       43,   27,   44,       51,    9,   51,
      60,   -9,   59,       69,  -26,   66,       78,  -40,   74,       88,  -54,   82,
      35,   56,   38,       38,   46,   41,       44,   31,   46,       52,   13,   52,
      60,   -5,   60,       69,  -22,   67,       79,  -37,   75,       88,  -51,   83,
      37,   58,   40,       40,   49,   43,       45,   34,   47,       53,   17,   54,
      61,   -1,   61,       70,  -18,   68,       79,  -34,   75,       88,  -48,   83,
      38,   60,   42,       41,   52,   45,       47,   38,   49,       54,   20,   55,
      62,    2,   62,       71,  -15,   69,       80,  -30,   76,       89,  -45,   84,
      40,   62,   44,       43,   54,   46,       48,   41,   51,       55,   24,   56,
      63,    6,   63,       71,  -11,   70,       80,  -27,   77,       89,  -42,   84,
      42,   65,   46,       44,   57,   48,       49,   44,   52,       56,   27,   58,
      64,    9,   64,       72,   -8,   71,       81,  -24,   78,       90,  -39,   85,
      44,   67,   48,       46,   60,   50,       51,   47,   54,       57,   31,   59,
      65,   13,   65,       73,   -4,   72,       81,  -20,   78,       90,  -36,   86,
      45,   69,   50,       48,   62,   52,       52,   50,   56,       58,   34,   60,
      66,   17,   66,       74,    0,   73,       82,  -17,   79,       91,  -32,   86,
      47,   71,   52,       49,   64,   54,       53,   53,   57,       59,   38,   62,
      67,   20,   67,       74,    3,   73,       83,  -13,   80,       92,  -29,   87,
      49,   73,   54,       51,   67,   56,       55,   56,   59,       61,   41,   63,
      68,   24,   69,       75,    7,   74,       83,  -10,   81,       92,  -26,   88,
      50,   75,   57,       53,   69,   58,       56,   59,   61,       62,   44,   65,
      69,   27,   70,       76,   11,   76,       84,   -6,   82,       93,  -22,   88,
      52,   77,   58,       54,   72,   60,       58,   61,   62,       63,   47,   66,
      70,   31,   71,       77,   14,   77,       85,   -3,   83,       93,  -19,   89,
      54,   79,   60,       56,   74,   62,       59,   64,   64,       64,   50,   68,
      71,   34,   72,       78,   17,   78,       86,    1,   84,       94,  -16,   90,
       4,    0,  -13,       17,  -21,    6,       29,  -34,   22,       41,  -45,   35,
      53,  -55,   47,       63,  -65,   58,       74,  -74,   67,       84,  -82,   76,
       5,    2,  -12,       17,  -19,    6,       30,  -33,   22,       41,  -44,   35,
      53,  -55,   47,       63,  -64,   58,       74,  -73,   67,       84,  -82,   76,
       5,    5,  -11,       18,  -17,    7,       30,  -32,   22,       41,  -43,   36,
      53,  -54,   47,       63,  -64,   58,       74,  -73,   67,       84,  -82,   76,
       6,    9,  -10,       18,  -14,    7,       30,  -30,   23,       41,  -42,   36,
      53,  -53,   48,       63,  -63,   58,       74,  -72,   67,       84,  -81,   76,
       7,   12,   -8,       18,  -11,    8,       30,  -28,   23,       42,  -41,   36,
      53,  -52,   48,       64,  -62,   58,       74,  -72,   67,       84,  -81,   77,
       9,   16,   -6,       19,   -7,    9,       31,  -25,   24,       42,  -39,   36,
      53,  -51,   48,       64,  -61,   58,       74,  -71,   67,       84,  -80,   77,
      10,   19,   -4,       20,   -3,   10,       31,  -22,   24,       42,  -37,   37,
      53,  -49,   48,       64,  -60,   58,       74,  -70,   68,       84,  -79,   77,
      12,   23,   -1,       21,    1,   12,       32,  -18,   25,       42,  -34,   37,
      54,  -47,   49,       64,  -58,   59,       74,  -68,   68,       85,  -78,   77,
      13,   26,    2,       22,    5,   13,       32,  -15,   26,       43,  -31,   38,
      54,  -45,   49,       64,  -56,   59,       74,  -67,   68,       85,  -77,   77,
      15,   29,    4,       23,    9,   15,       33,  -11,   27,       43,  -28,   38,
      54,  -42,   49,       64,  -54,   59,       75,  -65,   68,       85,  -76,   77,
      17,   31,    7,       24,   13,   16,       34,   -7,   28,       44,  -25,   39,
      55,  -40,   50,       65,  -52,   59,       75,  -64,   69,       85,  -74,   77,
      19,   34,   10,       25,   17,   18,       34,   -3,   29,       44,  -21,   40,
      55,  -37,   50,       65,  -50,   60,       75,  -62,   69,       85,  -73,   78,
      21,   37,   13,       27,   21,   20,       35,    1,   30,       45,  -17,   41,
      55,  -33,   51,       65,  -47,   60,       75,  -59,   69,       85,  -71,   78,
      22,   40,   15,       28,   24,   22,       36,    5,   32,       46,  -13,   42,
      56,  -30,   52,       66,  -44,   61,       76,  -57,   70,       86,  -69,   78,
      24,   42,   18,       29,   28,   24,       37,    9,   33,       46,  -10,   43,
      56,  -27,   52,       66,  -42,   61,       76,  -55,   70,       86,  -67,   79,
      26,   44,   20,       31,   31,   26,       38,   13,   34,       47,   -6,   44,
      57,  -24,   53,       67,  -39,   62,       76,  -52,   70,       86,  -64,   79,
      28,   47,   23,       32,   35,   28,       39,   17,   36,       48,   -2,   45,
      58,  -20,   54,       67,  -35,   63,       77,  -49,   71,       87,  -62,   79,
      30,   49,   26,       34,   38,   30,       41,   21,   38,       49,    2,   46,
      58,  -16,   55,       68,  -32,   63,       77,  -46,   71,       87,  -59,   80,
      31,   52,   28,       35,   41,   32,       42,   24,   39,       50,    6,   47,
      59,  -13,   56,       68,  -29,   64,       78,  -43,   72,       87,  -57,   80,
      33,   54,   30,       37,   44,   34,       43,   28,   41,       51,    9,   48,
      60,   -9,   56,       69,  -25,   65,       78,  -40,   73,       88,  -54,   81,
      35,   56,   33,       38,   47,   37,       44,   31,   42,       52,   14,   50,
      60,   -5,   58,       69,  -21,   65,       79,  -37,   73,       88,  -51,   81,
      37,   58,   35,       40,   49,   39,       45,   35,   44,       53,   17,   51,
      61,   -1,   58,       70,  -18,   66,       79,  -33,   74,       88,  -48,   82,
      38,   61,   38,       41,   52,   41,       47,   38,   46,       54,   21,   52,
      62,    2,   60,       71,  -15,   67,       80,  -30,   75,       89,  -45,   82,
      40,   63,   40,       43,   55,   43,       48,   41,   47,       55,   24,   53,
      63,    6,   61,       71,  -11,   68,       80,  -27,   75,       89,  -42,   83,
      42,   65,   42,       44,   57,   45,       49,   44,   49,       56,   28,   55,
      64,   10,   62,       72,   -8,   69,       81,  -24,   76,       90,  -39,   84,
      44,   67,   45,       46,   60,   47,       51,   47,   51,       57,   31,   56,
      65,   14,   63,       73,   -4,   70,       81,  -20,   77,       90,  -35,   84,
      45,   69,   47,       48,   62,   49,       52,   50,   53,       58,   35,   58,
      66,   17,   64,       74,    0,   71,       82,  -16,   78,       91,  -32,   85,
      47,   71,   49,       49,   65,   51,       54,   53,   54,       59,   38,   59,
      67,   20,   65,       74,    3,   72,       83,  -13,   78,       92,  -29,   86,
      49,   73,   51,       51,   67,   53,       55,   56,   56,       61,   41,   61,
      68,   24,   66,       75,    7,   73,       83,  -10,   79,       92,  -26,   86,
      50,   75,   53,       53,   69,   55,       56,   59,   58,       62,   44,   62,
      69,   28,   68,       76,   11,   74,       84,   -6,   80,       93,  -22,   87,
      52,   77,   55,       54,   72,   57,       58,   61,   60,       63,   47,   64,
      70,   31,   69,       77,   14,   75,       85,   -2,   81,       93,  -19,   88,
      54,   79,   57,       56,   74,   59,       59,   64,   61,       64,   50,   65,
      71,   34,   70,       78,   18,   76,       86,    1,   82,       94,  -15,   89,
       5,    3,  -18,       17,  -18,    1,       30,  -32,   17,       41,  -44,   32,
      53,  -55,   44,       63,  -64,   55,       74,  -73,   65,       84,  -82,   75,
       5,    5,  -18,       17,  -16,    1,       30,  -31,   18,       41,  -43,   32,
      53,  -54,   44,       63,  -64,   55,       74,  -73,   65,       84,  -82,   75,
       6,    8,  -17,       18,  -14,    1,       30,  -30,   18,       41,  -43,   32,
      53,  -54,   44,       63,  -63,   55,       74,  -72,   65,       84,  -81,   75,
       7,   11,  -15,       18,  -12,    2,       30,  -28,   18,       41,  -41,   32,
      53,  -53,   45,       64,  -63,   55,       74,  -72,   65,       84,  -81,   75,
       8,   15,  -14,       19,   -9,    3,       30,  -26,   19,       42,  -40,   32,
      53,  -51,   45,       64,  -62,   55,       74,  -71,   65,       84,  -80,   75,
       9,   18,  -11,       19,   -5,    4,       31,  -24,   19,       42,  -38,   33,
      53,  -50,   45,       64,  -61,   56,       74,  -70,   65,       84,  -80,   75,
      10,   21,   -9,       20,   -2,    5,       31,  -21,   20,       42,  -36,   33,
      53,  -48,   45,       64,  -59,   56,       74,  -69,   66,       84,  -79,   75,
      12,   24,   -6,       21,    3,    7,       32,  -17,   21,       43,  -33,   34,
      54,  -46,   46,       64,  -58,   56,       74,  -68,   66,       85,  -78,   75,
      14,   27,   -4,       22,    6,    8,       32,  -14,   22,       43,  -30,   34,
      54,  -44,   46,       64,  -56,   56,       74,  -67,   66,       85,  -77,   75,
      15,   29,   -1,       23,   10,   10,       33,  -10,   22,       43,  -27,   35,
      54,  -42,   46,       65,  -54,   57,       75,  -65,   66,       85,  -75,   76,
      17,   32,    2,       24,   14,   11,       34,   -6,   24,       44,  -24,   35,
      55,  -39,   47,       65,  -52,   57,       75,  -63,   67,       85,  -74,   76,
      19,   35,    4,       25,   18,   13,       34,   -2,   25,       44,  -20,   36,
      55,  -36,   47,       65,  -50,   57,       75,  -61,   67,       85,  -72,   76,
      21,   38,    7,       27,   22,   15,       35,    2,   26,       45,  -16,   37,
      55,  -33,   48,       65,  -47,   58,       75,  -59,   67,       85,  -70,   76,
      23,   40,   10,       28,   25,   17,       36,    6,   27,       46,  -13,   38,
      56,  -30,   49,       66,  -44,   58,       76,  -57,   68,       86,  -68,   77,
      24,   42,   13,       29,   28,   19,       37,   10,   29,       46,   -9,   39,
      56,  -26,   49,       66,  -41,   59,       76,  -54,   68,       86,  -66,   77,
      26,   45,   15,       31,   32,   21,       38,   13,   30,       47,   -5,   40,
      57,  -23,   50,       67,  -38,   60,       76,  -52,   68,       86,  -64,   77,
      28,   47,   18,       32,   35,   24,       39,   17,   32,       48,   -1,   41,
      58,  -19,   51,       67,  -35,   60,       77,  -49,   69,       87,  -61,   78,
      30,   50,   21,       34,   38,   26,       41,   21,   33,       49,    2,   42,
      58,  -16,   52,       68,  -32,   61,       77,  -46,   70,       87,  -59,   78,
      31,   52,   23,       35,   41,   28,       42,   25,   35,       50,    6,   44,
      59,  -12,   53,       68,  -28,   62,       78,  -43,   70,       87,  -56,   79,
      33,   54,   26,       37,   44,   30,       43,   28,   37,       51,   10,   45,
      60,   -9,   54,       69,  -25,   62,       78,  -40,   71,       88,  -54,   79,
      35,   57,   28,       38,   47,   32,       44,   32,   39,       52,   14,   46,
      61,   -4,   55,       69,  -21,   63,       79,  -36,   71,       88,  -51,   80,
      37,   59,   31,       40,   50,   34,       46,   35,   40,       53,   17,   48,
      61,   -1,   56,       70,  -18,   64,       79,  -33,   72,       89,  -48,   80,
      38,   61,   33,       42,   52,   36,       47,   38,   42,       54,   21,   49,
      62,    3,   57,       71,  -14,   65,       80,  -30,   73,       89,  -45,   81,
      40,   63,   35,       43,   55,   38,       48,   41,   44,       55,   24,   50,
      63,    6,   58,       71,  -11,   66,       80,  -27,   73,       89,  -42,   81,
      42,   65,   38,       45,   57,   41,       49,   44,   45,       56,   28,   52,
      64,   10,   59,       72,   -7,   67,       81,  -23,   74,       90,  -39,   82,
      44,   67,   40,       46,   60,   43,       51,   48,   47,       57,   32,   53,
      65,   14,   60,       73,   -3,   68,       81,  -20,   75,       90,  -35,   83,
      45,   69,   42,       48,   62,   45,       52,   50,   49,       58,   35,   55,
      66,   17,   61,       74,    0,   69,       82,  -16,   76,       91,  -32,   83,
      47,   71,   45,       49,   65,   47,       54,   53,   51,       59,   38,   56,
      67,   21,   63,       75,    4,   70,       83,  -13,   77,       92,  -29,   84,
      49,   73,   47,       51,   67,   49,       55,   56,   53,       61,   41,   58,
      68,   24,   64,       75,    7,   71,       83,   -9,   77,       92,  -26,   85,
      51,   76,   49,       53,   70,   51,       56,   59,   55,       62,   45,   59,
      69,   28,   65,       76,   11,   72,       84,   -6,   78,       93,  -22,   86,
      52,   77,   51,       54,   72,   53,       58,   62,   56,       63,   48,   61,
      70,   31,   67,       77,   14,   73,       85,   -2,   79,       93,  -19,   86,
      54,   79,   53,       56,   74,   55,       59,   64,   58,       64,   51,   62,
      71,   34,   68,       78,   18,   74,       86,    1,   80,       94,  -15,   87,
       5,    7,  -23,       18,  -15,   -4,       30,  -31,   13,       41,  -43,   28,
      53,  -54,   41,       63,  -63,   52,       74,  -73,   63,       84,  -82,   73,
       6,    9,  -23,       18,  -14,   -4,       30,  -30,   13,       41,  -42,   28,
      53,  -53,   41,       63,  -63,   52,       74,  -72,   63,       84,  -81,   73,
       6,   12,  -22,       18,  -12,   -4,       30,  -28,   13,       41,  -41,   28,
      53,  -53,   41,       63,  -63,   52,       74,  -72,   63,       84,  -81,   73,
       7,   14,  -20,       18,   -9,   -3,       30,  -27,   14,       42,  -40,   28,
      53,  -52,   41,       64,  -62,   53,       74,  -71,   63,       84,  -81,   73,
       8,   17,  -19,       19,   -7,   -2,       30,  -25,   14,       42,  -39,   28,
      53,  -51,   41,       64,  -61,   53,       74,  -71,   63,       84,  -80,   73,
      10,   20,  -17,       20,   -3,   -1,       31,  -22,   15,       42,  -37,   29,
      53,  -49,   42,       64,  -60,   53,       74,  -70,   63,       84,  -79,   73,
      11,   22,  -14,       20,    0,    0,       31,  -19,   15,       42,  -35,   29,
      53,  -48,   42,       64,  -59,   53,       74,  -69,   63,       84,  -79,   73,
      13,   25,  -12,       21,    4,    1,       32,  -16,   16,       43,  -32,   30,
      54,  -46,   42,       64,  -57,   53,       74,  -68,   63,       85,  -77,   73,
      14,   28,   -9,       22,    8,    3,       32,  -12,   17,       43,  -29,   30,
      54,  -43,   43,       64,  -55,   54,       74,  -66,   64,       85,  -76,   73,
      16,   31,   -6,       23,   11,    5,       33,   -9,   18,       43,  -26,   31,
      54,  -41,   43,       65,  -53,   54,       75,  -65,   64,       85,  -75,   74,
      17,   33,   -4,       24,   15,    6,       34,   -5,   19,       44,  -23,   32,
      55,  -38,   44,       65,  -51,   54,       75,  -63,   64,       85,  -74,   74,
      19,   36,   -1,       26,   19,    8,       35,   -1,   20,       45,  -20,   32,
      55,  -36,   44,       65,  -49,   55,       75,  -61,   65,       85,  -72,   74,
      21,   38,    2,       27,   22,   10,       36,    3,   22,       45,  -16,   33,
      56,  -32,   45,       66,  -46,   55,       75,  -58,   65,       85,  -70,   74,
      23,   41,    5,       28,   26,   12,       36,    7,   23,       46,  -12,   34,
      56,  -29,   45,       66,  -44,   56,       76,  -56,   65,       86,  -68,   75,
      24,   43,    7,       30,   29,   14,       37,   10,   24,       47,   -9,   35,
      57,  -26,   46,       66,  -41,   56,       76,  -54,   66,       86,  -66,   75,
      26,   45,   10,       31,   32,   16,       38,   14,   26,       47,   -5,   36,
      57,  -23,   47,       67,  -38,   57,       76,  -51,   66,       86,  -64,   75,
      28,   48,   13,       33,   36,   19,       40,   18,   28,       48,   -1,   37,
      58,  -19,   48,       67,  -34,   57,       77,  -48,   67,       87,  -61,   76,
      30,   50,   16,       34,   39,   21,       41,   22,   29,       49,    3,   39,
      58,  -15,   49,       68,  -31,   58,       77,  -45,   67,       87,  -59,   76,
      32,   52,   18,       35,   42,   23,       42,   25,   31,       50,    7,   40,
      59,  -12,   50,       68,  -28,   59,       78,  -43,   68,       87,  -56,   77,
      33,   55,   21,       37,   44,   25,       43,   28,   32,       51,   10,   41,
      60,   -8,   51,       69,  -25,   60,       78,  -40,   68,       88,  -53,   77,
      35,   57,   23,       39,   47,   28,       44,   32,   34,       52,   14,   43,
      61,   -4,   52,       70,  -21,   60,       79,  -36,   69,       88,  -50,   78,
      37,   59,   26,       40,   50,   30,       46,   35,   36,       53,   18,   44,
      61,   -1,   53,       70,  -17,   61,       79,  -33,   70,       89,  -47,   78,
      39,   61,   28,       42,   53,   32,       47,   38,   38,       54,   21,   45,
      62,    3,   54,       71,  -14,   62,       80,  -30,   70,       89,  -45,   79,
      40,   63,   31,       43,   55,   34,       48,   42,   40,       55,   25,   47,
      63,    7,   55,       71,  -10,   63,       80,  -26,   71,       89,  -41,   79,
      42,   65,   33,       45,   58,   36,       49,   45,   41,       56,   28,   48,
      64,   10,   56,       72,   -7,   64,       81,  -23,   72,       90,  -38,   80,
      44,   68,   36,       46,   60,   38,       51,   48,   43,       57,   32,   50,
      65,   14,   57,       73,   -3,   65,       82,  -19,   73,       91,  -35,   81,
      45,   70,   38,       48,   63,   41,       52,   51,   45,       58,   35,   51,
      66,   18,   59,       74,    0,   66,       82,  -16,   74,       91,  -32,   82,
      47,   72,   40,       49,   65,   43,       54,   53,   47,       59,   38,   53,
      67,   21,   60,       75,    4,   67,       83,  -13,   74,       92,  -29,   82,
      49,   74,   42,       51,   67,   45,       55,   56,   49,       61,   41,   54,
      68,   24,   61,       75,    7,   68,       84,   -9,   75,       92,  -25,   83,
      51,   76,   45,       53,   70,   47,       57,   59,   51,       62,   45,   56,
      69,   28,   62,       76,   11,   69,       84,   -5,   76,       93,  -22,   84,
      52,   78,   47,       54,   72,   49,       58,   62,   53,       63,   48,   58,
      70,   31,   64,       77,   15,   70,       85,   -2,   77,       93,  -18,   85,
      54,   80,   49,       56,   74,   51,       59,   64,   54,       64,   51,   59,
      71,   35,   65,       78,   18,   71,       86,    1,   78,       94,  -15,   85,
       6,   12,  -29,       18,  -11,  -10,       30,  -28,    7,       41,  -41,   23,
      53,  -53,   37,       63,  -63,   49,       74,  -72,   60,       84,  -81,   70,
       7,   14,  -28,       18,  -10,  -10,       30,  -27,    8,       41,  -41,   23,
      53,  -52,   37,       64,  -62,   49,       74,  -72,   60,       84,  -81,   70,
       7,   16,  -27,       18,   -9,   -9,       30,  -26,    8,       42,  -40,   23,
      53,  -52,   37,       64,  -62,   49,       74,  -71,   60,       84,  -81,   70,
       8,   18,  -26,       19,   -6,   -9,       30,  -25,    8,       42,  -39,   23,
      53,  -51,   37,       64,  -61,   49,       74,  -71,   60,       84,  -80,   70,
       9,   20,  -24,       19,   -4,   -8,       31,  -23,    9,       42,  -37,   24,
      53,  -50,   37,       64,  -60,   49,       74,  -70,   60,       84,  -80,   70,
      10,   22,  -22,       20,   -1,   -7,       31,  -20,    9,       42,  -35,   24,
      53,  -48,   38,       64,  -59,   49,       74,  -69,   60,       84,  -79,   70,
      11,   24,  -20,       21,    2,   -6,       31,  -18,   10,       42,  -33,   24,
      54,  -47,   38,       64,  -58,   50,       74,  -68,   60,       85,  -78,   71,
      13,   27,  -17,       22,    6,   -4,       32,  -14,   11,       43,  -31,   25,
      54,  -45,   38,       64,  -56,   50,       74,  -67,   61,       85,  -77,   71,
      15,   30,  -15,       23,    9,   -3,       33,  -11,   12,       43,  -28,   26,
      54,  -42,   39,       64,  -55,   50,       75,  -65,   61,       85,  -76,   71,
      16,   32,  -12,       24,   13,   -1,       33,   -7,   13,       44,  -25,   26,
      54,  -40,   39,       65,  -53,   50,       75,  -64,   61,       85,  -74,   71,
      18,   34,  -10,       25,   16,    1,       34,   -4,   14,       44,  -22,   27,
      55,  -38,   40,       65,  -51,   51,       75,  -62,   61,       85,  -73,   71,
      19,   37,   -7,       26,   20,    2,       35,    0,   15,       45,  -19,   28,
      55,  -35,   40,       65,  -48,   51,       75,  -60,   62,       85,  -71,   72,
      21,   39,   -4,       27,   24,    5,       36,    4,   16,       45,  -15,   29,
      56,  -31,   41,       66,  -45,   52,       75,  -58,   62,       86,  -69,   72,
      23,   42,   -1,       28,   27,    7,       37,    8,   18,       46,  -11,   30,
      56,  -28,   41,       66,  -43,   52,       76,  -56,   62,       86,  -68,   72,
      25,   44,    1,       30,   30,    9,       38,   11,   19,       47,   -8,   31,
      57,  -25,   42,       66,  -40,   53,       76,  -53,   63,       86,  -65,   73,
      26,   46,    4,       31,   33,   11,       39,   15,   21,       47,   -4,   32,
      57,  -22,   43,       67,  -37,   53,       76,  -51,   63,       86,  -63,   73,
      28,   49,    7,       33,   36,   13,       40,   19,   22,       48,    0,   33,
      58,  -18,   44,       67,  -34,   54,       77,  -48,   64,       87,  -61,   73,
      30,   51,   10,       34,   39,   15,       41,   22,   24,       49,    4,   34,
      58,  -15,   45,       68,  -31,   55,       77,  -45,   64,       87,  -58,   74,
      32,   53,   12,       36,   42,   18,       42,   26,   26,       50,    7,   35,
      59,  -11,   46,       68,  -27,   55,       78,  -42,   65,       87,  -56,   74,
      33,   55,   15,       37,   45,   20,       43,   29,   27,       51,   11,   37,
      60,   -8,   47,       69,  -24,   56,       78,  -39,   66,       88,  -53,   75,
      35,   57,   18,       39,   48,   22,       45,   33,   29,       52,   15,   38,
      61,   -4,   48,       70,  -20,   57,       79,  -36,   66,       88,  -50,   75,
      37,   59,   20,       40,   50,   24,       46,   36,   31,       53,   18,   40,
      61,    0,   49,       70,  -17,   58,       79,  -32,   67,       89,  -47,   76,
      39,   62,   23,       42,   53,   27,       47,   39,   33,       54,   22,   41,
      62,    4,   50,       71,  -13,   59,       80,  -29,   68,       89,  -44,   76,
      40,   64,   25,       43,   56,   29,       48,   42,   35,       55,   25,   42,
      63,    7,   51,       72,  -10,   60,       80,  -26,   68,       89,  -41,   77,
      42,   66,   28,       45,   58,   31,       50,   45,   37,       56,   29,   44,
      64,   11,   52,       72,   -7,   61,       81,  -23,   69,       90,  -38,   78,
      44,   68,   30,       46,   61,   33,       51,   48,   39,       57,   32,   46,
      65,   14,   54,       73,   -3,   62,       82,  -19,   70,       91,  -35,   78,
      46,   70,   33,       48,   63,   36,       52,   51,   41,       58,   36,   47,
      66,   18,   55,       74,    1,   63,       82,  -16,   71,       91,  -31,   79,
      47,   72,   35,       50,   65,   38,       54,   54,   42,       60,   39,   49,
      67,   21,   56,       75,    4,   64,       83,  -12,   72,       92,  -28,   80,
      49,   74,   37,       51,   68,   40,       55,   56,   44,       61,   42,   50,
      68,   25,   57,       75,    8,   65,       84,   -9,   73,       92,  -25,   81,
      51,   76,   40,       53,   70,   42,       57,   59,   46,       62,   45,   52,
      69,   28,   59,       76,   12,   66,       84,   -5,   74,       93,  -21,   81,
      52,   78,   42,       54,   72,   44,       58,   62,   48,       63,   48,   54,
      70,   32,   60,       77,   15,   67,       85,   -2,   75,       94,  -18,   82,
      54,   80,   44,       56,   74,   46,       59,   65,   50,       64,   51,   55,
      71,   35,   62,       78,   18,   68,       86,    2,   76,       94,  -15,   83,
       7,   17,  -33,       18,   -8,  -15,       30,  -26,    3,       42,  -40,   19,
      53,  -51,   33,       64,  -62,   45,       74,  -71,   57,       84,  -80,   68,
       7,   18,  -32,       19,   -7,  -15,       30,  -25,    3,       42,  -39,   19,
      53,  -51,   33,       64,  -61,   46,       74,  -71,   57,       84,  -80,   68,
       8,   19,  -32,       19,   -5,  -14,       30,  -24,    3,       42,  -38,   19,
      53,  -50,   33,       64,  -61,   46,       74,  -71,   57,       84,  -80,   68,
       9,   21,  -30,       19,   -3,  -14,       31,  -22,    3,       42,  -37,   19,
      53,  -49,   33,       64,  -60,   46,       74,  -70,   57,       84,  -79,   68,
      10,   22,  -29,       20,   -1,  -13,       31,  -20,    4,       42,  -36,   19,
      53,  -48,   33,       64,  -59,   46,       74,  -69,   57,       84,  -79,   68,
      11,   24,  -27,       20,    2,  -12,       31,  -18,    4,       42,  -34,   20,
      53,  -47,   34,       64,  -58,   46,       74,  -69,   57,       84,  -78,   68,
      12,   26,  -25,       21,    4,  -11,       32,  -16,    5,       43,  -32,   20,
      54,  -46,   34,       64,  -57,   46,       74,  -68,   57,       85,  -77,   68,
      14,   29,  -22,       22,    8,   -9,       32,  -12,    6,       43,  -29,   21,
      54,  -43,   34,       64,  -55,   46,       74,  -66,   58,       85,  -76,   68,
      15,   31,  -20,       23,   11,   -8,       33,   -9,    7,       43,  -27,   21,
      54,  -41,   35,       64,  -54,   47,       75,  -65,   58,       85,  -75,   68,
      17,   33,  -17,       24,   15,   -6,       33,   -6,    8,       44,  -24,   22,
      54,  -39,   35,       65,  -52,   47,       75,  -63,   58,       85,  -74,   69,
      18,   36,  -15,       25,   18,   -4,       34,   -3,    9,       44,  -21,   23,
      55,  -37,   36,       65,  -50,   47,       75,  -62,   58,       85,  -72,   69,
      20,   38,  -12,       26,   21,   -2,       35,    1,   10,       45,  -18,   23,
      55,  -34,   36,       65,  -48,   48,       75,  -60,   59,       85,  -71,   69,
      22,   40,   -9,       27,   25,    0,       36,    5,   12,       45,  -14,   24,
      56,  -31,   37,       66,  -45,   48,       76,  -57,   59,       86,  -69,   69,
      23,   42,   -6,       29,   28,    2,       37,    9,   13,       46,  -10,   25,
      56,  -28,   38,       66,  -42,   49,       76,  -55,   59,       86,  -67,   70,
      25,   45,   -4,       30,   31,    4,       38,   12,   14,       47,   -7,   26,
      57,  -24,   38,       66,  -39,   49,       76,  -53,   60,       86,  -65,   70,
      27,   47,   -1,       31,   34,    6,       39,   16,   16,       48,   -3,   27,
      57,  -21,   39,       67,  -36,   50,       76,  -50,   60,       86,  -63,   70,
      29,   49,    2,       33,   37,    8,       40,   20,   18,       48,    1,   29,
      58,  -17,   40,       67,  -33,   51,       77,  -47,   61,       87,  -60,   71,
      30,   51,    5,       34,   40,   10,       41,   23,   19,       49,    4,   30,
      59,  -14,   41,       68,  -30,   51,       77,  -44,   61,       87,  -58,   71,
      32,   53,    7,       36,   43,   13,       42,   26,   21,       50,    8,   31,
      59,  -10,   42,       68,  -27,   52,       78,  -42,   62,       87,  -55,   72,
      34,   56,   10,       37,   45,   15,       43,   30,   23,       51,   12,   33,
      60,   -7,   43,       69,  -24,   53,       78,  -39,   63,       88,  -53,   72,
      36,   58,   13,       39,   48,   17,       45,   33,   25,       52,   15,   34,
      61,   -3,   44,       70,  -20,   54,       79,  -35,   63,       88,  -49,   73,
      37,   60,   15,       40,   51,   20,       46,   36,   27,       53,   19,   35,
      62,    1,   45,       70,  -16,   55,       79,  -32,   64,       89,  -47,   73,
      39,   62,   18,       42,   54,   22,       47,   39,   28,       54,   22,   37,
      62,    4,   46,       71,  -13,   56,       80,  -29,   65,       89,  -44,   74,
      41,   64,   20,       43,   56,   24,       48,   42,   30,       55,   26,   38,
      63,    8,   47,       72,  -10,   57,       80,  -26,   66,       90,  -41,   75,
      42,   66,   23,       45,   58,   26,       50,   45,   32,       56,   29,   40,
      64,   11,   49,       72,   -6,   58,       81,  -22,   66,       90,  -38,   75,
      44,   68,   26,       47,   61,   29,       51,   49,   34,       57,   33,   42,
      65,   15,   50,       73,   -2,   59,       82,  -19,   67,       91,  -34,   76,
      46,   70,   28,       48,   63,   31,       52,   51,   36,       59,   36,   43,
      66,   18,   51,       74,    1,   60,       82,  -15,   68,       91,  -31,   77,
      47,   72,   30,       50,   66,   33,       54,   54,   38,       60,   39,   45,
      67,   22,   53,       75,    5,   61,       83,  -12,   69,       92,  -28,   77,
      49,   74,   33,       51,   68,   35,       55,   57,   40,       61,   42,   46,
      68,   25,   54,       75,    8,   62,       84,   -9,   70,       92,  -25,   78,
      51,   76,   35,       53,   70,   38,       57,   60,   42,       62,   46,   48,
      69,   29,   55,       76,   12,   63,       84,   -5,   71,       93,  -21,   79,
      52,   78,   38,       54,   73,   40,       58,   62,   44,       63,   48,   50,
      70,   32,   57,       77,   15,   64,       85,   -1,   72,       94,  -18,   80,
      54,   80,   40,       56,   75,   42,       59,   65,   46,       65,   51,   51,
      71,   35,   58,       78,   19,   65,       86,    2,   73,       94,  -14,   81,
       8,   21,  -37,       19,   -4,  -20,       30,  -23,   -2,       42,  -38,   14,
      53,  -50,   29,       64,  -61,   42,       74,  -70,   54,       84,  -80,   65,
       8,   21,  -37,       19,   -3,  -19,       30,  -22,   -2,       42,  -37,   14,
      53,  -50,   29,       64,  -60,   42,       74,  -70,   54,       84,  -80,   65,
       9,   22,  -36,       19,   -2,  -19,       31,  -22,   -2,       42,  -36,   14,
      53,  -49,   29,       64,  -60,   42,       74,  -70,   54,       84,  -79,   65,
      10,   24,  -34,       20,    0,  -18,       31,  -20,   -1,       42,  -35,   15,
      53,  -48,   29,       64,  -59,   42,       74,  -69,   54,       84,  -79,   65,
      10,   25,  -33,       20,    2,  -18,       31,  -18,   -1,       42,  -34,   15,
      53,  -47,   29,       64,  -58,   42,       74,  -69,   54,       84,  -78,   65,
      12,   27,  -31,       21,    4,  -17,       31,  -16,    0,       42,  -32,   15,
      54,  -46,   30,       64,  -57,   42,       74,  -68,   54,       85,  -78,   65,
      13,   29,  -29,       21,    7,  -15,       32,  -14,    0,       43,  -30,   16,
      54,  -44,   30,       64,  -56,   43,       74,  -67,   54,       85,  -77,   65,
      14,   31,  -27,       22,   10,  -14,       32,  -11,    1,       43,  -28,   16,
      54,  -42,   30,       64,  -54,   43,       75,  -65,   54,       85,  -76,   65,
      16,   33,  -24,       23,   13,  -13,       33,   -8,    2,       43,  -25,   17,
      54,  -40,   31,       65,  -53,   43,       75,  -64,   55,       85,  -75,   66,
      17,   35,  -22,       24,   16,  -11,       34,   -4,    3,       44,  -22,   17,
      55,  -38,   31,       65,  -51,   44,       75,  -62,   55,       85,  -73,   66,
      19,   37,  -19,       25,   19,   -9,       34,   -1,    4,       44,  -19,   18,
      55,  -35,   32,       65,  -49,   44,       75,  -61,   55,       85,  -72,   66,
      20,   39,  -17,       26,   22,   -7,       35,    2,    5,       45,  -16,   19,
      55,  -33,   32,       65,  -47,   44,       75,  -59,   56,       85,  -70,   66,
      22,   41,  -14,       28,   26,   -5,       36,    6,    7,       46,  -13,   20,
      56,  -30,   33,       66,  -44,   45,       76,  -57,   56,       86,  -68,   67,
      24,   43,  -11,       29,   29,   -3,       37,   10,    8,       46,   -9,   21,
      56,  -27,   34,       66,  -41,   45,       76,  -54,   56,       86,  -66,   67,
      25,   46,   -9,       30,   32,   -1,       38,   13,   10,       47,   -6,   22,
      57,  -23,   34,       67,  -39,   46,       76,  -52,   57,       86,  -64,   67,
      27,   48,   -6,       32,   35,    1,       39,   17,   11,       48,   -2,   23,
      57,  -20,   35,       67,  -36,   47,       77,  -49,   57,       86,  -62,   68,
      29,   50,   -3,       33,   38,    3,       40,   21,   13,       49,    2,   24,
      58,  -17,   36,       67,  -32,   47,       77,  -47,   58,       87,  -60,   68,
      30,   52,    0,       35,   41,    6,       41,   24,   15,       49,    5,   26,
      59,  -13,   37,       68,  -29,   48,       77,  -44,   58,       87,  -57,   69,
      32,   54,    2,       36,   43,    8,       42,   27,   16,       50,    9,   27,
      59,  -10,   38,       68,  -26,   49,       78,  -41,   59,       87,  -55,   69,
      34,   56,    5,       37,   46,   10,       43,   30,   18,       51,   12,   28,
      60,   -6,   39,       69,  -23,   50,       78,  -38,   60,       88,  -52,   70,
      36,   58,    8,       39,   49,   13,       45,   34,   20,       52,   16,   30,
      61,   -2,   40,       70,  -19,   50,       79,  -35,   60,       88,  -49,   70,
      37,   60,   11,       41,   52,   15,       46,   37,   22,       53,   20,   31,
      62,    1,   41,       70,  -16,   51,       79,  -31,   61,       89,  -46,   71,
      39,   62,   13,       42,   54,   17,       47,   40,   24,       54,   23,   33,
      62,    5,   43,       71,  -12,   52,       80,  -28,   62,       89,  -43,   71,
      41,   64,   16,       44,   56,   19,       49,   43,   26,       55,   26,   34,
      63,    8,   44,       72,   -9,   53,       80,  -25,   63,       90,  -40,   72,
      42,   66,   18,       45,   59,   22,       50,   46,   28,       56,   30,   36,
      64,   12,   45,       72,   -6,   54,       81,  -22,   63,       90,  -37,   73,
      44,   69,   21,       47,   61,   24,       51,   49,   30,       57,   33,   37,
      65,   15,   46,       73,   -2,   55,       82,  -18,   64,       91,  -34,   73,
      46,   71,   23,       48,   64,   26,       53,   52,   32,       59,   36,   39,
      66,   19,   48,       74,    2,   56,       82,  -15,   65,       91,  -31,   74,
      47,   73,   26,       50,   66,   29,       54,   55,   34,       60,   39,   41,
      67,   22,   49,       75,    5,   57,       83,  -11,   66,       92,  -28,   75,
      49,   74,   28,       51,   68,   31,       55,   57,   36,       61,   43,   42,
      68,   25,   50,       76,    8,   59,       84,   -8,   67,       92,  -24,   76,
      51,   77,   31,       53,   71,   33,       57,   60,   38,       62,   46,   44,
      69,   29,   52,       76,   12,   60,       84,   -4,   68,       93,  -21,   76,
      53,   79,   33,       55,   73,   36,       58,   63,   40,       63,   49,   46,
      70,   32,   53,       77,   16,   61,       85,   -1,   69,       94,  -17,   77,
      54,   80,   35,       56,   75,   38,       60,   65,   42,       65,   52,   48,
      71,   36,   55,       78,   19,   62,       86,    2,   70,       94,  -14,   78,
       9,   24,  -41,       19,   -1,  -24,       31,  -21,   -7,       42,  -36,   10,
      53,  -49,   25,       64,  -59,   38,       74,  -69,   50,       84,  -79,   62,
       9,   25,  -41,       19,    0,  -24,       31,  -20,   -7,       42,  -35,   10,
      53,  -48,   25,       64,  -59,   38,       74,  -69,   50,       84,  -79,   62,
      10,   25,  -40,       20,    1,  -24,       31,  -19,   -6,       42,  -34,   10,
      53,  -48,   25,       64,  -59,   38,       74,  -69,   50,       84,  -79,   62,
      10,   26,  -39,       20,    3,  -23,       31,  -17,   -6,       42,  -33,   10,
      53,  -47,   25,       64,  -58,   38,       74,  -68,   50,       84,  -78,   62,
      11,   28,  -37,       21,    5,  -22,       31,  -16,   -6,       42,  -32,   10,
      53,  -46,   25,       64,  -57,   39,       74,  -68,   51,       85,  -78,   62,
      12,   29,  -35,       21,    7,  -21,       32,  -14,   -5,       43,  -30,   11,
      54,  -44,   26,       64,  -56,   39,       74,  -67,   51,       85,  -77,   62,
      13,   31,  -34,       22,    9,  -20,       32,  -11,   -4,       43,  -28,   11,
      54,  -43,   26,       64,  -55,   39,       74,  -66,   51,       85,  -76,   62,
      15,   33,  -31,       23,   12,  -19,       33,   -8,   -3,       43,  -26,   12,
      54,  -41,   26,       64,  -53,   39,       75,  -65,   51,       85,  -75,   62,
      16,   34,  -29,       24,   15,  -17,       33,   -6,   -3,       44,  -24,   12,
      54,  -39,   27,       65,  -52,   39,       75,  -63,   51,       85,  -74,   63,
      18,   36,  -27,       25,   18,  -16,       34,   -3,   -2,       44,  -21,   13,
      55,  -37,   27,       65,  -50,   40,       75,  -62,   52,       85,  -73,   63,
      19,   38,  -24,       26,   21,  -14,       35,    1,    0,       45,  -18,   14,
      55,  -34,   28,       65,  -48,   40,       75,  -60,   52,       85,  -71,   63,
      21,   40,  -22,       27,   24,  -12,       35,    4,    1,       45,  -15,   15,
      55,  -32,   28,       65,  -46,   41,       75,  -58,   52,       85,  -70,   63,
      22,   43,  -19,       28,   27,  -10,       36,    8,    2,       46,  -11,   16,
      56,  -29,   29,       66,  -43,   41,       76,  -56,   53,       86,  -68,   64,
      24,   45,  -16,       29,   30,   -8,       37,   11,    4,       46,   -8,   16,
      56,  -26,   30,       66,  -40,   42,       76,  -54,   53,       86,  -66,   64,
      26,   47,  -13,       31,   33,   -6,       38,   14,    5,       47,   -5,   18,
      57,  -22,   30,       67,  -38,   42,       76,  -51,   53,       86,  -64,   64,
      27,   49,  -11,       32,   36,   -4,       39,   18,    7,       48,   -1,   19,
      57,  -19,   31,       67,  -35,   43,       77,  -49,   54,       86,  -62,   65,
      29,   51,   -8,       33,   39,   -1,       40,   22,    8,       49,    3,   20,
      58,  -16,   32,       68,  -32,   44,       77,  -46,   55,       87,  -59,   65,
      31,   53,   -5,       35,   42,    1,       41,   25,   10,       49,    6,   21,
      59,  -12,   33,       68,  -29,   44,       77,  -43,   55,       87,  -57,   66,
      32,   55,   -2,       36,   44,    3,       42,   28,   12,       50,   10,   23,
      59,   -9,   34,       69,  -25,   45,       78,  -40,   56,       87,  -54,   66,
      34,   57,    0,       38,   47,    5,       44,   31,   14,       51,   13,   24,
      60,   -5,   35,       69,  -22,   46,       78,  -37,   56,       88,  -51,   67,
      36,   59,    3,       39,   50,    8,       45,   35,   16,       52,   17,   25,
      61,   -2,   36,       70,  -18,   47,       79,  -34,   57,       88,  -48,   67,
      38,   61,    6,       41,   52,   10,       46,   38,   17,       53,   20,   27,
      62,    2,   37,       70,  -15,   48,       79,  -31,   58,       89,  -46,   68,
      39,   63,    8,       42,   55,   12,       47,   41,   19,       54,   24,   28,
      62,    5,   39,       71,  -12,   49,       80,  -28,   59,       89,  -43,   68,
      41,   65,   11,       44,   57,   15,       49,   44,   21,       55,   27,   30,
      63,    9,   40,       72,   -8,   50,       80,  -25,   59,       90,  -40,   69,
      43,   67,   13,       45,   59,   17,       50,   46,   23,       56,   30,   31,
      64,   12,   41,       72,   -5,   51,       81,  -21,   60,       90,  -37,   70,
      44,   69,   16,       47,   62,   19,       51,   50,   25,       58,   34,   33,
      65,   16,   42,       73,   -1,   52,       82,  -18,   61,       91,  -33,   70,
      46,   71,   19,       48,   64,   22,       53,   52,   27,       59,   37,   35,
      66,   19,   44,       74,    2,   53,       82,  -14,   62,       91,  -30,   71,
      48,   73,   21,       50,   66,   24,       54,   55,   29,       60,   40,   37,
      67,   23,   45,       75,    6,   54,       83,  -11,   63,       92,  -27,   72,
      49,   75,   23,       51,   69,   26,       55,   58,   31,       61,   43,   38,
      68,   26,   46,       76,    9,   55,       84,   -8,   64,       92,  -24,   73,
      51,   77,   26,       53,   71,   29,       57,   61,   34,       62,   46,   40,
      69,   30,   48,       77,   13,   56,       85,   -4,   65,       93,  -20,   74,
      53,   79,   29,       55,   73,   31,       58,   63,   36,       64,   49,   42,
      70,   33,   49,       77,   16,   57,       85,   -1,   66,       94,  -17,   74,
      54,   81,   31,       56,   75,   33,       60,   66,   38,       65,   52,   43,
      71,   36,   51,       78,   19,   59,       86,    3,   67,       94,  -14,   75,
      10,   27,  -45,       20,    3,  -29,       31,  -18,  -11,       42,  -34,    5,
      53,  -47,   21,       64,  -58,   34,       74,  -68,   47,       84,  -78,   59,
      10,   28,  -44,       20,    4,  -28,       31,  -17,  -11,       42,  -33,    5,
      53,  -46,   21,       64,  -58,   34,       74,  -68,   47,       84,  -78,   59,
      11,   28,  -44,       20,    5,  -28,       31,  -16,  -11,       42,  -32,    5,
      53,  -46,   21,       64,  -57,   34,       74,  -68,   47,       84,  -78,   59,
      11,   29,  -42,       21,    6,  -27,       31,  -15,  -11,       42,  -31,    6,
      53,  -45,   21,       64,  -57,   35,       74,  -67,   47,       85,  -77,   59,
      12,   30,  -41,       21,    8,  -27,       32,  -13,  -10,       43,  -30,    6,
      54,  -44,   21,       64,  -56,   35,       74,  -67,   47,       85,  -77,   59,
      13,   32,  -40,       22,   10,  -26,       32,  -11,  -10,       43,  -28,    6,
      54,  -43,   21,       64,  -55,   35,       74,  -66,   47,       85,  -76,   59,
      14,   33,  -38,       22,   12,  -25,       32,   -9,   -9,       43,  -27,    7,
      54,  -41,   22,       64,  -54,   35,       74,  -65,   47,       85,  -75,   59,
      16,   35,  -35,       23,   15,  -23,       33,   -6,   -8,       43,  -24,    7,
      54,  -39,   22,       65,  -52,   35,       75,  -64,   48,       85,  -74,   59,
      17,   36,  -33,       24,   17,  -22,       34,   -4,   -7,       44,  -22,    8,
      55,  -38,   22,       65,  -51,   36,       75,  -62,   48,       85,  -73,   59,
      18,   38,  -31,       25,   20,  -20,       34,   -1,   -6,       44,  -19,    8,
      55,  -35,   23,       65,  -49,   36,       75,  -61,   48,       85,  -72,   60,
      20,   40,  -29,       26,   23,  -19,       35,    2,   -5,       45,  -16,    9,
      55,  -33,   23,       65,  -47,   36,       75,  -59,   48,       85,  -70,   60,
      21,   42,  -26,       27,   26,  -17,       36,    6,   -4,       45,  -13,   10,
      56,  -30,   24,       66,  -45,   37,       75,  -57,   49,       86,  -69,   60,
      23,   44,  -23,       28,   29,  -15,       37,    9,   -2,       46,  -10,   11,
      56,  -27,   25,       66,  -42,   37,       76,  -55,   49,       86,  -67,   61,
      24,   46,  -21,       30,   32,  -13,       37,   12,   -1,       47,   -7,   12,
      57,  -24,   25,       66,  -39,   38,       76,  -53,   50,       86,  -65,   61,
      26,   48,  -18,       31,   34,  -11,       38,   16,    0,       47,   -3,   13,
      57,  -21,   26,       67,  -37,   38,       76,  -50,   50,       86,  -63,   61,
      28,   50,  -16,       32,   37,   -9,       39,   19,    2,       48,    0,   14,
      58,  -18,   27,       67,  -34,   39,       77,  -48,   51,       87,  -61,   62,
      29,   52,  -13,       34,   40,   -6,       40,   23,    4,       49,    4,   16,
      58,  -15,   28,       68,  -31,   40,       77,  -45,   51,       87,  -58,   62,
      31,   54,  -10,       35,   43,   -4,       42,   26,    5,       50,    7,   17,
      59,  -11,   29,       68,  -28,   41,       78,  -42,   52,       87,  -56,   63,
      33,   56,   -7,       36,   45,   -2,       43,   29,    7,       51,   11,   18,
      60,   -8,   30,       69,  -25,   41,       78,  -40,   52,       88,  -53,   63,
      34,   58,   -5,       38,   48,    0,       44,   32,    9,       51,   14,   19,
      60,   -5,   31,       69,  -21,   42,       78,  -37,   53,       88,  -51,   64,
      36,   60,   -2,       39,   50,    3,       45,   35,   11,       52,   18,   21,
      61,   -1,   32,       70,  -18,   43,       79,  -33,   54,       88,  -48,   64,
      38,   62,    1,       41,   53,    5,       46,   38,   13,       53,   21,   23,
      62,    3,   33,       70,  -14,   44,       79,  -30,   54,       89,  -45,   65,
      39,   64,    3,       42,   55,    8,       48,   41,   15,       54,   24,   24,
      63,    6,   34,       71,  -11,   45,       80,  -27,   55,       89,  -42,   65,
      41,   66,    6,       44,   58,   10,       49,   44,   17,       55,   28,   26,
      63,    9,   36,       72,   -8,   46,       81,  -24,   56,       90,  -39,   66,
      43,   67,    9,       45,   60,   12,       50,   47,   19,       57,   31,   27,
      64,   13,   37,       73,   -4,   47,       81,  -21,   57,       90,  -36,   67,
      45,   70,   11,       47,   62,   15,       52,   50,   21,       58,   34,   29,
      65,   17,   38,       73,   -1,   48,       82,  -17,   58,       91,  -33,   67,
      46,   71,   14,       49,   65,   17,       53,   53,   23,       59,   37,   31,
      66,   20,   40,       74,    3,   49,       82,  -14,   59,       91,  -30,   68,
      48,   73,   16,       50,   67,   19,       54,   56,   25,       60,   41,   32,
      67,   23,   41,       75,    6,   50,       83,  -10,   59,       92,  -27,   69,
      49,   75,   19,       52,   69,   22,       56,   58,   27,       61,   44,   34,
      68,   26,   42,       76,    9,   51,       84,   -7,   60,       92,  -23,   70,
      51,   77,   22,       53,   72,   24,       57,   61,   29,       62,   47,   36,
      69,   30,   44,       77,   13,   53,       85,   -3,   62,       93,  -20,   71,
      53,   79,   24,       55,   74,   26,       58,   64,   31,       64,   50,   38,
      70,   33,   46,       77,   16,   54,       85,    0,   63,       94,  -17,   71,
      54,   81,   26,       56,   76,   29,       60,   66,   33,       65,   53,   39,
      71,   36,   47,       78,   20,   55,       86,    3,   64,       94,  -13,   72,
      11,   31,  -49,       20,    7,  -34,       31,  -14,  -17,       42,  -31,    0,
      53,  -45,   16,       64,  -57,   30,       74,  -67,   43,       84,  -77,   55,
      11,   31,  -48,       21,    8,  -33,       31,  -13,  -16,       42,  -30,    0,
      54,  -44,   16,       64,  -56,   30,       74,  -67,   43,       85,  -77,   55,
      12,   32,  -48,       21,    8,  -33,       32,  -13,  -16,       42,  -30,    0,
      54,  -44,   16,       64,  -56,   30,       74,  -67,   43,       85,  -77,   55,
      12,   32,  -47,       21,   10,  -32,       32,  -11,  -16,       43,  -29,    1,
      54,  -43,   16,       64,  -55,   30,       74,  -66,   43,       85,  -76,   55,
      13,   33,  -45,       22,   11,  -32,       32,  -10,  -15,       43,  -27,    1,
      54,  -42,   16,       64,  -54,   30,       74,  -65,   43,       85,  -76,   55,
      14,   34,  -44,       22,   13,  -31,       32,   -8,  -15,       43,  -26,    1,
      54,  -41,   17,       64,  -53,   30,       74,  -65,   43,       85,  -75,   55,
      15,   36,  -42,       23,   15,  -30,       33,   -6,  -14,       43,  -24,    2,
      54,  -40,   17,       64,  -52,   31,       75,  -64,   43,       85,  -74,   55,
      16,   37,  -40,       24,   18,  -28,       33,   -4,  -13,       44,  -22,    2,
      54,  -38,   17,       65,  -51,   31,       75,  -62,   44,       85,  -73,   56,
      18,   38,  -38,       24,   20,  -27,       34,   -1,  -12,       44,  -20,    3,
      55,  -36,   18,       65,  -49,   31,       75,  -61,   44,       85,  -72,   56,
      19,   40,  -36,       25,   22,  -25,       34,    2,  -11,       44,  -17,    3,
      55,  -34,   18,       65,  -47,   32,       75,  -60,   44,       85,  -71,   56,
      20,   42,  -34,       26,   25,  -24,       35,    5,  -10,       45,  -14,    4,
      55,  -31,   19,       65,  -45,   32,       75,  -58,   44,       85,  -69,   56,
      22,   43,  -31,       27,   28,  -22,       36,    8,   -9,       45,  -12,    5,
      56,  -29,   19,       66,  -43,   32,       76,  -56,   45,       86,  -68,   56,
      23,   45,  -28,       29,   31,  -20,       37,   11,   -8,       46,   -8,    6,
      56,  -26,   20,       66,  -41,   33,       76,  -54,   45,       86,  -66,   57,
      25,   47,  -26,       30,   33,  -18,       38,   14,   -6,       47,   -5,    7,
      57,  -23,   21,       66,  -38,   33,       76,  -52,   46,       86,  -64,   57,
      26,   49,  -23,       31,   36,  -16,       39,   17,   -5,       47,   -2,    8,
      57,  -20,   21,       67,  -36,   34,       76,  -49,   46,       86,  -62,   58,
      28,   51,  -21,       32,   38,  -14,       40,   20,   -3,       48,    1,    9,
      58,  -17,   22,       67,  -33,   35,       77,  -47,   46,       87,  -60,   58,
      30,   53,  -18,       34,   41,  -11,       41,   24,   -1,       49,    5,   11,
      58,  -13,   23,       68,  -30,   35,       77,  -44,   47,       87,  -57,   58,
      31,   55,  -15,       35,   44,   -9,       42,   27,    0,       50,    8,   12,
      59,  -10,   24,       68,  -27,   36,       78,  -41,   48,       87,  -55,   59,
      33,   57,  -13,       37,   46,   -7,       43,   30,    2,       51,   12,   13,
      60,   -7,   25,       69,  -24,   37,       78,  -39,   48,       88,  -53,   59,
      35,   58,  -10,       38,   49,   -5,       44,   33,    4,       52,   15,   14,
      60,   -4,   26,       69,  -20,   38,       78,  -36,   49,       88,  -50,   60,
      37,   61,   -7,       40,   51,   -2,       45,   36,    6,       53,   19,   16,
      61,    0,   28,       70,  -17,   39,       79,  -32,   50,       88,  -47,   61,
      38,   62,   -4,       41,   54,    0,       47,   39,    8,       54,   22,   18,
      62,    4,   29,       71,  -14,   40,       80,  -29,   50,       89,  -44,   61,
      40,   64,   -2,       43,   56,    2,       48,   42,   10,       55,   25,   19,
      63,    7,   30,       71,  -10,   41,       80,  -26,   51,       89,  -41,   62,
      41,   66,    1,       44,   58,    5,       49,   45,   12,       56,   28,   21,
      64,   10,   31,       72,   -7,   42,       81,  -23,   52,       90,  -39,   62,
      43,   68,    3,       46,   61,    7,       50,   48,   14,       57,   32,   22,
      64,   14,   32,       73,   -4,   43,       81,  -20,   53,       90,  -36,   63,
      45,   70,    6,       47,   63,   10,       52,   51,   16,       58,   35,   24,
      65,   17,   34,       73,    0,   44,       82,  -16,   54,       91,  -32,   64,
      46,   72,    9,       49,   65,   12,       53,   54,   18,       59,   38,   26,
      66,   21,   35,       74,    3,   45,       83,  -13,   55,       91,  -29,   65,
      48,   74,   11,       50,   68,   14,       54,   56,   20,       60,   41,   27,
      67,   24,   37,       75,    7,   46,       83,  -10,   56,       92,  -26,   65,
      50,   76,   14,       52,   70,   16,       56,   59,   22,       61,   44,   29,
      68,   27,   38,       76,   10,   47,       84,   -7,   57,       92,  -23,   66,
      51,   78,   16,       53,   72,   19,       57,   62,   24,       63,   47,   31,
      69,   31,   40,       77,   14,   48,       85,   -3,   58,       93,  -19,   67,
      53,   80,   19,       55,   74,   21,       59,   64,   26,       64,   50,   33,
      70,   34,   41,       78,   17,   50,       85,    0,   59,       94,  -16,   68,
      55,   82,   21,       56,   76,   24,       60,   67,   28,       65,   53,   35,
      71,   37,   42,       78,   20,   51,       86,    4,   60,       94,  -13,   69,
      12,   34,  -52,       21,   11,  -38,       32,  -11,  -21,       43,  -28,   -4,
      54,  -43,   12,       64,  -55,   26,       74,  -66,   39,       85,  -76,   51,
      13,   34,  -52,       21,   11,  -38,       32,  -10,  -21,       43,  -28,   -4,
      54,  -42,   12,       64,  -55,   26,       74,  -66,   39,       85,  -76,   52,
      13,   34,  -51,       21,   12,  -37,       32,  -10,  -21,       43,  -27,   -4,
      54,  -42,   12,       64,  -54,   26,       74,  -65,   39,       85,  -76,   52,
      13,   35,  -50,       22,   13,  -37,       32,   -9,  -20,       43,  -26,   -4,
      54,  -41,   12,       64,  -54,   26,       74,  -65,   39,       85,  -75,   52,
      14,   36,  -49,       22,   14,  -36,       32,   -7,  -20,       43,  -25,   -4,
      54,  -40,   12,       64,  -53,   26,       74,  -64,   39,       85,  -75,   52,
      15,   37,  -48,       23,   16,  -35,       33,   -6,  -19,       43,  -24,   -3,
      54,  -39,   12,       64,  -52,   26,       75,  -63,   39,       85,  -74,   52,
      16,   38,  -46,       23,   18,  -34,       33,   -4,  -19,       44,  -22,   -3,
      54,  -38,   13,       65,  -51,   27,       75,  -62,   40,       85,  -73,   52,
      17,   39,  -44,       24,   20,  -33,       34,   -1,  -18,       44,  -20,   -2,
      55,  -36,   13,       65,  -49,   27,       75,  -61,   40,       85,  -72,   52,
      18,   40,  -42,       25,   22,  -31,       34,    1,  -17,       44,  -18,   -2,
      55,  -34,   13,       65,  -48,   27,       75,  -60,   40,       85,  -71,   52,
      20,   42,  -40,       26,   25,  -30,       35,    4,  -16,       45,  -15,   -1,
      55,  -32,   14,       65,  -46,   28,       75,  -58,   40,       85,  -70,   53,
      21,   43,  -38,       27,   27,  -28,       35,    7,  -15,       45,  -13,    0,
      55,  -30,   14,       66,  -44,   28,       75,  -57,   41,       85,  -68,   53,
      22,   45,  -35,       28,   29,  -26,       36,    9,  -14,       46,  -10,    1,
      56,  -27,   15,       66,  -42,   28,       76,  -55,   41,       86,  -67,   53,
      24,   47,  -33,       29,   32,  -24,       37,   13,  -12,       46,   -7,    2,
      56,  -24,   16,       66,  -39,   29,       76,  -53,   41,       86,  -65,   53,
      25,   48,  -30,       30,   35,  -22,       38,   16,  -11,       47,   -4,    3,
      57,  -22,   16,       67,  -37,   29,       76,  -51,   42,       86,  -63,   54,
      27,   50,  -28,       32,   37,  -20,       39,   19,   -9,       48,    0,    4,
      57,  -19,   17,       67,  -34,   30,       77,  -48,   42,       86,  -61,   54,
      28,   52,  -25,       33,   40,  -18,       40,   22,   -8,       48,    3,    5,
      58,  -16,   18,       67,  -32,   31,       77,  -46,   43,       87,  -59,   55,
      30,   54,  -22,       34,   42,  -16,       41,   25,   -6,       49,    6,    6,
      59,  -12,   19,       68,  -28,   31,       77,  -43,   43,       87,  -57,   55,
      32,   56,  -20,       36,   45,  -14,       42,   28,   -4,       50,   10,    7,
      59,   -9,   20,       68,  -26,   32,       78,  -40,   44,       87,  -54,   55,
      33,   58,  -17,       37,   47,  -12,       43,   31,   -3,       51,   13,    9,
      60,   -6,   21,       69,  -23,   33,       78,  -38,   45,       88,  -52,   56,
      35,   59,  -15,       38,   50,   -9,       44,   34,   -1,       52,   16,   10,
      61,   -3,   22,       69,  -19,   34,       79,  -35,   45,       88,  -49,   56,
      37,   61,  -12,       40,   52,   -7,       46,   37,    1,       53,   20,   12,
      61,    1,   23,       70,  -16,   35,       79,  -32,   46,       89,  -46,   57,
      38,   63,   -9,       41,   55,   -5,       47,   40,    3,       54,   23,   13,
      62,    4,   24,       71,  -13,   36,       80,  -29,   47,       89,  -44,   58,
      40,   65,   -7,       43,   57,   -2,       48,   43,    5,       55,   26,   15,
      63,    8,   26,       71,   -9,   37,       80,  -26,   47,       89,  -41,   58,
      42,   67,   -4,       44,   59,    0,       49,   46,    7,       56,   29,   16,
      64,   11,   27,       72,   -6,   38,       81,  -22,   48,       90,  -38,   59,
      43,   69,   -1,       46,   61,    2,       50,   49,    9,       57,   32,   18,
      65,   14,   28,       73,   -3,   39,       81,  -19,   49,       90,  -35,   60,
      45,   71,    1,       47,   64,    5,       52,   52,   11,       58,   36,   20,
      66,   18,   30,       74,    1,   40,       82,  -16,   50,       91,  -32,   60,
      47,   73,    4,       49,   66,    7,       53,   54,   13,       59,   39,   21,
      66,   21,   31,       74,    4,   41,       83,  -12,   51,       91,  -28,   61,
      48,   75,    6,       50,   68,   10,       55,   57,   15,       60,   42,   23,
      67,   25,   32,       75,    7,   42,       83,   -9,   52,       92,  -25,   62,
      50,   76,    9,       52,   70,   12,       56,   59,   17,       61,   45,   25,
      68,   28,   34,       76,   11,   43,       84,   -6,   53,       93,  -22,   63,
      52,   78,   12,       54,   73,   14,       57,   62,   20,       63,   48,   27,
      69,   31,   35,       77,   14,   45,       85,   -2,   54,       93,  -19,   64,
      53,   80,   14,       55,   75,   17,       59,   65,   22,       64,   51,   28,
      70,   34,   37,       78,   18,   46,       85,    1,   55,       94,  -15,   65,
      55,   82,   17,       57,   77,   19,       60,   67,   24,       65,   54,   30,
      71,   38,   38,       79,   21,   47,       86,    4,   56,       94,  -12,   65,
      13,   37,  -56,       22,   14,  -42,       32,   -8,  -25,       43,  -26,   -9,
      54,  -41,    7,       64,  -53,   22,       74,  -64,   35,       85,  -75,   48,
      14,   37,  -55,       22,   15,  -42,       32,   -7,  -25,       43,  -25,   -9,
      54,  -40,    7,       64,  -53,   22,       74,  -64,   35,       85,  -75,   48,
      14,   37,  -55,       22,   15,  -41,       32,   -7,  -25,       43,  -25,   -9,
      54,  -40,    7,       64,  -53,   22,       74,  -64,   35,       85,  -75,   48,
      14,   38,  -54,       22,   16,  -41,       33,   -5,  -25,       43,  -24,   -8,
      54,  -39,    8,       64,  -52,   22,       75,  -63,   35,       85,  -74,   48,
      15,   38,  -53,       23,   18,  -40,       33,   -4,  -24,       43,  -23,   -8,
      54,  -38,    8,       64,  -51,   22,       75,  -63,   35,       85,  -74,   48,
      16,   39,  -51,       23,   19,  -39,       33,   -3,  -24,       44,  -21,   -8,
      54,  -37,    8,       65,  -50,   22,       75,  -62,   36,       85,  -73,   48,
      17,   40,  -50,       24,   21,  -38,       34,   -1,  -23,       44,  -20,   -7,
      54,  -36,    8,       65,  -49,   22,       75,  -61,   36,       85,  -72,   48,
      18,   41,  -48,       25,   23,  -37,       34,    1,  -22,       44,  -18,   -7,
      55,  -34,    9,       65,  -48,   23,       75,  -60,   36,       85,  -71,   49,
      19,   42,  -46,       26,   25,  -36,       35,    4,  -21,       45,  -15,   -6,
      55,  -32,    9,       65,  -46,   23,       75,  -59,   36,       85,  -70,   49,
      20,   44,  -44,       26,   27,  -34,       35,    6,  -20,       45,  -13,   -5,
      55,  -30,   10,       65,  -45,   23,       75,  -57,   36,       85,  -69,   49,
      22,   45,  -42,       27,   29,  -33,       36,    9,  -19,       45,  -11,   -5,
      56,  -28,   10,       66,  -43,   24,       76,  -56,   37,       86,  -67,   49,
      23,   47,  -40,       28,   31,  -31,       37,   12,  -18,       46,   -8,   -4,
      56,  -26,   11,       66,  -41,   24,       76,  -54,   37,       86,  -66,   50,
      25,   48,  -37,       30,   34,  -29,       37,   15,  -17,       47,   -5,   -3,
      57,  -23,   11,       66,  -38,   25,       76,  -52,   38,       86,  -64,   50,
      26,   50,  -35,       31,   36,  -27,       38,   18,  -15,       47,   -2,   -2,
      57,  -20,   12,       67,  -36,   25,       76,  -49,   38,       86,  -62,   50,
      27,   52,  -32,       32,   39,  -25,       39,   20,  -14,       48,    1,   -1,
      58,  -17,   13,       67,  -33,   26,       77,  -47,   38,       86,  -60,   51,
      29,   53,  -30,       33,   41,  -23,       40,   23,  -12,       49,    4,    0,
      58,  -14,   14,       67,  -30,   27,       77,  -45,   39,       87,  -58,   51,
      31,   55,  -27,       35,   44,  -21,       41,   27,  -10,       49,    8,    2,
      59,  -11,   15,       68,  -27,   27,       77,  -42,   40,       87,  -56,   51,
      32,   57,  -24,       36,   46,  -18,       42,   30,   -9,       50,   11,    3,
      59,   -8,   16,       68,  -24,   28,       78,  -39,   40,       87,  -53,   52,
      34,   59,  -22,       37,   48,  -16,       43,   32,   -7,       51,   14,    4,
      60,   -5,   17,       69,  -21,   29,       78,  -37,   41,       88,  -51,   52,
      35,   60,  -19,       39,   51,  -14,       45,   35,   -5,       52,   17,    6,
      61,   -1,   18,       70,  -18,   30,       79,  -34,   41,       88,  -48,   53,
      37,   62,  -16,       40,   53,  -11,       46,   39,   -3,       53,   21,    7,
      61,    2,   19,       70,  -15,   31,       79,  -31,   42,       89,  -45,   54,
      39,   64,  -14,       42,   56,   -9,       47,   41,   -1,       54,   24,    9,
      62,    5,   20,       71,  -12,   32,       80,  -28,   43,       89,  -43,   54,
      40,   66,  -11,       43,   58,   -7,       48,   44,    1,       55,   27,   10,
      63,    9,   21,       71,   -9,   33,       80,  -25,   44,       89,  -40,   55,
      42,   68,   -9,       45,   60,   -5,       49,   47,    3,       56,   30,   12,
      64,   12,   23,       72,   -5,   34,       81,  -22,   45,       90,  -37,   56,
      43,   69,   -6,       46,   62,   -2,       51,   49,    4,       57,   33,   13,
      65,   15,   24,       73,   -2,   35,       81,  -18,   45,       90,  -34,   56,
      45,   72,   -3,       48,   65,    0,       52,   52,    7,       58,   37,   15,
      66,   19,   25,       74,    2,   36,       82,  -15,   46,       91,  -31,   57,
      47,   73,   -1,       49,   67,    3,       53,   55,    9,       59,   40,   17,
      67,   22,   27,       74,    5,   37,       83,  -12,   47,       92,  -28,   58,
      48,   75,    2,       51,   69,    5,       55,   58,   11,       60,   43,   19,
      68,   25,   28,       75,    8,   38,       83,   -8,   48,       92,  -25,   59,
      50,   77,    4,       52,   71,    7,       56,   60,   13,       62,   45,   20,
      68,   28,   30,       76,   11,   39,       84,   -5,   49,       93,  -22,   59,
      52,   79,    7,       54,   73,   10,       58,   63,   15,       63,   49,   22,
      70,   32,   31,       77,   15,   41,       85,   -2,   50,       93,  -18,   60,
      53,   81,   10,       55,   75,   12,       59,   65,   17,       64,   51,   24,
      71,   35,   33,       78,   18,   42,       86,    2,   51,       94,  -15,   61,
      55,   83,   12,       57,   77,   15,       60,   68,   19,       65,   54,   26,
      72,   38,   34,       79,   22,   43,       86,    5,   52,       95,  -12,   62,
      14,   39,  -59,       22,   18,  -46,       33,   -4,  -30,       43,  -23,  -13,
      54,  -39,    3,       64,  -52,   18,       75,  -63,   31,       85,  -74,   44,
      15,   40,  -59,       23,   18,  -46,       33,   -4,  -29,       43,  -22,  -13,
      54,  -38,    3,       64,  -51,   18,       75,  -63,   31,       85,  -74,   44,
      15,   40,  -58,       23,   19,  -45,       33,   -3,  -29,       43,  -22,  -13,
      54,  -38,    3,       64,  -51,   18,       75,  -62,   31,       85,  -73,   44,
      16,   40,  -57,       23,   20,  -45,       33,   -2,  -29,       43,  -21,  -13,
      54,  -37,    3,       65,  -50,   18,       75,  -62,   31,       85,  -73,   44,
      16,   41,  -56,       24,   21,  -44,       33,   -1,  -29,       44,  -20,  -12,
      54,  -36,    3,       65,  -50,   18,       75,  -61,   31,       85,  -72,   45,
      17,   42,  -55,       24,   22,  -43,       34,    0,  -28,       44,  -19,  -12,
      55,  -35,    4,       65,  -49,   18,       75,  -61,   32,       85,  -72,   45,
      18,   42,  -54,       25,   24,  -42,       34,    2,  -27,       44,  -17,  -12,
      55,  -34,    4,       65,  -48,   18,       75,  -60,   32,       85,  -71,   45,
      19,   43,  -52,       25,   25,  -41,       34,    4,  -27,       44,  -15,  -11,
      55,  -32,    4,       65,  -46,   19,       75,  -58,   32,       85,  -70,   45,
      20,   45,  -50,       26,   27,  -40,       35,    6,  -26,       45,  -13,  -11,
      55,  -30,    5,       65,  -45,   19,       75,  -57,   32,       85,  -69,   45,
      21,   46,  -48,       27,   29,  -38,       36,    9,  -25,       45,  -11,  -10,
      56,  -28,    5,       66,  -43,   19,       75,  -56,   33,       85,  -68,   45,
      22,   47,  -46,       28,   31,  -37,       36,   11,  -24,       46,   -9,   -9,
      56,  -26,    6,       66,  -41,   20,       76,  -54,   33,       86,  -66,   46,
      24,   48,  -44,       29,   33,  -35,       37,   14,  -22,       46,   -6,   -8,
      56,  -24,    6,       66,  -39,   20,       76,  -52,   33,       86,  -65,   46,
      25,   50,  -41,       30,   36,  -33,       38,   17,  -21,       47,   -3,   -7,
      57,  -21,    7,       66,  -37,   21,       76,  -50,   34,       86,  -63,   46,
      27,   51,  -39,       31,   38,  -31,       39,   19,  -20,       47,    0,   -6,
      57,  -18,    8,       67,  -34,   21,       76,  -48,   34,       86,  -61,   47,
      28,   53,  -36,       32,   40,  -29,       40,   22,  -18,       48,    3,   -5,
      58,  -16,    9,       67,  -32,   22,       77,  -46,   35,       87,  -59,   47,
      29,   54,  -34,       34,   43,  -27,       40,   25,  -17,       49,    6,   -4,
      58,  -13,    9,       68,  -29,   23,       77,  -44,   35,       87,  -57,   47,
      31,   56,  -31,       35,   45,  -25,       42,   28,  -15,       50,    9,   -3,
      59,  -10,   11,       68,  -26,   23,       78,  -41,   36,       87,  -55,   48,
      33,   58,  -29,       36,   47,  -23,       43,   31,  -13,       50,   12,   -1,
      59,   -6,   11,       69,  -23,   24,       78,  -38,   36,       88,  -52,   48,
      34,   60,  -26,       38,   50,  -21,       44,   34,  -12,       51,   15,    0,
      60,   -3,   12,       69,  -20,   25,       78,  -36,   37,       88,  -50,   49,
      36,   61,  -24,       39,   52,  -18,       45,   37,  -10,       52,   19,    1,
      61,    0,   14,       70,  -17,   26,       79,  -33,   38,       88,  -48,   49,
      37,   63,  -21,       41,   54,  -16,       46,   40,   -8,       53,   22,    3,
      62,    3,   15,       70,  -14,   27,       79,  -30,   38,       89,  -45,   50,
      39,   65,  -18,       42,   56,  -14,       47,   42,   -6,       54,   25,    4,
      62,    7,   16,       71,  -11,   28,       80,  -27,   39,       89,  -42,   51,
      41,   67,  -16,       43,   59,  -11,       48,   45,   -4,       55,   28,    6,
      63,   10,   17,       72,   -8,   29,       80,  -24,   40,       90,  -39,   51,
      42,   68,  -13,       45,   61,   -9,       50,   48,   -2,       56,   31,    7,
      64,   13,   18,       72,   -4,   30,       81,  -21,   41,       90,  -36,   52,
      44,   70,  -11,       46,   63,   -7,       51,   50,    0,       57,   34,    9,
      65,   16,   20,       73,   -1,   31,       82,  -18,   42,       91,  -33,   53,
      46,   72,   -8,       48,   65,   -4,       52,   53,    2,       58,   38,   11,
      66,   20,   21,       74,    2,   32,       82,  -14,   43,       91,  -30,   53,
      47,   74,   -5,       49,   67,   -2,       54,   56,    4,       59,   40,   13,
      67,   23,   23,       75,    6,   33,       83,  -11,   43,       92,  -27,   54,
      49,   76,   -3,       51,   69,    0,       55,   58,    6,       61,   43,   14,
      68,   26,   24,       75,    9,   34,       83,   -8,   44,       92,  -24,   55,
      50,   78,    0,       52,   72,    3,       56,   61,    8,       62,   46,   16,
      69,   29,   25,       76,   12,   35,       84,   -5,   45,       93,  -21,   56,
      52,   80,    3,       54,   74,    5,       58,   63,   11,       63,   49,   18,
      70,   33,   27,       77,   16,   37,       85,   -1,   47,       93,  -17,   57,
      54,   81,    5,       55,   76,    8,       59,   66,   13,       64,   52,   20,
      71,   36,   29,       78,   19,   38,       86,    2,   48,       94,  -14,   58,
      55,   83,    7,       57,   78,   10,       60,   68,   15,       65,   55,   22,
      72,   39,   30,       79,   22,   39,       86,    6,   49,       95,  -11,   59,
      16,   42,  -63,       23,   22,  -50,       33,   -1,  -34,       43,  -20,  -18,
      54,  -36,   -2,       65,  -49,   13,       75,  -61,   27,       85,  -72,   40,
      16,   43,  -62,       23,   22,  -50,       33,    0,  -34,       44,  -19,  -18,
      54,  -36,   -2,       65,  -49,   13,       75,  -61,   27,       85,  -72,   40,
      16,   43,  -62,       24,   23,  -50,       33,    0,  -34,       44,  -19,  -18,
      54,  -35,   -2,       65,  -49,   13,       75,  -61,   27,       85,  -72,   40,
      17,   43,  -61,       24,   23,  -49,       33,    1,  -34,       44,  -18,  -18,
      54,  -35,   -2,       65,  -48,   13,       75,  -60,   27,       85,  -71,   40,
      17,   44,  -60,       24,   24,  -48,       34,    2,  -33,       44,  -17,  -17,
      55,  -34,   -1,       65,  -48,   13,       75,  -60,   27,       85,  -71,   40,
      18,   44,  -59,       25,   25,  -48,       34,    4,  -33,       44,  -16,  -17,
      55,  -33,   -1,       65,  -47,   13,       75,  -59,   27,       85,  -70,   40,
      19,   45,  -58,       25,   27,  -47,       34,    5,  -32,       44,  -14,  -17,
      55,  -31,   -1,       65,  -46,   14,       75,  -58,   27,       85,  -70,   41,
      20,   46,  -56,       26,   28,  -46,       35,    7,  -31,       45,  -12,  -16,
      55,  -30,    0,       65,  -44,   14,       75,  -57,   28,       85,  -69,   41,
      21,   47,  -54,       27,   30,  -44,       35,    9,  -30,       45,  -10,  -15,
      55,  -28,    0,       65,  -43,   14,       75,  -56,   28,       85,  -68,   41,
      22,   48,  -52,       28,   32,  -43,       36,   11,  -30,       46,   -8,  -15,
      56,  -26,    0,       66,  -41,   15,       76,  -54,   28,       86,  -66,   41,
      23,   49,  -50,       29,   34,  -41,       37,   14,  -28,       46,   -6,  -14,
      56,  -24,    1,       66,  -39,   15,       76,  -53,   28,       86,  -65,   41,
      24,   50,  -48,       30,   36,  -40,       37,   16,  -27,       47,   -4,  -13,
      56,  -22,    2,       66,  -37,   16,       76,  -51,   29,       86,  -64,   42,
      26,   52,  -46,       31,   38,  -38,       38,   19,  -26,       47,   -1,  -12,
      57,  -19,    2,       67,  -35,   16,       76,  -49,   29,       86,  -62,   42,
      27,   53,  -43,       32,   40,  -36,       39,   22,  -25,       48,    2,  -11,
      57,  -17,    3,       67,  -33,   17,       77,  -47,   30,       86,  -60,   42,
      29,   55,  -41,       33,   42,  -34,       40,   24,  -23,       48,    5,  -10,
      58,  -14,    4,       67,  -30,   17,       77,  -45,   30,       87,  -58,   43,
      30,   56,  -39,       34,   44,  -32,       41,   27,  -22,       49,    8,   -9,
      58,  -11,    5,       68,  -28,   18,       77,  -42,   31,       87,  -56,   43,
      32,   58,  -36,       36,   47,  -30,       42,   30,  -20,       50,   11,   -8,
      59,   -8,    6,       68,  -25,   19,       78,  -40,   31,       87,  -54,   44,
      33,   59,  -33,       37,   49,  -28,       43,   33,  -18,       51,   14,   -6,
      60,   -5,    7,       69,  -22,   19,       78,  -37,   32,       88,  -51,   44,
      35,   61,  -31,       38,   51,  -26,       44,   35,  -16,       52,   17,   -5,
      60,   -2,    8,       69,  -19,   20,       78,  -34,   33,       88,  -49,   45,
      36,   63,  -29,       39,   53,  -23,       45,   38,  -15,       52,   20,   -4,
      61,    1,    9,       70,  -16,   21,       79,  -32,   33,       88,  -46,   45,
      38,   64,  -26,       41,   56,  -21,       46,   41,  -13,       53,   23,   -2,
      62,    5,   10,       71,  -13,   22,       79,  -29,   34,       89,  -44,   46,
      39,   66,  -23,       42,   58,  -19,       48,   44,  -11,       54,   26,   -1,
      63,    8,   11,       71,   -9,   23,       80,  -26,   35,       89,  -41,   47,
      41,   68,  -21,       44,   60,  -16,       49,   46,   -9,       55,   29,    1,
      63,   11,   12,       72,   -6,   24,       81,  -23,   36,       90,  -38,   47,
      43,   69,  -18,       45,   62,  -14,       50,   49,   -7,       56,   32,    3,
      64,   14,   14,       72,   -3,   25,       81,  -20,   36,       90,  -35,   48,
      44,   71,  -16,       47,   64,  -12,       51,   51,   -5,       57,   35,    4,
      65,   17,   15,       73,    0,   26,       82,  -17,   37,       91,  -32,   49,
      46,   73,  -13,       48,   66,   -9,       53,   54,   -3,       59,   39,    6,
      66,   21,   16,       74,    4,   27,       82,  -13,   38,       91,  -29,   49,
      47,   75,  -10,       50,   68,   -7,       54,   57,   -1,       60,   41,    8,
      67,   24,   18,       75,    7,   28,       83,  -10,   39,       92,  -26,   50,
      49,   77,   -8,       51,   70,   -5,       55,   59,    1,       61,   44,    9,
      68,   27,   19,       75,   10,   30,       84,   -7,   40,       92,  -23,   51,
      51,   78,   -5,       53,   72,   -2,       56,   62,    3,       62,   47,   11,
      69,   30,   21,       76,   13,   31,       84,   -4,   41,       93,  -20,   52,
      52,   80,   -3,       54,   75,    0,       58,   64,    6,       63,   50,   13,
      70,   34,   22,       77,   17,   32,       85,    0,   42,       94,  -17,   53,
      54,   82,    0,       56,   77,    3,       59,   67,    8,       64,   53,   15,
      71,   37,   24,       78,   20,   33,       86,    3,   43,       94,  -13,   54,
      55,   84,    2,       57,   78,    5,       61,   69,   10,       66,   56,   17,
      72,   40,   25,       79,   23,   35,       87,    6,   44,       95,  -10,   55,
      17,   45,  -66,       24,   25,  -54,       34,    3,  -39,       44,  -17,  -22,
      55,  -34,   -6,       65,  -47,    9,       75,  -60,   23,       85,  -71,   36,
      17,   45,  -65,       24,   25,  -54,       34,    3,  -38,       44,  -16,  -22,
      55,  -33,   -6,       65,  -47,    9,       75,  -59,   23,       85,  -71,   36,
      17,   45,  -65,       24,   26,  -53,       34,    4,  -38,       44,  -16,  -22,
      55,  -33,   -6,       65,  -47,    9,       75,  -59,   23,       85,  -70,   36,
      18,   46,  -64,       25,   27,  -53,       34,    5,  -38,       44,  -15,  -22,
      55,  -32,   -6,       65,  -46,    9,       75,  -59,   23,       85,  -70,   36,
      18,   46,  -63,       25,   27,  -52,       34,    6,  -37,       44,  -14,  -22,
      55,  -31,   -6,       65,  -46,    9,       75,  -58,   23,       85,  -70,   37,
      19,   47,  -62,       25,   28,  -52,       34,    7,  -37,       44,  -13,  -21,
      55,  -30,   -5,       65,  -45,    9,       75,  -57,   23,       85,  -69,   37,
      20,   47,  -61,       26,   30,  -51,       35,    8,  -36,       45,  -12,  -21,
      55,  -29,   -5,       65,  -44,   10,       75,  -56,   23,       85,  -68,   37,
      21,   48,  -59,       27,   31,  -49,       