#ifndef _MF_ASR_H
#define _MF_ASR_H

#include <stdint.h>
#include <float.h>
// #include "i2s.h"

/*****************************************************************************/
// Macro definitions
/*****************************************************************************/
#define BEAM_CNT  5  //前缀束搜索的数量
#define SIMILAR_N 5  //近音词数量，>=1
#define PNY_DICT_LEN (408)
#define PNY_LST_LEN  (32) //1s
#define DIGIT_LOG_LEN  	(128)	//4s
#define NONE_GATE (0.95f)

#define MEL_N 80
#define FTR_DIM		512
#define T_N 135
#define FLOAT_MODE	0

#if !FLOAT_MODE
	typedef uint8_t ftr_t;
	#define ASR_MODEL1_ADDRESS 0x400000
	#define ASR_MODEL2_ADDRESS 0x600000
	#define ASR_MODEL1_SIZE (780*1024)
	#define ASR_MODEL2_SIZE (740*1024)
#else
	typedef float ftr_t;
	#define ASR_MODEL1_ADDRESS 0x400000
	#define ASR_MODEL2_ADDRESS 0x600000
	#define ASR_MODEL1_SIZE (3*1024*1024)
	#define ASR_MODEL2_SIZE (1*1024*1024)
#endif

#define ASR_SAMPLE_RATE (16000)		//采样率16K
// #define LR_SHIFT 0					// 1 for Bit(H), 0 for Dock/Go(L)

#define FRAME_LEN 512
#define FRAME_MOVE 128
/*
// memory move 
// audio buffer = | 128 byte old | 128 byte old | 128 byte old | 128 byte new | 128 byte new | 128 byte new | 128 byte new|
//                          ^--------------------------------------------------------|              |              |
//                                       ^----------------------------------------------------------|              |
//                                                      ^----------------------------------------------------------|
//                |_____________________________ 1 ___________________________|
//                               |_____________________________ 2 ___________________________|
//                                               |_____________________________ 3 ___________________________|
//                                                            |_____________________________ 4 ___________________________|
//一格为128点8ms，整个buf为7格，3旧4新。
//每次进来向前滑动4格，即剩3格旧，4格空来待填充
*/

/*****************************************************************************/
// 模型烧录 配置
/*****************************************************************************/
#define FLOAT_MODE		0	//是否浮点模型
#if !FLOAT_MODE
	typedef uint8_t ftr_t;
	#define ASR_MODEL1_OFT 	0x000000	//相对传入基址的偏移
	#define ASR_MEM_OFT 	0x0E0000
	#define ASR_MODEL2_OFT 	0x100000
	#define ASR_MEM_W_OFT	 	(0)
	#define ASR_MEM_SCALE_OFT	(9*512*4)
	#define ASR_MEM_BIAS_OFT	(10*512*4)
	#define ASR_MODEL_SIZE1 	(780*1024)
	#define ASR_MODEL_SIZE2 	(740*1024)
	#define ASR_MEM_SIZE	 	(22*1024)
#else
	typedef float ftr_t;
	#define ASR_MODEL_ADDRESS1 	0x200000
	#define ASR_MODEL_ADDRESS2 	0x500000
	#define ASR_MODEL_SIZE1 	(3*1024*1024)
	#define ASR_MODEL_SIZE2 	(740*1024)
#endif

//二选一，前者288ms滞后，后者 416ms滞后
#define CNN211_FSMN818	0
#define CNN241_FSMN848	1


#if CNN211_FSMN818
	#define T_LPAD		2	
	#define T_RPAD		1
	#define T_CORE		1	//中心未影响部分
	#define FSMN_PAD	0	//实质内容之前的0填充
	#define FSMN_MARGIN	8	
	#define	FSMN_CORE	1
#endif
#if CNN241_FSMN848
	#define T_LPAD		2	
	#define T_RPAD		1
	#define T_CORE		4	//中心未影响部分
	#define FSMN_PAD	0	//实质内容之前的0填充
	#define FSMN_MARGIN	8	
	#define	FSMN_CORE	4
#endif

#define T_LEN 		(T_LPAD+T_RPAD+T_CORE)	//从计算时间角度，可以尝试5,7,9
#define MEL_LEN		(T_LEN*4)	//在8ms一格的时间轴上的长度
#define FSMN_T		((FSMN_PAD+FSMN_MARGIN)*2+FSMN_CORE)  //17
//注意，T_CORE 要和 FSMN_CORE 一致 
	
/*****************************************************************************/
// Enums
/*****************************************************************************/
typedef enum {
ASR_DICT_LV=0, ASR_DICT_SHI, ASR_DICT_YANG, ASR_DICT_CHUN, ASR_DICT_YAN, ASR_DICT_JING, ASR_DICT_DA, ASR_DICT_KUAI, ASR_DICT_WEN, ASR_DICT_ZHANG, ASR_DICT_DE, ASR_DICT_DI, ASR_DICT_SE, ASR_DICT_SI, ASR_DICT_YUE, ASR_DICT_LIN, ASR_DICT_LUAN, ASR_DICT_GENG, ASR_DICT_XIAN, ASR_DICT_HUO, ASR_DICT_XIU, ASR_DICT_MEI, ASR_DICT_YI, ASR_DICT_ANG, ASR_DICT_RAN, ASR_DICT_TA, ASR_DICT_JIN, ASR_DICT_PING, ASR_DICT_YAO, ASR_DICT_BU, ASR_DICT_LI, ASR_DICT_LIANG, ASR_DICT_ZAI, ASR_DICT_YONG, ASR_DICT_DAO, ASR_DICT_SHANG, ASR_DICT_XIA, ASR_DICT_FAN, ASR_DICT_TENG, ASR_DICT_DONG, ASR_DICT_SHE, ASR_DICT_XING, ASR_DICT_ZHUANG, ASR_DICT_RU, ASR_DICT_HAI, ASR_DICT_TUN, ASR_DICT_ZHI, ASR_DICT_TOU, ASR_DICT_YOU, ASR_DICT_LING, ASR_DICT_PAO, ASR_DICT_HAO, ASR_DICT_LE, ASR_DICT_ZHA, ASR_DICT_ZEN, ASR_DICT_ME, ASR_DICT_ZHENG, ASR_DICT_CAI, ASR_DICT_YA, ASR_DICT_SHU, ASR_DICT_TUO, ASR_DICT_QU, ASR_DICT_FU, ASR_DICT_GUANG, ASR_DICT_BANG, ASR_DICT_ZI, ASR_DICT_CHONG, ASR_DICT_SHUI, ASR_DICT_CUAN, ASR_DICT_KE, ASR_DICT_SHEI, ASR_DICT_WAN, ASR_DICT_HOU, ASR_DICT_ZHAO, ASR_DICT_JIAN, ASR_DICT_ZUO, ASR_DICT_CU, ASR_DICT_HEI, ASR_DICT_YU, ASR_DICT_CE, ASR_DICT_MING, ASR_DICT_DUI, ASR_DICT_CHENG, ASR_DICT_MEN, ASR_DICT_WO, ASR_DICT_BEI, ASR_DICT_DAI, ASR_DICT_ZHE, ASR_DICT_HU, ASR_DICT_JIAO, ASR_DICT_PANG, ASR_DICT_JI, ASR_DICT_LAO, ASR_DICT_NONG, ASR_DICT_KANG, ASR_DICT_YUAN, ASR_DICT_CHAO, ASR_DICT_HUI, ASR_DICT_XIANG, ASR_DICT_BING, ASR_DICT_QI, ASR_DICT_CHANG, ASR_DICT_NIAN, ASR_DICT_JIA, ASR_DICT_TU, ASR_DICT_BI, ASR_DICT_PIN, ASR_DICT_XI, ASR_DICT_ZOU, ASR_DICT_CHU, ASR_DICT_CUN, ASR_DICT_WANG, ASR_DICT_NA, ASR_DICT_GE, ASR_DICT_AN, ASR_DICT_NING, ASR_DICT_TIAN, ASR_DICT_XIAO, ASR_DICT_ZHONG, ASR_DICT_SHEN, ASR_DICT_NAN, ASR_DICT_ER, ASR_DICT_RI, ASR_DICT_ZHU, ASR_DICT_XIN, ASR_DICT_WAI, ASR_DICT_LUO, ASR_DICT_GANG, ASR_DICT_QING, ASR_DICT_XUN, ASR_DICT_TE, ASR_DICT_CONG, ASR_DICT_GAN, ASR_DICT_LAI, ASR_DICT_HE, ASR_DICT_DAN, ASR_DICT_WEI, ASR_DICT_DIE, ASR_DICT_KAI, ASR_DICT_CI, ASR_DICT_GU, ASR_DICT_NENG, ASR_DICT_BA, ASR_DICT_BAO, ASR_DICT_XUE, ASR_DICT_SHUAI, ASR_DICT_DOU, ASR_DICT_CAO, ASR_DICT_MAO, ASR_DICT_BO, ASR_DICT_ZHOU, ASR_DICT_LIE, ASR_DICT_QIE, ASR_DICT_JU, ASR_DICT_CHUAN, ASR_DICT_GUO, ASR_DICT_LAN, ASR_DICT_NI, ASR_DICT_TANG, ASR_DICT_BAN, ASR_DICT_SU, ASR_DICT_QUAN, ASR_DICT_HUAN, ASR_DICT_YING, ASR_DICT_A, ASR_DICT_MIN, ASR_DICT_MENG, ASR_DICT_WU, ASR_DICT_TAI, ASR_DICT_HUA, ASR_DICT_XIE, ASR_DICT_PAI, ASR_DICT_HUANG, ASR_DICT_GUA, ASR_DICT_JIANG, ASR_DICT_PIAN, ASR_DICT_MA, ASR_DICT_JIE, ASR_DICT_WA, ASR_DICT_SAN, ASR_DICT_KA, ASR_DICT_ZONG, ASR_DICT_NV, ASR_DICT_GAO, ASR_DICT_YE, ASR_DICT_BIAO, ASR_DICT_BIE, ASR_DICT_ZUI, ASR_DICT_REN, ASR_DICT_JUN, ASR_DICT_DUO, ASR_DICT_ZE, ASR_DICT_TAN, ASR_DICT_MU, ASR_DICT_GUI, ASR_DICT_QIU, ASR_DICT_BAI, ASR_DICT_SANG, ASR_DICT_JIU, ASR_DICT_YIN, ASR_DICT_HUAI, ASR_DICT_RANG, ASR_DICT_ZAN, ASR_DICT_SHUO, ASR_DICT_SHA, ASR_DICT_BEN, ASR_DICT_YUN, ASR_DICT_LA, ASR_DICT_CUO, ASR_DICT_HANG, ASR_DICT_HA, ASR_DICT_TUAN, ASR_DICT_GONG, ASR_DICT_SHAN, ASR_DICT_AI, ASR_DICT_KOU, ASR_DICT_ZHEN, ASR_DICT_QIONG, ASR_DICT_DING, ASR_DICT_DANG, ASR_DICT_QUE, ASR_DICT_WENG, ASR_DICT_QIAN, ASR_DICT_FENG, ASR_DICT_JUE, ASR_DICT_ZHUAN, ASR_DICT_CENG, ASR_DICT_ZU, ASR_DICT_BIAN, ASR_DICT_NEI, ASR_DICT_SHENG, ASR_DICT_CHAN, ASR_DICT_ZAO, ASR_DICT_FANG, ASR_DICT_QIN, ASR_DICT_E, ASR_DICT_LIAN, ASR_DICT_FA, ASR_DICT_LU, ASR_DICT_SUN, ASR_DICT_XU, ASR_DICT_DENG, ASR_DICT_GUAN, ASR_DICT_SHOU, ASR_DICT_MO, ASR_DICT_ZHAN, ASR_DICT_PO, ASR_DICT_PI, ASR_DICT_GUN, ASR_DICT_SHUANG, ASR_DICT_QIANG, ASR_DICT_KAO, ASR_DICT_HONG, ASR_DICT_KAN, ASR_DICT_DIAN, ASR_DICT_KONG, ASR_DICT_PEI, ASR_DICT_TONG, ASR_DICT_TING, ASR_DICT_ZANG, ASR_DICT_KUANG, ASR_DICT_RENG, ASR_DICT_TI, ASR_DICT_PAN, ASR_DICT_HENG, ASR_DICT_CHI, ASR_DICT_LUN, ASR_DICT_KUN, ASR_DICT_HAN, ASR_DICT_LEI, ASR_DICT_ZUAN, ASR_DICT_MAN, ASR_DICT_SEN, ASR_DICT_DUAN, ASR_DICT_LENG, ASR_DICT_SUI, ASR_DICT_GAI, ASR_DICT_GA, ASR_DICT_FOU, ASR_DICT_KUO, ASR_DICT_OU, ASR_DICT_SUO, ASR_DICT_SOU, ASR_DICT_NU, ASR_DICT_DU, ASR_DICT_MIAN, ASR_DICT_CHOU, ASR_DICT_HEN, ASR_DICT_KUA, ASR_DICT_SHAO, ASR_DICT_ROU, ASR_DICT_XUAN, ASR_DICT_CAN, ASR_DICT_SAI, ASR_DICT_DUN, ASR_DICT_NIAO, ASR_DICT_CHUI, ASR_DICT_CHEN, ASR_DICT_HUN, ASR_DICT_PENG, ASR_DICT_FEN, ASR_DICT_CANG, ASR_DICT_GEN, ASR_DICT_SHUA, ASR_DICT_CHUO, ASR_DICT_SHUN, ASR_DICT_CHA, ASR_DICT_GOU, ASR_DICT_MAI, ASR_DICT_LIU, ASR_DICT_DIAO, ASR_DICT_TAO, ASR_DICT_NIU, ASR_DICT_MI, ASR_DICT_CHAI, ASR_DICT_LONG, ASR_DICT_GUAI, ASR_DICT_XIONG, ASR_DICT_MOU, ASR_DICT_RONG, ASR_DICT_KU, ASR_DICT_SONG, ASR_DICT_CHE, ASR_DICT_SAO, ASR_DICT_PIAO, ASR_DICT_PU, ASR_DICT_TUI, ASR_DICT_LANG, ASR_DICT_CHUANG, ASR_DICT_KENG, ASR_DICT_LIAO, ASR_DICT_MIAO, ASR_DICT_ZHUI, ASR_DICT_NAI, ASR_DICT_LOU, ASR_DICT_BIN, ASR_DICT_JUAN, ASR_DICT_ZHUA, ASR_DICT_RUN, ASR_DICT_ZENG, ASR_DICT_AO, ASR_DICT_RE, ASR_DICT_PA, ASR_DICT_QUN, ASR_DICT_LIA, ASR_DICT_COU, ASR_DICT_TIE, ASR_DICT_ZHAI, ASR_DICT_KUAN, ASR_DICT_KUI, ASR_DICT_CUI, ASR_DICT_MIE, ASR_DICT_FEI, ASR_DICT_TIAO, ASR_DICT_NUO, ASR_DICT_GEI, ASR_DICT_CA, ASR_DICT_ZHUN, ASR_DICT_NIE, ASR_DICT_MANG, ASR_DICT_ZHUO, ASR_DICT_PEN, ASR_DICT_ZUN, ASR_DICT_NIANG, ASR_DICT_SUAN, ASR_DICT_NAO, ASR_DICT_RUAN, ASR_DICT_QIAO, ASR_DICT_FO, ASR_DICT_RUI, ASR_DICT_RAO, ASR_DICT_RUO, ASR_DICT_ZEI, ASR_DICT_EN, ASR_DICT_ZA, ASR_DICT_DIU, ASR_DICT_NVE, ASR_DICT_SA, ASR_DICT_NIN, ASR_DICT_SHAI, ASR_DICT_NEN, ASR_DICT_KEN, ASR_DICT_CHUAI, ASR_DICT_SHUAN, ASR_DICT_BENG, ASR_DICT_NE, ASR_DICT_LVE, ASR_DICT_QIA, ASR_DICT_JIONG, ASR_DICT_PIE, ASR_DICT_SENG, ASR_DICT_NUAN, ASR_DICT_NANG, ASR_DICT_MIU, ASR_DICT_POU, ASR_DICT_CEN, ASR_DICT_DIA, ASR_DICT_O, ASR_DICT_ZHUAI, ASR_DICT_YO, ASR_DICT_DEI, ASR_DICT_N, ASR_DICT_EI, ASR_DICT_NOU, ASR_DICT_BIA, ASR_DICT_ENG, ASR_DICT_DEN, ASR_DICT_BLANK, ASR_DICT_ERR}asr_dict_t;

typedef enum 
{
	ASR_DIGIT_0 = 0,
	ASR_DIGIT_1,
	ASR_DIGIT_2,
	ASR_DIGIT_3,
	ASR_DIGIT_4,
	ASR_DIGIT_5,
	ASR_DIGIT_6,
	ASR_DIGIT_7,
	ASR_DIGIT_8,
	ASR_DIGIT_9,
	ASR_DIGIT_DOT,
	ASR_DIGIT_SHI,
	ASR_DIGIT_BAI,
	ASR_DIGIT_QIAN,
	ASR_DIGIT_WAN,
	ASR_DIGIT_NONE,
}asr_digits_t;


/*****************************************************************************/
// Types
/*****************************************************************************/
typedef void (*asr_cb_t)(void);

//输出最可能的top5预测
typedef struct
{
	uint32_t idx;  //pny的下标
	float p;
}pnyp_t;

//回调里输出最近2.56s的音素识别结果和数字识别结果

int asr_init(uint64_t model_addr);
void asr_process(uint8_t* mel_data, int* t_cnt, pnyp_t* pnyp_list);
void asr_deinit(void);

#endif