/*
 * This file is part of the MicroPython project, http://micropython.org/
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Damien P. George
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#ifndef MICROPY_INCLUDED_MBEDTLS_CONFIG_H
#define MICROPY_INCLUDED_MBEDTLS_CONFIG_H

#define MBEDTLS_HAVE_ASM

//#define MBEDTLS_NO_UDBL_DIVISION

//#define MBEDTLS_NO_64BIT_MULTIPLICATION

// #define MBEDTLS_HAVE_TIME


// #define MBEDTLS_HAVE_TIME_DATE


#define MBEDTLS_PLATFORM_MEMORY


//#define MBEDTLS_PLATFORM_NO_STD_FUNCTIONS


//#define MBEDTLS_PLATFORM_EXIT_ALT
//#define MBEDTLS_PLATFORM_TIME_ALT
//#define MBEDTLS_PLATFORM_FPRINTF_ALT
#define MBEDTLS_PLATFORM_PRINTF_ALT
//#define MBEDTLS_PLATFORM_SNPRINTF_ALT
//#define MBEDTLS_PLATFORM_NV_SEED_ALT
//#define MBEDTLS_PLATFORM_SETUP_TEARDOWN_ALT

//#define MBEDTLS_DEPRECATED_WARNING
#define MBEDTLS_DEPRECATED_REMOVED
//#define MBEDTLS_CHECK_PARAMS

//#define MBEDTLS_TIMING_ALT


//#define MBEDTLS_AES_ALT
//#define MBEDTLS_ARC4_ALT
//#define MBEDTLS_ARIA_ALT
//#define MBEDTLS_BLOWFISH_ALT
//#define MBEDTLS_CAMELLIA_ALT
//#define MBEDTLS_CCM_ALT
//#define MBEDTLS_CHACHA20_ALT
//#define MBEDTLS_CHACHAPOLY_ALT
//#define MBEDTLS_CMAC_ALT
//#define MBEDTLS_DES_ALT
//#define MBEDTLS_DHM_ALT
//#define MBEDTLS_ECJPAKE_ALT
//#define MBEDTLS_GCM_ALT
//#define MBEDTLS_NIST_KW_ALT
//#define MBEDTLS_MD2_ALT
//#define MBEDTLS_MD4_ALT
//#define MBEDTLS_MD5_ALT
//#define MBEDTLS_POLY1305_ALT
//#define MBEDTLS_RIPEMD160_ALT
//#define MBEDTLS_RSA_ALT
//#define MBEDTLS_SHA1_ALT
//#define MBEDTLS_SHA256_ALT
//#define MBEDTLS_SHA512_ALT
//#define MBEDTLS_XTEA_ALT


//#define MBEDTLS_ECP_ALT


//#define MBEDTLS_MD2_PROCESS_ALT
//#define MBEDTLS_MD4_PROCESS_ALT
//#define MBEDTLS_MD5_PROCESS_ALT
//#define MBEDTLS_RIPEMD160_PROCESS_ALT
//#define MBEDTLS_SHA1_PROCESS_ALT
//#define MBEDTLS_SHA256_PROCESS_ALT
//#define MBEDTLS_SHA512_PROCESS_ALT
//#define MBEDTLS_DES_SETKEY_ALT
//#define MBEDTLS_DES_CRYPT_ECB_ALT
//#define MBEDTLS_DES3_CRYPT_ECB_ALT
//#define MBEDTLS_AES_SETKEY_ENC_ALT
//#define MBEDTLS_AES_SETKEY_DEC_ALT
//#define MBEDTLS_AES_ENCRYPT_ALT
//#define MBEDTLS_AES_DECRYPT_ALT
//#define MBEDTLS_ECDH_GEN_PUBLIC_ALT
//#define MBEDTLS_ECDH_COMPUTE_SHARED_ALT
//#define MBEDTLS_ECDSA_VERIFY_ALT
//#define MBEDTLS_ECDSA_SIGN_ALT
//#define MBEDTLS_ECDSA_GENKEY_ALT



//#define MBEDTLS_ECP_INTERNAL_ALT

//#define MBEDTLS_ECP_RANDOMIZE_JAC_ALT
//#define MBEDTLS_ECP_ADD_MIXED_ALT
//#define MBEDTLS_ECP_DOUBLE_JAC_ALT
//#define MBEDTLS_ECP_NORMALIZE_JAC_MANY_ALT
//#define MBEDTLS_ECP_NORMALIZE_JAC_ALT

//#define MBEDTLS_ECP_DOUBLE_ADD_MXZ_ALT
//#define MBEDTLS_ECP_RANDOMIZE_MXZ_ALT
//#define MBEDTLS_ECP_NORMALIZE_MXZ_ALT


// #define MBEDTLS_TEST_NULL_ENTROPY


#define MBEDTLS_ENTROPY_HARDWARE_ALT


#define MBEDTLS_AES_ROM_TABLES


//#define MBEDTLS_AES_FEWER_TABLES


//#define MBEDTLS_CAMELLIA_SMALL_MEMORY


#define MBEDTLS_CIPHER_MODE_CBC


#define MBEDTLS_CIPHER_MODE_CFB


#define MBEDTLS_CIPHER_MODE_CTR


//#define MBEDTLS_CIPHER_MODE_OFB


//#define MBEDTLS_CIPHER_MODE_XTS


//#define MBEDTLS_CIPHER_NULL_CIPHER


#define MBEDTLS_CIPHER_PADDING_PKCS7
#define MBEDTLS_CIPHER_PADDING_ONE_AND_ZEROS
#define MBEDTLS_CIPHER_PADDING_ZEROS_AND_LEN
#define MBEDTLS_CIPHER_PADDING_ZEROS


//#define MBEDTLS_ENABLE_WEAK_CIPHERSUITES


#define MBEDTLS_REMOVE_ARC4_CIPHERSUITES


// #define MBEDTLS_REMOVE_3DES_CIPHERSUITES


#define MBEDTLS_ECP_DP_SECP192R1_ENABLED
#define MBEDTLS_ECP_DP_SECP224R1_ENABLED
#define MBEDTLS_ECP_DP_SECP256R1_ENABLED
#define MBEDTLS_ECP_DP_SECP384R1_ENABLED
#define MBEDTLS_ECP_DP_SECP521R1_ENABLED
#define MBEDTLS_ECP_DP_SECP192K1_ENABLED
#define MBEDTLS_ECP_DP_SECP224K1_ENABLED
#define MBEDTLS_ECP_DP_SECP256K1_ENABLED
#define MBEDTLS_ECP_DP_BP256R1_ENABLED
#define MBEDTLS_ECP_DP_BP384R1_ENABLED
#define MBEDTLS_ECP_DP_BP512R1_ENABLED
#define MBEDTLS_ECP_DP_CURVE25519_ENABLED
// #define MBEDTLS_ECP_DP_CURVE448_ENABLED


#define MBEDTLS_ECP_NIST_OPTIM


//#define MBEDTLS_ECP_RESTARTABLE


//#define MBEDTLS_ECDSA_DETERMINISTIC


//#define MBEDTLS_KEY_EXCHANGE_PSK_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_DHE_PSK_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_ECDHE_PSK_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_RSA_PSK_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_RSA_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_DHE_RSA_ENABLED


#define MBEDTLS_KEY_EXCHANGE_ECDHE_RSA_ENABLED


#define MBEDTLS_KEY_EXCHANGE_ECDHE_ECDSA_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_ECDH_ECDSA_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_ECDH_RSA_ENABLED


//#define MBEDTLS_KEY_EXCHANGE_ECJPAKE_ENABLED


//#define MBEDTLS_PK_PARSE_EC_EXTENDED


//#define MBEDTLS_ERROR_STRERROR_DUMMY


#define MBEDTLS_GENPRIME


//#define MBEDTLS_FS_IO


//#define MBEDTLS_NO_DEFAULT_ENTROPY_SOURCES


#define MBEDTLS_NO_PLATFORM_ENTROPY


//#define MBEDTLS_ENTROPY_FORCE_SHA256


//#define MBEDTLS_ENTROPY_NV_SEED


//#define MBEDTLS_MEMORY_DEBUG


//#define MBEDTLS_MEMORY_BACKTRACE


#define MBEDTLS_PK_RSA_ALT_SUPPORT


#define MBEDTLS_PKCS1_V15


//#define MBEDTLS_PKCS1_V21


//#define MBEDTLS_PSA_CRYPTO_SPM


//#define MBEDTLS_PSA_HAS_ITS_IO


//#define MBEDTLS_RSA_NO_CRT


// #define MBEDTLS_SELF_TEST


#define MBEDTLS_SHA256_SMALLER


#define MBEDTLS_SSL_ALL_ALERT_MESSAGES


//#define MBEDTLS_SSL_ASYNC_PRIVATE


//#define MBEDTLS_SSL_DEBUG_ALL


#define MBEDTLS_SSL_ENCRYPT_THEN_MAC


#define MBEDTLS_SSL_EXTENDED_MASTER_SECRET


//#define MBEDTLS_SSL_FALLBACK_SCSV


#define MBEDTLS_SSL_KEEP_PEER_CERTIFICATE


//#define MBEDTLS_SSL_HW_RECORD_ACCEL


//#define MBEDTLS_SSL_CBC_RECORD_SPLITTING


//#define MBEDTLS_SSL_RENEGOTIATION


//#define MBEDTLS_SSL_SRV_SUPPORT_SSLV2_CLIENT_HELLO


//#define MBEDTLS_SSL_SRV_RESPECT_CLIENT_PREFERENCE


#define MBEDTLS_SSL_MAX_FRAGMENT_LENGTH


//#define MBEDTLS_SSL_PROTO_SSL3


#define MBEDTLS_SSL_PROTO_TLS1


#define MBEDTLS_SSL_PROTO_TLS1_1


#define MBEDTLS_SSL_PROTO_TLS1_2


//#define MBEDTLS_SSL_PROTO_DTLS


#define MBEDTLS_SSL_ALPN


//#define MBEDTLS_SSL_DTLS_ANTI_REPLAY


//#define MBEDTLS_SSL_DTLS_HELLO_VERIFY


//#define MBEDTLS_SSL_DTLS_CLIENT_PORT_REUSE


//#define MBEDTLS_SSL_DTLS_BADMAC_LIMIT


#define MBEDTLS_SSL_SESSION_TICKETS


//#define MBEDTLS_SSL_EXPORT_KEYS


#define MBEDTLS_SSL_SERVER_NAME_INDICATION


//#define MBEDTLS_SSL_TRUNCATED_HMAC


//#define MBEDTLS_SSL_TRUNCATED_HMAC_COMPAT


//#define MBEDTLS_THREADING_ALT


//#define MBEDTLS_THREADING_PTHREAD


//#define MBEDTLS_USE_PSA_CRYPTO


// #define MBEDTLS_VERSION_FEATURES


//#define MBEDTLS_X509_ALLOW_EXTENSIONS_NON_V3


//#define MBEDTLS_X509_ALLOW_UNSUPPORTED_CRITICAL_EXTENSION


#define MBEDTLS_X509_CHECK_KEY_USAGE


#define MBEDTLS_X509_CHECK_EXTENDED_KEY_USAGE


//#define MBEDTLS_X509_RSASSA_PSS_SUPPORT


//#define MBEDTLS_ZLIB_SUPPORT





//#define MBEDTLS_AESNI_C


#define MBEDTLS_AES_C


//#define MBEDTLS_ARC4_C


#define MBEDTLS_ASN1_PARSE_C


#define MBEDTLS_ASN1_WRITE_C


#define MBEDTLS_BASE64_C


#define MBEDTLS_BIGNUM_C


//#define MBEDTLS_BLOWFISH_C


//#define MBEDTLS_CAMELLIA_C


//#define MBEDTLS_ARIA_C


//#define MBEDTLS_CCM_C


//#define MBEDTLS_CERTS_C


//#define MBEDTLS_CHACHA20_C


//#define MBEDTLS_CHACHAPOLY_C


#define MBEDTLS_CIPHER_C


//#define MBEDTLS_CMAC_C


#define MBEDTLS_CTR_DRBG_C


// #define MBEDTLS_DEBUG_C


//#define MBEDTLS_DES_C


//#define MBEDTLS_DHM_C


#define MBEDTLS_ECDH_C


#define MBEDTLS_ECDSA_C


//#define MBEDTLS_ECJPAKE_C


#define MBEDTLS_ECP_C


#define MBEDTLS_ENTROPY_C


//#define MBEDTLS_ERROR_C


#define MBEDTLS_GCM_C


//#define MBEDTLS_HAVEGE_C


//#define MBEDTLS_HKDF_C


//#define MBEDTLS_HMAC_DRBG_C


//#define MBEDTLS_NIST_KW_C


#define MBEDTLS_MD_C


//#define MBEDTLS_MD2_C


//#define MBEDTLS_MD4_C


#define MBEDTLS_MD5_C


//#define MBEDTLS_MEMORY_BUFFER_ALLOC_C


//#define MBEDTLS_NET_C


#define MBEDTLS_OID_C
#define MBEDTLS_PKCS5_C


//#define MBEDTLS_PADLOCK_C


#define MBEDTLS_PEM_PARSE_C


//#define MBEDTLS_PEM_WRITE_C


#define MBEDTLS_PK_C


#define MBEDTLS_PK_PARSE_C


#define MBEDTLS_PK_WRITE_C




//#define MBEDTLS_PKCS11_C


//#define MBEDTLS_PKCS12_C


#define MBEDTLS_PLATFORM_C


//#define MBEDTLS_POLY1305_C


//#define MBEDTLS_PSA_CRYPTO_C


//#define MBEDTLS_PSA_CRYPTO_STORAGE_C


//#define MBEDTLS_PSA_CRYPTO_STORAGE_FILE_C


//#define MBEDTLS_PSA_CRYPTO_STORAGE_ITS_C


//#define MBEDTLS_RIPEMD160_C


#define MBEDTLS_RSA_C


#define MBEDTLS_SHA1_C


#define MBEDTLS_SHA256_C


// #define MBEDTLS_SHA512_C


//#define MBEDTLS_SSL_CACHE_C


//#define MBEDTLS_SSL_COOKIE_C


//#define MBEDTLS_SSL_TICKET_C


#define MBEDTLS_SSL_CLI_C


#define MBEDTLS_SSL_SRV_C


#define MBEDTLS_SSL_TLS_C


//#define MBEDTLS_THREADING_C


//#define MBEDTLS_TIMING_C


#define MBEDTLS_VERSION_C


#define MBEDTLS_X509_CRT_PARSE_C
#define MBEDTLS_X509_USE_C



//#define MBEDTLS_X509_CRL_PARSE_C


//#define MBEDTLS_X509_CSR_PARSE_C


//#define MBEDTLS_X509_CREATE_C


//#define MBEDTLS_X509_CRT_WRITE_C


//#define MBEDTLS_X509_CSR_WRITE_C


//#define MBEDTLS_XTEA_C






//#define MBEDTLS_MPI_WINDOW_SIZE            6 
//#define MBEDTLS_MPI_MAX_SIZE            1024 


//#define MBEDTLS_CTR_DRBG_ENTROPY_LEN               48 
//#define MBEDTLS_CTR_DRBG_RESEED_INTERVAL        10000 
//#define MBEDTLS_CTR_DRBG_MAX_INPUT                256 
//#define MBEDTLS_CTR_DRBG_MAX_REQUEST             1024 
//#define MBEDTLS_CTR_DRBG_MAX_SEED_INPUT           384 
//#define MBEDTLS_CTR_DRBG_USE_128_BIT_KEY              


//#define MBEDTLS_HMAC_DRBG_RESEED_INTERVAL   10000 
//#define MBEDTLS_HMAC_DRBG_MAX_INPUT           256 
//#define MBEDTLS_HMAC_DRBG_MAX_REQUEST        1024 
//#define MBEDTLS_HMAC_DRBG_MAX_SEED_INPUT      384 


//#define MBEDTLS_ECP_MAX_BITS             521 
//#define MBEDTLS_ECP_WINDOW_SIZE            6 
//#define MBEDTLS_ECP_FIXED_POINT_OPTIM      1 


//#define MBEDTLS_ENTROPY_MAX_SOURCES                20 
//#define MBEDTLS_ENTROPY_MAX_GATHER                128 
//#define MBEDTLS_ENTROPY_MIN_HARDWARE               32 


//#define MBEDTLS_MEMORY_ALIGN_MULTIPLE      4 


//#define MBEDTLS_PLATFORM_STD_MEM_HDR   <stdlib.h> 
//#define MBEDTLS_PLATFORM_STD_CALLOC        calloc 
//#define MBEDTLS_PLATFORM_STD_FREE            free 
//#define MBEDTLS_PLATFORM_STD_EXIT            exit 
//#define MBEDTLS_PLATFORM_STD_TIME            time 
//#define MBEDTLS_PLATFORM_STD_FPRINTF      fprintf 
//#define MBEDTLS_PLATFORM_STD_PRINTF        printf 

//#define MBEDTLS_PLATFORM_STD_SNPRINTF    snprintf 
//#define MBEDTLS_PLATFORM_STD_EXIT_SUCCESS       0 
//#define MBEDTLS_PLATFORM_STD_EXIT_FAILURE       1 
//#define MBEDTLS_PLATFORM_STD_NV_SEED_READ   mbedtls_platform_std_nv_seed_read 
//#define MBEDTLS_PLATFORM_STD_NV_SEED_WRITE  mbedtls_platform_std_nv_seed_write 
//#define MBEDTLS_PLATFORM_STD_NV_SEED_FILE  "seedfile" 



//#define MBEDTLS_PLATFORM_CALLOC_MACRO        calloc 
//#define MBEDTLS_PLATFORM_FREE_MACRO            free 
//#define MBEDTLS_PLATFORM_EXIT_MACRO            exit 
//#define MBEDTLS_PLATFORM_TIME_MACRO            time 
//#define MBEDTLS_PLATFORM_TIME_TYPE_MACRO       time_t 
//#define MBEDTLS_PLATFORM_FPRINTF_MACRO      fprintf 
// #define MBEDTLS_PLATFORM_PRINTF_MACRO        printf 

//#define MBEDTLS_PLATFORM_SNPRINTF_MACRO    snprintf 
//#define MBEDTLS_PLATFORM_VSNPRINTF_MACRO    vsnprintf 
//#define MBEDTLS_PLATFORM_NV_SEED_READ_MACRO   mbedtls_platform_std_nv_seed_read 
//#define MBEDTLS_PLATFORM_NV_SEED_WRITE_MACRO  mbedtls_platform_std_nv_seed_write 


//#define MBEDTLS_PARAM_FAILED( cond )               assert( cond )


#define MBEDTLS_SSL_CACHE_DEFAULT_TIMEOUT       86400 
#define MBEDTLS_SSL_CACHE_DEFAULT_MAX_ENTRIES      50 




#define MBEDTLS_SSL_MAX_CONTENT_LEN             8192


//#define MBEDTLS_SSL_IN_CONTENT_LEN              16384


//#define MBEDTLS_SSL_OUT_CONTENT_LEN             16384


//#define MBEDTLS_SSL_DTLS_MAX_BUFFERING             32768

//#define MBEDTLS_SSL_DEFAULT_TICKET_LIFETIME     86400 
//#define MBEDTLS_PSK_MAX_LEN               32 
#define MBEDTLS_SSL_COOKIE_TIMEOUT        60 


//#define MBEDTLS_SSL_CIPHERSUITES MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,MBEDTLS_TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256


//#define MBEDTLS_X509_MAX_INTERMEDIATE_CA   8   
//#define MBEDTLS_X509_MAX_FILE_PATH_LEN     512 


// #define MBEDTLS_TLS_DEFAULT_ALLOW_SHA1_IN_CERTIFICATES


//#define MBEDTLS_TLS_DEFAULT_ALLOW_SHA1_IN_KEY_EXCHANGE


//#define MBEDTLS_PLATFORM_ZEROIZE_ALT


//#define MBEDTLS_PLATFORM_GMTIME_R_ALT

// Memory allocation hooks
// #include <stdlib.h>
// #include "printf.h"
// void *m_calloc_mbedtls(size_t nmemb, size_t size);
// void m_free_mbedtls(void *ptr);
// #define MBEDTLS_PLATFORM_STD_CALLOC m_calloc_mbedtls
// #define MBEDTLS_PLATFORM_STD_FREE m_free_mbedtls
#define MBEDTLS_PLATFORM_SNPRINTF_MACRO snprintf

#include "mbedtls/check_config.h"

#endif /* MICROPY_INCLUDED_MBEDTLS_CONFIG_H */
