#include <stdint.h>
#include "imlib_config.h"

#ifdef IMLIB_ENABLE_YUV_LAB_FUNC

#include "math.h"

#if 0
// https://github.com/openmv/openmv/blob/master/tools/gen_rgb2yuv.py
int8_t yuv_table(uint32_t idx)
{
    int8_t y = 0, u = 0, v = 0;
    float r = 0, g = 0, b = 0;

    uint16_t pixel;
    uint8_t yuv;

    pixel = idx / 3;
    yuv = idx % 3;

    r = (uint8_t)(((((pixel >> 3) & 31) * 255) + 15.5) / 31);
    g = (uint8_t)((((((pixel & 7) << 3) | (pixel >> 13)) * 255) + 31.5) / 63);
    b = (uint8_t)(((((pixel >> 8) & 31) * 255) + 15.5) / 31);

    //  https://en.wikipedia.org/wiki/YCbCr (ITU-R BT.601 conversion)
    y = (int8_t)((r * 0.299) + (g * 0.587) + (b * 0.114) - 128);
    u = (int8_t)((-(r * 0.168736)) - (g * 0.331264) + (b * 0.5));
    v = (int8_t)((r * 0.5) - (g * 0.418688) - (b * 0.081312));

    return (int8_t)(yuv == 0) ? y : (yuv == 1) ? u : (yuv == 2) ? v : 0;
}
#else

const int8_t yuv_table_small[] = {
    -128,    0,    0,     -110,  -10,  -13,      -90,  -21,  -27,      -72,  -32,  -40,
     -52,  -43,  -54,      -33,  -53,  -67,      -15,  -64,  -81,        5,  -75,  -95,
    -126,   -1,    4,     -107,  -11,   -9,      -88,  -22,  -23,      -69,  -33,  -36,
     -50,  -44,  -50,      -31,  -55,  -63,      -12,  -65,  -77,        7,  -76,  -91,
    -124,   -2,    8,     -105,  -13,   -5,      -86,  -24,  -19,      -67,  -34,  -32,
     -47,  -45,  -46,      -29,  -56,  -59,      -10,  -66,  -73,       10,  -77,  -87,
    -121,   -4,   12,     -102,  -14,    0,      -83,  -25,  -14,      -64,  -36,  -28,
     -45,  -47,  -41,      -26,  -57,  -55,       -7,  -68,  -68,       12,  -79,  -82,
    -119,   -5,   16,     -100,  -16,    3,      -80,  -27,  -10,      -62,  -37,  -24,
     -42,  -48,  -37,      -24,  -59,  -51,       -5,  -69,  -64,       15,  -80,  -78,
    -116,   -6,   20,      -97,  -17,    7,      -78,  -28,   -6,      -59,  -39,  -20,
     -40,  -49,  -33,      -21,  -60,  -47,       -2,  -71,  -60,       17,  -82,  -74,
    -114,   -8,   24,      -95,  -18,   11,      -76,  -29,   -2,      -57,  -40,  -16,
     -38,  -51,  -29,      -19,  -61,  -43,        0,  -72,  -56,       19,  -83,  -70,
    -111,   -9,   29,      -92,  -20,   15,      -73,  -31,    1,      -54,  -41,  -11,
     -35,  -52,  -25,      -16,  -63,  -38,        3,  -74,  -52,       22,  -84,  -66,
    -109,  -11,   33,      -90,  -21,   19,      -71,  -32,    5,      -52,  -43,   -7,
     -32,  -54,  -21,      -14,  -64,  -34,        5,  -75,  -48,       24,  -86,  -62,
    -106,  -12,   37,      -88,  -23,   23,      -68,  -34,    9,      -49,  -44,   -3,
     -30,  -55,  -17,      -11,  -66,  -30,        8,  -76,  -44,       27,  -87,  -58,
    -104,  -13,   41,      -85,  -24,   27,      -66,  -35,   13,      -47,  -45,    0,
     -28,  -56,  -13,       -9,  -67,  -26,       10,  -78,  -40,       29,  -89,  -54,
    -102,  -15,   45,      -83,  -25,   31,      -63,  -36,   17,      -45,  -47,    4,
     -25,  -58,   -9,       -6,  -68,  -22,       12,  -79,  -36,       32,  -90,  -50,
     -99,  -16,   49,      -80,  -27,   36,      -61,  -38,   22,      -42,  -48,    8,
     -23,  -59,   -4,       -4,  -70,  -18,       15,  -80,  -31,       34,  -91,  -45,
     -97,  -18,   53,      -78,  -28,   40,      -58,  -39,   26,      -40,  -50,   12,
     -20,  -61,    0,       -1,  -71,  -14,       17,  -82,  -27,       37,  -93,  -41,
     -94,  -19,   57,      -75,  -30,   44,      -56,  -40,   30,      -37,  -51,   16,
     -18,  -62,    3,        1,  -73,  -10,       20,  -83,  -23,       39,  -94,  -37,
     -92,  -20,   61,      -73,  -31,   48,      -54,  -42,   34,      -35,  -52,   20,
     -15,  -63,    7,        3,  -74,   -6,       22,  -85,  -19,       42,  -95,  -33,
     -89,  -22,   66,      -70,  -32,   52,      -51,  -43,   38,      -32,  -54,   25,
     -13,  -65,   11,        6,  -75,   -1,       25,  -86,  -15,       44,  -97,  -29,
     -87,  -23,   70,      -68,  -34,   56,      -48,  -45,   42,      -30,  -55,   29,
     -10,  -66,   15,        8,  -77,    2,       27,  -87,  -11,       47,  -98,  -25,
     -84,  -24,   74,      -65,  -35,   60,      -46,  -46,   46,      -27,  -57,   33,
      -8,  -68,   19,       11,  -78,    6,       30,  -89,   -7,       49, -100,  -21,
     -82,  -26,   78,      -63,  -36,   64,      -44,  -47,   50,      -25,  -58,   37,
      -6,  -69,   23,       13,  -79,   10,       32,  -90,   -3,       51, -101,  -17,
     -79,  -27,   82,      -60,  -38,   69,      -41,  -49,   55,      -22,  -59,   41,
      -3,  -70,   28,       16,  -81,   14,       35,  -92,    1,       54, -103,  -12,
     -77,  -29,   86,      -58,  -39,   73,      -39,  -50,   59,      -20,  -61,   45,
       0,  -72,   32,       18,  -82,   18,       37,  -93,    5,       56, -104,   -8,
     -74,  -30,   90,      -56,  -41,   77,      -36,  -52,   63,      -17,  -62,   49,
       2,  -73,   36,       21,  -84,   22,       39,  -94,    9,       59, -105,   -4,
     -72,  -31,   94,      -53,  -42,   81,      -34,  -53,   67,      -15,  -64,   53,
       4,  -74,   40,       23,  -85,   26,       42,  -96,   13,       61, -107,    0,
     -70,  -33,   98,      -51,  -43,   85,      -31,  -54,   71,      -13,  -65,   57,
       7,  -76,   44,       25,  -86,   30,       44,  -97,   17,       64, -108,    3,
     -67,  -34,  103,      -48,  -45,   89,      -29,  -56,   75,      -10,  -66,   62,
       9,  -77,   48,       28,  -88,   35,       47,  -99,   21,       66, -109,    7,
     -65,  -36,  107,      -46,  -46,   93,      -26,  -57,   79,       -8,  -68,   66,
      12,  -79,   52,       31,  -89,   39,       49, -100,   25,       69, -111,   11,
     -62,  -37,  111,      -43,  -48,   97,      -24,  -58,   83,       -5,  -69,   70,
      14,  -80,   56,       33,  -91,   43,       52, -101,   29,       71, -112,   15,
     -60,  -38,  115,      -41,  -49,  101,      -22,  -60,   87,       -3,  -70,   74,
      17,  -81,   60,       35,  -92,   47,       54, -103,   33,       74, -114,   19,
     -57,  -40,  119,      -38,  -50,  106,      -19,  -61,   92,        0,  -72,   78,
      19,  -83,   65,       38,  -93,   51,       57, -104,   38,       76, -115,   24,
     -55,  -41,  123,      -36,  -52,  110,      -16,  -63,   96,        2,  -73,   82,
      22,  -84,   69,       40,  -95,   55,       59, -105,   42,       79, -116,   28,
     -52,  -43,  127,      -33,  -53,  114,      -14,  -64,  100,        5,  -75,   86,
      24,  -86,   73,       43,  -96,   59,       62, -107,   46,       81, -118,   32,
    -128,    4,    0,     -109,   -6,  -14,      -89,  -17,  -27,      -71,  -28,  -41,
     -51,  -39,  -55,      -32,  -49,  -68,      -14,  -60,  -81,        6,  -71,  -95,
    -125,    2,    3,     -106,   -7,  -10,      -87,  -18,  -23,      -68,  -29,  -37,
     -49,  -40,  -51,      -30,  -51,  -64,      -11,  -61,  -77,        8,  -72,  -91,
    -123,    1,    7,     -104,   -9,   -6,      -85,  -20,  -19,      -66,  -30,  -33,
     -46,  -41,  -47,      -28,  -52,  -60,       -9,  -62,  -73,       10,  -73,  -87,
    -120,    0,   11,     -101,  -10,   -1,      -82,  -21,  -15,      -63,  -32,  -28,
     -44,  -43,  -42,      -25,  -53,  -55,       -6,  -64,  -69,       13,  -75,  -83,
    -118,   -1,   15,      -99,  -12,    2,      -80,  -23,  -11,      -61,  -33,  -24,
     -41,  -44,  -38,      -23,  -55,  -51,       -4,  -65,  -65,       16,  -76,  -79,
    -115,   -2,   19,      -97,  -13,    6,      -77,  -24,   -7,      -58,  -35,  -20,
     -39,  -45,  -34,      -20,  -56,  -47,       -1,  -67,  -61,       18,  -78,  -75,
    -113,   -4,   23,      -94,  -14,   10,      -75,  -25,   -3,      -56,  -36,  -16,
     -37,  -47,  -30,      -18,  -57,  -43,        1,  -68,  -57,       20,  -79,  -71,
    -110,   -5,   28,      -91,  -16,   14,      -72,  -27,    1,      -53,  -37,  -12,
     -34,  -48,  -26,      -15,  -59,  -39,        4,  -70,  -52,       23,  -80,  -66,
    -108,   -7,   32,      -89,  -17,   18,      -70,  -28,    5,      -51,  -39,   -8,
     -32,  -50,  -22,      -13,  -60,  -35,        6,  -71,  -48,       25,  -82,  -62,
    -105,   -8,   36,      -87,  -19,   22,      -67,  -30,    9,      -49,  -40,   -4,
     -29,  -51,  -18,      -10,  -62,  -31,        8,  -72,  -44,       28,  -83,  -58,
    -103,   -9,   40,      -84,  -20,   26,      -65,  -31,   13,      -46,  -41,    0,
     -27,  -52,  -14,       -8,  -63,  -27,       11,  -74,  -40,       30,  -85,  -54,
    -101,  -11,   44,      -82,  -21,   30,      -63,  -32,   17,      -44,  -43,    3,
     -24,  -54,  -10,       -6,  -64,  -23,       13,  -75,  -36,       33,  -86,  -50,
     -98,  -12,   48,      -79,  -23,   35,      -60,  -34,   21,      -41,  -44,    8,
     -22,  -55,   -5,       -3,  -66,  -18,       16,  -76,  -32,       35,  -87,  -46,
     -96,  -14,   52,      -77,  -24,   39,      -57,  -35,   25,      -39,  -46,   12,
     -19,  -57,   -1,       -1,  -67,  -14,       18,  -78,  -28,       38,  -89,  -42,
     -93,  -15,   56,      -74,  -26,   43,      -55,  -36,   29,      -36,  -47,   16,
     -17,  -58,    2,        2,  -69,  -10,       21,  -79,  -24,       40,  -90,  -38,
     -91,  -16,   60,      -72,  -27,   47,      -53,  -38,   33,      -34,  -48,   20,
     -15,  -59,    6,        4,  -70,   -6,       23,  -81,  -20,       42,  -91,  -34,
     -88,  -18,   65,      -69,  -28,   51,      -50,  -39,   38,      -31,  -50,   24,
     -12,  -61,   10,        7,  -71,   -2,       26,  -82,  -15,       45,  -93,  -29,
     -86,  -19,   69,      -67,  -30,   55,      -48,  -41,   42,      -29,  -51,   28,
      -9,  -62,   14,        9,  -73,    1,       28,  -83,  -11,       48,  -94,  -25,
     -83,  -20,   73,      -65,  -31,   59,      -45,  -42,   46,      -26,  -53,   32,
      -7,  -64,   18,       12,  -74,    5,       31,  -85,   -7,       50,  -96,  -21,
     -81,  -22,   77,      -62,  -32,   63,      -43,  -43,   50,      -24,  -54,   36,
      -5,  -65,   22,       14,  -75,    9,       33,  -86,   -3,       52,  -97,  -17,
     -78,  -23,   81,      -59,  -34,   68,      -40,  -45,   54,      -21,  -55,   41,
      -2,  -66,   27,       17,  -77,   14,       36,  -88,    0,       55,  -99,  -13,
     -76,  -25,   85,      -57,  -35,   72,      -38,  -46,   58,      -19,  -57,   45,
       0,  -68,   31,       19,  -78,   18,       38,  -89,    4,       57, -100,   -9,
     -73,  -26,   89,      -55,  -37,   76,      -35,  -48,   62,      -17,  -58,   49,
       3,  -69,   35,       22,  -80,   22,       40,  -90,    8,       60, -101,   -5,
     -71,  -27,   93,      -52,  -38,   80,      -33,  -49,   66,      -14,  -60,   53,
       5,  -70,   39,       24,  -81,   26,       43,  -92,   12,       62, -103,   -1,
     -69,  -29,   97,      -50,  -39,   84,      -31,  -50,   70,      -12,  -61,   57,
       8,  -72,   43,       26,  -82,   30,       45,  -93,   16,       65, -104,    2,
     -66,  -30,  102,      -47,  -41,   88,      -28,  -52,   75,       -9,  -62,   61,
      10,  -73,   47,       29,  -84,   34,       48,  -95,   21,       67, -105,    7,
     -64,  -32,  106,      -45,  -42,   92,      -25,  -53,   79,       -7,  -64,   65,
      13,  -75,   51,       31,  -85,   38,       50,  -96,   25,       70, -107,   11,
     -61,  -33,  110,      -42,  -44,   96,      -23,  -54,   83,       -4,  -65,   69,
      15,  -76,   55,       34,  -87,   42,       53,  -97,   29,       72, -108,   15,
     -59,  -34,  114,      -40,  -45,  100,      -21,  -56,   87,       -2,  -66,   73,
      17,  -77,   59,       36,  -88,   46,       55,  -99,   33,       74, -110,   19,
     -56,  -36,  118,      -37,  -46,  105,      -18,  -57,   91,        1,  -68,   78,
      20,  -79,   64,       39,  -89,   51,       58, -100,   37,       77, -111,   23,
     -54,  -37,  122,      -35,  -48,  109,      -16,  -59,   95,        3,  -69,   82,
      23,  -80,   68,       41,  -91,   55,       60, -101,   41,       80, -112,   27,
     -51,  -39,  126,      -33,  -49,  113,      -13,  -60,   99,        6,  -71,   86,
      25,  -82,   72,       44,  -92,   59,       63, -103,   45,       82, -114,   31,
    -127,    8,   -1,     -108,   -2,  -14,      -89,  -13,  -28,      -70,  -24,  -41,
     -50,  -35,  -55,      -32,  -45,  -69,      -13,  -56,  -82,        7,  -67,  -96,
    -124,    6,    2,     -105,   -3,  -10,      -86,  -14,  -24,      -67,  -25,  -37,
     -48,  -36,  -51,      -29,  -47,  -65,      -10,  -57,  -78,        9,  -68,  -92,
    -122,    5,    6,     -103,   -5,   -6,      -84,  -16,  -20,      -65,  -26,  -33,
     -46,  -37,  -47,      -27,  -48,  -61,       -8,  -58,  -74,       11,  -69,  -88,
    -119,    3,   11,     -100,   -6,   -2,      -81,  -17,  -16,      -62,  -28,  -29,
     -43,  -39,  -43,      -24,  -49,  -56,       -5,  -60,  -70,       14,  -71,  -83,
    -117,    2,   15,      -98,   -8,    1,      -79,  -19,  -12,      -60,  -29,  -25,
     -40,  -40,  -39,      -22,  -51,  -52,       -3,  -61,  -66,       16,  -72,  -79,
    -114,    1,   19,      -96,   -9,    5,      -76,  -20,   -8,      -57,  -31,  -21,
     -38,  -41,  -35,      -19,  -52,  -48,       -1,  -63,  -62,       19,  -74,  -75,
    -112,    0,   23,      -93,  -10,    9,      -74,  -21,   -4,      -55,  -32,  -17,
     -36,  -43,  -31,      -17,  -53,  -44,        2,  -64,  -58,       21,  -75,  -71,
    -109,   -1,   27,      -91,  -12,   14,      -71,  -23,    0,      -52,  -33,  -12,
     -33,  -44,  -26,      -14,  -55,  -40,        5,  -66,  -53,       24,  -76,  -67,
    -107,   -3,   31,      -88,  -13,   18,      -69,  -24,    4,      -50,  -35,   -8,
     -31,  -46,  -22,      -12,  -56,  -36,        7,  -67,  -49,       26,  -78,  -63,
    -105,   -4,   35,      -86,  -15,   22,      -66,  -26,    8,      -48,  -36,   -4,
     -28,  -47,  -18,       -9,  -58,  -32,        9,  -68,  -45,       29,  -79,  -59,
    -102,   -5,   39,      -83,  -16,   26,      -64,  -27,   12,      -45,  -37,    0,
     -26,  -48,  -14,       -7,  -59,  -28,       12,  -70,  -41,       31,  -81,  -55,
    -100,   -7,   43,      -81,  -17,   30,      -62,  -28,   16,      -43,  -39,    3,
     -23,  -50,  -10,       -5,  -60,  -24,       14,  -71,  -37,       33,  -82,  -51,
     -97,   -8,   48,      -78,  -19,   34,      -59,  -30,   20,      -40,  -40,    7,
     -21,  -51,   -6,       -2,  -62,  -19,       17,  -72,  -33,       36,  -83,  -46,
     -95,  -10,   52,      -76,  -20,   38,      -57,  -31,   24,      -38,  -42,   11,
     -18,  -53,   -2,        0,  -63,  -15,       19,  -74,  -29,       39,  -85,  -42,
     -92,  -11,   56,      -74,  -22,   42,      -54,  -32,   28,      -35,  -43,   15,
     -16,  -54,    1,        3,  -65,  -11,       22,  -75,  -25,       41,  -86,  -38,
     -90,  -12,   60,      -71,  -23,   46,      -52,  -34,   32,      -33,  -44,   19,
     -14,  -55,    5,        5,  -66,   -7,       24,  -77,  -21,       43,  -87,  -34,
     -87,  -14,   64,      -68,  -24,   51,      -49,  -35,   37,      -30,  -46,   24,
     -11,  -57,   10,        8,  -67,   -3,       27,  -78,  -16,       46,  -89,  -30,
     -85,  -15,   68,      -66,  -26,   55,      -47,  -37,   41,      -28,  -47,   28,
      -9,  -58,   14,       10,  -69,    0,       29,  -79,  -12,       48,  -90,  -26,
     -82,  -16,   72,      -64,  -27,   59,      -44,  -38,   45,      -25,  -49,   32,
      -6,  -60,   18,       13,  -70,    4,       31,  -81,   -8,       51,  -92,  -22,
     -80,  -18,   76,      -61,  -28,   63,      -42,  -39,   49,      -23,  -50,   36,
      -4,  -61,   22,       15,  -71,    8,       34,  -82,   -4,       53,  -93,  -18,
     -77,  -19,   81,      -59,  -30,   67,      -39,  -41,   53,      -20,  -51,   40,
      -1,  -62,   26,       18,  -73,   13,       37,  -84,    0,       56,  -95,  -13,
     -75,  -21,   85,      -56,  -31,   71,      -37,  -42,   57,      -18,  -53,   44,
       1,  -64,   30,       20,  -74,   17,       39,  -85,    3,       58,  -96,   -9,
     -73,  -22,   89,      -54,  -33,   75,      -34,  -44,   61,      -16,  -54,   48,
       4,  -65,   34,       23,  -76,   21,       41,  -86,    7,       61,  -97,   -5,
     -70,  -23,   93,      -51,  -34,   79,      -32,  -45,   65,      -13,  -56,   52,
       6,  -66,   38,       25,  -77,   25,       44,  -88,   11,       63,  -99,   -1,
     -68,  -25,   97,      -49,  -35,   83,      -30,  -46,   69,      -11,  -57,   56,
       9,  -68,   42,       27,  -78,   29,       46,  -89,   15,       65, -100,    2,
     -65,  -26,  101,      -46,  -37,   88,      -27,  -48,   74,       -8,  -58,   61,
      11,  -69,   47,       30,  -80,   33,       49,  -91,   20,       68, -101,    6,
     -63,  -28,  105,      -44,  -38,   92,      -25,  -49,   78,       -6,  -60,   65,
      14,  -71,   51,       32,  -81,   37,       51,  -92,   24,       71, -103,   10,
     -60,  -29,  109,      -42,  -40,   96,      -22,  -50,   82,       -3,  -61,   69,
      16,  -72,   55,       35,  -83,   41,       54,  -93,   28,       73, -104,   14,
     -58,  -30,  113,      -39,  -41,  100,      -20,  -52,   86,       -1,  -62,   73,
      18,  -73,   59,       37,  -84,   45,       56,  -95,   32,       75, -106,   18,
     -55,  -32,  118,      -36,  -42,  104,      -17,  -53,   90,        2,  -64,   77,
      21,  -75,   63,       40,  -85,   50,       59,  -96,   36,       78, -107,   23,
     -53,  -33,  122,      -34,  -44,  108,      -15,  -55,   94,        4,  -65,   81,
      23,  -76,   67,       42,  -87,   54,       61,  -97,   40,       80, -108,   27,
     -50,  -35,  126,      -32,  -45,  112,      -12,  -56,   98,        7,  -67,   85,
      26,  -78,   71,       45,  -88,   58,       63,  -99,   44,       83, -110,   31,
    -126,   12,   -2,     -107,    1,  -15,      -87,   -9,  -29,      -69,  -19,  -42,
     -49,  -30,  -56,      -31,  -41,  -69,      -12,  -51,  -83,        8,  -62,  -97,
    -123,   11,    1,     -104,    0,  -11,      -85,  -10,  -25,      -66,  -20,  -38,
     -47,  -31,  -52,      -28,  -42,  -65,       -9,  -53,  -79,       10,  -64,  -93,
    -121,    9,    5,     -102,    0,   -7,      -83,  -11,  -21,      -64,  -22,  -34,
     -45,  -33,  -48,      -26,  -43,  -61,       -7,  -54,  -75,       12,  -65,  -89,
    -118,    8,   10,      -99,   -2,   -2,      -80,  -13,  -16,      -61,  -23,  -30,
     -42,  -34,  -43,      -23,  -45,  -57,       -4,  -55,  -70,       15,  -66,  -84,
    -116,    6,   14,      -97,   -3,    1,      -78,  -14,  -12,      -59,  -25,  -26,
     -39,  -36,  -39,      -21,  -46,  -53,       -2,  -57,  -66,       17,  -68,  -80,
    -113,    5,   18,      -95,   -5,    5,      -75,  -15,   -8,      -56,  -26,  -22,
     -37,  -37,  -35,      -18,  -48,  -49,        0,  -58,  -62,       20,  -69,  -76,
    -111,    4,   22,      -92,   -6,    9,      -73,  -17,   -4,      -54,  -27,  -18,
     -35,  -38,  -31,      -16,  -49,  -45,        3,  -60,  -58,       22,  -70,  -72,
    -108,    2,   26,      -90,   -7,   13,      -70,  -18,    0,      -51,  -29,  -13,
     -32,  -40,  -27,      -13,  -50,  -40,        6,  -61,  -54,       25,  -72,  -68,
    -106,    1,   30,      -87,   -9,   17,      -68,  -20,    3,      -49,  -30,   -9,
     -30,  -41,  -23,      -11,  -52,  -36,        8,  -62,  -50,       27,  -73,  -64,
    -104,    0,   34,      -85,  -10,   21,      -65,  -21,    7,      -47,  -32,   -5,
     -27,  -43,  -19,       -8,  -53,  -32,       10,  -64,  -46,       30,  -75,  -60,
    -101,   -1,   38,      -82,  -11,   25,      -63,  -22,   11,      -44,  -33,   -1,
     -25,  -44,  -15,       -6,  -55,  -28,       13,  -65,  -42,       32,  -76,  -56,
     -99,   -2,   42,      -80,  -13,   29,      -61,  -24,   15,      -42,  -34,    2,
     -22,  -45,  -11,       -4,  -56,  -24,       15,  -66,  -38,       35,  -77,  -52,
     -96,   -4,   47,      -77,  -14,   34,      -58,  -25,   20,      -39,  -36,    6,
     -20,  -47,   -6,       -1,  -57,  -20,       18,  -68,  -33,       37,  -79,  -47,
     -94,   -5,   51,      -75,  -16,   38,      -56,  -27,   24,      -37,  -37,   10,
     -17,  -48,   -2,        1,  -59,  -16,       20,  -69,  -29,       40,  -80,  -43,
     -91,   -6,   55,      -72,  -17,   42,      -53,  -28,   28,      -34,  -39,   14,
     -15,  -49,    1,        4,  -60,  -12,       23,  -71,  -25,       42,  -82,  -39,
     -89,   -8,   59,      -70,  -18,   46,      -51,  -29,   32,      -32,  -40,   18,
     -13,  -51,    5,        6,  -61,   -8,       25,  -72,  -21,       44,  -83,  -35,
     -86,   -9,   63,      -67,  -20,   50,      -48,  -31,   36,      -29,  -41,   23,
     -10,  -52,    9,        9,  -63,   -3,       28,  -74,  -17,       47,  -84,  -31,
     -84,  -11,   67,      -65,  -21,   54,      -46,  -32,   40,      -27,  -43,   27,
      -7,  -54,   13,       11,  -64,    0,       30,  -75,  -13,       49,  -86,  -27,
     -81,  -12,   71,      -63,  -23,   58,      -43,  -34,   44,      -24,  -44,   31,
      -5,  -55,   17,       14,  -66,    4,       32,  -76,   -9,       52,  -87,  -23,
     -79,  -13,   75,      -60,  -24,   62,      -41,  -35,   48,      -22,  -45,   35,
      -3,  -56,   21,       16,  -67,    8,       35,  -78,   -5,       54,  -89,  -19,
     -76,  -15,   80,      -58,  -25,   67,      -38,  -36,   53,      -19,  -47,   39,
       0,  -58,   26,       19,  -69,   12,       38,  -79,    0,       57,  -90,  -14,
     -74,  -16,   84,      -55,  -27,   71,      -36,  -38,   57,      -17,  -48,   43,
       2,  -59,   30,       21,  -70,   16,       40,  -80,    3,       59,  -91,  -10,
     -72,  -18,   88,      -53,  -28,   75,      -33,  -39,   61,      -15,  -50,   47,
       5,  -61,   34,       24,  -71,   20,       42,  -82,    7,       62,  -93,   -6,
     -69,  -19,   92,      -50,  -29,   79,      -31,  -40,   65,      -12,  -51,   51,
       7,  -62,   38,       26,  -73,   24,       45,  -83,   11,       64,  -94,   -2,
     -67,  -20,   96,      -48,  -31,   83,      -29,  -42,   69,      -10,  -52,   55,
      10,  -63,   42,       28,  -74,   28,       47,  -85,   15,       67,  -95,    1,
     -64,  -22,  100,      -45,  -32,   87,      -26,  -43,   73,       -7,  -54,   60,
      12,  -65,   46,       31,  -75,   33,       50,  -86,   19,       69,  -97,    5,
     -62,  -23,  104,      -43,  -34,   91,      -24,  -45,   77,       -5,  -55,   64,
      15,  -66,   50,       33,  -77,   37,       52,  -87,   23,       72,  -98,    9,
     -59,  -24,  108,      -40,  -35,   95,      -21,  -46,   81,       -2,  -57,   68,
      17,  -68,   54,       36,  -78,   41,       55,  -89,   27,       74, -100,   13,
     -57,  -26,  112,      -38,  -36,   99,      -19,  -47,   85,        0,  -58,   72,
      19,  -69,   58,       38,  -79,   45,       57,  -90,   31,       76, -101,   17,
     -54,  -27,  117,      -35,  -38,  104,      -16,  -49,   90,        3,  -59,   76,
      22,  -70,   63,       41,  -81,   49,       60,  -92,   36,       79, -103,   22,
     -52,  -29,  121,      -33,  -39,  108,      -14,  -50,   94,        5,  -61,   80,
      25,  -72,   67,       43,  -82,   53,       62,  -93,   40,       81, -104,   26,
     -49,  -30,  125,      -31,  -41,  112,      -11,  -52,   98,        8,  -62,   84,
      27,  -73,   71,       46,  -84,   57,       64,  -94,   44,       84, -105,   30,
    -125,   16,   -2,     -106,    5,  -16,      -87,   -5,  -29,      -68,  -15,  -43,
     -48,  -26,  -57,      -30,  -37,  -70,      -11,  -47,  -83,        9,  -58,  -97,
    -122,   15,    1,     -104,    4,  -12,      -84,   -6,  -25,      -65,  -16,  -39,
     -46,  -27,  -53,      -27,  -38,  -66,       -8,  -49,  -79,       11,  -60,  -93,
    -120,   13,    5,     -101,    3,   -8,      -82,   -7,  -21,      -63,  -18,  -35,
     -44,  -29,  -49,      -25,  -39,  -62,       -6,  -50,  -75,       13,  -61,  -89,
    -117,   12,    9,      -98,    1,   -3,      -79,   -9,  -17,      -60,  -19,  -30,
     -41,  -30,  -44,      -22,  -41,  -58,       -3,  -51,  -71,       16,  -62,  -85,
    -115,   10,   13,      -96,    0,    0,      -77,  -10,  -13,      -58,  -21,  -26,
     -39,  -32,  -40,      -20,  -42,  -54,       -1,  -53,  -67,       18,  -64,  -81,
    -112,    9,   17,      -94,   -1,    4,      -74,  -11,   -9,      -56,  -22,  -22,
     -36,  -33,  -36,      -17,  -44,  -50,        1,  -54,  -63,       21,  -65,  -77,
    -110,    8,   21,      -91,   -2,    8,      -72,  -13,   -5,      -53,  -23,  -18,
     -34,  -34,  -32,      -15,  -45,  -46,        4,  -56,  -59,       23,  -66,  -73,
    -107,    6,   26,      -89,   -3,   12,      -69,  -14,    0,      -50,  -25,  -14,
     -31,  -36,  -28,      -12,  -46,  -41,        6,  -57,  -54,       26,  -68,  -68,
    -105,    5,   30,      -86,   -5,   16,      -67,  -16,    3,      -48,  -26,  -10,
     -29,  -37,  -24,      -10,  -48,  -37,        9,  -58,  -50,       28,  -69,  -64,
    -103,    4,   34,      -84,   -6,   20,      -64,  -17,    7,      -46,  -28,   -6,
     -26,  -39,  -20,       -8,  -49,  -33,       11,  -60,  -46,       31,  -71,  -60,
    -100,    2,   38,      -81,   -7,   24,      -62,  -18,   11,      -43,  -29,   -2,
     -24,  -40,  -16,       -5,  -51,  -29,       14,  -61,  -42,       33,  -72,  -56,
     -98,    1,   42,      -79,   -9,   28,      -60,  -20,   15,      -41,  -30,    1,
     -22,  -41,  -12,       -3,  -52,  -25,       16,  -62,  -38,       35,  -73,  -52,
     -95,    0,   46,      -76,  -10,   33,      -57,  -21,   19,      -38,  -32,    6,
     -19,  -43,   -7,        0,  -53,  -21,       19,  -64,  -34,       38,  -75,  -48,
     -93,   -1,   50,      -74,  -12,   37,      -55,  -23,   23,      -36,  -33,   10,
     -16,  -44,   -3,        2,  -55,  -17,       21,  -65,  -30,       41,  -76,  -44,
     -90,   -2,   54,      -72,  -13,   41,      -52,  -24,   27,      -33,  -35,   14,
     -14,  -45,    0,        5,  -56,  -13,       24,  -67,  -26,       43,  -78,  -40,
     -88,   -4,   58,      -69,  -14,   45,      -50,  -25,   31,      -31,  -36,   18,
     -12,  -47,    4,        7,  -57,   -9,       26,  -68,  -22,       45,  -79,  -36,
     -85,   -5,   63,      -66,  -16,   49,      -47,  -27,   36,      -28,  -37,   22,
      -9,  -48,    8,       10,  -59,   -4,       29,  -70,  -17,       48,  -80,  -31,
     -83,   -7,   67,      -64,  -17,   53,      -45,  -28,   40,      -26,  -39,   26,
      -7,  -50,   12,       12,  -60,    0,       31,  -71,  -13,       50,  -82,  -27,
     -80,   -8,   71,      -62,  -19,   57,      -42,  -30,   44,      -24,  -40,   30,
      -4,  -51,   16,       15,  -62,    3,       33,  -72,   -9,       53,  -83,  -23,
     -78,   -9,   75,      -59,  -20,   61,      -40,  -31,   48,      -21,  -41,   34,
      -2,  -52,   20,       17,  -63,    7,       36,  -74,   -5,       55,  -85,  -19,
     -75,  -11,   79,      -57,  -21,   66,      -37,  -32,   52,      -18,  -43,   39,
       1,  -54,   25,       20,  -65,   11,       38,  -75,   -1,       58,  -86,  -15,
     -73,  -12,   83,      -54,  -23,   70,      -35,  -34,   56,      -16,  -44,   43,
       3,  -55,   29,       22,  -66,   15,       41,  -76,    2,       60,  -87,  -11,
     -71,  -14,   87,      -52,  -24,   74,      -32,  -35,   60,      -14,  -46,   47,
       6,  -57,   33,       24,  -67,   19,       43,  -78,    6,       63,  -89,   -7,
     -68,  -15,   91,      -49,  -25,   78,      -30,  -36,   64,      -11,  -47,   51,
       8,  -58,   37,       27,  -69,   23,       46,  -79,   10,       65,  -90,   -3,
     -66,  -16,   95,      -47,  -27,   82,      -28,  -38,   68,       -9,  -48,   55,
      10,  -59,   41,       29,  -70,   27,       48,  -81,   14,       67,  -91,    0,
     -63,  -18,  100,      -44,  -28,   86,      -25,  -39,   73,       -6,  -50,   59,
      13,  -61,   45,       32,  -71,   32,       51,  -82,   19,       70,  -93,    5,
     -61,  -19,  104,      -42,  -30,   90,      -23,  -41,   77,       -4,  -51,   63,
      16,  -62,   49,       34,  -73,   36,       53,  -83,   23,       72,  -94,    9,
     -58,  -20,  108,      -40,  -31,   94,      -20,  -42,   81,       -1,  -53,   67,
      18,  -64,   53,       37,  -74,   40,       56,  -85,   27,       75,  -96,   13,
     -56,  -22,  112,      -37,  -32,   98,      -18,  -43,   85,        1,  -54,   71,
      20,  -65,   57,       39,  -75,   44,       58,  -86,   31,       77,  -97,   17,
     -53,  -23,  116,      -34,  -34,  103,      -15,  -45,   89,        4,  -55,   76,
      23,  -66,   62,       42,  -77,   48,       61,  -88,   35,       80,  -99,   21,
     -51,  -25,  120,      -32,  -35,  107,      -13,  -46,   93,        6,  -57,   80,
      25,  -68,   66,       44,  -78,   52,       63,  -89,   39,       82, -100,   25,
     -48,  -26,  124,      -30,  -37,  111,      -10,  -48,   97,        8,  -58,   84,
      28,  -69,   70,       47,  -80,   56,       65,  -90,   43,       85, -101,   29,
    -124,   20,   -3,     -105,    9,  -16,      -86,   -1,  -30,      -67,  -11,  -43,
     -48,  -22,  -57,      -29,  -33,  -71,      -10,  -43,  -84,        9,  -54,  -98,
    -121,   19,    0,     -103,    8,  -12,      -83,   -2,  -26,      -64,  -12,  -39,
     -45,  -23,  -53,      -26,  -34,  -67,       -8,  -45,  -80,       12,  -56,  -94,
    -119,   17,    4,     -100,    7,   -8,      -81,   -3,  -22,      -62,  -14,  -35,
     -43,  -25,  -49,      -24,  -35,  -63,       -5,  -46,  -76,       14,  -57,  -90,
    -116,   16,    9,      -98,    5,   -4,      -78,   -5,  -18,      -59,  -15,  -31,
     -40,  -26,  -45,      -21,  -37,  -58,       -2,  -47,  -72,       17,  -58,  -85,
    -114,   14,   13,      -95,    4,    0,      -76,   -6,  -14,      -57,  -17,  -27,
     -38,  -28,  -41,      -19,  -38,  -54,        0,  -49,  -68,       19,  -60,  -81,
    -112,   13,   17,      -93,    2,    3,      -73,   -7,  -10,      -55,  -18,  -23,
     -35,  -29,  -37,      -16,  -40,  -50,        2,  -50,  -64,       22,  -61,  -77,
    -109,   12,   21,      -90,    1,    7,      -71,   -9,   -6,      -52,  -19,  -19,
     -33,  -30,  -33,      -14,  -41,  -46,        5,  -52,  -60,       24,  -62,  -73,
    -106,   10,   25,      -88,    0,   12,      -68,  -10,   -1,      -50,  -21,  -14,
     -30,  -32,  -28,      -11,  -42,  -42,        7,  -53,  -55,       27,  -64,  -69,
    -104,    9,   29,      -85,   -1,   16,      -66,  -12,    2,      -47,  -22,  -10,
     -28,  -33,  -24,       -9,  -44,  -38,       10,  -54,  -51,       29,  -65,  -65,
    -102,    8,   33,      -83,   -2,   20,      -64,  -13,    6,      -45,  -24,   -6,
     -25,  -35,  -20,       -7,  -45,  -34,       12,  -56,  -47,       32,  -67,  -61,
     -99,    6,   37,      -81,   -3,   24,      -61,  -14,   10,      -42,  -25,   -2,
     -23,  -36,  -16,       -4,  -47,  -30,       15,  -57,  -43,       34,  -68,  -57,
     -97,    5,   41,      -78,   -5,   28,      -59,  -16,   14,      -40,  -26,    1,
     -21,  -37,  -12,       -2,  -48,  -26,       17,  -58,  -39,       36,  -69,  -53,
     -94,    3,   46,      -75,   -6,   32,      -56,  -17,   18,      -37,  -28,    5,
     -18,  -39,   -8,        1,  -49,  -21,       20,  -60,  -35,       39,  -71,  -48,
     -92,    2,   50,      -73,   -8,   36,      -54,  -19,   22,      -35,  -29,    9,
     -16,  -40,   -4,        3,  -51,  -17,       22,  -61,  -31,       41,  -72,  -44,
     -89,    1,   54,      -71,   -9,   40,      -51,  -20,   26,      -33,  -31,   13,
     -13,  -41,    0,        6,  -52,  -13,       24,  -63,  -27,       44,  -74,  -40,
     -87,    0,   58,      -68,  -10,   44,      -49,  -21,   30,      -30,  -32,   17,
     -11,  -43,    3,        8,  -53,   -9,       27,  -64,  -23,       46,  -75,  -36,
     -84,   -1,   62,      -66,  -12,   49,      -46,  -23,   35,      -27,  -33,   22,
      -8,  -44,    8,       11,  -55,   -5,       30,  -66,  -18,       49,  -76,  -32,
     -82,   -3,   66,      -63,  -13,   53,      -44,  -24,   39,      -25,  -35,   26,
      -6,  -46,   12,       13,  -56,   -1,       32,  -67,  -14,       51,  -78,  -28,
     -80,   -4,   70,      -61,  -15,   57,      -41,  -26,   43,      -23,  -36,   30,
      -3,  -47,   16,       16,  -58,    2,       34,  -68,  -10,       54,  -79,  -24,
     -77,   -5,   74,      -58,  -16,   61,      -39,  -27,   47,      -20,  -37,   34,
      -1,  -48,   20,       18,  -59,    6,       37,  -70,   -6,       56,  -81,  -20,
     -74,   -7,   79,      -56,  -17,   65,      -36,  -28,   51,      -18,  -39,   38,
       2,  -50,   24,       21,  -61,   11,       39,  -71,   -2,       59,  -82,  -15,
     -72,   -8,   83,      -53,  -19,   69,      -34,  -30,   55,      -15,  -40,   42,
       4,  -51,   28,       23,  -62,   15,       42,  -72,    1,       61,  -83,  -11,
     -70,  -10,   87,      -51,  -20,   73,      -32,  -31,   59,      -13,  -42,   46,
       7,  -53,   32,       25,  -63,   19,       44,  -74,    5,       64,  -85,   -7,
     -67,  -11,   91,      -49,  -21,   77,      -29,  -32,   63,      -10,  -43,   50,
       9,  -54,   36,       28,  -65,   23,       47,  -75,    9,       66,  -86,   -3,
     -65,  -12,   95,      -46,  -23,   81,      -27,  -34,   67,       -8,  -44,   54,
      11,  -55,   40,       30,  -66,   27,       49,  -77,   13,       68,  -87,    0,
     -62,  -14,   99,      -43,  -24,   86,      -24,  -35,   72,       -5,  -46,   59,
      14,  -57,   45,       33,  -67,   31,       52,  -78,   18,       71,  -89,    4,
     -60,  -15,  103,      -41,  -26,   90,      -22,  -37,   76,       -3,  -47,   63,
      16,  -58,   49,       35,  -69,   35,       54,  -79,   22,       73,  -90,    8,
     -57,  -16,  107,      -39,  -27,   94,      -19,  -38,   80,       -1,  -49,   67,
      19,  -60,   53,       38,  -70,   39,       56,  -81,   26,       76,  -92,   12,
     -55,  -18,  111,      -36,  -28,   98,      -17,  -39,   84,        2,  -50,   71,
      21,  -61,   57,       40,  -71,   43,       59,  -82,   30,       78,  -93,   16,
     -52,  -19,  116,      -34,  -30,  102,      -14,  -41,   88,        5,  -51,   75,
      24,  -62,   61,       43,  -73,   48,       62,  -84,   34,       81,  -95,   21,
     -50,  -21,  120,      -31,  -31,  106,      -12,  -42,   92,        7,  -53,   79,
      26,  -64,   65,       45,  -74,   52,       64,  -85,   38,       83,  -96,   25,
     -48,  -22,  124,      -29,  -33,  110,       -9,  -44,   96,        9,  -54,   83,
      29,  -65,   69,       48,  -76,   56,       66,  -86,   42,       86,  -97,   29,
    -123,   24,   -3,     -104,   13,  -17,      -85,    2,  -31,      -66,   -7,  -44,
     -47,  -18,  -58,      -28,  -29,  -71,       -9,  -39,  -85,       10,  -50,  -99,
    -121,   23,    0,     -102,   12,  -13,      -82,    1,  -27,      -64,   -8,  -40,
     -44,  -19,  -54,      -25,  -30,  -67,       -7,  -41,  -81,       13,  -52,  -95,
    -118,   21,    4,      -99,   11,   -9,      -80,    0,  -23,      -61,  -10,  -36,
     -42,  -21,  -50,      -23,  -31,  -63,       -4,  -42,  -77,       15,  -53,  -91,
    -115,   20,    8,      -97,    9,   -4,      -77,   -1,  -18,      -58,  -11,  -32,
     -39,  -22,  -45,      -20,  -33,  -59,       -2,  -43,  -72,       18,  -54,  -86,
    -113,   18,   12,      -94,    8,    0,      -75,   -2,  -14,      -56,  -13,  -28,
     -37,  -24,  -41,      -18,  -34,  -55,        1,  -45,  -68,       20,  -56,  -82,
    -111,   17,   16,      -92,    6,    3,      -72,   -3,  -10,      -54,  -14,  -24,
     -34,  -25,  -37,      -16,  -36,  -51,        3,  -46,  -64,       23,  -57,  -78,
    -108,   16,   20,      -89,    5,    7,      -70,   -5,   -6,      -51,  -15,  -20,
     -32,  -26,  -33,      -13,  -37,  -47,        6,  -48,  -60,       25,  -58,  -74,
    -106,   14,   25,      -87,    4,   11,      -67,   -6,   -2,      -49,  -17,  -15,
     -29,  -28,  -29,      -10,  -38,  -42,        8,  -49,  -56,       28,  -60,  -70,
    -103,   13,   29,      -84,    2,   15,      -65,   -8,    1,      -46,  -18,  -11,
     -27,  -29,  -25,       -8,  -40,  -38,       11,  -50,  -52,       30,  -61,  -66,
    -101,   12,   33,      -82,    1,   19,      -63,   -9,    5,      -44,  -20,   -7,
     -24,  -31,  -21,       -6,  -41,  -34,       13,  -52,  -48,       32,  -63,  -62,
     -98,   10,   37,      -80,    0,   23,      -60,  -10,    9,      -41,  -21,   -3,
     -22,  -32,  -17,       -3,  -43,  -30,       15,  -53,  -44,       35,  -64,  -58,
     -96,    9,   41,      -77,   -1,   27,      -58,  -12,   13,      -39,  -22,    0,
     -20,  -33,  -13,       -1,  -44,  -26,       18,  -54,  -40,       37,  -65,  -54,
     -93,    7,   45,      -75,   -2,   32,      -55,  -13,   18,      -36,  -24,    4,
     -17,  -35,   -8,        2,  -45,  -22,       21,  -56,  -35,       40,  -67,  -49,
     -91,    6,   49,      -72,   -4,   36,      -53,  -15,   22,      -34,  -25,    8,
     -15,  -36,   -4,        4,  -47,  -18,       23,  -57,  -31,       42,  -68,  -45,
     -89,    5,   53,      -70,   -5,   40,      -50,  -16,   26,      -32,  -27,   12,
     -12,  -37,    0,        7,  -48,  -14,       25,  -59,  -27,       45,  -70,  -41,
     -86,    3,   57,      -67,   -6,   44,      -48,  -17,   30,      -29,  -28,   16,
     -10,  -39,    3,        9,  -49,  -10,       28,  -60,  -23,       47,  -71,  -37,
     -83,    2,   62,      -65,   -8,   48,      -45,  -19,   34,      -27,  -29,   21,
      -7,  -40,    7,       12,  -51,   -5,       30,  -62,  -19,       50,  -72,  -33,
     -81,    0,   66,      -62,   -9,   52,      -43,  -20,   38,      -24,  -31,   25,
      -5,  -42,   11,       14,  -52,   -1,       33,  -63,  -15,       52,  -74,  -29,
     -79,    0,   70,      -60,  -11,   56,      -41,  -22,   42,      -22,  -32,   29,
      -2,  -43,   15,       16,  -54,    2,       35,  -64,  -11,       55,  -75,  -25,
     -76,   -1,   74,      -57,  -12,   60,      -38,  -23,   46,      -19,  -33,   33,
       0,  -44,   19,       19,  -55,    6,       38,  -66,   -7,       57,  -77,  -21,
     -74,   -3,   78,      -55,  -13,   65,      -35,  -24,   51,      -17,  -35,   37,
       3,  -46,   24,       22,  -57,   10,       40,  -67,   -2,       60,  -78,  -16,
     -71,   -4,   82,      -52,  -15,   69,      -33,  -26,   55,      -14,  -36,   41,
       5,  -47,   28,       24,  -58,   14,       43,  -68,    1,       62,  -79,  -12,
     -69,   -6,   86,      -50,  -16,   73,      -31,  -27,   59,      -12,  -38,   45,
       8,  -49,   32,       26,  -59,   18,       45,  -70,    5,       64,  -81,   -8,
     -66,   -7,   90,      -48,  -17,   77,      -28,  -28,   63,       -9,  -39,   49,
      10,  -50,   36,       29,  -61,   22,       47,  -71,    9,       67,  -82,   -4,
     -64,   -8,   94,      -45,  -19,   81,      -26,  -30,   67,       -7,  -40,   53,
      12,  -51,   40,       31,  -62,   26,       50,  -73,   13,       69,  -83,    0,
     -61,  -10,   99,      -43,  -20,   85,      -23,  -31,   71,       -4,  -42,   58,
      15,  -53,   44,       34,  -63,   31,       53,  -74,   17,       72,  -85,    3,
     -59,  -11,  103,      -40,  -22,   89,      -21,  -33,   75,       -2,  -43,   62,
      17,  -54,   48,       36,  -65,   35,       55,  -75,   21,       74,  -86,    7,
     -57,  -12,  107,      -38,  -23,   93,      -18,  -34,   79,        0,  -45,   66,
      20,  -56,   52,       39,  -66,   39,       57,  -77,   25,       77,  -88,   11,
     -54,  -14,  111,      -35,  -24,   97,      -16,  -35,   83,        3,  -46,   70,
      22,  -57,   56,       41,  -67,   43,       60,  -78,   29,       79,  -89,   15,
     -51,  -15,  115,      -33,  -26,  102,      -13,  -37,   88,        5,  -47,   74,
      25,  -58,   61,       44,  -69,   47,       62,  -80,   34,       82,  -91,   20,
     -49,  -17,  119,      -30,  -27,  106,      -11,  -38,   92,        8,  -49,   78,
      27,  -60,   65,       46,  -70,   51,       65,  -81,   38,       84,  -92,   24,
     -47,  -18,  123,      -28,  -29,  110,       -9,  -40,   96,       10,  -50,   82,
      30,  -61,   69,       48,  -72,   55,       67,  -82,   42,       87,  -93,   28,
    -122,   29,   -4,     -103,   18,  -18,      -84,    7,  -31,      -65,   -3,  -45,
     -46,  -14,  -59,      -27,  -24,  -72,       -8,  -35,  -85,       11,  -46,  -99,
    -119,   27,    0,     -101,   17,  -14,      -81,    6,  -27,      -63,   -4,  -41,
     -43,  -15,  -55,      -24,  -26,  -68,       -6,  -36,  -81,       14,  -47,  -95,
    -117,   26,    3,      -98,   15,  -10,      -79,    4,  -23,      -60,   -5,  -37,
     -41,  -16,  -51,      -22,  -27,  -64,       -3,  -37,  -77,       16,  -48,  -91,
    -114,   24,    7,      -96,   14,   -5,      -76,    3,  -19,      -57,   -7,  -32,
     -38,  -18,  -46,      -19,  -28,  -60,       -1,  -39,  -73,       19,  -50,  -87,
    -112,   23,   11,      -93,   12,   -1,      -74,    1,  -15,      -55,   -8,  -28,
     -36,  -19,  -42,      -17,  -30,  -56,        2,  -40,  -69,       21,  -51,  -83,
    -110,   22,   15,      -91,   11,    2,      -71,    0,  -11,      -53,  -10,  -24,
     -33,  -20,  -38,      -15,  -31,  -52,        4,  -42,  -65,       24,  -53,  -79,
    -107,   20,   19,      -88,   10,    6,      -69,    0,   -7,      -50,  -11,  -20,
     -31,  -22,  -34,      -12,  -32,  -48,        7,  -43,  -61,       26,  -54,  -75,
    -105,   19,   24,      -86,    8,   10,      -66,   -2,   -2,      -48,  -12,  -16,
     -28,  -23,  -30,       -9,  -34,  -43,        9,  -45,  -56,       29,  -55,  -70,
    -102,   17,   28,      -83,    7,   14,      -64,   -3,    1,      -45,  -14,  -12,
     -26,  -25,  -26,       -7,  -35,  -39,       12,  -46,  -52,       31,  -57,  -66,
    -100,   16,   32,      -81,    5,   18,      -62,   -5,    5,      -43,  -15,   -8,
     -23,  -26,  -22,       -5,  -37,  -35,       14,  -47,  -48,       33,  -58,  -62,
     -97,   15,   36,      -79,    4,   22,      -59,   -6,    9,      -40,  -16,   -4,
     -21,  -27,  -18,       -2,  -38,  -31,       17,  -49,  -44,       36,  -60,  -58,
     -95,   13,   40,      -76,    3,   26,      -57,   -7,   13,      -38,  -18,    0,
     -19,  -29,  -14,        0,  -39,  -27,       19,  -50,  -40,       38,  -61,  -54,
     -92,   12,   44,      -74,    1,   31,      -54,   -9,   17,      -35,  -19,    4,
     -16,  -30,   -9,        3,  -41,  -23,       22,  -51,  -36,       41,  -62,  -50,
     -90,   10,   48,      -71,    0,   35,      -52,  -10,   21,      -33,  -21,    8,
     -14,  -32,   -5,        5,  -42,  -19,       24,  -53,  -32,       43,  -64,  -46,
     -88,    9,   52,      -69,   -1,   39,      -49,  -11,   25,      -31,  -22,   12,
     -11,  -33,   -1,        8,  -44,  -15,       26,  -54,  -28,       46,  -65,  -42,
     -85,    8,   56,      -66,   -2,   43,      -47,  -13,   29,      -28,  -23,   16,
      -9,  -34,    2,       10,  -45,  -11,       29,  -56,  -24,       48,  -66,  -38,
     -82,    6,   61,      -64,   -3,   47,      -44,  -14,   34,      -25,  -25,   20,
      -6,  -36,    6,       13,  -46,   -6,       31,  -57,  -19,       51,  -68,  -33,
     -80,    5,   65,      -61,   -5,   51,      -42,  -16,   38,      -23,  -26,   24,
      -4,  -37,   10,       15,  -48,   -2,       34,  -58,  -15,       53,  -69,  -29,
     -78,    4,   69,      -59,   -6,   55,      -39,  -17,   42,      -21,  -28,   28,
      -1,  -39,   14,       17,  -49,    1,       36,  -60,  -11,       56,  -71,  -25,
     -75,    2,   73,      -56,   -7,   59,      -37,  -18,   46,      -18,  -29,   32,
       1,  -40,   18,       20,  -50,    5,       39,  -61,   -7,       58,  -72,  -21,
     -73,    1,   77,      -54,   -9,   64,      -34,  -20,   50,      -16,  -30,   37,
       4,  -41,   23,       23,  -52,    9,       41,  -63,   -3,       61,  -74,  -17,
     -70,    0,   81,      -51,  -10,   68,      -32,  -21,   54,      -13,  -32,   41,
       6,  -43,   27,       25,  -53,   13,       44,  -64,    0,       63,  -75,  -13,
     -68,   -1,   85,      -49,  -12,   72,      -30,  -23,   58,      -11,  -33,   45,
       9,  -44,   31,       27,  -55,   17,       46,  -65,    4,       65,  -76,   -9,
     -65,   -2,   89,      -47,  -13,   76,      -27,  -24,   62,       -8,  -35,   49,
      11,  -45,   35,       30,  -56,   21,       49,  -67,    8,       68,  -78,   -5,
     -63,   -4,   93,      -44,  -14,   80,      -25,  -25,   66,       -6,  -36,   53,
      13,  -47,   39,       32,  -57,   25,       51,  -68,   12,       70,  -79,   -1,
     -60,   -5,   98,      -42,  -16,   84,      -22,  -27,   71,       -3,  -37,   57,
      16,  -48,   43,       35,  -59,   30,       54,  -70,   17,       73,  -80,    3,
     -58,   -7,  102,      -39,  -17,   88,      -20,  -28,   75,       -1,  -39,   61,
      18,  -50,   47,       37,  -60,   34,       56,  -71,   21,       75,  -82,    7,
     -56,   -8,  106,      -37,  -19,   92,      -17,  -29,   79,        1,  -40,   65,
      21,  -51,   51,       40,  -62,   38,       58,  -72,   25,       78,  -83,   11,
     -53,   -9,  110,      -34,  -20,   96,      -15,  -31,   83,        4,  -41,   69,
      23,  -52,   55,       42,  -63,   42,       61,  -74,   29,       80,  -85,   15,
     -50,  -11,  114,      -32,  -21,  101,      -12,  -32,   87,        7,  -43,   74,
      26,  -54,   60,       45,  -64,   46,       63,  -75,   33,       83,  -86,   19,
     -48,  -12,  118,      -29,  -23,  105,      -10,  -34,   91,        9,  -44,   78,
      28,  -55,   64,       47,  -66,   50,       66,  -76,   37,       85,  -87,   23,
     -46,  -14,  122,      -27,  -24,  109,       -7,  -35,   95,       11,  -46,   82,
      31,  -57,   68,       49,  -67,   54,       68,  -78,   41,       88,  -89,   27,
    -121,   33,   -5,     -102,   22,  -18,      -83,   11,  -32,      -64,    0,  -45,
     -45,  -10,  -59,      -26,  -20,  -73,       -7,  -31,  -86,       12,  -42, -100,
    -119,   31,   -1,     -100,   21,  -14,      -80,   10,  -28,      -62,    0,  -41,
     -42,  -11,  -55,      -23,  -22,  -69,       -5,  -32,  -82,       15,  -43,  -96,
    -116,   30,    2,      -97,   19,  -10,      -78,    8,  -24,      -59,   -1,  -37,
     -40,  -12,  -51,      -21,  -23,  -65,       -2,  -33,  -78,       17,  -44,  -92,
    -114,   28,    7,      -95,   18,   -6,      -75,    7,  -20,      -57,   -3,  -33,
     -37,  -14,  -47,      -18,  -24,  -60,        0,  -35,  -74,       20,  -46,  -87,
    -111,   27,   11,      -92,   16,   -2,      -73,    5,  -16,      -54,   -4,  -29,
     -35,  -15,  -43,      -16,  -26,  -56,        3,  -36,  -70,       22,  -47,  -83,
    -109,   26,   15,      -90,   15,    1,      -71,    4,  -12,      -52,   -6,  -25,
     -32,  -16,  -39,      -14,  -27,  -52,        5,  -38,  -66,       25,  -49,  -79,
    -106,   24,   19,      -88,   14,    5,      -68,    3,   -8,      -49,   -7,  -21,
     -30,  -18,  -35,      -11,  -28,  -48,        8,  -39,  -62,       27,  -50,  -75,
    -104,   23,   23,      -85,   12,   10,      -65,    1,   -3,      -47,   -8,  -16,
     -27,  -19,  -30,       -9,  -30,  -44,       10,  -41,  -57,       30,  -51,  -71,
    -101,   21,   27,      -82,   11,   14,      -63,    0,    0,      -44,  -10,  -12,
     -25,  -21,  -26,       -6,  -31,  -40,       13,  -42,  -53,       32,  -53,  -67,
     -99,   20,   31,      -80,    9,   18,      -61,   -1,    4,      -42,  -11,   -8,
     -23,  -22,  -22,       -4,  -33,  -36,       15,  -43,  -49,       34,  -54,  -63,
     -96,   19,   35,      -78,    8,   22,      -58,   -2,    8,      -40,  -12,   -4,
     -20,  -23,  -18,       -1,  -34,  -32,       17,  -45,  -45,       37,  -56,  -59,
     -94,   17,   39,      -75,    7,   26,      -56,   -3,   12,      -37,  -14,    0,
     -18,  -25,  -14,        1,  -35,  -28,       20,  -46,  -41,       39,  -57,  -55,
     -91,   16,   44,      -73,    5,   30,      -53,   -5,   16,      -34,  -15,    3,
     -15,  -26,  -10,        4,  -37,  -23,       23,  -47,  -37,       42,  -58,  -50,
     -89,   14,   48,      -70,    4,   34,      -51,   -6,   20,      -32,  -17,    7,
     -13,  -28,   -6,        6,  -38,  -19,       25,  -49,  -33,       44,  -60,  -46,
     -87,   13,   52,      -68,    2,   38,      -48,   -7,   24,      -30,  -18,   11,
     -10,  -29,   -2,        9,  -40,  -15,       27,  -50,  -29,       47,  -61,  -42,
     -84,   12,   56,      -65,    1,   42,      -46,   -9,   28,      -27,  -19,   15,
      -8,  -30,    1,       11,  -41,  -11,       30,  -52,  -25,       49,  -62,  -38,
     -82,   10,   60,      -63,    0,   47,      -43,  -10,   33,      -25,  -21,   20,
      -5,  -32,    6,       14,  -42,   -7,       32,  -53,  -20,       52,  -64,  -34,
     -79,    9,   64,      -60,   -1,   51,      -41,  -12,   37,      -22,  -22,   24,
      -3,  -33,   10,       16,  -44,   -3,       35,  -54,  -16,       54,  -65,  -30,
     -77,    8,   68,      -58,   -2,   55,      -39,  -13,   41,      -20,  -24,   28,
       0,  -35,   14,       18,  -45,    0,       37,  -56,  -12,       57,  -67,  -26,
     -74,    6,   72,      -56,   -3,   59,      -36,  -14,   45,      -17,  -25,   32,
       2,  -36,   18,       21,  -46,    4,       40,  -57,   -8,       59,  -68,  -22,
     -72,    5,   77,      -53,   -5,   63,      -33,  -16,   49,      -15,  -26,   36,
       5,  -37,   22,       23,  -48,    9,       42,  -59,   -4,       62,  -70,  -17,
     -69,    3,   81,      -50,   -6,   67,      -31,  -17,   53,      -12,  -28,   40,
       7,  -39,   26,       26,  -49,   13,       45,  -60,    0,       64,  -71,  -13,
     -67,    2,   85,      -48,   -8,   71,      -29,  -19,   57,      -10,  -29,   44,
       9,  -40,   30,       28,  -51,   17,       47,  -61,    3,       66,  -72,   -9,
     -64,    1,   89,      -46,   -9,   75,      -26,  -20,   61,       -8,  -31,   48,
      12,  -41,   34,       31,  -52,   21,       49,  -63,    7,       69,  -74,   -5,
     -62,    0,   93,      -43,  -10,   79,      -24,  -21,   65,       -5,  -32,   52,
      14,  -43,   38,       33,  -53,   25,       52,  -64,   11,       71,  -75,   -1,
     -59,   -1,   97,      -41,  -12,   84,      -21,  -23,   70,       -2,  -33,   57,
      17,  -44,   43,       36,  -55,   29,       54,  -66,   16,       74,  -76,    2,
     -57,   -3,  101,      -38,  -13,   88,      -19,  -24,   74,        0,  -35,   61,
      19,  -46,   47,       38,  -56,   33,       57,  -67,   20,       76,  -78,    6,
     -55,   -4,  105,      -36,  -15,   92,      -16,  -25,   78,        2,  -36,   65,
      22,  -47,   51,       40,  -58,   37,       59,  -68,   24,       79,  -79,   10,
     -52,   -5,  109,      -33,  -16,   96,      -14,  -27,   82,        5,  -37,   69,
      24,  -48,   55,       43,  -59,   41,       62,  -70,   28,       81,  -81,   14,
     -50,   -7,  114,      -31,  -17,  100,      -11,  -28,   86,        7,  -39,   73,
      27,  -50,   59,       46,  -60,   46,       64,  -71,   32,       84,  -82,   19,
     -47,   -8,  118,      -28,  -19,  104,       -9,  -30,   90,       10,  -40,   77,
      29,  -51,   63,       48,  -62,   50,       67,  -72,   36,       86,  -83,   23,
     -45,  -10,  122,      -26,  -20,  108,       -7,  -31,   94,       12,  -42,   81,
      32,  -53,   67,       50,  -63,   54,       69,  -74,   40,       89,  -85,   27,
    -120,   37,   -6,     -101,   26,  -19,      -82,   15,  -33,      -63,    4,  -46,
     -44,   -6,  -60,      -25,  -16,  -73,       -6,  -27,  -87,       13,  -38, -101,
    -118,   35,   -2,      -99,   25,  -15,      -80,   14,  -29,      -61,    3,  -42,
     -41,   -7,  -56,      -23,  -18,  -69,       -4,  -28,  -83,       16,  -39,  -97,
    -115,   34,    1,      -96,   23,  -11,      -77,   12,  -25,      -58,    2,  -38,
     -39,   -8,  -52,      -20,  -19,  -65,       -1,  -29,  -79,       18,  -40,  -93,
    -113,   32,    6,      -94,   22,   -6,      -74,   11,  -20,      -56,    0,  -34,
     -36,  -10,  -47,      -17,  -20,  -61,        1,  -31,  -74,       21,  -42,  -88,
    -110,   31,   10,      -91,   20,   -2,      -72,    9,  -16,      -53,    0,  -30,
     -34,  -11,  -43,      -15,  -22,  -57,        4,  -32,  -70,       23,  -43,  -84,
    -108,   30,   14,      -89,   19,    1,      -70,    8,  -12,      -51,   -2,  -26,
     -31,  -12,  -39,      -13,  -23,  -53,        6,  -34,  -66,       25,  -45,  -80,
    -105,   28,   18,      -87,   18,    5,      -67,    7,   -8,      -48,   -3,  -22,
     -29,  -14,  -35,      -10,  -24,  -49,        8,  -35,  -62,       28,  -46,  -76,
    -103,   27,   22,      -84,   16,    9,      -65,    5,   -4,      -46,   -4,  -17,
     -26,  -15,  -31,       -8,  -26,  -44,       11,  -37,  -58,       31,  -47,  -72,
    -100,   25,   26,      -82,   15,   13,      -62,    4,    0,      -43,   -6,  -13,
     -24,  -17,  -27,       -5,  -27,  -40,       14,  -38,  -54,       33,  -49,  -68,
     -98,   24,   30,      -79,   13,   17,      -60,    2,    3,      -41,   -7,   -9,
     -22,  -18,  -23,       -3,  -29,  -36,       16,  -39,  -50,       35,  -50,  -64,
     -96,   23,   34,      -77,   12,   21,      -57,    1,    7,      -39,   -8,   -5,
     -19,  -19,  -19,        0,  -30,  -32,       18,  -41,  -46,       38,  -52,  -60,
     -93,   21,   38,      -74,   11,   25,      -55,    0,   11,      -36,  -10,   -1,
     -17,  -21,  -15,        2,  -31,  -28,       21,  -42,  -42,       40,  -53,  -56,
     -90,   20,   43,      -72,    9,   30,      -52,   -1,   16,      -34,  -11,    2,
     -14,  -22,  -10,        5,  -33,  -24,       23,  -43,  -37,       43,  -54,  -51,
     -88,   18,   47,      -69,    8,   34,      -50,   -2,   20,      -31,  -13,    6,
     -12,  -24,   -6,        7,  -34,  -20,       26,  -45,  -33,       45,  -56,  -47,
     -86,   17,   51,      -67,    6,   38,      -48,   -3,   24,      -29,  -14,   10,
      -9,  -25,   -2,        9,  -36,  -16,       28,  -46,  -29,       48,  -57,  -43,
     -83,   16,   55,      -65,    5,   42,      -45,   -5,   28,      -26,  -15,   14,
      -7,  -26,    1,       12,  -37,  -12,       31,  -48,  -25,       50,  -58,  -39,
     -81,   14,   59,      -62,    4,   46,      -42,   -6,   32,      -24,  -17,   19,
      -4,  -28,    5,       14,  -38,   -7,       33,  -49,  -21,       53,  -60,  -35,
     -78,   13,   63,      -59,    2,   50,      -40,   -8,   36,      -21,  -18,   23,
      -2,  -29,    9,       17,  -40,   -3,       36,  -50,  -17,       55,  -61,  -31,
     -76,   12,   67,      -57,    1,   54,      -38,   -9,   40,      -19,  -20,   27,
       0,  -31,   13,       19,  -41,    0,       38,  -52,  -13,       57,  -63,  -27,
     -73,   10,   71,      -55,    0,   58,      -35,  -10,   44,      -16,  -21,   31,
       3,  -32,   17,       22,  -42,    4,       40,  -53,   -9,       60,  -64,  -23,
     -71,    9,   76,      -52,   -1,   63,      -33,  -12,   49,      -14,  -22,   35,
       6,  -33,   22,       24,  -44,    8,       43,  -55,   -4,       63,  -66,  -18,
     -68,    7,   80,      -50,   -2,   67,      -30,  -13,   53,      -11,  -24,   39,
       8,  -35,   26,       27,  -45,   12,       46,  -56,    0,       65,  -67,  -14,
     -66,    6,   84,      -47,   -4,   71,      -28,  -15,   57,       -9,  -25,   43,
      10,  -36,   30,       29,  -47,   16,       48,  -57,    3,       67,  -68,  -10,
     -64,    5,   88,      -45,   -5,   75,      -25,  -16,   61,       -7,  -27,   47,
      13,  -37,   34,       32,  -48,   20,       50,  -59,    7,       70,  -70,   -6,
     -61,    3,   92,      -42,   -6,   79,      -23,  -17,   65,       -4,  -28,   51,
      15,  -39,   38,       34,  -49,   24,       53,  -60,   11,       72,  -71,   -2,
     -58,    2,   96,      -40,   -8,   83,      -20,  -19,   69,       -2,  -29,   56,
      18,  -40,   42,       37,  -51,   29,       55,  -62,   15,       75,  -72,    1,
     -56,    0,  100,      -37,   -9,   87,      -18,  -20,   73,        1,  -31,   60,
      20,  -42,   46,       39,  -52,   33,       58,  -63,   19,       77,  -74,    5,
     -54,    0,  104,      -35,  -11,   91,      -16,  -21,   77,        3,  -32,   64,
      23,  -43,   50,       41,  -54,   37,       60,  -64,   23,       80,  -75,    9,
     -51,   -1,  108,      -33,  -12,   95,      -13,  -23,   81,        6,  -33,   68,
      25,  -44,   54,       44,  -55,   41,       63,  -66,   27,       82,  -77,   13,
     -49,   -3,  113,      -30,  -13,  100,      -10,  -24,   86,        8,  -35,   72,
      28,  -46,   59,       46,  -56,   45,       65,  -67,   32,       85,  -78,   18,
     -46,   -4,  117,      -27,  -15,  104,       -8,  -26,   90,       11,  -36,   76,
      30,  -47,   63,       49,  -58,   49,       68,  -68,   36,       87,  -79,   22,
     -44,   -6,  121,      -25,  -16,  108,       -6,  -27,   94,       13,  -38,   80,
      32,  -49,   67,       51,  -59,   53,       70,  -70,   40,       89,  -81,   26,
    -119,   41,   -6,     -100,   30,  -20,      -81,   19,  -33,      -62,    8,  -47,
     -43,   -2,  -61,      -24,  -12,  -74,       -5,  -23,  -87,       14,  -34, -101,
    -117,   39,   -2,      -98,   29,  -16,      -79,   18,  -29,      -60,    7,  -43,
     -40,   -3,  -57,      -22,  -14,  -70,       -3,  -24,  -83,       16,  -35,  -97,
    -114,   38,    1,      -96,   27,  -12,      -76,   16,  -25,      -57,    6,  -39,
     -38,   -4,  -53,      -19,  -15,  -66,        0,  -25,  -79,       19,  -36,  -93,
    -112,   36,    5,      -93,   26,   -7,      -74,   15,  -21,      -55,    4,  -34,
     -35,   -6,  -48,      -17,  -16,  -61,        2,  -27,  -75,       22,  -38,  -89,
    -109,   35,    9,      -91,   24,   -3,      -71,   13,  -17,      -52,    3,  -30,
     -33,   -7,  -44,      -14,  -18,  -57,        5,  -28,  -71,       24,  -39,  -85,
    -107,   34,   13,      -88,   23,    0,      -69,   12,  -13,      -50,    1,  -26,
     -31,   -8,  -40,      -12,  -19,  -53,        7,  -30,  -67,       26,  -41,  -81,
    -105,   32,   17,      -86,   22,    4,      -66,   11,   -9,      -48,    0,  -22,
     -28,  -10,  -36,       -9,  -20,  -49,        9,  -31,  -63,       29,  -42,  -77,
    -102,   31,   22,      -83,   20,    8,      -64,    9,   -4,      -45,    0,  -18,
     -25,  -11,  -32,       -7,  -22,  -45,       12,  -33,  -58,       31,  -43,  -72,
     -99,   29,   26,      -81,   19,   12,      -61,    8,    0,      -42,   -2,  -14,
     -23,  -13,  -28,       -4,  -23,  -41,       14,  -34,  -54,       34,  -45,  -68,
     -97,   28,   30,      -78,   17,   16,      -59,    6,    3,      -40,   -3,  -10,
     -21,  -14,  -24,       -2,  -25,  -37,       17,  -35,  -50,       36,  -46,  -64,
     -95,   27,   34,      -76,   16,   20,      -56,    5,    7,      -38,   -4,   -6,
     -18,  -15,  -20,        0,  -26,  -33,       19,  -37,  -46,       39,  -48,  -60,
     -92,   25,   38,      -73,   15,   24,      -54,    4,   11,      -35,   -6,   -2,
     -16,  -17,  -16,        3,  -27,  -29,       22,  -38,  -42,       41,  -49,  -56,
     -90,   24,   42,      -71,   13,   29,      -51,    2,   15,      -33,   -7,    2,
     -13,  -18,  -11,        6,  -29,  -24,       24,  -39,  -38,       44,  -50,  -52,
     -87,   22,   46,      -68,   12,   33,      -49,    1,   19,      -30,   -9,    6,
     -11,  -20,   -7,        8,  -30,  -20,       27,  -41,  -34,       46,  -52,  -48,
     -85,   21,   50,      -66,   10,   37,      -47,    0,   23,      -28,  -10,   10,
      -8,  -21,   -3,       10,  -32,  -16,       29,  -42,  -30,       48,  -53,  -44,
     -82,   20,   54,      -64,    9,   41,      -44,   -1,   27,      -25,  -11,   14,
      -6,  -22,    0,       13,  -33,  -12,       32,  -44,  -26,       51,  -54,  -40,
     -80,   18,   59,      -61,    8,   45,      -42,   -2,   32,      -23,  -13,   18,
      -3,  -24,    4,       15,  -34,   -8,       34,  -45,  -21,       54,  -56,  -35,
     -77,   17,   63,      -59,    6,   49,      -39,   -4,   36,      -20,  -14,   22,
      -1,  -25,    8,       18,  -36,   -4,       37,  -46,  -17,       56,  -57,  -31,
     -75,   16,   67,      -56,    5,   53,      -37,   -5,   40,      -18,  -16,   26,
       1,  -27,   12,       20,  -37,    0,       39,  -48,  -13,       58,  -59,  -27,
     -73,   14,   71,      -54,    4,   57,      -34,   -6,   44,      -16,  -17,   30,
       4,  -28,   16,       23,  -38,    3,       41,  -49,   -9,       61,  -60,  -23,
     -70,   13,   75,      -51,    2,   62,      -32,   -8,   48,      -13,  -18,   35,
       6,  -29,   21,       25,  -40,    8,       44,  -51,   -5,       63,  -62,  -19,
     -67,   11,   79,      -49,    1,   66,      -29,   -9,   52,      -10,  -20,   39,
       9,  -31,   25,       28,  -41,   12,       46,  -52,   -1,       66,  -63,  -15,
     -65,   10,   83,      -46,    0,   70,      -27,  -11,   56,       -8,  -21,   43,
      11,  -32,   29,       30,  -43,   16,       49,  -53,    2,       68,  -64,  -11,
     -63,    9,   87,      -44,   -1,   74,      -24,  -12,   60,       -6,  -23,   47,
      14,  -33,   33,       32,  -44,   20,       51,  -55,    6,       71,  -66,   -7,
     -60,    7,   91,      -41,   -2,   78,      -22,  -13,   64,       -3,  -24,   51,
      16,  -35,   37,       35,  -45,   24,       54,  -56,   10,       73,  -67,   -3,
     -58,    6,   96,      -39,   -4,   82,      -19,  -15,   69,       -1,  -25,   55,
      19,  -36,   41,       38,  -47,   28,       56,  -58,   15,       76,  -68,    1,
     -55,    4,  100,      -36,   -5,   86,      -17,  -16,   73,        2,  -27,   59,
      21,  -38,   45,       40,  -48,   32,       59,  -59,   19,       78,  -70,    5,
     -53,    3,  104,      -34,   -7,   90,      -15,  -17,   77,        4,  -28,   63,
      24,  -39,   49,       42,  -50,   36,       61,  -60,   23,       80,  -71,    9,
     -50,    2,  108,      -32,   -8,   94,      -12,  -19,   81,        7,  -29,   67,
      26,  -40,   53,       45,  -51,   40,       63,  -62,   27,       83,  -73,   13,
     -48,    0,  112,      -29,   -9,   99,      -10,  -20,   85,        9,  -31,   72,
      29,  -42,   58,       47,  -52,   45,       66,  -63,   31,       86,  -74,   17,
     -45,    0,  116,      -27,  -11,  103,       -7,  -22,   89,       12,  -32,   76,
      31,  -43,   62,       50,  -54,   49,       69,  -64,   35,       88,  -75,   21,
     -43,   -2,  120,      -24,  -12,  107,       -5,  -23,   93,       14,  -34,   80,
      33,  -45,   66,       52,  -55,   53,       71,  -66,   39,       90,  -77,   25,
    -118,   45,   -7,      -99,   34,  -20,      -80,   23,  -34,      -61,   12,  -47,
     -42,    1,  -61,      -23,   -8,  -75,       -4,  -19,  -88,       15,  -30, -102,
    -116,   43,   -3,      -97,   33,  -16,      -78,   22,  -30,      -59,   11,  -43,
     -40,    0,  -57,      -21,  -10,  -71,       -2,  -20,  -84,       17,  -31,  -98,
    -113,   42,    0,      -95,   31,  -12,      -75,   20,  -26,      -57,   10,  -39,
     -37,    0,  -53,      -18,  -11,  -67,        0,  -21,  -80,       20,  -32,  -94,
    -111,   40,    5,      -92,   30,   -8,      -73,   19,  -22,      -54,    8,  -35,
     -34,   -2,  -49,      -16,  -12,  -62,        3,  -23,  -76,       22,  -34,  -89,
    -108,   39,    9,      -90,   28,   -4,      -70,   17,  -18,      -51,    7,  -31,
     -32,   -3,  -45,      -13,  -14,  -58,        6,  -24,  -72,       25,  -35,  -85,
    -106,   38,   13,      -87,   27,    0,      -68,   16,  -14,      -49,    5,  -27,
     -30,   -4,  -41,      -11,  -15,  -54,        8,  -26,  -68,       27,  -37,  -81,
    -104,   36,   17,      -85,   26,    3,      -65,   15,  -10,      -47,    4,  -23,
     -27,   -6,  -37,       -8,  -16,  -50,       10,  -27,  -64,       30,  -38,  -77,
    -101,   35,   21,      -82,   24,    8,      -63,   13,   -5,      -44,    3,  -18,
     -25,   -7,  -32,       -6,  -18,  -46,       13,  -29,  -59,       32,  -39,  -73,
     -99,   33,   25,      -80,   23,   12,      -60,   12,   -1,      -42,    1,  -14,
     -22,   -9,  -28,       -3,  -19,  -42,       15,  -30,  -55,       35,  -41,  -69,
     -96,   32,   29,      -77,   21,   16,      -58,   10,    2,      -39,    0,  -10,
     -20,  -10,  -24,       -1,  -21,  -38,       18,  -31,  -51,       37,  -42,  -65,
     -94,   31,   33,      -75,   20,   20,      -56,    9,    6,      -37,    0,   -6,
     -17,  -11,  -20,        1,  -22,  -34,       20,  -33,  -47,       40,  -44,  -61,
     -91,   29,   37,      -73,   19,   24,      -53,    8,   10,      -34,   -2,   -2,
     -15,  -13,  -16,        4,  -23,  -30,       23,  -34,  -43,       42,  -45,  -57,
     -89,   28,   42,      -70,   17,   28,      -50,    6,   14,      -32,   -3,    1,
     -12,  -14,  -12,        6,  -25,  -25,       25,  -35,  -39,       45,  -46,  -52,
     -86,   26,   46,      -67,   16,   32,      -48,    5,   18,      -29,   -5,    5,
     -10,  -16,   -8,        9,  -26,  -21,       28,  -37,  -35,       47,  -48,  -48,
     -84,   25,   50,      -65,   14,   36,      -46,    4,   22,      -27,   -6,    9,
      -8,  -17,   -4,       11,  -28,  -17,       30,  -38,  -31,       49,  -49,  -44,
     -81,   24,   54,      -63,   13,   40,      -43,    2,   26,      -25,   -7,   13,
      -5,  -18,    0,       14,  -29,  -13,       32,  -40,  -27,       52,  -50,  -40,
     -79,   22,   58,      -60,   12,   45,      -41,    1,   31,      -22,   -9,   18,
      -2,  -20,    4,       16,  -30,   -9,       35,  -41,  -22,       54,  -52,  -36,
     -76,   21,   62,      -58,   10,   49,      -38,    0,   35,      -19,  -10,   22,
       0,  -21,    8,       19,  -32,   -5,       37,  -42,  -18,       57,  -53,  -32,
     -74,   20,   66,      -55,    9,   53,      -36,   -1,   39,      -17,  -12,   26,
       2,  -23,   12,       21,  -33,   -1,       40,  -44,  -14,       59,  -55,  -28,
     -72,   18,   70,      -53,    8,   57,      -33,   -2,   43,      -15,  -13,   30,
       5,  -24,   16,       23,  -34,    2,       42,  -45,  -10,       62,  -56,  -24,
     -69,   17,   75,      -50,    6,   61,      -31,   -4,   47,      -12,  -14,   34,
       7,  -25,   20,       26,  -36,    7,       45,  -47,   -6,       64,  -58,  -19,
     -67,   15,   79,      -48,    5,   65,      -28,   -5,   51,      -10,  -16,   38,
      10,  -27,   24,       29,  -37,   11,       47,  -48,   -2,       67,  -59,  -15,
     -64,   14,   83,      -45,    3,   69,      -26,   -7,   55,       -7,  -17,   42,
      12,  -28,   28,       31,  -39,   15,       50,  -49,    1,       69,  -60,  -11,
     -62,   13,   87,      -43,    2,   73,      -24,   -8,   59,       -5,  -19,   46,
      15,  -29,   32,       33,  -40,   19,       52,  -51,    5,       72,  -62,   -7,
     -59,   11,   91,      -41,    1,   77,      -21,   -9,   63,       -2,  -20,   50,
      17,  -31,   36,       36,  -41,   23,       55,  -52,    9,       74,  -63,   -3,
     -57,   10,   95,      -38,    0,   82,      -18,  -11,   68,        0,  -21,   55,
      20,  -32,   41,       38,  -43,   27,       57,  -54,   14,       77,  -64,    0,
     -54,    8,   99,      -35,   -1,   86,      -16,  -12,   72,        3,  -23,   59,
      22,  -34,   45,       41,  -44,   31,       60,  -55,   18,       79,  -66,    4,
     -52,    7,  103,      -33,   -3,   90,      -14,  -13,   76,        5,  -24,   63,
      24,  -35,   49,       43,  -46,   35,       62,  -56,   22,       81,  -67,    8,
     -49,    6,  107,      -31,   -4,   94,      -11,  -15,   80,        7,  -25,   67,
      27,  -36,   53,       46,  -47,   39,       64,  -58,   26,       84,  -69,   12,
     -47,    4,  112,      -28,   -5,   98,       -9,  -16,   84,       10,  -27,   71,
      30,  -38,   57,       48,  -48,   44,       67,  -59,   30,       86,  -70,   17,
     -44,    3,  116,      -26,   -7,  102,       -6,  -18,   88,       13,  -28,   75,
      32,  -39,   61,       51,  -50,   48,       69,  -60,   34,       89,  -71,   21,
     -42,    1,  120,      -23,   -8,  106,       -4,  -19,   92,       15,  -30,   79,
      34,  -41,   65,       53,  -51,   52,       72,  -62,   38,       91,  -73,   25,
    -117,   49,   -8,      -98,   38,  -21,      -79,   27,  -35,      -60,   17,  -48,
     -41,    6,  -62,      -22,   -4,  -75,       -3,  -14,  -89,       16,  -25, -103,
    -115,   48,   -4,      -96,   37,  -17,      -77,   26,  -31,      -58,   16,  -44,
     -39,    5,  -58,      -20,   -5,  -71,       -1,  -16,  -85,       18,  -27,  -99,
    -112,   46,    0,      -94,   36,  -13,      -74,   25,  -27,      -55,   14,  -40,
     -36,    3,  -54,      -17,   -6,  -67,        1,  -17,  -81,       21,  -28,  -95,
    -110,   45,    4,      -91,   34,   -8,      -72,   23,  -22,      -53,   13,  -36,
     -33,    2,  -49,      -15,   -8,  -63,        4,  -18,  -76,       24,  -29,  -90,
    -107,   43,    8,      -89,   33,   -4,      -69,   22,  -18,      -50,   11,  -32,
     -31,    0,  -45,      -12,   -9,  -59,        7,  -20,  -72,       26,  -31,  -86,
    -105,   42,   12,      -86,   31,    0,      -67,   21,  -14,      -48,   10,  -28,
     -29,    0,  -41,      -10,  -11,  -55,        9,  -21,  -68,       28,  -32,  -82,
    -103,   41,   16,      -84,   30,    3,      -64,   19,  -10,      -46,    9,  -24,
     -26,   -1,  -37,       -7,  -12,  -51,       11,  -23,  -64,       31,  -33,  -78,
    -100,   39,   20,      -81,   29,    7,      -62,   18,   -6,      -43,    7,  -19,
     -24,   -3,  -33,       -5,  -13,  -46,       14,  -24,  -60,       33,  -35,  -74,
     -97,   38,   24,      -79,   27,   11,      -59,   16,   -2,      -41,    6,  -15,
     -21,   -4,  -29,       -2,  -15,  -42,       16,  -25,  -56,       36,  -36,  -70,
     -95,   37,   28,      -76,   26,   15,      -57,   15,    1,      -38,    4,  -11,
     -19,   -6,  -25,        0,  -16,  -38,       19,  -27,  -52,       38,  -38,  -66,
     -93,   35,   32,      -74,   25,   19,      -55,   14,    5,      -36,    3,   -7,
     -16,   -7,  -21,        2,  -18,  -34,       21,  -28,  -48,       41,  -39,  -62,
     -90,   34,   36,      -72,   23,   23,      -52,   12,    9,      -33,    2,   -3,
     -14,   -8,  -17,        5,  -19,  -30,       24,  -29,  -44,       43,  -40,  -58,
     -88,   32,   41,      -69,   22,   28,      -49,   11,   14,      -31,    0,    0,
     -11,  -10,  -12,        7,  -20,  -26,       26,  -31,  -39,       46,  -42,  -53,
     -85,   31,   45,      -66,   20,   32,      -47,    9,   18,      -28,    0,    4,
      -9,  -11,   -8,       10,  -22,  -22,       29,  -32,  -35,       48,  -43,  -49,
     -83,   30,   49,      -64,   19,   36,      -45,    8,   22,      -26,   -2,    8,
      -7,  -12,   -4,       12,  -23,  -18,       31,  -34,  -31,       50,  -45,  -45,
     -80,   28,   53,      -62,   18,   40,      -42,    7,   26,      -23,   -3,   12,
      -4,  -14,    0,       15,  -24,  -14,       33,  -35,  -27,       53,  -46,  -41,
     -78,   27,   57,      -59,   16,   44,      -40,    5,   30,      -21,   -4,   17,
      -1,  -15,    3,       17,  -26,   -9,       36,  -37,  -23,       56,  -47,  -37,
     -75,   25,   61,      -57,   15,   48,      -37,    4,   34,      -18,   -6,   21,
       1,  -17,    7,       20,  -27,   -5,       39,  -38,  -19,       58,  -49,  -33,
     -73,   24,   65,      -54,   13,   52,      -35,    2,   38,      -16,   -7,   25,
       3,  -18,   11,       22,  -29,   -1,       41,  -39,  -15,       60,  -50,  -29,
     -71,   23,   69,      -52,   12,   56,      -32,    1,   42,      -14,   -8,   29,
       6,  -19,   15,       25,  -30,    2,       43,  -41,  -11,       63,  -52,  -25,
     -68,   21,   74,      -49,   11,   61,      -30,    0,   47,      -11,  -10,   33,
       8,  -21,   20,       27,  -32,    6,       46,  -42,   -6,       65,  -53,  -20,
     -65,   20,   78,      -47,    9,   65,      -27,   -1,   51,       -9,  -11,   37,
      11,  -22,   24,       30,  -33,   10,       48,  -43,   -2,       68,  -54,  -16,
     -63,   18,   82,      -44,    8,   69,      -25,   -2,   55,       -6,  -13,   41,
      13,  -24,   28,       32,  -34,   14,       51,  -45,    1,       70,  -56,  -12,
     -61,   17,   86,      -42,    7,   73,      -23,   -3,   59,       -4,  -14,   45,
      16,  -25,   32,       34,  -36,   18,       53,  -46,    5,       73,  -57,   -8,
     -58,   16,   90,      -40,    5,   77,      -20,   -5,   63,       -1,  -15,   49,
      18,  -26,   36,       37,  -37,   22,       56,  -48,    9,       75,  -58,   -4,
     -56,   14,   94,      -37,    4,   81,      -17,   -6,   67,        1,  -17,   54,
      21,  -28,   40,       39,  -38,   27,       58,  -49,   13,       78,  -60,    0,
     -53,   13,   98,      -34,    2,   85,      -15,   -8,   71,        4,  -18,   58,
      23,  -29,   44,       42,  -40,   31,       61,  -50,   17,       80,  -61,    3,
     -51,   12,  102,      -32,    1,   89,      -13,   -9,   75,        6,  -20,   62,
      25,  -31,   48,       44,  -41,   35,       63,  -52,   21,       82,  -63,    7,
     -48,   10,  106,      -30,    0,   93,      -10,  -10,   79,        8,  -21,   66,
      28,  -32,   52,       47,  -42,   39,       65,  -53,   25,       85,  -64,   11,
     -46,    9,  111,      -27,   -1,   98,       -8,  -12,   84,       11,  -22,   70,
      31,  -33,   57,       49,  -44,   43,       68,  -55,   30,       87,  -66,   16,
     -43,    7,  115,      -25,   -2,  102,       -5,  -13,   88,       14,  -24,   74,
      33,  -35,   61,       52,  -45,   47,       71,  -56,   34,       90,  -67,   20,
     -41,    6,  119,      -22,   -4,  106,       -3,  -15,   92,       16,  -25,   78,
      35,  -36,   65,       54,  -47,   51,       73,  -57,   38,       92,  -68,   24,
    -116,   53,   -8,      -98,   42,  -22,      -78,   31,  -35,      -59,   21,  -49,
     -40,   10,  -63,      -21,    0,  -76,       -2,  -10,  -89,       17,  -21, -103,
    -114,   52,   -4,      -95,   41,  -18,      -76,   30,  -31,      -57,   20,  -45,
     -38,    9,  -59,      -19,   -1,  -72,        0,  -12,  -85,       19,  -23,  -99,
    -112,   50,    0,      -93,   40,  -14,      -73,   29,  -27,      -55,   18,  -41,
     -35,    7,  -55,      -16,   -2,  -68,        2,  -13,  -81,       22,  -24,  -95,
    -109,   49,    3,      -90,   38,   -9,      -71,   27,  -23,      -52,   17,  -36,
     -33,    6,  -50,      -14,   -4,  -64,        5,  -14,  -77,       24,  -25,  -91,
    -106,   47,    7,      -88,   37,   -5,      -68,   26,  -19,      -49,   15,  -32,
     -30,    4,  -46,      -11,   -5,  -60,        7,  -16,  -73,       27,  -27,  -87,
    -104,   46,   11,      -85,   35,   -1,      -66,   25,  -15,      -47,   14,  -28,
     -28,    3,  -42,       -9,   -7,  -56,       10,  -17,  -69,       29,  -28,  -83,
    -102,   45,   15,      -83,   34,    2,      -63,   23,  -11,      -45,   13,  -24,
     -25,    2,  -38,       -7,   -8,  -52,       12,  -19,  -65,       32,  -29,  -79,
     -99,   43,   20,      -80,   33,    6,      -61,   22,   -6,      -42,   11,  -20,
     -23,    0,  -34,       -4,   -9,  -47,       15,  -20,  -60,       34,  -31,  -74,
     -97,   42,   24,      -78,   31,   10,      -58,   20,   -2,      -40,   10,  -16,
     -20,    0,  -30,       -1,  -11,  -43,       17,  -21,  -56,       37,  -32,  -70,
     -94,   41,   28,      -75,   30,   14,      -56,   19,    1,      -37,    8,  -12,
     -18,   -2,  -26,        1,  -12,  -39,       20,  -23,  -52,       39,  -34,  -66,
     -92,   39,   32,      -73,   29,   18,      -54,   18,    5,      -35,    7,   -8,
     -15,   -3,  -22,        3,  -14,  -35,       22,  -24,  -48,       41,  -35,  -62,
     -89,   38,   36,      -71,   27,   22,      -51,   16,    9,      -32,    6,   -4,
     -13,   -4,  -18,        6,  -15,  -31,       24,  -25,  -44,       44,  -36,  -58,
     -87,   36,   40,      -68,   26,   27,      -49,   15,   13,      -30,    4,    0,
     -10,   -6,  -13,        8,  -16,  -27,       27,  -27,  -40,       47,  -38,  -54,
     -84,   35,   44,      -66,   24,   31,      -46,   13,   17,      -27,    3,    4,
      -8,   -7,   -9,       11,  -18,  -23,       30,  -28,  -36,       49,  -39,  -50,
     -82,   34,   48,      -63,   23,   35,      -44,   12,   21,      -25,    1,    8,
      -6,   -8,   -5,       13,  -19,  -19,       32,  -30,  -32,       51,  -41,  -46,
     -80,   32,   52,      -61,   22,   39,      -41,   11,   25,      -23,    0,   12,
      -3,  -10,   -1,       16,  -20,  -15,       34,  -31,  -28,       54,  -42,  -42,
     -77,   31,   57,      -58,   20,   43,      -39,    9,   30,      -20,    0,   16,
      -1,  -11,    2,       18,  -22,  -10,       37,  -33,  -23,       56,  -43,  -37,
     -74,   29,   61,      -56,   19,   47,      -36,    8,   34,      -18,   -2,   20,
       2,  -13,    6,       21,  -23,   -6,       39,  -34,  -19,       59,  -45,  -33,
     -72,   28,   65,      -53,   17,   51,      -34,    6,   38,      -15,   -3,   24,
       4,  -14,   10,       23,  -25,   -2,       42,  -35,  -15,       61,  -46,  -29,
     -70,   27,   69,      -51,   16,   55,      -32,    5,   42,      -13,   -4,   28,
       7,  -15,   14,       25,  -26,    1,       44,  -37,  -11,       64,  -48,  -25,
     -67,   25,   73,      -48,   15,   60,      -29,    4,   46,      -10,   -6,   33,
       9,  -17,   19,       28,  -28,    5,       47,  -38,   -7,       66,  -49,  -21,
     -65,   24,   77,      -46,   13,   64,      -26,    2,   50,       -8,   -7,   37,
      12,  -18,   23,       31,  -29,    9,       49,  -39,   -3,       69,  -50,  -17,
     -62,   22,   81,      -43,   12,   68,      -24,    1,   54,       -5,   -9,   41,
      14,  -20,   27,       33,  -30,   13,       52,  -41,    0,       71,  -52,  -13,
     -60,   21,   85,      -41,   11,   72,      -22,    0,   58,       -3,  -10,   45,
      17,  -21,   31,       35,  -32,   17,       54,  -42,    4,       73,  -53,   -9,
     -57,   20,   89,      -39,    9,   76,      -19,   -1,   62,        0,  -11,   49,
      19,  -22,   35,       38,  -33,   21,       56,  -44,    8,       76,  -54,   -5,
     -55,   18,   94,      -36,    8,   80,      -17,   -2,   67,        2,  -13,   53,
      22,  -24,   39,       40,  -34,   26,       59,  -45,   13,       79,  -56,    0,
     -52,   17,   98,      -34,    6,   84,      -14,   -4,   71,        5,  -14,   57,
      24,  -25,   43,       43,  -36,   30,       62,  -46,   17,       81,  -57,    3,
     -50,   16,  102,      -31,    5,   88,      -12,   -5,   75,        7,  -16,   61,
      26,  -27,   47,       45,  -37,   34,       64,  -48,   21,       83,  -59,    7,
     -48,   14,  106,      -29,    4,   92,       -9,   -6,   79,        9,  -17,   65,
      29,  -28,   51,       48,  -38,   38,       66,  -49,   25,       86,  -60,   11,
     -45,   13,  110,      -26,    2,   97,       -7,   -8,   83,       12,  -18,   70,
      31,  -29,   56,       50,  -40,   42,       69,  -51,   29,       88,  -62,   15,
     -42,   11,  114,      -24,    1,  101,       -4,   -9,   87,       14,  -20,   74,
      34,  -31,   60,       53,  -41,   46,       71,  -52,   33,       91,  -63,   19,
     -40,   10,  118,      -21,    0,  105,       -2,  -11,   91,       17,  -21,   78,
      36,  -32,   64,       55,  -43,   50,       74,  -53,   37,       93,  -64,   23,
    -115,   57,   -9,      -97,   46,  -22,      -77,   35,  -36,      -58,   25,  -49,
     -39,   14,  -63,      -20,    3,  -77,       -2,   -6,  -90,       18,  -17, -104,
    -113,   56,   -5,      -94,   45,  -18,      -75,   34,  -32,      -56,   24,  -45,
     -37,   13,  -59,      -18,    2,  -73,        1,   -8,  -86,       20,  -19, -100,
    -111,   54,   -1,      -92,   44,  -14,      -72,   33,  -28,      -54,   22,  -41,
     -34,   11,  -55,      -16,    1,  -69,        3,   -9,  -82,       23,  -20,  -96,
    -108,   53,    3,      -89,   42,  -10,      -70,   31,  -24,      -51,   21,  -37,
     -32,   10,  -51,      -13,    0,  -64,        6,  -10,  -78,       25,  -21,  -91,
    -106,   51,    7,      -87,   41,   -6,      -67,   30,  -20,      -49,   19,  -33,
     -29,    8,  -47,      -10,   -1,  -60,        8,  -12,  -74,       28,  -23,  -87,
    -103,   50,   11,      -84,   39,   -2,      -65,   29,  -16,      -46,   18,  -29,
     -27,    7,  -43,       -8,   -3,  -56,       11,  -13,  -70,       30,  -24,  -83,
    -101,   49,   15,      -82,   38,    1,      -63,   27,  -12,      -44,   17,  -25,
     -24,    6,  -39,       -6,   -4,  -52,       13,  -15,  -66,       33,  -25,  -79,
     -98,   47,   19,      -79,   37,    6,      -60,   26,   -7,      -41,   15,  -20,
     -22,    4,  -34,       -3,   -5,  -48,       16,  -16,  -61,       35,  -27,  -75,
     -96,   46,   23,      -77,   35,   10,      -58,   24,   -3,      -39,   14,  -16,
     -19,    3,  -30,       -1,   -7,  -44,       18,  -17,  -57,       38,  -28,  -71,
     -93,   45,   27,      -74,   34,   14,      -55,   23,    0,      -36,   12,  -12,
     -17,    1,  -26,        2,   -8,  -40,       21,  -19,  -53,       40,  -30,  -67,
     -91,   43,   31,      -72,   33,   18,      -53,   22,    4,      -34,   11,   -8,
     -15,    0,  -22,        4,  -10,  -36,       23,  -20,  -49,       42,  -31,  -63,
     -88,   42,   35,      -70,   31,   22,      -50,   20,    8,      -32,   10,   -4,
     -12,    0,  -18,        7,  -11,  -32,       25,  -21,  -45,       45,  -32,  -59,
     -86,   40,   40,      -67,   30,   26,      -48,   19,   12,      -29,    8,    0,
      -9,   -2,  -14,        9,  -12,  -27,       28,  -23,  -41,       47,  -34,  -54,
     -83,   39,   44,      -65,   28,   30,      -45,   17,   16,      -26,    7,    3,
      -7,   -3,  -10,       12,  -14,  -23,       30,  -24,  -37,       50,  -35,  -50,
     -81,   38,   48,      -62,   27,   34,      -43,   16,   20,      -24,    5,    7,
      -5,   -4,   -6,       14,  -15,  -19,       33,  -26,  -33,       52,  -37,  -46,
     -79,   36,   52,      -60,   26,   38,      -40,   15,   24,      -22,    4,   11,
      -2,   -6,   -2,       16,  -16,  -15,       35,  -27,  -29,       55,  -38,  -42,
     -76,   35,   56,      -57,   24,   43,      -38,   13,   29,      -19,    3,   16,
       0,   -7,    2,       19,  -18,  -11,       38,  -29,  -24,       57,  -39,  -38,
     -74,   33,   60,      -55,   23,   47,      -35,   12,   33,      -17,    1,   20,
       3,   -9,    6,       22,  -19,   -7,       40,  -30,  -20,       60,  -41,  -34,
     -71,   32,   64,      -52,   21,   51,      -33,   10,   37,      -14,    0,   24,
       5,  -10,   10,       24,  -21,   -3,       43,  -31,  -16,       62,  -42,  -30,
     -69,   31,   68,      -50,   20,   55,      -31,    9,   41,      -12,    0,   28,
       8,  -11,   14,       26,  -22,    0,       45,  -33,  -12,       65,  -44,  -26,
     -66,   29,   73,      -47,   19,   59,      -28,    8,   45,       -9,   -2,   32,
      10,  -13,   18,       29,  -24,    5,       48,  -34,   -8,       67,  -45,  -21,
     -64,   28,   77,      -45,   17,   63,      -26,    6,   49,       -7,   -3,   36,
      13,  -14,   22,       31,  -25,    9,       50,  -35,   -4,       70,  -46,  -17,
     -61,   26,   81,      -42,   16,   67,      -23,    5,   53,       -4,   -5,   40,
      15,  -16,   26,       34,  -26,   13,       53,  -37,    0,       72,  -48,  -13,
     -59,   25,   85,      -40,   15,   71,      -21,    4,   57,       -2,   -6,   44,
      17,  -17,   30,       36,  -28,   17,       55,  -38,    3,       74,  -49,   -9,
     -56,   24,   89,      -38,   13,   75,      -18,    2,   61,        0,   -7,   48,
      20,  -18,   34,       39,  -29,   21,       57,  -40,    7,       77,  -50,   -5,
     -54,   22,   93,      -35,   12,   80,      -16,    1,   66,        3,   -9,   53,
      23,  -20,   39,       41,  -30,   25,       60,  -41,   12,       79,  -52,   -1,
     -51,   21,   97,      -33,   10,   84,      -13,    0,   70,        6,  -10,   57,
      25,  -21,   43,       44,  -32,   29,       62,  -42,   16,       82,  -53,    2,
     -49,   20,  101,      -30,    9,   88,      -11,   -1,   74,        8,  -12,   61,
      27,  -23,   47,       46,  -33,   33,       65,  -44,   20,       84,  -55,    6,
     -47,   18,  105,      -28,    8,   92,       -8,   -2,   78,       10,  -13,   65,
      30,  -24,   51,       48,  -34,   37,       67,  -45,   24,       87,  -56,   10,
     -44,   17,  110,      -25,    6,   96,       -6,   -4,   82,       13,  -14,   69,
      32,  -25,   55,       51,  -36,   42,       70,  -47,   28,       89,  -58,   15,
     -42,   15,  114,      -23,    5,  100,       -3,   -5,   86,       15,  -16,   73,
      35,  -27,   59,       54,  -37,   46,       72,  -48,   32,       92,  -59,   19,
     -39,   14,  118,      -20,    3,  104,       -1,   -7,   90,       18,  -17,   77,
      37,  -28,   63,       56,  -39,   50,       75,  -49,   36,       94,  -60,   23,
    -114,   61,  -10,      -96,   50,  -23,      -76,   39,  -37,      -58,   29,  -50,
     -38,   18,  -64,      -19,    7,  -77,       -1,   -2,  -91,       19,  -13, -105,
    -112,   60,   -6,      -93,   49,  -19,      -74,   38,  -33,      -55,   28,  -46,
     -36,   17,  -60,      -17,    6,  -73,        2,   -4,  -87,       21,  -15, -101,
    -110,   58,   -2,      -91,   48,  -15,      -72,   37,  -29,      -53,   26,  -42,
     -33,   15,  -56,      -15,    5,  -69,        4,   -5,  -83,       24,  -16,  -97,
    -107,   57,    2,      -88,   46,  -10,      -69,   35,  -24,      -50,   25,  -38,
     -31,   14,  -51,      -12,    3,  -65,        7,   -6,  -78,       26,  -17,  -92,
    -105,   55,    6,      -86,   45,   -6,      -66,   34,  -20,      -48,   23,  -34,
     -28,   12,  -47,      -10,    2,  -61,        9,   -8,  -74,       29,  -19,  -88,
    -102,   54,   10,      -83,   43,   -2,      -64,   33,  -16,      -45,   22,  -30,
     -26,   11,  -43,       -7,    0,  -57,       12,   -9,  -70,       31,  -20,  -84,
    -100,   53,   14,      -81,   42,    1,      -62,   31,  -12,      -43,   21,  -26,
     -24,   10,  -39,       -5,    0,  -53,       14,  -11,  -66,       33,  -21,  -80,
     -97,   51,   18,      -78,   41,    5,      -59,   30,   -8,      -40,   19,  -21,
     -21,    8,  -35,       -2,   -1,  -48,       17,  -12,  -62,       36,  -23,  -76,
     -95,   50,   22,      -76,   39,    9,      -57,   28,   -4,      -38,   18,  -17,
     -18,    7,  -31,        0,   -3,  -44,       19,  -13,  -58,       39,  -24,  -72,
     -92,   49,   26,      -74,   38,   13,      -54,   27,    0,      -35,   16,  -13,
     -16,    5,  -27,        3,   -4,  -40,       22,  -15,  -54,       41,  -26,  -68,
     -90,   47,   30,      -71,   37,   17,      -52,   26,    3,      -33,   15,   -9,
     -14,    4,  -23,        5,   -6,  -36,       24,  -16,  -50,       43,  -27,  -64,
     -88,   46,   34,      -69,   35,   21,      -49,   24,    7,      -31,   14,   -5,
     -11,    3,  -19,        8,   -7,  -32,       26,  -17,  -46,       46,  -28,  -60,
     -85,   44,   39,      -66,   34,   26,      -47,   23,   12,      -28,   12,   -1,
      -9,    1,  -14,       10,   -8,  -28,       29,  -19,  -41,       48,  -30,  -55,
     -82,   43,   43,      -64,   32,   30,      -44,   21,   16,      -26,   11,    2,
      -6,    0,  -10,       13,  -10,  -24,       31,  -20,  -37,       51,  -31,  -51,
     -80,   42,   47,      -61,   31,   34,      -42,   20,   20,      -23,    9,    6,
      -4,    0,   -6,       15,  -11,  -20,       34,  -22,  -33,       53,  -33,  -47,
     -78,   40,   51,      -59,   30,   38,      -40,   19,   24,      -21,    8,   10,
      -1,   -2,   -2,       17,  -12,  -16,       36,  -23,  -29,       56,  -34,  -43,
     -75,   39,   55,      -56,   28,   42,      -37,   17,   28,      -18,    7,   15,
       1,   -3,    1,       20,  -14,  -11,       39,  -25,  -25,       58,  -35,  -39,
     -73,   37,   59,      -54,   27,   46,      -34,   16,   32,      -16,    5,   19,
       4,   -5,    5,       22,  -15,   -7,       41,  -26,  -21,       61,  -37,  -35,
     -70,   36,   63,      -51,   25,   50,      -32,   14,   36,      -13,    4,   23,
       6,   -6,    9,       25,  -17,   -3,       44,  -27,  -17,       63,  -38,  -31,
     -68,   35,   67,      -49,   24,   54,      -30,   13,   40,      -11,    3,   27,
       8,   -7,   13,       27,  -18,    0,       46,  -29,  -13,       65,  -40,  -27,
     -65,   33,   72,      -46,   23,   59,      -27,   12,   45,       -8,    1,   31,
      11,   -9,   18,       30,  -20,    4,       49,  -30,   -8,       68,  -41,  -22,
     -63,   32,   76,      -44,   21,   63,      -25,   10,   49,       -6,    0,   35,
      14,  -10,   22,       32,  -21,    8,       51,  -31,   -4,       70,  -42,  -18,
     -60,   30,   80,      -42,   20,   67,      -22,    9,   53,       -3,   -1,   39,
      16,  -12,   26,       35,  -22,   12,       54,  -33,    0,       73,  -44,  -14,
     -58,   29,   84,      -39,   19,   71,      -20,    8,   57,       -1,   -2,   43,
      18,  -13,   30,       37,  -24,   16,       56,  -34,    3,       75,  -45,  -10,
     -56,   28,   88,      -37,   17,   75,      -17,    6,   61,        1,   -3,   47,
      21,  -14,   34,       40,  -25,   20,       58,  -36,    7,       78,  -46,   -6,
     -53,   26,   92,      -34,   16,   79,      -15,    5,   65,        4,   -5,   52,
      23,  -16,   38,       42,  -26,   25,       61,  -37,   11,       80,  -48,   -2,
     -50,   25,   96,      -32,   14,   83,      -12,    3,   69,        6,   -6,   56,
      26,  -17,   42,       45,  -28,   29,       63,  -38,   15,       83,  -49,    1,
     -48,   24,  100,      -29,   13,   87,      -10,    2,   73,        9,   -8,   60,
      28,  -19,   46,       47,  -29,   33,       66,  -40,   19,       85,  -51,    5,
     -46,   22,  104,      -27,   12,   91,       -8,    1,   77,       11,   -9,   64,
      31,  -20,   50,       49,  -30,   37,       68,  -41,   23,       88,  -52,    9,
     -43,   21,  109,      -24,   10,   96,       -5,    0,   82,       14,  -10,   68,
      33,  -21,   55,       52,  -32,   41,       71,  -43,   28,       90,  -54,   14,
     -41,   19,  113,      -22,    9,  100,       -2,   -1,   86,       16,  -12,   72,
      36,  -23,   59,       54,  -33,   45,       73,  -44,   32,       93,  -55,   18,
     -38,   18,  117,      -19,    7,  104,        0,   -3,   90,       19,  -13,   76,
      38,  -24,   63,       57,  -35,   49,       76,  -45,   36,       95,  -56,   22,
    -113,   66,  -10,      -95,   55,  -24,      -75,   44,  -37,      -57,   33,  -51,
     -37,   22,  -65,      -18,   12,  -78,        0,    1,  -91,       20,   -9, -105,
    -111,   64,   -6,      -92,   54,  -20,      -73,   43,  -33,      -54,   32,  -47,
     -35,   21,  -61,      -16,   10,  -74,        3,    0,  -87,       22,  -10, -101,
    -109,   63,   -2,      -90,   52,  -16,      -71,   41,  -29,      -52,   31,  -43,
     -32,   20,  -57,      -14,    9,  -70,        5,    0,  -83,       25,  -11,  -97,
    -106,   61,    1,      -87,   51,  -11,      -68,   40,  -25,      -49,   29,  -38,
     -30,   18,  -52,      -11,    8,  -66,        8,   -2,  -79,       27,  -13,  -93,
    -104,   60,    5,      -85,   49,   -7,      -65,   38,  -21,      -47,   28,  -34,
     -27,   17,  -48,       -8,    6,  -62,       10,   -3,  -75,       30,  -14,  -89,
    -101,   59,    9,      -82,   48,   -3,      -63,   37,  -17,      -44,   26,  -30,
     -25,   16,  -44,       -6,    5,  -58,       13,   -5,  -71,       32,  -16,  -85,
     -99,   57,   13,      -80,   47,    0,      -61,   36,  -13,      -42,   25,  -26,
     -22,   14,  -40,       -4,    4,  -54,       15,   -6,  -67,       34,  -17,  -81,
     -96,   56,   18,      -77,   45,    4,      -58,   34,   -8,      -39,   24,  -22,
     -20,   13,  -36,       -1,    2,  -49,       18,   -8,  -62,       37,  -18,  -76,
     -94,   54,   22,      -75,   44,    8,      -56,   33,   -4,      -37,   22,  -18,
     -17,   11,  -32,        1,    1,  -45,       20,   -9,  -58,       40,  -20,  -72,
     -91,   53,   26,      -73,   42,   12,      -53,   31,    0,      -34,   21,  -14,
     -15,   10,  -28,        4,    0,  -41,       23,  -10,  -54,       42,  -21,  -68,
     -89,   52,   30,      -70,   41,   16,      -51,   30,    3,      -32,   20,  -10,
     -13,    9,  -24,        6,   -1,  -37,       25,  -12,  -50,       44,  -23,  -64,
     -87,   50,   34,      -68,   40,   20,      -48,   29,    7,      -30,   18,   -6,
     -10,    7,  -20,        9,   -2,  -33,       27,  -13,  -46,       47,  -24,  -60,
     -84,   49,   38,      -65,   38,   25,      -46,   27,   11,      -27,   17,   -1,
      -8,    6,  -15,       11,   -4,  -29,       30,  -14,  -42,       49,  -25,  -56,
     -81,   47,   42,      -63,   37,   29,      -43,   26,   15,      -25,   15,    2,
      -5,    4,  -11,       14,   -5,  -25,       32,  -16,  -38,       52,  -27,  -52,
     -79,   46,   46,      -60,   35,   33,      -41,   25,   19,      -22,   14,    6,
      -3,    3,   -7,       16,   -7,  -21,       35,  -17,  -34,       54,  -28,  -48,
     -77,   45,   50,      -58,   34,   37,      -39,   23,   23,      -20,   13,   10,
       0,    2,   -3,       18,   -8,  -17,       37,  -19,  -30,       57,  -29,  -44,
     -74,   43,   55,      -55,   33,   41,      -36,   22,   28,      -17,   11,   14,
       2,    0,    0,       21,   -9,  -12,       40,  -20,  -25,       59,  -31,  -39,
     -72,   42,   59,      -53,   31,   45,      -33,   20,   32,      -15,   10,   18,
       5,    0,    4,       24,  -11,   -8,       42,  -21,  -21,       62,  -32,  -35,
     -69,   41,   63,      -50,   30,   49,      -31,   19,   36,      -12,    8,   22,
       7,   -2,    8,       26,  -12,   -4,       45,  -23,  -17,       64,  -34,  -31,
     -67,   39,   67,      -48,   29,   53,      -29,   18,   40,      -10,    7,   26,
      10,   -3,   12,       28,  -13,    0,       47,  -24,  -13,       66,  -35,  -27,
     -64,   38,   71,      -45,   27,   58,      -26,   16,   44,       -7,    6,   31,
      12,   -4,   17,       31,  -15,    3,       50,  -26,   -9,       69,  -37,  -23,
     -62,   36,   75,      -43,   26,   62,      -24,   15,   48,       -5,    4,   35,
      15,   -6,   21,       33,  -16,    7,       52,  -27,   -5,       72,  -38,  -19,
     -59,   35,   79,      -41,   24,   66,      -21,   13,   52,       -2,    3,   39,
      17,   -7,   25,       36,  -18,   11,       55,  -28,   -1,       74,  -39,  -15,
     -57,   34,   83,      -38,   23,   70,      -19,   12,   56,        0,    1,   43,
      19,   -8,   29,       38,  -19,   15,       57,  -30,    2,       76,  -41,  -11,
     -55,   32,   87,      -36,   22,   74,      -16,   11,   60,        2,    0,   47,
      22,  -10,   33,       41,  -20,   19,       59,  -31,    6,       79,  -42,   -7,
     -52,   31,   92,      -33,   20,   78,      -14,    9,   65,        5,    0,   51,
      24,  -11,   37,       43,  -22,   24,       62,  -33,   11,       81,  -43,   -2,
     -49,   29,   96,      -31,   19,   82,      -11,    8,   69,        7,   -2,   55,
      27,  -13,   41,       46,  -23,   28,       64,  -34,   15,       84,  -45,    1,
     -47,   28,  100,      -28,   17,   86,       -9,    7,   73,       10,   -3,   59,
      29,  -14,   45,       48,  -25,   32,       67,  -35,   19,       86,  -46,    5,
     -45,   27,  104,      -26,   16,   90,       -7,    5,   77,       12,   -4,   63,
      32,  -15,   49,       50,  -26,   36,       69,  -37,   23,       89,  -48,    9,
     -42,   25,  108,      -23,   15,   95,       -4,    4,   81,       15,   -6,   68,
      34,  -17,   54,       53,  -27,   40,       72,  -38,   27,       91,  -49,   13,
     -40,   24,  112,      -21,   13,   99,       -1,    2,   85,       17,   -7,   72,
      37,  -18,   58,       55,  -29,   44,       74,  -39,   31,       94,  -50,   17,
     -37,   22,  116,      -18,   12,  103,        1,    1,   89,       20,   -9,   76,
      39,  -20,   62,       58,  -30,   48,       77,  -41,   35,       96,  -52,   21,
    -113,   70,  -11,      -94,   59,  -24,      -74,   48,  -38,      -56,   37,  -51,
     -36,   26,  -65,      -17,   16,  -79,        1,    5,  -92,       21,   -5, -106,
    -110,   68,   -7,      -91,   58,  -20,      -72,   47,  -34,      -53,   36,  -47,
     -34,   25,  -61,      -15,   14,  -75,        4,    4,  -88,       23,   -6, -102,
    -108,   67,   -3,      -89,   56,  -16,      -70,   45,  -30,      -51,   35,  -43,
     -31,   24,  -57,      -13,   13,  -71,        6,    3,  -84,       25,   -7,  -98,
    -105,   65,    1,      -86,   55,  -12,      -67,   44,  -26,      -48,   33,  -39,
     -29,   22,  -53,      -10,   12,  -66,        9,    1,  -80,       28,   -9,  -93,
    -103,   64,    5,      -84,   53,   -8,      -65,   42,  -22,      -46,   32,  -35,
     -26,   21,  -49,       -8,   10,  -62,       11,    0,  -76,       31,  -10,  -89,
    -100,   63,    9,      -81,   52,   -4,      -62,   41,  -18,      -43,   30,  -31,
     -24,   20,  -45,       -5,    9,  -58,       14,   -1,  -72,       33,  -12,  -85,
     -98,   61,   13,      -79,   51,    0,      -60,   40,  -14,      -41,   29,  -27,
     -22,   18,  -41,       -3,    8,  -54,       16,   -2,  -68,       35,  -13,  -81,
     -95,   60,   17,      -76,   49,    4,      -57,   38,   -9,      -38,   28,  -22,
     -19,   17,  -36,        0,    6,  -50,       19,   -4,  -63,       38,  -14,  -77,
     -93,   58,   21,      -74,   48,    8,      -55,   37,   -5,      -36,   26,  -18,
     -16,   15,  -32,        2,    5,  -46,       21,   -5,  -59,       40,  -16,  -73,
     -90,   57,   25,      -72,   46,   12,      -52,   35,   -1,      -33,   25,  -14,
     -14,   14,  -28,        5,    3,  -42,       23,   -6,  -55,       43,  -17,  -69,
     -88,   56,   29,      -69,   45,   16,      -50,   34,    2,      -31,   24,  -10,
     -12,   13,  -24,        7,    2,  -38,       26,   -8,  -51,       45,  -19,  -65,
     -86,   54,   33,      -67,   44,   20,      -47,   33,    6,      -29,   22,   -6,
      -9,   11,  -20,        9,    1,  -34,       28,   -9,  -47,       48,  -20,  -61,
     -83,   53,   38,      -64,   42,   24,      -45,   31,   10,      -26,   21,   -2,
      -7,   10,  -16,       12,    0,  -29,       31,  -10,  -43,       50,  -21,  -56,
     -81,   51,   42,      -62,   41,   28,      -42,   30,   14,      -24,   19,    1,
      -4,    8,  -12,       15,   -1,  -25,       33,  -12,  -39,       53,  -23,  -52,
     -78,   50,   46,      -59,   39,   32,      -40,   29,   18,      -21,   18,    5,
      -2,    7,   -8,       17,   -3,  -21,       36,  -13,  -35,       55,  -24,  -48,
     -76,   49,   50,      -57,   38,   36,      -38,   27,   22,      -19,   17,    9,
       1,    6,   -4,       19,   -4,  -17,       38,  -15,  -31,       57,  -25,  -44,
     -73,   47,   54,      -54,   37,   41,      -35,   26,   27,      -16,   15,   14,
       3,    4,    0,       22,   -5,  -13,       41,  -16,  -26,       60,  -27,  -40,
     -71,   46,   58,      -52,   35,   45,      -33,   24,   31,      -14,   14,   18,
       6,    3,    4,       24,   -7,   -9,       43,  -17,  -22,       63,  -28,  -36,
     -68,   45,   62,      -50,   34,   49,      -30,   23,   35,      -11,   12,   22,
       8,    1,    8,       27,   -8,   -5,       46,  -19,  -18,       65,  -30,  -32,
     -66,   43,   66,      -47,   33,   53,      -28,   22,   39,       -9,   11,   26,
      10,    0,   12,       29,   -9,   -1,       48,  -20,  -14,       67,  -31,  -28,
     -63,   42,   71,      -44,   31,   57,      -25,   20,   43,       -6,   10,   30,
      13,    0,   16,       32,  -11,    3,       51,  -22,  -10,       70,  -33,  -23,
     -61,   40,   75,      -42,   30,   61,      -23,   19,   47,       -4,    8,   34,
      15,   -2,   20,       34,  -12,    7,       53,  -23,   -6,       72,  -34,  -19,
     -58,   39,   79,      -40,   28,   65,      -20,   17,   51,       -1,    7,   38,
      18,   -3,   24,       37,  -14,   11,       55,  -24,   -2,       75,  -35,  -15,
     -56,   38,   83,      -37,   27,   69,      -18,   16,   55,        1,    5,   42,
      20,   -4,   28,       39,  -15,   15,       58,  -26,    1,       77,  -37,  -11,
     -54,   36,   87,      -35,   26,   73,      -15,   15,   59,        3,    4,   46,
      23,   -6,   32,       41,  -16,   19,       60,  -27,    5,       80,  -38,   -7,
     -51,   35,   91,      -32,   24,   78,      -13,   13,   64,        6,    3,   51,
      25,   -7,   37,       44,  -18,   23,       63,  -29,   10,       82,  -39,   -3,
     -49,   33,   95,      -30,   23,   82,      -10,   12,   68,        8,    1,   55,
      28,   -9,   41,       47,  -19,   27,       65,  -30,   14,       85,  -41,    0,
     -46,   32,   99,      -27,   21,   86,       -8,   11,   72,       11,    0,   59,
      30,  -10,   45,       49,  -21,   31,       68,  -31,   18,       87,  -42,    4,
     -44,   31,  103,      -25,   20,   90,       -6,    9,   76,       13,    0,   63,
      33,  -11,   49,       51,  -22,   35,       70,  -33,   22,       89,  -44,    8,
     -41,   29,  108,      -22,   19,   94,       -3,    8,   80,       16,   -2,   67,
      35,  -13,   53,       54,  -23,   40,       73,  -34,   26,       92,  -45,   13,
     -39,   28,  112,      -20,   17,   98,       -1,    6,   84,       18,   -3,   71,
      38,  -14,   57,       56,  -25,   44,       75,  -35,   30,       95,  -46,   17,
     -36,   26,  116,      -18,   16,  102,        2,    5,   88,       21,   -5,   75,
      40,  -16,   61,       59,  -26,   48,       78,  -37,   34,       97,  -48,   21,
    -112,   74,  -12,      -93,   63,  -25,      -73,   52,  -39,      -55,   41,  -52,
     -35,   30,  -66,      -17,   20,  -79,        2,    9,  -93,       22,   -1, -107,
    -109,   72,   -8,      -90,   62,  -21,      -71,   51,  -35,      -52,   40,  -48,
     -33,   29,  -62,      -14,   18,  -75,        5,    8,  -89,       24,   -2, -103,
    -107,   71,   -4,      -88,   60,  -17,      -69,   49,  -31,      -50,   39,  -44,
     -31,   28,  -58,      -12,   17,  -71,        7,    7,  -85,       26,   -3,  -99,
    -104,   69,    0,      -85,   59,  -12,      -66,   48,  -26,      -47,   37,  -40,
     -28,   26,  -53,       -9,   16,  -67,       10,    5,  -80,       29,   -5,  -94,
    -102,   68,    4,      -83,   57,   -8,      -64,   46,  -22,      -45,   36,  -36,
     -25,   25,  -49,       -7,   14,  -63,       12,    4,  -76,       31,   -6,  -90,
     -99,   67,    8,      -81,   56,   -4,      -61,   45,  -18,      -42,   34,  -32,
     -23,   24,  -45,       -4,   13,  -59,       15,    2,  -72,       34,   -8,  -86,
     -97,   65,   12,      -78,   55,    0,      -59,   44,  -14,      -40,   33,  -28,
     -21,   22,  -41,       -2,   12,  -55,       17,    1,  -68,       36,   -9,  -82,
     -94,   64,   16,      -76,   53,    3,      -56,   42,  -10,      -37,   32,  -23,
     -18,   21,  -37,        1,   10,  -50,       20,    0,  -64,       39,  -10,  -78,
     -92,   62,   20,      -73,   52,    7,      -54,   41,   -6,      -35,   30,  -19,
     -16,   19,  -33,        3,    9,  -46,       22,   -1,  -60,       41,  -12,  -74,
     -90,   61,   24,      -71,   50,   11,      -51,   39,   -2,      -33,   29,  -15,
     -13,   18,  -29,        6,    7,  -42,       24,   -2,  -56,       44,  -13,  -70,
     -87,   60,   28,      -68,   49,   15,      -49,   38,    1,      -30,   28,  -11,
     -11,   17,  -25,        8,    6,  -38,       27,   -4,  -52,       46,  -15,  -66,
     -85,   58,   32,      -66,   48,   19,      -47,   37,    5,      -28,   26,   -7,
      -8,   15,  -21,       10,    5,  -34,       29,   -5,  -48,       49,  -16,  -62,
     -82,   57,   37,      -63,   46,   24,      -44,   35,   10,      -25,   25,   -3,
      -6,   14,  -16,       13,    3,  -30,       32,   -6,  -43,       51,  -17,  -57,
     -80,   55,   41,      -61,   45,   28,      -41,   34,   14,      -23,   23,    0,
      -3,   12,  -12,       15,    2,  -26,       34,   -8,  -39,       54,  -19,  -53,
     -77,   54,   45,      -58,   43,   32,      -39,   33,   18,      -20,   22,    4,
      -1,   11,   -8,       18,    0,  -22,       37,   -9,  -35,       56,  -20,  -49,
     -75,   53,   49,      -56,   42,   36,      -37,   31,   22,      -18,   21,    8,
       1,   10,   -4,       20,    0,  -18,       39,  -11,  -31,       58,  -21,  -45,
     -72,   51,   53,      -53,   41,   40,      -34,   30,   26,      -15,   19,   13,
       4,    8,    0,       23,   -1,  -13,       42,  -12,  -27,       61,  -23,  -41,
     -70,   50,   57,      -51,   39,   44,      -32,   28,   30,      -13,   18,   17,
       7,    7,    3,       25,   -3,   -9,       44,  -13,  -23,       63,  -24,  -37,
     -67,   49,   61,      -49,   38,   48,      -29,   27,   34,      -10,   16,   21,
       9,    5,    7,       28,   -4,   -5,       47,  -15,  -19,       66,  -26,  -33,
     -65,   47,   65,      -46,   37,   52,      -27,   26,   38,       -8,   15,   25,
      11,    4,   11,       30,   -5,   -1,       49,  -16,  -15,       68,  -27,  -29,
     -62,   46,   70,      -44,   35,   57,      -24,   24,   43,       -5,   14,   29,
      14,    3,   16,       33,   -7,    2,       52,  -18,  -10,       71,  -29,  -24,
     -60,   44,   74,      -41,   34,   61,      -22,   23,   47,       -3,   12,   33,
      16,    1,   20,       35,   -8,    6,       54,  -19,   -6,       73,  -30,  -20,
     -58,   43,   78,      -39,   32,   65,      -19,   21,   51,       -1,   11,   37,
      19,    0,   24,       38,  -10,   10,       56,  -20,   -2,       76,  -31,  -16,
     -55,   42,   82,      -36,   31,   69,      -17,   20,   55,        2,    9,   41,
      21,    0,   28,       40,  -11,   14,       59,  -22,    1,       78,  -33,  -12,
     -53,   40,   86,      -34,   30,   73,      -15,   19,   59,        4,    8,   45,
      24,   -2,   32,       42,  -12,   18,       61,  -23,    5,       81,  -34,   -8,
     -50,   39,   90,      -31,   28,   77,      -12,   17,   63,        7,    7,   50,
      26,   -3,   36,       45,  -14,   23,       64,  -25,    9,       83,  -35,   -4,
     -48,   37,   94,      -29,   27,   81,       -9,   16,   67,        9,    5,   54,
      29,   -5,   40,       47,  -15,   27,       66,  -26,   13,       86,  -37,    0,
     -45,   36,   98,      -26,   25,   85,       -7,   15,   71,       12,    4,   58,
      31,   -6,   44,       50,  -17,   31,       69,  -27,   17,       88,  -38,    3,
     -43,   35,  102,      -24,   24,   89,       -5,   13,   75,       14,    3,   62,
      33,   -7,   48,       52,  -18,   35,       71,  -29,   21,       90,  -40,    7,
     -40,   33,  107,      -21,   23,   94,       -2,   12,   80,       17,    1,   66,
      36,   -9,   53,       55,  -19,   39,       74,  -30,   26,       93,  -41,   12,
     -38,   32,  111,      -19,   21,   98,        0,   10,   84,       19,    0,   70,
      39,  -10,   57,       57,  -21,   43,       76,  -31,   30,       95,  -42,   16,
     -35,   30,  115,      -17,   20,  102,        3,    9,   88,       22,   -1,   74,
      41,  -12,   61,       60,  -22,   47,       78,  -33,   34,       98,  -44,   20,
    -111,   78,  -12,      -92,   67,  -26,      -73,   56,  -39,      -54,   45,  -53,
     -34,   34,  -67,      -16,   24,  -80,        3,   13,  -93,       23,    2, -107,
    -108,   76,   -8,      -90,   66,  -22,      -70,   55,  -35,      -51,   44,  -49,
     -32,   33,  -63,      -13,   22,  -76,        6,   12,  -89,       25,    1, -103,
    -106,   75,   -4,      -87,   64,  -18,      -68,   53,  -31,      -49,   43,  -45,
     -30,   32,  -59,      -11,   21,  -72,        8,   11,  -85,       27,    0,  -99,
    -103,   73,    0,      -84,   63,  -13,      -65,   52,  -27,      -46,   41,  -40,
     -27,   30,  -54,       -8,   20,  -68,       11,    9,  -81,       30,   -1,  -95,
    -101,   72,    3,      -82,   61,   -9,      -63,   50,  -23,      -44,   40,  -36,
     -25,   29,  -50,       -6,   18,  -64,       13,    8,  -77,       32,   -2,  -91,
     -98,   71,    7,      -80,   60,   -5,      -60,   49,  -19,      -42,   38,  -32,
     -22,   28,  -46,       -3,   17,  -60,       15,    6,  -73,       35,   -4,  -87,
     -96,   69,   11,      -77,   59,   -1,      -58,   48,  -15,      -39,   37,  -28,
     -20,   26,  -42,       -1,   16,  -56,       18,    5,  -69,       37,   -5,  -83,
     -93,   68,   16,      -75,   57,    2,      -55,   46,  -10,      -36,   36,  -24,
     -17,   25,  -38,        2,   14,  -51,       21,    3,  -64,       40,   -6,  -78,
     -91,   66,   20,      -72,   56,    6,      -53,   45,   -6,      -34,   34,  -20,
     -15,   23,  -34,        4,   13,  -47,       23,    2,  -60,       42,   -8,  -74,
     -89,   65,   24,      -70,   54,   10,      -50,   43,   -2,      -32,   33,  -16,
     -12,   22,  -30,        7,   11,  -43,       25,    1,  -56,       45,   -9,  -70,
     -86,   64,   28,      -67,   53,   14,      -48,   42,    1,      -29,   32,  -12,
     -10,   21,  -26,        9,   10,  -39,       28,    0,  -52,       47,  -11,  -66,
     -84,   62,   32,      -65,   52,   18,      -46,   41,    5,      -27,   30,   -8,
      -7,   19,  -22,       11,    9,  -35,       30,   -1,  -48,       49,  -12,  -62,
     -81,   61,   36,      -62,   50,   23,      -43,   39,    9,      -24,   29,   -3,
      -5,   18,  -17,       14,    7,  -31,       33,   -2,  -44,       52,  -13,  -58,
     -79,   59,   40,      -60,   49,   27,      -41,   38,   13,      -22,   27,    0,
      -2,   16,  -13,       16,    6,  -27,       35,   -4,  -40,       55,  -15,  -54,
     -76,   58,   44,      -58,   47,   31,      -38,   37,   17,      -19,   26,    4,
       0,   15,   -9,       19,    4,  -23,       38,   -5,  -36,       57,  -16,  -50,
     -74,   57,   48,      -55,   46,   35,      -36,   35,   21,      -17,   25,    8,
       2,   14,   -5,       21,    3,  -19,       40,   -7,  -32,       59,  -17,  -46,
     -71,   55,   53,      -52,   45,   39,      -33,   34,   26,      -14,   23,   12,
       5,   12,   -1,       24,    2,  -14,       43,   -8,  -27,       62,  -19,  -41,
     -69,   54,   57,      -50,   43,   43,      -31,   32,   30,      -12,   22,   16,
       7,   11,    2,       26,    0,  -10,       45,   -9,  -23,       64,  -20,  -37,
     -66,   53,   61,      -48,   42,   47,      -28,   31,   34,      -10,   20,   20,
      10,    9,    6,       29,    0,   -6,       47,  -11,  -19,       67,  -22,  -33,
     -64,   51,   65,      -45,   41,   51,      -26,   30,   38,       -7,   19,   24,
      12,    8,   10,       31,   -1,   -2,       50,  -12,  -15,       69,  -23,  -29,
     -61,   50,   69,      -43,   39,   56,      -23,   28,   42,       -4,   18,   29,
      15,    7,   15,       34,   -3,    1,       52,  -14,  -11,       72,  -25,  -25,
     -59,   48,   73,      -40,   38,   60,      -21,   27,   46,       -2,   16,   33,
      17,    5,   19,       36,   -4,    5,       55,  -15,   -7,       74,  -26,  -21,
     -57,   47,   77,      -38,   36,   64,      -18,   25,   50,        0,   15,   37,
      20,    4,   23,       38,   -6,    9,       57,  -16,   -3,       77,  -27,  -17,
     -54,   46,   81,      -35,   35,   68,      -16,   24,   54,        3,   13,   41,
      22,    3,   27,       41,   -7,   13,       60,  -18,    0,       79,  -29,  -13,
     -52,   44,   85,      -33,   34,   72,      -14,   23,   58,        5,   12,   45,
      24,    1,   31,       43,   -8,   17,       62,  -19,    4,       81,  -30,   -9,
     -49,   43,   90,      -30,   32,   76,      -11,   21,   63,        8,   11,   49,
      27,    0,   35,       46,  -10,   22,       65,  -21,    9,       84,  -31,   -4,
     -47,   41,   94,      -28,   31,   80,       -9,   20,   67,       10,    9,   53,
      30,   -1,   39,       48,  -11,   26,       67,  -22,   13,       87,  -33,    0,
     -44,   40,   98,      -26,   29,   84,       -6,   19,   71,       13,    8,   57,
      32,   -2,   43,       51,  -13,   30,       70,  -23,   17,       89,  -34,    3,
     -42,   39,  102,      -23,   28,   88,       -4,   17,   75,       15,    7,   61,
      34,   -3,   47,       53,  -14,   34,       72,  -25,   21,       91,  -36,    7,
     -39,   37,  106,      -20,   27,   93,       -1,   16,   79,       18,    5,   66,
      37,   -5,   52,       56,  -15,   38,       75,  -26,   25,       94,  -37,   11,
     -37,   36,  110,      -18,   25,   97,        1,   14,   83,       20,    4,   70,
      39,   -6,   56,       58,  -17,   42,       77,  -27,   29,       96,  -38,   15,
     -34,   34,  114,      -16,   24,  101,        4,   13,   87,       22,    2,   74,
      42,   -8,   60,       61,  -18,   46,       79,  -29,   33,       99,  -40,   19,
    -110,   82,  -13,      -91,   71,  -26,      -72,   60,  -40,      -53,   50,  -54,
     -33,   39,  -67,      -15,   28,  -81,        4,   18,  -94,       24,    7, -108,
    -107,   81,   -9,      -89,   70,  -22,      -69,   59,  -36,      -50,   49,  -50,
     -31,   38,  -63,      -12,   27,  -77,        7,   16,  -90,       26,    5, -104,
    -105,   79,   -5,      -86,   69,  -18,      -67,   58,  -32,      -48,   47,  -46,
     -29,   36,  -59,      -10,   26,  -73,        9,   15,  -86,       28,    4, -100,
    -102,   78,    0,      -83,   67,  -14,      -64,   56,  -28,      -45,   46,  -41,
     -26,   35,  -55,       -7,   24,  -68,       12,   14,  -82,       31,    3,  -95,
    -100,   76,    3,      -81,   66,  -10,      -62,   55,  -24,      -43,   44,  -37,
     -24,   33,  -51,       -5,   23,  -64,       14,   12,  -78,       33,    1,  -91,
     -97,   75,    7,      -79,   64,   -6,      -59,   54,  -20,      -40,   43,  -33,
     -21,   32,  -47,       -2,   21,  -60,       16,   11,  -74,       36,    0,  -87,
     -95,   74,   11,      -76,   63,   -2,      -57,   52,  -16,      -38,   42,  -29,
     -19,   31,  -43,        0,   20,  -56,       19,    9,  -70,       38,    0,  -83,
     -92,   72,   15,      -74,   62,    2,      -54,   51,  -11,      -35,   40,  -25,
     -16,   29,  -38,        3,   19,  -52,       22,    8,  -65,       41,   -2,  -79,
     -90,   71,   19,      -71,   60,    6,      -52,   49,   -7,      -33,   39,  -21,
     -14,   28,  -34,        5,   17,  -48,       24,    7,  -61,       43,   -3,  -75,
     -88,   70,   23,      -69,   59,   10,      -49,   48,   -3,      -31,   37,  -17,
     -11,   26,  -30,        8,   16,  -44,       26,    5,  -57,       46,   -5,  -71,
     -85,   68,   27,      -66,   58,   14,      -47,   47,    0,      -28,   36,  -13,
      -9,   25,  -26,       10,   14,  -40,       29,    4,  -53,       48,   -6,  -67,
     -83,   67,   31,      -64,   56,   18,      -45,   45,    4,      -26,   35,   -9,
      -6,   24,  -22,       12,   13,  -36,       31,    3,  -49,       50,   -7,  -63,
     -80,   65,   36,      -61,   55,   22,      -42,   44,    8,      -23,   33,   -4,
      -4,   22,  -18,       15,   12,  -31,       34,    1,  -45,       53,   -9,  -58,
     -78,   64,   40,      -59,   53,   26,      -40,   42,   12,      -21,   32,    0,
      -1,   21,  -14,       17,   10,  -27,       36,    0,  -41,       56,  -10,  -54,
     -75,   63,   44,      -57,   52,   30,      -37,   41,   16,      -18,   30,    3,
       1,   20,  -10,       20,    9,  -23,       39,   -1,  -37,       58,  -12,  -50,
     -73,   61,   48,      -54,   51,   34,      -35,   40,   20,      -16,   29,    7,
       3,   18,   -6,       22,    8,  -19,       41,   -2,  -33,       60,  -13,  -46,
     -70,   60,   52,      -51,   49,   39,      -32,   38,   25,      -13,   28,   11,
       6,   17,   -1,       25,    6,  -15,       44,   -4,  -28,       63,  -14,  -42,
     -68,   58,   56,      -49,   48,   43,      -30,   37,   29,      -11,   26,   15,
       8,   15,    2,       27,    5,  -11,       46,   -5,  -24,       65,  -16,  -38,
     -65,   57,   60,      -47,   46,   47,      -27,   35,   33,       -8,   25,   19,
      11,   14,    6,       30,    3,   -7,       48,   -6,  -20,       68,  -17,  -34,
     -63,   56,   64,      -44,   45,   51,      -25,   34,   37,       -6,   24,   23,
      13,   13,   10,       32,    2,   -3,       51,   -8,  -16,       70,  -19,  -30,
     -60,   54,   69,      -42,   44,   55,      -22,   33,   41,       -3,   22,   28,
      16,   11,   14,       35,    0,    1,       54,   -9,  -12,       73,  -20,  -25,
     -58,   53,   73,      -39,   42,   59,      -20,   31,   45,       -1,   21,   32,
      18,   10,   18,       37,    0,    5,       56,  -10,   -8,       75,  -21,  -21,
     -56,   51,   77,      -37,   41,   63,      -17,   30,   49,        1,   19,   36,
      21,    8,   22,       40,   -1,    9,       58,  -12,   -4,       78,  -23,  -17,
     -53,   50,   81,      -34,   40,   67,      -15,   29,   53,        4,   18,   40,
      23,    7,   26,       42,   -3,   13,       61,  -13,    0,       80,  -24,  -13,
     -51,   49,   85,      -32,   38,   71,      -13,   27,   57,        6,   17,   44,
      26,    6,   30,       44,   -4,   17,       63,  -15,    3,       82,  -25,   -9,
     -48,   47,   89,      -29,   37,   76,      -10,   26,   62,        9,   15,   48,
      28,    4,   35,       47,   -5,   21,       66,  -16,    8,       85,  -27,   -5,
     -46,   46,   93,      -27,   35,   80,       -8,   24,   66,       11,   14,   52,
      31,    3,   39,       49,   -7,   25,       68,  -17,   12,       88,  -28,   -1,
     -43,   45,   97,      -25,   34,   84,       -5,   23,   70,       14,   12,   56,
      33,    1,   43,       52,   -8,   29,       71,  -19,   16,       90,  -30,    2,
     -41,   43,  101,      -22,   33,   88,       -3,   22,   74,       16,   11,   60,
      35,    0,   47,       54,   -9,   33,       73,  -20,   20,       92,  -31,    6,
     -38,   42,  106,      -19,   31,   92,        0,   20,   78,       19,   10,   65,
      38,    0,   51,       57,  -11,   38,       76,  -22,   24,       95,  -33,   11,
     -36,   40,  110,      -17,   30,   96,        2,   19,   82,       21,    8,   69,
      40,   -2,   55,       59,  -12,   42,       78,  -23,   28,       97,  -34,   15,
     -33,   39,  114,      -15,   28,  100,        5,   17,   86,       23,    7,   73,
      43,   -3,   59,       62,  -14,   46,       80,  -24,   32,      100,  -35,   19,
    -109,   86,  -14,      -90,   75,  -27,      -71,   64,  -41,      -52,   54,  -54,
     -32,   43,  -68,      -14,   32,  -81,        5,   22,  -95,       24,   11, -109,
    -106,   85,  -10,      -88,   74,  -23,      -68,   63,  -37,      -49,   53,  -50,
     -30,   42,  -64,      -11,   31,  -77,        7,   20,  -91,       27,    9, -105,
    -104,   83,   -6,      -85,   73,  -19,      -66,   62,  -33,      -47,   51,  -46,
     -28,   40,  -60,       -9,   30,  -73,       10,   19,  -87,       29,    8, -101,
    -101,   82,   -1,      -83,   71,  -14,      -63,   60,  -28,      -44,   50,  -42,
     -25,   39,  -55,       -6,   28,  -69,       13,   18,  -82,       32,    7,  -96,
     -99,   80,    2,      -80,   70,  -10,      -61,   59,  -24,      -42,   48,  -38,
     -23,   37,  -51,       -4,   27,  -65,       15,   16,  -78,       34,    5,  -92,
     -97,   79,    6,      -78,   68,   -6,      -58,   58,  -20,      -40,   47,  -34,
     -20,   36,  -47,       -1,   25,  -61,       17,   15,  -74,       37,    4,  -88,
     -94,   78,   10,      -75,   67,   -2,      -56,   56,  -16,      -37,   46,  -30,
     -18,   35,  -43,        1,   24,  -57,       20,   13,  -70,       39,    3,  -84,
     -91,   76,   14,      -73,   66,    1,      -53,   55,  -12,      -34,   44,  -25,
     -15,   33,  -39,        4,   23,  -52,       22,   12,  -66,       42,    1,  -80,
     -89,   75,   18,      -70,   64,    5,      -51,   53,   -8,      -32,   43,  -21,
     -13,   32,  -35,        6,   21,  -48,       25,   11,  -62,       44,    0,  -76,
     -87,   74,   22,      -68,   63,    9,      -48,   52,   -4,      -30,   41,  -17,
     -10,   30,  -31,        8,   20,  -44,       27,    9,  -58,       47,   -1,  -72,
     -84,   72,   26,      -65,   62,   13,      -46,   51,    0,      -27,   40,  -13,
      -8,   29,  -27,       11,   18,  -40,       30,    8,  -54,       49,   -2,  -68,
     -82,   71,   30,      -63,   60,   17,      -44,   49,    3,      -25,   39,   -9,
      -6,   28,  -23,       13,   17,  -36,       32,    7,  -50,       51,   -3,  -64,
     -79,   69,   35,      -60,   59,   22,      -41,   48,    8,      -22,   37,   -5,
      -3,   26,  -18,       16,   16,  -32,       35,    5,  -45,       54,   -5,  -59,
     -77,   68,   39,      -58,   57,   26,      -39,   46,   12,      -20,   36,   -1,
       0,   25,  -14,       18,   14,  -28,       37,    4,  -41,       56,   -6,  -55,
     -74,   67,   43,      -56,   56,   30,      -36,   45,   16,      -17,   34,    2,
       2,   24,  -10,       21,   13,  -24,       39,    2,  -37,       59,   -8,  -51,
     -72,   65,   47,      -53,   55,   34,      -34,   44,   20,      -15,   33,    6,
       4,   22,   -6,       23,   12,  -20,       42,    1,  -33,       61,   -9,  -47,
     -69,   64,   51,      -51,   53,   38,      -31,   42,   24,      -12,   32,   11,
       7,   21,   -2,       26,   10,  -15,       45,    0,  -29,       64,  -10,  -43,
     -67,   62,   55,      -48,   52,   42,      -29,   41,   28,      -10,   30,   15,
       9,   19,    1,       28,    9,  -11,       47,   -1,  -25,       66,  -12,  -39,
     -65,   61,   59,      -46,   50,   46,      -26,   39,   32,       -8,   29,   19,
      12,   18,    5,       31,    7,   -7,       49,   -2,  -21,       69,  -13,  -35,
     -62,   60,   63,      -43,   49,   50,      -24,   38,   36,       -5,   28,   23,
      14,   17,    9,       33,    6,   -3,       52,   -4,  -17,       71,  -15,  -31,
     -59,   58,   68,      -41,   48,   55,      -21,   37,   41,       -3,   26,   27,
      17,   15,   14,       36,    4,    0,       54,   -5,  -12,       74,  -16,  -26,
     -57,   57,   72,      -38,   46,   59,      -19,   35,   45,        0,   25,   31,
      19,   14,   18,       38,    3,    4,       57,   -6,   -8,       76,  -17,  -22,
     -55,   55,   76,      -36,   45,   63,      -17,   34,   49,        2,   23,   35,
      22,   12,   22,       40,    2,    8,       59,   -8,   -4,       79,  -19,  -18,
     -52,   54,   80,      -33,   44,   67,      -14,   33,   53,        5,   22,   39,
      24,   11,   26,       43,    0,   12,       62,   -9,    0,       81,  -20,  -14,
     -50,   53,   84,      -31,   42,   71,      -12,   31,   57,        7,   21,   43,
      26,   10,   30,       45,    0,   16,       64,  -11,    3,       83,  -21,  -10,
     -47,   51,   88,      -28,   41,   75,       -9,   30,   61,       10,   19,   48,
      29,    8,   34,       48,   -1,   21,       67,  -12,    7,       86,  -23,   -6,
     -45,   50,   92,      -26,   39,   79,       -7,   28,   65,       12,   18,   52,
      32,    7,   38,       50,   -3,   25,       69,  -13,   11,       88,  -24,   -2,
     -42,   49,   96,      -24,   38,   83,       -4,   27,   69,       15,   16,   56,
      34,    5,   42,       53,   -4,   29,       71,  -15,   15,       91,  -26,    1,
     -40,   47,  100,      -21,   37,   87,       -2,   26,   73,       17,   15,   60,
      36,    4,   46,       55,   -5,   33,       74,  -16,   19,       93,  -27,    5,
     -37,   46,  105,      -19,   35,   92,        1,   24,   78,       20,   14,   64,
      39,    3,   51,       58,   -7,   37,       77,  -18,   24,       96,  -29,   10,
     -35,   44,  109,      -16,   34,   96,        3,   23,   82,       22,   12,   68,
      41,    1,   55,       60,   -8,   41,       79,  -19,   28,       98,  -30,   14,
     -33,   43,  113,      -14,   32,  100,        6,   21,   86,       24,   11,   72,
      44,    0,   59,       63,  -10,   45,       81,  -20,   32,      101,  -31,   18,
    -108,   90,  -14,      -89,   79,  -28,      -70,   68,  -41,      -51,   58,  -55,
     -32,   47,  -69,      -13,   36,  -82,        6,   26,  -95,       25,   15, -109,
    -105,   89,  -10,      -87,   78,  -24,      -67,   67,  -37,      -49,   57,  -51,
     -29,   46,  -65,      -10,   35,  -78,        8,   24,  -91,       28,   13, -105,
    -103,   87,   -6,      -84,   77,  -20,      -65,   66,  -33,      -46,   55,  -47,
     -27,   44,  -61,       -8,   34,  -74,       11,   23,  -87,       30,   12, -101,
    -100,   86,   -2,      -82,   75,  -15,      -62,   64,  -29,      -43,   54,  -42,
     -24,   43,  -56,       -5,   32,  -70,       13,   22,  -83,       33,   11,  -97,
     -98,   84,    1,      -79,   74,  -11,      -60,   63,  -25,      -41,   52,  -38,
     -22,   41,  -52,       -3,   31,  -66,       16,   20,  -79,       35,    9,  -93,
     -96,   83,    5,      -77,   72,   -7,      -57,   62,  -21,      -39,   51,  -34,
     -19,   40,  -48,       -1,   29,  -62,       18,   19,  -75,       38,    8,  -89,
     -93,   82,    9,      -74,   71,   -3,      -55,   60,  -17,      -36,   50,  -30,
     -17,   39,  -44,        2,   28,  -58,       21,   17,  -71,       40,    7,  -85,
     -91,   80,   14,      -72,   70,    0,      -52,   59,  -12,      -34,   48,  -26,
     -14,   37,  -40,        5,   27,  -53,       23,   16,  -66,       43,    5,  -80,
     -88,   79,   18,      -69,   68,    4,      -50,   57,   -8,      -31,   47,  -22,
     -12,   36,  -36,        7,   25,  -49,       26,   15,  -62,       45,    4,  -76,
     -86,   78,   22,      -67,   67,    8,      -48,   56,   -4,      -29,   45,  -18,
      -9,   34,  -32,        9,   24,  -45,       28,   13,  -58,       48,    2,  -72,
     -83,   76,   26,      -65,   66,   12,      -45,   55,    0,      -26,   44,  -14,
      -7,   33,  -28,       12,   22,  -41,       31,   12,  -54,       50,    1,  -68,
     -81,   75,   30,      -62,   64,   16,      -43,   53,    3,      -24,   43,  -10,
      -5,   32,  -24,       14,   21,  -37,       33,   11,  -50,       52,    0,  -64,
     -78,   73,   34,      -59,   63,   21,      -40,   52,    7,      -21,   41,   -5,
      -2,   30,  -19,       17,   20,  -33,       36,    9,  -46,       55,   -1,  -60,
     -76,   72,   38,      -57,   61,   25,      -38,   50,   11,      -19,   40,   -1,
       0,   29,  -15,       19,   18,  -29,       38,    8,  -42,       57,   -2,  -56,
     -73,   71,   42,      -55,   60,   29,      -35,   49,   15,      -17,   38,    2,
       3,   28,  -11,       22,   17,  -25,       40,    6,  -38,       60,   -4,  -52,
     -71,   69,   46,      -52,   59,   33,      -33,   48,   19,      -14,   37,    6,
       5,   26,   -7,       24,   16,  -21,       43,    5,  -34,       62,   -5,  -48,
     -68,   68,   51,      -50,   57,   37,      -30,   46,   24,      -11,   36,   10,
       8,   25,   -3,       27,   14,  -16,       45,    3,  -29,       65,   -6,  -43,
     -66,   66,   55,      -47,   56,   41,      -28,   45,   28,       -9,   34,   14,
      10,   23,    0,       29,   13,  -12,       48,    2,  -25,       67,   -8,  -39,
     -64,   65,   59,      -45,   54,   45,      -25,   43,   32,       -7,   33,   18,
      13,   22,    4,       31,   11,   -8,       50,    1,  -21,       70,   -9,  -35,
     -61,   64,   63,      -42,   53,   49,      -23,   42,   36,       -4,   32,   22,
      15,   21,    8,       34,   10,   -4,       53,    0,  -17,       72,  -11,  -31,
     -59,   62,   67,      -40,   52,   54,      -20,   41,   40,       -2,   30,   27,
      18,   19,   13,       37,    8,    0,       55,   -1,  -13,       75,  -12,  -27,
     -56,   61,   71,      -37,   50,   58,      -18,   39,   44,        1,   29,   31,
      20,   18,   17,       39,    7,    3,       58,   -2,   -9,       77,  -13,  -23,
     -54,   59,   75,      -35,   49,   62,      -16,   38,   48,        3,   27,   35,
      23,   16,   21,       41,    6,    7,       60,   -4,   -5,       80,  -15,  -19,
     -51,   58,   79,      -33,   48,   66,      -13,   37,   52,        6,   26,   39,
      25,   15,   25,       44,    4,   11,       63,   -5,   -1,       82,  -16,  -15,
     -49,   57,   83,      -30,   46,   70,      -11,   35,   56,        8,   25,   43,
      27,   14,   29,       46,    3,   15,       65,   -7,    2,       84,  -17,  -11,
     -46,   55,   88,      -27,   45,   74,       -8,   34,   61,       11,   23,   47,
      30,   12,   33,       49,    2,   20,       68,   -8,    7,       87,  -19,   -6,
     -44,   54,   92,      -25,   43,   78,       -6,   32,   65,       13,   22,   51,
      32,   11,   37,       51,    0,   24,       70,   -9,   11,       89,  -20,   -2,
     -41,   53,   96,      -23,   42,   82,       -3,   31,   69,       15,   20,   55,
      35,    9,   41,       54,    0,   28,       72,  -11,   15,       92,  -22,    1,
     -39,   51,  100,      -20,   41,   86,       -1,   30,   73,       18,   19,   59,
      37,    8,   45,       56,   -1,   32,       75,  -12,   19,       94,  -23,    5,
     -36,   50,  104,      -18,   39,   91,        2,   28,   77,       21,   18,   64,
      40,    7,   50,       59,   -3,   36,       77,  -14,   23,       97,  -25,    9,
     -34,   48,  108,      -15,   38,   95,        4,   27,   81,       23,   16,   68,
      42,    5,   54,       61,   -4,   40,       80,  -15,   27,       99,  -26,   13,
     -32,   47,  112,      -13,   36,   99,        7,   25,   85,       25,   15,   72,
      45,    4,   58,       63,   -6,   44,       82,  -16,   31,      102,  -27,   17,
    -107,   94,  -15,      -88,   83,  -28,      -69,   72,  -42,      -50,   62,  -55,
     -31,   51,  -69,      -12,   40,  -83,        7,   30,  -96,       26,   19, -110,
    -105,   93,  -11,      -86,   82,  -24,      -66,   71,  -38,      -48,   61,  -51,
     -28,   50,  -65,       -9,   39,  -79,        9,   28,  -92,       29,   17, -106,
    -102,   91,   -7,      -83,   81,  -20,      -64,   70,  -34,      -45,   59,  -47,
     -26,   48,  -61,       -7,   38,  -75,       12,   27,  -88,       31,   16, -102,
     -99,   90,   -2,      -81,   79,  -16,      -61,   68,  -30,      -43,   58,  -43,
     -23,   47,  -57,       -4,   36,  -70,       14,   26,  -84,       34,   15,  -97,
     -97,   88,    1,      -78,   78,  -12,      -59,   67,  -26,      -40,   56,  -39,
     -21,   45,  -53,       -2,   35,  -66,       17,   24,  -80,       36,   13,  -93,
     -95,   87,    5,      -76,   76,   -8,      -57,   66,  -22,      -38,   55,  -35,
     -18,   44,  -49,        0,   33,  -62,       19,   23,  -76,       39,   12,  -89,
     -92,   86,    9,      -74,   75,   -4,      -54,   64,  -18,      -35,   54,  -31,
     -16,   43,  -45,        3,   32,  -58,       22,   21,  -72,       41,   11,  -85,
     -90,   84,   13,      -71,   74,    0,      -51,   63,  -13,      -33,   52,  -26,
     -13,   41,  -40,        5,   31,  -54,       24,   20,  -67,       44,    9,  -81,
     -87,   83,   17,      -68,   72,    4,      -49,   61,   -9,      -30,   51,  -22,
     -11,   40,  -36,        8,   29,  -50,       27,   19,  -63,       46,    8,  -77,
     -85,   82,   21,      -66,   71,    8,      -47,   60,   -5,      -28,   49,  -18,
      -9,   38,  -32,       10,   28,  -46,       29,   17,  -59,       48,    6,  -73,
     -82,   80,   25,      -64,   70,   12,      -44,   59,   -1,      -25,   48,  -14,
      -6,   37,  -28,       13,   26,  -42,       31,   16,  -55,       51,    5,  -69,
     -80,   79,   29,      -61,   68,   16,      -42,   57,    2,      -23,   47,  -10,
      -4,   36,  -24,       15,   25,  -38,       34,   15,  -51,       53,    4,  -65,
     -77,   77,   34,      -59,   67,   20,      -39,   56,    6,      -20,   45,   -6,
      -1,   34,  -20,       18,   24,  -33,       37,   13,  -47,       56,    2,  -60,
     -75,   76,   38,      -56,   65,   24,      -37,   54,   10,      -18,   44,   -2,
       1,   33,  -16,       20,   22,  -29,       39,   12,  -43,       58,    1,  -56,
     -73,   75,   42,      -54,   64,   28,      -34,   53,   14,      -16,   42,    1,
       4,   32,  -12,       23,   21,  -25,       41,   10,  -39,       61,    0,  -52,
     -70,   73,   46,      -51,   63,   32,      -32,   52,   18,      -13,   41,    5,
       6,   30,   -8,       25,   20,  -21,       44,    9,  -35,       63,   -1,  -48,
     -67,   72,   50,      -49,   61,   37,      -29,   50,   23,      -11,   40,   10,
       9,   29,   -3,       28,   18,  -17,       46,    7,  -30,       66,   -2,  -44,
     -65,   70,   54,      -46,   60,   41,      -27,   49,   27,       -8,   38,   14,
      11,   27,    0,       30,   17,  -13,       49,    6,  -26,       68,   -4,  -40,
     -63,   69,   58,      -44,   58,   45,      -25,   47,   31,       -6,   37,   18,
      14,   26,    4,       32,   15,   -9,       51,    5,  -22,       71,   -5,  -36,
     -60,   68,   62,      -42,   57,   49,      -22,   46,   35,       -3,   36,   22,
      16,   25,    8,       35,   14,   -5,       54,    3,  -18,       73,   -7,  -32,
     -58,   66,   67,      -39,   56,   53,      -19,   45,   39,       -1,   34,   26,
      19,   23,   12,       37,   12,    0,       56,    2,  -14,       76,   -8,  -27,
     -55,   65,   71,      -36,   54,   57,      -17,   43,   43,        2,   33,   30,
      21,   22,   16,       40,   11,    3,       59,    1,  -10,       78,   -9,  -23,
     -53,   63,   75,      -34,   53,   61,      -15,   42,   47,        4,   31,   34,
      23,   20,   20,       42,   10,    7,       61,    0,   -6,       80,  -11,  -19,
     -50,   62,   79,      -32,   52,   65,      -12,   41,   51,        6,   30,   38,
      26,   19,   24,       45,    8,   11,       63,   -1,   -2,       83,  -12,  -15,
     -48,   61,   83,      -29,   50,   69,      -10,   39,   55,        9,   29,   42,
      28,   18,   28,       47,    7,   15,       66,   -3,    1,       85,  -13,  -11,
     -45,   59,   87,      -27,   49,   74,       -7,   38,   60,       12,   27,   47,
      31,   16,   33,       50,    6,   19,       69,   -4,    6,       88,  -15,   -7,
     -43,   58,   91,      -24,   47,   78,       -5,   36,   64,       14,   26,   51,
      33,   15,   37,       52,    4,   23,       71,   -5,   10,       90,  -16,   -3,
     -41,   57,   95,      -22,   46,   82,       -2,   35,   68,       16,   24,   55,
      36,   13,   41,       55,    3,   27,       73,   -7,   14,       93,  -18,    0,
     -38,   55,   99,      -19,   45,   86,        0,   34,   72,       19,   23,   59,
      38,   12,   45,       57,    2,   31,       76,   -8,   18,       95,  -19,    4,
     -35,   54,  104,      -17,   43,   90,        3,   32,   76,       21,   22,   63,
      41,   11,   49,       60,    0,   36,       78,  -10,   22,       98,  -21,    9,
     -33,   52,  108,      -14,   42,   94,        5,   31,   80,       24,   20,   67,
      43,    9,   53,       62,    0,   40,       81,  -11,   26,      100,  -22,   13,
     -31,   51,  112,      -12,   40,   98,        7,   29,   84,       26,   19,   71,
      46,    8,   57,       64,   -2,   44,       83,  -12,   30,      103,  -23,   17,
    -106,   98,  -16,      -87,   87,  -29,      -68,   76,  -43,      -49,   66,  -56,
     -30,   55,  -70,      -11,   44,  -83,        8,   34,  -97,       27,   23, -111,
    -104,   97,  -12,      -85,   86,  -25,      -65,   75,  -39,      -47,   65,  -52,
     -27,   54,  -66,       -9,   43,  -79,       10,   32,  -93,       30,   21, -107,
    -101,   95,   -8,      -82,   85,  -21,      -63,   74,  -35,      -44,   63,  -48,
     -25,   52,  -62,       -6,   42,  -75,       13,   31,  -89,       32,   20, -103,
     -99,   94,   -3,      -80,   83,  -16,      -60,   72,  -30,      -42,   62,  -44,
     -22,   51,  -57,       -3,   40,  -71,       15,   30,  -84,       35,   19,  -98,
     -96,   92,    0,      -77,   82,  -12,      -58,   71,  -26,      -39,   60,  -40,
     -20,   49,  -53,       -1,   39,  -67,       18,   28,  -80,       37,   17,  -94,
     -94,   91,    4,      -75,   80,   -8,      -56,   70,  -22,      -37,   59,  -36,
     -17,   48,  -49,        1,   37,  -63,       20,   27,  -76,       39,   16,  -90,
     -91,   90,    8,      -73,   79,   -4,      -53,   68,  -18,      -34,   58,  -32,
     -15,   47,  -45,        4,   36,  -59,       22,   25,  -72,       42,   15,  -86,
     -89,   88,   12,      -70,   78,    0,      -51,   67,  -14,      -32,   56,  -27,
     -12,   45,  -41,        6,   35,  -54,       25,   24,  -68,       45,   13,  -82,
     -86,   87,   16,      -68,   76,    3,      -48,   65,  -10,      -29,   55,  -23,
     -10,   44,  -37,        9,   33,  -50,       28,   23,  -64,       47,   12,  -78,
     -84,   86,   20,      -65,   75,    7,      -46,   64,   -6,      -27,   53,  -19,
      -8,   42,  -33,       11,   32,  -46,       30,   21,  -60,       49,   10,  -74,
     -82,   84,   24,      -63,   74,   11,      -43,   63,   -2,      -25,   52,  -15,
      -5,   41,  -29,       14,   30,  -42,       32,   20,  -56,       52,    9,  -70,
     -79,   83,   28,      -60,   72,   15,      -41,   61,    1,      -22,   51,  -11,
      -3,   40,  -25,       16,   29,  -38,       35,   19,  -52,       54,    8,  -66,
     -76,   81,   33,      -58,   71,   20,      -38,   60,    6,      -20,   49,   -7,
       0,   38,  -20,       19,   28,  -34,       37,   17,  -47,       57,    6,  -61,
     -74,   80,   37,      -55,   69,   24,      -36,   58,   10,      -17,   48,   -3,
       2,   37,  -16,       21,   26,  -30,       40,   16,  -43,       59,    5,  -57,
     -72,   79,   41,      -53,   68,   28,      -34,   57,   14,      -15,   46,    0,
       5,   36,  -12,       23,   25,  -26,       42,   14,  -39,       62,    3,  -53,
     -69,   77,   45,      -50,   67,   32,      -31,   56,   18,      -12,   45,    4,
       7,   34,   -8,       26,   24,  -22,       45,   13,  -35,       64,    2,  -49,
     -67,   76,   49,      -48,   65,   36,      -28,   54,   22,      -10,   44,    9,
      10,   33,   -4,       29,   22,  -17,       47,   11,  -31,       67,    1,  -45,
     -64,   74,   53,      -45,   64,   40,      -26,   53,   26,       -7,   42,   13,
      12,   31,    0,       31,   21,  -13,       50,   10,  -27,       69,    0,  -41,
     -62,   73,   57,      -43,   62,   44,      -24,   51,   30,       -5,   41,   17,
      15,   30,    3,       33,   19,   -9,       52,    9,  -23,       71,   -1,  -37,
     -59,   72,   61,      -41,   61,   48,      -21,   50,   34,       -2,   40,   21,
      17,   29,    7,       36,   18,   -5,       54,    7,  -19,       74,   -3,  -33,
     -57,   70,   66,      -38,   60,   53,      -19,   49,   39,        0,   38,   25,
      20,   27,   12,       38,   16,   -1,       57,    6,  -14,       77,   -4,  -28,
     -54,   69,   70,      -36,   58,   57,      -16,   47,   43,        3,   37,   29,
      22,   26,   16,       41,   15,    2,       60,    5,  -10,       79,   -5,  -24,
     -52,   67,   74,      -33,   57,   61,      -14,   46,   47,        5,   35,   33,
      24,   24,   20,       43,   14,    6,       62,    3,   -6,       81,   -7,  -20,
     -50,   66,   78,      -31,   56,   65,      -11,   45,   51,        7,   34,   37,
      27,   23,   24,       46,   12,   10,       64,    2,   -2,       84,   -8,  -16,
     -47,   65,   82,      -28,   54,   69,       -9,   43,   55,       10,   33,   41,
      29,   22,   28,       48,   11,   14,       67,    0,    1,       86,   -9,  -12,
     -44,   63,   86,      -26,   53,   73,       -6,   42,   59,       12,   31,   46,
      32,   20,   32,       51,   10,   19,       69,    0,    5,       89,  -11,   -8,
     -42,   62,   90,      -23,   51,   77,       -4,   40,   63,       15,   30,   50,
      34,   19,   36,       53,    8,   23,       72,   -1,    9,       91,  -12,   -4,
     -40,   61,   94,      -21,   50,   81,       -2,   39,   67,       17,   28,   54,
      37,   17,   40,       55,    7,   27,       74,   -3,   13,       94,  -14,    0,
     -37,   59,   98,      -18,   49,   85,        1,   38,   71,       20,   27,   58,
      39,   16,   44,       58,    6,   31,       77,   -4,   17,       96,  -15,    3,
     -35,   58,  103,      -16,   47,   90,        4,   36,   76,       22,   26,   62,
      42,   15,   49,       61,    4,   35,       79,   -6,   22,       99,  -17,    8,
     -32,   56,  107,      -13,   46,   94,        6,   35,   80,       25,   24,   66,
      44,   13,   53,       63,    3,   39,       82,   -7,   26,      101,  -18,   12,
     -30,   55,  111,      -11,   44,   98,        8,   33,   84,       27,   23,   70,
      47,   12,   57,       65,    1,   43,       84,   -8,   30,      103,  -19,   16,
    -105,  103,  -16,      -86,   92,  -30,      -67,   81,  -43,      -48,   70,  -57,
     -29,   59,  -71,      -10,   49,  -84,        9,   38,  -97,       28,   27, -111,
    -103,  101,  -12,      -84,   91,  -26,      -64,   80,  -39,      -46,   69,  -53,
     -26,   58,  -67,       -8,   47,  -80,       11,   37,  -93,       31,   26, -107,
    -100,  100,   -8,      -81,   89,  -22,      -62,   78,  -35,      -43,   68,  -49,
     -24,   57,  -63,       -5,   46,  -76,       14,   36,  -89,       33,   25, -103,
     -98,   98,   -4,      -79,   88,  -17,      -59,   77,  -31,      -41,   66,  -44,
     -21,   55,  -58,       -2,   45,  -72,       16,   34,  -85,       36,   23,  -99,
     -95,   97,    0,      -76,   86,  -13,      -57,   75,  -27,      -38,   65,  -40,
     -19,   54,  -54,        0,   43,  -68,       19,   33,  -81,       38,   22,  -95,
     -93,   96,    3,      -74,   85,   -9,      -55,   74,  -23,      -36,   63,  -36,
     -16,   53,  -50,        2,   42,  -64,       21,   31,  -77,       40,   20,  -91,
     -90,   94,    7,      -72,   84,   -5,      -52,   73,  -19,      -33,   62,  -32,
     -14,   51,  -46,        5,   41,  -60,       24,   30,  -73,       43,   19,  -87,
     -88,   93,   12,      -69,   82,   -1,      -50,   71,  -14,      -31,   61,  -28,
     -11,   50,  -42,        7,   39,  -55,       26,   28,  -68,       46,   18,  -82,
     -85,   91,   16,      -66,   81,    2,      -47,   70,  -10,      -28,   59,  -24,
      -9,   48,  -38,       10,   38,  -51,       29,   27,  -64,       48,   16,  -78,
     -83,   90,   20,      -64,   79,    6,      -45,   68,   -6,      -26,   58,  -20,
      -7,   47,  -34,       12,   36,  -47,       31,   26,  -60,       50,   15,  -74,
     -80,   89,   24,      -62,   78,   10,      -42,   67,   -2,      -24,   57,  -16,
      -4,   46,  -30,       15,   35,  -43,       33,   24,  -56,       53,   13,  -70,
     -78,   87,   28,      -59,   77,   14,      -40,   66,    1,      -21,   55,  -12,
      -2,   44,  -26,       17,   34,  -39,       36,   23,  -52,       55,   12,  -66,
     -75,   86,   32,      -57,   75,   19,      -37,   64,    5,      -18,   54,   -7,
       1,   43,  -21,       20,   32,  -35,       38,   22,  -48,       58,   11,  -62,
     -73,   84,   36,      -54,   74,   23,      -35,   63,    9,      -16,   52,   -3,
       3,   41,  -17,       22,   31,  -31,       41,   20,  -44,       60,    9,  -58,
     -71,   83,   40,      -52,   72,   27,      -32,   62,   13,      -14,   51,    0,
       6,   40,  -13,       24,   29,  -27,       43,   19,  -40,       63,    8,  -54,
     -68,   82,   44,      -49,   71,   31,      -30,   60,   17,      -11,   50,    4,
       8,   39,   -9,       27,   28,  -23,       46,   17,  -36,       65,    7,  -50,
     -66,   80,   49,      -47,   70,   35,      -27,   59,   22,       -9,   48,    8,
      11,   37,   -5,       30,   27,  -18,       48,   16,  -31,       68,    5,  -45,
     -63,   79,   53,      -44,   68,   39,      -25,   57,   26,       -6,   47,   12,
      13,   36,   -1,       32,   25,  -14,       51,   15,  -27,       70,    4,  -41,
     -61,   78,   57,      -42,   67,   43,      -23,   56,   30,       -4,   45,   16,
      16,   34,    2,       34,   24,  -10,       53,   13,  -23,       72,    2,  -37,
     -58,   76,   61,      -40,   66,   47,      -20,   55,   34,       -1,   44,   20,
      18,   33,    6,       37,   23,   -6,       56,   12,  -19,       75,    1,  -33,
     -56,   75,   65,      -37,   64,   52,      -18,   53,   38,        1,   43,   25,
      21,   32,   11,       39,   21,   -2,       58,   10,  -15,       78,    0,  -29,
     -53,   73,   69,      -35,   63,   56,      -15,   52,   42,        4,   41,   29,
      23,   30,   15,       42,   20,    1,       61,    9,  -11,       80,   -1,  -25,
     -51,   72,   73,      -32,   61,   60,      -13,   50,   46,        6,   40,   33,
      25,   29,   19,       44,   18,    5,       63,    8,   -7,       82,   -2,  -21,
     -49,   71,   77,      -30,   60,   64,      -10,   49,   50,        8,   38,   37,
      28,   28,   23,       47,   17,    9,       65,    6,   -3,       85,   -4,  -17,
     -46,   69,   81,      -27,   59,   68,       -8,   48,   54,       11,   37,   41,
      30,   26,   27,       49,   16,   13,       68,    5,    0,       87,   -5,  -13,
     -43,   68,   86,      -25,   57,   72,       -5,   46,   59,       14,   36,   45,
      33,   25,   31,       52,   14,   18,       70,    3,    5,       90,   -6,   -8,
     -41,   66,   90,      -22,   56,   76,       -3,   45,   63,       16,   34,   49,
      35,   23,   35,       54,   13,   22,       73,    2,    9,       92,   -8,   -4,
     -39,   65,   94,      -20,   54,   80,        0,   44,   67,       18,   33,   53,
      38,   22,   39,       56,   11,   26,       75,    1,   13,       95,   -9,    0,
     -36,   64,   98,      -17,   53,   84,        2,   42,   71,       21,   32,   57,
      40,   21,   43,       59,   10,   30,       78,    0,   17,       97,  -11,    3,
     -34,   62,  102,      -15,   52,   89,        5,   41,   75,       23,   30,   62,
      43,   19,   48,       62,    9,   34,       80,   -1,   21,      100,  -12,    7,
     -31,   61,  106,      -12,   50,   93,        7,   39,   79,       26,   29,   66,
      45,   18,   52,       64,    7,   38,       83,   -2,   25,      102,  -13,   11,
     -29,   59,  110,      -10,   49,   97,        9,   38,   83,       28,   27,   70,
      48,   16,   56,       66,    6,   42,       85,   -4,   29,      104,  -15,   15,
    -104,  107,  -17,      -85,   96,  -30,      -66,   85,  -44,      -47,   74,  -58,
     -28,   63,  -71,       -9,   53,  -85,       10,   42,  -98,       29,   31, -112,
    -102,  105,  -13,      -83,   95,  -26,      -64,   84,  -40,      -45,   73,  -54,
     -25,   62,  -67,       -7,   51,  -81,       12,   41,  -94,       32,   30, -108,
     -99,  104,   -9,      -81,   93,  -22,      -61,   82,  -36,      -42,   72,  -50,
     -23,   61,  -63,       -4,   50,  -77,       15,   40,  -90,       34,   29, -104,
     -97,  102,   -4,      -78,   92,  -18,      -58,   81,  -32,      -40,   70,  -45,
     -20,   59,  -59,       -2,   49,  -72,       17,   38,  -86,       37,   27,  -99,
     -94,  101,    0,      -75,   90,  -14,      -56,   79,  -28,      -37,   69,  -41,
     -18,   58,  -55,        1,   47,  -68,       20,   37,  -82,       39,   26,  -95,
     -92,  100,    3,      -73,   89,  -10,      -54,   78,  -24,      -35,   67,  -37,
     -16,   57,  -51,        3,   46,  -64,       22,   35,  -78,       41,   24,  -91,
     -89,   98,    7,      -71,   88,   -6,      -51,   77,  -20,      -33,   66,  -33,
     -13,   55,  -47,        6,   45,  -60,       24,   34,  -74,       44,   23,  -87,
     -87,   97,   11,      -68,   86,   -1,      -49,   75,  -15,      -30,   65,  -29,
     -10,   54,  -42,        8,   43,  -56,       27,   32,  -69,       46,   22,  -83,
     -84,   95,   15,      -66,   85,    2,      -46,   74,  -11,      -27,   63,  -25,
      -8,   52,  -38,       11,   42,  -52,       30,   31,  -65,       49,   20,  -79,
     -82,   94,   19,      -63,   83,    6,      -44,   72,   -7,      -25,   62,  -21,
      -6,   51,  -34,       13,   40,  -48,       32,   30,  -61,       51,   19,  -75,
     -80,   93,   23,      -61,   82,   10,      -41,   71,   -3,      -23,   61,  -17,
      -3,   50,  -30,       16,   39,  -44,       34,   28,  -57,       54,   17,  -71,
     -77,   91,   27,      -58,   81,   14,      -39,   70,    0,      -20,   59,  -13,
      -1,   48,  -26,       18,   38,  -40,       37,   27,  -53,       56,   16,  -67,
     -75,   90,   32,      -56,   79,   18,      -36,   68,    4,      -18,   58,   -8,
       2,   47,  -22,       21,   36,  -35,       39,   26,  -49,       59,   15,  -62,
     -72,   88,   36,      -53,   78,   22,      -34,   67,    8,      -15,   56,   -4,
       4,   45,  -18,       23,   35,  -31,       42,   24,  -45,       61,   13,  -58,
     -70,   87,   40,      -51,   76,   26,      -32,   66,   12,      -13,   55,    0,
       7,   44,  -14,       25,   33,  -27,       44,   23,  -41,       64,   12,  -54,
     -67,   86,   44,      -49,   75,   30,      -29,   64,   16,      -10,   54,    3,
       9,   43,  -10,       28,   32,  -23,       47,   21,  -37,       66,   11,  -50,
     -65,   84,   48,      -46,   74,   35,      -26,   63,   21,       -8,   52,    7,
      12,   41,   -5,       30,   31,  -19,       49,   20,  -32,       69,    9,  -46,
     -62,   83,   52,      -43,   72,   39,      -24,   61,   25,       -5,   51,   11,
      14,   40,   -1,       33,   29,  -15,       52,   19,  -28,       71,    8,  -42,
     -60,   82,   56,      -41,   71,   43,      -22,   60,   29,       -3,   49,   15,
      16,   38,    2,       35,   28,  -11,       54,   17,  -24,       73,    6,  -38,
     -57,   80,   60,      -39,   70,   47,      -19,   59,   33,       -1,   48,   19,
      19,   37,    6,       38,   27,   -7,       56,   16,  -20,       76,    5,  -34,
     -55,   79,   65,      -36,   68,   51,      -17,   57,   37,        2,   47,   24,
      22,   36,   10,       40,   25,   -2,       59,   14,  -16,       78,    3,  -29,
     -52,   77,   69,      -34,   67,   55,      -14,   56,   41,        5,   45,   28,
      24,   34,   14,       43,   24,    1,       62,   13,  -12,       81,    2,  -25,
     -50,   76,   73,      -31,   65,   59,      -12,   54,   45,        7,   44,   32,
      26,   33,   18,       45,   22,    5,       64,   12,   -8,       83,    1,  -21,
     -48,   75,   77,      -29,   64,   63,       -9,   53,   49,        9,   42,   36,
      29,   32,   22,       48,   21,    9,       66,   10,   -4,       86,    0,  -17,
     -45,   73,   81,      -26,   63,   67,       -7,   52,   53,       12,   41,   40,
      31,   30,   26,       50,   20,   13,       69,    9,    0,       88,   -1,  -13,
     -43,   72,   85,      -24,   61,   72,       -4,   50,   58,       14,   40,   44,
      34,   29,   31,       53,   18,   17,       71,    7,    4,       91,   -2,   -9,
     -40,   70,   89,      -21,   60,   76,       -2,   49,   62,       17,   38,   48,
      36,   27,   35,       55,   17,   21,       74,    6,    8,       93,   -4,   -5,
     -38,   69,   93,      -19,   58,   80,        0,   48,   66,       19,   37,   52,
      39,   26,   39,       57,   15,   25,       76,    5,   12,       96,   -5,   -1,
     -35,   68,   97,      -17,   57,   84,        3,   46,   70,       22,   36,   56,
      41,   25,   43,       60,   14,   29,       79,    3,   16,       98,   -7,    2,
     -33,   66,  102,      -14,   56,   88,        6,   45,   74,       24,   34,   61,
      44,   23,   47,       62,   13,   34,       81,    2,   20,      101,   -8,    7,
     -30,   65,  106,      -11,   54,   92,        8,   43,   78,       27,   33,   65,
      46,   22,   51,       65,   11,   38,       84,    1,   24,      103,   -9,   11,
     -28,   63,  110,       -9,   53,   96,       10,   42,   82,       29,   31,   69,
      48,   20,   55,       67,   10,   42,       86,    0,   28,      105,  -11,   15,
    -103,  111,  -18,      -84,  100,  -31,      -65,   89,  -45,      -46,   78,  -58,
     -27,   67,  -72,       -8,   57,  -85,       11,   46,  -99,       30,   35, -113,
    -101,  109,  -14,      -82,   99,  -27,      -63,   88,  -41,      -44,   77,  -54,
     -24,   66,  -68,       -6,   55,  -81,       13,   45,  -95,       32,   34, -109,
     -98,  108,  -10,      -80,   97,  -23,      -60,   86,  -37,      -41,   76,  -50,
     -22,   65,  -64,       -3,   54,  -77,       15,   44,  -91,       35,   33, -105,
     -96,  106,   -5,      -77,   96,  -18,      -58,   85,  -32,      -39,   74,  -46,
     -19,   63,  -59,       -1,   53,  -73,       18,   42,  -86,       38,   31, -100,
     -93,  105,   -1,      -75,   94,  -14,      -55,   83,  -28,      -36,   73,  -42,
     -17,   62,  -55,        2,   51,  -69,       21,   41,  -82,       40,   30,  -96,
     -91,  104,    2,      -72,   93,  -10,      -53,   82,  -24,      -34,   71,  -38,
     -15,   61,  -51,        4,   50,  -65,       23,   39,  -78,       42,   28,  -92,
     -89,  102,    6,      -70,   92,   -6,      -50,   81,  -20,      -32,   70,  -34,
     -12,   59,  -47,        7,   49,  -61,       25,   38,  -74,       45,   27,  -88,
     -86,  101,   10,      -67,   90,   -2,      -48,   79,  -16,      -29,   69,  -29,
     -10,   58,  -43,        9,   47,  -56,       28,   36,  -70,       47,   26,  -84,
     -83,   99,   14,      -65,   89,    1,      -45,   78,  -12,      -27,   67,  -25,
      -7,   56,  -39,       12,   46,  -52,       30,   35,  -66,       50,   24,  -80,
     -81,   98,   18,      -62,   87,    5,      -43,   76,   -8,      -24,   66,  -21,
      -5,   55,  -35,       14,   44,  -48,       33,   34,  -62,       52,   23,  -76,
     -79,   97,   22,      -60,   86,    9,      -41,   75,   -4,      -22,   65,  -17,
      -2,   54,  -31,       16,   43,  -44,       35,   32,  -58,       55,   21,  -72,
     -76,   95,   26,      -57,   85,   13,      -38,   74,    0,      -19,   63,  -13,
       0,   52,  -27,       19,   42,  -40,       38,   31,  -54,       57,   20,  -68,
     -74,   94,   31,      -55,   83,   18,      -35,   72,    4,      -17,   62,   -9,
       3,   51,  -22,       22,   40,  -36,       40,   30,  -49,       60,   19,  -63,
     -71,   92,   35,      -52,   82,   22,      -33,   71,    8,      -14,   60,   -5,
       5,   49,  -18,       24,   39,  -32,       43,   28,  -45,       62,   17,  -59,
     -69,   91,   39,      -50,   80,   26,      -31,   70,   12,      -12,   59,   -1,
       8,   48,  -14,       26,   37,  -28,       45,   27,  -41,       64,   16,  -55,
     -66,   90,   43,      -48,   79,   30,      -28,   68,   16,       -9,   58,    2,
      10,   47,  -10,       29,   36,  -24,       47,   25,  -37,       67,   15,  -51,
     -64,   88,   47,      -45,   78,   34,      -26,   67,   20,       -7,   56,    7,
      13,   45,   -6,       31,   35,  -19,       50,   24,  -33,       70,   13,  -47,
     -61,   87,   51,      -43,   76,   38,      -23,   65,   24,       -4,   55,   11,
      15,   44,   -2,       34,   33,  -15,       53,   23,  -29,       72,   12,  -43,
     -59,   86,   55,      -40,   75,   42,      -21,   64,   28,       -2,   53,   15,
      17,   42,    1,       36,   32,  -11,       55,   21,  -25,       74,   10,  -39,
     -57,   84,   59,      -38,   74,   46,      -18,   63,   32,        0,   52,   19,
      20,   41,    5,       39,   31,   -7,       57,   20,  -21,       77,    9,  -35,
     -54,   83,   64,      -35,   72,   51,      -16,   61,   37,        3,   51,   23,
      22,   40,   10,       41,   29,   -3,       60,   18,  -16,       79,    7,  -30,
     -51,   81,   68,      -33,   71,   55,      -13,   60,   41,        5,   49,   27,
      25,   38,   14,       44,   28,    0,       62,   17,  -12,       82,    6,  -26,
     -49,   80,   72,      -30,   69,   59,      -11,   58,   45,        8,   48,   31,
      27,   37,   18,       46,   26,    4,       65,   16,   -8,       84,    5,  -22,
     -47,   79,   76,      -28,   68,   63,       -9,   57,   49,       10,   46,   35,
      30,   36,   22,       48,   25,    8,       67,   14,   -4,       87,    3,  -18,
     -44,   77,   80,      -26,   67,   67,       -6,   56,   53,       13,   45,   39,
      32,   34,   26,       51,   24,   12,       70,   13,    0,       89,    2,  -14,
     -42,   76,   84,      -23,   65,   71,       -3,   54,   57,       15,   44,   44,
      35,   33,   30,       53,   22,   17,       72,   11,    3,       92,    1,  -10,
     -39,   74,   88,      -20,   64,   75,       -1,   53,   61,       18,   42,   48,
      37,   31,   34,       56,   21,   21,       75,   10,    7,       94,    0,   -6,
     -37,   73,   92,      -18,   62,   79,        1,   52,   65,       20,   41,   52,
      39,   30,   38,       58,   19,   25,       77,    9,   11,       96,   -1,   -2,
     -34,   72,   96,      -16,   61,   83,        4,   50,   69,       23,   40,   56,
      42,   29,   42,       61,   18,   29,       79,    7,   15,       99,   -3,    1,
     -32,   70,  101,      -13,   60,   88,        6,   49,   74,       25,   38,   60,
      45,   27,   47,       63,   17,   33,       82,    6,   20,      102,   -4,    6,
     -29,   69,  105,      -11,   58,   92,        9,   47,   78,       28,   37,   64,
      47,   26,   51,       66,   15,   37,       85,    5,   24,      104,   -5,   10,
     -27,   67,  109,       -8,   57,   96,       11,   46,   82,       30,   35,   68,
      49,   24,   55,       68,   14,   41,       87,    3,   28,      106,   -7,   14,
    -102,  115,  -18,      -83,  104,  -32,      -64,   93,  -45,      -45,   82,  -59,
     -26,   71,  -73,       -7,   61,  -86,       12,   50,  -99,       31,   39, -113,
    -100,  113,  -14,      -81,  103,  -28,      -62,   92,  -41,      -43,   81,  -55,
     -24,   70,  -69,       -5,   59,  -82,       14,   49,  -95,       33,   38, -109,
     -97,  112,  -10,      -79,  101,  -24,      -59,   90,  -37,      -41,   80,  -51,
     -21,   69,  -65,       -2,   58,  -78,       16,   48,  -91,       36,   37, -105,
     -95,  110,   -6,      -76,  100,  -19,      -57,   89,  -33,      -38,   78,  -46,
     -18,   67,  -60,        0,   57,  -74,       19,   46,  -87,       38,   35, -101,
     -92,  109,   -2,      -74,   98,  -15,      -54,   87,  -29,      -35,   77,  -42,
     -16,   66,  -56,        3,   55,  -70,       21,   45,  -83,       41,   34,  -97,
     -90,  108,    1,      -71,   97,  -11,      -52,   86,  -25,      -33,   75,  -38,
     -14,   65,  -52,        5,   54,  -66,       24,   43,  -79,       43,   32,  -93,
     -88,  106,    5,      -69,   96,   -7,      -49,   85,  -21,      -31,   74,  -34,
     -11,   63,  -48,        7,   53,  -62,       26,   42,  -75,       46,   31,  -89,
     -85,  105,   10,      -66,   94,   -3,      -47,   83,  -16,      -28,   73,  -30,
      -9,   62,  -44,       10,   51,  -57,       29,   40,  -70,       48,   30,  -84,
     -83,  103,   14,      -64,   93,    0,      -44,   82,  -12,      -26,   71,  -26,
      -6,   60,  -40,       13,   50,  -53,       31,   39,  -66,       51,   28,  -80,
     -80,  102,   18,      -61,   91,    4,      -42,   80,   -8,      -23,   70,  -22,
      -4,   59,  -36,       15,   48,  -49,       34,   38,  -62,       53,   27,  -76,
     -78,  101,   22,      -59,   90,    8,      -40,   79,   -4,      -21,   69,  -18,
      -1,   58,  -32,       17,   47,  -45,       36,   36,  -58,       55,   25,  -72,
     -75,   99,   26,      -57,   89,   12,      -37,   78,    0,      -18,   67,  -14,
       1,   56,  -28,       20,   46,  -41,       39,   35,  -54,       58,   24,  -68,
     -73,   98,   30,      -54,   87,   17,      -35,   76,    3,      -16,   66,   -9,
       4,   55,  -23,       22,   44,  -37,       41,   34,  -50,       61,   23,  -64,
     -70,   96,   34,      -52,   86,   21,      -32,   75,    7,      -13,   64,   -5,
       6,   53,  -19,       25,   43,  -33,       44,   32,  -46,       63,   21,  -60,
     -68,   95,   38,      -49,   84,   25,      -30,   74,   11,      -11,   63,   -1,
       8,   52,  -15,       27,   41,  -29,       46,   31,  -42,       65,   20,  -56,
     -66,   94,   42,      -47,   83,   29,      -27,   72,   15,       -9,   62,    2,
      11,   51,  -11,       30,   40,  -25,       48,   29,  -38,       68,   19,  -52,
     -63,   92,   47,      -44,   82,   33,      -25,   71,   20,       -6,   60,    6,
      13,   49,   -7,       32,   39,  -20,       51,   28,  -33,       70,   17,  -47,
     -60,   91,   51,      -42,   80,   37,      -22,   69,   24,       -3,   59,   10,
      16,   48,   -3,       35,   37,  -16,       53,   27,  -29,       73,   16,  -43,
     -58,   90,   55,      -39,   79,   41,      -20,   68,   28,       -1,   57,   14,
      18,   46,    0,       37,   36,  -12,       56,   25,  -25,       75,   14,  -39,
     -56,   88,   59,      -37,   78,   45,      -17,   67,   32,        1,   56,   18,
      21,   45,    4,       39,   35,   -8,       58,   24,  -21,       78,   13,  -35,
     -53,   87,   63,      -34,   76,   50,      -15,   65,   36,        4,   55,   23,
      23,   44,    9,       42,   33,   -4,       61,   22,  -17,       80,   11,  -31,
     -51,   85,   67,      -32,   75,   54,      -12,   64,   40,        6,   53,   27,
      26,   42,   13,       45,   32,    0,       63,   21,  -13,       83,   10,  -27,
     -48,   84,   71,      -29,   73,   58,      -10,   62,   44,        9,   52,   31,
      28,   41,   17,       47,   30,    3,       66,   20,   -9,       85,    9,  -23,
     -46,   83,   75,      -27,   72,   62,       -8,   61,   48,       11,   50,   35,
      31,   40,   21,       49,   29,    7,       68,   18,   -5,       87,    7,  -19,
     -43,   81,   79,      -25,   71,   66,       -5,   60,   52,       14,   49,   39,
      33,   38,   25,       52,   28,   11,       71,   17,   -1,       90,    6,  -15,
     -41,   80,   84,      -22,   69,   70,       -3,   58,   57,       16,   48,   43,
      36,   37,   29,       54,   26,   16,       73,   15,    3,       93,    5,  -10,
     -38,   78,   88,      -20,   68,   74,        0,   57,   61,       19,   46,   47,
      38,   35,   33,       57,   25,   20,       76,   14,    7,       95,    3,   -6,
     -36,   77,   92,      -17,   66,   78,        2,   56,   65,       21,   45,   51,
      40,   34,   37,       59,   23,   24,       78,   13,   11,       97,    2,   -2,
     -34,   76,   96,      -15,   65,   82,        5,   54,   69,       23,   44,   55,
      43,   33,   41,       62,   22,   28,       80,   11,   15,      100,    0,    1,
     -31,   74,  100,      -12,   64,   87,        7,   53,   73,       26,   42,   60,
      45,   31,   46,       64,   21,   32,       83,   10,   19,      102,    0,    5,
     -28,   73,  104,      -10,   62,   91,       10,   51,   77,       29,   41,   64,
      48,   30,   50,       67,   19,   36,       85,    9,   23,      105,   -1,    9,
     -26,   71,  108,       -7,   61,   95,       12,   50,   81,       31,   39,   68,
      50,   28,   54,       69,   18,   40,       88,    7,   27,      107,   -3,   13,
    -101,  119,  -19,      -82,  108,  -32,      -63,   97,  -46,      -44,   87,  -60,
     -25,   76,  -73,       -6,   65,  -87,       13,   55, -100,       32,   44, -114,
     -99,  118,  -15,      -80,  107,  -28,      -61,   96,  -42,      -42,   86,  -56,
     -23,   75,  -69,       -4,   64,  -83,       15,   53,  -96,       34,   42, -110,
     -96,  116,  -11,      -78,  106,  -24,      -58,   95,  -38,      -40,   84,  -52,
     -20,   73,  -65,       -1,   63,  -79,       17,   52,  -92,       37,   41, -106,
     -94,  115,   -6,      -75,  104,  -20,      -56,   93,  -34,      -37,   83,  -47,
     -17,   72,  -61,        1,   61,  -74,       20,   51,  -88,       39,   40, -101,
     -91,  113,   -2,      -73,  103,  -16,      -53,   92,  -30,      -34,   81,  -43,
     -15,   70,  -57,        4,   60,  -70,       22,   49,  -84,       42,   38,  -97,
     -89,  112,    1,      -70,  101,  -12,      -51,   91,  -26,      -32,   80,  -39,
     -13,   69,  -53,        6,   58,  -66,       25,   48,  -80,       44,   37,  -93,
     -87,  111,    5,      -68,  100,   -8,      -48,   89,  -22,      -30,   79,  -35,
     -10,   68,  -49,        8,   57,  -62,       27,   46,  -76,       47,   36,  -89,
     -84,  109,    9,      -65,   99,   -3,      -46,   88,  -17,      -27,   77,  -31,
      -8,   66,  -44,       11,   56,  -58,       30,   45,  -71,       49,   34,  -85,
     -82,  108,   13,      -63,   97,    0,      -43,   86,  -13,      -25,   76,  -27,
      -5,   65,  -40,       14,   54,  -54,       32,   44,  -67,       52,   33,  -81,
     -79,  107,   17,      -60,   96,    4,      -41,   85,   -9,      -22,   74,  -23,
      -3,   63,  -36,       16,   53,  -50,       35,   42,  -63,       54,   31,  -77,
     -77,  105,   21,      -58,   95,    8,      -39,   84,   -5,      -20,   73,  -19,
       0,   62,  -32,       18,   51,  -46,       37,   41,  -59,       57,   30,  -73,
     -74,  104,   25,      -56,   93,   12,      -36,   82,   -1,      -17,   72,  -15,
       2,   61,  -28,       21,   50,  -42,       40,   40,  -55,       59,   29,  -69,
     -72,  102,   30,      -53,   92,   16,      -33,   81,    2,      -15,   70,  -10,
       5,   59,  -24,       23,   49,  -37,       42,   38,  -51,       62,   27,  -64,
     -69,  101,   34,      -50,   90,   20,      -31,   79,    6,      -12,   69,   -6,
       7,   58,  -20,       26,   47,  -33,       45,   37,  -47,       64,   26,  -60,
     -67,  100,   38,      -48,   89,   24,      -29,   78,   10,      -10,   67,   -2,
       9,   57,  -16,       28,   46,  -29,       47,   35,  -43,       66,   24,  -56,
     -64,   98,   42,      -46,   88,   28,      -26,   77,   14,       -8,   66,    1,
      12,   55,  -12,       31,   45,  -25,       49,   34,  -39,       69,   23,  -52,
     -62,   97,   46,      -43,   86,   33,      -24,   75,   19,       -5,   65,    5,
      15,   54,   -7,       33,   43,  -21,       52,   32,  -34,       71,   22,  -48,
     -59,   95,   50,      -41,   85,   37,      -21,   74,   23,       -2,   63,    9,
      17,   52,   -3,       36,   42,  -17,       54,   31,  -30,       74,   20,  -44,
     -57,   94,   54,      -38,   83,   41,      -19,   72,   27,        0,   62,   13,
      19,   51,    0,       38,   40,  -13,       57,   30,  -26,       76,   19,  -40,
     -55,   93,   58,      -36,   82,   45,      -16,   71,   31,        2,   61,   17,
      22,   50,    4,       40,   39,   -9,       59,   28,  -22,       79,   17,  -36,
     -52,   91,   63,      -33,   81,   49,      -14,   70,   35,        5,   59,   22,
      24,   48,    8,       43,   37,   -4,       62,   27,  -18,       81,   16,  -31,
     -50,   90,   67,      -31,   79,   53,      -11,   68,   39,        7,   58,   26,
      27,   47,   12,       46,   36,    0,       64,   26,  -14,       84,   15,  -27,
     -47,   88,   71,      -28,   78,   57,       -9,   67,   43,       10,   56,   30,
      29,   45,   16,       48,   35,    3,       67,   24,  -10,       86,   13,  -23,
     -45,   87,   75,      -26,   77,   61,       -7,   66,   47,       12,   55,   34,
      32,   44,   20,       50,   33,    7,       69,   23,   -6,       89,   12,  -19,
     -42,   86,   79,      -24,   75,   65,       -4,   64,   51,       15,   54,   38,
      34,   43,   24,       53,   32,   11,       72,   21,   -2,       91,   11,  -15,
     -40,   84,   83,      -21,   74,   70,       -2,   63,   56,       17,   52,   42,
      37,   41,   29,       55,   31,   15,       74,   20,    2,       94,    9,  -11,
     -37,   83,   87,      -18,   72,   74,        1,   61,   60,       20,   51,   46,
      39,   40,   33,       58,   29,   19,       77,   19,    6,       96,    8,   -7,
     -35,   82,   91,      -16,   71,   78,        3,   60,   64,       22,   49,   50,
      41,   38,   37,       60,   28,   23,       79,   17,   10,       98,    6,   -3,
     -32,   80,   95,      -14,   70,   82,        6,   59,   68,       24,   48,   54,
      44,   37,   41,       63,   27,   27,       81,   16,   14,      101,    5,    0,
     -30,   79,  100,      -11,   68,   86,        8,   57,   72,       27,   47,   59,
      47,   36,   45,       65,   25,   32,       84,   14,   18,      103,    3,    5,
     -27,   77,  104,       -9,   67,   90,       11,   56,   76,       30,   45,   63,
      49,   34,   49,       68,   24,   36,       86,   13,   22,      106,    2,    9,
     -25,   76,  108,       -6,   65,   94,       13,   54,   80,       32,   44,   67,
      51,   33,   53,       70,   22,   40,       89,   12,   26,      108,    1,   13,
    -100,  123,  -20,      -82,  112,  -33,      -62,  101,  -47,      -43,   91,  -60,
     -24,   80,  -74,       -5,   69,  -87,       14,   59, -101,       33,   48, -115,
     -98,  122,  -16,      -79,  111,  -29,      -60,  100,  -43,      -41,   90,  -56,
     -22,   79,  -70,       -3,   68,  -83,       16,   57,  -97,       35,   46, -111,
     -96,  120,  -12,      -77,  110,  -25,      -57,   99,  -39,      -39,   88,  -52,
     -19,   77,  -66,        0,   67,  -79,       18,   56,  -93,       38,   45, -107,
     -93,  119,   -7,      -74,  108,  -20,      -55,   97,  -34,      -36,   87,  -48,
     -17,   76,  -62,        2,   65,  -75,       21,   55,  -88,       40,   44, -102,
     -90,  117,   -3,      -72,  107,  -16,      -52,   96,  -30,      -34,   85,  -44,
     -14,   74,  -58,        5,   64,  -71,       23,   53,  -84,       43,   42,  -98,
     -88,  116,    0,      -69,  105,  -12,      -50,   95,  -26,      -31,   84,  -40,
     -12,   73,  -54,        7,   62,  -67,       26,   52,  -80,       45,   41,  -94,
     -86,  115,    4,      -67,  104,   -8,      -48,   93,  -22,      -29,   83,  -36,
      -9,   72,  -50,        9,   61,  -63,       28,   50,  -76,       48,   40,  -90,
     -83,  113,    8,      -64,  103,   -4,      -45,   92,  -18,      -26,   81,  -31,
      -7,   70,  -45,       12,   60,  -58,       31,   49,  -72,       50,   38,  -86,
     -81,  112,   12,      -62,  101,    0,      -42,   90,  -14,      -24,   80,  -27,
      -4,   69,  -41,       14,   58,  -54,       33,   48,  -68,       53,   37,  -82,
     -78,  111,   16,      -59,  100,    3,      -40,   89,  -10,      -21,   78,  -23,
      -2,   67,  -37,       17,   57,  -50,       36,   46,  -64,       55,   35,  -78,
     -76,  109,   20,      -57,   99,    7,      -38,   88,   -6,      -19,   77,  -19,
       0,   66,  -33,       19,   55,  -46,       38,   45,  -60,       57,   34,  -74,
     -73,  108,   24,      -55,   97,   11,      -35,   86,   -2,      -16,   76,  -15,
       3,   65,  -29,       22,   54,  -42,       40,   44,  -56,       60,   33,  -70,
     -71,  106,   29,      -52,   96,   16,      -33,   85,    2,      -14,   74,  -11,
       6,   63,  -25,       24,   53,  -38,       43,   42,  -51,       63,   31,  -65,
     -68,  105,   33,      -50,   94,   20,      -30,   83,    6,      -11,   73,   -7,
       8,   62,  -21,       27,   51,  -34,       46,   41,  -47,       65,   30,  -61,
     -66,  104,   37,      -47,   93,   24,      -28,   82,   10,       -9,   71,   -3,
      10,   61,  -17,       29,   50,  -30,       48,   39,  -43,       67,   28,  -57,
     -64,  102,   41,      -45,   92,   28,      -25,   81,   14,       -7,   70,    0,
      13,   59,  -13,       32,   49,  -26,       50,   38,  -39,       70,   27,  -53,
     -61,  101,   45,      -42,   90,   32,      -23,   79,   18,       -4,   69,    5,
      15,   58,   -8,       34,   47,  -21,       53,   36,  -35,       72,   26,  -49,
     -58,   99,   49,      -40,   89,   36,      -20,   78,   22,       -2,   67,    9,
      18,   56,   -4,       37,   46,  -17,       55,   35,  -31,       75,   24,  -45,
     -56,   98,   53,      -37,   87,   40,      -18,   76,   26,        1,   66,   13,
      20,   55,    0,       39,   44,  -13,       58,   34,  -27,       77,   23,  -41,
     -54,   97,   57,      -35,   86,   44,      -16,   75,   30,        3,   65,   17,
      23,   54,    3,       41,   43,   -9,       60,   32,  -23,       80,   21,  -37,
     -51,   95,   62,      -32,   85,   49,      -13,   74,   35,        6,   63,   21,
      25,   52,    7,       44,   41,   -5,       63,   31,  -18,       82,   20,  -32,
     -49,   94,   66,      -30,   83,   53,      -10,   72,   39,        8,   62,   25,
      28,   51,   11,       46,   40,   -1,       65,   30,  -14,       85,   19,  -28,
     -46,   92,   70,      -27,   82,   57,       -8,   71,   43,       11,   60,   29,
      30,   49,   15,       49,   39,    2,       68,   28,  -10,       87,   17,  -24,
     -44,   91,   74,      -25,   81,   61,       -6,   70,   47,       13,   59,   33,
      32,   48,   19,       51,   37,    6,       70,   27,   -6,       89,   16,  -20,
     -41,   90,   78,      -23,   79,   65,       -3,   68,   51,       16,   58,   37,
      35,   47,   23,       54,   36,   10,       72,   25,   -2,       92,   15,  -16,
     -39,   88,   82,      -20,   78,   69,       -1,   67,   55,       18,   56,   42,
      38,   45,   28,       56,   35,   15,       75,   24,    1,       95,   13,  -12,
     -36,   87,   86,      -18,   76,   73,        2,   65,   59,       21,   55,   46,
      40,   44,   32,       59,   33,   19,       78,   23,    5,       97,   12,   -8,
     -34,   86,   90,      -15,   75,   77,        4,   64,   63,       23,   53,   50,
      42,   42,   36,       61,   32,   23,       80,   21,    9,       99,   10,   -4,
     -32,   84,   94,      -13,   74,   81,        7,   63,   67,       25,   52,   54,
      45,   41,   40,       64,   31,   27,       82,   20,   13,      102,    9,    0,
     -29,   83,   99,      -10,   72,   86,        9,   61,   72,       28,   51,   58,
      47,   40,   44,       66,   29,   31,       85,   18,   18,      104,    7,    4,
     -26,   81,  103,       -8,   71,   90,       12,   60,   76,       30,   49,   62,
      50,   38,   48,       69,   28,   35,       87,   17,   22,      107,    6,    8,
     -24,   80,  107,       -5,   69,   94,       14,   58,   80,       33,   48,   66,
      52,   37,   52,       71,   26,   39,       90,   16,   26,      109,    5,   12,
     -99,  127,  -20,      -81,  116,  -34,      -61,  105,  -47,      -42,   95,  -61,
     -23,   84,  -75,       -4,   73,  -88,       14,   63, -101,       34,   52, -115,
     -97,  126,  -16,      -78,  115,  -30,      -59,  104,  -43,      -40,   94,  -57,
     -21,   83,  -71,       -2,   72,  -84,       17,   61,  -97,       36,   50, -111,
     -95,  124,  -12,      -76,  114,  -26,      -56,  103,  -39,      -38,   92,  -53,
     -18,   81,  -67,        0,   71,  -80,       19,   60,  -93,       39,   49, -107,
     -92,  123,   -8,      -73,  112,  -21,      -54,  101,  -35,      -35,   91,  -48,
     -16,   80,  -62,        3,   69,  -76,       22,   59,  -89,       41,   48, -103,
     -90,  121,   -4,      -71,  111,  -17,      -51,  100,  -31,      -33,   89,  -44,
     -13,   78,  -58,        6,   68,  -72,       24,   57,  -85,       44,   46,  -99,
     -87,  120,    0,      -68,  109,  -13,      -49,   99,  -27,      -30,   88,  -40,
     -11,   77,  -54,        8,   66,  -68,       27,   56,  -81,       46,   45,  -95,
     -85,  119,    3,      -66,  108,   -9,      -47,   97,  -23,      -28,   87,  -36,
      -8,   76,  -50,       10,   65,  -64,       29,   54,  -77,       48,   44,  -91,
     -82,  117,    8,      -63,  107,   -5,      -44,   96,  -18,      -25,   85,  -32,
      -6,   74,  -46,       13,   64,  -59,       32,   53,  -72,       51,   42,  -86,
     -80,  116,   12,      -61,  105,   -1,      -42,   94,  -14,      -23,   84,  -28,
      -3,   73,  -42,       15,   62,  -55,       34,   52,  -68,       54,   41,  -82,
     -77,  115,   16,      -59,  104,    2,      -39,   93,  -10,      -20,   82,  -24,
      -1,   71,  -38,       18,   61,  -51,       37,   50,  -64,       56,   39,  -78,
     -75,  113,   20,      -56,  103,    6,      -37,   92,   -6,      -18,   81,  -20,
       1,   70,  -34,       20,   59,  -47,       39,   49,  -60,       58,   38,  -74,
     -73,  112,   24,      -54,  101,   10,      -34,   90,   -2,      -16,   80,  -16,
       4,   69,  -30,       23,   58,  -43,       41,   48,  -56,       61,   37,  -70,
     -70,  110,   28,      -51,  100,   15,      -32,   89,    1,      -13,   78,  -11,
       6,   67,  -25,       25,   57,  -39,       44,   46,  -52,       63,   35,  -66,
     -67,  109,   32,      -49,   98,   19,      -29,   87,    5,      -10,   77,   -7,
       9,   66,  -21,       28,   55,  -35,       46,   45,  -48,       66,   34,  -62,
     -65,  108,   36,      -46,   97,   23,      -27,   86,    9,       -8,   75,   -3,
      11,   65,  -17,       30,   54,  -31,       49,   43,  -44,       68,   32,  -58,
     -63,  106,   40,      -44,   96,   27,      -24,   85,   13,       -6,   74,    0,
      14,   63,  -13,       32,   53,  -27,       51,   42,  -40,       71,   31,  -54,
     -60,  105,   45,      -41,   94,   31,      -22,   83,   18,       -3,   73,    4,
      16,   62,   -9,       35,   51,  -22,       54,   40,  -35,       73,   30,  -49,
     -58,  103,   49,      -39,   93,   35,      -19,   82,   22,       -1,   71,    8,
      19,   60,   -5,       38,   50,  -18,       56,   39,  -31,       76,   28,  -45,
     -55,  102,   53,      -36,   91,   39,      -17,   80,   26,        2,   70,   12,
      21,   59,   -1,       40,   48,  -14,       59,   38,  -27,       78,   27,  -41,
     -53,  101,   57,      -34,   90,   43,      -15,   79,   30,        4,   69,   16,
      24,   58,    2,       42,   47,  -10,       61,   36,  -23,       80,   25,  -37,
     -50,   99,   61,      -31,   89,   48,      -12,   78,   34,        7,   67,   21,
      26,   56,    7,       45,   45,   -6,       64,   35,  -19,       83,   24,  -33,
     -48,   98,   65,      -29,   87,   52,      -10,   76,   38,        9,   66,   25,
      29,   55,   11,       47,   44,   -2,       66,   34,  -15,       86,   23,  -29,
     -45,   96,   69,      -27,   86,   56,       -7,   75,   42,       12,   64,   29,
      31,   53,   15,       50,   43,    1,       69,   32,  -11,       88,   21,  -25,
     -43,   95,   73,      -24,   85,   60,       -5,   74,   46,       14,   63,   33,
      33,   52,   19,       52,   41,    5,       71,   31,   -7,       90,   20,  -21,
     -41,   94,   77,      -22,   83,   64,       -2,   72,   50,       16,   62,   37,
      36,   51,   23,       55,   40,    9,       73,   29,   -3,       93,   19,  -17,
     -38,   92,   82,      -19,   82,   68,        0,   71,   55,       19,   60,   41,
      38,   49,   27,       57,   39,   14,       76,   28,    1,       95,   17,  -12,
     -35,   91,   86,      -17,   80,   72,        3,   69,   59,       21,   59,   45,
      41,   48,   31,       60,   37,   18,       78,   27,    5,       98,   16,   -8,
     -33,   90,   90,      -14,   79,   76,        5,   68,   63,       24,   57,   49,
      43,   46,   35,       62,   36,   22,       81,   25,    9,      100,   14,   -4,
     -31,   88,   94,      -12,   78,   80,        7,   67,   67,       26,   56,   53,
      46,   45,   39,       64,   35,   26,       83,   24,   13,      103,   13,    0,
     -28,   87,   98,       -9,   76,   85,       10,   65,   71,       29,   55,   58,
      48,   44,   44,       67,   33,   30,       86,   22,   17,      105,   11,    3,
     -26,   85,  102,       -7,   75,   89,       13,   64,   75,       31,   53,   62,
      51,   42,   48,       70,   32,   34,       88,   21,   21,      108,   10,    7,
     -23,   84,  106,       -4,   73,   93,       15,   62,   79,       34,   52,   66,
      53,   41,   52,       72,   30,   38,       91,   20,   25,      110,    9,   11,
};

const int8_t rest_yuv_table[8*3] = {0,2,5,7,9,12,14,16,  0,-1,-3,-4,-5,-7,-8,-9,  0,-2,-3,-5,-7,-8,-10,-11};

//原yuv_table 保留至1/8,即24KB处, 记为yuv_table_small
#define TABLE_SIZE (8*1024*3)

int8_t yuv_table(uint32_t idx)
{
	return yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[((idx%3)<<3)+(idx/TABLE_SIZE)];
}

//idx must %3 ==0
void pix_fill_yuv(uint32_t idx, int8_t* y, int8_t* u, int8_t* v)
{
	int8_t* ptr=&yuv_table_small[idx%TABLE_SIZE];
	*y = *(ptr+0)+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	*u = *(ptr+1)+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	*v = *(ptr+2)+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	return;
}


void pix_fill_8y(uint16_t* pixels, uint32_t ofs, int8_t* y)
{
	// int8_t* ptr;
	uint32_t idx;
	uint64_t data[2];
	data[0] = *((uint64_t*)(pixels+ofs));
	data[1] = *((uint64_t*)(pixels+ofs+4));	
	uint16_t* dat = (uint16_t*)&data;
	
	idx=dat[0]*3;
	y[0] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[1]*3;
	y[1] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[2]*3;
	y[2] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[3]*3;
	y[3] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[4]*3;
	y[4] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[5]*3;
	y[5] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[6]*3;
	y[6] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	idx=dat[7]*3;
	y[7] = yuv_table_small[idx%TABLE_SIZE]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	
	/*idx=pixels[ofs + 0]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[0] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	
	idx=pixels[ofs + 1]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[1] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	
	idx=pixels[ofs + 2]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[2] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	
	idx=pixels[ofs + 3]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[3] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];

	idx=pixels[ofs + 4]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[4] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];

	idx=pixels[ofs + 5]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[5] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];

	idx=pixels[ofs + 6]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[6] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];

	idx=pixels[ofs + 7]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[7] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
*/
	return;
}

void pix_fill_8uv2(uint16_t* pixels, uint32_t ofs, int8_t* u, int8_t* v)
{
	int8_t* ptr;
	uint32_t idx;
	
	idx=pixels[ofs+0]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[0] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[0] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+2]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[1] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[1] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+4]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[2] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[2] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+6]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[3] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[3] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+8]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[4] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[4] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+10]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[5] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[5] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+12]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[6] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[6] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=pixels[ofs+14]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	u[7] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[7] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
}


void pix_fill_8yuv(uint16_t* pixels, uint32_t ofs, int8_t* y, int8_t* u, int8_t* v)
{
	int8_t* ptr;
	uint32_t idx;
	uint64_t data[2];
	data[0] = *((uint64_t*)(pixels+ofs));
	data[1] = *((uint64_t*)(pixels+ofs+4));	
	uint16_t* dat = (uint16_t*)&data;
	
	idx=dat[0]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[0] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[0] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[0] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[1]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[1] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[1] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[1] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[2]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[2] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[2] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[2] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[3]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[3] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[3] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[3] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[4]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[4] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[4] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[4] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[5]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[5] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[5] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[5] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[6]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[6] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[6] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[6] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	idx=dat[7]*3;
	ptr=&yuv_table_small[idx%TABLE_SIZE];
	y[7] = ptr[0]+rest_yuv_table[(0<<3)+(idx/TABLE_SIZE)];
	u[7] = ptr[1]+rest_yuv_table[(1<<3)+(idx/TABLE_SIZE)];
	v[7] = ptr[2]+rest_yuv_table[(2<<3)+(idx/TABLE_SIZE)];
	
}


#endif
#else
const int8_t yuv_table[196608] = {
    -128,    0,    0,     -110,  -10,  -13,      -90,  -21,  -27,      -72,  -32,  -40,
     -52,  -43,  -54,      -33,  -53,  -67,      -15,  -64,  -81,        5,  -75,  -95,
    -126,   -1,    4,     -107,  -11,   -9,      -88,  -22,  -23,      -69,  -33,  -36,
     -50,  -44,  -50,      -31,  -55,  -63,      -12,  -65,  -77,        7,  -76,  -91,
    -124,   -2,    8,     -105,  -13,   -5,      -86,  -24,  -19,      -67,  -34,  -32,
     -47,  -45,  -46,      -29,  -56,  -59,      -10,  -66,  -73,       10,  -77,  -87,
    -121,   -4,   12,     -102,  -14,    0,      -83,  -25,  -14,      -64,  -36,  -28,
     -45,  -47,  -41,      -26,  -57,  -55,       -7,  -68,  -68,       12,  -79,  -82,
    -119,   -5,   16,     -100,  -16,    3,      -80,  -27,  -10,      -62,  -37,  -24,
     -42,  -48,  -37,      -24,  -59,  -51,       -5,  -69,  -64,       15,  -80,  -78,
    -116,   -6,   20,      -97,  -17,    7,      -78,  -28,   -6,      -59,  -39,  -20,
     -40,  -49,  -33,      -21,  -60,  -47,       -2,  -71,  -60,       17,  -82,  -74,
    -114,   -8,   24,      -95,  -18,   11,      -76,  -29,   -2,      -57,  -40,  -16,
     -38,  -51,  -29,      -19,  -61,  -43,        0,  -72,  -56,       19,  -83,  -70,
    -111,   -9,   29,      -92,  -20,   15,      -73,  -31,    1,      -54,  -41,  -11,
     -35,  -52,  -25,      -16,  -63,  -38,        3,  -74,  -52,       22,  -84,  -66,
    -109,  -11,   33,      -90,  -21,   19,      -71,  -32,    5,      -52,  -43,   -7,
     -32,  -54,  -21,      -14,  -64,  -34,        5,  -75,  -48,       24,  -86,  -62,
    -106,  -12,   37,      -88,  -23,   23,      -68,  -34,    9,      -49,  -44,   -3,
     -30,  -55,  -17,      -11,  -66,  -30,        8,  -76,  -44,       27,  -87,  -58,
    -104,  -13,   41,      -85,  -24,   27,      -66,  -35,   13,      -47,  -45,    0,
     -28,  -56,  -13,       -9,  -67,  -26,       10,  -78,  -40,       29,  -89,  -54,
    -102,  -15,   45,      -83,  -25,   31,      -63,  -36,   17,      -45,  -47,    4,
     -25,  -58,   -9,       -6,  -68,  -22,       12,  -79,  -36,       32,  -90,  -50,
     -99,  -16,   49,      -80,  -27,   36,      -61,  -38,   22,      -42,  -48,    8,
     -23,  -59,   -4,       -4,  -70,  -18,       15,  -80,  -31,       34,  -91,  -45,
     -97,  -18,   53,      -78,  -28,   40,      -58,  -39,   26,      -40,  -50,   12,
     -20,  -61,    0,       -1,  -71,  -14,       17,  -82,  -27,       37,  -93,  -41,
     -94,  -19,   57,      -75,  -30,   44,      -56,  -40,   30,      -37,  -51,   16,
     -18,  -62,    3,        1,  -73,  -10,       20,  -83,  -23,       39,  -94,  -37,
     -92,  -20,   61,      -73,  -31,   48,      -54,  -42,   34,      -35,  -52,   20,
     -15,  -63,    7,        3,  -74,   -6,       22,  -85,  -19,       42,  -95,  -33,
     -89,  -22,   66,      -70,  -32,   52,      -51,  -43,   38,      -32,  -54,   25,
     -13,  -65,   11,        6,  -75,   -1,       25,  -86,  -15,       44,  -97,  -29,
     -87,  -23,   70,      -68,  -34,   56,      -48,  -45,   42,      -30,  -55,   29,
     -10,  -66,   15,        8,  -77,    2,       27,  -87,  -11,       47,  -98,  -25,
     -84,  -24,   74,      -65,  -35,   60,      -46,  -46,   46,      -27,  -57,   33,
      -8,  -68,   19,       11,  -78,    6,       30,  -89,   -7,       49, -100,  -21,
     -82,  -26,   78,      -63,  -36,   64,      -44,  -47,   50,      -25,  -58,   37,
      -6,  -69,   23,       13,  -79,   10,       32,  -90,   -3,       51, -101,  -17,
     -79,  -27,   82,      -60,  -38,   69,      -41,  -49,   55,      -22,  -59,   41,
      -3,  -70,   28,       16,  -81,   14,       35,  -92,    1,       54, -103,  -12,
     -77,  -29,   86,      -58,  -39,   73,      -39,  -50,   59,      -20,  -61,   45,
       0,  -72,   32,       18,  -82,   18,       37,  -93,    5,       56, -104,   -8,
     -74,  -30,   90,      -56,  -41,   77,      -36,  -52,   63,      -17,  -62,   49,
       2,  -73,   36,       21,  -84,   22,       39,  -94,    9,       59, -105,   -4,
     -72,  -31,   94,      -53,  -42,   81,      -34,  -53,   67,      -15,  -64,   53,
       4,  -74,   40,       23,  -85,   26,       42,  -96,   13,       61, -107,    0,
     -70,  -33,   98,      -51,  -43,   85,      -31,  -54,   71,      -13,  -65,   57,
       7,  -76,   44,       25,  -86,   30,       44,  -97,   17,       64, -108,    3,
     -67,  -34,  103,      -48,  -45,   89,      -29,  -56,   75,      -10,  -66,   62,
       9,  -77,   48,       28,  -88,   35,       47,  -99,   21,       66, -109,    7,
     -65,  -36,  107,      -46,  -46,   93,      -26,  -57,   79,       -8,  -68,   66,
      12,  -79,   52,       31,  -89,   39,       49, -100,   25,       69, -111,   11,
     -62,  -37,  111,      -43,  -48,   97,      -24,  -58,   83,       -5,  -69,   70,
      14,  -80,   56,       33,  -91,   43,       52, -101,   29,       71, -112,   15,
     -60,  -38,  115,      -41,  -49,  101,      -22,  -60,   87,       -3,  -70,   74,
      17,  -81,   60,       35,  -92,   47,       54, -103,   33,       74, -114,   19,
     -57,  -40,  119,      -38,  -50,  106,      -19,  -61,   92,        0,  -72,   78,
      19,  -83,   65,       38,  -93,   51,       57, -104,   38,       76, -115,   24,
     -55,  -41,  123,      -36,  -52,  110,      -16,  -63,   96,        2,  -73,   82,
      22,  -84,   69,       40,  -95,   55,       59, -105,   42,       79, -116,   28,
     -52,  -43,  127,      -33,  -53,  114,      -14,  -64,  100,        5,  -75,   86,
      24,  -86,   73,       43,  -96,   59,       62, -107,   46,       81, -118,   32,
    -128,    4,    0,     -109,   -6,  -14,      -89,  -17,  -27,      -71,  -28,  -41,
     -51,  -39,  -55,      -32,  -49,  -68,      -14,  -60,  -81,        6,  -71,  -95,
    -125,    2,    3,     -106,   -7,  -10,      -87,  -18,  -23,      -68,  -29,  -37,
     -49,  -40,  -51,      -30,  -51,  -64,      -11,  -61,  -77,        8,  -72,  -91,
    -123,    1,    7,     -104,   -9,   -6,      -85,  -20,  -19,      -66,  -30,  -33,
     -46,  -41,  -47,      -28,  -52,  -60,       -9,  -62,  -73,       10,  -73,  -87,
    -120,    0,   11,     -101,  -10,   -1,      -82,  -21,  -15,      -63,  -32,  -28,
     -44,  -43,  -42,      -25,  -53,  -55,       -6,  -64,  -69,       13,  -75,  -83,
    -118,   -1,   15,      -99,  -12,    2,      -80,  -23,  -11,      -61,  -33,  -24,
     -41,  -44,  -38,      -23,  -55,  -51,       -4,  -65,  -65,       16,  -76,  -79,
    -115,   -2,   19,      -97,  -13,    6,      -77,  -24,   -7,      -58,  -35,  -20,
     -39,  -45,  -34,      -20,  -56,  -47,       -1,  -67,  -61,       18,  -78,  -75,
    -113,   -4,   23,      -94,  -14,   10,      -75,  -25,   -3,      -56,  -36,  -16,
     -37,  -47,  -30,      -18,  -57,  -43,        1,  -68,  -57,       20,  -79,  -71,
    -110,   -5,   28,      -91,  -16,   14,      -72,  -27,    1,      -53,  -37,  -12,
     -34,  -48,  -26,      -15,  -59,  -39,        4,  -70,  -52,       23,  -80,  -66,
    -108,   -7,   32,      -89,  -17,   18,      -70,  -28,    5,      -51,  -39,   -8,
     -32,  -50,  -22,      -13,  -60,  -35,        6,  -71,  -48,       25,  -82,  -62,
    -105,   -8,   36,      -87,  -19,   22,      -67,  -30,    9,      -49,  -40,   -4,
     -29,  -51,  -18,      -10,  -62,  -31,        8,  -72,  -44,       28,  -83,  -58,
    -103,   -9,   40,      -84,  -20,   26,      -65,  -31,   13,      -46,  -41,    0,
     -27,  -52,  -14,       -8,  -63,  -27,       11,  -74,  -40,       30,  -85,  -54,
    -101,  -11,   44,      -82,  -21,   30,      -63,  -32,   17,      -44,  -43,    3,
     -24,  -54,  -10,       -6,  -64,  -23,       13,  -75,  -36,       33,  -86,  -50,
     -98,  -12,   48,      -79,  -23,   35,      -60,  -34,   21,      -41,  -44,    8,
     -22,  -55,   -5,       -3,  -66,  -18,       16,  -76,  -32,       35,  -87,  -46,
     -96,  -14,   52,      -77,  -24,   39,      -57,  -35,   25,      -39,  -46,   12,
     -19,  -57,   -1,       -1,  -67,  -14,       18,  -78,  -28,       38,  -89,  -42,
     -93,  -15,   56,      -74,  -26,   43,      -55,  -36,   29,      -36,  -47,   16,
     -17,  -58,    2,        2,  -69,  -10,       21,  -79,  -24,       40,  -90,  -38,
     -91,  -16,   60,      -72,  -27,   47,      -53,  -38,   33,      -34,  -48,   20,
     -15,  -59,    6,        4,  -70,   -6,       23,  -81,  -20,       42,  -91,  -34,
     -88,  -18,   65,      -69,  -28,   51,      -50,  -39,   38,      -31,  -50,   24,
     -12,  -61,   10,        7,  -71,   -2,       26,  -82,  -15,       45,  -93,  -29,
     -86,  -19,   69,      -67,  -30,   55,      -48,  -41,   42,      -29,  -51,   28,
      -9,  -62,   14,        9,  -73,    1,       28,  -83,  -11,       48,  -94,  -25,
     -83,  -20,   73,      -65,  -31,   59,      -45,  -42,   46,      -26,  -53,   32,
      -7,  -64,   18,       12,  -74,    5,       31,  -85,   -7,       50,  -96,  -21,
     -81,  -22,   77,      -62,  -32,   63,      -43,  -43,   50,      -24,  -54,   36,
      -5,  -65,   22,       14,  -75,    9,       33,  -86,   -3,       52,  -97,  -17,
     -78,  -23,   81,      -59,  -34,   68,      -40,  -45,   54,      -21,  -55,   41,
      -2,  -66,   27,       17,  -77,   14,       36,  -88,    0,       55,  -99,  -13,
     -76,  -25,   85,      -57,  -35,   72,      -38,  -46,   58,      -19,  -57,   45,
       0,  -68,   31,       19,  -78,   18,       38,  -89,    4,       57, -100,   -9,
     -73,  -26,   89,      -55,  -37,   76,      -35,  -48,   62,      -17,  -58,   49,
       3,  -69,   35,       22,  -80,   22,       40,  -90,    8,       60, -101,   -5,
     -71,  -27,   93,      -52,  -38,   80,      -33,  -49,   66,      -14,  -60,   53,
       5,  -70,   39,       24,  -81,   26,       43,  -92,   12,       62, -103,   -1,
     -69,  -29,   97,      -50,  -39,   84,      -31,  -50,   70,      -12,  -61,   57,
       8,  -72,   43,       26,  -82,   30,       45,  -93,   16,       65, -104,    2,
     -66,  -30,  102,      -47,  -41,   88,      -28,  -52,   75,       -9,  -62,   61,
      10,  -73,   47,       29,  -84,   34,       48,  -95,   21,       67, -105,    7,
     -64,  -32,  106,      -45,  -42,   92,      -25,  -53,   79,       -7,  -64,   65,
      13,  -75,   51,       31,  -85,   38,       50,  -96,   25,       70, -107,   11,
     -61,  -33,  110,      -42,  -44,   96,      -23,  -54,   83,       -4,  -65,   69,
      15,  -76,   55,       34,  -87,   42,       53,  -97,   29,       72, -108,   15,
     -59,  -34,  114,      -40,  -45,  100,      -21,  -56,   87,       -2,  -66,   73,
      17,  -77,   59,       36,  -88,   46,       55,  -99,   33,       74, -110,   19,
     -56,  -36,  118,      -37,  -46,  105,      -18,  -57,   91,        1,  -68,   78,
      20,  -79,   64,       39,  -89,   51,       58, -100,   37,       77, -111,   23,
     -54,  -37,  122,      -35,  -48,  109,      -16,  -59,   95,        3,  -69,   82,
      23,  -80,   68,       41,  -91,   55,       60, -101,   41,       80, -112,   27,
     -51,  -39,  126,      -33,  -49,  113,      -13,  -60,   99,        6,  -71,   86,
      25,  -82,   72,       44,  -92,   59,       63, -103,   45,       82, -114,   31,
    -127,    8,   -1,     -108,   -2,  -14,      -89,  -13,  -28,      -70,  -24,  -41,
     -50,  -35,  -55,      -32,  -45,  -69,      -13,  -56,  -82,        7,  -67,  -96,
    -124,    6,    2,     -105,   -3,  -10,      -86,  -14,  -24,      -67,  -25,  -37,
     -48,  -36,  -51,      -29,  -47,  -65,      -10,  -57,  -78,        9,  -68,  -92,
    -122,    5,    6,     -103,   -5,   -6,      -84,  -16,  -20,      -65,  -26,  -33,
     -46,  -37,  -47,      -27,  -48,  -61,       -8,  -58,  -74,       11,  -69,  -88,
    -119,    3,   11,     -100,   -6,   -2,      -81,  -17,  -16,      -62,  -28,  -29,
     -43,  -39,  -43,      -24,  -49,  -56,       -5,  -60,  -70,       14,  -71,  -83,
    -117,    2,   15,      -98,   -8,    1,      -79,  -19,  -12,      -60,  -29,  -25,
     -40,  -40,  -39,      -22,  -51,  -52,       -3,  -61,  -66,       16,  -72,  -79,
    -114,    1,   19,      -96,   -9,    5,      -76,  -20,   -8,      -57,  -31,  -21,
     -38,  -41,  -35,      -19,  -52,  -48,       -1,  -63,  -62,       19,  -74,  -75,
    -112,    0,   23,      -93,  -10,    9,      -74,  -21,   -4,      -55,  -32,  -17,
     -36,  -43,  -31,      -17,  -53,  -44,        2,  -64,  -58,       21,  -75,  -71,
    -109,   -1,   27,      -91,  -12,   14,      -71,  -23,    0,      -52,  -33,  -12,
     -33,  -44,  -26,      -14,  -55,  -40,        5,  -66,  -53,       24,  -76,  -67,
    -107,   -3,   31,      -88,  -13,   18,      -69,  -24,    4,      -50,  -35,   -8,
     -31,  -46,  -22,      -12,  -56,  -36,        7,  -67,  -49,       26,  -78,  -63,
    -105,   -4,   35,      -86,  -15,   22,      -66,  -26,    8,      -48,  -36,   -4,
     -28,  -47,  -18,       -9,  -58,  -32,        9,  -68,  -45,       29,  -79,  -59,
    -102,   -5,   39,      -83,  -16,   26,      -64,  -27,   12,      -45,  -37,    0,
     -26,  -48,  -14,       -7,  -59,  -28,       12,  -70,  -41,       31,  -81,  -55,
    -100,   -7,   43,      -81,  -17,   30,      -62,  -28,   16,      -43,  -39,    3,
     -23,  -50,  -10,       -5,  -60,  -24,       14,  -71,  -37,       33,  -82,  -51,
     -97,   -8,   48,      -78,  -19,   34,      -59,  -30,   20,      -40,  -40,    7,
     -21,  -51,   -6,       -2,  -62,  -19,       17,  -72,  -33,       36,  -83,  -46,
     -95,  -10,   52,      -76,  -20,   38,      -57,  -31,   24,      -38,  -42,   11,
     -18,  -53,   -2,        0,  -63,  -15,       19,  -74,  -29,       39,  -85,  -42,
     -92,  -11,   56,      -74,  -22,   42,      -54,  -32,   28,      -35,  -43,   15,
     -16,  -54,    1,        3,  -65,  -11,       22,  -75,  -25,       41,  -86,  -38,
     -90,  -12,   60,      -71,  -23,   46,      -52,  -34,   32,      -33,  -44,   19,
     -14,  -55,    5,        5,  -66,   -7,       24,  -77,  -21,       43,  -87,  -34,
     -87,  -14,   64,      -68,  -24,   51,      -49,  -35,   37,      -30,  -46,   24,
     -11,  -57,   10,        8,  -67,   -3,       27,  -78,  -16,       46,  -89,  -30,
     -85,  -15,   68,      -66,  -26,   55,      -47,  -37,   41,      -28,  -47,   28,
      -9,  -58,   14,       10,  -69,    0,       29,  -79,  -12,       48,  -90,  -26,
     -82,  -16,   72,      -64,  -27,   59,      -44,  -38,   45,      -25,  -49,   32,
      -6,  -60,   18,       13,  -70,    4,       31,  -81,   -8,       51,  -92,  -22,
     -80,  -18,   76,      -61,  -28,   63,      -42,  -39,   49,      -23,  -50,   36,
      -4,  -61,   22,       15,  -71,    8,       34,  -82,   -4,       53,  -93,  -18,
     -77,  -19,   81,      -59,  -30,   67,      -39,  -41,   53,      -20,  -51,   40,
      -1,  -62,   26,       18,  -73,   13,       37,  -84,    0,       56,  -95,  -13,
     -75,  -21,   85,      -56,  -31,   71,      -37,  -42,   57,      -18,  -53,   44,
       1,  -64,   30,       20,  -74,   17,       39,  -85,    3,       58,  -96,   -9,
     -73,  -22,   89,      -54,  -33,   75,      -34,  -44,   61,      -16,  -54,   48,
       4,  -65,   34,       23,  -76,   21,       41,  -86,    7,       61,  -97,   -5,
     -70,  -23,   93,      -51,  -34,   79,      -32,  -45,   65,      -13,  -56,   52,
       6,  -66,   38,       25,  -77,   25,       44,  -88,   11,       63,  -99,   -1,
     -68,  -25,   97,      -49,  -35,   83,      -30,  -46,   69,      -11,  -57,   56,
       9,  -68,   42,       27,  -78,   29,       46,  -89,   15,       65, -100,    2,
     -65,  -26,  101,      -46,  -37,   88,      -27,  -48,   74,       -8,  -58,   61,
      11,  -69,   47,       30,  -80,   33,       49,  -91,   20,       68, -101,    6,
     -63,  -28,  105,      -44,  -38,   92,      -25,  -49,   78,       -6,  -60,   65,
      14,  -71,   51,       32,  -81,   37,       51,  -92,   24,       71, -103,   10,
     -60,  -29,  109,      -42,  -40,   96,      -22,  -50,   82,       -3,  -61,   69,
      16,  -72,   55,       35,  -83,   41,       54,  -93,   28,       73, -104,   14,
     -58,  -30,  113,      -39,  -41,  100,      -20,  -52,   86,       -1,  -62,   73,
      18,  -73,   59,       37,  -84,   45,       56,  -95,   32,       75, -106,   18,
     -55,  -32,  118,      -36,  -42,  104,      -17,  -53,   90,        2,  -64,   77,
      21,  -75,   63,       40,  -85,   50,       59,  -96,   36,       78, -107,   23,
     -53,  -33,  122,      -34,  -44,  108,      -15,  -55,   94,        4,  -65,   81,
      23,  -76,   67,       42,  -87,   54,       61,  -97,   40,       80, -108,   27,
     -50,  -35,  126,      -32,  -45,  112,      -12,  -56,   98,        7,  -67,   85,
      26,  -78,   71,       45,  -88,   58,       63,  -99,   44,       83, -110,   31,
    -126,   12,   -2,     -107,    1,  -15,      -87,   -9,  -29,      -69,  -19,  -42,
     -49,  -30,  -56,      -31,  -41,  -69,      -12,  -51,  -83,        8,  -62,  -97,
    -123,   11,    1,     -104,    0,  -11,      -85,  -10,  -25,      -66,  -20,  -38,
     -47,  -31,  -52,      -28,  -42,  -65,       -9,  -53,  -79,       10,  -64,  -93,
    -121,    9,    5,     -102,    0,   -7,      -83,  -11,  -21,      -64,  -22,  -34,
     -45,  -33,  -48,      -26,  -43,  -61,       -7,  -54,  -75,       12,  -65,  -89,
    -118,    8,   10,      -99,   -2,   -2,      -80,  -13,  -16,      -61,  -23,  -30,
     -42,  -34,  -43,      -23,  -45,  -57,       -4,  -55,  -70,       15,  -66,  -84,
    -116,    6,   14,      -97,   -3,    1,      -78,  -14,  -12,      -59,  -25,  -26,
     -39,  -36,  -39,      -21,  -46,  -53,       -2,  -57,  -66,       17,  -68,  -80,
    -113,    5,   18,      -95,   -5,    5,      -75,  -15,   -8,      -56,  -26,  -22,
     -37,  -37,  -35,      -18,  -48,  -49,        0,  -58,  -62,       20,  -69,  -76,
    -111,    4,   22,      -92,   -6,    9,      -73,  -17,   -4,      -54,  -27,  -18,
     -35,  -38,  -31,      -16,  -49,  -45,        3,  -60,  -58,       22,  -70,  -72,
    -108,    2,   26,      -90,   -7,   13,      -70,  -18,    0,      -51,  -29,  -13,
     -32,  -40,  -27,      -13,  -50,  -40,        6,  -61,  -54,       25,  -72,  -68,
    -106,    1,   30,      -87,   -9,   17,      -68,  -20,    3,      -49,  -30,   -9,
     -30,  -41,  -23,      -11,  -52,  -36,        8,  -62,  -50,       27,  -73,  -64,
    -104,    0,   34,      -85,  -10,   21,      -65,  -21,    7,      -47,  -32,   -5,
     -27,  -43,  -19,       -8,  -53,  -32,       10,  -64,  -46,       30,  -75,  -60,
    -101,   -1,   38,      -82,  -11,   25,      -63,  -22,   11,      -44,  -33,   -1,
     -25,  -44,  -15,       -6,  -55,  -28,       13,  -65,  -42,       32,  -76,  -56,
     -99,   -2,   42,      -80,  -13,   29,      -61,  -24,   15,      -42,  -34,    2,
     -22,  -45,  -11,       -4,  -56,  -24,       15,  -66,  -38,       35,  -77,  -52,
     -96,   -4,   47,      -77,  -14,   34,      -58,  -25,   20,      -39,  -36,    6,
     -20,  -47,   -6,       -1,  -57,  -20,       18,  -68,  -33,       37,  -79,  -47,
     -94,   -5,   51,      -75,  -16,   38,      -56,  -27,   24,      -37,  -37,   10,
     -17,  -48,   -2,        1,  -59,  -16,       20,  -69,  -29,       40,  -80,  -43,
     -91,   -6,   55,      -72,  -17,   42,      -53,  -28,   28,      -34,  -39,   14,
     -15,  -49,    1,        4,  -60,  -12,       23,  -71,  -25,       42,  -82,  -39,
     -89,   -8,   59,      -70,  -18,   46,      -51,  -29,   32,      -32,  -40,   18,
     -13,  -51,    5,        6,  -61,   -8,       25,  -72,  -21,       44,  -83,  -35,
     -86,   -9,   63,      -67,  -20,   50,      -48,  -31,   36,      -29,  -41,   23,
     -10,  -52,    9,        9,  -63,   -3,       28,  -74,  -17,       47,  -84,  -31,
     -84,  -11,   67,      -65,  -21,   54,      -46,  -32,   40,      -27,  -43,   27,
      -7,  -54,   13,       11,  -64,    0,       30,  -75,  -13,       49,  -86,  -27,
     -81,  -12,   71,      -63,  -23,   58,      -43,  -34,   44,      -24,  -44,   31,
      -5,  -55,   17,       14,  -66,    4,       32,  -76,   -9,       52,  -87,  -23,
     -79,  -13,   75,      -60,  -24,   62,      -41,  -35,   48,      -22,  -45,   35,
      -3,  -56,   21,       16,  -67,    8,       35,  -78,   -5,       54,  -89,  -19,
     -76,  -15,   80,      -58,  -25,   67,      -38,  -36,   53,      -19,  -47,   39,
       0,  -58,   26,       19,  -69,   12,       38,  -79,    0,       57,  -90,  -14,
     -74,  -16,   84,      -55,  -27,   71,      -36,  -38,   57,      -17,  -48,   43,
       2,  -59,   30,       21,  -70,   16,       40,  -80,    3,       59,  -91,  -10,
     -72,  -18,   88,      -53,  -28,   75,      -33,  -39,   61,      -15,  -50,   47,
       5,  -61,   34,       24,  -71,   20,       42,  -82,    7,       62,  -93,   -6,
     -69,  -19,   92,      -50,  -29,   79,      -31,  -40,   65,      -12,  -51,   51,
       7,  -62,   38,       26,  -73,   24,       45,  -83,   11,       64,  -94,   -2,
     -67,  -20,   96,      -48,  -31,   83,      -29,  -42,   69,      -10,  -52,   55,
      10,  -63,   42,       28,  -74,   28,       47,  -85,   15,       67,  -95,    1,
     -64,  -22,  100,      -45,  -32,   87,      -26,  -43,   73,       -7,  -54,   60,
      12,  -65,   46,       31,  -75,   33,       50,  -86,   19,       69,  -97,    5,
     -62,  -23,  104,      -43,  -34,   91,      -24,  -45,   77,       -5,  -55,   64,
      15,  -66,   50,       33,  -77,   37,       52,  -87,   23,       72,  -98,    9,
     -59,  -24,  108,      -40,  -35,   95,      -21,  -46,   81,       -2,  -57,   68,
      17,  -68,   54,       36,  -78,   41,       55,  -89,   27,       74, -100,   13,
     -57,  -26,  112,      -38,  -36,   99,      -19,  -47,   85,        0,  -58,   72,
      19,  -69,   58,       38,  -79,   45,       57,  -90,   31,       76, -101,   17,
     -54,  -27,  117,      -35,  -38,  104,      -16,  -49,   90,        3,  -59,   76,
      22,  -70,   63,       41,  -81,   49,       60,  -92,   36,       79, -103,   22,
     -52,  -29,  121,      -33,  -39,  108,      -14,  -50,   94,        5,  -61,   80,
      25,  -72,   67,       43,  -82,   53,       62,  -93,   40,       81, -104,   26,
     -49,  -30,  125,      -31,  -41,  112,      -11,  -52,   98,        8,  -62,   84,
      27,  -73,   71,       46,  -84,   57,       64,  -94,   44,       84, -105,   30,
    -125,   16,   -2,     -106,    5,  -16,      -87,   -5,  -29,      -68,  -15,  -43,
     -48,  -26,  -57,      -30,  -37,  -70,      -11,  -47,  -83,        9,  -58,  -97,
    -122,   15,    1,     -104,    4,  -12,      -84,   -6,  -25,      -65,  -16,  -39,
     -46,  -27,  -53,      -27,  -38,  -66,       -8,  -49,  -79,       11,  -60,  -93,
    -120,   13,    5,     -101,    3,   -8,      -82,   -7,  -21,      -63,  -18,  -35,
     -44,  -29,  -49,      -25,  -39,  -62,       -6,  -50,  -75,       13,  -61,  -89,
    -117,   12,    9,      -98,    1,   -3,      -79,   -9,  -17,      -60,  -19,  -30,
     -41,  -30,  -44,      -22,  -41,  -58,       -3,  -51,  -71,       16,  -62,  -85,
    -115,   10,   13,      -96,    0,    0,      -77,  -10,  -13,      -58,  -21,  -26,
     -39,  -32,  -40,      -20,  -42,  -54,       -1,  -53,  -67,       18,  -64,  -81,
    -112,    9,   17,      -94,   -1,    4,      -74,  -11,   -9,      -56,  -22,  -22,
     -36,  -33,  -36,      -17,  -44,  -50,        1,  -54,  -63,       21,  -65,  -77,
    -110,    8,   21,      -91,   -2,    8,      -72,  -13,   -5,      -53,  -23,  -18,
     -34,  -34,  -32,      -15,  -45,  -46,        4,  -56,  -59,       23,  -66,  -73,
    -107,    6,   26,      -89,   -3,   12,      -69,  -14,    0,      -50,  -25,  -14,
     -31,  -36,  -28,      -12,  -46,  -41,        6,  -57,  -54,       26,  -68,  -68,
    -105,    5,   30,      -86,   -5,   16,      -67,  -16,    3,      -48,  -26,  -10,
     -29,  -37,  -24,      -10,  -48,  -37,        9,  -58,  -50,       28,  -69,  -64,
    -103,    4,   34,      -84,   -6,   20,      -64,  -17,    7,      -46,  -28,   -6,
     -26,  -39,  -20,       -8,  -49,  -33,       11,  -60,  -46,       31,  -71,  -60,
    -100,    2,   38,      -81,   -7,   24,      -62,  -18,   11,      -43,  -29,   -2,
     -24,  -40,  -16,       -5,  -51,  -29,       14,  -61,  -42,       33,  -72,  -56,
     -98,    1,   42,      -79,   -9,   28,      -60,  -20,   15,      -41,  -30,    1,
     -22,  -41,  -12,       -3,  -52,  -25,       16,  -62,  -38,       35,  -73,  -52,
     -95,    0,   46,      -76,  -10,   33,      -57,  -21,   19,      -38,  -32,    6,
     -19,  -43,   -7,        0,  -53,  -21,       19,  -64,  -34,       38,  -75,  -48,
     -93,   -1,   50,      -74,  -12,   37,      -55,  -23,   23,      -36,  -33,   10,
     -16,  -44,   -3,        2,  -55,  -17,       21,  -65,  -30,       41,  -76,  -44,
     -90,   -2,   54,      -72,  -13,   41,      -52,  -24,   27,      -33,  -35,   14,
     -14,  -45,    0,        5,  -56,  -13,       24,  -67,  -26,       43,  -78,  -40,
     -88,   -4,   58,      -69,  -14,   45,      -50,  -25,   31,      -31,  -36,   18,
     -12,  -47,    4,        7,  -57,   -9,       26,  -68,  -22,       45,  -79,  -36,
     -85,   -5,   63,      -66,  -16,   49,      -47,  -27,   36,      -28,  -37,   22,
      -9,  -48,    8,       10,  -59,   -4,       29,  -70,  -17,       48,  -80,  -31,
     -83,   -7,   67,      -64,  -17,   53,      -45,  -28,   40,      -26,  -39,   26,
      -7,  -50,   12,       12,  -60,    0,       31,  -71,  -13,       50,  -82,  -27,
     -80,   -8,   71,      -62,  -19,   57,      -42,  -30,   44,      -24,  -40,   30,
      -4,  -51,   16,       15,  -62,    3,       33,  -72,   -9,       53,  -83,  -23,
     -78,   -9,   75,      -59,  -20,   61,      -40,  -31,   48,      -21,  -41,   34,
      -2,  -52,   20,       17,  -63,    7,       36,  -74,   -5,       55,  -85,  -19,
     -75,  -11,   79,      -57,  -21,   66,      -37,  -32,   52,      -18,  -43,   39,
       1,  -54,   25,       20,  -65,   11,       38,  -75,   -1,       58,  -86,  -15,
     -73,  -12,   83,      -54,  -23,   70,      -35,  -34,   56,      -16,  -44,   43,
       3,  -55,   29,       22,  -66,   15,       41,  -76,    2,       60,  -87,  -11,
     -71,  -14,   87,      -52,  -24,   74,      -32,  -35,   60,      -14,  -46,   47,
       6,  -57,   33,       24,  -67,   19,       43,  -78,    6,       63,  -89,   -7,
     -68,  -15,   91,      -49,  -25,   78,      -30,  -36,   64,      -11,  -47,   51,
       8,  -58,   37,       27,  -69,   23,       46,  -79,   10,       65,  -90,   -3,
     -66,  -16,   95,      -47,  -27,   82,      -28,  -38,   68,       -9,  -48,   55,
      10,  -59,   41,       29,  -70,   27,       48,  -81,   14,       67,  -91,    0,
     -63,  -18,  100,      -44,  -28,   86,      -25,  -39,   73,       -6,  -50,   59,
      13,  -61,   45,       32,  -71,   32,       51,  -82,   19,       70,  -93,    5,
     -61,  -19,  104,      -42,  -30,   90,      -23,  -41,   77,       -4,  -51,   63,
      16,  -62,   49,       34,  -73,   36,       53,  -83,   23,       72,  -94,    9,
     -58,  -20,  108,      -40,  -31,   94,      -20,  -42,   81,       -1,  -53,   67,
      18,  -64,   53,       37,  -74,   40,       56,  -85,   27,       75,  -96,   13,
     -56,  -22,  112,      -37,  -32,   98,      -18,  -43,   85,        1,  -54,   71,
      20,  -65,   57,       39,  -75,   44,       58,  -86,   31,       77,  -97,   17,
     -53,  -23,  116,      -34,  -34,  103,      -15,  -45,   89,        4,  -55,   76,
      23,  -66,   62,       42,  -77,   48,       61,  -88,   35,       80,  -99,   21,
     -51,  -25,  120,      -32,  -35,  107,      -13,  -46,   93,        6,  -57,   80,
      25,  -68,   66,       44,  -78,   52,       63,  -89,   39,       82, -100,   25,
     -48,  -26,  124,      -30,  -37,  111,      -10,  -48,   97,        8,  -58,   84,
      28,  -69,   70,       47,  -80,   56,       65,  -90,   43,       85, -101,   29,
    -124,   20,   -3,     -105,    9,  -16,      -86,   -1,  -30,      -67,  -11,  -43,
     -48,  -22,  -57,      -29,  -33,  -71,      -10,  -43,  -84,        9,  -54,  -98,
    -121,   19,    0,     -103,    8,  -12,      -83,   -2,  -26,      -64,  -12,  -39,
     -45,  -23,  -53,      -26,  -34,  -67,       -8,  -45,  -80,       12,  -56,  -94,
    -119,   17,    4,     -100,    7,   -8,      -81,   -3,  -22,      -62,  -14,  -35,
     -43,  -25,  -49,      -24,  -35,  -63,       -5,  -46,  -76,       14,  -57,  -90,
    -116,   16,    9,      -98,    5,   -4,      -78,   -5,  -18,      -59,  -15,  -31,
     -40,  -26,  -45,      -21,  -37,  -58,       -2,  -47,  -72,       17,  -58,  -85,
    -114,   14,   13,      -95,    4,    0,      -76,   -6,  -14,      -57,  -17,  -27,
     -38,  -28,  -41,      -19,  -38,  -54,        0,  -49,  -68,       19,  -60,  -81,
    -112,   13,   17,      -93,    2,    3,      -73,   -7,  -10,      -55,  -18,  -23,
     -35,  -29,  -37,      -16,  -40,  -50,        2,  -50,  -64,       22,  -61,  -77,
    -109,   12,   21,      -90,    1,    7,      -71,   -9,   -6,      -52,  -19,  -19,
     -33,  -30,  -33,      -14,  -41,  -46,        5,  -52,  -60,       24,  -62,  -73,
    -106,   10,   25,      -88,    0,   12,      -68,  -10,   -1,      -50,  -21,  -14,
     -30,  -32,  -28,      -11,  -42,  -42,        7,  -53,  -55,       27,  -64,  -69,
    -104,    9,   29,      -85,   -1,   16,      -66,  -12,    2,      -47,  -22,  -10,
     -28,  -33,  -24,       -9,  -44,  -38,       10,  -54,  -51,       29,  -65,  -65,
    -102,    8,   33,      -83,   -2,   20,      -64,  -13,    6,      -45,  -24,   -6,
     -25,  -35,  -20,       -7,  -45,  -34,       12,  -56,  -47,       32,  -67,  -61,
     -99,    6,   37,      -81,   -3,   24,      -61,  -14,   10,      -42,  -25,   -2,
     -23,  -36,  -16,       -4,  -47,  -30,       15,  -57,  -43,       34,  -68,  -57,
     -97,    5,   41,      -78,   -5,   28,      -59,  -16,   14,      -40,  -26,    1,
     -21,  -37,  -12,       -2,  -48,  -26,       17,  -58,  -39,       36,  -69,  -53,
     -94,    3,   46,      -75,   -6,   32,      -56,  -17,   18,      -37,  -28,    5,
     -18,  -39,   -8,        1,  -49,  -21,       20,  -60,  -35,       39,  -71,  -48,
     -92,    2,   50,      -73,   -8,   36,      -54,  -19,   22,      -35,  -29,    9,
     -16,  -40,   -4,        3,  -51,  -17,       22,  -61,  -31,       41,  -72,  -44,
     -89,    1,   54,      -71,   -9,   40,      -51,  -20,   26,      -33,  -31,   13,
     -13,  -41,    0,        6,  -52,  -13,       24,  -63,  -27,       44,  -74,  -40,
     -87,    0,   58,      -68,  -10,   44,      -49,  -21,   30,      -30,  -32,   17,
     -11,  -43,    3,        8,  -53,   -9,       27,  -64,  -23,       46,  -75,  -36,
     -84,   -1,   62,      -66,  -12,   49,      -46,  -23,   35,      -27,  -33,   22,
      -8,  -44,    8,       11,  -55,   -5,       30,  -66,  -18,       49,  -76,  -32,
     -82,   -3,   66,      -63,  -13,   53,      -44,  -24,   39,      -25,  -35,   26,
      -6,  -46,   12,       13,  -56,   -1,       32,  -67,  -14,       51,  -78,  -28,
     -80,   -4,   70,      -61,  -15,   57,      -41,  -26,   43,      -23,  -36,   30,
      -3,  -47,   16,       16,  -58,    2,       34,  -68,  -10,       54,  -79,  -24,
     -77,   -5,   74,      -58,  -16,   61,      -39,  -27,   47,      -20,  -37,   34,
      -1,  -48,   20,       18,  -59,    6,       37,  -70,   -6,       56,  -81,  -20,
     -74,   -7,   79,      -56,  -17,   65,      -36,  -28,   51,      -18,  -39,   38,
       2,  -50,   24,       21,  -61,   11,       39,  -71,   -2,       59,  -82,  -15,
     -72,   -8,   83,      -53,  -19,   69,      -34,  -30,   55,      -15,  -40,   42,
       4,  -51,   28,       23,  -62,   15,       42,  -72,    1,       61,  -83,  -11,
     -70,  -10,   87,      -51,  -20,   73,      -32,  -31,   59,      -13,  -42,   46,
       7,  -53,   32,       25,  -63,   19,       44,  -74,    5,       64,  -85,   -7,
     -67,  -11,   91,      -49,  -21,   77,      -29,  -32,   63,      -10,  -43,   50,
       9,  -54,   36,       28,  -65,   23,       47,  -75,    9,       66,  -86,   -3,
     -65,  -12,   95,      -46,  -23,   81,      -27,  -34,   67,       -8,  -44,   54,
      11,  -55,   40,       30,  -66,   27,       49,  -77,   13,       68,  -87,    0,
     -62,  -14,   99,      -43,  -24,   86,      -24,  -35,   72,       -5,  -46,   59,
      14,  -57,   45,       33,  -67,   31,       52,  -78,   18,       71,  -89,    4,
     -60,  -15,  103,      -41,  -26,   90,      -22,  -37,   76,       -3,  -47,   63,
      16,  -58,   49,       35,  -69,   35,       54,  -79,   22,       73,  -90,    8,
     -57,  -16,  107,      -39,  -27,   94,      -19,  -38,   80,       -1,  -49,   67,
      19,  -60,   53,       38,  -70,   39,       56,  -81,   26,       76,  -92,   12,
     -55,  -18,  111,      -36,  -28,   98,      -17,  -39,   84,        2,  -50,   71,
      21,  -61,   57,       40,  -71,   43,       59,  -82,   30,       78,  -93,   16,
     -52,  -19,  116,      -34,  -30,  102,      -14,  -41,   88,        5,  -51,   75,
      24,  -62,   61,       43,  -73,   48,       62,  -84,   34,       81,  -95,   21,
     -50,  -21,  120,      -31,  -31,  106,      -12,  -42,   92,        7,  -53,   79,
      26,  -64,   65,       45,  -74,   52,       64,  -85,   38,       83,  -96,   25,
     -48,  -22,  124,      -29,  -33,  110,       -9,  -44,   96,        9,  -54,   83,
      29,  -65,   69,       48,  -76,   56,       66,  -86,   42,       86,  -97,   29,
    -123,   24,   -3,     -104,   13,  -17,      -85,    2,  -31,      -66,   -7,  -44,
     -47,  -18,  -58,      -28,  -29,  -71,       -9,  -39,  -85,       10,  -50,  -99,
    -121,   23,    0,     -102,   12,  -13,      -82,    1,  -27,      -64,   -8,  -40,
     -44,  -19,  -54,      -25,  -30,  -67,       -7,  -41,  -81,       13,  -52,  -95,
    -118,   21,    4,      -99,   11,   -9,      -80,    0,  -23,      -61,  -10,  -36,
     -42,  -21,  -50,      -23,  -31,  -63,       -4,  -42,  -77,       15,  -53,  -91,
    -115,   20,    8,      -97,    9,   -4,      -77,   -1,  -18,      -58,  -11,  -32,
     -39,  -22,  -45,      -20,  -33,  -59,       -2,  -43,  -72,       18,  -54,  -86,
    -113,   18,   12,      -94,    8,    0,      -75,   -2,  -14,      -56,  -13,  -28,
     -37,  -24,  -41,      -18,  -34,  -55,        1,  -45,  -68,       20,  -56,  -82,
    -111,   17,   16,      -92,    6,    3,      -72,   -3,  -10,      -54,  -14,  -24,
     -34,  -25,  -37,      -16,  -36,  -51,        3,  -46,  -64,       23,  -57,  -78,
    -108,   16,   20,      -89,    5,    7,      -70,   -5,   -6,      -51,  -15,  -20,
     -32,  -26,  -33,      -13,  -37,  -47,        6,  -48,  -60,       25,  -58,  -74,
    -106,   14,   25,      -87,    4,   11,      -67,   -6,   -2,      -49,  -17,  -15,
     -29,  -28,  -29,      -10,  -38,  -42,        8,  -49,  -56,       28,  -60,  -70,
    -103,   13,   29,      -84,    2,   15,      -65,   -8,    1,      -46,  -18,  -11,
     -27,  -29,  -25,       -8,  -40,  -38,       11,  -50,  -52,       30,  -61,  -66,
    -101,   12,   33,      -82,    1,   19,      -63,   -9,    5,      -44,  -20,   -7,
     -24,  -31,  -21,       -6,  -41,  -34,       13,  -52,  -48,       32,  -63,  -62,
     -98,   10,   37,      -80,    0,   23,      -60,  -10,    9,      -41,  -21,   -3,
     -22,  -32,  -17,       -3,  -43,  -30,       15,  -53,  -44,       35,  -64,  -58,
     -96,    9,   41,      -77,   -1,   27,      -58,  -12,   13,      -39,  -22,    0,
     -20,  -33,  -13,       -1,  -44,  -26,       18,  -54,  -40,       37,  -65,  -54,
     -93,    7,   45,      -75,   -2,   32,      -55,  -13,   18,      -36,  -24,    4,
     -17,  -35,   -8,        2,  -45,  -22,       21,  -56,  -35,       40,  -67,  -49,
     -91,    6,   49,      -72,   -4,   36,      -53,  -15,   22,      -34,  -25,    8,
     -15,  -36,   -4,        4,  -47,  -18,       23,  -57,  -31,       42,  -68,  -45,
     -89,    5,   53,      -70,   -5,   40,      -50,  -16,   26,      -32,  -27,   12,
     -12,  -37,    0,        7,  -48,  -14,       25,  -59,  -27,       45,  -70,  -41,
     -86,    3,   57,      -67,   -6,   44,      -48,  -17,   30,      -29,  -28,   16,
     -10,  -39,    3,        9,  -49,  -10,       28,  -60,  -23,       47,  -71,  -37,
     -83,    2,   62,      -65,   -8,   48,      -45,  -19,   34,      -27,  -29,   21,
      -7,  -40,    7,       12,  -51,   -5,       30,  -62,  -19,       50,  -72,  -33,
     -81,    0,   66,      -62,   -9,   52,      -43,  -20,   38,      -24,  -31,   25,
      -5,  -42,   11,       14,  -52,   -1,       33,  -63,  -15,       52,  -74,  -29,
     -79,    0,   70,      -60,  -11,   56,      -41,  -22,   42,      -22,  -32,   29,
      -2,  -43,   15,       16,  -54,    2,       35,  -64,  -11,       55,  -75,  -25,
     -76,   -1,   74,      -57,  -12,   60,      -38,  -23,   46,      -19,  -33,   33,
       0,  -44,   19,       19,  -55,    6,       38,  -66,   -7,       57,  -77,  -21,
     -74,   -3,   78,      -55,  -13,   65,      -35,  -24,   51,      -17,  -35,   37,
       3,  -46,   24,       22,  -57,   10,       40,  -67,   -2,       60,  -78,  -16,
     -71,   -4,   82,      -52,  -15,   69,      -33,  -26,   55,      -14,  -36,   41,
       5,  -47,   28,       24,  -58,   14,       43,  -68,    1,       62,  -79,  -12,
     -69,   -6,   86,      -50,  -16,   73,      -31,  -27,   59,      -12,  -38,   45,
       8,  -49,   32,       26,  -59,   18,       45,  -70,    5,       64,  -81,   -8,
     -66,   -7,   90,      -48,  -17,   77,      -28,  -28,   63,       -9,  -39,   49,
      10,  -50,   36,       29,  -61,   22,       47,  -71,    9,       67,  -82,   -4,
     -64,   -8,   94,      -45,  -19,   81,      -26,  -30,   67,       -7,  -40,   53,
      12,  -51,   40,       31,  -62,   26,       50,  -73,   13,       69,  -83,    0,
     -61,  -10,   99,      -43,  -20,   85,      -23,  -31,   71,       -4,  -42,   58,
      15,  -53,   44,       34,  -63,   31,       53,  -74,   17,       72,  -85,    3,
     -59,  -11,  103,      -40,  -22,   89,      -21,  -33,   75,       -2,  -43,   62,
      17,  -54,   48,       36,  -65,   35,       55,  -75,   21,       74,  -86,    7,
     -57,  -12,  107,      -38,  -23,   93,      -18,  -34,   79,        0,  -45,   66,
      20,  -56,   52,       39,  -66,   39,       57,  -77,   25,       77,  -88,   11,
     -54,  -14,  111,      -35,  -24,   97,      -16,  -35,   83,        3,  -46,   70,
      22,  -57,   56,       41,  -67,   43,       60,  -78,   29,       79,  -89,   15,
     -51,  -15,  115,      -33,  -26,  102,      -13,  -37,   88,        5,  -47,   74,
      25,  -58,   61,       44,  -69,   47,       62,  -80,   34,       82,  -91,   20,
     -49,  -17,  119,      -30,  -27,  106,      -11,  -38,   92,        8,  -49,   78,
      27,  -60,   65,       46,  -70,   51,       65,  -81,   38,       84,  -92,   24,
     -47,  -18,  123,      -28,  -29,  110,       -9,  -40,   96,       10,  -50,   82,
      30,  -61,   69,       48,  -72,   55,       67,  -82,   42,       87,  -93,   28,
    -122,   29,   -4,     -103,   18,  -18,      -84,    7,  -31,      -65,   -3,  -45,
     -46,  -14,  -59,      -27,  -24,  -72,       -8,  -35,  -85,       11,  -46,  -99,
    -119,   27,    0,     -101,   17,  -14,      -81,    6,  -27,      -63,   -4,  -41,
     -43,  -15,  -55,      -24,  -26,  -68,       -6,  -36,  -81,       14,  -47,  -95,
    -117,   26,    3,      -98,   15,  -10,      -79,    4,  -23,      -60,   -5,  -37,
     -41,  -16,  -51,      -22,  -27,  -64,       -3,  -37,  -77,       16,  -48,  -91,
    -114,   24,    7,      -96,   14,   -5,      -76,    3,  -19,      -57,   -7,  -32,
     -38,  -18,  -46,      -19,  -28,  -60,       -1,  -39,  -73,       19,  -50,  -87,
    -112,   23,   11,      -93,   12,   -1,      -74,    1,  -15,      -55,   -8,  -28,
     -36,  -19,  -42,      -17,  -30,  -56,        2,  -40,  -69,       21,  -51,  -83,
    -110,   22,   15,      -91,   11,    2,      -71,    0,  -11,      -53,  -10,  -24,
     -33,  -20,  -38,      -15,  -31,  -52,        4,  -42,  -65,       24,  -53,  -79,
    -107,   20,   19,      -88,   10,    6,      -69,    0,   -7,      -50,  -11,  -20,
     -31,  -22,  -34,      -12,  -32,  -48,        7,  -43,  -61,       26,  -54,  -75,
    -105,   19,   24,      -86,    8,   10,      -66,   -2,   -2,      -48,  -12,  -16,
     -28,  -23,  -30,       -9,  -34,  -43,        9,  -45,  -56,       29,  -55,  -70,
    -102,   17,   28,      -83,    7,   14,      -64,   -3,    1,      -45,  -14,  -12,
     -26,  -25,  -26,       -7,  -35,  -39,       12,  -46,  -52,       31,  -57,  -66,
    -100,   16,   32,      -81,    5,   18,      -62,   -5,    5,      -43,  -15,   -8,
     -23,  -26,  -22,       -5,  -37,  -35,       14,  -47,  -48,       33,  -58,  -62,
     -97,   15,   36,      -79,    4,   22,      -59,   -6,    9,      -40,  -16,   -4,
     -21,  -27,  -18,       -2,  -38,  -31,       17,  -49,  -44,       36,  -60,  -58,
     -95,   13,   40,      -76,    3,   26,      -57,   -7,   13,      -38,  -18,    0,
     -19,  -29,  -14,        0,  -39,  -27,       19,  -50,  -40,       38,  -61,  -54,
     -92,   12,   44,      -74,    1,   31,      -54,   -9,   17,      -35,  -19,    4,
     -16,  -30,   -9,        3,  -41,  -23,       22,  -51,  -36,       41,  -62,  -50,
     -90,   10,   48,      -71,    0,   35,      -52,  -10,   21,      -33,  -21,    8,
     -14,  -32,   -5,        5,  -42,  -19,       24,  -53,  -32,       43,  -64,  -46,
     -88,    9,   52,      -69,   -1,   39,      -49,  -11,   25,      -31,  -22,   12,
     -11,  -33,   -1,        8,  -44,  -15,       26,  -54,  -28,       46,  -65,  -42,
     -85,    8,   56,      -66,   -2,   43,      -47,  -13,   29,      -28,  -23,   16,
      -9,  -34,    2,       10,  -45,  -11,       29,  -56,  -24,       48,  -66,  -38,
     -82,    6,   61,      -64,   -3,   47,      -44,  -14,   34,      -25,  -25,   20,
      -6,  -36,    6,       13,  -46,   -6,       31,  -57,  -19,       51,  -68,  -33,
     -80,    5,   65,      -61,   -5,   51,      -42,  -16,   38,      -23,  -26,   24,
      -4,  -37,   10,       15,  -48,   -2,       34,  -58,  -15,       53,  -69,  -29,
     -78,    4,   69,      -59,   -6,   55,      -39,  -17,   42,      -21,  -28,   28,
      -1,  -39,   14,       17,  -49,    1,       36,  -60,  -11,       56,  -71,  -25,
     -75,    2,   73,      -56,   -7,   59,      -37,  -18,   46,      -18,  -29,   32,
       1,  -40,   18,       20,  -50,    5,       39,  -61,   -7,       58,  -72,  -21,
     -73,    1,   77,      -54,   -9,   64,      -34,  -20,   50,      -16,  -30,   37,
       4,  -41,   23,       23,  -52,    9,       41,  -63,   -3,       61,  -74,  -17,
     -70,    0,   81,      -51,  -10,   68,      -32,  -21,   54,      -13,  -32,   41,
       6,  -43,   27,       25,  -53,   13,       44,  -64,    0,       63,  -75,  -13,
     -68,   -1,   85,      -49,  -12,   72,      -30,  -23,   58,      -11,  -33,   45,
       9,  -44,   31,       27,  -55,   17,       46,  -65,    4,       65,  -76,   -9,
     -65,   -2,   89,      -47,  -13,   76,      -27,  -24,   62,       -8,  -35,   49,
      11,  -45,   35,       30,  -56,   21,       49,  -67,    8,       68,  -78,   -5,
     -63,   -4,   93,      -44,  -14,   80,      -25,  -25,   66,       -6,  -36,   53,
      13,  -47,   39,       32,  -57,   25,       51,  -68,   12,       70,  -79,   -1,
     -60,   -5,   98,      -42,  -16,   84,      -22,  -27,   71,       -3,  -37,   57,
      16,  -48,   43,       35,  -59,   30,       54,  -70,   17,       73,  -80,    3,
     -58,   -7,  102,      -39,  -17,   88,      -20,  -28,   75,       -1,  -39,   61,
      18,  -50,   47,       37,  -60,   34,       56,  -71,   21,       75,  -82,    7,
     -56,   -8,  106,      -37,  -19,   92,      -17,  -29,   79,        1,  -40,   65,
      21,  -51,   51,       40,  -62,   38,       58,  -72,   25,       78,  -83,   11,
     -53,   -9,  110,      -34,  -20,   96,      -15,  -31,   83,        4,  -41,   69,
      23,  -52,   55,       42,  -63,   42,       61,  -74,   29,       80,  -85,   15,
     -50,  -11,  114,      -32,  -21,  101,      -12,  -32,   87,        7,  -43,   74,
      26,  -54,   60,       45,  -64,   46,       63,  -75,   33,       83,  -86,   19,
     -48,  -12,  118,      -29,  -23,  105,      -10,  -34,   91,        9,  -44,   78,
      28,  -55,   64,       47,  -66,   50,       66,  -76,   37,       85,  -87,   23,
     -46,  -14,  122,      -27,  -24,  109,       -7,  -35,   95,       11,  -46,   82,
      31,  -57,   68,       49,  -67,   54,       68,  -78,   41,       88,  -89,   27,
    -121,   33,   -5,     -102,   22,  -18,      -83,   11,  -32,      -64,    0,  -45,
     -45,  -10,  -59,      -26,  -20,  -73,       -7,  -31,  -86,       12,  -42, -100,
    -119,   31,   -1,     -100,   21,  -14,      -80,   10,  -28,      -62,    0,  -41,
     -42,  -11,  -55,      -23,  -22,  -69,       -5,  -32,  -82,       15,  -43,  -96,
    -116,   30,    2,      -97,   19,  -10,      -78,    8,  -24,      -59,   -1,  -37,
     -40,  -12,  -51,      -21,  -23,  -65,       -2,  -33,  -78,       17,  -44,  -92,
    -114,   28,    7,      -95,   18,   -6,      -75,    7,  -20,      -57,   -3,  -33,
     -37,  -14,  -47,      -18,  -24,  -60,        0,  -35,  -74,       20,  -46,  -87,
    -111,   27,   11,      -92,   16,   -2,      -73,    5,  -16,      -54,   -4,  -29,
     -35,  -15,  -43,      -16,  -26,  -56,        3,  -36,  -70,       22,  -47,  -83,
    -109,   26,   15,      -90,   15,    1,      -71,    4,  -12,      -52,   -6,  -25,
     -32,  -16,  -39,      -14,  -27,  -52,        5,  -38,  -66,       25,  -49,  -79,
    -106,   24,   19,      -88,   14,    5,      -68,    3,   -8,      -49,   -7,  -21,
     -30,  -18,  -35,      -11,  -28,  -48,        8,  -39,  -62,       27,  -50,  -75,
    -104,   23,   23,      -85,   12,   10,      -65,    1,   -3,      -47,   -8,  -16,
     -27,  -19,  -30,       -9,  -30,  -44,       10,  -41,  -57,       30,  -51,  -71,
    -101,   21,   27,      -82,   11,   14,      -63,    0,    0,      -44,  -10,  -12,
     -25,  -21,  -26,       -6,  -31,  -40,       13,  -42,  -53,       32,  -53,  -67,
     -99,   20,   31,      -80,    9,   18,      -61,   -1,    4,      -42,  -11,   -8,
     -23,  -22,  -22,       -4,  -33,  -36,       15,  -43,  -49,       34,  -54,  -63,
     -96,   19,   35,      -78,    8,   22,      -58,   -2,    8,      -40,  -12,   -4,
     -20,  -23,  -18,       -1,  -34,  -32,       17,  -45,  -45,       37,  -56,  -59,
     -94,   17,   39,      -75,    7,   26,      -56,   -3,   12,      -37,  -14,    0,
     -18,  -25,  -14,        1,  -35,  -28,       20,  -46,  -41,       39,  -57,  -55,
     -91,   16,   44,      -73,    5,   30,      -53,   -5,   16,      -34,  -15,    3,
     -15,  -26,  -10,        4,  -37,  -23,       23,  -47,  -37,       42,  -58,  -50,
     -89,   14,   48,      -70,    4,   34,      -51,   -6,   20,      -32,  -17,    7,
     -13,  -28,   -6,        6,  -38,  -19,       25,  -49,  -33,       44,  -60,  -46,
     -87,   13,   52,      -68,    2,   38,      -48,   -7,   24,      -30,  -18,   11,
     -10,  -29,   -2,        9,  -40,  -15,       27,  -50,  -29,       47,  -61,  -42,
     -84,   12,   56,      -65,    1,   42,      -46,   -9,   28,      -27,  -19,   15,
      -8,  -30,    1,       11,  -41,  -11,       30,  -52,  -25,       49,  -62,  -38,
     -82,   10,   60,      -63,    0,   47,      -43,  -10,   33,      -25,  -21,   20,
      -5,  -32,    6,       14,  -42,   -7,       32,  -53,  -20,       52,  -64,  -34,
     -79,    9,   64,      -60,   -1,   51,      -41,  -12,   37,      -22,  -22,   24,
      -3,  -33,   10,       16,  -44,   -3,       35,  -54,  -16,       54,  -65,  -30,
     -77,    8,   68,      -58,   -2,   55,      -39,  -13,   41,      -20,  -24,   28,
       0,  -35,   14,       18,  -45,    0,       37,  -56,  -12,       57,  -67,  -26,
     -74,    6,   72,      -56,   -3,   59,      -36,  -14,   45,      -17,  -25,   32,
       2,  -36,   18,       21,  -46,    4,       40,  -57,   -8,       59,  -68,  -22,
     -72,    5,   77,      -53,   -5,   63,      -33,  -16,   49,      -15,  -26,   36,
       5,  -37,   22,       23,  -48,    9,       42,  -59,   -4,       62,  -70,  -17,
     -69,    3,   81,      -50,   -6,   67,      -31,  -17,   53,      -12,  -28,   40,
       7,  -39,   26,       26,  -49,   13,       45,  -60,    0,       64,  -71,  -13,
     -67,    2,   85,      -48,   -8,   71,      -29,  -19,   57,      -10,  -29,   44,
       9,  -40,   30,       28,  -51,   17,       47,  -61,    3,       66,  -72,   -9,
     -64,    1,   89,      -46,   -9,   75,      -26,  -20,   61,       -8,  -31,   48,
      12,  -41,   34,       31,  -52,   21,       49,  -63,    7,       69,  -74,   -5,
     -62,    0,   93,      -43,  -10,   79,      -24,  -21,   65,       -5,  -32,   52,
      14,  -43,   38,       33,  -53,   25,       52,  -64,   11,       71,  -75,   -1,
     -59,   -1,   97,      -41,  -12,   84,      -21,  -23,   70,       -2,  -33,   57,
      17,  -44,   43,       36,  -55,   29,       54,  -66,   16,       74,  -76,    2,
     -57,   -3,  101,      -38,  -13,   88,      -19,  -24,   74,        0,  -35,   61,
      19,  -46,   47,       38,  -56,   33,       57,  -67,   20,       76,  -78,    6,
     -55,   -4,  105,      -36,  -15,   92,      -16,  -25,   78,        2,  -36,   65,
      22,  -47,   51,       40,  -58,   37,       59,  -68,   24,       79,  -79,   10,
     -52,   -5,  109,      -33,  -16,   96,      -14,  -27,   82,        5,  -37,   69,
      24,  -48,   55,       43,  -59,   41,       62,  -70,   28,       81,  -81,   14,
     -50,   -7,  114,      -31,  -17,  100,      -11,  -28,   86,        7,  -39,   73,
      27,  -50,   59,       46,  -60,   46,       64,  -71,   32,       84,  -82,   19,
     -47,   -8,  118,      -28,  -19,  104,       -9,  -30,   90,       10,  -40,   77,
      29,  -51,   63,       48,  -62,   50,       67,  -72,   36,       86,  -83,   23,
     -45,  -10,  122,      -26,  -20,  108,       -7,  -31,   94,       12,  -42,   81,
      32,  -53,   67,       50,  -63,   54,       69,  -74,   40,       89,  -85,   27,
    -120,   37,   -6,     -101,   26,  -19,      -82,   15,  -33,      -63,    4,  -46,
     -44,   -6,  -60,      -25,  -16,  -73,       -6,  -27,  -87,       13,  -38, -101,
    -118,   35,   -2,      -99,   25,  -15,      -80,   14,  -29,      -61,    3,  -42,
     -41,   -7,  -56,      -23,  -18,  -69,       -4,  -28,  -83,       16,  -39,  -97,
    -115,   34,    1,      -96,   23,  -11,      -77,   12,  -25,      -58,    2,  -38,
     -39,   -8,  -52,      -20,  -19,  -65,       -1,  -29,  -79,       18,  -40,  -93,
    -113,   32,    6,      -94,   22,   -6,      -74,   11,  -20,      -56,    0,  -34,
     -36,  -10,  -47,      -17,  -20,  -61,        1,  -31,  -74,       21,  -42,  -88,
    -110,   31,   10,      -91,   20,   -2,      -72,    9,  -16,      -53,    0,  -30,
     -34,  -11,  -43,      -15,  -22,  -57,        4,  -32,  -70,       23,  -43,  -84,
    -108,   30,   14,      -89,   19,    1,      -70,    8,  -12,      -51,   -2,  -26,
     -31,  -12,  -39,      -13,  -23,  -53,        6,  -34,  -66,       25,  -45,  -80,
    -105,   28,   18,      -87,   18,    5,      -67,    7,   -8,      -48,   -3,  -22,
     -29,  -14,  -35,      -10,  -24,  -49,        8,  -35,  -62,       28,  -46,  -76,
    -103,   27,   22,      -84,   16,    9,      -65,    5,   -4,      -46,   -4,  -17,
     -26,  -15,  -31,       -8,  -26,  -44,       11,  -37,  -58,       31,  -47,  -72,
    -100,   25,   26,      -82,   15,   13,      -62,    4,    0,      -43,   -6,  -13,
     -24,  -17,  -27,       -5,  -27,  -40,       14,  -38,  -54,       33,  -49,  -68,
     -98,   24,   30,      -79,   13,   17,      -60,    2,    3,      -41,   -7,   -9,
     -22,  -18,  -23,       -3,  -29,  -36,       16,  -39,  -50,       35,  -50,  -64,
     -96,   23,   34,      -77,   12,   21,      -57,    1,    7,      -39,   -8,   -5,
     -19,  -19,  -19,        0,  -30,  -32,       18,  -41,  -46,       38,  -52,  -60,
     -93,   21,   38,      -74,   11,   25,      -55,    0,   11,      -36,  -10,   -1,
     -17,  -21,  -15,        2,  -31,  -28,       21,  -42,  -42,       40,  -53,  -56,
     -90,   20,   43,      -72,    9,   30,      -52,   -1,   16,      -34,  -11,    2,
     -14,  -22,  -10,        5,  -33,  -24,       23,  -43,  -37,       43,  -54,  -51,
     -88,   18,   47,      -69,    8,   34,      -50,   -2,   20,      -31,  -13,    6,
     -12,  -24,   -6,        7,  -34,  -20,       26,  -45,  -33,       45,  -56,  -47,
     -86,   17,   51,      -67,    6,   38,      -48,   -3,   24,      -29,  -14,   10,
      -9,  -25,   -2,        9,  -36,  -16,       28,  -46,  -29,       48,  -57,  -43,
     -83,   16,   55,      -65,    5,   42,      -45,   -5,   28,      -26,  -15,   14,
      -7,  -26,    1,       12,  -37,  -12,       31,  -48,  -25,       50,  -58,  -39,
     -81,   14,   59,      -62,    4,   46,      -42,   -6,   32,      -24,  -17,   19,
      -4,  -28,    5,       14,  -38,   -7,       33,  -49,  -21,       53,  -60,  -35,
     -78,   13,   63,      -59,    2,   50,      -40,   -8,   36,      -21,  -18,   23,
      -2,  -29,    9,       17,  -40,   -3,       36,  -50,  -17,       55,  -61,  -31,
     -76,   12,   67,      -57,    1,   54,      -38,   -9,   40,      -19,  -20,   27,
       0,  -31,   13,       19,  -41,    0,       38,  -52,  -13,       57,  -63,  -27,
     -73,   10,   71,      -55,    0,   58,      -35,  -10,   44,      -16,  -21,   31,
       3,  -32,   17,       22,  -42,    4,       40,  -53,   -9,       60,  -64,  -23,
     -71,    9,   76,      -52,   -1,   63,      -33,  -12,   49,      -14,  -22,   35,
       6,  -33,   22,       24,  -44,    8,       43,  -55,   -4,       63,  -66,  -18,
     -68,    7,   80,      -50,   -2,   67,      -30,  -13,   53,      -11,  -24,   39,
       8,  -35,   26,       27,  -45,   12,       46,  -56,    0,       65,  -67,  -14,
     -66,    6,   84,      -47,   -4,   71,      -28,  -15,   57,       -9,  -25,   43,
      10,  -36,   30,       29,  -47,   16,       48,  -57,    3,       67,  -68,  -10,
     -64,    5,   88,      -45,   -5,   75,      -25,  -16,   61,       -7,  -27,   47,
      13,  -37,   34,       32,  -48,   20,       50,  -59,    7,       70,  -70,   -6,
     -61,    3,   92,      -42,   -6,   79,      -23,  -17,   65,       -4,  -28,   51,
      15,  -39,   38,       34,  -49,   24,       53,  -60,   11,       72,  -71,   -2,
     -58,    2,   96,      -40,   -8,   83,      -20,  -19,   69,       -2,  -29,   56,
      18,  -40,   42,       37,  -51,   29,       55,  -62,   15,       75,  -72,    1,
     -56,    0,  100,      -37,   -9,   87,      -18,  -20,   73,        1,  -31,   60,
      20,  -42,   46,       39,  -52,   33,       58,  -63,   19,       77,  -74,    5,
     -54,    0,  104,      -35,  -11,   91,      -16,  -21,   77,        3,  -32,   64,
      23,  -43,   50,       41,  -54,   37,       60,  -64,   23,       80,  -75,    9,
     -51,   -1,  108,      -33,  -12,   95,      -13,  -23,   81,        6,  -33,   68,
      25,  -44,   54,       44,  -55,   41,       63,  -66,   27,       82,  -77,   13,
     -49,   -3,  113,      -30,  -13,  100,      -10,  -24,   86,        8,  -35,   72,
      28,  -46,   59,       46,  -56,   45,       65,  -67,   32,       85,  -78,   18,
     -46,   -4,  117,      -27,  -15,  104,       -8,  -26,   90,       11,  -36,   76,
      30,  -47,   63,       49,  -58,   49,       68,  -68,   36,       87,  -79,   22,
     -44,   -6,  121,      -25,  -16,  108,       -6,  -27,   94,       13,  -38,   80,
      32,  -49,   67,       51,  -59,   53,       70,  -70,   40,       89,  -81,   26,
    -119,   41,   -6,     -100,   30,  -20,      -81,   19,  -33,      -62,    8,  -47,
     -43,   -2,  -61,      -24,  -12,  -74,       -5,  -23,  -87,       14,  -34, -101,
    -117,   39,   -2,      -98,   29,  -16,      -79,   18,  -29,      -60,    7,  -43,
     -40,   -3,  -57,      -22,  -14,  -70,       -3,  -24,  -83,       16,  -35,  -97,
    -114,   38,    1,      -96,   27,  -12,      -76,   16,  -25,      -57,    6,  -39,
     -38,   -4,  -53,      -19,  -15,  -66,        0,  -25,  -79,       19,  -36,  -93,
    -112,   36,    5,      -93,   26,   -7,      -74,   15,  -21,      -55,    4,  -34,
     -35,   -6,  -48,      -17,  -16,  -61,        2,  -27,  -75,       22,  -38,  -89,
    -109,   35,    9,      -91,   24,   -3,      -71,   13,  -17,      -52,    3,  -30,
     -33,   -7,  -44,      -14,  -18,  -57,        5,  -28,  -71,       24,  -39,  -85,
    -107,   34,   13,      -88,   23,    0,      -69,   12,  -13,      -50,    1,  -26,
     -31,   -8,  -40,      -12,  -19,  -53,        7,  -30,  -67,       26,  -41,  -81,
    -105,   32,   17,      -86,   22,    4,      -66,   11,   -9,      -48,    0,  -22,
     -28,  -10,  -36,       -9,  -20,  -49,        9,  -31,  -63,       29,  -42,  -77,
    -102,   31,   22,      -83,   20,    8,      -64,    9,   -4,      -45,    0,  -18,
     -25,  -11,  -32,       -7,  -22,  -45,       12,  -33,  -58,       31,  -43,  -72,
     -99,   29,   26,      -81,   19,   12,      -61,    8,    0,      -42,   -2,  -14,
     -23,  -13,  -28,       -4,  -23,  -41,       14,  -34,  -54,       34,  -45,  -68,
     -97,   28,   30,      -78,   17,   16,      -59,    6,    3,      -40,   -3,  -10,
     -21,  -14,  -24,       -2,  -25,  -37,       17,  -35,  -50,       36,  -46,  -64,
     -95,   27,   34,      -76,   16,   20,      -56,    5,    7,      -38,   -4,   -6,
     -18,  -15,  -20,        0,  -26,  -33,       19,  -37,  -46,       39,  -48,  -60,
     -92,   25,   38,      -73,   15,   24,      -54,    4,   11,      -35,   -6,   -2,
     -16,  -17,  -16,        3,  -27,  -29,       22,  -38,  -42,       41,  -49,  -56,
     -90,   24,   42,      -71,   13,   29,      -51,    2,   15,      -33,   -7,    2,
     -13,  -18,  -11,        6,  -29,  -24,       24,  -39,  -38,       44,  -50,  -52,
     -87,   22,   46,      -68,   12,   33,      -49,    1,   19,      -30,   -9,    6,
     -11,  -20,   -7,        8,  -30,  -20,       27,  -41,  -34,       46,  -52,  -48,
     -85,   21,   50,      -66,   10,   37,      -47,    0,   23,      -28,  -10,   10,
      -8,  -21,   -3,       10,  -32,  -16,       29,  -42,  -30,       48,  -53,  -44,
     -82,   20,   54,      -64,    9,   41,      -44,   -1,   27,      -25,  -11,   14,
      -6,  -22,    0,       13,  -33,  -12,       32,  -44,  -26,       51,  -54,  -40,
     -80,   18,   59,      -61,    8,   45,      -42,   -2,   32,      -23,  -13,   18,
      -3,  -24,    4,       15,  -34,   -8,       34,  -45,  -21,       54,  -56,  -35,
     -77,   17,   63,      -59,    6,   49,      -39,   -4,   36,      -20,  -14,   22,
      -1,  -25,    8,       18,  -36,   -4,       37,  -46,  -17,       56,  -57,  -31,
     -75,   16,   67,      -56,    5,   53,      -37,   -5,   40,      -18,  -16,   26,
       1,  -27,   12,       20,  -37,    0,       39,  -48,  -13,       58,  -59,  -27,
     -73,   14,   71,      -54,    4,   57,      -34,   -6,   44,      -16,  -17,   30,
       4,  -28,   16,       23,  -38,    3,       41,  -49,   -9,       61,  -60,  -23,
     -70,   13,   75,      -51,    2,   62,      -32,   -8,   48,      -13,  -18,   35,
       6,  -29,   21,       25,  -40,    8,       44,  -51,   -5,       63,  -62,  -19,
     -67,   11,   79,      -49,    1,   66,      -29,   -9,   52,      -10,  -20,   39,
       9,  -31,   25,       28,  -41,   12,       46,  -52,   -1,       66,  -63,  -15,
     -65,   10,   83,      -46,    0,   70,      -27,  -11,   56,       -8,  -21,   43,
      11,  -32,   29,       30,  -43,   16,       49,  -53,    2,       68,  -64,  -11,
     -63,    9,   87,      -44,   -1,   74,      -24,  -12,   60,       -6,  -23,   47,
      14,  -33,   33,       32,  -44,   20,       51,  -55,    6,       71,  -66,   -7,
     -60,    7,   91,      -41,   -2,   78,      -22,  -13,   64,       -3,  -24,   51,
      16,  -35,   37,       35,  -45,   24,       54,  -56,   10,       73,  -67,   -3,
     -58,    6,   96,      -39,   -4,   82,      -19,  -15,   69,       -1,  -25,   55,
      19,  -36,   41,       38,  -47,   28,       56,  -58,   15,       76,  -68,    1,
     -55,    4,  100,      -36,   -5,   86,      -17,  -16,   73,        2,  -27,   59,
      21,  -38,   45,       40,  -48,   32,       59,  -59,   19,       78,  -70,    5,
     -53,    3,  104,      -34,   -7,   90,      -15,  -17,   77,        4,  -28,   63,
      24,  -39,   49,       42,  -50,   36,       61,  -60,   23,       80,  -71,    9,
     -50,    2,  108,      -32,   -8,   94,      -12,  -19,   81,        7,  -29,   67,
      26,  -40,   53,       45,  -51,   40,       63,  -62,   27,       83,  -73,   13,
     -48,    0,  112,      -29,   -9,   99,      -10,  -20,   85,        9,  -31,   72,
      29,  -42,   58,       47,  -52,   45,       66,  -63,   31,       86,  -74,   17,
     -45,    0,  116,      -27,  -11,  103,       -7,  -22,   89,       12,  -32,   76,
      31,  -43,   62,       50,  -54,   49,       69,  -64,   35,       88,  -75,   21,
     -43,   -2,  120,      -24,  -12,  107,       -5,  -23,   93,       14,  -34,   80,
      33,  -45,   66,       52,  -55,   53,       71,  -66,   39,       90,  -77,   25,
    -118,   45,   -7,      -99,   34,  -20,      -80,   23,  -34,      -61,   12,  -47,
     -42,    1,  -61,      -23,   -8,  -75,       -4,  -19,  -88,       15,  -30, -102,
    -116,   43,   -3,      -97,   33,  -16,      -78,   22,  -30,      -59,   11,  -43,
     -40,    0,  -57,      -21,  -10,  -71,       -2,  -20,  -84,       17,  -31,  -98,
    -113,   42,    0,      -95,   31,  -12,      -75,   20,  -26,      -57,   10,  -39,
     -37,    0,  -53,      -18,  -11,  -67,        0,  -21,  -80,       20,  -32,  -94,
    -111,   40,    5,      -92,   30,   -8,      -73,   19,  -22,      -54,    8,  -35,
     -34,   -2,  -49,      -16,  -12,  -62,        3,  -23,  -76,       22,  -34,  -89,
    -108,   39,    9,      -90,   28,   -4,      -70,   17,  -18,      -51,    7,  -31,
     -32,   -3,  -45,      -13,  -14,  -58,        6,  -24,  -72,       25,  -35,  -85,
    -106,   38,   13,      -87,   27,    0,      -68,   16,  -14,      -49,    5,  -27,
     -30,   -4,  -41,      -11,  -15,  -54,        8,  -26,  -68,       27,  -37,  -81,
    -104,   36,   17,      -85,   26,    3,      -65,   15,  -10,      -47,    4,  -23,
     -27,   -6,  -37,       -8,  -16,  -50,       10,  -27,  -64,       30,  -38,  -77,
    -101,   35,   21,      -82,   24,    8,      -63,   13,   -5,      -44,    3,  -18,
     -25,   -7,  -32,       -6,  -18,  -46,       13,  -29,  -59,       32,  -39,  -73,
     -99,   33,   25,      -80,   23,   12,      -60,   12,   -1,      -42,    1,  -14,
     -22,   -9,  -28,       -3,  -19,  -42,       15,  -30,  -55,       35,  -41,  -69,
     -96,   32,   29,      -77,   21,   16,      -58,   10,    2,      -39,    0,  -10,
     -20,  -10,  -24,       -1,  -21,  -38,       18,  -31,  -51,       37,  -42,  -65,
     -94,   31,   33,      -75,   20,   20,      -56,    9,    6,      -37,    0,   -6,
     -17,  -11,  -20,        1,  -22,  -34,       20,  -33,  -47,       40,  -44,  -61,
     -91,   29,   37,      -73,   19,   24,      -53,    8,   10,      -34,   -2,   -2,
     -15,  -13,  -16,        4,  -23,  -30,       23,  -34,  -43,       42,  -45,  -57,
     -89,   28,   42,      -70,   17,   28,      -50,    6,   14,      -32,   -3,    1,
     -12,  -14,  -12,        6,  -25,  -25,       25,  -35,  -39,       45,  -46,  -52,
     -86,   26,   46,      -67,   16,   32,      -48,    5,   18,      -29,   -5,    5,
     -10,  -16,   -8,        9,  -26,  -21,       28,  -37,  -35,       47,  -48,  -48,
     -84,   25,   50,      -65,   14,   36,      -46,    4,   22,      -27,   -6,    9,
      -8,  -17,   -4,       11,  -28,  -17,       30,  -38,  -31,       49,  -49,  -44,
     -81,   24,   54,      -63,   13,   40,      -43,    2,   26,      -25,   -7,   13,
      -5,  -18,    0,       14,  -29,  -13,       32,  -40,  -27,       52,  -50,  -40,
     -79,   22,   58,      -60,   12,   45,      -41,    1,   31,      -22,   -9,   18,
      -2,  -20,    4,       16,  -30,   -9,       35,  -41,  -22,       54,  -52,  -36,
     -76,   21,   62,      -58,   10,   49,      -38,    0,   35,      -19,  -10,   22,
       0,  -21,    8,       19,  -32,   -5,       37,  -42,  -18,       57,  -53,  -32,
     -74,   20,   66,      -55,    9,   53,      -36,   -1,   39,      -17,  -12,   26,
       2,  -23,   12,       21,  -33,   -1,       40,  -44,  -14,       59,  -55,  -28,
     -72,   18,   70,      -53,    8,   57,      -33,   -2,   43,      -15,  -13,   30,
       5,  -24,   16,       23,  -34,    2,       42,  -45,  -10,       62,  -56,  -24,
     -69,   17,   75,      -50,    6,   61,      -31,   -4,   47,      -12,  -14,   34,
       7,  -25,   20,       26,  -36,    7,       45,  -47,   -6,       64,  -58,  -19,
     -67,   15,   79,      -48,    5,   65,      -28,   -5,   51,      -10,  -16,   38,
      10,  -27,   24,       29,  -37,   11,       47,  -48,   -2,       67,  -59,  -15,
     -64,   14,   83,      -45,    3,   69,      -26,   -7,   55,       -7,  -17,   42,
      12,  -28,   28,       31,  -39,   15,       50,  -49,    1,       69,  -60,  -11,
     -62,   13,   87,      -43,    2,   73,      -24,   -8,   59,       -5,  -19,   46,
      15,  -29,   32,       33,  -40,   19,       52,  -51,    5,       72,  -62,   -7,
     -59,   11,   91,      -41,    1,   77,      -21,   -9,   63,       -2,  -20,   50,
      17,  -31,   36,       36,  -41,   23,       55,  -52,    9,       74,  -63,   -3,
     -57,   10,   95,      -38,    0,   82,      -18,  -11,   68,        0,  -21,   55,
      20,  -32,   41,       38,  -43,   27,       57,  -54,   14,       77,  -64,    0,
     -54,    8,   99,      -35,   -1,   86,      -16,  -12,   72,        3,  -23,   59,
      22,  -34,   45,       41,  -44,   31,       60,  -55,   18,       79,  -66,    4,
     -52,    7,  103,      -33,   -3,   90,      -14,  -13,   76,        5,  -24,   63,
      24,  -35,   49,       43,  -46,   35,       62,  -56,   22,       81,  -67,    8,
     -49,    6,  107,      -31,   -4,   94,      -11,  -15,   80,        7,  -25,   67,
      27,  -36,   53,       46,  -47,   39,       64,  -58,   26,       84,  -69,   12,
     -47,    4,  112,      -28,   -5,   98,       -9,  -16,   84,       10,  -27,   71,
      30,  -38,   57,       48,  -48,   44,       67,  -59,   30,       86,  -70,   17,
     -44,    3,  116,      -26,   -7,  102,       -6,  -18,   88,       13,  -28,   75,
      32,  -39,   61,       51,  -50,   48,       69,  -60,   34,       89,  -71,   21,
     -42,    1,  120,      -23,   -8,  106,       -4,  -19,   92,       15,  -30,   79,
      34,  -41,   65,       53,  -51,   52,       72,  -62,   38,       91,  -73,   25,
    -117,   49,   -8,      -98,   38,  -21,      -79,   27,  -35,      -60,   17,  -48,
     -41,    6,  -62,      -22,   -4,  -75,       -3,  -14,  -89,       16,  -25, -103,
    -115,   48,   -4,      -96,   37,  -17,      -77,   26,  -31,      -58,   16,  -44,
     -39,    5,  -58,      -20,   -5,  -71,       -1,  -16,  -85,       18,  -27,  -99,
    -112,   46,    0,      -94,   36,  -13,      -74,   25,  -27,      -55,   14,  -40,
     -36,    3,  -54,      -17,   -6,  -67,        1,  -17,  -81,       21,  -28,  -95,
    -110,   45,    4,      -91,   34,   -8,      -72,   23,  -22,      -53,   13,  -36,
     -33,    2,  -49,      -15,   -8,  -63,        4,  -18,  -76,       24,  -29,  -90,
    -107,   43,    8,      -89,   33,   -4,      -69,   22,  -18,      -50,   11,  -32,
     -31,    0,  -45,      -12,   -9,  -59,        7,  -20,  -72,       26,  -31,  -86,
    -105,   42,   12,      -86,   31,    0,      -67,   21,  -14,      -48,   10,  -28,
     -29,    0,  -41,      -10,  -11,  -55,        9,  -21,  -68,       28,  -32,  -82,
    -103,   41,   16,      -84,   30,    3,      -64,   19,  -10,      -46,    9,  -24,
     -26,   -1,  -37,       -7,  -12,  -51,       11,  -23,  -64,       31,  -33,  -78,
    -100,   39,   20,      -81,   29,    7,      -62,   18,   -6,      -43,    7,  -19,
     -24,   -3,  -33,       -5,  -13,  -46,       14,  -24,  -60,       33,  -35,  -74,
     -97,   38,   24,      -79,   27,   11,      -59,   16,   -2,      -41,    6,  -15,
     -21,   -4,  -29,       -2,  -15,  -42,       16,  -25,  -56,       36,  -36,  -70,
     -95,   37,   28,      -76,   26,   15,      -57,   15,    1,      -38,    4,  -11,
     -19,   -6,  -25,        0,  -16,  -38,       19,  -27,  -52,       38,  -38,  -66,
     -93,   35,   32,      -74,   25,   19,      -55,   14,    5,      -36,    3,   -7,
     -16,   -7,  -21,        2,  -18,  -34,       21,  -28,  -48,       41,  -39,  -62,
     -90,   34,   36,      -72,   23,   23,      -52,   12,    9,      -33,    2,   -3,
     -14,   -8,  -17,        5,  -19,  -30,       24,  -29,  -44,       43,  -40,  -58,
     -88,   32,   41,      -69,   22,   28,      -49,   11,   14,      -31,    0,    0,
     -11,  -10,  -12,        7,  -20,  -26,       26,  -31,  -39,       46,  -42,  -53,
     -85,   31,   45,      -66,   20,   32,      -47,    9,   18,      -28,    0,    4,
      -9,  -11,   -8,       10,  -22,  -22,       29,  -32,  -35,       48,  -43,  -49,
     -83,   30,   49,      -64,   19,   36,      -45,    8,   22,      -26,   -2,    8,
      -7,  -12,   -4,       12,  -23,  -18,       31,  -34,  -31,       50,  -45,  -45,
     -80,   28,   53,      -62,   18,   40,      -42,    7,   26,      -23,   -3,   12,
      -4,  -14,    0,       15,  -24,  -14,       33,  -35,  -27,       53,  -46,  -41,
     -78,   27,   57,      -59,   16,   44,      -40,    5,   30,      -21,   -4,   17,
      -1,  -15,    3,       17,  -26,   -9,       36,  -37,  -23,       56,  -47,  -37,
     -75,   25,   61,      -57,   15,   48,      -37,    4,   34,      -18,   -6,   21,
       1,  -17,    7,       20,  -27,   -5,       39,  -38,  -19,       58,  -49,  -33,
     -73,   24,   65,      -54,   13,   52,      -35,    2,   38,      -16,   -7,   25,
       3,  -18,   11,       22,  -29,   -1,       41,  -39,  -15,       60,  -50,  -29,
     -71,   23,   69,      -52,   12,   56,      -32,    1,   42,      -14,   -8,   29,
       6,  -19,   15,       25,  -30,    2,       43,  -41,  -11,       63,  -52,  -25,
     -68,   21,   74,      -49,   11,   61,      -30,    0,   47,      -11,  -10,   33,
       8,  -21,   20,       27,  -32,    6,       46,  -42,   -6,       65,  -53,  -20,
     -65,   20,   78,      -47,    9,   65,      -27,   -1,   51,       -9,  -11,   37,
      11,  -22,   24,       30,  -33,   10,       48,  -43,   -2,       68,  -54,  -16,
     -63,   18,   82,      -44,    8,   69,      -25,   -2,   55,       -6,  -13,   41,
      13,  -24,   28,       32,  -34,   14,       51,  -45,    1,       70,  -56,  -12,
     -61,   17,   86,      -42,    7,   73,      -23,   -3,   59,       -4,  -14,   45,
      16,  -25,   32,       34,  -36,   18,       53,  -46,    5,       73,  -57,   -8,
     -58,   16,   90,      -40,    5,   77,      -20,   -5,   63,       -1,  -15,   49,
      18,  -26,   36,       37,  -37,   22,       56,  -48,    9,       75,  -58,   -4,
     -56,   14,   94,      -37,    4,   81,      -17,   -6,   67,        1,  -17,   54,
      21,  -28,   40,       39,  -38,   27,       58,  -49,   13,       78,  -60,    0,
     -53,   13,   98,      -34,    2,   85,      -15,   -8,   71,        4,  -18,   58,
      23,  -29,   44,       42,  -40,   31,       61,  -50,   17,       80,  -61,    3,
     -51,   12,  102,      -32,    1,   89,      -13,   -9,   75,        6,  -20,   62,
      25,  -31,   48,       44,  -41,   35,       63,  -52,   21,       82,  -63,    7,
     -48,   10,  106,      -30,    0,   93,      -10,  -10,   79,        8,  -21,   66,
      28,  -32,   52,       47,  -42,   39,       65,  -53,   25,       85,  -64,   11,
     -46,    9,  111,      -27,   -1,   98,       -8,  -12,   84,       11,  -22,   70,
      31,  -33,   57,       49,  -44,   43,       68,  -55,   30,       87,  -66,   16,
     -43,    7,  115,      -25,   -2,  102,       -5,  -13,   88,       14,  -24,   74,
      33,  -35,   61,       52,  -45,   47,       71,  -56,   34,       90,  -67,   20,
     -41,    6,  119,      -22,   -4,  106,       -3,  -15,   92,       16,  -25,   78,
      35,  -36,   65,       54,  -47,   51,       73,  -57,   38,       92,  -68,   24,
    -116,   53,   -8,      -98,   42,  -22,      -78,   31,  -35,      -59,   21,  -49,
     -40,   10,  -63,      -21,    0,  -76,       -2,  -10,  -89,       17,  -21, -103,
    -114,   52,   -4,      -95,   41,  -18,      -76,   30,  -31,      -57,   20,  -45,
     -38,    9,  -59,      -19,   -1,  -72,        0,  -12,  -85,       19,  -23,  -99,
    -112,   50,    0,      -93,   40,  -14,      -73,   29,  -27,      -55,   18,  -41,
     -35,    7,  -55,      -16,   -2,  -68,        2,  -13,  -81,       22,  -24,  -95,
    -109,   49,    3,      -90,   38,   -9,      -71,   27,  -23,      -52,   17,  -36,
     -33,    6,  -50,      -14,   -4,  -64,        5,  -14,  -77,       24,  -25,  -91,
    -106,   47,    7,      -88,   37,   -5,      -68,   26,  -19,      -49,   15,  -32,
     -30,    4,  -46,      -11,   -5,  -60,        7,  -16,  -73,       27,  -27,  -87,
    -104,   46,   11,      -85,   35,   -1,      -66,   25,  -15,      -47,   14,  -28,
     -28,    3,  -42,       -9,   -7,  -56,       10,  -17,  -69,       29,  -28,  -83,
    -102,   45,   15,      -83,   34,    2,      -63,   23,  -11,      -45,   13,  -24,
     -25,    2,  -38,       -7,   -8,  -52,       12,  -19,  -65,       32,  -29,  -79,
     -99,   43,   20,      -80,   33,    6,      -61,   22,   -6,      -42,   11,  -20,
     -23,    0,  -34,       -4,   -9,  -47,       15,  -20,  -60,       34,  -31,  -74,
     -97,   42,   24,      -78,   31,   10,      -58,   20,   -2,      -40,   10,  -16,
     -20,    0,  -30,       -1,  -11,  -43,       17,  -21,  -56,       37,  -32,  -70,
     -94,   41,   28,      -75,   30,   14,      -56,   19,    1,      -37,    8,  -12,
     -18,   -2,  -26,        1,  -12,  -39,       20,  -23,  -52,       39,  -34,  -66,
     -92,   39,   32,      -73,   29,   18,      -54,   18,    5,      -35,    7,   -8,
     -15,   -3,  -22,        3,  -14,  -35,       22,  -24,  -48,       41,  -35,  -62,
     -89,   38,   36,      -71,   27,   22,      -51,   16,    9,      -32,    6,   -4,
     -13,   -4,  -18,        6,  -15,  -31,       24,  -25,  -44,       44,  -36,  -58,
     -87,   36,   40,      -68,   26,   27,      -49,   15,   13,      -30,    4,    0,
     -10,   -6,  -13,        8,  -16,  -27,       27,  -27,  -40,       47,  -38,  -54,
     -84,   35,   44,      -66,   24,   31,      -46,   13,   17,      -27,    3,    4,
      -8,   -7,   -9,       11,  -18,  -23,       30,  -28,  -36,       49,  -39,  -50,
     -82,   34,   48,      -63,   23,   35,      -44,   12,   21,      -25,    1,    8,
      -6,   -8,   -5,       13,  -19,  -19,       32,  -30,  -32,       51,  -41,  -46,
     -80,   32,   52,      -61,   22,   39,      -41,   11,   25,      -23,    0,   12,
      -3,  -10,   -1,       16,  -20,  -15,       34,  -31,  -28,       54,  -42,  -42,
     -77,   31,   57,      -58,   20,   43,      -39,    9,   30,      -20,    0,   16,
      -1,  -11,    2,       18,  -22,  -10,       37,  -33,  -23,       56,  -43,  -37,
     -74,   29,   61,      -56,   19,   47,      -36,    8,   34,      -18,   -2,   20,
       2,  -13,    6,       21,  -23,   -6,       39,  -34,  -19,       59,  -45,  -33,
     -72,   28,   65,      -53,   17,   51,      -34,    6,   38,      -15,   -3,   24,
       4,  -14,   10,       23,  -25,   -2,       42,  -35,  -15,       61,  -46,  -29,
     -70,   27,   69,      -51,   16,   55,      -32,    5,   42,      -13,   -4,   28,
       7,  -15,   14,       25,  -26,    1,       44,  -37,  -11,       64,  -48,  -25,
     -67,   25,   73,      -48,   15,   60,      -29,    4,   46,      -10,   -6,   33,
       9,  -17,   19,       28,  -28,    5,       47,  -38,   -7,       66,  -49,  -21,
     -65,   24,   77,      -46,   13,   64,      -26,    2,   50,       -8,   -7,   37,
      12,  -18,   23,       31,  -29,    9,       49,  -39,   -3,       69,  -50,  -17,
     -62,   22,   81,      -43,   12,   68,      -24,    1,   54,       -5,   -9,   41,
      14,  -20,   27,       33,  -30,   13,       52,  -41,    0,       71,  -52,  -13,
     -60,   21,   85,      -41,   11,   72,      -22,    0,   58,       -3,  -10,   45,
      17,  -21,   31,       35,  -32,   17,       54,  -42,    4,       73,  -53,   -9,
     -57,   20,   89,      -39,    9,   76,      -19,   -1,   62,        0,  -11,   49,
      19,  -22,   35,       38,  -33,   21,       56,  -44,    8,       76,  -54,   -5,
     -55,   18,   94,      -36,    8,   80,      -17,   -2,   67,        2,  -13,   53,
      22,  -24,   39,       40,  -34,   26,       59,  -45,   13,       79,  -56,    0,
     -52,   17,   98,      -34,    6,   84,      -14,   -4,   71,        5,  -14,   57,
      24,  -25,   43,       43,  -36,   30,       62,  -46,   17,       81,  -57,    3,
     -50,   16,  102,      -31,    5,   88,      -12,   -5,   75,        7,  -16,   61,
      26,  -27,   47,       45,  -37,   34,       64,  -48,   21,       83,  -59,    7,
     -48,   14,  106,      -29,    4,   92,       -9,   -6,   79,        9,  -17,   65,
      29,  -28,   51,       48,  -38,   38,       66,  -49,   25,       86,  -60,   11,
     -45,   13,  110,      -26,    2,   97,       -7,   -8,   83,       12,  -18,   70,
      31,  -29,   56,       50,  -40,   42,       69,  -51,   29,       88,  -62,   15,
     -42,   11,  114,      -24,    1,  101,       -4,   -9,   87,       14,  -20,   74,
      34,  -31,   60,       53,  -41,   46,       71,  -52,   33,       91,  -63,   19,
     -40,   10,  118,      -21,    0,  105,       -2,  -11,   91,       17,  -21,   78,
      36,  -32,   64,       55,  -43,   50,       74,  -53,   37,       93,  -64,   23,
    -115,   57,   -9,      -97,   46,  -22,      -77,   35,  -36,      -58,   25,  -49,
     -39,   14,  -63,      -20,    3,  -77,       -2,   -6,  -90,       18,  -17, -104,
    -113,   56,   -5,      -94,   45,  -18,      -75,   34,  -32,      -56,   24,  -45,
     -37,   13,  -59,      -18,    2,  -73,        1,   -8,  -86,       20,  -19, -100,
    -111,   54,   -1,      -92,   44,  -14,      -72,   33,  -28,      -54,   22,  -41,
     -34,   11,  -55,      -16,    1,  -69,        3,   -9,  -82,       23,  -20,  -96,
    -108,   53,    3,      -89,   42,  -10,      -70,   31,  -24,      -51,   21,  -37,
     -32,   10,  -51,      -13,    0,  -64,        6,  -10,  -78,       25,  -21,  -91,
    -106,   51,    7,      -87,   41,   -6,      -67,   30,  -20,      -49,   19,  -33,
     -29,    8,  -47,      -10,   -1,  -60,        8,  -12,  -74,       28,  -23,  -87,
    -103,   50,   11,      -84,   39,   -2,      -65,   29,  -16,      -46,   18,  -29,
     -27,    7,  -43,       -8,   -3,  -56,       11,  -13,  -70,       30,  -24,  -83,
    -101,   49,   15,      -82,   38,    1,      -63,   27,  -12,      -44,   17,  -25,
     -24,    6,  -39,       -6,   -4,  -52,       13,  -15,  -66,       33,  -25,  -79,
     -98,   47,   19,      -79,   37,    6,      -60,   26,   -7,      -41,   15,  -20,
     -22,    4,  -34,       -3,   -5,  -48,       16,  -16,  -61,       35,  -27,  -75,
     -96,   46,   23,      -77,   35,   10,      -58,   24,   -3,      -39,   14,  -16,
     -19,    3,  -30,       -1,   -7,  -44,       18,  -17,  -57,       38,  -28,  -71,
     -93,   45,   27,      -74,   34,   14,      -55,   23,    0,      -36,   12,  -12,
     -17,    1,  -26,        2,   -8,  -40,       21,  -19,  -53,       40,  -30,  -67,
     -91,   43,   31,      -72,   33,   18,      -53,   22,    4,      -34,   11,   -8,
     -15,    0,  -22,        4,  -10,  -36,       23,  -20,  -49,       42,  -31,  -63,
     -88,   42,   35,      -70,   31,   22,      -50,   20,    8,      -32,   10,   -4,
     -12,    0,  -18,        7,  -11,  -32,       25,  -21,  -45,       45,  -32,  -59,
     -86,   40,   40,      -67,   30,   26,      -48,   19,   12,      -29,    8,    0,
      -9,   -2,  -14,        9,  -12,  -27,       28,  -23,  -41,       47,  -34,  -54,
     -83,   39,   44,      -65,   28,   30,      -45,   17,   16,      -26,    7,    3,
      -7,   -3,  -10,       12,  -14,  -23,       30,  -24,  -37,       50,  -35,  -50,
     -81,   38,   48,      -62,   27,   34,      -43,   16,   20,      -24,    5,    7,
      -5,   -4,   -6,       14,  -15,  -19,       33,  -26,  -33,       52,  -37,  -46,
     -79,   36,   52,      -60,   26,   38,      -40,   15,   24,      -22,    4,   11,
      -2,   -6,   -2,       16,  -16,  -15,       35,  -27,  -29,       55,  -38,  -42,
     -76,   35,   56,      -57,   24,   43,      -38,   13,   29,      -19,    3,   16,
       0,   -7,    2,       19,  -18,  -11,       38,  -29,  -24,       57,  -39,  -38,
     -74,   33,   60,      -55,   23,   47,      -35,   12,   33,      -17,    1,   20,
       3,   -9,    6,       22,  -19,   -7,       40,  -30,  -20,       60,  -41,  -34,
     -71,   32,   64,      -52,   21,   51,      -33,   10,   37,      -14,    0,   24,
       5,  -10,   10,       24,  -21,   -3,       43,  -31,  -16,       62,  -42,  -30,
     -69,   31,   68,      -50,   20,   55,      -31,    9,   41,      -12,    0,   28,
       8,  -11,   14,       26,  -22,    0,       45,  -33,  -12,       65,  -44,  -26,
     -66,   29,   73,      -47,   19,   59,      -28,    8,   45,       -9,   -2,   32,
      10,  -13,   18,       29,  -24,    5,       48,  -34,   -8,       67,  -45,  -21,
     -64,   28,   77,      -45,   17,   63,      -26,    6,   49,       -7,   -3,   36,
      13,  -14,   22,       31,  -25,    9,       50,  -35,   -4,       70,  -46,  -17,
     -61,   26,   81,      -42,   16,   67,      -23,    5,   53,       -4,   -5,   40,
      15,  -16,   26,       34,  -26,   13,       53,  -37,    0,       72,  -48,  -13,
     -59,   25,   85,      -40,   15,   71,      -21,    4,   57,       -2,   -6,   44,
      17,  -17,   30,       36,  -28,   17,       55,  -38,    3,       74,  -49,   -9,
     -56,   24,   89,      -38,   13,   75,      -18,    2,   61,        0,   -7,   48,
      20,  -18,   34,       39,  -29,   21,       57,  -40,    7,       77,  -50,   -5,
     -54,   22,   93,      -35,   12,   80,      -16,    1,   66,        3,   -9,   53,
      23,  -20,   39,       41,  -30,   25,       60,  -41,   12,       79,  -52,   -1,
     -51,   21,   97,      -33,   10,   84,      -13,    0,   70,        6,  -10,   57,
      25,  -21,   43,       44,  -32,   29,       62,  -42,   16,       82,  -53,    2,
     -49,   20,  101,      -30,    9,   88,      -11,   -1,   74,        8,  -12,   61,
      27,  -23,   47,       46,  -33,   33,       65,  -44,   20,       84,  -55,    6,
     -47,   18,  105,      -28,    8,   92,       -8,   -2,   78,       10,  -13,   65,
      30,  -24,   51,       48,  -34,   37,       67,  -45,   24,       87,  -56,   10,
     -44,   17,  110,      -25,    6,   96,       -6,   -4,   82,       13,  -14,   69,
      32,  -25,   55,       51,  -36,   42,       70,  -47,   28,       89,  -58,   15,
     -42,   15,  114,      -23,    5,  100,       -3,   -5,   86,       15,  -16,   73,
      35,  -27,   59,       54,  -37,   46,       72,  -48,   32,       92,  -59,   19,
     -39,   14,  118,      -20,    3,  104,       -1,   -7,   90,       18,  -17,   77,
      37,  -28,   63,       56,  -39,   50,       75,  -49,   36,       94,  -60,   23,
    -114,   61,  -10,      -96,   50,  -23,      -76,   39,  -37,      -58,   29,  -50,
     -38,   18,  -64,      -19,    7,  -77,       -1,   -2,  -91,       19,  -13, -105,
    -112,   60,   -6,      -93,   49,  -19,      -74,   38,  -33,      -55,   28,  -46,
     -36,   17,  -60,      -17,    6,  -73,        2,   -4,  -87,       21,  -15, -101,
    -110,   58,   -2,      -91,   48,  -15,      -72,   37,  -29,      -53,   26,  -42,
     -33,   15,  -56,      -15,    5,  -69,        4,   -5,  -83,       24,  -16,  -97,
    -107,   57,    2,      -88,   46,  -10,      -69,   35,  -24,      -50,   25,  -38,
     -31,   14,  -51,      -12,    3,  -65,        7,   -6,  -78,       26,  -17,  -92,
    -105,   55,    6,      -86,   45,   -6,      -66,   34,  -20,      -48,   23,  -34,
     -28,   12,  -47,      -10,    2,  -61,        9,   -8,  -74,       29,  -19,  -88,
    -102,   54,   10,      -83,   43,   -2,      -64,   33,  -16,      -45,   22,  -30,
     -26,   11,  -43,       -7,    0,  -57,       12,   -9,  -70,       31,  -20,  -84,
    -100,   53,   14,      -81,   42,    1,      -62,   31,  -12,      -43,   21,  -26,
     -24,   10,  -39,       -5,    0,  -53,       14,  -11,  -66,       33,  -21,  -80,
     -97,   51,   18,      -78,   41,    5,      -59,   30,   -8,      -40,   19,  -21,
     -21,    8,  -35,       -2,   -1,  -48,       17,  -12,  -62,       36,  -23,  -76,
     -95,   50,   22,      -76,   39,    9,      -57,   28,   -4,      -38,   18,  -17,
     -18,    7,  -31,        0,   -3,  -44,       19,  -13,  -58,       39,  -24,  -72,
     -92,   49,   26,      -74,   38,   13,      -54,   27,    0,      -35,   16,  -13,
     -16,    5,  -27,        3,   -4,  -40,       22,  -15,  -54,       41,  -26,  -68,
     -90,   47,   30,      -71,   37,   17,      -52,   26,    3,      -33,   15,   -9,
     -14,    4,  -23,        5,   -6,  -36,       24,  -16,  -50,       43,  -27,  -64,
     -88,   46,   34,      -69,   35,   21,      -49,   24,    7,      -31,   14,   -5,
     -11,    3,  -19,        8,   -7,  -32,       26,  -17,  -46,       46,  -28,  -60,
     -85,   44,   39,      -66,   34,   26,      -47,   23,   12,      -28,   12,   -1,
      -9,    1,  -14,       10,   -8,  -28,       29,  -19,  -41,       48,  -30,  -55,
     -82,   43,   43,      -64,   32,   30,      -44,   21,   16,      -26,   11,    2,
      -6,    0,  -10,       13,  -10,  -24,       31,  -20,  -37,       51,  -31,  -51,
     -80,   42,   47,      -61,   31,   34,      -42,   20,   20,      -23,    9,    6,
      -4,    0,   -6,       15,  -11,  -20,       34,  -22,  -33,       53,  -33,  -47,
     -78,   40,   51,      -59,   30,   38,      -40,   19,   24,      -21,    8,   10,
      -1,   -2,   -2,       17,  -12,  -16,       36,  -23,  -29,       56,  -34,  -43,
     -75,   39,   55,      -56,   28,   42,      -37,   17,   28,      -18,    7,   15,
       1,   -3,    1,       20,  -14,  -11,       39,  -25,  -25,       58,  -35,  -39,
     -73,   37,   59,      -54,   27,   46,      -34,   16,   32,      -16,    5,   19,
       4,   -5,    5,       22,  -15,   -7,       41,  -26,  -21,       61,  -37,  -35,
     -70,   36,   63,      -51,   25,   50,      -32,   14,   36,      -13,    4,   23,
       6,   -6,    9,       25,  -17,   -3,       44,  -27,  -17,       63,  -38,  -31,
     -68,   35,   67,      -49,   24,   54,      -30,   13,   40,      -11,    3,   27,
       8,   -7,   13,       27,  -18,    0,       46,  -29,  -13,       65,  -40,  -27,
     -65,   33,   72,      -46,   23,   59,      -27,   12,   45,       -8,    1,   31,
      11,   -9,   18,       30,  -20,    4,       49,  -30,   -8,       68,  -41,  -22,
     -63,   32,   76,      -44,   21,   63,      -25,   10,   49,       -6,    0,   35,
      14,  -10,   22,       32,  -21,    8,       51,  -31,   -4,       70,  -42,  -18,
     -60,   30,   80,      -42,   20,   67,      -22,    9,   53,       -3,   -1,   39,
      16,  -12,   26,       35,  -22,   12,       54,  -33,    0,       73,  -44,  -14,
     -58,   29,   84,      -39,   19,   71,      -20,    8,   57,       -1,   -2,   43,
      18,  -13,   30,       37,  -24,   16,       56,  -34,    3,       75,  -45,  -10,
     -56,   28,   88,      -37,   17,   75,      -17,    6,   61,        1,   -3,   47,
      21,  -14,   34,       40,  -25,   20,       58,  -36,    7,       78,  -46,   -6,
     -53,   26,   92,      -34,   16,   79,      -15,    5,   65,        4,   -5,   52,
      23,  -16,   38,       42,  -26,   25,       61,  -37,   11,       80,  -48,   -2,
     -50,   25,   96,      -32,   14,   83,      -12,    3,   69,        6,   -6,   56,
      26,  -17,   42,       45,  -28,   29,       63,  -38,   15,       83,  -49,    1,
     -48,   24,  100,      -29,   13,   87,      -10,    2,   73,        9,   -8,   60,
      28,  -19,   46,       47,  -29,   33,       66,  -40,   19,       85,  -51,    5,
     -46,   22,  104,      -27,   12,   91,       -8,    1,   77,       11,   -9,   64,
      31,  -20,   50,       49,  -30,   37,       68,  -41,   23,       88,  -52,    9,
     -43,   21,  109,      -24,   10,   96,       -5,    0,   82,       14,  -10,   68,
      33,  -21,   55,       52,  -32,   41,       71,  -43,   28,       90,  -54,   14,
     -41,   19,  113,      -22,    9,  100,       -2,   -1,   86,       16,  -12,   72,
      36,  -23,   59,       54,  -33,   45,       73,  -44,   32,       93,  -55,   18,
     -38,   18,  117,      -19,    7,  104,        0,   -3,   90,       19,  -13,   76,
      38,  -24,   63,       57,  -35,   49,       76,  -45,   36,       95,  -56,   22,
    -113,   66,  -10,      -95,   55,  -24,      -75,   44,  -37,      -57,   33,  -51,
     -37,   22,  -65,      -18,   12,  -78,        0,    1,  -91,       20,   -9, -105,
    -111,   64,   -6,      -92,   54,  -20,      -73,   43,  -33,      -54,   32,  -47,
     -35,   21,  -61,      -16,   10,  -74,        3,    0,  -87,       22,  -10, -101,
    -109,   63,   -2,      -90,   52,  -16,      -71,   41,  -29,      -52,   31,  -43,
     -32,   20,  -57,      -14,    9,  -70,        5,    0,  -83,       25,  -11,  -97,
    -106,   61,    1,      -87,   51,  -11,      -68,   40,  -25,      -49,   29,  -38,
     -30,   18,  -52,      -11,    8,  -66,        8,   -2,  -79,       27,  -13,  -93,
    -104,   60,    5,      -85,   49,   -7,      -65,   38,  -21,      -47,   28,  -34,
     -27,   17,  -48,       -8,    6,  -62,       10,   -3,  -75,       30,  -14,  -89,
    -101,   59,    9,      -82,   48,   -3,      -63,   37,  -17,      -44,   26,  -30,
     -25,   16,  -44,       -6,    5,  -58,       13,   -5,  -71,       32,  -16,  -85,
     -99,   57,   13,      -80,   47,    0,      -61,   36,  -13,      -42,   25,  -26,
     -22,   14,  -40,       -4,    4,  -54,       15,   -6,  -67,       34,  -17,  -81,
     -96,   56,   18,      -77,   45,    4,      -58,   34,   -8,      -39,   24,  -22,
     -20,   13,  -36,       -1,    2,  -49,       18,   -8,  -62,       37,  -18,  -76,
     -94,   54,   22,      -75,   44,    8,      -56,   33,   -4,      -37,   22,  -18,
     -17,   11,  -32,        1,    1,  -45,       20,   -9,  -58,       40,  -20,  -72,
     -91,   53,   26,      -73,   42,   12,      -53,   31,    0,      -34,   21,  -14,
     -15,   10,  -28,        4,    0,  -41,       23,  -10,  -54,       42,  -21,  -68,
     -89,   52,   30,      -70,   41,   16,      -51,   30,    3,      -32,   20,  -10,
     -13,    9,  -24,        6,   -1,  -37,       25,  -12,  -50,       44,  -23,  -64,
     -87,   50,   34,      -68,   40,   20,      -48,   29,    7,      -30,   18,   -6,
     -10,    7,  -20,        9,   -2,  -33,       27,  -13,  -46,       47,  -24,  -60,
     -84,   49,   38,      -65,   38,   25,      -46,   27,   11,      -27,   17,   -1,
      -8,    6,  -15,       11,   -4,  -29,       30,  -14,  -42,       49,  -25,  -56,
     -81,   47,   42,      -63,   37,   29,      -43,   26,   15,      -25,   15,    2,
      -5,    4,  -11,       14,   -5,  -25,       32,  -16,  -38,       52,  -27,  -52,
     -79,   46,   46,      -60,   35,   33,      -41,   25,   19,      -22,   14,    6,
      -3,    3,   -7,       16,   -7,  -21,       35,  -17,  -34,       54,  -28,  -48,
     -77,   45,   50,      -58,   34,   37,      -39,   23,   23,      -20,   13,   10,
       0,    2,   -3,       18,   -8,  -17,       37,  -19,  -30,       57,  -29,  -44,
     -74,   43,   55,      -55,   33,   41,      -36,   22,   28,      -17,   11,   14,
       2,    0,    0,       21,   -9,  -12,       40,  -20,  -25,       59,  -31,  -39,
     -72,   42,   59,      -53,   31,   45,      -33,   20,   32,      -15,   10,   18,
       5,    0,    4,       24,  -11,   -8,       42,  -21,  -21,       62,  -32,  -35,
     -69,   41,   63,      -50,   30,   49,      -31,   19,   36,      -12,    8,   22,
       7,   -2,    8,       26,  -12,   -4,       45,  -23,  -17,       64,  -34,  -31,
     -67,   39,   67,      -48,   29,   53,      -29,   18,   40,      -10,    7,   26,
      10,   -3,   12,       28,  -13,    0,       47,  -24,  -13,       66,  -35,  -27,
     -64,   38,   71,      -45,   27,   58,      -26,   16,   44,       -7,    6,   31,
      12,   -4,   17,       31,  -15,    3,       50,  -26,   -9,       69,  -37,  -23,
     -62,   36,   75,      -43,   26,   62,      -24,   15,   48,       -5,    4,   35,
      15,   -6,   21,       33,  -16,    7,       52,  -27,   -5,       72,  -38,  -19,
     -59,   35,   79,      -41,   24,   66,      -21,   13,   52,       -2,    3,   39,
      17,   -7,   25,       36,  -18,   11,       55,  -28,   -1,       74,  -39,  -15,
     -57,   34,   83,      -38,   23,   70,      -19,   12,   56,        0,    1,   43,
      19,   -8,   29,       38,  -19,   15,       57,  -30,    2,       76,  -41,  -11,
     -55,   32,   87,      -36,   22,   74,      -16,   11,   60,        2,    0,   47,
      22,  -10,   33,       41,  -20,   19,       59,  -31,    6,       79,  -42,   -7,
     -52,   31,   92,      -33,   20,   78,      -14,    9,   65,        5,    0,   51,
      24,  -11,   37,       43,  -22,   24,       62,  -33,   11,       81,  -43,   -2,
     -49,   29,   96,      -31,   19,   82,      -11,    8,   69,        7,   -2,   55,
      27,  -13,   41,       46,  -23,   28,       64,  -34,   15,       84,  -45,    1,
     -47,   28,  100,      -28,   17,   86,       -9,    7,   73,       10,   -3,   59,
      29,  -14,   45,       48,  -25,   32,       67,  -35,   19,       86,  -46,    5,
     -45,   27,  104,      -26,   16,   90,       -7,    5,   77,       12,   -4,   63,
      32,  -15,   49,       50,  -26,   36,       69,  -37,   23,       89,  -48,    9,
     -42,   25,  108,      -23,   15,   95,       -4,    4,   81,       15,   -6,   68,
      34,  -17,   54,       53,  -27,   40,       72,  -38,   27,       91,  -49,   13,
     -40,   24,  112,      -21,   13,   99,       -1,    2,   85,       17,   -7,   72,
      37,  -18,   58,       55,  -29,   44,       74,  -39,   31,       94,  -50,   17,
     -37,   22,  116,      -18,   12,  103,        1,    1,   89,       20,   -9,   76,
      39,  -20,   62,       58,  -30,   48,       77,  -41,   35,       96,  -52,   21,
    -113,   70,  -11,      -94,   59,  -24,      -74,   48,  -38,      -56,   37,  -51,
     -36,   26,  -65,      -17,   16,  -79,        1,    5,  -92,       21,   -5, -106,
    -110,   68,   -7,      -91,   58,  -20,      -72,   47,  -34,      -53,   36,  -47,
     -34,   25,  -61,      -15,   14,  -75,        4,    4,  -88,       23,   -6, -102,
    -108,   67,   -3,      -89,   56,  -16,      -70,   45,  -30,      -51,   35,  -43,
     -31,   24,  -57,      -13,   13,  -71,        6,    3,  -84,       25,   -7,  -98,
    -105,   65,    1,      -86,   55,  -12,      -67,   44,  -26,      -48,   33,  -39,
     -29,   22,  -53,      -10,   12,  -66,        9,    1,  -80,       28,   -9,  -93,
    -103,   64,    5,      -84,   53,   -8,      -65,   42,  -22,      -46,   32,  -35,
     -26,   21,  -49,       -8,   10,  -62,       11,    0,  -76,       31,  -10,  -89,
    -100,   63,    9,      -81,   52,   -4,      -62,   41,  -18,      -43,   30,  -31,
     -24,   20,  -45,       -5,    9,  -58,       14,   -1,  -72,       33,  -12,  -85,
     -98,   61,   13,      -79,   51,    0,      -60,   40,  -14,      -41,   29,  -27,
     -22,   18,  -41,       -3,    8,  -54,       16,   -2,  -68,       35,  -13,  -81,
     -95,   60,   17,      -76,   49,    4,      -57,   38,   -9,      -38,   28,  -22,
     -19,   17,  -36,        0,    6,  -50,       19,   -4,  -63,       38,  -14,  -77,
     -93,   58,   21,      -74,   48,    8,      -55,   37,   -5,      -36,   26,  -18,
     -16,   15,  -32,        2,    5,  -46,       21,   -5,  -59,       40,  -16,  -73,
     -90,   57,   25,      -72,   46,   12,      -52,   35,   -1,      -33,   25,  -14,
     -14,   14,  -28,        5,    3,  -42,       23,   -6,  -55,       43,  -17,  -69,
     -88,   56,   29,      -69,   45,   16,      -50,   34,    2,      -31,   24,  -10,
     -12,   13,  -24,        7,    2,  -38,       26,   -8,  -51,       45,  -19,  -65,
     -86,   54,   33,      -67,   44,   20,      -47,   33,    6,      -29,   22,   -6,
      -9,   11,  -20,        9,    1,  -34,       28,   -9,  -47,       48,  -20,  -61,
     -83,   53,   38,      -64,   42,   24,      -45,   31,   10,      -26,   21,   -2,
      -7,   10,  -16,       12,    0,  -29,       31,  -10,  -43,       50,  -21,  -56,
     -81,   51,   42,      -62,   41,   28,      -42,   30,   14,      -24,   19,    1,
      -4,    8,  -12,       15,   -1,  -25,       33,  -12,  -39,       53,  -23,  -52,
     -78,   50,   46,      -59,   39,   32,      -40,   29,   18,      -21,   18,    5,
      -2,    7,   -8,       17,   -3,  -21,       36,  -13,  -35,       55,  -24,  -48,
     -76,   49,   50,      -57,   38,   36,      -38,   27,   22,      -19,   17,    9,
       1,    6,   -4,       19,   -4,  -17,       38,  -15,  -31,       57,  -25,  -44,
     -73,   47,   54,      -54,   37,   41,      -35,   26,   27,      -16,   15,   14,
       3,    4,    0,       22,   -5,  -13,       41,  -16,  -26,       60,  -27,  -40,
     -71,   46,   58,      -52,   35,   45,      -33,   24,   31,      -14,   14,   18,
       6,    3,    4,       24,   -7,   -9,       43,  -17,  -22,       63,  -28,  -36,
     -68,   45,   62,      -50,   34,   49,      -30,   23,   35,      -11,   12,   22,
       8,    1,    8,       27,   -8,   -5,       46,  -19,  -18,       65,  -30,  -32,
     -66,   43,   66,      -47,   33,   53,      -28,   22,   39,       -9,   11,   26,
      10,    0,   12,       29,   -9,   -1,       48,  -20,  -14,       67,  -31,  -28,
     -63,   42,   71,      -44,   31,   57,      -25,   20,   43,       -6,   10,   30,
      13,    0,   16,       32,  -11,    3,       51,  -22,  -10,       70,  -33,  -23,
     -61,   40,   75,      -42,   30,   61,      -23,   19,   47,       -4,    8,   34,
      15,   -2,   20,       34,  -12,    7,       53,  -23,   -6,       72,  -34,  -19,
     -58,   39,   79,      -40,   28,   65,      -20,   17,   51,       -1,    7,   38,
      18,   -3,   24,       37,  -14,   11,       55,  -24,   -2,       75,  -35,  -15,
     -56,   38,   83,      -37,   27,   69,      -18,   16,   55,        1,    5,   42,
      20,   -4,   28,       39,  -15,   15,       58,  -26,    1,       77,  -37,  -11,
     -54,   36,   87,      -35,   26,   73,      -15,   15,   59,        3,    4,   46,
      23,   -6,   32,       41,  -16,   19,       60,  -27,    5,       80,  -38,   -7,
     -51,   35,   91,      -32,   24,   78,      -13,   13,   64,        6,    3,   51,
      25,   -7,   37,       44,  -18,   23,       63,  -29,   10,       82,  -39,   -3,
     -49,   33,   95,      -30,   23,   82,      -10,   12,   68,        8,    1,   55,
      28,   -9,   41,       47,  -19,   27,       65,  -30,   14,       85,  -41,    0,
     -46,   32,   99,      -27,   21,   86,       -8,   11,   72,       11,    0,   59,
      30,  -10,   45,       49,  -21,   31,       68,  -31,   18,       87,  -42,    4,
     -44,   31,  103,      -25,   20,   90,       -6,    9,   76,       13,    0,   63,
      33,  -11,   49,       51,  -22,   35,       70,  -33,   22,       89,  -44,    8,
     -41,   29,  108,      -22,   19,   94,       -3,    8,   80,       16,   -2,   67,
      35,  -13,   53,       54,  -23,   40,       73,  -34,   26,       92,  -45,   13,
     -39,   28,  112,      -20,   17,   98,       -1,    6,   84,       18,   -3,   71,
      38,  -14,   57,       56,  -25,   44,       75,  -35,   30,       95,  -46,   17,
     -36,   26,  116,      -18,   16,  102,        2,    5,   88,       21,   -5,   75,
      40,  -16,   61,       59,  -26,   48,       78,  -37,   34,       97,  -48,   21,
    -112,   74,  -12,      -93,   63,  -25,      -73,   52,  -39,      -55,   41,  -52,
     -35,   30,  -66,      -17,   20,  -79,        2,    9,  -93,       22,   -1, -107,
    -109,   72,   -8,      -90,   62,  -21,      -71,   51,  -35,      -52,   40,  -48,
     -33,   29,  -62,      -14,   18,  -75,        5,    8,  -89,       24,   -2, -103,
    -107,   71,   -4,      -88,   60,  -17,      -69,   49,  -31,      -50,   39,  -44,
     -31,   28,  -58,      -12,   17,  -71,        7,    7,  -85,       26,   -3,  -99,
    -104,   69,    0,      -85,   59,  -12,      -66,   48,  -26,      -47,   37,  -40,
     -28,   26,  -53,       -9,   16,  -67,       10,    5,  -80,       29,   -5,  -94,
    -102,   68,    4,      -83,   57,   -8,      -64,   46,  -22,      -45,   36,  -36,
     -25,   25,  -49,       -7,   14,  -63,       12,    4,  -76,       31,   -6,  -90,
     -99,   67,    8,      -81,   56,   -4,      -61,   45,  -18,      -42,   34,  -32,
     -23,   24,  -45,       -4,   13,  -59,       15,    2,  -72,       34,   -8,  -86,
     -97,   65,   12,      -78,   55,    0,      -59,   44,  -14,      -40,   33,  -28,
     -21,   22,  -41,       -2,   12,  -55,       17,    1,  -68,       36,   -9,  -82,
     -94,   64,   16,      -76,   53,    3,      -56,   42,  -10,      -37,   32,  -23,
     -18,   21,  -37,        1,   10,  -50,       20,    0,  -64,       39,  -10,  -78,
     -92,   62,   20,      -73,   52,    7,      -54,   41,   -6,      -35,   30,  -19,
     -16,   19,  -33,        3,    9,  -46,       22,   -1,  -60,       41,  -12,  -74,
     -90,   61,   24,      -71,   50,   11,      -51,   39,   -2,      -33,   29,  -15,
     -13,   18,  -29,        6,    7,  -42,       24,   -2,  -56,       44,  -13,  -70,
     -87,   60,   28,      -68,   49,   15,      -49,   38,    1,      -30,   28,  -11,
     -11,   17,  -25,        8,    6,  -38,       27,   -4,  -52,       46,  -15,  -66,
     -85,   58,   32,      -66,   48,   19,      -47,   37,    5,      -28,   26,   -7,
      -8,   15,  -21,       10,    5,  -34,       29,   -5,  -48,       49,  -16,  -62,
     -82,   57,   37,      -63,   46,   24,      -44,   35,   10,      -25,   25,   -3,
      -6,   14,  -16,       13,    3,  -30,       32,   -6,  -43,       51,  -17,  -57,
     -80,   55,   41,      -61,   45,   28,      -41,   34,   14,      -23,   23,    0,
      -3,   12,  -12,       15,    2,  -26,       34,   -8,  -39,       54,  -19,  -53,
     -77,   54,   45,      -58,   43,   32,      -39,   33,   18,      -20,   22,    4,
      -1,   11,   -8,       18,    0,  -22,       37,   -9,  -35,       56,  -20,  -49,
     -75,   53,   49,      -56,   42,   36,      -37,   31,   22,      -18,   21,    8,
       1,   10,   -4,       20,    0,  -18,       39,  -11,  -31,       58,  -21,  -45,
     -72,   51,   53,      -53,   41,   40,      -34,   30,   26,      -15,   19,   13,
       4,    8,    0,       23,   -1,  -13,       42,  -12,  -27,       61,  -23,  -41,
     -70,   50,   57,      -51,   39,   44,      -32,   28,   30,      -13,   18,   17,
       7,    7,    3,       25,   -3,   -9,       44,  -13,  -23,       63,  -24,  -37,
     -67,   49,   61,      -49,   38,   48,      -29,   27,   34,      -10,   16,   21,
       9,    5,    7,       28,   -4,   -5,       47,  -15,  -19,       66,  -26,  -33,
     -65,   47,   65,      -46,   37,   52,      -27,   26,   38,       -8,   15,   25,
      11,    4,   11,       30,   -5,   -1,       49,  -16,  -15,       68,  -27,  -29,
     -62,   46,   70,      -44,   35,   57,      -24,   24,   43,       -5,   14,   29,
      14,    3,   16,       33,   -7,    2,       52,  -18,  -10,       71,  -29,  -24,
     -60,   44,   74,      -41,   34,   61,      -22,   23,   47,       -3,   12,   33,
      16,    1,   20,       35,   -8,    6,       54,  -19,   -6,       73,  -30,  -20,
     -58,   43,   78,      -39,   32,   65,      -19,   21,   51,       -1,   11,   37,
      19,    0,   24,       38,  -10,   10,       56,  -20,   -2,       76,  -31,  -16,
     -55,   42,   82,      -36,   31,   69,      -17,   20,   55,        2,    9,   41,
      21,    0,   28,       40,  -11,   14,       59,  -22,    1,       78,  -33,  -12,
     -53,   40,   86,      -34,   30,   73,      -15,   19,   59,        4,    8,   45,
      24,   -2,   32,       42,  -12,   18,       61,  -23,    5,       81,  -34,   -8,
     -50,   39,   90,      -31,   28,   77,      -12,   17,   63,        7,    7,   50,
      26,   -3,   36,       45,  -14,   23,       64,  -25,    9,       83,  -35,   -4,
     -48,   37,   94,      -29,   27,   81,       -9,   16,   67,        9,    5,   54,
      29,   -5,   40,       47,  -15,   27,       66,  -26,   13,       86,  -37,    0,
     -45,   36,   98,      -26,   25,   85,       -7,   15,   71,       12,    4,   58,
      31,   -6,   44,       50,  -17,   31,       69,  -27,   17,       88,  -38,    3,
     -43,   35,  102,      -24,   24,   89,       -5,   13,   75,       14,    3,   62,
      33,   -7,   48,       52,  -18,   35,       71,  -29,   21,       90,  -40,    7,
     -40,   33,  107,      -21,   23,   94,       -2,   12,   80,       17,    1,   66,
      36,   -9,   53,       55,  -19,   39,       74,  -30,   26,       93,  -41,   12,
     -38,   32,  111,      -19,   21,   98,        0,   10,   84,       19,    0,   70,
      39,  -10,   57,       57,  -21,   43,       76,  -31,   30,       95,  -42,   16,
     -35,   30,  115,      -17,   20,  102,        3,    9,   88,       22,   -1,   74,
      41,  -12,   61,       60,  -22,   47,       78,  -33,   34,       98,  -44,   20,
    -111,   78,  -12,      -92,   67,  -26,      -73,   56,  -39,      -54,   45,  -53,
     -34,   34,  -67,      -16,   24,  -80,        3,   13,  -93,       23,    2, -107,
    -108,   76,   -8,      -90,   66,  -22,      -70,   55,  -35,      -51,   44,  -49,
     -32,   33,  -63,      -13,   22,  -76,        6,   12,  -89,       25,    1, -103,
    -106,   75,   -4,      -87,   64,  -18,      -68,   53,  -31,      -49,   43,  -45,
     -30,   32,  -59,      -11,   21,  -72,        8,   11,  -85,       27,    0,  -99,
    -103,   73,    0,      -84,   63,  -13,      -65,   52,  -27,      -46,   41,  -40,
     -27,   30,  -54,       -8,   20,  -68,       11,    9,  -81,       30,   -1,  -95,
    -101,   72,    3,      -82,   61,   -9,      -63,   50,  -23,      -44,   40,  -36,
     -25,   29,  -50,       -6,   18,  -64,       13,    8,  -77,       32,   -2,  -91,
     -98,   71,    7,      -80,   60,   -5,      -60,   49,  -19,      -42,   38,  -32,
     -22,   28,  -46,       -3,   17,  -60,       15,    6,  -73,       35,   -4,  -87,
     -96,   69,   11,      -77,   59,   -1,      -58,   48,  -15,      -39,   37,  -28,
     -20,   26,  -42,       -1,   16,  -56,       18,    5,  -69,       37,   -5,  -83,
     -93,   68,   16,      -75,   57,    2,      -55,   46,  -10,      -36,   36,  -24,
     -17,   25,  -38,        2,   14,  -51,       21,    3,  -64,       40,   -6,  -78,
     -91,   66,   20,      -72,   56,    6,      -53,   45,   -6,      -34,   34,  -20,
     -15,   23,  -34,        4,   13,  -47,       23,    2,  -60,       42,   -8,  -74,
     -89,   65,   24,      -70,   54,   10,      -50,   43,   -2,      -32,   33,  -16,
     -12,   22,  -30,        7,   11,  -43,       25,    1,  -56,       45,   -9,  -70,
     -86,   64,   28,      -67,   53,   14,      -48,   42,    1,      -29,   32,  -12,
     -10,   21,  -26,        9,   10,  -39,       28,    0,  -52,       47,  -11,  -66,
     -84,   62,   32,      -65,   52,   18,      -46,   41,    5,      -27,   30,   -8,
      -7,   19,  -22,       11,    9,  -35,       30,   -1,  -48,       49,  -12,  -62,
     -81,   61,   36,      -62,   50,   23,      -43,   39,    9,      -24,   29,   -3,
      -5,   18,  -17,       14,    7,  -31,       33,   -2,  -44,       52,  -13,  -58,
     -79,   59,   40,      -60,   49,   27,      -41,   38,   13,      -22,   27,    0,
      -2,   16,  -13,       16,    6,  -27,       35,   -4,  -40,       55,  -15,  -54,
     -76,   58,   44,      -58,   47,   31,      -38,   37,   17,      -19,   26,    4,
       0,   15,   -9,       19,    4,  -23,       38,   -5,  -36,       57,  -16,  -50,
     -74,   57,   48,      -55,   46,   35,      -36,   35,   21,      -17,   25,    8,
       2,   14,   -5,       21,    3,  -19,       40,   -7,  -32,       59,  -17,  -46,
     -71,   55,   53,      -52,   45,   39,      -33,   34,   26,      -14,   23,   12,
       5,   12,   -1,       24,    2,  -14,       43,   -8,  -27,       62,  -19,  -41,
     -69,   54,   57,      -50,   43,   43,      -31,   32,   30,      -12,   22,   16,
       7,   11,    2,       26,    0,  -10,       45,   -9,  -23,       64,  -20,  -37,
     -66,   53,   61,      -48,   42,   47,      -28,   31,   34,      -10,   20,   20,
      10,    9,    6,       29,    0,   -6,       47,  -11,  -19,       67,  -22,  -33,
     -64,   51,   65,      -45,   41,   51,      -26,   30,   38,       -7,   19,   24,
      12,    8,   10,       31,   -1,   -2,       50,  -12,  -15,       69,  -23,  -29,
     -61,   50,   69,      -43,   39,   56,      -23,   28,   42,       -4,   18,   29,
      15,    7,   15,       34,   -3,    1,       52,  -14,  -11,       72,  -25,  -25,
     -59,   48,   73,      -40,   38,   60,      -21,   27,   46,       -2,   16,   33,
      17,    5,   19,       36,   -4,    5,       55,  -15,   -7,       74,  -26,  -21,
     -57,   47,   77,      -38,   36,   64,      -18,   25,   50,        0,   15,   37,
      20,    4,   23,       38,   -6,    9,       57,  -16,   -3,       77,  -27,  -17,
     -54,   46,   81,      -35,   35,   68,      -16,   24,   54,        3,   13,   41,
      22,    3,   27,       41,   -7,   13,       60,  -18,    0,       79,  -29,  -13,
     -52,   44,   85,      -33,   34,   72,      -14,   23,   58,        5,   12,   45,
      24,    1,   31,       43,   -8,   17,       62,  -19,    4,       81,  -30,   -9,
     -49,   43,   90,      -30,   32,   76,      -11,   21,   63,        8,   11,   49,
      27,    0,   35,       46,  -10,   22,       65,  -21,    9,       84,  -31,   -4,
     -47,   41,   94,      -28,   31,   80,       -9,   20,   67,       10,    9,   53,
      30,   -1,   39,       48,  -11,   26,       67,  -22,   13,       87,  -33,    0,
     -44,   40,   98,      -26,   29,   84,       -6,   19,   71,       13,    8,   57,
      32,   -2,   43,       51,  -13,   30,       70,  -23,   17,       89,  -34,    3,
     -42,   39,  102,      -23,   28,   88,       -4,   17,   75,       15,    7,   61,
      34,   -3,   47,       53,  -14,   34,       72,  -25,   21,       91,  -36,    7,
     -39,   37,  106,      -20,   27,   93,       -1,   16,   79,       18,    5,   66,
      37,   -5,   52,       56,  -15,   38,       75,  -26,   25,       94,  -37,   11,
     -37,   36,  110,      -18,   25,   97,        1,   14,   83,       20,    4,   70,
      39,   -6,   56,       58,  -17,   42,       77,  -27,   29,       96,  -38,   15,
     -34,   34,  114,      -16,   24,  101,        4,   13,   87,       22,    2,   74,
      42,   -8,   60,       61,  -18,   46,       79,  -29,   33,       99,  -40,   19,
    -110,   82,  -13,      -91,   71,  -26,      -72,   60,  -40,      -53,   50,  -54,
     -33,   39,  -67,      -15,   28,  -81,        4,   18,  -94,       24,    7, -108,
    -107,   81,   -9,      -89,   70,  -22,      -69,   59,  -36,      -50,   49,  -50,
     -31,   38,  -63,      -12,   27,  -77,        7,   16,  -90,       26,    5, -104,
    -105,   79,   -5,      -86,   69,  -18,      -67,   58,  -32,      -48,   47,  -46,
     -29,   36,  -59,      -10,   26,  -73,        9,   15,  -86,       28,    4, -100,
    -102,   78,    0,      -83,   67,  -14,      -64,   56,  -28,      -45,   46,  -41,
     -26,   35,  -55,       -7,   24,  -68,       12,   14,  -82,       31,    3,  -95,
    -100,   76,    3,      -81,   66,  -10,      -62,   55,  -24,      -43,   44,  -37,
     -24,   33,  -51,       -5,   23,  -64,       14,   12,  -78,       33,    1,  -91,
     -97,   75,    7,      -79,   64,   -6,      -59,   54,  -20,      -40,   43,  -33,
     -21,   32,  -47,       -2,   21,  -60,       16,   11,  -74,       36,    0,  -87,
     -95,   74,   11,      -76,   63,   -2,      -57,   52,  -16,      -38,   42,  -29,
     -19,   31,  -43,        0,   20,  -56,       19,    9,  -70,       38,    0,  -83,
     -92,   72,   15,      -74,   62,    2,      -54,   51,  -11,      -35,   40,  -25,
     -16,   29,  -38,        3,   19,  -52,       22,    8,  -65,       41,   -2,  -79,
     -90,   71,   19,      -71,   60,    6,      -52,   49,   -7,      -33,   39,  -21,
     -14,   28,  -34,        5,   17,  -48,       24,    7,  -61,       43,   -3,  -75,
     -88,   70,   23,      -69,   59,   10,      -49,   48,   -3,      -31,   37,  -17,
     -11,   26,  -30,        8,   16,  -44,       26,    5,  -57,       46,   -5,  -71,
     -85,   68,   27,      -66,   58,   14,      -47,   47,    0,      -28,   36,  -13,
      -9,   25,  -26,       10,   14,  -40,       29,    4,  -53,       48,   -6,  -67,
     -83,   67,   31,      -64,   56,   18,      -45,   45,    4,      -26,   35,   -9,
      -6,   24,  -22,       12,   13,  -36,       31,    3,  -49,       50,   -7,  -63,
     -80,   65,   36,      -61,   55,   22,      -42,   44,    8,      -23,   33,   -4,
      -4,   22,  -18,       15,   12,  -31,       34,    1,  -45,       53,   -9,  -58,
     -78,   64,   40,      -59,   53,   26,      -40,   42,   12,      -21,   32,    0,
      -1,   21,  -14,       17,   10,  -27,       36,    0,  -41,       56,  -10,  -54,
     -75,   63,   44,      -57,   52,   30,      -37,   41,   16,      -18,   30,    3,
       1,   20,  -10,       20,    9,  -23,       39,   -1,  -37,       58,  -12,  -50,
     -73,   61,   48,      -54,   51,   34,      -35,   40,   20,      -16,   29,    7,
       3,   18,   -6,       22,    8,  -19,       41,   -2,  -33,       60,  -13,  -46,
     -70,   60,   52,      -51,   49,   39,      -32,   38,   25,      -13,   28,   11,
       6,   17,   -1,       25,    6,  -15,       44,   -4,  -28,       63,  -14,  -42,
     -68,   58,   56,      -49,   48,   43,      -30,   37,   29,      -11,   26,   15,
       8,   15,    2,       27,    5,  -11,       46,   -5,  -24,       65,  -16,  -38,
     -65,   57,   60,      -47,   46,   47,      -27,   35,   33,       -8,   25,   19,
      11,   14,    6,       30,    3,   -7,       48,   -6,  -20,       68,  -17,  -34,
     -63,   56,   64,      -44,   45,   51,      -25,   34,   37,       -6,   24,   23,
      13,   13,   10,       32,    2,   -3,       51,   -8,  -16,       70,  -19,  -30,
     -60,   54,   69,      -42,   44,   55,      -22,   33,   41,       -3,   22,   28,
      16,   11,   14,       35,    0,    1,       54,   -9,  -12,       73,  -20,  -25,
     -58,   53,   73,      -39,   42,   59,      -20,   31,   45,       -1,   21,   32,
      18,   10,   18,       37,    0,    5,       56,  -10,   -8,       75,  -21,  -21,
     -56,   51,   77,      -37,   41,   63,      -17,   30,   49,        1,   19,   36,
      21,    8,   22,       40,   -1,    9,       58,  -12,   -4,       78,  -23,  -17,
     -53,   50,   81,      -34,   40,   67,      -15,   29,   53,        4,   18,   40,
      23,    7,   26,       42,   -3,   13,       61,  -13,    0,       80,  -24,  -13,
     -51,   49,   85,      -32,   38,   71,      -13,   27,   57,        6,   17,   44,
      26,    6,   30,       44,   -4,   17,       63,  -15,    3,       82,  -25,   -9,
     -48,   47,   89,      -29,   37,   76,      -10,   26,   62,        9,   15,   48,
      28,    4,   35,       47,   -5,   21,       66,  -16,    8,       85,  -27,   -5,
     -46,   46,   93,      -27,   35,   80,       -8,   24,   66,       11,   14,   52,
      31,    3,   39,       49,   -7,   25,       68,  -17,   12,       88,  -28,   -1,
     -43,   45,   97,      -25,   34,   84,       -5,   23,   70,       14,   12,   56,
      33,    1,   43,       52,   -8,   29,       71,  -19,   16,       90,  -30,    2,
     -41,   43,  101,      -22,   33,   88,       -3,   22,   74,       16,   11,   60,
      35,    0,   47,       54,   -9,   33,       73,  -20,   20,       92,  -31,    6,
     -38,   42,  106,      -19,   31,   92,        0,   20,   78,       19,   10,   65,
      38,    0,   51,       57,  -11,   38,       76,  -22,   24,       95,  -33,   11,
     -36,   40,  110,      -17,   30,   96,        2,   19,   82,       21,    8,   69,
      40,   -2,   55,       59,  -12,   42,       78,  -23,   28,       97,  -34,   15,
     -33,   39,  114,      -15,   28,  100,        5,   17,   86,       23,    7,   73,
      43,   -3,   59,       62,  -14,   46,       80,  -24,   32,      100,  -35,   19,
    -109,   86,  -14,      -90,   75,  -27,      -71,   64,  -41,      -52,   54,  -54,
     -32,   43,  -68,      -14,   32,  -81,        5,   22,  -95,       24,   11, -109,
    -106,   85,  -10,      -88,   74,  -23,      -68,   63,  -37,      -49,   53,  -50,
     -30,   42,  -64,      -11,   31,  -77,        7,   20,  -91,       27,    9, -105,
    -104,   83,   -6,      -85,   73,  -19,      -66,   62,  -33,      -47,   51,  -46,
     -28,   40,  -60,       -9,   30,  -73,       10,   19,  -87,       29,    8, -101,
    -101,   82,   -1,      -83,   71,  -14,      -63,   60,  -28,      -44,   50,  -42,
     -25,   39,  -55,       -6,   28,  -69,       13,   18,  -82,       32,    7,  -96,
     -99,   80,    2,      -80,   70,  -10,      -61,   59,  -24,      -42,   48,  -38,
     -23,   37,  -51,       -4,   27,  -65,       15,   16,  -78,       34,    5,  -92,
     -97,   79,    6,      -78,   68,   -6,      -58,   58,  -20,      -40,   47,  -34,
     -20,   36,  -47,       -1,   25,  -61,       17,   15,  -74,       37,    4,  -88,
     -94,   78,   10,      -75,   67,   -2,      -56,   56,  -16,      -37,   46,  -30,
     -18,   35,  -43,        1,   24,  -57,       20,   13,  -70,       39,    3,  -84,
     -91,   76,   14,      -73,   66,    1,      -53,   55,  -12,      -34,   44,  -25,
     -15,   33,  -39,        4,   23,  -52,       22,   12,  -66,       42,    1,  -80,
     -89,   75,   18,      -70,   64,    5,      -51,   53,   -8,      -32,   43,  -21,
     -13,   32,  -35,        6,   21,  -48,       25,   11,  -62,       44,    0,  -76,
     -87,   74,   22,      -68,   63,    9,      -48,   52,   -4,      -30,   41,  -17,
     -10,   30,  -31,        8,   20,  -44,       27,    9,  -58,       47,   -1,  -72,
     -84,   72,   26,      -65,   62,   13,      -46,   51,    0,      -27,   40,  -13,
      -8,   29,  -27,       11,   18,  -40,       30,    8,  -54,       49,   -2,  -68,
     -82,   71,   30,      -63,   60,   17,      -44,   49,    3,      -25,   39,   -9,
      -6,   28,  -23,       13,   17,  -36,       32,    7,  -50,       51,   -3,  -64,
     -79,   69,   35,      -60,   59,   22,      -41,   48,    8,      -22,   37,   -5,
      -3,   26,  -18,       16,   16,  -32,       35,    5,  -45,       54,   -5,  -59,
     -77,   68,   39,      -58,   57,   26,      -39,   46,   12,      -20,   36,   -1,
       0,   25,  -14,       18,   14,  -28,       37,    4,  -41,       56,   -6,  -55,
     -74,   67,   43,      -56,   56,   30,      -36,   45,   16,      -17,   34,    2,
       2,   24,  -10,       21,   13,  -24,       39,    2,  -37,       59,   -8,  -51,
     -72,   65,   47,      -53,   55,   34,      -34,   44,   20,      -15,   33,    6,
       4,   22,   -6,       23,   12,  -20,       42,    1,  -33,       61,   -9,  -47,
     -69,   64,   51,      -51,   53,   38,      -31,   42,   24,      -12,   32,   11,
       7,   21,   -2,       26,   10,  -15,       45,    0,  -29,       64,  -10,  -43,
     -67,   62,   55,      -48,   52,   42,      -29,   41,   28,      -10,   30,   15,
       9,   19,    1,       28,    9,  -11,       47,   -1,  -25,       66,  -12,  -39,
     -65,   61,   59,      -46,   50,   46,      -26,   39,   32,       -8,   29,   19,
      12,   18,    5,       31,    7,   -7,       49,   -2,  -21,       69,  -13,  -35,
     -62,   60,   63,      -43,   49,   50,      -24,   38,   36,       -5,   28,   23,
      14,   17,    9,       33,    6,   -3,       52,   -4,  -17,       71,  -15,  -31,
     -59,   58,   68,      -41,   48,   55,      -21,   37,   41,       -3,   26,   27,
      17,   15,   14,       36,    4,    0,       54,   -5,  -12,       74,  -16,  -26,
     -57,   57,   72,      -38,   46,   59,      -19,   35,   45,        0,   25,   31,
      19,   14,   18,       38,    3,    4,       57,   -6,   -8,       76,  -17,  -22,
     -55,   55,   76,      -36,   45,   63,      -17,   34,   49,        2,   23,   35,
      22,   12,   22,       40,    2,    8,       59,   -8,   -4,       79,  -19,  -18,
     -52,   54,   80,      -33,   44,   67,      -14,   33,   53,        5,   22,   39,
      24,   11,   26,       43,    0,   12,       62,   -9,    0,       81,  -20,  -14,
     -50,   53,   84,      -31,   42,   71,      -12,   31,   57,        7,   21,   43,
      26,   10,   30,       45,    0,   16,       64,  -11,    3,       83,  -21,  -10,
     -47,   51,   88,      -28,   41,   75,       -9,   30,   61,       10,   19,   48,
      29,    8,   34,       48,   -1,   21,       67,  -12,    7,       86,  -23,   -6,
     -45,   50,   92,      -26,   39,   79,       -7,   28,   65,       12,   18,   52,
      32,    7,   38,       50,   -3,   25,       69,  -13,   11,       88,  -24,   -2,
     -42,   49,   96,      -24,   38,   83,       -4,   27,   69,       15,   16,   56,
      34,    5,   42,       53,   -4,   29,       71,  -15,   15,       91,  -26,    1,
     -40,   47,  100,      -21,   37,   87,       -2,   26,   73,       17,   15,   60,
      36,    4,   46,       55,   -5,   33,       74,  -16,   19,       93,  -27,    5,
     -37,   46,  105,      -19,   35,   92,        1,   24,   78,       20,   14,   64,
      39,    3,   51,       58,   -7,   37,       77,  -18,   24,       96,  -29,   10,
     -35,   44,  109,      -16,   34,   96,        3,   23,   82,       22,   12,   68,
      41,    1,   55,       60,   -8,   41,       79,  -19,   28,       98,  -30,   14,
     -33,   43,  113,      -14,   32,  100,        6,   21,   86,       24,   11,   72,
      44,    0,   59,       63,  -10,   45,       81,  -20,   32,      101,  -31,   18,
    -108,   90,  -14,      -89,   79,  -28,      -70,   68,  -41,      -51,   58,  -55,
     -32,   47,  -69,      -13,   36,  -82,        6,   26,  -95,       25,   15, -109,
    -105,   89,  -10,      -87,   78,  -24,      -67,   67,  -37,      -49,   57,  -51,
     -29,   46,  -65,      -10,   35,  -78,        8,   24,  -91,       28,   13, -105,
    -103,   87,   -6,      -84,   77,  -20,      -65,   66,  -33,      -46,   55,  -47,
     -27,   44,  -61,       -8,   34,  -74,       11,   23,  -87,       30,   12, -101,
    -100,   86,   -2,      -82,   75,  -15,      -62,   64,  -29,      -43,   54,  -42,
     -24,   43,  -56,       -5,   32,  -70,       13,   22,  -83,       33,   11,  -97,
     -98,   84,    1,      -79,   74,  -11,      -60,   63,  -25,      -41,   52,  -38,
     -22,   41,  -52,       -3,   31,  -66,       16,   20,  -79,       35,    9,  -93,
     -96,   83,    5,      -77,   72,   -7,      -57,   62,  -21,      -39,   51,  -34,
     -19,   40,  -48,       -1,   29,  -62,       18,   19,  -75,       38,    8,  -89,
     -93,   82,    9,      -74,   71,   -3,      -55,   60,  -17,      -36,   50,  -30,
     -17,   39,  -44,        2,   28,  -58,       21,   17,  -71,       40,    7,  -85,
     -91,   80,   14,      -72,   70,    0,      -52,   59,  -12,      -34,   48,  -26,
     -14,   37,  -40,        5,   27,  -53,       23,   16,  -66,       43,    5,  -80,
     -88,   79,   18,      -69,   68,    4,      -50,   57,   -8,      -31,   47,  -22,
     -12,   36,  -36,        7,   25,  -49,       26,   15,  -62,       45,    4,  -76,
     -86,   78,   22,      -67,   67,    8,      -48,   56,   -4,      -29,   45,  -18,
      -9,   34,  -32,        9,   24,  -45,       28,   13,  -58,       48,    2,  -72,
     -83,   76,   26,      -65,   66,   12,      -45,   55,    0,      -26,   44,  -14,
      -7,   33,  -28,       12,   22,  -41,       31,   12,  -54,       50,    1,  -68,
     -81,   75,   30,      -62,   64,   16,      -43,   53,    3,      -24,   43,  -10,
      -5,   32,  -24,       14,   21,  -37,       33,   11,  -50,       52,    0,  -64,
     -78,   73,   34,      -59,   63,   21,      -40,   52,    7,      -21,   41,   -5,
      -2,   30,  -19,       17,   20,  -33,       36,    9,  -46,       55,   -1,  -60,
     -76,   72,   38,      -57,   61,   25,      -38,   50,   11,      -19,   40,   -1,
       0,   29,  -15,       19,   18,  -29,       38,    8,  -42,       57,   -2,  -56,
     -73,   71,   42,      -55,   60,   29,      -35,   49,   15,      -17,   38,    2,
       3,   28,  -11,       22,   17,  -25,       40,    6,  -38,       60,   -4,  -52,
     -71,   69,   46,      -52,   59,   33,      -33,   48,   19,      -14,   37,    6,
       5,   26,   -7,       24,   16,  -21,       43,    5,  -34,       62,   -5,  -48,
     -68,   68,   51,      -50,   57,   37,      -30,   46,   24,      -11,   36,   10,
       8,   25,   -3,       27,   14,  -16,       45,    3,  -29,       65,   -6,  -43,
     -66,   66,   55,      -47,   56,   41,      -28,   45,   28,       -9,   34,   14,
      10,   23,    0,       29,   13,  -12,       48,    2,  -25,       67,   -8,  -39,
     -64,   65,   59,      -45,   54,   45,      -25,   43,   32,       -7,   33,   18,
      13,   22,    4,       31,   11,   -8,       50,    1,  -21,       70,   -9,  -35,
     -61,   64,   63,      -42,   53,   49,      -23,   42,   36,       -4,   32,   22,
      15,   21,    8,       34,   10,   -4,       53,    0,  -17,       72,  -11,  -31,
     -59,   62,   67,      -40,   52,   54,      -20,   41,   40,       -2,   30,   27,
      18,   19,   13,       37,    8,    0,       55,   -1,  -13,       75,  -12,  -27,
     -56,   61,   71,      -37,   50,   58,      -18,   39,   44,        1,   29,   31,
      20,   18,   17,       39,    7,    3,       58,   -2,   -9,       77,  -13,  -23,
     -54,   59,   75,      -35,   49,   62,      -16,   38,   48,        3,   27,   35,
      23,   16,   21,       41,    6,    7,       60,   -4,   -5,       80,  -15,  -19,
     -51,   58,   79,      -33,   48,   66,      -13,   37,   52,        6,   26,   39,
      25,   15,   25,       44,    4,   11,       63,   -5,   -1,       82,  -16,  -15,
     -49,   57,   83,      -30,   46,   70,      -11,   35,   56,        8,   25,   43,
      27,   14,   29,       46,    3,   15,       65,   -7,    2,       84,  -17,  -11,
     -46,   55,   88,      -27,   45,   74,       -8,   34,   61,       11,   23,   47,
      30,   12,   33,       49,    2,   20,       68,   -8,    7,       87,  -19,   -6,
     -44,   54,   92,      -25,   43,   78,       -6,   32,   65,       13,   22,   51,
      32,   11,   37,       51,    0,   24,       70,   -9,   11,       89,  -20,   -2,
     -41,   53,   96,      -23,   42,   82,       -3,   31,   69,       15,   20,   55,
      35,    9,   41,       54,    0,   28,       72,  -11,   15,       92,  -22,    1,
     -39,   51,  100,      -20,   41,   86,       -1,   30,   73,       18,   19,   59,
      37,    8,   45,       56,   -1,   32,       75,  -12,   19,       94,  -23,    5,
     -36,   50,  104,      -18,   39,   91,        2,   28,   77,       21,   18,   64,
      40,    7,   50,       59,   -3,   36,       77,  -14,   23,       97,  -25,    9,
     -34,   48,  108,      -15,   38,   95,        4,   27,   81,       23,   16,   68,
      42,    5,   54,       61,   -4,   40,       80,  -15,   27,       99,  -26,   13,
     -32,   47,  112,      -13,   36,   99,        7,   25,   85,       25,   15,   72,
      45,    4,   58,       63,   -6,   44,       82,  -16,   31,      102,  -27,   17,
    -107,   94,  -15,      -88,   83,  -28,      -69,   72,  -42,      -50,   62,  -55,
     -31,   51,  -69,      -12,   40,  -83,        7,   30,  -96,       26,   19, -110,
    -105,   93,  -11,      -86,   82,  -24,      -66,   71,  -38,      -48,   61,  -51,
     -28,   50,  -65,       -9,   39,  -79,        9,   28,  -92,       29,   17, -106,
    -102,   91,   -7,      -83,   81,  -20,      -64,   70,  -34,      -45,   59,  -47,
     -26,   48,  -61,       -7,   38,  -75,       12,   27,  -88,       31,   16, -102,
     -99,   90,   -2,      -81,   79,  -16,      -61,   68,  -30,      -43,   58,  -43,
     -23,   47,  -57,       -4,   36,  -70,       14,   26,  -84,       34,   15,  -97,
     -97,   88,    1,      -78,   78,  -12,      -59,   67,  -26,      -40,   56,  -39,
     -21,   45,  -53,       -2,   35,  -66,       17,   24,  -80,       36,   13,  -93,
     -95,   87,    5,      -76,   76,   -8,      -57,   66,  -22,      -38,   55,  -35,
     -18,   44,  -49,        0,   33,  -62,       19,   23,  -76,       39,   12,  -89,
     -92,   86,    9,      -74,   75,   -4,      -54,   64,  -18,      -35,   54,  -31,
     -16,   43,  -45,        3,   32,  -58,       22,   21,  -72,       41,   11,  -85,
     -90,   84,   13,      -71,   74,    0,      -51,   63,  -13,      -33,   52,  -26,
     -13,   41,  -40,        5,   31,  -54,       24,   20,  -67,       44,    9,  -81,
     -87,   83,   17,      -68,   72,    4,      -49,   61,   -9,      -30,   51,  -22,
     -11,   40,  -36,        8,   29,  -50,       27,   19,  -63,       46,    8,  -77,
     -85,   82,   21,      -66,   71,    8,      -47,   60,   -5,      -28,   49,  -18,
      -9,   38,  -32,       10,   28,  -46,       29,   17,  -59,       48,    6,  -73,
     -82,   80,   25,      -64,   70,   12,      -44,   59,   -1,      -25,   48,  -14,
      -6,   37,  -28,       13,   26,  -42,       31,   16,  -55,       51,    5,  -69,
     -80,   79,   29,      -61,   68,   16,      -42,   57,    2,      -23,   47,  -10,
      -4,   36,  -24,       15,   25,  -38,       34,   15,  -51,       53,    4,  -65,
     -77,   77,   34,      -59,   67,   20,      -39,   56,    6,      -20,   45,   -6,
      -1,   34,  -20,       18,   24,  -33,       37,   13,  -47,       56,    2,  -60,
     -75,   76,   38,      -56,   65,   24,      -37,   54,   10,      -18,   44,   -2,
       1,   33,  -16,       20,   22,  -29,       39,   12,  -43,       58,    1,  -56,
     -73,   75,   42,      -54,   64,   28,      -34,   53,   14,      -16,   42,    1,
       4,   32,  -12,       23,   21,  -25,       41,   10,  -39,       61,    0,  -52,
     -70,   73,   46,      -51,   63,   32,      -32,   52,   18,      -13,   41,    5,
       6,   30,   -8,       25,   20,  -21,       44,    9,  -35,       63,   -1,  -48,
     -67,   72,   50,      -49,   61,   37,      -29,   50,   23,      -11,   40,   10,
       9,   29,   -3,       28,   18,  -17,       46,    7,  -30,       66,   -2,  -44,
     -65,   70,   54,      -46,   60,   41,      -27,   49,   27,       -8,   38,   14,
      11,   27,    0,       30,   17,  -13,       49,    6,  -26,       68,   -4,  -40,
     -63,   69,   58,      -44,   58,   45,      -25,   47,   31,       -6,   37,   18,
      14,   26,    4,       32,   15,   -9,       51,    5,  -22,       71,   -5,  -36,
     -60,   68,   62,      -42,   57,   49,      -22,   46,   35,       -3,   36,   22,
      16,   25,    8,       35,   14,   -5,       54,    3,  -18,       73,   -7,  -32,
     -58,   66,   67,      -39,   56,   53,      -19,   45,   39,       -1,   34,   26,
      19,   23,   12,       37,   12,    0,       56,    2,  -14,       76,   -8,  -27,
     -55,   65,   71,      -36,   54,   57,      -17,   43,   43,        2,   33,   30,
      21,   22,   16,       40,   11,    3,       59,    1,  -10,       78,   -9,  -23,
     -53,   63,   75,      -34,   53,   61,      -15,   42,   47,        4,   31,   34,
      23,   20,   20,       42,   10,    7,       61,    0,   -6,       80,  -11,  -19,
     -50,   62,   79,      -32,   52,   65,      -12,   41,   51,        6,   30,   38,
      26,   19,   24,       45,    8,   11,       63,   -1,   -2,       83,  -12,  -15,
     -48,   61,   83,      -29,   50,   69,      -10,   39,   55,        9,   29,   42,
      28,   18,   28,       47,    7,   15,       66,   -3,    1,       85,  -13,  -11,
     -45,   59,   87,      -27,   49,   74,       -7,   38,   60,       12,   27,   47,
      31,   16,   33,       50,    6,   19,       69,   -4,    6,       88,  -15,   -7,
     -43,   58,   91,      -24,   47,   78,       -5,   36,   64,       14,   26,   51,
      33,   15,   37,       52,    4,   23,       71,   -5,   10,       90,  -16,   -3,
     -41,   57,   95,      -22,   46,   82,       -2,   35,   68,       16,   24,   55,
      36,   13,   41,       55,    3,   27,       73,   -7,   14,       93,  -18,    0,
     -38,   55,   99,      -19,   45,   86,        0,   34,   72,       19,   23,   59,
      38,   12,   45,       57,    2,   31,       76,   -8,   18,       95,  -19,    4,
     -35,   54,  104,      -17,   43,   90,        3,   32,   76,       21,   22,   63,
      41,   11,   49,       60,    0,   36,       78,  -10,   22,       98,  -21,    9,
     -33,   52,  108,      -14,   42,   94,        5,   31,   80,       24,   20,   67,
      43,    9,   53,       62,    0,   40,       81,  -11,   26,      100,  -22,   13,
     -31,   51,  112,      -12,   40,   98,        7,   29,   84,       26,   19,   71,
      46,    8,   57,       64,   -2,   44,       83,  -12,   30,      103,  -23,   17,
    -106,   98,  -16,      -87,   87,  -29,      -68,   76,  -43,      -49,   66,  -56,
     -30,   55,  -70,      -11,   44,  -83,        8,   34,  -97,       27,   23, -111,
    -104,   97,  -12,      -85,   86,  -25,      -65,   75,  -39,      -47,   65,  -52,
     -27,   54,  -66,       -9,   43,  -79,       10,   32,  -93,       30,   21, -107,
    -101,   95,   -8,      -82,   85,  -21,      -63,   74,  -35,      -44,   63,  -48,
     -25,   52,  -62,       -6,   42,  -75,       13,   31,  -89,       32,   20, -103,
     -99,   94,   -3,      -80,   83,  -16,      -60,   72,  -30,      -42,   62,  -44,
     -22,   51,  -57,       -3,   40,  -71,       15,   30,  -84,       35,   19,  -98,
     -96,   92,    0,      -77,   82,  -12,      -58,   71,  -26,      -39,   60,  -40,
     -20,   49,  -53,       -1,   39,  -67,       18,   28,  -80,       37,   17,  -94,
     -94,   91,    4,      -75,   80,   -8,      -56,   70,  -22,      -37,   59,  -36,
     -17,   48,  -49,        1,   37,  -63,       20,   27,  -76,       39,   16,  -90,
     -91,   90,    8,      -73,   79,   -4,      -53,   68,  -18,      -34,   58,  -32,
     -15,   47,  -45,        4,   36,  -59,       22,   25,  -72,       42,   15,  -86,
     -89,   88,   12,      -70,   78,    0,      -51,   67,  -14,      -32,   56,  -27,
     -12,   45,  -41,        6,   35,  -54,       25,   24,  -68,       45,   13,  -82,
     -86,   87,   16,      -68,   76,    3,      -48,   65,  -10,      -29,   55,  -23,
     -10,   44,  -37,        9,   33,  -50,       28,   23,  -64,       47,   12,  -78,
     -84,   86,   20,      -65,   75,    7,      -46,   64,   -6,      -27,   53,  -19,
      -8,   42,  -33,       11,   32,  -46,       30,   21,  -60,       49,   10,  -74,
     -82,   84,   24,      -63,   74,   11,      -43,   63,   -2,      -25,   52,  -15,
      -5,   41,  -29,       14,   30,  -42,       32,   20,  -56,       52,    9,  -70,
     -79,   83,   28,      -60,   72,   15,      -41,   61,    1,      -22,   51,  -11,
      -3,   40,  -25,       16,   29,  -38,       35,   19,  -52,       54,    8,  -66,
     -76,   81,   33,      -58,   71,   20,      -38,   60,    6,      -20,   49,   -7,
       0,   38,  -20,       19,   28,  -34,       37,   17,  -47,       57,    6,  -61,
     -74,   80,   37,      -55,   69,   24,      -36,   58,   10,      -17,   48,   -3,
       2,   37,  -16,       21,   26,  -30,       40,   16,  -43,       59,    5,  -57,
     -72,   79,   41,      -53,   68,   28,      -34,   57,   14,      -15,   46,    0,
       5,   36,  -12,       23,   25,  -26,       42,   14,  -39,       62,    3,  -53,
     -69,   77,   45,      -50,   67,   32,      -31,   56,   18,      -12,   45,    4,
       7,   34,   -8,       26,   24,  -22,       45,   13,  -35,       64,    2,  -49,
     -67,   76,   49,      -48,   65,   36,      -28,   54,   22,      -10,   44,    9,
      10,   33,   -4,       29,   22,  -17,       47,   11,  -31,       67,    1,  -45,
     -64,   74,   53,      -45,   64,   40,      -26,   53,   26,       -7,   42,   13,
      12,   31,    0,       31,   21,  -13,       50,   10,  -27,       69,    0,  -41,
     -62,   73,   57,      -43,   62,   44,      -24,   51,   30,       -5,   41,   17,
      15,   30,    3,       33,   19,   -9,       52,    9,  -23,       71,   -1,  -37,
     -59,   72,   61,      -41,   61,   48,      -21,   50,   34,       -2,   40,   21,
      17,   29,    7,       36,   18,   -5,       54,    7,  -19,       74,   -3,  -33,
     -57,   70,   66,      -38,   60,   53,      -19,   49,   39,        0,   38,   25,
      20,   27,   12,       38,   16,   -1,       57,    6,  -14,       77,   -4,  -28,
     -54,   69,   70,      -36,   58,   57,      -16,   47,   43,        3,   37,   29,
      22,   26,   16,       41,   15,    2,       60,    5,  -10,       79,   -5,  -24,
     -52,   67,   74,      -33,   57,   61,      -14,   46,   47,        5,   35,   33,
      24,   24,   20,       43,   14,    6,       62,    3,   -6,       81,   -7,  -20,
     -50,   66,   78,      -31,   56,   65,      -11,   45,   51,        7,   34,   37,
      27,   23,   24,       46,   12,   10,       64,    2,   -2,       84,   -8,  -16,
     -47,   65,   82,      -28,   54,   69,       -9,   43,   55,       10,   33,   41,
      29,   22,   28,       48,   11,   14,       67,    0,    1,       86,   -9,  -12,
     -44,   63,   86,      -26,   53,   73,       -6,   42,   59,       12,   31,   46,
      32,   20,   32,       51,   10,   19,       69,    0,    5,       89,  -11,   -8,
     -42,   62,   90,      -23,   51,   77,       -4,   40,   63,       15,   30,   50,
      34,   19,   36,       53,    8,   23,       72,   -1,    9,       91,  -12,   -4,
     -40,   61,   94,      -21,   50,   81,       -2,   39,   67,       17,   28,   54,
      37,   17,   40,       55,    7,   27,       74,   -3,   13,       94,  -14,    0,
     -37,   59,   98,      -18,   49,   85,        1,   38,   71,       20,   27,   58,
      39,   16,   44,       58,    6,   31,       77,   -4,   17,       96,  -15,    3,
     -35,   58,  103,      -16,   47,   90,        4,   36,   76,       22,   26,   62,
      42,   15,   49,       61,    4,   35,       79,   -6,   22,       99,  -17,    8,
     -32,   56,  107,      -13,   46,   94,        6,   35,   80,       25,   24,   66,
      44,   13,   53,       63,    3,   39,       82,   -7,   26,      101,  -18,   12,
     -30,   55,  111,      -11,   44,   98,        8,   33,   84,       27,   23,   70,
      47,   12,   57,       65,    1,   43,       84,   -8,   30,      103,  -19,   16,
    -105,  103,  -16,      -86,   92,  -30,      -67,   81,  -43,      -48,   70,  -57,
     -29,   59,  -71,      -10,   49,  -84,        9,   38,  -97,       28,   27, -111,
    -103,  101,  -12,      -84,   91,  -26,      -64,   80,  -39,      -46,   69,  -53,
     -26,   58,  -67,       -8,   47,  -80,       11,   37,  -93,       31,   26, -107,
    -100,  100,   -8,      -81,   89,  -22,      -62,   78,  -35,      -43,   68,  -49,
     -24,   57,  -63,       -5,   46,  -76,       14,   36,  -89,       33,   25, -103,
     -98,   98,   -4,      -79,   88,  -17,      -59,   77,  -31,      -41,   66,  -44,
     -21,   55,  -58,       -2,   45,  -72,       16,   34,  -85,       36,   23,  -99,
     -95,   97,    0,      -76,   86,  -13,      -57,   75,  -27,      -38,   65,  -40,
     -19,   54,  -54,        0,   43,  -68,       19,   33,  -81,       38,   22,  -95,
     -93,   96,    3,      -74,   85,   -9,      -55,   74,  -23,      -36,   63,  -36,
     -16,   53,  -50,        2,   42,  -64,       21,   31,  -77,       40,   20,  -91,
     -90,   94,    7,      -72,   84,   -5,      -52,   73,  -19,      -33,   62,  -32,
     -14,   51,  -46,        5,   41,  -60,       24,   30,  -73,       43,   19,  -87,
     -88,   93,   12,      -69,   82,   -1,      -50,   71,  -14,      -31,   61,  -28,
     -11,   50,  -42,        7,   39,  -55,       26,   28,  -68,       46,   18,  -82,
     -85,   91,   16,      -66,   81,    2,      -47,   70,  -10,      -28,   59,  -24,
      -9,   48,  -38,       10,   38,  -51,       29,   27,  -64,       48,   16,  -78,
     -83,   90,   20,      -64,   79,    6,      -45,   68,   -6,      -26,   58,  -20,
      -7,   47,  -34,       12,   36,  -47,       31,   26,  -60,       50,   15,  -74,
     -80,   89,   24,      -62,   78,   10,      -42,   67,   -2,      -24,   57,  -16,
      -4,   46,  -30,       15,   35,  -43,       33,   24,  -56,       53,   13,  -70,
     -78,   87,   28,      -59,   77,   14,      -40,   66,    1,      -21,   55,  -12,
      -2,   44,  -26,       17,   34,  -39,       36,   23,  -52,       55,   12,  -66,
     -75,   86,   32,      -57,   75,   19,      -37,   64,    5,      -18,   54,   -7,
       1,   43,  -21,       20,   32,  -35,       38,   22,  -48,       58,   11,  -62,
     -73,   84,   36,      -54,   74,   23,      -35,   63,    9,      -16,   52,   -3,
       3,   41,  -17,       22,   31,  -31,       41,   20,  -44,       60,    9,  -58,
     -71,   83,   40,      -52,   72,   27,      -32,   62,   13,      -14,   51,    0,
       6,   40,  -13,       24,   29,  -27,       43,   19,  -40,       63,    8,  -54,
     -68,   82,   44,      -49,   71,   31,      -30,   60,   17,      -11,   50,    4,
       8,   39,   -9,       27,   28,  -23,       46,   17,  -36,       65,    7,  -50,
     -66,   80,   49,      -47,   70,   35,      -27,   59,   22,       -9,   48,    8,
      11,   37,   -5,       30,   27,  -18,       48,   16,  -31,       68,    5,  -45,
     -63,   79,   53,      -44,   68,   39,      -25,   57,   26,       -6,   47,   12,
      13,   36,   -1,       32,   25,  -14,       51,   15,  -27,       70,    4,  -41,
     -61,   78,   57,      -42,   67,   43,      -23,   56,   30,       -4,   45,   16,
      16,   34,    2,       34,   24,  -10,       53,   13,  -23,       72,    2,  -37,
     -58,   76,   61,      -40,   66,   47,      -20,   55,   34,       -1,   44,   20,
      18,   33,    6,       37,   23,   -6,       56,   12,  -19,       75,    1,  -33,
     -56,   75,   65,      -37,   64,   52,      -18,   53,   38,        1,   43,   25,
      21,   32,   11,       39,   21,   -2,       58,   10,  -15,       78,    0,  -29,
     -53,   73,   69,      -35,   63,   56,      -15,   52,   42,        4,   41,   29,
      23,   30,   15,       42,   20,    1,       61,    9,  -11,       80,   -1,  -25,
     -51,   72,   73,      -32,   61,   60,      -13,   50,   46,        6,   40,   33,
      25,   29,   19,       44,   18,    5,       63,    8,   -7,       82,   -2,  -21,
     -49,   71,   77,      -30,   60,   64,      -10,   49,   50,        8,   38,   37,
      28,   28,   23,       47,   17,    9,       65,    6,   -3,       85,   -4,  -17,
     -46,   69,   81,      -27,   59,   68,       -8,   48,   54,       11,   37,   41,
      30,   26,   27,       49,   16,   13,       68,    5,    0,       87,   -5,  -13,
     -43,   68,   86,      -25,   57,   72,       -5,   46,   59,       14,   36,   45,
      33,   25,   31,       52,   14,   18,       70,    3,    5,       90,   -6,   -8,
     -41,   66,   90,      -22,   56,   76,       -3,   45,   63,       16,   34,   49,
      35,   23,   35,       54,   13,   22,       73,    2,    9,       92,   -8,   -4,
     -39,   65,   94,      -20,   54,   80,        0,   44,   67,       18,   33,   53,
      38,   22,   39,       56,   11,   26,       75,    1,   13,       95,   -9,    0,
     -36,   64,   98,      -17,   53,   84,        2,   42,   71,       21,   32,   57,
      40,   21,   43,       59,   10,   30,       78,    0,   17,       97,  -11,    3,
     -34,   62,  102,      -15,   52,   89,        5,   41,   75,       23,   30,   62,
      43,   19,   48,       62,    9,   34,       80,   -1,   21,      100,  -12,    7,
     -31,   61,  106,      -12,   50,   93,        7,   39,   79,       26,   29,   66,
      45,   18,   52,       64,    7,   38,       83,   -2,   25,      102,  -13,   11,
     -29,   59,  110,      -10,   49,   97,        9,   38,   83,       28,   27,   70,
      48,   16,   56,       66,    6,   42,       85,   -4,   29,      104,  -15,   15,
    -104,  107,  -17,      -85,   96,  -30,      -66,   85,  -44,      -47,   74,  -58,
     -28,   63,  -71,       -9,   53,  -85,       10,   42,  -98,       29,   31, -112,
    -102,  105,  -13,      -83,   95,  -26,      -64,   84,  -40,      -45,   73,  -54,
     -25,   62,  -67,       -7,   51,  -81,       12,   41,  -94,       32,   30, -108,
     -99,  104,   -9,      -81,   93,  -22,      -61,   82,  -36,      -42,   72,  -50,
     -23,   61,  -63,       -4,   50,  -77,       15,   40,  -90,       34,   29, -104,
     -97,  102,   -4,      -78,   92,  -18,      -58,   81,  -32,      -40,   70,  -45,
     -20,   59,  -59,       -2,   49,  -72,       17,   38,  -86,       37,   27,  -99,
     -94,  101,    0,      -75,   90,  -14,      -56,   79,  -28,      -37,   69,  -41,
     -18,   58,  -55,        1,   47,  -68,       20,   37,  -82,       39,   26,  -95,
     -92,  100,    3,      -73,   89,  -10,      -54,   78,  -24,      -35,   67,  -37,
     -16,   57,  -51,        3,   46,  -64,       22,   35,  -78,       41,   24,  -91,
     -89,   98,    7,      -71,   88,   -6,      -51,   77,  -20,      -33,   66,  -33,
     -13,   55,  -47,        6,   45,  -60,       24,   34,  -74,       44,   23,  -87,
     -87,   97,   11,      -68,   86,   -1,      -49,   75,  -15,      -30,   65,  -29,
     -10,   54,  -42,        8,   43,  -56,       27,   32,  -69,       46,   22,  -83,
     -84,   95,   15,      -66,   85,    2,      -46,   74,  -11,      -27,   63,  -25,
      -8,   52,  -38,       11,   42,  -52,       30,   31,  -65,       49,   20,  -79,
     -82,   94,   19,      -63,   83,    6,      -44,   72,   -7,      -25,   62,  -21,
      -6,   51,  -34,       13,   40,  -48,       32,   30,  -61,       51,   19,  -75,
     -80,   93,   23,      -61,   82,   10,      -41,   71,   -3,      -23,   61,  -17,
      -3,   50,  -30,       16,   39,  -44,       34,   28,  -57,       54,   17,  -71,
     -77,   91,   27,      -58,   81,   14,      -39,   70,    0,      -20,   59,  -13,
      -1,   48,  -26,       18,   38,  -40,       37,   27,  -53,       56,   16,  -67,
     -75,   90,   32,      -56,   79,   18,      -36,   68,    4,      -18,   58,   -8,
       2,   47,  -22,       21,   36,  -35,       39,   26,  -49,       59,   15,  -62,
     -72,   88,   36,      -53,   78,   22,      -34,   67,    8,      -15,   56,   -4,
       4,   45,  -18,       23,   35,  -31,       42,   24,  -45,       61,   13,  -58,
     -70,   87,   40,      -51,   76,   26,      -32,   66,   12,      -13,   55,    0,
       7,   44,  -14,       25,   33,  -27,       44,   23,  -41,       64,   12,  -54,
     -67,   86,   44,      -49,   75,   30,      -29,   64,   16,      -10,   54,    3,
       9,   43,  -10,       28,   32,  -23,       47,   21,  -37,       66,   11,  -50,
     -65,   84,   48,      -46,   74,   35,      -26,   63,   21,       -8,   52,    7,
      12,   41,   -5,       30,   31,  -19,       49,   20,  -32,       69,    9,  -46,
     -62,   83,   52,      -43,   72,   39,      -24,   61,   25,       -5,   51,   11,
      14,   40,   -1,       33,   29,  -15,       52,   19,  -28,       71,    8,  -42,
     -60,   82,   56,      -41,   71,   43,      -22,   60,   29,       -3,   49,   15,
      16,   38,    2,       35,   28,  -11,       54,   17,  -24,       73,    6,  -38,
     -57,   80,   60,      -39,   70,   47,      -19,   59,   33,       -1,   48,   19,
      19,   37,    6,       38,   27,   -7,       56,   16,  -20,       76,    5,  -34,
     -55,   79,   65,      -36,   68,   51,      -17,   57,   37,        2,   47,   24,
      22,   36,   10,       40,   25,   -2,       59,   14,  -16,       78,    3,  -29,
     -52,   77,   69,      -34,   67,   55,      -14,   56,   41,        5,   45,   28,
      24,   34,   14,       43,   24,    1,       62,   13,  -12,       81,    2,  -25,
     -50,   76,   73,      -31,   65,   59,      -12,   54,   45,        7,   44,   32,
      26,   33,   18,       45,   22,    5,       64,   12,   -8,       83,    1,  -21,
     -48,   75,   77,      -29,   64,   63,       -9,   53,   49,        9,   42,   36,
      29,   32,   22,       48,   21,    9,       66,   10,   -4,       86,    0,  -17,
     -45,   73,   81,      -26,   63,   67,       -7,   52,   53,       12,   41,   40,
      31,   30,   26,       50,   20,   13,       69,    9,    0,       88,   -1,  -13,
     -43,   72,   85,      -24,   61,   72,       -4,   50,   58,       14,   40,   44,
      34,   29,   31,       53,   18,   17,       71,    7,    4,       91,   -2,   -9,
     -40,   70,   89,      -21,   60,   76,       -2,   49,   62,       17,   38,   48,
      36,   27,   35,       55,   17,   21,       74,    6,    8,       93,   -4,   -5,
     -38,   69,   93,      -19,   58,   80,        0,   48,   66,       19,   37,   52,
      39,   26,   39,       57,   15,   25,       76,    5,   12,       96,   -5,   -1,
     -35,   68,   97,      -17,   57,   84,        3,   46,   70,       22,   36,   56,
      41,   25,   43,       60,   14,   29,       79,    3,   16,       98,   -7,    2,
     -33,   66,  102,      -14,   56,   88,        6,   45,   74,       24,   34,   61,
      44,   23,   47,       62,   13,   34,       81,    2,   20,      101,   -8,    7,
     -30,   65,  106,      -11,   54,   92,        8,   43,   78,       27,   33,   65,
      46,   22,   51,       65,   11,   38,       84,    1,   24,      103,   -9,   11,
     -28,   63,  110,       -9,   53,   96,       10,   42,   82,       29,   31,   69,
      48,   20,   55,       67,   10,   42,       86,    0,   28,      105,  -11,   15,
    -103,  111,  -18,      -84,  100,  -31,      -65,   89,  -45,      -46,   78,  -58,
     -27,   67,  -72,       -8,   57,  -85,       11,   46,  -99,       30,   35, -113,
    -101,  109,  -14,      -82,   99,  -27,      -63,   88,  -41,      -44,   77,  -54,
     -24,   66,  -68,       -6,   55,  -81,       13,   45,  -95,       32,   34, -109,
     -98,  108,  -10,      -80,   97,  -23,      -60,   86,  -37,      -41,   76,  -50,
     -22,   65,  -64,       -3,   54,  -77,       15,   44,  -91,       35,   33, -105,
     -96,  106,   -5,      -77,   96,  -18,      -58,   85,  -32,      -39,   74,  -46,
     -19,   63,  -59,       -1,   53,  -73,       18,   42,  -86,       38,   31, -100,
     -93,  105,   -1,      -75,   94,  -14,      -55,   83,  -28,      -36,   73,  -42,
     -17,   62,  -55,        2,   51,  -69,       21,   41,  -82,       40,   30,  -96,
     -91,  104,    2,      -72,   93,  -10,      -53,   82,  -24,      -34,   71,  -38,
     -15,   61,  -51,        4,   50,  -65,       23,   39,  -78,       42,   28,  -92,
     -89,  102,    6,      -70,   92,   -6,      -50,   81,  -20,      -32,   70,  -34,
     -12,   59,  -47,        7,   49,  -61,       25,   38,  -74,       45,   27,  -88,
     -86,  101,   10,      -67,   90,   -2,      -48,   79,  -16,      -29,   69,  -29,
     -10,   58,  -43,        9,   47,  -56,       28,   36,  -70,       47,   26,  -84,
     -83,   99,   14,      -65,   89,    1,      -45,   78,  -12,      -27,   67,  -25,
      -7,   56,  -39,       12,   46,  -52,       30,   35,  -66,       50,   24,  -80,
     -81,   98,   18,      -62,   87,    5,      -43,   76,   -8,      -24,   66,  -21,
      -5,   55,  -35,       14,   44,  -48,       33,   34,  -62,       52,   23,  -76,
     -79,   97,   22,      -60,   86,    9,      -41,   75,   -4,      -22,   65,  -17,
      -2,   54,  -31,       16,   43,  -44,       35,   32,  -58,       55,   21,  -72,
     -76,   95,   26,      -57,   85,   13,      -38,   74,    0,      -19,   63,  -13,
       0,   52,  -27,       19,   42,  -40,       38,   31,  -54,       57,   20,  -68,
     -74,   94,   31,      -55,   83,   18,      -35,   72,    4,      -17,   62,   -9,
       3,   51,  -22,       22,   40,  -36,       40,   30,  -49,       60,   19,  -63,
     -71,   92,   35,      -52,   82,   22,      -33,   71,    8,      -14,   60,   -5,
       5,   49,  -18,       24,   39,  -32,       43,   28,  -45,       62,   17,  -59,
     -69,   91,   39,      -50,   80,   26,      -31,   70,   12,      -12,   59,   -1,
       8,   48,  -14,       26,   37,  -28,       45,   27,  -41,       64,   16,  -55,
     -66,   90,   43,      -48,   79,   30,      -28,   68,   16,       -9,   58,    2,
      10,   47,  -10,       29,   36,  -24,       47,   25,  -37,       67,   15,  -51,
     -64,   88,   47,      -45,   78,   34,      -26,   67,   20,       -7,   56,    7,
      13,   45,   -6,       31,   35,  -19,       50,   24,  -33,       70,   13,  -47,
     -61,   87,   51,      -43,   76,   38,      -23,   65,   24,       -4,   55,   11,
      15,   44,   -2,       34,   33,  -15,       53,   23,  -29,       72,   12,  -43,
     -59,   86,   55,      -40,   75,   42,      -21,   64,   28,       -2,   53,   15,
      17,   42,    1,       36,   32,  -11,       55,   21,  -25,       74,   10,  -39,
     -57,   84,   59,      -38,   74,   46,      -18,   63,   32,        0,   52,   19,
      20,   41,    5,       39,   31,   -7,       57,   20,  -21,       77,    9,  -35,
     -54,   83,   64,      -35,   72,   51,      -16,   61,   37,        3,   51,   23,
      22,   40,   10,       41,   29,   -3,       60,   18,  -16,       79,    7,  -30,
     -51,   81,   68,      -33,   71,   55,      -13,   60,   41,        5,   49,   27,
      25,   38,   14,       44,   28,    0,       62,   17,  -12,       82,    6,  -26,
     -49,   80,   72,      -30,   69,   59,      -11,   58,   45,        8,   48,   31,
      27,   37,   18,       46,   26,    4,       65,   16,   -8,       84,    5,  -22,
     -47,   79,   76,      -28,   68,   63,       -9,   57,   49,       10,   46,   35,
      30,   36,   22,       48,   25,    8,       67,   14,   -4,       87,    3,  -18,
     -44,   77,   80,      -26,   67,   67,       -6,   56,   53,       13,   45,   39,
      32,   34,   26,       51,   24,   12,       70,   13,    0,       89,    2,  -14,
     -42,   76,   84,      -23,   65,   71,       -3,   54,   57,       15,   44,   44,
      35,   33,   30,       53,   22,   17,       72,   11,    3,       92,    1,  -10,
     -39,   74,   88,      -20,   64,   75,       -1,   53,   61,       18,   42,   48,
      37,   31,   34,       56,   21,   21,       75,   10,    7,       94,    0,   -6,
     -37,   73,   92,      -18,   62,   79,        1,   52,   65,       20,   41,   52,
      39,   30,   38,       58,   19,   25,       77,    9,   11,       96,   -1,   -2,
     -34,   72,   96,      -16,   61,   83,        4,   50,   69,       23,   40,   56,
      42,   29,   42,       61,   18,   29,       79,    7,   15,       99,   -3,    1,
     -32,   70,  101,      -13,   60,   88,        6,   49,   74,       25,   38,   60,
      45,   27,   47,       63,   17,   33,       82,    6,   20,      102,   -4,    6,
     -29,   69,  105,      -11,   58,   92,        9,   47,   78,       28,   37,   64,
      47,   26,   51,       66,   15,   37,       85,    5,   24,      104,   -5,   10,
     -27,   67,  109,       -8,   57,   96,       11,   46,   82,       30,   35,   68,
      49,   24,   55,       68,   14,   41,       87,    3,   28,      106,   -7,   14,
    -102,  115,  -18,      -83,  104,  -32,      -64,   93,  -45,      -45,   82,  -59,
     -26,   71,  -73,       -7,   61,  -86,       12,   50,  -99,       31,   39, -113,
    -100,  113,  -14,      -81,  103,  -28,      -62,   92,  -41,      -43,   81,  -55,
     -24,   70,  -69,       -5,   59,  -82,       14,   49,  -95,       33,   38, -109,
     -97,  112,  -10,      -79,  101,  -24,      -59,   90,  -37,      -41,   80,  -51,
     -21,   69,  -65,       -2,   58,  -78,       16,   48,  -91,       36,   37, -105,
     -95,  110,   -6,      -76,  100,  -19,      -57,   89,  -33,      -38,   78,  -46,
     -18,   67,  -60,        0,   57,  -74,       19,   46,  -87,       38,   35, -101,
     -92,  109,   -2,      -74,   98,  -15,      -54,   87,  -29,      -35,   77,  -42,
     -16,   66,  -56,        3,   55,  -70,       21,   45,  -83,       41,   34,  -97,
     -90,  108,    1,      -71,   97,  -11,      -52,   86,  -25,      -33,   75,  -38,
     -14,   65,  -52,        5,   54,  -66,       24,   43,  -79,       43,   32,  -93,
     -88,  106,    5,      -69,   96,   -7,      -49,   85,  -21,      -31,   74,  -34,
     -11,   63,  -48,        7,   53,  -62,       26,   42,  -75,       46,   31,  -89,
     -85,  105,   10,      -66,   94,   -3,      -47,   83,  -16,      -28,   73,  -30,
      -9,   62,  -44,       10,   51,  -57,       29,   40,  -70,       48,   30,  -84,
     -83,  103,   14,      -64,   93,    0,      -44,   82,  -12,      -26,   71,  -26,
      -6,   60,  -40,       13,   50,  -53,       31,   39,  -66,       51,   28,  -80,
     -80,  102,   18,      -61,   91,    4,      -42,   80,   -8,      -23,   70,  -22,
      -4,   59,  -36,       15,   48,  -49,       34,   38,  -62,       53,   27,  -76,
     -78,  101,   22,      -59,   90,    8,      -40,   79,   -4,      -21,   69,  -18,
      -1,   58,  -32,       17,   47,  -45,       36,   36,  -58,       55,   25,  -72,
     -75,   99,   26,      -57,   89,   12,      -37,   78,    0,      -18,   67,  -14,
       1,   56,  -28,       20,   46,  -41,       39,   35,  -54,       58,   24,  -68,
     -73,   98,   30,      -54,   87,   17,      -35,   76,    3,      -16,   66,   -9,
       4,   55,  -23,       22,   44,  -37,       41,   34,  -50,       61,   23,  -64,
     -70,   96,   34,      -52,   86,   21,      -32,   75,    7,      -13,   64,   -5,
       6,   53,  -19,       25,   43,  -33,       44,   32,  -46,       63,   21,  -60,
     -68,   95,   38,      -49,   84,   25,      -30,   74,   11,      -11,   63,   -1,
       8,   52,  -15,       27,   41,  -29,       46,   31,  -42,       65,   20,  -56,
     -66,   94,   42,      -47,   83,   29,      -27,   72,   15,       -9,   62,    2,
      11,   51,  -11,       30,   40,  -25,       48,   29,  -38,       68,   19,  -52,
     -63,   92,   47,      -44,   82,   33,      -25,   71,   20,       -6,   60,    6,
      13,   49,   -7,       32,   39,  -20,       51,   28,  -33,       70,   17,  -47,
     -60,   91,   51,      -42,   80,   37,      -22,   69,   24,       -3,   59,   10,
      16,   48,   -3,       35,   37,  -16,       53,   27,  -29,       73,   16,  -43,
     -58,   90,   55,      -39,   79,   41,      -20,   68,   28,       -1,   57,   14,
      18,   46,    0,       37,   36,  -12,       56,   25,  -25,       75,   14,  -39,
     -56,   88,   59,      -37,   78,   45,      -17,   67,   32,        1,   56,   18,
      21,   45,    4,       39,   35,   -8,       58,   24,  -21,       78,   13,  -35,
     -53,   87,   63,      -34,   76,   50,      -15,   65,   36,        4,   55,   23,
      23,   44,    9,       42,   33,   -4,       61,   22,  -17,       80,   11,  -31,
     -51,   85,   67,      -32,   75,   54,      -12,   64,   40,        6,   53,   27,
      26,   42,   13,       45,   32,    0,       63,   21,  -13,       83,   10,  -27,
     -48,   84,   71,      -29,   73,   58,      -10,   62,   44,        9,   52,   31,
      28,   41,   17,       47,   30,    3,       66,   20,   -9,       85,    9,  -23,
     -46,   83,   75,      -27,   72,   62,       -8,   61,   48,       11,   50,   35,
      31,   40,   21,       49,   29,    7,       68,   18,   -5,       87,    7,  -19,
     -43,   81,   79,      -25,   71,   66,       -5,   60,   52,       14,   49,   39,
      33,   38,   25,       52,   28,   11,       71,   17,   -1,       90,    6,  -15,
     -41,   80,   84,      -22,   69,   70,       -3,   58,   57,       16,   48,   43,
      36,   37,   29,       54,   26,   16,       73,   15,    3,       93,    5,  -10,
     -38,   78,   88,      -20,   68,   74,        0,   57,   61,       19,   46,   47,
      38,   35,   33,       57,   25,   20,       76,   14,    7,       95,    3,   -6,
     -36,   77,   92,      -17,   66,   78,        2,   56,   65,       21,   45,   51,
      40,   34,   37,       59,   23,   24,       78,   13,   11,       97,    2,   -2,
     -34,   76,   96,      -15,   65,   82,        5,   54,   69,       23,   44,   55,
      43,   33,   41,       62,   22,   28,       80,   11,   15,      100,    0,    1,
     -31,   74,  100,      -12,   64,   87,        7,   53,   73,       26,   42,   60,
      45,   31,   46,       64,   21,   32,       83,   10,   19,      102,    0,    5,
     -28,   73,  104,      -10,   62,   91,       10,   51,   77,       29,   41,   64,
      48,   30,   50,       67,   19,   36,       85,    9,   23,      105,   -1,    9,
     -26,   71,  108,       -7,   61,   95,       12,   50,   81,       31,   39,   68,
      50,   28,   54,       69,   18,   40,       88,    7,   27,      107,   -3,   13,
    -101,  119,  -19,      -82,  108,  -32,      -63,   97,  -46,      -44,   87,  -60,
     -25,   76,  -73,       -6,   65,  -87,       13,   55, -100,       32,   44, -114,
     -99,  118,  -15,      -80,  107,  -28,      -61,   96,  -42,      -42,   86,  -56,
     -23,   75,  -69,       -4,   64,  -83,       15,   53,  -96,       34,   42, -110,
     -96,  116,  -11,      -78,  106,  -24,      -58,   95,  -38,      -40,   84,  -52,
     -20,   73,  -65,       -1,   63,  -79,       17,   52,  -92,       37,   41, -106,
     -94,  115,   -6,      -75,  104,  -20,      -56,   93,  -34,      -37,   83,  -47,
     -17,   72,  -61,        1,   61,  -74,       20,   51,  -88,       39,   40, -101,
     -91,  113,   -2,      -73,  103,  -16,      -53,   92,  -30,      -34,   81,  -43,
     -15,   70,  -57,        4,   60,  -70,       22,   49,  -84,       42,   38,  -97,
     -89,  112,    1,      -70,  101,  -12,      -51,   91,  -26,      -32,   80,  -39,
     -13,   69,  -53,        6,   58,  -66,       25,   48,  -80,       44,   37,  -93,
     -87,  111,    5,      -68,  100,   -8,      -48,   89,  -22,      -30,   79,  -35,
     -10,   68,  -49,        8,   57,  -62,       27,   46,  -76,       47,   36,  -89,
     -84,  109,    9,      -65,   99,   -3,      -46,   88,  -17,      -27,   77,  -31,
      -8,   66,  -44,       11,   56,  -58,       30,   45,  -71,       49,   34,  -85,
     -82,  108,   13,      -63,   97,    0,      -43,   86,  -13,      -25,   76,  -27,
      -5,   65,  -40,       14,   54,  -54,       32,   44,  -67,       52,   33,  -81,
     -79,  107,   17,      -60,   96,    4,      -41,   85,   -9,      -22,   74,  -23,
      -3,   63,  -36,       16,   53,  -50,       35,   42,  -63,       54,   31,  -77,
     -77,  105,   21,      -58,   95,    8,      -39,   84,   -5,      -20,   73,  -19,
       0,   62,  -32,       18,   51,  -46,       37,   41,  -59,       57,   30,  -73,
     -74,  104,   25,      -56,   93,   12,      -36,   82,   -1,      -17,   72,  -15,
       2,   61,  -28,       21,   50,  -42,       40,   40,  -55,       59,   29,  -69,
     -72,  102,   30,      -53,   92,   16,      -33,   81,    2,      -15,   70,  -10,
       5,   59,  -24,       23,   49,  -37,       42,   38,  -51,       62,   27,  -64,
     -69,  101,   34,      -50,   90,   20,      -31,   79,    6,      -12,   69,   -6,
       7,   58,  -20,       26,   47,  -33,       45,   37,  -47,       64,   26,  -60,
     -67,  100,   38,      -48,   89,   24,      -29,   78,   10,      -10,   67,   -2,
       9,   57,  -16,       28,   46,  -29,       47,   35,  -43,       66,   24,  -56,
     -64,   98,   42,      -46,   88,   28,      -26,   77,   14,       -8,   66,    1,
      12,   55,  -12,       31,   45,  -25,       49,   34,  -39,       69,   23,  -52,
     -62,   97,   46,      -43,   86,   33,      -24,   75,   19,       -5,   65,    5,
      15,   54,   -7,       33,   43,  -21,       52,   32,  -34,       71,   22,  -48,
     -59,   95,   50,      -41,   85,   37,      -21,   74,   23,       -2,   63,    9,
      17,   52,   -3,       36,   42,  -17,       54,   31,  -30,       74,   20,  -44,
     -57,   94,   54,      -38,   83,   41,      -19,   72,   27,        0,   62,   13,
      19,   51,    0,       38,   40,  -13,       57,   30,  -26,       76,   19,  -40,
     -55,   93,   58,      -36,   82,   45,      -16,   71,   31,        2,   61,   17,
      22,   50,    4,       40,   39,   -9,       59,   28,  -22,       79,   17,  -36,
     -52,   91,   63,      -33,   81,   49,      -14,   70,   35,        5,   59,   22,
      24,   48,    8,       43,   37,   -4,       62,   27,  -18,       81,   16,  -31,
     -50,   90,   67,      -31,   79,   53,      -11,   68,   39,        7,   58,   26,
      27,   47,   12,       46,   36,    0,       64,   26,  -14,       84,   15,  -27,
     -47,   88,   71,      -28,   78,   57,       -9,   67,   43,       10,   56,   30,
      29,   45,   16,       48,   35,    3,       67,   24,  -10,       86,   13,  -23,
     -45,   87,   75,      -26,   77,   61,       -7,   66,   47,       12,   55,   34,
      32,   44,   20,       50,   33,    7,       69,   23,   -6,       89,   12,  -19,
     -42,   86,   79,      -24,   75,   65,       -4,   64,   51,       15,   54,   38,
      34,   43,   24,       53,   32,   11,       72,   21,   -2,       91,   11,  -15,
     -40,   84,   83,      -21,   74,   70,       -2,   63,   56,       17,   52,   42,
      37,   41,   29,       55,   31,   15,       74,   20,    2,       94,    9,  -11,
     -37,   83,   87,      -18,   72,   74,        1,   61,   60,       20,   51,   46,
      39,   40,   33,       58,   29,   19,       77,   19,    6,       96,    8,   -7,
     -35,   82,   91,      -16,   71,   78,        3,   60,   64,       22,   49,   50,
      41,   38,   37,       60,   28,   23,       79,   17,   10,       98,    6,   -3,
     -32,   80,   95,      -14,   70,   82,        6,   59,   68,       24,   48,   54,
      44,   37,   41,       63,   27,   27,       81,   16,   14,      101,    5,    0,
     -30,   79,  100,      -11,   68,   86,        8,   57,   72,       27,   47,   59,
      47,   36,   45,       65,   25,   32,       84,   14,   18,      103,    3,    5,
     -27,   77,  104,       -9,   67,   90,       11,   56,   76,       30,   45,   63,
      49,   34,   49,       68,   24,   36,       86,   13,   22,      106,    2,    9,
     -25,   76,  108,       -6,   65,   94,       13,   54,   80,       32,   44,   67,
      51,   33,   53,       70,   22,   40,       89,   12,   26,      108,    1,   13,
    -100,  123,  -20,      -82,  112,  -33,      -62,  101,  -47,      -43,   91,  -60,
     -24,   80,  -74,       -5,   69,  -87,       14,   59, -101,       33,   48, -115,
     -98,  122,  -16,      -79,  111,  -29,      -60,  100,  -43,      -41,   90,  -56,
     -22,   79,  -70,       -3,   68,  -83,       16,   57,  -97,       35,   46, -111,
     -96,  120,  -12,      -77,  110,  -25,      -57,   99,  -39,      -39,   88,  -52,
     -19,   77,  -66,        0,   67,  -79,       18,   56,  -93,       38,   45, -107,
     -93,  119,   -7,      -74,  108,  -20,      -55,   97,  -34,      -36,   87,  -48,
     -17,   76,  -62,        2,   65,  -75,       21,   55,  -88,       40,   44, -102,
     -90,  117,   -3,      -72,  107,  -16,      -52,   96,  -30,      -34,   85,  -44,
     -14,   74,  -58,        5,   64,  -71,       23,   53,  -84,       43,   42,  -98,
     -88,  116,    0,      -69,  105,  -12,      -50,   95,  -26,      -31,   84,  -40,
     -12,   73,  -54,        7,   62,  -67,       26,   52,  -80,       45,   41,  -94,
     -86,  115,    4,      -67,  104,   -8,      -48,   93,  -22,      -29,   83,  -36,
      -9,   72,  -50,        9,   61,  -63,       28,   50,  -76,       48,   40,  -90,
     -83,  113,    8,      -64,  103,   -4,      -45,   92,  -18,      -26,   81,  -31,
      -7,   70,  -45,       12,   60,  -58,       31,   49,  -72,       50,   38,  -86,
     -81,  112,   12,      -62,  101,    0,      -42,   90,  -14,      -24,   80,  -27,
      -4,   69,  -41,       14,   58,  -54,       33,   48,  -68,       53,   37,  -82,
     -78,  111,   16,      -59,  100,    3,      -40,   89,  -10,      -21,   78,  -23,
      -2,   67,  -37,       17,   57,  -50,       36,   46,  -64,       55,   35,  -78,
     -76,  109,   20,      -57,   99,    7,      -38,   88,   -6,      -19,   77,  -19,
       0,   66,  -33,       19,   55,  -46,       38,   45,  -60,       57,   34,  -74,
     -73,  108,   24,      -55,   97,   11,      -35,   86,   -2,      -16,   76,  -15,
       3,   65,  -29,       22,   54,  -42,       40,   44,  -56,       60,   33,  -70,
     -71,  106,   29,      -52,   96,   16,      -33,   85,    2,      -14,   74,  -11,
       6,   63,  -25,       24,   53,  -38,       43,   42,  -51,       63,   31,  -65,
     -68,  105,   33,      -50,   94,   20,      -30,   83,    6,      -11,   73,   -7,
       8,   62,  -21,       27,   51,  -34,       46,   41,  -47,       65,   30,  -61,
     -66,  104,   37,      -47,   93,   24,      -28,   82,   10,       -9,   71,   -3,
      10,   61,  -17,       29,   50,  -30,       48,   39,  -43,       67,   28,  -57,
     -64,  102,   41,      -45,   92,   28,      -25,   81,   14,       -7,   70,    0,
      13,   59,  -13,       32,   49,  -26,       50,   38,  -39,       70,   27,  -53,
     -61,  101,   45,      -42,   90,   32,      -23,   79,   18,       -4,   69,    5,
      15,   58,   -8,       34,   47,  -21,       53,   36,  -35,       72,   26,  -49,
     -58,   99,   49,      -40,   89,   36,      -20,   78,   22,       -2,   67,    9,
      18,   56,   -4,       37,   46,  -17,       55,   35,  -31,       75,   24,  -45,
     -56,   98,   53,      -37,   87,   40,      -18,   76,   26,        1,   66,   13,
      20,   55,    0,       39,   44,  -13,       58,   34,  -27,       77,   23,  -41,
     -54,   97,   57,      -35,   86,   44,      -16,   75,   30,        3,   65,   17,
      23,   54,    3,       41,   43,   -9,       60,   32,  -23,       80,   21,  -37,
     -51,   95,   62,      -32,   85,   49,      -13,   74,   35,        6,   63,   21,
      25,   52,    7,       44,   41,   -5,       63,   31,  -18,       82,   20,  -32,
     -49,   94,   66,      -30,   83,   53,      -10,   72,   39,        8,   62,   25,
      28,   51,   11,       46,   40,   -1,       65,   30,  -14,       85,   19,  -28,
     -46,   92,   70,      -27,   82,   57,       -8,   71,   43,       11,   60,   29,
      30,   49,   15,       49,   39,    2,       68,   28,  -10,       87,   17,  -24,
     -44,   91,   74,      -25,   81,   61,       -6,   70,   47,       13,   59,   33,
      32,   48,   19,       51,   37,    6,       70,   27,   -6,       89,   16,  -20,
     -41,   90,   78,      -23,   79,   65,       -3,   68,   51,       16,   58,   37,
      35,   47,   23,       54,   36,   10,       72,   25,   -2,       92,   15,  -16,
     -39,   88,   82,      -20,   78,   69,       -1,   67,   55,       18,   56,   42,
      38,   45,   28,       56,   35,   15,       75,   24,    1,       95,   13,  -12,
     -36,   87,   86,      -18,   76,   73,        2,   65,   59,       21,   55,   46,
      40,   44,   32,       59,   33,   19,       78,   23,    5,       97,   12,   -8,
     -34,   86,   90,      -15,   75,   77,        4,   64,   63,       23,   53,   50,
      42,   42,   36,       61,   32,   23,       80,   21,    9,       99,   10,   -4,
     -32,   84,   94,      -13,   74,   81,        7,   63,   67,       25,   52,   54,
      45,   41,   40,       64,   31,   27,       82,   20,   13,      102,    9,    0,
     -29,   83,   99,      -10,   72,   86,        9,   61,   72,       28,   51,   58,
      47,   40,   44,       66,   29,   31,       85,   18,   18,      104,    7,    4,
     -26,   81,  103,       -8,   71,   90,       12,   60,   76,       30,   49,   62,
      50,   38,   48,       69,   28,   35,       87,   17,   22,      107,    6,    8,
     -24,   80,  107,       -5,   69,   94,       14,   58,   80,       33,   48,   66,
      52,   37,   52,       71,   26,   39,       90,   16,   26,      109,    5,   12,
     -99,  127,  -20,      -81,  116,  -34,      -61,  105,  -47,      -42,   95,  -61,
     -23,   84,  -75,       -4,   73,  -88,       14,   63, -101,       34,   52, -115,
     -97,  126,  -16,      -78,  115,  -30,      -59,  104,  -43,      -40,   94,  -57,
     -21,   83,  -71,       -2,   72,  -84,       17,   61,  -97,       36,   50, -111,
     -95,  124,  -12,      -76,  114,  -26,      -56,  103,  -39,      -38,   92,  -53,
     -18,   81,  -67,        0,   71,  -80,       19,   60,  -93,       39,   49, -107,
     -92,  123,   -8,      -73,  112,  -21,      -54,  101,  -35,      -35,   91,  -48,
     -16,   80,  -62,        3,   69,  -76,       22,   59,  -89,       41,   48, -103,
     -90,  121,   -4,      -71,  111,  -17,      -51,  100,  -31,      -33,   89,  -44,
     -13,   78,  -58,        6,   68,  -72,       24,   57,  -85,       44,   46,  -99,
     -87,  120,    0,      -68,  109,  -13,      -49,   99,  -27,      -30,   88,  -40,
     -11,   77,  -54,        8,   66,  -68,       27,   56,  -81,       46,   45,  -95,
     -85,  119,    3,      -66,  108,   -9,      -47,   97,  -23,      -28,   87,  -36,
      -8,   76,  -50,       10,   65,  -64,       29,   54,  -77,       48,   44,  -91,
     -82,  117,    8,      -63,  107,   -5,      -44,   96,  -18,      -25,   85,  -32,
      -6,   74,  -46,       13,   64,  -59,       32,   53,  -72,       51,   42,  -86,
     -80,  116,   12,      -61,  105,   -1,      -42,   94,  -14,      -23,   84,  -28,
      -3,   73,  -42,       15,   62,  -55,       34,   52,  -68,       54,   41,  -82,
     -77,  115,   16,      -59,  104,    2,      -39,   93,  -10,      -20,   82,  -24,
      -1,   71,  -38,       18,   61,  -51,       37,   50,  -64,       56,   39,  -78,
     -75,  113,   20,      -56,  103,    6,      -37,   92,   -6,      -18,   81,  -20,
       1,   70,  -34,       20,   59,  -47,       39,   49,  -60,       58,   38,  -74,
     -73,  112,   24,      -54,  101,   10,      -34,   90,   -2,      -16,   80,  -16,
       4,   69,  -30,       23,   58,  -43,       41,   48,  -56,       61,   37,  -70,
     -70,  110,   28,      -51,  100,   15,      -32,   89,    1,      -13,   78,  -11,
       6,   67,  -25,       25,   57,  -39,       44,   46,  -52,       63,   35,  -66,
     -67,  109,   32,      -49,   98,   19,      -29,   87,    5,      -10,   77,   -7,
       9,   66,  -21,       28,   55,  -35,       46,   45,  -48,       66,   34,  -62,
     -65,  108,   36,      -46,   97,   23,      -27,   86,    9,       -8,   75,   -3,
      11,   65,  -17,       30,   54,  -31,       49,   43,  -44,       68,   32,  -58,
     -63,  106,   40,      -44,   96,   27,      -24,   85,   13,       -6,   74,    0,
      14,   63,  -13,       32,   53,  -27,       51,   42,  -40,       71,   31,  -54,
     -60,  105,   45,      -41,   94,   31,      -22,   83,   18,       -3,   73,    4,
      16,   62,   -9,       35,   51,  -22,       54,   40,  -35,       73,   30,  -49,
     -58,  103,   49,      -39,   93,   35,      -19,   82,   22,       -1,   71,    8,
      19,   60,   -5,       38,   50,  -18,       56,   39,  -31,       76,   28,  -45,
     -55,  102,   53,      -36,   91,   39,      -17,   80,   26,        2,   70,   12,
      21,   59,   -1,       40,   48,  -14,       59,   38,  -27,       78,   27,  -41,
     -53,  101,   57,      -34,   90,   43,      -15,   79,   30,        4,   69,   16,
      24,   58,    2,       42,   47,  -10,       61,   36,  -23,       80,   25,  -37,
     -50,   99,   61,      -31,   89,   48,      -12,   78,   34,        7,   67,   21,
      26,   56,    7,       45,   45,   -6,       64,   35,  -19,       83,   24,  -33,
     -48,   98,   65,      -29,   87,   52,      -10,   76,   38,        9,   66,   25,
      29,   55,   11,       47,   44,   -2,       66,   34,  -15,       86,   23,  -29,
     -45,   96,   69,      -27,   86,   56,       -7,   75,   42,       12,   64,   29,
      31,   53,   15,       50,   43,    1,       69,   32,  -11,       88,   21,  -25,
     -43,   95,   73,      -24,   85,   60,       -5,   74,   46,       14,   63,   33,
      33,   52,   19,       52,   41,    5,       71,   31,   -7,       90,   20,  -21,
     -41,   94,   77,      -22,   83,   64,       -2,   72,   50,       16,   62,   37,
      36,   51,   23,       55,   40,    9,       73,   29,   -3,       93,   19,  -17,
     -38,   92,   82,      -19,   82,   68,        0,   71,   55,       19,   60,   41,
      38,   49,   27,       57,   39,   14,       76,   28,    1,       95,   17,  -12,
     -35,   91,   86,      -17,   80,   72,        3,   69,   59,       21,   59,   45,
      41,   48,   31,       60,   37,   18,       78,   27,    5,       98,   16,   -8,
     -33,   90,   90,      -14,   79,   76,        5,   68,   63,       24,   57,   49,
      43,   46,   35,       62,   36,   22,       81,   25,    9,      100,   14,   -4,
     -31,   88,   94,      -12,   78,   80,        7,   67,   67,       26,   56,   53,
      46,   45,   39,       64,   35,   26,       83,   24,   13,      103,   13,    0,
     -28,   87,   98,       -9,   76,   85,       10,   65,   71,       29,   55,   58,
      48,   44,   44,       67,   33,   30,       86,   22,   17,      105,   11,    3,
     -26,   85,  102,       -7,   75,   89,       13,   64,   75,       31,   53,   62,
      51,   42,   48,       70,   32,   34,       88,   21,   21,      108,   10,    7,
     -23,   84,  106,       -4,   73,   93,       15,   62,   79,       34,   52,   66,
      53,   41,   52,       72,   30,   38,       91,   20,   25,      110,    9,   11,
    -126,   -1,   -1,     -107,  -11,  -15,      -88,  -22,  -28,      -69,  -33,  -42,
     -50,  -44,  -56,      -31,  -54,  -69,      -12,  -65,  -82,        7,  -76,  -96,
    -124,   -2,    2,     -105,  -13,  -11,      -86,  -24,  -24,      -67,  -34,  -38,
     -47,  -45,  -52,      -29,  -56,  -65,      -10,  -66,  -78,        9,  -77,  -92,
    -121,   -4,    6,     -103,  -14,   -7,      -83,  -25,  -20,      -64,  -36,  -34,
     -45,  -47,  -48,      -26,  -57,  -61,       -7,  -68,  -74,       12,  -79,  -88,
    -119,   -5,   10,     -100,  -16,   -2,      -81,  -27,  -16,      -62,  -37,  -29,
     -42,  -48,  -43,      -24,  -59,  -57,       -5,  -69,  -70,       15,  -80,  -84,
    -116,   -6,   14,      -98,  -17,    1,      -78,  -28,  -12,      -59,  -39,  -25,
     -40,  -49,  -39,      -21,  -60,  -53,       -2,  -71,  -66,       17,  -82,  -80,
    -114,   -8,   18,      -95,  -18,    5,      -76,  -29,   -8,      -57,  -40,  -21,
     -38,  -51,  -35,      -19,  -61,  -49,        0,  -72,  -62,       19,  -83,  -76,
    -112,   -9,   22,      -93,  -20,    9,      -73,  -31,   -4,      -55,  -41,  -17,
     -35,  -52,  -31,      -16,  -63,  -45,        2,  -73,  -58,       22,  -84,  -72,
    -109,  -11,   27,      -90,  -21,   13,      -71,  -32,    0,      -52,  -43,  -13,
     -32,  -54,  -27,      -14,  -64,  -40,        5,  -75,  -53,       24,  -86,  -67,
    -106,  -12,   31,      -88,  -23,   17,      -68,  -33,    4,      -49,  -44,   -9,
     -30,  -55,  -23,      -11,  -66,  -36,        7,  -76,  -49,       27,  -87,  -63,
    -104,  -13,   35,      -85,  -24,   21,      -66,  -35,    8,      -47,  -45,   -5,
     -28,  -56,  -19,       -9,  -67,  -32,       10,  -78,  -45,       29,  -89,  -59,
    -102,  -15,   39,      -83,  -25,   25,      -63,  -36,   12,      -45,  -47,   -1,
     -25,  -58,  -15,       -7,  -68,  -28,       12,  -79,  -41,       32,  -90,  -55,
     -99,  -16,   43,      -80,  -27,   29,      -61,  -38,   16,      -42,  -48,    2,
     -23,  -59,  -11,       -4,  -70,  -24,       15,  -80,  -37,       34,  -91,  -51,
     -97,  -18,   47,      -78,  -28,   34,      -58,  -39,   20,      -40,  -50,    7,
     -20,  -61,   -6,       -1,  -71,  -20,       17,  -82,  -33,       37,  -93,  -47,
     -94,  -19,   51,      -75,  -29,   38,      -56,  -40,   24,      -37,  -51,   11,
     -18,  -62,   -2,        1,  -73,  -16,       20,  -83,  -29,       39,  -94,  -43,
     -92,  -20,   55,      -73,  -31,   42,      -54,  -42,   28,      -35,  -52,   15,
     -15,  -63,    1,        3,  -74,  -12,       22,  -84,  -25,       41,  -95,  -39,
     -89,  -22,   59,      -71,  -32,   46,      -51,  -43,   32,      -32,  -54,   19,
     -13,  -65,    5,        6,  -75,   -8,       25,  -86,  -21,       44,  -97,  -35,
     -87,  -23,   64,      -68,  -34,   50,      -49,  -45,   37,      -30,  -55,   23,
     -10,  -66,    9,        8,  -77,   -3,       27,  -87,  -16,       47,  -98,  -30,
     -84,  -24,   68,      -66,  -35,   54,      -46,  -46,   41,      -27,  -57,   27,
      -8,  -68,   13,       11,  -78,    0,       30,  -89,  -12,       49, -100,  -26,
     -82,  -26,   72,      -63,  -36,   58,      -44,  -47,   45,      -25,  -58,   31,
      -6,  -69,   17,       13,  -79,    4,       32,  -90,   -8,       51, -101,  -22,
     -80,  -27,   76,      -61,  -38,   62,      -41,  -49,   49,      -23,  -59,   35,
      -3,  -70,   21,       16,  -81,    8,       34,  -91,   -4,       54, -102,  -18,
     -77,  -29,   80,      -58,  -39,   67,      -39,  -50,   53,      -20,  -61,   40,
      -1,  -72,   26,       18,  -82,   12,       37,  -93,    0,       56, -104,  -14,
     -74,  -30,   84,      -56,  -41,   71,      -36,  -52,   57,      -17,  -62,   44,
       2,  -73,   30,       21,  -84,   16,       39,  -94,    3,       59, -105,  -10,
     -72,  -31,   88,      -53,  -42,   75,      -34,  -53,   61,      -15,  -63,   48,
       4,  -74,   34,       23,  -85,   20,       42,  -96,    7,       61, -107,   -6,
     -70,  -33,   92,      -51,  -43,   79,      -31,  -54,   65,      -13,  -65,   52,
       7,  -76,   38,       25,  -86,   24,       44,  -97,   11,       64, -108,   -2,
     -67,  -34,   96,      -48,  -45,   83,      -29,  -56,   69,      -10,  -66,   56,
       9,  -77,   42,       28,  -88,   28,       47,  -98,   15,       66, -109,    1,
     -65,  -36,  101,      -46,  -46,   87,      -26,  -57,   74,       -8,  -68,   60,
      12,  -79,   46,       31,  -89,   33,       49, -100,   20,       69, -111,    6,
     -62,  -37,  105,      -43,  -48,   91,      -24,  -58,   78,       -5,  -69,   64,
      14,  -80,   50,       33,  -91,   37,       52, -101,   24,       71, -112,   10,
     -60,  -38,  109,      -41,  -49,   95,      -22,  -60,   82,       -3,  -70,   68,
      17,  -81,   54,       35,  -92,   41,       54, -103,   28,       73, -113,   14,
     -57,  -40,  113,      -39,  -50,   99,      -19,  -61,   86,        0,  -72,   72,
      19,  -83,   58,       38,  -93,   45,       56, -104,   32,       76, -115,   18,
     -55,  -41,  117,      -36,  -52,  104,      -17,  -63,   90,        2,  -73,   77,
      22,  -84,   63,       40,  -95,   49,       59, -105,   36,       79, -116,   22,
     -52,  -43,  121,      -34,  -53,  108,      -14,  -64,   94,        5,  -75,   81,
      24,  -86,   67,       43,  -96,   53,       62, -107,   40,       81, -118,   26,
     -50,  -44,  125,      -31,  -54,  112,      -12,  -65,   98,        7,  -76,   85,
      26,  -87,   71,       45,  -98,   57,       64, -108,   44,       83, -119,   30,
    -125,    2,   -2,     -106,   -7,  -15,      -87,  -18,  -29,      -68,  -29,  -42,
     -49,  -40,  -56,      -30,  -50,  -70,      -11,  -61,  -83,        8,  -72,  -97,
    -123,    1,    1,     -104,   -9,  -11,      -85,  -20,  -25,      -66,  -30,  -38,
     -47,  -41,  -52,      -28,  -52,  -66,       -9,  -62,  -79,       10,  -73,  -93,
    -120,    0,    5,     -102,  -10,   -7,      -82,  -21,  -21,      -64,  -32,  -34,
     -44,  -43,  -48,      -25,  -53,  -62,       -7,  -64,  -75,       13,  -75,  -89,
    -118,   -1,   10,      -99,  -12,   -3,      -80,  -23,  -17,      -61,  -33,  -30,
     -41,  -44,  -44,      -23,  -55,  -57,       -4,  -65,  -71,       15,  -76,  -84,
    -115,   -2,   14,      -97,  -13,    0,      -77,  -24,  -13,      -58,  -35,  -26,
     -39,  -45,  -40,      -20,  -56,  -53,       -1,  -67,  -67,       18,  -78,  -80,
    -113,   -4,   18,      -94,  -14,    4,      -75,  -25,   -9,      -56,  -36,  -22,
     -37,  -47,  -36,      -18,  -57,  -49,        1,  -68,  -63,       20,  -79,  -76,
    -111,   -5,   22,      -92,  -16,    8,      -72,  -27,   -5,      -54,  -37,  -18,
     -34,  -48,  -32,      -15,  -59,  -45,        3,  -69,  -59,       23,  -80,  -72,
    -108,   -7,   26,      -89,  -17,   13,      -70,  -28,    0,      -51,  -39,  -13,
     -32,  -50,  -27,      -13,  -60,  -41,        6,  -71,  -54,       25,  -82,  -68,
    -106,   -8,   30,      -87,  -19,   17,      -67,  -29,    3,      -49,  -40,   -9,
     -29,  -51,  -23,      -10,  -62,  -37,        8,  -72,  -50,       28,  -83,  -64,
    -103,   -9,   34,      -84,  -20,   21,      -65,  -31,    7,      -46,  -41,   -5,
     -27,  -52,  -19,       -8,  -63,  -33,       11,  -74,  -46,       30,  -85,  -60,
    -101,  -11,   38,      -82,  -21,   25,      -63,  -32,   11,      -44,  -43,   -1,
     -24,  -54,  -15,       -6,  -64,  -29,       13,  -75,  -42,       33,  -86,  -56,
     -98,  -12,   42,      -80,  -23,   29,      -60,  -34,   15,      -41,  -44,    2,
     -22,  -55,  -11,       -3,  -66,  -25,       16,  -76,  -38,       35,  -87,  -52,
     -96,  -14,   47,      -77,  -24,   33,      -57,  -35,   19,      -39,  -46,    6,
     -19,  -57,   -7,       -1,  -67,  -20,       18,  -78,  -34,       38,  -89,  -47,
     -93,  -15,   51,      -74,  -25,   37,      -55,  -36,   23,      -36,  -47,   10,
     -17,  -58,   -3,        2,  -69,  -16,       21,  -79,  -30,       40,  -90,  -43,
     -91,  -16,   55,      -72,  -27,   41,      -53,  -38,   27,      -34,  -48,   14,
     -15,  -59,    0,        4,  -70,  -12,       23,  -80,  -26,       42,  -91,  -39,
     -88,  -18,   59,      -70,  -28,   45,      -50,  -39,   31,      -32,  -50,   18,
     -12,  -61,    4,        7,  -71,   -8,       25,  -82,  -22,       45,  -93,  -35,
     -86,  -19,   63,      -67,  -30,   50,      -48,  -41,   36,      -29,  -51,   23,
      -9,  -62,    9,        9,  -73,   -4,       28,  -83,  -17,       47,  -94,  -31,
     -83,  -20,   67,      -65,  -31,   54,      -45,  -42,   40,      -26,  -53,   27,
      -7,  -64,   13,       12,  -74,    0,       30,  -85,  -13,       50,  -96,  -27,
     -81,  -22,   71,      -62,  -32,   58,      -43,  -43,   44,      -24,  -54,   31,
      -5,  -65,   17,       14,  -75,    3,       33,  -86,   -9,       52,  -97,  -23,
     -79,  -23,   75,      -60,  -34,   62,      -40,  -45,   48,      -22,  -55,   35,
      -2,  -66,   21,       16,  -77,    7,       35,  -87,   -5,       55,  -98,  -19,
     -76,  -25,   80,      -57,  -35,   66,      -38,  -46,   52,      -19,  -57,   39,
       0,  -68,   25,       19,  -78,   12,       38,  -89,   -1,       57, -100,  -14,
     -74,  -26,   84,      -55,  -37,   70,      -35,  -48,   56,      -17,  -58,   43,
       3,  -69,   29,       22,  -80,   16,       40,  -90,    2,       60, -101,  -10,
     -71,  -27,   88,      -52,  -38,   74,      -33,  -49,   60,      -14,  -59,   47,
       5,  -70,   33,       24,  -81,   20,       43,  -92,    6,       62, -103,   -6,
     -69,  -29,   92,      -50,  -39,   78,      -31,  -50,   64,      -12,  -61,   51,
       8,  -72,   37,       26,  -82,   24,       45,  -93,   10,       65, -104,   -2,
     -66,  -30,   96,      -48,  -41,   82,      -28,  -52,   68,       -9,  -62,   55,
      10,  -73,   41,       29,  -84,   28,       48,  -94,   14,       67, -105,    1,
     -64,  -32,  100,      -45,  -42,   87,      -25,  -53,   73,       -7,  -64,   60,
      13,  -75,   46,       31,  -85,   32,       50,  -96,   19,       70, -107,    5,
     -61,  -33,  104,      -42,  -44,   91,      -23,  -54,   77,       -4,  -65,   64,
      15,  -76,   50,       34,  -87,   36,       53,  -97,   23,       72, -108,    9,
     -59,  -34,  108,      -40,  -45,   95,      -21,  -56,   81,       -2,  -66,   68,
      17,  -77,   54,       36,  -88,   40,       55,  -99,   27,       74, -109,   13,
     -56,  -36,  112,      -38,  -46,   99,      -18,  -57,   85,        0,  -68,   72,
      20,  -79,   58,       39,  -89,   44,       57, -100,   31,       77, -111,   17,
     -54,  -37,  117,      -35,  -48,  103,      -16,  -59,   89,        3,  -69,   76,
      23,  -80,   62,       41,  -91,   49,       60, -101,   35,       79, -112,   22,
     -51,  -39,  121,      -33,  -49,  107,      -13,  -60,   93,        6,  -71,   80,
      25,  -82,   66,       44,  -92,   53,       62, -103,   39,       82, -114,   26,
     -49,  -40,  125,      -30,  -50,  111,      -11,  -61,   97,        8,  -72,   84,
      27,  -83,   70,       46,  -94,   57,       65, -104,   43,       84, -115,   30,
    -124,    6,   -2,     -106,   -3,  -16,      -86,  -14,  -30,      -67,  -25,  -43,
     -48,  -36,  -57,      -29,  -46,  -70,      -10,  -57,  -84,        9,  -68,  -98,
    -122,    5,    1,     -103,   -5,  -12,      -84,  -16,  -26,      -65,  -26,  -39,
     -46,  -37,  -53,      -27,  -48,  -66,       -8,  -58,  -80,       11,  -69,  -94,
    -120,    3,    5,     -101,   -6,   -8,      -81,  -17,  -22,      -63,  -28,  -35,
     -43,  -39,  -49,      -24,  -49,  -62,       -6,  -60,  -76,       14,  -71,  -90,
    -117,    2,    9,      -98,   -8,   -3,      -79,  -19,  -17,      -60,  -29,  -31,
     -41,  -40,  -44,      -22,  -51,  -58,       -3,  -61,  -71,       16,  -72,  -85,
    -114,    1,   13,      -96,   -9,    0,      -76,  -20,  -13,      -58,  -31,  -27,
     -38,  -41,  -40,      -19,  -52,  -54,       -1,  -63,  -67,       19,  -74,  -81,
    -112,    0,   17,      -93,  -10,    4,      -74,  -21,   -9,      -55,  -32,  -23,
     -36,  -43,  -36,      -17,  -53,  -50,        2,  -64,  -63,       21,  -75,  -77,
    -110,   -1,   21,      -91,  -12,    8,      -72,  -23,   -5,      -53,  -33,  -19,
     -33,  -44,  -32,      -15,  -55,  -46,        4,  -65,  -59,       24,  -76,  -73,
    -107,   -3,   26,      -88,  -13,   12,      -69,  -24,   -1,      -50,  -35,  -14,
     -31,  -46,  -28,      -12,  -56,  -41,        7,  -67,  -55,       26,  -78,  -69,
    -105,   -4,   30,      -86,  -15,   16,      -66,  -25,    2,      -48,  -36,  -10,
     -28,  -47,  -24,      -10,  -58,  -37,        9,  -68,  -51,       29,  -79,  -65,
    -102,   -5,   34,      -83,  -16,   20,      -64,  -27,    6,      -45,  -37,   -6,
     -26,  -48,  -20,       -7,  -59,  -33,       12,  -70,  -47,       31,  -81,  -61,
    -100,   -7,   38,      -81,  -17,   24,      -62,  -28,   10,      -43,  -39,   -2,
     -23,  -50,  -16,       -5,  -60,  -29,       14,  -71,  -43,       33,  -82,  -57,
     -97,   -8,   42,      -79,  -19,   28,      -59,  -30,   14,      -40,  -40,    1,
     -21,  -51,  -12,       -2,  -62,  -25,       16,  -72,  -39,       36,  -83,  -53,
     -95,  -10,   46,      -76,  -20,   33,      -57,  -31,   19,      -38,  -42,    5,
     -18,  -53,   -7,        0,  -63,  -21,       19,  -74,  -34,       39,  -85,  -48,
     -92,  -11,   50,      -74,  -21,   37,      -54,  -32,   23,      -35,  -43,    9,
     -16,  -54,   -3,        3,  -65,  -17,       22,  -75,  -30,       41,  -86,  -44,
     -90,  -12,   54,      -71,  -23,   41,      -52,  -34,   27,      -33,  -44,   13,
     -14,  -55,    0,        5,  -66,  -13,       24,  -76,  -26,       43,  -87,  -40,
     -88,  -14,   58,      -69,  -24,   45,      -49,  -35,   31,      -31,  -46,   17,
     -11,  -57,    4,        8,  -67,   -9,       26,  -78,  -22,       46,  -89,  -36,
     -85,  -15,   63,      -66,  -26,   49,      -47,  -37,   35,      -28,  -47,   22,
      -9,  -58,    8,       10,  -69,   -4,       29,  -79,  -18,       48,  -90,  -32,
     -82,  -16,   67,      -64,  -27,   53,      -44,  -38,   39,      -26,  -49,   26,
      -6,  -60,   12,       13,  -70,    0,       31,  -81,  -14,       51,  -92,  -28,
     -80,  -18,   71,      -61,  -28,   57,      -42,  -39,   43,      -23,  -50,   30,
      -4,  -61,   16,       15,  -71,    3,       34,  -82,  -10,       53,  -93,  -24,
     -78,  -19,   75,      -59,  -30,   61,      -40,  -41,   47,      -21,  -51,   34,
      -1,  -62,   20,       17,  -73,    7,       36,  -83,   -6,       56,  -94,  -20,
     -75,  -21,   79,      -56,  -31,   66,      -37,  -42,   52,      -18,  -53,   38,
       1,  -64,   25,       20,  -74,   11,       39,  -85,   -1,       58,  -96,  -15,
     -73,  -22,   83,      -54,  -33,   70,      -34,  -44,   56,      -16,  -54,   42,
       4,  -65,   29,       22,  -76,   15,       41,  -86,    2,       61,  -97,  -11,
     -70,  -23,   87,      -51,  -34,   74,      -32,  -45,   60,      -13,  -55,   46,
       6,  -66,   33,       25,  -77,   19,       44,  -88,    6,       63,  -99,   -7,
     -68,  -25,   91,      -49,  -35,   78,      -30,  -46,   64,      -11,  -57,   50,
       8,  -68,   37,       27,  -78,   23,       46,  -89,   10,       65, -100,   -3,
     -65,  -26,   95,      -47,  -37,   82,      -27,  -48,   68,       -8,  -58,   54,
      11,  -69,   41,       30,  -80,   27,       48,  -90,   14,       68, -101,    0,
     -63,  -28,  100,      -44,  -38,   86,      -25,  -49,   72,       -6,  -60,   59,
      14,  -71,   45,       32,  -81,   32,       51,  -92,   18,       71, -103,    4,
     -60,  -29,  104,      -42,  -40,   90,      -22,  -50,   76,       -3,  -61,   63,
      16,  -72,   49,       35,  -83,   36,       54,  -93,   22,       73, -104,    8,
     -58,  -30,  108,      -39,  -41,   94,      -20,  -52,   80,       -1,  -62,   67,
      18,  -73,   53,       37,  -84,   40,       56,  -95,   26,       75, -105,   12,
     -56,  -32,  112,      -37,  -42,   98,      -17,  -53,   84,        1,  -64,   71,
      21,  -75,   57,       40,  -85,   44,       58,  -96,   30,       78, -107,   16,
     -53,  -33,  116,      -34,  -44,  103,      -15,  -55,   89,        4,  -65,   75,
      23,  -76,   62,       42,  -87,   48,       61,  -97,   35,       80, -108,   21,
     -50,  -35,  120,      -32,  -45,  107,      -12,  -56,   93,        6,  -67,   79,
      26,  -78,   66,       45,  -88,   52,       63,  -99,   39,       83, -110,   25,
     -48,  -36,  124,      -29,  -46,  111,      -10,  -57,   97,        9,  -68,   83,
      28,  -79,   70,       47,  -90,   56,       66, -100,   43,       85, -111,   29,
    -123,   11,   -3,     -105,    0,  -17,      -85,  -10,  -30,      -66,  -20,  -44,
     -47,  -31,  -58,      -28,  -42,  -71,       -9,  -53,  -84,       10,  -64,  -98,
    -121,    9,    0,     -102,    0,  -13,      -83,  -11,  -26,      -64,  -22,  -40,
     -45,  -33,  -54,      -26,  -43,  -67,       -7,  -54,  -80,       12,  -65,  -94,
    -119,    8,    4,     -100,   -2,   -9,      -80,  -13,  -22,      -62,  -23,  -36,
     -42,  -34,  -50,      -23,  -45,  -63,       -5,  -55,  -76,       15,  -66,  -90,
    -116,    6,    8,      -97,   -3,   -4,      -78,  -14,  -18,      -59,  -25,  -31,
     -40,  -36,  -45,      -21,  -46,  -59,       -2,  -57,  -72,       17,  -68,  -86,
    -113,    5,   12,      -95,   -4,    0,      -75,  -15,  -14,      -56,  -26,  -27,
     -37,  -37,  -41,      -18,  -48,  -55,        0,  -58,  -68,       20,  -69,  -82,
    -111,    4,   16,      -92,   -6,    3,      -73,  -17,  -10,      -54,  -27,  -23,
     -35,  -38,  -37,      -16,  -49,  -51,        3,  -60,  -64,       22,  -70,  -78,
    -109,    2,   20,      -90,   -7,    7,      -70,  -18,   -6,      -52,  -29,  -19,
     -32,  -40,  -33,      -14,  -50,  -47,        5,  -61,  -60,       25,  -72,  -74,
    -106,    1,   25,      -87,   -9,   11,      -68,  -20,   -1,      -49,  -30,  -15,
     -30,  -41,  -29,      -11,  -52,  -42,        8,  -62,  -55,       27,  -73,  -69,
    -104,    0,   29,      -85,  -10,   15,      -65,  -21,    2,      -47,  -32,  -11,
     -27,  -43,  -25,       -8,  -53,  -38,       10,  -64,  -51,       30,  -75,  -65,
    -101,   -1,   33,      -82,  -11,   19,      -63,  -22,    6,      -44,  -33,   -7,
     -25,  -44,  -21,       -6,  -54,  -34,       13,  -65,  -47,       32,  -76,  -61,
     -99,   -2,   37,      -80,  -13,   23,      -61,  -24,   10,      -42,  -34,   -3,
     -22,  -45,  -17,       -4,  -56,  -30,       15,  -66,  -43,       34,  -77,  -57,
     -96,   -4,   41,      -78,  -14,   27,      -58,  -25,   14,      -39,  -36,    0,
     -20,  -47,  -13,       -1,  -57,  -26,       17,  -68,  -39,       37,  -79,  -53,
     -94,   -5,   45,      -75,  -16,   32,      -56,  -27,   18,      -37,  -37,    5,
     -17,  -48,   -8,        1,  -59,  -22,       20,  -69,  -35,       40,  -80,  -49,
     -91,   -6,   49,      -73,  -17,   36,      -53,  -28,   22,      -34,  -39,    9,
     -15,  -49,   -4,        4,  -60,  -18,       23,  -71,  -31,       42,  -82,  -45,
     -89,   -8,   53,      -70,  -18,   40,      -51,  -29,   26,      -32,  -40,   13,
     -13,  -51,    0,        6,  -61,  -14,       25,  -72,  -27,       44,  -83,  -41,
     -87,   -9,   57,      -68,  -20,   44,      -48,  -31,   30,      -30,  -41,   17,
     -10,  -52,    3,        9,  -63,  -10,       27,  -73,  -23,       47,  -84,  -37,
     -84,  -11,   62,      -65,  -21,   48,      -46,  -32,   35,      -27,  -43,   21,
      -8,  -54,    7,       11,  -64,   -5,       30,  -75,  -18,       49,  -86,  -32,
     -81,  -12,   66,      -63,  -23,   52,      -43,  -33,   39,      -25,  -44,   25,
      -5,  -55,   11,       14,  -66,   -1,       32,  -76,  -14,       52,  -87,  -28,
     -79,  -13,   70,      -60,  -24,   56,      -41,  -35,   43,      -22,  -45,   29,
      -3,  -56,   15,       16,  -67,    2,       35,  -78,  -10,       54,  -88,  -24,
     -77,  -15,   74,      -58,  -25,   60,      -39,  -36,   47,      -20,  -47,   33,
       0,  -58,   19,       18,  -68,    6,       37,  -79,   -6,       57,  -90,  -20,
     -74,  -16,   78,      -55,  -27,   65,      -36,  -38,   51,      -17,  -48,   38,
       2,  -59,   24,       21,  -70,   10,       40,  -80,   -2,       59,  -91,  -16,
     -72,  -18,   82,      -53,  -28,   69,      -33,  -39,   55,      -15,  -50,   42,
       5,  -61,   28,       24,  -71,   14,       42,  -82,    1,       62,  -93,  -12,
     -69,  -19,   86,      -50,  -29,   73,      -31,  -40,   59,      -12,  -51,   46,
       7,  -62,   32,       26,  -73,   18,       45,  -83,    5,       64,  -94,   -8,
     -67,  -20,   90,      -48,  -31,   77,      -29,  -42,   63,      -10,  -52,   50,
      10,  -63,   36,       28,  -74,   22,       47,  -84,    9,       66,  -95,   -4,
     -64,  -22,   94,      -46,  -32,   81,      -26,  -43,   67,       -7,  -54,   54,
      12,  -65,   40,       31,  -75,   26,       49,  -86,   13,       69,  -97,    0,
     -62,  -23,   99,      -43,  -34,   85,      -24,  -45,   72,       -5,  -55,   58,
      15,  -66,   44,       33,  -77,   31,       52,  -87,   18,       72,  -98,    4,
     -59,  -24,  103,      -41,  -35,   89,      -21,  -46,   76,       -2,  -57,   62,
      17,  -67,   48,       36,  -78,   35,       55,  -89,   22,       74, -100,    8,
     -57,  -26,  107,      -38,  -36,   93,      -19,  -47,   80,        0,  -58,   66,
      19,  -69,   52,       38,  -79,   39,       57,  -90,   26,       76, -101,   12,
     -55,  -27,  111,      -36,  -38,   97,      -16,  -49,   84,        2,  -59,   70,
      22,  -70,   56,       41,  -81,   43,       59,  -91,   30,       79, -102,   16,
     -52,  -29,  115,      -33,  -39,  102,      -14,  -50,   88,        5,  -61,   75,
      24,  -72,   61,       43,  -82,   47,       62,  -93,   34,       81, -104,   20,
     -49,  -30,  119,      -31,  -41,  106,      -11,  -52,   92,        7,  -62,   79,
      27,  -73,   65,       46,  -84,   51,       64,  -94,   38,       84, -105,   24,
     -47,  -31,  123,      -28,  -42,  110,       -9,  -53,   96,       10,  -63,   83,
      29,  -74,   69,       48,  -85,   55,       67,  -96,   42,       86, -107,   28,
    -122,   15,   -4,     -104,    4,  -17,      -84,   -6,  -31,      -65,  -16,  -44,
     -46,  -27,  -58,      -27,  -38,  -72,       -9,  -49,  -85,       11,  -60,  -99,
    -120,   13,    0,     -101,    3,  -13,      -82,   -7,  -27,      -63,  -18,  -40,
     -44,  -29,  -54,      -25,  -39,  -68,       -6,  -50,  -81,       13,  -61,  -95,
    -118,   12,    3,      -99,    1,   -9,      -79,   -9,  -23,      -61,  -19,  -36,
     -41,  -30,  -50,      -23,  -41,  -64,       -4,  -51,  -77,       16,  -62,  -91,
    -115,   10,    8,      -96,    0,   -5,      -77,  -10,  -19,      -58,  -21,  -32,
     -39,  -32,  -46,      -20,  -42,  -59,       -1,  -53,  -73,       18,  -64,  -86,
    -113,    9,   12,      -94,    0,   -1,      -74,  -11,  -15,      -56,  -22,  -28,
     -36,  -33,  -42,      -17,  -44,  -55,        1,  -54,  -69,       21,  -65,  -82,
    -110,    8,   16,      -91,   -2,    2,      -72,  -13,  -11,      -53,  -23,  -24,
     -34,  -34,  -38,      -15,  -45,  -51,        4,  -56,  -65,       23,  -66,  -78,
    -108,    6,   20,      -89,   -3,    6,      -70,  -14,   -7,      -51,  -25,  -20,
     -31,  -36,  -34,      -13,  -46,  -47,        6,  -57,  -61,       26,  -68,  -74,
    -105,    5,   24,      -86,   -5,   11,      -67,  -16,   -2,      -48,  -26,  -15,
     -29,  -37,  -29,      -10,  -48,  -43,        9,  -58,  -56,       28,  -69,  -70,
    -103,    4,   28,      -84,   -6,   15,      -65,  -17,    1,      -46,  -28,  -11,
     -26,  -39,  -25,       -8,  -49,  -39,       11,  -60,  -52,       31,  -71,  -66,
    -100,    2,   32,      -81,   -7,   19,      -62,  -18,    5,      -43,  -29,   -7,
     -24,  -40,  -21,       -5,  -50,  -35,       14,  -61,  -48,       33,  -72,  -62,
     -98,    1,   36,      -79,   -9,   23,      -60,  -20,    9,      -41,  -30,   -3,
     -22,  -41,  -17,       -3,  -52,  -31,       16,  -62,  -44,       35,  -73,  -58,
     -95,    0,   40,      -77,  -10,   27,      -57,  -21,   13,      -39,  -32,    0,
     -19,  -43,  -13,        0,  -53,  -27,       18,  -64,  -40,       38,  -75,  -54,
     -93,   -1,   45,      -74,  -12,   31,      -55,  -23,   17,      -36,  -33,    4,
     -16,  -44,   -9,        2,  -55,  -22,       21,  -65,  -36,       40,  -76,  -49,
     -90,   -2,   49,      -72,  -13,   35,      -52,  -24,   21,      -33,  -35,    8,
     -14,  -45,   -5,        5,  -56,  -18,       23,  -67,  -32,       43,  -78,  -45,
     -88,   -4,   53,      -69,  -14,   39,      -50,  -25,   25,      -31,  -36,   12,
     -12,  -47,   -1,        7,  -57,  -14,       26,  -68,  -28,       45,  -79,  -41,
     -86,   -5,   57,      -67,  -16,   43,      -47,  -27,   29,      -29,  -37,   16,
      -9,  -48,    2,        9,  -59,  -10,       28,  -69,  -24,       48,  -80,  -37,
     -83,   -7,   61,      -64,  -17,   48,      -45,  -28,   34,      -26,  -39,   21,
      -7,  -50,    7,       12,  -60,   -6,       31,  -71,  -19,       50,  -82,  -33,
     -81,   -8,   65,      -62,  -19,   52,      -42,  -29,   38,      -24,  -40,   25,
      -4,  -51,   11,       15,  -62,   -2,       33,  -72,  -15,       53,  -83,  -29,
     -78,   -9,   69,      -59,  -20,   56,      -40,  -31,   42,      -21,  -41,   29,
      -2,  -52,   15,       17,  -63,    1,       36,  -74,  -11,       55,  -84,  -25,
     -76,  -11,   73,      -57,  -21,   60,      -38,  -32,   46,      -19,  -43,   33,
       1,  -54,   19,       19,  -64,    5,       38,  -75,   -7,       58,  -86,  -21,
     -73,  -12,   78,      -54,  -23,   64,      -35,  -34,   50,      -16,  -44,   37,
       3,  -55,   23,       22,  -66,   10,       41,  -76,   -3,       60,  -87,  -16,
     -71,  -14,   82,      -52,  -24,   68,      -33,  -35,   54,      -14,  -46,   41,
       6,  -57,   27,       24,  -67,   14,       43,  -78,    0,       63,  -89,  -12,
     -68,  -15,   86,      -49,  -25,   72,      -30,  -36,   58,      -11,  -47,   45,
       8,  -58,   31,       27,  -69,   18,       46,  -79,    4,       65,  -90,   -8,
     -66,  -16,   90,      -47,  -27,   76,      -28,  -38,   62,       -9,  -48,   49,
      10,  -59,   35,       29,  -70,   22,       48,  -80,    8,       67,  -91,   -4,
     -63,  -18,   94,      -45,  -28,   80,      -25,  -39,   66,       -7,  -50,   53,
      13,  -61,   39,       32,  -71,   26,       50,  -82,   12,       70,  -93,    0,
     -61,  -19,   98,      -42,  -30,   85,      -23,  -41,   71,       -4,  -51,   58,
      16,  -62,   44,       34,  -73,   30,       53,  -83,   17,       72,  -94,    3,
     -58,  -20,  102,      -40,  -31,   89,      -20,  -42,   75,       -1,  -53,   62,
      18,  -63,   48,       37,  -74,   34,       55,  -85,   21,       75,  -96,    7,
     -56,  -22,  106,      -37,  -32,   93,      -18,  -43,   79,        1,  -54,   66,
      20,  -65,   52,       39,  -75,   38,       58,  -86,   25,       77,  -97,   11,
     -54,  -23,  110,      -35,  -34,   97,      -15,  -45,   83,        3,  -55,   70,
      23,  -66,   56,       41,  -77,   42,       60,  -87,   29,       80,  -98,   15,
     -51,  -25,  115,      -32,  -35,  101,      -13,  -46,   87,        6,  -57,   74,
      25,  -68,   60,       44,  -78,   47,       63,  -89,   33,       82, -100,   20,
     -49,  -26,  119,      -30,  -37,  105,      -10,  -48,   91,        8,  -58,   78,
      28,  -69,   64,       47,  -80,   51,       65,  -90,   37,       85, -101,   24,
     -46,  -27,  123,      -27,  -38,  109,       -8,  -49,   95,       11,  -59,   82,
      30,  -70,   68,       49,  -81,   55,       68,  -92,   41,       87, -103,   28,
    -121,   19,   -5,     -103,    8,  -18,      -83,   -2,  -32,      -65,  -12,  -45,
     -45,  -23,  -59,      -26,  -34,  -72,       -8,  -45,  -86,       12,  -56, -100,
    -119,   17,   -1,     -100,    7,  -14,      -81,   -3,  -28,      -62,  -14,  -41,
     -43,  -25,  -55,      -24,  -35,  -68,       -5,  -46,  -82,       14,  -57,  -96,
    -117,   16,    2,      -98,    5,  -10,      -79,   -5,  -24,      -60,  -15,  -37,
     -40,  -26,  -51,      -22,  -37,  -64,       -3,  -47,  -78,       17,  -58,  -92,
    -114,   14,    7,      -95,    4,   -5,      -76,   -6,  -19,      -57,  -17,  -33,
     -38,  -28,  -46,      -19,  -38,  -60,        0,  -49,  -73,       19,  -60,  -87,
    -112,   13,   11,      -93,    3,   -1,      -73,   -7,  -15,      -55,  -18,  -29,
     -35,  -29,  -42,      -17,  -40,  -56,        2,  -50,  -69,       22,  -61,  -83,
    -109,   12,   15,      -90,    1,    2,      -71,   -9,  -11,      -52,  -19,  -25,
     -33,  -30,  -38,      -14,  -41,  -52,        5,  -52,  -65,       24,  -62,  -79,
    -107,   10,   19,      -88,    0,    6,      -69,  -10,   -7,      -50,  -21,  -21,
     -31,  -32,  -34,      -12,  -42,  -48,        7,  -53,  -61,       26,  -64,  -75,
    -104,    9,   23,      -85,   -1,   10,      -66,  -12,   -3,      -47,  -22,  -16,
     -28,  -33,  -30,       -9,  -44,  -43,       10,  -54,  -57,       29,  -65,  -71,
    -102,    8,   27,      -83,   -2,   14,      -64,  -13,    0,      -45,  -24,  -12,
     -25,  -35,  -26,       -7,  -45,  -39,       12,  -56,  -53,       32,  -67,  -67,
     -99,    6,   31,      -81,   -3,   18,      -61,  -14,    4,      -42,  -25,   -8,
     -23,  -36,  -22,       -4,  -46,  -35,       15,  -57,  -49,       34,  -68,  -63,
     -97,    5,   35,      -78,   -5,   22,      -59,  -16,    8,      -40,  -26,   -4,
     -21,  -37,  -18,       -2,  -48,  -31,       17,  -58,  -45,       36,  -69,  -59,
     -95,    3,   39,      -76,   -6,   26,      -56,  -17,   12,      -38,  -28,    0,
     -18,  -39,  -14,        1,  -49,  -27,       19,  -60,  -41,       39,  -71,  -55,
     -92,    2,   44,      -73,   -8,   31,      -54,  -19,   17,      -35,  -29,    3,
     -16,  -40,   -9,        3,  -51,  -23,       22,  -61,  -36,       41,  -72,  -50,
     -89,    1,   48,      -71,   -9,   35,      -51,  -20,   21,      -33,  -31,    7,
     -13,  -41,   -5,        6,  -52,  -19,       24,  -63,  -32,       44,  -74,  -46,
     -87,    0,   52,      -68,  -10,   39,      -49,  -21,   25,      -30,  -32,   11,
     -11,  -43,   -1,        8,  -53,  -15,       27,  -64,  -28,       46,  -75,  -42,
     -85,   -1,   56,      -66,  -12,   43,      -47,  -23,   29,      -28,  -33,   15,
      -8,  -44,    2,       10,  -55,  -11,       29,  -65,  -24,       49,  -76,  -38,
     -82,   -3,   60,      -63,  -13,   47,      -44,  -24,   33,      -25,  -35,   20,
      -6,  -46,    6,       13,  -56,   -6,       32,  -67,  -20,       51,  -78,  -34,
     -80,   -4,   64,      -61,  -15,   51,      -41,  -25,   37,      -23,  -36,   24,
      -3,  -47,   10,       15,  -58,   -2,       34,  -68,  -16,       54,  -79,  -30,
     -77,   -5,   68,      -58,  -16,   55,      -39,  -27,   41,      -20,  -37,   28,
      -1,  -48,   14,       18,  -59,    1,       37,  -70,  -12,       56,  -80,  -26,
     -75,   -7,   72,      -56,  -17,   59,      -37,  -28,   45,      -18,  -39,   32,
       1,  -50,   18,       20,  -60,    5,       39,  -71,   -8,       58,  -82,  -22,
     -72,   -8,   77,      -53,  -19,   64,      -34,  -30,   50,      -15,  -40,   36,
       4,  -51,   23,       23,  -62,    9,       42,  -72,   -3,       61,  -83,  -17,
     -70,  -10,   81,      -51,  -20,   68,      -32,  -31,   54,      -13,  -42,   40,
       7,  -53,   27,       25,  -63,   13,       44,  -74,    0,       63,  -85,  -13,
     -67,  -11,   85,      -49,  -21,   72,      -29,  -32,   58,      -10,  -43,   44,
       9,  -54,   31,       28,  -65,   17,       47,  -75,    4,       66,  -86,   -9,
     -65,  -12,   89,      -46,  -23,   76,      -27,  -34,   62,       -8,  -44,   48,
      11,  -55,   35,       30,  -66,   21,       49,  -76,    8,       68,  -87,   -5,
     -63,  -14,   93,      -44,  -24,   80,      -24,  -35,   66,       -6,  -46,   52,
      14,  -57,   39,       33,  -67,   25,       51,  -78,   12,       71,  -89,   -1,
     -60,  -15,   97,      -41,  -26,   84,      -22,  -37,   70,       -3,  -47,   57,
      16,  -58,   43,       35,  -69,   30,       54,  -79,   16,       73,  -90,    2,
     -57,  -16,  101,      -39,  -27,   88,      -19,  -38,   74,       -1,  -49,   61,
      19,  -59,   47,       38,  -70,   34,       56,  -81,   20,       76,  -92,    6,
     -55,  -18,  105,      -36,  -28,   92,      -17,  -39,   78,        2,  -50,   65,
      21,  -61,   51,       40,  -71,   38,       59,  -82,   24,       78,  -93,   10,
     -53,  -19,  109,      -34,  -30,   96,      -15,  -41,   82,        4,  -51,   69,
      24,  -62,   55,       42,  -73,   42,       61,  -83,   28,       81,  -94,   14,
     -50,  -21,  114,      -31,  -31,  101,      -12,  -42,   87,        7,  -53,   73,
      26,  -64,   60,       45,  -74,   46,       64,  -85,   33,       83,  -96,   19,
     -48,  -22,  118,      -29,  -33,  105,       -9,  -44,   91,        9,  -54,   77,
      29,  -65,   64,       47,  -76,   50,       66,  -86,   37,       86,  -97,   23,
     -45,  -23,  122,      -26,  -34,  109,       -7,  -45,   95,       12,  -55,   81,
      31,  -66,   68,       50,  -77,   54,       69,  -88,   41,       88,  -99,   27,
    -121,   23,   -5,     -102,   12,  -19,      -82,    1,  -32,      -64,   -8,  -46,
     -44,  -19,  -60,      -25,  -30,  -73,       -7,  -41,  -86,       13,  -52, -100,
    -118,   21,   -1,      -99,   11,  -15,      -80,    0,  -28,      -61,  -10,  -42,
     -42,  -21,  -56,      -23,  -31,  -69,       -4,  -42,  -82,       15,  -53,  -96,
    -116,   20,    2,      -97,    9,  -11,      -78,   -1,  -24,      -59,  -11,  -38,
     -39,  -22,  -52,      -21,  -33,  -65,       -2,  -43,  -78,       17,  -54,  -92,
    -113,   18,    6,      -94,    8,   -6,      -75,   -2,  -20,      -56,  -13,  -33,
     -37,  -24,  -47,      -18,  -34,  -60,        1,  -45,  -74,       20,  -56,  -88,
    -111,   17,   10,      -92,    7,   -2,      -73,   -3,  -16,      -54,  -14,  -29,
     -34,  -25,  -43,      -16,  -36,  -56,        3,  -46,  -70,       23,  -57,  -84,
    -108,   16,   14,      -90,    5,    1,      -70,   -5,  -12,      -51,  -15,  -25,
     -32,  -26,  -39,      -13,  -37,  -52,        6,  -48,  -66,       25,  -58,  -80,
    -106,   14,   18,      -87,    4,    5,      -68,   -6,   -8,      -49,  -17,  -21,
     -30,  -28,  -35,      -11,  -38,  -48,        8,  -49,  -62,       27,  -60,  -76,
    -103,   13,   23,      -84,    2,    9,      -65,   -8,   -3,      -46,  -18,  -17,
     -27,  -29,  -31,       -8,  -40,  -44,       11,  -50,  -57,       30,  -61,  -71,
    -101,   12,   27,      -82,    1,   13,      -63,   -9,    0,      -44,  -20,  -13,
     -25,  -31,  -27,       -6,  -41,  -40,       13,  -52,  -53,       32,  -63,  -67,
     -98,   10,   31,      -80,    0,   17,      -60,  -10,    4,      -42,  -21,   -9,
     -22,  -32,  -23,       -3,  -42,  -36,       15,  -53,  -49,       35,  -64,  -63,
     -96,    9,   35,      -77,   -1,   21,      -58,  -12,    8,      -39,  -22,   -5,
     -20,  -33,  -19,       -1,  -44,  -32,       18,  -54,  -45,       37,  -65,  -59,
     -94,    7,   39,      -75,   -2,   25,      -56,  -13,   12,      -37,  -24,   -1,
     -17,  -35,  -15,        1,  -45,  -28,       20,  -56,  -41,       40,  -67,  -55,
     -91,    6,   43,      -72,   -4,   30,      -53,  -15,   16,      -34,  -25,    3,
     -15,  -36,  -10,        4,  -47,  -23,       23,  -57,  -37,       42,  -68,  -51,
     -89,    5,   47,      -70,   -5,   34,      -50,  -16,   20,      -32,  -27,    7,
     -12,  -37,   -6,        7,  -48,  -19,       25,  -59,  -33,       45,  -70,  -47,
     -86,    3,   51,      -67,   -6,   38,      -48,  -17,   24,      -29,  -28,   11,
     -10,  -39,   -2,        9,  -49,  -15,       28,  -60,  -29,       47,  -71,  -43,
     -84,    2,   55,      -65,   -8,   42,      -46,  -19,   28,      -27,  -29,   15,
      -7,  -40,    1,       11,  -51,  -11,       30,  -61,  -25,       49,  -72,  -39,
     -81,    0,   60,      -62,   -9,   46,      -43,  -20,   33,      -24,  -31,   19,
      -5,  -42,    5,       14,  -52,   -7,       33,  -63,  -20,       52,  -74,  -34,
     -79,    0,   64,      -60,  -11,   50,      -41,  -21,   37,      -22,  -32,   23,
      -2,  -43,    9,       16,  -54,   -3,       35,  -64,  -16,       55,  -75,  -30,
     -76,   -1,   68,      -58,  -12,   54,      -38,  -23,   41,      -19,  -33,   27,
       0,  -44,   13,       19,  -55,    0,       38,  -66,  -12,       57,  -76,  -26,
     -74,   -3,   72,      -55,  -13,   58,      -36,  -24,   45,      -17,  -35,   31,
       2,  -46,   17,       21,  -56,    4,       40,  -67,   -8,       59,  -78,  -22,
     -71,   -4,   76,      -52,  -15,   63,      -33,  -26,   49,      -14,  -36,   36,
       5,  -47,   22,       24,  -58,    9,       43,  -68,   -4,       62,  -79,  -18,
     -69,   -6,   80,      -50,  -16,   67,      -31,  -27,   53,      -12,  -38,   40,
       7,  -49,   26,       26,  -59,   13,       45,  -70,    0,       64,  -81,  -14,
     -66,   -7,   84,      -48,  -17,   71,      -28,  -28,   57,      -10,  -39,   44,
      10,  -50,   30,       29,  -61,   17,       47,  -71,    3,       67,  -82,  -10,
     -64,   -8,   88,      -45,  -19,   75,      -26,  -30,   61,       -7,  -40,   48,
      12,  -51,   34,       31,  -62,   21,       50,  -72,    7,       69,  -83,   -6,
     -62,  -10,   92,      -43,  -20,   79,      -24,  -31,   65,       -5,  -42,   52,
      15,  -53,   38,       33,  -63,   25,       52,  -74,   11,       72,  -85,   -2,
     -59,  -11,   97,      -40,  -22,   83,      -21,  -33,   70,       -2,  -43,   56,
      17,  -54,   42,       36,  -65,   29,       55,  -75,   16,       74,  -86,    2,
     -57,  -12,  101,      -38,  -23,   87,      -18,  -34,   74,        0,  -45,   60,
      20,  -55,   46,       39,  -66,   33,       57,  -77,   20,       77,  -88,    6,
     -54,  -14,  105,      -35,  -24,   91,      -16,  -35,   78,        3,  -46,   64,
      22,  -57,   50,       41,  -67,   37,       60,  -78,   24,       79,  -89,   10,
     -52,  -15,  109,      -33,  -26,   95,      -14,  -37,   82,        5,  -47,   68,
      25,  -58,   54,       43,  -69,   41,       62,  -79,   28,       81,  -90,   14,
     -49,  -17,  113,      -30,  -27,  100,      -11,  -38,   86,        8,  -49,   73,
      27,  -60,   59,       46,  -70,   46,       65,  -81,   32,       84,  -92,   18,
     -47,  -18,  117,      -28,  -29,  104,       -9,  -40,   90,       10,  -50,   77,
      30,  -61,   63,       48,  -72,   50,       67,  -82,   36,       87,  -93,   22,
     -44,  -19,  121,      -26,  -30,  108,       -6,  -41,   94,       13,  -51,   81,
      32,  -62,   67,       51,  -73,   54,       70,  -84,   40,       89,  -95,   26,
    -120,   27,   -6,     -101,   17,  -19,      -81,    6,  -33,      -63,   -4,  -47,
     -43,  -15,  -60,      -24,  -25,  -74,       -6,  -36,  -87,       14,  -47, -101,
    -117,   26,   -2,      -98,   15,  -15,      -79,    4,  -29,      -60,   -5,  -43,
     -41,  -16,  -56,      -22,  -27,  -70,       -3,  -37,  -83,       16,  -48,  -97,
    -115,   24,    1,      -96,   14,  -11,      -77,    3,  -25,      -58,   -7,  -39,
     -38,  -18,  -52,      -20,  -28,  -66,       -1,  -39,  -79,       18,  -50,  -93,
    -112,   23,    6,      -93,   12,   -7,      -74,    1,  -21,      -55,   -8,  -34,
     -36,  -19,  -48,      -17,  -30,  -61,        2,  -40,  -75,       21,  -51,  -88,
    -110,   22,   10,      -91,   11,   -3,      -72,    0,  -17,      -53,  -10,  -30,
     -33,  -20,  -44,      -15,  -31,  -57,        4,  -42,  -71,       24,  -53,  -84,
    -107,   20,   14,      -88,   10,    0,      -69,    0,  -13,      -50,  -11,  -26,
     -31,  -22,  -40,      -12,  -32,  -53,        7,  -43,  -67,       26,  -54,  -80,
    -105,   19,   18,      -86,    8,    4,      -67,   -2,   -9,      -48,  -12,  -22,
     -29,  -23,  -36,      -10,  -34,  -49,        9,  -44,  -63,       28,  -55,  -76,
    -102,   17,   22,      -83,    7,    9,      -64,   -3,   -4,      -45,  -14,  -18,
     -26,  -25,  -31,       -7,  -35,  -45,       12,  -46,  -58,       31,  -57,  -72,
    -100,   16,   26,      -81,    5,   13,      -62,   -4,    0,      -43,  -15,  -14,
     -23,  -26,  -27,       -5,  -37,  -41,       14,  -47,  -54,       33,  -58,  -68,
     -97,   15,   30,      -79,    4,   17,      -59,   -6,    3,      -40,  -16,  -10,
     -21,  -27,  -23,       -2,  -38,  -37,       16,  -49,  -50,       36,  -60,  -64,
     -95,   13,   34,      -76,    3,   21,      -57,   -7,    7,      -38,  -18,   -6,
     -19,  -29,  -19,        0,  -39,  -33,       19,  -50,  -46,       38,  -61,  -60,
     -93,   12,   38,      -74,    1,   25,      -54,   -9,   11,      -36,  -19,   -2,
     -16,  -30,  -15,        2,  -41,  -29,       21,  -51,  -42,       41,  -62,  -56,
     -90,   10,   43,      -71,    0,   29,      -52,  -10,   15,      -33,  -21,    2,
     -14,  -32,  -11,        5,  -42,  -24,       24,  -53,  -38,       43,  -64,  -51,
     -88,    9,   47,      -69,    0,   33,      -49,  -11,   19,      -31,  -22,    6,
     -11,  -33,   -7,        8,  -44,  -20,       26,  -54,  -34,       46,  -65,  -47,
     -85,    8,   51,      -66,   -2,   37,      -47,  -13,   23,      -28,  -23,   10,
      -9,  -34,   -3,       10,  -45,  -16,       29,  -55,  -30,       48,  -66,  -43,
     -83,    6,   55,      -64,   -3,   41,      -45,  -14,   27,      -26,  -25,   14,
      -6,  -36,    0,       12,  -46,  -12,       31,  -57,  -26,       50,  -68,  -39,
     -80,    5,   59,      -61,   -5,   46,      -42,  -16,   32,      -23,  -26,   18,
      -4,  -37,    5,       15,  -48,   -8,       34,  -58,  -21,       53,  -69,  -35,
     -78,    4,   63,      -59,   -6,   50,      -40,  -17,   36,      -21,  -28,   22,
      -1,  -39,    9,       17,  -49,   -4,       36,  -60,  -17,       56,  -71,  -31,
     -75,    2,   67,      -57,   -7,   54,      -37,  -18,   40,      -18,  -29,   26,
       1,  -40,   13,       20,  -50,    0,       39,  -61,  -13,       58,  -72,  -27,
     -73,    1,   71,      -54,   -9,   58,      -35,  -20,   44,      -16,  -30,   30,
       3,  -41,   17,       22,  -52,    3,       41,  -62,   -9,       60,  -73,  -23,
     -70,    0,   76,      -51,  -10,   62,      -32,  -21,   48,      -13,  -32,   35,
       6,  -43,   21,       25,  -53,    8,       44,  -64,   -5,       63,  -75,  -18,
     -68,   -1,   80,      -49,  -12,   66,      -30,  -23,   52,      -11,  -33,   39,
       8,  -44,   25,       27,  -55,   12,       46,  -65,   -1,       65,  -76,  -14,
     -65,   -2,   84,      -47,  -13,   70,      -27,  -24,   56,       -8,  -34,   43,
      11,  -45,   29,       30,  -56,   16,       48,  -67,    2,       68,  -78,  -10,
     -63,   -4,   88,      -44,  -14,   74,      -25,  -25,   60,       -6,  -36,   47,
      13,  -47,   33,       32,  -57,   20,       51,  -68,    6,       70,  -79,   -6,
     -61,   -5,   92,      -42,  -16,   78,      -22,  -27,   64,       -4,  -37,   51,
      16,  -48,   37,       34,  -59,   24,       53,  -69,   10,       73,  -80,   -2,
     -58,   -7,   96,      -39,  -17,   83,      -20,  -28,   69,       -1,  -39,   55,
      18,  -50,   42,       37,  -60,   28,       56,  -71,   15,       75,  -82,    1,
     -56,   -8,  100,      -37,  -19,   87,      -17,  -29,   73,        1,  -40,   59,
      21,  -51,   46,       40,  -62,   32,       58,  -72,   19,       78,  -83,    5,
     -53,   -9,  104,      -34,  -20,   91,      -15,  -31,   77,        4,  -41,   63,
      23,  -52,   50,       42,  -63,   36,       61,  -74,   23,       80,  -84,    9,
     -51,  -11,  108,      -32,  -21,   95,      -13,  -32,   81,        6,  -43,   67,
      26,  -54,   54,       44,  -64,   40,       63,  -75,   27,       82,  -86,   13,
     -48,  -12,  113,      -29,  -23,   99,      -10,  -34,   85,        9,  -44,   72,
      28,  -55,   58,       47,  -66,   45,       66,  -76,   31,       85,  -87,   18,
     -46,  -14,  117,      -27,  -24,  103,       -8,  -35,   89,       11,  -46,   76,
      31,  -57,   62,       49,  -67,   49,       68,  -78,   35,       88,  -89,   22,
     -43,  -15,  121,      -25,  -25,  107,       -5,  -36,   93,       14,  -47,   80,
      33,  -58,   66,       52,  -69,   53,       71,  -79,   39,       90,  -90,   26,
    -119,   31,   -7,     -100,   21,  -20,      -80,   10,  -34,      -62,    0,  -47,
     -42,  -11,  -61,      -24,  -21,  -74,       -5,  -32,  -88,       15,  -43, -102,
    -116,   30,   -3,      -97,   19,  -16,      -78,    8,  -30,      -59,   -1,  -43,
     -40,  -12,  -57,      -21,  -23,  -70,       -2,  -33,  -84,       17,  -44,  -98,
    -114,   28,    0,      -95,   18,  -12,      -76,    7,  -26,      -57,   -3,  -39,
     -38,  -14,  -53,      -19,  -24,  -66,        0,  -35,  -80,       19,  -46,  -94,
    -111,   27,    5,      -92,   16,   -7,      -73,    5,  -21,      -54,   -4,  -35,
     -35,  -15,  -48,      -16,  -26,  -62,        3,  -36,  -75,       22,  -47,  -89,
    -109,   26,    9,      -90,   15,   -3,      -71,    4,  -17,      -52,   -6,  -31,
     -32,  -16,  -44,      -14,  -27,  -58,        5,  -38,  -71,       24,  -49,  -85,
    -106,   24,   13,      -88,   14,    0,      -68,    3,  -13,      -49,   -7,  -27,
     -30,  -18,  -40,      -11,  -28,  -54,        8,  -39,  -67,       27,  -50,  -81,
    -104,   23,   17,      -85,   12,    4,      -66,    1,   -9,      -47,   -8,  -23,
     -28,  -19,  -36,       -9,  -30,  -50,       10,  -40,  -63,       29,  -51,  -77,
    -101,   21,   21,      -83,   11,    8,      -63,    0,   -5,      -44,  -10,  -18,
     -25,  -21,  -32,       -6,  -31,  -45,       13,  -42,  -59,       32,  -53,  -73,
     -99,   20,   25,      -80,    9,   12,      -61,    0,   -1,      -42,  -11,  -14,
     -23,  -22,  -28,       -4,  -33,  -41,       15,  -43,  -55,       34,  -54,  -69,
     -97,   19,   29,      -78,    8,   16,      -58,   -2,    2,      -40,  -12,  -10,
     -20,  -23,  -24,       -1,  -34,  -37,       17,  -45,  -51,       37,  -56,  -65,
     -94,   17,   33,      -75,    7,   20,      -56,   -3,    6,      -37,  -14,   -6,
     -18,  -25,  -20,        1,  -35,  -33,       20,  -46,  -47,       39,  -57,  -61,
     -92,   16,   37,      -73,    5,   24,      -54,   -5,   10,      -35,  -15,   -2,
     -15,  -26,  -16,        3,  -37,  -29,       22,  -47,  -43,       42,  -58,  -57,
     -89,   14,   42,      -70,    4,   29,      -51,   -6,   15,      -32,  -17,    1,
     -13,  -28,  -11,        6,  -38,  -25,       25,  -49,  -38,       44,  -60,  -52,
     -87,   13,   46,      -68,    3,   33,      -48,   -7,   19,      -30,  -18,    5,
     -10,  -29,   -7,        8,  -40,  -21,       27,  -50,  -34,       47,  -61,  -48,
     -84,   12,   50,      -65,    1,   37,      -46,   -9,   23,      -27,  -19,    9,
      -8,  -30,   -3,       11,  -41,  -17,       30,  -51,  -30,       49,  -62,  -44,
     -82,   10,   54,      -63,    0,   41,      -44,  -10,   27,      -25,  -21,   13,
      -6,  -32,    0,       13,  -42,  -13,       32,  -53,  -26,       51,  -64,  -40,
     -79,    9,   58,      -60,   -1,   45,      -41,  -12,   31,      -22,  -22,   18,
      -3,  -33,    4,       16,  -44,   -8,       35,  -54,  -22,       54,  -65,  -36,
     -77,    8,   62,      -58,   -2,   49,      -39,  -13,   35,      -20,  -24,   22,
       0,  -35,    8,       18,  -45,   -4,       37,  -56,  -18,       56,  -67,  -32,
     -74,    6,   66,      -56,   -3,   53,      -36,  -14,   39,      -17,  -25,   26,
       2,  -36,   12,       21,  -46,    0,       40,  -57,  -14,       59,  -68,  -28,
     -72,    5,   70,      -53,   -5,   57,      -34,  -16,   43,      -15,  -26,   30,
       4,  -37,   16,       23,  -48,    3,       42,  -58,  -10,       61,  -69,  -24,
     -69,    3,   75,      -51,   -6,   62,      -31,  -17,   48,      -12,  -28,   34,
       7,  -39,   21,       26,  -49,    7,       45,  -60,   -5,       64,  -71,  -19,
     -67,    2,   79,      -48,   -8,   66,      -29,  -19,   52,      -10,  -29,   38,
       9,  -40,   25,       28,  -51,   11,       47,  -61,   -1,       66,  -72,  -15,
     -65,    1,   83,      -46,   -9,   70,      -26,  -20,   56,       -8,  -30,   42,
      12,  -41,   29,       31,  -52,   15,       49,  -63,    2,       69,  -74,  -11,
     -62,    0,   87,      -43,  -10,   74,      -24,  -21,   60,       -5,  -32,   46,
      14,  -43,   33,       33,  -53,   19,       52,  -64,    6,       71,  -75,   -7,
     -60,   -1,   91,      -41,  -12,   78,      -22,  -23,   64,       -3,  -33,   50,
      17,  -44,   37,       35,  -55,   23,       54,  -65,   10,       74,  -76,   -3,
     -57,   -3,   95,      -38,  -13,   82,      -19,  -24,   68,        0,  -35,   55,
      19,  -46,   41,       38,  -56,   28,       57,  -67,   14,       76,  -78,    0,
     -55,   -4,   99,      -36,  -15,   86,      -16,  -25,   72,        2,  -36,   59,
      22,  -47,   45,       40,  -58,   32,       59,  -68,   18,       79,  -79,    4,
     -52,   -5,  103,      -33,  -16,   90,      -14,  -27,   76,        5,  -37,   63,
      24,  -48,   49,       43,  -59,   36,       62,  -70,   22,       81,  -80,    8,
     -50,   -7,  107,      -31,  -17,   94,      -12,  -28,   80,        7,  -39,   67,
      26,  -50,   53,       45,  -60,   40,       64,  -71,   26,       83,  -82,   12,
     -47,   -8,  112,      -28,  -19,   99,       -9,  -30,   85,       10,  -40,   71,
      29,  -51,   58,       48,  -62,   44,       67,  -72,   31,       86,  -83,   17,
     -45,  -10,  116,      -26,  -20,  103,       -7,  -31,   89,       12,  -42,   75,
      32,  -53,   62,       50,  -63,   48,       69,  -74,   35,       88,  -85,   21,
     -42,  -11,  120,      -24,  -21,  107,       -4,  -32,   93,       15,  -43,   79,
      34,  -54,   66,       53,  -65,   52,       71,  -75,   39,       91,  -86,   25,
    -118,   35,   -7,      -99,   25,  -21,      -80,   14,  -34,      -61,    3,  -48,
     -41,   -7,  -62,      -23,  -17,  -75,       -4,  -28,  -88,       16,  -39, -102,
    -115,   34,   -3,      -97,   23,  -17,      -77,   12,  -30,      -58,    2,  -44,
     -39,   -8,  -58,      -20,  -19,  -71,       -1,  -29,  -84,       18,  -40,  -98,
    -113,   32,    0,      -94,   22,  -13,      -75,   11,  -26,      -56,    0,  -40,
     -37,  -10,  -54,      -18,  -20,  -67,        1,  -31,  -80,       20,  -42,  -94,
    -110,   31,    4,      -91,   20,   -8,      -72,    9,  -22,      -53,    0,  -35,
     -34,  -11,  -49,      -15,  -22,  -63,        4,  -32,  -76,       23,  -43,  -90,
    -108,   30,    8,      -89,   19,   -4,      -70,    8,  -18,      -51,   -2,  -31,
     -32,  -12,  -45,      -13,  -23,  -59,        6,  -34,  -72,       25,  -45,  -86,
    -105,   28,   12,      -87,   18,    0,      -67,    7,  -14,      -49,   -3,  -27,
     -29,  -14,  -41,      -10,  -24,  -55,        8,  -35,  -68,       28,  -46,  -82,
    -103,   27,   16,      -84,   16,    3,      -65,    5,  -10,      -46,   -4,  -23,
     -27,  -15,  -37,       -8,  -26,  -51,       11,  -36,  -64,       30,  -47,  -78,
    -100,   25,   21,      -82,   15,    7,      -62,    4,   -5,      -43,   -6,  -19,
     -24,  -17,  -33,       -5,  -27,  -46,       14,  -38,  -59,       33,  -49,  -73,
     -98,   24,   25,      -79,   13,   11,      -60,    3,   -1,      -41,   -7,  -15,
     -22,  -18,  -29,       -3,  -29,  -42,       16,  -39,  -55,       35,  -50,  -69,
     -96,   23,   29,      -77,   12,   15,      -57,    1,    2,      -39,   -8,  -11,
     -19,  -19,  -25,        0,  -30,  -38,       18,  -41,  -51,       38,  -52,  -65,
     -93,   21,   33,      -74,   11,   19,      -55,    0,    6,      -36,  -10,   -7,
     -17,  -21,  -21,        2,  -31,  -34,       21,  -42,  -47,       40,  -53,  -61,
     -91,   20,   37,      -72,    9,   23,      -53,   -1,   10,      -34,  -11,   -3,
     -14,  -22,  -17,        4,  -33,  -30,       23,  -43,  -43,       42,  -54,  -57,
     -88,   18,   41,      -69,    8,   28,      -50,   -2,   14,      -31,  -13,    1,
     -12,  -24,  -12,        7,  -34,  -26,       26,  -45,  -39,       45,  -56,  -53,
     -86,   17,   45,      -67,    7,   32,      -48,   -3,   18,      -29,  -14,    5,
      -9,  -25,   -8,        9,  -36,  -22,       28,  -46,  -35,       48,  -57,  -49,
     -83,   16,   49,      -65,    5,   36,      -45,   -5,   22,      -26,  -15,    9,
      -7,  -26,   -4,       12,  -37,  -18,       31,  -47,  -31,       50,  -58,  -45,
     -81,   14,   53,      -62,    4,   40,      -43,   -6,   26,      -24,  -17,   13,
      -5,  -28,    0,       14,  -38,  -14,       33,  -49,  -27,       52,  -60,  -41,
     -78,   13,   58,      -59,    2,   44,      -40,   -8,   31,      -21,  -18,   17,
      -2,  -29,    3,       17,  -40,   -9,       36,  -50,  -22,       55,  -61,  -36,
     -76,   12,   62,      -57,    1,   48,      -38,   -9,   35,      -19,  -20,   21,
       0,  -31,    7,       19,  -41,   -5,       38,  -52,  -18,       57,  -63,  -32,
     -73,   10,   66,      -55,    0,   52,      -35,  -10,   39,      -17,  -21,   25,
       3,  -32,   11,       22,  -42,   -1,       40,  -53,  -14,       60,  -64,  -28,
     -71,    9,   70,      -52,   -1,   56,      -33,  -12,   43,      -14,  -22,   29,
       5,  -33,   15,       24,  -44,    2,       43,  -54,  -10,       62,  -65,  -24,
     -68,    7,   74,      -50,   -2,   61,      -30,  -13,   47,      -11,  -24,   34,
       8,  -35,   20,       27,  -45,    6,       45,  -56,   -6,       65,  -67,  -20,
     -66,    6,   78,      -47,   -4,   65,      -28,  -15,   51,       -9,  -25,   38,
      10,  -36,   24,       29,  -47,   10,       48,  -57,   -2,       67,  -68,  -16,
     -64,    5,   82,      -45,   -5,   69,      -25,  -16,   55,       -7,  -26,   42,
      13,  -37,   28,       31,  -48,   14,       50,  -59,    1,       70,  -70,  -12,
     -61,    3,   86,      -42,   -6,   73,      -23,  -17,   59,       -4,  -28,   46,
      15,  -39,   32,       34,  -49,   18,       53,  -60,    5,       72,  -71,   -8,
     -59,    2,   90,      -40,   -8,   77,      -21,  -19,   63,       -2,  -29,   50,
      17,  -40,   36,       36,  -51,   22,       55,  -61,    9,       74,  -72,   -4,
     -56,    0,   95,      -37,   -9,   81,      -18,  -20,   68,        1,  -31,   54,
      20,  -42,   40,       39,  -52,   27,       58,  -63,   14,       77,  -74,    0,
     -54,    0,   99,      -35,  -11,   85,      -16,  -21,   72,        3,  -32,   58,
      23,  -43,   44,       41,  -54,   31,       60,  -64,   18,       80,  -75,    4,
     -51,   -1,  103,      -33,  -12,   89,      -13,  -23,   76,        6,  -33,   62,
      25,  -44,   48,       44,  -55,   35,       63,  -66,   22,       82,  -76,    8,
     -49,   -3,  107,      -30,  -13,   93,      -11,  -24,   80,        8,  -35,   66,
      27,  -46,   52,       46,  -56,   39,       65,  -67,   26,       84,  -78,   12,
     -46,   -4,  111,      -27,  -15,   98,       -8,  -26,   84,       11,  -36,   71,
      30,  -47,   57,       49,  -58,   43,       68,  -68,   30,       87,  -79,   16,
     -44,   -6,  115,      -25,  -16,  102,       -6,  -27,   88,       13,  -38,   75,
      32,  -49,   61,       51,  -59,   47,       70,  -70,   34,       89,  -81,   20,
     -41,   -7,  119,      -23,  -17,  106,       -3,  -28,   92,       15,  -39,   79,
      35,  -50,   65,       54,  -61,   51,       72,  -71,   38,       92,  -82,   24,
    -117,   39,   -8,      -98,   29,  -21,      -79,   18,  -35,      -60,    7,  -48,
     -40,   -3,  -62,      -22,  -13,  -76,       -3,  -24,  -89,       16,  -35, -103,
    -114,   38,   -4,      -96,   27,  -17,      -76,   16,  -31,      -57,    6,  -44,
     -38,   -4,  -58,      -19,  -15,  -72,       -1,  -25,  -85,       19,  -36,  -99,
    -112,   36,    0,      -93,   26,  -13,      -74,   15,  -27,      -55,    4,  -40,
     -36,   -6,  -54,      -17,  -16,  -68,        2,  -27,  -81,       21,  -38,  -95,
    -109,   35,    4,      -91,   24,   -9,      -71,   13,  -23,      -52,    3,  -36,
     -33,   -7,  -50,      -14,  -18,  -63,        5,  -28,  -77,       24,  -39,  -90,
    -107,   34,    8,      -88,   23,   -5,      -69,   12,  -19,      -50,    1,  -32,
     -31,   -8,  -46,      -12,  -19,  -59,        7,  -30,  -73,       26,  -41,  -86,
    -105,   32,   12,      -86,   22,   -1,      -66,   11,  -15,      -48,    0,  -28,
     -28,  -10,  -42,       -9,  -20,  -55,        9,  -31,  -69,       29,  -42,  -82,
    -102,   31,   16,      -83,   20,    2,      -64,    9,  -11,      -45,    0,  -24,
     -26,  -11,  -38,       -7,  -22,  -51,       12,  -32,  -65,       31,  -43,  -78,
     -99,   29,   20,      -81,   19,    7,      -61,    8,   -6,      -43,   -2,  -19,
     -23,  -13,  -33,       -4,  -23,  -47,       14,  -34,  -60,       34,  -45,  -74,
     -97,   28,   24,      -78,   17,   11,      -59,    7,   -2,      -40,   -3,  -15,
     -21,  -14,  -29,       -2,  -25,  -43,       17,  -35,  -56,       36,  -46,  -70,
     -95,   27,   28,      -76,   16,   15,      -57,    5,    1,      -38,   -4,  -11,
     -18,  -15,  -25,        0,  -26,  -39,       19,  -37,  -52,       39,  -48,  -66,
     -92,   25,   32,      -74,   15,   19,      -54,    4,    5,      -35,   -6,   -7,
     -16,  -17,  -21,        3,  -27,  -35,       22,  -38,  -48,       41,  -49,  -62,
     -90,   24,   36,      -71,   13,   23,      -52,    2,    9,      -33,   -7,   -3,
     -14,  -18,  -17,        5,  -29,  -31,       24,  -39,  -44,       43,  -50,  -58,
     -87,   22,   41,      -68,   12,   27,      -49,    1,   13,      -30,   -9,    0,
     -11,  -20,  -13,        8,  -30,  -26,       27,  -41,  -40,       46,  -52,  -53,
     -85,   21,   45,      -66,   11,   31,      -47,    0,   17,      -28,  -10,    4,
      -9,  -21,   -9,       10,  -32,  -22,       29,  -42,  -36,       48,  -53,  -49,
     -82,   20,   49,      -64,    9,   35,      -44,   -1,   21,      -25,  -11,    8,
      -6,  -22,   -5,       13,  -33,  -18,       31,  -43,  -32,       51,  -54,  -45,
     -80,   18,   53,      -61,    8,   39,      -42,   -2,   25,      -23,  -13,   12,
      -4,  -24,   -1,       15,  -34,  -14,       34,  -45,  -28,       53,  -56,  -41,
     -77,   17,   57,      -59,    6,   44,      -39,   -4,   30,      -20,  -14,   17,
      -1,  -25,    3,       18,  -36,  -10,       37,  -46,  -23,       56,  -57,  -37,
     -75,   16,   61,      -56,    5,   48,      -37,   -5,   34,      -18,  -16,   21,
       1,  -27,    7,       20,  -37,   -6,       39,  -48,  -19,       58,  -59,  -33,
     -73,   14,   65,      -54,    4,   52,      -34,   -6,   38,      -16,  -17,   25,
       4,  -28,   11,       23,  -38,   -2,       41,  -49,  -15,       61,  -60,  -29,
     -70,   13,   69,      -51,    2,   56,      -32,   -8,   42,      -13,  -18,   29,
       6,  -29,   15,       25,  -40,    1,       44,  -50,  -11,       63,  -61,  -25,
     -67,   11,   74,      -49,    1,   60,      -29,   -9,   46,      -11,  -20,   33,
       9,  -31,   19,       28,  -41,    6,       46,  -52,   -7,       66,  -63,  -20,
     -65,   10,   78,      -46,    0,   64,      -27,  -11,   50,       -8,  -21,   37,
      11,  -32,   23,       30,  -43,   10,       49,  -53,   -3,       68,  -64,  -16,
     -63,    9,   82,      -44,   -1,   68,      -25,  -12,   54,       -6,  -22,   41,
      14,  -33,   27,       32,  -44,   14,       51,  -55,    0,       71,  -66,  -12,
     -60,    7,   86,      -42,   -2,   72,      -22,  -13,   58,       -3,  -24,   45,
      16,  -35,   31,       35,  -45,   18,       54,  -56,    4,       73,  -67,   -8,
     -58,    6,   90,      -39,   -4,   76,      -20,  -15,   62,       -1,  -25,   49,
      18,  -36,   35,       37,  -47,   22,       56,  -57,    8,       75,  -68,   -4,
     -55,    4,   94,      -36,   -5,   81,      -17,  -16,   67,        2,  -27,   54,
      21,  -38,   40,       40,  -48,   26,       59,  -59,   13,       78,  -70,    0,
     -53,    3,   98,      -34,   -7,   85,      -15,  -17,   71,        4,  -28,   58,
      23,  -39,   44,       42,  -50,   30,       61,  -60,   17,       80,  -71,    3,
     -50,    2,  102,      -32,   -8,   89,      -12,  -19,   75,        7,  -29,   62,
      26,  -40,   48,       45,  -51,   34,       63,  -62,   21,       83,  -72,    7,
     -48,    0,  106,      -29,   -9,   93,      -10,  -20,   79,        9,  -31,   66,
      28,  -42,   52,       47,  -52,   38,       66,  -63,   25,       85,  -74,   11,
     -45,    0,  111,      -27,  -11,   97,       -7,  -22,   83,       12,  -32,   70,
      31,  -43,   56,       50,  -54,   43,       69,  -64,   29,       88,  -75,   16,
     -43,   -2,  115,      -24,  -12,  101,       -5,  -23,   87,       14,  -34,   74,
      33,  -45,   60,       52,  -55,   47,       71,  -66,   33,       90,  -77,   20,
     -41,   -3,  119,      -22,  -13,  105,       -2,  -24,   91,       16,  -35,   78,
      36,  -46,   64,       55,  -57,   51,       73,  -67,   37,       93,  -78,   24,
    -116,   43,   -8,      -97,   33,  -22,      -78,   22,  -36,      -59,   11,  -49,
     -40,    0,  -63,      -21,   -9,  -76,       -2,  -20,  -90,       17,  -31, -104,
    -113,   42,   -4,      -95,   31,  -18,      -75,   20,  -32,      -57,   10,  -45,
     -37,    0,  -59,      -18,  -11,  -72,        0,  -21,  -86,       20,  -32, -100,
    -111,   40,    0,      -92,   30,  -14,      -73,   19,  -28,      -54,    8,  -41,
     -35,   -2,  -55,      -16,  -12,  -68,        3,  -23,  -82,       22,  -34,  -96,
    -108,   39,    3,      -90,   28,   -9,      -70,   17,  -23,      -51,    7,  -37,
     -32,   -3,  -50,      -13,  -14,  -64,        5,  -24,  -77,       25,  -35,  -91,
    -106,   38,    7,      -87,   27,   -5,      -68,   16,  -19,      -49,    5,  -33,
     -30,   -4,  -46,      -11,  -15,  -60,        8,  -26,  -73,       27,  -37,  -87,
    -104,   36,   11,      -85,   26,   -1,      -65,   15,  -15,      -47,    4,  -29,
     -27,   -6,  -42,       -9,  -16,  -56,       10,  -27,  -69,       30,  -38,  -83,
    -101,   35,   15,      -82,   24,    2,      -63,   13,  -11,      -44,    3,  -25,
     -25,   -7,  -38,       -6,  -18,  -52,       13,  -28,  -65,       32,  -39,  -79,
     -99,   33,   20,      -80,   23,    6,      -60,   12,   -7,      -42,    1,  -20,
     -22,   -9,  -34,       -3,  -19,  -47,       15,  -30,  -61,       35,  -41,  -75,
     -96,   32,   24,      -77,   21,   10,      -58,   11,   -3,      -39,    0,  -16,
     -20,  -10,  -30,       -1,  -21,  -43,       18,  -31,  -57,       37,  -42,  -71,
     -94,   31,   28,      -75,   20,   14,      -56,    9,    0,      -37,    0,  -12,
     -17,  -11,  -26,        1,  -22,  -39,       20,  -33,  -53,       39,  -44,  -67,
     -91,   29,   32,      -73,   19,   18,      -53,    8,    4,      -34,   -2,   -8,
     -15,  -13,  -22,        4,  -23,  -35,       23,  -34,  -49,       42,  -45,  -63,
     -89,   28,   36,      -70,   17,   22,      -51,    6,    8,      -32,   -3,   -4,
     -13,  -14,  -18,        6,  -25,  -31,       25,  -35,  -45,       44,  -46,  -59,
     -86,   26,   40,      -68,   16,   27,      -48,    5,   13,      -29,   -5,    0,
     -10,  -16,  -13,        9,  -26,  -27,       28,  -37,  -40,       47,  -48,  -54,
     -84,   25,   44,      -65,   15,   31,      -46,    4,   17,      -27,   -6,    3,
      -8,  -17,   -9,       11,  -28,  -23,       30,  -38,  -36,       49,  -49,  -50,
     -82,   24,   48,      -63,   13,   35,      -43,    2,   21,      -25,   -7,    7,
      -5,  -18,   -5,       14,  -29,  -19,       32,  -39,  -32,       52,  -50,  -46,
     -79,   22,   52,      -60,   12,   39,      -41,    1,   25,      -22,   -9,   11,
      -3,  -20,   -1,       16,  -30,  -15,       35,  -41,  -28,       54,  -52,  -42,
     -76,   21,   57,      -58,   10,   43,      -38,    0,   29,      -19,  -10,   16,
       0,  -21,    2,       19,  -32,  -10,       37,  -42,  -24,       57,  -53,  -38,
     -74,   20,   61,      -55,    9,   47,      -36,   -1,   33,      -17,  -12,   20,
       2,  -23,    6,       21,  -33,   -6,       40,  -44,  -20,       59,  -55,  -34,
     -72,   18,   65,      -53,    8,   51,      -33,   -2,   37,      -15,  -13,   24,
       5,  -24,   10,       23,  -34,   -2,       42,  -45,  -16,       62,  -56,  -30,
     -69,   17,   69,      -50,    6,   55,      -31,   -4,   41,      -12,  -14,   28,
       7,  -25,   14,       26,  -36,    1,       45,  -46,  -12,       64,  -57,  -26,
     -67,   15,   73,      -48,    5,   60,      -28,   -5,   46,      -10,  -16,   32,
      10,  -27,   19,       29,  -37,    5,       47,  -48,   -7,       67,  -59,  -21,
     -64,   14,   77,      -45,    3,   64,      -26,   -7,   50,       -7,  -17,   36,
      12,  -28,   23,       31,  -39,    9,       50,  -49,   -3,       69,  -60,  -17,
     -62,   13,   81,      -43,    2,   68,      -24,   -8,   54,       -5,  -18,   40,
      15,  -29,   27,       33,  -40,   13,       52,  -51,    0,       71,  -62,  -13,
     -59,   11,   85,      -41,    1,   72,      -21,   -9,   58,       -2,  -20,   44,
      17,  -31,   31,       36,  -41,   17,       54,  -52,    4,       74,  -63,   -9,
     -57,   10,   89,      -38,    0,   76,      -19,  -11,   62,        0,  -21,   48,
      19,  -32,   35,       38,  -43,   21,       57,  -53,    8,       76,  -64,   -5,
     -54,    8,   94,      -36,   -1,   80,      -16,  -12,   66,        3,  -23,   53,
      22,  -34,   39,       41,  -44,   26,       60,  -55,   12,       79,  -66,   -1,
     -52,    7,   98,      -33,   -3,   84,      -14,  -13,   70,        5,  -24,   57,
      24,  -35,   43,       43,  -46,   30,       62,  -56,   16,       81,  -67,    2,
     -50,    6,  102,      -31,   -4,   88,      -11,  -15,   74,        7,  -25,   61,
      27,  -36,   47,       46,  -47,   34,       64,  -58,   20,       84,  -68,    6,
     -47,    4,  106,      -28,   -5,   92,       -9,  -16,   78,       10,  -27,   65,
      29,  -38,   51,       48,  -48,   38,       67,  -59,   24,       86,  -70,   10,
     -44,    3,  110,      -26,   -7,   97,       -6,  -18,   83,       13,  -28,   69,
      32,  -39,   56,       51,  -50,   42,       69,  -60,   29,       89,  -71,   15,
     -42,    1,  114,      -23,   -8,  101,       -4,  -19,   87,       15,  -30,   73,
      34,  -41,   60,       53,  -51,   46,       72,  -62,   33,       91,  -73,   19,
     -40,    0,  118,      -21,   -9,  105,       -1,  -20,   91,       17,  -31,   77,
      37,  -42,   64,       55,  -53,   50,       74,  -63,   37,       94,  -74,   23,
    -115,   48,   -9,      -96,   37,  -23,      -77,   26,  -36,      -58,   16,  -50,
     -39,    5,  -64,      -20,   -5,  -77,       -1,  -16,  -90,       18,  -27, -104,
    -112,   46,   -5,      -94,   36,  -19,      -74,   25,  -32,      -56,   14,  -46,
     -36,    3,  -60,      -17,   -6,  -73,        1,  -17,  -86,       21,  -28, -100,
    -110,   45,   -1,      -91,   34,  -15,      -72,   23,  -28,      -53,   13,  -42,
     -34,    2,  -56,      -15,   -8,  -69,        4,  -18,  -82,       23,  -29,  -96,
    -107,   43,    2,      -89,   33,  -10,      -69,   22,  -24,      -50,   11,  -37,
     -31,    0,  -51,      -12,   -9,  -65,        6,  -20,  -78,       26,  -31,  -92,
    -105,   42,    6,      -86,   32,   -6,      -67,   21,  -20,      -48,   10,  -33,
     -29,    0,  -47,      -10,  -11,  -61,        9,  -21,  -74,       28,  -32,  -88,
    -103,   41,   10,      -84,   30,   -2,      -64,   19,  -16,      -46,    9,  -29,
     -26,   -1,  -43,       -8,  -12,  -57,       11,  -23,  -70,       31,  -33,  -84,
    -100,   39,   14,      -81,   29,    1,      -62,   18,  -12,      -43,    7,  -25,
     -24,   -3,  -39,       -5,  -13,  -53,       14,  -24,  -66,       33,  -35,  -80,
     -98,   38,   19,      -79,   27,    5,      -59,   16,   -7,      -41,    6,  -21,
     -21,   -4,  -35,       -2,  -15,  -48,       16,  -25,  -61,       36,  -36,  -75,
     -95,   37,   23,      -76,   26,    9,      -57,   15,   -3,      -38,    4,  -17,
     -19,   -6,  -31,        0,  -16,  -44,       19,  -27,  -57,       38,  -38,  -71,
     -93,   35,   27,      -74,   25,   13,      -55,   14,    0,      -36,    3,  -13,
     -16,   -7,  -27,        2,  -17,  -40,       21,  -28,  -53,       41,  -39,  -67,
     -90,   34,   31,      -72,   23,   17,      -52,   12,    4,      -33,    2,   -9,
     -14,   -8,  -23,        5,  -19,  -36,       24,  -29,  -49,       43,  -40,  -63,
     -88,   32,   35,      -69,   22,   21,      -50,   11,    8,      -31,    0,   -5,
     -12,  -10,  -19,        7,  -20,  -32,       26,  -31,  -45,       45,  -42,  -59,
     -85,   31,   39,      -66,   20,   26,      -47,    9,   12,      -28,    0,    0,
      -9,  -11,  -14,       10,  -22,  -28,       29,  -32,  -41,       48,  -43,  -55,
     -83,   30,   43,      -64,   19,   30,      -45,    8,   16,      -26,   -2,    3,
      -7,  -12,  -10,       12,  -23,  -24,       31,  -34,  -37,       50,  -45,  -51,
     -80,   28,   47,      -62,   18,   34,      -42,    7,   20,      -24,   -3,    7,
      -4,  -14,   -6,       15,  -24,  -20,       33,  -35,  -33,       53,  -46,  -47,
     -78,   27,   51,      -59,   16,   38,      -40,    5,   24,      -21,   -4,   11,
      -2,  -15,   -2,       17,  -26,  -16,       36,  -36,  -29,       55,  -47,  -43,
     -75,   25,   56,      -57,   15,   42,      -37,    4,   29,      -18,   -6,   15,
       1,  -17,    1,       20,  -27,  -11,       38,  -38,  -24,       58,  -49,  -38,
     -73,   24,   60,      -54,   13,   46,      -35,    3,   33,      -16,   -7,   19,
       3,  -18,    5,       22,  -29,   -7,       41,  -39,  -20,       60,  -50,  -34,
     -71,   23,   64,      -52,   12,   50,      -32,    1,   37,      -14,   -8,   23,
       6,  -19,    9,       24,  -30,   -3,       43,  -41,  -16,       63,  -51,  -30,
     -68,   21,   68,      -49,   11,   54,      -30,    0,   41,      -11,  -10,   27,
       8,  -21,   13,       27,  -31,    0,       46,  -42,  -12,       65,  -53,  -26,
     -66,   20,   72,      -47,    9,   59,      -27,   -1,   45,       -9,  -11,   32,
      11,  -22,   18,       30,  -33,    4,       48,  -43,   -8,       68,  -54,  -22,
     -63,   18,   76,      -44,    8,   63,      -25,   -2,   49,       -6,  -13,   36,
      13,  -24,   22,       32,  -34,    8,       51,  -45,   -4,       70,  -56,  -18,
     -61,   17,   80,      -42,    7,   67,      -23,   -3,   53,       -4,  -14,   40,
      16,  -25,   26,       34,  -36,   12,       53,  -46,    0,       73,  -57,  -14,
     -58,   16,   84,      -40,    5,   71,      -20,   -5,   57,       -1,  -15,   44,
      18,  -26,   30,       37,  -37,   16,       56,  -47,    3,       75,  -58,  -10,
     -56,   14,   88,      -37,    4,   75,      -18,   -6,   61,        1,  -17,   48,
      20,  -28,   34,       39,  -38,   20,       58,  -49,    7,       77,  -60,   -6,
     -53,   13,   93,      -34,    2,   79,      -15,   -8,   66,        4,  -18,   52,
      23,  -29,   38,       42,  -40,   25,       61,  -50,   12,       80,  -61,   -1,
     -51,   12,   97,      -32,    1,   83,      -13,   -9,   70,        6,  -20,   56,
      25,  -30,   42,       44,  -41,   29,       63,  -52,   16,       82,  -63,    2,
     -48,   10,  101,      -30,    0,   87,      -10,  -10,   74,        8,  -21,   60,
      28,  -32,   46,       47,  -42,   33,       65,  -53,   20,       85,  -64,    6,
     -46,    9,  105,      -27,   -1,   91,       -8,  -12,   78,       11,  -22,   64,
      30,  -33,   50,       49,  -44,   37,       68,  -54,   24,       87,  -65,   10,
     -43,    7,  109,      -25,   -2,   96,       -5,  -13,   82,       14,  -24,   69,
      33,  -35,   55,       52,  -45,   41,       70,  -56,   28,       90,  -67,   14,
     -41,    6,  113,      -22,   -4,  100,       -3,  -15,   86,       16,  -25,   73,
      35,  -36,   59,       54,  -47,   45,       73,  -57,   32,       92,  -68,   18,
     -39,    5,  117,      -20,   -5,  104,        0,  -16,   90,       18,  -26,   77,
      38,  -37,   63,       56,  -48,   49,       75,  -59,   36,       95,  -70,   22,
    -114,   52,  -10,      -95,   41,  -23,      -76,   30,  -37,      -57,   20,  -50,
     -38,    9,  -64,      -19,   -1,  -78,        0,  -12,  -91,       19,  -23, -105,
    -112,   50,   -6,      -93,   40,  -19,      -73,   29,  -33,      -55,   18,  -46,
     -35,    7,  -60,      -16,   -2,  -74,        2,  -13,  -87,       22,  -24, -101,
    -109,   49,   -2,      -90,   38,  -15,      -71,   27,  -29,      -52,   17,  -42,
     -33,    6,  -56,      -14,   -4,  -70,        5,  -14,  -83,       24,  -25,  -97,
    -106,   47,    2,      -88,   37,  -11,      -68,   26,  -25,      -50,   15,  -38,
     -30,    4,  -52,      -11,   -5,  -65,        7,  -16,  -79,       27,  -27,  -92,
    -104,   46,    6,      -85,   36,   -7,      -66,   25,  -21,      -47,   14,  -34,
     -28,    3,  -48,       -9,   -7,  -61,       10,  -17,  -75,       29,  -28,  -88,
    -102,   45,   10,      -83,   34,   -3,      -64,   23,  -17,      -45,   13,  -30,
     -25,    2,  -44,       -7,   -8,  -57,       12,  -19,  -71,       32,  -29,  -84,
     -99,   43,   14,      -81,   33,    0,      -61,   22,  -13,      -42,   11,  -26,
     -23,    0,  -40,       -4,   -9,  -53,       15,  -20,  -67,       34,  -31,  -80,
     -97,   42,   18,      -78,   31,    5,      -58,   20,   -8,      -40,   10,  -21,
     -20,    0,  -35,       -2,  -11,  -49,       17,  -21,  -62,       37,  -32,  -76,
     -94,   41,   22,      -75,   30,    9,      -56,   19,   -4,      -37,    8,  -17,
     -18,   -2,  -31,        1,  -12,  -45,       20,  -23,  -58,       39,  -34,  -72,
     -92,   39,   26,      -73,   29,   13,      -54,   18,    0,      -35,    7,  -13,
     -16,   -3,  -27,        3,  -13,  -41,       22,  -24,  -54,       41,  -35,  -68,
     -89,   38,   30,      -71,   27,   17,      -51,   16,    3,      -32,    6,   -9,
     -13,   -4,  -23,        6,  -15,  -37,       24,  -25,  -50,       44,  -36,  -64,
     -87,   36,   34,      -68,   26,   21,      -49,   15,    7,      -30,    4,   -5,
     -11,   -6,  -19,        8,  -16,  -33,       27,  -27,  -46,       46,  -38,  -60,
     -84,   35,   39,      -66,   24,   25,      -46,   13,   11,      -27,    3,   -1,
      -8,   -7,  -15,       11,  -18,  -28,       30,  -28,  -42,       49,  -39,  -55,
     -82,   34,   43,      -63,   23,   29,      -44,   12,   15,      -25,    1,    2,
      -6,   -8,  -11,       13,  -19,  -24,       32,  -30,  -38,       51,  -41,  -51,
     -80,   32,   47,      -61,   22,   33,      -41,   11,   19,      -23,    0,    6,
      -3,  -10,   -7,       16,  -20,  -20,       34,  -31,  -34,       54,  -42,  -47,
     -77,   31,   51,      -58,   20,   37,      -39,    9,   23,      -20,    0,   10,
      -1,  -11,   -3,       18,  -22,  -16,       37,  -32,  -30,       56,  -43,  -43,
     -74,   29,   55,      -56,   19,   42,      -36,    8,   28,      -18,   -2,   15,
       2,  -13,    1,       21,  -23,  -12,       39,  -34,  -25,       59,  -45,  -39,
     -72,   28,   59,      -53,   17,   46,      -34,    7,   32,      -15,   -3,   19,
       4,  -14,    5,       23,  -25,   -8,       42,  -35,  -21,       61,  -46,  -35,
     -70,   27,   63,      -51,   16,   50,      -32,    5,   36,      -13,   -4,   23,
       7,  -15,    9,       25,  -26,   -4,       44,  -37,  -17,       64,  -47,  -31,
     -67,   25,   67,      -49,   15,   54,      -29,    4,   40,      -10,   -6,   27,
       9,  -17,   13,       28,  -27,    0,       47,  -38,  -13,       66,  -49,  -27,
     -65,   24,   72,      -46,   13,   58,      -26,    2,   44,       -8,   -7,   31,
      12,  -18,   17,       30,  -29,    4,       49,  -39,   -9,       69,  -50,  -22,
     -62,   22,   76,      -43,   12,   62,      -24,    1,   48,       -5,   -9,   35,
      14,  -20,   21,       33,  -30,    8,       52,  -41,   -5,       71,  -52,  -18,
     -60,   21,   80,      -41,   11,   66,      -22,    0,   52,       -3,  -10,   39,
      16,  -21,   25,       35,  -32,   12,       54,  -42,   -1,       73,  -53,  -14,
     -57,   20,   84,      -39,    9,   70,      -19,   -1,   56,       -1,  -11,   43,
      19,  -22,   29,       38,  -33,   16,       56,  -43,    2,       76,  -54,  -10,
     -55,   18,   88,      -36,    8,   74,      -17,   -2,   60,        2,  -13,   47,
      21,  -24,   33,       40,  -34,   20,       59,  -45,    6,       78,  -56,   -6,
     -52,   17,   92,      -34,    6,   79,      -14,   -4,   65,        5,  -14,   52,
      24,  -25,   38,       43,  -36,   24,       62,  -46,   11,       81,  -57,   -2,
     -50,   16,   96,      -31,    5,   83,      -12,   -5,   69,        7,  -16,   56,
      26,  -26,   42,       45,  -37,   28,       64,  -48,   15,       83,  -59,    1,
     -48,   14,  100,      -29,    4,   87,       -9,   -6,   73,        9,  -17,   60,
      29,  -28,   46,       48,  -38,   32,       66,  -49,   19,       86,  -60,    5,
     -45,   13,  104,      -26,    2,   91,       -7,   -8,   77,       12,  -18,   64,
      31,  -29,   50,       50,  -40,   36,       69,  -50,   23,       88,  -61,    9,
     -42,   11,  109,      -24,    1,   95,       -4,   -9,   81,       14,  -20,   68,
      34,  -31,   54,       53,  -41,   41,       71,  -52,   27,       91,  -63,   14,
     -40,   10,  113,      -21,    0,   99,       -2,  -11,   85,       17,  -21,   72,
      36,  -32,   58,       55,  -43,   45,       74,  -53,   31,       93,  -64,   18,
     -38,    9,  117,      -19,   -1,  103,        0,  -12,   89,       19,  -22,   76,
      39,  -33,   62,       57,  -44,   49,       76,  -55,   35,       96,  -66,   22,
    -113,   56,  -11,      -94,   45,  -24,      -75,   34,  -38,      -56,   24,  -51,
     -37,   13,  -65,      -18,    2,  -78,        1,   -8,  -92,       20,  -19, -106,
    -111,   54,   -7,      -92,   44,  -20,      -72,   33,  -34,      -54,   22,  -47,
     -34,   11,  -61,      -16,    1,  -74,        3,   -9,  -88,       23,  -20, -102,
    -108,   53,   -3,      -89,   42,  -16,      -70,   31,  -30,      -51,   21,  -43,
     -32,   10,  -57,      -13,    0,  -70,        6,  -10,  -84,       25,  -21,  -98,
    -106,   51,    1,      -87,   41,  -11,      -67,   30,  -25,      -49,   19,  -39,
     -29,    8,  -52,      -10,   -1,  -66,        8,  -12,  -79,       28,  -23,  -93,
    -103,   50,    5,      -84,   40,   -7,      -65,   29,  -21,      -46,   18,  -35,
     -27,    7,  -48,       -8,   -3,  -62,       11,  -13,  -75,       30,  -24,  -89,
    -101,   49,    9,      -82,   38,   -3,      -63,   27,  -17,      -44,   17,  -31,
     -24,    6,  -44,       -6,   -4,  -58,       13,  -15,  -71,       32,  -25,  -85,
     -98,   47,   13,      -80,   37,    0,      -60,   26,  -13,      -41,   15,  -27,
     -22,    4,  -40,       -3,   -5,  -54,       15,  -16,  -67,       35,  -27,  -81,
     -96,   46,   17,      -77,   35,    4,      -58,   24,   -9,      -39,   14,  -22,
     -19,    3,  -36,       -1,   -7,  -49,       18,  -17,  -63,       38,  -28,  -77,
     -93,   45,   21,      -75,   34,    8,      -55,   23,   -5,      -36,   12,  -18,
     -17,    1,  -32,        2,   -8,  -45,       21,  -19,  -59,       40,  -30,  -73,
     -91,   43,   25,      -72,   33,   12,      -53,   22,   -1,      -34,   11,  -14,
     -15,    0,  -28,        4,   -9,  -41,       23,  -20,  -55,       42,  -31,  -69,
     -89,   42,   29,      -70,   31,   16,      -50,   20,    2,      -32,   10,  -10,
     -12,    0,  -24,        7,  -11,  -37,       25,  -21,  -51,       45,  -32,  -65,
     -86,   40,   33,      -67,   30,   20,      -48,   19,    6,      -29,    8,   -6,
     -10,   -2,  -20,        9,  -12,  -33,       28,  -23,  -47,       47,  -34,  -61,
     -83,   39,   38,      -65,   28,   25,      -45,   17,   11,      -27,    7,   -2,
      -7,   -3,  -15,       12,  -14,  -29,       30,  -24,  -42,       50,  -35,  -56,
     -81,   38,   42,      -62,   27,   29,      -43,   16,   15,      -24,    5,    1,
      -5,   -4,  -11,       14,  -15,  -25,       33,  -26,  -38,       52,  -37,  -52,
     -79,   36,   46,      -60,   26,   33,      -41,   15,   19,      -22,    4,    5,
      -2,   -6,   -7,       16,  -16,  -21,       35,  -27,  -34,       55,  -38,  -48,
     -76,   35,   50,      -57,   24,   37,      -38,   13,   23,      -19,    3,    9,
       0,   -7,   -3,       19,  -18,  -17,       38,  -28,  -30,       57,  -39,  -44,
     -74,   33,   54,      -55,   23,   41,      -35,   12,   27,      -17,    1,   14,
       3,   -9,    0,       22,  -19,  -12,       40,  -30,  -26,       60,  -41,  -40,
     -71,   32,   58,      -52,   21,   45,      -33,   11,   31,      -14,    0,   18,
       5,  -10,    4,       24,  -21,   -8,       43,  -31,  -22,       62,  -42,  -36,
     -69,   31,   62,      -50,   20,   49,      -31,    9,   35,      -12,    0,   22,
       8,  -11,    8,       26,  -22,   -4,       45,  -33,  -18,       64,  -43,  -32,
     -66,   29,   66,      -48,   19,   53,      -28,    8,   39,       -9,   -2,   26,
      10,  -13,   12,       29,  -23,    0,       47,  -34,  -14,       67,  -45,  -28,
     -64,   28,   71,      -45,   17,   58,      -26,    6,   44,       -7,   -3,   30,
      13,  -14,   17,       31,  -25,    3,       50,  -35,   -9,       70,  -46,  -23,
     -61,   26,   75,      -43,   16,   62,      -23,    5,   48,       -4,   -5,   34,
      15,  -16,   21,       34,  -26,    7,       53,  -37,   -5,       72,  -48,  -19,
     -59,   25,   79,      -40,   15,   66,      -21,    4,   52,       -2,   -6,   38,
      17,  -17,   25,       36,  -28,   11,       55,  -38,   -1,       74,  -49,  -15,
     -57,   24,   83,      -38,   13,   70,      -18,    2,   56,        0,   -7,   42,
      20,  -18,   29,       39,  -29,   15,       57,  -39,    2,       77,  -50,  -11,
     -54,   22,   87,      -35,   12,   74,      -16,    1,   60,        3,   -9,   46,
      22,  -20,   33,       41,  -30,   19,       60,  -41,    6,       79,  -52,   -7,
     -51,   21,   91,      -33,   10,   78,      -13,    0,   64,        5,  -10,   51,
      25,  -21,   37,       44,  -32,   24,       62,  -42,   10,       82,  -53,   -3,
     -49,   20,   95,      -30,    9,   82,      -11,   -1,   68,        8,  -12,   55,
      27,  -22,   41,       46,  -33,   28,       65,  -44,   14,       84,  -55,    0,
     -47,   18,   99,      -28,    8,   86,       -9,   -2,   72,       10,  -13,   59,
      30,  -24,   45,       48,  -34,   32,       67,  -45,   18,       87,  -56,    4,
     -44,   17,  103,      -25,    6,   90,       -6,   -4,   76,       13,  -14,   63,
      32,  -25,   49,       51,  -36,   36,       70,  -46,   22,       89,  -57,    8,
     -42,   15,  108,      -23,    5,   95,       -3,   -5,   81,       15,  -16,   67,
      35,  -27,   54,       54,  -37,   40,       72,  -48,   27,       92,  -59,   13,
     -39,   14,  112,      -20,    3,   99,       -1,   -7,   85,       18,  -17,   71,
      37,  -28,   58,       56,  -39,   44,       75,  -49,   31,       94,  -60,   17,
     -37,   13,  116,      -18,    2,  103,        1,   -8,   89,       20,  -18,   75,
      40,  -29,   62,       58,  -40,   48,       77,  -51,   35,       96,  -62,   21,
    -112,   60,  -11,      -93,   49,  -25,      -74,   38,  -38,      -55,   28,  -52,
     -36,   17,  -66,      -17,    6,  -79,        2,   -4,  -92,       21,  -15, -106,
    -110,   58,   -7,      -91,   48,  -21,      -72,   37,  -34,      -53,   26,  -48,
     -33,   15,  -62,      -15,    5,  -75,        4,   -5,  -88,       24,  -16, -102,
    -107,   57,   -3,      -89,   46,  -17,      -69,   35,  -30,      -50,   25,  -44,
     -31,   14,  -58,      -12,    3,  -71,        7,   -6,  -84,       26,  -17,  -98,
    -105,   55,    0,      -86,   45,  -12,      -66,   34,  -26,      -48,   23,  -39,
     -28,   12,  -53,      -10,    2,  -67,        9,   -8,  -80,       29,  -19,  -94,
    -102,   54,    4,      -83,   44,   -8,      -64,   33,  -22,      -45,   22,  -35,
     -26,   11,  -49,       -7,    0,  -63,       12,   -9,  -76,       31,  -20,  -90,
    -100,   53,    8,      -81,   42,   -4,      -62,   31,  -18,      -43,   21,  -31,
     -24,   10,  -45,       -5,    0,  -59,       14,  -11,  -72,       33,  -21,  -86,
     -97,   51,   12,      -79,   41,    0,      -59,   30,  -14,      -41,   19,  -27,
     -21,    8,  -41,       -2,   -1,  -55,       16,  -12,  -68,       36,  -23,  -82,
     -95,   50,   17,      -76,   39,    3,      -57,   28,   -9,      -38,   18,  -23,
     -18,    7,  -37,        0,   -3,  -50,       19,  -13,  -63,       38,  -24,  -77,
     -92,   49,   21,      -74,   38,    7,      -54,   27,   -5,      -35,   16,  -19,
     -16,    5,  -33,        3,   -4,  -46,       21,  -15,  -59,       41,  -26,  -73,
     -90,   47,   25,      -71,   37,   11,      -52,   26,   -1,      -33,   15,  -15,
     -14,    4,  -29,        5,   -5,  -42,       24,  -16,  -55,       43,  -27,  -69,
     -88,   46,   29,      -69,   35,   15,      -49,   24,    2,      -31,   14,  -11,
     -11,    3,  -25,        7,   -7,  -38,       26,  -17,  -51,       46,  -28,  -65,
     -85,   44,   33,      -66,   34,   19,      -47,   23,    6,      -28,   12,   -7,
      -9,    1,  -21,       10,   -8,  -34,       29,  -19,  -47,       48,  -30,  -61,
     -83,   43,   37,      -64,   32,   24,      -44,   21,   10,      -26,   11,   -2,
      -6,    0,  -16,       13,  -10,  -30,       31,  -20,  -43,       51,  -31,  -57,
     -80,   42,   41,      -61,   31,   28,      -42,   20,   14,      -23,    9,    1,
      -4,    0,  -12,       15,  -11,  -26,       34,  -22,  -39,       53,  -33,  -53,
     -78,   40,   45,      -59,   30,   32,      -40,   19,   18,      -21,    8,    5,
      -1,   -2,   -8,       17,  -12,  -22,       36,  -23,  -35,       56,  -34,  -49,
     -75,   39,   49,      -57,   28,   36,      -37,   17,   22,      -18,    7,    9,
       1,   -3,   -4,       20,  -14,  -18,       39,  -24,  -31,       58,  -35,  -45,
     -73,   37,   54,      -54,   27,   40,      -35,   16,   27,      -16,    5,   13,
       4,   -5,    0,       22,  -15,  -13,       41,  -26,  -26,       61,  -37,  -40,
     -70,   36,   58,      -51,   25,   44,      -32,   15,   31,      -13,    4,   17,
       6,   -6,    3,       25,  -17,   -9,       44,  -27,  -22,       63,  -38,  -36,
     -68,   35,   62,      -49,   24,   48,      -30,   13,   35,      -11,    3,   21,
       8,   -7,    7,       27,  -18,   -5,       46,  -29,  -18,       65,  -39,  -32,
     -65,   33,   66,      -47,   23,   52,      -27,   12,   39,       -9,    1,   25,
      11,   -9,   11,       30,  -19,   -1,       48,  -30,  -14,       68,  -41,  -28,
     -63,   32,   70,      -44,   21,   57,      -25,   10,   43,       -6,    0,   30,
      14,  -10,   16,       32,  -21,    2,       51,  -31,  -10,       70,  -42,  -24,
     -60,   30,   74,      -42,   20,   61,      -22,    9,   47,       -3,   -1,   34,
      16,  -12,   20,       35,  -22,    6,       53,  -33,   -6,       73,  -44,  -20,
     -58,   29,   78,      -39,   19,   65,      -20,    8,   51,       -1,   -2,   38,
      18,  -13,   24,       37,  -24,   10,       56,  -34,   -2,       75,  -45,  -16,
     -56,   28,   82,      -37,   17,   69,      -17,    6,   55,        1,   -3,   42,
      21,  -14,   28,       39,  -25,   14,       58,  -35,    1,       78,  -46,  -12,
     -53,   26,   86,      -34,   16,   73,      -15,    5,   59,        4,   -5,   46,
      23,  -16,   32,       42,  -26,   18,       61,  -37,    5,       80,  -48,   -8,
     -51,   25,   91,      -32,   14,   77,      -12,    3,   64,        6,   -6,   50,
      26,  -17,   36,       45,  -28,   23,       63,  -38,   10,       83,  -49,   -3,
     -48,   24,   95,      -29,   13,   81,      -10,    2,   68,        9,   -8,   54,
      28,  -18,   40,       47,  -29,   27,       66,  -40,   14,       85,  -51,    0,
     -46,   22,   99,      -27,   12,   85,       -8,    1,   72,       11,   -9,   58,
      31,  -20,   44,       49,  -30,   31,       68,  -41,   18,       87,  -52,    4,
     -43,   21,  103,      -25,   10,   89,       -5,    0,   76,       14,  -10,   62,
      33,  -21,   48,       52,  -32,   35,       71,  -42,   22,       90,  -53,    8,
     -41,   19,  107,      -22,    9,   94,       -3,   -1,   80,       16,  -12,   67,
      36,  -23,   53,       54,  -33,   39,       73,  -44,   26,       93,  -55,   12,
     -38,   18,  111,      -19,    7,   98,        0,   -3,   84,       19,  -13,   71,
      38,  -24,   57,       57,  -35,   43,       76,  -45,   30,       95,  -56,   16,
     -36,   17,  115,      -17,    6,  102,        2,   -4,   88,       21,  -14,   75,
      40,  -25,   61,       59,  -36,   47,       78,  -47,   34,       97,  -58,   20,
    -111,   64,  -12,      -92,   54,  -25,      -73,   43,  -39,      -54,   32,  -53,
     -35,   21,  -66,      -16,   11,  -80,        3,    0,  -93,       22,  -10, -107,
    -109,   63,   -8,      -90,   52,  -21,      -71,   41,  -35,      -52,   31,  -49,
     -32,   20,  -62,      -14,    9,  -76,        5,    0,  -89,       25,  -11, -103,
    -106,   61,   -4,      -88,   51,  -17,      -68,   40,  -31,      -49,   29,  -45,
     -30,   18,  -58,      -11,    8,  -72,        8,   -2,  -85,       27,  -13,  -99,
    -104,   60,    0,      -85,   49,  -13,      -65,   38,  -27,      -47,   28,  -40,
     -27,   17,  -54,       -9,    6,  -67,       10,   -3,  -81,       30,  -14,  -94,
    -101,   59,    4,      -82,   48,   -9,      -63,   37,  -23,      -44,   26,  -36,
     -25,   16,  -50,       -6,    5,  -63,       13,   -5,  -77,       32,  -16,  -90,
     -99,   57,    8,      -80,   47,   -5,      -61,   36,  -19,      -42,   25,  -32,
     -23,   14,  -46,       -4,    4,  -59,       15,   -6,  -73,       34,  -17,  -86,
     -96,   56,   12,      -78,   45,   -1,      -58,   34,  -15,      -40,   24,  -28,
     -20,   13,  -42,       -1,    2,  -55,       17,   -7,  -69,       37,  -18,  -82,
     -94,   54,   16,      -75,   44,    3,      -56,   33,  -10,      -37,   22,  -24,
     -17,   11,  -37,        1,    1,  -51,       20,   -9,  -64,       39,  -20,  -78,
     -91,   53,   20,      -73,   42,    7,      -53,   32,   -6,      -34,   21,  -20,
     -15,   10,  -33,        4,    0,  -47,       23,  -10,  -60,       42,  -21,  -74,
     -89,   52,   24,      -70,   41,   11,      -51,   30,   -2,      -32,   20,  -16,
     -13,    9,  -29,        6,   -1,  -43,       25,  -12,  -56,       44,  -23,  -70,
     -87,   50,   28,      -68,   40,   15,      -48,   29,    1,      -30,   18,  -12,
     -10,    7,  -25,        9,   -2,  -39,       27,  -13,  -52,       47,  -24,  -66,
     -84,   49,   32,      -65,   38,   19,      -46,   27,    5,      -27,   17,   -8,
      -8,    6,  -21,       11,   -4,  -35,       30,  -14,  -48,       49,  -25,  -62,
     -82,   47,   37,      -63,   37,   23,      -43,   26,    9,      -25,   15,   -3,
      -5,    4,  -17,       14,   -5,  -30,       32,  -16,  -44,       52,  -27,  -57,
     -79,   46,   41,      -60,   36,   27,      -41,   25,   13,      -22,   14,    0,
      -3,    3,  -13,       16,   -7,  -26,       35,  -17,  -40,       54,  -28,  -53,
     -77,   45,   45,      -58,   34,   31,      -39,   23,   17,      -20,   13,    4,
       0,    2,   -9,       18,   -8,  -22,       37,  -18,  -36,       57,  -29,  -49,
     -74,   43,   49,      -56,   33,   35,      -36,   22,   21,      -17,   11,    8,
       2,    0,   -5,       21,   -9,  -18,       40,  -20,  -32,       59,  -31,  -45,
     -72,   42,   53,      -53,   31,   40,      -33,   20,   26,      -15,   10,   12,
       5,    0,    0,       23,  -11,  -14,       42,  -21,  -27,       62,  -32,  -41,
     -69,   41,   57,      -50,   30,   44,      -31,   19,   30,      -12,    8,   16,
       7,   -2,    3,       26,  -12,  -10,       45,  -23,  -23,       64,  -34,  -37,
     -67,   39,   61,      -48,   29,   48,      -29,   18,   34,      -10,    7,   20,
       9,   -3,    7,       28,  -13,   -6,       47,  -24,  -19,       66,  -35,  -33,
     -64,   38,   65,      -46,   27,   52,      -26,   16,   38,       -8,    6,   24,
      12,   -4,   11,       31,  -15,   -2,       49,  -25,  -15,       69,  -36,  -29,
     -62,   36,   70,      -43,   26,   56,      -24,   15,   42,       -5,    4,   29,
      15,   -6,   15,       33,  -16,    2,       52,  -27,  -11,       71,  -38,  -24,
     -59,   35,   74,      -41,   24,   60,      -21,   13,   46,       -2,    3,   33,
      17,   -7,   19,       36,  -18,    6,       55,  -28,   -7,       74,  -39,  -20,
     -57,   34,   78,      -38,   23,   64,      -19,   12,   50,        0,    2,   37,
      19,   -8,   23,       38,  -19,   10,       57,  -30,   -3,       76,  -41,  -16,
     -55,   32,   82,      -36,   22,   68,      -16,   11,   54,        2,    0,   41,
      22,  -10,   27,       41,  -20,   14,       59,  -31,    0,       79,  -42,  -12,
     -52,   31,   86,      -33,   20,   72,      -14,    9,   58,        5,    0,   45,
      24,  -11,   31,       43,  -22,   18,       62,  -32,    4,       81,  -43,   -8,
     -50,   29,   90,      -31,   19,   77,      -11,    8,   63,        7,   -2,   49,
      27,  -13,   36,       46,  -23,   22,       64,  -34,    9,       84,  -45,   -4,
     -47,   28,   94,      -28,   17,   81,       -9,    7,   67,       10,   -3,   53,
      29,  -14,   40,       48,  -25,   26,       67,  -35,   13,       86,  -46,    0,
     -45,   27,   98,      -26,   16,   85,       -7,    5,   71,       12,   -4,   57,
      32,  -15,   44,       50,  -26,   30,       69,  -37,   17,       89,  -47,    3,
     -42,   25,  102,      -24,   15,   89,       -4,    4,   75,       15,   -6,   61,
      34,  -17,   48,       53,  -27,   34,       72,  -38,   21,       91,  -49,    7,
     -40,   24,  107,      -21,   13,   93,       -1,    2,   79,       17,   -7,   66,
      37,  -18,   52,       55,  -29,   39,       74,  -39,   25,       94,  -50,   12,
     -37,   22,  111,      -18,   12,   97,        1,    1,   83,       20,   -9,   70,
      39,  -20,   56,       58,  -30,   43,       77,  -41,   29,       96,  -52,   16,
     -35,   21,  115,      -16,   11,  101,        3,    0,   87,       22,  -10,   74,
      41,  -21,   60,       60,  -32,   47,       79,  -42,   33,       98,  -53,   20,
    -110,   68,  -13,      -91,   58,  -26,      -72,   47,  -40,      -53,   36,  -53,
     -34,   25,  -67,      -15,   15,  -80,        4,    4,  -94,       23,   -6, -108,
    -108,   67,   -9,      -89,   56,  -22,      -70,   45,  -36,      -51,   35,  -49,
     -31,   24,  -63,      -13,   13,  -76,        6,    3,  -90,       25,   -7, -104,
    -105,   65,   -5,      -87,   55,  -18,      -67,   44,  -32,      -48,   33,  -45,
     -29,   22,  -59,      -10,   12,  -72,        8,    1,  -86,       28,   -9, -100,
    -103,   64,    0,      -84,   53,  -13,      -65,   42,  -27,      -46,   32,  -41,
     -26,   21,  -54,       -8,   10,  -68,       11,    0,  -81,       31,  -10,  -95,
    -100,   63,    3,      -82,   52,   -9,      -62,   41,  -23,      -43,   30,  -37,
     -24,   20,  -50,       -5,    9,  -64,       14,   -1,  -77,       33,  -12,  -91,
     -98,   61,    7,      -79,   51,   -5,      -60,   40,  -19,      -41,   29,  -33,
     -22,   18,  -46,       -3,    8,  -60,       16,   -2,  -73,       35,  -13,  -87,
     -96,   60,   11,      -77,   49,   -1,      -57,   38,  -15,      -39,   28,  -29,
     -19,   17,  -42,        0,    6,  -56,       18,   -3,  -69,       38,  -14,  -83,
     -93,   58,   15,      -74,   48,    2,      -55,   37,  -11,      -36,   26,  -24,
     -17,   15,  -38,        2,    5,  -51,       21,   -5,  -65,       40,  -16,  -79,
     -90,   57,   19,      -72,   46,    6,      -52,   36,   -7,      -34,   25,  -20,
     -14,   14,  -34,        5,    3,  -47,       23,   -6,  -61,       43,  -17,  -75,
     -88,   56,   23,      -69,   45,   10,      -50,   34,   -3,      -31,   24,  -16,
     -12,   13,  -30,        7,    2,  -43,       26,   -8,  -57,       45,  -19,  -71,
     -86,   54,   27,      -67,   44,   14,      -48,   33,    0,      -29,   22,  -12,
      -9,   11,  -26,        9,    1,  -39,       28,   -9,  -53,       48,  -20,  -67,
     -83,   53,   31,      -64,   42,   18,      -45,   31,    4,      -26,   21,   -8,
      -7,   10,  -22,       12,    0,  -35,       31,  -10,  -49,       50,  -21,  -63,
     -81,   51,   36,      -62,   41,   23,      -42,   30,    9,      -24,   19,   -4,
      -4,    8,  -17,       15,   -1,  -31,       33,  -12,  -44,       53,  -23,  -58,
     -78,   50,   40,      -59,   40,   27,      -40,   29,   13,      -21,   18,    0,
      -2,    7,  -13,       17,   -3,  -27,       36,  -13,  -40,       55,  -24,  -54,
     -76,   49,   44,      -57,   38,   31,      -38,   27,   17,      -19,   17,    3,
       1,    6,   -9,       19,   -4,  -23,       38,  -14,  -36,       57,  -25,  -50,
     -73,   47,   48,      -55,   37,   35,      -35,   26,   21,      -16,   15,    7,
       3,    4,   -5,       22,   -5,  -19,       40,  -16,  -32,       60,  -27,  -46,
     -71,   46,   52,      -52,   35,   39,      -33,   24,   25,      -14,   14,   12,
       6,    3,   -1,       24,   -7,  -14,       43,  -17,  -28,       63,  -28,  -42,
     -68,   45,   56,      -50,   34,   43,      -30,   23,   29,      -11,   12,   16,
       8,    1,    2,       27,   -8,  -10,       46,  -19,  -24,       65,  -30,  -38,
     -66,   43,   60,      -47,   33,   47,      -28,   22,   33,       -9,   11,   20,
      10,    0,    6,       29,   -9,   -6,       48,  -20,  -20,       67,  -31,  -34,
     -64,   42,   64,      -45,   31,   51,      -25,   20,   37,       -7,   10,   24,
      13,    0,   10,       32,  -11,   -2,       50,  -21,  -16,       70,  -32,  -30,
     -61,   40,   69,      -42,   30,   56,      -23,   19,   42,       -4,    8,   28,
      15,   -2,   15,       34,  -12,    1,       53,  -23,  -11,       72,  -34,  -25,
     -58,   39,   73,      -40,   28,   60,      -20,   17,   46,       -2,    7,   32,
      18,   -3,   19,       37,  -14,    5,       55,  -24,   -7,       75,  -35,  -21,
     -56,   38,   77,      -37,   27,   64,      -18,   16,   50,        1,    6,   36,
      20,   -4,   23,       39,  -15,    9,       58,  -26,   -3,       77,  -37,  -17,
     -54,   36,   81,      -35,   26,   68,      -16,   15,   54,        3,    4,   40,
      23,   -6,   27,       41,  -16,   13,       60,  -27,    0,       80,  -38,  -13,
     -51,   35,   85,      -33,   24,   72,      -13,   13,   58,        6,    3,   44,
      25,   -7,   31,       44,  -18,   17,       63,  -28,    4,       82,  -39,   -9,
     -49,   33,   89,      -30,   23,   76,      -10,   12,   62,        8,    1,   49,
      28,   -9,   35,       46,  -19,   22,       65,  -30,    8,       85,  -41,   -5,
     -46,   32,   93,      -27,   21,   80,       -8,   11,   66,       11,    0,   53,
      30,  -10,   39,       49,  -21,   26,       68,  -31,   12,       87,  -42,   -1,
     -44,   31,   97,      -25,   20,   84,       -6,    9,   70,       13,    0,   57,
      32,  -11,   43,       51,  -22,   30,       70,  -33,   16,       89,  -43,    2,
     -41,   29,  101,      -23,   19,   88,       -3,    8,   74,       16,   -2,   61,
      35,  -13,   47,       54,  -23,   34,       72,  -34,   20,       92,  -45,    6,
     -39,   28,  106,      -20,   17,   93,       -1,    6,   79,       18,   -3,   65,
      38,  -14,   52,       56,  -25,   38,       75,  -35,   25,       95,  -46,   11,
     -36,   26,  110,      -18,   16,   97,        2,    5,   83,       21,   -5,   69,
      40,  -16,   56,       59,  -26,   42,       78,  -37,   29,       97,  -48,   15,
     -34,   25,  114,      -15,   15,  101,        4,    4,   87,       23,   -6,   73,
      42,  -17,   60,       61,  -28,   46,       80,  -38,   33,       99,  -49,   19,
    -109,   72,  -13,      -90,   62,  -27,      -71,   51,  -40,      -52,   40,  -54,
     -33,   29,  -68,      -14,   19,  -81,        5,    8,  -94,       24,   -2, -108,
    -107,   71,   -9,      -88,   60,  -23,      -69,   49,  -36,      -50,   39,  -50,
     -31,   28,  -64,      -12,   17,  -77,        7,    7,  -90,       26,   -3, -104,
    -104,   69,   -5,      -86,   59,  -19,      -66,   48,  -32,      -48,   37,  -46,
     -28,   26,  -60,       -9,   16,  -73,        9,    5,  -86,       29,   -5, -100,
    -102,   68,   -1,      -83,   57,  -14,      -64,   46,  -28,      -45,   36,  -41,
     -25,   25,  -55,       -7,   14,  -69,       12,    4,  -82,       31,   -6,  -96,
     -99,   67,    2,      -81,   56,  -10,      -61,   45,  -24,      -42,   34,  -37,
     -23,   24,  -51,       -4,   13,  -65,       14,    2,  -78,       34,   -8,  -92,
     -97,   65,    6,      -78,   55,   -6,      -59,   44,  -20,      -40,   33,  -33,
     -21,   22,  -47,       -2,   12,  -61,       17,    1,  -74,       36,   -9,  -88,
     -95,   64,   10,      -76,   53,   -2,      -56,   42,  -16,      -38,   32,  -29,
     -18,   21,  -43,        0,   10,  -57,       19,    0,  -70,       39,  -10,  -84,
     -92,   62,   15,      -73,   52,    1,      -54,   41,  -11,      -35,   30,  -25,
     -16,   19,  -39,        3,    9,  -52,       22,   -1,  -65,       41,  -12,  -79,
     -90,   61,   19,      -71,   50,    5,      -51,   40,   -7,      -33,   29,  -21,
     -13,   18,  -35,        6,    7,  -48,       24,   -2,  -61,       44,  -13,  -75,
     -87,   60,   23,      -68,   49,    9,      -49,   38,   -3,      -30,   28,  -17,
     -11,   17,  -31,        8,    6,  -44,       27,   -4,  -57,       46,  -15,  -71,
     -85,   58,   27,      -66,   48,   13,      -47,   37,    0,      -28,   26,  -13,
      -8,   15,  -27,       10,    5,  -40,       29,   -5,  -53,       48,  -16,  -67,
     -82,   57,   31,      -64,   46,   17,      -44,   35,    4,      -25,   25,   -9,
      -6,   14,  -23,       13,    3,  -36,       32,   -6,  -49,       51,  -17,  -63,
     -80,   55,   35,      -61,   45,   22,      -42,   34,    8,      -23,   23,   -4,
      -3,   12,  -18,       15,    2,  -32,       34,   -8,  -45,       54,  -19,  -59,
     -77,   54,   39,      -59,   44,   26,      -39,   33,   12,      -20,   22,    0,
      -1,   11,  -14,       18,    0,  -28,       37,   -9,  -41,       56,  -20,  -55,
     -75,   53,   43,      -56,   42,   30,      -37,   31,   16,      -18,   21,    3,
       1,   10,  -10,       20,    0,  -24,       39,  -10,  -37,       58,  -21,  -51,
     -73,   51,   47,      -54,   41,   34,      -34,   30,   20,      -16,   19,    7,
       4,    8,   -6,       23,   -1,  -20,       41,  -12,  -33,       61,  -23,  -47,
     -70,   50,   52,      -51,   39,   38,      -32,   28,   25,      -13,   18,   11,
       6,    7,   -2,       25,   -3,  -15,       44,  -13,  -28,       63,  -24,  -42,
     -67,   49,   56,      -49,   38,   42,      -29,   27,   29,      -10,   16,   15,
       9,    5,    1,       28,   -4,  -11,       46,  -15,  -24,       66,  -26,  -38,
     -65,   47,   60,      -46,   37,   46,      -27,   26,   33,       -8,   15,   19,
      11,    4,    5,       30,   -5,   -7,       49,  -16,  -20,       68,  -27,  -34,
     -63,   46,   64,      -44,   35,   50,      -24,   24,   37,       -6,   14,   23,
      14,    3,    9,       32,   -7,   -3,       51,  -17,  -16,       71,  -28,  -30,
     -60,   44,   68,      -41,   34,   55,      -22,   23,   41,       -3,   12,   28,
      16,    1,   14,       35,   -8,    0,       54,  -19,  -12,       73,  -30,  -26,
     -58,   43,   72,      -39,   32,   59,      -19,   21,   45,       -1,   11,   32,
      19,    0,   18,       38,  -10,    4,       56,  -20,   -8,       76,  -31,  -22,
     -55,   42,   76,      -36,   31,   63,      -17,   20,   49,        2,   10,   36,
      21,    0,   22,       40,  -11,    8,       59,  -22,   -4,       78,  -33,  -18,
     -53,   40,   80,      -34,   30,   67,      -15,   19,   53,        4,    8,   40,
      24,   -2,   26,       42,  -12,   12,       61,  -23,    0,       80,  -34,  -14,
     -50,   39,   84,      -32,   28,   71,      -12,   17,   57,        7,    7,   44,
      26,   -3,   30,       45,  -14,   16,       64,  -24,    3,       83,  -35,  -10,
     -48,   37,   89,      -29,   27,   75,      -10,   16,   62,        9,    5,   48,
      29,   -5,   34,       47,  -15,   21,       66,  -26,    8,       86,  -37,   -5,
     -45,   36,   93,      -27,   25,   79,       -7,   15,   66,       12,    4,   52,
      31,   -6,   38,       50,  -17,   25,       69,  -27,   12,       88,  -38,   -1,
     -43,   35,   97,      -24,   24,   83,       -5,   13,   70,       14,    3,   56,
      33,   -7,   42,       52,  -18,   29,       71,  -29,   16,       90,  -39,    2,
     -41,   33,  101,      -22,   23,   87,       -2,   12,   74,       16,    1,   60,
      36,   -9,   46,       55,  -19,   33,       73,  -30,   20,       93,  -41,    6,
     -38,   32,  105,      -19,   21,   92,        0,   10,   78,       19,    0,   65,
      38,  -10,   51,       57,  -21,   37,       76,  -31,   24,       95,  -42,   10,
     -35,   30,  109,      -17,   20,   96,        3,    9,   82,       22,   -1,   69,
      41,  -12,   55,       60,  -22,   41,       78,  -33,   28,       98,  -44,   14,
     -33,   29,  113,      -14,   19,  100,        5,    8,   86,       24,   -2,   73,
      43,  -13,   59,       62,  -24,   45,       81,  -34,   32,      100,  -45,   18,
    -108,   76,  -14,      -90,   66,  -27,      -70,   55,  -41,      -51,   44,  -54,
     -32,   33,  -68,      -13,   23,  -82,        6,   12,  -95,       25,    1, -109,
    -106,   75,  -10,      -87,   64,  -23,      -68,   53,  -37,      -49,   43,  -50,
     -30,   32,  -64,      -11,   21,  -78,        8,   11,  -91,       27,    0, -105,
    -104,   73,   -6,      -85,   63,  -19,      -65,   52,  -33,      -47,   41,  -46,
     -27,   30,  -60,       -8,   20,  -74,       10,    9,  -87,       30,   -1, -101,
    -101,   72,   -1,      -82,   61,  -15,      -63,   50,  -29,      -44,   40,  -42,
     -25,   29,  -56,       -6,   18,  -69,       13,    8,  -83,       32,   -2,  -96,
     -99,   71,    2,      -80,   60,  -11,      -60,   49,  -25,      -42,   38,  -38,
     -22,   28,  -52,       -3,   17,  -65,       15,    6,  -79,       35,   -4,  -92,
     -96,   69,    6,      -77,   59,   -7,      -58,   48,  -21,      -39,   37,  -34,
     -20,   26,  -48,       -1,   16,  -61,       18,    5,  -75,       37,   -5,  -88,
     -94,   68,   10,      -75,   57,   -3,      -56,   46,  -17,      -37,   36,  -30,
     -17,   25,  -44,        1,   14,  -57,       20,    4,  -71,       40,   -6,  -84,
     -91,   66,   14,      -72,   56,    1,      -53,   45,  -12,      -34,   34,  -25,
     -15,   23,  -39,        4,   13,  -53,       23,    2,  -66,       42,   -8,  -80,
     -89,   65,   18,      -70,   54,    5,      -50,   44,   -8,      -32,   33,  -21,
     -12,   22,  -35,        6,   11,  -49,       25,    1,  -62,       45,   -9,  -76,
     -86,   64,   22,      -67,   53,    9,      -48,   42,   -4,      -29,   32,  -17,
     -10,   21,  -31,        9,   10,  -45,       28,    0,  -58,       47,  -11,  -72,
     -84,   62,   26,      -65,   52,   13,      -46,   41,    0,      -27,   30,  -13,
      -8,   19,  -27,       11,    9,  -41,       30,   -1,  -54,       49,  -12,  -68,
     -81,   61,   30,      -63,   50,   17,      -43,   39,    3,      -25,   29,   -9,
      -5,   18,  -23,       14,    7,  -37,       32,   -2,  -50,       52,  -13,  -64,
     -79,   59,   35,      -60,   49,   21,      -41,   38,    7,      -22,   27,   -5,
      -2,   16,  -19,       16,    6,  -32,       35,   -4,  -46,       54,  -15,  -59,
     -76,   58,   39,      -58,   48,   25,      -38,   37,   11,      -19,   26,   -1,
       0,   15,  -15,       19,    4,  -28,       38,   -5,  -42,       57,  -16,  -55,
     -74,   57,   43,      -55,   46,   29,      -36,   35,   15,      -17,   25,    2,
       2,   14,  -11,       21,    3,  -24,       40,   -6,  -38,       59,  -17,  -51,
     -72,   55,   47,      -53,   45,   33,      -33,   34,   19,      -15,   23,    6,
       5,   12,   -7,       24,    2,  -20,       42,   -8,  -34,       62,  -19,  -47,
     -69,   54,   51,      -50,   43,   38,      -31,   32,   24,      -12,   22,   11,
       7,   11,   -2,       26,    0,  -16,       45,   -9,  -29,       64,  -20,  -43,
     -67,   53,   55,      -48,   42,   42,      -28,   31,   28,      -10,   20,   15,
      10,    9,    1,       29,    0,  -12,       47,  -11,  -25,       67,  -22,  -39,
     -64,   51,   59,      -45,   41,   46,      -26,   30,   32,       -7,   19,   19,
      12,    8,    5,       31,   -1,   -8,       50,  -12,  -21,       69,  -23,  -35,
     -62,   50,   63,      -43,   39,   50,      -24,   28,   36,       -5,   18,   23,
      15,    7,    9,       33,   -3,   -4,       52,  -13,  -17,       72,  -24,  -31,
     -59,   48,   68,      -40,   38,   54,      -21,   27,   40,       -2,   16,   27,
      17,    5,   13,       36,   -4,    0,       55,  -15,  -13,       74,  -26,  -26,
     -57,   47,   72,      -38,   36,   58,      -18,   25,   44,        0,   15,   31,
      20,    4,   17,       38,   -6,    4,       57,  -16,   -9,       77,  -27,  -22,
     -54,   46,   76,      -35,   35,   62,      -16,   24,   48,        3,   14,   35,
      22,    3,   21,       41,   -7,    8,       60,  -18,   -5,       79,  -29,  -18,
     -52,   44,   80,      -33,   34,   66,      -14,   23,   52,        5,   12,   39,
      24,    1,   25,       43,   -8,   12,       62,  -19,   -1,       81,  -30,  -14,
     -49,   43,   84,      -31,   32,   70,      -11,   21,   56,        7,   11,   43,
      27,    0,   29,       46,  -10,   16,       64,  -20,    2,       84,  -31,  -10,
     -47,   41,   88,      -28,   31,   75,       -9,   20,   61,       10,    9,   48,
      30,   -1,   34,       48,  -11,   20,       67,  -22,    7,       86,  -33,   -6,
     -44,   40,   92,      -26,   29,   79,       -6,   19,   65,       13,    8,   52,
      32,   -2,   38,       51,  -13,   24,       69,  -23,   11,       89,  -34,   -2,
     -42,   39,   96,      -23,   28,   83,       -4,   17,   69,       15,    7,   56,
      34,   -3,   42,       53,  -14,   28,       72,  -25,   15,       91,  -35,    1,
     -40,   37,  100,      -21,   27,   87,       -1,   16,   73,       17,    5,   60,
      37,   -5,   46,       55,  -15,   32,       74,  -26,   19,       94,  -37,    5,
     -37,   36,  105,      -18,   25,   91,        1,   14,   77,       20,    4,   64,
      39,   -6,   50,       58,  -17,   37,       77,  -27,   23,       96,  -38,   10,
     -35,   34,  109,      -16,   24,   95,        4,   13,   81,       22,    2,   68,
      42,   -8,   54,       61,  -18,   41,       79,  -29,   27,       99,  -40,   14,
     -32,   33,  113,      -13,   23,   99,        6,   12,   85,       25,    1,   72,
      44,   -9,   58,       63,  -20,   45,       82,  -30,   31,      101,  -41,   18,
    -107,   81,  -15,      -89,   70,  -28,      -69,   59,  -42,      -50,   49,  -55,
     -31,   38,  -69,      -12,   27,  -82,        7,   16,  -96,       26,    5, -110,
    -105,   79,  -11,      -86,   69,  -24,      -67,   58,  -38,      -48,   47,  -51,
     -29,   36,  -65,      -10,   26,  -78,        9,   15,  -92,       28,    4, -106,
    -103,   78,   -7,      -84,   67,  -20,      -64,   56,  -34,      -46,   46,  -47,
     -26,   35,  -61,       -7,   24,  -74,       11,   14,  -88,       31,    3, -102,
    -100,   76,   -2,      -81,   66,  -15,      -62,   55,  -29,      -43,   44,  -43,
     -24,   33,  -57,       -5,   23,  -70,       14,   12,  -83,       33,    1,  -97,
     -97,   75,    1,      -79,   65,  -11,      -59,   54,  -25,      -41,   43,  -39,
     -21,   32,  -53,       -2,   21,  -66,       16,   11,  -79,       36,    0,  -93,
     -95,   74,    5,      -76,   63,   -7,      -57,   52,  -21,      -38,   42,  -35,
     -19,   31,  -49,        0,   20,  -62,       19,    9,  -75,       38,    0,  -89,
     -93,   72,    9,      -74,   62,   -3,      -55,   51,  -17,      -36,   40,  -31,
     -16,   29,  -45,        2,   19,  -58,       21,    8,  -71,       41,   -2,  -85,
     -90,   71,   13,      -71,   60,    0,      -52,   49,  -13,      -33,   39,  -26,
     -14,   28,  -40,        5,   17,  -53,       24,    7,  -67,       43,   -3,  -81,
     -88,   70,   17,      -69,   59,    4,      -49,   48,   -9,      -31,   37,  -22,
     -11,   26,  -36,        7,   16,  -49,       26,    5,  -63,       46,   -5,  -77,
     -85,   68,   21,      -66,   58,    8,      -47,   47,   -5,      -28,   36,  -18,
      -9,   25,  -32,       10,   15,  -45,       29,    4,  -59,       48,   -6,  -73,
     -83,   67,   25,      -64,   56,   12,      -45,   45,   -1,      -26,   35,  -14,
      -7,   24,  -28,       12,   13,  -41,       31,    3,  -55,       50,   -7,  -69,
     -80,   65,   29,      -62,   55,   16,      -42,   44,    2,      -23,   33,  -10,
      -4,   22,  -24,       15,   12,  -37,       33,    1,  -51,       53,   -9,  -65,
     -78,   64,   34,      -59,   53,   21,      -40,   42,    7,      -21,   32,   -6,
      -1,   21,  -20,       17,   10,  -33,       36,    0,  -46,       56,  -10,  -60,
     -75,   63,   38,      -57,   52,   25,      -37,   41,   11,      -18,   30,   -2,
       1,   20,  -16,       20,    9,  -29,       39,   -1,  -42,       58,  -12,  -56,
     -73,   61,   42,      -54,   51,   29,      -35,   40,   15,      -16,   29,    1,
       3,   18,  -12,       22,    8,  -25,       41,   -2,  -38,       60,  -13,  -52,
     -71,   60,   46,      -52,   49,   33,      -32,   38,   19,      -14,   28,    5,
       6,   17,   -8,       25,    6,  -21,       43,   -3,  -34,       63,  -14,  -48,
     -68,   58,   50,      -49,   48,   37,      -30,   37,   23,      -11,   26,   10,
       8,   15,   -3,       27,    5,  -16,       46,   -5,  -30,       65,  -16,  -44,
     -65,   57,   54,      -47,   46,   41,      -27,   36,   27,       -9,   25,   14,
      11,   14,    0,       30,    3,  -12,       48,   -6,  -26,       68,  -17,  -40,
     -63,   56,   58,      -44,   45,   45,      -25,   34,   31,       -6,   24,   18,
      13,   13,    4,       32,    2,   -8,       51,   -8,  -22,       70,  -18,  -36,
     -61,   54,   62,      -42,   44,   49,      -23,   33,   35,       -4,   22,   22,
      16,   11,    8,       34,    1,   -4,       53,   -9,  -18,       73,  -20,  -32,
     -58,   53,   67,      -39,   42,   54,      -20,   31,   40,       -1,   21,   26,
      18,   10,   12,       37,    0,    0,       56,  -10,  -13,       75,  -21,  -27,
     -56,   51,   71,      -37,   41,   58,      -17,   30,   44,        1,   19,   30,
      21,    8,   16,       39,   -1,    3,       58,  -12,   -9,       78,  -23,  -23,
     -53,   50,   75,      -34,   40,   62,      -15,   29,   48,        4,   18,   34,
      23,    7,   20,       42,   -3,    7,       61,  -13,   -5,       80,  -24,  -19,
     -51,   49,   79,      -32,   38,   66,      -13,   27,   52,        6,   17,   38,
      25,    6,   24,       44,   -4,   11,       63,  -14,   -1,       82,  -25,  -15,
     -48,   47,   83,      -30,   37,   70,      -10,   26,   56,        9,   15,   42,
      28,    4,   28,       47,   -5,   15,       65,  -16,    2,       85,  -27,  -11,
     -46,   46,   87,      -27,   35,   74,       -8,   24,   60,       11,   14,   47,
      31,    3,   33,       49,   -7,   20,       68,  -17,    6,       88,  -28,   -7,
     -43,   45,   91,      -25,   34,   78,       -5,   23,   64,       14,   12,   51,
      33,    2,   37,       52,   -8,   24,       71,  -19,   10,       90,  -30,   -3,
     -41,   43,   95,      -22,   33,   82,       -3,   22,   68,       16,   11,   55,
      35,    0,   41,       54,   -9,   28,       73,  -20,   14,       92,  -31,    0,
     -39,   42,   99,      -20,   31,   86,        0,   20,   72,       18,   10,   59,
      38,    0,   45,       57,  -11,   32,       75,  -21,   18,       95,  -32,    4,
     -36,   40,  104,      -17,   30,   91,        2,   19,   77,       21,    8,   63,
      40,   -2,   49,       59,  -12,   36,       78,  -23,   23,       97,  -34,    9,
     -33,   39,  108,      -15,   28,   95,        5,   17,   81,       23,    7,   67,
      43,   -3,   53,       62,  -14,   40,       80,  -24,   27,      100,  -35,   13,
     -31,   38,  112,      -12,   27,   99,        7,   16,   85,       26,    6,   71,
      45,   -4,   57,       64,  -15,   44,       83,  -26,   31,      102,  -37,   17,
    -106,   85,  -15,      -88,   74,  -29,      -68,   63,  -42,      -49,   53,  -56,
     -30,   42,  -70,      -11,   31,  -83,        7,   20,  -96,       27,    9, -110,
    -104,   83,  -11,      -85,   73,  -25,      -66,   62,  -38,      -47,   51,  -52,
     -28,   40,  -66,       -9,   30,  -79,       10,   19,  -92,       29,    8, -106,
    -102,   82,   -7,      -83,   71,  -21,      -63,   60,  -34,      -45,   50,  -48,
     -25,   39,  -62,       -7,   28,  -75,       12,   18,  -88,       32,    7, -102,
     -99,   80,   -3,      -80,   70,  -16,      -61,   59,  -30,      -42,   48,  -43,
     -23,   37,  -57,       -4,   27,  -71,       15,   16,  -84,       34,    5,  -98,
     -97,   79,    0,      -78,   69,  -12,      -58,   58,  -26,      -40,   47,  -39,
     -20,   36,  -53,       -1,   25,  -67,       17,   15,  -80,       37,    4,  -94,
     -94,   78,    4,      -75,   67,   -8,      -56,   56,  -22,      -37,   46,  -35,
     -18,   35,  -49,        1,   24,  -63,       20,   13,  -76,       39,    3,  -90,
     -92,   76,    8,      -73,   66,   -4,      -54,   55,  -18,      -35,   44,  -31,
     -15,   33,  -45,        3,   23,  -59,       22,   12,  -72,       41,    1,  -86,
     -89,   75,   13,      -70,   64,    0,      -51,   53,  -13,      -32,   43,  -27,
     -13,   32,  -41,        6,   21,  -54,       25,   11,  -67,       44,    0,  -81,
     -87,   74,   17,      -68,   63,    3,      -49,   52,   -9,      -30,   41,  -23,
     -10,   30,  -37,        8,   20,  -50,       27,    9,  -63,       47,   -1,  -77,
     -84,   72,   21,      -66,   62,    7,      -46,   51,   -5,      -27,   40,  -19,
      -8,   29,  -33,       11,   19,  -46,       30,    8,  -59,       49,   -2,  -73,
     -82,   71,   25,      -63,   60,   11,      -44,   49,   -1,      -25,   39,  -15,
      -6,   28,  -29,       13,   17,  -42,       32,    7,  -55,       51,   -3,  -69,
     -80,   69,   29,      -61,   59,   15,      -41,   48,    2,      -23,   37,  -11,
      -3,   26,  -25,       16,   16,  -38,       34,    5,  -51,       54,   -5,  -65,
     -77,   68,   33,      -58,   57,   20,      -39,   46,    6,      -20,   36,   -6,
      -1,   25,  -20,       18,   14,  -34,       37,    4,  -47,       56,   -6,  -61,
     -74,   67,   37,      -56,   56,   24,      -36,   45,   10,      -17,   34,   -2,
       2,   24,  -16,       21,   13,  -30,       39,    2,  -43,       59,   -8,  -57,
     -72,   65,   41,      -53,   55,   28,      -34,   44,   14,      -15,   33,    1,
       4,   22,  -12,       23,   12,  -26,       42,    1,  -39,       61,   -9,  -53,
     -70,   64,   45,      -51,   53,   32,      -31,   42,   18,      -13,   32,    5,
       7,   21,   -8,       25,   10,  -22,       44,    0,  -35,       64,  -10,  -49,
     -67,   62,   50,      -48,   52,   36,      -29,   41,   23,      -10,   30,    9,
       9,   19,   -4,       28,    9,  -17,       47,   -1,  -30,       66,  -12,  -44,
     -65,   61,   54,      -46,   50,   40,      -26,   40,   27,       -8,   29,   13,
      12,   18,    0,       31,    7,  -13,       49,   -2,  -26,       69,  -13,  -40,
     -62,   60,   58,      -43,   49,   44,      -24,   38,   31,       -5,   28,   17,
      14,   17,    3,       33,    6,   -9,       52,   -4,  -22,       71,  -14,  -36,
     -60,   58,   62,      -41,   48,   48,      -22,   37,   35,       -3,   26,   21,
      17,   15,    7,       35,    5,   -5,       54,   -5,  -18,       73,  -16,  -32,
     -57,   57,   66,      -38,   46,   53,      -19,   35,   39,        0,   25,   26,
      19,   14,   12,       38,    3,   -1,       57,   -6,  -14,       76,  -17,  -28,
     -55,   55,   70,      -36,   45,   57,      -17,   34,   43,        2,   23,   30,
      22,   12,   16,       40,    2,    2,       59,   -8,  -10,       79,  -19,  -24,
     -52,   54,   74,      -34,   44,   61,      -14,   33,   47,        5,   22,   34,
      24,   11,   20,       43,    0,    6,       62,   -9,   -6,       81,  -20,  -20,
     -50,   53,   78,      -31,   42,   65,      -12,   31,   51,        7,   21,   38,
      26,   10,   24,       45,    0,   10,       64,  -10,   -2,       83,  -21,  -16,
     -48,   51,   82,      -29,   41,   69,       -9,   30,   55,        9,   19,   42,
      29,    8,   28,       48,   -1,   14,       66,  -12,    1,       86,  -23,  -12,
     -45,   50,   87,      -26,   39,   73,       -7,   28,   60,       12,   18,   46,
      31,    7,   32,       50,   -3,   19,       69,  -13,    6,       88,  -24,   -7,
     -42,   49,   91,      -24,   38,   77,       -4,   27,   64,       14,   16,   50,
      34,    6,   36,       53,   -4,   23,       71,  -15,   10,       91,  -26,   -3,
     -40,   47,   95,      -21,   37,   81,       -2,   26,   68,       17,   15,   54,
      36,    4,   40,       55,   -5,   27,       74,  -16,   14,       93,  -27,    0,
     -38,   46,   99,      -19,   35,   85,        0,   24,   72,       19,   14,   58,
      39,    3,   44,       57,   -7,   31,       76,  -17,   18,       96,  -28,    4,
     -35,   44,  103,      -16,   34,   90,        3,   23,   76,       22,   12,   63,
      41,    1,   49,       60,   -8,   35,       79,  -19,   22,       98,  -30,    8,
     -33,   43,  107,      -14,   32,   94,        6,   21,   80,       24,   11,   67,
      44,    0,   53,       63,  -10,   39,       81,  -20,   26,      101,  -31,   12,
     -30,   42,  111,      -11,   31,   98,        8,   20,   84,       27,   10,   71,
      46,    0,   57,       65,  -11,   43,       84,  -22,   30,      103,  -33,   16,
    -106,   89,  -16,      -87,   78,  -29,      -67,   67,  -43,      -49,   57,  -57,
     -29,   46,  -70,      -10,   35,  -84,        8,   24,  -97,       28,   13, -111,
    -103,   87,  -12,      -84,   77,  -25,      -65,   66,  -39,      -46,   55,  -53,
     -27,   44,  -66,       -8,   34,  -80,       11,   23,  -93,       30,   12, -107,
    -101,   86,   -8,      -82,   75,  -21,      -63,   64,  -35,      -44,   54,  -49,
     -24,   43,  -62,       -6,   32,  -76,       13,   22,  -89,       33,   11, -103,
     -98,   84,   -3,      -79,   74,  -17,      -60,   63,  -31,      -41,   52,  -44,
     -22,   41,  -58,       -3,   31,  -71,       16,   20,  -85,       35,    9,  -98,
     -96,   83,    0,      -77,   73,  -13,      -57,   62,  -27,      -39,   51,  -40,
     -19,   40,  -54,       -1,   29,  -67,       18,   19,  -81,       38,    8,  -94,
     -93,   82,    4,      -74,   71,   -9,      -55,   60,  -23,      -36,   50,  -36,
     -17,   39,  -50,        2,   28,  -63,       21,   17,  -77,       40,    7,  -90,
     -91,   80,    8,      -72,   70,   -5,      -53,   59,  -19,      -34,   48,  -32,
     -15,   37,  -46,        4,   27,  -59,       23,   16,  -73,       42,    5,  -86,
     -88,   79,   12,      -69,   68,    0,      -50,   57,  -14,      -31,   47,  -28,
     -12,   36,  -41,        7,   25,  -55,       26,   15,  -68,       45,    4,  -82,
     -86,   78,   16,      -67,   67,    3,      -48,   56,  -10,      -29,   45,  -24,
      -9,   34,  -37,        9,   24,  -51,       28,   13,  -64,       47,    2,  -78,
     -83,   76,   20,      -65,   66,    7,      -45,   55,   -6,      -26,   44,  -20,
      -7,   33,  -33,       12,   23,  -47,       30,   12,  -60,       50,    1,  -74,
     -81,   75,   24,      -62,   64,   11,      -43,   53,   -2,      -24,   43,  -16,
      -5,   32,  -29,       14,   21,  -43,       33,   11,  -56,       52,    0,  -70,
     -79,   73,   28,      -60,   63,   15,      -40,   52,    1,      -22,   41,  -12,
      -2,   30,  -25,       16,   20,  -39,       35,    9,  -52,       55,   -1,  -66,
     -76,   72,   33,      -57,   61,   19,      -38,   50,    5,      -19,   40,   -7,
       0,   29,  -21,       19,   18,  -34,       38,    8,  -48,       57,   -2,  -61,
     -74,   71,   37,      -55,   60,   23,      -35,   49,    9,      -17,   38,   -3,
       3,   28,  -17,       22,   17,  -30,       40,    6,  -44,       60,   -4,  -57,
     -71,   69,   41,      -52,   59,   27,      -33,   48,   13,      -14,   37,    0,
       5,   26,  -13,       24,   16,  -26,       43,    5,  -40,       62,   -5,  -53,
     -69,   68,   45,      -50,   57,   31,      -31,   46,   17,      -12,   36,    4,
       8,   25,   -9,       26,   14,  -22,       45,    4,  -36,       65,   -6,  -49,
     -66,   66,   49,      -47,   56,   36,      -28,   45,   22,       -9,   34,    8,
      10,   23,   -4,       29,   13,  -18,       48,    2,  -31,       67,   -8,  -45,
     -64,   65,   53,      -45,   54,   40,      -26,   44,   26,       -7,   33,   12,
      13,   22,    0,       31,   11,  -14,       50,    1,  -27,       70,   -9,  -41,
     -61,   64,   57,      -42,   53,   44,      -23,   42,   30,       -4,   32,   16,
      15,   21,    3,       34,   10,  -10,       53,    0,  -23,       72,  -10,  -37,
     -59,   62,   61,      -40,   52,   48,      -21,   41,   34,       -2,   30,   20,
      17,   19,    7,       36,    9,   -6,       55,   -1,  -19,       74,  -12,  -33,
     -56,   61,   66,      -37,   50,   52,      -18,   39,   38,        1,   29,   25,
      20,   18,   11,       39,    7,   -1,       58,   -2,  -15,       77,  -13,  -28,
     -54,   59,   70,      -35,   49,   56,      -16,   38,   42,        3,   27,   29,
      23,   16,   15,       41,    6,    2,       60,   -4,  -11,       79,  -15,  -24,
     -51,   58,   74,      -33,   48,   60,      -13,   37,   46,        6,   26,   33,
      25,   15,   19,       44,    4,    6,       62,   -5,   -7,       82,  -16,  -20,
     -49,   57,   78,      -30,   46,   64,      -11,   35,   50,        8,   25,   37,
      27,   14,   23,       46,    3,   10,       65,   -6,   -3,       84,  -17,  -16,
     -47,   55,   82,      -28,   45,   68,       -8,   34,   54,       10,   23,   41,
      30,   12,   27,       48,    2,   14,       67,   -8,    0,       87,  -19,  -12,
     -44,   54,   86,      -25,   43,   73,       -6,   32,   59,       13,   22,   45,
      32,   11,   32,       51,    0,   18,       70,   -9,    5,       89,  -20,   -8,
     -42,   53,   90,      -23,   42,   77,       -3,   31,   63,       15,   20,   49,
      35,   10,   36,       54,    0,   22,       72,  -11,    9,       92,  -22,   -4,
     -39,   51,   94,      -20,   41,   81,       -1,   30,   67,       18,   19,   53,
      37,    8,   40,       56,   -1,   26,       75,  -12,   13,       94,  -23,    0,
     -37,   50,   98,      -18,   39,   85,        1,   28,   71,       20,   18,   57,
      40,    7,   44,       58,   -3,   30,       77,  -13,   17,       97,  -24,    3,
     -34,   48,  103,      -15,   38,   89,        4,   27,   75,       23,   16,   62,
      42,    5,   48,       61,   -4,   35,       80,  -15,   21,       99,  -26,    8,
     -32,   47,  107,      -13,   36,   93,        6,   25,   79,       25,   15,   66,
      45,    4,   52,       63,   -6,   39,       82,  -16,   25,      102,  -27,   12,
     -29,   46,  111,      -10,   35,   97,        9,   24,   83,       28,   14,   70,
      47,    3,   56,       66,   -7,   43,       85,  -18,   29,      104,  -29,   16,
    -105,   93,  -17,      -86,   82,  -30,      -66,   71,  -44,      -48,   61,  -57,
     -28,   50,  -71,      -10,   39,  -84,        9,   28,  -98,       29,   17, -112,
    -102,   91,  -13,      -83,   81,  -26,      -64,   70,  -40,      -45,   59,  -53,
     -26,   48,  -67,       -7,   38,  -80,       12,   27,  -94,       31,   16, -108,
    -100,   90,   -9,      -81,   79,  -22,      -62,   68,  -36,      -43,   58,  -49,
     -24,   47,  -63,       -5,   36,  -76,       14,   26,  -90,       33,   15, -104,
     -97,   88,   -4,      -78,   78,  -17,      -59,   67,  -31,      -40,   56,  -45,
     -21,   45,  -58,       -2,   35,  -72,       17,   24,  -85,       36,   13,  -99,
     -95,   87,    0,      -76,   77,  -13,      -57,   66,  -27,      -38,   55,  -41,
     -18,   44,  -54,        0,   33,  -68,       19,   23,  -81,       39,   12,  -95,
     -92,   86,    3,      -74,   75,   -9,      -54,   64,  -23,      -35,   54,  -37,
     -16,   43,  -50,        3,   32,  -64,       22,   21,  -77,       41,   11,  -91,
     -90,   84,    7,      -71,   74,   -5,      -52,   63,  -19,      -33,   52,  -33,
     -14,   41,  -46,        5,   31,  -60,       24,   20,  -73,       43,    9,  -87,
     -87,   83,   11,      -68,   72,   -1,      -49,   61,  -15,      -30,   51,  -28,
     -11,   40,  -42,        8,   29,  -55,       27,   19,  -69,       46,    8,  -83,
     -85,   82,   15,      -66,   71,    2,      -47,   60,  -11,      -28,   49,  -24,
      -9,   38,  -38,       10,   28,  -51,       29,   17,  -65,       48,    6,  -79,
     -82,   80,   19,      -64,   70,    6,      -44,   59,   -7,      -26,   48,  -20,
      -6,   37,  -34,       13,   27,  -47,       31,   16,  -61,       51,    5,  -75,
     -80,   79,   23,      -61,   68,   10,      -42,   57,   -3,      -23,   47,  -16,
      -4,   36,  -30,       15,   25,  -43,       34,   15,  -57,       53,    4,  -71,
     -78,   77,   27,      -59,   67,   14,      -40,   56,    0,      -21,   45,  -12,
      -1,   34,  -26,       17,   24,  -39,       36,   13,  -53,       56,    2,  -67,
     -75,   76,   32,      -56,   65,   19,      -37,   54,    5,      -18,   44,   -8,
       1,   33,  -21,       20,   22,  -35,       39,   12,  -48,       58,    1,  -62,
     -73,   75,   36,      -54,   64,   23,      -34,   53,    9,      -16,   42,   -4,
       4,   32,  -17,       22,   21,  -31,       41,   10,  -44,       61,    0,  -58,
     -70,   73,   40,      -51,   63,   27,      -32,   52,   13,      -13,   41,    0,
       6,   30,  -13,       25,   20,  -27,       44,    9,  -40,       63,   -1,  -54,
     -68,   72,   44,      -49,   61,   31,      -30,   50,   17,      -11,   40,    3,
       8,   29,   -9,       27,   18,  -23,       46,    8,  -36,       65,   -2,  -50,
     -65,   70,   48,      -46,   60,   35,      -27,   49,   21,       -8,   38,    8,
      11,   27,   -5,       30,   17,  -18,       49,    6,  -32,       68,   -4,  -46,
     -63,   69,   52,      -44,   58,   39,      -25,   48,   25,       -6,   37,   12,
      14,   26,   -1,       32,   15,  -14,       51,    5,  -28,       71,   -5,  -42,
     -60,   68,   56,      -42,   57,   43,      -22,   46,   29,       -3,   36,   16,
      16,   25,    2,       35,   14,  -10,       54,    3,  -24,       73,   -6,  -38,
     -58,   66,   60,      -39,   56,   47,      -20,   45,   33,       -1,   34,   20,
      18,   23,    6,       37,   13,   -6,       56,    2,  -20,       75,   -8,  -34,
     -55,   65,   65,      -36,   54,   52,      -17,   43,   38,        2,   33,   24,
      21,   22,   11,       40,   11,   -2,       59,    1,  -15,       78,   -9,  -29,
     -53,   63,   69,      -34,   53,   56,      -15,   42,   42,        4,   31,   28,
      23,   20,   15,       42,   10,    1,       61,    0,  -11,       80,  -11,  -25,
     -50,   62,   73,      -32,   52,   60,      -12,   41,   46,        6,   30,   32,
      26,   19,   19,       45,    8,    5,       63,   -1,   -7,       83,  -12,  -21,
     -48,   61,   77,      -29,   50,   64,      -10,   39,   50,        9,   29,   36,
      28,   18,   23,       47,    7,    9,       66,   -2,   -3,       85,  -13,  -17,
     -46,   59,   81,      -27,   49,   68,       -8,   38,   54,       11,   27,   40,
      31,   16,   27,       49,    6,   13,       68,   -4,    0,       88,  -15,  -13,
     -43,   58,   85,      -24,   47,   72,       -5,   36,   58,       14,   26,   45,
      33,   15,   31,       52,    4,   18,       71,   -5,    4,       90,  -16,   -9,
     -41,   57,   89,      -22,   46,   76,       -2,   35,   62,       16,   24,   49,
      36,   14,   35,       54,    3,   22,       73,   -7,    8,       93,  -18,   -5,
     -38,   55,   93,      -19,   45,   80,        0,   34,   66,       19,   23,   53,
      38,   12,   39,       57,    2,   26,       76,   -8,   12,       95,  -19,   -1,
     -36,   54,   97,      -17,   43,   84,        2,   32,   70,       21,   22,   57,
      40,   11,   43,       59,    0,   30,       78,   -9,   16,       97,  -20,    2,
     -33,   52,  102,      -14,   42,   89,        5,   31,   75,       24,   20,   61,
      43,    9,   48,       62,    0,   34,       81,  -11,   21,      100,  -22,    7,
     -31,   51,  106,      -12,   40,   93,        7,   29,   79,       26,   19,   65,
      46,    8,   52,       64,   -2,   38,       83,  -12,   25,      102,  -23,   11,
     -28,   50,  110,      -10,   39,   97,       10,   28,   83,       29,   18,   69,
      48,    7,   56,       67,   -3,   42,       86,  -14,   29,      105,  -25,   15,
    -104,   97,  -17,      -85,   86,  -31,      -66,   75,  -44,      -47,   65,  -58,
     -27,   54,  -72,       -9,   43,  -85,       10,   32,  -98,       30,   21, -112,
    -101,   95,  -13,      -83,   85,  -27,      -63,   74,  -40,      -44,   63,  -54,
     -25,   52,  -68,       -6,   42,  -81,       13,   31,  -94,       32,   20, -108,
     -99,   94,   -9,      -80,   83,  -23,      -61,   72,  -36,      -42,   62,  -50,
     -23,   51,  -64,       -4,   40,  -77,       15,   30,  -90,       34,   19, -104,
     -96,   92,   -5,      -77,   82,  -18,      -58,   71,  -32,      -39,   60,  -45,
     -20,   49,  -59,       -1,   39,  -73,       18,   28,  -86,       37,   17, -100,
     -94,   91,   -1,      -75,   81,  -14,      -56,   70,  -28,      -37,   59,  -41,
     -18,   48,  -55,        1,   37,  -69,       20,   27,  -82,       39,   16,  -96,
     -91,   90,    2,      -73,   79,  -10,      -53,   68,  -24,      -34,   58,  -37,
     -15,   47,  -51,        4,   36,  -65,       22,   25,  -78,       42,   15,  -92,
     -89,   88,    6,      -70,   78,   -6,      -51,   67,  -20,      -32,   56,  -33,
     -13,   45,  -47,        6,   35,  -61,       25,   24,  -74,       44,   13,  -88,
     -86,   87,   11,      -68,   76,   -2,      -48,   65,  -15,      -29,   55,  -29,
     -10,   44,  -43,        9,   33,  -56,       28,   23,  -69,       47,   12,  -83,
     -84,   86,   15,      -65,   75,    1,      -46,   64,  -11,      -27,   53,  -25,
      -8,   42,  -39,       11,   32,  -52,       30,   21,  -65,       49,   10,  -79,
     -82,   84,   19,      -63,   74,    5,      -43,   63,   -7,      -25,   52,  -21,
      -5,   41,  -35,       14,   31,  -48,       32,   20,  -61,       52,    9,  -75,
     -79,   83,   23,      -60,   72,    9,      -41,   61,   -3,      -22,   51,  -17,
      -3,   40,  -31,       16,   29,  -44,       35,   19,  -57,       54,    8,  -71,
     -77,   81,   27,      -58,   71,   13,      -39,   60,    0,      -20,   49,  -13,
       0,   38,  -27,       18,   28,  -40,       37,   17,  -53,       56,    6,  -67,
     -74,   80,   31,      -55,   69,   18,      -36,   58,    4,      -17,   48,   -8,
       2,   37,  -22,       21,   26,  -36,       40,   16,  -49,       59,    5,  -63,
     -72,   79,   35,      -53,   68,   22,      -34,   57,    8,      -15,   46,   -4,
       5,   36,  -18,       23,   25,  -32,       42,   14,  -45,       62,    3,  -59,
     -69,   77,   39,      -51,   67,   26,      -31,   56,   12,      -12,   45,    0,
       7,   34,  -14,       26,   24,  -28,       45,   13,  -41,       64,    2,  -55,
     -67,   76,   43,      -48,   65,   30,      -29,   54,   16,      -10,   44,    3,
       9,   33,  -10,       28,   22,  -24,       47,   12,  -37,       66,    1,  -51,
     -64,   74,   48,      -45,   64,   34,      -26,   53,   21,       -7,   42,    7,
      12,   31,   -6,       31,   21,  -19,       50,   10,  -32,       69,    0,  -46,
     -62,   73,   52,      -43,   62,   38,      -24,   52,   25,       -5,   41,   11,
      14,   30,   -2,       33,   19,  -15,       52,    9,  -28,       71,   -1,  -42,
     -59,   72,   56,      -41,   61,   42,      -21,   50,   29,       -3,   40,   15,
      17,   29,    1,       36,   18,  -11,       54,    7,  -24,       74,   -2,  -38,
     -57,   70,   60,      -38,   60,   46,      -19,   49,   33,        0,   38,   19,
      19,   27,    5,       38,   17,   -7,       57,    6,  -20,       76,   -4,  -34,
     -54,   69,   64,      -36,   58,   51,      -16,   47,   37,        3,   37,   24,
      22,   26,   10,       41,   15,   -3,       60,    5,  -16,       79,   -5,  -30,
     -52,   67,   68,      -33,   57,   55,      -14,   46,   41,        5,   35,   28,
      24,   24,   14,       43,   14,    0,       62,    3,  -12,       81,   -7,  -26,
     -50,   66,   72,      -31,   56,   59,      -11,   45,   45,        7,   34,   32,
      27,   23,   18,       46,   12,    4,       64,    2,   -8,       84,   -8,  -22,
     -47,   65,   76,      -28,   54,   63,       -9,   43,   49,       10,   33,   36,
      29,   22,   22,       48,   11,    8,       67,    1,   -4,       86,   -9,  -18,
     -45,   63,   80,      -26,   53,   67,       -7,   42,   53,       12,   31,   40,
      32,   20,   26,       50,   10,   12,       69,    0,    0,       88,  -11,  -14,
     -42,   62,   85,      -23,   51,   71,       -4,   40,   58,       15,   30,   44,
      34,   19,   30,       53,    8,   17,       72,   -1,    4,       91,  -12,   -9,
     -40,   61,   89,      -21,   50,   75,       -2,   39,   62,       17,   28,   48,
      37,   18,   34,       55,    7,   21,       74,   -3,    8,       94,  -14,   -5,
     -37,   59,   93,      -19,   49,   79,        1,   38,   66,       20,   27,   52,
      39,   16,   38,       58,    6,   25,       77,   -4,   12,       96,  -15,   -1,
     -35,   58,   97,      -16,   47,   83,        3,   36,   70,       22,   26,   56,
      41,   15,   42,       60,    4,   29,       79,   -5,   16,       98,  -16,    2,
     -32,   56,  101,      -13,   46,   88,        6,   35,   74,       25,   24,   61,
      44,   13,   47,       63,    3,   33,       82,   -7,   20,      101,  -18,    6,
     -30,   55,  105,      -11,   44,   92,        8,   33,   78,       27,   23,   65,
      46,   12,   51,       65,    1,   37,       84,   -8,   24,      103,  -19,   10,
     -27,   54,  109,       -9,   43,   96,       11,   32,   82,       29,   22,   69,
      49,   11,   55,       68,    0,   41,       86,  -10,   28,      106,  -21,   14,
    -103,  101,  -18,      -84,   91,  -31,      -65,   80,  -45,      -46,   69,  -59,
     -26,   58,  -72,       -8,   48,  -86,       11,   37,  -99,       31,   26, -113,
    -100,  100,  -14,      -81,   89,  -27,      -62,   78,  -41,      -43,   68,  -55,
     -24,   57,  -68,       -5,   46,  -82,       14,   36,  -95,       33,   25, -109,
     -98,   98,  -10,      -79,   88,  -23,      -60,   77,  -37,      -41,   66,  -51,
     -22,   55,  -64,       -3,   45,  -78,       16,   34,  -91,       35,   23, -105,
     -95,   97,   -5,      -76,   86,  -19,      -57,   75,  -33,      -38,   65,  -46,
     -19,   54,  -60,        0,   43,  -73,       19,   33,  -87,       38,   22, -100,
     -93,   96,   -1,      -74,   85,  -15,      -55,   74,  -29,      -36,   63,  -42,
     -16,   53,  -56,        2,   42,  -69,       21,   31,  -83,       40,   20,  -96,
     -90,   94,    2,      -72,   84,  -11,      -52,   73,  -25,      -33,   62,  -38,
     -14,   51,  -52,        5,   41,  -65,       23,   30,  -79,       43,   19,  -92,
     -88,   93,    6,      -69,   82,   -7,      -50,   71,  -21,      -31,   61,  -34,
     -12,   50,  -48,        7,   39,  -61,       26,   29,  -75,       45,   18,  -88,
     -85,   91,   10,      -67,   81,   -2,      -47,   70,  -16,      -28,   59,  -30,
      -9,   48,  -43,       10,   38,  -57,       29,   27,  -70,       48,   16,  -84,
     -83,   90,   14,      -64,   79,    1,      -45,   69,  -12,      -26,   58,  -26,
      -7,   47,  -39,       12,   36,  -53,       31,   26,  -66,       50,   15,  -80,
     -81,   89,   18,      -62,   78,    5,      -42,   67,   -8,      -24,   57,  -22,
      -4,   46,  -35,       15,   35,  -49,       33,   24,  -62,       53,   13,  -76,
     -78,   87,   22,      -59,   77,    9,      -40,   66,   -4,      -21,   55,  -18,
      -2,   44,  -31,       17,   34,  -45,       36,   23,  -58,       55,   12,  -72,
     -76,   86,   26,      -57,   75,   13,      -38,   64,    0,      -19,   54,  -14,
       1,   43,  -27,       19,   32,  -41,       38,   22,  -54,       57,   11,  -68,
     -73,   84,   31,      -54,   74,   17,      -35,   63,    3,      -16,   52,   -9,
       3,   41,  -23,       22,   31,  -36,       41,   20,  -50,       60,    9,  -63,
     -71,   83,   35,      -52,   73,   21,      -33,   62,    7,      -14,   51,   -5,
       6,   40,  -19,       24,   29,  -32,       43,   19,  -46,       63,    8,  -59,
     -68,   82,   39,      -49,   71,   25,      -30,   60,   11,      -11,   50,   -1,
       8,   39,  -15,       27,   28,  -28,       46,   18,  -42,       65,    7,  -55,
     -66,   80,   43,      -47,   70,   29,      -28,   59,   15,       -9,   48,    2,
      10,   37,  -11,       29,   27,  -24,       48,   16,  -38,       67,    5,  -51,
     -63,   79,   47,      -44,   68,   34,      -25,   57,   20,       -6,   47,    6,
      13,   36,   -6,       32,   25,  -20,       51,   15,  -33,       70,    4,  -47,
     -61,   78,   51,      -42,   67,   38,      -23,   56,   24,       -4,   45,   10,
      16,   34,   -2,       34,   24,  -16,       53,   13,  -29,       72,    2,  -43,
     -58,   76,   55,      -40,   66,   42,      -20,   55,   28,       -1,   44,   14,
      18,   33,    1,       37,   23,  -12,       55,   12,  -25,       75,    1,  -39,
     -56,   75,   59,      -37,   64,   46,      -18,   53,   32,        1,   43,   18,
      20,   32,    5,       39,   21,   -8,       58,   11,  -21,       77,    0,  -35,
     -53,   73,   64,      -35,   63,   50,      -15,   52,   36,        4,   41,   23,
      23,   30,    9,       42,   20,   -3,       61,    9,  -17,       80,   -1,  -30,
     -51,   72,   68,      -32,   61,   54,      -13,   50,   40,        6,   40,   27,
      25,   29,   13,       44,   18,    0,       63,    8,  -13,       82,   -2,  -26,
     -49,   71,   72,      -30,   60,   58,      -10,   49,   44,        8,   39,   31,
      28,   28,   17,       47,   17,    4,       65,    6,   -9,       85,   -4,  -22,
     -46,   69,   76,      -27,   59,   62,       -8,   48,   48,       11,   37,   35,
      30,   26,   21,       49,   16,    8,       68,    5,   -5,       87,   -5,  -18,
     -44,   68,   80,      -25,   57,   66,       -6,   46,   52,       13,   36,   39,
      33,   25,   25,       51,   14,   12,       70,    4,   -1,       89,   -6,  -14,
     -41,   66,   84,      -22,   56,   71,       -3,   45,   57,       16,   34,   43,
      35,   23,   30,       54,   13,   16,       73,    2,    3,       92,   -8,  -10,
     -39,   65,   88,      -20,   54,   75,       -1,   44,   61,       18,   33,   47,
      38,   22,   34,       56,   11,   20,       75,    1,    7,       95,   -9,   -6,
     -36,   64,   92,      -18,   53,   79,        2,   42,   65,       21,   32,   51,
      40,   21,   38,       59,   10,   24,       78,    0,   11,       97,  -10,   -2,
     -34,   62,   96,      -15,   52,   83,        4,   41,   69,       23,   30,   55,
      42,   19,   42,       61,    9,   28,       80,   -1,   15,       99,  -12,    1,
     -31,   61,  101,      -12,   50,   87,        7,   39,   73,       26,   29,   60,
      45,   18,   46,       64,    7,   33,       83,   -2,   19,      102,  -13,    6,
     -29,   59,  105,      -10,   49,   91,        9,   38,   77,       28,   27,   64,
      47,   16,   50,       66,    6,   37,       85,   -4,   23,      104,  -15,   10,
     -26,   58,  109,       -8,   48,   95,       12,   37,   81,       31,   26,   68,
      50,   15,   54,       69,    4,   41,       87,   -5,   27,      107,  -16,   14,
    -102,  105,  -19,      -83,   95,  -32,      -64,   84,  -46,      -45,   73,  -59,
     -25,   62,  -73,       -7,   52,  -86,       12,   41, -100,       31,   30, -114,
     -99,  104,  -15,      -81,   93,  -28,      -61,   82,  -42,      -42,   72,  -55,
     -23,   61,  -69,       -4,   50,  -82,       15,   40,  -96,       34,   29, -110,
     -97,  102,  -11,      -78,   92,  -24,      -59,   81,  -38,      -40,   70,  -51,
     -21,   59,  -65,       -2,   49,  -78,       17,   38,  -92,       36,   27, -106,
     -94,  101,   -6,      -75,   90,  -19,      -56,   79,  -33,      -37,   69,  -47,
     -18,   58,  -61,        1,   47,  -74,       20,   37,  -87,       39,   26, -101,
     -92,  100,   -2,      -73,   89,  -15,      -54,   78,  -29,      -35,   67,  -43,
     -16,   57,  -57,        3,   46,  -70,       22,   35,  -83,       41,   24,  -97,
     -89,   98,    1,      -71,   88,  -11,      -51,   77,  -25,      -33,   66,  -39,
     -13,   55,  -53,        6,   45,  -66,       24,   34,  -79,       44,   23,  -93,
     -87,   97,    5,      -68,   86,   -7,      -49,   75,  -21,      -30,   65,  -35,
     -11,   54,  -49,        8,   43,  -62,       27,   33,  -75,       46,   22,  -89,
     -84,   95,    9,      -66,   85,   -3,      -46,   74,  -17,      -27,   63,  -30,
      -8,   52,  -44,       11,   42,  -57,       29,   31,  -71,       49,   20,  -85,
     -82,   94,   13,      -63,   83,    0,      -44,   73,  -13,      -25,   62,  -26,
      -6,   51,  -40,       13,   40,  -53,       32,   30,  -67,       51,   19,  -81,
     -80,   93,   17,      -61,   82,    4,      -41,   71,   -9,      -23,   61,  -22,
      -3,   50,  -36,       15,   39,  -49,       34,   28,  -63,       54,   17,  -77,
     -77,   91,   21,      -58,   81,    8,      -39,   70,   -5,      -20,   59,  -18,
      -1,   48,  -32,       18,   38,  -45,       37,   27,  -59,       56,   16,  -73,
     -75,   90,   25,      -56,   79,   12,      -37,   68,   -1,      -18,   58,  -14,
       1,   47,  -28,       20,   36,  -41,       39,   26,  -55,       58,   15,  -69,
     -72,   88,   30,      -53,   78,   17,      -34,   67,    3,      -15,   56,  -10,
       4,   45,  -24,       23,   35,  -37,       42,   24,  -50,       61,   13,  -64,
     -70,   87,   34,      -51,   77,   21,      -32,   66,    7,      -13,   55,   -6,
       7,   44,  -20,       25,   33,  -33,       44,   23,  -46,       63,   12,  -60,
     -67,   86,   38,      -49,   75,   25,      -29,   64,   11,      -10,   54,   -2,
       9,   43,  -16,       28,   32,  -29,       47,   22,  -42,       66,   11,  -56,
     -65,   84,   42,      -46,   74,   29,      -27,   63,   15,       -8,   52,    1,
      11,   41,  -12,       30,   31,  -25,       49,   20,  -38,       68,    9,  -52,
     -62,   83,   46,      -44,   72,   33,      -24,   61,   19,       -5,   51,    6,
      14,   40,   -7,       33,   29,  -20,       52,   19,  -34,       71,    8,  -48,
     -60,   82,   50,      -41,   71,   37,      -22,   60,   23,       -3,   49,   10,
      16,   38,   -3,       35,   28,  -16,       54,   17,  -30,       73,    6,  -44,
     -58,   80,   54,      -39,   70,   41,      -19,   59,   27,       -1,   48,   14,
      19,   37,    0,       38,   27,  -12,       56,   16,  -26,       76,    5,  -40,
     -55,   79,   58,      -36,   68,   45,      -17,   57,   31,        2,   47,   18,
      21,   36,    4,       40,   25,   -8,       59,   15,  -22,       78,    4,  -36,
     -52,   77,   63,      -34,   67,   50,      -14,   56,   36,        5,   45,   22,
      24,   34,    8,       43,   24,   -4,       61,   13,  -17,       81,    2,  -31,
     -50,   76,   67,      -31,   65,   54,      -12,   54,   40,        7,   44,   26,
      26,   33,   12,       45,   22,    0,       64,   12,  -13,       83,    1,  -27,
     -48,   75,   71,      -29,   64,   58,       -9,   53,   44,        9,   43,   30,
      29,   32,   16,       47,   21,    3,       66,   10,   -9,       86,    0,  -23,
     -45,   73,   75,      -26,   63,   62,       -7,   52,   48,       12,   41,   34,
      31,   30,   20,       50,   20,    7,       69,    9,   -5,       88,   -1,  -19,
     -43,   72,   79,      -24,   61,   66,       -5,   50,   52,       14,   40,   38,
      33,   29,   24,       52,   18,   11,       71,    8,   -1,       90,   -2,  -15,
     -40,   70,   83,      -21,   60,   70,       -2,   49,   56,       17,   38,   43,
      36,   27,   29,       55,   17,   16,       74,    6,    2,       93,   -4,  -11,
     -38,   69,   87,      -19,   58,   74,        0,   48,   60,       19,   37,   47,
      39,   26,   33,       57,   15,   20,       76,    5,    6,       95,   -5,   -7,
     -35,   68,   91,      -17,   57,   78,        3,   46,   64,       22,   36,   51,
      41,   25,   37,       60,   14,   24,       79,    3,   10,       98,   -6,   -3,
     -33,   66,   95,      -14,   56,   82,        5,   45,   68,       24,   34,   55,
      43,   23,   41,       62,   13,   28,       81,    2,   14,      100,   -8,    0,
     -30,   65,  100,      -12,   54,   87,        8,   43,   73,       27,   33,   59,
      46,   22,   45,       65,   11,   32,       84,    1,   19,      103,   -9,    5,
     -28,   63,  104,       -9,   53,   91,       10,   42,   77,       29,   31,   63,
      48,   20,   49,       67,   10,   36,       86,    0,   23,      105,  -11,    9,
     -26,   62,  108,       -7,   52,   95,       13,   41,   81,       31,   30,   67,
      51,   19,   53,       70,    8,   40,       88,   -1,   27,      108,  -12,   13,
    -101,  109,  -19,      -82,   99,  -33,      -63,   88,  -46,      -44,   77,  -60,
     -25,   66,  -74,       -6,   56,  -87,       13,   45, -100,       32,   34, -114,
     -98,  108,  -15,      -80,   97,  -29,      -60,   86,  -42,      -42,   76,  -56,
     -22,   65,  -70,       -3,   54,  -83,       15,   44,  -96,       35,   33, -110,
     -96,  106,  -11,      -77,   96,  -25,      -58,   85,  -38,      -39,   74,  -52,
     -20,   63,  -66,       -1,   53,  -79,       18,   42,  -92,       37,   31, -106,
     -93,  105,   -7,      -75,   94,  -20,      -55,   83,  -34,      -36,   73,  -47,
     -17,   62,  -61,        2,   51,  -75,       21,   41,  -88,       40,   30, -102,
     -91,  104,   -3,      -72,   93,  -16,      -53,   82,  -30,      -34,   71,  -43,
     -15,   61,  -57,        4,   50,  -71,       23,   39,  -84,       42,   28,  -98,
     -89,  102,    0,      -70,   92,  -12,      -50,   81,  -26,      -32,   70,  -39,
     -12,   59,  -53,        7,   49,  -67,       25,   38,  -80,       45,   27,  -94,
     -86,  101,    4,      -67,   90,   -8,      -48,   79,  -22,      -29,   69,  -35,
     -10,   58,  -49,        9,   47,  -63,       28,   37,  -76,       47,   26,  -90,
     -84,   99,    9,      -65,   89,   -4,      -45,   78,  -17,      -27,   67,  -31,
      -7,   56,  -45,       12,   46,  -58,       30,   35,  -71,       50,   24,  -85,
     -81,   98,   13,      -62,   87,    0,      -43,   77,  -13,      -24,   66,  -27,
      -5,   55,  -41,       14,   44,  -54,       33,   34,  -67,       52,   23,  -81,
     -79,   97,   17,      -60,   86,    3,      -41,   75,   -9,      -22,   65,  -23,
      -2,   54,  -37,       16,   43,  -50,       35,   32,  -63,       55,   21,  -77,
     -76,   95,   21,      -58,   85,    7,      -38,   74,   -5,      -19,   63,  -19,
       0,   52,  -33,       19,   42,  -46,       38,   31,  -59,       57,   20,  -73,
     -74,   94,   25,      -55,   83,   11,      -36,   72,   -1,      -17,   62,  -15,
       2,   51,  -29,       21,   40,  -42,       40,   30,  -55,       59,   19,  -69,
     -71,   92,   29,      -52,   82,   16,      -33,   71,    2,      -14,   60,  -10,
       5,   49,  -24,       24,   39,  -38,       43,   28,  -51,       62,   17,  -65,
     -69,   91,   33,      -50,   81,   20,      -31,   70,    6,      -12,   59,   -6,
       7,   48,  -20,       26,   37,  -34,       45,   27,  -47,       64,   16,  -61,
     -66,   90,   37,      -48,   79,   24,      -28,   68,   10,      -10,   58,   -2,
      10,   47,  -16,       29,   36,  -30,       47,   26,  -43,       67,   15,  -57,
     -64,   88,   41,      -45,   78,   28,      -26,   67,   14,       -7,   56,    1,
      12,   45,  -12,       31,   35,  -26,       50,   24,  -39,       69,   13,  -53,
     -61,   87,   46,      -43,   76,   32,      -23,   65,   19,       -4,   55,    5,
      15,   44,   -8,       34,   33,  -21,       53,   23,  -34,       72,   12,  -48,
     -59,   86,   50,      -40,   75,   36,      -21,   64,   23,       -2,   53,    9,
      17,   42,   -4,       36,   32,  -17,       55,   21,  -30,       74,   10,  -44,
     -57,   84,   54,      -38,   74,   40,      -18,   63,   27,        0,   52,   13,
      20,   41,    0,       39,   31,  -13,       57,   20,  -26,       77,    9,  -40,
     -54,   83,   58,      -35,   72,   44,      -16,   61,   31,        3,   51,   17,
      22,   40,    3,       41,   29,   -9,       60,   19,  -22,       79,    8,  -36,
     -52,   81,   62,      -33,   71,   49,      -13,   60,   35,        5,   49,   22,
      25,   38,    8,       44,   28,   -5,       62,   17,  -18,       82,    6,  -32,
     -49,   80,   66,      -30,   69,   53,      -11,   58,   39,        8,   48,   26,
      27,   37,   12,       46,   26,   -1,       65,   16,  -14,       84,    5,  -28,
     -47,   79,   70,      -28,   68,   57,       -9,   57,   43,       10,   47,   30,
      30,   36,   16,       48,   25,    2,       67,   14,  -10,       87,    3,  -24,
     -44,   77,   74,      -26,   67,   61,       -6,   56,   47,       13,   45,   34,
      32,   34,   20,       51,   24,    6,       70,   13,   -6,       89,    2,  -20,
     -42,   76,   78,      -23,   65,   65,       -4,   54,   51,       15,   44,   38,
      34,   33,   24,       53,   22,   10,       72,   12,   -2,       91,    1,  -16,
     -39,   74,   83,      -20,   64,   69,       -1,   53,   56,       18,   42,   42,
      37,   31,   28,       56,   21,   15,       75,   10,    2,       94,    0,  -11,
     -37,   73,   87,      -18,   62,   73,        1,   52,   60,       20,   41,   46,
      39,   30,   32,       58,   19,   19,       77,    9,    6,       96,   -1,   -7,
     -34,   72,   91,      -16,   61,   77,        4,   50,   64,       22,   40,   50,
      42,   29,   36,       61,   18,   23,       79,    7,   10,       99,   -2,   -3,
     -32,   70,   95,      -13,   60,   81,        6,   49,   68,       25,   38,   54,
      44,   27,   40,       63,   17,   27,       82,    6,   14,      101,   -4,    0,
     -29,   69,   99,      -11,   58,   86,        9,   47,   72,       28,   37,   59,
      47,   26,   45,       66,   15,   31,       84,    5,   18,      104,   -5,    4,
     -27,   67,  103,       -8,   57,   90,       11,   46,   76,       30,   35,   63,
      49,   24,   49,       68,   14,   35,       87,    3,   22,      106,   -7,    8,
     -25,   66,  107,       -6,   56,   94,       14,   45,   80,       32,   34,   67,
      52,   23,   53,       70,   12,   39,       89,    2,   26,      109,   -8,   12,
    -100,  113,  -20,      -81,  103,  -33,      -62,   92,  -47,      -43,   81,  -60,
     -24,   70,  -74,       -5,   60,  -88,       14,   49, -101,       33,   38, -115,
     -98,  112,  -16,      -79,  101,  -29,      -59,   90,  -43,      -41,   80,  -56,
     -21,   69,  -70,       -2,   58,  -84,       16,   48,  -97,       36,   37, -111,
     -95,  110,  -12,      -76,  100,  -25,      -57,   89,  -39,      -38,   78,  -52,
     -19,   67,  -66,        0,   57,  -80,       19,   46,  -93,       38,   35, -107,
     -92,  109,   -7,      -74,   98,  -21,      -54,   87,  -35,      -36,   77,  -48,
     -16,   66,  -62,        3,   55,  -75,       21,   45,  -89,       41,   34, -102,
     -90,  108,   -3,      -71,   97,  -17,      -52,   86,  -31,      -33,   75,  -44,
     -14,   65,  -58,        5,   54,  -71,       24,   43,  -85,       43,   32,  -98,
     -88,  106,    0,      -69,   96,  -13,      -50,   85,  -27,      -31,   74,  -40,
     -11,   63,  -54,        7,   53,  -67,       26,   42,  -81,       46,   31,  -94,
     -85,  105,    4,      -66,   94,   -9,      -47,   83,  -23,      -28,   73,  -36,
      -9,   62,  -50,       10,   51,  -63,       29,   41,  -77,       48,   30,  -90,
     -83,  103,    8,      -64,   93,   -4,      -44,   82,  -18,      -26,   71,  -31,
      -6,   60,  -45,       13,   50,  -59,       31,   39,  -72,       51,   28,  -86,
     -80,  102,   12,      -61,   91,    0,      -42,   81,  -14,      -23,   70,  -27,
      -4,   59,  -41,       15,   48,  -55,       34,   38,  -68,       53,   27,  -82,
     -78,  101,   16,      -59,   90,    3,      -40,   79,  -10,      -21,   69,  -23,
      -1,   58,  -37,       17,   47,  -51,       36,   36,  -64,       55,   25,  -78,
     -75,   99,   20,      -57,   89,    7,      -37,   78,   -6,      -18,   67,  -19,
       1,   56,  -33,       20,   46,  -47,       38,   35,  -60,       58,   24,  -74,
     -73,   98,   24,      -54,   87,   11,      -35,   76,   -2,      -16,   66,  -15,
       3,   55,  -29,       22,   44,  -43,       41,   34,  -56,       60,   23,  -70,
     -70,   96,   29,      -52,   86,   15,      -32,   75,    1,      -13,   64,  -11,
       6,   53,  -25,       25,   43,  -38,       44,   32,  -52,       63,   21,  -65,
     -68,   95,   33,      -49,   85,   19,      -30,   74,    5,      -11,   63,   -7,
       8,   52,  -21,       27,   41,  -34,       46,   31,  -48,       65,   20,  -61,
     -66,   94,   37,      -47,   83,   23,      -27,   72,    9,       -9,   62,   -3,
      11,   51,  -17,       30,   40,  -30,       48,   30,  -44,       68,   19,  -57,
     -63,   92,   41,      -44,   82,   27,      -25,   71,   13,       -6,   60,    0,
      13,   49,  -13,       32,   39,  -26,       51,   28,  -40,       70,   17,  -53,
     -60,   91,   45,      -42,   80,   32,      -22,   69,   18,       -4,   59,    5,
      16,   48,   -8,       35,   37,  -22,       53,   27,  -35,       73,   16,  -49,
     -58,   90,   49,      -39,   79,   36,      -20,   68,   22,       -1,   57,    9,
      18,   46,   -4,       37,   36,  -18,       56,   25,  -31,       75,   14,  -45,
     -56,   88,   53,      -37,   78,   40,      -18,   67,   26,        1,   56,   13,
      21,   45,    0,       39,   35,  -14,       58,   24,  -27,       78,   13,  -41,
     -53,   87,   57,      -35,   76,   44,      -15,   65,   30,        4,   55,   17,
      23,   44,    3,       42,   33,  -10,       61,   23,  -23,       80,   12,  -37,
     -51,   85,   62,      -32,   75,   48,      -12,   64,   34,        6,   53,   21,
      26,   42,    7,       44,   32,   -5,       63,   21,  -19,       83,   10,  -32,
     -48,   84,   66,      -29,   73,   52,      -10,   62,   38,        9,   52,   25,
      28,   41,   11,       47,   30,   -1,       66,   20,  -15,       85,    9,  -28,
     -46,   83,   70,      -27,   72,   56,       -8,   61,   42,       11,   51,   29,
      30,   40,   15,       49,   29,    2,       68,   18,  -11,       87,    7,  -24,
     -43,   81,   74,      -25,   71,   60,       -5,   60,   46,       14,   49,   33,
      33,   38,   19,       52,   28,    6,       70,   17,   -7,       90,    6,  -20,
     -41,   80,   78,      -22,   69,   64,       -3,   58,   50,       16,   48,   37,
      35,   37,   23,       54,   26,   10,       73,   16,   -3,       92,    5,  -16,
     -38,   78,   82,      -20,   68,   69,        0,   57,   55,       19,   46,   42,
      38,   35,   28,       57,   25,   14,       76,   14,    1,       95,    3,  -12,
     -36,   77,   86,      -17,   66,   73,        2,   56,   59,       21,   45,   46,
      40,   34,   32,       59,   23,   18,       78,   13,    5,       97,    2,   -8,
     -34,   76,   90,      -15,   65,   77,        5,   54,   63,       23,   44,   50,
      43,   33,   36,       62,   22,   22,       80,   11,    9,      100,    1,   -4,
     -31,   74,   94,      -12,   64,   81,        7,   53,   67,       26,   42,   54,
      45,   31,   40,       64,   21,   26,       83,   10,   13,      102,    0,    0,
     -28,   73,   99,      -10,   62,   85,       10,   51,   71,       28,   41,   58,
      48,   30,   44,       67,   19,   31,       85,    9,   17,      105,   -1,    4,
     -26,   71,  103,       -7,   61,   89,       12,   50,   75,       31,   39,   62,
      50,   28,   48,       69,   18,   35,       88,    7,   21,      107,   -3,    8,
     -24,   70,  107,       -5,   60,   93,       14,   49,   79,       33,   38,   66,
      53,   27,   52,       71,   16,   39,       90,    6,   25,      110,   -4,   12,
     -99,  118,  -21,      -80,  107,  -34,      -61,   96,  -48,      -42,   86,  -61,
     -23,   75,  -75,       -4,   64,  -88,       15,   53, -102,       34,   42, -116,
     -97,  116,  -17,      -78,  106,  -30,      -58,   95,  -44,      -40,   84,  -57,
     -20,   73,  -71,       -1,   63,  -84,       17,   52,  -98,       37,   41, -112,
     -94,  115,  -13,      -75,  104,  -26,      -56,   93,  -40,      -37,   83,  -53,
     -18,   72,  -67,        1,   61,  -80,       20,   51,  -94,       39,   40, -108,
     -91,  113,   -8,      -73,  103,  -22,      -53,   92,  -35,      -34,   81,  -49,
     -15,   70,  -63,        4,   60,  -76,       22,   49,  -89,       42,   38, -103,
     -89,  112,   -4,      -70,  102,  -18,      -51,   91,  -31,      -32,   80,  -45,
     -13,   69,  -59,        6,   58,  -72,       25,   48,  -85,       44,   37,  -99,
     -87,  111,    0,      -68,  100,  -14,      -48,   89,  -27,      -30,   79,  -41,
     -10,   68,  -55,        8,   57,  -68,       27,   46,  -81,       47,   36,  -95,
     -84,  109,    3,      -65,   99,  -10,      -46,   88,  -23,      -27,   77,  -37,
      -8,   66,  -51,       11,   56,  -64,       30,   45,  -77,       49,   34,  -91,
     -82,  108,    7,      -63,   97,   -5,      -43,   86,  -19,      -25,   76,  -32,
      -5,   65,  -46,       14,   54,  -59,       32,   44,  -73,       52,   33,  -87,
     -79,  107,   11,      -60,   96,   -1,      -41,   85,  -15,      -22,   74,  -28,
      -3,   63,  -42,       16,   53,  -55,       35,   42,  -69,       54,   31,  -83,
     -77,  105,   15,      -58,   95,    2,      -39,   84,  -11,      -20,   73,  -24,
       0,   62,  -38,       18,   52,  -51,       37,   41,  -65,       56,   30,  -79,
     -74,  104,   19,      -56,   93,    6,      -36,   82,   -7,      -17,   72,  -20,
       2,   61,  -34,       21,   50,  -47,       39,   40,  -61,       59,   29,  -75,
     -72,  102,   23,      -53,   92,   10,      -34,   81,   -3,      -15,   70,  -16,
       4,   59,  -30,       23,   49,  -43,       42,   38,  -57,       61,   27,  -71,
     -69,  101,   28,      -51,   90,   14,      -31,   79,    1,      -12,   69,  -12,
       7,   58,  -26,       26,   47,  -39,       45,   37,  -52,       64,   26,  -66,
     -67,  100,   32,      -48,   89,   18,      -29,   78,    5,      -10,   67,   -8,
       9,   57,  -22,       28,   46,  -35,       47,   35,  -48,       66,   24,  -62,
     -65,   98,   36,      -46,   88,   22,      -26,   77,    9,       -8,   66,   -4,
      12,   55,  -18,       31,   45,  -31,       49,   34,  -44,       69,   23,  -58,
     -62,   97,   40,      -43,   86,   26,      -24,   75,   13,       -5,   65,    0,
      14,   54,  -14,       33,   43,  -27,       52,   33,  -40,       71,   22,  -54,
     -59,   95,   44,      -41,   85,   31,      -21,   74,   17,       -2,   63,    4,
      17,   52,   -9,       36,   42,  -22,       54,   31,  -36,       74,   20,  -50,
     -57,   94,   48,      -38,   83,   35,      -19,   73,   21,        0,   62,    8,
      19,   51,   -5,       38,   40,  -18,       57,   30,  -32,       76,   19,  -46,
     -55,   93,   52,      -36,   82,   39,      -16,   71,   25,        2,   61,   12,
      22,   50,   -1,       40,   39,  -14,       59,   28,  -28,       79,   18,  -42,
     -52,   91,   56,      -33,   81,   43,      -14,   70,   29,        5,   59,   16,
      24,   48,    2,       43,   38,  -10,       62,   27,  -24,       81,   16,  -38,
     -50,   90,   61,      -31,   79,   47,      -11,   68,   34,        7,   58,   20,
      27,   47,    6,       46,   36,   -6,       64,   26,  -19,       84,   15,  -33,
     -47,   88,   65,      -28,   78,   51,       -9,   67,   38,       10,   56,   24,
      29,   45,   10,       48,   35,   -2,       67,   24,  -15,       86,   13,  -29,
     -45,   87,   69,      -26,   77,   55,       -7,   66,   42,       12,   55,   28,
      32,   44,   14,       50,   33,    1,       69,   23,  -11,       88,   12,  -25,
     -42,   86,   73,      -24,   75,   59,       -4,   64,   46,       15,   54,   32,
      34,   43,   18,       53,   32,    5,       71,   22,   -7,       91,   11,  -21,
     -40,   84,   77,      -21,   74,   63,       -2,   63,   50,       17,   52,   36,
      36,   41,   22,       55,   31,    9,       74,   20,   -3,       93,    9,  -17,
     -37,   83,   81,      -19,   72,   68,        1,   61,   54,       20,   51,   41,
      39,   40,   27,       58,   29,   14,       77,   19,    0,       96,    8,  -13,
     -35,   82,   85,      -16,   71,   72,        3,   60,   58,       22,   49,   45,
      41,   39,   31,       60,   28,   18,       79,   17,    4,       98,    6,   -9,
     -33,   80,   89,      -14,   70,   76,        6,   59,   62,       24,   48,   49,
      44,   37,   35,       63,   27,   22,       81,   16,    8,      101,    5,   -5,
     -30,   79,   93,      -11,   68,   80,        8,   57,   66,       27,   47,   53,
      46,   36,   39,       65,   25,   26,       84,   15,   12,      103,    4,   -1,
     -27,   77,   98,       -9,   67,   84,       11,   56,   71,       29,   45,   57,
      49,   34,   43,       68,   24,   30,       86,   13,   17,      106,    2,    3,
     -25,   76,  102,       -6,   65,   88,       13,   54,   75,       32,   44,   61,
      51,   33,   47,       70,   22,   34,       89,   12,   21,      108,    1,    7,
     -23,   75,  106,       -4,   64,   92,       15,   53,   79,       34,   43,   65,
      54,   32,   51,       72,   21,   38,       91,   10,   25,      111,    0,   11,
     -98,  122,  -21,      -79,  111,  -35,      -60,  100,  -48,      -41,   90,  -62,
     -22,   79,  -76,       -3,   68,  -89,       16,   57, -102,       35,   46, -116,
     -96,  120,  -17,      -77,  110,  -31,      -57,   99,  -44,      -39,   88,  -58,
     -19,   77,  -72,       -1,   67,  -85,       18,   56,  -98,       38,   45, -112,
     -93,  119,  -13,      -74,  108,  -27,      -55,   97,  -40,      -36,   87,  -54,
     -17,   76,  -68,        2,   65,  -81,       21,   55,  -94,       40,   44, -108,
     -91,  117,   -9,      -72,  107,  -22,      -52,   96,  -36,      -34,   85,  -49,
     -14,   74,  -63,        5,   64,  -77,       23,   53,  -90,       43,   42, -104,
     -88,  116,   -5,      -69,  106,  -18,      -50,   95,  -32,      -31,   84,  -45,
     -12,   73,  -59,        7,   62,  -73,       26,   52,  -86,       45,   41, -100,
     -86,  115,   -1,      -67,  104,  -14,      -48,   93,  -28,      -29,   83,  -41,
      -9,   72,  -55,        9,   61,  -69,       28,   50,  -82,       48,   40,  -96,
     -83,  113,    2,      -65,  103,  -10,      -45,   92,  -24,      -26,   81,  -37,
      -7,   70,  -51,       12,   60,  -65,       31,   49,  -78,       50,   38,  -92,
     -81,  112,    7,      -62,  101,   -6,      -42,   90,  -19,      -24,   80,  -33,
      -4,   69,  -47,       14,   58,  -60,       33,   48,  -73,       53,   37,  -87,
     -78,  111,   11,      -59,  100,   -2,      -40,   89,  -15,      -21,   78,  -29,
      -2,   67,  -43,       17,   57,  -56,       36,   46,  -69,       55,   35,  -83,
     -76,  109,   15,      -57,   99,    1,      -38,   88,  -11,      -19,   77,  -25,
       0,   66,  -39,       19,   56,  -52,       38,   45,  -65,       57,   34,  -79,
     -73,  108,   19,      -55,   97,    5,      -35,   86,   -7,      -17,   76,  -21,
       3,   65,  -35,       22,   54,  -48,       40,   44,  -61,       60,   33,  -75,
     -71,  106,   23,      -52,   96,    9,      -33,   85,   -3,      -14,   74,  -17,
       5,   63,  -31,       24,   53,  -44,       43,   42,  -57,       62,   31,  -71,
     -68,  105,   27,      -50,   94,   14,      -30,   83,    0,      -11,   73,  -12,
       8,   62,  -26,       27,   51,  -40,       45,   41,  -53,       65,   30,  -67,
     -66,  104,   31,      -47,   93,   18,      -28,   82,    4,       -9,   71,   -8,
      10,   61,  -22,       29,   50,  -36,       48,   39,  -49,       67,   28,  -63,
     -64,  102,   35,      -45,   92,   22,      -25,   81,    8,       -7,   70,   -4,
      13,   59,  -18,       31,   49,  -32,       50,   38,  -45,       70,   27,  -59,
     -61,  101,   39,      -42,   90,   26,      -23,   79,   12,       -4,   69,    0,
      15,   58,  -14,       34,   47,  -28,       53,   37,  -41,       72,   26,  -55,
     -59,   99,   44,      -40,   89,   30,      -20,   78,   17,       -2,   67,    3,
      18,   56,  -10,       37,   46,  -23,       55,   35,  -36,       75,   24,  -50,
     -56,   98,   48,      -37,   87,   34,      -18,   77,   21,        1,   66,    7,
      20,   55,   -6,       39,   44,  -19,       58,   34,  -32,       77,   23,  -46,
     -54,   97,   52,      -35,   86,   38,      -16,   75,   25,        3,   65,   11,
      23,   54,   -2,       41,   43,  -15,       60,   32,  -28,       80,   22,  -42,
     -51,   95,   56,      -33,   85,   42,      -13,   74,   29,        6,   63,   15,
      25,   52,    1,       44,   42,  -11,       63,   31,  -24,       82,   20,  -38,
     -49,   94,   60,      -30,   83,   47,      -11,   72,   33,        8,   62,   20,
      28,   51,    6,       46,   40,   -7,       65,   30,  -20,       85,   19,  -34,
     -46,   92,   64,      -27,   82,   51,       -8,   71,   37,       11,   60,   24,
      30,   49,   10,       49,   39,   -3,       68,   28,  -16,       87,   17,  -30,
     -44,   91,   68,      -25,   81,   55,       -6,   70,   41,       13,   59,   28,
      32,   48,   14,       51,   37,    0,       70,   27,  -12,       89,   16,  -26,
     -41,   90,   72,      -23,   79,   59,       -3,   68,   45,       15,   58,   32,
      35,   47,   18,       54,   36,    4,       72,   26,   -8,       92,   15,  -22,
     -39,   88,   76,      -20,   78,   63,       -1,   67,   49,       18,   56,   36,
      37,   45,   22,       56,   35,    8,       75,   24,   -4,       94,   13,  -18,
     -36,   87,   81,      -18,   76,   67,        2,   65,   54,       21,   55,   40,
      40,   44,   26,       59,   33,   13,       77,   23,    0,       97,   12,  -13,
     -34,   86,   85,      -15,   75,   71,        4,   64,   58,       23,   53,   44,
      42,   43,   30,       61,   32,   17,       80,   21,    4,       99,   10,   -9,
     -32,   84,   89,      -13,   74,   75,        7,   63,   62,       25,   52,   48,
      45,   41,   34,       63,   31,   21,       82,   20,    8,      102,    9,   -5,
     -29,   83,   93,      -10,   72,   79,        9,   61,   66,       28,   51,   52,
      47,   40,   38,       66,   29,   25,       85,   19,   12,      104,    8,   -1,
     -27,   81,   97,       -8,   71,   84,       12,   60,   70,       30,   49,   57,
      50,   38,   43,       69,   28,   29,       87,   17,   16,      107,    6,    2,
     -24,   80,  101,       -5,   69,   88,       14,   58,   74,       33,   48,   61,
      52,   37,   47,       71,   26,   33,       90,   16,   20,      109,    5,    6,
     -22,   79,  105,       -3,   68,   92,       16,   57,   78,       35,   47,   65,
      55,   36,   51,       73,   25,   37,       92,   14,   24,      112,    3,   10,
     -97,  126,  -22,      -78,  115,  -35,      -59,  104,  -49,      -40,   94,  -63,
     -21,   83,  -76,       -2,   72,  -90,       17,   61, -103,       36,   50, -117,
     -95,  124,  -18,      -76,  114,  -31,      -57,  103,  -45,      -38,   92,  -59,
     -18,   81,  -72,        0,   71,  -86,       19,   60,  -99,       39,   49, -113,
     -92,  123,  -14,      -74,  112,  -27,      -54,  101,  -41,      -35,   91,  -55,
     -16,   80,  -68,        3,   69,  -82,       22,   59,  -95,       41,   48, -109,
     -90,  121,   -9,      -71,  111,  -23,      -51,  100,  -37,      -33,   89,  -50,
     -13,   78,  -64,        5,   68,  -77,       24,   57,  -91,       44,   46, -104,
     -87,  120,   -5,      -68,  110,  -19,      -49,   99,  -33,      -30,   88,  -46,
     -11,   77,  -60,        8,   66,  -73,       27,   56,  -87,       46,   45, -100,
     -85,  119,   -1,      -66,  108,  -15,      -47,   97,  -29,      -28,   87,  -42,
      -9,   76,  -56,       10,   65,  -69,       29,   54,  -83,       48,   44,  -96,
     -82,  117,    2,      -64,  107,  -11,      -44,   96,  -25,      -25,   85,  -38,
      -6,   74,  -52,       13,   64,  -65,       31,   53,  -79,       51,   42,  -92,
     -80,  116,    6,      -61,  105,   -6,      -42,   94,  -20,      -23,   84,  -34,
      -3,   73,  -47,       15,   62,  -61,       34,   52,  -74,       54,   41,  -88,
     -77,  115,   10,      -59,  104,   -2,      -39,   93,  -16,      -20,   82,  -30,
      -1,   71,  -43,       18,   61,  -57,       37,   50,  -70,       56,   39,  -84,
     -75,  113,   14,      -56,  103,    1,      -37,   92,  -12,      -18,   81,  -26,
       1,   70,  -39,       20,   60,  -53,       39,   49,  -66,       58,   38,  -80,
     -73,  112,   18,      -54,  101,    5,      -34,   90,   -8,      -16,   80,  -22,
       4,   69,  -35,       23,   58,  -49,       41,   48,  -62,       61,   37,  -76,
     -70,  110,   22,      -51,  100,    9,      -32,   89,   -4,      -13,   78,  -18,
       6,   67,  -31,       25,   57,  -45,       44,   46,  -58,       63,   35,  -72,
     -67,  109,   27,      -49,   98,   13,      -29,   87,    0,      -11,   77,  -13,
       9,   66,  -27,       28,   55,  -40,       46,   45,  -54,       66,   34,  -67,
     -65,  108,   31,      -46,   97,   17,      -27,   86,    3,       -8,   75,   -9,
      11,   65,  -23,       30,   54,  -36,       49,   43,  -50,       68,   32,  -63,
     -63,  106,   35,      -44,   96,   21,      -25,   85,    7,       -6,   74,   -5,
      14,   63,  -19,       32,   53,  -32,       51,   42,  -46,       71,   31,  -59,
     -60,  105,   39,      -42,   94,   25,      -22,   83,   11,       -3,   73,   -1,
      16,   62,  -15,       35,   51,  -28,       54,   41,  -42,       73,   30,  -55,
     -58,  103,   43,      -39,   93,   30,      -19,   82,   16,       -1,   71,    2,
      19,   60,  -10,       37,   50,  -24,       56,   39,  -37,       76,   28,  -51,
     -55,  102,   47,      -36,   91,   34,      -17,   81,   20,        2,   70,    6,
      21,   59,   -6,       40,   48,  -20,       59,   38,  -33,       78,   27,  -47,
     -53,  101,   51,      -34,   90,   38,      -15,   79,   24,        4,   69,   10,
      23,   58,   -2,       42,   47,  -16,       61,   36,  -29,       80,   26,  -43,
     -50,   99,   55,      -32,   89,   42,      -12,   78,   28,        7,   67,   14,
      26,   56,    1,       45,   46,  -12,       63,   35,  -25,       83,   24,  -39,
     -48,   98,   60,      -29,   87,   46,      -10,   76,   32,        9,   66,   19,
      29,   55,    5,       47,   44,   -7,       66,   34,  -21,       86,   23,  -34,
     -45,   96,   64,      -27,   86,   50,       -7,   75,   36,       12,   64,   23,
      31,   53,    9,       50,   43,   -3,       69,   32,  -17,       88,   21,  -30,
     -43,   95,   68,      -24,   85,   54,       -5,   74,   40,       14,   63,   27,
      33,   52,   13,       52,   41,    0,       71,   31,  -13,       90,   20,  -26,
     -41,   94,   72,      -22,   83,   58,       -2,   72,   44,       16,   62,   31,
      36,   51,   17,       55,   40,    4,       73,   30,   -9,       93,   19,  -22,
     -38,   92,   76,      -19,   82,   62,        0,   71,   48,       19,   60,   35,
      38,   49,   21,       57,   39,    8,       76,   28,   -5,       95,   17,  -18,
     -35,   91,   80,      -17,   80,   67,        3,   69,   53,       21,   59,   39,
      41,   48,   26,       60,   37,   12,       78,   27,    0,       98,   16,  -14,
     -33,   90,   84,      -14,   79,   71,        5,   68,   57,       24,   57,   43,
      43,   47,   30,       62,   36,   16,       81,   25,    3,      100,   14,  -10,
     -31,   88,   88,      -12,   78,   75,        7,   67,   61,       26,   56,   47,
      46,   45,   34,       64,   35,   20,       83,   24,    7,      103,   13,   -6,
     -28,   87,   92,      -10,   76,   79,       10,   65,   65,       29,   55,   51,
      48,   44,   38,       67,   33,   24,       86,   23,   11,      105,   12,   -2,
     -26,   85,   97,       -7,   75,   83,       13,   64,   69,       31,   53,   56,
      51,   42,   42,       69,   32,   29,       88,   21,   15,      108,   10,    2,
     -23,   84,  101,       -4,   73,   87,       15,   62,   73,       34,   52,   60,
      53,   41,   46,       72,   30,   33,       91,   20,   19,      110,    9,    6,
     -21,   83,  105,       -2,   72,   91,       17,   61,   77,       36,   51,   64,
      55,   40,   50,       74,   29,   37,       93,   18,   23,      112,    7,   10,
    -124,   -2,   -3,     -105,  -13,  -16,      -86,  -24,  -30,      -67,  -34,  -43,
     -47,  -45,  -57,      -29,  -56,  -71,      -10,  -66,  -84,        9,  -77,  -98,
    -121,   -4,    0,     -103,  -14,  -12,      -83,  -25,  -26,      -64,  -36,  -39,
     -45,  -47,  -53,      -26,  -57,  -67,       -8,  -68,  -80,       12,  -79,  -94,
    -119,   -5,    4,     -100,  -15,   -8,      -81,  -26,  -22,      -62,  -37,  -35,
     -43,  -48,  -49,      -24,  -59,  -63,       -5,  -69,  -76,       14,  -80,  -90,
    -116,   -6,    9,      -98,  -17,   -4,      -78,  -28,  -18,      -59,  -39,  -31,
     -40,  -49,  -45,      -21,  -60,  -58,       -2,  -71,  -72,       17,  -82,  -85,
    -114,   -8,   13,      -95,  -18,    0,      -76,  -29,  -14,      -57,  -40,  -27,
     -38,  -51,  -41,      -19,  -61,  -54,        0,  -72,  -68,       19,  -83,  -81,
    -112,   -9,   17,      -93,  -20,    3,      -73,  -31,  -10,      -55,  -41,  -23,
     -35,  -52,  -37,      -16,  -63,  -50,        2,  -73,  -64,       22,  -84,  -77,
    -109,  -10,   21,      -90,  -21,    7,      -71,  -32,   -6,      -52,  -43,  -19,
     -33,  -53,  -33,      -14,  -64,  -46,        5,  -75,  -60,       24,  -86,  -73,
    -106,  -12,   25,      -88,  -23,   12,      -68,  -33,   -1,      -50,  -44,  -14,
     -30,  -55,  -28,      -11,  -66,  -42,        7,  -76,  -55,       27,  -87,  -69,
    -104,  -13,   29,      -85,  -24,   16,      -66,  -35,    2,      -47,  -45,  -10,
     -28,  -56,  -24,       -9,  -67,  -38,       10,  -78,  -51,       29,  -88,  -65,
    -102,  -15,   33,      -83,  -25,   20,      -64,  -36,    6,      -45,  -47,   -6,
     -25,  -58,  -20,       -7,  -68,  -34,       12,  -79,  -47,       32,  -90,  -61,
     -99,  -16,   37,      -81,  -27,   24,      -61,  -38,   10,      -42,  -48,   -2,
     -23,  -59,  -16,       -4,  -70,  -30,       15,  -80,  -43,       34,  -91,  -57,
     -97,  -17,   41,      -78,  -28,   28,      -59,  -39,   14,      -40,  -49,    1,
     -21,  -60,  -12,       -2,  -71,  -26,       17,  -82,  -39,       36,  -93,  -53,
     -94,  -19,   46,      -75,  -29,   32,      -56,  -40,   18,      -37,  -51,    5,
     -18,  -62,   -8,        1,  -73,  -21,       20,  -83,  -35,       39,  -94,  -48,
     -92,  -20,   50,      -73,  -31,   36,      -54,  -42,   22,      -35,  -52,    9,
     -16,  -63,   -4,        3,  -74,  -17,       22,  -84,  -31,       41,  -95,  -44,
     -89,  -22,   54,      -71,  -32,   40,      -51,  -43,   26,      -32,  -54,   13,
     -13,  -65,    0,        6,  -75,  -13,       24,  -86,  -27,       44,  -97,  -40,
     -87,  -23,   58,      -68,  -34,   44,      -49,  -44,   30,      -30,  -55,   17,
     -11,  -66,    3,        8,  -77,   -9,       27,  -87,  -23,       46,  -98,  -36,
     -84,  -24,   62,      -66,  -35,   49,      -46,  -46,   35,      -27,  -57,   22,
      -8,  -67,    8,       11,  -78,   -5,       30,  -89,  -18,       49, -100,  -32,
     -82,  -26,   66,      -63,  -36,   53,      -44,  -47,   39,      -25,  -58,   26,
      -6,  -69,   12,       13,  -79,   -1,       32,  -90,  -14,       51, -101,  -28,
     -80,  -27,   70,      -61,  -38,   57,      -41,  -49,   43,      -23,  -59,   30,
      -3,  -70,   16,       16,  -81,    2,       34,  -91,  -10,       54, -102,  -24,
     -77,  -28,   74,      -58,  -39,   61,      -39,  -50,   47,      -20,  -61,   34,
      -1,  -72,   20,       18,  -82,    6,       37,  -93,   -6,       56, -104,  -20,
     -74,  -30,   79,      -56,  -41,   65,      -36,  -52,   51,      -18,  -62,   38,
       2,  -73,   24,       21,  -84,   11,       39,  -94,   -2,       59, -105,  -15,
     -72,  -31,   83,      -53,  -42,   69,      -34,  -53,   55,      -15,  -63,   42,
       4,  -74,   28,       23,  -85,   15,       42,  -96,    1,       61, -107,  -11,
     -70,  -33,   87,      -51,  -43,   73,      -32,  -54,   59,      -13,  -65,   46,
       7,  -76,   32,       25,  -86,   19,       44,  -97,    5,       64, -108,   -7,
     -67,  -34,   91,      -49,  -45,   77,      -29,  -56,   63,      -10,  -66,   50,
       9,  -77,   36,       28,  -88,   23,       47,  -98,    9,       66, -109,   -3,
     -65,  -35,   95,      -46,  -46,   81,      -27,  -57,   67,       -8,  -68,   54,
      11,  -78,   40,       30,  -89,   27,       49, -100,   13,       68, -111,    0,
     -62,  -37,   99,      -43,  -48,   86,      -24,  -58,   72,       -5,  -69,   59,
      14,  -80,   45,       33,  -91,   31,       52, -101,   18,       71, -112,    4,
     -60,  -38,  103,      -41,  -49,   90,      -22,  -60,   76,       -3,  -70,   63,
      16,  -81,   49,       35,  -92,   35,       54, -103,   22,       73, -113,    8,
     -57,  -40,  107,      -39,  -50,   94,      -19,  -61,   80,        0,  -72,   67,
      19,  -83,   53,       38,  -93,   39,       56, -104,   26,       76, -115,   12,
     -55,  -41,  111,      -36,  -52,   98,      -17,  -62,   84,        2,  -73,   71,
      21,  -84,   57,       40,  -95,   43,       59, -105,   30,       78, -116,   16,
     -52,  -42,  116,      -34,  -53,  102,      -14,  -64,   88,        5,  -75,   75,
      24,  -86,   61,       43,  -96,   48,       62, -107,   34,       81, -118,   21,
     -50,  -44,  120,      -31,  -54,  106,      -12,  -65,   92,        7,  -76,   79,
      26,  -87,   65,       45,  -97,   52,       64, -108,   38,       83, -119,   25,
     -48,  -45,  124,      -29,  -56,  110,       -9,  -67,   96,        9,  -77,   83,
      29,  -88,   69,       48,  -99,   56,       66, -109,   42,       86, -120,   29,
    -123,    1,   -4,     -104,   -9,  -17,      -85,  -20,  -31,      -66,  -30,  -44,
     -47,  -41,  -58,      -28,  -52,  -71,       -9,  -62,  -85,       10,  -73,  -99,
    -121,    0,    0,     -102,  -10,  -13,      -82,  -21,  -27,      -64,  -32,  -40,
     -44,  -43,  -54,      -25,  -53,  -67,       -7,  -64,  -81,       13,  -75,  -95,
    -118,   -1,    4,      -99,  -11,   -9,      -80,  -22,  -23,      -61,  -33,  -36,
     -42,  -44,  -50,      -23,  -55,  -63,       -4,  -65,  -77,       15,  -76,  -91,
    -115,   -2,    8,      -97,  -13,   -4,      -77,  -24,  -18,      -58,  -35,  -32,
     -39,  -45,  -45,      -20,  -56,  -59,       -2,  -67,  -72,       18,  -78,  -86,
    -113,   -4,   12,      -94,  -14,    0,      -75,  -25,  -14,      -56,  -36,  -28,
     -37,  -47,  -41,      -18,  -57,  -55,        1,  -68,  -68,       20,  -79,  -82,
    -111,   -5,   16,      -92,  -16,    3,      -72,  -27,  -10,      -54,  -37,  -24,
     -34,  -48,  -37,      -16,  -59,  -51,        3,  -69,  -64,       23,  -80,  -78,
    -108,   -6,   20,      -89,  -17,    7,      -70,  -28,   -6,      -51,  -39,  -20,
     -32,  -49,  -33,      -13,  -60,  -47,        6,  -71,  -60,       25,  -82,  -74,
    -106,   -8,   25,      -87,  -19,   11,      -67,  -29,   -2,      -49,  -40,  -15,
     -29,  -51,  -29,      -10,  -62,  -42,        8,  -72,  -56,       28,  -83,  -70,
    -103,   -9,   29,      -84,  -20,   15,      -65,  -31,    1,      -46,  -41,  -11,
     -27,  -52,  -25,       -8,  -63,  -38,       11,  -74,  -52,       30,  -84,  -66,
    -101,  -11,   33,      -82,  -21,   19,      -63,  -32,    5,      -44,  -43,   -7,
     -24,  -54,  -21,       -6,  -64,  -34,       13,  -75,  -48,       32,  -86,  -62,
     -98,  -12,   37,      -80,  -23,   23,      -60,  -34,    9,      -41,  -44,   -3,
     -22,  -55,  -17,       -3,  -66,  -30,       16,  -76,  -44,       35,  -87,  -58,
     -96,  -13,   41,      -77,  -24,   27,      -58,  -35,   13,      -39,  -45,    0,
     -20,  -56,  -13,       -1,  -67,  -26,       18,  -78,  -40,       37,  -89,  -54,
     -93,  -15,   45,      -75,  -25,   32,      -55,  -36,   18,      -36,  -47,    4,
     -17,  -58,   -8,        2,  -69,  -22,       21,  -79,  -35,       40,  -90,  -49,
     -91,  -16,   49,      -72,  -27,   36,      -53,  -38,   22,      -34,  -48,    8,
     -15,  -59,   -4,        4,  -70,  -18,       23,  -80,  -31,       42,  -91,  -45,
     -89,  -18,   53,      -70,  -28,   40,      -50,  -39,   26,      -32,  -50,   12,
     -12,  -61,    0,        7,  -71,  -14,       25,  -82,  -27,       45,  -93,  -41,
     -86,  -19,   57,      -67,  -30,   44,      -48,  -40,   30,      -29,  -51,   16,
     -10,  -62,    3,        9,  -73,  -10,       28,  -83,  -23,       47,  -94,  -37,
     -83,  -20,   62,      -65,  -31,   48,      -45,  -42,   34,      -26,  -53,   21,
      -7,  -63,    7,       12,  -74,   -5,       30,  -85,  -19,       50,  -96,  -33,
     -81,  -22,   66,      -62,  -32,   52,      -43,  -43,   38,      -24,  -54,   25,
      -5,  -65,   11,       14,  -75,   -1,       33,  -86,  -15,       52,  -97,  -29,
     -79,  -23,   70,      -60,  -34,   56,      -40,  -45,   42,      -22,  -55,   29,
      -2,  -66,   15,       16,  -77,    2,       35,  -87,  -11,       55,  -98,  -25,
     -76,  -24,   74,      -57,  -35,   60,      -38,  -46,   46,      -19,  -57,   33,
       0,  -68,   19,       19,  -78,    6,       38,  -89,   -7,       57, -100,  -21,
     -74,  -26,   78,      -55,  -37,   65,      -35,  -48,   51,      -17,  -58,   37,
       3,  -69,   24,       22,  -80,   10,       40,  -90,   -2,       60, -101,  -16,
     -71,  -27,   82,      -52,  -38,   69,      -33,  -49,   55,      -14,  -59,   41,
       5,  -70,   28,       24,  -81,   14,       43,  -92,    1,       62, -103,  -12,
     -69,  -29,   86,      -50,  -39,   73,      -31,  -50,   59,      -12,  -61,   45,
       8,  -72,   32,       26,  -82,   18,       45,  -93,    5,       64, -104,   -8,
     -66,  -30,   90,      -48,  -41,   77,      -28,  -52,   63,       -9,  -62,   49,
      10,  -73,   36,       29,  -84,   22,       47,  -94,    9,       67, -105,   -4,
     -64,  -31,   94,      -45,  -42,   81,      -26,  -53,   67,       -7,  -64,   53,
      12,  -74,   40,       31,  -85,   26,       50,  -96,   13,       69, -107,    0,
     -61,  -33,   99,      -43,  -44,   85,      -23,  -54,   71,       -4,  -65,   58,
      15,  -76,   44,       34,  -87,   31,       53,  -97,   17,       72, -108,    3,
     -59,  -34,  103,      -40,  -45,   89,      -21,  -56,   75,       -2,  -66,   62,
      17,  -77,   48,       36,  -88,   35,       55,  -99,   21,       74, -109,    7,
     -57,  -36,  107,      -38,  -46,   93,      -18,  -57,   79,        0,  -68,   66,
      20,  -79,   52,       39,  -89,   39,       57, -100,   25,       77, -111,   11,
     -54,  -37,  111,      -35,  -48,   97,      -16,  -58,   83,        3,  -69,   70,
      22,  -80,   56,       41,  -91,   43,       60, -101,   29,       79, -112,   15,
     -51,  -38,  115,      -33,  -49,  102,      -13,  -60,   88,        6,  -71,   74,
      25,  -82,   61,       44,  -92,   47,       62, -103,   34,       82, -114,   20,
     -49,  -40,  119,      -30,  -50,  106,      -11,  -61,   92,        8,  -72,   78,
      27,  -83,   65,       46,  -93,   51,       65, -104,   38,       84, -115,   24,
     -47,  -41,  123,      -28,  -52,  110,       -8,  -63,   96,       10,  -73,   82,
      30,  -84,   69,       48,  -95,   55,       67, -105,   42,       87, -116,   28,
    -122,    5,   -4,     -103,   -5,  -18,      -84,  -16,  -31,      -65,  -26,  -45,
     -46,  -37,  -59,      -27,  -48,  -72,       -8,  -58,  -85,       11,  -69,  -99,
    -120,    4,    0,     -101,   -6,  -14,      -81,  -17,  -27,      -63,  -28,  -41,
     -43,  -39,  -55,      -24,  -49,  -68,       -6,  -60,  -81,       14,  -71,  -95,
    -117,    2,    3,      -98,   -7,  -10,      -79,  -18,  -23,      -60,  -29,  -37,
     -41,  -40,  -51,      -22,  -51,  -64,       -3,  -61,  -77,       16,  -72,  -91,
    -115,    1,    7,      -96,   -9,   -5,      -76,  -20,  -19,      -58,  -31,  -32,
     -38,  -41,  -46,      -19,  -52,  -59,       -1,  -63,  -73,       19,  -74,  -87,
    -112,    0,   11,      -93,  -10,   -1,      -74,  -21,  -15,      -55,  -32,  -28,
     -36,  -43,  -42,      -17,  -53,  -55,        2,  -64,  -69,       21,  -75,  -83,
    -110,   -1,   15,      -91,  -12,    2,      -72,  -23,  -11,      -53,  -33,  -24,
     -33,  -44,  -38,      -15,  -55,  -51,        4,  -65,  -65,       24,  -76,  -79,
    -107,   -2,   19,      -89,  -13,    6,      -69,  -24,   -7,      -50,  -35,  -20,
     -31,  -45,  -34,      -12,  -56,  -47,        7,  -67,  -61,       26,  -78,  -75,
    -105,   -4,   24,      -86,  -15,   10,      -66,  -25,   -2,      -48,  -36,  -16,
     -28,  -47,  -30,      -10,  -58,  -43,        9,  -68,  -56,       29,  -79,  -70,
    -102,   -5,   28,      -83,  -16,   14,      -64,  -27,    1,      -45,  -37,  -12,
     -26,  -48,  -26,       -7,  -59,  -39,       12,  -70,  -52,       31,  -80,  -66,
    -100,   -7,   32,      -81,  -17,   18,      -62,  -28,    5,      -43,  -39,   -8,
     -24,  -50,  -22,       -5,  -60,  -35,       14,  -71,  -48,       33,  -82,  -62,
     -97,   -8,   36,      -79,  -19,   22,      -59,  -30,    9,      -41,  -40,   -4,
     -21,  -51,  -18,       -2,  -62,  -31,       16,  -72,  -44,       36,  -83,  -58,
     -95,   -9,   40,      -76,  -20,   26,      -57,  -31,   13,      -38,  -41,    0,
     -19,  -52,  -14,        0,  -63,  -27,       19,  -74,  -40,       38,  -85,  -54,
     -92,  -11,   44,      -74,  -21,   31,      -54,  -32,   17,      -35,  -43,    4,
     -16,  -54,   -9,        3,  -65,  -22,       21,  -75,  -36,       41,  -86,  -50,
     -90,  -12,   48,      -71,  -23,   35,      -52,  -34,   21,      -33,  -44,    8,
     -14,  -55,   -5,        5,  -66,  -18,       24,  -76,  -32,       43,  -87,  -46,
     -88,  -14,   52,      -69,  -24,   39,      -49,  -35,   25,      -31,  -46,   12,
     -11,  -57,   -1,        7,  -67,  -14,       26,  -78,  -28,       46,  -89,  -42,
     -85,  -15,   56,      -66,  -26,   43,      -47,  -36,   29,      -28,  -47,   16,
      -9,  -58,    2,       10,  -69,  -10,       29,  -79,  -24,       48,  -90,  -38,
     -83,  -16,   61,      -64,  -27,   47,      -44,  -38,   34,      -26,  -49,   20,
      -6,  -59,    6,       13,  -70,   -6,       31,  -81,  -19,       51,  -92,  -33,
     -80,  -18,   65,      -61,  -28,   51,      -42,  -39,   38,      -23,  -50,   24,
      -4,  -61,   10,       15,  -71,   -2,       34,  -82,  -15,       53,  -93,  -29,
     -78,  -19,   69,      -59,  -30,   55,      -40,  -41,   42,      -21,  -51,   28,
      -1,  -62,   14,       17,  -73,    1,       36,  -83,  -11,       56,  -94,  -25,
     -75,  -20,   73,      -57,  -31,   59,      -37,  -42,   46,      -18,  -53,   32,
       1,  -64,   18,       20,  -74,    5,       39,  -85,   -7,       58,  -96,  -21,
     -73,  -22,   77,      -54,  -33,   64,      -34,  -44,   50,      -16,  -54,   37,
       4,  -65,   23,       22,  -76,   10,       41,  -86,   -3,       61,  -97,  -17,
     -70,  -23,   81,      -51,  -34,   68,      -32,  -45,   54,      -13,  -55,   41,
       6,  -66,   27,       25,  -77,   14,       44,  -88,    0,       63,  -99,  -13,
     -68,  -25,   85,      -49,  -35,   72,      -30,  -46,   58,      -11,  -57,   45,
       8,  -68,   31,       27,  -78,   18,       46,  -89,    4,       65, -100,   -9,
     -65,  -26,   89,      -47,  -37,   76,      -27,  -48,   62,       -9,  -58,   49,
      11,  -69,   35,       30,  -80,   22,       48,  -90,    8,       68, -101,   -5,
     -63,  -27,   93,      -44,  -38,   80,      -25,  -49,   66,       -6,  -60,   53,
      13,  -70,   39,       32,  -81,   26,       51,  -92,   12,       70, -103,   -1,
     -60,  -29,   98,      -42,  -40,   84,      -22,  -50,   71,       -3,  -61,   57,
      16,  -72,   43,       35,  -83,   30,       53,  -93,   17,       73, -104,    3,
     -58,  -30,  102,      -39,  -41,   88,      -20,  -52,   75,       -1,  -62,   61,
      18,  -73,   47,       37,  -84,   34,       56,  -95,   21,       75, -105,    7,
     -56,  -32,  106,      -37,  -42,   92,      -17,  -53,   79,        1,  -64,   65,
      21,  -75,   51,       39,  -85,   38,       58,  -96,   25,       78, -107,   11,
     -53,  -33,  110,      -34,  -44,   96,      -15,  -54,   83,        4,  -65,   69,
      23,  -76,   55,       42,  -87,   42,       61,  -97,   29,       80, -108,   15,
     -51,  -34,  114,      -32,  -45,  101,      -12,  -56,   87,        6,  -67,   74,
      26,  -78,   60,       45,  -88,   47,       63,  -99,   33,       83, -110,   19,
     -48,  -36,  118,      -29,  -46,  105,      -10,  -57,   91,        9,  -68,   78,
      28,  -79,   64,       47,  -89,   51,       66, -100,   37,       85, -111,   23,
     -46,  -37,  122,      -27,  -48,  109,       -8,  -59,   95,       11,  -69,   82,
      31,  -80,   68,       49,  -91,   55,       68, -101,   41,       88, -112,   27,
    -121,    9,   -5,     -102,    0,  -18,      -83,  -11,  -32,      -64,  -22,  -45,
     -45,  -33,  -59,      -26,  -43,  -73,       -7,  -54,  -86,       12,  -65, -100,
    -119,    8,   -1,     -100,   -2,  -14,      -80,  -13,  -28,      -62,  -23,  -41,
     -42,  -34,  -55,      -23,  -45,  -69,       -5,  -55,  -82,       15,  -66,  -96,
    -116,    7,    2,      -97,   -3,  -10,      -78,  -14,  -24,      -59,  -24,  -37,
     -40,  -35,  -51,      -21,  -46,  -65,       -2,  -57,  -78,       17,  -68,  -92,
    -113,    5,    7,      -95,   -4,   -6,      -75,  -15,  -20,      -57,  -26,  -33,
     -37,  -37,  -47,      -18,  -48,  -60,        0,  -58,  -74,       20,  -69,  -87,
    -111,    4,   11,      -92,   -6,   -2,      -73,  -17,  -16,      -54,  -27,  -29,
     -35,  -38,  -43,      -16,  -49,  -56,        3,  -59,  -70,       22,  -70,  -83,
    -109,    2,   15,      -90,   -7,    1,      -71,  -18,  -12,      -52,  -29,  -25,
     -32,  -40,  -39,      -14,  -50,  -52,        5,  -61,  -66,       25,  -72,  -79,
    -106,    1,   19,      -88,   -9,    5,      -68,  -19,   -8,      -49,  -30,  -21,
     -30,  -41,  -35,      -11,  -52,  -48,        8,  -62,  -62,       27,  -73,  -75,
    -104,    0,   23,      -85,  -10,   10,      -65,  -21,   -3,      -47,  -32,  -16,
     -27,  -43,  -30,       -9,  -53,  -44,       10,  -64,  -57,       30,  -75,  -71,
    -101,   -1,   27,      -82,  -11,   14,      -63,  -22,    0,      -44,  -33,  -12,
     -25,  -44,  -26,       -6,  -54,  -40,       13,  -65,  -53,       32,  -76,  -67,
     -99,   -2,   31,      -80,  -13,   18,      -61,  -24,    4,      -42,  -34,   -8,
     -23,  -45,  -22,       -4,  -56,  -36,       15,  -66,  -49,       34,  -77,  -63,
     -96,   -3,   35,      -78,  -14,   22,      -58,  -25,    8,      -39,  -36,   -4,
     -20,  -47,  -18,       -1,  -57,  -32,       17,  -68,  -45,       37,  -79,  -59,
     -94,   -5,   39,      -75,  -15,   26,      -56,  -26,   12,      -37,  -37,    0,
     -18,  -48,  -14,        1,  -59,  -28,       20,  -69,  -41,       39,  -80,  -55,
     -91,   -6,   44,      -73,  -17,   30,      -53,  -28,   16,      -34,  -38,    3,
     -15,  -49,  -10,        4,  -60,  -23,       23,  -71,  -37,       42,  -82,  -50,
     -89,   -8,   48,      -70,  -18,   34,      -51,  -29,   20,      -32,  -40,    7,
     -13,  -51,   -6,        6,  -61,  -19,       25,  -72,  -33,       44,  -83,  -46,
     -87,   -9,   52,      -68,  -20,   38,      -48,  -31,   24,      -30,  -41,   11,
     -10,  -52,   -2,        9,  -63,  -15,       27,  -73,  -29,       47,  -84,  -42,
     -84,  -10,   56,      -65,  -21,   42,      -46,  -32,   28,      -27,  -43,   15,
      -8,  -53,    1,       11,  -64,  -11,       30,  -75,  -25,       49,  -86,  -38,
     -81,  -12,   60,      -63,  -23,   47,      -43,  -33,   33,      -25,  -44,   20,
      -5,  -55,    6,       14,  -66,   -7,       32,  -76,  -20,       52,  -87,  -34,
     -79,  -13,   64,      -60,  -24,   51,      -41,  -35,   37,      -22,  -45,   24,
      -3,  -56,   10,       16,  -67,   -3,       35,  -78,  -16,       54,  -88,  -30,
     -77,  -15,   68,      -58,  -25,   55,      -39,  -36,   41,      -20,  -47,   28,
       0,  -58,   14,       18,  -68,    0,       37,  -79,  -12,       57,  -90,  -26,
     -74,  -16,   72,      -56,  -27,   59,      -36,  -38,   45,      -17,  -48,   32,
       2,  -59,   18,       21,  -70,    4,       40,  -80,   -8,       59,  -91,  -22,
     -72,  -17,   77,      -53,  -28,   63,      -33,  -39,   49,      -15,  -50,   36,
       5,  -61,   22,       23,  -71,    9,       42,  -82,   -4,       62,  -93,  -17,
     -69,  -19,   81,      -50,  -29,   67,      -31,  -40,   53,      -12,  -51,   40,
       7,  -62,   26,       26,  -73,   13,       45,  -83,    0,       64,  -94,  -13,
     -67,  -20,   85,      -48,  -31,   71,      -29,  -42,   57,      -10,  -52,   44,
       9,  -63,   30,       28,  -74,   17,       47,  -84,    3,       66,  -95,   -9,
     -64,  -22,   89,      -46,  -32,   75,      -26,  -43,   61,       -8,  -54,   48,
      12,  -65,   34,       31,  -75,   21,       49,  -86,    7,       69,  -97,   -5,
     -62,  -23,   93,      -43,  -33,   79,      -24,  -44,   65,       -5,  -55,   52,
      14,  -66,   38,       33,  -77,   25,       52,  -87,   11,       71,  -98,   -1,
     -59,  -24,   97,      -41,  -35,   84,      -21,  -46,   70,       -2,  -57,   57,
      17,  -67,   43,       36,  -78,   29,       55,  -89,   16,       74, -100,    2,
     -57,  -26,  101,      -38,  -36,   88,      -19,  -47,   74,        0,  -58,   61,
      19,  -69,   47,       38,  -79,   33,       57,  -90,   20,       76, -101,    6,
     -55,  -27,  105,      -36,  -38,   92,      -16,  -49,   78,        2,  -59,   65,
      22,  -70,   51,       41,  -81,   37,       59,  -91,   24,       79, -102,   10,
     -52,  -28,  109,      -33,  -39,   96,      -14,  -50,   82,        5,  -61,   69,
      24,  -72,   55,       43,  -82,   41,       62,  -93,   28,       81, -104,   14,
     -49,  -30,  114,      -31,  -41,  100,      -11,  -52,   86,        7,  -62,   73,
      27,  -73,   59,       46,  -84,   46,       64,  -94,   32,       84, -105,   19,
     -47,  -31,  118,      -28,  -42,  104,       -9,  -53,   90,       10,  -63,   77,
      29,  -74,   63,       48,  -85,   50,       67,  -96,   36,       86, -107,   23,
     -45,  -33,  122,      -26,  -43,  108,       -7,  -54,   94,       12,  -65,   81,
      32,  -76,   67,       50,  -86,   54,       69,  -97,   40,       89, -108,   27,
    -120,   13,   -6,     -101,    3,  -19,      -82,   -7,  -33,      -63,  -18,  -46,
     -44,  -29,  -60,      -25,  -39,  -73,       -6,  -50,  -87,       13,  -61, -101,
    -118,   12,   -2,      -99,    1,  -15,      -79,   -9,  -29,      -61,  -19,  -42,
     -41,  -30,  -56,      -23,  -41,  -69,       -4,  -51,  -83,       16,  -62,  -97,
    -115,   11,    1,      -96,    0,  -11,      -77,  -10,  -25,      -58,  -20,  -38,
     -39,  -31,  -52,      -20,  -42,  -65,       -1,  -53,  -79,       18,  -64,  -93,
    -113,    9,    6,      -94,    0,   -6,      -74,  -11,  -20,      -56,  -22,  -34,
     -36,  -33,  -47,      -17,  -44,  -61,        1,  -54,  -74,       21,  -65,  -88,
    -110,    8,   10,      -91,   -2,   -2,      -72,  -13,  -16,      -53,  -23,  -30,
     -34,  -34,  -43,      -15,  -45,  -57,        4,  -55,  -70,       23,  -66,  -84,
    -108,    6,   14,      -89,   -3,    1,      -70,  -14,  -12,      -51,  -25,  -26,
     -31,  -36,  -39,      -13,  -46,  -53,        6,  -57,  -66,       25,  -68,  -80,
    -105,    5,   18,      -87,   -5,    5,      -67,  -15,   -8,      -48,  -26,  -22,
     -29,  -37,  -35,      -10,  -48,  -49,        8,  -58,  -62,       28,  -69,  -76,
    -103,    4,   22,      -84,   -6,    9,      -65,  -17,   -4,      -46,  -28,  -17,
     -26,  -39,  -31,       -8,  -49,  -44,       11,  -60,  -58,       31,  -71,  -72,
    -100,    2,   26,      -82,   -7,   13,      -62,  -18,    0,      -43,  -29,  -13,
     -24,  -40,  -27,       -5,  -50,  -40,       14,  -61,  -54,       33,  -72,  -68,
     -98,    1,   30,      -79,   -9,   17,      -60,  -20,    3,      -41,  -30,   -9,
     -22,  -41,  -23,       -3,  -52,  -36,       16,  -62,  -50,       35,  -73,  -64,
     -96,    0,   34,      -77,  -10,   21,      -57,  -21,    7,      -39,  -32,   -5,
     -19,  -43,  -19,        0,  -53,  -32,       18,  -64,  -46,       38,  -75,  -60,
     -93,   -1,   38,      -74,  -11,   25,      -55,  -22,   11,      -36,  -33,   -1,
     -17,  -44,  -15,        2,  -55,  -28,       21,  -65,  -42,       40,  -76,  -56,
     -90,   -2,   43,      -72,  -13,   30,      -52,  -24,   16,      -34,  -34,    2,
     -14,  -45,  -10,        5,  -56,  -24,       23,  -67,  -37,       43,  -78,  -51,
     -88,   -4,   47,      -69,  -14,   34,      -50,  -25,   20,      -31,  -36,    6,
     -12,  -47,   -6,        7,  -57,  -20,       26,  -68,  -33,       45,  -79,  -47,
     -86,   -5,   51,      -67,  -16,   38,      -48,  -27,   24,      -29,  -37,   10,
      -9,  -48,   -2,        9,  -59,  -16,       28,  -69,  -29,       48,  -80,  -43,
     -83,   -6,   55,      -64,  -17,   42,      -45,  -28,   28,      -26,  -39,   14,
      -7,  -49,    1,       12,  -60,  -12,       31,  -71,  -25,       50,  -82,  -39,
     -81,   -8,   59,      -62,  -19,   46,      -42,  -29,   32,      -24,  -40,   19,
      -4,  -51,    5,       15,  -62,   -7,       33,  -72,  -21,       53,  -83,  -35,
     -78,   -9,   63,      -59,  -20,   50,      -40,  -31,   36,      -21,  -41,   23,
      -2,  -52,    9,       17,  -63,   -3,       36,  -74,  -17,       55,  -84,  -31,
     -76,  -11,   67,      -57,  -21,   54,      -38,  -32,   40,      -19,  -43,   27,
       1,  -54,   13,       19,  -64,    0,       38,  -75,  -13,       57,  -86,  -27,
     -73,  -12,   71,      -55,  -23,   58,      -35,  -34,   44,      -16,  -44,   31,
       3,  -55,   17,       22,  -66,    4,       40,  -76,   -9,       60,  -87,  -23,
     -71,  -13,   76,      -52,  -24,   63,      -33,  -35,   49,      -14,  -46,   35,
       6,  -57,   22,       24,  -67,    8,       43,  -78,   -4,       63,  -89,  -18,
     -68,  -15,   80,      -50,  -25,   67,      -30,  -36,   53,      -11,  -47,   39,
       8,  -58,   26,       27,  -69,   12,       46,  -79,    0,       65,  -90,  -14,
     -66,  -16,   84,      -47,  -27,   71,      -28,  -38,   57,       -9,  -48,   43,
      10,  -59,   30,       29,  -70,   16,       48,  -80,    3,       67,  -91,  -10,
     -64,  -18,   88,      -45,  -28,   75,      -25,  -39,   61,       -7,  -50,   47,
      13,  -61,   34,       32,  -71,   20,       50,  -82,    7,       70,  -93,   -6,
     -61,  -19,   92,      -42,  -29,   79,      -23,  -40,   65,       -4,  -51,   51,
      15,  -62,   38,       34,  -73,   24,       53,  -83,   11,       72,  -94,   -2,
     -58,  -20,   96,      -40,  -31,   83,      -20,  -42,   69,       -2,  -53,   56,
      18,  -63,   42,       37,  -74,   29,       55,  -85,   15,       75,  -96,    1,
     -56,  -22,  100,      -37,  -32,   87,      -18,  -43,   73,        1,  -54,   60,
      20,  -65,   46,       39,  -75,   33,       58,  -86,   19,       77,  -97,    5,
     -54,  -23,  104,      -35,  -34,   91,      -16,  -45,   77,        3,  -55,   64,
      23,  -66,   50,       41,  -77,   37,       60,  -87,   23,       80,  -98,    9,
     -51,  -24,  108,      -32,  -35,   95,      -13,  -46,   81,        6,  -57,   68,
      25,  -68,   54,       44,  -78,   41,       63,  -89,   27,       82, -100,   13,
     -49,  -26,  113,      -30,  -37,  100,      -10,  -48,   86,        8,  -58,   72,
      28,  -69,   59,       47,  -80,   45,       65,  -90,   32,       85, -101,   18,
     -46,  -27,  117,      -27,  -38,  104,       -8,  -49,   90,       11,  -59,   76,
      30,  -70,   63,       49,  -81,   49,       68,  -92,   36,       87, -103,   22,
     -44,  -29,  121,      -25,  -39,  108,       -6,  -50,   94,       13,  -61,   80,
      33,  -72,   67,       51,  -82,   53,       70,  -93,   40,       89, -104,   26,
    -119,   17,   -6,     -100,    7,  -20,      -81,   -3,  -33,      -62,  -14,  -47,
     -43,  -25,  -61,      -24,  -35,  -74,       -5,  -46,  -87,       14,  -57, -101,
    -117,   16,   -2,      -98,    5,  -16,      -79,   -5,  -29,      -60,  -15,  -43,
     -40,  -26,  -57,      -22,  -37,  -70,       -3,  -47,  -83,       17,  -58,  -97,
    -114,   15,    1,      -96,    4,  -12,      -76,   -6,  -25,      -57,  -16,  -39,
     -38,  -27,  -53,      -19,  -38,  -66,        0,  -49,  -79,       19,  -60,  -93,
    -112,   13,    5,      -93,    3,   -7,      -73,   -7,  -21,      -55,  -18,  -34,
     -35,  -29,  -48,      -17,  -40,  -62,        2,  -50,  -75,       22,  -61,  -89,
    -109,   12,    9,      -90,    1,   -3,      -71,   -9,  -17,      -52,  -19,  -30,
     -33,  -30,  -44,      -14,  -41,  -58,        5,  -51,  -71,       24,  -62,  -85,
    -107,   10,   13,      -88,    0,    0,      -69,  -10,  -13,      -50,  -21,  -26,
     -31,  -32,  -40,      -12,  -42,  -54,        7,  -53,  -67,       26,  -64,  -81,
    -104,    9,   17,      -86,   -1,    4,      -66,  -11,   -9,      -48,  -22,  -22,
     -28,  -33,  -36,       -9,  -44,  -50,        9,  -54,  -63,       29,  -65,  -77,
    -102,    8,   22,      -83,   -2,    8,      -64,  -13,   -4,      -45,  -24,  -18,
     -25,  -35,  -32,       -7,  -45,  -45,       12,  -56,  -58,       31,  -67,  -72,
     -99,    6,   26,      -81,   -3,   12,      -61,  -14,    0,      -42,  -25,  -14,
     -23,  -36,  -28,       -4,  -46,  -41,       14,  -57,  -54,       34,  -68,  -68,
     -97,    5,   30,      -78,   -5,   16,      -59,  -16,    3,      -40,  -26,  -10,
     -21,  -37,  -24,       -2,  -48,  -37,       17,  -58,  -50,       36,  -69,  -64,
     -95,    4,   34,      -76,   -6,   20,      -56,  -17,    7,      -38,  -28,   -6,
     -18,  -39,  -20,        0,  -49,  -33,       19,  -60,  -46,       39,  -71,  -60,
     -92,    2,   38,      -73,   -7,   24,      -54,  -18,   11,      -35,  -29,   -2,
     -16,  -40,  -16,        3,  -51,  -29,       22,  -61,  -42,       41,  -72,  -56,
     -90,    1,   42,      -71,   -9,   29,      -51,  -20,   15,      -33,  -30,    2,
     -13,  -41,  -11,        6,  -52,  -25,       24,  -63,  -38,       44,  -74,  -52,
     -87,    0,   46,      -68,  -10,   33,      -49,  -21,   19,      -30,  -32,    6,
     -11,  -43,   -7,        8,  -53,  -21,       27,  -64,  -34,       46,  -75,  -48,
     -85,   -1,   50,      -66,  -12,   37,      -47,  -23,   23,      -28,  -33,   10,
      -8,  -44,   -3,       10,  -55,  -17,       29,  -65,  -30,       49,  -76,  -44,
     -82,   -2,   54,      -64,  -13,   41,      -44,  -24,   27,      -25,  -35,   14,
      -6,  -45,    0,       13,  -56,  -13,       32,  -67,  -26,       51,  -78,  -40,
     -80,   -4,   59,      -61,  -15,   45,      -42,  -25,   32,      -23,  -36,   18,
      -3,  -47,    4,       15,  -58,   -8,       34,  -68,  -21,       54,  -79,  -35,
     -77,   -5,   63,      -58,  -16,   49,      -39,  -27,   36,      -20,  -37,   22,
      -1,  -48,    8,       18,  -59,   -4,       37,  -70,  -17,       56,  -80,  -31,
     -75,   -7,   67,      -56,  -17,   53,      -37,  -28,   40,      -18,  -39,   26,
       1,  -50,   12,       20,  -60,    0,       39,  -71,  -13,       58,  -82,  -27,
     -72,   -8,   71,      -54,  -19,   57,      -34,  -30,   44,      -16,  -40,   30,
       4,  -51,   16,       23,  -62,    3,       41,  -72,   -9,       61,  -83,  -23,
     -70,   -9,   75,      -51,  -20,   62,      -32,  -31,   48,      -13,  -42,   35,
       7,  -53,   21,       25,  -63,    7,       44,  -74,   -5,       63,  -85,  -19,
     -67,  -11,   79,      -49,  -21,   66,      -29,  -32,   52,      -10,  -43,   39,
       9,  -54,   25,       28,  -65,   11,       46,  -75,   -1,       66,  -86,  -15,
     -65,  -12,   83,      -46,  -23,   70,      -27,  -34,   56,       -8,  -44,   43,
      11,  -55,   29,       30,  -66,   15,       49,  -76,    2,       68,  -87,  -11,
     -63,  -14,   87,      -44,  -24,   74,      -24,  -35,   60,       -6,  -46,   47,
      14,  -57,   33,       32,  -67,   19,       51,  -78,    6,       71,  -89,   -7,
     -60,  -15,   91,      -41,  -25,   78,      -22,  -36,   64,       -3,  -47,   51,
      16,  -58,   37,       35,  -69,   23,       54,  -79,   10,       73,  -90,   -3,
     -58,  -16,   96,      -39,  -27,   82,      -19,  -38,   69,       -1,  -49,   55,
      19,  -59,   41,       38,  -70,   28,       56,  -81,   15,       76,  -92,    1,
     -55,  -18,  100,      -36,  -28,   86,      -17,  -39,   73,        2,  -50,   59,
      21,  -61,   45,       40,  -71,   32,       59,  -82,   19,       78,  -93,    5,
     -53,  -19,  104,      -34,  -30,   90,      -15,  -41,   77,        4,  -51,   63,
      24,  -62,   49,       42,  -73,   36,       61,  -83,   23,       80,  -94,    9,
     -50,  -20,  108,      -32,  -31,   94,      -12,  -42,   81,        7,  -53,   67,
      26,  -64,   53,       45,  -74,   40,       64,  -85,   27,       83,  -96,   13,
     -48,  -22,  112,      -29,  -33,   99,      -10,  -44,   85,        9,  -54,   72,
      29,  -65,   58,       47,  -76,   44,       66,  -86,   31,       86,  -97,   17,
     -45,  -23,  116,      -26,  -34,  103,       -7,  -45,   89,       12,  -55,   76,
      31,  -66,   62,       50,  -77,   48,       69,  -88,   35,       88,  -99,   21,
     -43,  -25,  120,      -24,  -35,  107,       -5,  -46,   93,       14,  -57,   80,
      33,  -68,   66,       52,  -78,   52,       71,  -89,   39,       90, -100,   25,
    -118,   21,   -7,      -99,   11,  -20,      -80,    0,  -34,      -61,  -10,  -47,
     -42,  -21,  -61,      -23,  -31,  -75,       -4,  -42,  -88,       15,  -53, -102,
    -116,   20,   -3,      -97,    9,  -16,      -78,   -1,  -30,      -59,  -11,  -43,
     -40,  -22,  -57,      -21,  -33,  -71,       -2,  -43,  -84,       17,  -54,  -98,
    -113,   19,    0,      -95,    8,  -12,      -75,   -2,  -26,      -56,  -12,  -39,
     -37,  -23,  -53,      -18,  -34,  -67,        0,  -45,  -80,       20,  -56,  -94,
    -111,   17,    5,      -92,    7,   -8,      -73,   -3,  -22,      -54,  -14,  -35,
     -34,  -25,  -49,      -16,  -36,  -62,        3,  -46,  -76,       23,  -57,  -89,
    -108,   16,    9,      -90,    5,   -4,      -70,   -5,  -18,      -51,  -15,  -31,
     -32,  -26,  -45,      -13,  -37,  -58,        6,  -47,  -72,       25,  -58,  -85,
    -106,   14,   13,      -87,    4,    0,      -68,   -6,  -14,      -49,  -17,  -27,
     -30,  -28,  -41,      -11,  -38,  -54,        8,  -49,  -68,       27,  -60,  -81,
    -104,   13,   17,      -85,    2,    3,      -65,   -7,  -10,      -47,  -18,  -23,
     -27,  -29,  -37,       -8,  -40,  -50,       10,  -50,  -64,       30,  -61,  -77,
    -101,   12,   21,      -82,    1,    8,      -63,   -9,   -5,      -44,  -20,  -18,
     -25,  -31,  -32,       -6,  -41,  -46,       13,  -52,  -59,       32,  -63,  -73,
     -98,   10,   25,      -80,    0,   12,      -60,  -10,   -1,      -42,  -21,  -14,
     -22,  -32,  -28,       -3,  -42,  -42,       15,  -53,  -55,       35,  -64,  -69,
     -96,    9,   29,      -77,   -1,   16,      -58,  -12,    2,      -39,  -22,  -10,
     -20,  -33,  -24,       -1,  -44,  -38,       18,  -54,  -51,       37,  -65,  -65,
     -94,    8,   33,      -75,   -2,   20,      -56,  -13,    6,      -37,  -24,   -6,
     -17,  -35,  -20,        1,  -45,  -34,       20,  -56,  -47,       40,  -67,  -61,
     -91,    6,   37,      -73,   -3,   24,      -53,  -14,   10,      -34,  -25,   -2,
     -15,  -36,  -16,        4,  -47,  -30,       23,  -57,  -43,       42,  -68,  -57,
     -89,    5,   42,      -70,   -5,   28,      -50,  -16,   14,      -32,  -26,    1,
     -12,  -37,  -12,        6,  -48,  -25,       25,  -59,  -39,       45,  -70,  -52,
     -86,    3,   46,      -67,   -6,   32,      -48,  -17,   18,      -29,  -28,    5,
     -10,  -39,   -8,        9,  -49,  -21,       28,  -60,  -35,       47,  -71,  -48,
     -84,    2,   50,      -65,   -8,   36,      -46,  -19,   22,      -27,  -29,    9,
      -8,  -40,   -4,       11,  -51,  -17,       30,  -61,  -31,       49,  -72,  -44,
     -81,    1,   54,      -63,   -9,   40,      -43,  -20,   26,      -25,  -31,   13,
      -5,  -41,    0,       14,  -52,  -13,       32,  -63,  -27,       52,  -74,  -40,
     -79,    0,   58,      -60,  -11,   45,      -41,  -21,   31,      -22,  -32,   18,
      -2,  -43,    4,       16,  -54,   -9,       35,  -64,  -22,       54,  -75,  -36,
     -76,   -1,   62,      -58,  -12,   49,      -38,  -23,   35,      -19,  -33,   22,
       0,  -44,    8,       19,  -55,   -5,       38,  -66,  -18,       57,  -76,  -32,
     -74,   -3,   66,      -55,  -13,   53,      -36,  -24,   39,      -17,  -35,   26,
       2,  -46,   12,       21,  -56,   -1,       40,  -67,  -14,       59,  -78,  -28,
     -72,   -4,   70,      -53,  -15,   57,      -33,  -26,   43,      -15,  -36,   30,
       5,  -47,   16,       24,  -58,    2,       42,  -68,  -10,       62,  -79,  -24,
     -69,   -5,   75,      -50,  -16,   61,      -31,  -27,   47,      -12,  -38,   34,
       7,  -49,   20,       26,  -59,    7,       45,  -70,   -6,       64,  -81,  -19,
     -66,   -7,   79,      -48,  -17,   65,      -28,  -28,   51,      -10,  -39,   38,
      10,  -50,   24,       29,  -61,   11,       47,  -71,   -2,       67,  -82,  -15,
     -64,   -8,   83,      -45,  -19,   69,      -26,  -30,   55,       -7,  -40,   42,
      12,  -51,   28,       31,  -62,   15,       50,  -72,    1,       69,  -83,  -11,
     -62,  -10,   87,      -43,  -20,   73,      -24,  -31,   59,       -5,  -42,   46,
      15,  -53,   32,       33,  -63,   19,       52,  -74,    5,       72,  -85,   -7,
     -59,  -11,   91,      -41,  -21,   77,      -21,  -32,   63,       -2,  -43,   50,
      17,  -54,   36,       36,  -65,   23,       55,  -75,    9,       74,  -86,   -3,
     -57,  -12,   95,      -38,  -23,   82,      -18,  -34,   68,        0,  -45,   55,
      20,  -55,   41,       38,  -66,   27,       57,  -77,   14,       77,  -88,    0,
     -54,  -14,   99,      -35,  -24,   86,      -16,  -35,   72,        3,  -46,   59,
      22,  -57,   45,       41,  -67,   31,       60,  -78,   18,       79,  -89,    4,
     -52,  -15,  103,      -33,  -26,   90,      -14,  -37,   76,        5,  -47,   63,
      24,  -58,   49,       43,  -69,   35,       62,  -79,   22,       81,  -90,    8,
     -49,  -16,  107,      -31,  -27,   94,      -11,  -38,   80,        7,  -49,   67,
      27,  -60,   53,       46,  -70,   39,       64,  -81,   26,       84,  -92,   12,
     -47,  -18,  112,      -28,  -29,   98,       -9,  -40,   84,       10,  -50,   71,
      30,  -61,   57,       48,  -72,   44,       67,  -82,   30,       86,  -93,   17,
     -44,  -19,  116,      -26,  -30,  102,       -6,  -41,   88,       13,  -51,   75,
      32,  -62,   61,       51,  -73,   48,       70,  -84,   34,       89,  -95,   21,
     -42,  -21,  120,      -23,  -31,  106,       -4,  -42,   92,       15,  -53,   79,
      34,  -64,   65,       53,  -74,   52,       72,  -85,   38,       91,  -96,   25,
    -117,   26,   -8,      -98,   15,  -21,      -79,    4,  -35,      -60,   -5,  -48,
     -41,  -16,  -62,      -22,  -27,  -75,       -3,  -37,  -89,       16,  -48, -103,
    -115,   25,   -4,      -96,   14,  -17,      -77,    3,  -31,      -58,   -7,  -44,
     -38,  -18,  -58,      -20,  -28,  -71,       -1,  -39,  -85,       18,  -50,  -99,
    -112,   23,    0,      -94,   13,  -13,      -74,    2,  -27,      -55,   -8,  -40,
     -36,  -19,  -54,      -17,  -30,  -67,        1,  -40,  -81,       21,  -51,  -95,
    -110,   22,    4,      -91,   11,   -8,      -72,    0,  -22,      -53,  -10,  -36,
     -33,  -20,  -49,      -15,  -31,  -63,        4,  -42,  -76,       24,  -53,  -90,
    -107,   20,    8,      -89,   10,   -4,      -69,    0,  -18,      -50,  -11,  -32,
     -31,  -22,  -45,      -12,  -32,  -59,        7,  -43,  -72,       26,  -54,  -86,
    -105,   19,   12,      -86,    8,    0,      -67,   -2,  -14,      -48,  -12,  -28,
     -29,  -23,  -41,      -10,  -34,  -55,        9,  -44,  -68,       28,  -55,  -82,
    -103,   18,   16,      -84,    7,    3,      -64,   -3,  -10,      -46,  -14,  -24,
     -26,  -24,  -37,       -7,  -35,  -51,       11,  -46,  -64,       31,  -57,  -78,
    -100,   16,   20,      -81,    5,    7,      -62,   -4,   -6,      -43,  -15,  -19,
     -24,  -26,  -33,       -5,  -37,  -46,       14,  -47,  -60,       33,  -58,  -74,
     -97,   15,   24,      -79,    4,   11,      -59,   -6,   -2,      -41,  -16,  -15,
     -21,  -27,  -29,       -2,  -38,  -42,       16,  -49,  -56,       36,  -59,  -70,
     -95,   13,   28,      -76,    3,   15,      -57,   -7,    1,      -38,  -18,  -11,
     -19,  -29,  -25,        0,  -39,  -38,       19,  -50,  -52,       38,  -61,  -66,
     -93,   12,   32,      -74,    1,   19,      -55,   -9,    5,      -36,  -19,   -7,
     -16,  -30,  -21,        2,  -41,  -34,       21,  -51,  -48,       41,  -62,  -62,
     -90,   11,   36,      -71,    0,   23,      -52,  -10,    9,      -33,  -20,   -3,
     -14,  -31,  -17,        5,  -42,  -30,       24,  -53,  -44,       43,  -64,  -58,
     -88,    9,   41,      -69,    0,   28,      -49,  -11,   14,      -31,  -22,    0,
     -11,  -33,  -12,        8,  -44,  -26,       26,  -54,  -39,       46,  -65,  -53,
     -85,    8,   45,      -66,   -2,   32,      -47,  -13,   18,      -28,  -23,    4,
      -9,  -34,   -8,       10,  -45,  -22,       29,  -55,  -35,       48,  -66,  -49,
     -83,    6,   49,      -64,   -3,   36,      -45,  -14,   22,      -26,  -25,    8,
      -6,  -36,   -4,       12,  -46,  -18,       31,  -57,  -31,       50,  -68,  -45,
     -80,    5,   53,      -62,   -5,   40,      -42,  -15,   26,      -23,  -26,   12,
      -4,  -37,    0,       15,  -48,  -14,       33,  -58,  -27,       53,  -69,  -41,
     -78,    4,   57,      -59,   -6,   44,      -40,  -17,   30,      -21,  -28,   17,
      -1,  -38,    3,       17,  -49,   -9,       36,  -60,  -23,       56,  -71,  -37,
     -75,    2,   61,      -57,   -7,   48,      -37,  -18,   34,      -18,  -29,   21,
       1,  -40,    7,       20,  -50,   -5,       39,  -61,  -19,       58,  -72,  -33,
     -73,    1,   65,      -54,   -9,   52,      -35,  -20,   38,      -16,  -30,   25,
       3,  -41,   11,       22,  -52,   -1,       41,  -62,  -15,       60,  -73,  -29,
     -71,    0,   69,      -52,  -10,   56,      -32,  -21,   42,      -14,  -32,   29,
       6,  -43,   15,       25,  -53,    2,       43,  -64,  -11,       63,  -75,  -25,
     -68,   -1,   74,      -49,  -12,   61,      -30,  -23,   47,      -11,  -33,   33,
       8,  -44,   20,       27,  -55,    6,       46,  -65,   -6,       65,  -76,  -20,
     -65,   -2,   78,      -47,  -13,   65,      -27,  -24,   51,       -9,  -34,   37,
      11,  -45,   24,       30,  -56,   10,       48,  -67,   -2,       68,  -78,  -16,
     -63,   -4,   82,      -44,  -14,   69,      -25,  -25,   55,       -6,  -36,   41,
      13,  -47,   28,       32,  -57,   14,       51,  -68,    1,       70,  -79,  -12,
     -61,   -5,   86,      -42,  -16,   73,      -23,  -27,   59,       -4,  -37,   45,
      16,  -48,   32,       34,  -59,   18,       53,  -69,    5,       73,  -80,   -8,
     -58,   -6,   90,      -40,  -17,   77,      -20,  -28,   63,       -1,  -39,   49,
      18,  -49,   36,       37,  -60,   22,       56,  -71,    9,       75,  -82,   -4,
     -56,   -8,   94,      -37,  -19,   81,      -17,  -29,   67,        1,  -40,   54,
      21,  -51,   40,       39,  -62,   27,       58,  -72,   13,       78,  -83,    0,
     -53,   -9,   98,      -34,  -20,   85,      -15,  -31,   71,        4,  -41,   58,
      23,  -52,   44,       42,  -63,   31,       61,  -74,   17,       80,  -84,    3,
     -51,  -11,  102,      -32,  -21,   89,      -13,  -32,   75,        6,  -43,   62,
      25,  -54,   48,       44,  -64,   35,       63,  -75,   21,       82,  -86,    7,
     -48,  -12,  106,      -30,  -23,   93,      -10,  -33,   79,        9,  -44,   66,
      28,  -55,   52,       47,  -66,   39,       65,  -76,   25,       85,  -87,   11,
     -46,  -13,  111,      -27,  -24,   98,       -8,  -35,   84,       11,  -46,   70,
      31,  -57,   57,       49,  -67,   43,       68,  -78,   30,       88,  -89,   16,
     -43,  -15,  115,      -25,  -25,  102,       -5,  -36,   88,       14,  -47,   74,
      33,  -58,   61,       52,  -68,   47,       71,  -79,   34,       90,  -90,   20,
     -41,  -16,  119,      -22,  -27,  106,       -3,  -38,   92,       16,  -48,   78,
      35,  -59,   65,       54,  -70,   51,       73,  -80,   38,       92,  -91,   24,
    -116,   30,   -8,      -97,   19,  -22,      -78,    8,  -35,      -59,   -1,  -49,
     -40,  -12,  -63,      -21,  -23,  -76,       -2,  -33,  -89,       17,  -44, -103,
    -114,   29,   -4,      -95,   18,  -18,      -76,    7,  -31,      -57,   -3,  -45,
     -38,  -14,  -59,      -19,  -24,  -72,        0,  -35,  -85,       19,  -46,  -99,
    -111,   27,    0,      -93,   17,  -14,      -73,    6,  -27,      -55,   -4,  -41,
     -35,  -15,  -55,      -16,  -26,  -68,        2,  -36,  -81,       22,  -47,  -95,
    -109,   26,    3,      -90,   15,   -9,      -71,    4,  -23,      -52,   -6,  -36,
     -32,  -16,  -50,      -14,  -27,  -64,        5,  -38,  -77,       24,  -49,  -91,
    -106,   24,    7,      -88,   14,   -5,      -68,    3,  -19,      -49,   -7,  -32,
     -30,  -18,  -46,      -11,  -28,  -60,        7,  -39,  -73,       27,  -50,  -87,
    -104,   23,   11,      -85,   12,   -1,      -66,    1,  -15,      -47,   -8,  -28,
     -28,  -19,  -42,       -9,  -30,  -56,       10,  -40,  -69,       29,  -51,  -83,
    -102,   22,   15,      -83,   11,    2,      -63,    0,  -11,      -45,  -10,  -24,
     -25,  -20,  -38,       -7,  -31,  -52,       12,  -42,  -65,       32,  -53,  -79,
     -99,   20,   20,      -80,    9,    6,      -61,    0,   -6,      -42,  -11,  -20,
     -23,  -22,  -34,       -4,  -33,  -47,       15,  -43,  -60,       34,  -54,  -74,
     -97,   19,   24,      -78,    8,   10,      -58,   -2,   -2,      -40,  -12,  -16,
     -20,  -23,  -30,       -1,  -34,  -43,       17,  -45,  -56,       37,  -55,  -70,
     -94,   17,   28,      -75,    7,   14,      -56,   -3,    1,      -37,  -14,  -12,
     -18,  -25,  -26,        1,  -35,  -39,       20,  -46,  -52,       39,  -57,  -66,
     -92,   16,   32,      -73,    5,   18,      -54,   -5,    5,      -35,  -15,   -8,
     -15,  -26,  -22,        3,  -37,  -35,       22,  -47,  -48,       41,  -58,  -62,
     -89,   15,   36,      -71,    4,   22,      -51,   -6,    9,      -32,  -16,   -4,
     -13,  -27,  -18,        6,  -38,  -31,       25,  -49,  -44,       44,  -60,  -58,
     -87,   13,   40,      -68,    3,   27,      -49,   -7,   13,      -30,  -18,    0,
     -10,  -29,  -13,        8,  -40,  -27,       27,  -50,  -40,       47,  -61,  -54,
     -84,   12,   44,      -66,    1,   31,      -46,   -9,   17,      -27,  -19,    4,
      -8,  -30,   -9,       11,  -41,  -23,       30,  -51,  -36,       49,  -62,  -50,
     -82,   10,   48,      -63,    0,   35,      -44,  -10,   21,      -25,  -21,    8,
      -6,  -32,   -5,       13,  -42,  -19,       32,  -53,  -32,       51,  -64,  -46,
     -80,    9,   52,      -61,   -1,   39,      -41,  -11,   25,      -23,  -22,   12,
      -3,  -33,   -1,       16,  -44,  -15,       34,  -54,  -28,       54,  -65,  -42,
     -77,    8,   57,      -58,   -2,   43,      -39,  -13,   30,      -20,  -24,   16,
      -1,  -34,    2,       18,  -45,  -10,       37,  -56,  -23,       56,  -67,  -37,
     -74,    6,   61,      -56,   -3,   47,      -36,  -14,   34,      -17,  -25,   20,
       2,  -36,    6,       21,  -46,   -6,       39,  -57,  -19,       59,  -68,  -33,
     -72,    5,   65,      -53,   -5,   51,      -34,  -16,   38,      -15,  -26,   24,
       4,  -37,   10,       23,  -48,   -2,       42,  -58,  -15,       61,  -69,  -29,
     -70,    4,   69,      -51,   -6,   55,      -31,  -17,   42,      -13,  -28,   28,
       7,  -39,   14,       25,  -49,    1,       44,  -60,  -11,       64,  -71,  -25,
     -67,    2,   73,      -48,   -8,   60,      -29,  -19,   46,      -10,  -29,   33,
       9,  -40,   19,       28,  -51,    5,       47,  -61,   -7,       66,  -72,  -21,
     -65,    1,   77,      -46,   -9,   64,      -26,  -20,   50,       -8,  -30,   37,
      12,  -41,   23,       31,  -52,    9,       49,  -63,   -3,       69,  -74,  -17,
     -62,    0,   81,      -43,  -10,   68,      -24,  -21,   54,       -5,  -32,   41,
      14,  -43,   27,       33,  -53,   13,       52,  -64,    0,       71,  -75,  -13,
     -60,   -1,   85,      -41,  -12,   72,      -22,  -23,   58,       -3,  -33,   45,
      17,  -44,   31,       35,  -55,   17,       54,  -65,    4,       73,  -76,   -9,
     -57,   -2,   89,      -39,  -13,   76,      -19,  -24,   62,        0,  -35,   49,
      19,  -45,   35,       38,  -56,   21,       57,  -67,    8,       76,  -78,   -5,
     -55,   -4,   94,      -36,  -15,   80,      -17,  -25,   67,        2,  -36,   53,
      22,  -47,   39,       40,  -58,   26,       59,  -68,   13,       79,  -79,    0,
     -52,   -5,   98,      -34,  -16,   84,      -14,  -27,   71,        5,  -37,   57,
      24,  -48,   43,       43,  -59,   30,       62,  -70,   17,       81,  -80,    3,
     -50,   -7,  102,      -31,  -17,   88,      -12,  -28,   75,        7,  -39,   61,
      26,  -50,   47,       45,  -60,   34,       64,  -71,   21,       83,  -82,    7,
     -48,   -8,  106,      -29,  -19,   92,       -9,  -29,   79,        9,  -40,   65,
      29,  -51,   51,       48,  -62,   38,       66,  -72,   25,       86,  -83,   11,
     -45,   -9,  110,      -26,  -20,   97,       -7,  -31,   83,       12,  -42,   70,
      31,  -53,   56,       50,  -63,   42,       69,  -74,   29,       88,  -85,   15,
     -42,  -11,  114,      -24,  -21,  101,       -4,  -32,   87,       15,  -43,   74,
      34,  -54,   60,       53,  -64,   46,       71,  -75,   33,       91,  -86,   19,
     -40,  -12,  118,      -21,  -23,  105,       -2,  -34,   91,       17,  -44,   78,
      36,  -55,   64,       55,  -66,   50,       74,  -76,   37,       93,  -87,   23,
    -115,   34,   -9,      -97,   23,  -22,      -77,   12,  -36,      -58,    2,  -49,
     -39,   -8,  -63,      -20,  -19,  -77,       -1,  -29,  -90,       18,  -40, -104,
    -113,   33,   -5,      -94,   22,  -18,      -75,   11,  -32,      -56,    0,  -45,
     -37,  -10,  -59,      -18,  -20,  -73,        1,  -31,  -86,       20,  -42, -100,
    -111,   31,   -1,      -92,   21,  -14,      -72,   10,  -28,      -54,    0,  -41,
     -34,  -11,  -55,      -15,  -22,  -69,        3,  -32,  -82,       23,  -43,  -96,
    -108,   30,    3,      -89,   19,  -10,      -70,    8,  -24,      -51,   -2,  -37,
     -32,  -12,  -51,      -13,  -23,  -64,        6,  -34,  -78,       25,  -45,  -91,
    -106,   28,    7,      -87,   18,   -6,      -67,    7,  -20,      -49,   -3,  -33,
     -29,  -14,  -47,      -10,  -24,  -60,        8,  -35,  -74,       28,  -46,  -87,
    -103,   27,   11,      -84,   16,   -2,      -65,    5,  -16,      -46,   -4,  -29,
     -27,  -15,  -43,       -8,  -26,  -56,       11,  -36,  -70,       30,  -47,  -83,
    -101,   26,   15,      -82,   15,    1,      -63,    4,  -12,      -44,   -6,  -25,
     -24,  -16,  -39,       -6,  -27,  -52,       13,  -38,  -66,       33,  -49,  -79,
     -98,   24,   19,      -79,   13,    6,      -60,    3,   -7,      -41,   -7,  -20,
     -22,  -18,  -34,       -3,  -29,  -48,       16,  -39,  -61,       35,  -50,  -75,
     -96,   23,   23,      -77,   12,   10,      -57,    1,   -3,      -39,   -8,  -16,
     -19,  -19,  -30,       -1,  -30,  -44,       18,  -41,  -57,       38,  -51,  -71,
     -93,   21,   27,      -74,   11,   14,      -55,    0,    0,      -36,  -10,  -12,
     -17,  -21,  -26,        2,  -31,  -40,       21,  -42,  -53,       40,  -53,  -67,
     -91,   20,   31,      -72,    9,   18,      -53,   -1,    4,      -34,  -11,   -8,
     -15,  -22,  -22,        4,  -33,  -36,       23,  -43,  -49,       42,  -54,  -63,
     -88,   19,   35,      -70,    8,   22,      -50,   -2,    8,      -32,  -12,   -4,
     -12,  -23,  -18,        7,  -34,  -32,       25,  -45,  -45,       45,  -56,  -59,
     -86,   17,   40,      -67,    7,   26,      -48,   -3,   12,      -29,  -14,    0,
      -9,  -25,  -14,        9,  -36,  -27,       28,  -46,  -41,       47,  -57,  -54,
     -83,   16,   44,      -65,    5,   30,      -45,   -5,   16,      -26,  -15,    3,
      -7,  -26,  -10,       12,  -37,  -23,       31,  -47,  -37,       50,  -58,  -50,
     -81,   14,   48,      -62,    4,   34,      -43,   -6,   20,      -24,  -17,    7,
      -5,  -28,   -6,       14,  -38,  -19,       33,  -49,  -33,       52,  -60,  -46,
     -79,   13,   52,      -60,    2,   38,      -40,   -7,   24,      -22,  -18,   11,
      -2,  -29,   -2,       17,  -40,  -15,       35,  -50,  -29,       55,  -61,  -42,
     -76,   12,   56,      -57,    1,   43,      -38,   -9,   29,      -19,  -20,   16,
       0,  -30,    2,       19,  -41,  -11,       38,  -52,  -24,       57,  -63,  -38,
     -74,   10,   60,      -55,    0,   47,      -35,  -10,   33,      -17,  -21,   20,
       3,  -32,    6,       22,  -42,   -7,       40,  -53,  -20,       60,  -64,  -34,
     -71,    9,   64,      -52,   -1,   51,      -33,  -12,   37,      -14,  -22,   24,
       5,  -33,   10,       24,  -44,   -3,       43,  -54,  -16,       62,  -65,  -30,
     -69,    8,   68,      -50,   -2,   55,      -31,  -13,   41,      -12,  -24,   28,
       8,  -35,   14,       26,  -45,    0,       45,  -56,  -12,       65,  -67,  -26,
     -66,    6,   73,      -47,   -4,   59,      -28,  -15,   45,       -9,  -25,   32,
      10,  -36,   18,       29,  -47,    5,       48,  -57,   -8,       67,  -68,  -21,
     -64,    5,   77,      -45,   -5,   63,      -25,  -16,   49,       -7,  -26,   36,
      13,  -37,   22,       31,  -48,    9,       50,  -59,   -4,       70,  -70,  -17,
     -61,    3,   81,      -42,   -6,   67,      -23,  -17,   53,       -4,  -28,   40,
      15,  -39,   26,       34,  -49,   13,       53,  -60,    0,       72,  -71,  -13,
     -59,    2,   85,      -40,   -8,   71,      -21,  -19,   57,       -2,  -29,   44,
      17,  -40,   30,       36,  -51,   17,       55,  -61,    3,       74,  -72,   -9,
     -56,    1,   89,      -38,   -9,   75,      -18,  -20,   61,        0,  -31,   48,
      20,  -41,   34,       39,  -52,   21,       57,  -63,    7,       77,  -74,   -5,
     -54,    0,   93,      -35,  -11,   80,      -16,  -21,   66,        3,  -32,   53,
      23,  -43,   39,       41,  -54,   25,       60,  -64,   12,       79,  -75,   -1,
     -51,   -1,   97,      -33,  -12,   84,      -13,  -23,   70,        6,  -33,   57,
      25,  -44,   43,       44,  -55,   29,       62,  -66,   16,       82,  -76,    2,
     -49,   -3,  101,      -30,  -13,   88,      -11,  -24,   74,        8,  -35,   61,
      27,  -46,   47,       46,  -56,   33,       65,  -67,   20,       84,  -78,    6,
     -47,   -4,  105,      -28,  -15,   92,       -8,  -25,   78,       10,  -36,   65,
      30,  -47,   51,       48,  -58,   37,       67,  -68,   24,       87,  -79,   10,
     -44,   -5,  110,      -25,  -16,   96,       -6,  -27,   82,       13,  -38,   69,
      32,  -49,   55,       51,  -59,   42,       70,  -70,   28,       89,  -81,   15,
     -42,   -7,  114,      -23,  -17,  100,       -3,  -28,   86,       15,  -39,   73,
      35,  -50,   59,       54,  -60,   46,       72,  -71,   32,       92,  -82,   19,
     -39,   -8,  118,      -20,  -19,  104,       -1,  -30,   90,       18,  -40,   77,
      37,  -51,   63,       56,  -62,   50,       75,  -72,   36,       94,  -83,   23,
    -114,   38,  -10,      -96,   27,  -23,      -76,   16,  -37,      -58,    6,  -50,
     -38,   -4,  -64,      -19,  -15,  -77,       -1,  -25,  -91,       19,  -36, -105,
    -112,   37,   -6,      -93,   26,  -19,      -74,   15,  -33,      -55,    4,  -46,
     -36,   -6,  -60,      -17,  -16,  -73,        2,  -27,  -87,       21,  -38, -101,
    -110,   35,   -2,      -91,   25,  -15,      -72,   14,  -29,      -53,    3,  -42,
     -33,   -7,  -56,      -15,  -18,  -69,        4,  -28,  -83,       24,  -39,  -97,
    -107,   34,    2,      -88,   23,  -10,      -69,   12,  -24,      -50,    1,  -38,
     -31,   -8,  -51,      -12,  -19,  -65,        7,  -30,  -78,       26,  -41,  -92,
    -105,   32,    6,      -86,   22,   -6,      -66,   11,  -20,      -48,    0,  -34,
     -28,  -10,  -47,       -9,  -20,  -61,        9,  -31,  -74,       29,  -42,  -88,
    -102,   31,   10,      -83,   20,   -2,      -64,    9,  -16,      -45,    0,  -30,
     -26,  -11,  -43,       -7,  -22,  -57,       12,  -32,  -70,       31,  -43,  -84,
    -100,   30,   14,      -81,   19,    1,      -62,    8,  -12,      -43,   -2,  -26,
     -23,  -12,  -39,       -5,  -23,  -53,       14,  -34,  -66,       33,  -45,  -80,
     -97,   28,   18,      -78,   17,    5,      -59,    7,   -8,      -40,   -3,  -21,
     -21,  -14,  -35,       -2,  -25,  -48,       17,  -35,  -62,       36,  -46,  -76,
     -95,   27,   22,      -76,   16,    9,      -57,    5,   -4,      -38,   -4,  -17,
     -18,  -15,  -31,        0,  -26,  -44,       19,  -37,  -58,       39,  -47,  -72,
     -92,   25,   26,      -74,   15,   13,      -54,    4,    0,      -35,   -6,  -13,
     -16,  -17,  -27,        3,  -27,  -40,       22,  -38,  -54,       41,  -49,  -68,
     -90,   24,   30,      -71,   13,   17,      -52,    2,    3,      -33,   -7,   -9,
     -14,  -18,  -23,        5,  -29,  -36,       24,  -39,  -50,       43,  -50,  -64,
     -88,   23,   34,      -69,   12,   21,      -49,    1,    7,      -31,   -8,   -5,
     -11,  -19,  -19,        8,  -30,  -32,       26,  -41,  -46,       46,  -52,  -60,
     -85,   21,   39,      -66,   11,   26,      -47,    0,   12,      -28,  -10,   -1,
      -9,  -21,  -14,       10,  -32,  -28,       29,  -42,  -41,       48,  -53,  -55,
     -82,   20,   43,      -64,    9,   30,      -44,   -1,   16,      -26,  -11,    2,
      -6,  -22,  -10,       13,  -33,  -24,       31,  -43,  -37,       51,  -54,  -51,
     -80,   18,   47,      -61,    8,   34,      -42,   -2,   20,      -23,  -13,    6,
      -4,  -24,   -6,       15,  -34,  -20,       34,  -45,  -33,       53,  -56,  -47,
     -78,   17,   51,      -59,    6,   38,      -40,   -3,   24,      -21,  -14,   10,
      -1,  -25,   -2,       17,  -36,  -16,       36,  -46,  -29,       56,  -57,  -43,
     -75,   16,   55,      -56,    5,   42,      -37,   -5,   28,      -18,  -16,   15,
       1,  -26,    1,       20,  -37,  -11,       39,  -48,  -25,       58,  -59,  -39,
     -73,   14,   59,      -54,    4,   46,      -34,   -6,   32,      -16,  -17,   19,
       4,  -28,    5,       22,  -38,   -7,       41,  -49,  -21,       61,  -60,  -35,
     -70,   13,   63,      -51,    2,   50,      -32,   -8,   36,      -13,  -18,   23,
       6,  -29,    9,       25,  -40,   -3,       44,  -50,  -17,       63,  -61,  -31,
     -68,   12,   67,      -49,    1,   54,      -30,   -9,   40,      -11,  -20,   27,
       8,  -31,   13,       27,  -41,    0,       46,  -52,  -13,       65,  -63,  -27,
     -65,   10,   72,      -46,    0,   59,      -27,  -11,   45,       -8,  -21,   31,
      11,  -32,   18,       30,  -43,    4,       49,  -53,   -8,       68,  -64,  -22,
     -63,    9,   76,      -44,   -1,   63,      -25,  -12,   49,       -6,  -22,   35,
      14,  -33,   22,       32,  -44,    8,       51,  -55,   -4,       71,  -66,  -18,
     -60,    7,   80,      -42,   -2,   67,      -22,  -13,   53,       -3,  -24,   39,
      16,  -35,   26,       35,  -45,   12,       54,  -56,    0,       73,  -67,  -14,
     -58,    6,   84,      -39,   -4,   71,      -20,  -15,   57,       -1,  -25,   43,
      18,  -36,   30,       37,  -47,   16,       56,  -57,    3,       75,  -68,  -10,
     -56,    5,   88,      -37,   -5,   75,      -17,  -16,   61,        1,  -27,   47,
      21,  -37,   34,       40,  -48,   20,       58,  -59,    7,       78,  -70,   -6,
     -53,    3,   92,      -34,   -7,   79,      -15,  -17,   65,        4,  -28,   52,
      23,  -39,   38,       42,  -50,   25,       61,  -60,   11,       80,  -71,   -2,
     -50,    2,   96,      -32,   -8,   83,      -12,  -19,   69,        6,  -29,   56,
      26,  -40,   42,       45,  -51,   29,       63,  -62,   15,       83,  -72,    1,
     -48,    0,  100,      -29,   -9,   87,      -10,  -20,   73,        9,  -31,   60,
      28,  -42,   46,       47,  -52,   33,       66,  -63,   19,       85,  -74,    5,
     -46,    0,  104,      -27,  -11,   91,       -8,  -21,   77,       11,  -32,   64,
      31,  -43,   50,       49,  -54,   37,       68,  -64,   23,       88,  -75,    9,
     -43,   -1,  109,      -24,  -12,   96,       -5,  -23,   82,       14,  -34,   68,
      33,  -45,   55,       52,  -55,   41,       71,  -66,   28,       90,  -77,   14,
     -41,   -3,  113,      -22,  -13,  100,       -2,  -24,   86,       16,  -35,   72,
      36,  -46,   59,       54,  -56,   45,       73,  -67,   32,       93,  -78,   18,
     -38,   -4,  117,      -19,  -15,  104,        0,  -26,   90,       19,  -36,   76,
      38,  -47,   63,       57,  -58,   49,       76,  -68,   36,       95,  -79,   22,
    -114,   42,  -10,      -95,   31,  -24,      -75,   20,  -37,      -57,   10,  -51,
     -37,    0,  -65,      -18,  -11,  -78,        0,  -21,  -91,       20,  -32, -105,
    -111,   41,   -6,      -92,   30,  -20,      -73,   19,  -33,      -54,    8,  -47,
     -35,   -2,  -61,      -16,  -12,  -74,        3,  -23,  -87,       22,  -34, -101,
    -109,   39,   -2,      -90,   29,  -16,      -71,   18,  -29,      -52,    7,  -43,
     -32,   -3,  -57,      -14,  -14,  -70,        5,  -24,  -83,       24,  -35,  -97,
    -106,   38,    1,      -87,   27,  -11,      -68,   16,  -25,      -49,    5,  -38,
     -30,   -4,  -52,      -11,  -15,  -65,        8,  -26,  -79,       27,  -37,  -93,
    -104,   36,    5,      -85,   26,   -7,      -66,   15,  -21,      -47,    4,  -34,
     -27,   -6,  -48,       -9,  -16,  -61,       10,  -27,  -75,       30,  -38,  -89,
    -101,   35,    9,      -83,   24,   -3,      -63,   13,  -17,      -44,    3,  -30,
     -25,   -7,  -44,       -6,  -18,  -57,       13,  -28,  -71,       32,  -39,  -85,
     -99,   34,   13,      -80,   23,    0,      -61,   12,  -13,      -42,    1,  -26,
     -23,   -8,  -40,       -4,  -19,  -53,       15,  -30,  -67,       34,  -41,  -81,
     -96,   32,   18,      -77,   21,    4,      -58,   11,   -8,      -39,    0,  -22,
     -20,  -10,  -36,       -1,  -21,  -49,       18,  -31,  -62,       37,  -42,  -76,
     -94,   31,   22,      -75,   20,    8,      -56,    9,   -4,      -37,    0,  -18,
     -17,  -11,  -32,        1,  -22,  -45,       20,  -33,  -58,       39,  -43,  -72,
     -91,   29,   26,      -73,   19,   12,      -53,    8,    0,      -34,   -2,  -14,
     -15,  -13,  -28,        4,  -23,  -41,       22,  -34,  -54,       42,  -45,  -68,
     -89,   28,   30,      -70,   17,   16,      -51,    6,    3,      -32,   -3,  -10,
     -13,  -14,  -24,        6,  -25,  -37,       25,  -35,  -50,       44,  -46,  -64,
     -87,   27,   34,      -68,   16,   20,      -48,    5,    7,      -30,   -4,   -6,
     -10,  -15,  -20,        8,  -26,  -33,       27,  -37,  -46,       47,  -48,  -60,
     -84,   25,   38,      -65,   15,   25,      -46,    4,   11,      -27,   -6,   -1,
      -8,  -17,  -15,       11,  -28,  -28,       30,  -38,  -42,       49,  -49,  -56,
     -82,   24,   42,      -63,   13,   29,      -43,    2,   15,      -25,   -7,    2,
      -5,  -18,  -11,       14,  -29,  -24,       32,  -39,  -38,       52,  -50,  -52,
     -79,   22,   46,      -60,   12,   33,      -41,    1,   19,      -22,   -9,    6,
      -3,  -20,   -7,       16,  -30,  -20,       35,  -41,  -34,       54,  -52,  -48,
     -77,   21,   50,      -58,   10,   37,      -39,    0,   23,      -20,  -10,   10,
       0,  -21,   -3,       18,  -32,  -16,       37,  -42,  -30,       56,  -53,  -44,
     -74,   20,   55,      -55,    9,   41,      -36,   -1,   28,      -17,  -12,   14,
       2,  -22,    0,       21,  -33,  -12,       40,  -44,  -25,       59,  -55,  -39,
     -72,   18,   59,      -53,    8,   45,      -34,   -2,   32,      -15,  -13,   18,
       5,  -24,    4,       23,  -34,   -8,       42,  -45,  -21,       62,  -56,  -35,
     -69,   17,   63,      -51,    6,   49,      -31,   -4,   36,      -12,  -14,   22,
       7,  -25,    8,       26,  -36,   -4,       45,  -46,  -17,       64,  -57,  -31,
     -67,   16,   67,      -48,    5,   53,      -29,   -5,   40,      -10,  -16,   26,
       9,  -27,   12,       28,  -37,    0,       47,  -48,  -13,       66,  -59,  -27,
     -64,   14,   71,      -45,    3,   58,      -26,   -7,   44,       -7,  -17,   31,
      12,  -28,   17,       31,  -39,    4,       50,  -49,   -9,       69,  -60,  -23,
     -62,   13,   75,      -43,    2,   62,      -24,   -8,   48,       -5,  -18,   35,
      14,  -29,   21,       33,  -40,    8,       52,  -51,   -5,       71,  -62,  -19,
     -59,   11,   79,      -41,    1,   66,      -21,   -9,   52,       -2,  -20,   39,
      17,  -31,   25,       36,  -41,   12,       54,  -52,   -1,       74,  -63,  -15,
     -57,   10,   83,      -38,    0,   70,      -19,  -11,   56,        0,  -21,   43,
      19,  -32,   29,       38,  -43,   16,       57,  -53,    2,       76,  -64,  -11,
     -55,    9,   87,      -36,   -1,   74,      -16,  -12,   60,        2,  -23,   47,
      22,  -33,   33,       40,  -44,   20,       59,  -55,    6,       79,  -66,   -7,
     -52,    7,   92,      -33,   -3,   78,      -14,  -13,   65,        5,  -24,   51,
      24,  -35,   37,       43,  -46,   24,       62,  -56,   11,       81,  -67,   -2,
     -50,    6,   96,      -31,   -4,   82,      -11,  -15,   69,        7,  -25,   55,
      27,  -36,   41,       46,  -47,   28,       64,  -58,   15,       84,  -68,    1,
     -47,    4,  100,      -28,   -5,   86,       -9,  -16,   73,       10,  -27,   59,
      29,  -38,   45,       48,  -48,   32,       67,  -59,   19,       86,  -70,    5,
     -45,    3,  104,      -26,   -7,   90,       -7,  -17,   77,       12,  -28,   63,
      32,  -39,   49,       50,  -50,   36,       69,  -60,   23,       88,  -71,    9,
     -42,    2,  108,      -23,   -8,   95,       -4,  -19,   81,       15,  -30,   68,
      34,  -41,   54,       53,  -51,   41,       72,  -62,   27,       91,  -73,   13,
     -40,    0,  112,      -21,   -9,   99,       -2,  -20,   85,       17,  -31,   72,
      37,  -42,   58,       55,  -52,   45,       74,  -63,   31,       94,  -74,   17,
     -37,    0,  116,      -19,  -11,  103,        1,  -22,   89,       20,  -32,   76,
      39,  -43,   62,       58,  -54,   49,       77,  -64,   35,       96,  -75,   21,
    -113,   46,  -11,      -94,   36,  -24,      -74,   25,  -38,      -56,   14,  -52,
     -36,    3,  -65,      -17,   -6,  -79,        1,  -17,  -92,       21,  -28, -106,
    -110,   45,   -7,      -91,   34,  -20,      -72,   23,  -34,      -53,   13,  -48,
     -34,    2,  -61,      -15,   -8,  -75,        4,  -18,  -88,       23,  -29, -102,
    -108,   44,   -3,      -89,   33,  -16,      -70,   22,  -30,      -51,   12,  -44,
     -31,    1,  -57,      -13,   -9,  -71,        6,  -20,  -84,       26,  -31,  -98,
    -105,   42,    1,      -86,   32,  -12,      -67,   21,  -26,      -48,   10,  -39,
     -29,    0,  -53,      -10,  -11,  -66,        9,  -21,  -80,       28,  -32,  -93,
    -103,   41,    5,      -84,   30,   -8,      -64,   19,  -22,      -46,    9,  -35,
     -26,   -1,  -49,       -8,  -12,  -62,       11,  -22,  -76,       31,  -33,  -89,
    -100,   39,    9,      -81,   29,   -4,      -62,   18,  -18,      -43,    7,  -31,
     -24,   -3,  -45,       -5,  -13,  -58,       14,  -24,  -72,       33,  -35,  -85,
     -98,   38,   13,      -79,   27,    0,      -60,   17,  -14,      -41,    6,  -27,
     -22,   -4,  -41,       -3,  -15,  -54,       16,  -25,  -68,       35,  -36,  -81,
     -95,   37,   17,      -76,   26,    4,      -57,   15,   -9,      -38,    4,  -23,
     -19,   -6,  -36,        0,  -16,  -50,       19,  -27,  -63,       38,  -38,  -77,
     -93,   35,   21,      -74,   25,    8,      -55,   14,   -5,      -36,    3,  -19,
     -16,   -7,  -32,        2,  -17,  -46,       21,  -28,  -59,       40,  -39,  -73,
     -90,   34,   25,      -72,   23,   12,      -52,   12,   -1,      -33,    2,  -15,
     -14,   -8,  -28,        5,  -19,  -42,       23,  -29,  -55,       43,  -40,  -69,
     -88,   33,   29,      -69,   22,   16,      -50,   11,    2,      -31,    0,  -11,
     -12,  -10,  -24,        7,  -20,  -38,       26,  -31,  -51,       45,  -42,  -65,
     -86,   31,   33,      -67,   21,   20,      -47,   10,    6,      -29,    0,   -7,
      -9,  -11,  -20,        9,  -22,  -34,       28,  -32,  -47,       48,  -43,  -61,
     -83,   30,   38,      -64,   19,   24,      -45,    8,   10,      -26,   -1,   -2,
      -7,  -12,  -16,       12,  -23,  -29,       31,  -34,  -43,       50,  -45,  -56,
     -81,   28,   42,      -62,   18,   28,      -42,    7,   14,      -24,   -3,    1,
      -4,  -14,  -12,       15,  -24,  -25,       33,  -35,  -39,       53,  -46,  -52,
     -78,   27,   46,      -59,   16,   32,      -40,    5,   18,      -21,   -4,    5,
      -2,  -15,   -8,       17,  -26,  -21,       36,  -36,  -35,       55,  -47,  -48,
     -76,   26,   50,      -57,   15,   36,      -38,    4,   22,      -19,   -6,    9,
       1,  -16,   -4,       19,  -27,  -17,       38,  -38,  -31,       58,  -49,  -44,
     -73,   24,   54,      -54,   13,   41,      -35,    3,   27,      -16,   -7,   13,
       3,  -18,    0,       22,  -29,  -13,       41,  -39,  -26,       60,  -50,  -40,
     -71,   23,   58,      -52,   12,   45,      -33,    1,   31,      -14,   -8,   17,
       6,  -19,    4,       24,  -30,   -9,       43,  -41,  -22,       63,  -51,  -36,
     -68,   21,   62,      -49,   11,   49,      -30,    0,   35,      -11,  -10,   21,
       8,  -21,    8,       27,  -31,   -5,       46,  -42,  -18,       65,  -53,  -32,
     -66,   20,   66,      -47,    9,   53,      -28,   -1,   39,       -9,  -11,   25,
      10,  -22,   12,       29,  -33,   -1,       48,  -43,  -14,       67,  -54,  -28,
     -63,   19,   71,      -44,    8,   57,      -25,   -2,   43,       -6,  -13,   30,
      13,  -24,   16,       32,  -34,    3,       51,  -45,  -10,       70,  -56,  -23,
     -61,   17,   75,      -42,    7,   61,      -23,   -3,   47,       -4,  -14,   34,
      16,  -25,   20,       34,  -36,    7,       53,  -46,   -6,       72,  -57,  -19,
     -58,   16,   79,      -40,    5,   65,      -20,   -5,   51,       -1,  -15,   38,
      18,  -26,   24,       37,  -37,   11,       55,  -47,   -2,       75,  -58,  -15,
     -56,   14,   83,      -37,    4,   69,      -18,   -6,   55,        1,  -17,   42,
      20,  -28,   28,       39,  -38,   15,       58,  -49,    1,       77,  -60,  -11,
     -54,   13,   87,      -35,    3,   73,      -15,   -7,   59,        3,  -18,   46,
      23,  -29,   32,       41,  -40,   19,       60,  -50,    5,       80,  -61,   -7,
     -51,   12,   91,      -32,    1,   78,      -13,   -9,   64,        6,  -20,   50,
      25,  -30,   37,       44,  -41,   23,       63,  -52,   10,       82,  -63,   -3,
     -49,   10,   95,      -30,    0,   82,      -10,  -10,   68,        8,  -21,   54,
      28,  -32,   41,       47,  -42,   27,       65,  -53,   14,       85,  -64,    0,
     -46,    9,   99,      -27,   -1,   86,       -8,  -12,   72,       11,  -22,   58,
      30,  -33,   45,       49,  -44,   31,       68,  -54,   18,       87,  -65,    4,
     -44,    8,  103,      -25,   -2,   90,       -6,  -13,   76,       13,  -24,   62,
      33,  -35,   49,       51,  -45,   35,       70,  -56,   22,       90,  -67,    8,
     -41,    6,  108,      -22,   -4,   94,       -3,  -15,   80,       16,  -25,   67,
      35,  -36,   53,       54,  -47,   40,       73,  -57,   26,       92,  -68,   13,
     -39,    5,  112,      -20,   -5,   98,       -1,  -16,   84,       18,  -26,   71,
      38,  -37,   57,       56,  -48,   44,       75,  -59,   30,       95,  -70,   17,
     -36,    3,  116,      -17,   -6,  102,        2,  -17,   88,       21,  -28,   75,
      40,  -39,   61,       59,  -49,   48,       78,  -60,   34,       97,  -71,   21,
    -112,   50,  -12,      -93,   40,  -25,      -73,   29,  -39,      -55,   18,  -52,
     -35,    7,  -66,      -17,   -2,  -79,        2,  -13,  -93,       22,  -24, -107,
    -109,   49,   -8,      -90,   38,  -21,      -71,   27,  -35,      -52,   17,  -48,
     -33,    6,  -62,      -14,   -4,  -75,        5,  -14,  -89,       24,  -25, -103,
    -107,   48,   -4,      -88,   37,  -17,      -69,   26,  -31,      -50,   16,  -44,
     -31,    5,  -58,      -12,   -5,  -71,        7,  -16,  -85,       26,  -27,  -99,
    -104,   46,    0,      -85,   36,  -12,      -66,   25,  -26,      -47,   14,  -40,
     -28,    3,  -53,       -9,   -7,  -67,       10,  -17,  -80,       29,  -28,  -94,
    -102,   45,    4,      -83,   34,   -8,      -64,   23,  -22,      -45,   13,  -36,
     -25,    2,  -49,       -7,   -8,  -63,       12,  -18,  -76,       32,  -29,  -90,
     -99,   43,    8,      -81,   33,   -4,      -61,   22,  -18,      -42,   11,  -32,
     -23,    0,  -45,       -4,   -9,  -59,       15,  -20,  -72,       34,  -31,  -86,
     -97,   42,   12,      -78,   31,    0,      -59,   21,  -14,      -40,   10,  -28,
     -21,    0,  -41,       -2,  -11,  -55,       17,  -21,  -68,       36,  -32,  -82,
     -94,   41,   16,      -75,   30,    3,      -56,   19,  -10,      -37,    8,  -23,
     -18,   -2,  -37,        1,  -12,  -50,       20,  -23,  -64,       39,  -34,  -78,
     -92,   39,   20,      -73,   29,    7,      -54,   18,   -6,      -35,    7,  -19,
     -16,   -3,  -33,        3,  -13,  -46,       22,  -24,  -60,       41,  -35,  -74,
     -89,   38,   24,      -71,   27,   11,      -51,   16,   -2,      -33,    6,  -15,
     -13,   -4,  -29,        6,  -15,  -42,       24,  -25,  -56,       44,  -36,  -70,
     -87,   37,   28,      -68,   26,   15,      -49,   15,    1,      -30,    4,  -11,
     -11,   -6,  -25,        8,  -16,  -38,       27,  -27,  -52,       46,  -38,  -66,
     -85,   35,   32,      -66,   25,   19,      -47,   14,    5,      -28,    3,   -7,
      -8,   -7,  -21,       10,  -18,  -34,       29,  -28,  -48,       49,  -39,  -62,
     -82,   34,   37,      -63,   23,   24,      -44,   12,   10,      -25,    2,   -3,
      -6,   -8,  -16,       13,  -19,  -30,       32,  -30,  -43,       51,  -41,  -57,
     -80,   32,   41,      -61,   22,   28,      -41,   11,   14,      -23,    0,    0,
      -3,  -10,  -12,       15,  -20,  -26,       34,  -31,  -39,       54,  -42,  -53,
     -77,   31,   45,      -58,   20,   32,      -39,    9,   18,      -20,    0,    4,
      -1,  -11,   -8,       18,  -22,  -22,       37,  -32,  -35,       56,  -43,  -49,
     -75,   30,   49,      -56,   19,   36,      -37,    8,   22,      -18,   -2,    8,
       1,  -12,   -4,       20,  -23,  -18,       39,  -34,  -31,       58,  -45,  -45,
     -72,   28,   53,      -53,   17,   40,      -34,    7,   26,      -15,   -3,   13,
       4,  -14,    0,       23,  -25,  -13,       42,  -35,  -27,       61,  -46,  -41,
     -70,   27,   57,      -51,   16,   44,      -32,    5,   30,      -13,   -4,   17,
       7,  -15,    3,       25,  -26,   -9,       44,  -37,  -23,       64,  -47,  -37,
     -67,   25,   61,      -49,   15,   48,      -29,    4,   34,      -10,   -6,   21,
       9,  -17,    7,       28,  -27,   -5,       47,  -38,  -19,       66,  -49,  -33,
     -65,   24,   65,      -46,   13,   52,      -27,    2,   38,       -8,   -7,   25,
      11,  -18,   11,       30,  -29,   -1,       49,  -39,  -15,       68,  -50,  -29,
     -62,   23,   70,      -43,   12,   57,      -24,    1,   43,       -5,   -9,   29,
      14,  -20,   16,       33,  -30,    2,       52,  -41,  -10,       71,  -52,  -24,
     -60,   21,   74,      -41,   11,   61,      -22,    0,   47,       -3,  -10,   33,
      16,  -21,   20,       35,  -32,    6,       54,  -42,   -6,       73,  -53,  -20,
     -57,   20,   78,      -39,    9,   65,      -19,   -1,   51,       -1,  -11,   37,
      19,  -22,   24,       38,  -33,   10,       56,  -43,   -2,       76,  -54,  -16,
     -55,   18,   82,      -36,    8,   69,      -17,   -2,   55,        2,  -13,   41,
      21,  -24,   28,       40,  -34,   14,       59,  -45,    1,       78,  -56,  -12,
     -53,   17,   86,      -34,    7,   73,      -15,   -3,   59,        4,  -14,   45,
      24,  -25,   32,       42,  -36,   18,       61,  -46,    5,       81,  -57,   -8,
     -50,   16,   90,      -31,    5,   77,      -12,   -5,   63,        7,  -16,   50,
      26,  -26,   36,       45,  -37,   23,       64,  -48,    9,       83,  -59,   -4,
     -48,   14,   94,      -29,    4,   81,       -9,   -6,   67,        9,  -17,   54,
      29,  -28,   40,       47,  -38,   27,       66,  -49,   13,       86,  -60,    0,
     -45,   13,   98,      -26,    2,   85,       -7,   -8,   71,       12,  -18,   58,
      31,  -29,   44,       50,  -40,   31,       69,  -50,   17,       88,  -61,    3,
     -43,   12,  102,      -24,    1,   89,       -5,   -9,   75,       14,  -20,   62,
      33,  -31,   48,       52,  -41,   35,       71,  -52,   21,       90,  -63,    7,
     -40,   10,  107,      -21,    0,   94,       -2,  -11,   80,       17,  -21,   66,
      36,  -32,   53,       55,  -43,   39,       74,  -53,   26,       93,  -64,   12,
     -38,    9,  111,      -19,   -1,   98,        0,  -12,   84,       19,  -22,   70,
      39,  -33,   57,       57,  -44,   43,       76,  -55,   30,       95,  -66,   16,
     -35,    7,  115,      -17,   -2,  102,        3,  -13,   88,       22,  -24,   74,
      41,  -35,   61,       60,  -45,   47,       79,  -56,   34,       98,  -67,   20,
    -111,   54,  -12,      -92,   44,  -26,      -73,   33,  -39,      -54,   22,  -53,
     -34,   11,  -67,      -16,    1,  -80,        3,   -9,  -93,       23,  -20, -107,
    -108,   53,   -8,      -90,   42,  -22,      -70,   31,  -35,      -51,   21,  -49,
     -32,   10,  -63,      -13,    0,  -76,        6,  -10,  -89,       25,  -21, -103,
    -106,   52,   -4,      -87,   41,  -18,      -68,   30,  -31,      -49,   20,  -45,
     -30,    9,  -59,      -11,   -1,  -72,        8,  -12,  -85,       27,  -23,  -99,
    -103,   50,    0,      -84,   40,  -13,      -65,   29,  -27,      -46,   18,  -40,
     -27,    7,  -54,       -8,   -3,  -68,       11,  -13,  -81,       30,  -24,  -95,
    -101,   49,    3,      -82,   38,   -9,      -63,   27,  -23,      -44,   17,  -36,
     -25,    6,  -50,       -6,   -4,  -64,       13,  -14,  -77,       32,  -25,  -91,
     -98,   47,    7,      -80,   37,   -5,      -60,   26,  -19,      -41,   15,  -32,
     -22,    4,  -46,       -3,   -5,  -60,       15,  -16,  -73,       35,  -27,  -87,
     -96,   46,   11,      -77,   35,   -1,      -58,   25,  -15,      -39,   14,  -28,
     -20,    3,  -42,       -1,   -7,  -56,       18,  -17,  -69,       37,  -28,  -83,
     -93,   45,   16,      -75,   34,    2,      -55,   23,  -10,      -36,   12,  -24,
     -17,    1,  -38,        2,   -8,  -51,       21,  -19,  -64,       40,  -30,  -78,
     -91,   43,   20,      -72,   33,    6,      -53,   22,   -6,      -34,   11,  -20,
     -15,    0,  -34,        4,   -9,  -47,       23,  -20,  -60,       42,  -31,  -74,
     -89,   42,   24,      -70,   31,   10,      -50,   20,   -2,      -32,   10,  -16,
     -12,    0,  -30,        7,  -11,  -43,       25,  -21,  -56,       45,  -32,  -70,
     -86,   41,   28,      -67,   30,   14,      -48,   19,    1,      -29,    8,  -12,
     -10,   -2,  -26,        9,  -12,  -39,       28,  -23,  -52,       47,  -34,  -66,
     -84,   39,   32,      -65,   29,   18,      -46,   18,    5,      -27,    7,   -8,
      -7,   -3,  -22,       11,  -14,  -35,       30,  -24,  -48,       49,  -35,  -62,
     -81,   38,   36,      -62,   27,   23,      -43,   16,    9,      -24,    6,   -3,
      -5,   -4,  -17,       14,  -15,  -31,       33,  -26,  -44,       52,  -37,  -58,
     -79,   36,   40,      -60,   26,   27,      -41,   15,   13,      -22,    4,    0,
      -2,   -6,  -13,       16,  -16,  -27,       35,  -27,  -40,       55,  -38,  -54,
     -76,   35,   44,      -58,   24,   31,      -38,   13,   17,      -19,    3,    4,
       0,   -7,   -9,       19,  -18,  -23,       38,  -28,  -36,       57,  -39,  -50,
     -74,   34,   48,      -55,   23,   35,      -36,   12,   21,      -17,    1,    8,
       2,   -8,   -5,       21,  -19,  -19,       40,  -30,  -32,       59,  -41,  -46,
     -71,   32,   53,      -52,   21,   39,      -33,   11,   26,      -14,    0,   12,
       5,  -10,   -1,       24,  -21,  -14,       43,  -31,  -27,       62,  -42,  -41,
     -69,   31,   57,      -50,   20,   43,      -31,    9,   30,      -12,    0,   16,
       7,  -11,    2,       26,  -22,  -10,       45,  -33,  -23,       64,  -43,  -37,
     -66,   29,   61,      -48,   19,   47,      -28,    8,   34,      -10,   -2,   20,
      10,  -13,    6,       29,  -23,   -6,       47,  -34,  -19,       67,  -45,  -33,
     -64,   28,   65,      -45,   17,   51,      -26,    6,   38,       -7,   -3,   24,
      12,  -14,   10,       31,  -25,   -2,       50,  -35,  -15,       69,  -46,  -29,
     -61,   27,   69,      -43,   16,   56,      -23,    5,   42,       -4,   -5,   29,
      15,  -16,   15,       34,  -26,    1,       53,  -37,  -11,       72,  -48,  -25,
     -59,   25,   73,      -40,   15,   60,      -21,    4,   46,       -2,   -6,   33,
      17,  -17,   19,       36,  -28,    5,       55,  -38,   -7,       74,  -49,  -21,
     -57,   24,   77,      -38,   13,   64,      -18,    2,   50,        0,   -7,   37,
      20,  -18,   23,       39,  -29,    9,       57,  -39,   -3,       77,  -50,  -17,
     -54,   22,   81,      -35,   12,   68,      -16,    1,   54,        3,   -9,   41,
      22,  -20,   27,       41,  -30,   13,       60,  -41,    0,       79,  -52,  -13,
     -52,   21,   85,      -33,   11,   72,      -14,    0,   58,        5,  -10,   45,
      25,  -21,   31,       43,  -32,   17,       62,  -42,    4,       81,  -53,   -9,
     -49,   20,   90,      -30,    9,   76,      -11,   -1,   63,        8,  -12,   49,
      27,  -22,   35,       46,  -33,   22,       65,  -44,    9,       84,  -55,   -4,
     -47,   18,   94,      -28,    8,   80,       -9,   -2,   67,       10,  -13,   53,
      30,  -24,   39,       48,  -34,   26,       67,  -45,   13,       87,  -56,    0,
     -44,   17,   98,      -26,    6,   84,       -6,   -4,   71,       13,  -14,   57,
      32,  -25,   43,       51,  -36,   30,       70,  -46,   17,       89,  -57,    3,
     -42,   16,  102,      -23,    5,   88,       -4,   -5,   75,       15,  -16,   61,
      34,  -27,   47,       53,  -37,   34,       72,  -48,   21,       91,  -59,    7,
     -39,   14,  106,      -20,    3,   93,       -1,   -7,   79,       18,  -17,   66,
      37,  -28,   52,       56,  -39,   38,       75,  -49,   25,       94,  -60,   11,
     -37,   13,  110,      -18,    2,   97,        1,   -8,   83,       20,  -18,   70,
      39,  -29,   56,       58,  -40,   42,       77,  -51,   29,       96,  -62,   15,
     -34,   11,  114,      -16,    1,  101,        4,   -9,   87,       22,  -20,   74,
      42,  -31,   60,       61,  -41,   46,       79,  -52,   33,       99,  -63,   19,
    -110,   58,  -13,      -91,   48,  -26,      -72,   37,  -40,      -53,   26,  -53,
     -33,   15,  -67,      -15,    5,  -81,        4,   -5,  -94,       23,  -16, -108,
    -107,   57,   -9,      -89,   46,  -22,      -69,   35,  -36,      -50,   25,  -49,
     -31,   14,  -63,      -12,    3,  -77,        6,   -6,  -90,       26,  -17, -104,
    -105,   56,   -5,      -86,   45,  -18,      -67,   34,  -32,      -48,   24,  -45,
     -29,   13,  -59,      -10,    2,  -73,        9,   -8,  -86,       28,  -19, -100,
    -102,   54,    0,      -84,   44,  -14,      -64,   33,  -28,      -45,   22,  -41,
     -26,   11,  -55,       -7,    0,  -68,       12,   -9,  -82,       31,  -20,  -95,
    -100,   53,    3,      -81,   42,  -10,      -62,   31,  -24,      -43,   21,  -37,
     -24,   10,  -51,       -5,    0,  -64,       14,  -10,  -78,       33,  -21,  -91,
     -98,   51,    7,      -79,   41,   -6,      -59,   30,  -20,      -41,   19,  -33,
     -21,    8,  -47,       -2,   -1,  -60,       16,  -12,  -74,       36,  -23,  -87,
     -95,   50,   11,      -76,   39,   -2,      -57,   29,  -16,      -38,   18,  -29,
     -19,    7,  -43,        0,   -3,  -56,       19,  -13,  -70,       38,  -24,  -83,
     -92,   49,   15,      -74,   38,    2,      -54,   27,  -11,      -36,   16,  -24,
     -16,    5,  -38,        3,   -4,  -52,       21,  -15,  -65,       41,  -26,  -79,
     -90,   47,   19,      -71,   37,    6,      -52,   26,   -7,      -33,   15,  -20,
     -14,    4,  -34,        5,   -5,  -48,       24,  -16,  -61,       43,  -27,  -75,
     -88,   46,   23,      -69,   35,   10,      -50,   24,   -3,      -31,   14,  -16,
     -11,    3,  -30,        7,   -7,  -44,       26,  -17,  -57,       46,  -28,  -71,
     -85,   45,   27,      -66,   34,   14,      -47,   23,    0,      -28,   12,  -12,
      -9,    1,  -26,       10,   -8,  -40,       29,  -19,  -53,       48,  -30,  -67,
     -83,   43,   31,      -64,   33,   18,      -45,   22,    4,      -26,   11,   -8,
      -7,    0,  -22,       12,  -10,  -36,       31,  -20,  -49,       50,  -31,  -63,
     -80,   42,   36,      -61,   31,   22,      -42,   20,    8,      -23,   10,   -4,
      -4,    0,  -18,       15,  -11,  -31,       34,  -22,  -45,       53,  -33,  -58,
     -78,   40,   40,      -59,   30,   26,      -40,   19,   12,      -21,    8,    0,
      -1,   -2,  -14,       17,  -12,  -27,       36,  -23,  -41,       55,  -34,  -54,
     -75,   39,   44,      -57,   28,   30,      -37,   17,   16,      -18,    7,    3,
       1,   -3,  -10,       20,  -14,  -23,       38,  -24,  -37,       58,  -35,  -50,
     -73,   38,   48,      -54,   27,   34,      -35,   16,   20,      -16,    5,    7,
       3,   -4,   -6,       22,  -15,  -19,       41,  -26,  -33,       60,  -37,  -46,
     -70,   36,   52,      -52,   25,   39,      -32,   15,   25,      -13,    4,   12,
       6,   -6,   -1,       25,  -17,  -15,       44,  -27,  -28,       63,  -38,  -42,
     -68,   35,   56,      -49,   24,   43,      -30,   13,   29,      -11,    3,   16,
       8,   -7,    2,       27,  -18,  -11,       46,  -29,  -24,       65,  -39,  -38,
     -66,   33,   60,      -47,   23,   47,      -27,   12,   33,       -9,    1,   20,
      11,   -9,    6,       30,  -19,   -7,       48,  -30,  -20,       68,  -41,  -34,
     -63,   32,   64,      -44,   21,   51,      -25,   10,   37,       -6,    0,   24,
      13,  -10,   10,       32,  -21,   -3,       51,  -31,  -16,       70,  -42,  -30,
     -60,   31,   69,      -42,   20,   55,      -22,    9,   41,       -4,   -1,   28,
      16,  -12,   14,       35,  -22,    1,       53,  -33,  -12,       73,  -44,  -25,
     -58,   29,   73,      -39,   19,   59,      -20,    8,   45,       -1,   -2,   32,
      18,  -13,   18,       37,  -24,    5,       56,  -34,   -8,       75,  -45,  -21,
     -56,   28,   77,      -37,   17,   63,      -18,    6,   49,        1,   -3,   36,
      21,  -14,   22,       39,  -25,    9,       58,  -35,   -4,       78,  -46,  -17,
     -53,   26,   81,      -34,   16,   67,      -15,    5,   53,        4,   -5,   40,
      23,  -16,   26,       42,  -26,   13,       61,  -37,    0,       80,  -48,  -13,
     -51,   25,   85,      -32,   15,   71,      -13,    4,   57,        6,   -6,   44,
      25,  -17,   30,       44,  -28,   17,       63,  -38,    3,       82,  -49,   -9,
     -48,   24,   89,      -29,   13,   76,      -10,    2,   62,        9,   -8,   49,
      28,  -18,   35,       47,  -29,   21,       66,  -40,    8,       85,  -51,   -5,
     -46,   22,   93,      -27,   12,   80,       -8,    1,   66,       11,   -9,   53,
      31,  -20,   39,       49,  -30,   25,       68,  -41,   12,       87,  -52,   -1,
     -43,   21,   97,      -25,   10,   84,       -5,    0,   70,       14,  -10,   57,
      33,  -21,   43,       52,  -32,   29,       70,  -42,   16,       90,  -53,    2,
     -41,   20,  101,      -22,    9,   88,       -3,   -1,   74,       16,  -12,   61,
      35,  -23,   47,       54,  -33,   33,       73,  -44,   20,       92,  -55,    6,
     -38,   18,  106,      -20,    7,   92,        0,   -3,   78,       19,  -13,   65,
      38,  -24,   51,       57,  -35,   38,       76,  -45,   24,       95,  -56,   11,
     -36,   17,  110,      -17,    6,   96,        2,   -4,   82,       21,  -14,   69,
      40,  -25,   55,       59,  -36,   42,       78,  -47,   28,       97,  -58,   15,
     -34,   15,  114,      -15,    5,  100,        5,   -5,   86,       23,  -16,   73,
      43,  -27,   59,       62,  -37,   46,       80,  -48,   32,      100,  -59,   19,
    -109,   63,  -14,      -90,   52,  -27,      -71,   41,  -41,      -52,   31,  -54,
     -32,   20,  -68,      -14,    9,  -81,        5,    0,  -95,       24,  -11, -109,
    -106,   62,  -10,      -88,   51,  -23,      -68,   40,  -37,      -49,   29,  -50,
     -30,   18,  -64,      -11,    8,  -77,        8,   -2,  -91,       27,  -13, -105,
    -104,   60,   -6,      -85,   50,  -19,      -66,   39,  -33,      -47,   28,  -46,
     -28,   17,  -60,       -9,    6,  -73,       10,   -3,  -87,       29,  -14, -101,
    -101,   59,   -1,      -82,   48,  -14,      -63,   37,  -28,      -44,   26,  -42,
     -25,   16,  -56,       -6,    5,  -69,       13,   -5,  -82,       32,  -16,  -96,
     -99,   57,    2,      -80,   47,  -10,      -61,   36,  -24,      -42,   25,  -38,
     -23,   14,  -52,       -4,    4,  -65,       15,   -6,  -78,       34,  -17,  -92,
     -96,   56,    6,      -78,   45,   -6,      -58,   34,  -20,      -40,   24,  -34,
     -20,   13,  -48,       -1,    2,  -61,       17,   -7,  -74,       37,  -18,  -88,
     -94,   55,   10,      -75,   44,   -2,      -56,   33,  -16,      -37,   22,  -30,
     -18,   12,  -44,        1,    1,  -57,       20,   -9,  -70,       39,  -20,  -84,
     -91,   53,   14,      -73,   42,    1,      -53,   32,  -12,      -34,   21,  -25,
     -15,   10,  -39,        4,    0,  -52,       22,  -10,  -66,       42,  -21,  -80,
     -89,   52,   18,      -70,   41,    5,      -51,   30,   -8,      -32,   20,  -21,
     -13,    9,  -35,        6,   -1,  -48,       25,  -12,  -62,       44,  -22,  -76,
     -87,   50,   22,      -68,   40,    9,      -48,   29,   -4,      -30,   18,  -17,
     -10,    7,  -31,        8,   -2,  -44,       27,  -13,  -58,       47,  -24,  -72,
     -84,   49,   26,      -65,   38,   13,      -46,   27,    0,      -27,   17,  -13,
      -8,    6,  -27,       11,   -4,  -40,       30,  -14,  -54,       49,  -25,  -68,
     -82,   48,   30,      -63,   37,   17,      -44,   26,    3,      -25,   16,   -9,
      -6,    5,  -23,       13,   -5,  -36,       32,  -16,  -50,       51,  -27,  -64,
     -79,   46,   35,      -60,   36,   22,      -41,   25,    8,      -22,   14,   -5,
      -3,    3,  -19,       16,   -7,  -32,       35,  -17,  -45,       54,  -28,  -59,
     -77,   45,   39,      -58,   34,   26,      -39,   23,   12,      -20,   13,   -1,
       0,    2,  -15,       18,   -8,  -28,       37,  -18,  -41,       56,  -29,  -55,
     -74,   43,   43,      -56,   33,   30,      -36,   22,   16,      -17,   11,    2,
       2,    0,  -11,       21,   -9,  -24,       40,  -20,  -37,       59,  -31,  -51,
     -72,   42,   47,      -53,   31,   34,      -34,   21,   20,      -15,   10,    6,
       4,    0,   -7,       23,  -11,  -20,       42,  -21,  -33,       61,  -32,  -47,
     -69,   41,   51,      -51,   30,   38,      -31,   19,   24,      -12,    8,   11,
       7,   -1,   -2,       26,  -12,  -15,       45,  -23,  -29,       64,  -34,  -43,
     -67,   39,   55,      -48,   29,   42,      -29,   18,   28,      -10,    7,   15,
       9,   -3,    1,       28,  -13,  -11,       47,  -24,  -25,       66,  -35,  -39,
     -65,   38,   59,      -46,   27,   46,      -26,   16,   32,       -8,    6,   19,
      12,   -4,    5,       31,  -15,   -7,       49,  -25,  -21,       69,  -36,  -35,
     -62,   37,   63,      -43,   26,   50,      -24,   15,   36,       -5,    4,   23,
      14,   -6,    9,       33,  -16,   -3,       52,  -27,  -17,       71,  -38,  -31,
     -59,   35,   68,      -41,   24,   55,      -21,   13,   41,       -2,    3,   27,
      17,   -7,   13,       36,  -18,    0,       54,  -28,  -12,       74,  -39,  -26,
     -57,   34,   72,      -38,   23,   59,      -19,   12,   45,        0,    2,   31,
      19,   -8,   17,       38,  -19,    4,       57,  -30,   -8,       76,  -41,  -22,
     -55,   32,   76,      -36,   22,   63,      -16,   11,   49,        2,    0,   35,
      22,  -10,   21,       40,  -20,    8,       59,  -31,   -4,       79,  -42,  -18,
     -52,   31,   80,      -33,   20,   67,      -14,    9,   53,        5,    0,   39,
      24,  -11,   25,       43,  -22,   12,       62,  -32,    0,       81,  -43,  -14,
     -50,   30,   84,      -31,   19,   71,      -12,    8,   57,        7,   -2,   43,
      26,  -12,   29,       45,  -23,   16,       64,  -34,    3,       83,  -45,  -10,
     -47,   28,   88,      -28,   17,   75,       -9,    7,   61,       10,   -3,   48,
      29,  -14,   34,       48,  -25,   21,       67,  -35,    7,       86,  -46,   -6,
     -45,   27,   92,      -26,   16,   79,       -7,    5,   65,       12,   -4,   52,
      32,  -15,   38,       50,  -26,   25,       69,  -37,   11,       88,  -47,   -2,
     -42,   25,   96,      -24,   15,   83,       -4,    4,   69,       15,   -6,   56,
      34,  -17,   42,       53,  -27,   29,       72,  -38,   15,       91,  -49,    1,
     -40,   24,  100,      -21,   13,   87,       -2,    3,   73,       17,   -7,   60,
      36,  -18,   46,       55,  -29,   33,       74,  -39,   19,       93,  -50,    5,
     -37,   23,  105,      -19,   12,   92,        1,    1,   78,       20,   -9,   64,
      39,  -20,   50,       58,  -30,   37,       77,  -41,   24,       96,  -52,   10,
     -35,   21,  109,      -16,   11,   96,        3,    0,   82,       22,  -10,   68,
      41,  -21,   54,       60,  -31,   41,       79,  -42,   28,       98,  -53,   14,
     -33,   20,  113,      -14,    9,  100,        6,   -1,   86,       24,  -11,   72,
      44,  -22,   58,       63,  -33,   45,       81,  -43,   32,      101,  -54,   18,
    -108,   67,  -14,      -89,   56,  -28,      -70,   45,  -41,      -51,   35,  -55,
     -32,   24,  -69,      -13,   13,  -82,        6,    3,  -95,       25,   -7, -109,
    -105,   66,  -10,      -87,   55,  -24,      -67,   44,  -37,      -49,   33,  -51,
     -29,   22,  -65,      -10,   12,  -78,        8,    1,  -91,       28,   -9, -105,
    -103,   64,   -6,      -84,   54,  -20,      -65,   43,  -33,      -46,   32,  -47,
     -27,   21,  -61,       -8,   10,  -74,       11,    0,  -87,       30,  -10, -101,
    -100,   63,   -2,      -82,   52,  -15,      -62,   41,  -29,      -43,   30,  -42,
     -24,   20,  -56,       -5,    9,  -70,       14,   -1,  -83,       33,  -12,  -97,
     -98,   61,    1,      -79,   51,  -11,      -60,   40,  -25,      -41,   29,  -38,
     -22,   18,  -52,       -3,    8,  -66,       16,   -2,  -79,       35,  -13,  -93,
     -96,   60,    5,      -77,   49,   -7,      -57,   38,  -21,      -39,   28,  -34,
     -19,   17,  -48,        0,    6,  -62,       18,   -3,  -75,       38,  -14,  -89,
     -93,   59,    9,      -74,   48,   -3,      -55,   37,  -17,      -36,   26,  -30,
     -17,   16,  -44,        2,    5,  -58,       21,   -5,  -71,       40,  -16,  -85,
     -91,   57,   14,      -72,   46,    0,      -52,   36,  -12,      -34,   25,  -26,
     -14,   14,  -40,        5,    3,  -53,       23,   -6,  -66,       43,  -17,  -80,
     -88,   56,   18,      -69,   45,    4,      -50,   34,   -8,      -31,   24,  -22,
     -12,   13,  -36,        7,    2,  -49,       26,   -8,  -62,       45,  -18,  -76,
     -86,   54,   22,      -67,   44,    8,      -48,   33,   -4,      -29,   22,  -18,
      -9,   11,  -32,        9,    1,  -45,       28,   -9,  -58,       48,  -20,  -72,
     -83,   53,   26,      -65,   42,   12,      -45,   31,    0,      -26,   21,  -14,
      -7,   10,  -28,       12,    0,  -41,       31,  -10,  -54,       50,  -21,  -68,
     -81,   52,   30,      -62,   41,   16,      -43,   30,    3,      -24,   20,  -10,
      -5,    9,  -24,       14,   -1,  -37,       33,  -12,  -50,       52,  -23,  -64,
     -78,   50,   34,      -59,   40,   21,      -40,   29,    7,      -21,   18,   -5,
      -2,    7,  -19,       17,   -3,  -33,       36,  -13,  -46,       55,  -24,  -60,
     -76,   49,   38,      -57,   38,   25,      -38,   27,   11,      -19,   17,   -1,
       0,    6,  -15,       19,   -4,  -29,       38,  -14,  -42,       57,  -25,  -56,
     -73,   47,   42,      -55,   37,   29,      -35,   26,   15,      -17,   15,    2,
       3,    4,  -11,       22,   -5,  -25,       40,  -16,  -38,       60,  -27,  -52,
     -71,   46,   46,      -52,   35,   33,      -33,   25,   19,      -14,   14,    6,
       5,    3,   -7,       24,   -7,  -21,       43,  -17,  -34,       62,  -28,  -48,
     -68,   45,   51,      -50,   34,   37,      -30,   23,   24,      -11,   12,   10,
       8,    2,   -3,       27,   -8,  -16,       46,  -19,  -29,       65,  -30,  -43,
     -66,   43,   55,      -47,   33,   41,      -28,   22,   28,       -9,   11,   14,
      10,    0,    0,       29,   -9,  -12,       48,  -20,  -25,       67,  -31,  -39,
     -64,   42,   59,      -45,   31,   45,      -25,   20,   32,       -7,   10,   18,
      13,    0,    4,       32,  -11,   -8,       50,  -21,  -21,       70,  -32,  -35,
     -61,   41,   63,      -42,   30,   49,      -23,   19,   36,       -4,    8,   22,
      15,   -2,    8,       34,  -12,   -4,       53,  -23,  -17,       72,  -34,  -31,
     -59,   39,   67,      -40,   28,   54,      -20,   17,   40,       -2,    7,   27,
      18,   -3,   13,       37,  -14,    0,       55,  -24,  -13,       75,  -35,  -27,
     -56,   38,   71,      -37,   27,   58,      -18,   16,   44,        1,    6,   31,
      20,   -4,   17,       39,  -15,    3,       58,  -26,   -9,       77,  -37,  -23,
     -54,   36,   75,      -35,   26,   62,      -16,   15,   48,        3,    4,   35,
      23,   -6,   21,       41,  -16,    7,       60,  -27,   -5,       80,  -38,  -19,
     -51,   35,   79,      -33,   24,   66,      -13,   13,   52,        6,    3,   39,
      25,   -7,   25,       44,  -18,   11,       63,  -28,   -1,       82,  -39,  -15,
     -49,   34,   83,      -30,   23,   70,      -11,   12,   56,        8,    1,   43,
      27,   -8,   29,       46,  -19,   15,       65,  -30,    2,       84,  -41,  -11,
     -46,   32,   88,      -27,   21,   74,       -8,   11,   61,       11,    0,   47,
      30,  -10,   33,       49,  -21,   20,       68,  -31,    7,       87,  -42,   -6,
     -44,   31,   92,      -25,   20,   78,       -6,    9,   65,       13,    0,   51,
      32,  -11,   37,       51,  -22,   24,       70,  -33,   11,       89,  -43,   -2,
     -41,   29,   96,      -23,   19,   82,       -3,    8,   69,       15,   -2,   55,
      35,  -13,   41,       54,  -23,   28,       72,  -34,   15,       92,  -45,    1,
     -39,   28,  100,      -20,   17,   86,       -1,    7,   73,       18,   -3,   59,
      37,  -14,   45,       56,  -25,   32,       75,  -35,   19,       94,  -46,    5,
     -36,   27,  104,      -18,   16,   91,        2,    5,   77,       21,   -5,   64,
      40,  -16,   50,       59,  -26,   36,       77,  -37,   23,       97,  -48,    9,
     -34,   25,  108,      -15,   15,   95,        4,    4,   81,       23,   -6,   68,
      42,  -17,   54,       61,  -27,   40,       80,  -38,   27,       99,  -49,   13,
     -32,   24,  112,      -13,   13,   99,        7,    2,   85,       25,   -7,   72,
      45,  -18,   58,       63,  -29,   44,       82,  -39,   31,      102,  -50,   17,
    -107,   71,  -15,      -88,   60,  -28,      -69,   49,  -42,      -50,   39,  -55,
     -31,   28,  -69,      -12,   17,  -83,        7,    7,  -96,       26,   -3, -110,
    -105,   70,  -11,      -86,   59,  -24,      -66,   48,  -38,      -48,   37,  -51,
     -28,   26,  -65,       -9,   16,  -79,        9,    5,  -92,       29,   -5, -106,
    -102,   68,   -7,      -83,   58,  -20,      -64,   47,  -34,      -45,   36,  -47,
     -26,   25,  -61,       -7,   14,  -75,       12,    4,  -88,       31,   -6, -102,
     -99,   67,   -2,      -81,   56,  -16,      -61,   45,  -30,      -43,   34,  -43,
     -23,   24,  -57,       -4,   13,  -70,       14,    2,  -84,       34,   -8,  -97,
     -97,   65,    1,      -78,   55,  -12,      -59,   44,  -26,      -40,   33,  -39,
     -21,   22,  -53,       -2,   12,  -66,       17,    1,  -80,       36,   -9,  -93,
     -95,   64,    5,      -76,   53,   -8,      -57,   42,  -22,      -38,   32,  -35,
     -18,   21,  -49,        0,   10,  -62,       19,    0,  -76,       39,  -10,  -89,
     -92,   63,    9,      -73,   52,   -4,      -54,   41,  -18,      -35,   30,  -31,
     -16,   20,  -45,        3,    9,  -58,       22,   -1,  -72,       41,  -12,  -85,
     -90,   61,   13,      -71,   50,    0,      -51,   40,  -13,      -33,   29,  -26,
     -13,   18,  -40,        6,    7,  -54,       24,   -2,  -67,       44,  -13,  -81,
     -87,   60,   17,      -68,   49,    4,      -49,   38,   -9,      -30,   28,  -22,
     -11,   17,  -36,        8,    6,  -50,       27,   -4,  -63,       46,  -14,  -77,
     -85,   58,   21,      -66,   48,    8,      -47,   37,   -5,      -28,   26,  -18,
      -8,   15,  -32,       10,    5,  -46,       29,   -5,  -59,       48,  -16,  -73,
     -82,   57,   25,      -64,   46,   12,      -44,   35,   -1,      -25,   25,  -14,
      -6,   14,  -28,       13,    3,  -42,       31,   -6,  -55,       51,  -17,  -69,
     -80,   56,   29,      -61,   45,   16,      -42,   34,    2,      -23,   24,  -10,
      -4,   13,  -24,       15,    2,  -38,       34,   -8,  -51,       53,  -19,  -65,
     -77,   54,   34,      -59,   44,   20,      -39,   33,    6,      -20,   22,   -6,
      -1,   11,  -20,       18,    0,  -33,       37,   -9,  -47,       56,  -20,  -60,
     -75,   53,   38,      -56,   42,   24,      -37,   31,   10,      -18,   21,   -2,
       1,   10,  -16,       20,    0,  -29,       39,  -10,  -43,       58,  -21,  -56,
     -73,   51,   42,      -54,   41,   28,      -34,   30,   14,      -16,   19,    1,
       4,    8,  -12,       23,   -1,  -25,       41,  -12,  -39,       61,  -23,  -52,
     -70,   50,   46,      -51,   39,   32,      -32,   29,   18,      -13,   18,    5,
       6,    7,   -8,       25,   -3,  -21,       44,  -13,  -35,       63,  -24,  -48,
     -67,   49,   50,      -49,   38,   37,      -29,   27,   23,      -11,   16,   10,
       9,    6,   -3,       28,   -4,  -17,       46,  -15,  -30,       66,  -26,  -44,
     -65,   47,   54,      -46,   37,   41,      -27,   26,   27,       -8,   15,   14,
      11,    4,    0,       30,   -5,  -13,       49,  -16,  -26,       68,  -27,  -40,
     -63,   46,   58,      -44,   35,   45,      -25,   24,   31,       -6,   14,   18,
      14,    3,    4,       32,   -7,   -9,       51,  -17,  -22,       71,  -28,  -36,
     -60,   45,   62,      -42,   34,   49,      -22,   23,   35,       -3,   12,   22,
      16,    1,    8,       35,   -8,   -5,       54,  -19,  -18,       73,  -30,  -32,
     -58,   43,   67,      -39,   32,   53,      -19,   21,   39,       -1,   11,   26,
      19,    0,   12,       37,  -10,    0,       56,  -20,  -14,       76,  -31,  -27,
     -55,   42,   71,      -36,   31,   57,      -17,   20,   43,        2,   10,   30,
      21,    0,   16,       40,  -11,    3,       59,  -22,  -10,       78,  -33,  -23,
     -53,   40,   75,      -34,   30,   61,      -15,   19,   47,        4,    8,   34,
      23,   -2,   20,       42,  -12,    7,       61,  -23,   -6,       80,  -34,  -19,
     -50,   39,   79,      -32,   28,   65,      -12,   17,   51,        7,    7,   38,
      26,   -3,   24,       45,  -14,   11,       63,  -24,   -2,       83,  -35,  -15,
     -48,   38,   83,      -29,   27,   69,      -10,   16,   55,        9,    5,   42,
      28,   -4,   28,       47,  -15,   15,       66,  -26,    1,       85,  -37,  -11,
     -45,   36,   87,      -27,   25,   74,       -7,   15,   60,       12,    4,   47,
      31,   -6,   33,       50,  -17,   19,       69,  -27,    6,       88,  -38,   -7,
     -43,   35,   91,      -24,   24,   78,       -5,   13,   64,       14,    3,   51,
      33,   -7,   37,       52,  -18,   23,       71,  -29,   10,       90,  -39,   -3,
     -41,   33,   95,      -22,   23,   82,       -2,   12,   68,       16,    1,   55,
      36,   -9,   41,       55,  -19,   27,       73,  -30,   14,       93,  -41,    0,
     -38,   32,   99,      -19,   21,   86,        0,   11,   72,       19,    0,   59,
      38,  -10,   45,       57,  -21,   31,       76,  -31,   18,       95,  -42,    4,
     -35,   31,  104,      -17,   20,   90,        3,    9,   76,       21,   -1,   63,
      41,  -12,   49,       60,  -22,   36,       78,  -33,   22,       98,  -44,    9,
     -33,   29,  108,      -14,   19,   94,        5,    8,   80,       24,   -2,   67,
      43,  -13,   53,       62,  -23,   40,       81,  -34,   26,      100,  -45,   13,
     -31,   28,  112,      -12,   17,   98,        7,    6,   84,       26,   -3,   71,
      46,  -14,   57,       64,  -25,   44,       83,  -35,   30,      103,  -46,   17,
    -106,   75,  -16,      -87,   64,  -29,      -68,   53,  -43,      -49,   43,  -56,
     -30,   32,  -70,      -11,   21,  -83,        8,   11,  -97,       27,    0, -111,
    -104,   74,  -12,      -85,   63,  -25,      -65,   52,  -39,      -47,   41,  -52,
     -27,   30,  -66,       -9,   20,  -79,       10,    9,  -93,       30,   -1, -107,
    -101,   72,   -8,      -82,   62,  -21,      -63,   51,  -35,      -44,   40,  -48,
     -25,   29,  -62,       -6,   18,  -75,       13,    8,  -89,       32,   -2, -103,
     -99,   71,   -3,      -80,   60,  -16,      -60,   49,  -30,      -42,   38,  -44,
     -22,   28,  -57,       -3,   17,  -71,       15,    6,  -84,       35,   -4,  -98,
     -96,   69,    0,      -77,   59,  -12,      -58,   48,  -26,      -39,   37,  -40,
     -20,   26,  -53,       -1,   16,  -67,       18,    5,  -80,       37,   -5,  -94,
     -94,   68,    4,      -75,   57,   -8,      -56,   46,  -22,      -37,   36,  -36,
     -17,   25,  -49,        1,   14,  -63,       20,    4,  -76,       39,   -6,  -90,
     -91,   67,    8,      -73,   56,   -4,      -53,   45,  -18,      -34,   34,  -32,
     -15,   24,  -45,        4,   13,  -59,       23,    2,  -72,       42,   -8,  -86,
     -89,   65,   12,      -70,   54,    0,      -51,   44,  -14,      -32,   33,  -27,
     -12,   22,  -41,        6,   11,  -54,       25,    1,  -68,       45,   -9,  -82,
     -86,   64,   16,      -68,   53,    3,      -48,   42,  -10,      -29,   32,  -23,
     -10,   21,  -37,        9,   10,  -50,       28,    0,  -64,       47,  -10,  -78,
     -84,   62,   20,      -65,   52,    7,      -46,   41,   -6,      -27,   30,  -19,
      -8,   19,  -33,       11,    9,  -46,       30,   -1,  -60,       49,  -12,  -74,
     -82,   61,   24,      -63,   50,   11,      -43,   39,   -2,      -25,   29,  -15,
      -5,   18,  -29,       14,    7,  -42,       32,   -2,  -56,       52,  -13,  -70,
     -79,   60,   28,      -60,   49,   15,      -41,   38,    1,      -22,   28,  -11,
      -3,   17,  -25,       16,    6,  -38,       35,   -4,  -52,       54,  -15,  -66,
     -76,   58,   33,      -58,   48,   20,      -38,   37,    6,      -19,   26,   -7,
       0,   15,  -20,       19,    4,  -34,       37,   -5,  -47,       57,  -16,  -61,
     -74,   57,   37,      -55,   46,   24,      -36,   35,   10,      -17,   25,   -3,
       2,   14,  -16,       21,    3,  -30,       40,   -6,  -43,       59,  -17,  -57,
     -72,   55,   41,      -53,   45,   28,      -33,   34,   14,      -15,   23,    0,
       5,   12,  -12,       23,    2,  -26,       42,   -8,  -39,       62,  -19,  -53,
     -69,   54,   45,      -50,   43,   32,      -31,   33,   18,      -12,   22,    4,
       7,   11,   -8,       26,    0,  -22,       45,   -9,  -35,       64,  -20,  -49,
     -67,   53,   49,      -48,   42,   36,      -28,   31,   22,      -10,   20,    9,
      10,   10,   -4,       29,    0,  -17,       47,  -11,  -31,       67,  -22,  -45,
     -64,   51,   53,      -45,   41,   40,      -26,   30,   26,       -7,   19,   13,
      12,    8,    0,       31,   -1,  -13,       50,  -12,  -27,       69,  -23,  -41,
     -62,   50,   57,      -43,   39,   44,      -24,   28,   30,       -5,   18,   17,
      15,    7,    3,       33,   -3,   -9,       52,  -13,  -23,       71,  -24,  -37,
     -59,   49,   61,      -41,   38,   48,      -21,   27,   34,       -2,   16,   21,
      17,    5,    7,       36,   -4,   -5,       55,  -15,  -19,       74,  -26,  -33,
     -57,   47,   66,      -38,   36,   53,      -19,   25,   39,        0,   15,   25,
      20,    4,   12,       38,   -6,   -1,       57,  -16,  -14,       77,  -27,  -28,
     -54,   46,   70,      -36,   35,   57,      -16,   24,   43,        3,   14,   29,
      22,    3,   16,       41,   -7,    2,       60,  -18,  -10,       79,  -29,  -24,
     -52,   44,   74,      -33,   34,   61,      -14,   23,   47,        5,   12,   33,
      24,    1,   20,       43,   -8,    6,       62,  -19,   -6,       81,  -30,  -20,
     -50,   43,   78,      -31,   32,   65,      -11,   21,   51,        7,   11,   37,
      27,    0,   24,       46,  -10,   10,       64,  -20,   -2,       84,  -31,  -16,
     -47,   42,   82,      -28,   31,   69,       -9,   20,   55,       10,    9,   41,
      29,    0,   28,       48,  -11,   14,       67,  -22,    1,       86,  -33,  -12,
     -44,   40,   86,      -26,   29,   73,       -6,   19,   59,       13,    8,   46,
      32,   -2,   32,       51,  -13,   19,       69,  -23,    5,       89,  -34,   -8,
     -42,   39,   90,      -23,   28,   77,       -4,   17,   63,       15,    7,   50,
      34,   -3,   36,       53,  -14,   23,       72,  -25,    9,       91,  -35,   -4,
     -40,   37,   94,      -21,   27,   81,       -1,   16,   67,       17,    5,   54,
      37,   -5,   40,       55,  -15,   27,       74,  -26,   13,       94,  -37,    0,
     -37,   36,   98,      -18,   25,   85,        1,   15,   71,       20,    4,   58,
      39,   -6,   44,       58,  -17,   31,       77,  -27,   17,       96,  -38,    3,
     -35,   35,  103,      -16,   24,   90,        4,   13,   76,       22,    2,   62,
      42,   -8,   49,       61,  -18,   35,       79,  -29,   22,       99,  -40,    8,
     -32,   33,  107,      -13,   23,   94,        6,   12,   80,       25,    1,   66,
      44,   -9,   53,       63,  -19,   39,       82,  -30,   26,      101,  -41,   12,
     -30,   32,  111,      -11,   21,   98,        8,   10,   84,       27,    0,   70,
      47,  -10,   57,       65,  -21,   43,       84,  -31,   30,      103,  -42,   16,
    -105,   79,  -16,      -86,   69,  -30,      -67,   58,  -43,      -48,   47,  -57,
     -29,   36,  -71,      -10,   26,  -84,        9,   15,  -97,       28,    4, -111,
    -103,   78,  -12,      -84,   67,  -26,      -64,   56,  -39,      -46,   46,  -53,
     -26,   35,  -67,       -8,   24,  -80,       11,   14,  -93,       31,    3, -107,
    -100,   77,   -8,      -81,   66,  -22,      -62,   55,  -35,      -43,   45,  -49,
     -24,   34,  -63,       -5,   23,  -76,       14,   12,  -89,       33,    1, -103,
     -98,   75,   -4,      -79,   65,  -17,      -59,   54,  -31,      -41,   43,  -44,
     -21,   32,  -58,       -2,   21,  -72,       16,   11,  -85,       36,    0,  -99,
     -95,   74,    0,      -76,   63,  -13,      -57,   52,  -27,      -38,   42,  -40,
     -19,   31,  -54,        0,   20,  -68,       19,   10,  -81,       38,    0,  -95,
     -93,   72,    3,      -74,   62,   -9,      -55,   51,  -23,      -36,   40,  -36,
     -16,   29,  -50,        2,   19,  -64,       21,    8,  -77,       41,   -2,  -91,
     -90,   71,    7,      -72,   60,   -5,      -52,   50,  -19,      -33,   39,  -32,
     -14,   28,  -46,        5,   17,  -60,       24,    7,  -73,       43,   -3,  -87,
     -88,   70,   12,      -69,   59,   -1,      -49,   48,  -14,      -31,   37,  -28,
     -11,   26,  -42,        7,   16,  -55,       26,    5,  -68,       46,   -5,  -82,
     -85,   68,   16,      -66,   58,    2,      -47,   47,  -10,      -28,   36,  -24,
      -9,   25,  -38,       10,   15,  -51,       29,    4,  -64,       48,   -6,  -78,
     -83,   67,   20,      -64,   56,    6,      -45,   45,   -6,      -26,   35,  -20,
      -7,   24,  -34,       12,   13,  -47,       31,    3,  -60,       50,   -7,  -74,
     -80,   66,   24,      -62,   55,   10,      -42,   44,   -2,      -24,   33,  -16,
      -4,   22,  -30,       15,   12,  -43,       33,    1,  -56,       53,   -9,  -70,
     -78,   64,   28,      -59,   54,   14,      -40,   43,    1,      -21,   32,  -12,
      -2,   21,  -26,       17,   10,  -39,       36,    0,  -52,       55,  -10,  -66,
     -75,   63,   32,      -57,   52,   19,      -37,   41,    5,      -18,   31,   -7,
       1,   20,  -21,       20,    9,  -35,       38,   -1,  -48,       58,  -12,  -62,
     -73,   61,   36,      -54,   51,   23,      -35,   40,    9,      -16,   29,   -3,
       3,   18,  -17,       22,    8,  -31,       41,   -2,  -44,       60,  -13,  -58,
     -71,   60,   40,      -52,   49,   27,      -32,   38,   13,      -14,   28,    0,
       6,   17,  -13,       24,    6,  -27,       43,   -3,  -40,       63,  -14,  -54,
     -68,   59,   44,      -49,   48,   31,      -30,   37,   17,      -11,   26,    4,
       8,   16,   -9,       27,    5,  -23,       46,   -5,  -36,       65,  -16,  -50,
     -66,   57,   49,      -47,   46,   35,      -27,   36,   22,       -9,   25,    8,
      11,   14,   -5,       30,    3,  -18,       48,   -6,  -31,       68,  -17,  -45,
     -63,   56,   53,      -44,   45,   39,      -25,   34,   26,       -6,   24,   12,
      13,   13,   -1,       32,    2,  -14,       51,   -8,  -27,       70,  -18,  -41,
     -61,   54,   57,      -42,   44,   43,      -23,   33,   30,       -4,   22,   16,
      16,   11,    2,       34,    1,  -10,       53,   -9,  -23,       73,  -20,  -37,
     -58,   53,   61,      -40,   42,   47,      -20,   31,   34,       -1,   21,   20,
      18,   10,    6,       37,    0,   -6,       56,  -10,  -19,       75,  -21,  -33,
     -56,   52,   65,      -37,   41,   52,      -18,   30,   38,        1,   19,   25,
      21,    8,   11,       39,   -1,   -2,       58,  -12,  -15,       78,  -23,  -29,
     -53,   50,   69,      -34,   40,   56,      -15,   29,   42,        4,   18,   29,
      23,    7,   15,       42,   -3,    1,       61,  -13,  -11,       80,  -24,  -25,
     -51,   49,   73,      -32,   38,   60,      -13,   27,   46,        6,   17,   33,
      25,    6,   19,       44,   -4,    5,       63,  -14,   -7,       82,  -25,  -21,
     -48,   47,   77,      -30,   37,   64,      -10,   26,   50,        8,   15,   37,
      28,    4,   23,       47,   -5,    9,       65,  -16,   -3,       85,  -27,  -17,
     -46,   46,   81,      -27,   36,   68,       -8,   25,   54,       11,   14,   41,
      30,    3,   27,       49,   -7,   13,       68,  -17,    0,       87,  -28,  -13,
     -43,   45,   86,      -25,   34,   72,       -5,   23,   59,       14,   12,   45,
      33,    2,   31,       52,   -8,   18,       70,  -19,    5,       90,  -30,   -8,
     -41,   43,   90,      -22,   33,   76,       -3,   22,   63,       16,   11,   49,
      35,    0,   35,       54,   -9,   22,       73,  -20,    9,       92,  -31,   -4,
     -39,   42,   94,      -20,   31,   80,        0,   20,   67,       18,   10,   53,
      38,    0,   39,       56,  -11,   26,       75,  -21,   13,       95,  -32,    0,
     -36,   41,   98,      -17,   30,   84,        2,   19,   71,       21,    8,   57,
      40,   -2,   43,       59,  -12,   30,       78,  -23,   17,       97,  -34,    3,
     -34,   39,  102,      -15,   28,   89,        5,   17,   75,       23,    7,   62,
      43,   -3,   48,       62,  -14,   34,       80,  -24,   21,      100,  -35,    7,
     -31,   38,  106,      -12,   27,   93,        7,   16,   79,       26,    6,   66,
      45,   -4,   52,       64,  -15,   38,       83,  -26,   25,      102,  -37,   11,
     -29,   36,  110,      -10,   26,   97,        9,   15,   83,       28,    4,   70,
      48,   -6,   56,       66,  -16,   42,       85,  -27,   29,      105,  -38,   15,
    -104,   83,  -17,      -85,   73,  -30,      -66,   62,  -44,      -47,   51,  -58,
     -28,   40,  -71,       -9,   30,  -85,       10,   19,  -98,       29,    8, -112,
    -102,   82,  -13,      -83,   71,  -26,      -64,   60,  -40,      -45,   50,  -54,
     -25,   39,  -67,       -7,   28,  -81,       12,   18,  -94,       32,    7, -108,
     -99,   81,   -9,      -81,   70,  -22,      -61,   59,  -36,      -42,   49,  -50,
     -23,   38,  -63,       -4,   27,  -77,       15,   16,  -90,       34,    5, -104,
     -97,   79,   -4,      -78,   69,  -18,      -58,   58,  -32,      -40,   47,  -45,
     -20,   36,  -59,       -2,   25,  -72,       17,   15,  -86,       37,    4,  -99,
     -94,   78,    0,      -75,   67,  -14,      -56,   56,  -28,      -37,   46,  -41,
     -18,   35,  -55,        1,   24,  -68,       20,   14,  -82,       39,    3,  -95,
     -92,   76,    3,      -73,   66,  -10,      -54,   55,  -24,      -35,   44,  -37,
     -16,   33,  -51,        3,   23,  -64,       22,   12,  -78,       41,    1,  -91,
     -89,   75,    7,      -71,   64,   -6,      -51,   54,  -20,      -32,   43,  -33,
     -13,   32,  -47,        6,   21,  -60,       24,   11,  -74,       44,    0,  -87,
     -87,   74,   11,      -68,   63,   -1,      -49,   52,  -15,      -30,   41,  -29,
     -10,   30,  -42,        8,   20,  -56,       27,    9,  -69,       47,   -1,  -83,
     -84,   72,   15,      -66,   62,    2,      -46,   51,  -11,      -27,   40,  -25,
      -8,   29,  -38,       11,   19,  -52,       30,    8,  -65,       49,   -2,  -79,
     -82,   71,   19,      -63,   60,    6,      -44,   49,   -7,      -25,   39,  -21,
      -6,   28,  -34,       13,   17,  -48,       32,    7,  -61,       51,   -3,  -75,
     -80,   70,   23,      -61,   59,   10,      -41,   48,   -3,      -23,   37,  -17,
      -3,   26,  -30,       16,   16,  -44,       34,    5,  -57,       54,   -5,  -71,
     -77,   68,   27,      -58,   58,   14,      -39,   47,    0,      -20,   36,  -13,
      -1,   25,  -26,       18,   14,  -40,       37,    4,  -53,       56,   -6,  -67,
     -74,   67,   32,      -56,   56,   18,      -36,   45,    4,      -18,   35,   -8,
       2,   24,  -22,       21,   13,  -35,       39,    2,  -49,       59,   -8,  -62,
     -72,   65,   36,      -53,   55,   22,      -34,   44,    8,      -15,   33,   -4,
       4,   22,  -18,       23,   12,  -31,       42,    1,  -45,       61,   -9,  -58,
     -70,   64,   40,      -51,   53,   26,      -32,   42,   12,      -13,   32,    0,
       7,   21,  -14,       25,   10,  -27,       44,    0,  -41,       64,  -10,  -54,
     -67,   63,   44,      -49,   52,   30,      -29,   41,   16,      -10,   30,    3,
       9,   20,  -10,       28,    9,  -23,       47,   -1,  -37,       66,  -12,  -50,
     -65,   61,   48,      -46,   50,   35,      -26,   40,   21,       -8,   29,    7,
      12,   18,   -5,       30,    7,  -19,       49,   -2,  -32,       69,  -13,  -46,
     -62,   60,   52,      -43,   49,   39,      -24,   38,   25,       -5,   28,   11,
      14,   17,   -1,       33,    6,  -15,       52,   -4,  -28,       71,  -14,  -42,
     -60,   58,   56,      -41,   48,   43,      -22,   37,   29,       -3,   26,   15,
      16,   15,    2,       35,    5,  -11,       54,   -5,  -24,       73,  -16,  -38,
     -57,   57,   60,      -39,   46,   47,      -19,   35,   33,        0,   25,   19,
      19,   14,    6,       38,    3,   -7,       56,   -6,  -20,       76,  -17,  -34,
     -55,   56,   65,      -36,   45,   51,      -17,   34,   37,        2,   23,   24,
      22,   12,   10,       40,    2,   -2,       59,   -8,  -16,       79,  -19,  -29,
     -52,   54,   69,      -34,   44,   55,      -14,   33,   41,        5,   22,   28,
      24,   11,   14,       43,    0,    1,       62,   -9,  -12,       81,  -20,  -25,
     -50,   53,   73,      -31,   42,   59,      -12,   31,   45,        7,   21,   32,
      26,   10,   18,       45,    0,    5,       64,  -10,   -8,       83,  -21,  -21,
     -48,   51,   77,      -29,   41,   63,       -9,   30,   49,        9,   19,   36,
      29,    8,   22,       48,   -1,    9,       66,  -12,   -4,       86,  -23,  -17,
     -45,   50,   81,      -26,   40,   67,       -7,   29,   53,       12,   18,   40,
      31,    7,   26,       50,   -3,   13,       69,  -13,    0,       88,  -24,  -13,
     -42,   49,   85,      -24,   38,   72,       -4,   27,   58,       14,   16,   44,
      34,    6,   31,       53,   -4,   17,       71,  -15,    4,       91,  -26,   -9,
     -40,   47,   89,      -21,   37,   76,       -2,   26,   62,       17,   15,   48,
      36,    4,   35,       55,   -5,   21,       74,  -16,    8,       93,  -27,   -5,
     -38,   46,   93,      -19,   35,   80,        0,   24,   66,       19,   14,   52,
      39,    3,   39,       57,   -7,   25,       76,  -17,   12,       96,  -28,   -1,
     -35,   45,   97,      -17,   34,   84,        3,   23,   70,       22,   12,   56,
      41,    1,   43,       60,   -8,   29,       79,  -19,   16,       98,  -30,    2,
     -33,   43,  102,      -14,   32,   88,        6,   21,   74,       24,   11,   61,
      44,    0,   47,       62,  -10,   34,       81,  -20,   20,      101,  -31,    7,
     -30,   42,  106,      -11,   31,   92,        8,   20,   78,       27,   10,   65,
      46,    0,   51,       65,  -11,   38,       84,  -22,   24,      103,  -33,   11,
     -28,   40,  110,       -9,   30,   96,       10,   19,   82,       29,    8,   69,
      48,   -2,   55,       67,  -12,   42,       86,  -23,   28,      105,  -34,   15,
    -103,   87,  -18,      -84,   77,  -31,      -65,   66,  -45,      -46,   55,  -58,
     -27,   44,  -72,       -8,   34,  -85,       11,   23,  -99,       30,   12, -113,
    -101,   86,  -14,      -82,   75,  -27,      -63,   64,  -41,      -44,   54,  -54,
     -24,   43,  -68,       -6,   32,  -81,       13,   22,  -95,       32,   11, -109,
     -98,   85,  -10,      -80,   74,  -23,      -60,   63,  -37,      -41,   53,  -50,
     -22,   42,  -64,       -3,   31,  -77,       15,   20,  -91,       35,    9, -105,
     -96,   83,   -5,      -77,   73,  -18,      -58,   62,  -32,      -39,   51,  -46,
     -19,   40,  -59,       -1,   29,  -73,       18,   19,  -86,       38,    8, -100,
     -93,   82,   -1,      -75,   71,  -14,      -55,   60,  -28,      -36,   50,  -42,
     -17,   39,  -55,        2,   28,  -69,       21,   18,  -82,       40,    7,  -96,
     -91,   80,    2,      -72,   70,  -10,      -53,   59,  -24,      -34,   48,  -38,
     -15,   37,  -51,        4,   27,  -65,       23,   16,  -78,       42,    5,  -92,
     -89,   79,    6,      -70,   68,   -6,      -50,   58,  -20,      -32,   47,  -34,
     -12,   36,  -47,        7,   25,  -61,       25,   15,  -74,       45,    4,  -88,
     -86,   78,   10,      -67,   67,   -2,      -48,   56,  -16,      -29,   45,  -29,
     -10,   34,  -43,        9,   24,  -56,       28,   13,  -70,       47,    2,  -84,
     -83,   76,   14,      -65,   66,    1,      -45,   55,  -12,      -26,   44,  -25,
      -7,   33,  -39,       12,   23,  -52,       30,   12,  -66,       50,    1,  -80,
     -81,   75,   18,      -62,   64,    5,      -43,   53,   -8,      -24,   43,  -21,
      -5,   32,  -35,       14,   21,  -48,       33,   11,  -62,       52,    0,  -76,
     -79,   74,   22,      -60,   63,    9,      -40,   52,   -4,      -22,   41,  -17,
      -2,   30,  -31,       16,   20,  -44,       35,    9,  -58,       55,   -1,  -72,
     -76,   72,   26,      -57,   62,   13,      -38,   51,    0,      -19,   40,  -13,
       0,   29,  -27,       19,   18,  -40,       38,    8,  -54,       57,   -2,  -68,
     -74,   71,   31,      -55,   60,   18,      -35,   49,    4,      -17,   39,   -9,
       3,   28,  -22,       22,   17,  -36,       40,    6,  -49,       60,   -4,  -63,
     -71,   69,   35,      -52,   59,   22,      -33,   48,    8,      -14,   37,   -5,
       5,   26,  -18,       24,   16,  -32,       43,    5,  -45,       62,   -5,  -59,
     -69,   68,   39,      -50,   57,   26,      -31,   46,   12,      -12,   36,   -1,
       8,   25,  -14,       26,   14,  -28,       45,    4,  -41,       64,   -6,  -55,
     -66,   67,   43,      -48,   56,   30,      -28,   45,   16,       -9,   34,    2,
      10,   24,  -10,       29,   13,  -24,       47,    2,  -37,       67,   -8,  -51,
     -64,   65,   47,      -45,   54,   34,      -26,   44,   20,       -7,   33,    7,
      13,   22,   -6,       31,   11,  -19,       50,    1,  -33,       70,   -9,  -47,
     -61,   64,   51,      -43,   53,   38,      -23,   42,   24,       -4,   32,   11,
      15,   21,   -2,       34,   10,  -15,       53,    0,  -29,       72,  -10,  -43,
     -59,   62,   55,      -40,   52,   42,      -21,   41,   28,       -2,   30,   15,
      17,   19,    1,       36,    9,  -11,       55,   -1,  -25,       74,  -12,  -39,
     -57,   61,   59,      -38,   50,   46,      -18,   39,   32,        0,   29,   19,
      20,   18,    5,       39,    7,   -7,       57,   -2,  -21,       77,  -13,  -35,
     -54,   60,   64,      -35,   49,   51,      -16,   38,   37,        3,   27,   23,
      22,   16,   10,       41,    6,   -3,       60,   -4,  -16,       79,  -15,  -30,
     -51,   58,   68,      -33,   48,   55,      -13,   37,   41,        5,   26,   27,
      25,   15,   14,       44,    4,    0,       62,   -5,  -12,       82,  -16,  -26,
     -49,   57,   72,      -30,   46,   59,      -11,   35,   45,        8,   25,   31,
      27,   14,   18,       46,    3,    4,       65,   -6,   -8,       84,  -17,  -22,
     -47,   55,   76,      -28,   45,   63,       -9,   34,   49,       10,   23,   35,
      30,   12,   22,       48,    2,    8,       67,   -8,   -4,       87,  -19,  -18,
     -44,   54,   80,      -25,   44,   67,       -6,   33,   53,       13,   22,   39,
      32,   11,   26,       51,    0,   12,       70,   -9,    0,       89,  -20,  -14,
     -42,   53,   84,      -23,   42,   71,       -3,   31,   57,       15,   20,   44,
      35,   10,   30,       54,    0,   17,       72,  -11,    3,       92,  -22,  -10,
     -39,   51,   88,      -20,   41,   75,       -1,   30,   61,       18,   19,   48,
      37,    8,   34,       56,   -1,   21,       75,  -12,    7,       94,  -23,   -6,
     -37,   50,   92,      -18,   39,   79,        1,   28,   65,       20,   18,   52,
      40,    7,   38,       58,   -3,   25,       77,  -13,   11,       96,  -24,   -2,
     -34,   49,   96,      -16,   38,   83,        4,   27,   69,       23,   16,   56,
      42,    5,   42,       61,   -4,   29,       79,  -15,   15,       99,  -26,    1,
     -32,   47,  101,      -13,   36,   88,        6,   25,   74,       25,   15,   60,
      45,    4,   47,       63,   -6,   33,       82,  -16,   20,      102,  -27,    6,
     -29,   46,  105,      -11,   35,   92,        9,   24,   78,       28,   14,   64,
      47,    3,   51,       66,   -7,   37,       85,  -18,   24,      104,  -29,   10,
     -27,   44,  109,       -8,   34,   96,       11,   23,   82,       30,   12,   68,
      49,    1,   55,       68,   -8,   41,       87,  -19,   28,      106,  -30,   14,
    -102,   91,  -18,      -83,   81,  -32,      -64,   70,  -45,      -45,   59,  -59,
     -26,   48,  -73,       -7,   38,  -86,       12,   27,  -99,       31,   16, -113,
    -100,   90,  -14,      -81,   79,  -28,      -62,   68,  -41,      -43,   58,  -55,
     -24,   47,  -69,       -5,   36,  -82,       14,   26,  -95,       33,   15, -109,
     -97,   89,  -10,      -79,   78,  -24,      -59,   67,  -37,      -41,   57,  -51,
     -21,   46,  -65,       -2,   35,  -78,       16,   24,  -91,       36,   13, -105,
     -95,   87,   -6,      -76,   77,  -19,      -57,   66,  -33,      -38,   55,  -46,
     -18,   44,  -60,        0,   33,  -74,       19,   23,  -87,       38,   12, -101,
     -92,   86,   -2,      -74,   75,  -15,      -54,   64,  -29,      -35,   54,  -42,
     -16,   43,  -56,        3,   32,  -70,       21,   22,  -83,       41,   11,  -97,
     -90,   84,    1,      -71,   74,  -11,      -52,   63,  -25,      -33,   52,  -38,
     -14,   41,  -52,        5,   31,  -66,       24,   20,  -79,       43,    9,  -93,
     -88,   83,    5,      -69,   72,   -7,      -49,   62,  -21,      -31,   51,  -34,
     -11,   40,  -48,        7,   29,  -62,       26,   19,  -75,       46,    8,  -89,
     -85,   82,   10,      -66,   71,   -3,      -47,   60,  -16,      -28,   49,  -30,
      -9,   38,  -44,       10,   28,  -57,       29,   17,  -70,       48,    6,  -84,
     -83,   80,   14,      -64,   70,    0,      -44,   59,  -12,      -26,   48,  -26,
      -6,   37,  -40,       13,   27,  -53,       31,   16,  -66,       51,    5,  -80,
     -80,   79,   18,      -61,   68,    4,      -42,   57,   -8,      -23,   47,  -22,
      -4,   36,  -36,       15,   25,  -49,       34,   15,  -62,       53,    4,  -76,
     -78,   78,   22,      -59,   67,    8,      -40,   56,   -4,      -21,   45,  -18,
      -1,   34,  -32,       17,   24,  -45,       36,   13,  -58,       56,    2,  -72,
     -75,   76,   26,      -57,   66,   12,      -37,   55,    0,      -18,   44,  -14,
       1,   33,  -28,       20,   22,  -41,       39,   12,  -54,       58,    1,  -68,
     -73,   75,   30,      -54,   64,   17,      -35,   53,    3,      -16,   43,   -9,
       4,   32,  -23,       22,   21,  -37,       41,   10,  -50,       61,    0,  -64,
     -70,   73,   34,      -51,   63,   21,      -32,   52,    7,      -13,   41,   -5,
       6,   30,  -19,       25,   20,  -33,       44,    9,  -46,       63,   -1,  -60,
     -68,   72,   38,      -49,   61,   25,      -30,   50,   11,      -11,   40,   -1,
       8,   29,  -15,       27,   18,  -29,       46,    8,  -42,       65,   -2,  -56,
     -65,   71,   42,      -47,   60,   29,      -27,   49,   15,       -9,   38,    2,
      11,   28,  -11,       30,   17,  -25,       48,    6,  -38,       68,   -4,  -52,
     -63,   69,   47,      -44,   58,   33,      -25,   48,   20,       -6,   37,    6,
      14,   26,   -7,       32,   15,  -20,       51,    5,  -33,       70,   -5,  -47,
     -60,   68,   51,      -42,   57,   37,      -22,   46,   24,       -3,   36,   10,
      16,   25,   -3,       35,   14,  -16,       53,    3,  -29,       73,   -6,  -43,
     -58,   66,   55,      -39,   56,   41,      -20,   45,   28,       -1,   34,   14,
      18,   23,    0,       37,   13,  -12,       56,    2,  -25,       75,   -8,  -39,
     -56,   65,   59,      -37,   54,   45,      -17,   43,   32,        1,   33,   18,
      21,   22,    4,       39,   11,   -8,       58,    1,  -21,       78,   -9,  -35,
     -53,   64,   63,      -34,   53,   50,      -15,   42,   36,        4,   31,   23,
      23,   20,    9,       42,   10,   -4,       61,    0,  -17,       80,  -11,  -31,
     -51,   62,   67,      -32,   52,   54,      -12,   41,   40,        6,   30,   27,
      26,   19,   13,       45,    8,    0,       63,   -1,  -13,       83,  -12,  -27,
     -48,   61,   71,      -29,   50,   58,      -10,   39,   44,        9,   29,   31,
      28,   18,   17,       47,    7,    3,       66,   -2,   -9,       85,  -13,  -23,
     -46,   59,   75,      -27,   49,   62,       -8,   38,   48,       11,   27,   35,
      31,   16,   21,       49,    6,    7,       68,   -4,   -5,       88,  -15,  -19,
     -43,   58,   79,      -25,   48,   66,       -5,   37,   52,       14,   26,   39,
      33,   15,   25,       52,    4,   11,       71,   -5,   -1,       90,  -16,  -15,
     -41,   57,   84,      -22,   46,   70,       -3,   35,   57,       16,   24,   43,
      36,   14,   29,       54,    3,   16,       73,   -7,    3,       93,  -18,  -10,
     -38,   55,   88,      -19,   45,   74,        0,   34,   61,       19,   23,   47,
      38,   12,   33,       57,    2,   20,       76,   -8,    7,       95,  -19,   -6,
     -36,   54,   92,      -17,   43,   78,        2,   32,   65,       21,   22,   51,
      40,   11,   37,       59,    0,   24,       78,   -9,   11,       97,  -20,   -2,
     -33,   53,   96,      -15,   42,   82,        5,   31,   69,       23,   20,   55,
      43,    9,   41,       62,    0,   28,       80,  -11,   15,      100,  -22,    1,
     -31,   51,  100,      -12,   40,   87,        7,   29,   73,       26,   19,   60,
      46,    8,   46,       64,   -2,   32,       83,  -12,   19,      102,  -23,    5,
     -28,   50,  104,      -10,   39,   91,       10,   28,   77,       29,   18,   64,
      48,    7,   50,       67,   -3,   36,       85,  -14,   23,      105,  -25,    9,
     -26,   48,  108,       -7,   38,   95,       12,   27,   81,       31,   16,   68,
      50,    5,   54,       69,   -4,   40,       88,  -15,   27,      107,  -26,   13,
    -101,   95,  -19,      -83,   85,  -32,      -63,   74,  -46,      -44,   63,  -59,
     -25,   52,  -73,       -6,   42,  -87,       13,   31, -100,       32,   20, -114,
     -99,   94,  -15,      -80,   83,  -28,      -61,   72,  -42,      -42,   62,  -55,
     -23,   51,  -69,       -4,   40,  -83,       15,   30,  -96,       34,   19, -110,
     -97,   93,  -11,      -78,   82,  -24,      -58,   71,  -38,      -40,   61,  -51,
     -20,   50,  -65,       -1,   39,  -79,       17,   28,  -92,       37,   17, -106,
     -94,   91,   -6,      -75,   81,  -20,      -56,   70,  -34,      -37,   59,  -47,
     -18,   48,  -61,        1,   37,  -74,       20,   27,  -88,       39,   16, -101,
     -91,   90,   -2,      -73,   79,  -16,      -53,   68,  -30,      -35,   58,  -43,
     -15,   47,  -57,        4,   36,  -70,       22,   26,  -84,       42,   15,  -97,
     -89,   88,    1,      -70,   78,  -12,      -51,   67,  -26,      -32,   56,  -39,
     -13,   45,  -53,        6,   35,  -66,       25,   24,  -80,       44,   13,  -93,
     -87,   87,    5,      -68,   76,   -8,      -49,   66,  -22,      -30,   55,  -35,
     -10,   44,  -49,        8,   33,  -62,       27,   23,  -76,       47,   12,  -89,
     -84,   86,    9,      -65,   75,   -3,      -46,   64,  -17,      -27,   53,  -30,
      -8,   42,  -44,       11,   32,  -58,       30,   21,  -71,       49,   10,  -85,
     -82,   84,   13,      -63,   74,    0,      -43,   63,  -13,      -25,   52,  -26,
      -5,   41,  -40,       13,   31,  -54,       32,   20,  -67,       52,    9,  -81,
     -79,   83,   17,      -60,   72,    4,      -41,   61,   -9,      -22,   51,  -22,
      -3,   40,  -36,       16,   29,  -50,       35,   19,  -63,       54,    8,  -77,
     -77,   82,   21,      -58,   71,    8,      -39,   60,   -5,      -20,   49,  -18,
      -1,   38,  -32,       18,   28,  -46,       37,   17,  -59,       56,    6,  -73,
     -74,   80,   25,      -56,   70,   12,      -36,   59,   -1,      -17,   48,  -14,
       2,   37,  -28,       21,   26,  -42,       39,   16,  -55,       59,    5,  -69,
     -72,   79,   30,      -53,   68,   16,      -34,   57,    2,      -15,   47,  -10,
       5,   36,  -24,       23,   25,  -37,       42,   14,  -51,       62,    3,  -64,
     -69,   77,   34,      -51,   67,   20,      -31,   56,    6,      -12,   45,   -6,
       7,   34,  -20,       26,   24,  -33,       45,   13,  -47,       64,    2,  -60,
     -67,   76,   38,      -48,   65,   24,      -29,   54,   10,      -10,   44,   -2,
       9,   33,  -16,       28,   22,  -29,       47,   12,  -43,       66,    1,  -56,
     -65,   75,   42,      -46,   64,   28,      -26,   53,   14,       -8,   42,    1,
      12,   32,  -12,       31,   21,  -25,       49,   10,  -39,       69,    0,  -52,
     -62,   73,   46,      -43,   62,   33,      -24,   52,   19,       -5,   41,    6,
      14,   30,   -7,       33,   19,  -21,       52,    9,  -34,       71,   -1,  -48,
     -59,   72,   50,      -41,   61,   37,      -21,   50,   23,       -3,   40,   10,
      17,   29,   -3,       36,   18,  -17,       54,    7,  -30,       74,   -2,  -44,
     -57,   70,   54,      -38,   60,   41,      -19,   49,   27,        0,   38,   14,
      19,   27,    0,       38,   17,  -13,       57,    6,  -26,       76,   -4,  -40,
     -55,   69,   58,      -36,   58,   45,      -17,   47,   31,        2,   37,   18,
      22,   26,    4,       40,   15,   -9,       59,    5,  -22,       79,   -5,  -36,
     -52,   68,   63,      -33,   57,   49,      -14,   46,   35,        5,   35,   22,
      24,   24,    8,       43,   14,   -4,       62,    3,  -18,       81,   -7,  -31,
     -50,   66,   67,      -31,   56,   53,      -11,   45,   39,        7,   34,   26,
      27,   23,   12,       45,   12,    0,       64,    2,  -14,       84,   -8,  -27,
     -47,   65,   71,      -28,   54,   57,       -9,   43,   43,       10,   33,   30,
      29,   22,   16,       48,   11,    3,       67,    1,  -10,       86,   -9,  -23,
     -45,   63,   75,      -26,   53,   61,       -7,   42,   47,       12,   31,   34,
      31,   20,   20,       50,   10,    7,       69,    0,   -6,       88,  -11,  -19,
     -42,   62,   79,      -24,   52,   65,       -4,   41,   51,       14,   30,   38,
      34,   19,   24,       53,    8,   11,       71,   -1,   -2,       91,  -12,  -15,
     -40,   61,   83,      -21,   50,   70,       -2,   39,   56,       17,   28,   43,
      37,   18,   29,       55,    7,   15,       74,   -3,    2,       93,  -14,  -11,
     -37,   59,   87,      -19,   49,   74,        1,   38,   60,       20,   27,   47,
      39,   16,   33,       58,    6,   19,       77,   -4,    6,       96,  -15,   -7,
     -35,   58,   91,      -16,   47,   78,        3,   36,   64,       22,   26,   51,
      41,   15,   37,       60,    4,   23,       79,   -5,   10,       98,  -16,   -3,
     -33,   57,   95,      -14,   46,   82,        6,   35,   68,       24,   24,   55,
      44,   13,   41,       63,    3,   27,       81,   -7,   14,      101,  -18,    0,
     -30,   55,  100,      -11,   44,   86,        8,   33,   72,       27,   23,   59,
      46,   12,   45,       65,    1,   32,       84,   -8,   18,      103,  -19,    5,
     -27,   54,  104,       -9,   43,   90,       11,   32,   76,       29,   22,   63,
      49,   11,   49,       68,    0,   36,       86,  -10,   22,      106,  -21,    9,
     -25,   52,  108,       -6,   42,   94,       13,   31,   80,       32,   20,   67,
      51,    9,   53,       70,    0,   40,       89,  -11,   26,      108,  -22,   13,
    -100,  100,  -20,      -82,   89,  -33,      -62,   78,  -47,      -43,   68,  -60,
     -24,   57,  -74,       -5,   46,  -87,       14,   36, -101,       33,   25, -115,
     -98,   99,  -16,      -79,   88,  -29,      -60,   77,  -43,      -41,   66,  -56,
     -22,   55,  -70,       -3,   45,  -83,       16,   34,  -97,       35,   23, -111,
     -96,   97,  -12,      -77,   87,  -25,      -57,   76,  -39,      -39,   65,  -52,
     -19,   54,  -66,        0,   43,  -79,       18,   33,  -93,       38,   22, -107,
     -93,   96,   -7,      -74,   85,  -20,      -55,   74,  -34,      -36,   63,  -48,
     -17,   53,  -62,        2,   42,  -75,       21,   31,  -88,       40,   20, -102,
     -90,   94,   -3,      -72,   84,  -16,      -52,   73,  -30,      -34,   62,  -44,
     -14,   51,  -58,        5,   41,  -71,       23,   30,  -84,       43,   19,  -98,
     -88,   93,    0,      -69,   82,  -12,      -50,   71,  -26,      -31,   61,  -40,
     -12,   50,  -54,        7,   39,  -67,       26,   29,  -80,       45,   18,  -94,
     -86,   92,    4,      -67,   81,   -8,      -48,   70,  -22,      -29,   59,  -36,
      -9,   49,  -50,        9,   38,  -63,       28,   27,  -76,       48,   16,  -90,
     -83,   90,    8,      -64,   79,   -4,      -45,   69,  -18,      -26,   58,  -31,
      -7,   47,  -45,       12,   36,  -58,       31,   26,  -72,       50,   15,  -86,
     -81,   89,   12,      -62,   78,    0,      -42,   67,  -14,      -24,   57,  -27,
      -4,   46,  -41,       15,   35,  -54,       33,   24,  -68,       53,   14,  -82,
     -78,   87,   16,      -59,   77,    3,      -40,   66,  -10,      -21,   55,  -23,
      -2,   44,  -37,       17,   34,  -50,       36,   23,  -64,       55,   12,  -78,
     -76,   86,   20,      -57,   75,    7,      -38,   64,   -6,      -19,   54,  -19,
       1,   43,  -33,       19,   32,  -46,       38,   22,  -60,       57,   11,  -74,
     -73,   85,   24,      -55,   74,   11,      -35,   63,   -2,      -16,   53,  -15,
       3,   42,  -29,       22,   31,  -42,       40,   20,  -56,       60,    9,  -70,
     -71,   83,   29,      -52,   73,   16,      -33,   62,    2,      -14,   51,  -11,
       6,   40,  -25,       24,   29,  -38,       43,   19,  -51,       63,    8,  -65,
     -68,   82,   33,      -50,   71,   20,      -30,   60,    6,      -11,   50,   -7,
       8,   39,  -21,       27,   28,  -34,       46,   18,  -47,       65,    7,  -61,
     -66,   80,   37,      -47,   70,   24,      -28,   59,   10,       -9,   48,   -3,
      10,   37,  -17,       29,   27,  -30,       48,   16,  -43,       67,    5,  -57,
     -64,   79,   41,      -45,   68,   28,      -25,   58,   14,       -7,   47,    0,
      13,   36,  -13,       32,   25,  -26,       50,   15,  -39,       70,    4,  -53,
     -61,   78,   45,      -42,   67,   32,      -23,   56,   18,       -4,   45,    5,
      15,   35,   -8,       34,   24,  -21,       53,   13,  -35,       72,    2,  -49,
     -58,   76,   49,      -40,   66,   36,      -20,   55,   22,       -2,   44,    9,
      18,   33,   -4,       37,   23,  -17,       55,   12,  -31,       75,    1,  -45,
     -56,   75,   53,      -37,   64,   40,      -18,   53,   26,        1,   43,   13,
      20,   32,    0,       39,   21,  -13,       58,   11,  -27,       77,    0,  -41,
     -54,   74,   57,      -35,   63,   44,      -16,   52,   30,        3,   41,   17,
      23,   30,    3,       41,   20,   -9,       60,    9,  -23,       80,   -1,  -37,
     -51,   72,   62,      -32,   61,   49,      -13,   50,   35,        6,   40,   21,
      25,   29,    7,       44,   18,   -5,       63,    8,  -18,       82,   -2,  -32,
     -49,   71,   66,      -30,   60,   53,      -10,   49,   39,        8,   39,   25,
      28,   28,   11,       47,   17,   -1,       65,    6,  -14,       85,   -4,  -28,
     -46,   69,   70,      -27,   59,   57,       -8,   48,   43,       11,   37,   29,
      30,   26,   15,       49,   16,    2,       68,    5,  -10,       87,   -5,  -24,
     -44,   68,   74,      -25,   57,   61,       -6,   46,   47,       13,   36,   33,
      33,   25,   19,       51,   14,    6,       70,    4,   -6,       89,   -6,  -20,
     -41,   67,   78,      -23,   56,   65,       -3,   45,   51,       16,   34,   37,
      35,   24,   23,       54,   13,   10,       72,    2,   -2,       92,   -8,  -16,
     -39,   65,   82,      -20,   54,   69,       -1,   44,   55,       18,   33,   42,
      38,   22,   28,       56,   11,   15,       75,    1,    1,       95,   -9,  -12,
     -36,   64,   86,      -18,   53,   73,        2,   42,   59,       21,   32,   46,
      40,   21,   32,       59,   10,   19,       78,    0,    5,       97,  -10,   -8,
     -34,   62,   90,      -15,   52,   77,        4,   41,   63,       23,   30,   50,
      42,   19,   36,       61,    9,   23,       80,   -1,    9,       99,  -12,   -4,
     -32,   61,   94,      -13,   50,   81,        7,   40,   67,       25,   29,   54,
      45,   18,   40,       64,    7,   27,       82,   -2,   13,      102,  -13,    0,
     -29,   60,   99,      -10,   49,   86,        9,   38,   72,       28,   27,   58,
      47,   16,   44,       66,    6,   31,       85,   -4,   18,      104,  -15,    4,
     -26,   58,  103,       -8,   48,   90,       12,   37,   76,       30,   26,   62,
      50,   15,   48,       69,    5,   35,       87,   -5,   22,      107,  -16,    8,
     -24,   57,  107,       -5,   46,   94,       14,   35,   80,       33,   25,   66,
      52,   14,   52,       71,    3,   39,       90,   -6,   26,      109,  -17,   12,
     -99,  104,  -20,      -81,   93,  -34,      -61,   82,  -47,      -42,   72,  -61,
     -23,   61,  -75,       -4,   50,  -88,       14,   40, -101,       34,   29, -115,
     -97,  103,  -16,      -78,   92,  -30,      -59,   81,  -43,      -40,   70,  -57,
     -21,   59,  -71,       -2,   49,  -84,       17,   38,  -97,       36,   27, -111,
     -95,  101,  -12,      -76,   91,  -26,      -56,   80,  -39,      -38,   69,  -53,
     -18,   58,  -67,        0,   47,  -80,       19,   37,  -93,       39,   26, -107,
     -92,  100,   -8,      -73,   89,  -21,      -54,   78,  -35,      -35,   67,  -48,
     -16,   57,  -62,        3,   46,  -76,       22,   35,  -89,       41,   24, -103,
     -90,   98,   -4,      -71,   88,  -17,      -51,   77,  -31,      -33,   66,  -44,
     -13,   55,  -58,        6,   45,  -72,       24,   34,  -85,       44,   23,  -99,
     -87,   97,    0,      -68,   86,  -13,      -49,   75,  -27,      -30,   65,  -40,
     -11,   54,  -54,        8,   43,  -68,       27,   33,  -81,       46,   22,  -95,
     -85,   96,    3,      -66,   85,   -9,      -47,   74,  -23,      -28,   63,  -36,
      -8,   53,  -50,       10,   42,  -64,       29,   31,  -77,       48,   20,  -91,
     -82,   94,    8,      -63,   83,   -5,      -44,   73,  -18,      -25,   62,  -32,
      -6,   51,  -46,       13,   40,  -59,       32,   30,  -72,       51,   19,  -86,
     -80,   93,   12,      -61,   82,   -1,      -42,   71,  -14,      -23,   61,  -28,
      -3,   50,  -42,       15,   39,  -55,       34,   28,  -68,       54,   18,  -82,
     -77,   91,   16,      -58,   81,    2,      -39,   70,  -10,      -20,   59,  -24,
      -1,   48,  -38,       18,   38,  -51,       37,   27,  -64,       56,   16,  -78,
     -75,   90,   20,      -56,   79,    6,      -37,   68,   -6,      -18,   58,  -20,
       1,   47,  -34,       20,   36,  -47,       39,   26,  -60,       58,   15,  -74,
     -72,   89,   24,      -54,   78,   10,      -34,   67,   -2,      -16,   57,  -16,
       4,   46,  -30,       23,   35,  -43,       41,   24,  -56,       61,   13,  -70,
     -70,   87,   28,      -51,   77,   15,      -32,   66,    1,      -13,   55,  -11,
       7,   44,  -25,       25,   33,  -39,       44,   23,  -52,       63,   12,  -66,
     -67,   86,   32,      -49,   75,   19,      -29,   64,    5,      -10,   54,   -7,
       9,   43,  -21,       28,   32,  -35,       46,   22,  -48,       66,   11,  -62,
     -65,   84,   36,      -46,   74,   23,      -27,   63,    9,       -8,   52,   -3,
      11,   41,  -17,       30,   31,  -31,       49,   20,  -44,       68,    9,  -58,
     -63,   83,   40,      -44,   72,   27,      -24,   62,   13,       -6,   51,    0,
      14,   40,  -13,       32,   29,  -27,       51,   19,  -40,       71,    8,  -54,
     -60,   82,   45,      -41,   71,   31,      -22,   60,   18,       -3,   49,    4,
      16,   39,   -9,       35,   28,  -22,       54,   17,  -35,       73,    6,  -49,
     -58,   80,   49,      -39,   70,   35,      -19,   59,   22,       -1,   48,    8,
      19,   37,   -5,       38,   27,  -18,       56,   16,  -31,       76,    5,  -45,
     -55,   79,   53,      -36,   68,   39,      -17,   57,   26,        2,   47,   12,
      21,   36,   -1,       40,   25,  -14,       59,   15,  -27,       78,    4,  -41,
     -53,   78,   57,      -34,   67,   43,      -15,   56,   30,        4,   45,   16,
      24,   34,    2,       42,   24,  -10,       61,   13,  -23,       80,    2,  -37,
     -50,   76,   61,      -31,   65,   48,      -12,   54,   34,        7,   44,   21,
      26,   33,    7,       45,   22,   -6,       64,   12,  -19,       83,    1,  -33,
     -48,   75,   65,      -29,   64,   52,      -10,   53,   38,        9,   43,   25,
      29,   32,   11,       47,   21,   -2,       66,   10,  -15,       86,    0,  -29,
     -45,   73,   69,      -27,   63,   56,       -7,   52,   42,       12,   41,   29,
      31,   30,   15,       50,   20,    1,       69,    9,  -11,       88,   -1,  -25,
     -43,   72,   73,      -24,   61,   60,       -5,   50,   46,       14,   40,   33,
      33,   29,   19,       52,   18,    5,       71,    8,   -7,       90,   -2,  -21,
     -41,   71,   77,      -22,   60,   64,       -2,   49,   50,       16,   38,   37,
      36,   28,   23,       55,   17,    9,       73,    6,   -3,       93,   -4,  -17,
     -38,   69,   82,      -19,   58,   68,        0,   48,   55,       19,   37,   41,
      38,   26,   27,       57,   15,   14,       76,    5,    1,       95,   -5,  -12,
     -35,   68,   86,      -17,   57,   72,        3,   46,   59,       22,   36,   45,
      41,   25,   31,       60,   14,   18,       78,    3,    5,       98,   -6,   -8,
     -33,   66,   90,      -14,   56,   76,        5,   45,   63,       24,   34,   49,
      43,   23,   35,       62,   13,   22,       81,    2,    9,      100,   -8,   -4,
     -31,   65,   94,      -12,   54,   80,        8,   44,   67,       26,   33,   53,
      46,   22,   39,       64,   11,   26,       83,    1,   13,      103,   -9,    0,
     -28,   64,   98,       -9,   53,   85,       10,   42,   71,       29,   31,   58,
      48,   20,   44,       67,   10,   30,       86,    0,   17,      105,  -11,    3,
     -26,   62,  102,       -7,   52,   89,       13,   41,   75,       31,   30,   62,
      51,   19,   48,       70,    9,   34,       88,   -1,   21,      108,  -12,    7,
     -23,   61,  106,       -4,   50,   93,       15,   39,   79,       34,   29,   66,
      53,   18,   52,       72,    7,   38,       91,   -2,   25,      110,  -13,   11,
     -98,  108,  -21,      -80,   97,  -34,      -60,   86,  -48,      -42,   76,  -62,
     -22,   65,  -75,       -3,   54,  -89,       15,   44, -102,       35,   33, -116,
     -96,  107,  -17,      -77,   96,  -30,      -58,   85,  -44,      -39,   74,  -58,
     -20,   63,  -71,       -1,   53,  -85,       18,   42,  -98,       37,   31, -112,
     -94,  105,  -13,      -75,   95,  -26,      -56,   84,  -40,      -37,   73,  -54,
     -17,   62,  -67,        1,   51,  -81,       20,   41,  -94,       40,   30, -108,
     -91,  104,   -8,      -72,   93,  -22,      -53,   82,  -36,      -34,   71,  -49,
     -15,   61,  -63,        4,   50,  -76,       23,   39,  -90,       42,   28, -103,
     -89,  102,   -4,      -70,   92,  -18,      -50,   81,  -32,      -32,   70,  -45,
     -12,   59,  -59,        6,   49,  -72,       25,   38,  -86,       45,   27,  -99,
     -86,  101,    0,      -67,   90,  -14,      -48,   79,  -28,      -29,   69,  -41,
     -10,   58,  -55,        9,   47,  -68,       28,   37,  -82,       47,   26,  -95,
     -84,  100,    3,      -65,   89,  -10,      -46,   78,  -24,      -27,   67,  -37,
      -8,   57,  -51,       11,   46,  -64,       30,   35,  -78,       49,   24,  -91,
     -81,   98,    7,      -62,   87,   -5,      -43,   77,  -19,      -24,   66,  -33,
      -5,   55,  -46,       14,   44,  -60,       33,   34,  -73,       52,   23,  -87,
     -79,   97,   11,      -60,   86,   -1,      -41,   75,  -15,      -22,   65,  -29,
      -2,   54,  -42,       16,   43,  -56,       35,   32,  -69,       54,   22,  -83,
     -76,   95,   15,      -58,   85,    2,      -38,   74,  -11,      -19,   63,  -25,
       0,   52,  -38,       19,   42,  -52,       38,   31,  -65,       57,   20,  -79,
     -74,   94,   19,      -55,   83,    6,      -36,   72,   -7,      -17,   62,  -21,
       2,   51,  -34,       21,   40,  -48,       40,   30,  -61,       59,   19,  -75,
     -72,   93,   23,      -53,   82,   10,      -33,   71,   -3,      -15,   61,  -17,
       5,   50,  -30,       24,   39,  -44,       42,   28,  -57,       62,   17,  -71,
     -69,   91,   28,      -50,   81,   14,      -31,   70,    0,      -12,   59,  -12,
       7,   48,  -26,       26,   37,  -39,       45,   27,  -53,       64,   16,  -66,
     -67,   90,   32,      -48,   79,   18,      -28,   68,    4,      -10,   58,   -8,
      10,   47,  -22,       29,   36,  -35,       47,   26,  -49,       67,   15,  -62,
     -64,   88,   36,      -45,   78,   22,      -26,   67,    8,       -7,   56,   -4,
      12,   45,  -18,       31,   35,  -31,       50,   24,  -45,       69,   13,  -58,
     -62,   87,   40,      -43,   76,   26,      -24,   66,   12,       -5,   55,    0,
      15,   44,  -14,       33,   33,  -27,       52,   23,  -41,       72,   12,  -54,
     -59,   86,   44,      -40,   75,   31,      -21,   64,   17,       -2,   53,    3,
      17,   43,   -9,       36,   32,  -23,       55,   21,  -36,       74,   10,  -50,
     -57,   84,   48,      -38,   74,   35,      -18,   63,   21,        0,   52,    7,
      20,   41,   -5,       38,   31,  -19,       57,   20,  -32,       77,    9,  -46,
     -54,   83,   52,      -35,   72,   39,      -16,   61,   25,        3,   51,   11,
      22,   40,   -1,       41,   29,  -15,       60,   19,  -28,       79,    8,  -42,
     -52,   82,   56,      -33,   71,   43,      -14,   60,   29,        5,   49,   15,
      24,   38,    2,       43,   28,  -11,       62,   17,  -24,       81,    6,  -38,
     -49,   80,   61,      -30,   69,   47,      -11,   58,   33,        8,   48,   20,
      27,   37,    6,       46,   26,   -6,       65,   16,  -20,       84,    5,  -33,
     -47,   79,   65,      -28,   68,   51,       -9,   57,   37,       10,   47,   24,
      30,   36,   10,       48,   25,   -2,       67,   14,  -16,       86,    3,  -29,
     -44,   77,   69,      -26,   67,   55,       -6,   56,   41,       13,   45,   28,
      32,   34,   14,       51,   24,    1,       70,   13,  -12,       89,    2,  -25,
     -42,   76,   73,      -23,   65,   59,       -4,   54,   45,       15,   44,   32,
      34,   33,   18,       53,   22,    5,       72,   12,   -8,       91,    1,  -21,
     -40,   75,   77,      -21,   64,   63,       -1,   53,   49,       17,   42,   36,
      37,   32,   22,       56,   21,    9,       74,   10,   -4,       94,    0,  -17,
     -37,   73,   81,      -18,   62,   68,        1,   52,   54,       20,   41,   40,
      39,   30,   27,       58,   19,   13,       77,    9,    0,       96,   -1,  -13,
     -35,   72,   85,      -16,   61,   72,        4,   50,   58,       22,   40,   44,
      42,   29,   31,       61,   18,   17,       79,    7,    4,       99,   -2,   -9,
     -32,   70,   89,      -13,   60,   76,        6,   49,   62,       25,   38,   48,
      44,   27,   35,       63,   17,   21,       82,    6,    8,      101,   -4,   -5,
     -30,   69,   93,      -11,   58,   80,        8,   48,   66,       27,   37,   52,
      47,   26,   39,       65,   15,   25,       84,    5,   12,      104,   -5,   -1,
     -27,   68,   98,       -8,   57,   84,       11,   46,   70,       30,   35,   57,
      49,   24,   43,       68,   14,   30,       87,    3,   16,      106,   -7,    3,
     -25,   66,  102,       -6,   56,   88,       14,   45,   74,       32,   34,   61,
      52,   23,   47,       70,   13,   34,       89,    2,   20,      109,   -8,    7,
     -22,   65,  106,       -3,   54,   92,       16,   43,   78,       35,   33,   65,
      54,   22,   51,       73,   11,   38,       92,    1,   24,      111,   -9,   11,
     -98,  112,  -22,      -79,  101,  -35,      -59,   90,  -49,      -41,   80,  -62,
     -21,   69,  -76,       -2,   58,  -89,       16,   48, -103,       36,   37, -117,
     -95,  111,  -18,      -76,  100,  -31,      -57,   89,  -45,      -38,   78,  -58,
     -19,   67,  -72,        0,   57,  -85,       19,   46,  -99,       38,   35, -113,
     -93,  109,  -14,      -74,   99,  -27,      -55,   88,  -41,      -36,   77,  -54,
     -16,   66,  -68,        2,   55,  -81,       21,   45,  -95,       40,   34, -109,
     -90,  108,   -9,      -71,   97,  -22,      -52,   86,  -36,      -33,   75,  -50,
     -14,   65,  -63,        5,   54,  -77,       24,   43,  -90,       43,   32, -104,
     -88,  106,   -5,      -69,   96,  -18,      -50,   85,  -32,      -31,   74,  -46,
     -11,   63,  -59,        7,   53,  -73,       26,   42,  -86,       46,   31, -100,
     -85,  105,   -1,      -67,   94,  -14,      -47,   83,  -28,      -28,   73,  -42,
      -9,   62,  -55,       10,   51,  -69,       29,   41,  -82,       48,   30,  -96,
     -83,  104,    2,      -64,   93,  -10,      -45,   82,  -24,      -26,   71,  -38,
      -7,   61,  -51,       12,   50,  -65,       31,   39,  -78,       50,   28,  -92,
     -80,  102,    6,      -61,   91,   -6,      -42,   81,  -20,      -23,   70,  -33,
      -4,   59,  -47,       15,   48,  -60,       34,   38,  -74,       53,   27,  -88,
     -78,  101,   10,      -59,   90,   -2,      -40,   79,  -16,      -21,   69,  -29,
      -2,   58,  -43,       17,   47,  -56,       36,   36,  -70,       55,   26,  -84,
     -75,   99,   14,      -57,   89,    1,      -37,   78,  -12,      -19,   67,  -25,
       1,   56,  -39,       20,   46,  -52,       38,   35,  -66,       58,   24,  -80,
     -73,   98,   18,      -54,   87,    5,      -35,   76,   -8,      -16,   66,  -21,
       3,   55,  -35,       22,   44,  -48,       41,   34,  -62,       60,   23,  -76,
     -71,   97,   22,      -52,   86,    9,      -33,   75,   -4,      -14,   65,  -17,
       6,   54,  -31,       24,   43,  -44,       43,   32,  -58,       63,   21,  -72,
     -68,   95,   27,      -49,   85,   14,      -30,   74,    0,      -11,   63,  -13,
       8,   52,  -26,       27,   41,  -40,       46,   31,  -53,       65,   20,  -67,
     -66,   94,   31,      -47,   83,   18,      -27,   72,    4,       -9,   62,   -9,
      11,   51,  -22,       30,   40,  -36,       48,   30,  -49,       68,   19,  -63,
     -63,   92,   35,      -44,   82,   22,      -25,   71,    8,       -6,   60,   -5,
      13,   49,  -18,       32,   39,  -32,       51,   28,  -45,       70,   17,  -59,
     -61,   91,   39,      -42,   80,   26,      -23,   70,   12,       -4,   59,   -1,
      16,   48,  -14,       34,   37,  -28,       53,   27,  -41,       72,   16,  -55,
     -58,   90,   43,      -39,   79,   30,      -20,   68,   16,       -1,   57,    3,
      18,   47,  -10,       37,   36,  -23,       56,   25,  -37,       75,   14,  -51,
     -56,   88,   47,      -37,   78,   34,      -18,   67,   20,        1,   56,    7,
      21,   45,   -6,       39,   35,  -19,       58,   24,  -33,       78,   13,  -47,
     -53,   87,   51,      -35,   76,   38,      -15,   65,   24,        4,   55,   11,
      23,   44,   -2,       42,   33,  -15,       61,   23,  -29,       80,   12,  -43,
     -51,   86,   55,      -32,   75,   42,      -13,   64,   28,        6,   53,   15,
      25,   42,    1,       44,   32,  -11,       63,   21,  -25,       82,   10,  -39,
     -48,   84,   60,      -29,   73,   47,      -10,   62,   33,        9,   52,   19,
      28,   41,    6,       47,   30,   -7,       66,   20,  -20,       85,    9,  -34,
     -46,   83,   64,      -27,   72,   51,       -8,   61,   37,       11,   51,   23,
      30,   40,   10,       49,   29,   -3,       68,   18,  -16,       87,    7,  -30,
     -43,   81,   68,      -25,   71,   55,       -5,   60,   41,       13,   49,   27,
      33,   38,   14,       52,   28,    0,       70,   17,  -12,       90,    6,  -26,
     -41,   80,   72,      -22,   69,   59,       -3,   58,   45,       16,   48,   31,
      35,   37,   18,       54,   26,    4,       73,   16,   -8,       92,    5,  -22,
     -39,   79,   76,      -20,   68,   63,       -1,   57,   49,       18,   46,   35,
      38,   36,   22,       56,   25,    8,       75,   14,   -4,       95,    3,  -18,
     -36,   77,   80,      -17,   66,   67,        2,   56,   53,       21,   45,   40,
      40,   34,   26,       59,   23,   13,       78,   13,    0,       97,    2,  -14,
     -34,   76,   84,      -15,   65,   71,        5,   54,   57,       23,   44,   44,
      43,   33,   30,       61,   22,   17,       80,   11,    3,      100,    1,  -10,
     -31,   74,   88,      -12,   64,   75,        7,   53,   61,       26,   42,   48,
      45,   31,   34,       64,   21,   21,       83,   10,    7,      102,    0,   -6,
     -29,   73,   92,      -10,   62,   79,        9,   52,   65,       28,   41,   52,
      47,   30,   38,       66,   19,   25,       85,    9,   11,      104,   -1,   -2,
     -26,   72,   97,       -7,   61,   84,       12,   50,   70,       31,   39,   56,
      50,   28,   43,       69,   18,   29,       88,    7,   16,      107,   -3,    2,
     -24,   70,  101,       -5,   60,   88,       14,   49,   74,       33,   38,   60,
      53,   27,   47,       71,   17,   33,       90,    6,   20,      110,   -4,    6,
     -21,   69,  105,       -3,   58,   92,       17,   47,   78,       36,   37,   64,
      55,   26,   51,       74,   15,   37,       93,    5,   24,      112,   -5,   10,
     -97,  116,  -22,      -78,  106,  -36,      -58,   95,  -49,      -40,   84,  -63,
     -20,   73,  -77,       -1,   63,  -90,       17,   52, -104,       37,   41, -117,
     -94,  115,  -18,      -75,  104,  -32,      -56,   93,  -45,      -37,   83,  -59,
     -18,   72,  -73,        1,   61,  -86,       20,   51, -100,       39,   40, -113,
     -92,  114,  -14,      -73,  103,  -28,      -54,   92,  -41,      -35,   82,  -55,
     -15,   71,  -69,        3,   60,  -82,       22,   49,  -96,       41,   38, -109,
     -89,  112,  -10,      -70,  102,  -23,      -51,   91,  -37,      -32,   80,  -50,
     -13,   69,  -64,        6,   58,  -78,       25,   48,  -91,       44,   37, -105,
     -87,  111,   -6,      -68,  100,  -19,      -49,   89,  -33,      -30,   79,  -46,
     -10,   68,  -60,        8,   57,  -74,       27,   47,  -87,       47,   36, -101,
     -84,  109,   -2,      -66,   99,  -15,      -46,   88,  -29,      -27,   77,  -42,
      -8,   66,  -56,       11,   56,  -70,       30,   45,  -83,       49,   34,  -97,
     -82,  108,    1,      -63,   97,  -11,      -44,   87,  -25,      -25,   76,  -38,
      -6,   65,  -52,       13,   54,  -66,       32,   44,  -79,       51,   33,  -93,
     -79,  107,    6,      -60,   96,   -7,      -41,   85,  -20,      -22,   74,  -34,
      -3,   63,  -48,       16,   53,  -61,       35,   42,  -75,       54,   31,  -88,
     -77,  105,   10,      -58,   95,   -3,      -39,   84,  -16,      -20,   73,  -30,
      -1,   62,  -44,       18,   52,  -57,       37,   41,  -71,       56,   30,  -84,
     -74,  104,   14,      -56,   93,    0,      -36,   82,  -12,      -17,   72,  -26,
       2,   61,  -40,       21,   50,  -53,       39,   40,  -67,       59,   29,  -80,
     -72,  103,   18,      -53,   92,    4,      -34,   81,   -8,      -15,   70,  -22,
       4,   59,  -36,       23,   49,  -49,       42,   38,  -63,       61,   27,  -76,
     -70,  101,   22,      -51,   91,    8,      -31,   80,   -4,      -13,   69,  -18,
       7,   58,  -32,       25,   47,  -45,       44,   37,  -59,       64,   26,  -72,
     -67,  100,   26,      -48,   89,   13,      -29,   78,    0,      -10,   68,  -13,
       9,   57,  -27,       28,   46,  -41,       47,   35,  -54,       66,   24,  -68,
     -65,   98,   30,      -46,   88,   17,      -26,   77,    3,       -8,   66,   -9,
      12,   55,  -23,       31,   45,  -37,       49,   34,  -50,       69,   23,  -64,
     -62,   97,   34,      -43,   86,   21,      -24,   75,    7,       -5,   65,   -5,
      14,   54,  -19,       33,   43,  -33,       52,   33,  -46,       71,   22,  -60,
     -60,   96,   38,      -41,   85,   25,      -22,   74,   11,       -3,   63,   -1,
      17,   53,  -15,       35,   42,  -29,       54,   31,  -42,       73,   20,  -56,
     -57,   94,   43,      -38,   83,   29,      -19,   73,   16,        0,   62,    2,
      19,   51,  -11,       38,   40,  -24,       57,   30,  -38,       76,   19,  -51,
     -55,   93,   47,      -36,   82,   33,      -17,   71,   20,        2,   61,    6,
      22,   50,   -7,       40,   39,  -20,       59,   28,  -34,       79,   18,  -47,
     -52,   91,   51,      -34,   81,   37,      -14,   70,   24,        5,   59,   10,
      24,   48,   -3,       43,   38,  -16,       62,   27,  -30,       81,   16,  -43,
     -50,   90,   55,      -31,   79,   41,      -12,   68,   28,        7,   58,   14,
      26,   47,    0,       45,   36,  -12,       64,   26,  -26,       83,   15,  -39,
     -47,   89,   59,      -28,   78,   46,       -9,   67,   32,       10,   56,   19,
      29,   45,    5,       48,   35,   -8,       67,   24,  -21,       86,   13,  -35,
     -45,   87,   63,      -26,   77,   50,       -7,   66,   36,       12,   55,   23,
      31,   44,    9,       50,   33,   -4,       69,   23,  -17,       88,   12,  -31,
     -42,   86,   67,      -24,   75,   54,       -4,   64,   40,       15,   54,   27,
      34,   43,   13,       53,   32,    0,       71,   22,  -13,       91,   11,  -27,
     -40,   84,   71,      -21,   74,   58,       -2,   63,   44,       17,   52,   31,
      36,   41,   17,       55,   31,    3,       74,   20,   -9,       93,    9,  -23,
     -38,   83,   75,      -19,   73,   62,        1,   62,   48,       19,   51,   35,
      39,   40,   21,       57,   29,    7,       76,   19,   -5,       96,    8,  -19,
     -35,   82,   80,      -16,   71,   66,        3,   60,   53,       22,   49,   39,
      41,   39,   25,       60,   28,   12,       79,   17,   -1,       98,    6,  -14,
     -33,   80,   84,      -14,   70,   70,        6,   59,   57,       24,   48,   43,
      44,   37,   29,       63,   27,   16,       81,   16,    2,      101,    5,  -10,
     -30,   79,   88,      -11,   68,   74,        8,   57,   61,       27,   47,   47,
      46,   36,   33,       65,   25,   20,       84,   15,    6,      103,    4,   -6,
     -28,   78,   92,       -9,   67,   78,       10,   56,   65,       29,   45,   51,
      49,   34,   37,       67,   24,   24,       86,   13,   10,      105,    2,   -2,
     -25,   76,   96,       -6,   65,   83,       13,   54,   69,       32,   44,   56,
      51,   33,   42,       70,   22,   28,       89,   12,   15,      108,    1,    1,
     -23,   75,  100,       -4,   64,   87,       15,   53,   73,       34,   43,   60,
      54,   32,   46,       72,   21,   32,       91,   10,   19,      111,    0,    5,
     -20,   73,  104,       -2,   63,   91,       18,   52,   77,       37,   41,   64,
      56,   30,   50,       75,   20,   36,       94,    9,   23,      113,   -1,    9,
     -96,  120,  -23,      -77,  110,  -36,      -57,   99,  -50,      -39,   88,  -64,
     -19,   77,  -77,       -1,   67,  -91,       18,   56, -104,       38,   45, -118,
     -93,  119,  -19,      -74,  108,  -32,      -55,   97,  -46,      -36,   87,  -60,
     -17,   76,  -73,        2,   65,  -87,       21,   55, -100,       40,   44, -114,
     -91,  118,  -15,      -72,  107,  -28,      -53,   96,  -42,      -34,   86,  -56,
     -15,   75,  -69,        4,   64,  -83,       23,   53,  -96,       42,   42, -110,
     -88,  116,  -10,      -69,  106,  -24,      -50,   95,  -38,      -31,   84,  -51,
     -12,   73,  -65,        7,   62,  -78,       26,   52,  -92,       45,   41, -105,
     -86,  115,   -6,      -67,  104,  -20,      -48,   93,  -34,      -29,   83,  -47,
      -9,   72,  -61,        9,   61,  -74,       28,   51,  -88,       47,   40, -101,
     -83,  113,   -2,      -65,  103,  -16,      -45,   92,  -30,      -26,   81,  -43,
      -7,   70,  -57,       12,   60,  -70,       30,   49,  -84,       50,   38,  -97,
     -81,  112,    1,      -62,  101,  -12,      -43,   91,  -26,      -24,   80,  -39,
      -5,   69,  -53,       14,   58,  -66,       33,   48,  -80,       52,   37,  -93,
     -78,  111,    5,      -60,  100,   -7,      -40,   89,  -21,      -21,   78,  -35,
      -2,   67,  -48,       17,   57,  -62,       36,   46,  -75,       55,   35,  -89,
     -76,  109,    9,      -57,   99,   -3,      -38,   88,  -17,      -19,   77,  -31,
       0,   66,  -44,       19,   56,  -58,       38,   45,  -71,       57,   34,  -85,
     -74,  108,   13,      -55,   97,    0,      -35,   86,  -13,      -17,   76,  -27,
       3,   65,  -40,       22,   54,  -54,       40,   44,  -67,       60,   33,  -81,
     -71,  107,   17,      -52,   96,    4,      -33,   85,   -9,      -14,   74,  -23,
       5,   63,  -36,       24,   53,  -50,       43,   42,  -63,       62,   31,  -77,
     -69,  105,   21,      -50,   95,    8,      -31,   84,   -5,      -12,   73,  -19,
       8,   62,  -32,       26,   51,  -46,       45,   41,  -59,       65,   30,  -73,
     -66,  104,   26,      -47,   93,   12,      -28,   82,   -1,       -9,   72,  -14,
      10,   61,  -28,       29,   50,  -41,       48,   39,  -55,       67,   28,  -68,
     -64,  102,   30,      -45,   92,   16,      -25,   81,    2,       -7,   70,  -10,
      13,   59,  -24,       31,   49,  -37,       50,   38,  -51,       70,   27,  -64,
     -61,  101,   34,      -42,   90,   20,      -23,   79,    6,       -4,   69,   -6,
      15,   58,  -20,       34,   47,  -33,       53,   37,  -47,       72,   26,  -60,
     -59,  100,   38,      -40,   89,   24,      -21,   78,   10,       -2,   67,   -2,
      17,   57,  -16,       36,   46,  -29,       55,   35,  -43,       74,   24,  -56,
     -56,   98,   42,      -37,   87,   29,      -18,   77,   15,        1,   66,    1,
      20,   55,  -11,       39,   44,  -25,       58,   34,  -38,       77,   23,  -52,
     -54,   97,   46,      -35,   86,   33,      -16,   75,   19,        3,   65,    5,
      23,   54,   -7,       41,   43,  -21,       60,   32,  -34,       79,   22,  -48,
     -51,   95,   50,      -33,   85,   37,      -13,   74,   23,        6,   63,    9,
      25,   52,   -3,       44,   42,  -17,       62,   31,  -30,       82,   20,  -44,
     -49,   94,   54,      -30,   83,   41,      -11,   72,   27,        8,   62,   13,
      27,   51,    0,       46,   40,  -13,       65,   30,  -26,       84,   19,  -40,
     -46,   93,   59,      -28,   82,   45,       -8,   71,   31,       11,   60,   18,
      30,   49,    4,       49,   39,   -8,       68,   28,  -22,       87,   17,  -35,
     -44,   91,   63,      -25,   81,   49,       -6,   70,   35,       13,   59,   22,
      32,   48,    8,       51,   37,   -4,       70,   27,  -18,       89,   16,  -31,
     -42,   90,   67,      -23,   79,   53,       -3,   68,   39,       15,   58,   26,
      35,   47,   12,       54,   36,    0,       72,   26,  -14,       92,   15,  -27,
     -39,   88,   71,      -20,   78,   57,       -1,   67,   43,       18,   56,   30,
      37,   45,   16,       56,   35,    3,       75,   24,  -10,       94,   13,  -23,
     -37,   87,   75,      -18,   77,   61,        1,   66,   47,       20,   55,   34,
      40,   44,   20,       58,   33,    7,       77,   23,   -6,       97,   12,  -19,
     -34,   86,   79,      -15,   75,   66,        4,   64,   52,       23,   53,   38,
      42,   43,   25,       61,   32,   11,       80,   21,   -1,       99,   10,  -15,
     -32,   84,   83,      -13,   74,   70,        6,   63,   56,       25,   52,   42,
      45,   41,   29,       63,   31,   15,       82,   20,    2,      102,    9,  -11,
     -29,   83,   87,      -10,   72,   74,        9,   61,   60,       28,   51,   46,
      47,   40,   33,       66,   29,   19,       85,   19,    6,      104,    8,   -7,
     -27,   82,   91,       -8,   71,   78,       11,   60,   64,       30,   49,   50,
      49,   38,   37,       68,   28,   23,       87,   17,   10,      106,    6,   -3,
     -24,   80,   96,       -5,   69,   82,       14,   58,   68,       33,   48,   55,
      52,   37,   41,       71,   26,   28,       90,   16,   14,      109,    5,    1,
     -22,   79,  100,       -3,   68,   86,       16,   57,   72,       35,   47,   59,
      55,   36,   45,       73,   25,   32,       92,   14,   18,      111,    3,    5,
     -19,   77,  104,       -1,   67,   90,       19,   56,   76,       38,   45,   63,
      57,   34,   49,       76,   24,   36,       94,   13,   22,      114,    2,    9,
     -95,  124,  -24,      -76,  114,  -37,      -57,  103,  -51,      -38,   92,  -64,
     -18,   81,  -78,        0,   71,  -91,       19,   60, -105,       39,   49, -119,
     -92,  123,  -20,      -74,  112,  -33,      -54,  101,  -47,      -35,   91,  -60,
     -16,   80,  -74,        3,   69,  -87,       22,   59, -101,       41,   48, -115,
     -90,  122,  -16,      -71,  111,  -29,      -52,  100,  -43,      -33,   90,  -56,
     -14,   79,  -70,        5,   68,  -83,       24,   57,  -97,       43,   46, -111,
     -87,  120,  -11,      -68,  110,  -24,      -49,   99,  -38,      -30,   88,  -52,
     -11,   77,  -66,        8,   66,  -79,       27,   56,  -92,       46,   45, -106,
     -85,  119,   -7,      -66,  108,  -20,      -47,   97,  -34,      -28,   87,  -48,
      -9,   76,  -62,       10,   65,  -75,       29,   55,  -88,       48,   44, -102,
     -82,  117,   -3,      -64,  107,  -16,      -44,   96,  -30,      -26,   85,  -44,
      -6,   74,  -58,       13,   64,  -71,       31,   53,  -84,       51,   42,  -98,
     -80,  116,    0,      -61,  105,  -12,      -42,   95,  -26,      -23,   84,  -40,
      -4,   73,  -54,       15,   62,  -67,       34,   52,  -80,       53,   41,  -94,
     -77,  115,    4,      -59,  104,   -8,      -39,   93,  -22,      -20,   82,  -35,
      -1,   71,  -49,       18,   61,  -62,       36,   50,  -76,       56,   39,  -90,
     -75,  113,    8,      -56,  103,   -4,      -37,   92,  -18,      -18,   81,  -31,
       1,   70,  -45,       20,   60,  -58,       39,   49,  -72,       58,   38,  -86,
     -73,  112,   12,      -54,  101,    0,      -34,   90,  -14,      -16,   80,  -27,
       4,   69,  -41,       22,   58,  -54,       41,   48,  -68,       61,   37,  -82,
     -70,  111,   16,      -51,  100,    3,      -32,   89,  -10,      -13,   78,  -23,
       6,   67,  -37,       25,   57,  -50,       44,   46,  -64,       63,   35,  -78,
     -68,  109,   20,      -49,   99,    7,      -30,   88,   -6,      -11,   77,  -19,
       8,   66,  -33,       27,   55,  -46,       46,   45,  -60,       65,   34,  -74,
     -65,  108,   25,      -46,   97,   12,      -27,   86,   -1,       -8,   76,  -15,
      11,   65,  -29,       30,   54,  -42,       49,   43,  -55,       68,   32,  -69,
     -63,  106,   29,      -44,   96,   16,      -25,   85,    2,       -6,   74,  -11,
      14,   63,  -25,       32,   53,  -38,       51,   42,  -51,       71,   31,  -65,
     -60,  105,   33,      -42,   94,   20,      -22,   83,    6,       -3,   73,   -7,
      16,   62,  -21,       35,   51,  -34,       54,   41,  -47,       73,   30,  -61,
     -58,  104,   37,      -39,   93,   24,      -20,   82,   10,       -1,   71,   -3,
      18,   61,  -17,       37,   50,  -30,       56,   39,  -43,       75,   28,  -57,
     -55,  102,   41,      -36,   91,   28,      -17,   81,   14,        2,   70,    1,
      21,   59,  -12,       40,   48,  -25,       59,   38,  -39,       78,   27,  -53,
     -53,  101,   45,      -34,   90,   32,      -15,   79,   18,        4,   69,    5,
      23,   58,   -8,       42,   47,  -21,       61,   36,  -35,       80,   26,  -49,
     -50,   99,   49,      -32,   89,   36,      -12,   78,   22,        6,   67,    9,
      26,   56,   -4,       45,   46,  -17,       63,   35,  -31,       83,   24,  -45,
     -48,   98,   53,      -29,   87,   40,      -10,   76,   26,        9,   66,   13,
      28,   55,    0,       47,   44,  -13,       66,   34,  -27,       85,   23,  -41,
     -45,   97,   58,      -27,   86,   45,       -7,   75,   31,       12,   64,   17,
      31,   53,    3,       50,   43,   -9,       68,   32,  -22,       88,   21,  -36,
     -43,   95,   62,      -24,   85,   49,       -5,   74,   35,       14,   63,   21,
      33,   52,    7,       52,   41,   -5,       71,   31,  -18,       90,   20,  -32,
     -41,   94,   66,      -22,   83,   53,       -2,   72,   39,       16,   62,   25,
      36,   51,   11,       54,   40,   -1,       73,   30,  -14,       93,   19,  -28,
     -38,   92,   70,      -19,   82,   57,        0,   71,   43,       19,   60,   29,
      38,   49,   15,       57,   39,    2,       76,   28,  -10,       95,   17,  -24,
     -36,   91,   74,      -17,   81,   61,        2,   70,   47,       21,   59,   33,
      40,   48,   19,       59,   37,    6,       78,   27,   -6,       97,   16,  -20,
     -33,   90,   78,      -14,   79,   65,        5,   68,   51,       24,   57,   38,
      43,   47,   24,       62,   36,   11,       81,   25,   -2,      100,   14,  -16,
     -31,   88,   82,      -12,   78,   69,        7,   67,   55,       26,   56,   42,
      46,   45,   28,       64,   35,   15,       83,   24,    1,      103,   13,  -12,
     -28,   87,   86,      -10,   76,   73,       10,   65,   59,       29,   55,   46,
      48,   44,   32,       67,   33,   19,       86,   23,    5,      105,   12,   -8,
     -26,   86,   90,       -7,   75,   77,       12,   64,   63,       31,   53,   50,
      50,   42,   36,       69,   32,   23,       88,   21,    9,      107,   10,   -4,
     -23,   84,   95,       -4,   73,   82,       15,   62,   68,       34,   52,   54,
      53,   41,   40,       72,   30,   27,       91,   20,   14,      110,    9,    0,
     -21,   83,   99,       -2,   72,   86,       17,   61,   72,       36,   51,   58,
      55,   40,   44,       74,   29,   31,       93,   18,   18,      112,    7,    4,
     -18,   81,  103,        0,   71,   90,       20,   60,   76,       38,   49,   62,
      58,   38,   48,       77,   28,   35,       95,   17,   22,      115,    6,    8,
    -121,   -3,   -5,     -102,  -14,  -18,      -83,  -25,  -32,      -65,  -36,  -45,
     -45,  -47,  -59,      -26,  -57,  -72,       -8,  -68,  -86,       12,  -79, -100,
    -119,   -5,   -1,     -100,  -16,  -14,      -81,  -26,  -28,      -62,  -37,  -41,
     -43,  -48,  -55,      -24,  -58,  -68,       -5,  -69,  -82,       14,  -80,  -96,
    -117,   -6,    2,      -97,  -17,  -10,      -79,  -28,  -24,      -60,  -38,  -37,
     -40,  -49,  -51,      -22,  -60,  -64,       -3,  -70,  -78,       17,  -81,  -92,
    -114,   -8,    7,      -95,  -19,   -6,      -76,  -29,  -19,      -57,  -40,  -33,
     -38,  -51,  -46,      -19,  -61,  -60,        0,  -72,  -73,       19,  -83,  -87,
    -112,   -9,   11,      -92,  -20,   -2,      -73,  -31,  -15,      -55,  -41,  -29,
     -35,  -52,  -42,      -16,  -63,  -56,        2,  -73,  -69,       22,  -84,  -83,
    -109,  -10,   15,      -90,  -21,    1,      -71,  -32,  -11,      -52,  -43,  -25,
     -33,  -53,  -38,      -14,  -64,  -52,        5,  -75,  -65,       24,  -86,  -79,
    -107,  -12,   19,      -87,  -23,    5,      -69,  -33,   -7,      -50,  -44,  -21,
     -30,  -55,  -34,      -12,  -65,  -48,        7,  -76,  -61,       26,  -87,  -75,
    -104,  -13,   23,      -85,  -24,   10,      -66,  -35,   -3,      -47,  -45,  -16,
     -28,  -56,  -30,       -9,  -67,  -43,       10,  -78,  -57,       29,  -88,  -71,
    -102,  -15,   27,      -82,  -26,   14,      -64,  -36,    0,      -45,  -47,  -12,
     -25,  -58,  -26,       -7,  -68,  -39,       12,  -79,  -53,       32,  -90,  -67,
     -99,  -16,   31,      -80,  -27,   18,      -61,  -37,    4,      -42,  -48,   -8,
     -23,  -59,  -22,       -4,  -70,  -35,       15,  -80,  -49,       34,  -91,  -63,
     -97,  -17,   35,      -78,  -28,   22,      -59,  -39,    8,      -40,  -49,   -4,
     -21,  -60,  -18,       -2,  -71,  -31,       17,  -82,  -45,       36,  -93,  -59,
     -95,  -19,   39,      -75,  -30,   26,      -56,  -40,   12,      -38,  -51,    0,
     -18,  -62,  -14,        1,  -72,  -27,       19,  -83,  -41,       39,  -94,  -55,
     -92,  -20,   44,      -72,  -31,   30,      -54,  -42,   17,      -35,  -52,    3,
     -16,  -63,   -9,        3,  -74,  -23,       22,  -84,  -36,       41,  -95,  -50,
     -89,  -22,   48,      -70,  -32,   34,      -51,  -43,   21,      -33,  -54,    7,
     -13,  -65,   -5,        6,  -75,  -19,       24,  -86,  -32,       44,  -97,  -46,
     -87,  -23,   52,      -68,  -34,   38,      -49,  -44,   25,      -30,  -55,   11,
     -11,  -66,   -1,        8,  -77,  -15,       27,  -87,  -28,       46,  -98,  -42,
     -85,  -24,   56,      -65,  -35,   42,      -47,  -46,   29,      -28,  -56,   15,
      -8,  -67,    2,       10,  -78,  -11,       29,  -88,  -24,       49,  -99,  -38,
     -82,  -26,   60,      -63,  -37,   47,      -44,  -47,   33,      -25,  -58,   20,
      -6,  -69,    6,       13,  -79,   -6,       32,  -90,  -20,       51, -101,  -34,
     -80,  -27,   64,      -60,  -38,   51,      -41,  -49,   37,      -23,  -59,   24,
      -3,  -70,   10,       15,  -81,   -2,       34,  -91,  -16,       54, -102,  -30,
     -77,  -28,   68,      -58,  -39,   55,      -39,  -50,   41,      -20,  -61,   28,
      -1,  -72,   14,       18,  -82,    1,       37,  -93,  -12,       56, -104,  -26,
     -75,  -30,   72,      -55,  -41,   59,      -37,  -51,   45,      -18,  -62,   32,
       1,  -73,   18,       20,  -83,    5,       39,  -94,   -8,       58, -105,  -22,
     -72,  -31,   77,      -53,  -42,   63,      -34,  -53,   50,      -15,  -63,   36,
       4,  -74,   23,       23,  -85,    9,       42,  -96,   -3,       61, -107,  -17,
     -70,  -33,   81,      -50,  -44,   67,      -32,  -54,   54,      -13,  -65,   40,
       7,  -76,   27,       25,  -86,   13,       44,  -97,    0,       64, -108,  -13,
     -67,  -34,   85,      -48,  -45,   71,      -29,  -56,   58,      -10,  -66,   44,
       9,  -77,   31,       28,  -88,   17,       47,  -98,    4,       66, -109,   -9,
     -65,  -35,   89,      -46,  -46,   75,      -27,  -57,   62,       -8,  -67,   48,
      11,  -78,   35,       30,  -89,   21,       49, -100,    8,       68, -111,   -5,
     -63,  -37,   93,      -43,  -48,   79,      -24,  -58,   66,       -6,  -69,   52,
      14,  -80,   39,       33,  -90,   25,       51, -101,   12,       71, -112,   -1,
     -60,  -38,   97,      -40,  -49,   84,      -22,  -60,   70,       -3,  -70,   57,
      16,  -81,   43,       35,  -92,   30,       54, -103,   16,       73, -113,    2,
     -57,  -40,  101,      -38,  -51,   88,      -19,  -61,   74,       -1,  -72,   61,
      19,  -83,   47,       38,  -93,   34,       56, -104,   20,       76, -115,    6,
     -55,  -41,  105,      -36,  -52,   92,      -17,  -62,   78,        2,  -73,   65,
      21,  -84,   51,       40,  -95,   38,       59, -105,   24,       78, -116,   10,
     -53,  -42,  109,      -33,  -53,   96,      -15,  -64,   82,        4,  -74,   69,
      24,  -85,   55,       42,  -96,   42,       61, -107,   28,       81, -117,   14,
     -50,  -44,  114,      -31,  -55,  100,      -12,  -65,   87,        7,  -76,   73,
      26,  -87,   60,       45,  -97,   46,       64, -108,   33,       83, -119,   19,
     -48,  -45,  118,      -28,  -56,  104,       -9,  -67,   91,        9,  -77,   77,
      29,  -88,   64,       47,  -99,   50,       66, -109,   37,       86, -120,   23,
     -45,  -47,  122,      -26,  -57,  108,       -7,  -68,   95,       12,  -79,   81,
      31,  -90,   68,       50, -100,   54,       69, -111,   41,       88, -122,   27,
    -121,    0,   -5,     -101,  -10,  -19,      -82,  -21,  -32,      -64,  -32,  -46,
     -44,  -43,  -60,      -25,  -53,  -73,       -7,  -64,  -86,       13,  -75, -100,
    -118,   -1,   -1,      -99,  -12,  -15,      -80,  -22,  -28,      -61,  -33,  -42,
     -42,  -44,  -56,      -23,  -54,  -69,       -4,  -65,  -82,       15,  -76,  -96,
    -116,   -2,    2,      -96,  -13,  -11,      -78,  -24,  -24,      -59,  -34,  -38,
     -39,  -45,  -52,      -21,  -56,  -65,       -2,  -66,  -78,       17,  -77,  -92,
    -113,   -4,    6,      -94,  -15,   -6,      -75,  -25,  -20,      -56,  -36,  -33,
     -37,  -47,  -47,      -18,  -57,  -61,        1,  -68,  -74,       20,  -79,  -88,
    -111,   -5,   10,      -91,  -16,   -2,      -73,  -27,  -16,      -54,  -37,  -29,
     -34,  -48,  -43,      -16,  -59,  -57,        3,  -69,  -70,       23,  -80,  -84,
    -108,   -6,   14,      -89,  -17,    1,      -70,  -28,  -12,      -51,  -39,  -25,
     -32,  -49,  -39,      -13,  -60,  -53,        6,  -71,  -66,       25,  -82,  -80,
    -106,   -8,   18,      -87,  -19,    5,      -68,  -29,   -8,      -49,  -40,  -21,
     -30,  -51,  -35,      -11,  -61,  -49,        8,  -72,  -62,       27,  -83,  -76,
    -103,   -9,   23,      -84,  -20,    9,      -65,  -31,   -3,      -46,  -41,  -17,
     -27,  -52,  -31,       -8,  -63,  -44,       11,  -74,  -57,       30,  -84,  -71,
    -101,  -11,   27,      -81,  -22,   13,      -63,  -32,    0,      -44,  -43,  -13,
     -24,  -54,  -27,       -6,  -64,  -40,       13,  -75,  -53,       32,  -86,  -67,
     -98,  -12,   31,      -79,  -23,   17,      -60,  -33,    4,      -41,  -44,   -9,
     -22,  -55,  -23,       -3,  -66,  -36,       15,  -76,  -49,       35,  -87,  -63,
     -96,  -13,   35,      -77,  -24,   21,      -58,  -35,    8,      -39,  -45,   -5,
     -20,  -56,  -19,       -1,  -67,  -32,       18,  -78,  -45,       37,  -89,  -59,
     -94,  -15,   39,      -74,  -26,   25,      -55,  -36,   12,      -37,  -47,   -1,
     -17,  -58,  -15,        1,  -68,  -28,       20,  -79,  -41,       40,  -90,  -55,
     -91,  -16,   43,      -72,  -27,   30,      -53,  -38,   16,      -34,  -48,    3,
     -15,  -59,  -10,        4,  -70,  -24,       23,  -80,  -37,       42,  -91,  -51,
     -89,  -18,   47,      -69,  -28,   34,      -50,  -39,   20,      -32,  -50,    7,
     -12,  -61,   -6,        7,  -71,  -20,       25,  -82,  -33,       45,  -93,  -47,
     -86,  -19,   51,      -67,  -30,   38,      -48,  -40,   24,      -29,  -51,   11,
     -10,  -62,   -2,        9,  -73,  -16,       28,  -83,  -29,       47,  -94,  -43,
     -84,  -20,   55,      -64,  -31,   42,      -46,  -42,   28,      -27,  -52,   15,
      -7,  -63,    1,       11,  -74,  -12,       30,  -84,  -25,       49,  -95,  -39,
     -81,  -22,   60,      -62,  -33,   46,      -43,  -43,   33,      -24,  -54,   19,
      -5,  -65,    5,       14,  -75,   -7,       33,  -86,  -20,       52,  -97,  -34,
     -79,  -23,   64,      -59,  -34,   50,      -41,  -45,   37,      -22,  -55,   23,
      -2,  -66,    9,       16,  -77,   -3,       35,  -87,  -16,       55,  -98,  -30,
     -76,  -24,   68,      -57,  -35,   54,      -38,  -46,   41,      -19,  -57,   27,
       0,  -68,   13,       19,  -78,    0,       38,  -89,  -12,       57, -100,  -26,
     -74,  -26,   72,      -55,  -37,   58,      -36,  -47,   45,      -17,  -58,   31,
       2,  -69,   17,       21,  -79,    4,       40,  -90,   -8,       59, -101,  -22,
     -71,  -27,   76,      -52,  -38,   63,      -33,  -49,   49,      -14,  -59,   36,
       5,  -70,   22,       24,  -81,    8,       43,  -92,   -4,       62, -103,  -18,
     -69,  -29,   80,      -49,  -40,   67,      -31,  -50,   53,      -12,  -61,   40,
       7,  -72,   26,       26,  -82,   12,       45,  -93,    0,       64, -104,  -14,
     -66,  -30,   84,      -47,  -41,   71,      -28,  -52,   57,       -9,  -62,   44,
      10,  -73,   30,       29,  -84,   16,       47,  -94,    3,       67, -105,  -10,
     -64,  -31,   88,      -45,  -42,   75,      -26,  -53,   61,       -7,  -63,   48,
      12,  -74,   34,       31,  -85,   20,       50,  -96,    7,       69, -107,   -6,
     -62,  -33,   92,      -42,  -44,   79,      -23,  -54,   65,       -5,  -65,   52,
      15,  -76,   38,       33,  -86,   24,       52,  -97,   11,       72, -108,   -2,
     -59,  -34,   97,      -40,  -45,   83,      -21,  -56,   70,       -2,  -66,   56,
      17,  -77,   42,       36,  -88,   29,       55,  -99,   16,       74, -109,    2,
     -57,  -36,  101,      -37,  -47,   87,      -18,  -57,   74,        0,  -68,   60,
      20,  -79,   46,       39,  -89,   33,       57, -100,   20,       77, -111,    6,
     -54,  -37,  105,      -35,  -48,   91,      -16,  -58,   78,        3,  -69,   64,
      22,  -80,   50,       41,  -91,   37,       60, -101,   24,       79, -112,   10,
     -52,  -38,  109,      -32,  -49,   95,      -14,  -60,   82,        5,  -70,   68,
      25,  -81,   54,       43,  -92,   41,       62, -103,   28,       81, -113,   14,
     -49,  -40,  113,      -30,  -51,  100,      -11,  -61,   86,        8,  -72,   73,
      27,  -83,   59,       46,  -93,   45,       65, -104,   32,       84, -115,   18,
     -47,  -41,  117,      -27,  -52,  104,       -9,  -63,   90,       10,  -73,   77,
      30,  -84,   63,       48,  -95,   49,       67, -105,   36,       87, -116,   22,
     -44,  -43,  121,      -25,  -53,  108,       -6,  -64,   94,       13,  -75,   81,
      32,  -86,   67,       51,  -96,   53,       70, -107,   40,       89, -118,   26,
    -120,    4,   -6,     -100,   -6,  -20,      -81,  -17,  -33,      -63,  -28,  -46,
     -43,  -39,  -60,      -25,  -49,  -74,       -6,  -60,  -87,       14,  -71, -101,
    -117,    2,   -2,      -98,   -8,  -16,      -79,  -18,  -29,      -60,  -29,  -42,
     -41,  -40,  -56,      -22,  -50,  -70,       -3,  -61,  -83,       16,  -72,  -97,
    -115,    1,    1,      -95,   -9,  -12,      -77,  -20,  -25,      -58,  -30,  -38,
     -39,  -41,  -52,      -20,  -52,  -66,       -1,  -62,  -79,       18,  -73,  -93,
    -112,    0,    6,      -93,  -11,   -7,      -74,  -21,  -21,      -55,  -32,  -34,
     -36,  -43,  -48,      -17,  -53,  -61,        2,  -64,  -75,       21,  -75,  -88,
    -110,   -1,   10,      -90,  -12,   -3,      -72,  -23,  -17,      -53,  -33,  -30,
     -33,  -44,  -44,      -15,  -55,  -57,        4,  -65,  -71,       23,  -76,  -84,
    -107,   -2,   14,      -88,  -13,    0,      -69,  -24,  -13,      -50,  -35,  -26,
     -31,  -45,  -40,      -12,  -56,  -53,        7,  -67,  -67,       26,  -78,  -80,
    -105,   -4,   18,      -86,  -15,    4,      -67,  -25,   -9,      -48,  -36,  -22,
     -29,  -47,  -36,      -10,  -57,  -49,        9,  -68,  -63,       28,  -79,  -76,
    -102,   -5,   22,      -83,  -16,    8,      -64,  -27,   -4,      -45,  -37,  -17,
     -26,  -48,  -31,       -7,  -59,  -45,       12,  -70,  -58,       31,  -80,  -72,
    -100,   -7,   26,      -81,  -18,   12,      -62,  -28,    0,      -43,  -39,  -13,
     -24,  -50,  -27,       -5,  -60,  -41,       14,  -71,  -54,       33,  -82,  -68,
     -98,   -8,   30,      -78,  -19,   16,      -59,  -29,    3,      -41,  -40,   -9,
     -21,  -51,  -23,       -2,  -62,  -37,       16,  -72,  -50,       36,  -83,  -64,
     -95,   -9,   34,      -76,  -20,   20,      -57,  -31,    7,      -38,  -41,   -5,
     -19,  -52,  -19,        0,  -63,  -33,       19,  -74,  -46,       38,  -85,  -60,
     -93,  -11,   38,      -73,  -22,   24,      -55,  -32,   11,      -36,  -43,   -1,
     -16,  -54,  -15,        2,  -64,  -29,       21,  -75,  -42,       41,  -86,  -56,
     -90,  -12,   43,      -71,  -23,   29,      -52,  -34,   15,      -33,  -44,    2,
     -14,  -55,  -11,        5,  -66,  -24,       24,  -76,  -38,       43,  -87,  -51,
     -88,  -14,   47,      -68,  -24,   33,      -49,  -35,   19,      -31,  -46,    6,
     -11,  -57,   -7,        7,  -67,  -20,       26,  -78,  -34,       46,  -89,  -47,
     -85,  -15,   51,      -66,  -26,   37,      -47,  -36,   23,      -28,  -47,   10,
      -9,  -58,   -3,       10,  -69,  -16,       29,  -79,  -30,       48,  -90,  -43,
     -83,  -16,   55,      -63,  -27,   41,      -45,  -38,   27,      -26,  -48,   14,
      -7,  -59,    0,       12,  -70,  -12,       31,  -80,  -26,       50,  -91,  -39,
     -80,  -18,   59,      -61,  -29,   45,      -42,  -39,   32,      -23,  -50,   19,
      -4,  -61,    5,       15,  -71,   -8,       34,  -82,  -21,       53,  -93,  -35,
     -78,  -19,   63,      -58,  -30,   49,      -40,  -41,   36,      -21,  -51,   23,
      -1,  -62,    9,       17,  -73,   -4,       36,  -83,  -17,       55,  -94,  -31,
     -75,  -20,   67,      -56,  -31,   53,      -37,  -42,   40,      -18,  -53,   27,
       1,  -64,   13,       20,  -74,    0,       38,  -85,  -13,       58,  -96,  -27,
     -73,  -22,   71,      -54,  -33,   57,      -35,  -43,   44,      -16,  -54,   31,
       3,  -65,   17,       22,  -75,    3,       41,  -86,   -9,       60,  -97,  -23,
     -70,  -23,   76,      -51,  -34,   62,      -32,  -45,   48,      -13,  -55,   35,
       6,  -66,   21,       25,  -77,    8,       44,  -88,   -5,       63,  -99,  -18,
     -68,  -25,   80,      -49,  -36,   66,      -30,  -46,   52,      -11,  -57,   39,
       8,  -68,   25,       27,  -78,   12,       46,  -89,   -1,       65, -100,  -14,
     -66,  -26,   84,      -46,  -37,   70,      -27,  -48,   56,       -9,  -58,   43,
      11,  -69,   29,       30,  -80,   16,       48,  -90,    2,       68, -101,  -10,
     -63,  -27,   88,      -44,  -38,   74,      -25,  -49,   60,       -6,  -59,   47,
      13,  -70,   33,       32,  -81,   20,       51,  -92,    6,       70, -103,   -6,
     -61,  -29,   92,      -41,  -40,   78,      -23,  -50,   64,       -4,  -61,   51,
      16,  -72,   37,       34,  -82,   24,       53,  -93,   10,       73, -104,   -2,
     -58,  -30,   96,      -39,  -41,   82,      -20,  -52,   69,       -1,  -62,   56,
      18,  -73,   42,       37,  -84,   28,       56,  -95,   15,       75, -105,    1,
     -56,  -32,  100,      -36,  -43,   86,      -17,  -53,   73,        1,  -64,   60,
      21,  -75,   46,       39,  -85,   32,       58,  -96,   19,       78, -107,    5,
     -53,  -33,  104,      -34,  -44,   90,      -15,  -54,   77,        4,  -65,   64,
      23,  -76,   50,       42,  -87,   36,       61,  -97,   23,       80, -108,    9,
     -51,  -34,  108,      -31,  -45,   94,      -13,  -56,   81,        6,  -66,   68,
      25,  -77,   54,       44,  -88,   40,       63,  -99,   27,       82, -109,   13,
     -48,  -36,  113,      -29,  -47,   99,      -10,  -57,   85,        9,  -68,   72,
      28,  -79,   58,       47,  -89,   45,       66, -100,   31,       85, -111,   18,
     -46,  -37,  117,      -26,  -48,  103,       -8,  -59,   89,       11,  -69,   76,
      31,  -80,   62,       49,  -91,   49,       68, -101,   35,       87, -112,   22,
     -43,  -39,  121,      -24,  -49,  107,       -5,  -60,   93,       14,  -71,   80,
      33,  -82,   66,       52,  -92,   53,       70, -103,   39,       90, -114,   26,
    -119,    8,   -7,      -99,   -2,  -20,      -80,  -13,  -34,      -62,  -23,  -47,
     -42,  -34,  -61,      -24,  -45,  -74,       -5,  -55,  -88,       15,  -66, -102,
    -116,    7,   -3,      -97,   -3,  -16,      -78,  -14,  -30,      -59,  -24,  -43,
     -40,  -35,  -57,      -21,  -46,  -70,       -2,  -57,  -84,       17,  -68,  -98,
    -114,    5,    0,      -94,   -5,  -12,      -76,  -15,  -26,      -57,  -26,  -39,
     -38,  -37,  -53,      -19,  -47,  -66,        0,  -58,  -80,       19,  -69,  -94,
    -111,    4,    5,      -92,   -6,   -8,      -73,  -17,  -21,      -54,  -27,  -35,
     -35,  -38,  -48,      -16,  -49,  -62,        3,  -59,  -75,       22,  -70,  -89,
    -109,    2,    9,      -89,   -7,   -4,      -71,  -18,  -17,      -52,  -29,  -31,
     -32,  -40,  -44,      -14,  -50,  -58,        5,  -61,  -71,       25,  -72,  -85,
    -106,    1,   13,      -87,   -9,    0,      -68,  -19,  -13,      -49,  -30,  -27,
     -30,  -41,  -40,      -11,  -52,  -54,        8,  -62,  -67,       27,  -73,  -81,
    -104,    0,   17,      -85,  -10,    3,      -66,  -21,   -9,      -47,  -31,  -23,
     -28,  -42,  -36,       -9,  -53,  -50,       10,  -64,  -63,       29,  -74,  -77,
    -101,   -1,   21,      -82,  -12,    8,      -63,  -22,   -5,      -44,  -33,  -18,
     -25,  -44,  -32,       -6,  -54,  -45,       13,  -65,  -59,       32,  -76,  -73,
     -99,   -2,   25,      -80,  -13,   12,      -61,  -24,   -1,      -42,  -34,  -14,
     -23,  -45,  -28,       -4,  -56,  -41,       15,  -66,  -55,       34,  -77,  -69,
     -96,   -3,   29,      -77,  -14,   16,      -58,  -25,    2,      -40,  -36,  -10,
     -20,  -47,  -24,       -1,  -57,  -37,       17,  -68,  -51,       37,  -79,  -65,
     -94,   -5,   33,      -75,  -16,   20,      -56,  -26,    6,      -37,  -37,   -6,
     -18,  -48,  -20,        1,  -58,  -33,       20,  -69,  -47,       39,  -80,  -61,
     -92,   -6,   37,      -72,  -17,   24,      -54,  -28,   10,      -35,  -38,   -2,
     -15,  -49,  -16,        3,  -60,  -29,       22,  -70,  -43,       42,  -81,  -57,
     -89,   -8,   42,      -70,  -19,   28,      -51,  -29,   15,      -32,  -40,    1,
     -13,  -51,  -11,        6,  -61,  -25,       25,  -72,  -38,       44,  -83,  -52,
     -87,   -9,   46,      -67,  -20,   32,      -48,  -31,   19,      -30,  -41,    5,
     -10,  -52,   -7,        8,  -63,  -21,       27,  -73,  -34,       47,  -84,  -48,
     -84,  -10,   50,      -65,  -21,   36,      -46,  -32,   23,      -27,  -43,    9,
      -8,  -53,   -3,       11,  -64,  -17,       30,  -75,  -30,       49,  -86,  -44,
     -82,  -12,   54,      -62,  -23,   40,      -44,  -33,   27,      -25,  -44,   13,
      -6,  -55,    0,       13,  -65,  -13,       32,  -76,  -26,       51,  -87,  -40,
     -79,  -13,   58,      -60,  -24,   45,      -41,  -35,   31,      -22,  -45,   18,
      -3,  -56,    4,       16,  -67,   -8,       35,  -78,  -22,       54,  -88,  -36,
     -77,  -15,   62,      -57,  -26,   49,      -39,  -36,   35,      -20,  -47,   22,
       0,  -58,    8,       18,  -68,   -4,       37,  -79,  -18,       57,  -90,  -32,
     -74,  -16,   66,      -55,  -27,   53,      -36,  -37,   39,      -17,  -48,   26,
       2,  -59,   12,       21,  -70,    0,       40,  -80,  -14,       59,  -91,  -28,
     -72,  -17,   70,      -53,  -28,   57,      -34,  -39,   43,      -15,  -49,   30,
       4,  -60,   16,       23,  -71,    3,       42,  -82,  -10,       61,  -92,  -24,
     -69,  -19,   75,      -50,  -30,   61,      -31,  -40,   48,      -12,  -51,   34,
       7,  -62,   21,       26,  -72,    7,       45,  -83,   -5,       64,  -94,  -19,
     -67,  -20,   79,      -48,  -31,   65,      -29,  -42,   52,      -10,  -52,   38,
       9,  -63,   25,       28,  -74,   11,       47,  -84,   -1,       66,  -95,  -15,
     -64,  -22,   83,      -45,  -32,   69,      -26,  -43,   56,       -8,  -54,   42,
      12,  -65,   29,       31,  -75,   15,       49,  -86,    2,       69,  -97,  -11,
     -62,  -23,   87,      -43,  -34,   73,      -24,  -44,   60,       -5,  -55,   46,
      14,  -66,   33,       33,  -77,   19,       52,  -87,    6,       71,  -98,   -7,
     -60,  -24,   91,      -40,  -35,   77,      -22,  -46,   64,       -3,  -56,   50,
      17,  -67,   37,       35,  -78,   23,       54,  -88,   10,       74,  -99,   -3,
     -57,  -26,   95,      -38,  -37,   82,      -19,  -47,   68,        0,  -58,   55,
      19,  -69,   41,       38,  -79,   28,       57,  -90,   14,       76, -101,    0,
     -55,  -27,   99,      -35,  -38,   86,      -16,  -49,   72,        2,  -59,   59,
      22,  -70,   45,       40,  -81,   32,       59,  -91,   18,       79, -102,    4,
     -52,  -28,  103,      -33,  -39,   90,      -14,  -50,   76,        5,  -61,   63,
      24,  -71,   49,       43,  -82,   36,       62,  -93,   22,       81, -104,    8,
     -50,  -30,  107,      -30,  -41,   94,      -12,  -51,   80,        7,  -62,   67,
      26,  -73,   53,       45,  -83,   40,       64,  -94,   26,       83, -105,   12,
     -47,  -31,  112,      -28,  -42,   98,       -9,  -53,   85,       10,  -63,   71,
      29,  -74,   58,       48,  -85,   44,       67,  -96,   31,       86, -107,   17,
     -45,  -33,  116,      -25,  -44,  102,       -7,  -54,   89,       12,  -65,   75,
      32,  -76,   62,       50,  -86,   48,       69,  -97,   35,       88, -108,   21,
     -42,  -34,  120,      -23,  -45,  106,       -4,  -56,   93,       15,  -66,   79,
      34,  -77,   66,       53,  -88,   52,       72,  -98,   39,       91, -109,   25,
    -118,   12,   -7,      -98,    1,  -21,      -80,   -9,  -34,      -61,  -19,  -48,
     -41,  -30,  -62,      -23,  -41,  -75,       -4,  -51,  -88,       16,  -62, -102,
    -115,   11,   -3,      -96,    0,  -17,      -77,  -10,  -30,      -58,  -20,  -44,
     -39,  -31,  -58,      -20,  -42,  -71,       -1,  -53,  -84,       18,  -64,  -98,
    -113,    9,    0,      -94,   -1,  -13,      -75,  -11,  -26,      -56,  -22,  -40,
     -37,  -33,  -54,      -18,  -43,  -67,        1,  -54,  -80,       20,  -65,  -94,
    -110,    8,    4,      -91,   -2,   -9,      -72,  -13,  -22,      -53,  -23,  -35,
     -34,  -34,  -49,      -15,  -45,  -63,        4,  -55,  -76,       23,  -66,  -90,
    -108,    6,    8,      -88,   -3,   -5,      -70,  -14,  -18,      -51,  -25,  -31,
     -32,  -36,  -45,      -13,  -46,  -59,        6,  -57,  -72,       25,  -68,  -86,
    -105,    5,   12,      -86,   -5,   -1,      -67,  -15,  -14,      -48,  -26,  -27,
     -29,  -37,  -41,      -10,  -48,  -55,        8,  -58,  -68,       28,  -69,  -82,
    -103,    4,   16,      -84,   -6,    2,      -65,  -17,  -10,      -46,  -27,  -23,
     -27,  -38,  -37,       -8,  -49,  -51,       11,  -60,  -64,       30,  -70,  -78,
    -100,    2,   21,      -81,   -8,    7,      -62,  -18,   -5,      -43,  -29,  -19,
     -24,  -40,  -33,       -5,  -50,  -46,       14,  -61,  -59,       33,  -72,  -73,
     -98,    1,   25,      -79,   -9,   11,      -60,  -20,   -1,      -41,  -30,  -15,
     -22,  -41,  -29,       -3,  -52,  -42,       16,  -62,  -55,       35,  -73,  -69,
     -96,    0,   29,      -76,  -10,   15,      -57,  -21,    2,      -39,  -32,  -11,
     -19,  -43,  -25,        0,  -53,  -38,       18,  -64,  -51,       38,  -75,  -65,
     -93,   -1,   33,      -74,  -12,   19,      -55,  -22,    6,      -36,  -33,   -7,
     -17,  -44,  -21,        2,  -54,  -34,       21,  -65,  -47,       40,  -76,  -61,
     -91,   -2,   37,      -71,  -13,   23,      -53,  -24,   10,      -34,  -34,   -3,
     -14,  -45,  -17,        4,  -56,  -30,       23,  -66,  -43,       42,  -77,  -57,
     -88,   -4,   41,      -69,  -15,   27,      -50,  -25,   14,      -31,  -36,    1,
     -12,  -47,  -12,        7,  -57,  -26,       26,  -68,  -39,       45,  -79,  -53,
     -86,   -5,   45,      -66,  -16,   31,      -48,  -27,   18,      -29,  -37,    5,
      -9,  -48,   -8,        9,  -59,  -22,       28,  -69,  -35,       48,  -80,  -49,
     -83,   -6,   49,      -64,  -17,   35,      -45,  -28,   22,      -26,  -39,    9,
      -7,  -49,   -4,       12,  -60,  -18,       31,  -71,  -31,       50,  -82,  -45,
     -81,   -8,   53,      -62,  -19,   39,      -43,  -29,   26,      -24,  -40,   13,
      -5,  -51,    0,       14,  -61,  -14,       33,  -72,  -27,       52,  -83,  -41,
     -78,   -9,   58,      -59,  -20,   44,      -40,  -31,   31,      -21,  -41,   17,
      -2,  -52,    3,       17,  -63,   -9,       36,  -74,  -22,       55,  -84,  -36,
     -76,  -11,   62,      -56,  -22,   48,      -38,  -32,   35,      -19,  -43,   21,
       0,  -54,    7,       19,  -64,   -5,       38,  -75,  -18,       57,  -86,  -32,
     -73,  -12,   66,      -54,  -23,   52,      -35,  -33,   39,      -17,  -44,   25,
       3,  -55,   11,       22,  -66,   -1,       40,  -76,  -14,       60,  -87,  -28,
     -71,  -13,   70,      -52,  -24,   56,      -33,  -35,   43,      -14,  -45,   29,
       5,  -56,   15,       24,  -67,    2,       43,  -78,  -10,       62,  -88,  -24,
     -68,  -15,   74,      -49,  -26,   60,      -30,  -36,   47,      -11,  -47,   34,
       8,  -58,   20,       27,  -68,    6,       46,  -79,   -6,       65,  -90,  -20,
     -66,  -16,   78,      -47,  -27,   64,      -28,  -38,   51,       -9,  -48,   38,
      10,  -59,   24,       29,  -70,   10,       48,  -80,   -2,       67,  -91,  -16,
     -64,  -18,   82,      -44,  -28,   68,      -25,  -39,   55,       -7,  -50,   42,
      13,  -61,   28,       32,  -71,   14,       50,  -82,    1,       70,  -93,  -12,
     -61,  -19,   86,      -42,  -30,   72,      -23,  -40,   59,       -4,  -51,   46,
      15,  -62,   32,       34,  -73,   18,       53,  -83,    5,       72,  -94,   -8,
     -59,  -20,   90,      -39,  -31,   76,      -21,  -42,   63,       -2,  -52,   50,
      18,  -63,   36,       36,  -74,   22,       55,  -84,    9,       74,  -95,   -4,
     -56,  -22,   95,      -37,  -33,   81,      -18,  -43,   68,        1,  -54,   54,
      20,  -65,   40,       39,  -75,   27,       58,  -86,   14,       77,  -97,    0,
     -54,  -23,   99,      -34,  -34,   85,      -16,  -45,   72,        3,  -55,   58,
      23,  -66,   44,       41,  -77,   31,       60,  -87,   18,       80,  -98,    4,
     -51,  -24,  103,      -32,  -35,   89,      -13,  -46,   76,        6,  -57,   62,
      25,  -67,   48,       44,  -78,   35,       63,  -89,   22,       82, -100,    8,
     -49,  -26,  107,      -30,  -37,   93,      -11,  -47,   80,        8,  -58,   66,
      27,  -69,   52,       46,  -79,   39,       65,  -90,   26,       84, -101,   12,
     -46,  -27,  111,      -27,  -38,   97,       -8,  -49,   84,       11,  -59,   71,
      30,  -70,   57,       49,  -81,   43,       68,  -92,   30,       87, -103,   16,
     -44,  -29,  115,      -24,  -40,  101,       -6,  -50,   88,       13,  -61,   75,
      32,  -72,   61,       51,  -82,   47,       70,  -93,   34,       89, -104,   20,
     -41,  -30,  119,      -22,  -41,  105,       -3,  -52,   92,       15,  -62,   79,
      35,  -73,   65,       54,  -84,   51,       72,  -94,   38,       92, -105,   24,
    -117,   16,   -8,      -97,    5,  -22,      -79,   -5,  -35,      -60,  -15,  -48,
     -40,  -26,  -62,      -22,  -37,  -76,       -3,  -47,  -89,       16,  -58, -103,
    -114,   15,   -4,      -95,    4,  -18,      -76,   -6,  -31,      -57,  -16,  -44,
     -38,  -27,  -58,      -19,  -38,  -72,       -1,  -49,  -85,       19,  -60,  -99,
    -112,   13,    0,      -93,    2,  -14,      -74,   -7,  -27,      -55,  -18,  -40,
     -36,  -29,  -54,      -17,  -39,  -68,        2,  -50,  -81,       21,  -61,  -95,
    -109,   12,    4,      -90,    1,   -9,      -71,   -9,  -23,      -52,  -19,  -36,
     -33,  -30,  -50,      -14,  -41,  -63,        5,  -51,  -77,       24,  -62,  -90,
    -107,   10,    8,      -88,    0,   -5,      -69,  -10,  -19,      -50,  -21,  -32,
     -31,  -32,  -46,      -12,  -42,  -59,        7,  -53,  -73,       26,  -64,  -86,
    -105,    9,   12,      -85,   -1,   -1,      -66,  -11,  -15,      -48,  -22,  -28,
     -28,  -33,  -42,       -9,  -44,  -55,        9,  -54,  -69,       29,  -65,  -82,
    -102,    8,   16,      -83,   -2,    2,      -64,  -13,  -11,      -45,  -23,  -24,
     -26,  -34,  -38,       -7,  -45,  -51,       12,  -56,  -65,       31,  -66,  -78,
     -99,    6,   20,      -80,   -4,    6,      -61,  -14,   -6,      -43,  -25,  -19,
     -23,  -36,  -33,       -4,  -46,  -47,       14,  -57,  -60,       34,  -68,  -74,
     -97,    5,   24,      -78,   -5,   10,      -59,  -16,   -2,      -40,  -26,  -15,
     -21,  -37,  -29,       -2,  -48,  -43,       17,  -58,  -56,       36,  -69,  -70,
     -95,    4,   28,      -75,   -6,   14,      -57,  -17,    1,      -38,  -28,  -11,
     -18,  -39,  -25,        0,  -49,  -39,       19,  -60,  -52,       39,  -71,  -66,
     -92,    2,   32,      -73,   -8,   18,      -54,  -18,    5,      -35,  -29,   -7,
     -16,  -40,  -21,        3,  -50,  -35,       22,  -61,  -48,       41,  -72,  -62,
     -90,    1,   36,      -71,   -9,   22,      -52,  -20,    9,      -33,  -30,   -3,
     -14,  -41,  -17,        5,  -52,  -31,       24,  -62,  -44,       43,  -73,  -58,
     -87,    0,   41,      -68,  -11,   27,      -49,  -21,   13,      -30,  -32,    0,
     -11,  -43,  -13,        8,  -53,  -26,       27,  -64,  -40,       46,  -75,  -53,
     -85,   -1,   45,      -65,  -12,   31,      -47,  -23,   17,      -28,  -33,    4,
      -8,  -44,   -9,       10,  -55,  -22,       29,  -65,  -36,       48,  -76,  -49,
     -82,   -2,   49,      -63,  -13,   35,      -44,  -24,   21,      -25,  -35,    8,
      -6,  -45,   -5,       13,  -56,  -18,       31,  -67,  -32,       51,  -78,  -45,
     -80,   -4,   53,      -61,  -15,   39,      -42,  -25,   25,      -23,  -36,   12,
      -4,  -47,   -1,       15,  -57,  -14,       34,  -68,  -28,       53,  -79,  -41,
     -77,   -5,   57,      -58,  -16,   43,      -39,  -27,   30,      -20,  -37,   17,
      -1,  -48,    3,       18,  -59,  -10,       37,  -70,  -23,       56,  -80,  -37,
     -75,   -7,   61,      -56,  -18,   47,      -37,  -28,   34,      -18,  -39,   21,
       1,  -50,    7,       20,  -60,   -6,       39,  -71,  -19,       58,  -82,  -33,
     -73,   -8,   65,      -53,  -19,   51,      -34,  -29,   38,      -16,  -40,   25,
       4,  -51,   11,       23,  -62,   -2,       41,  -72,  -15,       61,  -83,  -29,
     -70,   -9,   69,      -51,  -20,   55,      -32,  -31,   42,      -13,  -41,   29,
       6,  -52,   15,       25,  -63,    1,       44,  -74,  -11,       63,  -84,  -25,
     -67,  -11,   74,      -48,  -22,   60,      -29,  -32,   46,      -11,  -43,   33,
       9,  -54,   19,       28,  -64,    6,       46,  -75,   -7,       66,  -86,  -20,
     -65,  -12,   78,      -46,  -23,   64,      -27,  -34,   50,       -8,  -44,   37,
      11,  -55,   23,       30,  -66,   10,       49,  -76,   -3,       68,  -87,  -16,
     -63,  -14,   82,      -43,  -24,   68,      -25,  -35,   54,       -6,  -46,   41,
      14,  -57,   27,       32,  -67,   14,       51,  -78,    0,       71,  -89,  -12,
     -60,  -15,   86,      -41,  -26,   72,      -22,  -36,   58,       -3,  -47,   45,
      16,  -58,   31,       35,  -69,   18,       54,  -79,    4,       73,  -90,   -8,
     -58,  -16,   90,      -39,  -27,   76,      -20,  -38,   62,       -1,  -48,   49,
      18,  -59,   35,       37,  -70,   22,       56,  -80,    8,       75,  -91,   -4,
     -55,  -18,   94,      -36,  -29,   80,      -17,  -39,   67,        2,  -50,   54,
      21,  -61,   40,       40,  -71,   26,       59,  -82,   13,       78,  -93,    0,
     -53,  -19,   98,      -33,  -30,   84,      -15,  -41,   71,        4,  -51,   58,
      24,  -62,   44,       42,  -73,   30,       61,  -83,   17,       80,  -94,    3,
     -50,  -20,  102,      -31,  -31,   88,      -12,  -42,   75,        7,  -53,   62,
      26,  -63,   48,       45,  -74,   34,       63,  -85,   21,       83,  -96,    7,
     -48,  -22,  106,      -29,  -33,   92,      -10,  -43,   79,        9,  -54,   66,
      28,  -65,   52,       47,  -75,   38,       66,  -86,   25,       85,  -97,   11,
     -45,  -23,  111,      -26,  -34,   97,       -7,  -45,   83,       12,  -55,   70,
      31,  -66,   56,       50,  -77,   43,       69,  -88,   29,       88,  -99,   16,
     -43,  -25,  115,      -24,  -36,  101,       -5,  -46,   87,       14,  -57,   74,
      33,  -68,   60,       52,  -78,   47,       71,  -89,   33,       90, -100,   20,
     -41,  -26,  119,      -21,  -37,  105,       -2,  -48,   91,       16,  -58,   78,
      36,  -69,   64,       55,  -80,   51,       73,  -90,   37,       93, -101,   24,
    -116,   20,   -9,      -96,    9,  -22,      -78,   -1,  -36,      -59,  -11,  -49,
     -40,  -22,  -63,      -21,  -33,  -76,       -2,  -43,  -90,       17,  -54, -104,
    -113,   19,   -5,      -94,    8,  -18,      -75,   -2,  -32,      -57,  -12,  -45,
     -37,  -23,  -59,      -18,  -34,  -72,        0,  -45,  -86,       20,  -56, -100,
    -111,   17,   -1,      -92,    6,  -14,      -73,   -3,  -28,      -54,  -14,  -41,
     -35,  -25,  -55,      -16,  -35,  -68,        3,  -46,  -82,       22,  -57,  -96,
    -108,   16,    3,      -89,    5,  -10,      -70,   -5,  -23,      -51,  -15,  -37,
     -32,  -26,  -50,      -13,  -37,  -64,        5,  -47,  -77,       25,  -58,  -91,
    -106,   14,    7,      -87,    4,   -6,      -68,   -6,  -19,      -49,  -17,  -33,
     -30,  -28,  -46,      -11,  -38,  -60,        8,  -49,  -73,       27,  -60,  -87,
    -104,   13,   11,      -84,    2,   -2,      -65,   -7,  -15,      -47,  -18,  -29,
     -27,  -29,  -42,       -9,  -40,  -56,       10,  -50,  -69,       30,  -61,  -83,
    -101,   12,   15,      -82,    1,    1,      -63,   -9,  -11,      -44,  -19,  -25,
     -25,  -30,  -38,       -6,  -41,  -52,       13,  -52,  -65,       32,  -62,  -79,
     -99,   10,   19,      -79,    0,    6,      -60,  -10,   -7,      -42,  -21,  -20,
     -22,  -32,  -34,       -3,  -42,  -47,       15,  -53,  -61,       35,  -64,  -75,
     -96,    9,   23,      -77,   -1,   10,      -58,  -12,   -3,      -39,  -22,  -16,
     -20,  -33,  -30,       -1,  -44,  -43,       18,  -54,  -57,       37,  -65,  -71,
     -94,    8,   27,      -74,   -2,   14,      -56,  -13,    0,      -37,  -24,  -12,
     -17,  -35,  -26,        1,  -45,  -39,       20,  -56,  -53,       40,  -67,  -67,
     -91,    6,   31,      -72,   -4,   18,      -53,  -14,    4,      -34,  -25,   -8,
     -15,  -36,  -22,        4,  -46,  -35,       23,  -57,  -49,       42,  -68,  -63,
     -89,    5,   35,      -70,   -5,   22,      -51,  -16,    8,      -32,  -26,   -4,
     -13,  -37,  -18,        6,  -48,  -31,       25,  -58,  -45,       44,  -69,  -59,
     -86,    3,   40,      -67,   -7,   26,      -48,  -17,   13,      -29,  -28,    0,
     -10,  -39,  -13,        9,  -49,  -27,       28,  -60,  -40,       47,  -71,  -54,
     -84,    2,   44,      -65,   -8,   30,      -46,  -19,   17,      -27,  -29,    3,
      -8,  -40,   -9,       11,  -51,  -23,       30,  -61,  -36,       49,  -72,  -50,
     -81,    1,   48,      -62,   -9,   34,      -43,  -20,   21,      -25,  -31,    7,
      -5,  -41,   -5,       14,  -52,  -19,       32,  -63,  -32,       52,  -74,  -46,
     -79,    0,   52,      -60,  -11,   38,      -41,  -21,   25,      -22,  -32,   11,
      -3,  -43,   -1,       16,  -53,  -15,       35,  -64,  -28,       54,  -75,  -42,
     -76,   -1,   56,      -57,  -12,   43,      -38,  -23,   29,      -19,  -33,   16,
       0,  -44,    2,       19,  -55,  -10,       37,  -66,  -24,       57,  -76,  -38,
     -74,   -3,   60,      -55,  -14,   47,      -36,  -24,   33,      -17,  -35,   20,
       2,  -46,    6,       21,  -56,   -6,       40,  -67,  -20,       59,  -78,  -34,
     -72,   -4,   64,      -52,  -15,   51,      -33,  -25,   37,      -15,  -36,   24,
       5,  -47,   10,       23,  -58,   -2,       42,  -68,  -16,       62,  -79,  -30,
     -69,   -5,   68,      -50,  -16,   55,      -31,  -27,   41,      -12,  -37,   28,
       7,  -48,   14,       26,  -59,    1,       45,  -70,  -12,       64,  -80,  -26,
     -67,   -7,   73,      -47,  -18,   59,      -28,  -28,   46,      -10,  -39,   32,
      10,  -50,   19,       29,  -60,    5,       47,  -71,   -7,       67,  -82,  -21,
     -64,   -8,   77,      -45,  -19,   63,      -26,  -30,   50,       -7,  -40,   36,
      12,  -51,   23,       31,  -62,    9,       50,  -72,   -3,       69,  -83,  -17,
     -62,  -10,   81,      -42,  -20,   67,      -24,  -31,   54,       -5,  -42,   40,
      15,  -53,   27,       33,  -63,   13,       52,  -74,    0,       71,  -85,  -13,
     -59,  -11,   85,      -40,  -22,   71,      -21,  -32,   58,       -2,  -43,   44,
      17,  -54,   31,       36,  -65,   17,       55,  -75,    4,       74,  -86,   -9,
     -57,  -12,   89,      -38,  -23,   75,      -19,  -34,   62,        0,  -44,   48,
      19,  -55,   35,       38,  -66,   21,       57,  -76,    8,       76,  -87,   -5,
     -54,  -14,   93,      -35,  -25,   80,      -16,  -35,   66,        3,  -46,   53,
      22,  -57,   39,       41,  -67,   26,       60,  -78,   12,       79,  -89,   -1,
     -52,  -15,   97,      -33,  -26,   84,      -14,  -37,   70,        5,  -47,   57,
      24,  -58,   43,       43,  -69,   30,       62,  -79,   16,       81,  -90,    2,
     -49,  -16,  101,      -30,  -27,   88,      -11,  -38,   74,        7,  -49,   61,
      27,  -59,   47,       46,  -70,   34,       64,  -81,   20,       84,  -92,    6,
     -47,  -18,  105,      -28,  -29,   92,       -9,  -39,   78,       10,  -50,   65,
      29,  -61,   51,       48,  -71,   38,       67,  -82,   24,       86,  -93,   10,
     -44,  -19,  110,      -25,  -30,   96,       -6,  -41,   83,       13,  -51,   69,
      32,  -62,   56,       51,  -73,   42,       69,  -84,   29,       89,  -95,   15,
     -42,  -21,  114,      -23,  -32,  100,       -4,  -42,   87,       15,  -53,   73,
      34,  -64,   60,       53,  -74,   46,       72,  -85,   33,       91,  -96,   19,
     -40,  -22,  118,      -20,  -33,  104,       -1,  -44,   91,       17,  -54,   77,
      37,  -65,   64,       55,  -76,   50,       74,  -86,   37,       94,  -97,   23,
    -115,   25,   -9,      -95,   14,  -23,      -77,    3,  -36,      -58,   -7,  -50,
     -39,  -18,  -64,      -20,  -28,  -77,       -1,  -39,  -90,       18,  -50, -104,
    -112,   23,   -5,      -93,   12,  -19,      -74,    2,  -32,      -56,   -8,  -46,
     -36,  -19,  -60,      -17,  -29,  -73,        1,  -40,  -86,       21,  -51, -100,
    -110,   22,   -1,      -91,   11,  -15,      -72,    0,  -28,      -53,   -9,  -42,
     -34,  -20,  -56,      -15,  -31,  -69,        4,  -41,  -82,       23,  -52,  -96,
    -107,   20,    2,      -88,    9,  -11,      -69,    0,  -24,      -50,  -11,  -37,
     -31,  -22,  -51,      -12,  -32,  -65,        7,  -43,  -78,       26,  -54,  -92,
    -105,   19,    6,      -86,    8,   -7,      -67,   -2,  -20,      -48,  -12,  -33,
     -29,  -23,  -47,      -10,  -34,  -61,        9,  -44,  -74,       28,  -55,  -88,
    -103,   18,   10,      -83,    7,   -3,      -64,   -3,  -16,      -46,  -14,  -29,
     -26,  -24,  -43,       -7,  -35,  -57,       11,  -46,  -70,       31,  -57,  -84,
    -100,   16,   14,      -81,    5,    0,      -62,   -4,  -12,      -43,  -15,  -25,
     -24,  -26,  -39,       -5,  -36,  -53,       14,  -47,  -66,       33,  -58,  -80,
     -98,   15,   19,      -78,    4,    5,      -59,   -6,   -7,      -41,  -16,  -21,
     -21,  -27,  -35,       -2,  -38,  -48,       16,  -49,  -61,       36,  -59,  -75,
     -95,   13,   23,      -76,    2,    9,      -57,   -7,   -3,      -38,  -18,  -17,
     -19,  -29,  -31,        0,  -39,  -44,       19,  -50,  -57,       38,  -61,  -71,
     -93,   12,   27,      -73,    1,   13,      -55,   -8,    0,      -36,  -19,  -13,
     -16,  -30,  -27,        2,  -41,  -40,       21,  -51,  -53,       41,  -62,  -67,
     -90,   11,   31,      -71,    0,   17,      -52,  -10,    4,      -33,  -20,   -9,
     -14,  -31,  -23,        5,  -42,  -36,       24,  -53,  -49,       43,  -64,  -63,
     -88,    9,   35,      -69,   -1,   21,      -50,  -11,    8,      -31,  -22,   -5,
     -12,  -33,  -19,        7,  -43,  -32,       26,  -54,  -45,       45,  -65,  -59,
     -85,    8,   39,      -66,   -2,   25,      -47,  -13,   12,      -28,  -23,    0,
      -9,  -34,  -14,       10,  -45,  -28,       29,  -55,  -41,       48,  -66,  -55,
     -83,    6,   43,      -63,   -3,   29,      -45,  -14,   16,      -26,  -25,    3,
      -7,  -36,  -10,       12,  -46,  -24,       31,  -57,  -37,       50,  -68,  -51,
     -80,    5,   47,      -61,   -5,   33,      -42,  -15,   20,      -24,  -26,    7,
      -4,  -37,   -6,       15,  -48,  -20,       33,  -58,  -33,       53,  -69,  -47,
     -78,    4,   51,      -59,   -6,   37,      -40,  -17,   24,      -21,  -27,   11,
      -2,  -38,   -2,       17,  -49,  -16,       36,  -59,  -29,       55,  -70,  -43,
     -75,    2,   56,      -56,   -8,   42,      -37,  -18,   29,      -18,  -29,   15,
       1,  -40,    1,       20,  -50,  -11,       39,  -61,  -24,       58,  -72,  -38,
     -73,    1,   60,      -54,   -9,   46,      -35,  -20,   33,      -16,  -30,   19,
       3,  -41,    5,       22,  -52,   -7,       41,  -62,  -20,       60,  -73,  -34,
     -71,    0,   64,      -51,  -10,   50,      -32,  -21,   37,      -14,  -32,   23,
       6,  -43,    9,       25,  -53,   -3,       43,  -64,  -16,       63,  -75,  -30,
     -68,   -1,   68,      -49,  -12,   54,      -30,  -22,   41,      -11,  -33,   27,
       8,  -44,   13,       27,  -54,    0,       46,  -65,  -12,       65,  -76,  -26,
     -66,   -2,   72,      -46,  -13,   58,      -27,  -24,   45,       -9,  -34,   32,
      11,  -45,   18,       30,  -56,    4,       48,  -67,   -8,       68,  -78,  -22,
     -63,   -4,   76,      -44,  -15,   62,      -25,  -25,   49,       -6,  -36,   36,
      13,  -47,   22,       32,  -57,    8,       51,  -68,   -4,       70,  -79,  -18,
     -61,   -5,   80,      -41,  -16,   66,      -23,  -27,   53,       -4,  -37,   40,
      16,  -48,   26,       34,  -59,   12,       53,  -69,    0,       73,  -80,  -14,
     -58,   -6,   84,      -39,  -17,   70,      -20,  -28,   57,       -1,  -38,   44,
      18,  -49,   30,       37,  -60,   16,       56,  -71,    3,       75,  -82,  -10,
     -56,   -8,   88,      -37,  -19,   74,      -18,  -29,   61,        1,  -40,   48,
      20,  -51,   34,       39,  -61,   20,       58,  -72,    7,       77,  -83,   -6,
     -53,   -9,   93,      -34,  -20,   79,      -15,  -31,   66,        4,  -41,   52,
      23,  -52,   38,       42,  -63,   25,       61,  -74,   12,       80,  -84,   -1,
     -51,  -11,   97,      -31,  -22,   83,      -13,  -32,   70,        6,  -43,   56,
      25,  -54,   42,       44,  -64,   29,       63,  -75,   16,       82,  -86,    2,
     -48,  -12,  101,      -29,  -23,   87,      -10,  -33,   74,        8,  -44,   60,
      28,  -55,   46,       47,  -66,   33,       65,  -76,   20,       85,  -87,    6,
     -46,  -13,  105,      -27,  -24,   91,       -8,  -35,   78,       11,  -45,   64,
      30,  -56,   50,       49,  -67,   37,       68,  -78,   24,       87,  -88,   10,
     -43,  -15,  109,      -24,  -26,   95,       -5,  -36,   82,       14,  -47,   69,
      33,  -58,   55,       52,  -68,   41,       70,  -79,   28,       90,  -90,   14,
     -41,  -16,  113,      -22,  -27,   99,       -3,  -38,   86,       16,  -48,   73,
      35,  -59,   59,       54,  -70,   45,       73,  -80,   32,       92,  -91,   18,
     -39,  -18,  117,      -19,  -28,  103,        0,  -39,   90,       18,  -50,   77,
      38,  -61,   63,       56,  -71,   49,       75,  -82,   36,       95,  -93,   22,
    -114,   29,  -10,      -95,   18,  -24,      -76,    7,  -37,      -57,   -3,  -51,
     -38,  -14,  -64,      -19,  -24,  -78,        0,  -35,  -91,       19,  -46, -105,
    -112,   27,   -6,      -92,   16,  -20,      -73,    6,  -33,      -55,   -4,  -47,
     -35,  -15,  -60,      -16,  -25,  -74,        2,  -36,  -87,       22,  -47, -101,
    -109,   26,   -2,      -90,   15,  -16,      -71,    4,  -29,      -52,   -5,  -43,
     -33,  -16,  -56,      -14,  -27,  -70,        5,  -37,  -83,       24,  -48,  -97,
    -106,   24,    2,      -87,   13,  -11,      -68,    3,  -25,      -50,   -7,  -38,
     -30,  -18,  -52,      -11,  -28,  -65,        7,  -39,  -79,       27,  -50,  -92,
    -104,   23,    6,      -85,   12,   -7,      -66,    1,  -21,      -47,   -8,  -34,
     -28,  -19,  -48,       -9,  -30,  -61,       10,  -40,  -75,       29,  -51,  -88,
    -102,   22,   10,      -82,   11,   -3,      -64,    0,  -17,      -45,  -10,  -30,
     -25,  -20,  -44,       -7,  -31,  -57,       12,  -42,  -71,       32,  -53,  -84,
     -99,   20,   14,      -80,    9,    0,      -61,    0,  -13,      -42,  -11,  -26,
     -23,  -22,  -40,       -4,  -32,  -53,       15,  -43,  -67,       34,  -54,  -80,
     -97,   19,   18,      -77,    8,    4,      -58,   -2,   -8,      -40,  -12,  -22,
     -20,  -23,  -35,       -1,  -34,  -49,       17,  -45,  -62,       37,  -55,  -76,
     -94,   17,   22,      -75,    6,    8,      -56,   -3,   -4,      -37,  -14,  -18,
     -18,  -25,  -31,        1,  -35,  -45,       20,  -46,  -58,       39,  -57,  -72,
     -92,   16,   26,      -72,    5,   12,      -54,   -4,    0,      -35,  -15,  -14,
     -15,  -26,  -27,        3,  -37,  -41,       22,  -47,  -54,       41,  -58,  -68,
     -89,   15,   30,      -70,    4,   16,      -51,   -6,    3,      -32,  -16,  -10,
     -13,  -27,  -23,        6,  -38,  -37,       24,  -49,  -50,       44,  -60,  -64,
     -87,   13,   34,      -68,    2,   20,      -49,   -7,    7,      -30,  -18,   -6,
     -11,  -29,  -19,        8,  -39,  -33,       27,  -50,  -46,       46,  -61,  -60,
     -84,   12,   39,      -65,    1,   25,      -46,   -9,   11,      -27,  -19,   -1,
      -8,  -30,  -15,       11,  -41,  -28,       30,  -51,  -42,       49,  -62,  -55,
     -82,   10,   43,      -63,    0,   29,      -44,  -10,   15,      -25,  -21,    2,
      -6,  -32,  -11,       13,  -42,  -24,       32,  -53,  -38,       51,  -64,  -51,
     -80,    9,   47,      -60,   -1,   33,      -41,  -11,   19,      -23,  -22,    6,
      -3,  -33,   -7,       16,  -44,  -20,       34,  -54,  -34,       54,  -65,  -47,
     -77,    8,   51,      -58,   -2,   37,      -39,  -13,   23,      -20,  -23,   10,
      -1,  -34,   -3,       18,  -45,  -16,       37,  -55,  -30,       56,  -66,  -43,
     -74,    6,   55,      -55,   -4,   41,      -36,  -14,   28,      -18,  -25,   14,
       2,  -36,    1,       21,  -46,  -12,       39,  -57,  -25,       59,  -68,  -39,
     -72,    5,   59,      -53,   -5,   45,      -34,  -16,   32,      -15,  -26,   18,
       4,  -37,    5,       23,  -48,   -8,       42,  -58,  -21,       61,  -69,  -35,
     -70,    4,   63,      -50,   -6,   49,      -32,  -17,   36,      -13,  -28,   22,
       7,  -39,    9,       25,  -49,   -4,       44,  -60,  -17,       64,  -71,  -31,
     -67,    2,   67,      -48,   -8,   53,      -29,  -18,   40,      -10,  -29,   26,
       9,  -40,   13,       28,  -50,    0,       47,  -61,  -13,       66,  -72,  -27,
     -65,    1,   72,      -45,   -9,   58,      -26,  -20,   44,       -8,  -30,   31,
      12,  -41,   17,       30,  -52,    4,       49,  -63,   -9,       69,  -74,  -22,
     -62,    0,   76,      -43,  -11,   62,      -24,  -21,   48,       -5,  -32,   35,
      14,  -43,   21,       33,  -53,    8,       52,  -64,   -5,       71,  -75,  -18,
     -60,   -1,   80,      -40,  -12,   66,      -22,  -23,   52,       -3,  -33,   39,
      16,  -44,   25,       35,  -55,   12,       54,  -65,   -1,       73,  -76,  -14,
     -57,   -2,   84,      -38,  -13,   70,      -19,  -24,   56,        0,  -34,   43,
      19,  -45,   29,       38,  -56,   16,       56,  -67,    2,       76,  -78,  -10,
     -55,   -4,   88,      -36,  -15,   74,      -17,  -25,   60,        2,  -36,   47,
      21,  -47,   33,       40,  -57,   20,       59,  -68,    6,       78,  -79,   -6,
     -52,   -5,   92,      -33,  -16,   78,      -14,  -27,   65,        5,  -37,   51,
      24,  -48,   38,       43,  -59,   24,       62,  -70,   11,       81,  -80,   -2,
     -50,   -7,   96,      -31,  -18,   82,      -12,  -28,   69,        7,  -39,   55,
      26,  -50,   42,       45,  -60,   28,       64,  -71,   15,       83,  -82,    1,
     -48,   -8,  100,      -28,  -19,   86,       -9,  -29,   73,        9,  -40,   59,
      29,  -51,   46,       48,  -62,   32,       66,  -72,   19,       86,  -83,    5,
     -45,   -9,  104,      -26,  -20,   90,       -7,  -31,   77,       12,  -41,   63,
      31,  -52,   50,       50,  -63,   36,       69,  -74,   23,       88,  -84,    9,
     -42,  -11,  109,      -23,  -22,   95,       -4,  -32,   81,       14,  -43,   68,
      34,  -54,   54,       53,  -64,   41,       71,  -75,   27,       91,  -86,   14,
     -40,  -12,  113,      -21,  -23,   99,       -2,  -34,   85,       17,  -44,   72,
      36,  -55,   58,       55,  -66,   45,       74,  -76,   31,       93,  -87,   18,
     -38,  -14,  117,      -18,  -24,  103,        0,  -35,   89,       19,  -46,   76,
      39,  -57,   62,       57,  -67,   49,       76,  -78,   35,       96,  -89,   22,
    -113,   33,  -11,      -94,   22,  -24,      -75,   11,  -38,      -56,    0,  -51,
     -37,  -10,  -65,      -18,  -20,  -78,        1,  -31,  -92,       20,  -42, -106,
    -111,   31,   -7,      -91,   20,  -20,      -72,   10,  -34,      -54,    0,  -47,
     -34,  -11,  -61,      -16,  -21,  -74,        3,  -32,  -88,       23,  -43, -102,
    -108,   30,   -3,      -89,   19,  -16,      -70,    8,  -30,      -51,   -1,  -43,
     -32,  -12,  -57,      -13,  -23,  -70,        6,  -33,  -84,       25,  -44,  -98,
    -106,   28,    1,      -86,   17,  -12,      -67,    7,  -25,      -49,   -3,  -39,
     -29,  -14,  -52,      -10,  -24,  -66,        8,  -35,  -79,       28,  -46,  -93,
    -103,   27,    5,      -84,   16,   -8,      -65,    5,  -21,      -46,   -4,  -35,
     -27,  -15,  -48,       -8,  -26,  -62,       11,  -36,  -75,       30,  -47,  -89,
    -101,   26,    9,      -81,   15,   -4,      -63,    4,  -17,      -44,   -6,  -31,
     -24,  -16,  -44,       -6,  -27,  -58,       13,  -38,  -71,       32,  -49,  -85,
     -98,   24,   13,      -79,   13,    0,      -60,    3,  -13,      -41,   -7,  -27,
     -22,  -18,  -40,       -3,  -28,  -54,       16,  -39,  -67,       35,  -50,  -81,
     -96,   23,   17,      -76,   12,    4,      -58,    1,   -9,      -39,   -8,  -22,
     -19,  -19,  -36,       -1,  -30,  -49,       18,  -41,  -63,       38,  -51,  -77,
     -93,   21,   21,      -74,   10,    8,      -55,    0,   -5,      -36,  -10,  -18,
     -17,  -21,  -32,        2,  -31,  -45,       21,  -42,  -59,       40,  -53,  -73,
     -91,   20,   25,      -72,    9,   12,      -53,    0,   -1,      -34,  -11,  -14,
     -15,  -22,  -28,        4,  -33,  -41,       23,  -43,  -55,       42,  -54,  -69,
     -89,   19,   29,      -69,    8,   16,      -50,   -2,    2,      -32,  -12,  -10,
     -12,  -23,  -24,        7,  -34,  -37,       25,  -45,  -51,       45,  -56,  -65,
     -86,   17,   33,      -67,    6,   20,      -48,   -3,    6,      -29,  -14,   -6,
     -10,  -25,  -20,        9,  -35,  -33,       28,  -46,  -47,       47,  -57,  -61,
     -83,   16,   38,      -64,    5,   24,      -45,   -5,   11,      -26,  -15,   -2,
      -7,  -26,  -15,       12,  -37,  -29,       30,  -47,  -42,       50,  -58,  -56,
     -81,   14,   42,      -62,    4,   28,      -43,   -6,   15,      -24,  -17,    1,
      -5,  -28,  -11,       14,  -38,  -25,       33,  -49,  -38,       52,  -60,  -52,
     -79,   13,   46,      -59,    2,   32,      -40,   -7,   19,      -22,  -18,    5,
      -2,  -29,   -7,       16,  -40,  -21,       35,  -50,  -34,       55,  -61,  -48,
     -76,   12,   50,      -57,    1,   36,      -38,   -9,   23,      -19,  -19,    9,
       0,  -30,   -3,       19,  -41,  -17,       38,  -51,  -30,       57,  -62,  -44,
     -74,   10,   54,      -54,    0,   41,      -35,  -10,   27,      -17,  -21,   14,
       3,  -32,    0,       22,  -42,  -12,       40,  -53,  -26,       60,  -64,  -40,
     -71,    9,   58,      -52,   -1,   45,      -33,  -12,   31,      -14,  -22,   18,
       5,  -33,    4,       24,  -44,   -8,       43,  -54,  -22,       62,  -65,  -36,
     -69,    8,   62,      -49,   -2,   49,      -31,  -13,   35,      -12,  -24,   22,
       8,  -35,    8,       26,  -45,   -4,       45,  -56,  -18,       64,  -67,  -32,
     -66,    6,   66,      -47,   -4,   53,      -28,  -14,   39,       -9,  -25,   26,
      10,  -36,   12,       29,  -46,    0,       48,  -57,  -14,       67,  -68,  -28,
     -64,    5,   71,      -44,   -5,   57,      -26,  -16,   44,       -7,  -26,   30,
      13,  -37,   17,       31,  -48,    3,       50,  -59,   -9,       70,  -70,  -23,
     -61,    3,   75,      -42,   -7,   61,      -23,  -17,   48,       -4,  -28,   34,
      15,  -39,   21,       34,  -49,    7,       53,  -60,   -5,       72,  -71,  -19,
     -59,    2,   79,      -40,   -8,   65,      -21,  -19,   52,       -2,  -29,   38,
      17,  -40,   25,       36,  -51,   11,       55,  -61,   -1,       74,  -72,  -15,
     -57,    1,   83,      -37,   -9,   69,      -18,  -20,   56,        0,  -30,   42,
      20,  -41,   29,       39,  -52,   15,       57,  -63,    2,       77,  -74,  -11,
     -54,    0,   87,      -35,  -11,   73,      -16,  -21,   60,        3,  -32,   46,
      22,  -43,   33,       41,  -53,   19,       60,  -64,    6,       79,  -75,   -7,
     -51,   -1,   91,      -32,  -12,   78,      -13,  -23,   64,        6,  -33,   51,
      25,  -44,   37,       44,  -55,   24,       62,  -66,   10,       82,  -76,   -3,
     -49,   -3,   95,      -30,  -14,   82,      -11,  -24,   68,        8,  -35,   55,
      27,  -46,   41,       46,  -56,   28,       65,  -67,   14,       84,  -78,    0,
     -47,   -4,   99,      -27,  -15,   86,       -8,  -25,   72,       10,  -36,   59,
      30,  -47,   45,       48,  -58,   32,       67,  -68,   18,       87,  -79,    4,
     -44,   -5,  103,      -25,  -16,   90,       -6,  -27,   76,       13,  -37,   63,
      32,  -48,   49,       51,  -59,   36,       70,  -70,   22,       89,  -80,    8,
     -42,   -7,  108,      -22,  -18,   94,       -3,  -28,   81,       15,  -39,   67,
      35,  -50,   54,       54,  -60,   40,       72,  -71,   27,       92,  -82,   13,
     -39,   -8,  112,      -20,  -19,   98,       -1,  -30,   85,       18,  -40,   71,
      37,  -51,   58,       56,  -62,   44,       75,  -72,   31,       94,  -83,   17,
     -37,  -10,  116,      -17,  -20,  102,        1,  -31,   89,       20,  -42,   75,
      40,  -53,   62,       58,  -63,   48,       77,  -74,   35,       96,  -85,   21,
    -112,   37,  -11,      -93,   26,  -25,      -74,   15,  -38,      -55,    4,  -52,
     -36,   -6,  -66,      -17,  -16,  -79,        2,  -27,  -92,       21,  -38, -106,
    -110,   35,   -7,      -90,   24,  -21,      -72,   14,  -34,      -53,    3,  -48,
     -33,   -7,  -62,      -15,  -17,  -75,        4,  -28,  -88,       24,  -39, -102,
    -107,   34,   -3,      -88,   23,  -17,      -69,   12,  -30,      -50,    2,  -44,
     -31,   -8,  -58,      -12,  -19,  -71,        7,  -29,  -84,       26,  -40,  -98,
    -105,   32,    0,      -85,   21,  -13,      -66,   11,  -26,      -48,    0,  -39,
     -28,  -10,  -53,      -10,  -20,  -67,        9,  -31,  -80,       29,  -42,  -94,
    -102,   31,    4,      -83,   20,   -9,      -64,    9,  -22,      -45,    0,  -35,
     -26,  -11,  -49,       -7,  -22,  -63,       12,  -32,  -76,       31,  -43,  -90,
    -100,   30,    8,      -80,   19,   -5,      -62,    8,  -18,      -43,   -2,  -31,
     -24,  -12,  -45,       -5,  -23,  -59,       14,  -34,  -72,       33,  -45,  -86,
     -97,   28,   12,      -78,   17,   -1,      -59,    7,  -14,      -41,   -3,  -27,
     -21,  -14,  -41,       -2,  -24,  -55,       16,  -35,  -68,       36,  -46,  -82,
     -95,   27,   17,      -75,   16,    3,      -57,    5,   -9,      -38,   -4,  -23,
     -18,  -15,  -37,        0,  -26,  -50,       19,  -37,  -63,       38,  -47,  -77,
     -92,   25,   21,      -73,   14,    7,      -54,    4,   -5,      -35,   -6,  -19,
     -16,  -17,  -33,        3,  -27,  -46,       22,  -38,  -59,       41,  -49,  -73,
     -90,   24,   25,      -71,   13,   11,      -52,    3,   -1,      -33,   -7,  -15,
     -14,  -18,  -29,        5,  -29,  -42,       24,  -39,  -55,       43,  -50,  -69,
     -88,   23,   29,      -68,   12,   15,      -49,    1,    2,      -31,   -8,  -11,
     -11,  -19,  -25,        8,  -30,  -38,       26,  -41,  -51,       46,  -52,  -65,
     -85,   21,   33,      -66,   10,   19,      -47,    0,    6,      -28,  -10,   -7,
      -9,  -21,  -21,       10,  -31,  -34,       29,  -42,  -47,       48,  -53,  -61,
     -83,   20,   37,      -63,    9,   23,      -44,   -1,   10,      -26,  -11,   -2,
      -6,  -22,  -16,       13,  -33,  -30,       31,  -43,  -43,       51,  -54,  -57,
     -80,   18,   41,      -61,    8,   27,      -42,   -2,   14,      -23,  -13,    1,
      -4,  -24,  -12,       15,  -34,  -26,       34,  -45,  -39,       53,  -56,  -53,
     -78,   17,   45,      -58,    6,   31,      -40,   -3,   18,      -21,  -14,    5,
      -1,  -25,   -8,       17,  -36,  -22,       36,  -46,  -35,       56,  -57,  -49,
     -75,   16,   49,      -56,    5,   35,      -37,   -5,   22,      -18,  -15,    9,
       1,  -26,   -4,       20,  -37,  -18,       39,  -47,  -31,       58,  -58,  -45,
     -73,   14,   54,      -53,    3,   40,      -34,   -6,   27,      -16,  -17,   13,
       4,  -28,    0,       22,  -38,  -13,       41,  -49,  -26,       61,  -60,  -40,
     -70,   13,   58,      -51,    2,   44,      -32,   -8,   31,      -13,  -18,   17,
       6,  -29,    3,       25,  -40,   -9,       44,  -50,  -22,       63,  -61,  -36,
     -68,   12,   62,      -48,    1,   48,      -30,   -9,   35,      -11,  -20,   21,
       8,  -31,    7,       27,  -41,   -5,       46,  -52,  -18,       65,  -63,  -32,
     -65,   10,   66,      -46,    0,   52,      -27,  -10,   39,       -9,  -21,   25,
      11,  -32,   11,       30,  -42,   -1,       48,  -53,  -14,       68,  -64,  -28,
     -63,    9,   70,      -43,   -1,   56,      -25,  -12,   43,       -6,  -22,   30,
      14,  -33,   16,       32,  -44,    2,       51,  -55,  -10,       70,  -66,  -24,
     -60,    7,   74,      -41,   -3,   60,      -22,  -13,   47,       -3,  -24,   34,
      16,  -35,   20,       35,  -45,    6,       53,  -56,   -6,       73,  -67,  -20,
     -58,    6,   78,      -39,   -4,   64,      -20,  -15,   51,       -1,  -25,   38,
      18,  -36,   24,       37,  -47,   10,       56,  -57,   -2,       75,  -68,  -16,
     -56,    5,   82,      -36,   -5,   68,      -17,  -16,   55,        1,  -26,   42,
      21,  -37,   28,       39,  -48,   14,       58,  -59,    1,       78,  -70,  -12,
     -53,    3,   86,      -34,   -7,   72,      -15,  -17,   59,        4,  -28,   46,
      23,  -39,   32,       42,  -49,   18,       61,  -60,    5,       80,  -71,   -8,
     -51,    2,   91,      -31,   -8,   77,      -12,  -19,   64,        6,  -29,   50,
      26,  -40,   36,       45,  -51,   23,       63,  -62,   10,       83,  -72,   -3,
     -48,    0,   95,      -29,  -10,   81,      -10,  -20,   68,        9,  -31,   54,
      28,  -42,   40,       47,  -52,   27,       66,  -63,   14,       85,  -74,    0,
     -46,    0,   99,      -26,  -11,   85,       -8,  -21,   72,       11,  -32,   58,
      31,  -43,   44,       49,  -54,   31,       68,  -64,   18,       88,  -75,    4,
     -43,   -1,  103,      -24,  -12,   89,       -5,  -23,   76,       14,  -33,   62,
      33,  -44,   48,       52,  -55,   35,       71,  -66,   22,       90,  -76,    8,
     -41,   -3,  107,      -21,  -14,   93,       -2,  -24,   80,       16,  -35,   67,
      36,  -46,   53,       54,  -56,   39,       73,  -67,   26,       93,  -78,   12,
     -38,   -4,  111,      -19,  -15,   97,        0,  -26,   84,       19,  -36,   71,
      38,  -47,   57,       57,  -58,   43,       76,  -68,   30,       95,  -79,   16,
     -36,   -6,  115,      -16,  -16,  101,        2,  -27,   88,       21,  -38,   75,
      40,  -49,   61,       59,  -59,   47,       78,  -70,   34,       97,  -81,   20,
    -111,   41,  -12,      -92,   30,  -26,      -73,   19,  -39,      -54,    8,  -52,
     -35,   -2,  -66,      -16,  -12,  -80,        3,  -23,  -93,       22,  -34, -107,
    -109,   39,   -8,      -89,   28,  -22,      -71,   18,  -35,      -52,    7,  -48,
     -32,   -3,  -62,      -14,  -13,  -76,        5,  -24,  -89,       24,  -35, -103,
    -106,   38,   -4,      -87,   27,  -18,      -68,   16,  -31,      -49,    6,  -44,
     -30,   -4,  -58,      -11,  -15,  -72,        7,  -25,  -85,       27,  -36,  -99,
    -104,   36,    0,      -84,   25,  -13,      -66,   15,  -27,      -47,    4,  -40,
     -27,   -6,  -54,       -9,  -16,  -67,       10,  -27,  -81,       30,  -38,  -94,
    -101,   35,    4,      -82,   24,   -9,      -63,   13,  -23,      -44,    3,  -36,
     -25,   -7,  -50,       -6,  -18,  -63,       13,  -28,  -77,       32,  -39,  -90,
     -99,   34,    8,      -80,   23,   -5,      -61,   12,  -19,      -42,    1,  -32,
     -23,   -8,  -46,       -4,  -19,  -59,       15,  -30,  -73,       34,  -41,  -86,
     -97,   32,   12,      -77,   21,   -1,      -58,   11,  -15,      -40,    0,  -28,
     -20,  -10,  -42,       -1,  -20,  -55,       17,  -31,  -69,       37,  -42,  -82,
     -94,   31,   16,      -74,   20,    2,      -56,    9,  -10,      -37,    0,  -23,
     -18,  -11,  -37,        1,  -22,  -51,       20,  -33,  -64,       39,  -43,  -78,
     -91,   29,   20,      -72,   18,    6,      -53,    8,   -6,      -35,   -2,  -19,
     -15,  -13,  -33,        4,  -23,  -47,       22,  -34,  -60,       42,  -45,  -74,
     -89,   28,   24,      -70,   17,   10,      -51,    7,   -2,      -32,   -3,  -15,
     -13,  -14,  -29,        6,  -25,  -43,       25,  -35,  -56,       44,  -46,  -70,
     -87,   27,   28,      -67,   16,   14,      -49,    5,    1,      -30,   -4,  -11,
     -10,  -15,  -25,        8,  -26,  -39,       27,  -37,  -52,       47,  -48,  -66,
     -84,   25,   32,      -65,   14,   18,      -46,    4,    5,      -27,   -6,   -7,
      -8,  -17,  -21,       11,  -27,  -35,       30,  -38,  -48,       49,  -49,  -62,
     -82,   24,   37,      -62,   13,   23,      -43,    2,    9,      -25,   -7,   -3,
      -5,  -18,  -17,       13,  -29,  -30,       32,  -39,  -44,       52,  -50,  -57,
     -79,   22,   41,      -60,   12,   27,      -41,    1,   13,      -22,   -9,    0,
      -3,  -20,  -13,       16,  -30,  -26,       35,  -41,  -40,       54,  -52,  -53,
     -77,   21,   45,      -57,   10,   31,      -39,    0,   17,      -20,  -10,    4,
      -1,  -21,   -9,       18,  -32,  -22,       37,  -42,  -36,       56,  -53,  -49,
     -74,   20,   49,      -55,    9,   35,      -36,   -1,   21,      -17,  -11,    8,
       2,  -22,   -5,       21,  -33,  -18,       39,  -43,  -32,       59,  -54,  -45,
     -72,   18,   53,      -52,    7,   39,      -34,   -2,   26,      -15,  -13,   13,
       5,  -24,    0,       23,  -34,  -14,       42,  -45,  -27,       62,  -56,  -41,
     -69,   17,   57,      -50,    6,   43,      -31,   -4,   30,      -12,  -14,   17,
       7,  -25,    3,       26,  -36,  -10,       45,  -46,  -23,       64,  -57,  -37,
     -67,   16,   61,      -48,    5,   47,      -29,   -5,   34,      -10,  -16,   21,
       9,  -27,    7,       28,  -37,   -6,       47,  -48,  -19,       66,  -59,  -33,
     -65,   14,   65,      -45,    3,   51,      -26,   -6,   38,       -8,  -17,   25,
      12,  -28,   11,       31,  -38,   -2,       49,  -49,  -15,       69,  -60,  -29,
     -62,   13,   70,      -42,    2,   56,      -24,   -8,   42,       -5,  -18,   29,
      14,  -29,   15,       33,  -40,    2,       52,  -51,  -11,       71,  -62,  -24,
     -59,   11,   74,      -40,    0,   60,      -21,   -9,   46,       -3,  -20,   33,
      17,  -31,   19,       36,  -41,    6,       54,  -52,   -7,       74,  -63,  -20,
     -57,   10,   78,      -38,    0,   64,      -19,  -11,   50,        0,  -21,   37,
      19,  -32,   23,       38,  -43,   10,       57,  -53,   -3,       76,  -64,  -16,
     -55,    9,   82,      -35,   -1,   68,      -17,  -12,   54,        2,  -22,   41,
      22,  -33,   27,       40,  -44,   14,       59,  -55,    0,       79,  -66,  -12,
     -52,    7,   86,      -33,   -3,   72,      -14,  -13,   58,        5,  -24,   45,
      24,  -35,   31,       43,  -45,   18,       62,  -56,    4,       81,  -67,   -8,
     -50,    6,   90,      -30,   -4,   76,      -11,  -15,   63,        7,  -25,   50,
      27,  -36,   36,       45,  -47,   22,       64,  -58,    9,       84,  -68,   -4,
     -47,    4,   94,      -28,   -6,   80,       -9,  -16,   67,       10,  -27,   54,
      29,  -38,   40,       48,  -48,   26,       67,  -59,   13,       86,  -70,    0,
     -45,    3,   98,      -25,   -7,   84,       -7,  -17,   71,       12,  -28,   58,
      31,  -39,   44,       50,  -50,   30,       69,  -60,   17,       88,  -71,    3,
     -42,    2,  102,      -23,   -8,   88,       -4,  -19,   75,       15,  -29,   62,
      34,  -40,   48,       53,  -51,   34,       71,  -62,   21,       91,  -72,    7,
     -40,    0,  107,      -20,  -10,   93,       -2,  -20,   79,       17,  -31,   66,
      37,  -42,   52,       55,  -52,   39,       74,  -63,   25,       94,  -74,   12,
     -37,    0,  111,      -18,  -11,   97,        1,  -22,   83,       20,  -32,   70,
      39,  -43,   56,       58,  -54,   43,       77,  -64,   29,       96,  -75,   16,
     -35,   -2,  115,      -16,  -12,  101,        3,  -23,   87,       22,  -34,   74,
      41,  -45,   60,       60,  -55,   47,       79,  -66,   33,       98,  -77,   20,
    -110,   45,  -13,      -91,   34,  -26,      -72,   23,  -40,      -53,   13,  -53,
     -34,    2,  -67,      -15,   -8,  -80,        4,  -18,  -94,       23,  -29, -108,
    -108,   44,   -9,      -88,   33,  -22,      -70,   22,  -36,      -51,   12,  -49,
     -31,    1,  -63,      -13,   -9,  -76,        6,  -20,  -90,       25,  -31, -104,
    -105,   42,   -5,      -86,   31,  -18,      -67,   21,  -32,      -48,   10,  -45,
     -29,    0,  -59,      -10,  -10,  -72,        8,  -21,  -86,       28,  -32, -100,
    -103,   41,    0,      -83,   30,  -14,      -65,   19,  -27,      -46,    9,  -41,
     -26,   -1,  -55,       -8,  -12,  -68,       11,  -22,  -81,       31,  -33,  -95,
    -100,   39,    3,      -81,   29,  -10,      -62,   18,  -23,      -43,    7,  -37,
     -24,   -3,  -51,       -5,  -13,  -64,       14,  -24,  -77,       33,  -35,  -91,
     -98,   38,    7,      -79,   27,   -6,      -60,   17,  -19,      -41,    6,  -33,
     -22,   -4,  -47,       -3,  -15,  -60,       16,  -25,  -73,       35,  -36,  -87,
     -96,   37,   11,      -76,   26,   -2,      -57,   15,  -15,      -39,    5,  -29,
     -19,   -5,  -43,        0,  -16,  -56,       18,  -27,  -69,       38,  -37,  -83,
     -93,   35,   15,      -73,   24,    2,      -55,   14,  -11,      -36,    3,  -24,
     -17,   -7,  -38,        2,  -17,  -51,       21,  -28,  -65,       40,  -39,  -79,
     -90,   34,   19,      -71,   23,    6,      -52,   12,   -7,      -33,    2,  -20,
     -14,   -8,  -34,        5,  -19,  -47,       23,  -29,  -61,       43,  -40,  -75,
     -88,   33,   23,      -69,   22,   10,      -50,   11,   -3,      -31,    0,  -16,
     -12,  -10,  -30,        7,  -20,  -43,       26,  -31,  -57,       45,  -42,  -71,
     -86,   31,   27,      -66,   20,   14,      -47,   10,    0,      -29,    0,  -12,
      -9,  -11,  -26,        9,  -21,  -39,       28,  -32,  -53,       48,  -43,  -67,
     -83,   30,   31,      -64,   19,   18,      -45,    8,    4,      -26,   -1,   -8,
      -7,  -12,  -22,       12,  -23,  -35,       31,  -33,  -49,       50,  -44,  -63,
     -81,   28,   36,      -61,   17,   22,      -42,    7,    9,      -24,   -3,   -4,
      -4,  -14,  -18,       15,  -24,  -31,       33,  -35,  -44,       53,  -46,  -58,
     -78,   27,   40,      -59,   16,   26,      -40,    5,   13,      -21,   -4,    0,
      -2,  -15,  -14,       17,  -26,  -27,       36,  -36,  -40,       55,  -47,  -54,
     -76,   26,   44,      -56,   15,   30,      -38,    4,   17,      -19,   -6,    3,
       1,  -16,  -10,       19,  -27,  -23,       38,  -38,  -36,       57,  -49,  -50,
     -73,   24,   48,      -54,   13,   34,      -35,    3,   21,      -16,   -7,    7,
       3,  -18,   -6,       22,  -28,  -19,       40,  -39,  -32,       60,  -50,  -46,
     -71,   23,   52,      -51,   12,   39,      -33,    1,   25,      -14,   -8,   12,
       6,  -19,   -1,       24,  -30,  -14,       43,  -41,  -28,       63,  -51,  -42,
     -68,   21,   56,      -49,   10,   43,      -30,    0,   29,      -11,  -10,   16,
       8,  -21,    2,       27,  -31,  -10,       46,  -42,  -24,       65,  -53,  -38,
     -66,   20,   60,      -47,    9,   47,      -28,    0,   33,       -9,  -11,   20,
      10,  -22,    6,       29,  -33,   -6,       48,  -43,  -20,       67,  -54,  -34,
     -64,   19,   64,      -44,    8,   51,      -25,   -2,   37,       -7,  -12,   24,
      13,  -23,   10,       32,  -34,   -2,       50,  -45,  -16,       70,  -55,  -30,
     -61,   17,   69,      -41,    6,   55,      -23,   -3,   42,       -4,  -14,   28,
      15,  -25,   14,       34,  -35,    1,       53,  -46,  -11,       72,  -57,  -25,
     -58,   16,   73,      -39,    5,   59,      -20,   -5,   46,       -2,  -15,   32,
      18,  -26,   18,       37,  -37,    5,       55,  -47,   -7,       75,  -58,  -21,
     -56,   14,   77,      -37,    4,   63,      -18,   -6,   50,        1,  -17,   36,
      20,  -28,   22,       39,  -38,    9,       58,  -49,   -3,       77,  -60,  -17,
     -54,   13,   81,      -34,    2,   67,      -16,   -7,   54,        3,  -18,   40,
      23,  -29,   26,       41,  -40,   13,       60,  -50,    0,       80,  -61,  -13,
     -51,   12,   85,      -32,    1,   71,      -13,   -9,   58,        6,  -19,   44,
      25,  -30,   30,       44,  -41,   17,       63,  -51,    4,       82,  -62,   -9,
     -49,   10,   89,      -29,    0,   76,      -10,  -10,   62,        8,  -21,   49,
      28,  -32,   35,       47,  -42,   22,       65,  -53,    8,       85,  -64,   -5,
     -46,    9,   93,      -27,   -1,   80,       -8,  -12,   66,       11,  -22,   53,
      30,  -33,   39,       49,  -44,   26,       68,  -54,   12,       87,  -65,   -1,
     -44,    8,   97,      -24,   -2,   84,       -6,  -13,   70,       13,  -24,   57,
      33,  -34,   43,       51,  -45,   30,       70,  -56,   16,       89,  -67,    2,
     -41,    6,  101,      -22,   -4,   88,       -3,  -14,   74,       16,  -25,   61,
      35,  -36,   47,       54,  -46,   34,       72,  -57,   20,       92,  -68,    6,
     -39,    5,  106,      -19,   -5,   92,       -1,  -16,   79,       18,  -26,   65,
      38,  -37,   51,       56,  -48,   38,       75,  -59,   25,       95,  -70,   11,
     -36,    3,  110,      -17,   -7,   96,        2,  -17,   83,       21,  -28,   69,
      40,  -39,   55,       59,  -49,   42,       78,  -60,   29,       97,  -71,   15,
     -34,    2,  114,      -15,   -8,  100,        4,  -19,   87,       23,  -29,   73,
      42,  -40,   59,       61,  -51,   46,       80,  -61,   33,       99,  -72,   19,
    -109,   49,  -13,      -90,   38,  -27,      -71,   27,  -40,      -52,   17,  -54,
     -33,    6,  -68,      -14,   -4,  -81,        5,  -14,  -94,       24,  -25, -108,
    -107,   48,   -9,      -87,   37,  -23,      -69,   26,  -36,      -50,   16,  -50,
     -31,    5,  -64,      -12,   -5,  -77,        7,  -16,  -90,       26,  -27, -104,
    -104,   46,   -5,      -85,   35,  -19,      -66,   25,  -32,      -48,   14,  -46,
     -28,    3,  -60,       -9,   -6,  -73,        9,  -17,  -86,       29,  -28, -100,
    -102,   45,   -1,      -82,   34,  -15,      -64,   23,  -28,      -45,   13,  -41,
     -25,    2,  -55,       -7,   -8,  -69,       12,  -18,  -82,       31,  -29,  -96,
     -99,   43,    2,      -80,   33,  -11,      -61,   22,  -24,      -42,   11,  -37,
     -23,    0,  -51,       -4,   -9,  -65,       14,  -20,  -78,       34,  -31,  -92,
     -97,   42,    6,      -78,   31,   -7,      -59,   21,  -20,      -40,   10,  -33,
     -21,    0,  -47,       -2,  -11,  -61,       17,  -21,  -74,       36,  -32,  -88,
     -95,   41,   10,      -75,   30,   -3,      -56,   19,  -16,      -38,    9,  -29,
     -18,   -1,  -43,        0,  -12,  -57,       19,  -23,  -70,       39,  -33,  -84,
     -92,   39,   15,      -73,   28,    1,      -54,   18,  -11,      -35,    7,  -25,
     -16,   -3,  -39,        3,  -13,  -52,       22,  -24,  -65,       41,  -35,  -79,
     -90,   38,   19,      -70,   27,    5,      -51,   16,   -7,      -33,    6,  -21,
     -13,   -4,  -35,        6,  -15,  -48,       24,  -25,  -61,       44,  -36,  -75,
     -87,   37,   23,      -68,   26,    9,      -49,   15,   -3,      -30,    4,  -17,
     -11,   -6,  -31,        8,  -16,  -44,       27,  -27,  -57,       46,  -38,  -71,
     -85,   35,   27,      -65,   24,   13,      -47,   14,    0,      -28,    3,  -13,
      -8,   -7,  -27,       10,  -17,  -40,       29,  -28,  -53,       49,  -39,  -67,
     -82,   34,   31,      -63,   23,   17,      -44,   12,    4,      -25,    2,   -9,
      -6,   -8,  -23,       13,  -19,  -36,       32,  -29,  -49,       51,  -40,  -63,
     -80,   32,   35,      -60,   21,   21,      -42,   11,    8,      -23,    0,   -4,
      -3,  -10,  -18,       15,  -20,  -32,       34,  -31,  -45,       54,  -42,  -59,
     -77,   31,   39,      -58,   20,   25,      -39,    9,   12,      -20,    0,    0,
      -1,  -11,  -14,       18,  -22,  -28,       37,  -32,  -41,       56,  -43,  -55,
     -75,   30,   43,      -56,   19,   29,      -37,    8,   16,      -18,   -2,    3,
       1,  -12,  -10,       20,  -23,  -24,       39,  -34,  -37,       58,  -45,  -51,
     -72,   28,   47,      -53,   17,   33,      -34,    7,   20,      -16,   -3,    7,
       4,  -14,   -6,       23,  -24,  -20,       41,  -35,  -33,       61,  -46,  -47,
     -70,   27,   52,      -50,   16,   38,      -32,    5,   25,      -13,   -4,   11,
       7,  -15,   -2,       25,  -26,  -15,       44,  -37,  -28,       63,  -47,  -42,
     -67,   25,   56,      -48,   14,   42,      -29,    4,   29,      -10,   -6,   15,
       9,  -17,    1,       28,  -27,  -11,       46,  -38,  -24,       66,  -49,  -38,
     -65,   24,   60,      -46,   13,   46,      -27,    3,   33,       -8,   -7,   19,
      11,  -18,    5,       30,  -29,   -7,       49,  -39,  -20,       68,  -50,  -34,
     -63,   23,   64,      -43,   12,   50,      -24,    1,   37,       -6,   -8,   23,
      14,  -19,    9,       32,  -30,   -3,       51,  -41,  -16,       71,  -51,  -30,
     -60,   21,   68,      -41,   10,   54,      -22,    0,   41,       -3,  -10,   28,
      16,  -21,   14,       35,  -31,    0,       54,  -42,  -12,       73,  -53,  -26,
     -58,   20,   72,      -38,    9,   58,      -19,   -1,   45,       -1,  -11,   32,
      19,  -22,   18,       38,  -33,    4,       56,  -43,   -8,       76,  -54,  -22,
     -55,   18,   76,      -36,    8,   62,      -17,   -2,   49,        2,  -13,   36,
      21,  -24,   22,       40,  -34,    8,       59,  -45,   -4,       78,  -56,  -18,
     -53,   17,   80,      -33,    6,   66,      -15,   -3,   53,        4,  -14,   40,
      24,  -25,   26,       42,  -36,   12,       61,  -46,    0,       81,  -57,  -14,
     -50,   16,   84,      -31,    5,   70,      -12,   -5,   57,        7,  -15,   44,
      26,  -26,   30,       45,  -37,   16,       64,  -47,    3,       83,  -58,  -10,
     -48,   14,   89,      -28,    3,   75,      -10,   -6,   62,        9,  -17,   48,
      29,  -28,   34,       47,  -38,   21,       66,  -49,    8,       86,  -60,   -5,
     -45,   13,   93,      -26,    2,   79,       -7,   -8,   66,       12,  -18,   52,
      31,  -29,   38,       50,  -40,   25,       69,  -50,   12,       88,  -61,   -1,
     -43,   12,   97,      -24,    1,   83,       -5,   -9,   70,       14,  -20,   56,
      33,  -30,   42,       52,  -41,   29,       71,  -52,   16,       90,  -63,    2,
     -40,   10,  101,      -21,    0,   87,       -2,  -10,   74,       16,  -21,   60,
      36,  -32,   46,       55,  -42,   33,       73,  -53,   20,       93,  -64,    6,
     -38,    9,  105,      -18,   -1,   91,        0,  -12,   78,       19,  -22,   65,
      39,  -33,   51,       57,  -44,   37,       76,  -55,   24,       95,  -66,   10,
     -35,    7,  109,      -16,   -3,   95,        3,  -13,   82,       22,  -24,   69,
      41,  -35,   55,       60,  -45,   41,       78,  -56,   28,       98,  -67,   14,
     -33,    6,  113,      -14,   -4,   99,        5,  -15,   86,       24,  -25,   73,
      43,  -36,   59,       62,  -47,   45,       81,  -57,   32,      100,  -68,   18,
    -108,   53,  -14,      -89,   42,  -28,      -70,   31,  -41,      -51,   21,  -54,
     -32,   10,  -68,      -13,    0,  -82,        6,  -10,  -95,       25,  -21, -109,
    -106,   52,  -10,      -87,   41,  -24,      -68,   30,  -37,      -49,   20,  -50,
     -30,    9,  -64,      -11,   -1,  -78,        8,  -12,  -91,       27,  -23, -105,
    -104,   50,   -6,      -84,   39,  -20,      -65,   29,  -33,      -47,   18,  -46,
     -27,    7,  -60,       -8,   -2,  -74,       10,  -13,  -87,       30,  -24, -101,
    -101,   49,   -1,      -81,   38,  -15,      -63,   27,  -29,      -44,   17,  -42,
     -25,    6,  -56,       -6,   -4,  -69,       13,  -14,  -83,       32,  -25,  -96,
     -98,   47,    2,      -79,   37,  -11,      -60,   26,  -25,      -42,   15,  -38,
     -22,    4,  -52,       -3,   -5,  -65,       15,  -16,  -79,       35,  -27,  -92,
     -96,   46,    6,      -77,   35,   -7,      -58,   25,  -21,      -39,   14,  -34,
     -20,    3,  -48,       -1,   -7,  -61,       18,  -17,  -75,       37,  -28,  -88,
     -94,   45,   10,      -74,   34,   -3,      -56,   23,  -17,      -37,   13,  -30,
     -17,    2,  -44,        1,   -8,  -57,       20,  -19,  -71,       40,  -29,  -84,
     -91,   43,   14,      -72,   32,    0,      -53,   22,  -12,      -34,   11,  -25,
     -15,    0,  -39,        4,   -9,  -53,       23,  -20,  -66,       42,  -31,  -80,
     -89,   42,   18,      -69,   31,    4,      -50,   20,   -8,      -32,   10,  -21,
     -12,    0,  -35,        6,  -11,  -49,       25,  -21,  -62,       45,  -32,  -76,
     -86,   41,   22,      -67,   30,    8,      -48,   19,   -4,      -29,    8,  -17,
     -10,   -2,  -31,        9,  -12,  -45,       28,  -23,  -58,       47,  -34,  -72,
     -84,   39,   26,      -64,   28,   12,      -46,   18,    0,      -27,    7,  -13,
      -8,   -3,  -27,       11,  -13,  -41,       30,  -24,  -54,       49,  -35,  -68,
     -81,   38,   30,      -62,   27,   16,      -43,   16,    3,      -24,    6,   -9,
      -5,   -4,  -23,       14,  -15,  -37,       32,  -25,  -50,       52,  -36,  -64,
     -79,   36,   35,      -59,   25,   21,      -41,   15,    7,      -22,    4,   -5,
      -2,   -6,  -19,       16,  -16,  -32,       35,  -27,  -46,       55,  -38,  -59,
     -76,   35,   39,      -57,   24,   25,      -38,   13,   11,      -19,    3,   -1,
       0,   -7,  -15,       19,  -18,  -28,       38,  -28,  -42,       57,  -39,  -55,
     -74,   34,   43,      -55,   23,   29,      -36,   12,   15,      -17,    1,    2,
       2,   -8,  -11,       21,  -19,  -24,       40,  -30,  -38,       59,  -41,  -51,
     -72,   32,   47,      -52,   21,   33,      -33,   11,   19,      -15,    0,    6,
       5,  -10,   -7,       24,  -20,  -20,       42,  -31,  -34,       62,  -42,  -47,
     -69,   31,   51,      -50,   20,   37,      -31,    9,   24,      -12,    0,   11,
       7,  -11,   -2,       26,  -22,  -16,       45,  -33,  -29,       64,  -43,  -43,
     -66,   29,   55,      -47,   18,   41,      -28,    8,   28,      -10,   -2,   15,
      10,  -13,    1,       29,  -23,  -12,       47,  -34,  -25,       67,  -45,  -39,
     -64,   28,   59,      -45,   17,   45,      -26,    7,   32,       -7,   -3,   19,
      12,  -14,    5,       31,  -25,   -8,       50,  -35,  -21,       69,  -46,  -35,
     -62,   27,   63,      -42,   16,   49,      -24,    5,   36,       -5,   -4,   23,
      15,  -15,    9,       33,  -26,   -4,       52,  -37,  -17,       72,  -47,  -31,
     -59,   25,   68,      -40,   14,   54,      -21,    4,   40,       -2,   -6,   27,
      17,  -17,   13,       36,  -27,    0,       55,  -38,  -13,       74,  -49,  -26,
     -57,   24,   72,      -37,   13,   58,      -18,    2,   44,        0,   -7,   31,
      20,  -18,   17,       38,  -29,    4,       57,  -39,   -9,       77,  -50,  -22,
     -54,   22,   76,      -35,   12,   62,      -16,    1,   48,        3,   -9,   35,
      22,  -20,   21,       41,  -30,    8,       60,  -41,   -5,       79,  -52,  -18,
     -52,   21,   80,      -32,   10,   66,      -14,    0,   52,        5,  -10,   39,
      24,  -21,   25,       43,  -32,   12,       62,  -42,   -1,       81,  -53,  -14,
     -49,   20,   84,      -30,    9,   70,      -11,   -1,   56,        7,  -11,   43,
      27,  -22,   29,       46,  -33,   16,       64,  -43,    2,       84,  -54,  -10,
     -47,   18,   88,      -27,    7,   74,       -9,   -2,   61,       10,  -13,   48,
      30,  -24,   34,       48,  -34,   20,       67,  -45,    7,       86,  -56,   -6,
     -44,   17,   92,      -25,    6,   78,       -6,   -4,   65,       13,  -14,   52,
      32,  -25,   38,       51,  -36,   24,       70,  -46,   11,       89,  -57,   -2,
     -42,   16,   96,      -23,    5,   82,       -4,   -5,   69,       15,  -16,   56,
      34,  -26,   42,       53,  -37,   28,       72,  -48,   15,       91,  -59,    1,
     -40,   14,  100,      -20,    3,   86,       -1,   -6,   73,       17,  -17,   60,
      37,  -28,   46,       56,  -38,   32,       74,  -49,   19,       94,  -60,    5,
     -37,   13,  105,      -18,    2,   91,        1,   -8,   77,       20,  -18,   64,
      39,  -29,   50,       58,  -40,   37,       77,  -51,   23,       96,  -62,   10,
     -34,   11,  109,      -15,    0,   95,        4,   -9,   81,       22,  -20,   68,
      42,  -31,   54,       61,  -41,   41,       79,  -52,   27,       99,  -63,   14,
     -32,   10,  113,      -13,    0,   99,        6,  -11,   85,       25,  -21,   72,
      44,  -32,   58,       63,  -43,   45,       82,  -53,   31,      101,  -64,   18,
    -107,   57,  -15,      -88,   46,  -28,      -69,   35,  -42,      -50,   25,  -55,
     -31,   14,  -69,      -12,    3,  -82,        6,   -6,  -96,       26,  -17, -110,
    -105,   56,  -11,      -86,   45,  -24,      -67,   34,  -38,      -48,   24,  -51,
     -29,   13,  -65,      -10,    2,  -78,        9,   -8,  -92,       28,  -19, -106,
    -103,   54,   -7,      -83,   43,  -20,      -64,   33,  -34,      -46,   22,  -47,
     -26,   11,  -61,       -8,    1,  -74,       11,   -9,  -88,       31,  -20, -102,
    -100,   53,   -2,      -81,   42,  -16,      -62,   31,  -29,      -43,   21,  -43,
     -24,   10,  -56,       -5,    0,  -70,       14,  -10,  -83,       33,  -21,  -97,
     -98,   51,    1,      -78,   41,  -12,      -59,   30,  -25,      -41,   19,  -39,
     -21,    8,  -52,       -2,   -1,  -66,       16,  -12,  -79,       36,  -23,  -93,
     -95,   50,    5,      -76,   39,   -8,      -57,   29,  -21,      -38,   18,  -35,
     -19,    7,  -48,        0,   -3,  -62,       19,  -13,  -75,       38,  -24,  -89,
     -93,   49,    9,      -73,   38,   -4,      -55,   27,  -17,      -36,   17,  -31,
     -16,    6,  -44,        2,   -4,  -58,       21,  -15,  -71,       40,  -25,  -85,
     -90,   47,   13,      -71,   36,    0,      -52,   26,  -13,      -33,   15,  -26,
     -14,    4,  -40,        5,   -5,  -53,       24,  -16,  -67,       43,  -27,  -81,
     -88,   46,   17,      -68,   35,    4,      -50,   24,   -9,      -31,   14,  -22,
     -11,    3,  -36,        7,   -7,  -49,       26,  -17,  -63,       46,  -28,  -77,
     -85,   45,   21,      -66,   34,    8,      -47,   23,   -5,      -28,   12,  -18,
      -9,    1,  -32,       10,   -8,  -45,       29,  -19,  -59,       48,  -30,  -73,
     -83,   43,   25,      -64,   32,   12,      -45,   22,   -1,      -26,   11,  -14,
      -7,    0,  -28,       12,   -9,  -41,       31,  -20,  -55,       50,  -31,  -69,
     -81,   42,   29,      -61,   31,   16,      -42,   20,    2,      -24,   10,  -10,
      -4,    0,  -24,       15,  -11,  -37,       33,  -21,  -51,       53,  -32,  -65,
     -78,   40,   34,      -58,   29,   20,      -40,   19,    7,      -21,    8,   -6,
      -2,   -2,  -19,       17,  -12,  -33,       36,  -23,  -46,       55,  -34,  -60,
     -75,   39,   38,      -56,   28,   24,      -37,   17,   11,      -19,    7,   -2,
       1,   -3,  -15,       20,  -14,  -29,       38,  -24,  -42,       58,  -35,  -56,
     -73,   38,   42,      -54,   27,   28,      -35,   16,   15,      -16,    5,    1,
       3,   -4,  -11,       22,  -15,  -25,       41,  -26,  -38,       60,  -37,  -52,
     -71,   36,   46,      -51,   25,   32,      -33,   15,   19,      -14,    4,    5,
       6,   -6,   -7,       24,  -16,  -21,       43,  -27,  -34,       63,  -38,  -48,
     -68,   35,   50,      -49,   24,   37,      -30,   13,   23,      -11,    3,   10,
       8,   -7,   -3,       27,  -18,  -16,       46,  -29,  -30,       65,  -39,  -44,
     -66,   33,   54,      -46,   22,   41,      -27,   12,   27,       -9,    1,   14,
      11,   -9,    0,       30,  -19,  -12,       48,  -30,  -26,       68,  -41,  -40,
     -63,   32,   58,      -44,   21,   45,      -25,   11,   31,       -6,    0,   18,
      13,  -10,    4,       32,  -21,   -8,       51,  -31,  -22,       70,  -42,  -36,
     -61,   31,   62,      -41,   20,   49,      -23,    9,   35,       -4,    0,   22,
      16,  -11,    8,       34,  -22,   -4,       53,  -33,  -18,       72,  -43,  -32,
     -58,   29,   67,      -39,   18,   53,      -20,    8,   40,       -1,   -2,   26,
      18,  -13,   13,       37,  -23,    0,       56,  -34,  -13,       75,  -45,  -27,
     -56,   28,   71,      -36,   17,   57,      -18,    6,   44,        1,   -3,   30,
      21,  -14,   17,       39,  -25,    3,       58,  -35,   -9,       78,  -46,  -23,
     -53,   26,   75,      -34,   16,   61,      -15,    5,   48,        4,   -5,   34,
      23,  -16,   21,       42,  -26,    7,       61,  -37,   -5,       80,  -48,  -19,
     -51,   25,   79,      -32,   14,   65,      -13,    4,   52,        6,   -6,   38,
      25,  -17,   25,       44,  -28,   11,       63,  -38,   -1,       82,  -49,  -15,
     -49,   24,   83,      -29,   13,   69,      -10,    2,   56,        8,   -7,   42,
      28,  -18,   29,       47,  -29,   15,       65,  -39,    2,       85,  -50,  -11,
     -46,   22,   87,      -26,   11,   74,       -8,    1,   60,       11,   -9,   47,
      30,  -20,   33,       49,  -30,   20,       68,  -41,    6,       87,  -52,   -7,
     -43,   21,   91,      -24,   10,   78,       -5,    0,   64,       13,  -10,   51,
      33,  -21,   37,       52,  -32,   24,       70,  -42,   10,       90,  -53,   -3,
     -41,   20,   95,      -22,    9,   82,       -3,   -1,   68,       16,  -12,   55,
      35,  -22,   41,       54,  -33,   28,       73,  -44,   14,       92,  -55,    0,
     -39,   18,   99,      -19,    7,   86,       -1,   -2,   72,       18,  -13,   59,
      38,  -24,   45,       56,  -34,   32,       75,  -45,   18,       95,  -56,    4,
     -36,   17,  104,      -17,    6,   90,        2,   -4,   77,       21,  -14,   63,
      40,  -25,   50,       59,  -36,   36,       78,  -47,   23,       97,  -58,    9,
     -34,   15,  108,      -14,    4,   94,        5,   -5,   81,       23,  -16,   67,
      43,  -27,   54,       62,  -37,   40,       80,  -48,   27,      100,  -59,   13,
     -31,   14,  112,      -12,    3,   98,        7,   -7,   85,       26,  -17,   71,
      45,  -28,   58,       64,  -39,   44,       83,  -49,   31,      102,  -60,   17,
    -106,   62,  -15,      -87,   51,  -29,      -68,   40,  -42,      -49,   29,  -56,
     -30,   18,  -70,      -11,    8,  -83,        7,   -2,  -96,       27,  -13, -110,
    -104,   60,  -11,      -85,   49,  -25,      -66,   39,  -38,      -47,   28,  -52,
     -28,   17,  -66,       -9,    7,  -79,       10,   -3,  -92,       29,  -14, -106,
    -102,   59,   -7,      -82,   48,  -21,      -63,   37,  -34,      -45,   27,  -48,
     -25,   16,  -62,       -7,    5,  -75,       12,   -4,  -88,       32,  -15, -102,
     -99,   57,   -3,      -80,   46,  -17,      -61,   36,  -30,      -42,   25,  -43,
     -23,   14,  -57,       -4,    4,  -71,       15,   -6,  -84,       34,  -17,  -98,
     -97,   56,    0,      -77,   45,  -13,      -58,   34,  -26,      -40,   24,  -39,
     -20,   13,  -53,       -1,    2,  -67,       17,   -7,  -80,       37,  -18,  -94,
     -94,   55,    4,      -75,   44,   -9,      -56,   33,  -22,      -37,   22,  -35,
     -18,   12,  -49,        1,    1,  -63,       20,   -9,  -76,       39,  -20,  -90,
     -92,   53,    8,      -72,   42,   -5,      -54,   32,  -18,      -35,   21,  -31,
     -15,   10,  -45,        3,    0,  -59,       22,  -10,  -72,       41,  -21,  -86,
     -89,   52,   13,      -70,   41,    0,      -51,   30,  -13,      -32,   20,  -27,
     -13,    9,  -41,        6,   -1,  -54,       25,  -12,  -67,       44,  -22,  -81,
     -87,   50,   17,      -67,   39,    3,      -49,   29,   -9,      -30,   18,  -23,
     -10,    7,  -37,        8,   -2,  -50,       27,  -13,  -63,       47,  -24,  -77,
     -84,   49,   21,      -65,   38,    7,      -46,   28,   -5,      -27,   17,  -19,
      -8,    6,  -33,       11,   -4,  -46,       30,  -14,  -59,       49,  -25,  -73,
     -82,   48,   25,      -63,   37,   11,      -44,   26,   -1,      -25,   16,  -15,
      -6,    5,  -29,       13,   -5,  -42,       32,  -16,  -55,       51,  -27,  -69,
     -79,   46,   29,      -60,   35,   15,      -41,   25,    2,      -23,   14,  -11,
      -3,    3,  -25,       16,   -6,  -38,       34,  -17,  -51,       54,  -28,  -65,
     -77,   45,   33,      -57,   34,   19,      -39,   23,    6,      -20,   13,   -6,
       0,    2,  -20,       18,   -8,  -34,       37,  -18,  -47,       56,  -29,  -61,
     -74,   43,   37,      -55,   33,   23,      -36,   22,   10,      -17,   11,   -2,
       2,    0,  -16,       21,   -9,  -30,       39,  -20,  -43,       59,  -31,  -57,
     -72,   42,   41,      -53,   31,   27,      -34,   21,   14,      -15,   10,    1,
       4,    0,  -12,       23,  -11,  -26,       42,  -21,  -39,       61,  -32,  -53,
     -70,   41,   45,      -50,   30,   31,      -31,   19,   18,      -13,    9,    5,
       7,   -1,   -8,       25,  -12,  -22,       44,  -22,  -35,       64,  -33,  -49,
     -67,   39,   50,      -48,   28,   36,      -29,   18,   23,      -10,    7,    9,
       9,   -3,   -4,       28,  -13,  -17,       47,  -24,  -30,       66,  -35,  -44,
     -65,   38,   54,      -45,   27,   40,      -26,   16,   27,       -8,    6,   13,
      12,   -4,    0,       31,  -15,  -13,       49,  -25,  -26,       69,  -36,  -40,
     -62,   37,   58,      -43,   26,   44,      -24,   15,   31,       -5,    4,   17,
      14,   -6,    3,       33,  -16,   -9,       52,  -27,  -22,       71,  -38,  -36,
     -60,   35,   62,      -40,   24,   48,      -22,   14,   35,       -3,    3,   21,
      17,   -7,    7,       35,  -17,   -5,       54,  -28,  -18,       73,  -39,  -32,
     -57,   34,   66,      -38,   23,   52,      -19,   12,   39,        0,    2,   26,
      19,   -8,   12,       38,  -19,   -1,       57,  -30,  -14,       76,  -41,  -28,
     -55,   32,   70,      -35,   21,   56,      -17,   11,   43,        2,    0,   30,
      22,  -10,   16,       40,  -20,    2,       59,  -31,  -10,       79,  -42,  -24,
     -52,   31,   74,      -33,   20,   60,      -14,    9,   47,        5,    0,   34,
      24,  -11,   20,       43,  -22,    6,       62,  -32,   -6,       81,  -43,  -20,
     -50,   30,   78,      -31,   19,   64,      -12,    8,   51,        7,   -1,   38,
      26,  -12,   24,       45,  -23,   10,       64,  -34,   -2,       83,  -45,  -16,
     -48,   28,   82,      -28,   17,   68,       -9,    7,   55,        9,   -3,   42,
      29,  -14,   28,       48,  -24,   14,       66,  -35,    1,       86,  -46,  -12,
     -45,   27,   87,      -25,   16,   73,       -7,    5,   60,       12,   -4,   46,
      31,  -15,   32,       50,  -26,   19,       69,  -37,    6,       88,  -47,   -7,
     -42,   25,   91,      -23,   14,   77,       -4,    4,   64,       15,   -6,   50,
      34,  -17,   36,       53,  -27,   23,       71,  -38,   10,       91,  -49,   -3,
     -40,   24,   95,      -21,   13,   81,       -2,    3,   68,       17,   -7,   54,
      36,  -18,   40,       55,  -29,   27,       74,  -39,   14,       93,  -50,    0,
     -38,   23,   99,      -18,   12,   85,        1,    1,   72,       19,   -8,   58,
      39,  -19,   44,       57,  -30,   31,       76,  -41,   18,       96,  -51,    4,
     -35,   21,  103,      -16,   10,   89,        3,    0,   76,       22,  -10,   63,
      41,  -21,   49,       60,  -31,   35,       79,  -42,   22,       98,  -53,    8,
     -33,   20,  107,      -13,    9,   93,        6,   -1,   80,       24,  -11,   67,
      44,  -22,   53,       63,  -33,   39,       81,  -43,   26,      101,  -54,   12,
     -30,   18,  111,      -11,    8,   97,        8,   -2,   84,       27,  -13,   71,
      46,  -24,   57,       65,  -34,   43,       84,  -45,   30,      103,  -56,   16,
    -105,   66,  -16,      -86,   55,  -30,      -67,   44,  -43,      -49,   33,  -57,
     -29,   22,  -70,      -10,   12,  -84,        8,    1,  -97,       28,   -9, -111,
    -103,   64,  -12,      -84,   53,  -26,      -65,   43,  -39,      -46,   32,  -53,
     -27,   21,  -66,       -8,   11,  -80,       11,    0,  -93,       30,  -10, -107,
    -101,   63,   -8,      -81,   52,  -22,      -63,   41,  -35,      -44,   31,  -49,
     -24,   20,  -62,       -6,    9,  -76,       13,    0,  -89,       33,  -11, -103,
     -98,   61,   -3,      -79,   50,  -17,      -60,   40,  -31,      -41,   29,  -44,
     -22,   18,  -58,       -3,    8,  -71,       16,   -2,  -85,       35,  -13,  -98,
     -96,   60,    0,      -76,   49,  -13,      -57,   38,  -27,      -39,   28,  -40,
     -19,   17,  -54,       -1,    6,  -67,       18,   -3,  -81,       38,  -14,  -94,
     -93,   59,    4,      -74,   48,   -9,      -55,   37,  -23,      -36,   26,  -36,
     -17,   16,  -50,        2,    5,  -63,       21,   -5,  -77,       40,  -16,  -90,
     -91,   57,    8,      -71,   46,   -5,      -53,   36,  -19,      -34,   25,  -32,
     -15,   14,  -46,        4,    4,  -59,       23,   -6,  -73,       42,  -17,  -86,
     -88,   56,   12,      -69,   45,   -1,      -50,   34,  -14,      -31,   24,  -28,
     -12,   13,  -41,        7,    2,  -55,       26,   -8,  -68,       45,  -18,  -82,
     -86,   54,   16,      -66,   43,    2,      -48,   33,  -10,      -29,   22,  -24,
      -9,   11,  -37,        9,    1,  -51,       28,   -9,  -64,       47,  -20,  -78,
     -83,   53,   20,      -64,   42,    6,      -45,   32,   -6,      -26,   21,  -20,
      -7,   10,  -33,       12,    0,  -47,       31,  -10,  -60,       50,  -21,  -74,
     -81,   52,   24,      -62,   41,   10,      -43,   30,   -2,      -24,   20,  -16,
      -5,    9,  -29,       14,   -1,  -43,       33,  -12,  -56,       52,  -23,  -70,
     -79,   50,   28,      -59,   39,   14,      -40,   29,    1,      -22,   18,  -12,
      -2,    7,  -25,       17,   -2,  -39,       35,  -13,  -52,       55,  -24,  -66,
     -76,   49,   33,      -57,   38,   19,      -38,   27,    5,      -19,   17,   -7,
       0,    6,  -21,       19,   -4,  -34,       38,  -14,  -48,       57,  -25,  -61,
     -74,   47,   37,      -54,   37,   23,      -35,   26,    9,      -17,   15,   -3,
       3,    4,  -17,       22,   -5,  -30,       40,  -16,  -44,       60,  -27,  -57,
     -71,   46,   41,      -52,   35,   27,      -33,   25,   13,      -14,   14,    0,
       5,    3,  -13,       24,   -7,  -26,       43,  -17,  -40,       62,  -28,  -53,
     -69,   45,   45,      -49,   34,   31,      -31,   23,   17,      -12,   13,    4,
       8,    2,   -9,       26,   -8,  -22,       45,  -18,  -36,       65,  -29,  -49,
     -66,   43,   49,      -47,   32,   35,      -28,   22,   22,       -9,   11,    8,
      10,    0,   -4,       29,   -9,  -18,       48,  -20,  -31,       67,  -31,  -45,
     -64,   42,   53,      -44,   31,   39,      -25,   20,   26,       -7,   10,   12,
      13,    0,    0,       31,  -11,  -14,       50,  -21,  -27,       70,  -32,  -41,
     -61,   41,   57,      -42,   30,   43,      -23,   19,   30,       -4,    8,   16,
      15,   -2,    3,       34,  -12,  -10,       53,  -23,  -23,       72,  -34,  -37,
     -59,   39,   61,      -39,   28,   47,      -21,   18,   34,       -2,    7,   20,
      17,   -3,    7,       36,  -13,   -6,       55,  -24,  -19,       74,  -35,  -33,
     -56,   38,   66,      -37,   27,   52,      -18,   16,   38,        1,    6,   25,
      20,   -4,   11,       39,  -15,   -1,       58,  -26,  -15,       77,  -37,  -28,
     -54,   36,   70,      -34,   25,   56,      -16,   15,   42,        3,    4,   29,
      23,   -6,   15,       41,  -16,    2,       60,  -27,  -11,       79,  -38,  -24,
     -51,   35,   74,      -32,   24,   60,      -13,   13,   46,        6,    3,   33,
      25,   -7,   19,       44,  -18,    6,       63,  -28,   -7,       82,  -39,  -20,
     -49,   34,   78,      -30,   23,   64,      -11,   12,   50,        8,    2,   37,
      27,   -8,   23,       46,  -19,   10,       65,  -30,   -3,       84,  -41,  -16,
     -47,   32,   82,      -27,   21,   68,       -8,   11,   54,       10,    0,   41,
      30,  -10,   27,       49,  -20,   14,       67,  -31,    0,       87,  -42,  -12,
     -44,   31,   86,      -25,   20,   72,       -6,    9,   59,       13,    0,   45,
      32,  -11,   32,       51,  -22,   18,       70,  -33,    5,       89,  -43,   -8,
     -42,   29,   90,      -22,   18,   76,       -3,    8,   63,       15,   -2,   49,
      35,  -13,   36,       54,  -23,   22,       72,  -34,    9,       92,  -45,   -4,
     -39,   28,   94,      -20,   17,   80,       -1,    7,   67,       18,   -3,   53,
      37,  -14,   40,       56,  -25,   26,       75,  -35,   13,       94,  -46,    0,
     -37,   27,   98,      -17,   16,   84,        1,    5,   71,       20,   -4,   57,
      40,  -15,   44,       58,  -26,   30,       77,  -37,   17,       97,  -47,    3,
     -34,   25,  103,      -15,   14,   89,        4,    4,   75,       23,   -6,   62,
      42,  -17,   48,       61,  -27,   35,       80,  -38,   21,       99,  -49,    8,
     -32,   24,  107,      -12,   13,   93,        7,    2,   79,       25,   -7,   66,
      45,  -18,   52,       63,  -29,   39,       82,  -39,   25,      102,  -50,   12,
     -29,   22,  111,      -10,   12,   97,        9,    1,   83,       28,   -9,   70,
      47,  -20,   56,       66,  -30,   43,       85,  -41,   29,      104,  -52,   16,
    -105,   70,  -17,      -85,   59,  -30,      -66,   48,  -44,      -48,   37,  -57,
     -28,   26,  -71,       -9,   16,  -84,        9,    5,  -98,       29,   -5, -112,
    -102,   68,  -13,      -83,   57,  -26,      -64,   47,  -40,      -45,   36,  -53,
     -26,   25,  -67,       -7,   15,  -80,       12,    4,  -94,       31,   -6, -108,
    -100,   67,   -9,      -80,   56,  -22,      -62,   45,  -36,      -43,   35,  -49,
     -23,   24,  -63,       -5,   13,  -76,       14,    3,  -90,       33,   -7, -104,
     -97,   65,   -4,      -78,   54,  -18,      -59,   44,  -31,      -40,   33,  -45,
     -21,   22,  -58,       -2,   12,  -72,       17,    1,  -85,       36,   -9,  -99,
     -95,   64,    0,      -75,   53,  -14,      -57,   42,  -27,      -38,   32,  -41,
     -18,   21,  -54,        0,   10,  -68,       19,    0,  -81,       39,  -10,  -95,
     -92,   63,    3,      -73,   52,  -10,      -54,   41,  -23,      -35,   30,  -37,
     -16,   20,  -50,        3,    9,  -64,       22,   -1,  -77,       41,  -12,  -91,
     -90,   61,    7,      -71,   50,   -6,      -52,   40,  -19,      -33,   29,  -33,
     -14,   18,  -46,        5,    8,  -60,       24,   -2,  -73,       43,  -13,  -87,
     -87,   60,   11,      -68,   49,   -1,      -49,   38,  -15,      -30,   28,  -28,
     -11,   17,  -42,        8,    6,  -55,       27,   -4,  -69,       46,  -14,  -83,
     -85,   58,   15,      -65,   47,    2,      -47,   37,  -11,      -28,   26,  -24,
      -9,   15,  -38,       10,    5,  -51,       29,   -5,  -65,       48,  -16,  -79,
     -82,   57,   19,      -63,   46,    6,      -44,   36,   -7,      -26,   25,  -20,
      -6,   14,  -34,       13,    3,  -47,       31,   -6,  -61,       51,  -17,  -75,
     -80,   56,   23,      -61,   45,   10,      -42,   34,   -3,      -23,   24,  -16,
      -4,   13,  -30,       15,    2,  -43,       34,   -8,  -57,       53,  -19,  -71,
     -78,   54,   27,      -58,   43,   14,      -40,   33,    0,      -21,   22,  -12,
      -1,   11,  -26,       17,    1,  -39,       36,   -9,  -53,       56,  -20,  -67,
     -75,   53,   32,      -56,   42,   18,      -37,   31,    5,      -18,   21,   -8,
       1,   10,  -21,       20,    0,  -35,       39,  -10,  -48,       58,  -21,  -62,
     -73,   51,   36,      -53,   41,   22,      -34,   30,    9,      -16,   19,   -4,
       4,    8,  -17,       23,   -1,  -31,       41,  -12,  -44,       61,  -23,  -58,
     -70,   50,   40,      -51,   39,   26,      -32,   29,   13,      -13,   18,    0,
       6,    7,  -13,       25,   -3,  -27,       44,  -13,  -40,       63,  -24,  -54,
     -68,   49,   44,      -48,   38,   30,      -30,   27,   17,      -11,   17,    3,
       9,    6,   -9,       27,   -4,  -23,       46,  -14,  -36,       65,  -25,  -50,
     -65,   47,   48,      -46,   36,   35,      -27,   26,   21,       -8,   15,    8,
      11,    4,   -5,       30,   -5,  -18,       49,  -16,  -32,       68,  -27,  -46,
     -63,   46,   52,      -43,   35,   39,      -25,   24,   25,       -6,   14,   12,
      14,    3,   -1,       32,   -7,  -14,       51,  -17,  -28,       71,  -28,  -42,
     -60,   45,   56,      -41,   34,   43,      -22,   23,   29,       -3,   12,   16,
      16,    1,    2,       35,   -8,  -10,       54,  -19,  -24,       73,  -30,  -38,
     -58,   43,   60,      -39,   32,   47,      -20,   22,   33,       -1,   11,   20,
      18,    0,    6,       37,   -9,   -6,       56,  -20,  -20,       75,  -31,  -34,
     -55,   42,   65,      -36,   31,   51,      -17,   20,   38,        2,   10,   24,
      21,    0,   11,       40,  -11,   -2,       59,  -22,  -15,       78,  -33,  -29,
     -53,   40,   69,      -33,   29,   55,      -15,   19,   42,        4,    8,   28,
      23,   -2,   15,       42,  -12,    1,       61,  -23,  -11,       80,  -34,  -25,
     -50,   39,   73,      -31,   28,   59,      -12,   17,   46,        6,    7,   32,
      26,   -3,   19,       45,  -14,    5,       63,  -24,   -7,       83,  -35,  -21,
     -48,   38,   77,      -29,   27,   63,      -10,   16,   50,        9,    6,   36,
      28,   -4,   23,       47,  -15,    9,       66,  -26,   -3,       85,  -37,  -17,
     -46,   36,   81,      -26,   25,   67,       -8,   15,   54,       11,    4,   40,
      31,   -6,   27,       49,  -16,   13,       68,  -27,    0,       88,  -38,  -13,
     -43,   35,   85,      -24,   24,   72,       -5,   13,   58,       14,    3,   45,
      33,   -7,   31,       52,  -18,   18,       71,  -29,    4,       90,  -39,   -9,
     -41,   33,   89,      -21,   22,   76,       -2,   12,   62,       16,    1,   49,
      36,   -9,   35,       54,  -19,   22,       73,  -30,    8,       93,  -41,   -5,
     -38,   32,   93,      -19,   21,   80,        0,   11,   66,       19,    0,   53,
      38,  -10,   39,       57,  -21,   26,       76,  -31,   12,       95,  -42,   -1,
     -36,   31,   97,      -16,   20,   84,        2,    9,   70,       21,    0,   57,
      40,  -11,   43,       59,  -22,   30,       78,  -33,   16,       97,  -43,    2,
     -33,   29,  102,      -14,   18,   88,        5,    8,   75,       24,   -2,   61,
      43,  -13,   48,       62,  -23,   34,       81,  -34,   21,      100,  -45,    7,
     -31,   28,  106,      -11,   17,   92,        7,    6,   79,       26,   -3,   65,
      46,  -14,   52,       64,  -25,   38,       83,  -35,   25,      103,  -46,   11,
     -28,   26,  110,       -9,   16,   96,       10,    5,   83,       29,   -5,   69,
      48,  -16,   56,       67,  -26,   42,       86,  -37,   29,      105,  -48,   15,
    -104,   74,  -17,      -84,   63,  -31,      -66,   52,  -44,      -47,   41,  -58,
     -27,   30,  -72,       -9,   20,  -85,       10,    9,  -98,       30,   -1, -112,
    -101,   72,  -13,      -82,   61,  -27,      -63,   51,  -40,      -44,   40,  -54,
     -25,   29,  -68,       -6,   19,  -81,       13,    8,  -94,       32,   -2, -108,
     -99,   71,   -9,      -80,   60,  -23,      -61,   49,  -36,      -42,   39,  -50,
     -23,   28,  -64,       -4,   17,  -77,       15,    7,  -90,       34,   -3, -104,
     -96,   69,   -5,      -77,   58,  -19,      -58,   48,  -32,      -39,   37,  -45,
     -20,   26,  -59,       -1,   16,  -73,       18,    5,  -86,       37,   -5, -100,
     -94,   68,   -1,      -74,   57,  -15,      -56,   46,  -28,      -37,   36,  -41,
     -17,   25,  -55,        1,   14,  -69,       20,    4,  -82,       39,   -6,  -96,
     -91,   67,    2,      -72,   56,  -11,      -53,   45,  -24,      -34,   34,  -37,
     -15,   24,  -51,        4,   13,  -65,       22,    2,  -78,       42,   -8,  -92,
     -89,   65,    6,      -70,   54,   -7,      -51,   44,  -20,      -32,   33,  -33,
     -13,   22,  -47,        6,   12,  -61,       25,    1,  -74,       44,   -9,  -88,
     -86,   64,   11,      -67,   53,   -2,      -48,   42,  -15,      -29,   32,  -29,
     -10,   21,  -43,        9,   10,  -56,       28,    0,  -69,       47,  -10,  -83,
     -84,   62,   15,      -65,   51,    1,      -46,   41,  -11,      -27,   30,  -25,
      -8,   19,  -39,       11,    9,  -52,       30,   -1,  -65,       49,  -12,  -79,
     -82,   61,   19,      -62,   50,    5,      -43,   40,   -7,      -25,   29,  -21,
      -5,   18,  -35,       14,    7,  -48,       32,   -2,  -61,       52,  -13,  -75,
     -79,   60,   23,      -60,   49,    9,      -41,   38,   -3,      -22,   28,  -17,
      -3,   17,  -31,       16,    6,  -44,       35,   -4,  -57,       54,  -15,  -71,
     -77,   58,   27,      -57,   47,   13,      -39,   37,    0,      -20,   26,  -13,
       0,   15,  -27,       18,    5,  -40,       37,   -5,  -53,       56,  -16,  -67,
     -74,   57,   31,      -55,   46,   17,      -36,   35,    4,      -17,   25,   -8,
       2,   14,  -22,       21,    3,  -36,       40,   -6,  -49,       59,  -17,  -63,
     -72,   55,   35,      -52,   45,   21,      -34,   34,    8,      -15,   23,   -4,
       5,   12,  -18,       23,    2,  -32,       42,   -8,  -45,       62,  -19,  -59,
     -69,   54,   39,      -50,   43,   25,      -31,   33,   12,      -12,   22,    0,
       7,   11,  -14,       26,    0,  -28,       45,   -9,  -41,       64,  -20,  -55,
     -67,   53,   43,      -48,   42,   29,      -29,   31,   16,      -10,   21,    3,
       9,   10,  -10,       28,    0,  -24,       47,  -10,  -37,       66,  -21,  -51,
     -64,   51,   48,      -45,   40,   34,      -26,   30,   21,       -7,   19,    7,
      12,    8,   -6,       31,   -1,  -19,       50,  -12,  -32,       69,  -23,  -46,
     -62,   50,   52,      -42,   39,   38,      -24,   28,   25,       -5,   18,   11,
      14,    7,   -2,       33,   -3,  -15,       52,  -13,  -28,       71,  -24,  -42,
     -59,   49,   56,      -40,   38,   42,      -21,   27,   29,       -2,   16,   15,
      17,    5,    1,       36,   -4,  -11,       54,  -15,  -24,       74,  -26,  -38,
     -57,   47,   60,      -38,   36,   46,      -19,   26,   33,        0,   15,   19,
      19,    4,    5,       38,   -5,   -7,       57,  -16,  -20,       76,  -27,  -34,
     -54,   46,   64,      -35,   35,   50,      -16,   24,   37,        3,   14,   24,
      22,    3,   10,       41,   -7,   -3,       60,  -18,  -16,       79,  -29,  -30,
     -52,   44,   68,      -33,   33,   54,      -14,   23,   41,        5,   12,   28,
      24,    1,   14,       43,   -8,    0,       62,  -19,  -12,       81,  -30,  -26,
     -50,   43,   72,      -30,   32,   58,      -11,   21,   45,        7,   11,   32,
      27,    0,   18,       46,  -10,    4,       64,  -20,   -8,       84,  -31,  -22,
     -47,   42,   76,      -28,   31,   62,       -9,   20,   49,       10,   10,   36,
      29,    0,   22,       48,  -11,    8,       67,  -22,   -4,       86,  -33,  -18,
     -45,   40,   80,      -25,   29,   66,       -7,   19,   53,       12,    8,   40,
      32,   -2,   26,       50,  -12,   12,       69,  -23,    0,       88,  -34,  -14,
     -42,   39,   85,      -23,   28,   71,       -4,   17,   58,       15,    7,   44,
      34,   -3,   30,       53,  -14,   17,       72,  -25,    4,       91,  -35,   -9,
     -40,   37,   89,      -20,   26,   75,       -2,   16,   62,       17,    5,   48,
      37,   -5,   34,       55,  -15,   21,       74,  -26,    8,       94,  -37,   -5,
     -37,   36,   93,      -18,   25,   79,        1,   15,   66,       20,    4,   52,
      39,   -6,   38,       58,  -17,   25,       77,  -27,   12,       96,  -38,   -1,
     -35,   35,   97,      -16,   24,   83,        3,   13,   70,       22,    3,   56,
      41,   -7,   42,       60,  -18,   29,       79,  -29,   16,       98,  -39,    2,
     -32,   33,  101,      -13,   22,   87,        6,   12,   74,       25,    1,   61,
      44,   -9,   47,       63,  -19,   33,       82,  -30,   20,      101,  -41,    6,
     -30,   32,  105,      -10,   21,   91,        8,   10,   78,       27,    0,   65,
      46,  -10,   51,       65,  -21,   37,       84,  -31,   24,      103,  -42,   10,
     -27,   30,  109,       -8,   20,   95,       11,    9,   82,       30,   -1,   69,
      49,  -12,   55,       68,  -22,   41,       86,  -33,   28,      106,  -44,   14,
    -103,   78,  -18,      -83,   67,  -32,      -64,   56,  -45,      -46,   46,  -59,
     -26,   35,  -72,       -8,   24,  -86,       11,   14,  -99,       31,    3, -113,
    -100,   77,  -14,      -81,   66,  -28,      -62,   55,  -41,      -43,   45,  -55,
     -24,   34,  -68,       -5,   23,  -82,       14,   12,  -95,       33,    1, -109,
     -98,   75,  -10,      -78,   64,  -24,      -60,   54,  -37,      -41,   43,  -51,
     -22,   32,  -64,       -3,   22,  -78,       16,   11,  -91,       35,    0, -105,
     -95,   74,   -5,      -76,   63,  -19,      -57,   52,  -33,      -38,   42,  -46,
     -19,   31,  -60,        0,   20,  -73,       19,   10,  -87,       38,    0, -100,
     -93,   72,   -1,      -73,   62,  -15,      -55,   51,  -29,      -36,   40,  -42,
     -16,   29,  -56,        2,   19,  -69,       21,    8,  -83,       40,   -2,  -96,
     -90,   71,    2,      -71,   60,  -11,      -52,   50,  -25,      -33,   39,  -38,
     -14,   28,  -52,        5,   17,  -65,       23,    7,  -79,       43,   -3,  -92,
     -88,   70,    6,      -69,   59,   -7,      -50,   48,  -21,      -31,   38,  -34,
     -12,   27,  -48,        7,   16,  -61,       26,    5,  -75,       45,   -4,  -88,
     -85,   68,   10,      -66,   57,   -3,      -47,   47,  -16,      -28,   36,  -30,
      -9,   25,  -43,       10,   15,  -57,       29,    4,  -70,       48,   -6,  -84,
     -83,   67,   14,      -64,   56,    0,      -45,   45,  -12,      -26,   35,  -26,
      -7,   24,  -39,       12,   13,  -53,       31,    3,  -66,       50,   -7,  -80,
     -81,   66,   18,      -61,   55,    4,      -42,   44,   -8,      -24,   33,  -22,
      -4,   22,  -35,       15,   12,  -49,       33,    1,  -62,       53,   -9,  -76,
     -78,   64,   22,      -59,   53,    8,      -40,   43,   -4,      -21,   32,  -18,
      -2,   21,  -31,       17,   11,  -45,       36,    0,  -58,       55,  -10,  -72,
     -76,   63,   26,      -56,   52,   12,      -38,   41,    0,      -19,   31,  -14,
       1,   20,  -27,       19,    9,  -41,       38,    0,  -54,       58,  -11,  -68,
     -73,   61,   31,      -54,   50,   17,      -35,   40,    3,      -16,   29,   -9,
       3,   18,  -23,       22,    8,  -36,       41,   -2,  -50,       60,  -13,  -63,
     -71,   60,   35,      -51,   49,   21,      -32,   38,    7,      -14,   28,   -5,
       6,   17,  -19,       24,    6,  -32,       43,   -3,  -46,       63,  -14,  -59,
     -68,   59,   39,      -49,   48,   25,      -30,   37,   11,      -11,   26,   -1,
       8,   16,  -15,       27,    5,  -28,       46,   -5,  -42,       65,  -16,  -55,
     -66,   57,   43,      -46,   46,   29,      -28,   36,   15,       -9,   25,    2,
      10,   14,  -11,       29,    4,  -24,       48,   -6,  -38,       67,  -17,  -51,
     -63,   56,   47,      -44,   45,   33,      -25,   34,   20,       -6,   24,    6,
      13,   13,   -6,       32,    2,  -20,       51,   -8,  -33,       70,  -18,  -47,
     -61,   54,   51,      -41,   43,   37,      -23,   33,   24,       -4,   22,   10,
      16,   11,   -2,       34,    1,  -16,       53,   -9,  -29,       72,  -20,  -43,
     -58,   53,   55,      -39,   42,   41,      -20,   32,   28,       -1,   21,   14,
      18,   10,    1,       37,    0,  -12,       55,  -10,  -25,       75,  -21,  -39,
     -56,   52,   59,      -37,   41,   45,      -18,   30,   32,        1,   20,   18,
      20,    9,    5,       39,   -1,   -8,       58,  -12,  -21,       77,  -22,  -35,
     -53,   50,   64,      -34,   39,   50,      -15,   29,   36,        4,   18,   23,
      23,    7,    9,       42,   -2,   -3,       61,  -13,  -17,       80,  -24,  -30,
     -51,   49,   68,      -32,   38,   54,      -13,   27,   40,        6,   17,   27,
      25,    6,   13,       44,   -4,    0,       63,  -14,  -13,       82,  -25,  -26,
     -49,   47,   72,      -29,   37,   58,      -10,   26,   44,        8,   15,   31,
      28,    4,   17,       47,   -5,    4,       65,  -16,   -9,       85,  -27,  -22,
     -46,   46,   76,      -27,   35,   62,       -8,   25,   48,       11,   14,   35,
      30,    3,   21,       49,   -7,    8,       68,  -17,   -5,       87,  -28,  -18,
     -44,   45,   80,      -24,   34,   66,       -6,   23,   52,       13,   13,   39,
      33,    2,   25,       51,   -8,   12,       70,  -18,   -1,       90,  -29,  -14,
     -41,   43,   84,      -22,   32,   70,       -3,   22,   57,       16,   11,   43,
      35,    0,   30,       54,   -9,   16,       73,  -20,    3,       92,  -31,  -10,
     -39,   42,   88,      -19,   31,   74,       -1,   20,   61,       18,   10,   47,
      38,    0,   34,       56,  -11,   20,       75,  -21,    7,       95,  -32,   -6,
     -36,   41,   92,      -17,   30,   78,        2,   19,   65,       21,    8,   51,
      40,   -1,   38,       59,  -12,   24,       78,  -23,   11,       97,  -34,   -2,
     -34,   39,   96,      -15,   28,   82,        4,   18,   69,       23,    7,   55,
      42,   -3,   42,       61,  -13,   28,       80,  -24,   15,       99,  -35,    1,
     -31,   38,  101,      -12,   27,   87,        7,   16,   73,       26,    6,   60,
      45,   -4,   46,       64,  -15,   33,       83,  -26,   19,      102,  -37,    6,
     -29,   36,  105,       -9,   25,   91,        9,   15,   77,       28,    4,   64,
      48,   -6,   50,       66,  -16,   37,       85,  -27,   23,      104,  -38,   10,
     -26,   35,  109,       -7,   24,   95,       12,   13,   81,       31,    3,   68,
      50,   -7,   54,       69,  -18,   41,       87,  -28,   27,      107,  -39,   14,
    -102,   82,  -19,      -82,   71,  -32,      -64,   60,  -46,      -45,   50,  -59,
     -25,   39,  -73,       -7,   28,  -86,       12,   18, -100,       32,    7, -114,
     -99,   81,  -15,      -80,   70,  -28,      -61,   59,  -42,      -42,   49,  -55,
     -23,   38,  -69,       -4,   27,  -82,       15,   16,  -96,       34,    5, -110,
     -97,   79,  -11,      -78,   68,  -24,      -59,   58,  -38,      -40,   47,  -51,
     -21,   36,  -65,       -2,   26,  -78,       17,   15,  -92,       36,    4, -106,
     -94,   78,   -6,      -75,   67,  -20,      -56,   56,  -33,      -37,   46,  -47,
     -18,   35,  -61,        1,   24,  -74,       20,   14,  -87,       39,    3, -101,
     -92,   76,   -2,      -72,   66,  -16,      -54,   55,  -29,      -35,   44,  -43,
     -16,   33,  -57,        3,   23,  -70,       22,   12,  -83,       41,    1,  -97,
     -89,   75,    1,      -70,   64,  -12,      -51,   54,  -25,      -33,   43,  -39,
     -13,   32,  -53,        6,   21,  -66,       24,   11,  -79,       44,    0,  -93,
     -87,   74,    5,      -68,   63,   -8,      -49,   52,  -21,      -30,   42,  -35,
     -11,   31,  -49,        8,   20,  -62,       27,    9,  -75,       46,    0,  -89,
     -84,   72,    9,      -65,   61,   -3,      -46,   51,  -17,      -27,   40,  -30,
      -8,   29,  -44,       11,   19,  -57,       29,    8,  -71,       49,   -2,  -85,
     -82,   71,   13,      -63,   60,    0,      -44,   49,  -13,      -25,   39,  -26,
      -6,   28,  -40,       13,   17,  -53,       32,    7,  -67,       51,   -3,  -81,
     -80,   70,   17,      -60,   59,    4,      -41,   48,   -9,      -23,   37,  -22,
      -3,   26,  -36,       15,   16,  -49,       34,    5,  -63,       54,   -5,  -77,
     -77,   68,   21,      -58,   57,    8,      -39,   47,   -5,      -20,   36,  -18,
      -1,   25,  -32,       18,   15,  -45,       37,    4,  -59,       56,   -6,  -73,
     -75,   67,   25,      -55,   56,   12,      -37,   45,   -1,      -18,   35,  -14,
       1,   24,  -28,       20,   13,  -41,       39,    3,  -55,       58,   -7,  -69,
     -72,   65,   30,      -53,   54,   16,      -34,   44,    3,      -15,   33,  -10,
       4,   22,  -24,       23,   12,  -37,       42,    1,  -50,       61,   -9,  -64,
     -70,   64,   34,      -50,   53,   20,      -32,   42,    7,      -13,   32,   -6,
       7,   21,  -20,       25,   10,  -33,       44,    0,  -46,       64,  -10,  -60,
     -67,   63,   38,      -48,   52,   24,      -29,   41,   11,      -10,   30,   -2,
       9,   20,  -16,       28,    9,  -29,       47,   -1,  -42,       66,  -12,  -56,
     -65,   61,   42,      -46,   50,   28,      -27,   40,   15,       -8,   29,    1,
      11,   18,  -12,       30,    8,  -25,       49,   -2,  -38,       68,  -13,  -52,
     -62,   60,   46,      -43,   49,   33,      -24,   38,   19,       -5,   28,    6,
      14,   17,   -7,       33,    6,  -20,       52,   -4,  -34,       71,  -14,  -48,
     -60,   58,   50,      -41,   47,   37,      -22,   37,   23,       -3,   26,   10,
      16,   15,   -3,       35,    5,  -16,       54,   -5,  -30,       73,  -16,  -44,
     -57,   57,   54,      -38,   46,   41,      -19,   36,   27,       -1,   25,   14,
      19,   14,    0,       38,    3,  -12,       56,   -6,  -26,       76,  -17,  -40,
     -55,   56,   58,      -36,   45,   45,      -17,   34,   31,        2,   24,   18,
      21,   13,    4,       40,    2,   -8,       59,   -8,  -22,       78,  -18,  -36,
     -52,   54,   63,      -33,   43,   49,      -14,   33,   36,        5,   22,   22,
      24,   11,    8,       43,    1,   -4,       61,   -9,  -17,       81,  -20,  -31,
     -50,   53,   67,      -31,   42,   53,      -12,   31,   40,        7,   21,   26,
      26,   10,   12,       45,    0,    0,       64,  -10,  -13,       83,  -21,  -27,
     -48,   51,   71,      -28,   41,   57,       -9,   30,   44,        9,   19,   30,
      29,    8,   16,       47,   -1,    3,       66,  -12,   -9,       86,  -23,  -23,
     -45,   50,   75,      -26,   39,   61,       -7,   29,   48,       12,   18,   34,
      31,    7,   20,       50,   -3,    7,       69,  -13,   -5,       88,  -24,  -19,
     -43,   49,   79,      -23,   38,   65,       -5,   27,   52,       14,   17,   38,
      33,    6,   24,       52,   -4,   11,       71,  -14,   -1,       90,  -25,  -15,
     -40,   47,   83,      -21,   36,   70,       -2,   26,   56,       17,   15,   43,
      36,    4,   29,       55,   -5,   16,       74,  -16,    2,       93,  -27,  -11,
     -38,   46,   87,      -18,   35,   74,        0,   24,   60,       19,   14,   47,
      39,    3,   33,       57,   -7,   20,       76,  -17,    6,       96,  -28,   -7,
     -35,   45,   91,      -16,   34,   78,        3,   23,   64,       22,   12,   51,
      41,    2,   37,       60,   -8,   24,       79,  -19,   10,       98,  -30,   -3,
     -33,   43,   95,      -14,   32,   82,        5,   22,   68,       24,   11,   55,
      43,    0,   41,       62,   -9,   28,       81,  -20,   14,      100,  -31,    0,
     -30,   42,  100,      -11,   31,   86,        8,   20,   73,       27,   10,   59,
      46,    0,   45,       65,  -11,   32,       84,  -22,   19,      103,  -33,    5,
     -28,   40,  104,       -9,   29,   90,       10,   19,   77,       29,    8,   63,
      48,   -2,   49,       67,  -12,   36,       86,  -23,   23,      105,  -34,    9,
     -25,   39,  108,       -6,   28,   94,       13,   17,   81,       31,    7,   67,
      51,   -3,   53,       70,  -14,   40,       88,  -24,   27,      108,  -35,   13,
    -101,   86,  -19,      -81,   75,  -33,      -63,   64,  -46,      -44,   54,  -60,
     -25,   43,  -74,       -6,   32,  -87,       13,   22, -100,       32,   11, -114,
     -98,   85,  -15,      -79,   74,  -29,      -60,   63,  -42,      -41,   53,  -56,
     -22,   42,  -70,       -3,   31,  -83,       15,   20,  -96,       35,    9, -110,
     -96,   83,  -11,      -77,   72,  -25,      -58,   62,  -38,      -39,   51,  -52,
     -20,   40,  -66,       -1,   30,  -79,       18,   19,  -92,       37,    8, -106,
     -93,   82,   -7,      -74,   71,  -21,      -55,   60,  -34,      -36,   50,  -47,
     -17,   39,  -61,        2,   28,  -75,       21,   18,  -88,       40,    7, -102,
     -91,   80,   -3,      -72,   70,  -17,      -53,   59,  -30,      -34,   48,  -43,
     -15,   37,  -57,        4,   27,  -71,       23,   16,  -84,       42,    5,  -98,
     -89,   79,    0,      -69,   68,  -13,      -50,   58,  -26,      -32,   47,  -39,
     -12,   36,  -53,        7,   25,  -67,       25,   15,  -80,       45,    4,  -94,
     -86,   78,    4,      -67,   67,   -9,      -48,   56,  -22,      -29,   46,  -35,
     -10,   35,  -49,        9,   24,  -63,       28,   13,  -76,       47,    3,  -90,
     -83,   76,    9,      -64,   65,   -4,      -45,   55,  -17,      -27,   44,  -31,
      -7,   33,  -45,       12,   23,  -58,       30,   12,  -71,       50,    1,  -85,
     -81,   75,   13,      -62,   64,    0,      -43,   53,  -13,      -24,   43,  -27,
      -5,   32,  -41,       14,   21,  -54,       33,   11,  -67,       52,    0,  -81,
     -79,   74,   17,      -59,   63,    3,      -41,   52,   -9,      -22,   41,  -23,
      -2,   30,  -37,       16,   20,  -50,       35,    9,  -63,       55,   -1,  -77,
     -76,   72,   21,      -57,   61,    7,      -38,   51,   -5,      -19,   40,  -19,
       0,   29,  -33,       19,   19,  -46,       38,    8,  -59,       57,   -2,  -73,
     -74,   71,   25,      -55,   60,   11,      -36,   49,   -1,      -17,   39,  -15,
       2,   28,  -29,       21,   17,  -42,       40,    7,  -55,       59,   -3,  -69,
     -71,   69,   29,      -52,   58,   15,      -33,   48,    2,      -14,   37,  -10,
       5,   26,  -24,       24,   16,  -38,       43,    5,  -51,       62,   -5,  -65,
     -69,   68,   33,      -49,   57,   19,      -31,   46,    6,      -12,   36,   -6,
       7,   25,  -20,       26,   14,  -34,       45,    4,  -47,       64,   -6,  -61,
     -66,   67,   37,      -47,   56,   23,      -28,   45,   10,       -9,   34,   -2,
      10,   24,  -16,       29,   13,  -30,       47,    2,  -43,       67,   -8,  -57,
     -64,   65,   41,      -45,   54,   27,      -26,   44,   14,       -7,   33,    1,
      12,   22,  -12,       31,   12,  -26,       50,    1,  -39,       69,   -9,  -53,
     -61,   64,   46,      -42,   53,   32,      -23,   42,   19,       -4,   32,    5,
      15,   21,   -8,       34,   10,  -21,       53,    0,  -34,       72,  -10,  -48,
     -59,   62,   50,      -40,   51,   36,      -21,   41,   23,       -2,   30,    9,
      17,   19,   -4,       36,    9,  -17,       55,   -1,  -30,       74,  -12,  -44,
     -57,   61,   54,      -37,   50,   40,      -18,   40,   27,        0,   29,   13,
      20,   18,    0,       39,    7,  -13,       57,   -2,  -26,       77,  -13,  -40,
     -54,   60,   58,      -35,   49,   44,      -16,   38,   31,        3,   28,   17,
      22,   17,    3,       41,    6,   -9,       60,   -4,  -22,       79,  -14,  -36,
     -51,   58,   62,      -32,   47,   48,      -13,   37,   35,        5,   26,   22,
      25,   15,    8,       44,    5,   -5,       62,   -5,  -18,       82,  -16,  -32,
     -49,   57,   66,      -30,   46,   52,      -11,   35,   39,        8,   25,   26,
      27,   14,   12,       46,    3,   -1,       65,   -6,  -14,       84,  -17,  -28,
     -47,   55,   70,      -27,   45,   56,       -9,   34,   43,       10,   23,   30,
      30,   12,   16,       48,    2,    2,       67,   -8,  -10,       87,  -19,  -24,
     -44,   54,   74,      -25,   43,   60,       -6,   33,   47,       13,   22,   34,
      32,   11,   20,       51,    0,    6,       70,   -9,   -6,       89,  -20,  -20,
     -42,   53,   78,      -23,   42,   64,       -4,   31,   51,       15,   21,   38,
      34,   10,   24,       53,    0,   10,       72,  -10,   -2,       91,  -21,  -16,
     -39,   51,   83,      -20,   40,   69,       -1,   30,   56,       18,   19,   42,
      37,    8,   28,       56,   -1,   15,       75,  -12,    2,       94,  -23,  -11,
     -37,   50,   87,      -17,   39,   73,        1,   28,   60,       20,   18,   46,
      39,    7,   32,       58,   -3,   19,       77,  -13,    6,       96,  -24,   -7,
     -34,   49,   91,      -15,   38,   77,        4,   27,   64,       22,   16,   50,
      42,    6,   36,       61,   -4,   23,       79,  -15,   10,       99,  -26,   -3,
     -32,   47,   95,      -13,   36,   81,        6,   26,   68,       25,   15,   54,
      44,    4,   40,       63,   -5,   27,       82,  -16,   14,      101,  -27,    0,
     -29,   46,   99,      -10,   35,   85,        9,   24,   72,       28,   14,   59,
      47,    3,   45,       66,   -7,   31,       85,  -18,   18,      104,  -29,    4,
     -27,   44,  103,       -8,   33,   89,       11,   23,   76,       30,   12,   63,
      49,    1,   49,       68,   -8,   35,       87,  -19,   22,      106,  -30,    8,
     -25,   43,  107,       -5,   32,   93,       14,   21,   80,       32,   11,   67,
      52,    0,   53,       71,  -10,   39,       89,  -20,   26,      109,  -31,   12,
    -100,   90,  -20,      -81,   79,  -34,      -62,   68,  -47,      -43,   58,  -61,
     -24,   47,  -74,       -5,   36,  -88,       14,   26, -101,       33,   15, -115,
     -98,   89,  -16,      -78,   78,  -30,      -59,   67,  -43,      -41,   57,  -57,
     -21,   46,  -70,       -2,   35,  -84,       16,   24,  -97,       36,   13, -111,
     -95,   87,  -12,      -76,   76,  -26,      -57,   66,  -39,      -38,   55,  -53,
     -19,   44,  -66,        0,   34,  -80,       19,   23,  -93,       38,   12, -107,
     -92,   86,   -7,      -73,   75,  -21,      -54,   64,  -35,      -35,   54,  -48,
     -16,   43,  -62,        3,   32,  -75,       21,   22,  -89,       41,   11, -102,
     -90,   84,   -3,      -71,   74,  -17,      -52,   63,  -31,      -33,   52,  -44,
     -14,   41,  -58,        5,   31,  -71,       24,   20,  -85,       43,    9,  -98,
     -88,   83,    0,      -68,   72,  -13,      -49,   62,  -27,      -31,   51,  -40,
     -11,   40,  -54,        7,   29,  -67,       26,   19,  -81,       46,    8,  -94,
     -85,   82,    4,      -66,   71,   -9,      -47,   60,  -23,      -28,   50,  -36,
      -9,   39,  -50,       10,   28,  -63,       29,   17,  -77,       48,    7,  -90,
     -83,   80,    8,      -63,   69,   -5,      -44,   59,  -18,      -26,   48,  -32,
      -6,   37,  -45,       13,   27,  -59,       31,   16,  -72,       51,    5,  -86,
     -80,   79,   12,      -61,   68,   -1,      -42,   57,  -14,      -23,   47,  -28,
      -4,   36,  -41,       15,   25,  -55,       34,   15,  -68,       53,    4,  -82,
     -78,   78,   16,      -58,   67,    2,      -40,   56,  -10,      -21,   45,  -24,
      -1,   34,  -37,       17,   24,  -51,       36,   13,  -64,       55,    2,  -78,
     -75,   76,   20,      -56,   65,    6,      -37,   55,   -6,      -18,   44,  -20,
       1,   33,  -33,       20,   23,  -47,       38,   12,  -60,       58,    1,  -74,
     -73,   75,   24,      -54,   64,   10,      -35,   53,   -2,      -16,   43,  -16,
       3,   32,  -29,       22,   21,  -43,       41,   11,  -56,       60,    0,  -70,
     -70,   73,   29,      -51,   62,   15,      -32,   52,    1,      -13,   41,  -11,
       6,   30,  -25,       25,   20,  -38,       44,    9,  -52,       63,   -1,  -65,
     -68,   72,   33,      -49,   61,   19,      -30,   50,    5,      -11,   40,   -7,
       8,   29,  -21,       27,   18,  -34,       46,    8,  -48,       65,   -2,  -61,
     -66,   71,   37,      -46,   60,   23,      -27,   49,    9,       -9,   38,   -3,
      11,   28,  -17,       30,   17,  -30,       48,    6,  -44,       68,   -4,  -57,
     -63,   69,   41,      -44,   58,   27,      -25,   48,   13,       -6,   37,    0,
      13,   26,  -13,       32,   16,  -26,       51,    5,  -40,       70,   -5,  -53,
     -60,   68,   45,      -41,   57,   31,      -22,   46,   18,       -4,   36,    4,
      16,   25,   -8,       35,   14,  -22,       53,    3,  -35,       73,   -6,  -49,
     -58,   66,   49,      -39,   55,   35,      -20,   45,   22,       -1,   34,    8,
      18,   23,   -4,       37,   13,  -18,       56,    2,  -31,       75,   -8,  -45,
     -56,   65,   53,      -36,   54,   39,      -18,   44,   26,        1,   33,   12,
      21,   22,    0,       39,   11,  -14,       58,    1,  -27,       78,   -9,  -41,
     -53,   64,   57,      -34,   53,   43,      -15,   42,   30,        4,   32,   16,
      23,   21,    3,       42,   10,  -10,       61,    0,  -23,       80,  -10,  -37,
     -51,   62,   62,      -31,   51,   48,      -12,   41,   34,        6,   30,   21,
      26,   19,    7,       45,    9,   -5,       63,   -1,  -19,       83,  -12,  -32,
     -48,   61,   66,      -29,   50,   52,      -10,   39,   38,        9,   29,   25,
      28,   18,   11,       47,    7,   -1,       66,   -2,  -15,       85,  -13,  -28,
     -46,   59,   70,      -26,   49,   56,       -8,   38,   42,       11,   27,   29,
      31,   16,   15,       49,    6,    2,       68,   -4,  -11,       87,  -15,  -24,
     -43,   58,   74,      -24,   47,   60,       -5,   37,   46,       14,   26,   33,
      33,   15,   19,       52,    4,    6,       70,   -5,   -7,       90,  -16,  -20,
     -41,   57,   78,      -22,   46,   64,       -3,   35,   50,       16,   25,   37,
      35,   14,   23,       54,    3,   10,       73,   -6,   -3,       92,  -17,  -16,
     -38,   55,   82,      -19,   44,   68,        0,   34,   55,       19,   23,   41,
      38,   12,   28,       57,    2,   14,       76,   -8,    1,       95,  -19,  -12,
     -36,   54,   86,      -17,   43,   72,        2,   32,   59,       21,   22,   45,
      40,   11,   32,       59,    0,   18,       78,   -9,    5,       97,  -20,   -8,
     -34,   53,   90,      -14,   42,   76,        5,   31,   63,       23,   20,   49,
      43,   10,   36,       62,    0,   22,       80,  -11,    9,      100,  -22,   -4,
     -31,   51,   94,      -12,   40,   80,        7,   30,   67,       26,   19,   53,
      45,    8,   40,       64,   -1,   26,       83,  -12,   13,      102,  -23,    0,
     -28,   50,   99,       -9,   39,   85,       10,   28,   71,       28,   18,   58,
      48,    7,   44,       67,   -3,   31,       85,  -14,   17,      105,  -25,    4,
     -26,   48,  103,       -7,   37,   89,       12,   27,   75,       31,   16,   62,
      50,    5,   48,       69,   -4,   35,       88,  -15,   21,      107,  -26,    8,
     -24,   47,  107,       -4,   36,   93,       14,   25,   79,       33,   15,   66,
      53,    4,   52,       71,   -6,   39,       90,  -16,   25,      110,  -27,   12,
     -99,   94,  -21,      -80,   83,  -34,      -61,   72,  -48,      -42,   62,  -61,
     -23,   51,  -75,       -4,   40,  -88,       15,   30, -102,       34,   19, -116,
     -97,   93,  -17,      -77,   82,  -30,      -58,   71,  -44,      -40,   61,  -57,
     -20,   50,  -71,       -2,   39,  -84,       17,   28,  -98,       37,   17, -112,
     -94,   91,  -13,      -75,   80,  -26,      -56,   70,  -40,      -37,   59,  -53,
     -18,   48,  -67,        1,   38,  -80,       20,   27,  -94,       39,   16, -108,
     -92,   90,   -8,      -72,   79,  -22,      -53,   68,  -35,      -35,   58,  -49,
     -15,   47,  -62,        4,   36,  -76,       22,   26,  -89,       42,   15, -103,
     -89,   88,   -4,      -70,   78,  -18,      -51,   67,  -31,      -32,   56,  -45,
     -13,   45,  -58,        6,   35,  -72,       25,   24,  -85,       44,   13,  -99,
     -87,   87,    0,      -67,   76,  -14,      -49,   66,  -27,      -30,   55,  -41,
     -10,   44,  -54,        8,   33,  -68,       27,   23,  -81,       47,   12,  -95,
     -84,   86,    3,      -65,   75,  -10,      -46,   64,  -23,      -27,   54,  -37,
      -8,   43,  -50,       11,   32,  -64,       30,   21,  -77,       49,   11,  -91,
     -82,   84,    7,      -62,   73,   -5,      -44,   63,  -19,      -25,   52,  -32,
      -5,   41,  -46,       13,   31,  -59,       32,   20,  -73,       52,    9,  -87,
     -79,   83,   11,      -60,   72,   -1,      -41,   61,  -15,      -22,   51,  -28,
      -3,   40,  -42,       16,   29,  -55,       35,   19,  -69,       54,    8,  -83,
     -77,   82,   15,      -58,   71,    2,      -39,   60,  -11,      -20,   49,  -24,
      -1,   38,  -38,       18,   28,  -51,       37,   17,  -65,       56,    6,  -79,
     -74,   80,   19,      -55,   69,    6,      -36,   59,   -7,      -18,   48,  -20,
       2,   37,  -34,       21,   27,  -47,       39,   16,  -61,       59,    5,  -75,
     -72,   79,   23,      -53,   68,   10,      -34,   57,   -3,      -15,   47,  -16,
       4,   36,  -30,       23,   25,  -43,       42,   15,  -57,       61,    4,  -71,
     -69,   77,   28,      -50,   66,   14,      -31,   56,    1,      -12,   45,  -12,
       7,   34,  -25,       26,   24,  -39,       44,   13,  -52,       64,    2,  -66,
     -67,   76,   32,      -48,   65,   18,      -29,   54,    5,      -10,   44,   -8,
       9,   33,  -21,       28,   22,  -35,       47,   12,  -48,       66,    1,  -62,
     -65,   75,   36,      -45,   64,   22,      -26,   53,    9,       -8,   42,   -4,
      12,   32,  -17,       30,   21,  -31,       49,   10,  -44,       69,    0,  -58,
     -62,   73,   40,      -43,   62,   26,      -24,   52,   13,       -5,   41,    0,
      14,   30,  -13,       33,   20,  -27,       52,    9,  -40,       71,   -1,  -54,
     -60,   72,   44,      -40,   61,   31,      -21,   50,   17,       -3,   40,    4,
      17,   29,   -9,       36,   18,  -22,       54,    7,  -36,       74,   -2,  -50,
     -57,   70,   48,      -38,   59,   35,      -19,   49,   21,        0,   38,    8,
      19,   27,   -5,       38,   17,  -18,       57,    6,  -32,       76,   -4,  -46,
     -55,   69,   52,      -35,   58,   39,      -17,   48,   25,        2,   37,   12,
      22,   26,   -1,       40,   15,  -14,       59,    5,  -28,       79,   -5,  -42,
     -52,   68,   56,      -33,   57,   43,      -14,   46,   29,        5,   36,   16,
      24,   25,    2,       43,   14,  -10,       62,    3,  -24,       81,   -6,  -38,
     -50,   66,   61,      -30,   55,   47,      -12,   45,   34,        7,   34,   20,
      27,   23,    7,       45,   13,   -6,       64,    2,  -19,       84,   -8,  -33,
     -47,   65,   65,      -28,   54,   51,       -9,   43,   38,       10,   33,   24,
      29,   22,   11,       48,   11,   -2,       67,    1,  -15,       86,   -9,  -29,
     -45,   63,   69,      -26,   53,   55,       -7,   42,   42,       12,   31,   28,
      31,   20,   15,       50,   10,    1,       69,    0,  -11,       88,  -11,  -25,
     -42,   62,   73,      -23,   51,   59,       -4,   41,   46,       14,   30,   32,
      34,   19,   19,       53,    8,    5,       71,   -1,   -7,       91,  -12,  -21,
     -40,   61,   77,      -21,   50,   63,       -2,   39,   50,       17,   29,   36,
      36,   18,   23,       55,    7,    9,       74,   -2,   -3,       93,  -13,  -17,
     -37,   59,   81,      -18,   48,   68,        1,   38,   54,       20,   27,   41,
      39,   16,   27,       58,    6,   14,       76,   -4,    0,       96,  -15,  -13,
     -35,   58,   85,      -16,   47,   72,        3,   36,   58,       22,   26,   45,
      41,   15,   31,       60,    4,   18,       79,   -5,    4,       98,  -16,   -9,
     -33,   57,   89,      -13,   46,   76,        6,   35,   62,       24,   24,   49,
      44,   14,   35,       62,    3,   22,       81,   -7,    8,      101,  -18,   -5,
     -30,   55,   93,      -11,   44,   80,        8,   34,   66,       27,   23,   53,
      46,   12,   39,       65,    2,   26,       84,   -8,   12,      103,  -19,   -1,
     -28,   54,   98,       -8,   43,   84,       11,   32,   71,       29,   22,   57,
      49,   11,   44,       68,    0,   30,       86,  -10,   17,      106,  -21,    3,
     -25,   52,  102,       -6,   41,   88,       13,   31,   75,       32,   20,   61,
      51,    9,   48,       70,    0,   34,       89,  -11,   21,      108,  -22,    7,
     -23,   51,  106,       -3,   40,   92,       15,   29,   79,       34,   19,   65,
      54,    8,   52,       72,   -2,   38,       91,  -12,   25,      110,  -23,   11,
     -98,   99,  -21,      -79,   88,  -35,      -60,   77,  -48,      -41,   66,  -62,
     -22,   55,  -76,       -3,   45,  -89,       16,   34, -103,       35,   23, -116,
     -96,   97,  -17,      -76,   86,  -31,      -57,   76,  -44,      -39,   65,  -58,
     -19,   54,  -72,        0,   44,  -85,       18,   33,  -99,       38,   22, -112,
     -93,   96,  -13,      -74,   85,  -27,      -55,   74,  -40,      -36,   64,  -54,
     -17,   53,  -68,        2,   42,  -81,       21,   32,  -95,       40,   21, -108,
     -90,   94,   -9,      -71,   83,  -23,      -52,   73,  -36,      -34,   62,  -49,
     -14,   51,  -63,        5,   41,  -77,       23,   30,  -90,       43,   19, -104,
     -88,   93,   -5,      -69,   82,  -19,      -50,   71,  -32,      -31,   61,  -45,
     -12,   50,  -59,        7,   39,  -73,       26,   29,  -86,       45,   18, -100,
     -86,   92,   -1,      -66,   81,  -15,      -48,   70,  -28,      -29,   59,  -41,
      -9,   49,  -55,        9,   38,  -69,       28,   27,  -82,       48,   16,  -96,
     -83,   90,    2,      -64,   79,  -11,      -45,   69,  -24,      -26,   58,  -37,
      -7,   47,  -51,       12,   37,  -65,       31,   26,  -78,       50,   15,  -92,
     -81,   89,    7,      -61,   78,   -6,      -42,   67,  -19,      -24,   57,  -33,
      -4,   46,  -47,       14,   35,  -60,       33,   24,  -74,       53,   14,  -87,
     -78,   87,   11,      -59,   76,   -2,      -40,   66,  -15,      -21,   55,  -29,
      -2,   44,  -43,       17,   34,  -56,       36,   23,  -70,       55,   12,  -83,
     -76,   86,   15,      -56,   75,    1,      -38,   65,  -11,      -19,   54,  -25,
       0,   43,  -39,       19,   32,  -52,       38,   22,  -66,       57,   11,  -79,
     -73,   85,   19,      -54,   74,    5,      -35,   63,   -7,      -17,   53,  -21,
       3,   42,  -35,       22,   31,  -48,       40,   20,  -62,       60,    9,  -75,
     -71,   83,   23,      -52,   72,    9,      -33,   62,   -3,      -14,   51,  -17,
       5,   40,  -31,       24,   30,  -44,       43,   19,  -58,       62,    8,  -71,
     -68,   82,   27,      -49,   71,   13,      -30,   60,    0,      -11,   50,  -12,
       8,   39,  -26,       27,   28,  -40,       46,   18,  -53,       65,    7,  -67,
     -66,   80,   31,      -47,   70,   17,      -28,   59,    4,       -9,   48,   -8,
      10,   37,  -22,       29,   27,  -36,       48,   16,  -49,       67,    5,  -63,
     -64,   79,   35,      -44,   68,   21,      -25,   58,    8,       -7,   47,   -4,
      13,   36,  -18,       32,   25,  -32,       50,   15,  -45,       70,    4,  -59,
     -61,   78,   39,      -42,   67,   25,      -23,   56,   12,       -4,   46,    0,
      15,   35,  -14,       34,   24,  -28,       53,   14,  -41,       72,    3,  -55,
     -59,   76,   44,      -39,   65,   30,      -20,   55,   17,       -2,   44,    3,
      18,   33,  -10,       37,   23,  -23,       55,   12,  -37,       75,    1,  -50,
     -56,   75,   48,      -37,   64,   34,      -18,   53,   21,        1,   43,    7,
      20,   32,   -6,       39,   21,  -19,       58,   11,  -33,       77,    0,  -46,
     -54,   74,   52,      -34,   63,   38,      -16,   52,   25,        3,   41,   11,
      23,   30,   -2,       41,   20,  -15,       60,    9,  -29,       80,   -1,  -42,
     -51,   72,   56,      -32,   61,   42,      -13,   51,   29,        6,   40,   15,
      25,   29,    1,       44,   19,  -11,       63,    8,  -25,       82,   -2,  -38,
     -49,   71,   60,      -29,   60,   46,      -10,   49,   33,        8,   39,   20,
      28,   28,    6,       46,   17,   -7,       65,    6,  -20,       85,   -4,  -34,
     -46,   69,   64,      -27,   58,   50,       -8,   48,   37,       11,   37,   24,
      30,   26,   10,       49,   16,   -3,       68,    5,  -16,       87,   -5,  -30,
     -44,   68,   68,      -24,   57,   54,       -6,   46,   41,       13,   36,   28,
      32,   25,   14,       51,   14,    0,       70,    4,  -12,       89,   -6,  -26,
     -41,   67,   72,      -22,   56,   58,       -3,   45,   45,       15,   35,   32,
      35,   24,   18,       54,   13,    4,       72,    2,   -8,       92,   -8,  -22,
     -39,   65,   76,      -20,   54,   62,       -1,   44,   49,       18,   33,   36,
      37,   22,   22,       56,   12,    8,       75,    1,   -4,       94,   -9,  -18,
     -36,   64,   81,      -17,   53,   67,        2,   42,   54,       21,   32,   40,
      40,   21,   26,       59,   10,   13,       78,    0,    0,       97,  -10,  -13,
     -34,   62,   85,      -15,   51,   71,        4,   41,   58,       23,   30,   44,
      42,   19,   30,       61,    9,   17,       80,   -1,    3,       99,  -12,   -9,
     -32,   61,   89,      -12,   50,   75,        7,   40,   62,       25,   29,   48,
      45,   18,   34,       64,    7,   21,       82,   -2,    7,      102,  -13,   -5,
     -29,   60,   93,      -10,   49,   79,        9,   38,   66,       28,   28,   52,
      47,   17,   38,       66,    6,   25,       85,   -4,   11,      104,  -14,   -1,
     -27,   58,   97,       -7,   47,   83,       12,   37,   70,       30,   26,   57,
      50,   15,   43,       69,    5,   29,       87,   -5,   16,      107,  -16,    2,
     -24,   57,  101,       -5,   46,   87,       14,   35,   74,       33,   25,   61,
      52,   14,   47,       71,    3,   33,       90,   -6,   20,      109,  -17,    6,
     -22,   55,  105,       -2,   45,   91,       16,   34,   78,       35,   23,   65,
      55,   12,   51,       73,    2,   37,       92,   -8,   24,      112,  -19,   10,
     -97,  103,  -22,      -78,   92,  -36,      -59,   81,  -49,      -40,   70,  -63,
     -21,   59,  -76,       -2,   49,  -90,       17,   38, -103,       36,   27, -117,
     -95,  101,  -18,      -75,   90,  -32,      -57,   80,  -45,      -38,   69,  -59,
     -18,   58,  -72,        0,   48,  -86,       19,   37,  -99,       39,   26, -113,
     -92,  100,  -14,      -73,   89,  -28,      -54,   78,  -41,      -35,   68,  -55,
     -16,   57,  -68,        3,   46,  -82,       22,   36,  -95,       41,   25, -109,
     -90,   98,   -9,      -70,   87,  -23,      -51,   77,  -37,      -33,   66,  -50,
     -13,   55,  -64,        6,   45,  -77,       24,   34,  -91,       44,   23, -104,
     -87,   97,   -5,      -68,   86,  -19,      -49,   75,  -33,      -30,   65,  -46,
     -11,   54,  -60,        8,   43,  -73,       27,   33,  -87,       46,   22, -100,
     -85,   96,   -1,      -65,   85,  -15,      -47,   74,  -29,      -28,   63,  -42,
      -8,   53,  -56,       10,   42,  -69,       29,   31,  -83,       48,   20,  -96,
     -82,   94,    2,      -63,   83,  -11,      -44,   73,  -25,      -25,   62,  -38,
      -6,   51,  -52,       13,   41,  -65,       31,   30,  -79,       51,   19,  -92,
     -80,   93,    6,      -60,   82,   -7,      -42,   71,  -20,      -23,   61,  -34,
      -3,   50,  -47,       15,   39,  -61,       34,   28,  -74,       54,   18,  -88,
     -77,   91,   10,      -58,   80,   -3,      -39,   70,  -16,      -20,   59,  -30,
      -1,   48,  -43,       18,   38,  -57,       37,   27,  -70,       56,   16,  -84,
     -75,   90,   14,      -56,   79,    0,      -37,   69,  -12,      -18,   58,  -26,
       1,   47,  -39,       20,   36,  -53,       39,   26,  -66,       58,   15,  -80,
     -73,   89,   18,      -53,   78,    4,      -34,   67,   -8,      -16,   57,  -22,
       4,   46,  -35,       23,   35,  -49,       41,   24,  -62,       61,   13,  -76,
     -70,   87,   22,      -51,   76,    8,      -32,   66,   -4,      -13,   55,  -18,
       6,   44,  -31,       25,   34,  -45,       44,   23,  -58,       63,   12,  -72,
     -67,   86,   27,      -48,   75,   13,      -29,   64,    0,      -11,   54,  -13,
       9,   43,  -27,       28,   32,  -40,       46,   22,  -54,       66,   11,  -67,
     -65,   84,   31,      -46,   74,   17,      -27,   63,    3,       -8,   52,   -9,
      11,   41,  -23,       30,   31,  -36,       49,   20,  -50,       68,    9,  -63,
     -63,   83,   35,      -43,   72,   21,      -25,   62,    7,       -6,   51,   -5,
      14,   40,  -19,       32,   29,  -32,       51,   19,  -46,       71,    8,  -59,
     -60,   82,   39,      -41,   71,   25,      -22,   60,   11,       -3,   50,   -1,
      16,   39,  -15,       35,   28,  -28,       54,   18,  -42,       73,    7,  -55,
     -58,   80,   43,      -38,   69,   29,      -19,   59,   16,       -1,   48,    2,
      19,   37,  -10,       38,   27,  -24,       56,   16,  -37,       76,    5,  -51,
     -55,   79,   47,      -36,   68,   33,      -17,   57,   20,        2,   47,    6,
      21,   36,   -6,       40,   25,  -20,       59,   15,  -33,       78,    4,  -47,
     -53,   78,   51,      -33,   67,   37,      -15,   56,   24,        4,   45,   10,
      24,   34,   -2,       42,   24,  -16,       61,   13,  -29,       80,    2,  -43,
     -50,   76,   55,      -31,   65,   41,      -12,   55,   28,        7,   44,   14,
      26,   33,    1,       45,   23,  -12,       63,   12,  -25,       83,    1,  -39,
     -48,   75,   60,      -28,   64,   46,      -10,   53,   32,        9,   43,   19,
      29,   32,    5,       47,   21,   -7,       66,   10,  -21,       86,    0,  -34,
     -45,   73,   64,      -26,   62,   50,       -7,   52,   36,       12,   41,   23,
      31,   30,    9,       50,   20,   -3,       69,    9,  -17,       88,   -1,  -30,
     -43,   72,   68,      -24,   61,   54,       -5,   50,   40,       14,   40,   27,
      33,   29,   13,       52,   18,    0,       71,    8,  -13,       90,   -2,  -26,
     -41,   71,   72,      -21,   60,   58,       -2,   49,   44,       16,   39,   31,
      36,   28,   17,       55,   17,    4,       73,    6,   -9,       93,   -4,  -22,
     -38,   69,   76,      -19,   58,   62,        0,   48,   48,       19,   37,   35,
      38,   26,   21,       57,   16,    8,       76,    5,   -5,       95,   -5,  -18,
     -35,   68,   80,      -16,   57,   66,        3,   46,   53,       21,   36,   39,
      41,   25,   26,       60,   14,   12,       78,    4,    0,       98,   -6,  -14,
     -33,   66,   84,      -14,   55,   70,        5,   45,   57,       24,   34,   43,
      43,   23,   30,       62,   13,   16,       81,    2,    3,      100,   -8,  -10,
     -31,   65,   88,      -11,   54,   74,        7,   44,   61,       26,   33,   47,
      46,   22,   34,       64,   11,   20,       83,    1,    7,      103,   -9,   -6,
     -28,   64,   92,       -9,   53,   78,       10,   42,   65,       29,   32,   51,
      48,   21,   38,       67,   10,   24,       86,    0,   11,      105,  -10,   -2,
     -26,   62,   97,       -6,   51,   83,       13,   41,   69,       31,   30,   56,
      51,   19,   42,       69,    9,   29,       88,   -1,   15,      108,  -12,    2,
     -23,   61,  101,       -4,   50,   87,       15,   39,   73,       34,   29,   60,
      53,   18,   46,       72,    7,   33,       91,   -2,   19,      110,  -13,    6,
     -21,   59,  105,       -1,   49,   91,       17,   38,   77,       36,   27,   64,
      55,   16,   50,       74,    6,   37,       93,   -4,   23,      112,  -15,   10,
     -96,  107,  -23,      -77,   96,  -36,      -58,   85,  -50,      -39,   74,  -63,
     -20,   63,  -77,       -1,   53,  -90,       18,   42, -104,       37,   31, -118,
     -94,  105,  -19,      -74,   94,  -32,      -56,   84,  -46,      -37,   73,  -59,
     -17,   62,  -73,        1,   52,  -86,       20,   41, -100,       39,   30, -114,
     -91,  104,  -15,      -72,   93,  -28,      -53,   82,  -42,      -34,   72,  -55,
     -15,   61,  -69,        4,   50,  -82,       23,   40,  -96,       42,   29, -110,
     -89,  102,  -10,      -69,   91,  -24,      -51,   81,  -37,      -32,   70,  -51,
     -12,   59,  -65,        6,   49,  -78,       25,   38,  -91,       45,   27, -105,
     -86,  101,   -6,      -67,   90,  -20,      -48,   79,  -33,      -29,   69,  -47,
     -10,   58,  -61,        9,   47,  -74,       28,   37,  -87,       47,   26, -101,
     -84,  100,   -2,      -65,   89,  -16,      -46,   78,  -29,      -27,   67,  -43,
      -8,   57,  -57,       11,   46,  -70,       30,   35,  -83,       49,   24,  -97,
     -81,   98,    1,      -62,   87,  -12,      -43,   77,  -25,      -25,   66,  -39,
      -5,   55,  -53,       14,   45,  -66,       32,   34,  -79,       52,   23,  -93,
     -79,   97,    5,      -59,   86,   -7,      -41,   75,  -21,      -22,   65,  -34,
      -2,   54,  -48,       16,   43,  -61,       35,   32,  -75,       54,   22,  -89,
     -76,   95,    9,      -57,   84,   -3,      -38,   74,  -17,      -19,   63,  -30,
       0,   52,  -44,       19,   42,  -57,       37,   31,  -71,       57,   20,  -85,
     -74,   94,   13,      -55,   83,    0,      -36,   73,  -13,      -17,   62,  -26,
       2,   51,  -40,       21,   40,  -53,       40,   30,  -67,       59,   19,  -81,
     -72,   93,   17,      -52,   82,    4,      -33,   71,   -9,      -15,   61,  -22,
       5,   50,  -36,       23,   39,  -49,       42,   28,  -63,       62,   17,  -77,
     -69,   91,   21,      -50,   80,    8,      -31,   70,   -5,      -12,   59,  -18,
       7,   48,  -32,       26,   38,  -45,       45,   27,  -59,       64,   16,  -73,
     -67,   90,   26,      -47,   79,   12,      -28,   68,    0,      -10,   58,  -14,
      10,   47,  -28,       29,   36,  -41,       47,   26,  -54,       67,   15,  -68,
     -64,   88,   30,      -45,   78,   16,      -26,   67,    3,       -7,   56,  -10,
      12,   45,  -24,       31,   35,  -37,       50,   24,  -50,       69,   13,  -64,
     -62,   87,   34,      -42,   76,   20,      -24,   66,    7,       -5,   55,   -6,
      15,   44,  -20,       33,   33,  -33,       52,   23,  -46,       71,   12,  -60,
     -59,   86,   38,      -40,   75,   24,      -21,   64,   11,       -2,   54,   -2,
      17,   43,  -16,       36,   32,  -29,       55,   22,  -42,       74,   11,  -56,
     -57,   84,   42,      -37,   73,   29,      -19,   63,   15,        0,   52,    2,
      20,   41,  -11,       38,   31,  -24,       57,   20,  -38,       77,    9,  -52,
     -54,   83,   46,      -35,   72,   33,      -16,   61,   19,        3,   51,    6,
      22,   40,   -7,       41,   29,  -20,       60,   19,  -34,       79,    8,  -48,
     -52,   82,   50,      -33,   71,   37,      -14,   60,   23,        5,   49,   10,
      24,   38,   -3,       43,   28,  -16,       62,   17,  -30,       81,    6,  -44,
     -50,   80,   54,      -30,   69,   41,      -11,   59,   27,        7,   48,   14,
      27,   37,    0,       46,   27,  -12,       64,   16,  -26,       84,    5,  -40,
     -47,   79,   59,      -27,   68,   45,       -9,   57,   32,       10,   47,   18,
      29,   36,    4,       48,   25,   -8,       67,   14,  -21,       86,    3,  -35,
     -44,   77,   63,      -25,   66,   49,       -6,   56,   36,       13,   45,   22,
      32,   34,    8,       51,   24,   -4,       69,   13,  -17,       89,    2,  -31,
     -42,   76,   67,      -23,   65,   53,       -4,   54,   40,       15,   44,   26,
      34,   33,   12,       53,   22,    0,       72,   12,  -13,       91,    1,  -27,
     -40,   75,   71,      -20,   64,   57,       -1,   53,   44,       17,   43,   30,
      37,   32,   16,       55,   21,    3,       74,   10,   -9,       94,    0,  -23,
     -37,   73,   75,      -18,   62,   61,        1,   52,   48,       20,   41,   34,
      39,   30,   20,       58,   20,    7,       77,    9,   -5,       96,   -1,  -19,
     -35,   72,   79,      -15,   61,   66,        4,   50,   52,       22,   40,   39,
      42,   29,   25,       61,   18,   12,       79,    8,   -1,       99,   -2,  -15,
     -32,   70,   83,      -13,   59,   70,        6,   49,   56,       25,   38,   43,
      44,   27,   29,       63,   17,   16,       82,    6,    2,      101,   -4,  -11,
     -30,   69,   87,      -10,   58,   74,        8,   48,   60,       27,   37,   47,
      47,   26,   33,       65,   15,   20,       84,    5,    6,      103,   -5,   -7,
     -27,   68,   91,       -8,   57,   78,       11,   46,   64,       30,   36,   51,
      49,   25,   37,       68,   14,   24,       87,    3,   10,      106,   -6,   -3,
     -25,   66,   96,       -5,   55,   82,       13,   45,   69,       32,   34,   55,
      52,   23,   41,       70,   13,   28,       89,    2,   15,      109,   -8,    1,
     -22,   65,  100,       -3,   54,   86,       16,   43,   73,       35,   33,   59,
      54,   22,   45,       73,   11,   32,       92,    1,   19,      111,   -9,    5,
     -20,   63,  104,       -1,   53,   90,       18,   42,   77,       37,   31,   63,
      56,   20,   49,       75,   10,   36,       94,    0,   23,      113,  -11,    9,
     -95,  111,  -23,      -76,  100,  -37,      -57,   89,  -50,      -38,   78,  -64,
     -19,   67,  -78,        0,   57,  -91,       19,   46, -104,       38,   35, -118,
     -93,  109,  -19,      -73,   98,  -33,      -55,   88,  -46,      -36,   77,  -60,
     -17,   66,  -74,        2,   56,  -87,       21,   45, -100,       40,   34, -114,
     -90,  108,  -15,      -71,   97,  -29,      -52,   86,  -42,      -34,   76,  -56,
     -14,   65,  -70,        5,   54,  -83,       23,   44,  -96,       43,   33, -110,
     -88,  106,  -11,      -68,   95,  -25,      -50,   85,  -38,      -31,   74,  -51,
     -11,   63,  -65,        7,   53,  -79,       26,   42,  -92,       45,   31, -106,
     -85,  105,   -7,      -66,   94,  -21,      -47,   83,  -34,      -28,   73,  -47,
      -9,   62,  -61,       10,   51,  -75,       29,   41,  -88,       48,   30, -102,
     -83,  104,   -3,      -64,   93,  -17,      -45,   82,  -30,      -26,   71,  -43,
      -7,   61,  -57,       12,   50,  -71,       31,   39,  -84,       50,   28,  -98,
     -81,  102,    0,      -61,   91,  -13,      -42,   81,  -26,      -24,   70,  -39,
      -4,   59,  -53,       15,   49,  -67,       33,   38,  -80,       53,   27,  -94,
     -78,  101,    5,      -59,   90,   -8,      -40,   79,  -21,      -21,   69,  -35,
      -2,   58,  -49,       17,   47,  -62,       36,   36,  -75,       55,   26,  -89,
     -76,   99,    9,      -56,   88,   -4,      -37,   78,  -17,      -19,   67,  -31,
       1,   56,  -45,       20,   46,  -58,       38,   35,  -71,       58,   24,  -85,
     -73,   98,   13,      -54,   87,    0,      -35,   77,  -13,      -16,   66,  -27,
       3,   55,  -41,       22,   44,  -54,       41,   34,  -67,       60,   23,  -81,
     -71,   97,   17,      -51,   86,    3,      -33,   75,   -9,      -14,   65,  -23,
       6,   54,  -37,       24,   43,  -50,       43,   32,  -63,       63,   21,  -77,
     -68,   95,   21,      -49,   84,    7,      -30,   74,   -5,      -11,   63,  -19,
       8,   52,  -33,       27,   42,  -46,       46,   31,  -59,       65,   20,  -73,
     -66,   94,   25,      -46,   83,   11,      -27,   72,   -1,       -9,   62,  -14,
      11,   51,  -28,       29,   40,  -42,       48,   30,  -55,       68,   19,  -69,
     -63,   92,   29,      -44,   82,   15,      -25,   71,    2,       -6,   60,  -10,
      13,   49,  -24,       32,   39,  -38,       51,   28,  -51,       70,   17,  -65,
     -61,   91,   33,      -41,   80,   19,      -23,   70,    6,       -4,   59,   -6,
      15,   48,  -20,       34,   37,  -34,       53,   27,  -47,       72,   16,  -61,
     -58,   90,   37,      -39,   79,   23,      -20,   68,   10,       -2,   58,   -2,
      18,   47,  -16,       37,   36,  -30,       55,   26,  -43,       75,   15,  -57,
     -56,   88,   42,      -36,   77,   28,      -18,   67,   15,        1,   56,    1,
      21,   45,  -12,       39,   35,  -25,       58,   24,  -38,       77,   13,  -52,
     -53,   87,   46,      -34,   76,   32,      -15,   65,   19,        4,   55,    5,
      23,   44,   -8,       42,   33,  -21,       61,   23,  -34,       80,   12,  -48,
     -51,   86,   50,      -32,   75,   36,      -13,   64,   23,        6,   53,    9,
      25,   42,   -4,       44,   32,  -17,       63,   21,  -30,       82,   10,  -44,
     -49,   84,   54,      -29,   73,   40,      -10,   63,   27,        8,   52,   13,
      28,   41,    0,       47,   31,  -13,       65,   20,  -26,       85,    9,  -40,
     -46,   83,   58,      -27,   72,   44,       -8,   61,   31,       11,   51,   18,
      30,   40,    4,       49,   29,   -9,       68,   18,  -22,       87,    7,  -36,
     -44,   81,   62,      -24,   70,   48,       -5,   60,   35,       13,   49,   22,
      33,   38,    8,       52,   28,   -5,       70,   17,  -18,       90,    6,  -32,
     -41,   80,   66,      -22,   69,   52,       -3,   58,   39,       16,   48,   26,
      35,   37,   12,       54,   26,   -1,       73,   16,  -14,       92,    5,  -28,
     -39,   79,   70,      -19,   68,   56,       -1,   57,   43,       18,   47,   30,
      38,   36,   16,       56,   25,    2,       75,   14,  -10,       95,    3,  -24,
     -36,   77,   74,      -17,   66,   60,        2,   56,   47,       21,   45,   34,
      40,   34,   20,       59,   24,    6,       78,   13,   -6,       97,    2,  -20,
     -34,   76,   79,      -14,   65,   65,        5,   54,   52,       23,   44,   38,
      43,   33,   24,       61,   22,   11,       80,   12,   -1,      100,    1,  -15,
     -31,   74,   83,      -12,   63,   69,        7,   53,   56,       26,   42,   42,
      45,   31,   28,       64,   21,   15,       83,   10,    2,      102,    0,  -11,
     -29,   73,   87,       -9,   62,   73,        9,   52,   60,       28,   41,   46,
      47,   30,   32,       66,   19,   19,       85,    9,    6,      104,   -1,   -7,
     -26,   72,   91,       -7,   61,   77,       12,   50,   64,       30,   40,   50,
      50,   29,   36,       69,   18,   23,       87,    7,   10,      107,   -2,   -3,
     -24,   70,   95,       -4,   59,   81,       14,   49,   68,       33,   38,   55,
      53,   27,   41,       71,   17,   27,       90,    6,   14,      109,   -4,    0,
     -21,   69,   99,       -2,   58,   85,       17,   47,   72,       36,   37,   59,
      55,   26,   45,       74,   15,   31,       92,    5,   18,      112,   -5,    4,
     -19,   67,  103,        0,   57,   89,       19,   46,   76,       38,   35,   63,
      57,   24,   49,       76,   14,   35,       95,    3,   22,      114,   -7,    8,
     -94,  115,  -24,      -75,  104,  -38,      -56,   93,  -51,      -37,   83,  -65,
     -18,   72,  -78,        1,   61,  -92,       20,   51, -105,       39,   40, -119,
     -92,  114,  -20,      -72,  103,  -34,      -54,   92,  -47,      -35,   82,  -61,
     -16,   71,  -74,        3,   60,  -88,       22,   49, -101,       41,   38, -115,
     -89,  112,  -16,      -70,  101,  -30,      -51,   91,  -43,      -32,   80,  -57,
     -13,   69,  -70,        6,   59,  -84,       24,   48,  -97,       44,   37, -111,
     -87,  111,  -11,      -67,  100,  -25,      -49,   89,  -39,      -30,   79,  -52,
     -10,   68,  -66,        8,   57,  -79,       27,   47,  -93,       47,   36, -107,
     -84,  109,   -7,      -65,   99,  -21,      -46,   88,  -35,      -27,   77,  -48,
      -8,   66,  -62,       11,   56,  -75,       30,   45,  -89,       49,   34, -103,
     -82,  108,   -3,      -63,   97,  -17,      -44,   87,  -31,      -25,   76,  -44,
      -6,   65,  -58,       13,   54,  -71,       32,   44,  -85,       51,   33,  -99,
     -80,  107,    0,      -60,   96,  -13,      -41,   85,  -27,      -23,   75,  -40,
      -3,   64,  -54,       16,   53,  -67,       34,   42,  -81,       54,   32,  -95,
     -77,  105,    4,      -57,   94,   -9,      -39,   84,  -22,      -20,   73,  -36,
      -1,   62,  -49,       18,   52,  -63,       37,   41,  -76,       56,   30,  -90,
     -74,  104,    8,      -55,   93,   -5,      -36,   82,  -18,      -18,   72,  -32,
       2,   61,  -45,       21,   50,  -59,       39,   40,  -72,       59,   29,  -86,
     -72,  103,   12,      -53,   92,   -1,      -34,   81,  -14,      -15,   70,  -28,
       4,   59,  -41,       23,   49,  -55,       42,   38,  -68,       61,   27,  -82,
     -70,  101,   16,      -50,   90,    2,      -32,   80,  -10,      -13,   69,  -24,
       7,   58,  -37,       25,   48,  -51,       44,   37,  -64,       64,   26,  -78,
     -67,  100,   20,      -48,   89,    6,      -29,   78,   -6,      -10,   68,  -20,
       9,   57,  -33,       28,   46,  -47,       47,   36,  -60,       66,   25,  -74,
     -65,   98,   25,      -45,   87,   11,      -26,   77,   -2,       -8,   66,  -15,
      12,   55,  -29,       30,   45,  -42,       49,   34,  -56,       69,   23,  -70,
     -62,   97,   29,      -43,   86,   15,      -24,   75,    1,       -5,   65,  -11,
      14,   54,  -25,       33,   43,  -38,       52,   33,  -52,       71,   22,  -66,
     -60,   96,   33,      -40,   85,   19,      -22,   74,    5,       -3,   63,   -7,
      16,   53,  -21,       35,   42,  -34,       54,   31,  -48,       73,   20,  -62,
     -57,   94,   37,      -38,   83,   23,      -19,   73,    9,        0,   62,   -3,
      19,   51,  -17,       38,   41,  -30,       56,   30,  -44,       76,   19,  -58,
     -55,   93,   41,      -35,   82,   27,      -17,   71,   14,        2,   61,    0,
      22,   50,  -12,       40,   39,  -26,       59,   28,  -39,       79,   18,  -53,
     -52,   91,   45,      -33,   80,   31,      -14,   70,   18,        5,   59,    4,
      24,   48,   -8,       43,   38,  -22,       62,   27,  -35,       81,   16,  -49,
     -50,   90,   49,      -31,   79,   35,      -12,   69,   22,        7,   58,    8,
      26,   47,   -4,       45,   36,  -18,       64,   26,  -31,       83,   15,  -45,
     -48,   89,   53,      -28,   78,   39,       -9,   67,   26,        9,   57,   12,
      29,   46,    0,       48,   35,  -14,       66,   24,  -27,       86,   14,  -41,
     -45,   87,   58,      -26,   76,   44,       -7,   66,   30,       12,   55,   17,
      31,   44,    3,       50,   34,   -9,       69,   23,  -23,       88,   12,  -37,
     -42,   86,   62,      -23,   75,   48,       -4,   64,   34,       14,   54,   21,
      34,   43,    7,       53,   32,   -5,       71,   22,  -19,       91,   11,  -33,
     -40,   84,   66,      -21,   74,   52,       -2,   63,   38,       17,   52,   25,
      36,   41,   11,       55,   31,   -1,       74,   20,  -15,       93,    9,  -29,
     -38,   83,   70,      -18,   72,   56,        0,   62,   42,       19,   51,   29,
      39,   40,   15,       57,   29,    2,       76,   19,  -11,       96,    8,  -25,
     -35,   82,   74,      -16,   71,   60,        3,   60,   46,       22,   50,   33,
      41,   39,   19,       60,   28,    6,       79,   18,   -7,       98,    7,  -21,
     -33,   80,   78,      -13,   69,   64,        6,   59,   51,       24,   48,   37,
      44,   37,   24,       62,   27,   10,       81,   16,   -2,      101,    5,  -16,
     -30,   79,   82,      -11,   68,   68,        8,   57,   55,       27,   47,   41,
      46,   36,   28,       65,   25,   14,       84,   15,    1,      103,    4,  -12,
     -28,   78,   86,       -8,   67,   72,       10,   56,   59,       29,   45,   45,
      48,   35,   32,       67,   24,   18,       86,   13,    5,      105,    2,   -8,
     -25,   76,   90,       -6,   65,   76,       13,   55,   63,       31,   44,   49,
      51,   33,   36,       70,   23,   22,       88,   12,    9,      108,    1,   -4,
     -23,   75,   95,       -3,   64,   81,       15,   53,   67,       34,   43,   54,
      54,   32,   40,       72,   21,   27,       91,   10,   13,      110,    0,    0,
     -20,   73,   99,       -1,   62,   85,       18,   52,   71,       37,   41,   58,
      56,   30,   44,       75,   20,   31,       94,    9,   17,      113,   -1,    3,
     -18,   72,  103,        1,   61,   89,       20,   50,   75,       39,   40,   62,
      58,   29,   48,       77,   18,   35,       96,    8,   21,      115,   -2,    7,
     -93,  119,  -25,      -74,  108,  -38,      -55,   97,  -52,      -36,   87,  -65,
     -17,   76,  -79,        2,   65,  -92,       21,   55, -106,       40,   44, -120,
     -91,  118,  -21,      -72,  107,  -34,      -53,   96,  -48,      -34,   86,  -61,
     -15,   75,  -75,        4,   64,  -88,       23,   53, -102,       42,   42, -116,
     -89,  116,  -17,      -69,  105,  -30,      -50,   95,  -44,      -32,   84,  -57,
     -12,   73,  -71,        7,   63,  -84,       25,   52,  -98,       45,   41, -112,
     -86,  115,  -12,      -66,  104,  -26,      -48,   93,  -39,      -29,   83,  -53,
     -10,   72,  -67,        9,   61,  -80,       28,   51,  -93,       47,   40, -107,
     -83,  113,   -8,      -64,  103,  -22,      -45,   92,  -35,      -26,   81,  -49,
      -7,   70,  -63,       12,   60,  -76,       30,   49,  -89,       50,   38, -103,
     -81,  112,   -4,      -62,  101,  -18,      -43,   91,  -31,      -24,   80,  -45,
      -5,   69,  -59,       14,   58,  -72,       33,   48,  -85,       52,   37,  -99,
     -79,  111,    0,      -59,  100,  -14,      -40,   89,  -27,      -22,   79,  -41,
      -2,   68,  -55,       16,   57,  -68,       35,   46,  -81,       55,   36,  -95,
     -76,  109,    3,      -57,   98,   -9,      -38,   88,  -23,      -19,   77,  -36,
       0,   66,  -50,       19,   56,  -63,       38,   45,  -77,       57,   34,  -91,
     -74,  108,    7,      -54,   97,   -5,      -35,   86,  -19,      -17,   76,  -32,
       3,   65,  -46,       22,   54,  -59,       40,   44,  -73,       60,   33,  -87,
     -71,  107,   11,      -52,   96,   -1,      -33,   85,  -15,      -14,   74,  -28,
       5,   63,  -42,       24,   53,  -55,       43,   42,  -69,       62,   31,  -83,
     -69,  105,   15,      -49,   94,    2,      -31,   84,  -11,      -12,   73,  -24,
       8,   62,  -38,       26,   52,  -51,       45,   41,  -65,       64,   30,  -79,
     -66,  104,   19,      -47,   93,    6,      -28,   82,   -7,       -9,   72,  -20,
      10,   61,  -34,       29,   50,  -47,       47,   40,  -61,       67,   29,  -75,
     -64,  102,   24,      -44,   91,   10,      -26,   81,   -2,       -7,   70,  -16,
      13,   59,  -30,       31,   49,  -43,       50,   38,  -56,       70,   27,  -70,
     -61,  101,   28,      -42,   90,   14,      -23,   79,    1,       -4,   69,  -12,
      15,   58,  -26,       34,   47,  -39,       53,   37,  -52,       72,   26,  -66,
     -59,  100,   32,      -40,   89,   18,      -21,   78,    5,       -2,   67,   -8,
      17,   57,  -22,       36,   46,  -35,       55,   35,  -48,       74,   24,  -62,
     -57,   98,   36,      -37,   87,   22,      -18,   77,    9,        0,   66,   -4,
      20,   55,  -18,       39,   45,  -31,       57,   34,  -44,       77,   23,  -58,
     -54,   97,   40,      -34,   86,   27,      -16,   75,   13,        3,   65,    0,
      22,   54,  -13,       41,   43,  -26,       60,   32,  -40,       79,   22,  -54,
     -51,   95,   44,      -32,   84,   31,      -13,   74,   17,        6,   63,    4,
      25,   52,   -9,       44,   42,  -22,       62,   31,  -36,       82,   20,  -50,
     -49,   94,   48,      -30,   83,   35,      -11,   73,   21,        8,   62,    8,
      27,   51,   -5,       46,   40,  -18,       65,   30,  -32,       84,   19,  -46,
     -47,   93,   52,      -27,   82,   39,       -8,   71,   25,       10,   61,   12,
      30,   50,   -1,       48,   39,  -14,       67,   28,  -28,       87,   18,  -42,
     -44,   91,   57,      -25,   80,   43,       -6,   70,   30,       13,   59,   16,
      32,   48,    2,       51,   38,  -10,       70,   27,  -23,       89,   16,  -37,
     -42,   90,   61,      -22,   79,   47,       -3,   68,   34,       15,   58,   20,
      35,   47,    6,       54,   36,   -6,       72,   26,  -19,       92,   15,  -33,
     -39,   88,   65,      -20,   78,   51,       -1,   67,   38,       18,   56,   24,
      37,   45,   10,       56,   35,   -2,       75,   24,  -15,       94,   13,  -29,
     -37,   87,   69,      -17,   76,   55,        1,   66,   42,       20,   55,   28,
      40,   44,   14,       58,   33,    1,       77,   23,  -11,       96,   12,  -25,
     -34,   86,   73,      -15,   75,   59,        4,   64,   46,       23,   54,   32,
      42,   43,   18,       61,   32,    5,       79,   22,   -7,       99,   11,  -21,
     -32,   84,   77,      -12,   73,   64,        6,   63,   50,       25,   52,   37,
      45,   41,   23,       63,   31,   10,       82,   20,   -3,      102,    9,  -17,
     -29,   83,   81,      -10,   72,   68,        9,   61,   54,       28,   51,   41,
      47,   40,   27,       66,   29,   14,       85,   19,    0,      104,    8,  -13,
     -27,   82,   85,       -8,   71,   72,       11,   60,   58,       30,   49,   45,
      49,   39,   31,       68,   28,   18,       87,   17,    4,      106,    6,   -9,
     -25,   80,   89,       -5,   69,   76,       14,   59,   62,       32,   48,   49,
      52,   37,   35,       71,   27,   22,       89,   16,    8,      109,    5,   -5,
     -22,   79,   94,       -2,   68,   80,       16,   57,   67,       35,   47,   53,
      54,   36,   39,       73,   25,   26,       92,   14,   13,      111,    4,    0,
     -19,   77,   98,        0,   66,   84,       19,   56,   71,       37,   45,   57,
      57,   34,   43,       76,   24,   30,       94,   13,   17,      114,    2,    3,
     -17,   76,  102,        2,   65,   88,       21,   54,   75,       40,   44,   61,
      59,   33,   47,       78,   22,   34,       97,   12,   21,      116,    1,    7,
     -92,  123,  -25,      -73,  112,  -39,      -54,  101,  -52,      -35,   91,  -66,
     -16,   80,  -80,        3,   69,  -93,       21,   59, -106,       41,   48, -120,
     -90,  122,  -21,      -71,  111,  -35,      -52,  100,  -48,      -33,   90,  -62,
     -14,   79,  -76,        5,   68,  -89,       24,   57, -102,       43,   46, -116,
     -88,  120,  -17,      -68,  109,  -31,      -49,   99,  -44,      -31,   88,  -58,
     -11,   77,  -72,        7,   67,  -85,       26,   56,  -98,       46,   45, -112,
     -85,  119,  -13,      -66,  108,  -27,      -47,   97,  -40,      -28,   87,  -53,
      -9,   76,  -67,       10,   65,  -81,       29,   55,  -94,       48,   44, -108,
     -83,  117,   -9,      -63,  107,  -23,      -44,   96,  -36,      -26,   85,  -49,
      -6,   74,  -63,       13,   64,  -77,       31,   53,  -90,       51,   42, -104,
     -80,  116,   -5,      -61,  105,  -19,      -42,   95,  -32,      -23,   84,  -45,
      -4,   73,  -59,       15,   62,  -73,       34,   52,  -86,       53,   41, -100,
     -78,  115,   -1,      -58,  104,  -15,      -40,   93,  -28,      -21,   83,  -41,
      -1,   72,  -55,       17,   61,  -69,       36,   50,  -82,       56,   40,  -96,
     -75,  113,    3,      -56,  102,  -10,      -37,   92,  -23,      -18,   81,  -37,
       1,   70,  -51,       20,   60,  -64,       39,   49,  -77,       58,   38,  -91,
     -73,  112,    7,      -53,  101,   -6,      -34,   90,  -19,      -16,   80,  -33,
       4,   69,  -47,       22,   58,  -60,       41,   48,  -73,       61,   37,  -87,
     -70,  111,   11,      -51,  100,   -2,      -32,   89,  -15,      -13,   78,  -29,
       6,   67,  -43,       25,   57,  -56,       44,   46,  -69,       63,   35,  -83,
     -68,  109,   15,      -48,   98,    1,      -30,   88,  -11,      -11,   77,  -25,
       8,   66,  -39,       27,   56,  -52,       46,   45,  -65,       65,   34,  -79,
     -65,  108,   19,      -46,   97,    5,      -27,   86,   -7,       -9,   76,  -21,
      11,   65,  -35,       30,   54,  -48,       48,   44,  -61,       68,   33,  -75,
     -63,  106,   23,      -43,   95,    9,      -25,   85,   -3,       -6,   74,  -16,
      14,   63,  -30,       32,   53,  -44,       51,   42,  -57,       70,   31,  -71,
     -60,  105,   27,      -41,   94,   13,      -22,   83,    0,       -3,   73,  -12,
      16,   62,  -26,       35,   51,  -40,       53,   41,  -53,       73,   30,  -67,
     -58,  104,   31,      -39,   93,   17,      -20,   82,    4,       -1,   71,   -8,
      18,   61,  -22,       37,   50,  -36,       56,   39,  -49,       75,   28,  -63,
     -56,  102,   35,      -36,   91,   21,      -17,   81,    8,        1,   70,   -4,
      21,   59,  -18,       39,   49,  -32,       58,   38,  -45,       78,   27,  -59,
     -53,  101,   40,      -34,   90,   26,      -15,   79,   13,        4,   69,    0,
      23,   58,  -14,       42,   47,  -27,       61,   36,  -40,       80,   26,  -54,
     -51,   99,   44,      -31,   88,   30,      -12,   78,   17,        6,   67,    3,
      26,   56,  -10,       45,   46,  -23,       63,   35,  -36,       83,   24,  -50,
     -48,   98,   48,      -29,   87,   34,      -10,   77,   21,        9,   66,    7,
      28,   55,   -6,       47,   44,  -19,       66,   34,  -32,       85,   23,  -46,
     -46,   97,   52,      -26,   86,   38,       -8,   75,   25,       11,   65,   11,
      31,   54,   -2,       49,   43,  -15,       68,   32,  -28,       88,   22,  -42,
     -43,   95,   56,      -24,   84,   42,       -5,   74,   29,       14,   63,   16,
      33,   52,    2,       52,   42,  -11,       71,   31,  -24,       90,   20,  -38,
     -41,   94,   60,      -21,   83,   46,       -3,   72,   33,       16,   62,   20,
      36,   51,    6,       54,   40,   -7,       73,   30,  -20,       93,   19,  -34,
     -38,   92,   64,      -19,   82,   50,        0,   71,   37,       19,   60,   24,
      38,   49,   10,       57,   39,   -3,       76,   28,  -16,       95,   17,  -30,
     -36,   91,   68,      -17,   80,   54,        2,   70,   41,       21,   59,   28,
      40,   48,   14,       59,   37,    0,       78,   27,  -12,       97,   16,  -26,
     -33,   90,   72,      -14,   79,   58,        5,   68,   45,       23,   58,   32,
      43,   47,   18,       62,   36,    4,       80,   26,   -8,      100,   15,  -22,
     -31,   88,   77,      -11,   77,   63,        7,   67,   50,       26,   56,   36,
      46,   45,   22,       64,   35,    9,       83,   24,   -3,      102,   13,  -17,
     -28,   87,   81,       -9,   76,   67,       10,   65,   54,       29,   55,   40,
      48,   44,   26,       67,   33,   13,       85,   23,    0,      105,   12,  -13,
     -26,   86,   85,       -7,   75,   71,       12,   64,   58,       31,   53,   44,
      50,   43,   30,       69,   32,   17,       88,   21,    4,      107,   10,   -9,
     -24,   84,   89,       -4,   73,   75,       15,   63,   62,       33,   52,   48,
      53,   41,   34,       71,   31,   21,       90,   20,    8,      110,    9,   -5,
     -21,   83,   93,       -2,   72,   79,       17,   61,   66,       36,   51,   53,
      55,   40,   39,       74,   29,   25,       93,   18,   12,      112,    8,   -1,
     -19,   81,   97,        1,   70,   83,       20,   60,   70,       38,   49,   57,
      58,   38,   43,       77,   28,   29,       95,   17,   16,      115,    6,    2,
     -16,   80,  101,        3,   69,   87,       22,   58,   74,       41,   48,   61,
      60,   37,   47,       79,   26,   33,       98,   16,   20,      117,    5,    6,
    -119,   -5,   -6,     -100,  -16,  -20,      -81,  -26,  -33,      -62,  -37,  -47,
     -43,  -48,  -61,      -24,  -58,  -74,       -5,  -69,  -87,       14,  -80, -101,
    -117,   -6,   -2,      -97,  -17,  -16,      -79,  -28,  -29,      -60,  -38,  -43,
     -40,  -49,  -57,      -22,  -60,  -70,       -3,  -70,  -83,       17,  -81,  -97,
    -114,   -8,    1,      -95,  -18,  -12,      -76,  -29,  -25,      -57,  -40,  -39,
     -38,  -51,  -53,      -19,  -61,  -66,        0,  -72,  -79,       19,  -83,  -93,
    -112,   -9,    5,      -92,  -20,   -8,      -73,  -31,  -21,      -55,  -41,  -34,
     -35,  -52,  -48,      -17,  -63,  -62,        2,  -73,  -75,       22,  -84,  -89,
    -109,  -10,    9,      -90,  -21,   -4,      -71,  -32,  -17,      -52,  -43,  -30,
     -33,  -53,  -44,      -14,  -64,  -58,        5,  -75,  -71,       24,  -86,  -85,
    -107,  -12,   13,      -87,  -23,    0,      -69,  -33,  -13,      -50,  -44,  -26,
     -31,  -55,  -40,      -12,  -65,  -54,        7,  -76,  -67,       26,  -87,  -81,
    -104,  -13,   17,      -85,  -24,    3,      -66,  -35,   -9,      -48,  -45,  -22,
     -28,  -56,  -36,       -9,  -67,  -50,        9,  -77,  -63,       29,  -88,  -77,
    -102,  -15,   22,      -82,  -26,    8,      -64,  -36,   -4,      -45,  -47,  -18,
     -25,  -58,  -32,       -7,  -68,  -45,       12,  -79,  -58,       31,  -90,  -72,
     -99,  -16,   26,      -80,  -27,   12,      -61,  -37,    0,      -42,  -48,  -14,
     -23,  -59,  -28,       -4,  -70,  -41,       15,  -80,  -54,       34,  -91,  -68,
     -97,  -17,   30,      -78,  -28,   16,      -59,  -39,    3,      -40,  -49,  -10,
     -21,  -60,  -24,       -2,  -71,  -37,       17,  -82,  -50,       36,  -92,  -64,
     -95,  -19,   34,      -75,  -30,   20,      -56,  -40,    7,      -38,  -51,   -6,
     -18,  -62,  -20,        1,  -72,  -33,       19,  -83,  -46,       39,  -94,  -60,
     -92,  -20,   38,      -73,  -31,   24,      -54,  -42,   11,      -35,  -52,   -2,
     -16,  -63,  -16,        3,  -74,  -29,       22,  -84,  -42,       41,  -95,  -56,
     -90,  -22,   42,      -70,  -32,   28,      -51,  -43,   15,      -33,  -54,    2,
     -13,  -65,  -11,        6,  -75,  -25,       24,  -86,  -38,       44,  -97,  -52,
     -87,  -23,   46,      -68,  -34,   32,      -49,  -44,   19,      -30,  -55,    6,
     -11,  -66,   -7,        8,  -77,  -21,       27,  -87,  -34,       46,  -98,  -48,
     -85,  -24,   50,      -65,  -35,   36,      -47,  -46,   23,      -28,  -56,   10,
      -8,  -67,   -3,       10,  -78,  -17,       29,  -88,  -30,       49,  -99,  -44,
     -82,  -26,   54,      -63,  -36,   40,      -44,  -47,   27,      -25,  -58,   14,
      -6,  -69,    0,       13,  -79,  -13,       32,  -90,  -26,       51, -101,  -40,
     -80,  -27,   59,      -60,  -38,   45,      -41,  -49,   32,      -23,  -59,   18,
      -3,  -70,    4,       15,  -81,   -8,       34,  -91,  -21,       54, -102,  -35,
     -77,  -28,   63,      -58,  -39,   49,      -39,  -50,   36,      -20,  -61,   22,
      -1,  -71,    8,       18,  -82,   -4,       37,  -93,  -17,       56, -104,  -31,
     -75,  -30,   67,      -55,  -41,   53,      -37,  -51,   40,      -18,  -62,   26,
       1,  -73,   12,       20,  -83,    0,       39,  -94,  -13,       58, -105,  -27,
     -72,  -31,   71,      -53,  -42,   57,      -34,  -53,   44,      -16,  -63,   30,
       4,  -74,   16,       23,  -85,    3,       41,  -95,   -9,       61, -106,  -23,
     -70,  -33,   75,      -50,  -44,   61,      -32,  -54,   48,      -13,  -65,   35,
       7,  -76,   21,       25,  -86,    7,       44,  -97,   -5,       63, -108,  -19,
     -67,  -34,   79,      -48,  -45,   65,      -29,  -56,   52,      -10,  -66,   39,
       9,  -77,   25,       28,  -88,   11,       46,  -98,   -1,       66, -109,  -15,
     -65,  -35,   83,      -46,  -46,   69,      -27,  -57,   56,       -8,  -67,   43,
      11,  -78,   29,       30,  -89,   15,       49, -100,    2,       68, -111,  -11,
     -63,  -37,   87,      -43,  -48,   73,      -24,  -58,   60,       -6,  -69,   47,
      14,  -80,   33,       32,  -90,   19,       51, -101,    6,       71, -112,   -7,
     -60,  -38,   91,      -41,  -49,   77,      -22,  -60,   64,       -3,  -70,   51,
      16,  -81,   37,       35,  -92,   23,       54, -102,   10,       73, -113,   -3,
     -58,  -40,   96,      -38,  -50,   82,      -19,  -61,   69,       -1,  -72,   55,
      19,  -83,   41,       38,  -93,   28,       56, -104,   15,       76, -115,    1,
     -55,  -41,  100,      -36,  -52,   86,      -17,  -62,   73,        2,  -73,   59,
      21,  -84,   45,       40,  -95,   32,       59, -105,   19,       78, -116,    5,
     -53,  -42,  104,      -33,  -53,   90,      -15,  -64,   77,        4,  -74,   63,
      24,  -85,   49,       42,  -96,   36,       61, -107,   23,       81, -117,    9,
     -50,  -44,  108,      -31,  -55,   94,      -12,  -65,   81,        7,  -76,   67,
      26,  -87,   53,       45,  -97,   40,       64, -108,   27,       83, -119,   13,
     -48,  -45,  112,      -28,  -56,   98,       -9,  -67,   85,        9,  -77,   72,
      29,  -88,   58,       47,  -99,   44,       66, -109,   31,       86, -120,   17,
     -45,  -46,  116,      -26,  -57,  102,       -7,  -68,   89,       12,  -79,   76,
      31,  -90,   62,       50, -100,   48,       69, -111,   35,       88, -122,   21,
     -43,  -48,  120,      -23,  -59,  106,       -5,  -69,   93,       14,  -80,   80,
      33,  -91,   66,       52, -101,   52,       71, -112,   39,       90, -123,   25,
    -118,   -1,   -7,      -99,  -12,  -21,      -80,  -22,  -34,      -61,  -33,  -47,
     -42,  -44,  -61,      -23,  -54,  -75,       -4,  -65,  -88,       15,  -76, -102,
    -116,   -2,   -3,      -96,  -13,  -17,      -78,  -24,  -30,      -59,  -34,  -43,
     -39,  -45,  -57,      -21,  -56,  -71,       -2,  -66,  -84,       17,  -77,  -98,
    -113,   -4,    0,      -94,  -14,  -13,      -75,  -25,  -26,      -56,  -36,  -39,
     -37,  -47,  -53,      -18,  -57,  -67,        0,  -68,  -80,       20,  -79,  -94,
    -111,   -5,    5,      -91,  -16,   -8,      -73,  -27,  -22,      -54,  -37,  -35,
     -34,  -48,  -49,      -16,  -59,  -62,        3,  -69,  -76,       23,  -80,  -89,
    -108,   -6,    9,      -89,  -17,   -4,      -70,  -28,  -18,      -51,  -39,  -31,
     -32,  -49,  -45,      -13,  -60,  -58,        6,  -71,  -72,       25,  -82,  -85,
    -106,   -8,   13,      -87,  -19,    0,      -68,  -29,  -14,      -49,  -40,  -27,
     -30,  -51,  -41,      -11,  -61,  -54,        8,  -72,  -68,       27,  -83,  -81,
    -104,   -9,   17,      -84,  -20,    3,      -65,  -31,  -10,      -47,  -41,  -23,
     -27,  -52,  -37,       -8,  -63,  -50,       10,  -73,  -64,       30,  -84,  -77,
    -101,  -11,   21,      -81,  -22,    7,      -63,  -32,   -5,      -44,  -43,  -18,
     -25,  -54,  -32,       -6,  -64,  -46,       13,  -75,  -59,       32,  -86,  -73,
     -98,  -12,   25,      -79,  -23,   11,      -60,  -33,   -1,      -42,  -44,  -14,
     -22,  -55,  -28,       -3,  -66,  -42,       15,  -76,  -55,       35,  -87,  -69,
     -96,  -13,   29,      -77,  -24,   15,      -58,  -35,    2,      -39,  -45,  -10,
     -20,  -56,  -24,       -1,  -67,  -38,       18,  -78,  -51,       37,  -88,  -65,
     -94,  -15,   33,      -74,  -26,   19,      -56,  -36,    6,      -37,  -47,   -6,
     -17,  -58,  -20,        1,  -68,  -34,       20,  -79,  -47,       40,  -90,  -61,
     -91,  -16,   37,      -72,  -27,   23,      -53,  -38,   10,      -34,  -48,   -2,
     -15,  -59,  -16,        4,  -70,  -30,       23,  -80,  -43,       42,  -91,  -57,
     -89,  -18,   42,      -69,  -28,   28,      -50,  -39,   14,      -32,  -50,    1,
     -12,  -61,  -12,        6,  -71,  -25,       25,  -82,  -39,       45,  -93,  -52,
     -86,  -19,   46,      -67,  -30,   32,      -48,  -40,   18,      -29,  -51,    5,
     -10,  -62,   -8,        9,  -73,  -21,       28,  -83,  -35,       47,  -94,  -48,
     -84,  -20,   50,      -64,  -31,   36,      -46,  -42,   22,      -27,  -52,    9,
      -8,  -63,   -4,       11,  -74,  -17,       30,  -84,  -31,       49,  -95,  -44,
     -81,  -22,   54,      -62,  -32,   40,      -43,  -43,   26,      -24,  -54,   13,
      -5,  -65,    0,       14,  -75,  -13,       32,  -86,  -27,       52,  -97,  -40,
     -79,  -23,   58,      -59,  -34,   44,      -41,  -45,   31,      -22,  -55,   18,
      -2,  -66,    4,       16,  -77,   -9,       35,  -87,  -22,       55,  -98,  -36,
     -76,  -24,   62,      -57,  -35,   48,      -38,  -46,   35,      -19,  -57,   22,
       0,  -67,    8,       19,  -78,   -5,       38,  -89,  -18,       57, -100,  -32,
     -74,  -26,   66,      -55,  -37,   52,      -36,  -47,   39,      -17,  -58,   26,
       2,  -69,   12,       21,  -79,   -1,       40,  -90,  -14,       59, -101,  -28,
     -72,  -27,   70,      -52,  -38,   56,      -33,  -49,   43,      -15,  -59,   30,
       5,  -70,   16,       24,  -81,    2,       42,  -91,  -10,       62, -102,  -24,
     -69,  -29,   75,      -49,  -40,   61,      -31,  -50,   47,      -12,  -61,   34,
       7,  -72,   20,       26,  -82,    7,       45,  -93,   -6,       64, -104,  -19,
     -66,  -30,   79,      -47,  -41,   65,      -28,  -52,   51,      -10,  -62,   38,
      10,  -73,   24,       29,  -84,   11,       47,  -94,   -2,       67, -105,  -15,
     -64,  -31,   83,      -45,  -42,   69,      -26,  -53,   55,       -7,  -63,   42,
      12,  -74,   28,       31,  -85,   15,       50,  -96,    1,       69, -107,  -11,
     -62,  -33,   87,      -42,  -44,   73,      -24,  -54,   59,       -5,  -65,   46,
      15,  -76,   32,       33,  -86,   19,       52,  -97,    5,       72, -108,   -7,
     -59,  -34,   91,      -40,  -45,   77,      -21,  -56,   63,       -2,  -66,   50,
      17,  -77,   36,       36,  -88,   23,       55,  -98,    9,       74, -109,   -3,
     -57,  -36,   95,      -37,  -46,   81,      -18,  -57,   68,        0,  -68,   55,
      20,  -79,   41,       38,  -89,   27,       57, -100,   14,       77, -111,    0,
     -54,  -37,   99,      -35,  -48,   85,      -16,  -58,   72,        3,  -69,   59,
      22,  -80,   45,       41,  -91,   31,       60, -101,   18,       79, -112,    4,
     -52,  -38,  103,      -32,  -49,   89,      -14,  -60,   76,        5,  -70,   63,
      24,  -81,   49,       43,  -92,   35,       62, -103,   22,       81, -113,    8,
     -49,  -40,  107,      -30,  -51,   93,      -11,  -61,   80,        8,  -72,   67,
      27,  -83,   53,       46,  -93,   39,       64, -104,   26,       84, -115,   12,
     -47,  -41,  112,      -27,  -52,   98,       -9,  -63,   84,       10,  -73,   71,
      30,  -84,   57,       48,  -95,   44,       67, -105,   30,       87, -116,   17,
     -44,  -42,  116,      -25,  -53,  102,       -6,  -64,   88,       13,  -75,   75,
      32,  -86,   61,       51,  -96,   48,       70, -107,   34,       89, -118,   21,
     -42,  -44,  120,      -23,  -55,  106,       -4,  -65,   92,       15,  -76,   79,
      34,  -87,   65,       53,  -97,   52,       72, -108,   38,       91, -119,   25,
    -117,    2,   -8,      -98,   -8,  -21,      -79,  -18,  -35,      -60,  -29,  -48,
     -41,  -40,  -62,      -22,  -50,  -75,       -3,  -61,  -89,       16,  -72, -103,
    -115,    1,   -4,      -96,   -9,  -17,      -77,  -20,  -31,      -58,  -30,  -44,
     -39,  -41,  -58,      -20,  -52,  -71,       -1,  -62,  -85,       18,  -73,  -99,
    -113,    0,    0,      -93,  -10,  -13,      -74,  -21,  -27,      -56,  -32,  -40,
     -36,  -43,  -54,      -17,  -53,  -67,        1,  -64,  -81,       21,  -75,  -95,
    -110,   -1,    4,      -90,  -12,   -9,      -72,  -23,  -22,      -53,  -33,  -36,
     -33,  -44,  -49,      -15,  -55,  -63,        4,  -65,  -76,       23,  -76,  -90,
    -107,   -2,    8,      -88,  -13,   -5,      -69,  -24,  -18,      -50,  -35,  -32,
     -31,  -45,  -45,      -12,  -56,  -59,        6,  -67,  -72,       26,  -78,  -86,
    -105,   -4,   12,      -86,  -15,   -1,      -67,  -25,  -14,      -48,  -36,  -28,
     -29,  -47,  -41,      -10,  -57,  -55,        9,  -68,  -68,       28,  -79,  -82,
    -103,   -5,   16,      -83,  -16,    2,      -64,  -27,  -10,      -46,  -37,  -24,
     -26,  -48,  -37,       -8,  -59,  -51,       11,  -69,  -64,       31,  -80,  -78,
    -100,   -7,   21,      -81,  -18,    7,      -62,  -28,   -6,      -43,  -39,  -19,
     -24,  -50,  -33,       -5,  -60,  -46,       14,  -71,  -60,       33,  -82,  -74,
     -98,   -8,   25,      -78,  -19,   11,      -59,  -29,   -2,      -41,  -40,  -15,
     -21,  -51,  -29,       -2,  -62,  -42,       16,  -72,  -56,       36,  -83,  -70,
     -95,   -9,   29,      -76,  -20,   15,      -57,  -31,    1,      -38,  -41,  -11,
     -19,  -52,  -25,        0,  -63,  -38,       19,  -74,  -52,       38,  -84,  -66,
     -93,  -11,   33,      -73,  -22,   19,      -55,  -32,    5,      -36,  -43,   -7,
     -16,  -54,  -21,        2,  -64,  -34,       21,  -75,  -48,       40,  -86,  -62,
     -90,  -12,   37,      -71,  -23,   23,      -52,  -34,    9,      -33,  -44,   -3,
     -14,  -55,  -17,        5,  -66,  -30,       24,  -76,  -44,       43,  -87,  -58,
     -88,  -14,   41,      -68,  -24,   27,      -50,  -35,   14,      -31,  -46,    0,
     -11,  -57,  -12,        7,  -67,  -26,       26,  -78,  -39,       46,  -89,  -53,
     -85,  -15,   45,      -66,  -26,   31,      -47,  -36,   18,      -28,  -47,    4,
      -9,  -58,   -8,       10,  -69,  -22,       29,  -79,  -35,       48,  -90,  -49,
     -83,  -16,   49,      -64,  -27,   35,      -45,  -38,   22,      -26,  -48,    8,
      -7,  -59,   -4,       12,  -70,  -18,       31,  -80,  -31,       50,  -91,  -45,
     -81,  -18,   53,      -61,  -28,   39,      -42,  -39,   26,      -24,  -50,   12,
      -4,  -61,    0,       15,  -71,  -14,       33,  -82,  -27,       53,  -93,  -41,
     -78,  -19,   58,      -58,  -30,   44,      -40,  -41,   30,      -21,  -51,   17,
      -2,  -62,    3,       17,  -73,   -9,       36,  -83,  -23,       55,  -94,  -37,
     -75,  -20,   62,      -56,  -31,   48,      -37,  -42,   34,      -18,  -53,   21,
       1,  -63,    7,       20,  -74,   -5,       38,  -85,  -19,       58,  -96,  -33,
     -73,  -22,   66,      -54,  -33,   52,      -35,  -43,   38,      -16,  -54,   25,
       3,  -65,   11,       22,  -75,   -1,       41,  -86,  -15,       60,  -97,  -29,
     -71,  -23,   70,      -51,  -34,   56,      -32,  -45,   42,      -14,  -55,   29,
       6,  -66,   15,       24,  -77,    2,       43,  -87,  -11,       63,  -98,  -25,
     -68,  -25,   74,      -49,  -36,   60,      -30,  -46,   47,      -11,  -57,   33,
       8,  -68,   20,       27,  -78,    6,       46,  -89,   -6,       65, -100,  -20,
     -66,  -26,   78,      -46,  -37,   64,      -27,  -48,   51,       -9,  -58,   37,
      11,  -69,   24,       30,  -80,   10,       48,  -90,   -2,       68, -101,  -16,
     -63,  -27,   82,      -44,  -38,   68,      -25,  -49,   55,       -6,  -59,   41,
      13,  -70,   28,       32,  -81,   14,       51,  -92,    1,       70, -103,  -12,
     -61,  -29,   86,      -41,  -40,   72,      -23,  -50,   59,       -4,  -61,   45,
      16,  -72,   32,       34,  -82,   18,       53,  -93,    5,       72, -104,   -8,
     -58,  -30,   90,      -39,  -41,   76,      -20,  -52,   63,       -1,  -62,   49,
      18,  -73,   36,       37,  -84,   22,       55,  -94,    9,       75, -105,   -4,
     -56,  -32,   95,      -36,  -42,   81,      -18,  -53,   67,        1,  -64,   54,
      21,  -75,   40,       39,  -85,   27,       58,  -96,   13,       78, -107,    0,
     -53,  -33,   99,      -34,  -44,   85,      -15,  -54,   71,        4,  -65,   58,
      23,  -76,   44,       42,  -87,   31,       61,  -97,   17,       80, -108,    3,
     -51,  -34,  103,      -32,  -45,   89,      -13,  -56,   75,        6,  -66,   62,
      25,  -77,   48,       44,  -88,   35,       63,  -99,   21,       82, -109,    7,
     -49,  -36,  107,      -29,  -47,   93,      -10,  -57,   79,        8,  -68,   66,
      28,  -79,   52,       47,  -89,   39,       65, -100,   25,       85, -111,   11,
     -46,  -37,  111,      -26,  -48,   97,       -8,  -59,   84,       11,  -69,   70,
      30,  -80,   57,       49,  -91,   43,       68, -101,   30,       87, -112,   16,
     -43,  -38,  115,      -24,  -49,  101,       -5,  -60,   88,       14,  -71,   74,
      33,  -82,   61,       52,  -92,   47,       70, -103,   34,       90, -114,   20,
     -41,  -40,  119,      -22,  -51,  105,       -3,  -61,   92,       16,  -72,   78,
      35,  -83,   65,       54,  -93,   51,       73, -104,   38,       92, -115,   24,
    -116,    7,   -8,      -97,   -3,  -22,      -78,  -14,  -35,      -59,  -24,  -49,
     -40,  -35,  -63,      -21,  -46,  -76,       -2,  -57,  -89,       17,  -67, -103,
    -114,    5,   -4,      -94,   -5,  -18,      -76,  -15,  -31,      -57,  -26,  -45,
     -38,  -37,  -59,      -19,  -47,  -72,        0,  -58,  -85,       19,  -69,  -99,
    -111,    4,    0,      -92,   -6,  -14,      -73,  -17,  -27,      -55,  -27,  -41,
     -35,  -38,  -55,      -16,  -49,  -68,        2,  -59,  -81,       22,  -70,  -95,
    -109,    2,    3,      -89,   -7,  -10,      -71,  -18,  -23,      -52,  -29,  -36,
     -32,  -40,  -50,      -14,  -50,  -64,        5,  -61,  -77,       24,  -72,  -91,
    -106,    1,    7,      -87,   -9,   -6,      -68,  -19,  -19,      -49,  -30,  -32,
     -30,  -41,  -46,      -11,  -52,  -60,        7,  -62,  -73,       27,  -73,  -87,
    -104,    0,   11,      -85,  -10,   -2,      -66,  -21,  -15,      -47,  -31,  -28,
     -28,  -42,  -42,       -9,  -53,  -56,       10,  -63,  -69,       29,  -74,  -83,
    -102,   -1,   15,      -82,  -12,    1,      -63,  -22,  -11,      -45,  -33,  -24,
     -25,  -44,  -38,       -7,  -54,  -52,       12,  -65,  -65,       32,  -76,  -79,
     -99,   -2,   20,      -80,  -13,    6,      -61,  -24,   -6,      -42,  -34,  -20,
     -23,  -45,  -34,       -4,  -56,  -47,       15,  -66,  -60,       34,  -77,  -74,
     -97,   -3,   24,      -77,  -14,   10,      -58,  -25,   -2,      -40,  -36,  -16,
     -20,  -47,  -30,       -1,  -57,  -43,       17,  -68,  -56,       37,  -79,  -70,
     -94,   -5,   28,      -75,  -16,   14,      -56,  -26,    1,      -37,  -37,  -12,
     -18,  -48,  -26,        1,  -58,  -39,       20,  -69,  -52,       39,  -80,  -66,
     -92,   -6,   32,      -72,  -17,   18,      -54,  -28,    5,      -35,  -38,   -8,
     -15,  -49,  -22,        3,  -60,  -35,       22,  -70,  -48,       42,  -81,  -62,
     -89,   -7,   36,      -70,  -18,   22,      -51,  -29,    9,      -32,  -40,   -4,
     -13,  -51,  -18,        6,  -61,  -31,       25,  -72,  -44,       44,  -83,  -58,
     -87,   -9,   40,      -67,  -20,   26,      -49,  -31,   13,      -30,  -41,    0,
     -10,  -52,  -13,        8,  -63,  -27,       27,  -73,  -40,       47,  -84,  -54,
     -84,  -10,   44,      -65,  -21,   30,      -46,  -32,   17,      -27,  -42,    4,
      -8,  -53,   -9,       11,  -64,  -23,       30,  -75,  -36,       49,  -86,  -50,
     -82,  -12,   48,      -63,  -23,   34,      -44,  -33,   21,      -25,  -44,    8,
      -6,  -55,   -5,       13,  -65,  -19,       32,  -76,  -32,       51,  -87,  -46,
     -79,  -13,   52,      -60,  -24,   38,      -41,  -35,   25,      -23,  -45,   12,
      -3,  -56,   -1,       16,  -67,  -15,       34,  -77,  -28,       54,  -88,  -42,
     -77,  -15,   57,      -57,  -26,   43,      -39,  -36,   30,      -20,  -47,   16,
       0,  -58,    2,       18,  -68,  -10,       37,  -79,  -23,       56,  -90,  -37,
     -74,  -16,   61,      -55,  -27,   47,      -36,  -37,   34,      -17,  -48,   20,
       2,  -59,    6,       21,  -70,   -6,       39,  -80,  -19,       59,  -91,  -33,
     -72,  -17,   65,      -53,  -28,   51,      -34,  -39,   38,      -15,  -49,   24,
       4,  -60,   10,       23,  -71,   -2,       42,  -82,  -15,       61,  -92,  -29,
     -70,  -19,   69,      -50,  -30,   55,      -31,  -40,   42,      -13,  -51,   28,
       7,  -62,   14,       25,  -72,    1,       44,  -83,  -11,       64,  -94,  -25,
     -67,  -20,   73,      -48,  -31,   59,      -29,  -42,   46,      -10,  -52,   33,
       9,  -63,   19,       28,  -74,    5,       47,  -84,   -7,       66,  -95,  -21,
     -65,  -21,   77,      -45,  -32,   63,      -26,  -43,   50,       -8,  -54,   37,
      12,  -65,   23,       31,  -75,    9,       49,  -86,   -3,       69,  -97,  -17,
     -62,  -23,   81,      -43,  -34,   67,      -24,  -44,   54,       -5,  -55,   41,
      14,  -66,   27,       33,  -77,   13,       52,  -87,    0,       71,  -98,  -13,
     -60,  -24,   85,      -40,  -35,   71,      -22,  -46,   58,       -3,  -56,   45,
      17,  -67,   31,       35,  -78,   17,       54,  -88,    4,       74,  -99,   -9,
     -57,  -26,   89,      -38,  -36,   75,      -19,  -47,   62,        0,  -58,   49,
      19,  -69,   35,       38,  -79,   21,       57,  -90,    8,       76, -101,   -5,
     -55,  -27,   94,      -35,  -38,   80,      -17,  -49,   67,        2,  -59,   53,
      22,  -70,   39,       40,  -81,   26,       59,  -91,   13,       79, -102,    0,
     -52,  -28,   98,      -33,  -39,   84,      -14,  -50,   71,        5,  -61,   57,
      24,  -71,   43,       43,  -82,   30,       62,  -93,   17,       81, -104,    3,
     -50,  -30,  102,      -31,  -41,   88,      -12,  -51,   75,        7,  -62,   61,
      26,  -73,   47,       45,  -83,   34,       64,  -94,   21,       83, -105,    7,
     -47,  -31,  106,      -28,  -42,   92,       -9,  -53,   79,        9,  -63,   65,
      29,  -74,   51,       48,  -85,   38,       66,  -95,   25,       86, -106,   11,
     -45,  -33,  110,      -25,  -44,   96,       -7,  -54,   83,       12,  -65,   70,
      32,  -76,   56,       50,  -86,   42,       69,  -97,   29,       88, -108,   15,
     -42,  -34,  114,      -23,  -45,  100,       -4,  -56,   87,       15,  -66,   74,
      34,  -77,   60,       53,  -88,   46,       71,  -98,   33,       91, -109,   19,
     -40,  -35,  118,      -21,  -46,  104,       -2,  -57,   91,       17,  -67,   78,
      36,  -78,   64,       55,  -89,   50,       74, -100,   37,       93, -111,   23,
    -115,   11,   -9,      -96,    0,  -23,      -77,  -10,  -36,      -58,  -20,  -49,
     -39,  -31,  -63,      -20,  -42,  -77,       -1,  -53,  -90,       18,  -63, -104,
    -113,    9,   -5,      -94,   -1,  -19,      -75,  -11,  -32,      -56,  -22,  -45,
     -37,  -33,  -59,      -18,  -43,  -73,        1,  -54,  -86,       20,  -65, -100,
    -111,    8,   -1,      -91,   -2,  -15,      -72,  -13,  -28,      -54,  -23,  -41,
     -34,  -34,  -55,      -15,  -45,  -69,        3,  -55,  -82,       23,  -66,  -96,
    -108,    6,    3,      -88,   -3,  -10,      -70,  -14,  -24,      -51,  -25,  -37,
     -32,  -36,  -51,      -13,  -46,  -64,        6,  -57,  -78,       25,  -68,  -91,
    -105,    5,    7,      -86,   -5,   -6,      -67,  -15,  -20,      -49,  -26,  -33,
     -29,  -37,  -47,      -10,  -48,  -60,        8,  -58,  -74,       28,  -69,  -87,
    -103,    4,   11,      -84,   -6,   -2,      -65,  -17,  -16,      -46,  -27,  -29,
     -27,  -38,  -43,       -8,  -49,  -56,       11,  -59,  -70,       30,  -70,  -83,
    -101,    2,   15,      -81,   -8,    1,      -63,  -18,  -12,      -44,  -29,  -25,
     -24,  -40,  -39,       -6,  -50,  -52,       13,  -61,  -66,       33,  -72,  -79,
     -98,    1,   19,      -79,   -9,    5,      -60,  -20,   -7,      -41,  -30,  -20,
     -22,  -41,  -34,       -3,  -52,  -48,       16,  -62,  -61,       35,  -73,  -75,
     -96,    0,   23,      -76,  -10,    9,      -57,  -21,   -3,      -39,  -32,  -16,
     -19,  -43,  -30,       -1,  -53,  -44,       18,  -64,  -57,       38,  -75,  -71,
     -93,   -1,   27,      -74,  -12,   13,      -55,  -22,    0,      -36,  -33,  -12,
     -17,  -44,  -26,        2,  -54,  -40,       21,  -65,  -53,       40,  -76,  -67,
     -91,   -2,   31,      -71,  -13,   17,      -53,  -24,    4,      -34,  -34,   -8,
     -15,  -45,  -22,        4,  -56,  -36,       23,  -66,  -49,       42,  -77,  -63,
     -88,   -3,   35,      -69,  -14,   21,      -50,  -25,    8,      -31,  -36,   -4,
     -12,  -47,  -18,        7,  -57,  -32,       25,  -68,  -45,       45,  -79,  -59,
     -86,   -5,   40,      -66,  -16,   26,      -48,  -27,   12,      -29,  -37,    0,
      -9,  -48,  -14,        9,  -59,  -27,       28,  -69,  -41,       48,  -80,  -54,
     -83,   -6,   44,      -64,  -17,   30,      -45,  -28,   16,      -26,  -38,    3,
      -7,  -49,  -10,       12,  -60,  -23,       31,  -71,  -37,       50,  -82,  -50,
     -81,   -8,   48,      -62,  -19,   34,      -43,  -29,   20,      -24,  -40,    7,
      -5,  -51,   -6,       14,  -61,  -19,       33,  -72,  -33,       52,  -83,  -46,
     -79,   -9,   52,      -59,  -20,   38,      -40,  -31,   24,      -22,  -41,   11,
      -2,  -52,   -2,       17,  -63,  -15,       35,  -73,  -29,       55,  -84,  -42,
     -76,  -11,   56,      -57,  -22,   42,      -38,  -32,   29,      -19,  -43,   16,
       0,  -54,    2,       19,  -64,  -11,       38,  -75,  -24,       57,  -86,  -38,
     -73,  -12,   60,      -54,  -23,   46,      -35,  -33,   33,      -17,  -44,   20,
       3,  -55,    6,       22,  -66,   -7,       40,  -76,  -20,       60,  -87,  -34,
     -71,  -13,   64,      -52,  -24,   50,      -33,  -35,   37,      -14,  -45,   24,
       5,  -56,   10,       24,  -67,   -3,       43,  -78,  -16,       62,  -88,  -30,
     -69,  -15,   68,      -49,  -26,   54,      -31,  -36,   41,      -12,  -47,   28,
       8,  -58,   14,       26,  -68,    0,       45,  -79,  -12,       65,  -90,  -26,
     -66,  -16,   73,      -47,  -27,   59,      -28,  -38,   45,       -9,  -48,   32,
      10,  -59,   18,       29,  -70,    5,       48,  -80,   -8,       67,  -91,  -21,
     -64,  -17,   77,      -44,  -28,   63,      -25,  -39,   49,       -7,  -50,   36,
      13,  -61,   22,       31,  -71,    9,       50,  -82,   -4,       70,  -93,  -17,
     -61,  -19,   81,      -42,  -30,   67,      -23,  -40,   53,       -4,  -51,   40,
      15,  -62,   26,       34,  -73,   13,       53,  -83,    0,       72,  -94,  -13,
     -59,  -20,   85,      -39,  -31,   71,      -21,  -42,   57,       -2,  -52,   44,
      17,  -63,   30,       36,  -74,   17,       55,  -84,    3,       74,  -95,   -9,
     -56,  -22,   89,      -37,  -32,   75,      -18,  -43,   61,        0,  -54,   48,
      20,  -65,   34,       39,  -75,   21,       57,  -86,    7,       77,  -97,   -5,
     -54,  -23,   93,      -34,  -34,   79,      -16,  -45,   66,        3,  -55,   53,
      23,  -66,   39,       41,  -77,   25,       60,  -87,   12,       79,  -98,   -1,
     -51,  -24,   97,      -32,  -35,   83,      -13,  -46,   70,        6,  -57,   57,
      25,  -67,   43,       44,  -78,   29,       63,  -89,   16,       82, -100,    2,
     -49,  -26,  101,      -30,  -37,   87,      -11,  -47,   74,        8,  -58,   61,
      27,  -69,   47,       46,  -79,   33,       65,  -90,   20,       84, -101,    6,
     -47,  -27,  105,      -27,  -38,   91,       -8,  -49,   78,       10,  -59,   65,
      30,  -70,   51,       49,  -81,   37,       67,  -91,   24,       87, -102,   10,
     -44,  -29,  110,      -25,  -40,   96,       -6,  -50,   82,       13,  -61,   69,
      32,  -72,   55,       51,  -82,   42,       70,  -93,   28,       89, -104,   15,
     -41,  -30,  114,      -22,  -41,  100,       -3,  -52,   86,       15,  -62,   73,
      35,  -73,   59,       54,  -84,   46,       72,  -94,   32,       92, -105,   19,
     -39,  -31,  118,      -20,  -42,  104,       -1,  -53,   90,       18,  -63,   77,
      37,  -74,   63,       56,  -85,   50,       75,  -96,   36,       94, -107,   23,
    -114,   15,  -10,      -95,    4,  -23,      -76,   -6,  -37,      -57,  -16,  -50,
     -38,  -27,  -64,      -19,  -38,  -77,       -1,  -49,  -91,       19,  -59, -105,
    -112,   13,   -6,      -93,    2,  -19,      -74,   -7,  -33,      -55,  -18,  -46,
     -36,  -29,  -60,      -17,  -39,  -73,        2,  -50,  -87,       21,  -61, -101,
    -110,   12,   -2,      -90,    1,  -15,      -71,   -9,  -29,      -53,  -19,  -42,
     -33,  -30,  -56,      -15,  -41,  -69,        4,  -51,  -83,       24,  -62,  -97,
    -107,   10,    2,      -88,    0,  -11,      -69,  -10,  -24,      -50,  -21,  -38,
     -31,  -32,  -51,      -12,  -42,  -65,        7,  -53,  -78,       26,  -64,  -92,
    -105,    9,    6,      -85,   -1,   -7,      -66,  -11,  -20,      -48,  -22,  -34,
     -28,  -33,  -47,       -9,  -44,  -61,        9,  -54,  -74,       29,  -65,  -88,
    -102,    8,   10,      -83,   -2,   -3,      -64,  -13,  -16,      -45,  -23,  -30,
     -26,  -34,  -43,       -7,  -45,  -57,       12,  -55,  -70,       31,  -66,  -84,
    -100,    6,   14,      -80,   -4,    0,      -62,  -14,  -12,      -43,  -25,  -26,
     -23,  -36,  -39,       -5,  -46,  -53,       14,  -57,  -66,       33,  -68,  -80,
     -97,    5,   18,      -78,   -5,    5,      -59,  -16,   -8,      -40,  -26,  -21,
     -21,  -37,  -35,       -2,  -48,  -48,       17,  -58,  -62,       36,  -69,  -76,
     -95,    4,   22,      -75,   -6,    9,      -57,  -17,   -4,      -38,  -28,  -17,
     -18,  -39,  -31,        0,  -49,  -44,       19,  -60,  -58,       39,  -71,  -72,
     -92,    2,   26,      -73,   -8,   13,      -54,  -18,    0,      -35,  -29,  -13,
     -16,  -40,  -27,        3,  -50,  -40,       22,  -61,  -54,       41,  -72,  -68,
     -90,    1,   30,      -71,   -9,   17,      -52,  -20,    3,      -33,  -30,   -9,
     -14,  -41,  -23,        5,  -52,  -36,       24,  -62,  -50,       43,  -73,  -64,
     -88,    0,   34,      -68,  -10,   21,      -49,  -21,    7,      -31,  -32,   -5,
     -11,  -43,  -19,        8,  -53,  -32,       26,  -64,  -46,       46,  -75,  -60,
     -85,   -1,   39,      -65,  -12,   25,      -47,  -23,   12,      -28,  -33,   -1,
      -9,  -44,  -14,       10,  -55,  -28,       29,  -65,  -41,       48,  -76,  -55,
     -82,   -2,   43,      -63,  -13,   29,      -44,  -24,   16,      -26,  -34,    2,
      -6,  -45,  -10,       13,  -56,  -24,       31,  -67,  -37,       51,  -78,  -51,
     -80,   -4,   47,      -61,  -15,   33,      -42,  -25,   20,      -23,  -36,    6,
      -4,  -47,   -6,       15,  -57,  -20,       34,  -68,  -33,       53,  -79,  -47,
     -78,   -5,   51,      -58,  -16,   37,      -40,  -27,   24,      -21,  -37,   10,
      -1,  -48,   -2,       17,  -59,  -16,       36,  -69,  -29,       56,  -80,  -43,
     -75,   -7,   55,      -56,  -18,   42,      -37,  -28,   28,      -18,  -39,   15,
       1,  -50,    1,       20,  -60,  -11,       39,  -71,  -25,       58,  -82,  -39,
     -73,   -8,   59,      -53,  -19,   46,      -34,  -29,   32,      -16,  -40,   19,
       4,  -51,    5,       23,  -62,   -7,       41,  -72,  -21,       61,  -83,  -35,
     -70,   -9,   63,      -51,  -20,   50,      -32,  -31,   36,      -13,  -41,   23,
       6,  -52,    9,       25,  -63,   -3,       44,  -74,  -17,       63,  -84,  -31,
     -68,  -11,   67,      -48,  -22,   54,      -30,  -32,   40,      -11,  -43,   27,
       9,  -54,   13,       27,  -64,    0,       46,  -75,  -13,       65,  -86,  -27,
     -65,  -12,   72,      -46,  -23,   58,      -27,  -34,   45,       -8,  -44,   31,
      11,  -55,   18,       30,  -66,    4,       49,  -76,   -8,       68,  -87,  -22,
     -63,  -13,   76,      -43,  -24,   62,      -25,  -35,   49,       -6,  -46,   35,
      14,  -57,   22,       32,  -67,    8,       51,  -78,   -4,       71,  -89,  -18,
     -60,  -15,   80,      -41,  -26,   66,      -22,  -36,   53,       -3,  -47,   39,
      16,  -58,   26,       35,  -69,   12,       54,  -79,    0,       73,  -90,  -14,
     -58,  -16,   84,      -39,  -27,   70,      -20,  -38,   57,       -1,  -48,   43,
      18,  -59,   30,       37,  -70,   16,       56,  -80,    3,       75,  -91,  -10,
     -56,  -18,   88,      -36,  -28,   74,      -17,  -39,   61,        1,  -50,   47,
      21,  -61,   34,       40,  -71,   20,       58,  -82,    7,       78,  -93,   -6,
     -53,  -19,   92,      -33,  -30,   79,      -15,  -41,   65,        4,  -51,   52,
      23,  -62,   38,       42,  -73,   25,       61,  -83,   11,       80,  -94,   -2,
     -50,  -20,   96,      -31,  -31,   83,      -12,  -42,   69,        6,  -53,   56,
      26,  -63,   42,       45,  -74,   29,       63,  -85,   15,       83,  -96,    1,
     -48,  -22,  100,      -29,  -33,   87,      -10,  -43,   73,        9,  -54,   60,
      28,  -65,   46,       47,  -75,   33,       66,  -86,   19,       85,  -97,    5,
     -46,  -23,  104,      -26,  -34,   91,       -8,  -45,   77,       11,  -55,   64,
      31,  -66,   50,       49,  -77,   37,       68,  -87,   23,       88,  -98,    9,
     -43,  -25,  109,      -24,  -36,   95,       -5,  -46,   82,       14,  -57,   68,
      33,  -68,   55,       52,  -78,   41,       71,  -89,   28,       90, -100,   14,
     -41,  -26,  113,      -21,  -37,   99,       -2,  -48,   86,       16,  -58,   72,
      36,  -69,   59,       55,  -80,   45,       73,  -90,   32,       93, -101,   18,
     -38,  -27,  117,      -19,  -38,  103,        0,  -49,   90,       19,  -59,   76,
      38,  -70,   63,       57,  -81,   49,       76,  -92,   36,       95, -103,   22,
    -114,   19,  -10,      -94,    8,  -24,      -75,   -2,  -37,      -57,  -12,  -51,
     -37,  -23,  -65,      -18,  -34,  -78,        0,  -45,  -91,       20,  -55, -105,
    -111,   17,   -6,      -92,    6,  -20,      -73,   -3,  -33,      -54,  -14,  -47,
     -35,  -25,  -61,      -16,  -35,  -74,        3,  -46,  -87,       22,  -57, -101,
    -109,   16,   -2,      -89,    5,  -16,      -71,   -5,  -29,      -52,  -15,  -43,
     -32,  -26,  -57,      -14,  -37,  -70,        5,  -47,  -83,       25,  -58,  -97,
    -106,   14,    1,      -87,    4,  -12,      -68,   -6,  -25,      -49,  -17,  -38,
     -30,  -28,  -52,      -11,  -38,  -66,        8,  -49,  -79,       27,  -60,  -93,
    -104,   13,    5,      -84,    2,   -8,      -66,   -7,  -21,      -47,  -18,  -34,
     -27,  -29,  -48,       -9,  -40,  -62,       10,  -50,  -75,       30,  -61,  -89,
    -101,   12,    9,      -82,    1,   -4,      -63,   -9,  -17,      -44,  -19,  -30,
     -25,  -30,  -44,       -6,  -41,  -58,       13,  -51,  -71,       32,  -62,  -85,
     -99,   10,   13,      -79,    0,    0,      -61,  -10,  -13,      -42,  -21,  -26,
     -23,  -32,  -40,       -4,  -42,  -54,       15,  -53,  -67,       34,  -64,  -81,
     -96,    9,   18,      -77,   -1,    4,      -58,  -12,   -8,      -39,  -22,  -22,
     -20,  -33,  -36,       -1,  -44,  -49,       18,  -54,  -62,       37,  -65,  -76,
     -94,    8,   22,      -74,   -2,    8,      -56,  -13,   -4,      -37,  -24,  -18,
     -17,  -35,  -32,        1,  -45,  -45,       20,  -56,  -58,       39,  -67,  -72,
     -91,    6,   26,      -72,   -4,   12,      -53,  -14,    0,      -34,  -25,  -14,
     -15,  -36,  -28,        4,  -46,  -41,       22,  -57,  -54,       42,  -68,  -68,
     -89,    5,   30,      -70,   -5,   16,      -51,  -16,    3,      -32,  -26,  -10,
     -13,  -37,  -24,        6,  -48,  -37,       25,  -58,  -50,       44,  -69,  -64,
     -87,    4,   34,      -67,   -6,   20,      -48,  -17,    7,      -30,  -28,   -6,
     -10,  -39,  -20,        8,  -49,  -33,       27,  -60,  -46,       47,  -71,  -60,
     -84,    2,   38,      -65,   -8,   25,      -46,  -19,   11,      -27,  -29,   -1,
      -8,  -40,  -15,       11,  -51,  -29,       30,  -61,  -42,       49,  -72,  -56,
     -82,    1,   42,      -62,   -9,   29,      -43,  -20,   15,      -25,  -30,    2,
      -5,  -41,  -11,       14,  -52,  -25,       32,  -63,  -38,       52,  -74,  -52,
     -79,    0,   46,      -60,  -11,   33,      -41,  -21,   19,      -22,  -32,    6,
      -3,  -43,   -7,       16,  -53,  -21,       35,  -64,  -34,       54,  -75,  -48,
     -77,   -1,   50,      -57,  -12,   37,      -39,  -23,   23,      -20,  -33,   10,
       0,  -44,   -3,       18,  -55,  -17,       37,  -65,  -30,       57,  -76,  -44,
     -74,   -3,   55,      -55,  -14,   41,      -36,  -24,   28,      -17,  -35,   14,
       2,  -46,    0,       21,  -56,  -12,       40,  -67,  -25,       59,  -78,  -39,
     -72,   -4,   59,      -52,  -15,   45,      -34,  -25,   32,      -15,  -36,   18,
       5,  -47,    4,       23,  -58,   -8,       42,  -68,  -21,       62,  -79,  -35,
     -69,   -5,   63,      -50,  -16,   49,      -31,  -27,   36,      -12,  -37,   22,
       7,  -48,    8,       26,  -59,   -4,       45,  -70,  -17,       64,  -80,  -31,
     -67,   -7,   67,      -48,  -18,   53,      -29,  -28,   40,      -10,  -39,   26,
       9,  -50,   12,       28,  -60,    0,       47,  -71,  -13,       66,  -82,  -27,
     -64,   -8,   71,      -45,  -19,   58,      -26,  -30,   44,       -7,  -40,   31,
      12,  -51,   17,       31,  -62,    3,       50,  -72,   -9,       69,  -83,  -23,
     -62,   -9,   75,      -42,  -20,   61,      -24,  -31,   48,       -5,  -42,   35,
      15,  -53,   21,       33,  -63,    7,       52,  -74,   -5,       71,  -85,  -19,
     -59,  -11,   79,      -40,  -22,   65,      -21,  -32,   52,       -2,  -43,   39,
      17,  -54,   25,       36,  -65,   11,       54,  -75,   -1,       74,  -86,  -15,
     -57,  -12,   83,      -38,  -23,   69,      -19,  -34,   56,        0,  -44,   43,
      19,  -55,   29,       38,  -66,   15,       57,  -76,    2,       76,  -87,  -11,
     -55,  -14,   87,      -35,  -24,   73,      -16,  -35,   60,        2,  -46,   47,
      22,  -57,   33,       40,  -67,   19,       59,  -78,    6,       79,  -89,   -7,
     -52,  -15,   92,      -33,  -26,   78,      -14,  -37,   65,        5,  -47,   51,
      24,  -58,   37,       43,  -69,   24,       62,  -79,   11,       81,  -90,   -2,
     -50,  -16,   96,      -30,  -27,   82,      -11,  -38,   69,        7,  -49,   55,
      27,  -59,   41,       46,  -70,   28,       64,  -81,   15,       84,  -92,    1,
     -47,  -18,  100,      -28,  -29,   86,       -9,  -39,   73,       10,  -50,   59,
      29,  -61,   45,       48,  -71,   32,       67,  -82,   19,       86,  -93,    5,
     -45,  -19,  104,      -25,  -30,   90,       -7,  -41,   77,       12,  -51,   63,
      32,  -62,   49,       50,  -73,   36,       69,  -83,   23,       88,  -94,    9,
     -42,  -21,  108,      -23,  -32,   94,       -4,  -42,   81,       15,  -53,   68,
      34,  -64,   54,       53,  -74,   40,       72,  -85,   27,       91,  -96,   13,
     -40,  -22,  112,      -20,  -33,   98,       -2,  -44,   85,       17,  -54,   72,
      37,  -65,   58,       55,  -76,   44,       74,  -86,   31,       94,  -97,   17,
     -37,  -23,  116,      -18,  -34,  102,        1,  -45,   89,       20,  -55,   76,
      39,  -66,   62,       58,  -77,   48,       77,  -88,   35,       96,  -99,   21,
    -112,   23,  -11,      -93,   12,  -25,      -74,    2,  -38,      -56,   -8,  -52,
     -36,  -19,  -65,      -17,  -29,  -79,        1,  -40,  -92,       21,  -51, -106,
    -110,   22,   -7,      -91,   11,  -21,      -72,    0,  -34,      -53,   -9,  -48,
     -34,  -20,  -61,      -15,  -31,  -75,        4,  -41,  -88,       23,  -52, -102,
    -108,   21,   -3,      -88,   10,  -17,      -70,    0,  -30,      -51,  -11,  -44,
     -31,  -22,  -57,      -13,  -32,  -71,        6,  -43,  -84,       26,  -54,  -98,
    -105,   19,    1,      -86,    8,  -12,      -67,   -2,  -26,      -48,  -12,  -39,
     -29,  -23,  -53,      -10,  -34,  -66,        9,  -44,  -80,       28,  -55,  -93,
    -103,   18,    5,      -83,    7,   -8,      -64,   -3,  -22,      -46,  -14,  -35,
     -26,  -24,  -49,       -8,  -35,  -62,       11,  -46,  -76,       31,  -57,  -89,
    -100,   16,    9,      -81,    5,   -4,      -62,   -4,  -18,      -43,  -15,  -31,
     -24,  -26,  -45,       -5,  -36,  -58,       14,  -47,  -72,       33,  -58,  -85,
     -98,   15,   13,      -78,    4,    0,      -60,   -6,  -14,      -41,  -16,  -27,
     -22,  -27,  -41,       -3,  -38,  -54,       16,  -48,  -68,       35,  -59,  -81,
     -95,   13,   17,      -76,    2,    3,      -57,   -7,   -9,      -38,  -18,  -23,
     -19,  -29,  -36,        0,  -39,  -50,       19,  -50,  -63,       38,  -61,  -77,
     -93,   12,   21,      -73,    1,    7,      -55,   -8,   -5,      -36,  -19,  -19,
     -16,  -30,  -32,        2,  -41,  -46,       21,  -51,  -59,       40,  -62,  -73,
     -90,   11,   25,      -71,    0,   11,      -52,  -10,   -1,      -33,  -20,  -15,
     -14,  -31,  -28,        5,  -42,  -42,       24,  -53,  -55,       43,  -63,  -69,
     -88,    9,   29,      -69,   -1,   15,      -50,  -11,    2,      -31,  -22,  -11,
     -12,  -33,  -24,        7,  -43,  -38,       26,  -54,  -51,       45,  -65,  -65,
     -86,    8,   33,      -66,   -2,   19,      -47,  -13,    6,      -29,  -23,   -7,
      -9,  -34,  -20,       10,  -45,  -34,       28,  -55,  -47,       48,  -66,  -61,
     -83,    6,   38,      -64,   -3,   24,      -45,  -14,   10,      -26,  -25,   -2,
      -7,  -36,  -16,       12,  -46,  -29,       31,  -57,  -43,       50,  -68,  -56,
     -81,    5,   42,      -61,   -5,   28,      -42,  -15,   14,      -24,  -26,    1,
      -4,  -37,  -12,       15,  -48,  -25,       33,  -58,  -39,       53,  -69,  -52,
     -78,    4,   46,      -59,   -6,   32,      -40,  -17,   18,      -21,  -27,    5,
      -2,  -38,   -8,       17,  -49,  -21,       36,  -59,  -35,       55,  -70,  -48,
     -76,    2,   50,      -56,   -7,   36,      -38,  -18,   22,      -19,  -29,    9,
       1,  -40,   -4,       19,  -50,  -17,       38,  -61,  -31,       58,  -72,  -44,
     -73,    1,   54,      -54,   -9,   40,      -35,  -20,   27,      -16,  -30,   13,
       3,  -41,    0,       22,  -52,  -13,       41,  -62,  -26,       60,  -73,  -40,
     -71,    0,   58,      -51,  -10,   44,      -32,  -21,   31,      -14,  -32,   17,
       6,  -42,    4,       24,  -53,   -9,       43,  -64,  -22,       63,  -75,  -36,
     -68,   -1,   62,      -49,  -12,   48,      -30,  -22,   35,      -11,  -33,   21,
       8,  -44,    8,       27,  -54,   -5,       46,  -65,  -18,       65,  -76,  -32,
     -66,   -2,   66,      -46,  -13,   52,      -28,  -24,   39,       -9,  -34,   25,
      10,  -45,   12,       29,  -56,   -1,       48,  -66,  -14,       67,  -77,  -28,
     -63,   -4,   71,      -44,  -15,   57,      -25,  -25,   43,       -6,  -36,   30,
      13,  -47,   16,       32,  -57,    3,       51,  -68,  -10,       70,  -79,  -23,
     -61,   -5,   75,      -41,  -16,   61,      -23,  -27,   47,       -4,  -37,   34,
      16,  -48,   20,       34,  -59,    7,       53,  -69,   -6,       72,  -80,  -19,
     -58,   -6,   79,      -39,  -17,   65,      -20,  -28,   51,       -1,  -38,   38,
      18,  -49,   24,       37,  -60,   11,       56,  -71,   -2,       75,  -82,  -15,
     -56,   -8,   83,      -37,  -19,   69,      -18,  -29,   55,        1,  -40,   42,
      20,  -51,   28,       39,  -61,   15,       58,  -72,    1,       77,  -83,  -11,
     -54,   -9,   87,      -34,  -20,   73,      -15,  -31,   59,        3,  -41,   46,
      23,  -52,   32,       42,  -63,   19,       60,  -73,    5,       80,  -84,   -7,
     -51,  -11,   91,      -32,  -21,   77,      -13,  -32,   64,        6,  -43,   50,
      25,  -54,   37,       44,  -64,   23,       63,  -75,   10,       82,  -86,   -3,
     -49,  -12,   95,      -29,  -23,   81,      -10,  -33,   68,        8,  -44,   54,
      28,  -55,   41,       47,  -66,   27,       65,  -76,   14,       85,  -87,    0,
     -46,  -13,   99,      -27,  -24,   85,       -8,  -35,   72,       11,  -45,   58,
      30,  -56,   45,       49,  -67,   31,       68,  -78,   18,       87,  -88,    4,
     -44,  -15,  103,      -24,  -26,   89,       -6,  -36,   76,       13,  -47,   62,
      33,  -58,   49,       51,  -68,   35,       70,  -79,   22,       90,  -90,    8,
     -41,  -16,  108,      -22,  -27,   94,       -3,  -38,   80,       16,  -48,   67,
      35,  -59,   53,       54,  -70,   40,       73,  -80,   26,       92,  -91,   13,
     -39,  -17,  112,      -19,  -28,   98,        0,  -39,   84,       18,  -50,   71,
      38,  -61,   57,       56,  -71,   44,       75,  -82,   30,       95,  -93,   17,
     -36,  -19,  116,      -17,  -30,  102,        2,  -40,   88,       21,  -51,   75,
      40,  -62,   61,       59,  -72,   48,       78,  -83,   34,       97,  -94,   21,
    -112,   27,  -12,      -92,   16,  -25,      -73,    6,  -39,      -55,   -4,  -52,
     -35,  -15,  -66,      -16,  -25,  -79,        2,  -36,  -93,       22,  -47, -107,
    -109,   26,   -8,      -90,   15,  -21,      -71,    4,  -35,      -52,   -5,  -48,
     -33,  -16,  -62,      -14,  -27,  -75,        5,  -37,  -89,       24,  -48, -103,
    -107,   25,   -4,      -87,   14,  -17,      -69,    3,  -31,      -50,   -7,  -44,
     -30,  -18,  -58,      -12,  -28,  -71,        7,  -39,  -85,       26,  -50,  -99,
    -104,   23,    0,      -85,   12,  -13,      -66,    1,  -26,      -47,   -8,  -40,
     -28,  -19,  -53,       -9,  -30,  -67,       10,  -40,  -80,       29,  -51,  -94,
    -102,   22,    4,      -82,   11,   -9,      -64,    0,  -22,      -45,  -10,  -36,
     -25,  -20,  -49,       -7,  -31,  -63,       12,  -42,  -76,       32,  -53,  -90,
     -99,   20,    8,      -80,    9,   -5,      -61,    0,  -18,      -42,  -11,  -32,
     -23,  -22,  -45,       -4,  -32,  -59,       15,  -43,  -72,       34,  -54,  -86,
     -97,   19,   12,      -78,    8,   -1,      -59,   -2,  -14,      -40,  -12,  -28,
     -21,  -23,  -41,       -2,  -34,  -55,       17,  -44,  -68,       36,  -55,  -82,
     -94,   17,   16,      -75,    6,    3,      -56,   -3,  -10,      -37,  -14,  -23,
     -18,  -25,  -37,        1,  -35,  -50,       20,  -46,  -64,       39,  -57,  -78,
     -92,   16,   20,      -72,    5,    7,      -54,   -4,   -6,      -35,  -15,  -19,
     -16,  -26,  -33,        3,  -37,  -46,       22,  -47,  -60,       41,  -58,  -74,
     -89,   15,   24,      -70,    4,   11,      -51,   -6,   -2,      -33,  -16,  -15,
     -13,  -27,  -29,        6,  -38,  -42,       24,  -49,  -56,       44,  -59,  -70,
     -87,   13,   28,      -68,    2,   15,      -49,   -7,    1,      -30,  -18,  -11,
     -11,  -29,  -25,        8,  -39,  -38,       27,  -50,  -52,       46,  -61,  -66,
     -85,   12,   32,      -65,    1,   19,      -47,   -9,    5,      -28,  -19,   -7,
      -8,  -30,  -21,       10,  -41,  -34,       29,  -51,  -48,       49,  -62,  -62,
     -82,   10,   37,      -63,    0,   23,      -44,  -10,   10,      -25,  -21,   -3,
      -6,  -32,  -16,       13,  -42,  -30,       32,  -53,  -43,       51,  -64,  -57,
     -80,    9,   41,      -60,   -1,   27,      -41,  -11,   14,      -23,  -22,    0,
      -3,  -33,  -12,       16,  -44,  -26,       34,  -54,  -39,       54,  -65,  -53,
     -77,    8,   45,      -58,   -2,   31,      -39,  -13,   18,      -20,  -23,    4,
      -1,  -34,   -8,       18,  -45,  -22,       37,  -55,  -35,       56,  -66,  -49,
     -75,    6,   49,      -55,   -3,   35,      -37,  -14,   22,      -18,  -25,    8,
       2,  -36,   -4,       20,  -46,  -18,       39,  -57,  -31,       58,  -68,  -45,
     -72,    5,   53,      -53,   -5,   40,      -34,  -16,   26,      -15,  -26,   13,
       4,  -37,    0,       23,  -48,  -13,       42,  -58,  -27,       61,  -69,  -41,
     -70,    4,   57,      -50,   -6,   44,      -32,  -17,   30,      -13,  -28,   17,
       7,  -38,    3,       25,  -49,   -9,       44,  -60,  -23,       64,  -71,  -37,
     -67,    2,   61,      -48,   -8,   48,      -29,  -18,   34,      -10,  -29,   21,
       9,  -40,    7,       28,  -50,   -5,       47,  -61,  -19,       66,  -72,  -33,
     -65,    1,   65,      -46,   -9,   52,      -27,  -20,   38,       -8,  -30,   25,
      11,  -41,   11,       30,  -52,   -1,       49,  -62,  -15,       68,  -73,  -29,
     -62,    0,   70,      -43,  -11,   56,      -24,  -21,   43,       -5,  -32,   29,
      14,  -43,   16,       33,  -53,    2,       52,  -64,  -10,       71,  -75,  -24,
     -60,   -1,   74,      -40,  -12,   60,      -22,  -23,   47,       -3,  -33,   33,
      16,  -44,   20,       35,  -55,    6,       54,  -65,   -6,       73,  -76,  -20,
     -57,   -2,   78,      -38,  -13,   64,      -19,  -24,   51,       -1,  -34,   37,
      19,  -45,   24,       38,  -56,   10,       56,  -67,   -2,       76,  -78,  -16,
     -55,   -4,   82,      -36,  -15,   68,      -17,  -25,   55,        2,  -36,   41,
      21,  -47,   28,       40,  -57,   14,       59,  -68,    1,       78,  -79,  -12,
     -53,   -5,   86,      -33,  -16,   72,      -15,  -27,   59,        4,  -37,   45,
      24,  -48,   32,       42,  -59,   18,       61,  -69,    5,       81,  -80,   -8,
     -50,   -7,   90,      -31,  -17,   77,      -12,  -28,   63,        7,  -39,   50,
      26,  -50,   36,       45,  -60,   23,       64,  -71,    9,       83,  -82,   -4,
     -48,   -8,   94,      -28,  -19,   81,       -9,  -29,   67,        9,  -40,   54,
      29,  -51,   40,       47,  -62,   27,       66,  -72,   13,       86,  -83,    0,
     -45,   -9,   98,      -26,  -20,   85,       -7,  -31,   71,       12,  -41,   58,
      31,  -52,   44,       50,  -63,   31,       69,  -74,   17,       88,  -84,    3,
     -43,  -11,  102,      -23,  -22,   89,       -5,  -32,   75,       14,  -43,   62,
      33,  -54,   48,       52,  -64,   35,       71,  -75,   21,       90,  -86,    7,
     -40,  -12,  107,      -21,  -23,   93,       -2,  -34,   80,       17,  -44,   66,
      36,  -55,   53,       55,  -66,   39,       74,  -76,   26,       93,  -87,   12,
     -38,  -13,  111,      -18,  -24,   97,        0,  -35,   84,       19,  -46,   70,
      39,  -57,   57,       57,  -67,   43,       76,  -78,   30,       96,  -89,   16,
     -35,  -15,  115,      -16,  -26,  101,        3,  -36,   88,       22,  -47,   74,
      41,  -58,   61,       60,  -68,   47,       79,  -79,   34,       98,  -90,   20,
    -111,   31,  -12,      -91,   20,  -26,      -73,   10,  -39,      -54,    0,  -53,
     -34,  -11,  -67,      -16,  -21,  -80,        3,  -32,  -93,       23,  -43, -107,
    -108,   30,   -8,      -89,   19,  -22,      -70,    8,  -35,      -51,   -1,  -49,
     -32,  -12,  -63,      -13,  -23,  -76,        6,  -33,  -89,       25,  -44, -103,
    -106,   29,   -4,      -87,   18,  -18,      -68,    7,  -31,      -49,   -3,  -45,
     -30,  -14,  -59,      -11,  -24,  -72,        8,  -35,  -85,       27,  -46,  -99,
    -103,   27,    0,      -84,   16,  -14,      -65,    5,  -27,      -46,   -4,  -40,
     -27,  -15,  -54,       -8,  -26,  -68,       11,  -36,  -81,       30,  -47,  -95,
    -101,   26,    3,      -81,   15,  -10,      -63,    4,  -23,      -44,   -6,  -36,
     -24,  -16,  -50,       -6,  -27,  -64,       13,  -38,  -77,       32,  -49,  -91,
     -98,   24,    7,      -79,   13,   -6,      -60,    3,  -19,      -41,   -7,  -32,
     -22,  -18,  -46,       -3,  -28,  -60,       15,  -39,  -73,       35,  -50,  -87,
     -96,   23,   11,      -77,   12,   -2,      -58,    1,  -15,      -39,   -8,  -28,
     -20,  -19,  -42,       -1,  -30,  -56,       18,  -40,  -69,       37,  -51,  -83,
     -93,   21,   16,      -74,   10,    2,      -55,    0,  -10,      -36,  -10,  -24,
     -17,  -21,  -38,        2,  -31,  -51,       21,  -42,  -64,       40,  -53,  -78,
     -91,   20,   20,      -72,    9,    6,      -53,    0,   -6,      -34,  -11,  -20,
     -15,  -22,  -34,        4,  -33,  -47,       23,  -43,  -60,       42,  -54,  -74,
     -89,   19,   24,      -69,    8,   10,      -50,   -2,   -2,      -32,  -12,  -16,
     -12,  -23,  -30,        7,  -34,  -43,       25,  -45,  -56,       45,  -55,  -70,
     -86,   17,   28,      -67,    6,   14,      -48,   -3,    1,      -29,  -14,  -12,
     -10,  -25,  -26,        9,  -35,  -39,       28,  -46,  -52,       47,  -57,  -66,
     -84,   16,   32,      -64,    5,   18,      -46,   -5,    5,      -27,  -15,   -8,
      -7,  -26,  -22,       11,  -37,  -35,       30,  -47,  -48,       49,  -58,  -62,
     -81,   14,   36,      -62,    4,   22,      -43,   -6,    9,      -24,  -17,   -3,
      -5,  -28,  -17,       14,  -38,  -31,       33,  -49,  -44,       52,  -60,  -58,
     -79,   13,   40,      -59,    2,   26,      -41,   -7,   13,      -22,  -18,    0,
      -2,  -29,  -13,       16,  -40,  -27,       35,  -50,  -40,       55,  -61,  -54,
     -76,   12,   44,      -57,    1,   30,      -38,   -9,   17,      -19,  -19,    4,
       0,  -30,   -9,       19,  -41,  -23,       38,  -51,  -36,       57,  -62,  -50,
     -74,   10,   48,      -55,    0,   34,      -36,  -10,   21,      -17,  -21,    8,
       2,  -32,   -5,       21,  -42,  -19,       40,  -53,  -32,       59,  -64,  -46,
     -71,    9,   53,      -52,   -1,   39,      -33,  -12,   26,      -14,  -22,   12,
       5,  -33,   -1,       24,  -44,  -14,       43,  -54,  -27,       62,  -65,  -41,
     -69,    8,   57,      -49,   -2,   43,      -31,  -13,   30,      -12,  -24,   16,
       7,  -34,    2,       26,  -45,  -10,       45,  -56,  -23,       64,  -67,  -37,
     -66,    6,   61,      -47,   -4,   47,      -28,  -14,   34,       -9,  -25,   20,
      10,  -36,    6,       29,  -46,   -6,       47,  -57,  -19,       67,  -68,  -33,
     -64,    5,   65,      -45,   -5,   51,      -26,  -16,   38,       -7,  -26,   24,
      12,  -37,   10,       31,  -48,   -2,       50,  -58,  -15,       69,  -69,  -29,
     -61,    3,   69,      -42,   -7,   55,      -23,  -17,   42,       -4,  -28,   29,
      15,  -39,   15,       34,  -49,    1,       53,  -60,  -11,       72,  -71,  -25,
     -59,    2,   73,      -40,   -8,   59,      -21,  -19,   46,       -2,  -29,   33,
      17,  -40,   19,       36,  -51,    5,       55,  -61,   -7,       74,  -72,  -21,
     -57,    1,   77,      -37,   -9,   63,      -18,  -20,   50,        0,  -30,   37,
      20,  -41,   23,       39,  -52,    9,       57,  -63,   -3,       77,  -74,  -17,
     -54,    0,   81,      -35,  -11,   67,      -16,  -21,   54,        3,  -32,   41,
      22,  -43,   27,       41,  -53,   13,       60,  -64,    0,       79,  -75,  -13,
     -52,   -1,   85,      -32,  -12,   71,      -14,  -23,   58,        5,  -33,   45,
      25,  -44,   31,       43,  -55,   17,       62,  -65,    4,       81,  -76,   -9,
     -49,   -3,   90,      -30,  -13,   76,      -11,  -24,   63,        8,  -35,   49,
      27,  -46,   35,       46,  -56,   22,       65,  -67,    9,       84,  -78,   -4,
     -47,   -4,   94,      -27,  -15,   80,       -9,  -25,   67,       10,  -36,   53,
      30,  -47,   39,       48,  -58,   26,       67,  -68,   13,       87,  -79,    0,
     -44,   -5,   98,      -25,  -16,   84,       -6,  -27,   71,       13,  -37,   57,
      32,  -48,   43,       51,  -59,   30,       70,  -70,   17,       89,  -80,    3,
     -42,   -7,  102,      -23,  -18,   88,       -4,  -28,   75,       15,  -39,   61,
      34,  -50,   47,       53,  -60,   34,       72,  -71,   21,       91,  -82,    7,
     -39,   -8,  106,      -20,  -19,   92,       -1,  -30,   79,       18,  -40,   66,
      37,  -51,   52,       56,  -62,   38,       75,  -72,   25,       94,  -83,   11,
     -37,   -9,  110,      -17,  -20,   96,        1,  -31,   83,       20,  -42,   70,
      39,  -53,   56,       58,  -63,   42,       77,  -74,   29,       96,  -85,   15,
     -34,  -11,  114,      -15,  -22,  100,        4,  -32,   87,       23,  -43,   74,
      42,  -54,   60,       61,  -64,   46,       79,  -75,   33,       99,  -86,   19,
    -110,   35,  -13,      -90,   24,  -27,      -72,   14,  -40,      -53,    3,  -53,
     -33,   -7,  -67,      -15,  -17,  -81,        4,  -28,  -94,       23,  -39, -108,
    -107,   34,   -9,      -88,   23,  -23,      -69,   12,  -36,      -50,    2,  -49,
     -31,   -8,  -63,      -12,  -19,  -77,        7,  -29,  -90,       26,  -40, -104,
    -105,   33,   -5,      -86,   22,  -19,      -67,   11,  -32,      -48,    0,  -45,
     -29,  -10,  -59,      -10,  -20,  -73,        9,  -31,  -86,       28,  -42, -100,
    -102,   31,    0,      -83,   20,  -14,      -64,    9,  -28,      -45,    0,  -41,
     -26,  -11,  -55,       -7,  -22,  -68,       12,  -32,  -82,       31,  -43,  -95,
    -100,   30,    3,      -81,   19,  -10,      -62,    8,  -24,      -43,   -2,  -37,
     -24,  -12,  -51,       -5,  -23,  -64,       14,  -34,  -78,       33,  -45,  -91,
     -98,   28,    7,      -78,   17,   -6,      -59,    7,  -20,      -41,   -3,  -33,
     -21,  -14,  -47,       -2,  -24,  -60,       16,  -35,  -74,       36,  -46,  -87,
     -95,   27,   11,      -76,   16,   -2,      -57,    5,  -16,      -38,   -4,  -29,
     -19,  -15,  -43,        0,  -26,  -56,       19,  -36,  -70,       38,  -47,  -83,
     -92,   25,   15,      -73,   14,    1,      -54,    4,  -11,      -35,   -6,  -24,
     -16,  -17,  -38,        3,  -27,  -52,       21,  -38,  -65,       41,  -49,  -79,
     -90,   24,   19,      -71,   13,    5,      -52,    3,   -7,      -33,   -7,  -20,
     -14,  -18,  -34,        5,  -29,  -48,       24,  -39,  -61,       43,  -50,  -75,
     -88,   23,   23,      -68,   12,    9,      -49,    1,   -3,      -31,   -8,  -16,
     -11,  -19,  -30,        7,  -30,  -44,       26,  -41,  -57,       46,  -51,  -71,
     -85,   21,   27,      -66,   10,   13,      -47,    0,    0,      -28,  -10,  -12,
      -9,  -21,  -26,       10,  -31,  -40,       29,  -42,  -53,       48,  -53,  -67,
     -83,   20,   31,      -63,    9,   17,      -45,   -1,    4,      -26,  -11,   -8,
      -7,  -22,  -22,       12,  -33,  -36,       31,  -43,  -49,       50,  -54,  -63,
     -80,   18,   36,      -61,    8,   22,      -42,   -2,    8,      -23,  -13,   -4,
      -4,  -24,  -18,       15,  -34,  -31,       34,  -45,  -45,       53,  -56,  -58,
     -78,   17,   40,      -58,    6,   26,      -40,   -3,   12,      -21,  -14,    0,
      -1,  -25,  -14,       17,  -36,  -27,       36,  -46,  -41,       55,  -57,  -54,
     -75,   16,   44,      -56,    5,   30,      -37,   -5,   16,      -18,  -15,    3,
       1,  -26,  -10,       20,  -37,  -23,       39,  -47,  -37,       58,  -58,  -50,
     -73,   14,   48,      -54,    4,   34,      -35,   -6,   20,      -16,  -17,    7,
       3,  -28,   -6,       22,  -38,  -19,       41,  -49,  -33,       60,  -60,  -46,
     -70,   13,   52,      -51,    2,   38,      -32,   -8,   25,      -13,  -18,   12,
       6,  -29,   -1,       25,  -40,  -15,       44,  -50,  -28,       63,  -61,  -42,
     -68,   12,   56,      -49,    1,   42,      -30,   -9,   29,      -11,  -20,   16,
       8,  -30,    2,       27,  -41,  -11,       46,  -52,  -24,       65,  -63,  -38,
     -66,   10,   60,      -46,    0,   46,      -27,  -10,   33,       -9,  -21,   20,
      11,  -32,    6,       30,  -42,   -7,       48,  -53,  -20,       68,  -64,  -34,
     -63,    9,   64,      -44,   -1,   50,      -25,  -12,   37,       -6,  -22,   24,
      13,  -33,   10,       32,  -44,   -3,       51,  -54,  -16,       70,  -65,  -30,
     -60,    7,   69,      -41,   -3,   55,      -22,  -13,   41,       -3,  -24,   28,
      16,  -35,   14,       35,  -45,    1,       53,  -56,  -12,       73,  -67,  -25,
     -58,    6,   73,      -39,   -4,   59,      -20,  -15,   45,       -1,  -25,   32,
      18,  -36,   18,       37,  -47,    5,       56,  -57,   -8,       75,  -68,  -21,
     -56,    5,   77,      -36,   -5,   63,      -17,  -16,   49,        1,  -26,   36,
      21,  -37,   22,       39,  -48,    9,       58,  -59,   -4,       78,  -70,  -17,
     -53,    3,   81,      -34,   -7,   67,      -15,  -17,   53,        4,  -28,   40,
      23,  -39,   26,       42,  -49,   13,       61,  -60,    0,       80,  -71,  -13,
     -51,    2,   85,      -31,   -8,   71,      -13,  -19,   57,        6,  -29,   44,
      25,  -40,   30,       44,  -51,   17,       63,  -61,    3,       82,  -72,   -9,
     -48,    0,   89,      -29,   -9,   75,      -10,  -20,   62,        9,  -31,   49,
      28,  -42,   35,       47,  -52,   21,       66,  -63,    8,       85,  -74,   -5,
     -46,    0,   93,      -26,  -11,   79,       -8,  -21,   66,       11,  -32,   53,
      31,  -43,   39,       49,  -54,   25,       68,  -64,   12,       87,  -75,   -1,
     -43,   -1,   97,      -24,  -12,   83,       -5,  -23,   70,       14,  -33,   57,
      33,  -44,   43,       52,  -55,   29,       70,  -66,   16,       90,  -76,    2,
     -41,   -3,  101,      -22,  -14,   87,       -3,  -24,   74,       16,  -35,   61,
      35,  -46,   47,       54,  -56,   33,       73,  -67,   20,       92,  -78,    6,
     -38,   -4,  106,      -19,  -15,   92,        0,  -26,   78,       19,  -36,   65,
      38,  -47,   51,       57,  -58,   38,       76,  -68,   24,       95,  -79,   11,
     -36,   -5,  110,      -17,  -16,   96,        2,  -27,   82,       21,  -38,   69,
      40,  -49,   55,       59,  -59,   42,       78,  -70,   28,       97,  -81,   15,
     -34,   -7,  114,      -14,  -18,  100,        5,  -28,   86,       23,  -39,   73,
      43,  -50,   59,       62,  -60,   46,       80,  -71,   32,      100,  -82,   19,
    -109,   39,  -14,      -89,   28,  -27,      -71,   18,  -41,      -52,    7,  -54,
     -33,   -3,  -68,      -14,  -13,  -81,        5,  -24,  -95,       24,  -35, -109,
    -106,   38,  -10,      -87,   27,  -23,      -68,   16,  -37,      -50,    6,  -50,
     -30,   -4,  -64,      -11,  -15,  -77,        7,  -25,  -91,       27,  -36, -105,
    -104,   37,   -6,      -85,   26,  -19,      -66,   15,  -33,      -47,    4,  -46,
     -28,   -6,  -60,       -9,  -16,  -73,       10,  -27,  -87,       29,  -38, -101,
    -101,   35,   -1,      -82,   24,  -15,      -63,   13,  -28,      -44,    3,  -42,
     -25,   -7,  -55,       -6,  -18,  -69,       13,  -28,  -82,       32,  -39,  -96,
     -99,   34,    2,      -80,   23,  -11,      -61,   12,  -24,      -42,    1,  -38,
     -23,   -8,  -51,       -4,  -19,  -65,       15,  -30,  -78,       34,  -41,  -92,
     -97,   32,    6,      -77,   21,   -7,      -58,   11,  -20,      -40,    0,  -34,
     -20,  -10,  -47,       -1,  -20,  -61,       17,  -31,  -74,       37,  -42,  -88,
     -94,   31,   10,      -75,   20,   -3,      -56,    9,  -16,      -37,    0,  -30,
     -18,  -11,  -43,        1,  -22,  -57,       20,  -32,  -70,       39,  -43,  -84,
     -92,   29,   14,      -72,   18,    1,      -53,    8,  -12,      -35,   -2,  -25,
     -15,  -13,  -39,        4,  -23,  -52,       22,  -34,  -66,       42,  -45,  -80,
     -89,   28,   18,      -70,   17,    5,      -51,    7,   -8,      -32,   -3,  -21,
     -13,  -14,  -35,        6,  -25,  -48,       25,  -35,  -62,       44,  -46,  -76,
     -87,   27,   22,      -67,   16,    9,      -49,    5,   -4,      -30,   -4,  -17,
     -10,  -15,  -31,        8,  -26,  -44,       27,  -37,  -58,       47,  -47,  -72,
     -84,   25,   26,      -65,   14,   13,      -46,    4,    0,      -27,   -6,  -13,
      -8,  -17,  -27,       11,  -27,  -40,       30,  -38,  -54,       49,  -49,  -68,
     -82,   24,   30,      -63,   13,   17,      -44,    2,    3,      -25,   -7,   -9,
      -6,  -18,  -23,       13,  -29,  -36,       32,  -39,  -50,       51,  -50,  -64,
     -79,   22,   35,      -60,   12,   21,      -41,    1,    8,      -22,   -9,   -5,
      -3,  -20,  -18,       16,  -30,  -32,       35,  -41,  -45,       54,  -52,  -59,
     -77,   21,   39,      -57,   10,   25,      -39,    0,   12,      -20,  -10,   -1,
      -1,  -21,  -14,       18,  -32,  -28,       37,  -42,  -41,       56,  -53,  -55,
     -74,   20,   43,      -55,    9,   29,      -36,   -1,   16,      -18,  -11,    2,
       2,  -22,  -10,       21,  -33,  -24,       39,  -43,  -37,       59,  -54,  -51,
     -72,   18,   47,      -53,    8,   33,      -34,   -2,   20,      -15,  -13,    6,
       4,  -24,   -6,       23,  -34,  -20,       42,  -45,  -33,       61,  -56,  -47,
     -69,   17,   51,      -50,    6,   38,      -31,   -4,   24,      -12,  -14,   11,
       7,  -25,   -2,       26,  -36,  -15,       44,  -46,  -29,       64,  -57,  -43,
     -67,   16,   55,      -48,    5,   42,      -29,   -5,   28,      -10,  -16,   15,
       9,  -26,    1,       28,  -37,  -11,       47,  -48,  -25,       66,  -59,  -39,
     -65,   14,   59,      -45,    3,   46,      -26,   -6,   32,       -8,  -17,   19,
      12,  -28,    5,       30,  -38,   -7,       49,  -49,  -21,       69,  -60,  -35,
     -62,   13,   63,      -43,    2,   50,      -24,   -8,   36,       -5,  -18,   23,
      14,  -29,    9,       33,  -40,   -3,       52,  -50,  -17,       71,  -61,  -31,
     -60,   11,   68,      -40,    0,   54,      -21,   -9,   41,       -3,  -20,   27,
      17,  -31,   14,       36,  -41,    0,       54,  -52,  -12,       74,  -63,  -26,
     -57,   10,   72,      -38,    0,   58,      -19,  -11,   45,        0,  -21,   31,
      19,  -32,   18,       38,  -43,    4,       57,  -53,   -8,       76,  -64,  -22,
     -55,    9,   76,      -35,   -1,   62,      -17,  -12,   49,        2,  -22,   35,
      22,  -33,   22,       40,  -44,    8,       59,  -55,   -4,       79,  -66,  -18,
     -52,    7,   80,      -33,   -3,   66,      -14,  -13,   53,        5,  -24,   39,
      24,  -35,   26,       43,  -45,   12,       62,  -56,    0,       81,  -67,  -14,
     -50,    6,   84,      -31,   -4,   70,      -12,  -15,   57,        7,  -25,   43,
      26,  -36,   30,       45,  -47,   16,       64,  -57,    3,       83,  -68,  -10,
     -47,    4,   88,      -28,   -5,   75,       -9,  -16,   61,       10,  -27,   48,
      29,  -38,   34,       48,  -48,   21,       67,  -59,    7,       86,  -70,   -6,
     -45,    3,   92,      -25,   -7,   79,       -7,  -17,   65,       12,  -28,   52,
      31,  -39,   38,       50,  -50,   25,       69,  -60,   11,       88,  -71,   -2,
     -42,    2,   96,      -23,   -8,   83,       -4,  -19,   69,       14,  -29,   56,
      34,  -40,   42,       53,  -51,   29,       71,  -62,   15,       91,  -72,    1,
     -40,    0,  100,      -21,  -10,   87,       -2,  -20,   73,       17,  -31,   60,
      36,  -42,   46,       55,  -52,   33,       74,  -63,   19,       93,  -74,    5,
     -37,    0,  105,      -18,  -11,   91,        1,  -22,   78,       20,  -32,   64,
      39,  -43,   51,       58,  -54,   37,       76,  -64,   24,       96,  -75,   10,
     -35,   -1,  109,      -16,  -12,   95,        3,  -23,   82,       22,  -34,   68,
      41,  -45,   55,       60,  -55,   41,       79,  -66,   28,       98,  -77,   14,
     -33,   -3,  113,      -13,  -14,   99,        6,  -24,   86,       24,  -35,   72,
      44,  -46,   59,       62,  -56,   45,       81,  -67,   32,      101,  -78,   18,
    -108,   44,  -14,      -88,   33,  -28,      -70,   22,  -41,      -51,   12,  -55,
     -32,    1,  -69,      -13,   -9,  -82,        6,  -20,  -95,       25,  -30, -109,
    -105,   42,  -10,      -86,   31,  -24,      -67,   21,  -37,      -48,   10,  -51,
     -29,    0,  -65,      -10,  -10,  -78,        8,  -21,  -91,       28,  -32, -105,
    -103,   41,   -6,      -84,   30,  -20,      -65,   19,  -33,      -46,    9,  -47,
     -27,   -1,  -61,       -8,  -12,  -74,       11,  -22,  -87,       30,  -33, -101,
    -100,   39,   -2,      -81,   29,  -16,      -62,   18,  -29,      -43,    7,  -42,
     -24,   -3,  -56,       -5,  -13,  -70,       14,  -24,  -83,       33,  -35,  -97,
     -98,   38,    1,      -79,   27,  -12,      -60,   17,  -25,      -41,    6,  -38,
     -22,   -4,  -52,       -3,  -15,  -66,       16,  -25,  -79,       35,  -36,  -93,
     -96,   37,    5,      -76,   26,   -8,      -57,   15,  -21,      -39,    5,  -34,
     -19,   -5,  -48,        0,  -16,  -62,       18,  -26,  -75,       38,  -37,  -89,
     -93,   35,    9,      -74,   25,   -4,      -55,   14,  -17,      -36,    3,  -30,
     -17,   -7,  -44,        2,  -17,  -58,       21,  -28,  -71,       40,  -39,  -85,
     -90,   34,   14,      -71,   23,    0,      -52,   12,  -12,      -34,    2,  -26,
     -14,   -8,  -40,        5,  -19,  -53,       23,  -29,  -66,       43,  -40,  -80,
     -88,   33,   18,      -69,   22,    4,      -50,   11,   -8,      -31,    0,  -22,
     -12,  -10,  -36,        7,  -20,  -49,       26,  -31,  -62,       45,  -42,  -76,
     -86,   31,   22,      -66,   20,    8,      -48,   10,   -4,      -29,    0,  -18,
      -9,  -11,  -32,        9,  -21,  -45,       28,  -32,  -58,       48,  -43,  -72,
     -83,   30,   26,      -64,   19,   12,      -45,    8,    0,      -26,   -1,  -14,
      -7,  -12,  -28,       12,  -23,  -41,       31,  -33,  -54,       50,  -44,  -68,
     -81,   29,   30,      -62,   18,   16,      -43,    7,    3,      -24,   -3,  -10,
      -5,  -14,  -24,       14,  -24,  -37,       33,  -35,  -50,       52,  -46,  -64,
     -78,   27,   34,      -59,   16,   20,      -40,    5,    7,      -21,   -4,   -5,
      -2,  -15,  -19,       17,  -26,  -33,       36,  -36,  -46,       55,  -47,  -60,
     -76,   26,   38,      -56,   15,   24,      -38,    4,   11,      -19,   -5,   -1,
       0,  -16,  -15,       19,  -27,  -29,       38,  -38,  -42,       57,  -49,  -56,
     -73,   24,   42,      -54,   13,   28,      -35,    3,   15,      -16,   -7,    2,
       3,  -18,  -11,       22,  -28,  -25,       40,  -39,  -38,       60,  -50,  -52,
     -71,   23,   46,      -52,   12,   32,      -33,    1,   19,      -14,   -8,    6,
       5,  -19,   -7,       24,  -30,  -21,       43,  -40,  -34,       62,  -51,  -48,
     -68,   21,   51,      -49,   10,   37,      -30,    0,   24,      -11,  -10,   10,
       8,  -21,   -3,       27,  -31,  -16,       46,  -42,  -29,       65,  -53,  -43,
     -66,   20,   55,      -47,    9,   41,      -28,    0,   28,       -9,  -11,   14,
      10,  -22,    0,       29,  -33,  -12,       48,  -43,  -25,       67,  -54,  -39,
     -64,   19,   59,      -44,    8,   45,      -25,   -2,   32,       -7,  -12,   18,
      13,  -23,    4,       32,  -34,   -8,       50,  -45,  -21,       70,  -55,  -35,
     -61,   17,   63,      -42,    6,   49,      -23,   -3,   36,       -4,  -14,   22,
      15,  -25,    8,       34,  -35,   -4,       53,  -46,  -17,       72,  -57,  -31,
     -58,   16,   67,      -39,    5,   53,      -20,   -5,   40,       -2,  -15,   27,
      18,  -26,   13,       37,  -37,    0,       55,  -47,  -13,       75,  -58,  -27,
     -56,   15,   71,      -37,    4,   57,      -18,   -6,   44,        1,  -17,   31,
      20,  -28,   17,       39,  -38,    3,       58,  -49,   -9,       77,  -60,  -23,
     -54,   13,   75,      -34,    2,   61,      -16,   -7,   48,        3,  -18,   35,
      23,  -29,   21,       41,  -40,    7,       60,  -50,   -5,       80,  -61,  -19,
     -51,   12,   79,      -32,    1,   65,      -13,   -9,   52,        6,  -19,   39,
      25,  -30,   25,       44,  -41,   11,       63,  -51,   -1,       82,  -62,  -15,
     -49,   10,   83,      -30,    0,   69,      -11,  -10,   56,        8,  -21,   43,
      27,  -32,   29,       46,  -42,   15,       65,  -53,    2,       84,  -64,  -11,
     -46,    9,   88,      -27,   -1,   74,       -8,  -12,   61,       11,  -22,   47,
      30,  -33,   33,       49,  -44,   20,       68,  -54,    7,       87,  -65,   -6,
     -44,    8,   92,      -24,   -2,   78,       -6,  -13,   65,       13,  -24,   51,
      32,  -34,   37,       51,  -45,   24,       70,  -56,   11,       89,  -67,   -2,
     -41,    6,   96,      -22,   -4,   82,       -3,  -14,   69,       15,  -25,   55,
      35,  -36,   41,       54,  -46,   28,       72,  -57,   15,       92,  -68,    1,
     -39,    5,  100,      -20,   -5,   86,       -1,  -16,   73,       18,  -26,   59,
      37,  -37,   45,       56,  -48,   32,       75,  -58,   19,       94,  -69,    5,
     -36,    3,  104,      -17,   -7,   90,        2,  -17,   77,       21,  -28,   64,
      40,  -39,   50,       59,  -49,   36,       78,  -60,   23,       97,  -71,    9,
     -34,    2,  108,      -15,   -8,   94,        4,  -19,   81,       23,  -29,   68,
      42,  -40,   54,       61,  -51,   40,       80,  -61,   27,       99,  -72,   13,
     -32,    1,  112,      -12,   -9,   98,        7,  -20,   85,       25,  -30,   72,
      45,  -41,   58,       64,  -52,   44,       82,  -63,   31,      102,  -74,   17,
    -107,   48,  -15,      -88,   37,  -29,      -69,   26,  -42,      -50,   16,  -56,
     -31,    5,  -69,      -12,   -5,  -83,        7,  -16,  -96,       26,  -26, -110,
    -105,   46,  -11,      -85,   35,  -25,      -66,   25,  -38,      -48,   14,  -52,
     -28,    3,  -65,       -9,   -6,  -79,        9,  -17,  -92,       29,  -28, -106,
    -102,   45,   -7,      -83,   34,  -21,      -64,   23,  -34,      -45,   13,  -48,
     -26,    2,  -61,       -7,   -8,  -75,       12,  -18,  -88,       31,  -29, -102,
     -99,   43,   -2,      -80,   33,  -16,      -61,   22,  -30,      -42,   11,  -43,
     -23,    0,  -57,       -4,   -9,  -70,       14,  -20,  -84,       34,  -31,  -97,
     -97,   42,    1,      -78,   31,  -12,      -59,   21,  -26,      -40,   10,  -39,
     -21,    0,  -53,       -2,  -11,  -66,       17,  -21,  -80,       36,  -32,  -93,
     -95,   41,    5,      -75,   30,   -8,      -56,   19,  -22,      -38,    9,  -35,
     -18,   -1,  -49,        0,  -12,  -62,       19,  -22,  -76,       39,  -33,  -89,
     -92,   39,    9,      -73,   29,   -4,      -54,   18,  -18,      -35,    7,  -31,
     -16,   -3,  -45,        3,  -13,  -58,       22,  -24,  -72,       41,  -35,  -85,
     -90,   38,   13,      -70,   27,    0,      -51,   16,  -13,      -33,    6,  -27,
     -13,   -4,  -40,        6,  -15,  -54,       24,  -25,  -67,       44,  -36,  -81,
     -87,   37,   17,      -68,   26,    3,      -49,   15,   -9,      -30,    4,  -23,
     -11,   -6,  -36,        8,  -16,  -50,       27,  -27,  -63,       46,  -38,  -77,
     -85,   35,   21,      -65,   24,    7,      -47,   14,   -5,      -28,    3,  -19,
      -8,   -7,  -32,       10,  -17,  -46,       29,  -28,  -59,       48,  -39,  -73,
     -82,   34,   25,      -63,   23,   11,      -44,   12,   -1,      -25,    2,  -15,
      -6,   -8,  -28,       13,  -19,  -42,       31,  -29,  -55,       51,  -40,  -69,
     -80,   33,   29,      -61,   22,   15,      -42,   11,    2,      -23,    0,  -11,
      -4,  -10,  -24,       15,  -20,  -38,       34,  -31,  -51,       53,  -42,  -65,
     -77,   31,   34,      -58,   20,   20,      -39,    9,    6,      -20,    0,   -6,
      -1,  -11,  -20,       18,  -22,  -33,       37,  -32,  -47,       56,  -43,  -60,
     -75,   30,   38,      -56,   19,   24,      -37,    8,   10,      -18,   -1,   -2,
       1,  -12,  -16,       20,  -23,  -29,       39,  -34,  -43,       58,  -45,  -56,
     -73,   28,   42,      -53,   17,   28,      -34,    7,   14,      -16,   -3,    1,
       4,  -14,  -12,       23,  -24,  -25,       41,  -35,  -39,       61,  -46,  -52,
     -70,   27,   46,      -51,   16,   32,      -32,    5,   18,      -13,   -4,    5,
       6,  -15,   -8,       25,  -26,  -21,       44,  -36,  -35,       63,  -47,  -48,
     -67,   25,   50,      -48,   14,   36,      -29,    4,   23,      -11,   -6,    9,
       9,  -17,   -3,       28,  -27,  -17,       46,  -38,  -30,       66,  -49,  -44,
     -65,   24,   54,      -46,   13,   40,      -27,    3,   27,       -8,   -7,   13,
      11,  -18,    0,       30,  -29,  -13,       49,  -39,  -26,       68,  -50,  -40,
     -63,   23,   58,      -43,   12,   44,      -25,    1,   31,       -6,   -8,   17,
      14,  -19,    4,       32,  -30,   -9,       51,  -41,  -22,       71,  -51,  -36,
     -60,   21,   62,      -41,   10,   48,      -22,    0,   35,       -3,  -10,   21,
      16,  -21,    8,       35,  -31,   -5,       54,  -42,  -18,       73,  -53,  -32,
     -58,   20,   67,      -38,    9,   53,      -19,   -1,   39,       -1,  -11,   26,
      19,  -22,   12,       38,  -33,    0,       56,  -43,  -14,       76,  -54,  -27,
     -55,   19,   71,      -36,    8,   57,      -17,   -2,   43,        2,  -13,   30,
      21,  -24,   16,       40,  -34,    3,       59,  -45,  -10,       78,  -56,  -23,
     -53,   17,   75,      -33,    6,   61,      -15,   -3,   47,        4,  -14,   34,
      24,  -25,   20,       42,  -36,    7,       61,  -46,   -6,       80,  -57,  -19,
     -50,   16,   79,      -31,    5,   65,      -12,   -5,   51,        7,  -15,   38,
      26,  -26,   24,       45,  -37,   11,       63,  -47,   -2,       83,  -58,  -15,
     -48,   14,   83,      -29,    4,   69,      -10,   -6,   55,        9,  -17,   42,
      28,  -28,   28,       47,  -38,   15,       66,  -49,    1,       85,  -60,  -11,
     -45,   13,   87,      -26,    2,   73,       -7,   -8,   60,       12,  -18,   46,
      31,  -29,   33,       50,  -40,   19,       69,  -50,    6,       88,  -61,   -7,
     -43,   12,   91,      -24,    1,   77,       -5,   -9,   64,       14,  -20,   50,
      33,  -30,   37,       52,  -41,   23,       71,  -52,   10,       90,  -63,   -3,
     -41,   10,   95,      -21,    0,   81,       -2,  -10,   68,       16,  -21,   54,
      36,  -32,   41,       55,  -42,   27,       73,  -53,   14,       93,  -64,    0,
     -38,    9,   99,      -19,   -1,   85,        0,  -12,   72,       19,  -22,   58,
      38,  -33,   45,       57,  -44,   31,       76,  -54,   18,       95,  -65,    4,
     -35,    7,  104,      -16,   -3,   90,        3,  -13,   76,       21,  -24,   63,
      41,  -35,   49,       60,  -45,   36,       78,  -56,   22,       98,  -67,    9,
     -33,    6,  108,      -14,   -4,   94,        5,  -15,   80,       24,  -25,   67,
      43,  -36,   53,       62,  -47,   40,       81,  -57,   26,      100,  -68,   13,
     -31,    5,  112,      -11,   -5,   98,        7,  -16,   84,       26,  -26,   71,
      46,  -37,   57,       64,  -48,   44,       83,  -59,   30,      103,  -70,   17,
    -106,   52,  -16,      -87,   41,  -29,      -68,   30,  -43,      -49,   20,  -56,
     -30,    9,  -70,      -11,   -1,  -83,        8,  -12,  -97,       27,  -22, -111,
    -104,   50,  -12,      -84,   39,  -25,      -65,   29,  -39,      -47,   18,  -52,
     -27,    7,  -66,       -9,   -2,  -79,       10,  -13,  -93,       30,  -24, -107,
    -101,   49,   -8,      -82,   38,  -21,      -63,   27,  -35,      -44,   17,  -48,
     -25,    6,  -62,       -6,   -4,  -75,       13,  -14,  -89,       32,  -25, -103,
     -99,   47,   -3,      -79,   37,  -17,      -60,   26,  -30,      -42,   15,  -44,
     -22,    4,  -57,       -3,   -5,  -71,       15,  -16,  -84,       35,  -27,  -98,
     -96,   46,    0,      -77,   35,  -13,      -58,   25,  -26,      -39,   14,  -40,
     -20,    3,  -53,       -1,   -7,  -67,       18,  -17,  -80,       37,  -28,  -94,
     -94,   45,    4,      -74,   34,   -9,      -56,   23,  -22,      -37,   13,  -36,
     -17,    2,  -49,        1,   -8,  -63,       20,  -18,  -76,       40,  -29,  -90,
     -91,   43,    8,      -72,   33,   -5,      -53,   22,  -18,      -34,   11,  -32,
     -15,    0,  -45,        4,   -9,  -59,       23,  -20,  -72,       42,  -31,  -86,
     -89,   42,   12,      -69,   31,    0,      -51,   20,  -14,      -32,   10,  -27,
     -12,    0,  -41,        6,  -11,  -54,       25,  -21,  -68,       45,  -32,  -82,
     -86,   41,   16,      -67,   30,    3,      -48,   19,  -10,      -29,    8,  -23,
     -10,   -2,  -37,        9,  -12,  -50,       28,  -23,  -64,       47,  -34,  -78,
     -84,   39,   20,      -65,   28,    7,      -46,   18,   -6,      -27,    7,  -19,
      -8,   -3,  -33,       11,  -13,  -46,       30,  -24,  -60,       49,  -35,  -74,
     -81,   38,   24,      -62,   27,   11,      -43,   16,   -2,      -25,    6,  -15,
      -5,   -4,  -29,       14,  -15,  -42,       32,  -25,  -56,       52,  -36,  -70,
     -79,   37,   28,      -60,   26,   15,      -41,   15,    1,      -22,    4,  -11,
      -3,   -6,  -25,       16,  -16,  -38,       35,  -27,  -52,       54,  -38,  -66,
     -76,   35,   33,      -57,   24,   19,      -38,   13,    6,      -19,    3,   -7,
       0,   -7,  -20,       19,  -18,  -34,       37,  -28,  -47,       57,  -39,  -61,
     -74,   34,   37,      -55,   23,   23,      -36,   12,   10,      -17,    2,   -3,
       2,   -8,  -16,       21,  -19,  -30,       40,  -30,  -43,       59,  -41,  -57,
     -72,   32,   41,      -52,   21,   27,      -33,   11,   14,      -15,    0,    0,
       5,  -10,  -12,       23,  -20,  -26,       42,  -31,  -39,       62,  -42,  -53,
     -69,   31,   45,      -50,   20,   31,      -31,    9,   18,      -12,    0,    4,
       7,  -11,   -8,       26,  -22,  -22,       45,  -32,  -35,       64,  -43,  -49,
     -67,   29,   49,      -47,   18,   36,      -28,    8,   22,      -10,   -2,    9,
      10,  -13,   -4,       29,  -23,  -17,       47,  -34,  -31,       67,  -45,  -45,
     -64,   28,   53,      -45,   17,   40,      -26,    7,   26,       -7,   -3,   13,
      12,  -14,    0,       31,  -25,  -13,       50,  -35,  -27,       69,  -46,  -41,
     -62,   27,   57,      -42,   16,   44,      -24,    5,   30,       -5,   -4,   17,
      15,  -15,    3,       33,  -26,   -9,       52,  -37,  -23,       72,  -47,  -37,
     -59,   25,   61,      -40,   14,   48,      -21,    4,   34,       -2,   -6,   21,
      17,  -17,    7,       36,  -27,   -5,       55,  -38,  -19,       74,  -49,  -33,
     -57,   24,   66,      -37,   13,   52,      -19,    2,   39,        0,   -7,   25,
      20,  -18,   12,       38,  -29,   -1,       57,  -39,  -14,       77,  -50,  -28,
     -54,   23,   70,      -35,   12,   56,      -16,    1,   43,        3,   -9,   29,
      22,  -20,   16,       41,  -30,    2,       60,  -41,  -10,       79,  -52,  -24,
     -52,   21,   74,      -33,   10,   60,      -14,    0,   47,        5,  -10,   33,
      24,  -21,   20,       43,  -32,    6,       62,  -42,   -6,       81,  -53,  -20,
     -49,   20,   78,      -30,    9,   64,      -11,   -1,   51,        7,  -11,   37,
      27,  -22,   24,       46,  -33,   10,       64,  -43,   -2,       84,  -54,  -16,
     -47,   18,   82,      -28,    8,   68,       -9,   -2,   55,       10,  -13,   41,
      29,  -24,   28,       48,  -34,   14,       67,  -45,    1,       86,  -56,  -12,
     -44,   17,   86,      -25,    6,   73,       -6,   -4,   59,       13,  -14,   46,
      32,  -25,   32,       51,  -36,   19,       69,  -46,    5,       89,  -57,   -8,
     -42,   16,   90,      -23,    5,   77,       -4,   -5,   63,       15,  -16,   50,
      34,  -26,   36,       53,  -37,   23,       72,  -48,    9,       91,  -59,   -4,
     -40,   14,   94,      -20,    3,   81,       -1,   -6,   67,       17,  -17,   54,
      37,  -28,   40,       55,  -38,   27,       74,  -49,   13,       94,  -60,    0,
     -37,   13,   98,      -18,    2,   85,        1,   -8,   71,       20,  -18,   58,
      39,  -29,   44,       58,  -40,   31,       77,  -50,   17,       96,  -61,    3,
     -35,   11,  103,      -15,    0,   89,        4,   -9,   76,       22,  -20,   62,
      42,  -31,   49,       61,  -41,   35,       79,  -52,   22,       99,  -63,    8,
     -32,   10,  107,      -13,    0,   93,        6,  -11,   80,       25,  -21,   66,
      44,  -32,   53,       63,  -43,   39,       82,  -53,   26,      101,  -64,   12,
     -30,    9,  111,      -10,   -1,   97,        8,  -12,   84,       27,  -22,   70,
      47,  -33,   57,       65,  -44,   43,       84,  -55,   30,      103,  -66,   16,
    -105,   56,  -16,      -86,   45,  -30,      -67,   34,  -43,      -48,   24,  -57,
     -29,   13,  -71,      -10,    2,  -84,        9,   -8,  -97,       28,  -18, -111,
    -103,   54,  -12,      -83,   43,  -26,      -65,   33,  -39,      -46,   22,  -53,
     -26,   11,  -67,       -8,    1,  -80,       11,   -9,  -93,       31,  -20, -107,
    -100,   53,   -8,      -81,   42,  -22,      -62,   31,  -35,      -43,   21,  -49,
     -24,   10,  -63,       -5,    0,  -76,       14,  -10,  -89,       33,  -21, -103,
     -98,   51,   -4,      -78,   41,  -18,      -59,   30,  -31,      -41,   19,  -44,
     -21,    8,  -58,       -3,   -1,  -72,       16,  -12,  -85,       36,  -23,  -99,
     -95,   50,    0,      -76,   39,  -14,      -57,   29,  -27,      -38,   18,  -40,
     -19,    7,  -54,        0,   -3,  -68,       19,  -13,  -81,       38,  -24,  -95,
     -93,   49,    3,      -73,   38,  -10,      -55,   27,  -23,      -36,   17,  -36,
     -17,    6,  -50,        2,   -4,  -64,       21,  -14,  -77,       40,  -25,  -91,
     -90,   47,    7,      -71,   37,   -6,      -52,   26,  -19,      -33,   15,  -32,
     -14,    4,  -46,        5,   -5,  -60,       23,  -16,  -73,       43,  -27,  -87,
     -88,   46,   12,      -68,   35,   -1,      -50,   24,  -14,      -31,   14,  -28,
     -11,    3,  -42,        7,   -7,  -55,       26,  -17,  -68,       46,  -28,  -82,
     -85,   45,   16,      -66,   34,    2,      -47,   23,  -10,      -28,   12,  -24,
      -9,    1,  -38,       10,   -8,  -51,       29,  -19,  -64,       48,  -30,  -78,
     -83,   43,   20,      -64,   32,    6,      -45,   22,   -6,      -26,   11,  -20,
      -7,    0,  -34,       12,   -9,  -47,       31,  -20,  -60,       50,  -31,  -74,
     -81,   42,   24,      -61,   31,   10,      -42,   20,   -2,      -24,   10,  -16,
      -4,    0,  -30,       15,  -11,  -43,       33,  -21,  -56,       53,  -32,  -70,
     -78,   41,   28,      -59,   30,   14,      -40,   19,    1,      -21,    8,  -12,
      -2,   -2,  -26,       17,  -12,  -39,       36,  -23,  -52,       55,  -34,  -66,
     -75,   39,   32,      -56,   28,   18,      -37,   17,    5,      -19,    7,   -7,
       1,   -3,  -21,       20,  -14,  -35,       38,  -24,  -48,       58,  -35,  -62,
     -73,   38,   36,      -54,   27,   22,      -35,   16,    9,      -16,    6,   -3,
       3,   -4,  -17,       22,  -15,  -31,       41,  -26,  -44,       60,  -37,  -58,
     -71,   36,   40,      -51,   25,   26,      -33,   15,   13,      -14,    4,    0,
       6,   -6,  -13,       24,  -16,  -27,       43,  -27,  -40,       63,  -38,  -54,
     -68,   35,   44,      -49,   24,   30,      -30,   13,   17,      -11,    3,    4,
       8,   -7,   -9,       27,  -18,  -23,       46,  -28,  -36,       65,  -39,  -50,
     -66,   33,   49,      -46,   22,   35,      -27,   12,   22,       -9,    1,    8,
      11,   -9,   -5,       29,  -19,  -18,       48,  -30,  -31,       68,  -41,  -45,
     -63,   32,   53,      -44,   21,   39,      -25,   11,   26,       -6,    0,   12,
      13,  -10,   -1,       32,  -21,  -14,       51,  -31,  -27,       70,  -42,  -41,
     -61,   31,   57,      -41,   20,   43,      -23,    9,   30,       -4,    0,   16,
      15,  -11,    2,       34,  -22,  -10,       53,  -33,  -23,       72,  -43,  -37,
     -58,   29,   61,      -39,   18,   47,      -20,    8,   34,       -2,   -2,   20,
      18,  -13,    6,       37,  -23,   -6,       55,  -34,  -19,       75,  -45,  -33,
     -56,   28,   65,      -36,   17,   51,      -18,    6,   38,        1,   -3,   25,
      21,  -14,   11,       39,  -25,   -2,       58,  -35,  -15,       77,  -46,  -29,
     -53,   27,   69,      -34,   16,   55,      -15,    5,   42,        4,   -5,   29,
      23,  -16,   15,       42,  -26,    1,       61,  -37,  -11,       80,  -48,  -25,
     -51,   25,   73,      -32,   14,   59,      -13,    4,   46,        6,   -6,   33,
      25,  -17,   19,       44,  -28,    5,       63,  -38,   -7,       82,  -49,  -21,
     -49,   24,   77,      -29,   13,   63,      -10,    2,   50,        8,   -7,   37,
      28,  -18,   23,       47,  -29,    9,       65,  -39,   -3,       85,  -50,  -17,
     -46,   22,   81,      -27,   12,   67,       -8,    1,   54,       11,   -9,   41,
      30,  -20,   27,       49,  -30,   13,       68,  -41,    0,       87,  -52,  -13,
     -43,   21,   86,      -24,   10,   72,       -5,    0,   59,       13,  -10,   45,
      33,  -21,   31,       52,  -32,   18,       70,  -42,    5,       90,  -53,   -8,
     -41,   20,   90,      -22,    9,   76,       -3,   -1,   63,       16,  -12,   49,
      35,  -22,   35,       54,  -33,   22,       73,  -44,    9,       92,  -55,   -4,
     -39,   18,   94,      -19,    7,   80,       -1,   -2,   67,       18,  -13,   53,
      38,  -24,   39,       56,  -34,   26,       75,  -45,   13,       95,  -56,    0,
     -36,   17,   98,      -17,    6,   84,        2,   -4,   71,       21,  -14,   57,
      40,  -25,   43,       59,  -36,   30,       78,  -46,   17,       97,  -57,    3,
     -34,   15,  102,      -14,    4,   88,        5,   -5,   75,       23,  -16,   62,
      43,  -27,   48,       61,  -37,   34,       80,  -48,   21,      100,  -59,    7,
     -31,   14,  106,      -12,    3,   92,        7,   -7,   79,       26,  -17,   66,
      45,  -28,   52,       64,  -39,   38,       83,  -49,   25,      102,  -60,   11,
     -29,   13,  110,       -9,    2,   96,        9,   -8,   83,       28,  -18,   70,
      47,  -29,   56,       66,  -40,   42,       85,  -51,   29,      104,  -62,   15,
    -104,   60,  -17,      -85,   49,  -31,      -66,   39,  -44,      -47,   28,  -58,
     -28,   17,  -71,       -9,    7,  -85,       10,   -3,  -98,       29,  -14, -112,
    -102,   59,  -13,      -82,   48,  -27,      -64,   37,  -40,      -45,   27,  -54,
     -25,   16,  -67,       -7,    5,  -81,       12,   -4,  -94,       32,  -15, -108,
     -99,   58,   -9,      -80,   47,  -23,      -61,   36,  -36,      -42,   25,  -50,
     -23,   14,  -63,       -4,    4,  -77,       15,   -6,  -90,       34,  -17, -104,
     -97,   56,   -4,      -77,   45,  -18,      -58,   34,  -32,      -40,   24,  -45,
     -20,   13,  -59,       -1,    2,  -72,       17,   -7,  -86,       37,  -18,  -99,
     -94,   55,    0,      -75,   44,  -14,      -56,   33,  -28,      -37,   22,  -41,
     -18,   12,  -55,        1,    1,  -68,       20,   -9,  -82,       39,  -20,  -95,
     -92,   53,    3,      -72,   42,  -10,      -54,   32,  -24,      -35,   21,  -37,
     -15,   10,  -51,        3,    0,  -64,       22,  -10,  -78,       41,  -21,  -91,
     -89,   52,    7,      -70,   41,   -6,      -51,   30,  -20,      -32,   20,  -33,
     -13,    9,  -47,        6,   -1,  -60,       24,  -11,  -74,       44,  -22,  -87,
     -87,   50,   11,      -67,   39,   -2,      -49,   29,  -15,      -30,   18,  -29,
     -10,    7,  -42,        8,   -2,  -56,       27,  -13,  -69,       47,  -24,  -83,
     -84,   49,   15,      -65,   38,    1,      -46,   28,  -11,      -27,   17,  -25,
      -8,    6,  -38,       11,   -4,  -52,       30,  -14,  -65,       49,  -25,  -79,
     -82,   48,   19,      -63,   37,    5,      -44,   26,  