/*
 * This file is part of the OpenMV project.
 * Copyright (c) 2013/2014 Ibrahim Abdelkader <i.abdalkader@gmail.com>
 * This work is licensed under the MIT license, see the file LICENSE for details.
 *
 * Mutex.
 *
 */
#ifndef __MUTEX_H__
#define __MUTEX_H__
#include <stdint.h>
// #if MICROPY_PY_THREAD
// #include "FreeRTOS.h"
// #include "task.h"
// #include "semphr.h"
// #endif

#define MUTEX_TID_IDE (1<<0)
#define MUTEX_TID_OMV (1<<1)

typedef struct {
	uint32_t tid;
    uint32_t lock;
} mutex_t;
void mutex_init(mutex_t *mutex);
void mutex_lock(mutex_t *mutex, uint32_t tid);
int mutex_try_lock(mutex_t *mutex, uint32_t tid);
void mutex_unlock(mutex_t *mutex, uint32_t tid);
#endif /* __MUTEX_H__ */
