BEGIN TRANSACTION;
CREATE TABLE IF NOT EXISTS "batch_job" (
	"id"	INTEGER UNIQUE,
	"comment"	TEXT,
	"state"	INTEGER DEFAULT 0,
	"create_time"	TIMESTAMP DEFAULT (datetime('now', 'localtime')),
	"end_time"	TIMESTAMP,
	"task_num"	INTEGER,
	"base_json"	TEXT,
	"var_json"	TEXT,
	"config_json" TEXT,
	PRIMARY KEY("id")
);
CREATE TABLE IF NOT EXISTS "batch_task" (
	"id"	INTEGER UNIQUE,
	"job_id"	INTEGER NOT NULL,
	"state"	INTEGER NOT NULL DEFAULT 0,
	"create_time"	TIMESTAMP DEFAULT (datetime('now', 'localtime')),
	"start_time"	TIMESTAMP,
	"end_time"	TIMESTAMP,
	"is_favorite"	INTEGER,
	"var_index_json"	TEXT,
	"image_names_json"	TEXT,
	PRIMARY KEY("id")
);
CREATE INDEX IF NOT EXISTS "batch_task_index" ON "batch_task" (
	"id"	ASC,
	"job_id"	ASC,
	"state"	ASC
);
COMMIT;
