/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PTComboEditor
extends PTEditor {
    private final boolean readOnly;
    private final List<Object> data;

    public PTComboEditor(boolean readOnly, Object ... data) {
        this.readOnly = readOnly;
        this.data = new ArrayList<Object>(Arrays.asList(data));
    }

    public PTComboEditor(Object ... data) {
        this.readOnly = false;
        this.data = new ArrayList<Object>(Arrays.asList(data));
    }

    @Override
    public ControlEditor render(PTWidget widget, Item item, PTProperty property) {
        Object editor = widget.getWidget() instanceof Table ? new TableEditor((Table)widget.getWidget()) : new TreeEditor((Tree)widget.getWidget());
        CCombo combo = new CCombo(widget.getWidget(), 0x800 | (this.readOnly ? 8 : 0));
        int i = 0;
        while (i < this.data.size()) {
            Object datum = this.data.get(i);
            combo.add(datum.toString());
            if (datum.equals(property.getValue())) {
                combo.select(i);
            }
            ++i;
        }
        combo.addListener(13, event -> property.setValue(this.data.get(combo.getSelectionIndex())));
        combo.addListener(15, event -> widget.updateDescriptionPanel(property));
        editor.grabHorizontal = false;
        editor.horizontalAlignment = 16384;
        editor.minimumWidth = 200;
        if (widget.getWidget() instanceof Table) {
            editor.setEditor((Control)combo, (TableItem)item, 1);
        } else {
            ((TreeEditor)editor).setEditor((Control)combo, (TreeItem)item, 1);
        }
        return editor;
    }
}

