/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.bean.SensorBean;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import com.verisilicon.isp.tuning.ui.view.group.PopupTable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RowTableView {
    private boolean savable = false;

    public void setSavable(boolean savable) {
        this.savable = savable;
    }

    public void show(Composite parent, ParamBean paramBean, ParamGroupBean currentGroupBean, ModuleBean currentModuleBean) {
        if (!"matrix".equals(paramBean.getType())) {
            SensorBean.Mode sensorMode = PreviewDialog.getSensorMode();
            if (sensorMode == null) {
                paramBean.setIsEnabled(Boolean.valueOf(false));
                ConsoleLogger.print((String)"No sensor mode selected.");
            } else {
                SensorBean.Mode.FloatValue sensorFloatValue = sensorMode.getFloatValueByParamBeanType(paramBean.getType());
                if (sensorFloatValue == null) {
                    paramBean.setIsEnabled(Boolean.valueOf(false));
                } else {
                    paramBean.setIsEnabled(Boolean.valueOf(true));
                    paramBean.getValue().setMin(new BigDecimal(sensorFloatValue.getMin().floatValue()).setScale(3, 1));
                    paramBean.getValue().setMax(new BigDecimal(sensorFloatValue.getMax().floatValue()).setScale(3, 1));
                }
            }
        }
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        GridData gridData1 = new GridData(16384, 0x1000000, true, true, 1, 1);
        label.setLayoutData((Object)gridData1);
        label.setText(paramBean.getShowName());
        label.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        Button showTableBtn = new Button(composite, 0);
        GridData gridData2 = new GridData(4, 4, true, true, 2, 1);
        showTableBtn.setLayoutData((Object)gridData2);
        showTableBtn.setText("View");
        showTableBtn.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        showTableBtn.setBackground(Display.getCurrent().getSystemColor(1));
        showTableBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (paramBean.getValue().getRelateTable() != null) {
                    String tableName = paramBean.getValue().getRelateTable();
                    if (!$assertionsDisabled && tableName == null) {
                        throw new AssertionError();
                    }
                    for (ParamBean bean : currentGroupBean.getParams()) {
                        if (!bean.getShowName().equals(tableName) || bean.getValue().getValue() == null) continue;
                        List valueList = (List)bean.getValue().getValue();
                        ArrayList<String> titles = new ArrayList<String>();
                        int i = 0;
                        while (i < valueList.size()) {
                            titles.add(String.valueOf(String.valueOf(i)) + ": " + String.valueOf(valueList.get(i)));
                            ++i;
                        }
                        paramBean.getValue().setColTitles(titles);
                    }
                }
                PopupTable popupTable = new PopupTable();
                popupTable.setEditable(RowTableView.this.savable);
                popupTable.show(paramBean, currentModuleBean);
            }
        });
    }
}

