/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import cn.hutool.core.util.StrUtil;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.view.group.IRowView;
import java.math.BigDecimal;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class RowInputView
implements IRowView {
    private ParamBean oldParamBean;
    private Text input;
    private ParamBean.ValueBean valueBean;
    private boolean isDragging = false;
    private String lastInput;
    private final int maxScaleValue = 1000000;
    private int scaleCoef = 1;

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private String standardString(String s, ParamBean paramBean) {
        if (StrUtil.isEmpty((CharSequence)s)) {
            return null;
        }
        try {
            BigDecimal value = new BigDecimal(s);
            if (value.compareTo(paramBean.getValue().getMin()) < 0) {
                value = paramBean.getValue().getMin();
            }
            if (value.compareTo(paramBean.getValue().getMax()) > 0) {
                value = paramBean.getValue().getMax();
            }
            return paramBean.getValue().getDecimals() == null ? value.setScale(0, 1).toString() : value.setScale((int)paramBean.getValue().getDecimals(), 1).toString();
        }
        catch (Exception e) {
            System.out.println("!Error! " + paramBean.getShowName() + ":" + e.getMessage());
            assert (false);
            return null;
        }
    }

    public void show(Composite parent, ParamBean paramBean, ModuleBean currentModuleBean) {
        BigDecimal adjustDecimal;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        GridData gridData1 = new GridData(16384, 0x1000000, true, true, 1, 1);
        label.setLayoutData((Object)gridData1);
        label.setText(paramBean.getShowName());
        label.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        this.input = new Text(composite, 0);
        GridData gridData2 = new GridData(4, 0x1000000, true, true, 1, 1);
        this.input.setBackground(Display.getCurrent().getSystemColor(1));
        this.input.setLayoutData((Object)gridData2);
        this.lastInput = this.standardString(paramBean.getText(), paramBean);
        this.input.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        this.input.setToolTipText("Value Range: [" + this.standardString(paramBean.getValue().getMin().toString(), paramBean) + ", " + this.standardString(paramBean.getValue().getMax().toString(), paramBean) + "]");
        this.input.setText(this.lastInput == null ? "" : this.lastInput);
        Scale scale = new Scale(composite, 256);
        GridData gridData3 = new GridData(4, 4, true, true, 1, 1);
        scale.setLayoutData((Object)gridData3);
        scale.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        scale.setToolTipText("Value Range: [" + this.standardString(paramBean.getValue().getMin().toString(), paramBean) + ", " + this.standardString(paramBean.getValue().getMax().toString(), paramBean) + "]");
        this.valueBean = paramBean.getValue();
        Integer factor = 1;
        int i = 0;
        while (i < this.valueBean.getDecimals()) {
            factor = factor * 10;
            ++i;
        }
        BigDecimal factorDecimal = new BigDecimal(factor.toString());
        BigDecimal bigDecimal = adjustDecimal = this.valueBean.getMin().compareTo(BigDecimal.ZERO) < 0 ? this.valueBean.getMin().negate().multiply(factorDecimal) : BigDecimal.ZERO;
        if (this.valueBean.getMax() != null && this.valueBean.getMin() != null) {
            assert (this.valueBean.getMax().multiply(factorDecimal).add(adjustDecimal).compareTo(new BigDecimal(String.valueOf(Integer.MAX_VALUE))) <= 0);
            int maxValue = this.valueBean.getMax().multiply(factorDecimal).add(adjustDecimal).intValue();
            int minValue = this.valueBean.getMin().multiply(factorDecimal).add(adjustDecimal).intValue();
            int diff = maxValue - minValue;
            while (diff / this.scaleCoef > 1000000) {
                this.scaleCoef *= 10;
            }
            scale.setMaximum(maxValue / this.scaleCoef);
            scale.setMinimum(minValue / this.scaleCoef);
        }
        String valueStr = paramBean.getText();
        try {
            BigDecimal valueDecimal = StrUtil.isEmpty((CharSequence)valueStr) ? this.valueBean.getMin() : new BigDecimal(valueStr);
            scale.setSelection(valueDecimal.multiply(factorDecimal).add(adjustDecimal).intValue() / this.scaleCoef);
        }
        catch (Exception exception) {
            assert (false);
            ConsoleLogger.printWarningMsg((String)(" Wrong format! expect a number value: " + valueStr));
            return;
        }
        this.input.addListener(27, e -> {
            String currentInput = this.input.getText();
            if (!this.inputCheck(currentInput)) {
                this.input.setText(this.lastInput == null ? "" : this.lastInput);
                return;
            }
            currentInput = this.standardString(currentInput, paramBean);
            this.input.setText(currentInput);
            if (!(this.lastInput != null && currentInput.compareTo(this.lastInput) == 0 || this.isDragging)) {
                this.oldParamBean = paramBean.clone();
                if (this.valueBean.getDecimals() == 0) {
                    this.valueBean.setCurrentValue((Object)Integer.valueOf(currentInput));
                } else {
                    this.valueBean.setCurrentValue((Object)new BigDecimal(currentInput));
                }
                scale.setSelection(factorDecimal.multiply(new BigDecimal(currentInput)).add(adjustDecimal).intValue() / this.scaleCoef);
                ParamBean newParamBean = paramBean.clone();
                EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)this.oldParamBean, (Object)newParamBean);
                this.lastInput = currentInput;
            }
            if (paramBean.getValue().getRelateCurve() != null) {
                CallbackManager cbManager = CallbackManager.getInstance();
                CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getValue().getRelateCurve());
                EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
            }
        });
        this.input.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    RowInputView.this.input.notifyListeners(27, new Event());
                }
            }
        });
        scale.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                RowInputView.this.isDragging = true;
            }

            public void mouseUp(MouseEvent e) {
                RowInputView.this.isDragging = false;
                scale.notifyListeners(13, new Event());
            }
        });
        scale.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String str;
                if (RowInputView.this.scaleCoef > 1) {
                    str = scale.getSelection() == scale.getMaximum() ? String.valueOf(paramBean.getValue().getMax().multiply(factorDecimal).add(adjustDecimal).intValue()) : (scale.getSelection() == scale.getMinimum() ? String.valueOf(paramBean.getValue().getMin().multiply(factorDecimal).add(adjustDecimal).intValue()) : String.valueOf(scale.getSelection() * RowInputView.this.scaleCoef));
                } else {
                    if (!$assertionsDisabled && RowInputView.this.scaleCoef != 1) {
                        throw new AssertionError();
                    }
                    str = String.valueOf(scale.getSelection());
                }
                String actualValue = new BigDecimal(str).subtract(adjustDecimal).divide(factorDecimal).toString();
                if (RowInputView.this.inputCheck(actualValue)) {
                    actualValue = RowInputView.this.standardString(actualValue, paramBean);
                    RowInputView.this.input.setText(actualValue);
                    if (!RowInputView.this.isDragging) {
                        RowInputView.this.input.notifyListeners(27, new Event());
                    }
                }
            }
        });
        scale.addListener(37, event -> {
            boolean bl = event.doit = false;
        });
        scale.addListener(1, event -> {
            boolean bl = event.doit = false;
        });
        if (paramBean.getKey().equals("standardVal")) {
            Boolean state = (Boolean)currentModuleBean.findParamBeanByKey("isStandard").getValue().getCurrentValue();
            if (state == null) {
                return;
            }
            if (!state.booleanValue()) {
                this.input.setEnabled(false);
                scale.setEnabled(false);
            }
        }
    }

    @Override
    public void show(Composite parent, ParamBean paramBean) {
    }
}

