/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import com.verisilicon.isp.tuning.ui.view.dialog.DrawRoiDialog;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import com.verisilicon.isp.tuning.ui.view.group.IRowView;
import java.util.ArrayList;
import java.util.Base64;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RowImageTableView
implements IRowView {
    private static final String BASE64_PREFIX = "data:image/yuv;base64,";

    public void show(Composite parent, ParamBean paramBean, ModuleBean currentModuleBean) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, true));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        label.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        label.setText(paramBean.getShowName());
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        button.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        button.setText("View");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ArrayList<ParamBean> requestParams = new ArrayList<ParamBean>();
                    ParamBean snapNumParamBean = new ParamBean("snapshotNumber", "range");
                    snapNumParamBean.getValue().setCurrentValue((Object)1);
                    snapNumParamBean.setCategory("OPT");
                    requestParams.add(snapNumParamBean);
                    int i = 0;
                    while (i < requestParams.size()) {
                        JSONObject paramObject = new JSONObject();
                        paramObject.set("category", (Object)((ParamBean)requestParams.get(i)).getCategory());
                        paramObject.set("key", (Object)((ParamBean)requestParams.get(i)).getKey());
                        paramObject.set("type", (Object)((ParamBean)requestParams.get(i)).getType());
                        JSONObject valueObject = new JSONObject();
                        valueObject.set("current", ((ParamBean)requestParams.get(i)).getValue().getValue());
                        paramObject.set("value", (Object)valueObject);
                        try {
                            ClientHolder.getInstance().sendSyncRequest(paramObject.toString());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        ++i;
                    }
                    ArrayList<ParamBean> responseParams = new ArrayList<ParamBean>();
                    ParamBean imageParamBean = new ParamBean("images", "file");
                    imageParamBean.setCategory("OPT");
                    responseParams.add(imageParamBean);
                    String responseStr = null;
                    int i2 = 0;
                    while (i2 < responseParams.size()) {
                        JSONObject paramObject = new JSONObject();
                        paramObject.set("category", (Object)((ParamBean)responseParams.get(i2)).getCategory());
                        paramObject.set("key", (Object)((ParamBean)responseParams.get(i2)).getKey());
                        paramObject.set("type", (Object)((ParamBean)responseParams.get(i2)).getType());
                        try {
                            responseStr = ClientHolder.getInstance().sendSyncRequest(paramObject.toString());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        ++i2;
                    }
                    JSONObject responseJson = new JSONObject(responseStr).getJSONObject((Object)"value");
                    JSONArray currentValueJson = responseJson.getJSONArray((Object)"current");
                    String base64Str = currentValueJson.getStr((Object)0).toString();
                    base64Str = base64Str.replaceFirst(RowImageTableView.BASE64_PREFIX, "");
                    Base64.Decoder decoder = Base64.getDecoder();
                    byte[] currentData = decoder.decode(base64Str);
                    int width = PreviewDialog.getWidth();
                    int height = PreviewDialog.getHeight();
                    String format = PreviewDialog.getFormat();
                    byte[] rgbBytes = new byte[width * height * 3];
                    switch (format) {
                        case "YUV422 Semi-Planar": {
                            ImageFormatConverter.NV162RGB((byte[])currentData, (int)width, (int)height, (byte[])rgbBytes);
                            break;
                        }
                        case "YUV422 Interleaved": {
                            ImageFormatConverter.YUV422I2RGB((byte[])currentData, (int)width, (int)height, (byte[])rgbBytes);
                            break;
                        }
                        case "YUV420 Semi-Planar": {
                            ImageFormatConverter.YUV420SP2RGB((byte[])currentData, (int)width, (int)height, (byte[])rgbBytes);
                            break;
                        }
                        case "YUV444 Planer": {
                            ImageFormatConverter.YUV444P2RGB((byte[])currentData, (int)width, (int)height, (byte[])rgbBytes);
                            break;
                        }
                        case "YUV444 Interleaved": {
                            ImageFormatConverter.YUV444I2RGB((byte[])currentData, (int)width, (int)height, (byte[])rgbBytes);
                            break;
                        }
                        default: {
                            ConsoleLogger.printWarningMsg((String)(String.valueOf(format) + "is not support format"));
                            return;
                        }
                    }
                    ImageData imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
                    imageData.data = rgbBytes;
                    Image image = new Image((Device)Display.getDefault(), imageData);
                    Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
                    DrawRoiDialog drawRoi = new DrawRoiDialog(shell, currentModuleBean, paramBean, image);
                    drawRoi.open();
                }
                catch (Exception exception) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"warning", (String)"Please confirm that preview is lanched");
                }
            }
        });
    }

    @Override
    public void show(Composite parent, ParamBean paramBean) {
    }
}

