/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.ui.core.UIPlugin;
import com.verisilicon.isp.tuning.ui.view.group.IRowView;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RowComboView
implements IRowView {
    public void show(Composite parent, ParamBean paramBean, ModuleBean currentModuleBean) {
        ParamBean.ValueBean valueBean;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        GridData gridData1 = new GridData(16384, 0x1000000, true, true, 1, 1);
        label.setLayoutData((Object)gridData1);
        label.setText(paramBean.getShowName());
        label.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        Combo combo = new Combo(composite, 8);
        GridData gridData2 = new GridData(4, 4, true, true, 2, 1);
        combo.setLayoutData((Object)gridData2);
        combo.setBackground(Display.getCurrent().getSystemColor(1));
        combo.setEnabled(currentModuleBean.getModuleEnable() != false && paramBean.getIsEnabled() != false);
        if (paramBean.getKey().equals("modeSwitch")) {
            label.setEnabled(true);
            combo.setEnabled(true);
        }
        if ((valueBean = paramBean.getValue()).getOptions() != null) {
            for (String option : valueBean.getOptions()) {
                combo.add(option);
            }
            Object currentValue = valueBean.getValue();
            if (currentValue != null) {
                if (currentValue instanceof String) {
                    combo.select(valueBean.getOptions().indexOf((String)currentValue));
                } else if (currentValue instanceof Integer) {
                    combo.select(((Integer)currentValue).intValue());
                } else assert (false);
            } else {
                combo.select(0);
            }
        }
        combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Integer selectionIndex = combo.getSelectionIndex();
                valueBean.setCurrentValue((Object)selectionIndex);
                if (paramBean.getKey().equals("modeSwitch")) {
                    ModuleBean newModuleBean = null;
                    if ((Integer)valueBean.getCurrentValue() == 0) {
                        if (!currentModuleBean.getShowName().startsWith("Auto")) {
                            newModuleBean = ModuleDataCenter.getInstance().getModuleBeanByShowName("Auto " + currentModuleBean.getShowName());
                        }
                    } else if (currentModuleBean.getShowName().startsWith("Auto")) {
                        newModuleBean = ModuleDataCenter.getInstance().getModuleBeanByShowName(currentModuleBean.getShowName().substring(currentModuleBean.getShowName().indexOf(" ") + 1, currentModuleBean.getShowName().length()));
                    }
                    UIPlugin.getInstance().showDetailEditor();
                    if (newModuleBean != null) {
                        ((ParamBean)((ParamGroupBean)newModuleBean.getParamGroups().get(0)).getParams().get(0)).getValue().setCurrentValue(valueBean.getCurrentValue());
                        ModuleDataCenter.getInstance().changeCurrentModule(newModuleBean);
                        EventManager.getInstance().notifyEvent("EVENT_TEMPLATE_CHANGED", (Object)ModuleDataCenter.getInstance().getCurrentTemplate());
                        EventManager.getInstance().notifyEvent("EVENT_MODULE_CHANGED", (Object)newModuleBean);
                    }
                } else {
                    ParamBean oldParamBean = paramBean.clone();
                    ParamBean newParamBean = paramBean.clone();
                    EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)oldParamBean, (Object)newParamBean);
                    if (paramBean.getValue().getRelateCurve() != null) {
                        CallbackManager cbManager = CallbackManager.getInstance();
                        CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getValue().getRelateCurve());
                        EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
                    }
                }
            }
        });
    }

    @Override
    public void show(Composite parent, ParamBean paramBean) {
    }
}

