/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import cn.hutool.core.text.csv.CsvData;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.text.csv.CsvWriter;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PopupTable {
    private Boolean isDirty = false;
    private ParamBean paramBean;
    private boolean editable = false;

    public void setEditable(boolean savable) {
        this.editable = savable;
    }

    private boolean inputCheck(String input) {
        if (this.paramBean.getValue().getMax() == null && this.paramBean.getValue().getMin() == null || this.paramBean.getValue().getDecimals() == null) {
            return input.equals("false") || input.equals("true");
        }
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private String standardString(String s, ParamBean paramBean) {
        if (paramBean.getValue().getMax() == null && paramBean.getValue().getMin() == null || paramBean.getValue().getDecimals() == null) {
            return s;
        }
        BigDecimal value = new BigDecimal(s);
        if (paramBean.getValue().getMin() != null && value.compareTo(paramBean.getValue().getMin()) < 0) {
            value = paramBean.getValue().getMin();
        }
        if (paramBean.getValue().getMax() != null && value.compareTo(paramBean.getValue().getMax()) > 0) {
            value = paramBean.getValue().getMax();
        }
        return paramBean.getValue().getDecimals() == null ? value.setScale(0, 1).toString() : value.setScale((int)paramBean.getValue().getDecimals(), 1).toString();
    }

    void show(ParamBean paramBean, ModuleBean currentModuleBean) {
        Shell shell = Display.getCurrent().getActiveShell();
        this.paramBean = paramBean;
        TableViewerDialog dialog = new TableViewerDialog(shell);
        dialog.setParamBean(paramBean);
        dialog.setCurrentModuleBean(currentModuleBean);
        dialog.open();
    }

    protected class ContentProvider
    implements IStructuredContentProvider {
        protected ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class MyTextCellEditor
    extends TextCellEditor {
        public MyTextCellEditor(Composite parent) {
            super(parent);
        }

        public void doSetValue(Object value) {
            if (value == null) {
                return;
            }
            EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", null);
            super.doSetValue(value);
        }
    }

    protected class TableCellModifier
    implements ICellModifier {
        private TableViewer tableViewer;
        private ParamBean paramBean;
        private List<String> columnProperties;
        private int page;
        private int count;

        public TableCellModifier(TableViewer tableViewer, List<String> columnProperties, ParamBean paramBean, int page, int count) {
            this.tableViewer = tableViewer;
            this.columnProperties = columnProperties;
            this.paramBean = paramBean;
            this.page = page;
            this.count = count;
        }

        public boolean canModify(Object element, String property) {
            return PopupTable.this.editable;
        }

        public Object getValue(Object element, String property) {
            int index = this.columnProperties.indexOf(property);
            if (element instanceof ArrayList) {
                return ((ArrayList)element).get(index);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            if (StrUtil.isBlank((CharSequence)((String)value))) {
                return;
            }
            String valueStr = value.toString();
            int rowIndex = this.tableViewer.getTable().getSelectionIndex();
            int col = this.columnProperties.indexOf(property);
            ArrayList rows = (ArrayList)this.tableViewer.getInput();
            ArrayList rowValueArray = (ArrayList)rows.get(rowIndex);
            Object oldValue = rowValueArray.get(col);
            if (!PopupTable.this.inputCheck(valueStr)) {
                return;
            }
            valueStr = PopupTable.this.standardString(valueStr, this.paramBean);
            if (!oldValue.toString().equals(valueStr)) {
                PopupTable.this.isDirty = true;
                rowValueArray.set(col, valueStr);
                this.tableViewer.update((Object)rowValueArray, null);
            }
        }
    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof List) {
                List strArray = (List)element;
                if (columnIndex >= strArray.size()) {
                    return "";
                }
                return (String)strArray.get(columnIndex);
            }
            assert (false);
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class TableViewerDialog
    extends Dialog {
        private ModuleBean currentModuleBean;
        private ParamBean paramBean;
        private Table table;
        private TableViewer tableViewer;
        private int page;
        private Button pageUpBtn;
        private Button pageDownBtn;
        private Text pageText;
        private int totalColCount;
        int count;
        List<List<String>> rows;
        List<String> columnTitles;
        boolean isTransed;

        public TableViewerDialog(Shell parentShell) {
            super(parentShell);
            this.page = 0;
            this.totalColCount = 0;
            this.count = 20;
            this.rows = new ArrayList<List<String>>();
            this.columnTitles = new ArrayList<String>();
            this.isTransed = false;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            String title = this.paramBean.getShowName();
            if (this.paramBean.getValue().getMax() != null && this.paramBean.getValue().getMin() != null) {
                title = String.valueOf(title) + " [" + this.paramBean.getValue().getMin().toString() + " - " + this.paramBean.getValue().getMax().toString() + "]";
            }
            shell.setText(title);
        }

        protected boolean isResizable() {
            return true;
        }

        private void updatePageButton() {
            this.pageDownBtn.setEnabled(this.page * this.count + this.count < this.totalColCount);
            this.pageUpBtn.setEnabled(this.page > 0);
            this.pageText.setText(String.valueOf(this.page * this.count + 1) + "- " + (this.page * this.count + this.count > this.totalColCount ? this.totalColCount : this.page * this.count + this.count) + "/ " + this.totalColCount);
        }

        private void updateTable() {
            this.table.removeAll();
            while (this.table.getColumnCount() > 0) {
                this.table.getColumns()[0].dispose();
            }
            ArrayList<String> columnProperties = new ArrayList<String>(this.columnTitles.subList(this.page * this.count, this.page * this.count + this.count > this.totalColCount ? this.totalColCount : this.page * this.count + this.count));
            int currentColCount = columnProperties.size();
            ArrayList<ArrayList<String>> data = new ArrayList<ArrayList<String>>();
            CellEditor[] editors = new CellEditor[currentColCount];
            for (List<String> singleRow : this.rows) {
                data.add(new ArrayList<String>(singleRow.subList(this.page * this.count, this.page * this.count + this.count > this.totalColCount ? this.totalColCount : this.page * this.count + this.count)));
            }
            int i = 0;
            while (i < currentColCount) {
                TableColumn col = new TableColumn(this.table, 0);
                col.setWidth(100);
                col.setText((String)columnProperties.get(i));
                col.setResizable(true);
                MyTextCellEditor textEditor = new MyTextCellEditor((Composite)this.table);
                ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

                    public void verifyText(VerifyEvent e) {
                        e.doit = e.text.length() <= 1 ? (TableViewerDialog.this.paramBean.getValue().getMax() == null && TableViewerDialog.this.paramBean.getValue().getMin() == null || TableViewerDialog.this.paramBean.getValue().getDecimals() == null ? "falsetrue".indexOf(e.text) >= 0 : "-.0123456789".indexOf(e.text) >= 0) : true;
                    }
                });
                editors[i] = textEditor;
                ++i;
            }
            this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier(this.tableViewer, columnProperties, this.paramBean, this.page, this.count));
            this.tableViewer.setCellEditors(editors);
            this.tableViewer.setInput(data);
            this.tableViewer.setColumnProperties(columnProperties.toArray(new String[columnProperties.size()]));
        }

        private void loadData() {
            this.totalColCount = 0;
            this.columnTitles = new ArrayList<String>();
            if (this.paramBean.getValue().getColTitles() != null) {
                for (Object title : this.paramBean.getValue().getColTitles()) {
                    this.columnTitles.add(title.toString());
                }
                this.totalColCount = this.paramBean.getValue().getColTitles().size();
            }
            ArrayList<String> singleRow = new ArrayList<String>();
            JSONArray jsonArray = (JSONArray)this.paramBean.getValue().getValue();
            if (jsonArray == null) {
                return;
            }
            for (Object object : jsonArray) {
                if (object instanceof JSONArray) {
                    JSONArray rowJsonArray = (JSONArray)object;
                    if (this.totalColCount == 0) {
                        int i = 0;
                        while (i < rowJsonArray.size()) {
                            this.columnTitles.add(String.valueOf(i + 1));
                            ++i;
                        }
                        this.totalColCount = rowJsonArray.size();
                    }
                    ArrayList<String> row = new ArrayList<String>();
                    for (Object rowObject : rowJsonArray) {
                        if (this.paramBean.getValue().getDecimals() != null) {
                            row.add(new BigDecimal(rowObject.toString()).setScale((int)this.paramBean.getValue().getDecimals(), 1).toString());
                            continue;
                        }
                        if (rowObject instanceof Integer) {
                            row.add(((Integer)rowObject).toString());
                            continue;
                        }
                        assert (false);
                    }
                    this.rows.add(row);
                    continue;
                }
                if (this.totalColCount == 0) {
                    int i = 0;
                    while (i < jsonArray.size()) {
                        this.columnTitles.add(String.valueOf(i + 1));
                        ++i;
                    }
                    this.totalColCount = jsonArray.size();
                }
                if (this.paramBean.getValue().getDecimals() != null) {
                    singleRow.add(new BigDecimal(object.toString()).setScale((int)this.paramBean.getValue().getDecimals(), 1).toString());
                    continue;
                }
                if (object instanceof Integer) {
                    singleRow.add(((Integer)object).toString());
                    continue;
                }
                if (object instanceof Boolean) {
                    singleRow.add(String.valueOf(object));
                    continue;
                }
                assert (false);
            }
            if (singleRow.size() > 0) {
                this.rows.add(singleRow);
            }
            if (this.paramBean.getValue().getRelateTable() != null && this.rows.size() > 1) {
                this.rows = this.transMatrix(this.rows);
                this.isTransed = true;
            }
        }

        private List<List<String>> transMatrix(List<List<String>> matrix) {
            ArrayList<List<String>> newRows = new ArrayList<List<String>>();
            int i = 0;
            while (i < matrix.get(0).size()) {
                ArrayList<String> colValues = new ArrayList<String>();
                int j = 0;
                while (j < matrix.size()) {
                    colValues.add(matrix.get(j).get(i));
                    ++j;
                }
                newRows.add(colValues);
                ++i;
            }
            return newRows;
        }

        protected Control createDialogArea(Composite parent) {
            assert (this.paramBean != null);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setLayoutData((Object)new GridData(1808));
            this.tableViewer = new TableViewer(composite, 68354);
            this.tableViewer.setContentProvider((IContentProvider)new ContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            this.table = this.tableViewer.getTable();
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.loadData();
            this.updateTable();
            return null;
        }

        private void importMatrix() {
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            fileDialog.setFilterNames(new String[]{"TuningTool Matrix data(*.csv)", "All Files(*.*)"});
            fileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
            fileDialog.setFilterPath(System.getProperty("user.dir"));
            fileDialog.setText("Open");
            String fileName = fileDialog.open();
            if (fileName != null) {
                Path filePath = Paths.get(fileName, new String[0]);
                CsvReader reader = CsvUtil.getReader();
                CsvData data = reader.read(filePath, CharsetUtil.CHARSET_GBK);
                List csvrows = data.getRows();
                this.rows = new ArrayList<List<String>>();
                ArrayList<CsvRow> invalidRows = new ArrayList<CsvRow>();
                for (CsvRow temp : csvrows) {
                    List rowValues = temp.getRawList();
                    int i = 0;
                    while (i < rowValues.size()) {
                        BigDecimal v = new BigDecimal((String)rowValues.get(i));
                        if (this.paramBean.getValue().getMin() != null && v.compareTo(this.paramBean.getValue().getMin()) < 0 || this.paramBean.getValue().getMax() != null && v.compareTo(this.paramBean.getValue().getMax()) > 0) {
                            if (!invalidRows.contains(temp)) {
                                invalidRows.add(temp);
                            }
                            rowValues.set(i, PopupTable.this.standardString((String)rowValues.get(i), this.paramBean));
                        }
                        ++i;
                    }
                    this.rows.add(rowValues);
                }
                if (invalidRows.size() > 0) {
                    ArrayList<Long> invalidIndex = new ArrayList<Long>();
                    int i = 0;
                    while (i < invalidRows.size()) {
                        invalidIndex.add(((CsvRow)invalidRows.get(i)).getOriginalLineNumber());
                        ++i;
                    }
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)("Fix Values Out of Range : row " + invalidIndex));
                }
                this.page = 0;
                this.updateTable();
                this.updatePageButton();
                ConsoleLogger.print((String)("Load data from " + fileName + " success."));
                this.saveTableData();
            }
        }

        private void exportMatrix() {
            this.okPressed();
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            fileDialog.setFilterNames(new String[]{"TuningTool Matrix Data(*.csv)", "All Files(*.*)"});
            fileDialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
            fileDialog.setFilterPath(System.getProperty("user.dir"));
            fileDialog.setFileName(String.valueOf(this.paramBean.getCategory()) + "_" + this.paramBean.getKey() + "_" + System.currentTimeMillis() + ".csv");
            fileDialog.setText("Save");
            String fileName = fileDialog.open();
            if (fileName != null) {
                CsvWriter writer = CsvUtil.getWriter((String)fileName, (Charset)CharsetUtil.CHARSET_GBK);
                new ArrayList();
                int row = 0;
                while (row < this.rows.size()) {
                    List<String> rowValues = this.rows.get(row);
                    String[] temp = rowValues.toArray(new String[rowValues.size()]);
                    writer.writeLine(temp);
                    ++row;
                }
                writer.close();
                ConsoleLogger.print((String)("Save data to " + fileName + " success."));
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            ++((GridLayout)parent.getLayout()).numColumns;
            this.pageUpBtn = new Button(parent, 0);
            this.pageUpBtn.setText("<");
            this.setButtonLayoutData(this.pageUpBtn);
            this.pageUpBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog.this.updateData();
                    TableViewerDialog tableViewerDialog = TableViewerDialog.this;
                    tableViewerDialog.page = tableViewerDialog.page - 1;
                    TableViewerDialog.this.updateTable();
                    TableViewerDialog.this.updatePageButton();
                }
            });
            ++((GridLayout)parent.getLayout()).numColumns;
            this.pageText = new Text(parent, 0x1000000);
            this.pageText.setEnabled(false);
            GridData data = new GridData(256);
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            Point minSize = this.pageText.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minSize.x);
            this.pageText.setLayoutData((Object)data);
            ++((GridLayout)parent.getLayout()).numColumns;
            this.pageDownBtn = new Button(parent, 0);
            this.pageDownBtn.setText(">");
            this.setButtonLayoutData(this.pageDownBtn);
            this.pageDownBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog.this.updateData();
                    TableViewerDialog tableViewerDialog = TableViewerDialog.this;
                    tableViewerDialog.page = tableViewerDialog.page + 1;
                    TableViewerDialog.this.updateTable();
                    TableViewerDialog.this.updatePageButton();
                }
            });
            this.updatePageButton();
            ++((GridLayout)parent.getLayout()).numColumns;
            Button importButton = new Button(parent, 0);
            importButton.setText("Import");
            importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog.this.importMatrix();
                }
            });
            this.setButtonLayoutData(importButton);
            ++((GridLayout)parent.getLayout()).numColumns;
            Button exportButton = new Button(parent, 0);
            exportButton.setText("Export");
            exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableViewerDialog.this.exportMatrix();
                }
            });
            this.setButtonLayoutData(exportButton);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        }

        protected void okPressed() {
            if (PopupTable.this.isDirty.booleanValue()) {
                this.updateData();
                this.saveTableData();
                PopupTable.this.isDirty = false;
            }
            if (this.paramBean.getValue().getRelateCurve() != null) {
                CallbackManager cbManager = CallbackManager.getInstance();
                CallbackManager.processCallback((ModuleBean)this.currentModuleBean, (String)this.paramBean.getCategory(), (String)this.paramBean.getValue().getRelateCurve());
                EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
            }
            super.okPressed();
        }

        void saveTableData() {
            ParamBean.ValueBean valueBean = this.paramBean.getValue();
            ParamBean oldParamBean = this.paramBean.clone();
            JSONArray jsonArray = (JSONArray)valueBean.getValue();
            assert (jsonArray != null);
            if (this.isTransed) {
                this.rows = this.transMatrix(this.rows);
            }
            int row = 0;
            while (row < this.rows.size()) {
                List<String> rowValues = this.rows.get(row);
                Object rowObject = jsonArray.get(row);
                int col = 0;
                while (col < rowValues.size()) {
                    String value = rowValues.get(col);
                    Object colObject = null;
                    if (rowObject instanceof JSONArray) {
                        JSONArray rowJsonArray = (JSONArray)rowObject;
                        colObject = rowJsonArray.get(col);
                        if (valueBean.getDecimals() != null) {
                            rowJsonArray.set(col, (Object)new BigDecimal(value));
                        } else if (colObject instanceof Integer) {
                            rowJsonArray.set(col, (Object)Integer.valueOf(value));
                        } else assert (false);
                    } else {
                        assert (row == 0);
                        colObject = jsonArray.get(col);
                        if (valueBean.getDecimals() != null) {
                            jsonArray.set(col, (Object)new BigDecimal(value));
                        } else if (colObject instanceof Integer) {
                            jsonArray.set(col, (Object)Integer.valueOf(value));
                        } else if (colObject instanceof Boolean) {
                            jsonArray.set(col, (Object)Boolean.valueOf(value));
                        } else assert (false);
                    }
                    ++col;
                }
                ++row;
            }
            ParamBean newParamBean = this.paramBean.clone();
            EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)oldParamBean, (Object)newParamBean);
        }

        void updateData() {
            int rowCount = this.table.getItemCount();
            int colCount = this.table.getColumnCount();
            int row = 0;
            while (row < rowCount) {
                TableItem item = this.table.getItem(row);
                int col = 0;
                while (col < colCount) {
                    this.rows.get(row).set(this.page * this.count + col, item.getText(col));
                    ++col;
                }
                ++row;
            }
        }

        public ModuleBean getCurrentModuleBean() {
            return this.currentModuleBean;
        }

        public ParamBean getParamBean() {
            return this.paramBean;
        }

        public Table getTable() {
            return this.table;
        }

        public TableViewer getTableViewer() {
            return this.tableViewer;
        }

        public int getPage() {
            return this.page;
        }

        public Button getPageUpBtn() {
            return this.pageUpBtn;
        }

        public Button getPageDownBtn() {
            return this.pageDownBtn;
        }

        public Text getPageText() {
            return this.pageText;
        }

        public int getTotalColCount() {
            return this.totalColCount;
        }

        public int getCount() {
            return this.count;
        }

        public List<List<String>> getRows() {
            return this.rows;
        }

        public List<String> getColumnTitles() {
            return this.columnTitles;
        }

        public boolean isTransed() {
            return this.isTransed;
        }

        public void setCurrentModuleBean(ModuleBean currentModuleBean) {
            this.currentModuleBean = currentModuleBean;
        }

        public void setParamBean(ParamBean paramBean) {
            this.paramBean = paramBean;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public void setTableViewer(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public void setPageUpBtn(Button pageUpBtn) {
            this.pageUpBtn = pageUpBtn;
        }

        public void setPageDownBtn(Button pageDownBtn) {
            this.pageDownBtn = pageDownBtn;
        }

        public void setPageText(Text pageText) {
            this.pageText = pageText;
        }

        public void setTotalColCount(int totalColCount) {
            this.totalColCount = totalColCount;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setRows(List<List<String>> rows) {
            this.rows = rows;
        }

        public void setColumnTitles(List<String> columnTitles) {
            this.columnTitles = columnTitles;
        }

        public void setTransed(boolean isTransed) {
            this.isTransed = isTransed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TableViewerDialog)) {
                return false;
            }
            TableViewerDialog other = (TableViewerDialog)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.getPage() != other.getPage()) {
                return false;
            }
            if (this.getTotalColCount() != other.getTotalColCount()) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.isTransed() != other.isTransed()) {
                return false;
            }
            ModuleBean this$currentModuleBean = this.getCurrentModuleBean();
            ModuleBean other$currentModuleBean = other.getCurrentModuleBean();
            if (this$currentModuleBean == null ? other$currentModuleBean != null : !this$currentModuleBean.equals(other$currentModuleBean)) {
                return false;
            }
            ParamBean this$paramBean = this.getParamBean();
            ParamBean other$paramBean = other.getParamBean();
            if (this$paramBean == null ? other$paramBean != null : !this$paramBean.equals(other$paramBean)) {
                return false;
            }
            Table this$table = this.getTable();
            Table other$table = other.getTable();
            if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
                return false;
            }
            TableViewer this$tableViewer = this.getTableViewer();
            TableViewer other$tableViewer = other.getTableViewer();
            if (this$tableViewer == null ? other$tableViewer != null : !this$tableViewer.equals(other$tableViewer)) {
                return false;
            }
            Button this$pageUpBtn = this.getPageUpBtn();
            Button other$pageUpBtn = other.getPageUpBtn();
            if (this$pageUpBtn == null ? other$pageUpBtn != null : !this$pageUpBtn.equals(other$pageUpBtn)) {
                return false;
            }
            Button this$pageDownBtn = this.getPageDownBtn();
            Button other$pageDownBtn = other.getPageDownBtn();
            if (this$pageDownBtn == null ? other$pageDownBtn != null : !this$pageDownBtn.equals(other$pageDownBtn)) {
                return false;
            }
            Text this$pageText = this.getPageText();
            Text other$pageText = other.getPageText();
            if (this$pageText == null ? other$pageText != null : !this$pageText.equals(other$pageText)) {
                return false;
            }
            List<List<String>> this$rows = this.getRows();
            List<List<String>> other$rows = other.getRows();
            if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
                return false;
            }
            List<String> this$columnTitles = this.getColumnTitles();
            List<String> other$columnTitles = other.getColumnTitles();
            return !(this$columnTitles == null ? other$columnTitles != null : !((Object)this$columnTitles).equals(other$columnTitles));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TableViewerDialog;
        }

        public int hashCode() {
            int result = 1;
            result = result * 59 + this.getPage();
            result = result * 59 + this.getTotalColCount();
            result = result * 59 + this.getCount();
            result = result * 59 + (this.isTransed() ? 79 : 97);
            ModuleBean $currentModuleBean = this.getCurrentModuleBean();
            result = result * 59 + ($currentModuleBean == null ? 43 : $currentModuleBean.hashCode());
            ParamBean $paramBean = this.getParamBean();
            result = result * 59 + ($paramBean == null ? 43 : $paramBean.hashCode());
            Table $table = this.getTable();
            result = result * 59 + ($table == null ? 43 : $table.hashCode());
            TableViewer $tableViewer = this.getTableViewer();
            result = result * 59 + ($tableViewer == null ? 43 : $tableViewer.hashCode());
            Button $pageUpBtn = this.getPageUpBtn();
            result = result * 59 + ($pageUpBtn == null ? 43 : $pageUpBtn.hashCode());
            Button $pageDownBtn = this.getPageDownBtn();
            result = result * 59 + ($pageDownBtn == null ? 43 : $pageDownBtn.hashCode());
            Text $pageText = this.getPageText();
            result = result * 59 + ($pageText == null ? 43 : $pageText.hashCode());
            List<List<String>> $rows = this.getRows();
            result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
            List<String> $columnTitles = this.getColumnTitles();
            result = result * 59 + ($columnTitles == null ? 43 : ((Object)$columnTitles).hashCode());
            return result;
        }

        public String toString() {
            return "PopupTable.TableViewerDialog(currentModuleBean=" + this.getCurrentModuleBean() + ", paramBean=" + this.getParamBean() + ", table=" + this.getTable() + ", tableViewer=" + this.getTableViewer() + ", page=" + this.getPage() + ", pageUpBtn=" + this.getPageUpBtn() + ", pageDownBtn=" + this.getPageDownBtn() + ", pageText=" + this.getPageText() + ", totalColCount=" + this.getTotalColCount() + ", count=" + this.getCount() + ", rows=" + this.getRows() + ", columnTitles=" + this.getColumnTitles() + ", isTransed=" + this.isTransed() + ")";
        }
    }
}

