/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import cn.hutool.core.io.file.FileReader;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PopupFileManage {
    void show(ParamBean paramBean) {
        Shell shell = Display.getCurrent().getActiveShell();
        FileManageDialog dialog = new FileManageDialog(shell);
        dialog.setParamBean(paramBean);
        dialog.open();
    }

    public class FileManageDialog
    extends Dialog {
        private ParamBean paramBean;
        private Text pathInput;
        private String remoteFileName;

        protected FileManageDialog(Shell parentShell) {
            super(parentShell);
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new RowLayout(512));
            Composite localFileComposite = new Composite(composite, 0);
            localFileComposite.setLayout((Layout)new RowLayout());
            Label label = new Label(localFileComposite, 0);
            label.setText("Upload Local File ");
            Button browseLocalFileBtn = new Button(localFileComposite, 0);
            browseLocalFileBtn.setText("Browse");
            browseLocalFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileDialog.setFilterNames(new String[]{"TuningTool Sava data(*.json)", "All Files(*.*)"});
                    fileDialog.setFilterExtensions(new String[]{"*.json", "*.*"});
                    fileDialog.setFilterPath(System.getProperty("user.dir"));
                    fileDialog.setText("Open");
                    String fileName = fileDialog.open();
                    if (fileName != null) {
                        Path filePath = Paths.get(fileName, new String[0]);
                        FileReader fileReader = new FileReader(filePath.toString());
                        String fileContent = fileReader.readString();
                        ModuleDataCenter.getInstance().importFromExportedSetting(fileContent);
                        ConsoleLogger.print((String)("Load data from " + fileName + " success."));
                    }
                }
            });
            Label remoteLabel = new Label(composite, 0);
            remoteLabel.setText("Remote File ");
            Composite remoteFileComposite = new Composite(composite, 0);
            remoteFileComposite.setLayout((Layout)new RowLayout());
            final List list = new List(remoteFileComposite, 516);
            list.add("1.drv");
            list.add("2.raw");
            list.add("3.xml");
            list.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    String[] arr = list.getSelection();
                    FileManageDialog.this.remoteFileName = arr[0];
                    ConsoleLogger.print((String)("select remote file:" + FileManageDialog.this.remoteFileName));
                }
            });
            Composite remoteFileRightComposite = new Composite(remoteFileComposite, 0);
            remoteFileRightComposite.setLayout((Layout)new RowLayout(512));
            Composite remoteFileSavePathComposite = new Composite(remoteFileRightComposite, 0);
            remoteFileSavePathComposite.setLayout((Layout)new RowLayout());
            Label pathLabel = new Label(remoteFileSavePathComposite, 0);
            pathLabel.setText("Save Path ");
            this.pathInput = new Text(remoteFileSavePathComposite, 0);
            if (DialogSettingManager.getInstance().getCaptureSavePath() != null) {
                this.pathInput.setText(DialogSettingManager.getInstance().getCaptureSavePath());
            }
            Button browseSavePathBtn = new Button(remoteFileSavePathComposite, 0);
            browseSavePathBtn.setText("Browse");
            browseSavePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    dialog.setText("Browse Save Path");
                    String path = dialog.open();
                    if (path != null) {
                        FileManageDialog.this.pathInput.setText(path);
                    }
                }
            });
            Button downloadBtn = new Button(remoteFileRightComposite, 0);
            downloadBtn.setText("Download");
            downloadBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConsoleLogger.print((String)("will download remote file:" + FileManageDialog.this.remoteFileName));
                }
            });
            Button deleteBtn = new Button(remoteFileRightComposite, 0);
            deleteBtn.setText("Delete");
            deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConsoleLogger.print((String)("will delete remote file:" + FileManageDialog.this.remoteFileName));
                }
            });
            Button activeBtn = new Button(remoteFileRightComposite, 0);
            activeBtn.setText("Active");
            activeBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConsoleLogger.print((String)("will active remote file:" + FileManageDialog.this.remoteFileName));
                }
            });
            return composite;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Select " + this.paramBean.getShowName());
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            return null;
        }

        protected void initializeBounds() {
            Composite comp = (Composite)this.getButtonBar();
            super.createButton(comp, 1, "Close", false);
            super.initializeBounds();
        }

        protected Point getInitialSize() {
            return new Point(800, 500);
        }

        public ParamBean getParamBean() {
            return this.paramBean;
        }

        public Text getPathInput() {
            return this.pathInput;
        }

        public String getRemoteFileName() {
            return this.remoteFileName;
        }

        public void setParamBean(ParamBean paramBean) {
            this.paramBean = paramBean;
        }

        public void setPathInput(Text pathInput) {
            this.pathInput = pathInput;
        }

        public void setRemoteFileName(String remoteFileName) {
            this.remoteFileName = remoteFileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileManageDialog)) {
                return false;
            }
            FileManageDialog other = (FileManageDialog)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            ParamBean this$paramBean = this.getParamBean();
            ParamBean other$paramBean = other.getParamBean();
            if (this$paramBean == null ? other$paramBean != null : !this$paramBean.equals(other$paramBean)) {
                return false;
            }
            Text this$pathInput = this.getPathInput();
            Text other$pathInput = other.getPathInput();
            if (this$pathInput == null ? other$pathInput != null : !this$pathInput.equals(other$pathInput)) {
                return false;
            }
            String this$remoteFileName = this.getRemoteFileName();
            String other$remoteFileName = other.getRemoteFileName();
            return !(this$remoteFileName == null ? other$remoteFileName != null : !this$remoteFileName.equals(other$remoteFileName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileManageDialog;
        }

        public int hashCode() {
            int result = 1;
            ParamBean $paramBean = this.getParamBean();
            result = result * 59 + ($paramBean == null ? 43 : $paramBean.hashCode());
            Text $pathInput = this.getPathInput();
            result = result * 59 + ($pathInput == null ? 43 : $pathInput.hashCode());
            String $remoteFileName = this.getRemoteFileName();
            result = result * 59 + ($remoteFileName == null ? 43 : $remoteFileName.hashCode());
            return result;
        }

        public String toString() {
            return "PopupFileManage.FileManageDialog(paramBean=" + this.getParamBean() + ", pathInput=" + this.getPathInput() + ", remoteFileName=" + this.getRemoteFileName() + ")";
        }
    }
}

