/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PopupColorMatrix {
    void show(ParamBean paramBean) {
        Shell shell = Display.getCurrent().getActiveShell();
        ColorMatrixDialog dialog = new ColorMatrixDialog(shell);
        dialog.setParamBean(paramBean);
        dialog.open();
    }

    public class ColorMatrixDialog
    extends Dialog {
        private ParamBean paramBean;

        public ColorMatrixDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText("Color Matrix");
            shell.setSize(700, 700);
        }

        protected Control createDialogArea(Composite parent) {
            assert (this.paramBean != null);
            Composite gridComposite = new Composite(parent, 0);
            ParamBean.ValueBean valueBean = this.paramBean.getValue();
            JSONObject dataObject = new JSONObject(valueBean.getCurrentValue());
            JSONArray dataArray = dataObject.getJSONArray((Object)"data");
            int colNumber = dataArray.size() > 625 ? 32 : 25;
            GridLayout gridLayout = new GridLayout(colNumber, true);
            GridData gridData = new GridData(680, 680);
            gridComposite.setLayoutData((Object)gridData);
            gridLayout.horizontalSpacing = 1;
            gridLayout.verticalSpacing = 1;
            gridComposite.setLayout((Layout)gridLayout);
            Integer i = 0;
            while (i < dataArray.size()) {
                Integer s = Math.min(255, dataArray.getInt((Object)i));
                Label label = new Label(gridComposite, 0);
                GridData labelGridData = new GridData();
                labelGridData.widthHint = 20;
                labelGridData.heightHint = 18;
                label.setLayoutData((Object)labelGridData);
                label.setAlignment(0x1000000);
                label.setText(s.toString());
                label.setBackground(new Color(null, s.intValue(), s.intValue(), s.intValue()));
                i = i + 1;
            }
            return null;
        }

        public ParamBean getParamBean() {
            return this.paramBean;
        }

        public void setParamBean(ParamBean paramBean) {
            this.paramBean = paramBean;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColorMatrixDialog)) {
                return false;
            }
            ColorMatrixDialog other = (ColorMatrixDialog)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            ParamBean this$paramBean = this.getParamBean();
            ParamBean other$paramBean = other.getParamBean();
            return !(this$paramBean == null ? other$paramBean != null : !this$paramBean.equals(other$paramBean));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColorMatrixDialog;
        }

        public int hashCode() {
            int result = 1;
            ParamBean $paramBean = this.getParamBean();
            result = result * 59 + ($paramBean == null ? 43 : $paramBean.hashCode());
            return result;
        }

        public String toString() {
            return "PopupColorMatrix.ColorMatrixDialog(paramBean=" + this.getParamBean() + ")";
        }
    }
}

