/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.group;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.ui.view.chart.LineChart;
import com.verisilicon.isp.tuning.ui.view.chart.LinearLineChart;
import com.verisilicon.isp.tuning.ui.view.chart.SplineLineChart;
import com.verisilicon.isp.tuning.ui.view.group.GroupTitleView;
import com.verisilicon.isp.tuning.ui.view.group.RowColorView;
import com.verisilicon.isp.tuning.ui.view.group.RowComboView;
import com.verisilicon.isp.tuning.ui.view.group.RowImageTableView;
import com.verisilicon.isp.tuning.ui.view.group.RowInputView;
import com.verisilicon.isp.tuning.ui.view.group.RowLabelView;
import com.verisilicon.isp.tuning.ui.view.group.RowSwitchView;
import com.verisilicon.isp.tuning.ui.view.group.RowTableView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class ParamGroupView {
    private List<Rectangle> boundsList = new ArrayList<Rectangle>();
    public Composite composite;

    public void show(Composite parent, ParamGroupBean paramGroupBean, ModuleBean currentModuleBean, Boolean editable) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.composite.setBackground(Display.getCurrent().getSystemColor(1));
        Composite group = new Composite(this.composite, 0);
        group.setBackground(Display.getCurrent().getSystemColor(19));
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.fill = true;
        rowLayout.wrap = false;
        group.setLayout((Layout)rowLayout);
        group.setEnabled(editable.booleanValue());
        group.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite tableComposite = new Composite(this.composite, 0);
        tableComposite.setLayout((Layout)new RowLayout(256));
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableComposite.setBackground(Display.getCurrent().getSystemColor(1));
        tableComposite.setVisible(false);
        GroupTitleView titleView = new GroupTitleView();
        titleView.show(group, paramGroupBean.getGroupName());
        int index = 0;
        for (ParamBean paramBean : paramGroupBean.getParams()) {
            if (paramBean.getIsHide().booleanValue()) continue;
            switch (paramBean.getType()) {
                case "range": {
                    RowInputView rowInput = new RowInputView();
                    rowInput.show(group, paramBean, currentModuleBean);
                    break;
                }
                case "toggle": {
                    RowSwitchView switchView = new RowSwitchView();
                    switchView.show(group, paramBean, currentModuleBean);
                    break;
                }
                case "option": {
                    RowComboView rowCombo = new RowComboView();
                    rowCombo.show(group, paramBean, currentModuleBean);
                    break;
                }
                case "label": {
                    RowLabelView rowLabel = new RowLabelView();
                    rowLabel.show(group, paramBean, currentModuleBean);
                    break;
                }
                case "matrix.sensorMode.aGain": 
                case "matrix.sensorMode.dGain": 
                case "matrix": 
                case "matrix.sensorMode.integrationTime": {
                    RowTableView rowTable = new RowTableView();
                    rowTable.setSavable(true);
                    rowTable.show(group, paramBean, paramGroupBean, currentModuleBean);
                    break;
                }
                case "drawMatrix": {
                    RowImageTableView rowImageTable = new RowImageTableView();
                    rowImageTable.show(group, paramBean, currentModuleBean);
                    break;
                }
                case "curve": {
                    LineChart lineChart = new LineChart();
                    Object valueObject = paramBean.getValue().getValue();
                    lineChart.show(group, paramBean, (JSONArray)valueObject, tableComposite, this.boundsList, currentModuleBean, false);
                    break;
                }
                case "curveY": {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getKey());
                    LineChart lineChart = new LineChart();
                    lineChart.show(group, paramBean, pointsPosArray, tableComposite, this.boundsList, currentModuleBean, false);
                    break;
                }
                case "lineCurve": {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getKey());
                    LinearLineChart linearLineChart = new LinearLineChart();
                    linearLineChart.show(group, paramBean, pointsPosArray, tableComposite, this.boundsList, currentModuleBean, false);
                    break;
                }
                case "splineCurve": {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getKey());
                    SplineLineChart splinClineChart = new SplineLineChart();
                    splinClineChart.show(group, paramBean, pointsPosArray, tableComposite, this.boundsList, currentModuleBean, false);
                    break;
                }
                case "tableCurve": {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getKey(), (int)0);
                    LineChart lineChart = new LineChart();
                    lineChart.show(group, paramBean, pointsPosArray, tableComposite, this.boundsList, currentModuleBean, true);
                    break;
                }
                case "tableSplineCurve": {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)currentModuleBean, (String)paramBean.getCategory(), (String)paramBean.getKey(), (int)0);
                    SplineLineChart splinClineChart = new SplineLineChart();
                    splinClineChart.show(group, paramBean, pointsPosArray, tableComposite, this.boundsList, currentModuleBean, true);
                    break;
                }
                case "color": {
                    RowColorView rowColorView = new RowColorView();
                    rowColorView.show(group, paramBean, currentModuleBean);
                    break;
                }
                default: {
                    System.out.println("unsupported type: " + paramBean.getType() + " for param " + paramBean.getShowName());
                }
            }
        }
        parent.pack();
        Control[] controlArray = tableComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBounds(this.boundsList.get(index++));
            ++n2;
        }
    }

    public void dispose() {
    }
}

