/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import com.verisilicon.isp.tuning.core.bean.ServerConfigBean;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.core.UIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;

public class ServerConfigDialog
extends TitleAreaDialog {
    private Combo serverTypeCombo;
    private Composite stackContentComposite;
    private Composite serverHttpComposite;
    private Composite serverUartComposite;
    private Text serverHostText;
    private Text serverPortText;
    private Table serverTable;
    private Button addButton;
    private Button deleteButton;
    private Button testConnectionButton;
    private Text serverUartText;
    private int currentIndex;
    private Image selectImage;
    private Image passImage;
    private Image failureImage;
    private DialogSettingManager dialogSettingManager;
    private boolean ret = false;
    private Combo baudCombo;
    private String[] baudRateOPtions = new String[]{"0", "50", "75", "110", "150", "200", "300", "600", "1200", "1800", "2400", "4800", "9600", "19200", "38400", "57600", "115200", "230400", "460800", "576000", "921600"};

    public ServerConfigDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selectImage = ImageRegistry.getImage(ImageRegistry.TABLE_ITEM_SELECT);
        this.passImage = ImageRegistry.getImage(ImageRegistry.CHECK_STATUS_PASS);
        this.failureImage = ImageRegistry.getImage(ImageRegistry.CHECK_STATUS_FAIL);
        this.currentIndex = -1;
        this.dialogSettingManager = DialogSettingManager.getInstance();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Server Configuration");
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        this.updateWidgetEnablements();
        return ret;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Server Configuration");
        Composite workArea = new Composite(parent, 16);
        workArea.setLayout((Layout)new GridLayout(1, false));
        workArea.setLayoutData((Object)new GridData(1808));
        this.createSubviews(workArea);
        this.restoreWidgetValues();
        return workArea;
    }

    private void createSubviews(Composite parent) {
        GridLayout topLayout = new GridLayout(2, false);
        parent.setLayout((Layout)topLayout);
        Label connectTypeLabel = new Label(parent, 0);
        connectTypeLabel.setText("Connection Type ");
        this.serverTypeCombo = new Combo(parent, 8);
        this.serverTypeCombo.setLayoutData((Object)new GridData(768));
        this.serverTypeCombo.setItems(new String[]{"HTTP", "TCP", "UART"});
        this.serverTypeCombo.select(0);
        this.serverTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerConfigDialog.this.handleServerTypeChanged();
                ServerConfigDialog.this.updateServerActionEnablements();
                ServerConfigDialog.this.updateWidgetEnablements();
            }
        });
        this.stackContentComposite = new Composite(parent, 0);
        GridData stackGridData = new GridData(1808);
        stackGridData.horizontalSpan = 3;
        this.stackContentComposite.setLayoutData((Object)stackGridData);
        this.stackContentComposite.setLayout((Layout)new StackLayout());
        this.createHttpContent();
        this.createUartContent();
        ((StackLayout)this.stackContentComposite.getLayout()).topControl = this.serverHttpComposite;
    }

    private void handleServerTypeChanged() {
        ((StackLayout)this.stackContentComposite.getLayout()).topControl = this.serverTypeCombo.getSelectionIndex() == 2 ? this.serverUartComposite : this.serverHttpComposite;
        this.stackContentComposite.layout();
    }

    private void createHttpContent() {
        this.serverHttpComposite = new Composite(this.stackContentComposite, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginWidth = 0;
        this.serverHttpComposite.setLayout((Layout)topLayout);
        Composite hostComposite = new Composite(this.serverHttpComposite, 0);
        hostComposite.setLayoutData((Object)new GridData(768));
        GridLayout hostLayout = new GridLayout(4, false);
        hostLayout.marginWidth = 0;
        hostComposite.setLayout((Layout)hostLayout);
        Label hostLabel = new Label(hostComposite, 0);
        hostLabel.setText("Host(name or IP) ");
        this.serverHostText = new Text(hostComposite, 2048);
        this.serverHostText.setLayoutData((Object)new GridData(768));
        this.serverHostText.setMessage("192.168.0.1");
        this.serverHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerConfigDialog.this.updateServerActionEnablements();
            }
        });
        Label portLabel = new Label(hostComposite, 0);
        portLabel.setText("Port ");
        this.serverPortText = new Text(hostComposite, 2048);
        this.serverPortText.setLayoutData((Object)new GridData(768));
        this.serverPortText.setMessage("8080");
        this.serverPortText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = ((Text)e.widget).getText();
                try {
                    String tmp = e.start < text.length() && e.end <= text.length() ? String.valueOf(text.substring(0, e.start)) + e.text + text.substring(e.end) : String.valueOf(text) + e.text;
                    if (tmp.compareTo("") != 0) {
                        Integer.parseUnsignedInt(tmp);
                    }
                    e.doit = true;
                    ServerConfigDialog.this.updateServerActionEnablements();
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.serverPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerConfigDialog.this.updateServerActionEnablements();
            }
        });
        Composite tableComposite = new Composite(this.serverHttpComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        GridLayout listLayout = new GridLayout(2, false);
        listLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)listLayout);
        this.serverTable = new Table(tableComposite, 68354);
        this.serverTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.serverTable.setHeaderVisible(false);
        this.serverTable.setLinesVisible(false);
        new TableColumn(this.serverTable, 0).setText("address");
        new TableColumn(this.serverTable, 0).setText("connection type");
        new TableColumn(this.serverTable, 0).setText("status");
        this.serverTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = ServerConfigDialog.this.serverTable.getClientArea();
                int widgetHeight = ((ServerConfigDialog)ServerConfigDialog.this).serverTable.computeSize((int)-1, (int)-1).y;
                ScrollBar vBar = ServerConfigDialog.this.serverTable.getVerticalBar();
                int width = area.width - ((ServerConfigDialog)ServerConfigDialog.this).serverTable.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                if (widgetHeight > area.height) {
                    int vBarWidth = vBar.getSize().x;
                    width -= vBarWidth;
                }
                int statusColumnWidth = width / 5;
                ServerConfigDialog.this.serverTable.getColumn(2).setWidth(statusColumnWidth);
                ServerConfigDialog.this.serverTable.getColumn(1).setWidth(statusColumnWidth);
                ServerConfigDialog.this.serverTable.getColumn(0).setWidth(width - statusColumnWidth * 2);
            }
        });
        this.serverTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String type = ServerConfigDialog.this.serverTable.getItem(ServerConfigDialog.this.serverTable.getSelectionIndex()).getText(1);
                ServerConfigDialog.this.serverTypeCombo.select(type.equals("HTTP") ? 0 : 1);
                ServerConfigDialog.this.updateSelectedTableItem(-1);
                ServerConfigDialog.this.updateHostPortText();
                ServerConfigDialog.this.updateWidgetEnablements();
            }
        });
        Composite buttonsComposite = new Composite(tableComposite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(1040));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    int portVal = Integer.parseUnsignedInt(ServerConfigDialog.this.serverPortText.getText());
                    String itemString = String.valueOf(ServerConfigDialog.this.serverHostText.getText().trim()) + ":" + String.valueOf(portVal);
                    String type = ServerConfigDialog.this.serverTypeCombo.getItem(ServerConfigDialog.this.serverTypeCombo.getSelectionIndex());
                    TableItem item = new TableItem(ServerConfigDialog.this.serverTable, 0);
                    item.setText(0, itemString);
                    item.setText(1, type);
                    ServerConfigDialog.this.updateServerActionEnablements();
                    ServerConfigDialog.this.serverTable.deselectAll();
                    ServerConfigDialog.this.serverTable.select(ServerConfigDialog.this.serverTable.getItemCount() - 1);
                    ServerConfigDialog.this.updateSelectedTableItem(ServerConfigDialog.this.serverTable.getItemCount() - 1);
                }
                catch (NumberFormatException numberFormatException) {}
                ServerConfigDialog.this.updateWidgetEnablements();
            }
        });
        this.deleteButton = new Button(buttonsComposite, 8);
        this.deleteButton.setText("Delete");
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerConfigDialog.this.serverTable.remove(ServerConfigDialog.this.serverTable.getSelectionIndices());
                ServerConfigDialog.this.updateServerActionEnablements();
                if (ServerConfigDialog.this.serverTable.getItemCount() > 0) {
                    ServerConfigDialog.this.serverTable.select(ServerConfigDialog.this.serverTable.getItemCount() - 1);
                    ServerConfigDialog.this.updateSelectedTableItem(ServerConfigDialog.this.serverTable.getItemCount() - 1);
                }
                ServerConfigDialog.this.updateWidgetEnablements();
            }
        });
        this.testConnectionButton = new Button(buttonsComposite, 8);
        this.testConnectionButton.setText("Test");
        this.testConnectionButton.setLayoutData((Object)new GridData(768));
        this.testConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerConfigDialog.this.testConnection();
            }
        });
        this.updateServerActionEnablements();
        if (this.serverTable.getItemCount() > 0) {
            this.serverTable.select(this.serverTable.getItemCount() - 1);
            this.updateSelectedTableItem(this.serverTable.getItemCount() - 1);
        }
    }

    private boolean hasSameHostAndPort(String itemString, String host, String port, String itemType, String type) {
        String[] subStrs = itemString.split(":");
        host = host.trim();
        port = port.trim();
        if (subStrs.length != 2 || host.isEmpty() || port.isEmpty()) {
            return false;
        }
        try {
            int portVal = Integer.parseUnsignedInt(port);
            return host.equals(subStrs[0]) && String.valueOf(portVal).equals(subStrs[1]) && type.equals(itemType);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void updateServerActionEnablements() {
        boolean enable = this.serverTable.getItemCount() != 0;
        this.deleteButton.setEnabled(enable);
        this.testConnectionButton.setEnabled(enable);
        String hostText = this.serverHostText.getText().trim();
        String portText = this.serverPortText.getText().trim();
        if (hostText.isEmpty() || portText.isEmpty()) {
            this.addButton.setEnabled(false);
            return;
        }
        int i = 0;
        while (i < this.serverTable.getItemCount()) {
            TableItem item = this.serverTable.getItem(i);
            if (this.hasSameHostAndPort(item.getText(0), this.serverHostText.getText(), this.serverPortText.getText(), item.getText(1), this.serverTypeCombo.getItem(this.serverTypeCombo.getSelectionIndex()))) {
                this.addButton.setEnabled(false);
                return;
            }
            ++i;
        }
        this.addButton.setEnabled(true);
    }

    private void updateSelectedTableItem(int index) {
        int itemIndex = index;
        if (index < 0) {
            itemIndex = this.serverTable.getSelectionIndex();
        }
        if (itemIndex < 0) {
            return;
        }
        int i = 0;
        while (i < this.serverTable.getItemCount()) {
            TableItem item = this.serverTable.getItem(i);
            if (i == itemIndex) {
                item.setImage(0, this.selectImage);
            } else {
                item.setImage(0, null);
            }
            item.setImage(1, null);
            ++i;
        }
        this.currentIndex = itemIndex;
    }

    private void updateHostPortText() {
        int itemIndex = this.serverTable.getSelectionIndex();
        if (itemIndex < 0) {
            return;
        }
        TableItem item = this.serverTable.getItem(itemIndex);
        String itemString = item.getText(0);
        String[] subStrs = itemString.split(":");
        if (subStrs.length != 2) {
            return;
        }
        this.serverHostText.setText(subStrs[0]);
        this.serverPortText.setText(subStrs[1]);
    }

    private void testConnection() {
        ServerConfigBean config = new ServerConfigBean();
        if (this.serverTypeCombo.getSelectionIndex() == 0 || this.serverTypeCombo.getSelectionIndex() == 1) {
            int itemIndex = this.serverTable.getSelectionIndex();
            if (itemIndex < 0) {
                return;
            }
            int imageColIndex = 2;
            TableItem item = this.serverTable.getItem(itemIndex);
            String httpAddr = item.getText(0);
            String[] subStrs = httpAddr.split(":");
            config.setServerType(item.getText(1).equals("HTTP") ? ServerConfigBean.ServerType.HTTP : ServerConfigBean.ServerType.TCP);
            config.setHttpHost(subStrs[0]);
            config.setHttpPort(subStrs[1]);
            if (subStrs.length == 2) {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ServerConfigDialog.this.ret = ClientHolder.getInstance().testConnection(config);
                        ServerConfigDialog.this.dialogSettingManager.setIsConnected(ServerConfigDialog.this.ret);
                        if (ServerConfigDialog.this.ret) {
                            item.setImage(imageColIndex, ServerConfigDialog.this.passImage);
                        } else {
                            item.setImage(imageColIndex, ServerConfigDialog.this.failureImage);
                        }
                    }
                });
            } else {
                item.setImage(imageColIndex, this.failureImage);
            }
        } else if (this.serverTypeCombo.getSelectionIndex() == 2) {
            config.setServerType(ServerConfigBean.ServerType.UART);
            config.setUartName(this.serverUartText.getText());
            int index = this.baudCombo.getSelectionIndex();
            String rate = this.baudRateOPtions[index];
            int uartRate = Integer.parseInt(rate);
            config.setBaudRate(uartRate);
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ServerConfigDialog.this.ret = ClientHolder.getInstance().testConnection(config);
                    ServerConfigDialog.this.dialogSettingManager.setIsConnected(ServerConfigDialog.this.ret);
                }
            });
        }
    }

    private void createUartContent() {
        this.serverUartComposite = new Composite(this.stackContentComposite, 0);
        GridLayout topLayout = new GridLayout(5, true);
        topLayout.marginWidth = 0;
        this.serverUartComposite.setLayout((Layout)topLayout);
        Label uartLabel = new Label(this.serverUartComposite, 0);
        uartLabel.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        uartLabel.setText("UART ");
        this.serverUartText = new Text(this.serverUartComposite, 2048);
        this.serverUartText.setLayoutData((Object)new GridData(4, 128, true, true, 3, 1));
        this.serverUartText.setText("COM1");
        this.serverUartText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ServerConfigDialog.this.updateWidgetEnablements();
            }
        });
        this.baudCombo = new Combo(this.serverUartComposite, 8);
        this.baudCombo.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        int baudrate = this.dialogSettingManager.getBaudRate();
        int i = 0;
        while (i < this.baudRateOPtions.length) {
            this.baudCombo.add(this.baudRateOPtions[i]);
            if (String.valueOf(baudrate).equals(this.baudRateOPtions[i])) {
                this.baudCombo.select(i);
            }
            ++i;
        }
    }

    private void restoreWidgetValues() {
        int itemCount = this.serverTypeCombo.getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (this.serverTypeCombo.getItem(i).equals(this.dialogSettingManager.getServerType())) {
                this.serverTypeCombo.select(i);
            }
            ++i;
        }
        this.handleServerTypeChanged();
        String[] httpList = this.dialogSettingManager.getHttpList();
        String[] connectionTypeList = this.dialogSettingManager.getConnectionTypeList();
        int i2 = 0;
        while (i2 < httpList.length) {
            TableItem item = new TableItem(this.serverTable, 0);
            item.setText(0, httpList[i2]);
            item.setText(1, connectionTypeList[i2]);
            ++i2;
        }
        int httpIndex = this.dialogSettingManager.getHttpIndex();
        if (httpIndex < httpList.length) {
            this.serverTable.select(httpIndex);
            this.updateSelectedTableItem(httpIndex);
        }
        this.serverUartText.setText(this.dialogSettingManager.getUartName());
        this.updateServerActionEnablements();
        this.updateWidgetEnablements();
    }

    protected void okPressed() {
        this.saveWidgetValues();
        this.testConnection();
        UIPlugin.getInstance().updateServerStatus(ClientHolder.getInstance().getURI(), this.ret);
        UIJob uiJob = new UIJob("Synchronize data between client and server"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
        super.okPressed();
    }

    private void saveWidgetValues() {
        this.dialogSettingManager.setServerType(this.serverTypeCombo.getText());
        this.dialogSettingManager.setHttpIndex(this.currentIndex);
        String[] httpList = new String[this.serverTable.getItemCount()];
        String[] connectionTypeList = new String[this.serverTable.getItemCount()];
        int i = 0;
        while (i < this.serverTable.getItemCount()) {
            TableItem item = this.serverTable.getItem(i);
            httpList[i] = item.getText(0);
            connectionTypeList[i] = item.getText(1);
            ++i;
        }
        this.dialogSettingManager.setHttpList(httpList);
        this.dialogSettingManager.setUartName(this.serverUartText.getText());
        int index = this.baudCombo.getSelectionIndex();
        String rate = this.baudRateOPtions[index];
        int uartRate = Integer.parseInt(rate);
        this.dialogSettingManager.setBaudRate(uartRate);
        this.dialogSettingManager.setConnectionTypeList(connectionTypeList);
        this.dialogSettingManager.saveServerConfig();
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.validate();
        if (pageComplete) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(true);
            }
            this.setMessage(null);
        } else if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(false);
        }
    }

    private boolean validate() {
        if (this.serverTypeCombo.getSelectionIndex() == 0 || this.serverTypeCombo.getSelectionIndex() == 1) {
            if (this.serverTable.getItemCount() == 0) {
                this.setMessage("Add a server.");
                return false;
            }
            if (this.currentIndex < 0) {
                this.setMessage("Select the server you want to connect.");
                return false;
            }
        } else if (this.serverTypeCombo.getSelectionIndex() == 2 && this.serverUartText.getText().trim().isEmpty()) {
            this.setMessage("Enter UART.");
            return false;
        }
        this.setMessage(null);
        return true;
    }
}

