/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import com.verisilicon.isp.tuning.core.bean.TemplateBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectTemplateDialog
extends Dialog {
    private Combo combo;
    private List<TemplateBean> templateBeans;
    private int currentSelectIndex;

    public SelectTemplateDialog(Shell parentShell) {
        super(parentShell);
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        label.setText("Select Template ");
        this.combo = new Combo(composite, 8);
        this.combo.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        this.currentSelectIndex = 0;
        this.templateBeans = ModuleDataCenter.getInstance().getTemplateBeans();
        int i = 0;
        while (i < this.templateBeans.size()) {
            TemplateBean template = this.templateBeans.get(i);
            if (template.getTemplateName().equals(ModuleDataCenter.getInstance().getCurrentTemplateName())) {
                this.currentSelectIndex = i;
            }
            this.combo.add(template.getTemplateName());
            ++i;
        }
        this.combo.select(this.currentSelectIndex);
        return composite;
    }

    protected void okPressed() {
        int selectionIndex = this.combo.getSelectionIndex();
        if (this.currentSelectIndex != selectionIndex) {
            EventManager.getInstance().notifyEvent("EVENT_TEMPLATE_CHANGED", (Object)this.templateBeans.get(selectionIndex));
            DialogSettingManager.getInstance().setCaptureSavePath(this.templateBeans.get(selectionIndex).getTemplateName());
            DialogSettingManager.getInstance().saveCaptureConfig();
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select Template");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        parent.setLayoutData((Object)new GridData(64));
    }

    protected Point getInitialSize() {
        return new Point(400, 200);
    }
}

