/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.ui.core.ProjectNature;
import com.verisilicon.isp.tuning.ui.core.UIPlugin;
import com.verisilicon.tuning.ui.util.CommonProjectWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class ProjectWizard
extends CommonProjectWizard {
    private static final String ISP_PROJECT_WIZARD_MAIN_PAGE_NAME = "ISPProjectWizardMainPage";
    private static final String ISP_PERSPECTIVE = "com.verisilicon.isp.tuning.ui.perspective";
    private Combo targetNameCombo;

    public ProjectWizard() {
        super("ISP Project", "Create a ISP project");
    }

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage(ISP_PROJECT_WIZARD_MAIN_PAGE_NAME){

            public void createControl(Composite parent) {
                super.createControl(parent);
                ProjectWizard.this.createTargetGroup((Composite)this.getControl());
                Dialog.applyDialogFont((Control)this.getControl());
            }
        };
        this.mainPage.setTitle("ISP Project");
        this.mainPage.setDescription("Create a ISP project");
        this.addPage((IWizardPage)this.mainPage);
    }

    public void createTargetGroup(Composite composite) {
        Composite targetGroup = new Composite(composite, 0);
        targetGroup.setFont(composite.getFont());
        targetGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        targetGroup.setLayout((Layout)layout);
        Label targetLabel = new Label(targetGroup, 0);
        targetLabel.setText("Target names");
        targetLabel.setFont(targetGroup.getFont());
        this.targetNameCombo = new Combo(targetGroup, 8);
        GridData data = new GridData(768);
        this.targetNameCombo.setLayoutData((Object)data);
        this.targetNameCombo.setFont(targetGroup.getFont());
        this.updateTargetList();
    }

    public void updateTargetList() {
        List targets = ModuleDataCenter.getInstance().getTemplateBeans();
        if (targets != null) {
            targets.stream().forEach(e -> this.targetNameCombo.add(e.getTemplateName()));
            this.targetNameCombo.select(0);
        } else {
            this.mainPage.setPageComplete(false);
        }
    }

    public boolean performFinish() {
        boolean ret = super.performFinish();
        if (ret) {
            UIPlugin.getInstance().changeCurrentProject(this.newProject, this.targetNameCombo.getText());
            UIPlugin.getInstance().saveProjectSettings();
            this.switchPerspective();
        }
        return ret;
    }

    protected void continueCreation(IProject project, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            ProjectNature.addNature(project, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e, "Create project failed!");
        }
    }

    private void switchPerspective() {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && !ISP_PERSPECTIVE.equals(activePage.getPerspective().getId())) {
            IPerspectiveDescriptor persDesc = reg.findPerspectiveWithId(ISP_PERSPECTIVE);
            activePage.setPerspective(persDesc);
        }
    }
}

