/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.SensorBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.view.VideoView;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PreviewDialog
extends TitleAreaDialog {
    private ModuleBean sensorModuleBean;
    private ModuleBean inputModuleBean;
    private ModuleBean outputModuleBean;
    private ModuleBean tileModuleBean;
    private DialogSettingManager dialogSettingManager;
    private Button streamCheckBox;
    private Scale frameRateScale;
    private Scale outputBitsScale;
    private Combo inputTypeCombo;
    private Combo sensorNameCombo;
    private Combo sensorModeCombo;
    private Combo tileModeCombo;
    private Combo tileOperationCombo;
    private Combo outputPathCombo;
    private Combo outputFormatCombo;
    private Combo outputBayerPatternCombo;
    private Text framerateInput;
    private Text outputBitsInput;
    private Text outputWidthInput;
    private Text outputHeightInput;
    private SensorBean sensorBean;
    private List<String> sensorNames;
    private static int outputWidth = 0;
    private static int outputHeight = 0;
    private static String outputFormat = null;
    private static String outputPath = null;
    private static String outputBayerPattern = null;
    private static SensorBean.Mode sensorMode = null;
    private static String formatMode = null;
    private static int outputBits = 8;
    private String lastBitsInput;
    private Integer sensorWidth = 0;
    private Integer sensorHeight = 0;

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    public PreviewDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(208);
        this.dialogSettingManager = DialogSettingManager.getInstance();
    }

    public static int getWidth() {
        return outputWidth;
    }

    public static int getHeight() {
        return outputHeight;
    }

    public static String getFormat() {
        return outputFormat;
    }

    public static String getOutputPath() {
        return outputPath;
    }

    public static String getOutputBayerPattern() {
        return outputBayerPattern;
    }

    public static SensorBean.Mode getSensorMode() {
        return sensorMode;
    }

    public static String getformatMode() {
        return formatMode;
    }

    public static int getOutputBits() {
        return outputBits;
    }

    private void readAndUpdateModule(ModuleBean moduleBean, String[] queryKeys) {
        ArrayList<ParamBean> queryParams = new ArrayList<ParamBean>();
        String requestString = null;
        if (queryKeys != null) {
            String[] stringArray = queryKeys;
            int n = queryKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ParamBean paramBean = moduleBean.findParamBeanByKey(key);
                assert (paramBean != null);
                queryParams.add(paramBean);
                ++n2;
            }
            requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(queryParams, Boolean.valueOf(false));
        } else {
            requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(moduleBean, Boolean.valueOf(false));
        }
        String responseString = ClientHolder.getInstance().sendSyncRequest(requestString);
        if (responseString == null) {
            return;
        }
        JSONArray jsonAr = JSONUtil.parseArray((String)responseString);
        int i = 0;
        while (i < jsonAr.size()) {
            JSONObject paramObj = jsonAr.getJSONObject((Object)i);
            String key = paramObj.getStr((Object)"key");
            String message = paramObj.getStr((Object)"message");
            if (!StrUtil.isEmpty((CharSequence)message)) {
                ConsoleLogger.printErrorMsg((String)("Read" + moduleBean.getModuleName() + "ModuleData Failed: {" + key + " : " + message + "}"));
            }
            ++i;
        }
        try {
            ModuleDataCenter.getInstance().updateModuleDataWithJsonString(responseString);
        }
        catch (Exception e) {
            ConsoleLogger.printWarningMsg((String)e.getMessage());
        }
    }

    private void readAndUpdateModuleBean() {
        String[] outputModuleQueryKeys = new String[]{"type", ":bayerPattern", ":bits", ":format", ":height", ":width"};
        this.readAndUpdateModule(this.outputModuleBean, outputModuleQueryKeys);
        String[] inputModuleQueryKeys = new String[]{"type", "framerate", "isStream"};
        this.readAndUpdateModule(this.inputModuleBean, inputModuleQueryKeys);
        String[] tileModuleQueryKeys = new String[]{"joint", "operation"};
        this.readAndUpdateModule(this.tileModuleBean, tileModuleQueryKeys);
        this.readAndUpdateModule(this.sensorModuleBean, null);
        this.updateUI();
    }

    public void updateUI() {
        Integer height;
        Integer width;
        Integer bits;
        Integer bayerPattern;
        Integer outputFormat;
        Boolean streamState = (Boolean)this.inputModuleBean.findParamBeanByKey("isStream").getValue().getCurrentValue();
        this.streamCheckBox.setSelection(streamState.booleanValue());
        Integer inputType = (Integer)this.inputModuleBean.findParamBeanByKey("type").getValue().getCurrentValue();
        this.inputTypeCombo.select(inputType.intValue());
        BigDecimal frameRate = (BigDecimal)this.inputModuleBean.findParamBeanByKey("framerate").getValue().getCurrentValue();
        this.framerateInput.setText(String.valueOf(frameRate.intValue()));
        Integer tileMode = (Integer)this.tileModuleBean.findParamBeanByKey("joint").getValue().getCurrentValue();
        this.tileModeCombo.select(tileMode.intValue());
        Integer operation = (Integer)this.tileModuleBean.findParamBeanByKey("operation").getValue().getCurrentValue();
        this.tileOperationCombo.select(operation.intValue());
        if (this.tileOperationCombo.getSelectionIndex() == 0) {
            this.tileModeCombo.setEnabled(false);
        } else {
            this.tileModeCombo.setEnabled(true);
        }
        ParamBean sensorParamBean = this.sensorModuleBean.findParamBeanByKey("name");
        String currentSensorName = (String)sensorParamBean.getValue().getCurrentValue();
        if (StrUtil.isBlank((CharSequence)currentSensorName)) {
            this.sensorNameCombo.deselectAll();
            this.sensorModeCombo.removeAll();
            this.sensorModeCombo.deselectAll();
        } else {
            this.sensorNameCombo.select(this.sensorNames.indexOf(currentSensorName));
            this.updateSensorModeCombo(this.sensorNameCombo.getText());
        }
        Integer outputPathType = (Integer)this.outputModuleBean.findParamBeanByKey("type").getValue().getCurrentValue();
        if (outputPathType != null) {
            this.outputPathCombo.select(outputPathType.intValue());
        }
        if ((outputFormat = (Integer)this.outputModuleBean.findParamBeanByKey(":format").getValue().getCurrentValue()) != null) {
            this.outputFormatCombo.select(outputFormat.intValue());
        }
        if ((bayerPattern = (Integer)this.outputModuleBean.findParamBeanByKey(":bayerPattern").getValue().getCurrentValue()) != null) {
            this.outputBayerPatternCombo.select(bayerPattern.intValue());
        }
        if ((bits = (Integer)this.outputModuleBean.findParamBeanByKey(":bits").getValue().getCurrentValue()) != null) {
            this.outputBitsScale.setSelection(bits.intValue());
            this.outputBitsInput.setText(String.valueOf(bits));
            outputBits = bits;
        }
        if ((width = (Integer)this.outputModuleBean.findParamBeanByKey(":width").getValue().getCurrentValue()) != null) {
            this.outputWidthInput.setText(String.valueOf(width));
            outputWidth = width;
        }
        if ((height = (Integer)this.outputModuleBean.findParamBeanByKey(":height").getValue().getCurrentValue()) != null) {
            this.outputHeightInput.setText(String.valueOf(height));
            outputHeight = height;
        }
    }

    private void updateSensorModeCombo(String sensorName) {
        Optional<SensorBean> result;
        this.sensorModeCombo.removeAll();
        this.sensorModeCombo.deselectAll();
        ParamBean modeParamBean = this.sensorModuleBean.findParamBeanByKey("mode");
        Integer currentMode = (Integer)modeParamBean.getValue().getCurrentValue();
        if (currentMode == null) {
            currentMode = 0;
        }
        if ((result = ModuleDataCenter.getInstance().getAllSensorBeans().stream().filter(e -> e.getSensorName().equals(this.sensorNameCombo.getText())).findFirst()).isPresent()) {
            this.sensorBean = result.get();
            Integer i = 0;
            if (currentMode >= this.sensorBean.getModes().size()) {
                currentMode = 0;
                sensorMode = (SensorBean.Mode)this.sensorBean.getModes().get(0);
            }
            for (SensorBean.Mode mode : this.sensorBean.getModes()) {
                String item = String.valueOf(i.toString()) + " " + mode.getSize().getWidth().toString() + "x" + mode.getSize().getHeight().toString() + " " + mode.getHdr();
                this.sensorModeCombo.add(item);
                if (i.equals(currentMode)) {
                    this.sensorModeCombo.select(i.intValue());
                    sensorMode = mode;
                    this.sensorWidth = mode.getSize().getWidth();
                    this.sensorHeight = mode.getSize().getHeight();
                    formatMode = mode.getHdr();
                }
                i = i + 1;
            }
        } else {
            this.sensorBean = null;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Live Preview");
        shell.setSize(600, 600);
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle("Live Preview");
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite streamComposite = new Composite(composite, 0);
        streamComposite.setLayout((Layout)new GridLayout(6, true));
        streamComposite.setLayoutData((Object)new GridData(1808));
        Label streamTitleLabel = new Label(streamComposite, 0);
        streamTitleLabel.setText("Stream Enable");
        streamTitleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.streamCheckBox = new Button(streamComposite, 32);
        this.streamCheckBox.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 4, 1));
        Label urlTitleLabel = new Label(streamComposite, 0);
        urlTitleLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        urlTitleLabel.setText("Stream RTMP URL");
        Text urlInput = new Text(streamComposite, 0);
        urlInput.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 4, 1));
        urlInput.setText("rtmp://ServerIPAddress:1935/tuning/preview");
        urlInput.setEditable(false);
        Label typeLabel = new Label(streamComposite, 0);
        typeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        typeLabel.setText("Input Type");
        this.inputTypeCombo = new Combo(streamComposite, 8);
        this.inputTypeCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.inputTypeCombo.add("Image");
        this.inputTypeCombo.add("Sensor");
        this.inputTypeCombo.select(1);
        Label sensorLabel = new Label(streamComposite, 0);
        sensorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        sensorLabel.setText("Sensor Name");
        this.sensorNameCombo = new Combo(streamComposite, 8);
        this.sensorNameCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label sensorModeLabel = new Label(streamComposite, 0);
        sensorModeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        sensorModeLabel.setText("Sensor Mode");
        this.sensorModeCombo = new Combo(streamComposite, 8);
        this.sensorModeCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label tileOperationLabel = new Label(streamComposite, 0);
        tileOperationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        tileOperationLabel.setText("Tile Operation");
        this.tileOperationCombo = new Combo(streamComposite, 8);
        this.tileOperationCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label tileModeLabel = new Label(streamComposite, 0);
        tileModeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        tileModeLabel.setText("Tile Mode");
        this.tileModeCombo = new Combo(streamComposite, 8);
        this.tileModeCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label pathLabel = new Label(streamComposite, 0);
        pathLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        pathLabel.setText("Output Path");
        this.outputPathCombo = new Combo(streamComposite, 8);
        this.outputPathCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label formatLabel = new Label(streamComposite, 0);
        formatLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        formatLabel.setText("Output Format");
        this.outputFormatCombo = new Combo(streamComposite, 8);
        this.outputFormatCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label bayerPatternLabel = new Label(streamComposite, 0);
        bayerPatternLabel.setText("Output Bayer Pattern");
        bayerPatternLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.outputBayerPatternCombo = new Combo(streamComposite, 8);
        this.outputBayerPatternCombo.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        Label bitsLabel = new Label(streamComposite, 0);
        bitsLabel.setText("Output YUV Bits");
        bitsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.outputBitsInput = new Text(streamComposite, 0);
        this.outputBitsInput.setBackground(Display.getCurrent().getSystemColor(1));
        this.outputBitsInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.outputBitsScale = new Scale(streamComposite, 0);
        this.outputBitsScale.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        Label frameRateLabel = new Label(streamComposite, 0);
        frameRateLabel.setText("Output Frame Rate");
        frameRateLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.framerateInput = new Text(streamComposite, 0);
        this.framerateInput.setBackground(Display.getCurrent().getSystemColor(1));
        this.framerateInput.setText("2");
        this.framerateInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.frameRateScale = new Scale(streamComposite, 0);
        this.frameRateScale.setMaximum(24);
        this.frameRateScale.setMinimum(1);
        this.frameRateScale.setSelection(2);
        this.frameRateScale.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        Label previewsizeLabel = new Label(streamComposite, 0);
        previewsizeLabel.setText("Output Size");
        previewsizeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.outputWidthInput = new Text(streamComposite, 0);
        this.outputWidthInput.setBackground(Display.getCurrent().getSystemColor(1));
        this.outputWidthInput.setText("");
        this.outputWidthInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Label xLabel = new Label(streamComposite, 0);
        xLabel.setText("x");
        xLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        this.outputHeightInput = new Text(streamComposite, 0);
        this.outputHeightInput.setBackground(Display.getCurrent().getSystemColor(1));
        this.outputHeightInput.setText("");
        this.outputHeightInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.sensorModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Sensor");
        if (this.sensorModuleBean == null) {
            ConsoleLogger.print((String)"Sensor module not found.");
            return null;
        }
        this.inputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Input");
        if (this.inputModuleBean == null) {
            ConsoleLogger.print((String)"Input module not found.");
            return null;
        }
        this.outputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Output");
        if (this.outputModuleBean == null) {
            ConsoleLogger.print((String)"Output module not found.");
            return null;
        }
        this.tileModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Tile");
        if (this.tileModuleBean == null) {
            ConsoleLogger.print((String)"Tile module not found.");
            return null;
        }
        ParamBean streamBean = this.inputModuleBean.findParamBeanByKey("isStream");
        if (streamBean == null) {
            ConsoleLogger.print((String)"Please select product first.");
            return null;
        }
        Boolean state = (Boolean)streamBean.getValue().getValue();
        this.streamCheckBox.setSelection(state == null ? false : state);
        this.sensorNames = ModuleDataCenter.getInstance().getAllSensorBeans().stream().filter(e -> e.getModes().size() > 0).map(SensorBean::getSensorName).collect(Collectors.toList());
        int i = 0;
        while (i < this.sensorNames.size()) {
            this.sensorNameCombo.add(this.sensorNames.get(i));
            ++i;
        }
        this.sensorNameCombo.select(0);
        this.updateSensorModeCombo(this.sensorNameCombo.getText());
        this.sensorNameCombo.addListener(13, e -> this.updateSensorModeCombo(this.sensorNameCombo.getText()));
        this.sensorModeCombo.addListener(13, e -> {
            sensorMode = (SensorBean.Mode)this.sensorBean.getModes().get(this.sensorModeCombo.getSelectionIndex());
            this.sensorWidth = sensorMode.getSize().getWidth();
            this.sensorHeight = sensorMode.getSize().getHeight();
            formatMode = sensorMode.getHdr();
        });
        ParamBean tileJointParamBean = this.tileModuleBean.findParamBeanByKey("joint");
        assert (tileJointParamBean != null);
        for (String option : tileJointParamBean.getValue().getOptions()) {
            this.tileModeCombo.add(option);
        }
        this.tileModeCombo.select(0);
        ParamBean tileOperationParamBean = this.tileModuleBean.findParamBeanByKey("operation");
        assert (tileOperationParamBean != null);
        for (String option : tileOperationParamBean.getValue().getOptions()) {
            this.tileOperationCombo.add(option);
        }
        this.tileOperationCombo.select(0);
        if (this.tileOperationCombo.getSelectionIndex() == 0) {
            this.tileModeCombo.setEnabled(false);
        } else {
            this.tileModeCombo.setEnabled(true);
        }
        this.tileOperationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String tileOperation = PreviewDialog.this.tileOperationCombo.getText();
                if (tileOperation.equals("General")) {
                    PreviewDialog.this.tileModeCombo.setEnabled(false);
                } else {
                    PreviewDialog.this.tileModeCombo.setEnabled(true);
                }
            }
        });
        ParamBean outputPathParamBean = this.outputModuleBean.findParamBeanByKey("type");
        assert (outputPathParamBean != null);
        for (String option : outputPathParamBean.getValue().getOptions()) {
            this.outputPathCombo.add(option);
        }
        this.outputPathCombo.select(0);
        ParamBean formatParamBean = this.outputModuleBean.findParamBeanByKey(":format");
        assert (formatParamBean != null);
        for (String option : formatParamBean.getValue().getOptions()) {
            this.outputFormatCombo.add(option);
        }
        this.outputFormatCombo.select(0);
        ParamBean bayerPatternParamBean = this.outputModuleBean.findParamBeanByKey(":bayerPattern");
        assert (bayerPatternParamBean != null);
        for (String option : bayerPatternParamBean.getValue().getOptions()) {
            this.outputBayerPatternCombo.add(option);
        }
        this.outputBayerPatternCombo.select(0);
        ParamBean bitsParamBean = this.outputModuleBean.findParamBeanByKey(":bits");
        assert (bitsParamBean != null);
        int maxBits = bitsParamBean.getValue().getMax().intValue();
        int minBits = bitsParamBean.getValue().getMin().intValue();
        this.outputBitsScale.setMaximum(maxBits);
        this.outputBitsScale.setMinimum(minBits);
        this.outputBitsScale.setSelection(minBits);
        this.outputBitsInput.setText(String.valueOf(minBits));
        this.outputBitsInput.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = PreviewDialog.this.outputBitsInput.getText();
                if (!PreviewDialog.this.inputCheck(valueStr)) {
                    PreviewDialog.this.outputBitsInput.setText(PreviewDialog.this.lastBitsInput);
                    return;
                }
                int num = Integer.parseInt(valueStr);
                if (num <= minBits) {
                    num = minBits;
                } else if (num >= maxBits) {
                    num = maxBits;
                }
                PreviewDialog.this.outputBitsInput.setText(String.valueOf(num));
                PreviewDialog.this.lastBitsInput = PreviewDialog.this.outputBitsInput.getText();
                PreviewDialog.this.outputBitsScale.setSelection(num);
            }
        });
        this.outputBitsInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    PreviewDialog.this.outputBitsInput.notifyListeners(27, new Event());
                }
            }
        });
        this.outputBitsScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String str = String.valueOf(PreviewDialog.this.outputBitsScale.getSelection());
                PreviewDialog.this.outputBitsInput.setText(str);
                PreviewDialog.this.outputBitsInput.notifyListeners(27, new Event());
                outputBits = PreviewDialog.this.outputBitsScale.getSelection();
            }
        });
        this.framerateInput.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = PreviewDialog.this.framerateInput.getText();
                PreviewDialog.this.frameRateScale.setSelection(Integer.valueOf(valueStr).intValue());
            }
        });
        this.frameRateScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String str = String.valueOf(PreviewDialog.this.frameRateScale.getSelection());
                PreviewDialog.this.framerateInput.setText(str);
            }
        });
        this.outputWidthInput.setText(String.valueOf(this.sensorWidth));
        this.outputHeightInput.setText(String.valueOf(this.sensorHeight));
        this.outputWidthInput.addListener(27, e -> {
            int val = 0;
            try {
                val = Integer.parseUnsignedInt(this.outputWidthInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                val = this.sensorWidth;
            }
            int width = 0;
            if (val >= this.sensorWidth) {
                width = this.sensorWidth;
            } else {
                int multiple = Math.round(val / 16);
                width = 16 * multiple;
            }
            this.outputWidthInput.setText(String.valueOf(width));
            this.outputWidthInput.notifyListeners(13, new Event());
        });
        this.outputWidthInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (!PreviewDialog.this.inputCheck(PreviewDialog.this.outputWidthInput.getText())) {
                    return;
                }
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    PreviewDialog.this.outputWidthInput.notifyListeners(27, new Event());
                }
            }
        });
        this.outputHeightInput.addListener(27, e -> {
            int val = 0;
            try {
                val = Integer.parseUnsignedInt(this.outputHeightInput.getText());
            }
            catch (NumberFormatException numberFormatException) {
                val = this.sensorHeight;
            }
            int height = Math.min(this.sensorHeight, val);
            this.outputHeightInput.setText(String.valueOf(height));
            this.outputHeightInput.notifyListeners(13, new Event());
        });
        this.outputHeightInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (!PreviewDialog.this.inputCheck(PreviewDialog.this.outputHeightInput.getText())) {
                    return;
                }
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    PreviewDialog.this.outputWidthInput.notifyListeners(27, new Event());
                }
            }
        });
        if (this.dialogSettingManager.getIsConnected().booleanValue()) {
            this.readAndUpdateModuleBean();
        }
        return composite;
    }

    protected void okPressed() {
        try {
            this.dialogSettingManager.setIsConnected(true);
            try {
                outputPath = this.outputPathCombo.getText();
                outputFormat = this.outputFormatCombo.getText();
                outputWidth = Integer.valueOf(this.outputWidthInput.getText());
                outputHeight = Integer.valueOf(this.outputHeightInput.getText());
                outputBayerPattern = this.outputBayerPatternCombo.getText();
                this.outputModuleBean.findParamBeanByKey("type").getValue().setCurrentValue((Object)this.outputPathCombo.getSelectionIndex());
                this.outputModuleBean.findParamBeanByKey(":width").getValue().setCurrentValue((Object)outputWidth);
                this.outputModuleBean.findParamBeanByKey(":height").getValue().setCurrentValue((Object)outputHeight);
                this.outputModuleBean.findParamBeanByKey(":bayerPattern").getValue().setCurrentValue((Object)this.outputBayerPatternCombo.getSelectionIndex());
                this.outputModuleBean.findParamBeanByKey(":bits").getValue().setCurrentValue((Object)this.outputBitsScale.getSelection());
                this.outputModuleBean.findParamBeanByKey(":format").getValue().setCurrentValue((Object)this.outputFormatCombo.getSelectionIndex());
                ArrayList<ParamBean> outputModuleParams = new ArrayList<ParamBean>();
                outputModuleParams.add(this.outputModuleBean.findParamBeanByKey("type"));
                outputModuleParams.add(this.outputModuleBean.findParamBeanByKey(":width"));
                outputModuleParams.add(this.outputModuleBean.findParamBeanByKey(":height"));
                outputModuleParams.add(this.outputModuleBean.findParamBeanByKey(":format"));
                outputModuleParams.add(this.outputModuleBean.findParamBeanByKey(":bayerPattern"));
                outputModuleParams.add(this.outputModuleBean.findParamBeanByKey(":bits"));
                String outputModuleRequestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(outputModuleParams, Boolean.valueOf(true));
                String response = ClientHolder.getInstance().sendSyncRequest(outputModuleRequestString);
                if (StrUtil.isEmpty((CharSequence)response)) {
                    return;
                }
                JSONArray jsonAr = JSONUtil.parseArray((String)response);
                int i = 0;
                while (i < jsonAr.size()) {
                    JSONObject paramObj = jsonAr.getJSONObject((Object)i);
                    String key = paramObj.getStr((Object)"key");
                    String message = paramObj.getStr((Object)"message");
                    if (!StrUtil.isEmpty((CharSequence)message)) {
                        ConsoleLogger.printErrorMsg((String)("WriteOuputModuleData Failed: {" + key + " : " + message + "}"));
                    }
                    ++i;
                }
                this.tileModuleBean.findParamBeanByKey("operation").getValue().setCurrentValue((Object)this.tileOperationCombo.getSelectionIndex());
                this.tileModuleBean.findParamBeanByKey("joint").getValue().setCurrentValue((Object)this.tileModeCombo.getSelectionIndex());
                ArrayList<ParamBean> tileModuleParams = new ArrayList<ParamBean>();
                tileModuleParams.add(this.tileModuleBean.findParamBeanByKey("operation"));
                tileModuleParams.add(this.tileModuleBean.findParamBeanByKey("joint"));
                String tileString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(tileModuleParams, Boolean.valueOf(true));
                response = ClientHolder.getInstance().sendSyncRequest(tileString);
                if (StrUtil.isEmpty((CharSequence)response)) {
                    return;
                }
                jsonAr = JSONUtil.parseArray((String)response);
                int i2 = 0;
                while (i2 < jsonAr.size()) {
                    JSONObject paramObj = jsonAr.getJSONObject((Object)i2);
                    String key = paramObj.getStr((Object)"key");
                    String message = paramObj.getStr((Object)"message");
                    if (!StrUtil.isEmpty((CharSequence)message)) {
                        ConsoleLogger.printErrorMsg((String)("WriteTileModuleData Failed: {" + key + " : " + message + "}"));
                    }
                    ++i2;
                }
                this.sensorModuleBean.findParamBeanByKey("name").getValue().setCurrentValue((Object)this.sensorNameCombo.getText());
                this.sensorModuleBean.findParamBeanByKey("mode").getValue().setCurrentValue((Object)Math.max(this.sensorModeCombo.getSelectionIndex(), 0));
                String sensorString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(this.sensorModuleBean, Boolean.valueOf(true));
                response = ClientHolder.getInstance().sendSyncRequest(sensorString);
                if (StrUtil.isEmpty((CharSequence)response)) {
                    return;
                }
                jsonAr = JSONUtil.parseArray((String)response);
                int i3 = 0;
                while (i3 < jsonAr.size()) {
                    JSONObject paramObj = jsonAr.getJSONObject((Object)i3);
                    String key = paramObj.getStr((Object)"key");
                    String message = paramObj.getStr((Object)"message");
                    if (!StrUtil.isEmpty((CharSequence)message)) {
                        ConsoleLogger.printErrorMsg((String)("WriteSensorModuleData Failed: {" + key + " : " + message + "}"));
                    }
                    ++i3;
                }
                this.inputModuleBean.findParamBeanByKey("isStream").getValue().setCurrentValue((Object)this.streamCheckBox.getSelection());
                this.inputModuleBean.findParamBeanByKey("type").getValue().setCurrentValue((Object)this.inputTypeCombo.getSelectionIndex());
                this.inputModuleBean.findParamBeanByKey("framerate").getValue().setCurrentValue((Object)Integer.parseInt(this.framerateInput.getText()));
                ArrayList<ParamBean> inputModuleParams = new ArrayList<ParamBean>();
                inputModuleParams.add(this.inputModuleBean.findParamBeanByKey("type"));
                inputModuleParams.add(this.inputModuleBean.findParamBeanByKey("framerate"));
                inputModuleParams.add(this.inputModuleBean.findParamBeanByKey("isStream"));
                String inputModuleRequestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(inputModuleParams, Boolean.valueOf(true));
                if (this.dialogSettingManager.getServerType().equals("TCP")) {
                    VideoView videoView = new VideoView();
                    if (((Boolean)this.inputModuleBean.findParamBeanByKey("isStream").getValue().getValue()).booleanValue()) {
                        videoView.start(inputModuleRequestString);
                    } else {
                        videoView.stop(inputModuleRequestString);
                    }
                    ConsoleLogger.print((String)(" >> " + inputModuleRequestString));
                    this.cancelPressed();
                } else {
                    ClientHolder.getInstance().sendAsyncRequest(inputModuleRequestString, new ClientHolder.ResponseListener(){

                        public void success(String response) {
                            JSONArray jsonAr = JSONUtil.parseArray((String)response);
                            int i = 0;
                            while (i < jsonAr.size()) {
                                JSONObject paramObj = jsonAr.getJSONObject((Object)i);
                                String key = paramObj.getStr((Object)"key");
                                String message = paramObj.getStr((Object)"message");
                                if (!StrUtil.isEmpty((CharSequence)message)) {
                                    ConsoleLogger.printErrorMsg((String)("WriteInputModuleData Failed: {" + key + " : " + message + "}"));
                                }
                                ++i;
                            }
                            PreviewDialog.this.cancelPressed();
                        }

                        public void failed(String response) {
                            ConsoleLogger.printErrorMsg((String)"ReadSensorData Failed");
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.dialogSettingManager.setIsConnected(false);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

