/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchMatrix;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MatrixDialog
extends Dialog {
    private List<Object> jobList;
    private BatchParamBean batchParamBean;
    private final int maxMatrixNum = 5;

    public MatrixDialog(Shell parentShell) {
        super(parentShell);
    }

    public List<Object> getJobList() {
        return this.jobList;
    }

    public void setJobList(List<Object> jobList) {
        this.jobList = jobList;
    }

    public void setBatchParamBean(BatchParamBean bean) {
        this.batchParamBean = bean;
    }

    private void groupShow(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(5, true));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        Button addBtn = new Button((Composite)group, 8);
        addBtn.setImage(ImageRegistry.getImage(ImageRegistry.SERVER_STATUS_PASS));
        addBtn.setLayoutData((Object)new GridData(131072, 128, false, false, 5, 1));
        addBtn.setEnabled(this.jobList.size() < 5);
        addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParamBean newParamBean = MatrixDialog.this.batchParamBean.getCopyParamBean();
                BatchMatrix batchMatrix = new BatchMatrix();
                batchMatrix.setNames(MatrixDialog.this.batchParamBean.getMatrixNames() == null ? new ArrayList() : MatrixDialog.this.batchParamBean.getMatrixNames());
                if (batchMatrix.show(newParamBean) == 0) {
                    MatrixDialog.this.jobList.add(newParamBean.getValue().getValue());
                    MatrixDialog.this.batchParamBean.setMatrixNames(batchMatrix.getNames());
                    group.dispose();
                    MatrixDialog.this.groupShow(parent);
                    parent.pack();
                    parent.getShell().pack();
                }
            }
        });
        if (this.jobList.size() == 0) {
            Label label = new Label((Composite)group, 0);
            label.setLayoutData((Object)new GridData(0x1000000, 4, true, true, 5, 1));
            label.setText("Please Select a Matrix");
        } else {
            int i = 0;
            while (i < this.jobList.size()) {
                Button button = new Button((Composite)group, 0);
                button.setText((String)this.batchParamBean.getMatrixNames().get(i));
                button.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
                ParamBean tempParamBean = this.batchParamBean.getCopyParamBean();
                tempParamBean.getValue().setCurrentValue(this.jobList.get(i));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        BatchMatrix batchMatrix = new BatchMatrix();
                        batchMatrix.setAddPattern(false);
                        batchMatrix.show(tempParamBean);
                    }
                });
                Button rmvBtn = new Button((Composite)group, 0);
                rmvBtn.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
                rmvBtn.setImage(ImageRegistry.getImage(ImageRegistry.BATCH_TASK_DELETE));
                rmvBtn.setBackground(Display.getCurrent().getSystemColor(3));
                int currentIndex = i++;
                rmvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MatrixDialog.this.jobList.remove(currentIndex);
                        MatrixDialog.this.batchParamBean.getMatrixNames().remove(currentIndex);
                        group.dispose();
                        MatrixDialog.this.groupShow(parent);
                        parent.pack();
                        parent.getShell().pack();
                    }
                });
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(5, true));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.groupShow(composite);
        return composite;
    }
}

