/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import cn.hutool.core.io.file.FileWriter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.helpers.DefaultHandler;

public class JsonXmlEditDialog
extends TitleAreaDialog {
    private final int OpenButtonID = 22;
    private final int SaveButtonID = 23;
    private final int SaveAsButtonID = 24;
    private Button saveBtn;
    private Button saveAsBtn;
    private StyledText styledText;
    private String str = "";
    private boolean isFirstLoad;
    private String[] strSplit;
    private final String strRegex = "[[A-Za-z0-9-/./,/;\"\b\\{\\}\\[\\]\\:\\\r\\s*<>]]";
    private boolean isValid = true;
    private String jsonPath;
    private String fileType;

    public JsonXmlEditDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Json/XML Edit");
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        return ret;
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle("Json/XML Edit");
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.styledText = new StyledText(composite, 2882);
        this.styledText.setLayoutData((Object)new GridData(500, 850));
        Font font = new Font((Device)Display.getDefault(), "Courier New", 10, 0);
        this.styledText.setFont(font);
        StyledTextContent content = this.styledText.getContent();
        this.styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                Pattern pattern = Pattern.compile("[[A-Za-z0-9-/./,/;\"\b\\{\\}\\[\\]\\:\\\r\\s*<>]]");
                Matcher matcher = pattern.matcher(Character.toString(event.character));
                event.doit = JsonXmlEditDialog.this.styledText.getText() != "" ? matcher.find() || event.keyCode == 0x1000001 || event.keyCode == 0x1000002 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 : false;
            }
        });
        this.styledText.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent event) {
                if (JsonXmlEditDialog.this.isFirstLoad) {
                    JsonXmlEditDialog.this.isFirstLoad = false;
                    return;
                }
                int startLine = content.getLineAtOffset(event.start);
                if (JsonXmlEditDialog.this.fileType.equals("xml")) {
                    try {
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        SAXParser parser = factory.newSAXParser();
                        parser.parse((InputStream)new ByteArrayInputStream(JsonXmlEditDialog.this.styledText.getText().getBytes()), new DefaultHandler());
                        JsonXmlEditDialog.this.styledText.setLineBackground(0, JsonXmlEditDialog.this.strSplit.length - 1, new Color(null, 255, 252, 255));
                    }
                    catch (Exception exception) {
                        JsonXmlEditDialog.this.styledText.setLineBackground(startLine, 1, new Color(null, 255, 0, 0));
                        return;
                    }
                }
                if (JsonXmlEditDialog.this.fileType.equals("json")) {
                    try {
                        new JSONObject((Object)JsonXmlEditDialog.this.styledText.getText());
                        JsonXmlEditDialog.this.styledText.setLineBackground(0, JsonXmlEditDialog.this.strSplit.length - 1, new Color(null, 255, 252, 255));
                    }
                    catch (JSONException jSONException) {
                        JsonXmlEditDialog.this.styledText.setLineBackground(startLine, 1, new Color(null, 255, 0, 0));
                        return;
                    }
                }
            }
        });
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (22 == buttonId) {
            this.OpenFile();
        } else if (23 == buttonId) {
            this.SaveFile();
        } else if (24 == buttonId) {
            this.SaveAsFile();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 22, "Open", false);
        this.saveBtn = this.createButton(parent, 23, "Save", false);
        this.saveAsBtn = this.createButton(parent, 24, "Save as", false);
        this.saveBtn.setEnabled(false);
        this.saveAsBtn.setEnabled(false);
        parent.setLayoutData((Object)new GridData(128));
    }

    private void OpenFile() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        fileDialog.setFilterNames(new String[]{"(*.json *.xml)"});
        fileDialog.setFilterExtensions(new String[]{"*.json;*.xml"});
        fileDialog.setFilterPath(System.getProperty("user.dir"));
        fileDialog.open();
        if (fileDialog.getFileName() != null && !fileDialog.getFileName().equals("")) {
            this.jsonPath = String.valueOf(fileDialog.getFilterPath()) + "\\" + fileDialog.getFileName();
            File file = new File(this.jsonPath);
            byte[] bytes = new byte[(int)file.length()];
            try {
                FileInputStream in = new FileInputStream(file);
                in.read(bytes);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.str = new String(bytes);
            this.strSplit = this.str.split("\n");
            if (this.str.startsWith("<")) {
                this.fileType = "xml";
            } else if (this.str.startsWith("{")) {
                this.fileType = "json";
            }
            this.isFirstLoad = true;
            this.styledText.setText(this.str);
            this.saveBtn.setEnabled(true);
            this.saveAsBtn.setEnabled(true);
        }
    }

    private void SaveFile() {
        if (this.fileType.equals("xml")) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputStream)new ByteArrayInputStream(this.styledText.getText().getBytes()), new DefaultHandler());
                this.isValid = true;
            }
            catch (Exception exception) {
                this.isValid = false;
            }
        } else if (this.fileType.equals("json")) {
            try {
                new JSONObject((Object)this.styledText.getText());
                this.isValid = true;
            }
            catch (JSONException jSONException) {
                this.isValid = false;
            }
        }
        if (this.isValid) {
            if (this.jsonPath != null) {
                FileWriter fileWriter = new FileWriter(this.jsonPath.toString());
                fileWriter.write(this.styledText.getText());
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)"Save Success!");
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Syntax error in the file, Please check.");
        }
    }

    private void SaveAsFile() {
        if (this.fileType.equals("xml")) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputStream)new ByteArrayInputStream(this.styledText.getText().getBytes()), new DefaultHandler());
                this.isValid = true;
            }
            catch (Exception exception) {
                this.isValid = false;
            }
        } else if (this.fileType.equals("json")) {
            try {
                new JSONObject((Object)this.styledText.getText());
                this.isValid = true;
            }
            catch (JSONException jSONException) {
                this.isValid = false;
            }
        }
        if (this.isValid) {
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            fileDialog.setFilterExtensions(new String[]{"*." + this.fileType});
            fileDialog.setFilterPath(System.getProperty("user.dir"));
            fileDialog.setFileName("1111");
            fileDialog.setText("Save");
            String fileName = fileDialog.open();
            if (fileName != null) {
                Path filePath = Paths.get(fileName, new String[0]);
                FileWriter fileWriter = new FileWriter(filePath.toString());
                fileWriter.write(this.styledText.getText());
            }
        } else {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Syntax error in the file, Please check.");
        }
    }
}

