/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageInputDialog
extends TitleAreaDialog {
    private List<String> imagePath = new ArrayList<String>();
    private static final String BASE64_PREFIX = "data:image/raw;base64,";
    private List<StringBuffer> encodes = new ArrayList<StringBuffer>();
    private Text frameBInput;
    private Text frameNumInput;
    private final int frameStep = 1;
    private final int maxFrameNum = 10;
    private Text widthInput;
    private Text heightInput;
    private Combo formatCombo;
    private Combo bayerPatternCombo;
    private Button videoBtn;
    private int timeout = 0;
    private ModuleBean inputModuleBean;
    private ParamBean formatBean;
    private ParamBean bayerPatternBean;

    public ImageInputDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Image Input");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected Control createContents(Composite parent) {
        this.setHelpAvailable(false);
        Control ret = super.createContents(parent);
        return ret;
    }

    protected void okPressed() {
        if (this.imagePath.size() == 0) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Plaese select input image");
            return;
        }
        if (!StrUtil.isNumeric((CharSequence)this.widthInput.getText())) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Plaese input width");
            return;
        }
        if (!StrUtil.isNumeric((CharSequence)this.heightInput.getText())) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Plaese input height");
            return;
        }
        Shell shell = new Shell(Display.getCurrent(), 65632);
        shell.setText("Image Input");
        shell.setSize(400, 200);
        shell.setLayout((Layout)new GridLayout(3, true));
        Label label = new Label((Composite)shell, 0);
        label.setText("Waiting for Processing......");
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 3, 1));
        shell.open();
        String queryString = null;
        try {
            queryString = this.makeQueryString();
        }
        catch (Exception e) {
            shell.close();
            ConsoleLogger.printErrorMsg((String)("Failed: " + e.getMessage()));
            return;
        }
        if (queryString == null) {
            shell.close();
            ConsoleLogger.printErrorMsg((String)"Failed: Null Request");
            return;
        }
        ClientHolder.getInstance().sendAsyncRequest(queryString, new ClientHolder.ResponseListener(){

            public void success(String response) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)"Image upload success!");
                shell.close();
                ImageInputDialog.this.cancelPressed();
            }

            public void failed(String response) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)("Fail to upload image: " + response));
                shell.close();
            }
        }, this.timeout);
    }

    public Control createDialogArea(Composite parent) {
        this.timeout = DialogSettingManager.getInstance().getServerType() == "UART" ? 300000 : 150000;
        this.setTitle("Image Input");
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite paramCompsite = new Composite(composite, 0);
        paramCompsite.setLayout((Layout)new GridLayout(2, false));
        paramCompsite.setLayoutData((Object)new GridData(1808));
        Label patLabel = new Label(paramCompsite, 0);
        patLabel.setText("Video Input");
        patLabel.setLayoutData((Object)new GridData(200, 20));
        this.videoBtn = new Button(paramCompsite, 32);
        this.videoBtn.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(paramCompsite, 0);
        imageLabel.setText("Image File ");
        imageLabel.setLayoutData((Object)new GridData(100, 20));
        Button selectImageBtn = new Button(paramCompsite, 8);
        selectImageBtn.setText("Select Image(*.bin, *.raw)");
        selectImageBtn.setLayoutData((Object)new GridData(768));
        selectImageBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4098);
                String[] extensions = new String[]{"*.bin; *.raw"};
                fileDialog.setFilterExtensions(extensions);
                fileDialog.open();
                if (fileDialog.getFilterPath() != null && !fileDialog.getFilterPath().equals("")) {
                    ImageInputDialog.this.imagePath.clear();
                    String[] files = fileDialog.getFileNames();
                    String text = "";
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        ImageInputDialog.this.imagePath.add(String.valueOf(fileDialog.getFilterPath()) + "\\" + str);
                        text = String.valueOf(text) + str + ",";
                        ++n2;
                    }
                    selectImageBtn.setText(text);
                }
            }
        });
        Label frameB = new Label(paramCompsite, 0);
        frameB.setText("Frame Begin");
        frameB.setLayoutData((Object)new GridData(200, 20));
        this.frameBInput = new Text(paramCompsite, 0);
        this.frameBInput.setLayoutData((Object)new GridData(768));
        Label frameNum = new Label(paramCompsite, 0);
        frameNum.setText("Frame Num");
        frameNum.setLayoutData((Object)new GridData(200, 20));
        this.frameNumInput = new Text(paramCompsite, 0);
        this.frameNumInput.setLayoutData((Object)new GridData(768));
        frameB.setEnabled(this.videoBtn.getSelection());
        this.frameBInput.setEnabled(this.videoBtn.getSelection());
        frameNum.setEnabled(this.videoBtn.getSelection());
        this.frameNumInput.setEnabled(this.videoBtn.getSelection());
        this.videoBtn.addListener(13, e -> {
            frameB.setEnabled(this.videoBtn.getSelection());
            this.frameBInput.setEnabled(this.videoBtn.getSelection());
            frameNum.setEnabled(this.videoBtn.getSelection());
            this.frameNumInput.setEnabled(this.videoBtn.getSelection());
        });
        Label widthLabel = new Label(paramCompsite, 0);
        widthLabel.setText("Width");
        widthLabel.setLayoutData((Object)new GridData(200, 20));
        this.widthInput = new Text(paramCompsite, 0);
        this.widthInput.setLayoutData((Object)new GridData(768));
        Label heightLabel = new Label(paramCompsite, 0);
        heightLabel.setText("Height");
        heightLabel.setLayoutData((Object)new GridData(200, 20));
        this.heightInput = new Text(paramCompsite, 0);
        this.heightInput.setLayoutData((Object)new GridData(768));
        Label formatLabel = new Label(paramCompsite, 0);
        formatLabel.setText("Format");
        formatLabel.setLayoutData((Object)new GridData(200, 20));
        this.formatCombo = new Combo(paramCompsite, 8);
        this.formatCombo.setLayoutData((Object)new GridData(768));
        this.inputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Input");
        if (this.inputModuleBean == null) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Please select a project.");
            return null;
        }
        this.formatBean = this.inputModuleBean.findParamBeanByKey(":format");
        assert (this.formatBean != null);
        Integer formatIndex = (Integer)this.formatBean.getValue().getCurrentValue();
        if (formatIndex == null) {
            formatIndex = 0;
        }
        for (String format : this.formatBean.getValue().getOptions()) {
            this.formatCombo.add(format);
        }
        this.formatCombo.select(formatIndex.intValue());
        Label bayerpatternLabel = new Label(paramCompsite, 0);
        bayerpatternLabel.setText("Bayer Pattern");
        bayerpatternLabel.setLayoutData((Object)new GridData(200, 20));
        this.bayerPatternCombo = new Combo(paramCompsite, 8);
        this.bayerPatternCombo.setLayoutData((Object)new GridData(768));
        this.bayerPatternBean = this.inputModuleBean.findParamBeanByKey(":bayerPattern");
        assert (this.bayerPatternBean != null);
        Integer bayerPatternIndex = (Integer)this.bayerPatternBean.getValue().getCurrentValue();
        if (bayerPatternIndex == null) {
            bayerPatternIndex = 0;
        }
        assert (this.bayerPatternBean != null);
        for (String pattern : this.bayerPatternBean.getValue().getOptions()) {
            this.bayerPatternCombo.add(pattern);
        }
        this.bayerPatternCombo.select(bayerPatternIndex.intValue());
        return composite;
    }

    private String makeQueryString() {
        FileInputStream in = null;
        this.encodes.clear();
        if (this.videoBtn.getSelection()) {
            if (!this.valueCheck()) {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Info", (String)"Input Error: Please Check the Inputted Value!");
                return null;
            }
            int width = Integer.valueOf(this.widthInput.getText());
            int height = Integer.valueOf(this.heightInput.getText());
            File file = new File(this.imagePath.get(0));
            String rawPicPath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/rawPics/";
            File dict = new File(rawPicPath);
            if (dict.exists()) {
                File[] fileArray = dict.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    f.delete();
                    ++n2;
                }
            }
            dict.delete();
            dict.mkdir();
            int size = 0;
            size = this.formatCombo.getSelectionIndex() == 0 ? width * height : width * height * 2;
            try {
                int beginFrame = Integer.valueOf(this.frameBInput.getText());
                int numFrame = Integer.valueOf(this.frameNumInput.getText());
                in = new FileInputStream(file);
                long t = (long)beginFrame * (long)size;
                in.skip(t);
                int index = beginFrame;
                byte[] bytes = new byte[size];
                while (in.read(bytes) != -1) {
                    FileOutputStream fout = new FileOutputStream(dict + "\\" + String.valueOf(index++) + ".raw");
                    fout.write(bytes);
                    StringBuffer encode = new StringBuffer();
                    encode.append(Base64.getEncoder().encodeToString(bytes));
                    this.encodes.add(encode);
                    if (index - beginFrame >= numFrame) break;
                    in.skip(0L * (long)size);
                }
            }
            catch (IOException event) {
                event.printStackTrace();
                return null;
            }
        } else {
            int i = 0;
            while (i < this.imagePath.size()) {
                File file = new File(this.imagePath.get(i));
                try {
                    StringBuffer encode = new StringBuffer();
                    in = new FileInputStream(file);
                    byte[] bytes = new byte[(int)file.length()];
                    in.read(bytes);
                    encode.append(Base64.getEncoder().encodeToString(bytes));
                    this.encodes.add(encode);
                }
                catch (IOException event) {
                    event.printStackTrace();
                    return null;
                }
                ++i;
            }
        }
        JSONArray imagesArray = new JSONArray();
        int i = 0;
        while (i < this.encodes.size()) {
            imagesArray.add((Object)(BASE64_PREFIX + this.encodes.get(i).toString()));
            ++i;
        }
        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
        this.inputModuleBean.findParamBeanByKey("type").getValue().setCurrentValue((Object)new Integer(0));
        this.inputModuleBean.findParamBeanByKey("images").getValue().setCurrentValue((Object)imagesArray);
        this.inputModuleBean.findParamBeanByKey(":bayerPattern").getValue().setCurrentValue((Object)this.bayerPatternCombo.getSelectionIndex());
        this.inputModuleBean.findParamBeanByKey(":format").getValue().setCurrentValue((Object)this.formatCombo.getSelectionIndex());
        this.inputModuleBean.findParamBeanByKey(":width").getValue().setCurrentValue((Object)new Integer(this.widthInput.getText()));
        this.inputModuleBean.findParamBeanByKey(":height").getValue().setCurrentValue((Object)new Integer(this.heightInput.getText()));
        params.add(this.inputModuleBean.findParamBeanByKey("type"));
        params.add(this.inputModuleBean.findParamBeanByKey("images"));
        params.add(this.inputModuleBean.findParamBeanByKey(":bayerPattern"));
        params.add(this.inputModuleBean.findParamBeanByKey(":format"));
        params.add(this.inputModuleBean.findParamBeanByKey(":width"));
        params.add(this.inputModuleBean.findParamBeanByKey(":height"));
        String requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(params, Boolean.valueOf(true));
        return requestString;
    }

    private boolean valueCheck() {
        int frameNum;
        int beginFrame;
        block3: {
            try {
                beginFrame = Integer.parseInt(this.frameBInput.getText());
                frameNum = Integer.parseInt(this.frameNumInput.getText());
                if (frameNum <= 10) break block3;
                ConsoleLogger.printWarningMsg((String)"Frame Number Should Not Exceed 10");
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return beginFrame >= 0 && frameNum > 0;
    }
}

