/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import cn.hutool.core.io.file.FileReader;
import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.core.util.StrBinaryConverter;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JOptionPane;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditRegisterDialog
extends TitleAreaDialog {
    private List<Button> checkBoxes = new ArrayList<Button>();
    private List<Label> bitLabels = new ArrayList<Label>();
    private final int ReadButtonID = 24;
    private final int WriteButtonID = 25;
    private Table registerTable;
    private Button addButton;
    private Button deleteButton;
    private Text addressText;
    private Text valueText;
    private Label countLabel;
    private Label valueLabel;
    private Text countText;
    private Button sequenceBtn;
    private Combo typeCombo;
    private final String[] regType = new String[]{"ISP", "Sensor"};

    public EditRegisterDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Edit Register");
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        return ret;
    }

    private void clearBitCheckBox() {
        if (this.checkBoxes != null) {
            for (Button checkBox : this.checkBoxes) {
                checkBox.setSelection(false);
            }
        }
    }

    private void clearValue() {
        this.valueText.setText("");
        this.clearBitCheckBox();
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle("Edit Register");
        Composite workArea = new Composite(parent, 16);
        workArea.setLayout((Layout)new GridLayout(1, false));
        workArea.setLayoutData((Object)new GridData(1808));
        Composite registerComposite = new Composite(workArea, 0);
        registerComposite.setLayoutData((Object)new GridData(768));
        GridLayout registerLayout = new GridLayout(8, true);
        registerLayout.marginWidth = 0;
        registerComposite.setLayout((Layout)registerLayout);
        Group addressGroup = new Group(registerComposite, 0);
        addressGroup.setLayout((Layout)new GridLayout(1, true));
        addressGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        Composite addressComposite = new Composite((Composite)addressGroup, 0);
        addressComposite.setLayout((Layout)new GridLayout(5, true));
        Label addressLabel = new Label(addressComposite, 0);
        addressLabel.setText("Address ");
        addressLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.addressText = new Text(addressComposite, 2048);
        this.addressText.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.addressText.setText("0x00000000");
        this.addressText.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = EditRegisterDialog.this.addressText.getText();
                if (valueStr == null || valueStr.length() == 0) {
                    EditRegisterDialog.this.addressText.setText("0x00000000");
                    return;
                }
                if (!valueStr.startsWith("0x")) {
                    valueStr = "0x" + valueStr;
                }
                if (!HexUtil.isHexNumber((String)valueStr)) {
                    ConsoleLogger.print((String)"input error");
                    EditRegisterDialog.this.addressText.setText("0x00000000");
                    return;
                }
                if (valueStr.length() >= 10) {
                    valueStr = valueStr.substring(valueStr.length() - 8, valueStr.length());
                } else {
                    String temp = "";
                    int i = 0;
                    while (i < 10 - valueStr.length()) {
                        temp = String.valueOf(temp) + "0";
                        ++i;
                    }
                    valueStr = String.valueOf(temp) + valueStr.substring(2);
                }
                EditRegisterDialog.this.addressText.setText("0x" + valueStr.toUpperCase());
                EditRegisterDialog.this.addressText.selectAll();
                TableItem[] tableItemArray = EditRegisterDialog.this.registerTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getText(0).equals(EditRegisterDialog.this.addressText.getText())) {
                        EditRegisterDialog.this.valueText.setText(valueStr.toUpperCase());
                        EditRegisterDialog.this.typeCombo.select(item.getText(2).equals(EditRegisterDialog.this.regType[0]) ? 0 : 1);
                        break;
                    }
                    ++n2;
                }
            }
        });
        this.addressText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    EditRegisterDialog.this.addressText.notifyListeners(27, new Event());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addressText.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (EditRegisterDialog.this.addressText.getText().length() > 0) {
                    EditRegisterDialog.this.addressText.selectAll();
                }
                if (EditRegisterDialog.this.valueText != null) {
                    EditRegisterDialog.this.clearValue();
                }
            }
        });
        Group sequenceGroup = new Group(registerComposite, 0);
        sequenceGroup.setLayout((Layout)new GridLayout(1, true));
        sequenceGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 6, 1));
        Composite sequenceComposite = new Composite((Composite)sequenceGroup, 0);
        sequenceComposite.setLayout((Layout)new GridLayout(8, true));
        Label typeLabel = new Label(sequenceComposite, 0);
        typeLabel.setText("Type ");
        typeLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.typeCombo = new Combo(sequenceComposite, 0);
        this.typeCombo.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        int i = 0;
        while (i < this.regType.length) {
            this.typeCombo.add(this.regType[i]);
            ++i;
        }
        this.typeCombo.select(0);
        this.typeCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                TableItem[] tableItemArray = EditRegisterDialog.this.registerTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getText(0).equals(EditRegisterDialog.this.addressText.getText())) {
                        item.setText(2, EditRegisterDialog.this.typeCombo.getItem(EditRegisterDialog.this.typeCombo.getSelectionIndex()));
                        break;
                    }
                    ++n2;
                }
            }
        });
        Label sequenceLabel = new Label(sequenceComposite, 0);
        sequenceLabel.setText("  Sequence ");
        sequenceLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sequenceBtn = new Button(sequenceComposite, 32);
        this.sequenceBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sequenceBtn.addListener(13, e -> this.updateEnableState());
        this.countLabel = new Label(sequenceComposite, 0);
        this.countLabel.setText("Count ");
        this.countLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.countText = new Text(sequenceComposite, 2048);
        this.countText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Group valueGroup = new Group(registerComposite, 0);
        valueGroup.setLayout((Layout)new GridLayout(1, true));
        valueGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        Composite valueComposite = new Composite((Composite)valueGroup, 0);
        valueComposite.setLayout((Layout)new GridLayout(5, true));
        this.valueLabel = new Label(valueComposite, 0);
        this.valueLabel.setText("    Value ");
        this.valueLabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.valueText = new Text(valueComposite, 2048);
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.valueText.setText("");
        this.valueText.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = EditRegisterDialog.this.valueText.getText();
                if (valueStr == null || valueStr.length() == 0) {
                    EditRegisterDialog.this.clearValue();
                    return;
                }
                if (!valueStr.startsWith("0x")) {
                    valueStr = "0x" + valueStr;
                }
                if (!HexUtil.isHexNumber((String)valueStr)) {
                    ConsoleLogger.print((String)"input error");
                    EditRegisterDialog.this.clearValue();
                }
                if (valueStr.length() >= 10) {
                    valueStr = valueStr.substring(valueStr.length() - 8, valueStr.length());
                } else {
                    String temp = "";
                    int i = 0;
                    while (i < 10 - valueStr.length()) {
                        temp = String.valueOf(temp) + "0";
                        ++i;
                    }
                    valueStr = String.valueOf(temp) + valueStr.substring(2);
                }
                EditRegisterDialog.this.valueText.setText("0x" + valueStr.toUpperCase());
                EditRegisterDialog.this.valueText.selectAll();
            }
        });
        this.valueText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    EditRegisterDialog.this.valueText.notifyListeners(27, new Event());
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.valueText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = EditRegisterDialog.this.valueText.getText();
                if (valueStr == null || valueStr.length() == 0) {
                    EditRegisterDialog.this.clearBitCheckBox();
                    return;
                }
                if (!valueStr.startsWith("0x")) {
                    valueStr = "0x" + valueStr;
                }
                if (!HexUtil.isHexNumber((String)valueStr)) {
                    EditRegisterDialog.this.clearBitCheckBox();
                    return;
                }
                if (valueStr.length() >= 10) {
                    valueStr = valueStr.substring(valueStr.length() - 8, valueStr.length());
                } else {
                    String temp = "";
                    int i = 0;
                    while (i < 10 - valueStr.length()) {
                        temp = String.valueOf(temp) + "0";
                        ++i;
                    }
                    valueStr = String.valueOf(temp) + valueStr.substring(2);
                }
                StringBuilder sb = new StringBuilder(8);
                sb.append(valueStr);
                String result = StrBinaryConverter.HexToBin((String)sb.toString());
                boolean[] output = new boolean[32];
                int i = 0;
                while (i < result.length()) {
                    if (result.charAt(i) == '1') {
                        output[i] = true;
                    }
                    ++i;
                }
                Integer flag = 0;
                for (Button checkBox : EditRegisterDialog.this.checkBoxes) {
                    Integer n = flag;
                    flag = n + 1;
                    checkBox.setSelection(output[n]);
                }
                if (EditRegisterDialog.this.addressText.getText() != null) {
                    TableItem[] tableItemArray = EditRegisterDialog.this.registerTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getText(0).equals(EditRegisterDialog.this.addressText.getText())) {
                            item.setText(1, "0x" + valueStr.toUpperCase());
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
        Group bitGroup = new Group(registerComposite, 0);
        bitGroup.setLayout((Layout)new GridLayout(1, false));
        bitGroup.setLayoutData((Object)new GridData(4, 4, true, true, 6, 1));
        Composite bitlabelComposite = new Composite((Composite)bitGroup, 0);
        bitlabelComposite.setLayout((Layout)new RowLayout());
        Composite bitComposite = new Composite((Composite)bitGroup, 0);
        bitComposite.setLayout((Layout)new RowLayout());
        Integer flag = 31;
        int i2 = 0;
        while (i2 < 32) {
            Label bitlabel = new Label(bitlabelComposite, 0);
            Integer n = flag;
            flag = n - 1;
            bitlabel.setText(n.toString());
            if (i2 % 8 == 7) {
                bitlabel.setLayoutData((Object)new RowData(25, 15));
            } else {
                bitlabel.setLayoutData((Object)new RowData(15, 15));
            }
            this.bitLabels.add(bitlabel);
            Button checkBox = new Button(bitComposite, 32);
            this.checkBoxes.add(checkBox);
            if (i2 % 8 == 7) {
                checkBox.setLayoutData((Object)new RowData(25, 15));
            } else {
                checkBox.setLayoutData((Object)new RowData(15, 15));
            }
            ++i2;
        }
        for (Button checkBox : this.checkBoxes) {
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringBuilder registerValuesb = new StringBuilder();
                    int i = 0;
                    while (i < EditRegisterDialog.this.checkBoxes.size()) {
                        registerValuesb.append(((Button)EditRegisterDialog.this.checkBoxes.get(i)).getSelection() ? "1" : "0");
                        ++i;
                    }
                    String result = StrBinaryConverter.BinToHex((String)registerValuesb.toString());
                    EditRegisterDialog.this.valueText.setText("0x" + result.toUpperCase());
                }
            });
        }
        Composite stackContentComposite = new Composite(workArea, 0);
        GridData stackGridData = new GridData(4, 4, true, true);
        stackGridData.horizontalSpan = 3;
        stackContentComposite.setLayoutData((Object)stackGridData);
        stackContentComposite.setLayout((Layout)new StackLayout());
        Composite tableControlComposite = new Composite(stackContentComposite, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginWidth = 0;
        tableControlComposite.setLayout((Layout)topLayout);
        ((StackLayout)stackContentComposite.getLayout()).topControl = tableControlComposite;
        Composite tableComposite = new Composite(tableControlComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        GridLayout listLayout = new GridLayout(2, false);
        listLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)listLayout);
        this.registerTable = new Table(tableComposite, 68354);
        this.registerTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.registerTable.setHeaderVisible(true);
        this.registerTable.setLinesVisible(false);
        new TableColumn(this.registerTable, 0).setText("ADDRESS");
        new TableColumn(this.registerTable, 0).setText("VALUE");
        new TableColumn(this.registerTable, 0).setText("TYPE");
        this.registerTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = EditRegisterDialog.this.registerTable.getClientArea();
                int widgetHeight = ((EditRegisterDialog)EditRegisterDialog.this).registerTable.computeSize((int)-1, (int)-1).y;
                ScrollBar vBar = EditRegisterDialog.this.registerTable.getVerticalBar();
                int width = area.width - ((EditRegisterDialog)EditRegisterDialog.this).registerTable.computeTrim((int)0, (int)0, (int)0, (int)0).width;
                if (widgetHeight > area.height) {
                    int vBarWidth = vBar.getSize().x;
                    width -= vBarWidth;
                }
                int statusColumnWidth = width / 3;
                EditRegisterDialog.this.registerTable.getColumn(2).setWidth(statusColumnWidth);
                EditRegisterDialog.this.registerTable.getColumn(1).setWidth(statusColumnWidth);
                EditRegisterDialog.this.registerTable.getColumn(0).setWidth(width - statusColumnWidth * 2);
            }
        });
        this.registerTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditRegisterDialog.this.registerTable.getSelectionIndex() >= 0) {
                    TableItem item = EditRegisterDialog.this.registerTable.getItem(EditRegisterDialog.this.registerTable.getSelectionIndex());
                    EditRegisterDialog.this.addressText.setText(item.getText(0));
                    EditRegisterDialog.this.valueText.setText(item.getText(1));
                    EditRegisterDialog.this.typeCombo.select(item.getText(2).equals(EditRegisterDialog.this.regType[0]) ? 0 : 1);
                }
            }
        });
        Composite buttonsComposite = new Composite(tableComposite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(1040));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        this.addButton = new Button(buttonsComposite, 8);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData(768));
        this.addButton.setEnabled(true);
        this.deleteButton = new Button(buttonsComposite, 8);
        this.deleteButton.setText("Delete");
        this.deleteButton.setLayoutData((Object)new GridData(768));
        this.deleteButton.setEnabled(this.registerTable.getItemCount() > 0);
        Button importBtn = new Button(buttonsComposite, 8);
        importBtn.setText("Import");
        importBtn.setLayoutData((Object)new GridData(768));
        importBtn.setEnabled(true);
        Button exportBtn = new Button(buttonsComposite, 8);
        exportBtn.setText("Export");
        exportBtn.setLayoutData((Object)new GridData(768));
        exportBtn.setEnabled(true);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!EditRegisterDialog.this.sequenceBtn.getSelection()) {
                        String addressVal = EditRegisterDialog.this.addressText.getText();
                        String valueVal = EditRegisterDialog.this.valueText.getText();
                        String typeStr = EditRegisterDialog.this.regType[EditRegisterDialog.this.typeCombo.getSelectionIndex()];
                        EditRegisterDialog.this.addItem(addressVal, valueVal, typeStr, true);
                    } else {
                        Long addressNum = HexUtil.hexToLong((String)EditRegisterDialog.this.addressText.getText().substring(2));
                        int count = Integer.valueOf(EditRegisterDialog.this.countText.getText());
                        int i = 0;
                        while (i < count) {
                            EditRegisterDialog.this.addItem(EditRegisterDialog.this.standard(addressNum), "", EditRegisterDialog.this.regType[EditRegisterDialog.this.typeCombo.getSelectionIndex()], false);
                            addressNum = addressNum + 1L;
                            ++i;
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    ConsoleLogger.print((String)ex.getMessage());
                }
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditRegisterDialog.this.registerTable.remove(EditRegisterDialog.this.registerTable.getSelectionIndices());
                EditRegisterDialog.this.registerTable.setSelection(EditRegisterDialog.this.registerTable.getItemCount() - 1);
                EditRegisterDialog.this.updateButtonStatus();
                EditRegisterDialog.this.updateTableSelection();
            }
        });
        importBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditRegisterDialog.this.importRegister();
            }
        });
        exportBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditRegisterDialog.this.exportRegister();
            }
        });
        this.updateEnableState();
        return workArea;
    }

    protected void buttonPressed(int buttonId) {
        if (24 == buttonId) {
            this.readRegister();
        } else if (25 == buttonId) {
            this.writeRegister();
        } else if (1 == buttonId) {
            super.cancelPressed();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 24, "Read", false);
        this.createButton(parent, 25, "Write", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        parent.setLayoutData((Object)new GridData(128));
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
        this.getButton(24).setEnabled(this.registerTable.getItemCount() > 0);
        this.getButton(25).setEnabled(this.registerTable.getItemCount() > 0);
        this.deleteButton.setEnabled(this.registerTable.getItemCount() > 0);
    }

    private void updateTableSelection() {
        if (this.registerTable.getItemCount() < 1) {
            this.addressText.setText("");
            this.valueText.setText("");
            this.typeCombo.select(0);
            this.addressText.setFocus();
            return;
        }
        this.registerTable.setSelection(this.registerTable.getItemCount() - 1);
        this.addressText.setText(this.registerTable.getItem(this.registerTable.getItemCount() - 1).getText(0));
        this.valueText.setText(this.registerTable.getItem(this.registerTable.getItemCount() - 1).getText(1));
        if (!this.registerTable.getItem(this.registerTable.getItemCount() - 1).getText(2).equals("Failed")) {
            this.typeCombo.select(this.registerTable.getItem(this.registerTable.getItemCount() - 1).getText(2).equals(this.regType[0]) ? 0 : 1);
        }
        this.registerTable.setFocus();
    }

    private void importRegister() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        fileDialog.setFilterNames(new String[]{"TuningTool Register data(*.txt)", "All Files(*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.txt", "*.*"});
        fileDialog.setFilterPath(System.getProperty("user.dir"));
        fileDialog.setText("Open");
        String fileName = fileDialog.open();
        if (fileName != null) {
            if (this.registerTable.getItemCount() > 0) {
                String message = "Do You Want to Replace Existing Items in the Table ?";
                int option = JOptionPane.showConfirmDialog(null, message, "", 1);
                if (option == 0) {
                    this.registerTable.removeAll();
                } else if (option == 2) {
                    return;
                }
            }
            Path filePath = Paths.get(fileName, new String[0]);
            FileReader fileReader = new FileReader(filePath.toString());
            String fileContent = fileReader.readString();
            JSONArray jsonArray = new JSONArray((Object)fileContent);
            for (Object rowJsonArray : jsonArray) {
                List rowValues = JSONUtil.toList((JSONArray)((JSONArray)rowJsonArray), String.class);
                this.addItem((String)rowValues.get(0), (String)rowValues.get(1), (String)rowValues.get(2), false);
            }
        }
        this.updateTableSelection();
        this.updateButtonStatus();
    }

    private void exportRegister() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        fileDialog.setFilterNames(new String[]{"TuningTool Register Data(*.txt)", "All Files(*.*)"});
        fileDialog.setFilterExtensions(new String[]{"*.txt", "*.*"});
        fileDialog.setFilterPath(System.getProperty("user.dir"));
        fileDialog.setFileName("Register_" + System.currentTimeMillis() + ".txt");
        fileDialog.setText("Save");
        String fileName = fileDialog.open();
        if (fileName != null) {
            ArrayList exportArray = new ArrayList();
            int row = 0;
            while (row < this.registerTable.getItemCount()) {
                TableItem item = this.registerTable.getItem(row);
                ArrayList<String> rowValues = new ArrayList<String>();
                rowValues.add(item.getText(0));
                rowValues.add(item.getText(1));
                exportArray.add(rowValues);
                ++row;
            }
            String fileContent = JSONUtil.toJsonStr(exportArray);
            Path filePath = Paths.get(fileName, new String[0]);
            FileWriter fileWriter = new FileWriter(filePath.toString());
            fileWriter.write(fileContent);
            ConsoleLogger.print((String)("Save data to " + fileName + " success."));
        }
    }

    private void addItem(String address, String value, String type, boolean showWarning) {
        TableItem[] tableItemArray = this.registerTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tempItem = tableItemArray[n2];
            if (tempItem.getText(0).equals(address)) {
                if (showWarning) {
                    String message = "Try to Add an Existed Register. Do You Want to Replace it?";
                    int option = JOptionPane.showConfirmDialog(null, message, "", 0);
                    if (option == 0) {
                        tempItem.setText(1, value);
                        tempItem.setText(2, type);
                        this.updateTableSelection();
                        return;
                    }
                    this.updateTableSelection();
                    return;
                }
                tempItem.setText(1, value);
                tempItem.setText(2, type);
                this.updateTableSelection();
                return;
            }
            ++n2;
        }
        TableItem item = new TableItem(this.registerTable, 0);
        item.setText(0, address);
        item.setText(1, value);
        item.setText(2, type);
        this.updateTableSelection();
        this.updateButtonStatus();
    }

    private void writeRegister() {
        ArrayList<String> diffValues = new ArrayList<String>();
        TableItem[] tableItemArray = this.registerTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!item.getText(1).equals("Failed")) {
                String addressVal = item.getText(0).substring(2);
                String valueVal = item.getText(1).substring(2);
                if (item.getText(1).length() < 2 || !HexUtil.isHexNumber((String)item.getText(1))) {
                    item.setText(1, "Failed");
                } else {
                    ParamBean addressParamBean = new ParamBean("address", "text");
                    addressParamBean.setCategory("RGT");
                    addressParamBean.getValue().setCurrentValue((Object)addressVal);
                    ParamBean valueParamBean = new ParamBean("value", "text");
                    valueParamBean.setCategory("RGT");
                    valueParamBean.getValue().setCurrentValue((Object)valueVal);
                    ParamBean typeParamBean = new ParamBean("type", "option");
                    typeParamBean.setCategory("RGT");
                    int type = item.getText(2).equals("ISP") ? 0 : 1;
                    typeParamBean.getValue().setCurrentValue((Object)type);
                    List<ParamBean> params = Arrays.asList(addressParamBean, typeParamBean, valueParamBean);
                    ParamGroupBean registerGroupBean = new ParamGroupBean("Register");
                    registerGroupBean.setParams(params);
                    ArrayList<ParamGroupBean> paramGroups = new ArrayList<ParamGroupBean>();
                    paramGroups.add(registerGroupBean);
                    ModuleBean registerModuleBean = new ModuleBean("Register");
                    registerModuleBean.setParamGroups(paramGroups);
                    if (DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
                        String requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(registerModuleBean, Boolean.valueOf(true));
                        String response = ClientHolder.getInstance().sendSyncRequest(requestString);
                        if (response != null && response.length() > 0) {
                            paramGroups.clear();
                            params = Arrays.asList(valueParamBean);
                            registerGroupBean.setParams(params);
                            paramGroups.add(registerGroupBean);
                            registerModuleBean.setParamGroups(paramGroups);
                            requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(registerModuleBean, Boolean.valueOf(false));
                            response = ClientHolder.getInstance().sendSyncRequest(requestString);
                            if (response != null && response.length() > 0) {
                                JSONArray responseArray = JSONUtil.parseArray((String)response);
                                if (responseArray.size() < 1) {
                                    item.setText(1, "Failed");
                                } else {
                                    int i = 0;
                                    while (i < responseArray.size()) {
                                        String message;
                                        JSONObject responseJson = (JSONObject)responseArray.get(i);
                                        String key = responseJson.getStr((Object)"key");
                                        assert (key.equals("value"));
                                        JSONObject valueObject = (JSONObject)JSONUtil.parse((Object)responseJson.getStr((Object)"value"));
                                        String currentValStr = valueObject.getStr((Object)"current");
                                        if (currentValStr != null) {
                                            if (!this.standard(HexUtil.hexToLong((String)valueObject.getStr((Object)"current").substring(2))).equals(item.getText(1))) {
                                                item.setText(1, this.standard(HexUtil.hexToLong((String)valueObject.getStr((Object)"current").substring(2))));
                                                diffValues.add(item.getText(0));
                                            }
                                        } else {
                                            item.setText(1, "Failed");
                                        }
                                        if (!StrUtil.isEmpty((CharSequence)(message = responseJson.getStr((Object)"message")))) {
                                            ConsoleLogger.printErrorMsg((String)("WriteRegister Failed: {" + key + " : " + message + "}"));
                                        } else {
                                            item.setText(1, "Failed");
                                        }
                                        ++i;
                                    }
                                }
                            } else {
                                item.setText(1, "Failed");
                            }
                        }
                        this.updateTableSelection();
                    }
                }
            }
            ++n2;
        }
        if (diffValues.size() > 0) {
            JOptionPane.showMessageDialog(null, "Warning: The actual values are different from values expected to be written for: " + diffValues);
        }
    }

    private void readRegister() {
        TableItem[] tableItemArray = this.registerTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String addressVal = item.getText(0).substring(2);
            ParamBean addressParamBean = new ParamBean("address", "text");
            addressParamBean.setCategory("RGT");
            addressParamBean.getValue().setCurrentValue((Object)addressVal);
            ParamBean typeParamBean = new ParamBean("type", "option");
            typeParamBean.setCategory("RGT");
            int type = item.getText(2).equals("ISP") ? 0 : 1;
            typeParamBean.getValue().setCurrentValue((Object)type);
            ParamBean valueParamBean = new ParamBean("value", "text");
            valueParamBean.setCategory("RGT");
            List<ParamBean> params = Arrays.asList(addressParamBean, typeParamBean);
            ParamGroupBean registerGroupBean = new ParamGroupBean("Register");
            registerGroupBean.setParams(params);
            ArrayList<ParamGroupBean> paramGroups = new ArrayList<ParamGroupBean>();
            paramGroups.add(registerGroupBean);
            ModuleBean registerModuleBean = new ModuleBean("Register");
            registerModuleBean.setParamGroups(paramGroups);
            if (DialogSettingManager.getInstance().getIsConnected().booleanValue()) {
                String requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(registerModuleBean, Boolean.valueOf(true));
                String response = ClientHolder.getInstance().sendSyncRequest(requestString);
                if (response != null && response.length() > 0) {
                    params = Arrays.asList(valueParamBean);
                    registerGroupBean = new ParamGroupBean("Register");
                    registerGroupBean.setParams(params);
                    paramGroups.clear();
                    paramGroups.add(registerGroupBean);
                    registerModuleBean = new ModuleBean("Register");
                    registerModuleBean.setParamGroups(paramGroups);
                    requestString = ModuleDataCenter.getInstance().generateModuleRequestJsonString(registerModuleBean, Boolean.valueOf(false));
                    response = ClientHolder.getInstance().sendSyncRequest(requestString);
                    if (response != null) {
                        JSONArray responseArray = JSONUtil.parseArray((String)response);
                        if (responseArray.size() < 1) {
                            item.setText(1, "Failed");
                        } else {
                            int i = 0;
                            while (i < responseArray.size()) {
                                JSONObject responseJson = (JSONObject)responseArray.get(i);
                                String key = responseJson.getStr((Object)"key");
                                assert (key.equals("value"));
                                JSONObject valueObject = (JSONObject)JSONUtil.parse((Object)responseJson.getStr((Object)"value"));
                                item.setText(1, valueObject.getStr((Object)"current") == null || valueObject.getStr((Object)"current").isEmpty() ? "Failed" : this.standard(HexUtil.hexToLong((String)valueObject.getStr((Object)"current").substring(2))));
                                String message = responseJson.getStr((Object)"message");
                                if (!StrUtil.isEmpty((CharSequence)message)) {
                                    ConsoleLogger.printErrorMsg((String)("ReadRegister Failed: {" + key + " : " + message + "}"));
                                } else {
                                    item.setText(1, "Failed");
                                }
                                ++i;
                            }
                        }
                    } else {
                        item.setText(1, "Failed");
                    }
                } else {
                    item.setText(1, "Failed");
                }
                this.updateTableSelection();
            }
            ++n2;
        }
    }

    private String standard(long value) {
        String result = String.valueOf(HexUtil.toHex((long)value));
        result = "0x" + result;
        assert (HexUtil.isHexNumber((String)result));
        if (result.length() >= 10) {
            result = result.substring(result.length() - 8, result.length());
        } else {
            String temp = "";
            int i = 0;
            while (i < 10 - result.length()) {
                temp = String.valueOf(temp) + "0";
                ++i;
            }
            result = String.valueOf(temp) + result.substring(2);
        }
        return "0x" + result.toUpperCase();
    }

    private void updateEnableState() {
        this.countLabel.setEnabled(this.sequenceBtn.getSelection());
        this.countText.setEnabled(this.sequenceBtn.getSelection());
        this.valueLabel.setEnabled(!this.sequenceBtn.getSelection());
        this.valueText.setEnabled(!this.sequenceBtn.getSelection());
        for (Label label : this.bitLabels) {
            label.setEnabled(!this.sequenceBtn.getSelection());
        }
        for (Button button : this.checkBoxes) {
            button.setEnabled(!this.sequenceBtn.getSelection());
        }
    }
}

