/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DualImageViewDialog
extends Dialog {
    private Canvas canvas1;
    private Image image1;
    private Canvas canvas2;
    private Image image2;
    private int startX = 0;
    private int startY = 0;
    private int endX = 0;
    private int endY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int dx = 0;
    private int dy = 0;
    private double rate = 1.0;
    private Button zoomInBtn;
    private Button zoomOutBtn;

    public DualImageViewDialog(Shell parentShell) {
        super(parentShell);
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Composite image1Composite = new Composite(composite, 0);
        image1Composite.setLayout((Layout)new RowLayout(512));
        Composite canvas1Compsite = new Composite(image1Composite, 0);
        canvas1Compsite.setLayout((Layout)new RowLayout());
        this.canvas1 = new Canvas(canvas1Compsite, 2048);
        this.canvas1.setLayoutData((Object)new RowData(400, 300));
        this.canvas1.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (DualImageViewDialog.this.image1 != null) {
                    int height = (int)((double)event.height * DualImageViewDialog.this.rate);
                    int width = (int)((double)event.width * DualImageViewDialog.this.rate);
                    event.gc.drawImage(DualImageViewDialog.this.image1, 0, 0, ((DualImageViewDialog)DualImageViewDialog.this).image1.getBounds().width, ((DualImageViewDialog)DualImageViewDialog.this).image1.getBounds().height, DualImageViewDialog.this.dx, DualImageViewDialog.this.dy, width, height);
                }
            }
        });
        this.canvas1.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                DualImageViewDialog.this.endX = e.x;
                DualImageViewDialog.this.endY = e.y;
                DualImageViewDialog.this.offsetX = DualImageViewDialog.this.endX - DualImageViewDialog.this.startX;
                DualImageViewDialog.this.offsetY = DualImageViewDialog.this.endY - DualImageViewDialog.this.startY;
                DualImageViewDialog dualImageViewDialog = DualImageViewDialog.this;
                dualImageViewDialog.dx = dualImageViewDialog.dx + (int)((double)DualImageViewDialog.this.offsetX * DualImageViewDialog.this.rate);
                DualImageViewDialog dualImageViewDialog2 = DualImageViewDialog.this;
                dualImageViewDialog2.dy = dualImageViewDialog2.dy + (int)((double)DualImageViewDialog.this.offsetY * DualImageViewDialog.this.rate);
                DualImageViewDialog.this.canvas1.redraw();
                DualImageViewDialog.this.canvas2.redraw();
                DualImageViewDialog.this.offsetX = 0;
                DualImageViewDialog.this.offsetY = 0;
            }

            public void mouseDown(MouseEvent e) {
                DualImageViewDialog.this.startX = e.x;
                DualImageViewDialog.this.startY = e.y;
            }
        });
        Composite btn1Composite = new Composite(image1Composite, 0);
        btn1Composite.setLayout((Layout)new RowLayout(256));
        Button select1Btn = new Button(btn1Composite, 0);
        select1Btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                String[] extensions = new String[]{".jpg", ".bmp", ".*"};
                fileDialog.setFilterNames(extensions);
                fileDialog.open();
                if (fileDialog.getFilterPath() != null && !fileDialog.getFilterPath().equals("")) {
                    String imagePath = String.valueOf(fileDialog.getFilterPath()) + "\\" + fileDialog.getFileName();
                    DualImageViewDialog.this.image1 = new Image((Device)Display.getDefault(), imagePath);
                    if (DualImageViewDialog.this.image1 != null) {
                        DualImageViewDialog.this.canvas1.redraw();
                    }
                }
            }
        });
        select1Btn.setText("Select File");
        Button viewParam1Btn = new Button(btn1Composite, 0);
        viewParam1Btn.setText("View Param");
        Button save1Btn = new Button(btn1Composite, 0);
        save1Btn.setText("Save");
        Button apply1Btn = new Button(btn1Composite, 0);
        apply1Btn.setText("Apply");
        Composite zoomComposite = new Composite(composite, 0);
        zoomComposite.setLayout((Layout)new RowLayout(512));
        this.zoomInBtn = new Button(zoomComposite, 0);
        this.zoomInBtn.setText("Zoom In");
        this.zoomInBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DualImageViewDialog.this.zoomImageOperation(1);
            }
        });
        this.zoomOutBtn = new Button(zoomComposite, 0);
        this.zoomOutBtn.setText("Zoom Out");
        this.zoomOutBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DualImageViewDialog.this.zoomImageOperation(-1);
            }
        });
        Button restoreBtn = new Button(zoomComposite, 0);
        restoreBtn.setText("Restore");
        restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DualImageViewDialog.this.zoomImageOperation(0);
            }
        });
        Composite image2Composite = new Composite(composite, 0);
        image2Composite.setLayout((Layout)new RowLayout(512));
        Composite canvas2Composite = new Composite(image2Composite, 0);
        canvas2Composite.setLayout((Layout)new RowLayout());
        this.canvas2 = new Canvas(canvas2Composite, 2048);
        this.canvas2.setLayoutData((Object)new RowData(400, 300));
        this.canvas2.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (DualImageViewDialog.this.image2 != null) {
                    int height = (int)((double)event.height * DualImageViewDialog.this.rate);
                    int width = (int)((double)event.width * DualImageViewDialog.this.rate);
                    event.gc.drawImage(DualImageViewDialog.this.image2, 0, 0, ((DualImageViewDialog)DualImageViewDialog.this).image2.getBounds().width, ((DualImageViewDialog)DualImageViewDialog.this).image2.getBounds().height, DualImageViewDialog.this.dx, DualImageViewDialog.this.dy, width, height);
                }
            }
        });
        Composite btn2Composite = new Composite(image2Composite, 0);
        btn2Composite.setLayout((Layout)new RowLayout(256));
        Button select2Btn = new Button(btn2Composite, 0);
        select2Btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                String[] extensions = new String[]{".jpg", ".bmp", ".*"};
                fileDialog.setFilterNames(extensions);
                fileDialog.open();
                if (fileDialog.getFilterPath() != null && !fileDialog.getFilterPath().equals("")) {
                    String imagePath = String.valueOf(fileDialog.getFilterPath()) + "\\" + fileDialog.getFileName();
                    DualImageViewDialog.this.image2 = new Image((Device)Display.getDefault(), imagePath);
                    if (DualImageViewDialog.this.image2 != null) {
                        DualImageViewDialog.this.canvas2.redraw();
                    }
                }
            }
        });
        select2Btn.setText("Select File");
        Button viewParam2Btn = new Button(btn2Composite, 0);
        viewParam2Btn.setText("View Param");
        Button save2Btn = new Button(btn2Composite, 0);
        save2Btn.setText("Save");
        Button apply2Btn = new Button(btn2Composite, 0);
        apply2Btn.setText("Apply");
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Dual Image View");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridData data = new GridData(0, 0);
        parent.setLayoutData((Object)data);
        super.createButtonsForButtonBar(parent);
    }

    protected Point getInitialSize() {
        return new Point(950, 400);
    }

    private void zoomImageOperation(int i) {
        if (i == 0) {
            this.rate = 1.0;
            this.zoomOutBtn.setEnabled(true);
            this.zoomInBtn.setEnabled(true);
            this.dx = 0;
            this.dy = 0;
        } else if (i > 0) {
            this.rate += 0.1;
            if (this.rate > 2.0) {
                this.rate = 2.0;
                this.zoomInBtn.setEnabled(false);
            }
            this.zoomOutBtn.setEnabled(true);
        } else if (i < 0) {
            this.rate -= 0.1;
            if (this.rate < 0.1) {
                this.rate = 0.1;
                this.zoomOutBtn.setEnabled(false);
            }
            this.zoomInBtn.setEnabled(true);
        }
        this.canvas1.redraw();
        this.canvas2.redraw();
    }
}

