/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DrawRoiDialog
extends TitleAreaDialog {
    private ModuleBean currentModuleBean;
    private ParamBean paramBean;
    private Table table;
    private List<Composite> buttonPanes = new ArrayList<Composite>();
    private Canvas canvas;
    private Image image;
    private Cursor crosshairCursor = new Cursor(null, 2);
    private int startX = 0;
    private int startY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    boolean mouseDown = false;
    int roiNums = 25;
    LinkedList<RoiInfo> roiInfos = new LinkedList();

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private String standardString(String str) {
        BigDecimal value = new BigDecimal(str).setScale(3, 1);
        return value.toString();
    }

    public DrawRoiDialog(Shell parentShell, ModuleBean currentModuleBean, ParamBean paramBean, Image image) {
        super(parentShell);
        this.currentModuleBean = currentModuleBean;
        this.paramBean = paramBean;
        this.image = image;
        JSONArray roiInfosArray = (JSONArray)paramBean.getValue().getValue();
        int row = 0;
        while (row < roiInfosArray.size()) {
            JSONArray rowObject = (JSONArray)roiInfosArray.get(row);
            RoiInfo roiInfo = new RoiInfo(rowObject.getInt((Object)0), rowObject.getInt((Object)1), rowObject.getInt((Object)2), rowObject.getInt((Object)3), rowObject.getFloat((Object)4).floatValue());
            this.roiInfos.add(roiInfo);
            ++row;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select Rois");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select Rois");
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(4, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.canvas = new Canvas(composite, 0x20000800);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        int imageWidth = PreviewDialog.getWidth();
        int imageHeight = PreviewDialog.getHeight();
        this.table = new Table(composite, 67588);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumn indexColumn = new TableColumn(this.table, 0x1000000);
        indexColumn.setText("Num");
        TableColumn xColumn = new TableColumn(this.table, 0x1000000);
        xColumn.setText("X");
        TableColumn yColumn = new TableColumn(this.table, 0x1000000);
        yColumn.setText("Y");
        TableColumn widthColumn = new TableColumn(this.table, 0x1000000);
        widthColumn.setText("Width");
        TableColumn heightColumn = new TableColumn(this.table, 0x1000000);
        heightColumn.setText("Height");
        TableColumn weightColumn = new TableColumn(this.table, 0x1000000);
        weightColumn.setText("Weight");
        TableColumn deleteColumn = new TableColumn(this.table, 0x1000000);
        deleteColumn.setText("Operation");
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int tableWidth = ((DrawRoiDialog)DrawRoiDialog.this).table.getClientArea().width;
                TableColumn[] tableColumnArray = DrawRoiDialog.this.table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    tableColumn.setWidth(tableWidth / DrawRoiDialog.this.table.getColumnCount());
                    ++n2;
                }
            }
        });
        TableEditor editEditor = new TableEditor(this.table);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                final int selectIndex = DrawRoiDialog.this.table.getSelectionIndex();
                if (selectIndex < 0) {
                    return;
                }
                final TableItem item = DrawRoiDialog.this.table.getItem(selectIndex);
                Point point = new Point(e.x, e.y);
                int clickedCell = 0;
                int i = 0;
                while (i < DrawRoiDialog.this.table.getColumnCount()) {
                    if (item.getBounds(i).contains(point)) {
                        clickedCell = i;
                        break;
                    }
                    ++i;
                }
                if (clickedCell != 5) {
                    return;
                }
                final int selectCol = clickedCell;
                final String weightString = item.getText(selectCol);
                Control editor = editEditor.getEditor();
                if (editor != null) {
                    editor.dispose();
                }
                final Text text = new Text((Composite)DrawRoiDialog.this.table, 0);
                text.setText(weightString);
                editEditor.grabHorizontal = true;
                editEditor.minimumHeight = text.getSize().y;
                editEditor.minimumWidth = text.getSize().x;
                text.selectAll();
                text.setFocus();
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        String newValue = text.getText();
                        if (!DrawRoiDialog.this.inputCheck(newValue)) {
                            text.setText(weightString);
                            text.dispose();
                        }
                        newValue = DrawRoiDialog.this.standardString(newValue);
                        (this).DrawRoiDialog.this.roiInfos.get((int)selectIndex).weight = Float.parseFloat(newValue);
                        item.setText(selectCol, newValue);
                        text.dispose();
                    }
                });
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\r' || e.character == '\t') {
                            String newValue = text.getText();
                            if (!DrawRoiDialog.this.inputCheck(newValue)) {
                                text.setText(weightString);
                                text.dispose();
                            }
                            newValue = DrawRoiDialog.this.standardString(newValue);
                            item.setText(selectCol, newValue);
                            (this).DrawRoiDialog.this.roiInfos.get((int)selectIndex).weight = Float.parseFloat(newValue);
                            text.dispose();
                        }
                        if (e.character == '\u001b') {
                            text.dispose();
                        }
                    }
                });
                editEditor.setEditor((Control)text, item, selectCol);
            }
        });
        if (this.image != null) {
            this.canvas.setCursor(this.crosshairCursor);
            this.canvas.redraw();
        }
        this.updateTable();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (DrawRoiDialog.this.image != null) {
                    Font font = new Font((Device)Display.getCurrent(), "Courier New", 15, 1);
                    event.gc.setFont(font);
                    event.gc.setLineWidth(3);
                    event.gc.fillRectangle(0, 0, ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width, ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height);
                    event.gc.setForeground(Display.getCurrent().getSystemColor(3));
                    event.gc.drawImage(DrawRoiDialog.this.image, 0, 0, ((DrawRoiDialog)DrawRoiDialog.this).image.getBounds().width, ((DrawRoiDialog)DrawRoiDialog.this).image.getBounds().height, 0, 0, ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width, ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height);
                    if (DrawRoiDialog.this.mouseDown) {
                        event.gc.drawString(String.valueOf(DrawRoiDialog.this.roiInfos.size() + 1), DrawRoiDialog.this.startX * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width / imageWidth, DrawRoiDialog.this.startY * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height / imageHeight);
                        event.gc.drawRectangle(DrawRoiDialog.this.startX * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width / imageWidth, DrawRoiDialog.this.startY * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height / imageHeight, DrawRoiDialog.this.offsetX * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width / imageWidth, DrawRoiDialog.this.offsetY * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height / imageHeight);
                    }
                    int num = 0;
                    for (RoiInfo roiInfo : DrawRoiDialog.this.roiInfos) {
                        event.gc.drawRectangle(roiInfo.x * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width / imageWidth, roiInfo.y * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height / imageHeight, roiInfo.w * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width / imageWidth, roiInfo.h * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height / imageHeight);
                        event.gc.drawString(String.valueOf(++num), roiInfo.x * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width / imageWidth, roiInfo.y * ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height / imageHeight);
                    }
                }
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (DrawRoiDialog.this.image != null) {
                    DrawRoiDialog.this.mouseDown = false;
                    if (DrawRoiDialog.this.offsetX <= 20 || DrawRoiDialog.this.offsetY <= 20) {
                        return;
                    }
                    DrawRoiDialog.this.roiInfos.add(new RoiInfo(DrawRoiDialog.this.startX, DrawRoiDialog.this.startY, DrawRoiDialog.this.offsetX, DrawRoiDialog.this.offsetY, 1.0f));
                    DrawRoiDialog.this.updateTable();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (DrawRoiDialog.this.image != null) {
                    if (DrawRoiDialog.this.roiInfos.size() >= DrawRoiDialog.this.roiNums) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"warning", (String)("You have added " + DrawRoiDialog.this.roiNums + " regions of image"));
                        return;
                    }
                    DrawRoiDialog.this.mouseDown = true;
                    DrawRoiDialog.this.startX = e.x * imageWidth / ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width;
                    DrawRoiDialog.this.startY = e.y * imageHeight / ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height;
                    DrawRoiDialog.this.offsetX = 0;
                    DrawRoiDialog.this.offsetY = 0;
                }
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (DrawRoiDialog.this.mouseDown) {
                    if (e.x >= ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().x + ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width) {
                        e.x = ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().x + ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width;
                    } else if (e.x <= ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().x) {
                        e.x = ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().x;
                    }
                    if (e.y >= ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().y + ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height) {
                        e.y = ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().y + ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height;
                    } else if (e.y <= ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().y) {
                        e.y = ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().y;
                    }
                    DrawRoiDialog.this.offsetX = e.x * imageWidth / ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().width - DrawRoiDialog.this.startX;
                    DrawRoiDialog.this.offsetY = e.y * imageHeight / ((DrawRoiDialog)DrawRoiDialog.this).canvas.getClientArea().height - DrawRoiDialog.this.startY;
                    DrawRoiDialog.this.canvas.redraw();
                }
            }
        });
        return composite;
    }

    private void updateTable() {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        for (Composite buttonpane : this.buttonPanes) {
            buttonpane.dispose();
        }
        this.buttonPanes.clear();
        int i = 0;
        while (i < this.roiInfos.size()) {
            TableItem item = new TableItem(this.table, 0x1000000);
            item.setText(0, String.valueOf(i + 1));
            item.setBackground(0, new Color((Device)item.getDisplay(), 200, 200, 200));
            item.setText(1, String.valueOf(this.roiInfos.get((int)i).x));
            item.setText(2, String.valueOf(this.roiInfos.get((int)i).y));
            item.setText(3, String.valueOf(this.roiInfos.get((int)i).w));
            item.setText(4, String.valueOf(this.roiInfos.get((int)i).h));
            item.setText(5, String.valueOf(this.roiInfos.get((int)i).weight));
            TableEditor editor = new TableEditor(this.table);
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            Composite buttonPane = new Composite((Composite)this.table, 0);
            buttonPane.setLayout((Layout)new FillLayout());
            Button deleteBtn = new Button(buttonPane, 0);
            deleteBtn.setText("Del");
            deleteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DrawRoiDialog.this.table.setSelection(item);
                    DrawRoiDialog.this.roiInfos.remove(DrawRoiDialog.this.table.getSelectionIndex());
                    DrawRoiDialog.this.updateTable();
                    DrawRoiDialog.this.canvas.redraw();
                }
            });
            this.buttonPanes.add(buttonPane);
            editor.setEditor((Control)buttonPane, item, 6);
            editor.layout();
            ++i;
        }
    }

    protected void okPressed() {
        BigDecimal allWeight = new BigDecimal(0).setScale(3, 1);
        JSONArray roiInfosArray = new JSONArray();
        int i = 0;
        while (i < this.roiInfos.size()) {
            RoiInfo roiInfo = this.roiInfos.get(i);
            JSONArray rowArray = new JSONArray();
            rowArray.add((Object)roiInfo.x);
            rowArray.add((Object)roiInfo.y);
            rowArray.add((Object)roiInfo.w);
            rowArray.add((Object)roiInfo.h);
            rowArray.add((Object)Float.valueOf(roiInfo.weight));
            allWeight = allWeight.add(new BigDecimal(roiInfo.weight).setScale(3, 1));
            roiInfosArray.add((Object)rowArray);
            ++i;
        }
        if (allWeight.compareTo(new BigDecimal(1).setScale(3, 1)) == 1) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"warning", (String)"The sum of all ROIs Weight must be equal to 1 !");
            return;
        }
        this.paramBean.getValue().setCurrentValue((Object)roiInfosArray);
        if (this.paramBean.getValue().getRelateLabel() != null) {
            ParamBean numBean = this.currentModuleBean.findParamBeanByKey(this.paramBean.getValue().getRelateLabel());
            assert (numBean != null);
            numBean.getValue().setCurrentValue((Object)this.roiInfos.size());
            EventManager.getInstance().notifyEvent("EVENT_REFRESH_UI", null);
        }
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(1500, 800);
    }

    private class RoiInfo {
        int x;
        int y;
        int w;
        int h;
        float weight;

        public RoiInfo(int x, int y, int w, int h, float weight) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.weight = weight;
        }
    }
}

