/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import cn.hutool.core.util.StrUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.util.ConsoleLogger;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CaptureDialog
extends TitleAreaDialog {
    private Text pathInput;
    private Scale snapNumScale;
    private String lastSnapNumInput;
    private boolean isOutputAsOneFile;
    private DialogSettingManager dialogSettingManager = DialogSettingManager.getInstance();

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    public CaptureDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(208);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Capture");
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        return ret;
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle("Capture");
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite captureComposite = new Composite(composite, 0);
        captureComposite.setLayout((Layout)new GridLayout(6, true));
        captureComposite.setLayoutData((Object)new GridData(1808));
        Label outputLbale = new Label(captureComposite, 0);
        outputLbale.setText("Output as One File");
        outputLbale.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        Button outputButton = new Button(captureComposite, 32);
        outputButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 4, 1));
        this.isOutputAsOneFile = outputButton.getSelection();
        Label snapNumLabel = new Label(captureComposite, 0);
        snapNumLabel.setText("Snapshot Num");
        snapNumLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        Text snapNumInput = new Text(captureComposite, 0);
        snapNumInput.setBackground(Display.getCurrent().getSystemColor(1));
        snapNumInput.setText("1");
        snapNumInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.snapNumScale = new Scale(captureComposite, 0);
        this.snapNumScale.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        this.snapNumScale.setMaximum(10);
        this.snapNumScale.setMinimum(1);
        this.snapNumScale.setSelection(1);
        Label pathLabel = new Label(captureComposite, 0);
        pathLabel.setText("Save Path");
        pathLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        this.pathInput = new Text(captureComposite, 0);
        this.pathInput.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        String path = DialogSettingManager.getInstance().getCaptureSavePath();
        if (path != null) {
            this.pathInput.setText(path);
        }
        this.pathInput.setEditable(false);
        this.pathInput.setBackground(new Color(null, 255, 255, 255));
        Button browsePathBtn = new Button(captureComposite, 0);
        browsePathBtn.setText("Browse");
        browsePathBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        browsePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dialog.setText("Browse Save Path");
                String path = dialog.open();
                if (path != null) {
                    CaptureDialog.this.pathInput.setText(path);
                }
            }
        });
        ModuleBean outputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Output");
        if (outputModuleBean == null) {
            ConsoleLogger.printWarningMsg((String)"Please select a project");
            return null;
        }
        outputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (outputButton.getSelection()) {
                    CaptureDialog.this.isOutputAsOneFile = true;
                } else {
                    CaptureDialog.this.isOutputAsOneFile = false;
                }
            }
        });
        snapNumInput.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = snapNumInput.getText();
                if (!CaptureDialog.this.inputCheck(valueStr)) {
                    snapNumInput.setText(CaptureDialog.this.lastSnapNumInput);
                    return;
                }
                int num = Integer.parseInt(valueStr);
                if (num <= 1) {
                    num = 1;
                } else if (num >= 10) {
                    num = 10;
                }
                snapNumInput.setText(String.valueOf(num));
                CaptureDialog.this.lastSnapNumInput = snapNumInput.getText();
                CaptureDialog.this.snapNumScale.setSelection(num);
            }
        });
        snapNumInput.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    snapNumInput.notifyListeners(27, new Event());
                }
            }
        });
        this.snapNumScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String str = String.valueOf(CaptureDialog.this.snapNumScale.getSelection());
                snapNumInput.setText(str);
                snapNumInput.notifyListeners(27, new Event());
            }
        });
        return composite;
    }

    protected void okPressed() {
        DialogSettingManager.getInstance().setCaptureSavePath(this.pathInput.getText());
        DialogSettingManager.getInstance().saveCaptureConfig();
        if (this.pathInput.getText().isEmpty()) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Please select save path.");
            return;
        }
        if (StrUtil.isEmpty((CharSequence)PreviewDialog.getFormat())) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Please start stream first.");
            return;
        }
        if (!this.dialogSettingManager.getIsAutoRead().booleanValue()) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"todo");
            return;
        }
        Display display = Display.getCurrent();
        Shell shell = new Shell(display, 65632);
        shell.setText("Capture");
        shell.setSize(400, 200);
        shell.setLayout((Layout)new GridLayout(3, true));
        Label label = new Label((Composite)shell, 0);
        label.setText("Waiting for capture image......");
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 3, 1));
        shell.open();
        String path = this.pathInput.getText();
        String format = PreviewDialog.getFormat();
        String pathType = PreviewDialog.getOutputPath();
        String bayerPattern = PreviewDialog.getOutputBayerPattern();
        int width = PreviewDialog.getWidth();
        int height = PreviewDialog.getHeight();
        String formatMode = PreviewDialog.getformatMode();
        int outputBits = PreviewDialog.getOutputBits();
        int snapNum = this.snapNumScale.getSelection();
        new Thread(() -> {
            List images;
            try {
                images = ModuleDataCenter.getInstance().captureRequest(this.isOutputAsOneFile, path, format, pathType, bayerPattern, width, height, formatMode, outputBits, snapNum, this.setRequestParams(snapNum), this.queryRequestParams());
                if (images == null) {
                    shell.close();
                    return;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                shell.close();
                return;
            }
            int i = 0;
            while (i < images.size()) {
                block29: {
                    block30: {
                        block28: {
                            if (images.get(i) != null) break block28;
                            ConsoleLogger.printWarningMsg((String)("SnapShot " + String.valueOf(i) + ": No Image Data"));
                            break block29;
                        }
                        if (!((String)images.get(i)).endsWith(".yuv") || this.isOutputAsOneFile) break block30;
                        File temp = new File((String)images.get(i));
                        ByteArrayOutputStream os = new ByteArrayOutputStream((int)temp.length());
                        BufferedInputStream in = null;
                        try {
                            in = new BufferedInputStream(new FileInputStream(temp));
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        byte[] buffer = new byte[1024];
                        try {
                            while (in.read(buffer) > 0) {
                                os.write(buffer);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        byte[] yuvByte = os.toByteArray();
                        byte[] rgbByte = new byte[width * height * 3];
                        switch (format) {
                            case "YUV422 Semi-Planar": {
                                ImageFormatConverter.NV162RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                                break;
                            }
                            case "YUV422 Interleaved": {
                                ImageFormatConverter.YUV422I2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                                break;
                            }
                            case "YUV420 Semi-Planar": {
                                ImageFormatConverter.YUV420SP2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                                break;
                            }
                            case "YUV444 Planer": {
                                ImageFormatConverter.YUV444P2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                                break;
                            }
                            case "YUV444 Interleaved": {
                                ImageFormatConverter.YUV444I2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                                break;
                            }
                            default: {
                                ConsoleLogger.printWarningMsg((String)(String.valueOf(format) + "is not support format"));
                                shell.close();
                                return;
                            }
                        }
                        ImageData imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
                        imageData.data = rgbByte;
                        int imageIndex = i;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CaptureDialog.this.imageShow(imageData, (String)images.get(imageIndex));
                                shell.close();
                            }
                        });
                        break block29;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            shell.close();
                        }
                    });
                }
                ++i;
            }
        }).start();
        this.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Capture", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        parent.setLayoutData((Object)new GridData(128));
    }

    public List<ParamBean> setRequestParams(int snapNum) {
        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
        ModuleBean outputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Output");
        assert (outputModuleBean != null);
        ParamBean snapNumParamBean = outputModuleBean.findParamBeanByKey("snapshotNumber");
        assert (snapNumParamBean != null);
        snapNumParamBean.getValue().setCurrentValue((Object)snapNum);
        params.add(snapNumParamBean);
        return params;
    }

    public List<ParamBean> queryRequestParams() {
        ArrayList<ParamBean> params = new ArrayList<ParamBean>();
        ParamBean imageParamBean = new ParamBean("images", "file");
        imageParamBean.setCategory("OPT");
        params.add(imageParamBean);
        return params;
    }

    private void imageShow(ImageData imagedata, String fileName) {
        Display display = Display.getDefault();
        Shell shell = new Shell(17616);
        Image image = new Image((Device)display, imagedata);
        shell.setText(fileName);
        shell.setSize(640, 360);
        shell.setLayout((Layout)new FillLayout());
        Canvas cvs = new Canvas((Composite)shell, 0x20000000);
        cvs.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, shell.getBounds().width, shell.getBounds().height);
            }
        });
        shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                cvs.redraw();
            }

            public void controlResized(ControlEvent e) {
                cvs.redraw();
            }
        });
        shell.open();
        shell.layout();
    }
}

