/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.dialog;

import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.ui.core.DialogSettingManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BatchJobDialog
extends TitleAreaDialog {
    String[] options = new String[]{"RAW08 (*.pgm)", "RAW10 (*.pgm)", "RAW12 (*.pgm)", "RAW16 (*.pgm)", "RGB (*.ppm)", "YUV (*.yuv)"};
    private Text pathInput;
    private Text commentInput;
    private Combo combo;
    private Scale scale;
    private String comment;
    private String path;
    private String type;
    private int num;
    private String title;

    public BatchJobDialog(Shell parentShell, String text) {
        super(parentShell);
        this.title = text;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public String getComment() {
        return this.comment;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public Integer getNum() {
        return this.num;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("BatchJob Settings");
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        return ret;
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        Composite composite = new Composite(parent, 16);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite formatComposite = new Composite(composite, 0);
        GridLayout formayLayout = new GridLayout(2, false);
        formatComposite.setLayout((Layout)formayLayout);
        formatComposite.setLayoutData((Object)new GridData(1808));
        Label formatLabel = new Label(formatComposite, 0);
        formatLabel.setText("Image Type     ");
        this.combo = new Combo(formatComposite, 8);
        this.combo.setLayoutData((Object)new GridData(768));
        String[] stringArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            this.combo.add(option);
            ++n2;
        }
        this.combo.select(0);
        Composite pathComposite = new Composite(composite, 0);
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        pathComposite.setLayoutData((Object)new GridData(1808));
        Label pathLabel = new Label(pathComposite, 0);
        pathLabel.setText("Save Path         ");
        this.pathInput = new Text(pathComposite, 0);
        this.pathInput.setLayoutData((Object)new GridData(768));
        String path = DialogSettingManager.getInstance().getCaptureSavePath();
        if (path != null) {
            this.pathInput.setText(path);
        }
        this.pathInput.setEditable(false);
        this.pathInput.setBackground(new Color(null, 255, 255, 255));
        Button browsePathBtn = new Button(pathComposite, 0);
        browsePathBtn.setText("Browse");
        browsePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dialog.setText("Browse Save Path");
                String path = dialog.open();
                if (path != null) {
                    BatchJobDialog.this.pathInput.setText(path);
                }
            }
        });
        Composite snapComposite = new Composite(composite, 0);
        snapComposite.setLayout((Layout)new GridLayout(3, false));
        snapComposite.setLayoutData((Object)new GridData(1808));
        Label snapLabel = new Label(snapComposite, 0);
        snapLabel.setText("Snapshot Num");
        Text input = new Text(snapComposite, 0);
        input.setBackground(Display.getCurrent().getSystemColor(1));
        input.setText("1");
        input.setLayoutData((Object)new GridData(768));
        this.scale = new Scale(snapComposite, 0);
        this.scale.setLayoutData((Object)new GridData(768));
        this.scale.setMaximum(100);
        this.scale.setMinimum(1);
        this.scale.setSelection(1);
        input.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String valueStr = input.getText();
                BatchJobDialog.this.scale.setSelection(Integer.valueOf(valueStr).intValue());
                EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", null);
            }
        });
        this.scale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String str = String.valueOf(BatchJobDialog.this.scale.getSelection());
                input.setText(str);
                EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", null);
            }
        });
        Composite commentComposite = new Composite(composite, 0);
        commentComposite.setLayout((Layout)new GridLayout(4, true));
        commentComposite.setLayoutData((Object)new GridData(1808));
        Label commentLable = new Label(commentComposite, 0);
        commentLable.setText("Comment  ");
        GridData gridData6 = new GridData(16384, 0x1000000, true, true, 1, 1);
        commentLable.setLayoutData((Object)gridData6);
        this.commentInput = new Text(commentComposite, 0);
        GridData gridData7 = new GridData(4, 0x1000000, true, true, 3, 1);
        this.commentInput.setBackground(Display.getCurrent().getSystemColor(1));
        this.commentInput.setLayoutData((Object)gridData7);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.commentInput.setText("BatchJob " + String.valueOf(dateFormat.format(date)));
        this.commentInput.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (BatchJobDialog.this.commentInput.getText().isEmpty()) {
                    BatchJobDialog.this.commentInput.setText("BatchJob" + String.valueOf(dateFormat.format(date)));
                }
            }
        });
        return composite;
    }

    protected void okPressed() {
        this.path = this.pathInput.getText();
        this.num = this.scale.getSelection();
        this.comment = this.commentInput.getText();
        this.type = this.options[this.combo.getSelectionIndex()];
        if (this.path.isEmpty()) {
            Shell shell = new Shell();
            MessageBox mb = new MessageBox(shell, 0);
            mb.setText("Warning");
            mb.setMessage("Path cannot be empty");
            mb.open();
            return;
        }
        super.okPressed();
    }
}

