/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.chart;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.util.CubicSplineFitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.NoRepeatsPointsList;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SplineLineChart {
    private ParamBean oldParamBean;
    private ParamBean paramBean;
    private ModuleBean currentModuleBean;
    private double xRangeMin = 0.5;
    private double xRangeMax = 5.5;
    private double yRangeMin = 100000.0;
    private double yRangeMax = -100000.0;
    private TableEditor fTableEditor;
    protected Axis xAxis;
    protected Axis yAxis;
    IXYGraph xyGraph;
    private Table table;
    private List<BigDecimal> xArray = new ArrayList<BigDecimal>();
    private List<BigDecimal> yArray = new ArrayList<BigDecimal>();
    private Combo tableIndexcombo;
    private int controlPoints = 64;
    private Spinner ctrlPointsSpinner;
    private ControlPointDragger controlPointDragger;
    private DragableCurve dragableCurve1;
    private boolean editable = true;
    private boolean isAutoModule = true;
    private double[] splineXData;
    private double[] splineYData;

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private String standardString(String s, ParamBean paramBean) {
        BigDecimal value = new BigDecimal(s);
        if (value.compareTo(paramBean.getValue().getMin()) < 0) {
            value = paramBean.getValue().getMin();
        }
        if (value.compareTo(paramBean.getValue().getMax()) > 0) {
            value = paramBean.getValue().getMax();
        }
        return paramBean.getValue().getDecimals() == null ? value.setScale(0, 1).toString() : value.setScale((int)paramBean.getValue().getDecimals(), 1).toString();
    }

    public void show(Composite parent, ParamBean paramBean, JSONArray pointsPosArray, Composite right, List<Rectangle> bounds, ModuleBean currentModuleBean, boolean isAutoModule) {
        this.paramBean = paramBean;
        this.currentModuleBean = currentModuleBean;
        this.isAutoModule = isAutoModule;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(100, true));
        Canvas cvs = new Canvas(composite, 0);
        cvs.setLayoutData((Object)new GridData(4, 4, true, true, 100, 100));
        cvs.setEnabled(parent.getEnabled());
        LightweightSystem lws = new LightweightSystem(cvs);
        this.xyGraph = new XYGraph();
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph(this.xyGraph);
        this.xyGraph.setTitle(paramBean.getShowName());
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setEnabled(paramBean.getIsEnabled() != false && currentModuleBean.getModuleEnable() != false);
        lws.setContents((IFigure)toolbarArmedXYGraph);
        List<Object> pointsList = new ArrayList();
        if (pointsPosArray != null) {
            pointsList = this.updateAxis(pointsPosArray);
            this.dragableCurve1 = new DragableCurve(this.xyGraph, (double[])pointsList.get(0), (double[])pointsList.get(1));
            this.controlPointDragger = new ControlPointDragger();
            this.controlPointDragger.dragableCurves.add(this.dragableCurve1);
            this.xyGraph.getPlotArea().addMouseListener((MouseListener)this.controlPointDragger);
            this.xyGraph.getPlotArea().addMouseMotionListener((MouseMotionListener)this.controlPointDragger);
        } else {
            this.controlPoints = 0;
        }
        composite.pack();
        parent.pack();
        Rectangle curveBounds = composite.getBounds();
        bounds.add(curveBounds);
        right.setVisible(true);
        Composite tableComp = new Composite(right, 2048);
        this.createTable(tableComp, curveBounds);
        if (paramBean.getKey().equals("curve")) {
            Boolean state = (Boolean)currentModuleBean.findParamBeanByKey("isStandard").getValue().getCurrentValue();
            if (state == null) {
                return;
            }
            if (state.booleanValue()) {
                cvs.setEnabled(false);
                this.xyGraph.setEnabled(false);
                this.table.setEnabled(false);
                this.ctrlPointsSpinner.setEnabled(false);
            }
        }
    }

    private void createTable(Composite parent, Rectangle bounds) {
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        Composite controlPointComp = new Composite(parent, 2048);
        controlPointComp.setLayout((Layout)new GridLayout(3, false));
        controlPointComp.setLayoutData((Object)new GridData(4, 128, true, false));
        Label controlPointlabel = new Label(controlPointComp, 0);
        controlPointlabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        controlPointlabel.setText("Control Points");
        this.ctrlPointsSpinner = new Spinner(controlPointComp, 0);
        this.ctrlPointsSpinner.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.ctrlPointsSpinner.setSelection(64);
        this.ctrlPointsSpinner.setMaximum(64);
        this.ctrlPointsSpinner.setMinimum(3);
        this.ctrlPointsSpinner.setDigits(0);
        this.ctrlPointsSpinner.setEnabled(this.paramBean.getIsEnabled() != false && this.currentModuleBean.getModuleEnable() != false);
        this.ctrlPointsSpinner.addListener(27, e -> {
            int val = Integer.parseInt(this.ctrlPointsSpinner.getText());
            if (val < this.ctrlPointsSpinner.getMinimum()) {
                this.ctrlPointsSpinner.setSelection(this.ctrlPointsSpinner.getMinimum());
            } else if (val > this.ctrlPointsSpinner.getMaximum()) {
                this.ctrlPointsSpinner.setSelection(this.ctrlPointsSpinner.getMaximum());
            }
            this.ctrlPointsSpinner.notifyListeners(13, new Event());
        });
        this.ctrlPointsSpinner.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    SplineLineChart.this.ctrlPointsSpinner.notifyListeners(27, new Event());
                }
            }
        });
        this.ctrlPointsSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SplineLineChart.this.controlPoints = (int)((double)SplineLineChart.this.ctrlPointsSpinner.getSelection() / Math.pow(10.0, SplineLineChart.this.ctrlPointsSpinner.getDigits()));
                DragableCurve curve = SplineLineChart.this.controlPointDragger.getDragableCurves().get(0);
                curve.updateCurve();
                SplineLineChart.this.setPointsToTable();
            }
        });
        if (this.isAutoModule) {
            Composite tableIndexComp = new Composite(parent, 2048);
            tableIndexComp.setLayout((Layout)new GridLayout(3, false));
            tableIndexComp.setLayoutData((Object)new GridData(4, 128, true, false));
            Label tableIndexlabel = new Label(tableIndexComp, 0);
            tableIndexlabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            tableIndexlabel.setText("Table Control");
            this.tableIndexcombo = new Combo(tableIndexComp, 8);
            this.tableIndexcombo.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            ParamBean gainsBean = this.currentModuleBean.findParamBeanByKey(":gains");
            JSONArray gainsArray = (JSONArray)gainsBean.getValue().getValue();
            if (gainsArray == null) {
                gainsArray = new JSONArray();
            }
            for (Object obj : gainsArray) {
                this.tableIndexcombo.add(obj.toString());
            }
            this.tableIndexcombo.select(0);
            this.tableIndexcombo.select(0);
            this.tableIndexcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SplineLineChart.this.ctrlPointsSpinner.setSelection(64);
                    SplineLineChart.this.ctrlPointsSpinner.notifyListeners(13, new Event());
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)SplineLineChart.this.currentModuleBean, (String)SplineLineChart.this.paramBean.getCategory(), (String)SplineLineChart.this.paramBean.getKey(), (int)SplineLineChart.this.tableIndexcombo.getSelectionIndex());
                    SplineLineChart.this.updateAxis(pointsPosArray);
                    SplineLineChart.this.dragableCurve1.splineTrace.getCurveFitter().setSamples(SplineLineChart.this.splineXData, SplineLineChart.this.splineYData);
                    DragableCurve curve = SplineLineChart.this.controlPointDragger.getDragableCurves().get(0);
                    curve.updateCurve();
                    SplineLineChart.this.setPointsToTable();
                }
            });
        }
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setEnabled(this.paramBean.getIsEnabled() != false && this.currentModuleBean.getModuleEnable() != false);
        GridData tableGridData = new GridData(4, 4, true, true, 2, 1);
        this.table.setLayoutData((Object)tableGridData);
        this.fTableEditor = new TableEditor(this.table);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        int indexWidth = 70;
        int itemWidth = bounds.width - indexWidth - (this.table.getVerticalBar().getSize().x << 1) >> 1;
        TableColumn indexColumn = new TableColumn(this.table, 0x1000000);
        indexColumn.setText("Point");
        indexColumn.setWidth(indexWidth);
        TableColumn xColumn = new TableColumn(this.table, 0x1000000);
        xColumn.setText("X");
        xColumn.setWidth(itemWidth);
        TableColumn yColumn = new TableColumn(this.table, 0x1000000);
        yColumn.setText("Y");
        yColumn.setWidth(itemWidth);
        this.setPointsToTable();
        this.table.addMouseListener((org.eclipse.swt.events.MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
                if (!SplineLineChart.this.editable) {
                    return;
                }
                int selectIndex = SplineLineChart.this.table.getSelectionIndex();
                if (selectIndex < 0) {
                    return;
                }
                final TableItem item = SplineLineChart.this.table.getItem(selectIndex);
                org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(e.x, e.y);
                int clickedCell = 0;
                int i = 0;
                while (i < SplineLineChart.this.table.getColumnCount()) {
                    if (item.getBounds(i).contains(point)) {
                        clickedCell = i;
                        break;
                    }
                    ++i;
                }
                if (clickedCell < 2) {
                    return;
                }
                final int selectCol = clickedCell;
                final String itemString = item.getText(selectCol);
                Control oldEditor = SplineLineChart.this.fTableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                final Text text = new Text((Composite)SplineLineChart.this.table, 0);
                text.setText(itemString);
                ((SplineLineChart)SplineLineChart.this).fTableEditor.grabHorizontal = true;
                ((SplineLineChart)SplineLineChart.this).fTableEditor.minimumHeight = text.getSize().y;
                ((SplineLineChart)SplineLineChart.this).fTableEditor.minimumWidth = text.getSize().x;
                text.selectAll();
                text.setFocus();
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        String newValue = text.getText();
                        if (!SplineLineChart.this.inputCheck(newValue)) {
                            text.setText(itemString);
                            text.dispose();
                            return;
                        }
                        newValue = SplineLineChart.this.standardString(newValue, SplineLineChart.this.paramBean);
                        item.setText(selectCol, newValue);
                        int selectRow = SplineLineChart.this.table.getSelectionIndex();
                        text.dispose();
                        if (selectCol == 2 && itemString.compareTo(newValue) != 0) {
                            SplineLineChart.this.handleTableYItemChanged(selectRow, selectCol, newValue);
                        }
                    }
                });
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\r' || e.character == '\t') {
                            String newValue = text.getText();
                            if (!SplineLineChart.this.inputCheck(newValue)) {
                                text.setText(itemString);
                                text.dispose();
                                return;
                            }
                            newValue = SplineLineChart.this.standardString(newValue, SplineLineChart.this.paramBean);
                            item.setText(selectCol, newValue);
                            int selectRow = SplineLineChart.this.table.getSelectionIndex();
                            text.dispose();
                            if (selectCol == 2 && itemString.compareTo(newValue) != 0) {
                                SplineLineChart.this.handleTableYItemChanged(selectRow, selectCol, newValue);
                            }
                        }
                        if (e.character == '\u001b') {
                            text.dispose();
                        }
                    }
                });
                SplineLineChart.this.fTableEditor.setEditor((Control)text, item, selectCol);
            }
        });
    }

    private List<double[]> updateAxis(JSONArray pointsPosArray) {
        this.xArray = new ArrayList<BigDecimal>();
        this.yArray = new ArrayList<BigDecimal>();
        pointsPosArray.stream().forEach(e1 -> {
            assert (e1 instanceof JSONArray);
            JSONArray posArray = (JSONArray)e1;
            Object x = posArray.get(0);
            Object y = posArray.get(1);
            if (x instanceof BigDecimal) {
                this.xArray.add((BigDecimal)x);
            } else if (x instanceof Integer) {
                this.xArray.add(new BigDecimal((Integer)x));
            }
            if (y instanceof BigDecimal) {
                this.yArray.add((BigDecimal)y);
            } else if (y instanceof Integer) {
                this.yArray.add(new BigDecimal((Integer)y));
            }
        });
        this.splineXData = this.xArray.stream().mapToDouble(e2 -> Double.parseDouble(String.valueOf(e2))).toArray();
        this.xRangeMin = this.splineXData[0];
        this.xRangeMax = this.splineXData[this.splineXData.length - 1];
        this.splineYData = this.yArray.stream().mapToDouble(e3 -> Double.parseDouble(String.valueOf(e3))).toArray();
        this.yRangeMax = this.paramBean.getValue().getMax().doubleValue();
        this.yRangeMin = this.paramBean.getValue().getMin().doubleValue();
        Double rangeDiff = this.yRangeMax - this.yRangeMin;
        if (rangeDiff < 20.0) {
            this.yRangeMax = Math.round(this.yRangeMax + (20.0 - rangeDiff) / 2.0);
            this.yRangeMin = Math.round(this.yRangeMin - (20.0 - rangeDiff) / 2.0);
        }
        this.xAxis = this.xyGraph.getPrimaryXAxis();
        this.yAxis = this.xyGraph.getPrimaryYAxis();
        this.xAxis.setRange(this.xRangeMin, this.xRangeMax);
        this.yAxis.setRange(this.yRangeMin, this.yRangeMax);
        ArrayList<double[]> pointsList = new ArrayList<double[]>();
        pointsList.add(this.splineXData);
        pointsList.add(this.splineYData);
        return pointsList;
    }

    public void handleTableYItemChanged(int row, int col, String newValue) {
        DragableCurve curve = this.controlPointDragger.getDragableCurves().get(0);
        curve.currentControlPointIndex = row;
        curve.updateY(Double.parseDouble(newValue));
        this.setTableUpdate();
    }

    public void setTableUpdate() {
        this.oldParamBean = this.paramBean.clone();
        this.paramBean.getValue().setCurrentValue((Object)this.getCurveJsonArray(this.paramBean.getType()));
        ParamBean newParamBean = this.paramBean.clone();
        EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)this.oldParamBean, (Object)newParamBean);
    }

    public int getColumnIndex(Table table, TableColumn column) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getTableItemText(Table table, TableItem item) {
        int count = table.getColumnCount();
        String[] strs = new String[count];
        int i = 0;
        while (i < count) {
            strs[i] = item.getText(i);
            ++i;
        }
        return strs;
    }

    public void setPointsToTable() {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        int i = 0;
        while (i < this.controlPoints) {
            TableItem item = new TableItem(this.table, 0x1000000);
            item.setText(0, String.valueOf(i));
            item.setBackground(0, new Color((Device)item.getDisplay(), 200, 200, 200));
            item.setText(1, String.valueOf(Math.round(this.splineXData[i])));
            item.setText(2, String.valueOf(Math.round(this.splineYData[i])));
            ++i;
        }
    }

    private JSONArray getCurveJsonArray(String type) {
        JSONArray curveJsonArray = new JSONArray();
        if (type.equals("tableSplineCurve")) {
            int d = this.tableIndexcombo.getSelectionIndex();
            curveJsonArray = (JSONArray)this.paramBean.getValue().getValue();
            JSONArray dArray = new JSONArray();
            int i = 0;
            while (i < this.xArray.size()) {
                BigDecimal curvey = this.yArray.get(i);
                dArray.add((Object)curvey);
                ++i;
            }
            curveJsonArray.put(d, (Object)dArray);
        } else if (type.equals("splineCurve")) {
            int i = 0;
            while (i < this.xArray.size()) {
                curveJsonArray.add((Object)this.yArray.get(i));
                ++i;
            }
        }
        return curveJsonArray;
    }

    private class ControlPointDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private List<DragableCurve> dragableCurves = new ArrayList<DragableCurve>();
        private DragableCurve currentDragingCurve;
        private Boolean armed = false;
        private int plotTopY;
        private int plotBottomY;

        public List<DragableCurve> getDragableCurves() {
            return this.dragableCurves;
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (!SplineLineChart.this.editable) {
                return;
            }
            for (DragableCurve dragableCurve : this.dragableCurves) {
                int validDistance = 10;
                double minDistance = -1.0;
                int nn_index = -1;
                int i = 0;
                while (i < dragableCurve.controlPointXs.size()) {
                    double distance = Math.pow(Math.abs(SplineLineChart.this.xAxis.getValuePosition(dragableCurve.controlPointXs.get(i).doubleValue(), false) - me.x), 2.0);
                    if (minDistance < 0.0) {
                        nn_index = i;
                        minDistance = distance;
                    } else {
                        nn_index = distance < minDistance ? i : nn_index;
                        minDistance = distance < minDistance ? distance : minDistance;
                    }
                    ++i;
                }
                dragableCurve.currentControlPointIndex = nn_index;
                this.armed = minDistance < (double)validDistance;
                if (!this.armed.booleanValue()) continue;
                this.plotTopY = SplineLineChart.this.xyGraph.getPlotArea().getBounds().y;
                this.plotBottomY = this.plotTopY + SplineLineChart.this.xyGraph.getPlotArea().getBounds().height;
                this.currentDragingCurve = dragableCurve;
                SplineLineChart.this.oldParamBean = SplineLineChart.this.paramBean.clone();
                break;
            }
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            if (!this.armed.booleanValue()) {
                return;
            }
            SplineLineChart.this.paramBean.getValue().setCurrentValue((Object)SplineLineChart.this.getCurveJsonArray(SplineLineChart.this.paramBean.getType()));
            ParamBean newParamBean = SplineLineChart.this.paramBean.clone();
            EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)SplineLineChart.this.oldParamBean, (Object)newParamBean);
            this.armed = false;
            this.currentDragingCurve.currentControlPointIndex = -1;
            me.consume();
        }

        public void mouseDragged(MouseEvent me) {
            if (!SplineLineChart.this.editable) {
                return;
            }
            if (!this.armed.booleanValue()) {
                return;
            }
            if (this.currentDragingCurve.currentControlPointIndex < 0) {
                return;
            }
            if (me.y < this.plotTopY || me.y > this.plotBottomY) {
                return;
            }
            double y = SplineLineChart.this.yAxis.getPositionValue(me.y, false);
            if (SplineLineChart.this.paramBean.getValue().getMax() != null && y > SplineLineChart.this.paramBean.getValue().getMax().doubleValue()) {
                y = SplineLineChart.this.paramBean.getValue().getMax().doubleValue();
            }
            if (SplineLineChart.this.paramBean.getValue().getMin() != null && y < SplineLineChart.this.paramBean.getValue().getMin().doubleValue()) {
                y = SplineLineChart.this.paramBean.getValue().getMin().doubleValue();
            }
            this.currentDragingCurve.updateY(y);
            int decimal = SplineLineChart.this.paramBean.getValue().getDecimals() == null ? 0 : SplineLineChart.this.paramBean.getValue().getDecimals();
            BigDecimal newValue = new BigDecimal(y).setScale(decimal, 1);
            SplineLineChart.this.table.getItem(this.currentDragingCurve.currentControlPointIndex.intValue()).setText(2, String.valueOf(newValue));
            SplineLineChart.this.table.setSelection(this.currentDragingCurve.currentControlPointIndex.intValue());
            me.consume();
        }
    }

    private class DragableCurve {
        protected CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        public List<Double> controlPointXs;
        public List<Double> controlPointYs;
        private Integer currentControlPointIndex = -1;
        private SplineTrace splineTrace;

        public DragableCurve(IXYGraph xyGraph, double[] xs, double[] ys) {
            this.traceDataProvider.setUpdateMode(CircularBufferDataProvider.UpdateMode.Y);
            this.traceDataProvider.setBufferSize(xs.length);
            this.traceDataProvider.setCurrentXDataArray(xs);
            this.traceDataProvider.setCurrentYDataArray(ys);
            this.splineTrace = new SplineTrace("Trace1-XY Plot", SplineLineChart.this.xAxis, SplineLineChart.this.yAxis, (IDataProvider)this.traceDataProvider);
            CubicSplineFitter curveFitter = this.splineTrace.getCurveFitter();
            if (curveFitter != null) {
                curveFitter.setSamples(xs, ys);
            }
            this.traceDataProvider.addDataProviderListener((IDataProviderListener)this.splineTrace);
            xyGraph.addTrace((Trace)this.splineTrace);
            this.controlPointXs = new ArrayList<Double>();
            this.controlPointYs = new ArrayList<Double>();
            int i = 0;
            while (i < SplineLineChart.this.controlPoints) {
                this.controlPointXs.add(xs[i]);
                this.controlPointYs.add(ys[i]);
                ++i;
            }
        }

        public void updateY(double value) {
            int index = this.currentControlPointIndex;
            CubicSplineFitter curveFitter = this.splineTrace.getCurveFitter();
            if (curveFitter != null) {
                ((SplineLineChart)SplineLineChart.this).splineYData[index] = value;
                curveFitter.setSamples(SplineLineChart.this.splineXData, SplineLineChart.this.splineYData);
            }
            this.setTraceData();
            this.splineTrace.getXYGraph().repaint();
        }

        public void updateCurve() {
            ParamBean curvePxParamBean = SplineLineChart.this.currentModuleBean.findParamBeanByKey("curvePx");
            JSONArray pxArray = new JSONArray(curvePxParamBean.getValue().getValue());
            double xRange = 0.0;
            int i = 0;
            while (i < pxArray.size()) {
                if (pxArray.get(i) instanceof BigDecimal) {
                    xRange += Math.pow(2.0, ((BigDecimal)pxArray.get(i)).doubleValue());
                } else if (pxArray.get(i) instanceof Integer) {
                    xRange += Math.pow(2.0, ((Integer)pxArray.get(i)).doubleValue());
                }
                ++i;
            }
            CubicSplineFitter curveFitter = this.splineTrace.getCurveFitter();
            if (curveFitter != null) {
                int start = (int)SplineLineChart.this.splineXData[0];
                SplineLineChart.this.splineXData = new double[SplineLineChart.this.controlPoints];
                SplineLineChart.this.splineYData = new double[SplineLineChart.this.controlPoints];
                int i2 = 0;
                while (i2 < SplineLineChart.this.controlPoints) {
                    int step = Math.round((float)(xRange - (double)start) / (float)(SplineLineChart.this.controlPoints - 1) * (float)i2) + start;
                    ((SplineLineChart)SplineLineChart.this).splineXData[i2] = step;
                    ((SplineLineChart)SplineLineChart.this).splineYData[i2] = curveFitter.spline((double)step);
                    ++i2;
                }
                curveFitter.setSamples(SplineLineChart.this.splineXData, SplineLineChart.this.splineYData);
            }
            this.setTraceData();
            this.splineTrace.getXYGraph().repaint();
        }

        private void setTraceData() {
            this.traceDataProvider.setBufferSize(SplineLineChart.this.controlPoints);
            this.traceDataProvider.setCurrentXDataArray(SplineLineChart.this.splineXData);
            this.traceDataProvider.setCurrentYDataArray(SplineLineChart.this.splineYData);
            this.traceDataProvider.triggerUpdate();
            this.controlPointXs = new ArrayList<Double>();
            this.controlPointYs = new ArrayList<Double>();
            int i = 0;
            while (i < SplineLineChart.this.controlPoints) {
                this.controlPointXs.add(SplineLineChart.this.splineXData[i]);
                this.controlPointYs.add(SplineLineChart.this.splineYData[i]);
                ++i;
            }
        }
    }

    private class SplineTrace
    extends Trace {
        private CubicSplineFitter fitter;
        private double step;

        public SplineTrace(String name) {
            super(name);
            this.step = 0.1;
            this.setInitSettings();
        }

        public SplineTrace(String name, Axis xAxis, Axis yAxis, IDataProvider dataProvider) {
            super(name, xAxis, yAxis, dataProvider);
            this.step = 0.1;
            this.setInitSettings();
        }

        private void setInitSettings() {
            this.setPointStyle(Trace.PointStyle.POINT);
            this.setTraceType(Trace.TraceType.POINT);
            this.setCurveFitter(new CubicSplineFitter());
            this.setLineWidth(2);
            this.setPointSize(6);
            this.setAntiAliasing(true);
        }

        public void setCurveFitter(CubicSplineFitter _fitter) {
            this.fitter = _fitter;
        }

        public CubicSplineFitter getCurveFitter() {
            return this.fitter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintInternalFigure(Graphics graphics) {
            graphics.setAntialias(1);
            graphics.setForegroundColor(this.getTraceColor());
            graphics.setLineWidth(this.getLineWidth());
            IDataProvider traceDataProvider = this.getDataProvider();
            if (traceDataProvider == null) {
                throw new RuntimeException("No DataProvider defined for splineTrace: " + this.getName());
            }
            IDataProvider iDataProvider = traceDataProvider;
            synchronized (iDataProvider) {
                int sampleSize = traceDataProvider.getSize();
                double[] xSample = new double[sampleSize];
                int i = 0;
                while (i < sampleSize) {
                    xSample[i] = traceDataProvider.getSample(i).getXValue();
                    ++i;
                }
                NoRepeatsPointsList plPolyline = new NoRepeatsPointsList();
                int k = 0;
                int i2 = 0;
                while (i2 < sampleSize - 1) {
                    double xVal = xSample[i2];
                    while (xVal < xSample[i2 + 1]) {
                        double yVal = this.fitter.spline(xVal);
                        yVal = yVal < SplineLineChart.this.yRangeMin ? SplineLineChart.this.yRangeMin : yVal;
                        yVal = yVal > SplineLineChart.this.yRangeMax ? SplineLineChart.this.yRangeMax : yVal;
                        Point dpPos = new Point(this.getXAxis().getValuePosition(xVal, false), this.getYAxis().getValuePosition(yVal, false));
                        plPolyline.addPoint(dpPos);
                        if ((int)xVal == ((BigDecimal)SplineLineChart.this.xArray.get(k)).intValue()) {
                            SplineLineChart.this.yArray.set(k, new BigDecimal(yVal).setScale((int)SplineLineChart.this.paramBean.getValue().getDecimals(), 1));
                            ++k;
                        }
                        xVal += this.step;
                    }
                    ++i2;
                }
                SplineLineChart.this.yArray.set(k, new BigDecimal(traceDataProvider.getSample(sampleSize - 1).getYValue()).setScale((int)SplineLineChart.this.paramBean.getValue().getDecimals(), 1));
                graphics.drawPolyline((PointList)plPolyline);
                SplineLineChart.this.paramBean.getValue().setCurrentValue((Object)SplineLineChart.this.getCurveJsonArray(SplineLineChart.this.paramBean.getType()));
            }
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.pushState();
            try {
                this.paintInternalFigure(graphics);
            }
            finally {
                graphics.popState();
            }
        }
    }
}

