/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.chart;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import com.verisilicon.isp.tuning.core.util.LinearFitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.NoRepeatsPointsList;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LinearLineChart {
    private ParamBean oldParamBean;
    private ParamBean paramBean;
    private ModuleBean currentModuleBean;
    private double xRangeMin = 0.5;
    private double xRangeMax = 5.5;
    private double yRangeMin = 100000.0;
    private double yRangeMax = -100000.0;
    private TableEditor fTableEditor;
    protected Axis xAxis;
    protected Axis yAxis;
    IXYGraph xyGraph;
    private Table table;
    private List<BigDecimal> xArray = new ArrayList<BigDecimal>();
    private List<BigDecimal> yArray = new ArrayList<BigDecimal>();
    private Combo tableIndexcombo;
    private int controlPoints = 0;
    private int ctrlSpinnerPoints = 0;
    private ControlPointDragger controlPointDragger;
    private DragableCurve dragableCurve1;
    private boolean editable = true;
    private boolean isAutoModule = true;
    private double[] splineXData;
    private double[] splineYData;

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private String standardString(String s, ParamBean paramBean) {
        BigDecimal value = new BigDecimal(s);
        if (value.compareTo(paramBean.getValue().getMin()) < 0) {
            value = paramBean.getValue().getMin();
        }
        if (value.compareTo(paramBean.getValue().getMax()) > 0) {
            value = paramBean.getValue().getMax();
        }
        return paramBean.getValue().getDecimals() == null ? value.setScale(0, 1).toString() : value.setScale((int)paramBean.getValue().getDecimals(), 1).toString();
    }

    public void show(Composite parent, ParamBean paramBean, JSONArray pointsPosArray, Composite right, List<Rectangle> bounds, ModuleBean currentModuleBean, boolean isAutoModule) {
        this.paramBean = paramBean;
        this.currentModuleBean = currentModuleBean;
        this.isAutoModule = isAutoModule;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(100, true));
        Canvas cvs = new Canvas(composite, 0);
        cvs.setLayoutData((Object)new GridData(4, 4, true, true, 100, 100));
        cvs.setEnabled(parent.getEnabled());
        LightweightSystem lws = new LightweightSystem(cvs);
        this.xyGraph = new XYGraph();
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph(this.xyGraph);
        this.xyGraph.setTitle(paramBean.getShowName());
        this.xyGraph.setShowLegend(false);
        this.xyGraph.setEnabled(paramBean.getIsEnabled().booleanValue());
        lws.setContents((IFigure)toolbarArmedXYGraph);
        List<Object> pointsList = new ArrayList();
        if (pointsPosArray != null) {
            pointsList = this.updateAxis(pointsPosArray);
            this.dragableCurve1 = new DragableCurve(this.xyGraph, (double[])pointsList.get(0), (double[])pointsList.get(1));
            this.controlPointDragger = new ControlPointDragger();
            this.controlPointDragger.dragableCurves.add(this.dragableCurve1);
            this.xyGraph.getPlotArea().addMouseListener((MouseListener)this.controlPointDragger);
            this.xyGraph.getPlotArea().addMouseMotionListener((MouseMotionListener)this.controlPointDragger);
            this.ctrlSpinnerPoints = pointsPosArray.size();
            this.controlPoints = pointsPosArray.size();
        } else {
            this.controlPoints = 0;
        }
        composite.pack();
        parent.pack();
        Rectangle curveBounds = composite.getBounds();
        bounds.add(curveBounds);
        right.setVisible(true);
        Composite tableComp = new Composite(right, 2048);
        this.createTable(tableComp, curveBounds);
    }

    private void createTable(Composite parent, Rectangle bounds) {
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        Composite controlPointComp = new Composite(parent, 2048);
        controlPointComp.setLayout((Layout)new GridLayout(3, false));
        controlPointComp.setLayoutData((Object)new GridData(4, 128, true, false));
        Label controlPointlabel = new Label(controlPointComp, 0);
        controlPointlabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        controlPointlabel.setText("Control Points");
        Spinner ctrlPointsSpinner = new Spinner(controlPointComp, 0);
        ctrlPointsSpinner.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        ctrlPointsSpinner.setMaximum(this.ctrlSpinnerPoints);
        ctrlPointsSpinner.setMinimum(3);
        ctrlPointsSpinner.setDigits(0);
        ctrlPointsSpinner.setSelection(this.ctrlSpinnerPoints);
        ctrlPointsSpinner.setEnabled(this.paramBean.getIsEnabled() != false && this.currentModuleBean.getModuleEnable() != false);
        ctrlPointsSpinner.addListener(27, e -> {
            int val = Integer.parseInt(ctrlPointsSpinner.getText());
            if (val < ctrlPointsSpinner.getMinimum()) {
                ctrlPointsSpinner.setSelection(ctrlPointsSpinner.getMinimum());
            } else if (val > ctrlPointsSpinner.getMaximum()) {
                ctrlPointsSpinner.setSelection(ctrlPointsSpinner.getMaximum());
            }
            ctrlPointsSpinner.notifyListeners(13, new Event());
        });
        ctrlPointsSpinner.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    ctrlPointsSpinner.notifyListeners(27, new Event());
                }
            }
        });
        ctrlPointsSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LinearLineChart.this.controlPoints = (int)((double)ctrlPointsSpinner.getSelection() / Math.pow(10.0, ctrlPointsSpinner.getDigits()));
                DragableCurve curve = LinearLineChart.this.controlPointDragger.getDragableCurves().get(0);
                curve.updateCurve();
                LinearLineChart.this.setPointsToTable();
            }
        });
        if (this.isAutoModule) {
            Composite tableIndexComp = new Composite(parent, 2048);
            tableIndexComp.setLayout((Layout)new GridLayout(3, false));
            tableIndexComp.setLayoutData((Object)new GridData(4, 128, true, false));
            Label tableIndexlabel = new Label(tableIndexComp, 0);
            tableIndexlabel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            tableIndexlabel.setText("Table Control");
            this.tableIndexcombo = new Combo(tableIndexComp, 8);
            this.tableIndexcombo.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            ParamBean gainsBean = this.currentModuleBean.findParamBeanByKey(":gains");
            JSONArray gainsArray = (JSONArray)gainsBean.getValue().getValue();
            if (gainsArray == null) {
                gainsArray = new JSONArray();
            }
            for (Object obj : gainsArray) {
                this.tableIndexcombo.add(obj.toString());
            }
            this.tableIndexcombo.select(0);
            this.tableIndexcombo.select(0);
            this.tableIndexcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ctrlPointsSpinner.setSelection(LinearLineChart.this.ctrlSpinnerPoints);
                    ctrlPointsSpinner.notifyListeners(13, new Event());
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)LinearLineChart.this.currentModuleBean, (String)LinearLineChart.this.paramBean.getCategory(), (String)LinearLineChart.this.paramBean.getKey(), (int)LinearLineChart.this.tableIndexcombo.getSelectionIndex());
                    LinearLineChart.this.updateAxis(pointsPosArray);
                    LinearLineChart.this.dragableCurve1.splineTrace.getCurveFitter().setSamples(LinearLineChart.this.splineXData, LinearLineChart.this.splineYData);
                    DragableCurve curve = LinearLineChart.this.controlPointDragger.getDragableCurves().get(0);
                    curve.updateCurve();
                    LinearLineChart.this.setPointsToTable();
                }
            });
        }
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setEnabled(this.paramBean.getIsEnabled() != false && this.currentModuleBean.getModuleEnable() != false);
        GridData tableGridData = new GridData(4, 4, true, true, 2, 1);
        this.table.setLayoutData((Object)tableGridData);
        this.fTableEditor = new TableEditor(this.table);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        int indexWidth = 70;
        int itemWidth = bounds.width - indexWidth - (this.table.getVerticalBar().getSize().x << 1) >> 1;
        TableColumn indexColumn = new TableColumn(this.table, 0x1000000);
        indexColumn.setText("Point");
        indexColumn.setWidth(indexWidth);
        TableColumn xColumn = new TableColumn(this.table, 0x1000000);
        xColumn.setText("X");
        xColumn.setWidth(itemWidth);
        TableColumn yColumn = new TableColumn(this.table, 0x1000000);
        yColumn.setText("Y");
        yColumn.setWidth(itemWidth);
        this.setPointsToTable();
        this.table.addMouseListener((org.eclipse.swt.events.MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
                if (!LinearLineChart.this.editable) {
                    return;
                }
                int selectIndex = LinearLineChart.this.table.getSelectionIndex();
                if (selectIndex < 0) {
                    return;
                }
                final TableItem item = LinearLineChart.this.table.getItem(selectIndex);
                org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(e.x, e.y);
                int clickedCell = 0;
                int i = 0;
                while (i < LinearLineChart.this.table.getColumnCount()) {
                    if (item.getBounds(i).contains(point)) {
                        clickedCell = i;
                        break;
                    }
                    ++i;
                }
                if (clickedCell < 2) {
                    return;
                }
                final int selectCol = clickedCell;
                final String itemString = item.getText(selectCol);
                Control oldEditor = LinearLineChart.this.fTableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                final Text text = new Text((Composite)LinearLineChart.this.table, 0);
                text.setText(itemString);
                ((LinearLineChart)LinearLineChart.this).fTableEditor.grabHorizontal = true;
                ((LinearLineChart)LinearLineChart.this).fTableEditor.minimumHeight = text.getSize().y;
                ((LinearLineChart)LinearLineChart.this).fTableEditor.minimumWidth = text.getSize().x;
                text.selectAll();
                text.setFocus();
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        String newValue = text.getText();
                        if (!LinearLineChart.this.inputCheck(newValue)) {
                            text.setText(itemString);
                            text.dispose();
                            return;
                        }
                        newValue = LinearLineChart.this.standardString(newValue, LinearLineChart.this.paramBean);
                        item.setText(selectCol, newValue);
                        int selectRow = LinearLineChart.this.table.getSelectionIndex();
                        text.dispose();
                        if (selectCol == 2 && itemString.compareTo(newValue) != 0) {
                            LinearLineChart.this.handleTableYItemChanged(selectRow, selectCol, newValue);
                        }
                    }
                });
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\r' || e.character == '\t') {
                            String newValue = text.getText();
                            if (!LinearLineChart.this.inputCheck(newValue)) {
                                text.setText(itemString);
                                text.dispose();
                                return;
                            }
                            newValue = LinearLineChart.this.standardString(newValue, LinearLineChart.this.paramBean);
                            item.setText(selectCol, newValue);
                            int selectRow = LinearLineChart.this.table.getSelectionIndex();
                            text.dispose();
                            if (selectCol == 2 && itemString.compareTo(newValue) != 0) {
                                LinearLineChart.this.handleTableYItemChanged(selectRow, selectCol, newValue);
                            }
                        }
                        if (e.character == '\u001b') {
                            text.dispose();
                        }
                    }
                });
                LinearLineChart.this.fTableEditor.setEditor((Control)text, item, selectCol);
            }
        });
    }

    private List<double[]> updateAxis(JSONArray pointsPosArray) {
        this.xArray = new ArrayList<BigDecimal>();
        this.yArray = new ArrayList<BigDecimal>();
        pointsPosArray.stream().forEach(e1 -> {
            assert (e1 instanceof JSONArray);
            JSONArray posArray = (JSONArray)e1;
            Object x = posArray.get(0);
            Object y = posArray.get(1);
            if (x instanceof BigDecimal) {
                this.xArray.add((BigDecimal)x);
            } else if (x instanceof Integer) {
                this.xArray.add(new BigDecimal((Integer)x));
            }
            if (y instanceof BigDecimal) {
                this.yArray.add((BigDecimal)y);
            } else if (y instanceof Integer) {
                this.yArray.add(new BigDecimal((Integer)y));
            }
        });
        this.splineXData = this.xArray.stream().mapToDouble(e2 -> Double.parseDouble(String.valueOf(e2))).toArray();
        this.xRangeMin = this.splineXData[0];
        this.xRangeMax = this.splineXData[this.splineXData.length - 1];
        this.splineYData = this.yArray.stream().mapToDouble(e3 -> Double.parseDouble(String.valueOf(e3))).toArray();
        this.yRangeMax = this.paramBean.getValue().getMax().doubleValue();
        this.yRangeMin = this.paramBean.getValue().getMin().doubleValue();
        Double rangeDiff = this.yRangeMax - this.yRangeMin;
        if (rangeDiff < 20.0) {
            this.yRangeMax = Math.round(this.yRangeMax + (20.0 - rangeDiff) / 2.0);
            this.yRangeMin = Math.round(this.yRangeMin - (20.0 - rangeDiff) / 2.0);
        }
        this.xAxis = this.xyGraph.getPrimaryXAxis();
        this.yAxis = this.xyGraph.getPrimaryYAxis();
        this.xAxis.setRange(this.xRangeMin, this.xRangeMax);
        this.yAxis.setRange(this.yRangeMin, this.yRangeMax);
        ArrayList<double[]> pointsList = new ArrayList<double[]>();
        pointsList.add(this.splineXData);
        pointsList.add(this.splineYData);
        return pointsList;
    }

    public void handleTableYItemChanged(int row, int col, String newValue) {
        DragableCurve curve = this.controlPointDragger.getDragableCurves().get(0);
        curve.currentControlPointIndex = row;
        curve.updateY(Double.parseDouble(newValue));
        this.setTableUpdate();
    }

    public void setTableUpdate() {
        this.oldParamBean = this.paramBean.clone();
        this.paramBean.getValue().setCurrentValue((Object)this.getCurveJsonArray(this.paramBean.getType()));
        ParamBean newParamBean = this.paramBean.clone();
        EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)this.oldParamBean, (Object)newParamBean);
    }

    public int getColumnIndex(Table table, TableColumn column) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getTableItemText(Table table, TableItem item) {
        int count = table.getColumnCount();
        String[] strs = new String[count];
        int i = 0;
        while (i < count) {
            strs[i] = item.getText(i);
            ++i;
        }
        return strs;
    }

    public void setPointsToTable() {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        int i = 0;
        while (i < this.controlPoints) {
            TableItem item = new TableItem(this.table, 0x1000000);
            item.setText(0, String.valueOf(i));
            item.setBackground(0, new Color((Device)item.getDisplay(), 200, 200, 200));
            item.setText(1, String.valueOf(Math.round(this.splineXData[i])));
            item.setText(2, String.valueOf(Math.round(this.splineYData[i])));
            ++i;
        }
    }

    private JSONArray getCurveJsonArray(String type) {
        JSONArray curveJsonArray = new JSONArray();
        if (type.equals("tableLineCurve")) {
            int d = this.tableIndexcombo.getSelectionIndex();
            curveJsonArray = (JSONArray)this.paramBean.getValue().getValue();
            JSONArray dArray = new JSONArray();
            int i = 0;
            while (i < this.xArray.size()) {
                BigDecimal curvey = this.yArray.get(i);
                dArray.add((Object)curvey);
                ++i;
            }
            curveJsonArray.put(d, (Object)dArray);
        } else if (type.equals("lineCurve")) {
            int i = 0;
            while (i < this.xArray.size()) {
                curveJsonArray.add((Object)this.yArray.get(i));
                ++i;
            }
        }
        return curveJsonArray;
    }

    private class ControlPointDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private List<DragableCurve> dragableCurves = new ArrayList<DragableCurve>();
        private DragableCurve currentDragingCurve;
        private Boolean armed = false;
        private int plotTopY;
        private int plotBottomY;

        public List<DragableCurve> getDragableCurves() {
            return this.dragableCurves;
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (!LinearLineChart.this.editable) {
                return;
            }
            for (DragableCurve dragableCurve : this.dragableCurves) {
                int validDistance = 10;
                double minDistance = -1.0;
                int nn_index = -1;
                int i = 0;
                while (i < dragableCurve.controlPointXs.size()) {
                    double distance = Math.pow(Math.abs(LinearLineChart.this.xAxis.getValuePosition(dragableCurve.controlPointXs.get(i).doubleValue(), false) - me.x), 2.0);
                    if (minDistance < 0.0) {
                        nn_index = i;
                        minDistance = distance;
                    } else {
                        nn_index = distance < minDistance ? i : nn_index;
                        minDistance = distance < minDistance ? distance : minDistance;
                    }
                    ++i;
                }
                dragableCurve.currentControlPointIndex = nn_index;
                this.armed = minDistance < (double)validDistance;
                if (!this.armed.booleanValue()) continue;
                this.plotTopY = LinearLineChart.this.xyGraph.getPlotArea().getBounds().y;
                this.plotBottomY = this.plotTopY + LinearLineChart.this.xyGraph.getPlotArea().getBounds().height;
                this.currentDragingCurve = dragableCurve;
                LinearLineChart.this.oldParamBean = LinearLineChart.this.paramBean.clone();
                break;
            }
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            if (!this.armed.booleanValue()) {
                return;
            }
            LinearLineChart.this.paramBean.getValue().setCurrentValue((Object)LinearLineChart.this.getCurveJsonArray(LinearLineChart.this.paramBean.getType()));
            ParamBean newParamBean = LinearLineChart.this.paramBean.clone();
            EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)LinearLineChart.this.oldParamBean, (Object)newParamBean);
            this.armed = false;
            this.currentDragingCurve.currentControlPointIndex = -1;
            me.consume();
        }

        public void mouseDragged(MouseEvent me) {
            if (!LinearLineChart.this.editable) {
                return;
            }
            if (!this.armed.booleanValue()) {
                return;
            }
            if (this.currentDragingCurve.currentControlPointIndex < 0) {
                return;
            }
            if (me.y < this.plotTopY || me.y > this.plotBottomY) {
                return;
            }
            double y = LinearLineChart.this.yAxis.getPositionValue(me.y, false);
            if (LinearLineChart.this.paramBean.getValue().getMax() != null && y > LinearLineChart.this.paramBean.getValue().getMax().doubleValue()) {
                y = LinearLineChart.this.paramBean.getValue().getMax().doubleValue();
            }
            if (LinearLineChart.this.paramBean.getValue().getMin() != null && y < LinearLineChart.this.paramBean.getValue().getMin().doubleValue()) {
                y = LinearLineChart.this.paramBean.getValue().getMin().doubleValue();
            }
            this.currentDragingCurve.updateY(y);
            int decimal = LinearLineChart.this.paramBean.getValue().getDecimals() == null ? 0 : LinearLineChart.this.paramBean.getValue().getDecimals();
            BigDecimal newValue = new BigDecimal(y).setScale(decimal, 1);
            LinearLineChart.this.table.getItem(this.currentDragingCurve.currentControlPointIndex.intValue()).setText(2, String.valueOf(newValue));
            LinearLineChart.this.table.setSelection(this.currentDragingCurve.currentControlPointIndex.intValue());
            me.consume();
        }
    }

    private class DragableCurve {
        protected CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        public List<Double> controlPointXs;
        public List<Double> controlPointYs;
        private Integer currentControlPointIndex = -1;
        private SplineTrace splineTrace;

        public DragableCurve(IXYGraph xyGraph, double[] xs, double[] ys) {
            this.traceDataProvider.setUpdateMode(CircularBufferDataProvider.UpdateMode.Y);
            this.traceDataProvider.setBufferSize(xs.length);
            this.traceDataProvider.setCurrentXDataArray(xs);
            this.traceDataProvider.setCurrentYDataArray(ys);
            this.splineTrace = new SplineTrace("Trace1-XY Plot", LinearLineChart.this.xAxis, LinearLineChart.this.yAxis, (IDataProvider)this.traceDataProvider);
            LinearFitter curveFitter = this.splineTrace.getCurveFitter();
            if (curveFitter != null) {
                curveFitter.setSamples(xs, ys);
            }
            this.traceDataProvider.addDataProviderListener((IDataProviderListener)this.splineTrace);
            xyGraph.addTrace((Trace)this.splineTrace);
            this.controlPointXs = new ArrayList<Double>();
            this.controlPointYs = new ArrayList<Double>();
            int i = 0;
            while (i < LinearLineChart.this.controlPoints) {
                this.controlPointXs.add(xs[i]);
                this.controlPointYs.add(ys[i]);
                ++i;
            }
        }

        public void updateY(double value) {
            int index = this.currentControlPointIndex;
            LinearFitter curveFitter = this.splineTrace.getCurveFitter();
            if (curveFitter != null) {
                ((LinearLineChart)LinearLineChart.this).splineYData[index] = value;
                curveFitter.setSamples(LinearLineChart.this.splineXData, LinearLineChart.this.splineYData);
            }
            this.setTraceData();
            this.splineTrace.getXYGraph().repaint();
        }

        public void updateCurve() {
            LinearFitter curveFitter = this.splineTrace.getCurveFitter();
            if (curveFitter != null) {
                LinearLineChart.this.splineXData = new double[LinearLineChart.this.controlPoints];
                LinearLineChart.this.splineYData = new double[LinearLineChart.this.controlPoints];
                ((LinearLineChart)LinearLineChart.this).splineXData[0] = ((BigDecimal)LinearLineChart.this.xArray.get(0)).doubleValue();
                ((LinearLineChart)LinearLineChart.this).splineYData[0] = ((BigDecimal)LinearLineChart.this.yArray.get(0)).doubleValue();
                int i = 1;
                while (i < LinearLineChart.this.controlPoints - 1) {
                    int step = Math.round((float)LinearLineChart.this.ctrlSpinnerPoints / (float)LinearLineChart.this.controlPoints * (float)i);
                    ((LinearLineChart)LinearLineChart.this).splineXData[i] = ((BigDecimal)LinearLineChart.this.xArray.get(step)).doubleValue();
                    ((LinearLineChart)LinearLineChart.this).splineYData[i] = curveFitter.spline(LinearLineChart.this.splineXData[i]);
                    ++i;
                }
                ((LinearLineChart)LinearLineChart.this).splineXData[((LinearLineChart)LinearLineChart.this).controlPoints - 1] = ((BigDecimal)LinearLineChart.this.xArray.get(LinearLineChart.this.ctrlSpinnerPoints - 1)).doubleValue();
                ((LinearLineChart)LinearLineChart.this).splineYData[((LinearLineChart)LinearLineChart.this).controlPoints - 1] = ((BigDecimal)LinearLineChart.this.yArray.get(LinearLineChart.this.ctrlSpinnerPoints - 1)).doubleValue();
                curveFitter.setSamples(LinearLineChart.this.splineXData, LinearLineChart.this.splineYData);
            }
            this.setTraceData();
            this.splineTrace.getXYGraph().repaint();
        }

        private void setTraceData() {
            this.traceDataProvider.setBufferSize(LinearLineChart.this.controlPoints);
            this.traceDataProvider.setCurrentXDataArray(LinearLineChart.this.splineXData);
            this.traceDataProvider.setCurrentYDataArray(LinearLineChart.this.splineYData);
            this.traceDataProvider.triggerUpdate();
            this.controlPointXs = new ArrayList<Double>();
            this.controlPointYs = new ArrayList<Double>();
            int i = 0;
            while (i < LinearLineChart.this.controlPoints) {
                this.controlPointXs.add(LinearLineChart.this.splineXData[i]);
                this.controlPointYs.add(LinearLineChart.this.splineYData[i]);
                ++i;
            }
        }
    }

    private class SplineTrace
    extends Trace {
        private LinearFitter fitter;
        private double step;

        public SplineTrace(String name) {
            super(name);
            this.step = 1.0;
            this.setInitSettings();
        }

        public SplineTrace(String name, Axis xAxis, Axis yAxis, IDataProvider dataProvider) {
            super(name, xAxis, yAxis, dataProvider);
            this.step = 1.0;
            this.setInitSettings();
        }

        private void setInitSettings() {
            this.setPointStyle(Trace.PointStyle.POINT);
            this.setTraceType(Trace.TraceType.POINT);
            this.setCurveFitter(new LinearFitter());
            this.setLineWidth(2);
            this.setPointSize(6);
            this.setAntiAliasing(true);
        }

        public void setCurveFitter(LinearFitter _fitter) {
            this.fitter = _fitter;
        }

        public LinearFitter getCurveFitter() {
            return this.fitter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintInternalFigure(Graphics graphics) {
            graphics.setAntialias(1);
            graphics.setForegroundColor(this.getTraceColor());
            graphics.setLineWidth(this.getLineWidth());
            IDataProvider traceDataProvider = this.getDataProvider();
            if (traceDataProvider == null) {
                throw new RuntimeException("No DataProvider defined for splineTrace: " + this.getName());
            }
            IDataProvider iDataProvider = traceDataProvider;
            synchronized (iDataProvider) {
                int sampleSize = traceDataProvider.getSize();
                double[] xSample = new double[sampleSize];
                int i = 0;
                while (i < sampleSize) {
                    xSample[i] = traceDataProvider.getSample(i).getXValue();
                    ++i;
                }
                NoRepeatsPointsList plPolyline = new NoRepeatsPointsList();
                int k = 0;
                double maxBoundary = xSample[sampleSize - 1];
                double minBoundary = xSample[0];
                this.step = maxBoundary - minBoundary > 1500.0 ? 1.0 : 0.1;
                int i2 = 0;
                while (i2 < sampleSize - 1) {
                    double xVal = xSample[i2];
                    if (xVal > 1500.0) {
                        this.step = 8.0;
                    }
                    while (xVal < xSample[i2 + 1]) {
                        double yVal = this.fitter.spline(xVal);
                        yVal = yVal < LinearLineChart.this.yRangeMin ? LinearLineChart.this.yRangeMin : yVal;
                        yVal = yVal > LinearLineChart.this.yRangeMax ? LinearLineChart.this.yRangeMax : yVal;
                        Point dpPos = new Point(this.getXAxis().getValuePosition(xVal, false), this.getYAxis().getValuePosition(yVal, false));
                        plPolyline.addPoint(dpPos);
                        if ((int)xVal == ((BigDecimal)LinearLineChart.this.xArray.get(k)).intValue()) {
                            LinearLineChart.this.yArray.set(k, new BigDecimal(yVal).setScale((int)LinearLineChart.this.paramBean.getValue().getDecimals(), 1));
                            ++k;
                        }
                        xVal += this.step;
                    }
                    ++i2;
                }
                LinearLineChart.this.yArray.set(k, new BigDecimal(traceDataProvider.getSample(sampleSize - 1).getYValue()).setScale((int)LinearLineChart.this.paramBean.getValue().getDecimals(), 1));
                graphics.drawPolyline((PointList)plPolyline);
                LinearLineChart.this.paramBean.getValue().setCurrentValue((Object)LinearLineChart.this.getCurveJsonArray(LinearLineChart.this.paramBean.getType()));
            }
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            graphics.pushState();
            try {
                this.paintInternalFigure(graphics);
            }
            finally {
                graphics.popState();
            }
        }
    }
}

