/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.chart;

import cn.hutool.json.JSONArray;
import com.verisilicon.isp.tuning.core.algo.CallbackManager;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.manager.EventManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LineChart {
    private ParamBean oldParamBean;
    private ParamBean paramBean;
    private ModuleBean currentModuleBean;
    private double xRangeMin = 0.5;
    private double xRangeMax = 5.5;
    private double yRangeMin = 100000.0;
    private double yRangeMax = -100000.0;
    private TableEditor fTableEditor;
    protected Axis xAxis;
    protected Axis yAxis;
    IXYGraph xyGraph;
    private Table table;
    private List<BigDecimal> xArray = new ArrayList<BigDecimal>();
    private List<BigDecimal> yArray = new ArrayList<BigDecimal>();
    private Combo combo;
    private ControlPointDragger controlPointDragger;
    private boolean editable = true;
    private boolean isAuto = true;

    private boolean inputCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private String standardString(String s, ParamBean paramBean) {
        BigDecimal value = new BigDecimal(s);
        if (value.compareTo(paramBean.getValue().getMin()) < 0) {
            value = paramBean.getValue().getMin();
        }
        if (value.compareTo(paramBean.getValue().getMax()) > 0) {
            value = paramBean.getValue().getMax();
        }
        return paramBean.getValue().getDecimals() == null ? value.setScale(0, 1).toString() : value.setScale((int)paramBean.getValue().getDecimals(), 1).toString();
    }

    public void show(Composite parent, ParamBean paramBean, JSONArray pointsPosArray, Composite right, List<Rectangle> bounds, ModuleBean currentModuleBean, boolean isAuto) {
        this.paramBean = paramBean;
        this.currentModuleBean = currentModuleBean;
        this.isAuto = isAuto;
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(100, true));
        Canvas cvs = new Canvas(composite, 0);
        cvs.setLayoutData((Object)new GridData(4, 4, true, true, 100, 100));
        cvs.setEnabled(parent.getEnabled());
        LightweightSystem lws = new LightweightSystem(cvs);
        this.xyGraph = new XYGraph();
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph(this.xyGraph);
        this.xyGraph.setTitle(paramBean.getShowName());
        this.xyGraph.setShowLegend(false);
        lws.setContents((IFigure)toolbarArmedXYGraph);
        this.xyGraph.setEnabled(paramBean.getIsEnabled() != false && currentModuleBean.getModuleEnable() != false);
        List<Object> pointsList = new ArrayList();
        if (pointsPosArray != null) {
            pointsList = this.updateAxis(pointsPosArray);
            DragableCurve dragableCurve1 = new DragableCurve(this.xyGraph, (double[])pointsList.get(0), (double[])pointsList.get(1));
            this.controlPointDragger = new ControlPointDragger();
            this.controlPointDragger.dragableCurves.add(dragableCurve1);
            this.xyGraph.getPlotArea().addMouseListener((MouseListener)this.controlPointDragger);
            this.xyGraph.getPlotArea().addMouseMotionListener((MouseMotionListener)this.controlPointDragger);
        }
        composite.pack();
        parent.pack();
        Rectangle curveBounds = composite.getBounds();
        bounds.add(curveBounds);
        right.setVisible(true);
        Composite tableComp = new Composite(right, 2048);
        tableComp.setEnabled(paramBean.getIsEnabled().booleanValue());
        this.createTable(tableComp, curveBounds);
    }

    private void createTable(Composite parent, Rectangle bounds) {
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        if (this.isAuto) {
            Composite tableIndexComp = new Composite(parent, 2048);
            tableIndexComp.setLayout((Layout)new GridLayout(3, false));
            tableIndexComp.setLayoutData((Object)new GridData(4, 128, true, false));
            Label label = new Label(tableIndexComp, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            label.setText("Table Control");
            this.combo = new Combo(tableIndexComp, 8);
            this.combo.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            ParamBean gainsBean = this.currentModuleBean.findParamBeanByKey(":gains");
            JSONArray gainsArray = (JSONArray)gainsBean.getValue().getValue();
            if (gainsArray == null) {
                gainsArray = new JSONArray();
            }
            for (Object obj : gainsArray) {
                this.combo.add(obj.toString());
            }
            this.combo.select(0);
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    CallbackManager cbManager = CallbackManager.getInstance();
                    JSONArray pointsPosArray = (JSONArray)CallbackManager.processCallback((ModuleBean)LineChart.this.currentModuleBean, (String)LineChart.this.paramBean.getCategory(), (String)LineChart.this.paramBean.getKey(), (int)LineChart.this.combo.getSelectionIndex());
                    List pointsList = LineChart.this.updateAxis(pointsPosArray);
                    LineChart.this.setPointsToTable();
                    DragableCurve curve = LineChart.this.controlPointDragger.getDragableCurves().get(0);
                    curve.updateCurve((double[])pointsList.get(0), (double[])pointsList.get(1));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.table = new Table(parent, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setEnabled(this.paramBean.getIsEnabled() != false && this.currentModuleBean.getModuleEnable() != false);
        GridData tableGridData = new GridData(4, 4, true, true, 2, 1);
        this.table.setLayoutData((Object)tableGridData);
        this.fTableEditor = new TableEditor(this.table);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        int indexWidth = 70;
        int itemWidth = bounds.width - indexWidth - (this.table.getVerticalBar().getSize().x << 1) >> 1;
        TableColumn indexColumn = new TableColumn(this.table, 0x1000000);
        indexColumn.setText("Point");
        indexColumn.setWidth(indexWidth);
        TableColumn xColumn = new TableColumn(this.table, 0x1000000);
        xColumn.setText("X");
        xColumn.setWidth(itemWidth);
        TableColumn yColumn = new TableColumn(this.table, 0x1000000);
        yColumn.setText("Y");
        yColumn.setWidth(itemWidth);
        this.setPointsToTable();
        this.table.addMouseListener((org.eclipse.swt.events.MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
                if (!LineChart.this.editable) {
                    return;
                }
                int selectIndex = LineChart.this.table.getSelectionIndex();
                if (selectIndex < 0) {
                    return;
                }
                final TableItem item = LineChart.this.table.getItem(selectIndex);
                Point point = new Point(e.x, e.y);
                int clickedCell = 0;
                int i = 0;
                while (i < LineChart.this.table.getColumnCount()) {
                    if (item.getBounds(i).contains(point)) {
                        clickedCell = i;
                        break;
                    }
                    ++i;
                }
                if (clickedCell < 2) {
                    return;
                }
                final int selectCol = clickedCell;
                final String itemString = item.getText(selectCol);
                Control oldEditor = LineChart.this.fTableEditor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                final Text text = new Text((Composite)LineChart.this.table, 0);
                text.setText(itemString);
                ((LineChart)LineChart.this).fTableEditor.grabHorizontal = true;
                ((LineChart)LineChart.this).fTableEditor.minimumHeight = text.getSize().y;
                ((LineChart)LineChart.this).fTableEditor.minimumWidth = text.getSize().x;
                text.selectAll();
                text.setFocus();
                text.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        String newValue = text.getText();
                        if (!LineChart.this.inputCheck(newValue)) {
                            text.setText(itemString);
                            text.dispose();
                            return;
                        }
                        newValue = LineChart.this.standardString(newValue, LineChart.this.paramBean);
                        item.setText(selectCol, newValue);
                        int selectRow = LineChart.this.table.getSelectionIndex();
                        text.dispose();
                        if (selectCol == 2 && itemString.compareTo(newValue) != 0) {
                            LineChart.this.handleTableYItemChanged(selectRow, selectCol, newValue);
                        }
                    }
                });
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\r' || e.character == '\t') {
                            String newValue = text.getText();
                            if (!LineChart.this.inputCheck(newValue)) {
                                text.setText(itemString);
                                text.dispose();
                                return;
                            }
                            newValue = LineChart.this.standardString(newValue, LineChart.this.paramBean);
                            item.setText(selectCol, newValue);
                            int selectRow = LineChart.this.table.getSelectionIndex();
                            text.dispose();
                            if (selectCol == 2 && itemString.compareTo(newValue) != 0) {
                                LineChart.this.handleTableYItemChanged(selectRow, selectCol, newValue);
                            }
                        }
                        if (e.character == '\u001b') {
                            text.dispose();
                        }
                    }
                });
                LineChart.this.fTableEditor.setEditor((Control)text, item, selectCol);
            }
        });
    }

    private List<double[]> updateAxis(JSONArray pointsPosArray) {
        this.xArray = new ArrayList<BigDecimal>();
        this.yArray = new ArrayList<BigDecimal>();
        pointsPosArray.stream().forEach(e1 -> {
            assert (e1 instanceof JSONArray);
            JSONArray posArray = (JSONArray)e1;
            Object x = posArray.get(0);
            Object y = posArray.get(1);
            if (x instanceof BigDecimal) {
                this.xArray.add((BigDecimal)x);
            } else if (x instanceof Integer) {
                this.xArray.add(new BigDecimal((Integer)x));
            }
            if (y instanceof BigDecimal) {
                this.yArray.add((BigDecimal)y);
            } else if (y instanceof Integer) {
                this.yArray.add(new BigDecimal((Integer)y));
            }
        });
        double[] xs = this.xArray.stream().mapToDouble(e2 -> Double.parseDouble(String.valueOf(e2))).toArray();
        this.xRangeMin = xs[0];
        this.xRangeMax = xs[xs.length - 1];
        double[] ys = this.yArray.stream().mapToDouble(e3 -> Double.parseDouble(String.valueOf(e3))).toArray();
        this.yRangeMax = this.paramBean.getValue().getMax().doubleValue();
        this.yRangeMin = this.paramBean.getValue().getMin().doubleValue();
        Double rangeDiff = this.yRangeMax - this.yRangeMin;
        if (rangeDiff < 20.0) {
            this.yRangeMax = Math.round(this.yRangeMax + (20.0 - rangeDiff) / 2.0);
            this.yRangeMin = Math.round(this.yRangeMin - (20.0 - rangeDiff) / 2.0);
        }
        this.xAxis = this.xyGraph.getPrimaryXAxis();
        this.yAxis = this.xyGraph.getPrimaryYAxis();
        this.xAxis.setRange(this.xRangeMin, this.xRangeMax);
        this.yAxis.setRange(this.yRangeMin, this.yRangeMax);
        ArrayList<double[]> pointsList = new ArrayList<double[]>();
        pointsList.add(xs);
        pointsList.add(ys);
        return pointsList;
    }

    public void handleTableXItemChanged(TableItem[] items) {
        int i = 0;
        while (i < this.xArray.size()) {
            this.xArray.set(i, new BigDecimal(items[i].getText(1)));
            this.yArray.set(i, new BigDecimal(items[i].getText(2)));
            ++i;
        }
        this.setTableUpdate();
    }

    public void handleTableYItemChanged(int row, int col, String newValue) {
        this.yArray.set(row, new BigDecimal(newValue));
        this.setTableUpdate();
        DragableCurve curve = this.controlPointDragger.getDragableCurves().get(0);
        curve.currentControlPointIndex = row;
        curve.updateY(Double.parseDouble(newValue));
    }

    public void setTableUpdate() {
        this.oldParamBean = this.paramBean.clone();
        this.paramBean.getValue().setCurrentValue((Object)this.getJsonArrayWithList(this.xArray, this.yArray, this.paramBean.getType()));
        ParamBean newParamBean = this.paramBean.clone();
        EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)this.oldParamBean, (Object)newParamBean);
    }

    public int getColumnIndex(Table table, TableColumn column) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].equals(column)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getTableItemText(Table table, TableItem item) {
        int count = table.getColumnCount();
        String[] strs = new String[count];
        int i = 0;
        while (i < count) {
            strs[i] = item.getText(i);
            ++i;
        }
        return strs;
    }

    public void sort(Table table, TableColumn column, boolean isAscend) {
        int colIndex = this.getColumnIndex(table, column);
        TableItem[] items = table.getItems();
        String strVal1 = "";
        String strVal2 = "";
        int numVal1 = 0;
        int numVal2 = 0;
        int i = 1;
        while (i < items.length) {
            strVal2 = items[i].getText(colIndex);
            if (strVal2.equals("")) break;
            int j = 0;
            while (j < i) {
                strVal1 = items[j].getText(colIndex);
                numVal1 = Integer.valueOf(strVal1);
                numVal2 = Integer.valueOf(strVal2);
                boolean isLessThan = false;
                if (numVal2 < numVal1) {
                    isLessThan = true;
                }
                if (isAscend && isLessThan || !isAscend && !isLessThan) {
                    String[] values = this.getTableItemText(table, items[i]);
                    Object obj = items[i].getData();
                    items[i].dispose();
                    TableItem item = new TableItem(table, 0, j);
                    item.setText(values);
                    item.setData(obj);
                    items = table.getItems();
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setPointsToTable() {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        int i = 0;
        while (i < this.xArray.size()) {
            TableItem item = new TableItem(this.table, 0x1000000);
            BigDecimal xVal = this.xArray.get(i);
            BigDecimal yVal = this.yArray.get(i);
            item.setText(0, String.valueOf(i));
            item.setBackground(0, new Color((Device)item.getDisplay(), 200, 200, 200));
            item.setText(1, String.valueOf(xVal));
            item.setText(2, String.valueOf(yVal));
            ++i;
        }
    }

    private JSONArray getJsonArrayWithPoints(double[] xs, double[] ys, String type) {
        JSONArray valueJsonArray = new JSONArray();
        if (type.equals("tableCurve")) {
            int d = this.combo.getSelectionIndex();
            valueJsonArray = (JSONArray)this.paramBean.getValue().getValue();
            JSONArray dArray = new JSONArray();
            int i = 0;
            while (i < xs.length) {
                Double y = ys[i];
                BigDecimal curvey = new BigDecimal(y.toString()).setScale((int)this.paramBean.getValue().getDecimals(), 1);
                dArray.add((Object)curvey);
                ++i;
            }
            valueJsonArray.put(d, (Object)dArray);
        } else {
            int i = 0;
            while (i < xs.length) {
                Double x = xs[i];
                Double y = ys[i];
                BigDecimal curvex = new BigDecimal(x.toString()).setScale((int)this.paramBean.getValue().getDecimals(), 1);
                BigDecimal curvey = new BigDecimal(y.toString()).setScale((int)this.paramBean.getValue().getDecimals(), 1);
                if (type.equals("curveY")) {
                    valueJsonArray.add((Object)curvey);
                } else if (type.equals("curve")) {
                    JSONArray pointArray = new JSONArray();
                    pointArray.add((Object)curvex);
                    pointArray.add((Object)curvey);
                    valueJsonArray.add((Object)pointArray);
                }
                ++i;
            }
        }
        return valueJsonArray;
    }

    private JSONArray getJsonArrayWithList(List<BigDecimal> xArray, List<BigDecimal> yArray, String type) {
        JSONArray valueJsonArray = new JSONArray();
        if (type.equals("tableCurve")) {
            int d = this.combo.getSelectionIndex();
            valueJsonArray = (JSONArray)this.paramBean.getValue().getValue();
            JSONArray dArray = new JSONArray();
            int i = 0;
            while (i < xArray.size()) {
                dArray.add((Object)yArray.get(i));
                ++i;
            }
            valueJsonArray.put(d, (Object)dArray);
        } else {
            int i = 0;
            while (i < xArray.size()) {
                if (type.equals("curveY")) {
                    valueJsonArray.add((Object)yArray.get(i));
                } else if (type.equals("curve")) {
                    JSONArray pointArray = new JSONArray();
                    pointArray.add((Object)xArray.get(i));
                    pointArray.add((Object)yArray.get(i));
                    valueJsonArray.add((Object)pointArray);
                }
                ++i;
            }
        }
        return valueJsonArray;
    }

    private class ControlPointDragger
    extends MouseMotionListener.Stub
    implements MouseListener {
        private List<DragableCurve> dragableCurves = new ArrayList<DragableCurve>();
        private DragableCurve currentDragingCurve;
        private Boolean armed = false;
        private int plotTopY;
        private int plotBottomY;

        public List<DragableCurve> getDragableCurves() {
            return this.dragableCurves;
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (!LineChart.this.editable) {
                return;
            }
            for (DragableCurve dragableCurve : this.dragableCurves) {
                int validDistance = 10;
                double minDistance = -1.0;
                int nn_index = -1;
                int i = 0;
                while (i < dragableCurve.controlPointOrigIndexes.size()) {
                    double distance = Math.pow(Math.abs(LineChart.this.xAxis.getValuePosition(dragableCurve.controlPointXs.get(i).doubleValue(), false) - me.x), 2.0);
                    if (minDistance < 0.0) {
                        nn_index = i;
                        minDistance = distance;
                    } else {
                        nn_index = distance < minDistance ? i : nn_index;
                        minDistance = distance < minDistance ? distance : minDistance;
                    }
                    ++i;
                }
                dragableCurve.currentControlPointIndex = nn_index;
                this.armed = minDistance < (double)validDistance;
                if (!this.armed.booleanValue()) continue;
                this.plotTopY = LineChart.this.xyGraph.getPlotArea().getBounds().y;
                this.plotBottomY = this.plotTopY + LineChart.this.xyGraph.getPlotArea().getBounds().height;
                this.currentDragingCurve = dragableCurve;
                LineChart.this.oldParamBean = LineChart.this.paramBean.clone();
                break;
            }
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            if (!this.armed.booleanValue()) {
                return;
            }
            LineChart.this.paramBean.getValue().setCurrentValue((Object)LineChart.this.getJsonArrayWithPoints(this.currentDragingCurve.xs, this.currentDragingCurve.ys, LineChart.this.paramBean.getType()));
            ParamBean newParamBean = LineChart.this.paramBean.clone();
            EventManager.getInstance().notifyEvent("EVENT_PARAM_VALUE_CHANGED", (Object)LineChart.this.oldParamBean, (Object)newParamBean);
            this.armed = false;
            this.currentDragingCurve.currentControlPointIndex = -1;
            me.consume();
        }

        public void mouseDragged(MouseEvent me) {
            if (!LineChart.this.editable) {
                return;
            }
            if (!this.armed.booleanValue()) {
                return;
            }
            if (this.currentDragingCurve.currentControlPointIndex < 0) {
                return;
            }
            if (me.y < this.plotTopY || me.y > this.plotBottomY) {
                return;
            }
            double y = LineChart.this.yAxis.getPositionValue(me.y, false);
            if (LineChart.this.paramBean.getValue().getMax() != null && y > LineChart.this.paramBean.getValue().getMax().doubleValue()) {
                y = LineChart.this.paramBean.getValue().getMax().doubleValue();
            }
            if (LineChart.this.paramBean.getValue().getMin() != null && y < LineChart.this.paramBean.getValue().getMin().doubleValue()) {
                y = LineChart.this.paramBean.getValue().getMin().doubleValue();
            }
            this.currentDragingCurve.updateY(y);
            int decimal = LineChart.this.paramBean.getValue().getDecimals() == null ? 0 : LineChart.this.paramBean.getValue().getDecimals();
            BigDecimal newValue = new BigDecimal(y).setScale(decimal, 1);
            LineChart.this.table.getItem(this.currentDragingCurve.currentControlPointIndex.intValue()).setText(2, String.valueOf(newValue));
            LineChart.this.table.setSelection(this.currentDragingCurve.currentControlPointIndex.intValue());
            LineChart.this.yArray.set(this.currentDragingCurve.currentControlPointIndex, newValue);
            me.consume();
        }
    }

    private class DragableCurve {
        protected CircularBufferDataProvider traceDataProvider;
        public List<Double> controlPointXs;
        public List<Double> controlPointYs;
        public List<Integer> controlPointOrigIndexes;
        private Integer currentControlPointIndex = -1;
        protected double[] xs;
        protected double[] ys;

        public DragableCurve(IXYGraph xyGraph, double[] xs, double[] ys) {
            this.xs = xs;
            this.ys = ys;
            this.traceDataProvider = new CircularBufferDataProvider(false);
            this.traceDataProvider.setUpdateMode(CircularBufferDataProvider.UpdateMode.Y);
            this.traceDataProvider.setBufferSize(xs.length);
            this.traceDataProvider.setCurrentXDataArray(xs);
            this.traceDataProvider.setCurrentYDataArray(ys);
            Trace trace = new Trace("Trace1-XY Plot", LineChart.this.xAxis, LineChart.this.yAxis, (IDataProvider)this.traceDataProvider);
            this.traceDataProvider.addDataProviderListener((IDataProviderListener)trace);
            trace.setPointStyle(Trace.PointStyle.POINT);
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setLineWidth(2);
            trace.setPointSize(6);
            trace.setAntiAliasing(true);
            xyGraph.addTrace(trace);
            int xsNum = xs.length;
            this.controlPointOrigIndexes = new ArrayList<Integer>();
            this.controlPointXs = new ArrayList<Double>();
            this.controlPointYs = new ArrayList<Double>();
            int i = 0;
            while (i < xsNum) {
                this.controlPointXs.add(xs[i]);
                this.controlPointYs.add(ys[i]);
                this.controlPointOrigIndexes.add(i);
                ++i;
            }
        }

        public void updateY(double value) {
            int index = this.controlPointOrigIndexes.get(this.currentControlPointIndex);
            this.ys[index] = value;
            this.traceDataProvider.setCurrentYDataArray(this.ys);
            this.controlPointYs.set(this.currentControlPointIndex, value);
        }

        public void updateCurve(double[] xs, double[] ys) {
            this.traceDataProvider.setCurrentXDataArray(xs);
            this.traceDataProvider.setCurrentYDataArray(ys);
            this.controlPointOrigIndexes = new ArrayList<Integer>();
            this.controlPointXs = new ArrayList<Double>();
            this.controlPointYs = new ArrayList<Double>();
            int i = 0;
            while (i < xs.length) {
                this.controlPointXs.add(xs[i]);
                this.controlPointYs.add(ys[i]);
                this.controlPointOrigIndexes.add(i);
                ++i;
            }
        }
    }
}

