/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.chart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Legend;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ZoomType;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

class DcTest {
    public DcTest() {
        Shell shell = new Shell();
        shell.setSize(300, 250);
        shell.open();
        ToolbarArmedXYGraph toolbarArmedXYGraph = DcTest.createXYGraph();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        lws.setContents((IFigure)toolbarArmedXYGraph);
        shell.setText("Comprehensive Example");
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static ToolbarArmedXYGraph createXYGraph() {
        XYGraph xyGraph = new XYGraph();
        xyGraph.setTitle("XY Graph Test");
        xyGraph.setFont(XYGraphMediaFactory.getInstance().getFont(XYGraphMediaFactory.FONT_TAHOMA));
        xyGraph.getPrimaryXAxis().setTitle("Time");
        xyGraph.getPrimaryYAxis().setTitle("Amplitude");
        xyGraph.getPrimaryXAxis().setRange(new Range(0.0, 200.0));
        xyGraph.getPrimaryXAxis().setDateEnabled(true);
        xyGraph.getPrimaryYAxis().setAutoScale(true);
        xyGraph.getPrimaryXAxis().setAutoScale(true);
        xyGraph.getPrimaryXAxis().setShowMajorGrid(true);
        xyGraph.getPrimaryYAxis().setShowMajorGrid(true);
        xyGraph.getPrimaryXAxis().setAutoScaleThreshold(0.0);
        ToolbarArmedXYGraph toolbarArmedXYGraph = new ToolbarArmedXYGraph((IXYGraph)xyGraph);
        xyGraph.setFocusTraversable(true);
        xyGraph.setRequestFocusEnabled(true);
        xyGraph.getPlotArea().addMouseListener((MouseListener)new MouseListener.Stub((IXYGraph)xyGraph){
            private final /* synthetic */ IXYGraph val$xyGraph;
            {
                this.val$xyGraph = iXYGraph;
            }

            public void mousePressed(MouseEvent me) {
                this.val$xyGraph.requestFocus();
            }
        });
        xyGraph.addKeyListener((KeyListener)new KeyListener.Stub((IXYGraph)xyGraph){
            private final /* synthetic */ IXYGraph val$xyGraph;
            {
                this.val$xyGraph = iXYGraph;
            }

            public void keyPressed(KeyEvent ke) {
                if (ke.getState() == 262144 && ke.keycode == 122) {
                    this.val$xyGraph.getOperationsManager().undo();
                }
                if (ke.getState() == 262144 && ke.keycode == 121) {
                    this.val$xyGraph.getOperationsManager().redo();
                }
                if (ke.getState() == 262144 && ke.keycode == 120) {
                    this.val$xyGraph.performAutoScale();
                }
                if (ke.getState() == 262144 && ke.keycode == 115) {
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{this.val$xyGraph.getImage().getImageData()};
                    FileDialog dialog = new FileDialog(Display.getDefault().getShells()[0], 8192);
                    dialog.setFilterNames(new String[]{"PNG Files", "All Files (*.*)"});
                    dialog.setFilterExtensions(new String[]{"*.png", "*.*"});
                    String path = dialog.open();
                    if (path != null && !path.equals("")) {
                        loader.save(path, 5);
                    }
                }
                if (ke.getState() == 262144 && ke.keycode + 97 - 97 == 116) {
                    switch (this.val$xyGraph.getZoomType()) {
                        case RUBBERBAND_ZOOM: {
                            this.val$xyGraph.setZoomType(ZoomType.HORIZONTAL_ZOOM);
                            break;
                        }
                        case HORIZONTAL_ZOOM: {
                            this.val$xyGraph.setZoomType(ZoomType.VERTICAL_ZOOM);
                            break;
                        }
                        case VERTICAL_ZOOM: {
                            this.val$xyGraph.setZoomType(ZoomType.ZOOM_IN);
                            break;
                        }
                        case ZOOM_IN: {
                            this.val$xyGraph.setZoomType(ZoomType.ZOOM_OUT);
                            break;
                        }
                        case ZOOM_OUT: {
                            this.val$xyGraph.setZoomType(ZoomType.PANNING);
                            break;
                        }
                        case PANNING: {
                            this.val$xyGraph.setZoomType(ZoomType.NONE);
                            break;
                        }
                        case NONE: {
                            this.val$xyGraph.setZoomType(ZoomType.RUBBERBAND_ZOOM);
                            break;
                        }
                    }
                }
            }
        });
        CircularBufferDataProvider traceProvider = new CircularBufferDataProvider(true);
        traceProvider.setBufferSize(100);
        traceProvider.setUpdateDelay(100);
        Trace trace = new Trace("COS", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), (IDataProvider)traceProvider);
        trace.setDataProvider((IDataProvider)traceProvider);
        trace.setTraceType(Trace.TraceType.SOLID_LINE);
        trace.setLineWidth(1);
        trace.setPointStyle(Trace.PointStyle.POINT);
        trace.setPointSize(4);
        trace.setBaseLine(Trace.BaseLine.NEGATIVE_INFINITY);
        trace.setAreaAlpha(100);
        trace.setAntiAliasing(true);
        trace.setErrorBarEnabled(true);
        trace.setDrawYErrorInArea(true);
        trace.setYErrorBarType(Trace.ErrorBarType.BOTH);
        trace.setXErrorBarType(Trace.ErrorBarType.NONE);
        trace.setErrorBarCapWidth(3);
        xyGraph.addTrace(trace);
        CircularBufferDataProvider trace2Provider = new CircularBufferDataProvider(true);
        Trace trace2 = new Trace("SIN", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), (IDataProvider)trace2Provider);
        trace2.setPointStyle(Trace.PointStyle.XCROSS);
        trace2.setTraceType(Trace.TraceType.SOLID_LINE);
        trace2.setLineWidth(1);
        trace2.setPointSize(4);
        trace2Provider.setUpdateDelay(100);
        xyGraph.addTrace(trace2);
        CircularBufferDataProvider trace3Provider = new CircularBufferDataProvider(true);
        Trace trace3 = new Trace("COS - SIN", xyGraph.getPrimaryXAxis(), xyGraph.getPrimaryYAxis(), (IDataProvider)trace3Provider);
        trace3.setPointStyle(Trace.PointStyle.NONE);
        trace3.setTraceType(Trace.TraceType.BAR);
        trace3.setLineWidth(8);
        trace3.setPointSize(4);
        trace3Provider.setUpdateDelay(100);
        xyGraph.addTrace(trace3);
        Font LEGEND_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Lucida Sans", 11, 1));
        Legend legend = xyGraph.getLegend(trace);
        legend.setDrawBorder(true);
        legend.setPreferredHeight(20);
        legend.setTextFont(LEGEND_FONT);
        Runnable updater = new Runnable(){
            private double updateIndex = 0.0;
            private long t = System.currentTimeMillis();
            private boolean running = true;

            @Override
            public void run() {
                this.t += 1000L;
                traceProvider.setCurrentYData(Math.cos(this.updateIndex), this.t);
                traceProvider.setCurrentYDataTimestamp(this.t);
                trace2Provider.setCurrentYData(Math.sin(this.updateIndex), this.t);
                trace3Provider.setCurrentYData(Math.cos(this.updateIndex) - Math.sin(this.updateIndex), this.t);
                this.updateIndex += 0.1;
                if (this.running) {
                    Display.getCurrent().timerExec(1, (Runnable)this);
                }
            }
        };
        Display.getCurrent().timerExec(1000, updater);
        return toolbarArmedXYGraph;
    }

    public static void main(String[] args) {
        new DcTest();
    }
}

