/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.chart;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.ToDoubleFunction;
import javax.imageio.ImageIO;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.Annotation;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Legend;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class AwbStatistic {
    private BigDecimal x0 = new BigDecimal(0.8);
    private BigDecimal xn = new BigDecimal(2.4);
    private BigDecimal step = new BigDecimal(0.01);
    private int size = 160;
    private Table table;
    private IXYGraph xyGraph;
    private double[] R;
    private double[] G;
    private double[] B;
    private double[] RG;
    private double[] BG;
    private double[] luma_data;
    private double[][] wp;
    private int[] gridWidth;
    private int[] gridHeight;
    private List<Integer> oldIndex = new ArrayList<Integer>();
    private Scalar scalar1 = new Scalar(0.0, 0.0, 0.0, 0.0);
    private Scalar scalar2 = new Scalar(0.0, 0.0, 255.0, 200.0);
    private double[] x;
    private double[] y;
    private String[] xNames;
    private JSONArray globals;
    private JSONArray illumination;
    private int[] selectZone;
    private String[] rowNames = new String[]{"R", "G", "B"};
    private List<Double> outWpX;
    private List<Double> outWpY;
    private List<Double> innWpX;
    private List<Double> innWpY;
    private double validRSum = 0.0;
    private double validGSum = 0.0;
    private double validBSum = 0.0;
    private double validWpNum = 0.0;
    private String filePath;
    private String fileName;
    private int blockSize = 32;
    private Combo selectCombo;
    private Shell showImageShell;
    private Shell chartShell;

    public void sort(double[] x, double[] y, String[] name) {
        int i = 0;
        while (i < x.length - 1) {
            int j = i + 1;
            while (j < x.length) {
                if (x[i] > x[j]) {
                    double tempX = x[i];
                    double tempY = y[i];
                    String tempName = name[i];
                    x[i] = x[j];
                    x[j] = tempX;
                    y[i] = y[j];
                    y[j] = tempY;
                    name[i] = name[j];
                    name[j] = tempName;
                }
                ++j;
            }
            ++i;
        }
        this.x = x;
        this.y = y;
        this.xNames = name;
    }

    public AwbStatistic(JSONArray globals, JSONArray illumination) {
        this.globals = globals;
        this.illumination = illumination;
        int illuNum = illumination.size();
        this.xNames = new String[illuNum];
        this.x = new double[illuNum];
        this.y = new double[illuNum];
        int i = 0;
        while (i < illuNum) {
            this.xNames[i] = illumination.getJSONObject((Object)i).getStr((Object)"name");
            JSONArray t = JSONUtil.parseArray((String)illumination.getJSONObject((Object)i).getStr((Object)"manualWB"));
            this.x[i] = t.getBigDecimal((Object)0).doubleValue();
            this.y[i] = t.getBigDecimal((Object)3).doubleValue();
            ++i;
        }
        this.sort(this.x, this.y, this.xNames);
        new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    try {
                        AwbStatistic.this.loadImg();
                    }
                    catch (Exception e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)e.getMessage());
                                if (AwbStatistic.this.showImageShell != null && !AwbStatistic.this.showImageShell.isDisposed()) {
                                    AwbStatistic.this.showImageShell.dispose();
                                }
                                if (AwbStatistic.this.chartShell != null && !AwbStatistic.this.chartShell.isDisposed()) {
                                    AwbStatistic.this.chartShell.dispose();
                                }
                            }
                        });
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AwbStatistic.this.showImageShell != null && !AwbStatistic.this.showImageShell.isDisposed()) {
                                AwbStatistic.this.showImageShell.dispose();
                            }
                            if (AwbStatistic.this.chartShell != null && !AwbStatistic.this.chartShell.isDisposed()) {
                                AwbStatistic.this.chartShell.dispose();
                            }
                            AwbStatistic.this.selectZone = null;
                            AwbStatistic.this.chartShell = new Shell();
                            AwbStatistic.this.chartShell.setSize(1000, 550);
                            AwbStatistic.this.chartShell.setLayout((Layout)new GridLayout(5, true));
                            AwbStatistic.this.chartShell.setLayoutData((Object)new GridData(1808));
                            AwbStatistic.this.show(AwbStatistic.this.chartShell);
                            Mat showImg = AwbStatistic.this.updateImg();
                            AwbStatistic.this.imageShow(showImg);
                        }
                    });
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (AwbStatistic.this.chartShell != null && !AwbStatistic.this.chartShell.isDisposed());
            }
        }).start();
    }

    public void show(Shell shell) {
        Composite tableComposite = new Composite((Composite)shell, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table = new Table(tableComposite, 67588);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        TableColumn itemGlobalColumn = new TableColumn(this.table, 0x1000000);
        itemGlobalColumn.setText("Item");
        TableColumn valueColumn = new TableColumn(this.table, 0x1000000);
        valueColumn.setText("Value");
        this.createTable("Global", this.rowNames);
        this.createTable("SelectZone", this.rowNames);
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int tableWidth = ((AwbStatistic)AwbStatistic.this).table.getClientArea().width;
                TableColumn[] tableColumnArray = AwbStatistic.this.table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    tableColumn.setWidth(tableWidth / AwbStatistic.this.table.getColumnCount());
                    ++n2;
                }
            }
        });
        Composite selectItemComposite = new Composite(tableComposite, 0);
        selectItemComposite.setLayout((Layout)new GridLayout(2, true));
        selectItemComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label selectLable = new Label(selectItemComposite, 0);
        selectLable.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        selectLable.setText("Select Item");
        this.selectCombo = new Combo(selectItemComposite, 0);
        this.selectCombo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int i = 0;
        while (i < this.rowNames.length) {
            this.selectCombo.add(this.rowNames[i]);
            ++i;
        }
        this.selectCombo.select(0);
        this.selectCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Mat showImage = AwbStatistic.this.updateImg();
                AwbStatistic.this.imageShow(showImage);
                AwbStatistic.this.selectZone = null;
                AwbStatistic.this.updateTable("SelectZone");
            }
        });
        this.updateTable("Global");
        this.updateTable("SelectZone");
        Canvas canvas = new Canvas((Composite)shell, 2048);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        shell.open();
        this.xyGraph = this.createXYGraph();
        this.plotWhitePoints();
        LightweightSystem lws = new LightweightSystem(canvas);
        lws.setContents((IFigure)this.xyGraph);
        shell.setText("AWB Tool");
    }

    private void updateTable(String part) {
        if (this.chartShell == null || this.chartShell != null && this.chartShell.isDisposed()) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (this.table.getItem(i).getText(0).equals(part)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return;
        }
        if (part.equals("SelectZone")) {
            if (this.selectZone == null) {
                this.table.getItem(index).setText(1, "");
                this.table.getItem(index + 1).setText(1, "");
                this.table.getItem(index + 2).setText(1, "");
                return;
            }
            this.table.getItem(index).setText(1, String.valueOf(this.R[this.selectZone[0] * this.blockSize + this.selectZone[1]]));
            this.table.getItem(index + 1).setText(1, String.valueOf(this.G[this.selectZone[0] * this.blockSize + this.selectZone[1]]));
            this.table.getItem(index + 2).setText(1, String.valueOf(this.B[this.selectZone[0] * this.blockSize + this.selectZone[1]]));
        }
        if (part.equals("Global")) {
            if (this.validWpNum == 0.0) {
                this.table.getItem(index).setText(1, "");
                this.table.getItem(index + 1).setText(1, "");
                this.table.getItem(index + 2).setText(1, "");
                return;
            }
            this.table.getItem(index).setText(1, String.valueOf(this.validRSum / this.validWpNum));
            this.table.getItem(index + 1).setText(1, String.valueOf(this.validGSum / this.validWpNum));
            this.table.getItem(index + 2).setText(1, String.valueOf(this.validBSum / this.validWpNum));
        }
    }

    private void createTable(String name, String[] rows) {
        TableItem nameItem = new TableItem(this.table, 0);
        nameItem.setText(0, name);
        int i = 0;
        while (i < rows.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, rows[i]);
            item.setText(1, "");
            ++i;
        }
    }

    private IXYGraph createXYGraph() {
        this.xyGraph = new XYGraph();
        this.xyGraph.setTitle("AWB Statistic");
        this.xyGraph.getPrimaryXAxis().setRange(0.0, 5.0);
        this.xyGraph.getPrimaryYAxis().setRange(0.0, 5.0);
        ArrayRealVector Xpoints = new ArrayRealVector(this.x);
        ArrayRealVector Ypoints = new ArrayRealVector(this.y);
        PolynomialCurveFitter fitter1 = PolynomialCurveFitter.create((int)1);
        PolynomialCurveFitter fitter2 = PolynomialCurveFitter.create((int)2);
        WeightedObservedPoints points = new WeightedObservedPoints();
        int i = 0;
        while (i < Xpoints.getDimension()) {
            points.add(Xpoints.getEntry(i), Ypoints.getEntry(i));
            ++i;
        }
        ArrayRealVector coef1 = new ArrayRealVector(fitter1.fit((Collection)points.toList()));
        ArrayRealVector coef2 = new ArrayRealVector(fitter2.fit((Collection)points.toList()));
        ArrayRealVector X = new ArrayRealVector(this.xn.subtract(this.x0).divide(this.step.setScale(2, 4)).setScale(0, 4).intValue() + 1);
        BigDecimal begin = this.x0.setScale(2, 4);
        int index = 0;
        while (begin.compareTo(this.xn) < 0) {
            X.setEntry(index++, begin.doubleValue());
            begin = begin.add(this.step).setScale(2, 4);
        }
        X.setEntry(index++, this.xn.doubleValue());
        ArrayRealVector Y1 = new ArrayRealVector(X.getDimension());
        int i2 = 0;
        while (i2 < Y1.getDimension()) {
            Y1.setEntry(i2, this.calcPoly(X.getEntry(i2), coef1));
            ++i2;
        }
        ArrayRealVector Y = new ArrayRealVector(2);
        Y.setEntry(0, this.calcPoly(X.getMinValue(), coef1));
        Y.setEntry(1, this.calcPoly(X.getMaxValue(), coef1));
        ArrayRealVector n = new ArrayRealVector(2);
        n.setEntry(0, this.scaleDouble(-(Y.getEntry(0) - Y.getEntry(1)), 4));
        n.setEntry(1, this.scaleDouble(this.x0.subtract(this.xn).doubleValue(), 4));
        ArrayRealVector n0 = this.scaleVector((ArrayRealVector)n.mapDivideToSelf(n.getNorm()), 4);
        double d0 = this.scaleDouble(n.dotProduct((RealVector)new ArrayRealVector(new double[]{this.x0.doubleValue(), Y.getEntry(0)})), 4);
        double rg0indoor = Double.valueOf(this.globals.getJSONObject((Object)0).getStr((Object)"fRgProjIndoorMin"));
        double rg1 = Double.valueOf(this.globals.getJSONObject((Object)0).getStr((Object)"fRgProjMax"));
        double rg1_sky = Double.valueOf(this.globals.getJSONObject((Object)0).getStr((Object)"fRgProjMaxSky"));
        JSONArray rgArray1JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afRg1");
        double[] rgArray1 = new double[rgArray1JSON.size()];
        int i3 = 0;
        while (i3 < rgArray1JSON.size()) {
            rgArray1[i3] = rgArray1JSON.getDouble((Object)i3);
            ++i3;
        }
        JSONArray maxDisArray1JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afMaxDist1");
        double[] maxDisArray1 = new double[maxDisArray1JSON.size()];
        int i4 = 0;
        while (i4 < maxDisArray1JSON.size()) {
            maxDisArray1[i4] = maxDisArray1JSON.getDouble((Object)i4);
            ++i4;
        }
        JSONArray rgArray2JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afRg2");
        double[] rgArray2 = new double[rgArray2JSON.size()];
        int i5 = 0;
        while (i5 < rgArray2JSON.size()) {
            rgArray2[i5] = rgArray2JSON.getDouble((Object)i5);
            ++i5;
        }
        JSONArray maxDisArray2JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afMaxDist2");
        double[] maxDisArray2 = new double[maxDisArray2JSON.size()];
        int i6 = 0;
        while (i6 < maxDisArray2JSON.size()) {
            maxDisArray2[i6] = maxDisArray2JSON.getDouble((Object)i6);
            ++i6;
        }
        rgArray1 = this.scaleDoubleArray(rgArray1, 4);
        maxDisArray1 = this.scaleDoubleArray(maxDisArray1, 4);
        rgArray2 = this.scaleDoubleArray(rgArray2, 4);
        maxDisArray2 = this.scaleDoubleArray(maxDisArray2, 4);
        this.plotRegionPolygon(rgArray1, maxDisArray1, rgArray2, maxDisArray2, rg0indoor, rg1, coef1, n0, 2, "innerBounds");
        JSONArray fadeArray21JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afGlobalFade1");
        double[] fadeArray21 = new double[fadeArray21JSON.size()];
        int i7 = 0;
        while (i7 < fadeArray21JSON.size()) {
            fadeArray21[i7] = fadeArray21JSON.getDouble((Object)i7);
            ++i7;
        }
        JSONArray globalGainDistanceArray1JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afGlobalGainDistance1");
        double[] globalGainDistanceArray1 = new double[globalGainDistanceArray1JSON.size()];
        int i8 = 0;
        while (i8 < globalGainDistanceArray1JSON.size()) {
            globalGainDistanceArray1[i8] = globalGainDistanceArray1JSON.getDouble((Object)i8);
            ++i8;
        }
        JSONArray fadeArray22JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afGlobalFade2");
        double[] fadeArray22 = new double[fadeArray22JSON.size()];
        int i9 = 0;
        while (i9 < fadeArray22JSON.size()) {
            fadeArray22[i9] = fadeArray22JSON.getDouble((Object)i9);
            ++i9;
        }
        JSONArray globalGainDistanceArray2JSON = this.globals.getJSONObject((Object)0).getJSONArray((Object)"afGlobalGainDistance2");
        double[] globalGainDistanceArray2 = new double[globalGainDistanceArray2JSON.size()];
        int i10 = 0;
        while (i10 < globalGainDistanceArray2JSON.size()) {
            globalGainDistanceArray2[i10] = globalGainDistanceArray2JSON.getDouble((Object)i10);
            ++i10;
        }
        this.plotRegionPolygon(fadeArray21, globalGainDistanceArray1, fadeArray22, globalGainDistanceArray2, fadeArray21[0], rg1_sky, coef1, n0, 1, "outterBounds");
        i10 = 0;
        while (i10 < this.x.length) {
            Annotation lAnnotation = new Annotation(this.xNames[i10], this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis());
            lAnnotation.setValues(this.x[i10], this.y[i10]);
            lAnnotation.setEnabled(false);
            lAnnotation.setShowPosition(false);
            lAnnotation.setShowName(true);
            lAnnotation.setShowSampleInfo(false);
            lAnnotation.setAnnotationColor(ColorConstants.lightBlue);
            this.xyGraph.addAnnotation(lAnnotation);
            ++i10;
        }
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        Trace trace = new Trace("illuProfiles", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setTraceType(Trace.TraceType.POINT);
        traceDataProvider.setBufferSize(this.size * 2);
        traceDataProvider.setCurrentXDataArray(this.x);
        traceDataProvider.setCurrentYDataArray(this.y);
        trace.setDataProvider((IDataProvider)traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.POINT);
        trace.setPointSize(10);
        this.xyGraph.addTrace(trace);
        CircularBufferDataProvider tp1 = new CircularBufferDataProvider(false);
        Trace trace1 = new Trace("pGain1", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tp1);
        tp1.setBufferSize(this.size * 2);
        tp1.setCurrentXDataArray(X.toArray());
        tp1.setCurrentYDataArray(Y1.toArray());
        this.xyGraph.addTrace(trace1);
        CircularBufferDataProvider tp2 = new CircularBufferDataProvider(false);
        Trace trace2 = new Trace("pGain2", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tp2);
        tp2.setBufferSize(this.size * 2);
        tp2.setCurrentXDataArray(X.toArray());
        tp2.setCurrentYDataArray(this.calcPoly(X, coef2).toArray());
        this.xyGraph.addTrace(trace2);
        Font LEGEND_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Lucida Sans", 11, 1));
        Legend legend = this.xyGraph.getLegend(trace1);
        legend.setDrawBorder(true);
        legend.setPreferredHeight(100);
        legend.setTextFont(LEGEND_FONT);
        this.calculate(this.x, this.y, n0, d0, fadeArray21, globalGainDistanceArray1, fadeArray22, globalGainDistanceArray2, rg0indoor, rg1);
        return this.xyGraph;
    }

    private double[] getDoubleRatio(int[] arr) {
        ArrayList<Double> ratioList = new ArrayList<Double>();
        NumberFormat instance = NumberFormat.getInstance();
        instance.setMaximumFractionDigits(2);
        double sum = 0.0;
        int i = 0;
        while (i < arr.length) {
            sum += (double)arr[i];
            ++i;
        }
        double ratioSum = 0.0;
        int i2 = 0;
        while (i2 < arr.length) {
            double ratio;
            String ratioStr;
            if (arr.length > 1 && i2 == arr.length - 1) {
                ratioStr = instance.format(1.0 - ratioSum);
                ratio = Double.parseDouble(ratioStr);
                ratioList.add(ratio);
            } else {
                ratioStr = instance.format((double)arr[i2] / sum);
                ratio = Double.parseDouble(ratioStr);
                ratioSum += ratio;
                ratioList.add(ratio);
            }
            ++i2;
        }
        return ratioList.stream().mapToDouble(Double::doubleValue).toArray();
    }

    private double[] linspace(double min, double max, int points) {
        double[] d = new double[points];
        int i = 0;
        while (i < points) {
            d[i] = min + (double)i * (max - min) / (double)(points - 1);
            ++i;
        }
        return d;
    }

    private double calcPoly(double x, ArrayRealVector factor) {
        double y = 0.0;
        int deg = 0;
        while (deg < factor.getDimension()) {
            y += Math.pow(x, deg) * factor.getEntry(deg);
            ++deg;
        }
        return new BigDecimal(y).setScale(4, 4).doubleValue();
    }

    private ArrayRealVector calcPoly(ArrayRealVector x, ArrayRealVector factor) {
        ArrayRealVector result = new ArrayRealVector(x.getDimension());
        int i = 0;
        while (i < result.getDimension()) {
            result.setEntry(i, this.calcPoly(x.getEntry(i), factor));
            ++i;
        }
        return result;
    }

    private double scaleDouble(double x, int scale) {
        return new BigDecimal(x).setScale(scale, 4).doubleValue();
    }

    private double[] scaleDoubleArray(double[] x, int scale) {
        int i = 0;
        while (i < x.length) {
            x[i] = this.scaleDouble(x[i], scale);
            ++i;
        }
        return x;
    }

    private ArrayRealVector scaleVector(ArrayRealVector v, int scale) {
        int i = 0;
        while (i < v.getDimension()) {
            v.setEntry(i, this.scaleDouble(v.getEntry(i), scale));
            ++i;
        }
        return v;
    }

    private ArrayRealVector vectorSqrt(ArrayRealVector v) {
        int i = 0;
        while (i < v.getDimension()) {
            v.setEntry(i, Math.sqrt(v.getEntry(i)));
            ++i;
        }
        return v;
    }

    private double[][] calcGainClippingAlongLocus(ArrayRealVector X, ArrayRealVector pGain, ArrayRealVector n0, double d0, ArrayRealVector pGain2, double lucusWidth, int interpLength) {
        ArrayRealVector Xfine = this.scaleVector(new ArrayRealVector(this.linspace(X.getMinValue(), X.getMaxValue(), 1000)), 4);
        ArrayRealVector Y1fine = this.scaleVector(this.calcPoly(Xfine, pGain), 4);
        ArrayRealVector Y2fine = this.scaleVector(this.calcPoly(Xfine, pGain2), 4);
        ArrayRealVector deltaFine = new ArrayRealVector(1000);
        int i = 0;
        while (i < 1000) {
            ArrayRealVector item1 = new ArrayRealVector(Y2fine.getDimension(), Y1fine.getEntry(i)).subtract((RealVector)Y2fine);
            item1 = item1.ebeMultiply((RealVector)item1);
            ArrayRealVector item2 = new ArrayRealVector(Xfine.getDimension(), Xfine.getEntry(i)).subtract((RealVector)Xfine);
            item2 = item2.ebeMultiply((RealVector)item2);
            ArrayRealVector d = this.scaleVector(this.vectorSqrt(item1.add((RealVector)item2)), 4);
            double z = d.getMinValue();
            int ind = d.getMinIndex();
            double item3 = new ArrayRealVector(new double[]{Xfine.getEntry(ind), Y2fine.getEntry(ind)}).dotProduct((RealVector)n0) - d0;
            int sgn = item3 > 0.0 ? 1 : (item3 == 0.0 ? 0 : -1);
            deltaFine.setEntry(i, (double)sgn * z);
            ++i;
        }
        ArrayRealVector coarse = this.scaleVector(new ArrayRealVector(this.linspace(0.0, 999.0, interpLength)), 0);
        ArrayRealVector deltaCoarse = new ArrayRealVector(interpLength);
        int i2 = 0;
        while (i2 < deltaCoarse.getDimension()) {
            deltaCoarse.setEntry(i2, deltaFine.getEntry((int)coarse.getEntry(i2)));
            ++i2;
        }
        ArrayRealVector rgArray1 = this.scaleVector(new ArrayRealVector(this.linspace(X.getEntry(0), X.getEntry(1), interpLength)), 4);
        ArrayRealVector rgArray2 = rgArray1.copy();
        ArrayRealVector maxDisArray2 = (ArrayRealVector)deltaCoarse.copy().mapMultiplyToSelf(-1.0).mapAddToSelf(lucusWidth);
        ArrayRealVector maxDisArray1 = (ArrayRealVector)deltaCoarse.copy().mapAddToSelf(lucusWidth);
        double[][] result = new double[][]{rgArray1.toArray(), maxDisArray1.toArray(), rgArray2.toArray(), maxDisArray2.toArray()};
        return result;
    }

    private Array2DRowRealMatrix vecToMat(ArrayRealVector v) {
        return new Array2DRowRealMatrix((double[][])new double[][]{v.toArray()});
    }

    private Path2D plotRegionPolygon(double[] fadeArray1, double[] distanceArray1, double[] fadeArray2, double[] distanceArray2, double rg0, double rg1, ArrayRealVector pGain, ArrayRealVector n0, int flag, String name) {
        ArrayRealVector pStart = new ArrayRealVector(new double[]{rg0, this.scaleDouble(this.calcPoly(rg0, pGain), 4)});
        ArrayRealVector pEnd = new ArrayRealVector(new double[]{rg1, this.scaleDouble(this.calcPoly(rg1, pGain), 4)});
        ArrayRealVector rgRange = new ArrayRealVector((int)this.scaleDouble((rg1 - rg0) / 0.001, 4) + 1);
        int index = 0;
        double i = rg0;
        while (i <= rg1) {
            rgRange.setEntry(index++, i);
            i = this.scaleDouble(i + 0.001, 4);
        }
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf1 = li.interpolate(fadeArray1, distanceArray1);
        PolynomialSplineFunction psf2 = li.interpolate(fadeArray2, distanceArray2);
        ArrayRealVector maxDist1 = new ArrayRealVector(new double[rgRange.getDimension()]);
        ArrayRealVector maxDist2 = new ArrayRealVector(new double[rgRange.getDimension()]);
        int i2 = 0;
        while (i2 < rgRange.getDimension()) {
            maxDist1.setEntry(i2, this.scaleDouble(psf1.value(this.scaleDouble(rgRange.getEntry(i2), 4)), 4));
            maxDist2.setEntry(i2, this.scaleDouble(psf2.value(this.scaleDouble(rgRange.getEntry(i2), 4)), 4));
            ++i2;
        }
        this.scaleVector((ArrayRealVector)n0.copy().mapMultiplyToSelf(maxDist1.getEntry(0)).add((RealVector)pStart), 4);
        this.scaleVector((ArrayRealVector)n0.copy().mapMultiplyToSelf(maxDist1.getEntry(0) * -1.0).add((RealVector)pStart), 4);
        this.scaleVector((ArrayRealVector)n0.copy().mapMultiplyToSelf(maxDist1.getEntry(maxDist1.getMaxIndex())).add((RealVector)pEnd), 4);
        this.scaleVector((ArrayRealVector)n0.copy().mapMultiplyToSelf(maxDist1.getEntry(maxDist1.getMaxIndex()) * -1.0).add((RealVector)pEnd), 4);
        Array2DRowRealMatrix pStart0 = new Array2DRowRealMatrix(rgRange.getDimension(), 2);
        pStart0.setColumnMatrix(0, this.vecToMat(rgRange).transpose());
        pStart0.setColumnMatrix(1, this.vecToMat(this.calcPoly(rgRange, pGain)).transpose());
        Array2DRowRealMatrix x1 = (Array2DRowRealMatrix)this.vecToMat(maxDist1).transpose().multiply((RealMatrix)this.vecToMat(n0)).add((RealMatrix)pStart0);
        Array2DRowRealMatrix x2 = (Array2DRowRealMatrix)this.vecToMat((ArrayRealVector)maxDist2.copy().mapMultiplyToSelf(-1.0)).transpose().multiply((RealMatrix)this.vecToMat(n0)).add((RealMatrix)pStart0);
        double[] xData = new double[x1.getRowDimension() + x2.getRowDimension() + 1];
        double[] yData = new double[xData.length];
        assert (x1.getRowDimension() == x2.getRowDimension());
        int i3 = 0;
        while (i3 < x1.getRowDimension()) {
            xData[i3] = x1.getColumn(0)[i3];
            yData[i3] = x1.getColumn(1)[i3];
            xData[i3 + x1.getRowDimension()] = x2.getColumn(0)[x2.getRowDimension() - 1 - i3];
            yData[i3 + x1.getRowDimension()] = x2.getColumn(1)[x2.getRowDimension() - 1 - i3];
            ++i3;
        }
        xData[x1.getRowDimension() + x2.getRowDimension()] = xData[0];
        yData[x1.getRowDimension() + x2.getRowDimension()] = yData[0];
        Path2D.Double path = new Path2D.Double();
        int i4 = 0;
        while (i4 < xData.length - 1) {
            if (i4 == 0) {
                ((Path2D)path).moveTo(xData[0], yData[0]);
            } else {
                ((Path2D)path).lineTo(xData[i4], yData[i4]);
            }
            ++i4;
        }
        path.closePath();
        CircularBufferDataProvider tp = new CircularBufferDataProvider(false);
        Trace trace = new Trace(name, this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tp);
        tp.setBufferSize(xData.length);
        tp.setCurrentXDataArray(xData);
        tp.setCurrentYDataArray(yData);
        trace.setPointStyle(Trace.PointStyle.POINT);
        this.xyGraph.addTrace(trace);
        return path;
    }

    private int[] round(double[] array) {
        int[] result = new int[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (int)Math.round(array[i]);
            ++i;
        }
        return result;
    }

    private void loadImg() throws Exception {
        List images;
        if (StrUtil.isEmpty((CharSequence)PreviewDialog.getFormat())) {
            throw new Exception("Stream not Started yet");
        }
        String format = PreviewDialog.getFormat();
        String pathType = PreviewDialog.getOutputPath();
        String bayerPattern = PreviewDialog.getOutputBayerPattern();
        int width = PreviewDialog.getWidth();
        int height = PreviewDialog.getHeight();
        String formatMode = PreviewDialog.getformatMode();
        int outputBits = PreviewDialog.getOutputBits();
        int snapNum = 1;
        String tempPath = String.valueOf(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation())) + System.getProperty("file.separator") + "temppics";
        File picsDir = new File(tempPath);
        if (picsDir.exists()) {
            File[] picsFiles;
            File[] fileArray = picsFiles = picsDir.listFiles();
            int n = picsFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            picsDir.delete();
        }
        picsDir.mkdir();
        try {
            this.loadMeanBlock();
            ArrayList<ParamBean> numParams = new ArrayList<ParamBean>();
            ModuleBean outputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Output");
            assert (outputModuleBean != null);
            ParamBean snapNumParamBean = outputModuleBean.findParamBeanByKey("snapshotNumber");
            assert (snapNumParamBean != null);
            snapNumParamBean.getValue().setCurrentValue((Object)snapNum);
            numParams.add(snapNumParamBean);
            ArrayList<ParamBean> fileParams = new ArrayList<ParamBean>();
            ParamBean imageParamBean = new ParamBean("images", "file");
            imageParamBean.setCategory("OPT");
            fileParams.add(imageParamBean);
            images = ModuleDataCenter.getInstance().captureRequest(false, tempPath, format, pathType, bayerPattern, width, height, formatMode, outputBits, snapNum, numParams, fileParams);
            if (images == null) {
                throw new Exception("Fail to Capture an Image");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new Exception("Fail to Capture an Image");
        }
        assert (images.size() == 1);
        int i = 0;
        while (i < images.size()) {
            if (images.get(i) == null) {
                throw new Exception("Fail to Capture an Image");
            }
            assert (((String)images.get(i)).endsWith(".yuv"));
            File temp = new File((String)images.get(i));
            ByteArrayOutputStream os = new ByteArrayOutputStream((int)temp.length());
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(temp));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            byte[] buffer = new byte[1024];
            try {
                while (in.read(buffer) > 0) {
                    os.write(buffer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] yuvByte = os.toByteArray();
            byte[] rgbByte = new byte[width * height * 3];
            switch (format) {
                case "YUV422 Semi-Planar": {
                    ImageFormatConverter.NV162RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV422 Interleaved": {
                    ImageFormatConverter.YUV422I2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV420 Semi-Planar": {
                    ImageFormatConverter.YUV420SP2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV444 Planer": {
                    ImageFormatConverter.YUV444P2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV444 Interleaved": {
                    ImageFormatConverter.YUV444I2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                default: {
                    throw new Exception("Unsupported Image Format: " + format);
                }
            }
            BufferedImage bi = new BufferedImage(width, height, 1);
            bi.setRGB(0, 0, width, height, ImageFormatConverter.rgb24ToPixel((byte[])rgbByte, (int)width, (int)height), 0, width);
            this.fileName = String.valueOf(tempPath) + System.getProperty("file.separator") + "temp" + i + ".jpg";
            File outfile = new File(this.fileName);
            try {
                ImageIO.write((RenderedImage)bi, "jpg", outfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.filePath = tempPath;
            ++i;
        }
        this.gridHeight = this.round(this.linspace(0.0, 100.0, this.blockSize + 1));
        this.gridWidth = this.round(this.linspace(0.0, 100.0, this.blockSize + 1));
    }

    private double[][] whitePointsEvalueate() {
        return null;
    }

    private void loadMeanBlock() {
        JSONObject paramObject = new JSONObject();
        for (ModuleBean moduleBean : ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans()) {
            if (!moduleBean.getShowName().equals("Exposure Statistics")) continue;
            ParamBean paramBean = (ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0);
            paramObject.set("category", (Object)((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getCategory());
            paramObject.set("key", (Object)"statistics");
            String result = ClientHolder.getInstance().sendSyncRequest(paramObject.toString());
            paramBean = (ParamBean)JSONUtil.toBean((String)result, paramBean.getClass());
            JSONObject obj = (JSONObject)paramBean.getValue().getCurrentValue();
            JSONArray arr = obj.getJSONArray((Object)"data");
            List list = arr.toList(Double.class);
            this.luma_data = list.stream().mapToDouble(Double::doubleValue).toArray();
        }
    }

    private Mat updateImg() {
        Mat IWPE = Imgcodecs.imread((String)this.fileName, (int)-1);
        Mat showImg = Imgcodecs.imread((String)this.fileName, (int)1);
        int height = IWPE.rows();
        int width = IWPE.cols();
        int targetChanel = 0;
        if (this.selectCombo == null || this.rowNames[this.selectCombo.getSelectionIndex()].equals("R")) {
            targetChanel = 2;
        } else if (this.rowNames[this.selectCombo.getSelectionIndex()].equals("G")) {
            targetChanel = 1;
        } else if (this.rowNames[this.selectCombo.getSelectionIndex()].equals("B")) {
            targetChanel = 0;
        }
        int i = 0;
        while (i < this.blockSize) {
            int j = 0;
            while (j < this.blockSize) {
                int heightStartIndex = (int)Math.round((double)height * (double)this.gridHeight[i] / 100.0);
                int heightEndIndex = (int)Math.round((double)height * (double)this.gridHeight[i + 1] / 100.0);
                int widthStartIndex = (int)Math.round((double)width * (double)this.gridWidth[j] / 100.0);
                int widthEndIndex = (int)Math.round((double)width * (double)this.gridWidth[j + 1] / 100.0);
                if (heightStartIndex - 1 < 0) {
                    heightStartIndex = 1;
                }
                if (widthStartIndex - 1 < 0) {
                    widthStartIndex = 1;
                }
                Rect rect1 = new Rect(new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1)), new Point((double)widthEndIndex, (double)heightEndIndex));
                Point textPoint = new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1 + rect1.height / 2));
                if (targetChanel == 0) {
                    Imgproc.putText((Mat)showImg, (String)String.valueOf((int)this.B[i * this.blockSize + j]), (Point)textPoint, (int)0, (double)0.5, (Scalar)this.scalar1, (int)1, (int)16, (boolean)false);
                } else if (targetChanel == 1) {
                    Imgproc.putText((Mat)showImg, (String)String.valueOf((int)this.G[i * this.blockSize + j]), (Point)textPoint, (int)0, (double)0.5, (Scalar)this.scalar1, (int)1, (int)16, (boolean)false);
                } else if (targetChanel == 2) {
                    Imgproc.putText((Mat)showImg, (String)String.valueOf((int)this.R[i * this.blockSize + j]), (Point)textPoint, (int)0, (double)0.5, (Scalar)this.scalar1, (int)1, (int)16, (boolean)false);
                }
                Imgproc.rectangle((Mat)showImg, (Rect)rect1, (Scalar)this.scalar1);
                ++j;
            }
            ++i;
        }
        return showImg;
    }

    private int calculate(double[] illuX, double[] illuY, ArrayRealVector n0, double d0, double[] fade1Fade, double[] fade1GainDist, double[] fade2Fade, double[] fade2GainDist, double rgProjIndoorMin, double rgProjMax) {
        this.outWpX = new ArrayList<Double>();
        this.outWpY = new ArrayList<Double>();
        this.innWpX = new ArrayList<Double>();
        this.innWpY = new ArrayList<Double>();
        int[] whitePixels = new int[illuX.length];
        int i = 0;
        while (i < illuX.length) {
            whitePixels[i] = 0;
            ++i;
        }
        int grid = 32;
        this.validRSum = 0.0;
        this.validGSum = 0.0;
        this.validBSum = 0.0;
        this.validWpNum = 0.0;
        List wb_gain = new ArrayList();
        Object gainParam = null;
        for (ModuleBean moduleBean : ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans()) {
            if (!moduleBean.getShowName().equals("White Balance")) continue;
            for (ParamGroupBean paramGroupBean : moduleBean.getParamGroups()) {
                for (ParamBean paramBean : paramGroupBean.getParams()) {
                    if (!paramBean.getShowName().equals("gain")) continue;
                    gainParam = paramBean.clone();
                }
            }
        }
        if (gainParam != null) {
            String response = ModuleDataCenter.getInstance().readParamBean(gainParam);
            JSONArray jsonArray = JSONUtil.parseArray((String)response);
            JSONObject jsonObj = jsonArray.getJSONObject((Object)0);
            gainParam = (ParamBean)jsonObj.toBean(gainParam.getClass());
            wb_gain = (List)gainParam.getValue().getCurrentValue();
        }
        double awb_r = ((BigDecimal)wb_gain.get(0)).doubleValue();
        double awb_gr = ((BigDecimal)wb_gain.get(1)).doubleValue();
        double awb_gb = ((BigDecimal)wb_gain.get(2)).doubleValue();
        double awb_b = ((BigDecimal)wb_gain.get(3)).doubleValue();
        this.R = new double[this.blockSize * this.blockSize];
        this.G = new double[this.blockSize * this.blockSize];
        this.B = new double[this.blockSize * this.blockSize];
        this.RG = new double[this.blockSize * this.blockSize];
        this.BG = new double[this.blockSize * this.blockSize];
        int i2 = 0;
        while (i2 < grid) {
            int j = 0;
            while (j < grid) {
                int index = i2 * this.blockSize + j;
                this.R[index] = this.luma_data[index * 4 + 0] / awb_r;
                this.G[index] = (this.luma_data[index * 4 + 1] / awb_gr + this.luma_data[index * 4 + 2] / awb_gb) / 2.0;
                this.B[index] = this.luma_data[index * 4 + 3] / awb_b;
                this.RG[index] = this.R[index] > (double)1.0E-5f ? this.G[index] / this.R[index] : 0.0;
                this.BG[index] = this.B[index] > (double)1.0E-5f ? this.G[index] / this.B[index] : 0.0;
                double cfr_ignored_0 = this.R[index];
                double cfr_ignored_1 = this.G[index];
                double cfr_ignored_2 = this.B[index];
                if (!(this.RG[index] < 1.0 || this.RG[index] >= 4.0 || this.BG[index] < 1.0 || this.BG[index] >= 4.0)) {
                    double distance1 = 0.0;
                    double distance2 = 0.0;
                    double calibRg = n0.getEntry(0);
                    double calibBg = n0.getEntry(1);
                    double substraction = (float)(calibRg * this.RG[index] + calibBg * this.BG[index] - d0);
                    double rgProj = (float)(this.RG[index] - substraction * calibRg);
                    distance1 = this.interpolate(fade1Fade, fade1GainDist, 16, rgProj, distance1);
                    distance2 = this.interpolate(fade2Fade, fade2GainDist, 16, rgProj, distance2);
                    distance2 = -distance2;
                    double w = 1.0;
                    if (substraction > distance1 || substraction < distance2 || rgProj < rgProjIndoorMin || rgProj > rgProjMax) {
                        w = 0.0;
                        this.outWpX.add(this.RG[index]);
                        this.outWpY.add(this.BG[index]);
                    } else {
                        this.validRSum += this.R[index];
                        this.validGSum += this.G[index];
                        this.validBSum += this.B[index];
                        this.validWpNum += 1.0;
                        this.innWpX.add(this.RG[index]);
                        this.innWpY.add(this.BG[index]);
                    }
                    double min_dist = -1.0;
                    int min_index = -1;
                    int k = 0;
                    while (k < illuX.length) {
                        double current_dist = (illuX[k] - this.RG[index]) * (illuX[k] - this.RG[index]) + (illuY[k] - this.BG[index]) * (illuY[k] - this.BG[index]);
                        if (min_dist < 0.0) {
                            min_dist = current_dist;
                            min_index = k;
                        } else if (current_dist < min_dist) {
                            min_dist = current_dist;
                            min_index = k;
                        }
                        ++k;
                    }
                    if (min_index != -1) {
                        int n = min_index;
                        whitePixels[n] = whitePixels[n] + 1;
                    }
                    double cfr_ignored_3 = this.RG[index];
                    double cfr_ignored_4 = this.BG[index];
                }
                ++j;
            }
            ++i2;
        }
        this.updateTable("Global");
        return 0;
    }

    private void plotWhitePoints() {
        if (this.outWpX == null && this.innWpX == null) {
            return;
        }
        if (this.outWpX != null && this.outWpX.size() > 0) {
            CircularBufferDataProvider tpo = new CircularBufferDataProvider(false);
            Trace traceo = new Trace("outer", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tpo);
            tpo.setBufferSize(this.outWpX.size());
            tpo.setCurrentXDataArray(this.outWpX.stream().mapToDouble(Double::doubleValue).toArray());
            tpo.setCurrentYDataArray(this.outWpY.stream().mapToDouble(Double::doubleValue).toArray());
            traceo.setPointStyle(Trace.PointStyle.POINT);
            traceo.setTraceType(Trace.TraceType.POINT);
            this.xyGraph.addTrace(traceo);
        }
        if (this.innWpX != null && this.innWpX.size() > 0) {
            CircularBufferDataProvider tpi = new CircularBufferDataProvider(false);
            Trace tracei = new Trace("inner", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tpi);
            tpi.setBufferSize(this.innWpX.size());
            tpi.setCurrentXDataArray(this.innWpX.stream().mapToDouble(Double::doubleValue).toArray());
            tpi.setCurrentYDataArray(this.innWpY.stream().mapToDouble(Double::doubleValue).toArray());
            tracei.setPointStyle(Trace.PointStyle.POINT);
            tracei.setTraceType(Trace.TraceType.POINT);
            this.xyGraph.addTrace(tracei);
        }
    }

    private double interpolate(double[] vx, double[] vy, int num, double x, double y) {
        if (vx == null || vy == null) {
            return y;
        }
        if (x <= vx[0]) {
            y = vy[0];
            return y;
        }
        if (x >= vx[num - 1]) {
            y = vy[num - 1];
            return y;
        }
        int i = 0;
        while (i < num - 1) {
            if (x >= vx[i] && x < vx[i + 1]) {
                y = (x - vx[i]) * (vy[i + 1] - vy[i]) / (vx[i + 1] - vx[i]) + vy[i];
                break;
            }
            ++i;
        }
        return y;
    }

    /*
     * Unable to fully structure code
     */
    private int[] wpStatisticCalculation(double[] illuX, double[] illuY, double[] wpX, double[] wpY, Path2D pathInner, Path2D pathOuter) {
        whitePixels = new int[illuX.length];
        outWpX = new ArrayList<Double>();
        outWpY = new ArrayList<Double>();
        midWpX = new ArrayList<Double>();
        midWpY = new ArrayList<Double>();
        innWpX = new ArrayList<Double>();
        innWpY = new ArrayList<Double>();
        i = 0;
        while (i < wpX.length) {
            block8: {
                if (!pathInner.contains(wpX[i], wpY[i])) break block8;
                innWpX.add(wpX[i]);
                innWpY.add(wpY[i]);
                ** GOTO lbl27
            }
            if (!pathOuter.contains(wpX[i], wpY[i])) {
                outWpX.add(wpX[i]);
                outWpY.add(wpY[i]);
            } else {
                midWpX.add(wpX[i]);
                midWpY.add(wpY[i]);
lbl27:
                // 2 sources

                distance = -1.0;
                minIndex = -1;
                j = 0;
                while (j < illuX.length) {
                    currentDistance = (illuX[j] - wpX[i]) * (illuX[j] - wpX[i]) + (illuY[j] - wpY[i]) * (illuY[j] - wpY[i]);
                    if (distance < 0.0) {
                        distance = currentDistance;
                        minIndex = j;
                    } else if (currentDistance < distance) {
                        distance = currentDistance;
                        minIndex = j;
                    }
                    ++j;
                }
                if (minIndex >= 0) {
                    v0 = minIndex;
                    whitePixels[v0] = whitePixels[v0] + 1;
                }
            }
            ++i;
        }
        tpo = new CircularBufferDataProvider(false);
        traceo = new Trace("outer", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tpo);
        tpo.setBufferSize(outWpX.size());
        tpo.setCurrentXDataArray(outWpX.stream().mapToDouble((ToDoubleFunction<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, doubleValue(), (Ljava/lang/Double;)D)()).toArray());
        tpo.setCurrentYDataArray(outWpY.stream().mapToDouble((ToDoubleFunction<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, doubleValue(), (Ljava/lang/Double;)D)()).toArray());
        traceo.setPointStyle(Trace.PointStyle.POINT);
        traceo.setTraceType(Trace.TraceType.POINT);
        this.xyGraph.addTrace(traceo);
        tpm = new CircularBufferDataProvider(false);
        tracem = new Trace("mid", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tpm);
        tpm.setBufferSize(midWpX.size());
        tpm.setCurrentXDataArray(midWpX.stream().mapToDouble((ToDoubleFunction<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, doubleValue(), (Ljava/lang/Double;)D)()).toArray());
        tpm.setCurrentYDataArray(midWpY.stream().mapToDouble((ToDoubleFunction<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, doubleValue(), (Ljava/lang/Double;)D)()).toArray());
        tracem.setPointStyle(Trace.PointStyle.POINT);
        tracem.setTraceType(Trace.TraceType.POINT);
        this.xyGraph.addTrace(tracem);
        tpi = new CircularBufferDataProvider(false);
        tracei = new Trace("inner", this.xyGraph.getPrimaryXAxis(), this.xyGraph.getPrimaryYAxis(), (IDataProvider)tpi);
        tpi.setBufferSize(innWpX.size());
        tpi.setCurrentXDataArray(innWpX.stream().mapToDouble((ToDoubleFunction<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, doubleValue(), (Ljava/lang/Double;)D)()).toArray());
        tpi.setCurrentYDataArray(innWpY.stream().mapToDouble((ToDoubleFunction<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, doubleValue(), (Ljava/lang/Double;)D)()).toArray());
        tracei.setPointStyle(Trace.PointStyle.POINT);
        tracei.setTraceType(Trace.TraceType.POINT);
        this.xyGraph.addTrace(tracei);
        return whitePixels;
    }

    private void imageShow(Mat img) {
        String newFileName = String.valueOf(this.filePath) + System.getProperty("file.separator") + "newImg.png";
        Imgcodecs.imwrite((String)newFileName, (Mat)img);
        if (this.showImageShell != null) {
            this.showImageShell.dispose();
        }
        Display display = Display.getDefault();
        this.showImageShell = new Shell(1264);
        Image data = new Image((Device)display, newFileName);
        this.showImageShell.setText(newFileName);
        this.showImageShell.setSize(img.cols(), img.rows());
        this.showImageShell.setLayout((Layout)new FillLayout());
        Canvas cvs = new Canvas((Composite)this.showImageShell, 0x20000000);
        cvs.setData((Object)data);
        cvs.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image image = (Image)cvs.getData();
                e.gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, ((AwbStatistic)AwbStatistic.this).showImageShell.getBounds().width, ((AwbStatistic)AwbStatistic.this).showImageShell.getBounds().height);
            }
        });
        cvs.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int blockWidth = img.cols() / 32;
                int blockHeight = img.rows() / 32;
                int i = e.y / blockHeight;
                int j = e.x / blockWidth;
                if (AwbStatistic.this.selectZone != null && i == AwbStatistic.this.selectZone[0] && j == AwbStatistic.this.selectZone[1]) {
                    AwbStatistic.this.selectZone = null;
                } else {
                    AwbStatistic.this.selectZone = new int[]{i, j};
                }
                AwbStatistic.this.updateTable("SelectZone");
                Mat t = AwbStatistic.this.updateColor(img);
                Imgcodecs.imwrite((String)newFileName, (Mat)t);
                cvs.setData((Object)new Image((Device)display, newFileName));
                cvs.redraw();
                AwbStatistic.this.showImageShell.update();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.showImageShell.open();
        this.showImageShell.layout();
    }

    private Mat updateColor(Mat img) {
        if (!this.oldIndex.isEmpty()) {
            int oldi = this.oldIndex.get(0);
            int oldj = this.oldIndex.get(1);
            int height = img.rows();
            int width = img.cols();
            int heightStartIndex = (int)Math.round((double)height * (double)this.gridHeight[oldi] / 100.0);
            int heightEndIndex = (int)Math.round((double)height * (double)this.gridHeight[oldi + 1] / 100.0);
            int widthStartIndex = (int)Math.round((double)width * (double)this.gridWidth[oldj] / 100.0);
            int widthEndIndex = (int)Math.round((double)width * (double)this.gridWidth[oldj + 1] / 100.0);
            if (heightStartIndex - 1 < 0) {
                heightStartIndex = 1;
            }
            if (widthStartIndex - 1 < 0) {
                widthStartIndex = 1;
            }
            Rect rect1 = new Rect(new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1)), new Point((double)widthEndIndex, (double)heightEndIndex));
            Imgproc.rectangle((Mat)img, (Rect)rect1, (Scalar)this.scalar1);
            this.oldIndex.clear();
        }
        if (this.selectZone != null) {
            int height = img.rows();
            int width = img.cols();
            int heightStartIndex = (int)Math.round((double)height * (double)this.gridHeight[this.selectZone[0]] / 100.0);
            int heightEndIndex = (int)Math.round((double)height * (double)this.gridHeight[this.selectZone[0] + 1] / 100.0);
            int widthStartIndex = (int)Math.round((double)width * (double)this.gridWidth[this.selectZone[1]] / 100.0);
            int widthEndIndex = (int)Math.round((double)width * (double)this.gridWidth[this.selectZone[1] + 1] / 100.0);
            if (heightStartIndex - 1 < 0) {
                heightStartIndex = 1;
            }
            if (widthStartIndex - 1 < 0) {
                widthStartIndex = 1;
            }
            Rect rect1 = new Rect(new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1)), new Point((double)widthEndIndex, (double)heightEndIndex));
            Imgproc.rectangle((Mat)img, (Rect)rect1, (Scalar)this.scalar2);
            this.oldIndex.add(this.selectZone[0]);
            this.oldIndex.add(this.selectZone[1]);
        }
        return img;
    }
}

