/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.chart;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.verisilicon.isp.tuning.core.bean.ModuleBean;
import com.verisilicon.isp.tuning.core.bean.ParamBean;
import com.verisilicon.isp.tuning.core.bean.ParamGroupBean;
import com.verisilicon.isp.tuning.core.model.ModuleDataCenter;
import com.verisilicon.isp.tuning.core.transfer.ClientHolder;
import com.verisilicon.isp.tuning.core.util.ImageFormatConverter;
import com.verisilicon.isp.tuning.ui.view.dialog.PreviewDialog;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class AeStatistic {
    private Table table;
    private String[] rowNames = new String[]{"R", "G", "B"};
    private Shell showImageShell;
    private Shell chartShell;
    private Combo selectCombo;
    private int[] selectZone;
    private XYGraph xyGraph;
    private int[] gridWidth;
    private int[] gridHeight;
    private List<Integer> oldIndex = new ArrayList<Integer>();
    private Scalar scalar1 = new Scalar(0.0, 0.0, 0.0, 0.0);
    private Scalar scalar2 = new Scalar(0.0, 0.0, 255.0, 200.0);
    private String fileName;
    private String filePath;
    private int blockSize = 32;
    private double[] luma_data;
    private double[] R;
    private double[] G;
    private double[] B;
    private double sumR;
    private double sumG;
    private double sumB;

    private double[] linspace(double min, double max, int points) {
        double[] d = new double[points];
        int i = 0;
        while (i < points) {
            d[i] = min + (double)i * (max - min) / (double)(points - 1);
            ++i;
        }
        return d;
    }

    private int[] round(double[] array) {
        int[] result = new int[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (int)Math.round(array[i]);
            ++i;
        }
        return result;
    }

    public AeStatistic() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                do {
                    try {
                        AeStatistic.this.loadImg();
                    }
                    catch (Exception e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)e.getMessage());
                                if (AeStatistic.this.showImageShell != null && !AeStatistic.this.showImageShell.isDisposed()) {
                                    AeStatistic.this.showImageShell.dispose();
                                }
                                if (AeStatistic.this.chartShell != null && !AeStatistic.this.chartShell.isDisposed()) {
                                    AeStatistic.this.chartShell.dispose();
                                }
                            }
                        });
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (AeStatistic.this.showImageShell != null && !AeStatistic.this.showImageShell.isDisposed()) {
                                AeStatistic.this.showImageShell.dispose();
                            }
                            if (AeStatistic.this.chartShell != null && !AeStatistic.this.chartShell.isDisposed()) {
                                AeStatistic.this.chartShell.dispose();
                            }
                            AeStatistic.this.selectZone = null;
                            AeStatistic.this.chartShell = new Shell();
                            AeStatistic.this.chartShell.setSize(1000, 550);
                            AeStatistic.this.chartShell.setLayout((Layout)new GridLayout(5, true));
                            AeStatistic.this.chartShell.setLayoutData((Object)new GridData(1808));
                            AeStatistic.this.show(AeStatistic.this.chartShell);
                            Mat showImg = AeStatistic.this.updateImg();
                            AeStatistic.this.imageShow(showImg);
                        }
                    });
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } while (AeStatistic.this.chartShell != null && !AeStatistic.this.chartShell.isDisposed());
            }
        }).start();
    }

    private void loadImg() throws Exception {
        List images;
        if (StrUtil.isEmpty((CharSequence)PreviewDialog.getFormat())) {
            throw new Exception("Stream not Started yet");
        }
        String format = PreviewDialog.getFormat();
        String pathType = PreviewDialog.getOutputPath();
        String bayerPattern = PreviewDialog.getOutputBayerPattern();
        int width = PreviewDialog.getWidth();
        int height = PreviewDialog.getHeight();
        String formatMode = PreviewDialog.getformatMode();
        int outputBits = PreviewDialog.getOutputBits();
        int snapNum = 1;
        String tempPath = String.valueOf(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation())) + System.getProperty("file.separator") + "temppics";
        File picsDir = new File(tempPath);
        if (picsDir.exists()) {
            File[] picsFiles;
            File[] fileArray = picsFiles = picsDir.listFiles();
            int n = picsFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
            picsDir.delete();
        }
        picsDir.mkdir();
        try {
            this.loadMeanBlock();
            ArrayList<ParamBean> numParams = new ArrayList<ParamBean>();
            ModuleBean outputModuleBean = ModuleDataCenter.getInstance().getModuleBeanByName("Output");
            assert (outputModuleBean != null);
            ParamBean snapNumParamBean = outputModuleBean.findParamBeanByKey("snapshotNumber");
            assert (snapNumParamBean != null);
            snapNumParamBean.getValue().setCurrentValue((Object)snapNum);
            numParams.add(snapNumParamBean);
            ArrayList<ParamBean> fileParams = new ArrayList<ParamBean>();
            ParamBean imageParamBean = new ParamBean("images", "file");
            imageParamBean.setCategory("OPT");
            fileParams.add(imageParamBean);
            images = ModuleDataCenter.getInstance().captureRequest(false, tempPath, format, pathType, bayerPattern, width, height, formatMode, outputBits, snapNum, numParams, fileParams);
            if (images == null) {
                throw new Exception("Fail to Capture an Image");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new Exception("Fail to Capture an Image");
        }
        assert (images.size() == 1);
        int i = 0;
        while (i < images.size()) {
            if (images.get(i) == null) {
                throw new Exception("Fail to Capture an Image");
            }
            assert (((String)images.get(i)).endsWith(".yuv"));
            File temp = new File((String)images.get(i));
            ByteArrayOutputStream os = new ByteArrayOutputStream((int)temp.length());
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(temp));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            byte[] buffer = new byte[1024];
            try {
                while (in.read(buffer) > 0) {
                    os.write(buffer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] yuvByte = os.toByteArray();
            byte[] rgbByte = new byte[width * height * 3];
            switch (format) {
                case "YUV422 Semi-Planar": {
                    ImageFormatConverter.NV162RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV422 Interleaved": {
                    ImageFormatConverter.YUV422I2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV420 Semi-Planar": {
                    ImageFormatConverter.YUV420SP2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV444 Planer": {
                    ImageFormatConverter.YUV444P2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                case "YUV444 Interleaved": {
                    ImageFormatConverter.YUV444I2RGB((byte[])yuvByte, (int)width, (int)height, (byte[])rgbByte);
                    break;
                }
                default: {
                    throw new Exception("Unsupported Image Format: " + format);
                }
            }
            BufferedImage bi = new BufferedImage(width, height, 1);
            bi.setRGB(0, 0, width, height, ImageFormatConverter.rgb24ToPixel((byte[])rgbByte, (int)width, (int)height), 0, width);
            this.fileName = String.valueOf(tempPath) + System.getProperty("file.separator") + "temp" + i + ".jpg";
            File outfile = new File(this.fileName);
            try {
                ImageIO.write((RenderedImage)bi, "jpg", outfile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.filePath = tempPath;
            ++i;
        }
        this.gridHeight = this.round(this.linspace(0.0, 100.0, this.blockSize + 1));
        this.gridWidth = this.round(this.linspace(0.0, 100.0, this.blockSize + 1));
    }

    private void loadMeanBlock() {
        JSONObject paramObject = new JSONObject();
        for (ModuleBean moduleBean : ModuleDataCenter.getInstance().getCurrentTemplateModuleBeans()) {
            if (!moduleBean.getShowName().equals("Exposure Statistics")) continue;
            ParamBean paramBean = (ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0);
            paramObject.set("category", (Object)((ParamBean)((ParamGroupBean)moduleBean.getParamGroups().get(0)).getParams().get(0)).getCategory());
            paramObject.set("key", (Object)"statistics");
            String result = ClientHolder.getInstance().sendSyncRequest(paramObject.toString());
            paramBean = (ParamBean)JSONUtil.toBean((String)result, paramBean.getClass());
            JSONObject obj = (JSONObject)paramBean.getValue().getCurrentValue();
            JSONArray arr = obj.getJSONArray((Object)"data");
            List list = arr.toList(Double.class);
            this.luma_data = list.stream().mapToDouble(Double::doubleValue).toArray();
        }
    }

    private void show(Shell shell) {
        Composite tableComposite = new Composite((Composite)shell, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, true));
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table = new Table(tableComposite, 67588);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(1808));
        TableColumn itemGlobalColumn = new TableColumn(this.table, 0x1000000);
        itemGlobalColumn.setText("Item");
        TableColumn valueColumn = new TableColumn(this.table, 0x1000000);
        valueColumn.setText("Value");
        this.createTable("Global", this.rowNames);
        this.createTable("SelectZone", this.rowNames);
        this.table.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int tableWidth = ((AeStatistic)AeStatistic.this).table.getClientArea().width;
                TableColumn[] tableColumnArray = AeStatistic.this.table.getColumns();
                int n = tableColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    tableColumn.setWidth(tableWidth / AeStatistic.this.table.getColumnCount());
                    ++n2;
                }
            }
        });
        Composite selectItemComposite = new Composite(tableComposite, 0);
        selectItemComposite.setLayout((Layout)new GridLayout(2, true));
        selectItemComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label selectLable = new Label(selectItemComposite, 0);
        selectLable.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        selectLable.setText("Select Item");
        this.selectCombo = new Combo(selectItemComposite, 0);
        this.selectCombo.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int i = 0;
        while (i < this.rowNames.length) {
            this.selectCombo.add(this.rowNames[i]);
            ++i;
        }
        this.selectCombo.select(0);
        this.selectCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                Mat showImage = AeStatistic.this.updateImg();
                AeStatistic.this.imageShow(showImage);
                AeStatistic.this.selectZone = null;
                AeStatistic.this.updateTable("SelectZone");
            }
        });
        this.updateTable("Global");
        this.updateTable("SelectZone");
        Canvas canvas = new Canvas((Composite)shell, 2048);
        canvas.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        shell.open();
        this.xyGraph = this.createXYGraph();
        shell.setText("AE Tool");
    }

    private XYGraph createXYGraph() {
        this.calculate();
        this.updateTable("Global");
        return null;
    }

    private void calculate() {
        this.R = new double[this.blockSize * this.blockSize];
        this.G = new double[this.blockSize * this.blockSize];
        this.B = new double[this.blockSize * this.blockSize];
        int i = 0;
        while (i < this.blockSize) {
            int j = 0;
            while (j < this.blockSize) {
                int index = i * this.blockSize + j;
                this.R[index] = this.luma_data[index * 4 + 0];
                this.G[index] = (this.luma_data[index * 4 + 1] + this.luma_data[index * 4 + 2]) / 2.0;
                this.B[index] = this.luma_data[index * 4 + 3];
                this.sumR += this.R[index];
                this.sumG += this.G[index];
                this.sumB += this.B[index];
                ++j;
            }
            ++i;
        }
    }

    private void createTable(String name, String[] rows) {
        TableItem nameItem = new TableItem(this.table, 0);
        nameItem.setText(0, name);
        int i = 0;
        while (i < rows.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, rows[i]);
            item.setText(1, "");
            ++i;
        }
    }

    private void updateTable(String part) {
        if (this.chartShell == null || this.chartShell != null && this.chartShell.isDisposed()) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (this.table.getItem(i).getText(0).equals(part)) {
                index = i + 1;
                break;
            }
            ++i;
        }
        if (index < 0) {
            return;
        }
        if (part.equals("SelectZone")) {
            if (this.selectZone == null) {
                this.table.getItem(index).setText(1, "");
                this.table.getItem(index + 1).setText(1, "");
                this.table.getItem(index + 2).setText(1, "");
                return;
            }
            int k = this.selectZone[0] * this.blockSize + this.selectZone[1];
            this.table.getItem(index).setText(1, String.valueOf(this.R[k]));
            this.table.getItem(index + 1).setText(1, String.valueOf(this.G[k]));
            this.table.getItem(index + 2).setText(1, String.valueOf(this.B[k]));
        }
        if (part.equals("Global")) {
            if (this.sumR == 0.0 && this.sumG == 0.0 && this.sumB == 0.0) {
                this.table.getItem(index).setText(1, "");
                this.table.getItem(index + 1).setText(1, "");
                this.table.getItem(index + 2).setText(1, "");
                return;
            }
            this.table.getItem(index).setText(1, String.valueOf((int)(this.sumR / (double)this.blockSize / (double)this.blockSize)));
            this.table.getItem(index + 1).setText(1, String.valueOf((int)(this.sumG / (double)this.blockSize / (double)this.blockSize)));
            this.table.getItem(index + 2).setText(1, String.valueOf((int)(this.sumB / (double)this.blockSize / (double)this.blockSize)));
        }
    }

    private Mat updateImg() {
        Mat IWPE = Imgcodecs.imread((String)this.fileName, (int)-1);
        Mat showImg = Imgcodecs.imread((String)this.fileName, (int)1);
        int height = IWPE.rows();
        int width = IWPE.cols();
        int targetChanel = 0;
        if (this.selectCombo == null || this.rowNames[this.selectCombo.getSelectionIndex()].equals("R")) {
            targetChanel = 0;
        } else if (this.rowNames[this.selectCombo.getSelectionIndex()].equals("G")) {
            targetChanel = 1;
        } else if (this.rowNames[this.selectCombo.getSelectionIndex()].equals("B")) {
            targetChanel = 2;
        }
        int i = 0;
        while (i < this.blockSize) {
            int j = 0;
            while (j < this.blockSize) {
                int heightStartIndex = (int)Math.round((double)height * (double)this.gridHeight[i] / 100.0);
                int heightEndIndex = (int)Math.round((double)height * (double)this.gridHeight[i + 1] / 100.0);
                int widthStartIndex = (int)Math.round((double)width * (double)this.gridWidth[j] / 100.0);
                int widthEndIndex = (int)Math.round((double)width * (double)this.gridWidth[j + 1] / 100.0);
                if (heightStartIndex - 1 < 0) {
                    heightStartIndex = 1;
                }
                if (widthStartIndex - 1 < 0) {
                    widthStartIndex = 1;
                }
                Rect rect1 = new Rect(new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1)), new Point((double)widthEndIndex, (double)heightEndIndex));
                Point textPoint = new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1 + rect1.height / 2));
                int index = i * this.blockSize + j;
                if (targetChanel == 0) {
                    Imgproc.putText((Mat)showImg, (String)String.valueOf((int)this.R[index]), (Point)textPoint, (int)0, (double)0.5, (Scalar)this.scalar1, (int)1, (int)16, (boolean)false);
                } else if (targetChanel == 1) {
                    Imgproc.putText((Mat)showImg, (String)String.valueOf((int)this.G[index]), (Point)textPoint, (int)0, (double)0.5, (Scalar)this.scalar1, (int)1, (int)16, (boolean)false);
                } else if (targetChanel == 2) {
                    Imgproc.putText((Mat)showImg, (String)String.valueOf((int)this.B[index]), (Point)textPoint, (int)0, (double)0.5, (Scalar)this.scalar1, (int)1, (int)16, (boolean)false);
                }
                Imgproc.rectangle((Mat)showImg, (Rect)rect1, (Scalar)this.scalar1);
                ++j;
            }
            ++i;
        }
        return showImg;
    }

    private void imageShow(Mat img) {
        String newFileName = String.valueOf(this.filePath) + System.getProperty("file.separator") + "newImg.png";
        Imgcodecs.imwrite((String)newFileName, (Mat)img);
        if (this.showImageShell != null) {
            this.showImageShell.dispose();
        }
        Display display = Display.getDefault();
        this.showImageShell = new Shell(1264);
        Image data = new Image((Device)display, newFileName);
        this.showImageShell.setText(newFileName);
        this.showImageShell.setSize(img.cols(), img.rows());
        this.showImageShell.setLayout((Layout)new FillLayout());
        Canvas cvs = new Canvas((Composite)this.showImageShell, 0x20000000);
        cvs.setData((Object)data);
        cvs.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Image image = (Image)cvs.getData();
                e.gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, ((AeStatistic)AeStatistic.this).showImageShell.getBounds().width, ((AeStatistic)AeStatistic.this).showImageShell.getBounds().height);
            }
        });
        cvs.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int blockWidth = img.cols() / 32;
                int blockHeight = img.rows() / 32;
                int i = e.y / blockHeight;
                int j = e.x / blockWidth;
                if (AeStatistic.this.selectZone != null && i == AeStatistic.this.selectZone[0] && j == AeStatistic.this.selectZone[1]) {
                    AeStatistic.this.selectZone = null;
                } else {
                    AeStatistic.this.selectZone = new int[]{i, j};
                }
                AeStatistic.this.updateTable("SelectZone");
                Mat t = AeStatistic.this.updateColor(img);
                Imgcodecs.imwrite((String)newFileName, (Mat)t);
                cvs.setData((Object)new Image((Device)display, newFileName));
                cvs.redraw();
                AeStatistic.this.showImageShell.update();
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.showImageShell.open();
        this.showImageShell.layout();
    }

    private Mat updateColor(Mat img) {
        if (!this.oldIndex.isEmpty()) {
            int oldi = this.oldIndex.get(0);
            int oldj = this.oldIndex.get(1);
            int height = img.rows();
            int width = img.cols();
            int heightStartIndex = (int)Math.round((double)height * (double)this.gridHeight[oldi] / 100.0);
            int heightEndIndex = (int)Math.round((double)height * (double)this.gridHeight[oldi + 1] / 100.0);
            int widthStartIndex = (int)Math.round((double)width * (double)this.gridWidth[oldj] / 100.0);
            int widthEndIndex = (int)Math.round((double)width * (double)this.gridWidth[oldj + 1] / 100.0);
            if (heightStartIndex - 1 < 0) {
                heightStartIndex = 1;
            }
            if (widthStartIndex - 1 < 0) {
                widthStartIndex = 1;
            }
            Rect rect1 = new Rect(new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1)), new Point((double)widthEndIndex, (double)heightEndIndex));
            Imgproc.rectangle((Mat)img, (Rect)rect1, (Scalar)this.scalar1);
            this.oldIndex.clear();
        }
        if (this.selectZone != null) {
            int height = img.rows();
            int width = img.cols();
            int heightStartIndex = (int)Math.round((double)height * (double)this.gridHeight[this.selectZone[0]] / 100.0);
            int heightEndIndex = (int)Math.round((double)height * (double)this.gridHeight[this.selectZone[0] + 1] / 100.0);
            int widthStartIndex = (int)Math.round((double)width * (double)this.gridWidth[this.selectZone[1]] / 100.0);
            int widthEndIndex = (int)Math.round((double)width * (double)this.gridWidth[this.selectZone[1] + 1] / 100.0);
            if (heightStartIndex - 1 < 0) {
                heightStartIndex = 1;
            }
            if (widthStartIndex - 1 < 0) {
                widthStartIndex = 1;
            }
            Rect rect1 = new Rect(new Point((double)(widthStartIndex - 1), (double)(heightStartIndex - 1)), new Point((double)widthEndIndex, (double)heightEndIndex));
            Imgproc.rectangle((Mat)img, (Rect)rect1, (Scalar)this.scalar2);
            this.oldIndex.add(this.selectZone[0]);
            this.oldIndex.add(this.selectZone[1]);
        }
        return img;
    }
}

