/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import com.verisilicon.isp.tuning.core.bean.BatchParamBean;
import com.verisilicon.isp.tuning.ui.core.ImageRegistry;
import com.verisilicon.isp.tuning.ui.view.batchtuning.BatchJobView;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RangeJobView {
    private BigDecimal step;
    private BigDecimal max;
    private BigDecimal min;
    private BigDecimal defaultMin;
    private BigDecimal defaultMax;
    private BigDecimal defaultStep;
    private int count;
    private Label labelCount;
    private List<Object> jobList;

    private boolean formatCheck(String input) {
        return input.matches("-?\\d+(\\.\\d+)?");
    }

    private boolean inputCheck(String input, String type, int decimal) {
        BigDecimal inputStep;
        if (!this.formatCheck(input)) {
            this.warningWindow("Invalid Input : " + input);
            return false;
        }
        if (type.compareTo("min") == 0) {
            BigDecimal inputMin = new BigDecimal(input).setScale(decimal, 1);
            if (inputMin.compareTo(this.defaultMin) < 0 || inputMin.compareTo(this.defaultMax) > 0) {
                this.warningWindow("The value of min should between " + this.defaultMin + " and " + this.defaultMax);
                return false;
            }
            if (inputMin.compareTo(this.max) > 0) {
                this.warningWindow("The value of min should be no bigger than that of max");
                return false;
            }
        }
        if (type.compareTo("max") == 0) {
            BigDecimal inputMax = new BigDecimal(input).setScale(decimal, 1);
            if (inputMax.compareTo(this.defaultMin) < 0 || inputMax.compareTo(this.defaultMax) > 0) {
                this.warningWindow("The value of max should between " + this.defaultMin + " and " + this.defaultMax);
                return false;
            }
            if (inputMax.compareTo(this.min) < 0) {
                this.warningWindow("The value of max should be no smaller than that of min");
                return false;
            }
        }
        if (type.compareTo("step") == 0 && (inputStep = new BigDecimal(input).setScale(decimal, 1)).compareTo(BigDecimal.ZERO) <= 0) {
            this.warningWindow("Invalid Step: " + input);
            return false;
        }
        return true;
    }

    private void warningWindow(String message) {
        Shell shell = new Shell();
        MessageBox mb = new MessageBox(shell, 0);
        mb.setText("Warning");
        mb.setMessage(message);
        mb.open();
    }

    private void updateCount() {
        this.count = this.step.compareTo(BigDecimal.ZERO) == 0 ? 1 : this.max.subtract(this.min).divide(this.step, 2).setScale(0, 0).intValue() + 1;
        this.labelCount.setText("Count    " + String.valueOf(this.count));
    }

    private void updateJobList() {
        this.jobList.clear();
        int i = 0;
        while (i < this.count) {
            if (this.min.add(this.step.multiply(BigDecimal.valueOf(i))).compareTo(this.max) >= 0) {
                this.jobList.add(this.max);
                break;
            }
            this.jobList.add(this.min.add(this.step.multiply(BigDecimal.valueOf(i))));
            ++i;
        }
    }

    public void show(BatchJobView view, Composite parent, BatchParamBean bean) {
        int decimal = bean.getOrigParamBean().getValue().getDecimals();
        this.defaultMin = bean.getOrigParamBean().getValue().getMin().setScale(decimal, 1);
        this.defaultMax = bean.getOrigParamBean().getValue().getMax().setScale(decimal, 1);
        this.defaultStep = BigDecimal.ONE.setScale(decimal, 1);
        if (bean.getRangeMax() == null) {
            bean.setRangeMax(this.defaultMax);
        }
        if (bean.getRangeMin() == null) {
            bean.setRangeMin(this.defaultMin);
        }
        if (bean.getRangeStep() == null) {
            bean.setRangeStep(this.defaultStep);
        }
        this.min = bean.getRangeMin();
        this.max = bean.getRangeMax();
        this.step = bean.getRangeStep();
        if (bean.getBatchValues() == null) {
            this.jobList = new ArrayList<Object>();
            this.updateJobList();
            bean.setBatchValues(this.jobList);
        } else {
            this.jobList = bean.getBatchValues();
        }
        Group group = new Group(parent, 2);
        GridLayout gridLayout = new GridLayout(10, true);
        group.setLayout((Layout)gridLayout);
        group.setText(bean.getProcessedName());
        group.setLayoutData((Object)new GridData(4, 4, true, true, 10, 1));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        label.setText("Min  ");
        Text minValue = new Text((Composite)group, 0);
        minValue.setBackground(Display.getCurrent().getSystemColor(1));
        minValue.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        minValue.setText(String.valueOf(bean.getRangeMin()));
        minValue.setToolTipText("Value Range: [" + this.defaultMin.setScale(decimal, 7) + ", " + this.defaultMax.setScale(decimal, 7) + "]");
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        label.setText("Max  ");
        Text maxValue = new Text((Composite)group, 0);
        maxValue.setBackground(Display.getCurrent().getSystemColor(1));
        maxValue.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        maxValue.setText(String.valueOf(bean.getRangeMax()));
        maxValue.setToolTipText("Value Range: [" + this.defaultMin.setScale(decimal, 7) + ", " + this.defaultMax.setScale(decimal, 7) + "]");
        Button delButton = new Button((Composite)group, 0);
        delButton.setLayoutData((Object)new GridData(131072, 128, true, true, 2, 1));
        delButton.setImage(ImageRegistry.getImage(ImageRegistry.BATCH_TASK_DELETE));
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        label.setText("Step  ");
        Text stepValue = new Text((Composite)group, 0);
        stepValue.setBackground(Display.getCurrent().getSystemColor(1));
        stepValue.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 2, 1));
        stepValue.setText(String.valueOf(bean.getRangeStep()));
        this.labelCount = new Label((Composite)group, 0);
        this.labelCount.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 5, 1));
        this.updateCount();
        this.updateJobList();
        minValue.addListener(27, e -> {
            if (!this.inputCheck(minValue.getText(), "min", decimal)) {
                minValue.setText(this.min.toString());
                return;
            }
            this.min = new BigDecimal(minValue.getText()).setScale(decimal, 1);
            minValue.setText(this.min.toString());
            bean.setRangeMin(this.min);
            this.updateCount();
            this.updateJobList();
            bean.setBatchValues(this.jobList);
        });
        maxValue.addListener(27, e -> {
            if (!this.inputCheck(maxValue.getText(), "max", decimal)) {
                maxValue.setText(this.max.toString());
                return;
            }
            this.max = new BigDecimal(maxValue.getText()).setScale(decimal, 1);
            maxValue.setText(this.max.toString());
            bean.setRangeMax(this.max);
            this.updateCount();
            this.updateJobList();
            bean.setBatchValues(this.jobList);
        });
        stepValue.addListener(27, e -> {
            if (!this.inputCheck(stepValue.getText(), "step", decimal)) {
                stepValue.setText(String.valueOf(this.step));
                return;
            }
            this.step = new BigDecimal(stepValue.getText()).setScale(decimal, 1);
            stepValue.setText(this.step.toString());
            bean.setRangeStep(this.step);
            this.updateCount();
            this.updateJobList();
            bean.setBatchValues(this.jobList);
        });
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                view.paramBeanList.remove(bean);
                view.paramNameList.remove(bean.getProcessedName());
                final Display display = Display.getCurrent();
                new Thread(){

                    @Override
                    public void run() {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                view.rightGroupShow();
                            }
                        });
                    }
                }.start();
            }
        });
    }
}

