/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BatchTaskJsonView {
    private int temp = 0;
    private Font font;

    public void show(Composite parent) {
        Composite composite = new Composite(parent, 0x1000000);
        composite.setLayout((Layout)new GridLayout(2, true));
        String baseJsonPath = "res/modules.json";
        String varJsonPath = "res/modules.json";
        String baseStr = this.readJsonFile(baseJsonPath);
        String varStr = this.readJsonFile(varJsonPath);
        Label baseLabel = new Label(composite, 0);
        baseLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        baseLabel.setText("Base json");
        Label varLabel = new Label(composite, 0);
        varLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        varLabel.setText("Diff json");
        StyledText baseJson = new StyledText(composite, 2890);
        baseJson.setLayoutData((Object)new GridData(500, 850));
        baseJson.setText(baseStr);
        this.font = new Font((Device)Display.getDefault(), "Courier New", 10, 0);
        baseJson.setFont(this.font);
        StyledText varJson = new StyledText(composite, 2890);
        varJson.setLayoutData((Object)new GridData(500, 850));
        varJson.setText(varStr);
        varJson.setFont(this.font);
        Button upBtn = new Button(composite, 0);
        upBtn.setText("Up Search");
        upBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button downBtn = new Button(composite, 0);
        downBtn.setText("Down Search");
        downBtn.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Pattern pattern = Pattern.compile("\".*\":");
        Matcher matcher = pattern.matcher(baseStr);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            baseJson.setStyleRange(new StyleRange(start, end - start, new Color(null, 0, 255, 0), new Color(null, 255, 255, 255)));
        }
        ArrayList<Integer> flag = new ArrayList<Integer>();
        String[] baseSplit = baseJson.getText().split("\n");
        String[] varSplit = varJson.getText().split("\n");
        int i = 0;
        while (i < baseSplit.length) {
            if (!baseSplit[i].equals(varSplit[i])) {
                baseJson.setLineBackground(i, 1, new Color(null, 20, 252, 252));
                varJson.setLineBackground(i, 1, new Color(null, 20, 252, 252));
                flag.add(i);
            }
            ++i;
        }
        upBtn.setEnabled(false);
        upBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                downBtn.setEnabled(true);
                BatchTaskJsonView batchTaskJsonView = BatchTaskJsonView.this;
                batchTaskJsonView.temp = batchTaskJsonView.temp - 1;
                if (BatchTaskJsonView.this.temp <= 0) {
                    BatchTaskJsonView.this.temp = 0;
                    upBtn.setEnabled(false);
                }
                baseJson.setTopIndex(((Integer)flag.get(BatchTaskJsonView.this.temp)).intValue());
                varJson.setTopIndex(((Integer)flag.get(BatchTaskJsonView.this.temp)).intValue());
            }
        });
        downBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                upBtn.setEnabled(true);
                baseJson.setTopIndex(((Integer)flag.get(BatchTaskJsonView.this.temp)).intValue());
                varJson.setTopIndex(((Integer)flag.get(BatchTaskJsonView.this.temp)).intValue());
                BatchTaskJsonView batchTaskJsonView = BatchTaskJsonView.this;
                batchTaskJsonView.temp = batchTaskJsonView.temp + 1;
                if (BatchTaskJsonView.this.temp >= flag.size()) {
                    BatchTaskJsonView.this.temp = flag.size() - 1;
                    downBtn.setEnabled(false);
                }
            }
        });
        ScrollBar vBarLeft = baseJson.getVerticalBar();
        vBarLeft.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                varJson.setTopIndex(baseJson.getTopIndex());
            }
        });
    }

    private String readJsonFile(String jsonPath) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL url = bundle.getResource(jsonPath);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            InputStream input = FileLocator.toFileURL((URL)url).openStream();
            byte[] buffer = new byte[1024];
            while ((n = input.read(buffer)) != -1) {
                outputStream.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toString();
    }

    public void dispose() {
        this.font.dispose();
    }
}

