/*
 * Decompiled with CFR 0.152.
 */
package com.verisilicon.isp.tuning.ui.view.batchtuning;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class BatchSingleImageView {
    public Canvas canvas;
    private Image image;
    private int startX = 0;
    private int startY = 0;
    private int endX = 0;
    private int endY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private int dx = 0;
    private int dy = 0;
    private double rate = 1.0;
    private Button zoomInBtn;
    private Button zoomOutBtn;

    public void show(Composite parent, String fileName) {
        Composite composite = new Composite(parent, 0x1000000);
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite imageComposite = new Composite(composite, 0);
        imageComposite.setLayout((Layout)new RowLayout(512));
        Composite canvasCompsite = new Composite(imageComposite, 0);
        canvasCompsite.setLayout((Layout)new RowLayout());
        this.canvas = new Canvas(canvasCompsite, 0x20000800);
        this.canvas.setLayoutData((Object)new RowData(1200, 800));
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                BatchSingleImageView.this.image = new Image((Device)Display.getDefault(), fileName);
                if (BatchSingleImageView.this.image != null) {
                    int height = (int)((double)event.height * BatchSingleImageView.this.rate);
                    int width = (int)((double)event.width * BatchSingleImageView.this.rate);
                    event.gc.drawImage(BatchSingleImageView.this.image, 0, 0, ((BatchSingleImageView)BatchSingleImageView.this).image.getBounds().width, ((BatchSingleImageView)BatchSingleImageView.this).image.getBounds().height, BatchSingleImageView.this.dx, BatchSingleImageView.this.dy, width, height);
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                BatchSingleImageView.this.endX = e.x;
                BatchSingleImageView.this.endY = e.y;
                BatchSingleImageView.this.offsetX = BatchSingleImageView.this.endX - BatchSingleImageView.this.startX;
                BatchSingleImageView.this.offsetY = BatchSingleImageView.this.endY - BatchSingleImageView.this.startY;
                BatchSingleImageView batchSingleImageView = BatchSingleImageView.this;
                batchSingleImageView.dx = batchSingleImageView.dx + (int)((double)BatchSingleImageView.this.offsetX * BatchSingleImageView.this.rate);
                BatchSingleImageView batchSingleImageView2 = BatchSingleImageView.this;
                batchSingleImageView2.dy = batchSingleImageView2.dy + (int)((double)BatchSingleImageView.this.offsetY * BatchSingleImageView.this.rate);
                BatchSingleImageView.this.canvas.redraw();
                BatchSingleImageView.this.offsetX = 0;
                BatchSingleImageView.this.offsetY = 0;
            }

            public void mouseDown(MouseEvent e) {
                BatchSingleImageView.this.startX = e.x;
                BatchSingleImageView.this.startY = e.y;
            }
        });
        Composite btnComposite = new Composite(imageComposite, 0);
        btnComposite.setLayout((Layout)new RowLayout(256));
        Button viewParamBtn = new Button(btnComposite, 0);
        viewParamBtn.setText("View Param");
        Button saveBtn = new Button(btnComposite, 0);
        saveBtn.setText("Save");
        Button applyBtn = new Button(btnComposite, 0);
        applyBtn.setText("Apply");
        Composite zoomComposite = new Composite(composite, 0);
        zoomComposite.setLayout((Layout)new RowLayout(256));
        zoomComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.zoomInBtn = new Button(zoomComposite, 0);
        this.zoomInBtn.setText("Zoom In");
        this.zoomInBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BatchSingleImageView.this.zoomImageOperation(1);
            }
        });
        this.zoomOutBtn = new Button(zoomComposite, 0);
        this.zoomOutBtn.setText("Zoom Out");
        this.zoomOutBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BatchSingleImageView.this.zoomImageOperation(-1);
            }
        });
        Button restoreBtn = new Button(zoomComposite, 0);
        restoreBtn.setText("Restore");
        restoreBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BatchSingleImageView.this.zoomImageOperation(0);
            }
        });
    }

    private void zoomImageOperation(int i) {
        if (i == 0) {
            this.rate = 1.0;
            this.zoomOutBtn.setEnabled(true);
            this.zoomInBtn.setEnabled(true);
            this.dx = 0;
            this.dy = 0;
        } else if (i > 0) {
            this.rate += 0.1;
            if (this.rate > 2.0) {
                this.rate = 2.0;
                this.zoomInBtn.setEnabled(false);
            }
            this.zoomOutBtn.setEnabled(true);
        } else if (i < 0) {
            this.rate -= 0.1;
            if (this.rate < 0.1) {
                this.rate = 0.1;
                this.zoomOutBtn.setEnabled(false);
            }
            this.zoomInBtn.setEnabled(true);
        }
        this.canvas.redraw();
    }
}

